/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.sequencediagram.Doll;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.ParticipantEnglober;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class Dolls {
    private final Map<ParticipantEnglober, Doll> alls = new LinkedHashMap<ParticipantEnglober, Doll>();

    public Dolls(TileArguments tileArguments) {
        for (Participant p : tileArguments.getLivingSpaces().participants()) {
            ParticipantEnglober englober = tileArguments.getLivingSpaces().get(p).getEnglober();
            if (englober == null) continue;
            for (ParticipantEnglober pe : englober.getGenealogy()) {
                this.addParticipant(p, pe, tileArguments);
            }
        }
    }

    private void addParticipant(Participant p, ParticipantEnglober englober, TileArguments tileArguments) {
        Doll already = this.alls.get(englober);
        if (already == null) {
            already = Doll.createTeoz(englober, tileArguments);
            this.alls.put(englober, already);
        }
        already.addParticipant(p);
    }

    private Doll getParent(Doll doll) {
        ParticipantEnglober parent = doll.getParticipantEnglober().getParent();
        if (parent == null) {
            return null;
        }
        return this.alls.get(parent);
    }

    public int size() {
        return this.alls.size();
    }

    public double getOffsetForEnglobers(StringBounder stringBounder) {
        double result = 0.0;
        for (Doll doll : this.alls.values()) {
            double height = doll.getTitlePreferredHeight();
            Doll group = this.getParent(doll);
            if (group != null) {
                height += group.getTitlePreferredHeight();
            }
            if (!(height > result)) continue;
            result = height;
        }
        return result;
    }

    public void addConstraints(StringBounder stringBounder) {
        for (Doll doll : this.alls.values()) {
            doll.addInternalConstraints(stringBounder);
        }
        for (Doll doll : this.alls.values()) {
            doll.addConstraintAfter(stringBounder);
        }
    }

    public void drawEnglobers(UGraphic ug, double height, Context2D context) {
        for (Doll doll : this.alls.values()) {
            doll.drawMe(ug, height, context, this.getParent(doll));
        }
    }

    public Real getMinX(StringBounder stringBounder) {
        if (this.size() == 0) {
            throw new IllegalStateException();
        }
        ArrayList<Real> result = new ArrayList<Real>();
        for (Doll doll : this.alls.values()) {
            result.add(doll.getMinX(stringBounder));
        }
        return RealUtils.min(result);
    }

    public Real getMaxX(StringBounder stringBounder) {
        if (this.size() == 0) {
            throw new IllegalStateException();
        }
        ArrayList<Real> result = new ArrayList<Real>();
        for (Doll doll : this.alls.values()) {
            result.add(doll.getMaxX(stringBounder));
        }
        return RealUtils.max(result);
    }
}

