/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.emoji;

import java.awt.geom.AffineTransform;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UShape;

public class UGraphicWithScale {
    private final UGraphic ug;
    private final AffineTransform at;
    private final double angle;
    private final double scale;

    public UGraphicWithScale(UGraphic ug, double scale) {
        this(ug, AffineTransform.getScaleInstance(scale, scale), 0.0, scale);
    }

    private UGraphicWithScale(UGraphic ug, AffineTransform at, double angle, double scale) {
        this.ug = ug;
        this.at = at;
        this.angle = angle;
        this.scale = scale;
    }

    public UGraphic getUg() {
        return this.ug;
    }

    public UGraphicWithScale apply(UChange change) {
        return new UGraphicWithScale(this.ug.apply(change), this.at, this.angle, this.scale);
    }

    public UGraphicWithScale applyScale(double changex, double changey) {
        if (changex != changey) {
            throw new IllegalArgumentException();
        }
        AffineTransform copy = new AffineTransform(this.at);
        copy.scale(changex, changey);
        return new UGraphicWithScale(this.ug, copy, this.angle, 1.0 * changex);
    }

    public void draw(UShape shape) {
        this.ug.draw(shape);
    }

    public UGraphicWithScale applyRotate(double delta_angle, double x, double y) {
        AffineTransform copy = new AffineTransform(this.at);
        copy.rotate(delta_angle * Math.PI / 180.0, x, y);
        return new UGraphicWithScale(this.ug, copy, this.angle + delta_angle, this.scale);
    }

    public UGraphicWithScale applyTranslate(double x, double y) {
        AffineTransform copy = new AffineTransform(this.at);
        copy.translate(x, y);
        return new UGraphicWithScale(this.ug, copy, this.angle, this.scale);
    }

    public AffineTransform getAffineTransform() {
        return this.at;
    }

    public UGraphicWithScale applyMatrix(double v1, double v2, double v3, double v4, double v5, double v6) {
        AffineTransform copy = new AffineTransform(this.at);
        copy.concatenate(new AffineTransform(new double[]{v1, v2, v3, v4, v5, v6}));
        return new UGraphicWithScale(this.ug, copy, this.angle, this.scale);
    }

    public final double getAngle() {
        return this.angle;
    }

    public double getScale() {
        return this.scale;
    }
}

