/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ebnf;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FloatingNote;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.ebnf.CornerCurved;
import net.sourceforge.plantuml.ebnf.ETile;
import net.sourceforge.plantuml.ebnf.ETileAlternation;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ETileOptional
extends ETile {
    private final double deltax;
    private final double deltay = 16.0;
    private final ETile orig;
    private final ISkinParam skinParam;
    private String commentAbove;
    private String commentBelow;
    private final boolean specialForAlternate;

    public ETileOptional(ETile orig, ISkinParam skinParam) {
        this.skinParam = skinParam;
        this.orig = orig;
        this.specialForAlternate = orig instanceof ETileAlternation;
        this.deltax = this.specialForAlternate ? 0.0 : 15.0;
    }

    @Override
    public double getH1(StringBounder stringBounder) {
        TextBlock note = this.getNoteAbove(stringBounder);
        return 16.0 + this.orig.getH1(stringBounder) + note.calculateDimension(stringBounder).getHeight();
    }

    private double getDeltaY(StringBounder stringBounder) {
        TextBlock note = this.getNoteAbove(stringBounder);
        return 16.0 + note.calculateDimension(stringBounder).getHeight();
    }

    @Override
    public double getH2(StringBounder stringBounder) {
        TextBlock note = this.getNoteBelow(stringBounder);
        return this.orig.getH2(stringBounder) + note.calculateDimension(stringBounder).getHeight();
    }

    @Override
    public double getWidth(StringBounder stringBounder) {
        return this.orig.getWidth(stringBounder) + 2.0 * this.deltax;
    }

    @Override
    public void drawU(UGraphic ug) {
        TextBlock noteBelow;
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dim = this.calculateDimension(stringBounder);
        double linePos = this.getH1(stringBounder);
        double posA = this.specialForAlternate ? 12.0 : 8.0;
        double corner = this.specialForAlternate ? 12.0 : 8.0;
        double posB = dim.getWidth() - posA;
        double posYoptionalLine = this.getDeltaY(stringBounder) - 11.0;
        CornerCurved.createSE(corner).drawU(ug.apply(new UTranslate(posA, linePos)));
        this.drawVline(ug, posA, corner + posYoptionalLine, linePos - corner);
        CornerCurved.createNW(corner).drawU(ug.apply(new UTranslate(posA, posYoptionalLine)));
        this.drawHlineDirected(ug, posYoptionalLine, posA + corner, posB - corner, 0.4);
        CornerCurved.createSW(corner).drawU(ug.apply(new UTranslate(posB, linePos)));
        this.drawVline(ug, posB, corner + posYoptionalLine, linePos - corner);
        CornerCurved.createNE(corner).drawU(ug.apply(new UTranslate(posB, posYoptionalLine)));
        this.drawHline(ug, linePos, 0.0, this.deltax);
        this.drawHline(ug, linePos, dim.getWidth() - this.deltax, dim.getWidth());
        this.orig.drawU(ug.apply(new UTranslate(this.deltax, this.getDeltaY(stringBounder))));
        TextBlock noteAbove = this.getNoteAbove(stringBounder);
        if (noteAbove != TextBlockUtils.EMPTY_TEXT_BLOCK) {
            double pos2 = (dim.getWidth() - noteAbove.calculateDimension(stringBounder).getWidth()) / 2.0;
            noteAbove.drawU(ug.apply(UTranslate.dx(pos2)));
        }
        if ((noteBelow = this.getNoteBelow(stringBounder)) != TextBlockUtils.EMPTY_TEXT_BLOCK) {
            XDimension2D dimBelow = noteBelow.calculateDimension(stringBounder);
            double pos2 = (dim.getWidth() - dimBelow.getWidth()) / 2.0;
            noteBelow.drawU(ug.apply(new UTranslate(pos2, dim.getHeight() - dimBelow.getHeight())));
        }
    }

    @Override
    public void push(ETile tile) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void addCommentAbove(String comment) {
        this.commentAbove = comment;
    }

    @Override
    protected void addCommentBelow(String comment) {
        this.commentBelow = comment;
    }

    private TextBlock getNoteAbove(StringBounder stringBounder) {
        if (this.commentAbove == null) {
            return TextBlockUtils.EMPTY_TEXT_BLOCK;
        }
        FloatingNote note = FloatingNote.create(Display.getWithNewlines(this.commentAbove), this.skinParam, SName.ebnf);
        return TextBlockUtils.withMargin(note, 0.0, 0.0, 0.0, 10.0);
    }

    private TextBlock getNoteBelow(StringBounder stringBounder) {
        if (this.commentBelow == null) {
            return TextBlockUtils.EMPTY_TEXT_BLOCK;
        }
        FloatingNote note = FloatingNote.create(Display.getWithNewlines(this.commentBelow), this.skinParam, SName.ebnf);
        return TextBlockUtils.withMargin(note, 0.0, 0.0, 10.0, 0.0);
    }
}

