/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.legacy;

import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.creole.Neutron;
import net.sourceforge.plantuml.creole.Parser;
import net.sourceforge.plantuml.creole.atom.Atom;
import net.sourceforge.plantuml.creole.atom.AtomMath;
import net.sourceforge.plantuml.creole.legacy.StripeRaw;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.math.ScientificEquationSafe;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class StripeLatex
implements StripeRaw {
    private final FontConfiguration fontConfiguration;
    private final StringBuilder formula = new StringBuilder();
    private AtomMath atom;
    private boolean terminated;

    public StripeLatex(FontConfiguration fontConfiguration) {
        this.fontConfiguration = fontConfiguration;
    }

    @Override
    public List<Atom> getAtoms() {
        return Collections.singletonList(this);
    }

    @Override
    public Atom getLHeader() {
        return null;
    }

    @Override
    public boolean addAndCheckTermination(String line) {
        if (Parser.isLatexEnd(line)) {
            this.terminated = true;
            return true;
        }
        this.formula.append(line);
        return false;
    }

    @Override
    public final boolean isTerminated() {
        return this.terminated;
    }

    private Atom getAtom() {
        if (this.atom == null) {
            ScientificEquationSafe math = ScientificEquationSafe.fromLatex(this.formula.toString());
            this.atom = new AtomMath(math, this.fontConfiguration.getColor(), this.fontConfiguration.getExtendedColor());
        }
        return this.atom;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.getAtom().calculateDimension(stringBounder);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        this.getAtom().drawU(ug);
    }

    @Override
    public List<Neutron> getNeutrons() {
        throw new UnsupportedOperationException();
    }
}

