/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class XPoint2D {
    public final double x;
    public final double y;

    public XPoint2D() {
        this(0.0, 0.0);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public XPoint2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public boolean equals(Object obj) {
        XPoint2D other = (XPoint2D)obj;
        return this.x == other.x && this.y == other.y;
    }

    public int hashCode() {
        return Double.valueOf(this.x).hashCode() + Double.valueOf(this.y).hashCode();
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public double distance(XPoint2D other) {
        double px = other.getX() - this.getX();
        double py = other.getY() - this.getY();
        return Math.sqrt(px * px + py * py);
    }

    public double distanceSq(XPoint2D other) {
        double px = other.getX() - this.getX();
        double py = other.getY() - this.getY();
        return px * px + py * py;
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x1 -= x2) * x1 + (y1 -= y2) * y1);
    }

    public double distance(double px, double py) {
        return Math.sqrt((px -= this.getX()) * px + (py -= this.getY()) * py);
    }

    public XPoint2D move(double dx, double dy) {
        return new XPoint2D(this.x + dx, this.y + dy);
    }

    public XPoint2D transform(AffineTransform rotate) {
        Point2D.Double tmp = new Point2D.Double(this.x, this.y);
        rotate.transform(tmp, tmp);
        return new XPoint2D(tmp.x, tmp.y);
    }

    public XPoint2D move(XPoint2D delta) {
        return new XPoint2D(delta.x, delta.y);
    }
}

