/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Data;
using System.Text;

namespace PostgreSql.Data.PgSqlClient.DbSchema
{
	internal class PgSqlLanguagesSchema : PgAbstractDbSchema
	{
		#region Constructors

		public PgSqlLanguagesSchema() : base("SqlLanguages")
		{
		}

		#endregion

		#region Add Methods

		public override void AddTables()
		{
			AddTable("pg_language");
		}

		public override void AddRestrictionColumns()
		{
		}

		public override void AddDataColumns()
		{
			AddDataColumn("pg_language.lanname", "LANGUAGE_NAME");
			AddDataColumn("pg_language.lanispl", "IS_USER_DEFINED");
			AddDataColumn("pg_proc.proname", "CALL_FUNCTION");
			AddDataColumn("pg_procv.proname", "VALIDATOR");
			AddDataColumn("pg_description.description", "DESCRIPTION");
		}

		public override void AddJoins()
		{
			AddJoin("left join", "pg_proc", "pg_language.lanplcallfoid = pg_proc.oid");
			AddJoin("left join", "pg_proc as pg_procv", "pg_language.lanvalidator = pg_procv.oid");
			AddJoin("left join", "pg_description", "pg_language.oid = pg_description.objoid");
		}

		public override void AddOrderByColumns()
		{
			AddOrderBy("pg_language.lanname");
		}

		public override void AddWhereFilters()
		{
		}

		#endregion

		#region Parse Methods

		public override object[] ParseRestrictions(object[] restrictions)
		{
			object[] parsed = restrictions;

			return parsed;
		}

		#endregion
	}
}