/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Data;
using PostgreSql.Data.PgSqlClient;
using NUnit.Framework;

namespace PostgreSql.Data.PgSqlClient.UnitTests
{
	[TestFixture]
	public class PgDatabaseSchemaTest : PgBaseTest
	{
		[Test]
		public void Aggregates()
		{
			DataTable aggregates = Connection.GetDbSchemaTable(
				PgDbSchemaType.Aggregates, null);
		}
		
		[Test]
		public void Casts()
		{
			DataTable casts = Connection.GetDbSchemaTable(
				PgDbSchemaType.Casts, null);
		}

		[Test]
		public void CheckConstraints()
		{
			DataTable checkConstraints = Connection.GetDbSchemaTable(
				PgDbSchemaType.Check_Constraints, null);
		}

		[Test]
		public void CheckConstraintsByTable()
		{
			DataTable checkConstraintsByTable = Connection.GetDbSchemaTable(
				PgDbSchemaType.Check_Constraints_By_Table, null);
		}

		[Test]
		public void Columns()
		{
			DataTable columns = Connection.GetDbSchemaTable(
				PgDbSchemaType.Columns, null);
		}

		[Test]
		public void Databases()
		{
			DataTable databases = Connection.GetDbSchemaTable(
				PgDbSchemaType.Database, null);
		}

		[Test]
		public void Domains()
		{
			DataTable domains = Connection.GetDbSchemaTable(
				PgDbSchemaType.Domains, null);
		}

		[Test]
		public void ForeignKeys()
		{
			DataTable foreignKeys = Connection.GetDbSchemaTable(
				PgDbSchemaType.Foreign_Keys, null);
		}

		[Test]
		public void FunctionPrivileges()
		{
			DataTable functionPrivileges = Connection.GetDbSchemaTable(
				PgDbSchemaType.Function_Privileges, null);
		}

		[Test]
		public void Functions()
		{
			DataTable functions = Connection.GetDbSchemaTable(
				PgDbSchemaType.Functions, null);
		}

		[Test]
		public void Groups()
		{
			DataTable groups = Connection.GetDbSchemaTable(
				PgDbSchemaType.Groups, null);
		}

		[Test]
		public void Indexes()
		{
			DataTable indexes = Connection.GetDbSchemaTable(
				PgDbSchemaType.Indexes, null);
		}

		[Test]
		public void PrimaryKeys()
		{
			DataTable primaryKeys = Connection.GetDbSchemaTable(
				PgDbSchemaType.Primary_Keys, null);
		}

		[Test]
		public void ProviderTypes()
		{
			DataTable providerTypes = Connection.GetDbSchemaTable(
				PgDbSchemaType.Provider_Types, null);
		}

		[Test]
		public void Schemata()
		{
			DataTable schemata = Connection.GetDbSchemaTable(
				PgDbSchemaType.Schemata, null);
		}

		[Test]
		public void SqlLanguages()
		{
			DataTable sqlLanguages = Connection.GetDbSchemaTable(
				PgDbSchemaType.Sql_Languages, null);
		}

		[Test]
		[Ignore("Not implemented.")]
		public void Statistics()
		{
			DataTable statistics = Connection.GetDbSchemaTable(
				PgDbSchemaType.Statistics, null);
		}

		[Test]
		public void TableConstraint()
		{
			DataTable tableConstraint = Connection.GetDbSchemaTable(
				PgDbSchemaType.Table_Constraint, null);
		}

		[Test]
		public void TablePrivileges()
		{
			DataTable tablePrivileges = Connection.GetDbSchemaTable(
				PgDbSchemaType.Table_Privileges, null);
		}

		[Test]
		[Ignore("Not implemented.")]
		public void TableStatistics()
		{
			DataTable table_Statistics = Connection.GetDbSchemaTable(
				PgDbSchemaType.Table_Statistics, null);
		}

		[Test]
		public void Tables()
		{
			DataTable tables = Connection.GetDbSchemaTable(
				PgDbSchemaType.Tables, null);
		}

		[Test]
		[Ignore("Not implemented.")]
		public void TablesInfo()
		{
			DataTable tablesInfo = Connection.GetDbSchemaTable(
				PgDbSchemaType.Tables_Info, null);
		}

		[Test]
		[Ignore("Not implemented.")]
		public void TriggerParameters()
		{
			DataTable triggerParameters = Connection.GetDbSchemaTable(
				PgDbSchemaType.Trigger_Parameters, null);
		}

		[Test]
		[Ignore("Not implemented.")]
		public void TriggerPrivileges()
		{
			DataTable triggerPrivileges = Connection.GetDbSchemaTable(
				PgDbSchemaType.Trigger_Privileges, null);
		}

		[Test]
		public void Triggers()
		{
			DataTable triggers = Connection.GetDbSchemaTable(
				PgDbSchemaType.Triggers, null);
		}

		[Test]
		[Ignore("Not implemented.")]
		public void UsagePrivileges()
		{
			DataTable usagePrivileges = Connection.GetDbSchemaTable(
				PgDbSchemaType.Usage_Privileges, null);
		}

		[Test]
		[Ignore("Not implemented.")]
		public void ViewColumnUsage()
		{
			DataTable viewColumnUsage = Connection.GetDbSchemaTable(
				PgDbSchemaType.View_Column_Usage, null);
		}

		[Test]
		public void ViewPrivileges()
		{
			DataTable viewPrivileges = Connection.GetDbSchemaTable(
				PgDbSchemaType.View_Privileges, null);
		}

		[Test]
		public void Views()
		{
			DataTable views = Connection.GetDbSchemaTable(
				PgDbSchemaType.Views, null);
		}
	}
}
