/* -*- pftp-c -*- */
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#if HAVE_STDLIB_H
# include <stdlib.h>
#endif
#if HAVE_MATH_H
# include <math.h>
#endif
#if HAVE_STRING_H
# include <string.h>
#endif
#if HAVE_STRINGS_H
# include <strings.h>
#endif

#include "nice_list.h"

#ifdef WITH_DMALLOC
# include <dmalloc.h>
#endif

void calc_columns(const size_t *len, size_t lens, size_t width, size_t spacing,
		  size_t *columns, size_t **col_width, size_t *lines)
{
    size_t y, x, cur_len;
    int ok = 0;
    (*lines) = 1;
    (*columns) = lens;

    for (cur_len = 0; cur_len < lens; cur_len++) {
	if (len[cur_len] + spacing >= width) {
	    (*lines) = lens;
	    (*columns) = 1;
	    (*col_width) = realloc((*col_width), 1 * sizeof(size_t));
	    (*col_width)[0] = width;
	    return;
	}
    }
    
    while (!ok) {
	(*col_width) = realloc((*col_width), (*columns) * sizeof(size_t));
	memset((*col_width), 0, (*columns) * sizeof(size_t));
	
	for (x = 0; x < (*columns); x++) {
	    for (y = 0; y < (*lines); y++) {
		cur_len = (x * (*lines)) + y;
		if (cur_len >= lens) break;
		if (len[cur_len] + spacing > (*col_width)[x])
		    (*col_width)[x] = len[cur_len] + spacing;
	    }
	}
	
	if ((*columns) > 1) {
	    cur_len = 0;	       
	    for (x = 0; x < (*columns); x++)
		cur_len += (*col_width)[x];		    
	    if (cur_len < width + spacing)
		ok = 1;
	} else {
	    ok = 1;
	}
	
	if (!ok) {
	    (*columns)--;
	    (*lines) = (size_t)ceil((double)lens / (double)(*columns));
	}
    }
}
