#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.20';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CNTH',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoG5XII',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoR6',
	'Image::ExifTool::Canon::CameraInfoR6m2',
	'Image::ExifTool::Canon::CameraInfoR6m3',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData10',
	'Image::ExifTool::Canon::ColorData11',
	'Image::ExifTool::Canon::ColorData12',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LevelInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::LogInfo',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::RawBurstInfo',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::Canon::WBInfo',
	'Image::ExifTool::Canon::uuid',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GIF::Extensions',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::Google::Device',
	'Image::ExifTool::Google::GAudio',
	'Image::ExifTool::Google::GCamera',
	'Image::ExifTool::Google::GContainer',
	'Image::ExifTool::Google::GCreations',
	'Image::ExifTool::Google::GDepth',
	'Image::ExifTool::Google::GFocus',
	'Image::ExifTool::Google::GImage',
	'Image::ExifTool::Google::GPano',
	'Image::ExifTool::Google::GSpherical',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::ColorSpec',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type5',
	'Image::ExifTool::Kodak::Type6',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Microsoft::Xtra',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2V0100',
	'Image::ExifTool::Nikon::AFInfo2V0101',
	'Image::ExifTool::Nikon::AFInfo2V0200',
	'Image::ExifTool::Nikon::AFInfo2V0300',
	'Image::ExifTool::Nikon::AFInfo2V0400',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::AutoCaptureInfo',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::BracketingInfoD500',
	'Image::ExifTool::Nikon::BracketingInfoD810',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::ColorBalanceUnknown2',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::DistortionInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::FlashInfo0300',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::HDRInfo2',
	'Image::ExifTool::Nikon::ISOAutoInfoD810',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::IntervalInfoD6',
	'Image::ExifTool::Nikon::IntervalInfoZ7II',
	'Image::ExifTool::Nikon::JPGInfoD500',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MakerNotes0x51',
	'Image::ExifTool::Nikon::MakerNotes0x56',
	'Image::ExifTool::Nikon::MenuSettingsD850',
	'Image::ExifTool::Nikon::MenuSettingsZ6III',
	'Image::ExifTool::Nikon::MenuSettingsZ7II',
	'Image::ExifTool::Nikon::MenuSettingsZ8',
	'Image::ExifTool::Nikon::MenuSettingsZ8v1',
	'Image::ExifTool::Nikon::MenuSettingsZ8v2',
	'Image::ExifTool::Nikon::MenuSettingsZ9',
	'Image::ExifTool::Nikon::MenuSettingsZ9v3',
	'Image::ExifTool::Nikon::MenuSettingsZ9v4',
	'Image::ExifTool::Nikon::MoreSettingsD850',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::MultiExposure2',
	'Image::ExifTool::Nikon::Offset13InfoZ9',
	'Image::ExifTool::Nikon::OrientationInfo',
	'Image::ExifTool::Nikon::OtherInfoD500',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PortraitInfoZ7II',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::RotationInfoD500',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::SeqInfoD6',
	'Image::ExifTool::Nikon::SeqInfoZ9',
	'Image::ExifTool::Nikon::SettingsInfoD810',
	'Image::ExifTool::Nikon::ShootingMenuD500',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::VignetteInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::NikonCustom::SettingsZ6III',
	'Image::ExifTool::NikonCustom::SettingsZ8',
	'Image::ExifTool::NikonCustom::SettingsZ9',
	'Image::ExifTool::NikonCustom::SettingsZ9v4',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::AFTargetInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::Olympus::SubjectDetectInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::DSA',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFInfoK3III',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CAFPointInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FaceInfoK3III',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::LevelInfoK3III',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::AudioKeys',
	'Image::ExifTool::QuickTime::ItemList',
	'Image::ExifTool::QuickTime::ItemPropCont',
	'Image::ExifTool::QuickTime::Keys',
	'Image::ExifTool::QuickTime::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::QuickTime::UserData',
	'Image::ExifTool::QuickTime::VideoKeys',
	'Image::ExifTool::Reconyx::HyperFire',
	'Image::ExifTool::Reconyx::HyperFire2',
	'Image::ExifTool::Reconyx::HyperFire4K',
	'Image::ExifTool::Reconyx::MicroFire',
	'Image::ExifTool::Reconyx::UltraFire',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sigma::WBSettings',
	'Image::ExifTool::Sigma::WBSettings2',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::HiddenInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::SR2SubIFD',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9050c',
	'Image::ExifTool::Sony::Tag9050d',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag9406b',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::ACDSeeRegions',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExifTool',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::HDRGainMap',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apdi',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crd',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::hdr',
	'Image::ExifTool::XMP::hdrgm',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::panorama',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::pdfx',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 116 => 0x69 },
	'about' => { 559 => 'about' },
	'aboutcvterm' => { 549 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 549 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 549 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 549 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 549 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 123 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 565 => 'absPeakAudioFilePath' },
	'academicfield' => { 555 => 'academicField' },
	'acceleration' => { 126 => 0x9404, 542 => 'Acceleration' },
	'accelerationtracking' => { 91 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 449 => 0x3 },
	'accelerometerdata' => { 436 => 'vrot' },
	'accelerometerx' => { 371 => 0x8d },
	'accelerometery' => { 371 => 0x8e },
	'accelerometerz' => { 371 => 0x8c },
	'accessoryserialnumber' => { 371 => 0x54 },
	'accessorytype' => { 371 => 0x53 },
	'acdseeregion' => { 518 => [\'Regions','RegionsRegionList'] },
	'acdseeregionalgarea' => { 518 => [\'Regions','RegionsRegionListALGArea'] },
	'acdseeregionalgareah' => { 518 => [\'Regions','RegionsRegionListALGAreaH'] },
	'acdseeregionalgareaw' => { 518 => [\'Regions','RegionsRegionListALGAreaW'] },
	'acdseeregionalgareax' => { 518 => [\'Regions','RegionsRegionListALGAreaX'] },
	'acdseeregionalgareay' => { 518 => [\'Regions','RegionsRegionListALGAreaY'] },
	'acdseeregionappliedtodimensions' => { 518 => [\'Regions','RegionsAppliedToDimensions'] },
	'acdseeregionappliedtodimensionsh' => { 518 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'acdseeregionappliedtodimensionsunit' => { 518 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'acdseeregionappliedtodimensionsw' => { 518 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'acdseeregiondlyarea' => { 518 => [\'Regions','RegionsRegionListDLYArea'] },
	'acdseeregiondlyareah' => { 518 => [\'Regions','RegionsRegionListDLYAreaH'] },
	'acdseeregiondlyareaw' => { 518 => [\'Regions','RegionsRegionListDLYAreaW'] },
	'acdseeregiondlyareax' => { 518 => [\'Regions','RegionsRegionListDLYAreaX'] },
	'acdseeregiondlyareay' => { 518 => [\'Regions','RegionsRegionListDLYAreaY'] },
	'acdseeregionname' => { 518 => [\'Regions','RegionsRegionListName'] },
	'acdseeregionnameassigntype' => { 518 => [\'Regions','RegionsRegionListNameAssignType'] },
	'acdseeregiontype' => { 518 => [\'Regions','RegionsRegionListType'] },
	'actionadvised' => { 149 => 0x2a },
	'actioninafccont' => { 382 => 0x220 },
	'actionpriority' => { 2 => 0x1d },
	'activearea' => { 126 => 0xc68d },
	'actived-lighting' => { 257 => 0x22, 315 => 0x24 },
	'actived-lightingmode' => { 315 => 0x25 },
	'adaptervoltage' => { 156 => 0x407 },
	'addaspectratioinfo' => { 91 => 0x80e },
	'addiptcinformation' => { 91 => 0x815 },
	'additionalmodelinformation' => { 549 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 91 => 0x80f, 92 => 0x11, 93 => 0x13, 96 => 0x14 },
	'address' => { 179 => 'Address' },
	'adjustmentmode' => { 456 => 0x15 },
	'adlbracketingstep' => { 219 => 0x17 },
	'adlbracketingtype' => { 219 => 0x18 },
	'adobe' => { 127 => 'Adobe' },
	'adultcontentwarning' => { 357 => 'AdultContentWarning', 558 => 'adultContentWarning' },
	'advancedfilter' => { 134 => 0x1201 },
	'advancedraw' => { 317 => 0x76a43203 },
	'advancedscenetype' => { 371 => 0x3d },
	'advisory' => { 563 => 'Advisory' },
	'ae_iso' => { 379 => 0x2, 380 => 0x4, 381 => 0x12 },
	'aeaperture' => { 379 => 0x1, 380 => 0x3, 381 => 0x11 },
	'aeaperturesteps' => { 379 => 0x8, 380 => 0xb },
	'aeaverage' => { 1 => 0x6 },
	'aebautocancel' => { 91 => 0x104 },
	'aebbracketvalue' => { 83 => 0x11 },
	'aebracketingsteps' => { 219 => 0xf, 220 => 0xf, 297 => 0x174c },
	'aebsequence' => { 91 => 0x105 },
	'aebsequenceautocancel' => { 89 => 0x9, 90 => 0x9, 92 => 0x8, 93 => 0x9, 96 => 0x9, 97 => 0x7 },
	'aebshotcount' => { 91 => 0x106 },
	'aebxv' => { 379 => 0x4, 380 => 0x6 },
	'aeerror' => { 380 => 0x8 },
	'aeexposuretime' => { 379 => 0x0, 380 => 0x2, 381 => 0x10 },
	'aelbutton' => { 202 => 0x45 },
	'aelexposureindicator' => { 202 => 0x51 },
	'aelock' => { 202 => 0x5b, 326 => '4.2', 335 => '4.2', 346 => 0x201, 410 => 0x48, 466 => 0x40, 467 => 0x40, 468 => [0x86,0x286] },
	'aelockbutton' => { 324 => '16.1', 326 => '4.1', 329 => '15.1', 330 => '16.1', 331 => '16.1', 333 => '30.1', 334 => '16.1', 335 => '4.1', 337 => '17.1', 339 => '17.1' },
	'aelockbuttonplusdials' => { 324 => '16.2', 333 => '32.1', 337 => '44.1' },
	'aelockformb-d80' => { 339 => '3.1' },
	'aelockmetermodeafterfocus' => { 91 => 0x114 },
	'aematrix' => { 1 => 0x2 },
	'aemaxaperture' => { 379 => 0x9, 380 => 0x10, 381 => 0x1c },
	'aemaxaperture2' => { 379 => 0xa, 380 => 0x11, 381 => 0x1d },
	'aemeteringmode' => { 379 => 0xc },
	'aemeteringmode2' => { 379 => '13.1' },
	'aemeteringsegments' => { 205 => 0x628, 410 => 0x209 },
	'aemicroadjustment' => { 91 => 0x110 },
	'aeminaperture' => { 379 => 0xb, 380 => 0x12, 381 => 0x1e },
	'aeminexposuretime' => { 379 => 0x5, 380 => 0x13, 381 => 0x1f },
	'aeprogrammode' => { 379 => 0x6 },
	'aeprojectlink' => { 536 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 536 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 536 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 536 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 536 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 536 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 38 => 0x21 },
	'aestable' => { 1 => 0x4 },
	'aestheticscore' => { 360 => 'aesthetic_score' },
	'aetarget' => { 1 => 0x5 },
	'aewhitebalance' => { 379 => 0xd },
	'aexv' => { 379 => 0x3, 380 => 0x5 },
	'af-assistilluminator' => { 340 => 0x1a, 341 => 0x19, 342 => 0x19, 343 => 0x19 },
	'af-cfocusdisplay' => { 341 => 0x234, 342 => 0x234, 343 => 0x24c },
	'af-cpriority' => { 135 => '0.2' },
	'af-cpriorityselection' => { 324 => '1.1', 325 => '1.1', 327 => '1.1', 328 => '1.1', 330 => '0.1', 331 => '0.1', 332 => '0.1', 333 => '1.1', 334 => '0.1', 337 => '1.1', 338 => '1.1', 340 => 0x3, 341 => 0x3, 342 => 0x3, 343 => 0x3 },
	'af-csetting' => { 131 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 131 => '0.2' },
	'af-ctrackingsensitivity' => { 131 => '0.1' },
	'af-czoneareaswitching' => { 131 => '0.3' },
	'af-onbutton' => { 327 => '70.1', 328 => '70.1', 338 => '70.1' },
	'af-onformb-d10' => { 324 => '3.3', 333 => '3.2' },
	'af-onformb-d11' => { 334 => '2.2' },
	'af-onformb-d12' => { 337 => '50.1' },
	'af-onoutoffocusrelease' => { 340 => 0x10, 341 => 0x10, 342 => 0x10, 343 => 0x10 },
	'af-spriority' => { 135 => '0.1' },
	'af-spriorityselection' => { 324 => '1.2', 325 => '1.2', 327 => '1.2', 328 => '1.2', 332 => '0.2', 333 => '1.2', 334 => '0.2', 337 => '1.2', 338 => '1.2', 340 => 0x5, 341 => 0x5, 342 => 0x5, 343 => 0x5 },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 324 => '2.1', 325 => '2.1', 327 => '78.3', 328 => '78.3', 333 => '2.1', 337 => '2.1', 338 => '78.3', 340 => 0xf, 341 => 0xf, 342 => 0xf, 343 => 0xf },
	'afadjustment' => { 410 => 0x72, 419 => 0x267 },
	'afandmeteringbuttons' => { 91 => 0x701 },
	'afaperture' => { 250 => 0x5, 251 => 0x5, 255 => 0x5 },
	'afareaheight' => { 211 => 0x1a, 212 => 0x50, 214 => 0x34, 215 => 0x48 },
	'afareaillumination' => { 202 => 0x4b, 335 => '15.3' },
	'afareainitialheight' => { 272 => 0xbeb },
	'afareainitialwidth' => { 272 => 0xbea },
	'afareainitialxposition' => { 272 => 0xbe8 },
	'afareainitialyposition' => { 272 => 0xbe9 },
	'afareamode' => { 133 => '0.3', 198 => 0x33, 202 => 0xe, 210 => 0x0, 211 => 0x5, 212 => 0x5, 213 => 0x5, 214 => 0x5, 215 => 0x5, 261 => 0x340, 263 => 0x224, 266 => 0x210, 267 => 0x224, 268 => 0x224, 371 => 0xf, 446 => 0x1205, 459 => [0xa,0x3a], 466 => 0x11, 467 => 0x10, 468 => 0x24, 480 => 0xb043, 506 => 0x17 },
	'afareamodesetting' => { 326 => '11.1', 329 => '0.1', 335 => '16.1', 339 => '2.1', 480 => 0x201c },
	'afareapointsize' => { 133 => '0.4' },
	'afareas' => { 346 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 91 => 0x51b },
	'afareasize' => { 371 => 0xde },
	'afareawidth' => { 211 => 0x18, 212 => 0x4e, 214 => 0x32, 215 => 0x46 },
	'afareaxposition' => { 211 => 0x14, 212 => 0x4a, 214 => 0x2e, 215 => 0x42, 446 => 0x1203 },
	'afareaxposition1' => { 446 => 0x1201 },
	'afareayposition' => { 211 => 0x16, 212 => 0x4c, 214 => 0x30, 215 => 0x44, 446 => 0x1204 },
	'afareayposition1' => { 446 => 0x1202 },
	'afareazonesize' => { 133 => '0.5' },
	'afassist' => { 89 => 0x5, 97 => 0x5, 202 => 0x48, 324 => '2.5', 326 => '0.2', 329 => '0.2', 330 => '1.1', 331 => '1.1', 332 => '1.3', 333 => '2.4', 334 => '1.3', 335 => '0.2', 337 => '2.4', 339 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 91 => 0x50e, 92 => 0x4, 93 => 0x5, 94 => 0x4, 95 => 0x4, 96 => 0x5 },
	'afassistlamp' => { 371 => 0x31 },
	'afbuttonpressed' => { 468 => [0x83,0x283] },
	'afchold' => { 382 => 0x221 },
	'afconfidence' => { 1 => 0x3d },
	'afconfigtool' => { 2 => 0x1 },
	'afcoordinatesavailable' => { 214 => 0x7, 215 => 0x7 },
	'afcpointtracking' => { 382 => '545.1' },
	'afcsensitivity' => { 382 => '545.2' },
	'afdefocus' => { 382 => 0x6 },
	'afdetectionmethod' => { 211 => 0x4, 212 => 0x4, 214 => 0x4, 215 => 0x4 },
	'afduringliveview' => { 91 => 0x511 },
	'affinea' => { 528 => 'AffineA' },
	'affineb' => { 528 => 'AffineB' },
	'affinec' => { 528 => 'AffineC' },
	'affined' => { 528 => 'AffineD' },
	'affinetune' => { 216 => 0x0, 264 => 0x6b0, 265 => 0x6c0, 266 => 0x5b0, 267 => 0x5e0, 268 => 0x5f8, 346 => 0x306 },
	'affinetuneadj' => { 216 => 0x2, 290 => 0x2d1, 291 => 0x2dc, 346 => 0x307 },
	'affinetuneadjtele' => { 216 => 0x3 },
	'affinetuneindex' => { 216 => 0x1 },
	'affinex' => { 528 => 'AffineX' },
	'affiney' => { 528 => 'AffineY' },
	'affocusarea' => { 345 => 0x2 },
	'afframesize' => { 345 => 0x0 },
	'afhold' => { 382 => 0x1fd },
	'afilluminator' => { 466 => 0x29, 480 => 0xb044 },
	'afimageheight' => { 211 => 0x12, 212 => 0x48, 214 => 0x2c, 215 => 0x40 },
	'afimagewidth' => { 211 => 0x10, 212 => 0x46, 214 => 0x2a, 215 => 0x3e },
	'afinfo' => { 383 => 0x0 },
	'afintegrationtime' => { 382 => 0x7 },
	'afmeasureddepth' => { 1 => 0x38 },
	'afmicroadj' => { 459 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 463 => 0x131 },
	'afmicroadjregisteredlenses' => { 463 => '305.1' },
	'afmicroadjustment' => { 91 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 463 => 0x130 },
	'afmode' => { 120 => 0x3009, 134 => 0x1022, 198 => 0x16, 383 => '0.1', 456 => 0x5 },
	'afmoderestrictions' => { 325 => '50.3', 327 => '48.3', 328 => '48.3', 337 => '48.3', 338 => '48.3' },
	'afonaelockbuttonswitch' => { 91 => 0x702 },
	'afonbutton' => { 324 => '3.1', 325 => '47.1', 340 => 0x87, 341 => 0x83, 342 => 0x83, 343 => 0x83 },
	'afperformance' => { 1 => 0x23 },
	'afpoint' => { 38 => 0x13, 119 => 0x18, 198 => 0x15, 210 => 0x1, 349 => 0x308, 456 => 0x1f, 459 => [0x37,0x7], 463 => 0x19, 464 => 0x18, 465 => [0x18,0x20] },
	'afpointactivationarea' => { 90 => 0x11, 96 => 0x11 },
	'afpointareaexpansion' => { 91 => 0x508 },
	'afpointatshutterrelease' => { 459 => [0x39,0x9] },
	'afpointautoselection' => { 91 => 0x50b },
	'afpointbrightness' => { 91 => 0x50d, 324 => '2.4', 325 => '46.5', 327 => '2.2', 328 => '2.2', 337 => '2.3', 338 => '2.2' },
	'afpointdetails' => { 349 => 0x31b },
	'afpointdisplayduringfocus' => { 2 => 0x10, 91 => 0x50c },
	'afpointillumination' => { 90 => 0xa, 324 => '2.3', 325 => '46.2', 327 => '47.2', 328 => '47.2', 332 => '1.2', 333 => '2.3', 334 => '1.2', 337 => '47.2', 338 => '47.2', 339 => '2.4' },
	'afpointinfocus' => { 459 => [0x38,0x8] },
	'afpointmode' => { 389 => 0x3 },
	'afpointposition' => { 120 => 0x2021, 371 => 0x4d },
	'afpointregistration' => { 89 => 0x7 },
	'afpoints' => { 201 => 0x10 },
	'afpointsel' => { 340 => 0xb, 341 => 0xb, 342 => 0xb, 343 => 0xb },
	'afpointselected' => { 202 => 0xd, 346 => 0x305, 410 => 0xe, 463 => 0x15, 464 => 0x14, 465 => [0x14,0x1c], 480 => 0x201e },
	'afpointselected2' => { 389 => 0x4 },
	'afpointselection' => { 90 => 0xb, 324 => '1.3', 325 => '1.3', 333 => '1.3', 337 => '1.3', 338 => '1.3' },
	'afpointselectionmethod' => { 91 => 0x50f, 92 => 0xc, 93 => 0xd, 96 => 0xd },
	'afpointsetting' => { 466 => 0x12, 467 => 0x11 },
	'afpointsinfocus' => { 83 => 0xe, 210 => 0x2, 212 => 0x30, 382 => 0xb, 410 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 19 => 0x38 },
	'afpointspotmetering' => { 90 => 0xd },
	'afpointsselected' => { 211 => 0x1c, 212 => 0x1c, 382 => 0x12a, 515 => 0x4 },
	'afpointsunknown' => { 382 => 0x18f },
	'afpointsunknown1' => { 382 => 0x0 },
	'afpointsunknown2' => { 382 => 0x2 },
	'afpointsused' => { 211 => 0x8, 212 => [0x1c,0x8], 213 => 0x8, 214 => 0xa, 215 => 0xa, 459 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpointvalues' => { 382 => 0x14 },
	'afpredictor' => { 382 => 0x4 },
	'afresponse' => { 257 => 0xad },
	'afresult' => { 351 => 0x1038 },
	'afsearch' => { 346 => 0x303 },
	'afselectedarea' => { 345 => 0x6 },
	'afselectionmode' => { 383 => 0x1 },
	'afsensoractive' => { 198 => 0x1 },
	'afstable' => { 1 => 0x7 },
	'afstatus' => { 446 => 0x1200 },
	'afstatus_00_b4' => { 462 => 0x0 },
	'afstatus_01_c4' => { 462 => 0x2 },
	'afstatus_02_d4' => { 462 => 0x4 },
	'afstatus_03_e4' => { 462 => 0x6 },
	'afstatus_04_f4' => { 462 => 0x8 },
	'afstatus_05_g4' => { 462 => 0xa },
	'afstatus_06_h4' => { 462 => 0xc },
	'afstatus_07_b3' => { 462 => 0xe },
	'afstatus_08_c3' => { 462 => 0x10 },
	'afstatus_09_d3' => { 462 => 0x12 },
	'afstatus_10_e3' => { 462 => 0x14 },
	'afstatus_11_f3' => { 462 => 0x16 },
	'afstatus_12_g3' => { 462 => 0x18 },
	'afstatus_13_h3' => { 462 => 0x1a },
	'afstatus_14_b2' => { 462 => 0x1c },
	'afstatus_15_c2' => { 462 => 0x1e },
	'afstatus_16_d2' => { 462 => 0x20 },
	'afstatus_17_e2' => { 462 => 0x22 },
	'afstatus_18_f2' => { 462 => 0x24 },
	'afstatus_19_g2' => { 462 => 0x26 },
	'afstatus_20_h2' => { 462 => 0x28 },
	'afstatus_21_c1' => { 462 => 0x2a },
	'afstatus_22_d1' => { 462 => 0x2c },
	'afstatus_23_e1' => { 462 => 0x2e },
	'afstatus_24_f1' => { 462 => 0x30 },
	'afstatus_25_g1' => { 462 => 0x32 },
	'afstatus_26_a7_vertical' => { 462 => 0x34 },
	'afstatus_27_a6_vertical' => { 462 => 0x36 },
	'afstatus_28_a5_vertical' => { 462 => 0x38 },
	'afstatus_29_c7_vertical' => { 462 => 0x3a },
	'afstatus_30_c6_vertical' => { 462 => 0x3c },
	'afstatus_31_c5_vertical' => { 462 => 0x3e },
	'afstatus_32_e7_vertical' => { 462 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 462 => 0x42 },
	'afstatus_34_e5_vertical' => { 462 => 0x44 },
	'afstatus_35_g7_vertical' => { 462 => 0x46 },
	'afstatus_36_g6_vertical' => { 462 => 0x48 },
	'afstatus_37_g5_vertical' => { 462 => 0x4a },
	'afstatus_38_i7_vertical' => { 462 => 0x4c },
	'afstatus_39_i6_vertical' => { 462 => 0x4e },
	'afstatus_40_i5_vertical' => { 462 => 0x50 },
	'afstatus_41_a7' => { 462 => 0x52 },
	'afstatus_42_b7' => { 462 => 0x54 },
	'afstatus_43_c7' => { 462 => 0x56 },
	'afstatus_44_d7' => { 462 => 0x58 },
	'afstatus_45_e7' => { 462 => 0x5a },
	'afstatus_46_f7' => { 462 => 0x5c },
	'afstatus_47_g7' => { 462 => 0x5e },
	'afstatus_48_h7' => { 462 => 0x60 },
	'afstatus_49_i7' => { 462 => 0x62 },
	'afstatus_50_a6' => { 462 => 0x64 },
	'afstatus_51_b6' => { 462 => 0x66 },
	'afstatus_52_c6' => { 462 => 0x68 },
	'afstatus_53_d6' => { 462 => 0x6a },
	'afstatus_54_e6_center' => { 462 => 0x6c },
	'afstatus_55_f6' => { 462 => 0x6e },
	'afstatus_56_g6' => { 462 => 0x70 },
	'afstatus_57_h6' => { 462 => 0x72 },
	'afstatus_58_i6' => { 462 => 0x74 },
	'afstatus_59_a5' => { 462 => 0x76 },
	'afstatus_60_b5' => { 462 => 0x78 },
	'afstatus_61_c5' => { 462 => 0x7a },
	'afstatus_62_d5' => { 462 => 0x7c },
	'afstatus_63_e5' => { 462 => 0x7e },
	'afstatus_64_f5' => { 462 => 0x80 },
	'afstatus_65_g5' => { 462 => 0x82 },
	'afstatus_66_h5' => { 462 => 0x84 },
	'afstatus_67_i5' => { 462 => 0x86 },
	'afstatus_68_c11' => { 462 => 0x88 },
	'afstatus_69_d11' => { 462 => 0x8a },
	'afstatus_70_e11' => { 462 => 0x8c },
	'afstatus_71_f11' => { 462 => 0x8e },
	'afstatus_72_g11' => { 462 => 0x90 },
	'afstatus_73_b10' => { 462 => 0x92 },
	'afstatus_74_c10' => { 462 => 0x94 },
	'afstatus_75_d10' => { 462 => 0x96 },
	'afstatus_76_e10' => { 462 => 0x98 },
	'afstatus_77_f10' => { 462 => 0x9a },
	'afstatus_78_g10' => { 462 => 0x9c },
	'afstatus_79_h10' => { 462 => 0x9e },
	'afstatus_80_b9' => { 462 => 0xa0 },
	'afstatus_81_c9' => { 462 => 0xa2 },
	'afstatus_82_d9' => { 462 => 0xa4 },
	'afstatus_83_e9' => { 462 => 0xa6 },
	'afstatus_84_f9' => { 462 => 0xa8 },
	'afstatus_85_g9' => { 462 => 0xaa },
	'afstatus_86_h9' => { 462 => 0xac },
	'afstatus_87_b8' => { 462 => 0xae },
	'afstatus_88_c8' => { 462 => 0xb0 },
	'afstatus_89_d8' => { 462 => 0xb2 },
	'afstatus_90_e8' => { 462 => 0xb4 },
	'afstatus_91_f8' => { 462 => 0xb6 },
	'afstatus_92_g8' => { 462 => 0xb8 },
	'afstatus_93_h8' => { 462 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 462 => 0xbc },
	'afstatusactivesensor' => { 198 => 0x2, 459 => [0x4,0x3b], 463 => 0x1e, 464 => 0x1b, 465 => [0x1b,0x21] },
	'afstatusbottom' => { 198 => 0x8, 463 => 0x2a, 464 => 0x21, 465 => 0x21 },
	'afstatusbottom-left' => { 198 => 0x12, 464 => 0x2b, 465 => 0x2b },
	'afstatusbottom-right' => { 198 => 0x6, 464 => 0x1f, 465 => 0x1f },
	'afstatusbottomassist-left' => { 463 => 0x28 },
	'afstatusbottomassist-right' => { 463 => 0x2c },
	'afstatusbottomhorizontal' => { 460 => 0x10, 461 => 0x1c },
	'afstatusbottomvertical' => { 460 => 0x16, 461 => 0x26 },
	'afstatuscenter-10' => { 463 => 0x34 },
	'afstatuscenter-11' => { 463 => 0x36 },
	'afstatuscenter-12' => { 463 => 0x38 },
	'afstatuscenter-14' => { 463 => 0x3c },
	'afstatuscenter-7' => { 463 => 0x2e },
	'afstatuscenter-9' => { 463 => 0x32 },
	'afstatuscenter-horizontal' => { 463 => 0x30 },
	'afstatuscenter-vertical' => { 463 => 0x3a },
	'afstatuscenterf2-8' => { 463 => 0x4c },
	'afstatuscenterhorizontal' => { 198 => 0x2f, 460 => 0xc, 461 => 0x18, 464 => 0x2f, 465 => 0x2f },
	'afstatuscentervertical' => { 198 => 0xc, 460 => 0x14, 461 => 0x22, 464 => 0x25, 465 => 0x25 },
	'afstatusfarleft' => { 460 => 0x6, 463 => 0x26 },
	'afstatusfarlefthorizontal' => { 461 => 0x4 },
	'afstatusfarleftvertical' => { 461 => 0x12 },
	'afstatusfarright' => { 460 => 0x18, 463 => 0x44 },
	'afstatusfarrighthorizontal' => { 461 => 0x2c },
	'afstatusfarrightvertical' => { 461 => 0x34 },
	'afstatusleft' => { 198 => 0x2d, 460 => 0x2, 463 => 0x22, 464 => 0x2d, 465 => 0x2d },
	'afstatuslefthorizontal' => { 461 => 0x6 },
	'afstatusleftvertical' => { 461 => 0xe },
	'afstatuslower-left' => { 460 => 0x4, 463 => 0x24 },
	'afstatuslower-lefthorizontal' => { 461 => 0xa },
	'afstatuslower-leftvertical' => { 461 => 0x10 },
	'afstatuslower-middle' => { 460 => 0x22, 461 => 0x24 },
	'afstatuslower-right' => { 460 => 0x1e, 463 => 0x4a },
	'afstatuslower-righthorizontal' => { 461 => 0x32 },
	'afstatuslower-rightvertical' => { 461 => 0x3a },
	'afstatuslowerfarleft' => { 461 => 0x8 },
	'afstatuslowerfarright' => { 461 => 0x30 },
	'afstatusmiddlehorizontal' => { 198 => 0xa, 464 => 0x23, 465 => 0x23 },
	'afstatusnearleft' => { 460 => 0xe, 461 => 0x1a },
	'afstatusnearright' => { 460 => 0xa, 461 => 0x16 },
	'afstatusright' => { 198 => 0x31, 460 => 0x1c, 463 => 0x48, 464 => 0x31, 465 => 0x31 },
	'afstatusrighthorizontal' => { 461 => 0x2e },
	'afstatusrightvertical' => { 461 => 0x38 },
	'afstatustop' => { 198 => 0xe, 463 => 0x40, 464 => 0x27, 465 => 0x27 },
	'afstatustop-left' => { 198 => 0x10, 464 => 0x29, 465 => 0x29 },
	'afstatustop-right' => { 198 => 0x4, 464 => 0x1d, 465 => 0x1d },
	'afstatustopassist-left' => { 463 => 0x3e },
	'afstatustopassist-right' => { 463 => 0x42 },
	'afstatustophorizontal' => { 460 => 0x8, 461 => 0x14 },
	'afstatustopvertical' => { 460 => 0x12, 461 => 0x1e },
	'afstatusupper-left' => { 460 => 0x0, 463 => 0x20 },
	'afstatusupper-lefthorizontal' => { 461 => 0x2 },
	'afstatusupper-leftvertical' => { 461 => 0xc },
	'afstatusupper-middle' => { 460 => 0x20, 461 => 0x20 },
	'afstatusupper-right' => { 460 => 0x1a, 463 => 0x46 },
	'afstatusupper-righthorizontal' => { 461 => 0x2a },
	'afstatusupper-rightvertical' => { 461 => 0x36 },
	'afstatusupperfarleft' => { 461 => 0x0 },
	'afstatusupperfarright' => { 461 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'afsubjectdetection' => { 371 => 0xe9 },
	'aftargetinfo' => { 346 => 0x30a },
	'aftracking' => { 480 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 459 => 0x2 },
	'afwithshutter' => { 466 => 0x2a },
	'aggregateissuenumber' => { 555 => 'aggregateIssueNumber' },
	'aggregationtype' => { 555 => 'aggregationType' },
	'agreement' => { 558 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 156 => 0xe4e },
	'aipromptinformation' => { 549 => 'AIPromptInformation' },
	'aipromptwritername' => { 549 => 'AIPromptWriterName' },
	'airplanemode' => { 261 => 0x9c0, 264 => 0x722, 265 => 0x782, 266 => 0x624, 267 => 0x654, 268 => 0x6bc },
	'aiservocontinuousshooting' => { 90 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 91 => 0x519 },
	'aiservoimagepriority' => { 91 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 91 => 0x51a },
	'aiservotrackingmethod' => { 91 => 0x504 },
	'aiservotrackingsensitivity' => { 90 => 0x14, 91 => 0x502 },
	'aisubjecttrackingmode' => { 346 => 0x309 },
	'aisystemused' => { 549 => 'AISystemUsed' },
	'aisystemversionused' => { 549 => 'AISystemVersionUsed' },
	'album' => { 428 => ['albm',"\xa9alb"], 430 => 'album', 436 => ['albm',"\xa9alb"], 565 => 'album' },
	'albumartist' => { 197 => 'WM/AlbumArtist', 428 => 'aART', 436 => 'albr' },
	'albumcoverurl' => { 197 => 'WM/AlbumCoverURL' },
	'albumid' => { 428 => 'plID' },
	'albumtitle' => { 197 => 'WM/AlbumTitle' },
	'alreadyapplied' => { 535 => 'AlreadyApplied', 537 => 'AlreadyApplied' },
	'alternatetitle' => { 555 => 'alternateTitle' },
	'alternatetitlea-lang' => { 555 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 555 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 555 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 218 => 0x6 },
	'alttapename' => { 565 => 'altTapeName' },
	'alttextaccessibility' => { 548 => 'AltTextAccessibility' },
	'alttimecode' => { 565 => 'altTimecode' },
	'alttimecodetimeformat' => { 565 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 565 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 565 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 439 => 0x5c, 441 => 0x6c },
	'ambientlight' => { 439 => 0x5e, 440 => 0x45, 441 => 0x6e },
	'ambienttemperature' => { 126 => 0x9400, 438 => 0x14, 439 => 0x50, 440 => 0x3a, 441 => 0x60, 442 => 0x46, 506 => 0x4, 542 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 438 => 0x13, 439 => 0x4e, 440 => 0x38, 441 => 0x5e, 442 => 0x44 },
	'analogbalance' => { 126 => 0xc627 },
	'analogcaptureiso' => { 156 => 0x89e },
	'analogisotable' => { 156 => 0x89d },
	'androidcapturefps' => { 430 => 'com.android.capture.fps' },
	'androidmake' => { 430 => 'com.android.manufacturer' },
	'androidmodel' => { 430 => 'com.android.model' },
	'androidtimezone' => { 430 => 'samsung.android.utc_offset' },
	'androidversion' => { 430 => 'com.android.version' },
	'angleadj' => { 110 => 0x10003, 116 => 0x8b },
	'angleinforoll' => { 531 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 531 => 'AngleInfoYaw' },
	'anti-blur' => { 480 => 0xb04b },
	'antialiasstrength' => { 126 => 0xc632 },
	'antiflicker' => { 62 => 0x20 },
	'antishockwaitingtime' => { 349 => 0x2100 },
	'aperturelock' => { 325 => '38.2', 327 => '38.2', 328 => '38.2', 337 => '38.2', 338 => '38.2', 340 => 0xbc, 341 => 0xb8, 342 => 0xb8, 343 => 0xb8 },
	'aperturemode' => { 436 => 'apmd' },
	'aperturerange' => { 91 => 0x10d },
	'apertureringuse' => { 389 => '1.4' },
	'aperturesetting' => { 202 => 0x7, 466 => 0x30, 467 => 0x29, 468 => 0x1 },
	'aperturevalue' => { 100 => 0x2, 126 => 0x9202, 351 => 0x1002, 419 => 0x401, 541 => 'ApertureValue' },
	'appinfo' => { 139 => 'AppInfo' },
	'appinfoapplication' => { 139 => [\'AppInfo','AppInfoApplication'] },
	'appinfoitemuri' => { 139 => [\'AppInfo','AppInfoItemURI'] },
	'appinfoversion' => { 139 => [\'AppInfo','AppInfoVersion'] },
	'apple_0x004e' => { 1 => 0x4e },
	'apple_0x004f' => { 1 => 0x4f },
	'apple_0x0054' => { 1 => 0x54 },
	'apple_0x005a' => { 1 => 0x5a },
	'applekeywords' => { 356 => 'AAPL:Keywords' },
	'applephotosvariationidentifier' => { 430 => 'apple.photos.variation-identifier' },
	'applestoreaccount' => { 428 => 'apID' },
	'applestoreaccounttype' => { 428 => 'akID' },
	'applestorecatalogid' => { 428 => 'cnID' },
	'applestorecountry' => { 428 => 'sfID' },
	'applicationkeystring' => { 156 => 0x400 },
	'applicationnotes' => { 126 => 0x2bc, 376 => 0x2bc },
	'applicationrecordversion' => { 149 => 0x0 },
	'applyautomatically' => { 361 => 'ApplyAutomatically' },
	'applyshootingmeteringmode' => { 91 => 0x10e },
	'approved' => { 543 => 'Approved' },
	'approvedby' => { 543 => 'ApprovedBy' },
	'approximatefnumber' => { 366 => 0x313, 373 => 0x3406 },
	'approximatefocusdistance' => { 532 => 'ApproximateFocusDistance' },
	'appversion' => { 547 => 'AppVersion' },
	'aps-csizecapture' => { 499 => 0x114, 500 => [0x114,0x1eb,0x1ee,0x21a,0x21c] },
	'aquahsl' => { 110 => 0x20914 },
	'armidentifier' => { 150 => 0x78 },
	'armversion' => { 150 => 0x7a },
	'arranger' => { 428 => "\xa9arg", 436 => "\xa9arg" },
	'arrangerkeywords' => { 436 => "\xa9ark" },
	'artdirector' => { 428 => "\xa9ard" },
	'artfilter' => { 346 => 0x529 },
	'artfiltereffect' => { 346 => 0x52f },
	'artist' => { 126 => 0x13b, 360 => 'Artist', 376 => 0x13b, 410 => 0x22e, 428 => "\xa9ART", 430 => 'artist', 436 => "\xa9ART", 561 => 'Artist', 565 => 'artist' },
	'artistid' => { 428 => 'atID' },
	'artmode' => { 120 => 0x301b },
	'artmodeparameters' => { 120 => 0x310b },
	'artwork' => { 430 => 'artwork' },
	'artworkcircadatecreated' => { 549 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 549 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 549 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 549 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 549 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 549 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 549 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 549 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 549 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 549 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 549 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 549 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 549 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 549 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 549 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 549 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 549 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 549 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 350 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 350 => 0x1112, 410 => 0x80, 466 => 0x55, 467 => 0x55, 468 => 0xa, 493 => [0x192c,0x1a88], 494 => 0x192c, 495 => 0x1958, 496 => 0x192c, 497 => 0x188c },
	'assetid' => { 523 => 'AssetID' },
	'asshoticcprofile' => { 126 => 0xc68f },
	'asshotneutral' => { 126 => 0xc628 },
	'asshotpreprofilematrix' => { 126 => 0xc690 },
	'asshotprofilename' => { 126 => 0xc6f6 },
	'asshotwhitexy' => { 126 => 0xc629 },
	'assignbktbutton' => { 324 => '4.2', 325 => '16.1', 327 => '16.1', 328 => '16.1', 337 => '16.1', 338 => '16.1' },
	'assignfuncbutton' => { 91 => 0x70b },
	'assignmb-d17af-onbutton' => { 328 => '79.1' },
	'assignmb-d17funcbutton' => { 328 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 328 => '68.1' },
	'assignmb-d18af-onbutton' => { 338 => '79.1' },
	'assignmb-d18funcbutton' => { 338 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 338 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 327 => '75.1', 328 => '75.1', 338 => '75.1' },
	'assignmoviefunc2button' => { 327 => '82.1', 328 => '82.1', 338 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 327 => '75.2', 328 => '75.2', 338 => '75.2' },
	'assignmovierecordbutton' => { 325 => '43.2', 337 => '45.1', 340 => 0x9f, 341 => 0x9b, 342 => 0x9b, 343 => 0x9b },
	'assignmovierecordbuttonplusdials' => { 327 => '45.1', 328 => '45.1', 338 => '45.1' },
	'assignmoviesubselector' => { 327 => '74.1', 328 => '74.1', 338 => '74.1' },
	'assignmoviesubselectorplusdials' => { 327 => '76.1', 328 => '76.1', 338 => '76.1' },
	'assignremotefnbutton' => { 325 => '54.1', 337 => '51.1' },
	'assistbuttonfunction' => { 89 => 0xd },
	'atcaptureusercrop' => { 156 => 0x943 },
	'attributionname' => { 533 => 'attributionName' },
	'attributionurl' => { 533 => 'attributionURL' },
	'audio' => { 371 => 0x20 },
	'audiobitrate' => { 73 => 0x6c, 549 => 'audioBitRate' },
	'audiobitratemode' => { 549 => 'audioBitRateMode' },
	'audiobitspersample' => { 549 => 'audioBitsPerSample' },
	'audiobutton' => { 342 => 0x17b, 343 => 0x193 },
	'audiobuttonplaybackmode' => { 342 => 0x1b9, 343 => 0x1d1 },
	'audiochannelcount' => { 549 => 'audioChannelCount' },
	'audiochannels' => { 73 => 0x70 },
	'audiochanneltype' => { 565 => 'audioChannelType' },
	'audiocompression' => { 91 => 0x816, 173 => 'Compression' },
	'audiocompressor' => { 565 => 'audioCompressor' },
	'audiodata' => { 140 => 'Data' },
	'audioduration' => { 149 => 0x99 },
	'audiogain' => { 427 => 'player.movie.audio.gain', 430 => 'player.movie.audio.gain' },
	'audiomimetype' => { 140 => 'Mime' },
	'audiomoddate' => { 565 => 'audioModDate' },
	'audiooutcue' => { 149 => 0x9a },
	'audiosamplerate' => { 73 => 0x6e, 565 => 'audioSampleRate' },
	'audiosampletype' => { 565 => 'audioSampleType' },
	'audiosamplingrate' => { 149 => 0x97 },
	'audiosamplingresolution' => { 149 => 0x98 },
	'audiotype' => { 149 => 0x96 },
	'author' => { 175 => 'Author', 356 => 'Author', 360 => 'Author', 426 => 'Author', 428 => ['auth',"\xa9aut"], 430 => 'author', 436 => 'auth', 529 => 'author', 551 => 'Author', 563 => 'Author' },
	'authorsposition' => { 553 => 'AuthorsPosition' },
	'authorurl' => { 197 => 'WM/AuthorURL' },
	'autoafpointcolortracking' => { 91 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 400 => '0.1' },
	'autobracket' => { 456 => 0x19 },
	'autobracketing' => { 134 => 0x1100, 410 => 0x18, 446 => 0x1007 },
	'autobracketingmode' => { 336 => '12.3' },
	'autobracketingset' => { 336 => '12.1' },
	'autobracketmodem' => { 324 => '21.2', 325 => '13.3', 327 => '13.2', 328 => '13.2', 333 => '26.2', 337 => '13.3', 338 => '13.2', 340 => 0x63, 341 => 0x5f, 342 => 0x5f, 343 => 0x5f },
	'autobracketorder' => { 202 => 0x43, 324 => '21.3', 325 => '13.2', 327 => '13.1', 328 => '13.1', 333 => '26.3', 334 => '12.2', 335 => '2.2', 336 => '12.2', 337 => '13.2', 338 => '13.1', 339 => '13.2', 340 => 0x65, 341 => 0x61, 342 => 0x61, 343 => 0x61 },
	'autobracketset' => { 324 => '21.1', 325 => '13.1', 329 => '11.1', 330 => '12.1', 331 => '12.1', 333 => '26.1', 334 => '12.1', 335 => '2.1', 337 => '13.1', 339 => '13.1' },
	'autobrightness' => { 535 => 'AutoBrightness', 537 => 'AutoBrightness' },
	'autocapturecriteria' => { 217 => 0x1 },
	'autocapturecriteriamotiondirection' => { 217 => 0x5f },
	'autocapturecriteriamotionsize' => { 217 => 0x64 },
	'autocapturecriteriamotionspeed' => { 217 => 0x63 },
	'autocapturecriteriasubjectsize' => { 217 => 0x69 },
	'autocapturecriteriasubjecttype' => { 217 => 0x6a },
	'autocapturedframe' => { 217 => 0x0 },
	'autocapturedistancefar' => { 217 => 0x4a },
	'autocapturedistancenear' => { 217 => 0x4e },
	'autocapturepreset' => { 268 => 0x746 },
	'autocapturerecordingtime' => { 217 => 0x37 },
	'autocapturewaittime' => { 217 => 0x38 },
	'autocontrast' => { 535 => 'AutoContrast', 537 => 'AutoContrast' },
	'autodistortioncontrol' => { 231 => 0x4, 261 => 0x2cf, 262 => 0x143 },
	'autodynamicrange' => { 134 => 0x140b },
	'autoexposure' => { 535 => 'AutoExposure', 537 => 'AutoExposure' },
	'autoexposurebracketing' => { 83 => 0x10 },
	'autoflashisosensitivity' => { 327 => '38.5', 328 => '38.5', 338 => '38.5', 340 => 0x5f, 341 => 0x5b, 342 => 0x5b, 343 => 0x5b },
	'autofocus' => { 349 => 0x209 },
	'autofocusmoderestrictions' => { 341 => 0x107, 342 => 0x107, 343 => 0x11d },
	'autofp' => { 335 => '7.3', 339 => '31.4' },
	'autoiso' => { 83 => 0x1, 120 => 0x3008, 261 => 0x288, 263 => 0x152, 266 => 0x142, 267 => 0x156, 268 => 0x156, 326 => '1.1', 335 => '1.1' },
	'autoisomax' => { 326 => '1.2', 335 => '1.2' },
	'autoisominshutterspeed' => { 326 => '1.3', 335 => '1.3' },
	'autolateralca' => { 535 => 'AutoLateralCA', 537 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 16 => 0xbe, 17 => 0xbf, 20 => 0xbf, 68 => 0x2, 91 => 0x204, 110 => 0x20500, 116 => 0x6f },
	'autolightingoptimizeron' => { 110 => '0x20500.0', 116 => 0x6e },
	'autoportraitframed' => { 480 => 0x2016 },
	'autoredeye' => { 317 => 0xfe28a44f },
	'autorotate' => { 83 => 0x1b },
	'autoshadows' => { 535 => 'AutoShadows', 537 => 'AutoShadows' },
	'autotone' => { 535 => 'AutoTone', 537 => 'AutoTone' },
	'autotonedigest' => { 535 => 'AutoToneDigest', 537 => 'AutoToneDigest' },
	'autotonedigestnosat' => { 535 => 'AutoToneDigestNoSat', 537 => 'AutoToneDigestNoSat' },
	'autowhiteversion' => { 535 => 'AutoWhiteVersion', 537 => 'AutoWhiteVersion' },
	'auxiliaryimagetype' => { 530 => 'AuxiliaryImageType' },
	'auxiliarylens' => { 257 => 0x82 },
	'avaperturesetting' => { 389 => 0x13 },
	'averageblacklevel' => { 50 => 0xe7, 52 => 0xfb, 53 => 0x114, 54 => 0x146 },
	'averagelv' => { 205 => 0x38 },
	'avsettingwithoutlens' => { 91 => 0x707 },
	'azimuth' => { 183 => 'Azimuth' },
	'babyage' => { 371 => [0x8010,0x33] },
	'babyname' => { 371 => 0x66 },
	'backgroundalpha' => { 560 => 'bgalpha' },
	'balance' => { 427 => 'player.movie.audio.balance', 430 => 'player.movie.audio.balance' },
	'baseexposurecompensation' => { 389 => 0x15 },
	'baseiso' => { 83 => 0x2, 104 => 0x101c, 156 => 0x903, 373 => 0x312a, 512 => 0x6 },
	'baseisodaylight' => { 156 => 0x910 },
	'baseisoflash' => { 156 => 0x913 },
	'baseisofluorescent' => { 156 => 0x912 },
	'baseisotungsten' => { 156 => 0x911 },
	'baselineexposure' => { 126 => 0xc62a },
	'baselineexposureoffset' => { 126 => 0xc7a5 },
	'baselinenoise' => { 126 => 0xc62b },
	'baselinesharpness' => { 126 => 0xc62c },
	'baserenditionishdr' => { 546 => 'BaseRenditionIsHDR' },
	'baseurl' => { 563 => 'BaseURL' },
	'bass' => { 427 => 'player.movie.audio.bass', 430 => 'player.movie.audio.bass' },
	'batterylevel' => { 371 => 0x38, 466 => 0x51, 470 => 0xc, 471 => 0x4, 472 => 0x4, 513 => 0x7, 514 => 0x5 },
	'batterylevel2' => { 514 => 0x7 },
	'batterylevelgrip1' => { 513 => 0x6 },
	'batterylevelgrip2' => { 513 => 0x8 },
	'batteryorder' => { 324 => '12.5', 333 => '13.2', 334 => '2.1', 337 => '3.1' },
	'batterystate' => { 202 => 0x60, 466 => 0x50, 472 => 0x14 },
	'batterytemperature' => { 470 => 0x1, 472 => 0x2, 513 => 0x5 },
	'batterytype' => { 70 => 0x38, 439 => 0x66, 440 => 0x4f, 441 => 0x74 },
	'batteryunknown' => { 470 => 0x2, 472 => 0x0 },
	'batteryvoltage' => { 156 => 0x408, 438 => 0x2a, 439 => 0x62, 440 => 0x4b, 441 => 0x72, 442 => 0x49, 470 => 0x8 },
	'batteryvoltage1' => { 472 => 0x6 },
	'batteryvoltage2' => { 472 => 0x8 },
	'batteryvoltageavg' => { 439 => 0x64, 440 => 0x4d },
	'bayergreensplit' => { 126 => 0xc62d },
	'bayerpattern' => { 155 => 0xf902, 206 => 0x17 },
	'beatsperminute' => { 428 => 'tmpo' },
	'beatspliceparams' => { 565 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 565 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 565 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 565 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 565 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 565 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 324 => '13.1', 325 => '5.4', 326 => '0.1', 329 => '2.1', 330 => '3.1', 331 => '3.1', 333 => '10.1', 335 => '0.1', 337 => '5.5', 339 => '4.1' },
	'beeppitch' => { 334 => '3.1' },
	'beepvolume' => { 334 => '4.5' },
	'bestqualityscale' => { 126 => 0xc65c },
	'bestshotmode' => { 120 => 0x3007 },
	'bitdepth' => { 180 => 'BitDepth', 206 => 0x11, 283 => 0x41 },
	'bitspercomponent' => { 151 => 0x87 },
	'bitspersample' => { 126 => 0x102, 376 => 0xa, 561 => 'BitsPerSample' },
	'blackacquirerows' => { 156 => 0x18ba },
	'blacklevel' => { 126 => [0x7310,0xc61a], 228 => 0x20, 257 => 0x3d, 351 => [0x401,0x1012], 419 => 0x21d, 487 => [0x7300,0x7310] },
	'blacklevel2' => { 350 => 0x600, 354 => 0x600 },
	'blacklevelblue' => { 376 => 0x1e },
	'blacklevelbottom' => { 156 => 0x3f0 },
	'blackleveldata' => { 419 => 0x223 },
	'blackleveldeltah' => { 126 => 0xc61b },
	'blackleveldeltav' => { 126 => 0xc61c },
	'blacklevelgreen' => { 376 => 0x1d },
	'blacklevelred' => { 376 => 0x1c },
	'blacklevelrepeatdim' => { 126 => 0xc619 },
	'blacklevelrough' => { 156 => 0x40e },
	'blacklevelroughafter' => { 156 => 0x416 },
	'blacklevels' => { 39 => 0x1d },
	'blackleveltop' => { 156 => 0x3ef },
	'blackpoint' => { 410 => 0x200 },
	'blacks2012' => { 535 => 'Blacks2012', 537 => 'Blacks2012' },
	'blacksadj' => { 517 => 0x9018 },
	'bleachbypasstoning' => { 410 => 0x7f },
	'blockshotafresponse' => { 327 => '1.5', 328 => '1.5', 338 => '1.5', 340 => 0x7, 341 => 0x7, 342 => 0x7, 343 => 0x7 },
	'blogtitle' => { 555 => 'blogTitle' },
	'blogurl' => { 555 => 'blogURL' },
	'bluebalance' => { 351 => 0x1018, 376 => 0x12, 410 => 0x1b },
	'bluecurvelimits' => { 115 => 0x1fe },
	'bluecurvepoints' => { 114 => 0x79, 115 => 0x1d4 },
	'bluehsl' => { 110 => 0x20915 },
	'bluehue' => { 535 => 'BlueHue', 537 => 'BlueHue' },
	'bluesaturation' => { 535 => 'BlueSaturation', 537 => 'BlueSaturation' },
	'bluetoothfirmwaredate' => { 441 => 0x3a },
	'bluetoothfirmwareversion' => { 441 => 0x34 },
	'bluratinfinity' => { 145 => 'BlurAtInfinity' },
	'blurcontrol' => { 410 => 0x82 },
	'blurwarning' => { 134 => 0x1300 },
	'bodybatteryadload' => { 386 => 0x3 },
	'bodybatteryadnoload' => { 386 => 0x2 },
	'bodybatterypercent' => { 386 => 0x3 },
	'bodybatterystate' => { 386 => ['1.1',0x2] },
	'bodybatteryvoltage' => { 386 => 0x4 },
	'bodybatteryvoltage1' => { 386 => 0x2 },
	'bodybatteryvoltage2' => { 386 => 0x4 },
	'bodybatteryvoltage3' => { 386 => 0x6 },
	'bodybatteryvoltage4' => { 386 => 0x8 },
	'bodyfirmware' => { 447 => 0x0 },
	'bodyfirmwareversion' => { 347 => 0x104, 348 => 0x100, 351 => 0x104 },
	'bodyserialnumber' => { 447 => 0x10 },
	'bookedition' => { 555 => 'bookEdition' },
	'bootloaderversion' => { 442 => 0x26 },
	'bracketbutton' => { 265 => 0x808, 268 => 0x80c },
	'bracketbuttonplaybackmode' => { 265 => 0x810, 268 => 0x816 },
	'bracketincrement' => { 261 => 0x34a, 263 => 0x22e, 266 => 0x21a, 267 => 0x22e, 268 => 0x22e },
	'bracketmode' => { 62 => 0x3 },
	'bracketprogram' => { 261 => 0x348, 263 => 0x22c, 266 => 0x218, 267 => 0x22c, 268 => 0x22c },
	'bracketsequence' => { 120 => 0x301d },
	'bracketset' => { 261 => 0x346, 263 => 0x22a, 266 => 0x216, 267 => 0x22a, 268 => 0x22a },
	'bracketsettings' => { 371 => 0x45 },
	'bracketshotnumber' => { 62 => 0x5, 389 => 0x9, 477 => 0x2b },
	'bracketshotnumber2' => { 477 => 0x2d },
	'bracketstep' => { 199 => 0xe },
	'bracketvalue' => { 62 => 0x4 },
	'brightness' => { 126 => 0xfe53, 174 => 'Brightness', 194 => 'Brightness', 199 => 0x2c, 275 => 0x34, 276 => 0x39, 277 => 0x41, 430 => 'player.movie.visual.brightness', 438 => 0x25, 439 => 0x54, 440 => 0x3e, 441 => 0x64, 466 => 0x22, 480 => 0x2007, 535 => 'Brightness', 537 => 'Brightness' },
	'brightnessadj' => { 115 => 0x114, 310 => 0x0, 320 => 0x2d, 517 => 0x8018 },
	'brightnessvalue' => { 126 => 0x9203, 205 => [0x691,0x49c3], 351 => 0x1003, 485 => 0x1e, 489 => 0x1140, 490 => 0x1140, 491 => 0x111c, 492 => 0x1198, 493 => 0x1174, 494 => 0x102c, 495 => 0x224, 496 => 0x224, 497 => 0x219, 541 => 'BrightnessValue' },
	'buildnumber' => { 209 => 0x5500 },
	'bulbduration' => { 83 => 0x18 },
	'burstcount' => { 156 => 0x40d },
	'burstgroupid' => { 259 => 0x4 },
	'burstid' => { 141 => 'BurstID' },
	'burstmode' => { 158 => 0xa, 371 => 0x2a },
	'burstmode2' => { 158 => 0x18 },
	'burstprimary' => { 141 => 'BurstPrimary' },
	'burstshot' => { 456 => 0x34 },
	'burstspeed' => { 371 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 91 => 0x70a },
	'bwadjustment' => { 134 => 0x1049 },
	'bwfilter' => { 199 => 0x2a, 207 => 0x39 },
	'bwmagentagreen' => { 134 => 0x104b },
	'bwmode' => { 351 => 0x203 },
	'by-line' => { 149 => 0x50 },
	'by-linetitle' => { 149 => 0x55 },
	'bytecount' => { 555 => 'byteCount' },
	'c14configuration' => { 156 => 0x1964 },
	'cacheversion' => { 126 => 0xc7aa },
	'cafarea' => { 393 => 0x2 },
	'cafgridsize' => { 387 => '1.1' },
	'calibratedfocallength' => { 123 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 123 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 123 => 'CalibratedOpticalCenterY' },
	'calibration' => { 456 => [0x24,0x30] },
	'calibrationhistory' => { 156 => 0x9c9 },
	'calibrationilluminant1' => { 126 => 0xc65a },
	'calibrationilluminant2' => { 126 => 0xc65b },
	'calibrationilluminant3' => { 126 => 0xcd31 },
	'calibrationversion' => { 156 => 0x9c6 },
	'callforimage' => { 523 => 'CallForImage' },
	'camera' => { 139 => [\'Cameras','CamerasCamera'] },
	'cameraangle' => { 436 => 'angl', 565 => 'cameraAngle' },
	'cameraappinfo' => { 139 => [\'Cameras','CamerasCameraAppInfo'] },
	'cameraappinfoapplication' => { 139 => [\'Cameras','CamerasCameraAppInfoApplication'] },
	'cameraappinfoitemuri' => { 139 => [\'Cameras','CamerasCameraAppInfoItemURI'] },
	'cameraappinfoversion' => { 139 => [\'Cameras','CamerasCameraAppInfoVersion'] },
	'cameraburstid' => { 143 => 'CameraBurstID' },
	'cameracalibration' => { 456 => 0x11f },
	'cameracalibration1' => { 126 => 0xc623 },
	'cameracalibration2' => { 126 => 0xc624 },
	'cameracalibration3' => { 126 => 0xcd32 },
	'cameracalibrationsig' => { 126 => 0xc6f3 },
	'cameracolorcalibration01' => { 40 => 0x0, 41 => 0x0 },
	'cameracolorcalibration02' => { 40 => 0x4, 41 => 0x5 },
	'cameracolorcalibration03' => { 40 => 0x8, 41 => 0xa },
	'cameracolorcalibration04' => { 40 => 0xc, 41 => 0xf },
	'cameracolorcalibration05' => { 40 => 0x10, 41 => 0x14 },
	'cameracolorcalibration06' => { 40 => 0x14, 41 => 0x19 },
	'cameracolorcalibration07' => { 40 => 0x18, 41 => 0x1e },
	'cameracolorcalibration08' => { 40 => 0x1c, 41 => 0x23 },
	'cameracolorcalibration09' => { 40 => 0x20, 41 => 0x28 },
	'cameracolorcalibration10' => { 40 => 0x24, 41 => 0x2d },
	'cameracolorcalibration11' => { 40 => 0x28, 41 => 0x32 },
	'cameracolorcalibration12' => { 40 => 0x2c, 41 => 0x37 },
	'cameracolorcalibration13' => { 40 => 0x30, 41 => 0x3c },
	'cameracolorcalibration14' => { 40 => 0x34, 41 => 0x41 },
	'cameracolorcalibration15' => { 40 => 0x38, 41 => 0x46 },
	'cameradepthmap' => { 139 => [\'Cameras','CamerasCameraDepthMap'] },
	'cameradepthmapconfidenceuri' => { 139 => [\'Cameras','CamerasCameraDepthMapConfidenceURI'] },
	'cameradepthmapdepthuri' => { 139 => [\'Cameras','CamerasCameraDepthMapDepthURI'] },
	'cameradepthmapfar' => { 139 => [\'Cameras','CamerasCameraDepthMapFar'] },
	'cameradepthmapfocaltable' => { 139 => [\'Cameras','CamerasCameraDepthMapFocalTable'] },
	'cameradepthmapfocaltableentrycount' => { 139 => [\'Cameras','CamerasCameraDepthMapFocalTableEntryCount'] },
	'cameradepthmapformat' => { 139 => [\'Cameras','CamerasCameraDepthMapFormat'] },
	'cameradepthmapitemsemantic' => { 139 => [\'Cameras','CamerasCameraDepthMapItemSemantic'] },
	'cameradepthmapmeasuretype' => { 139 => [\'Cameras','CamerasCameraDepthMapMeasureType'] },
	'cameradepthmapnear' => { 139 => [\'Cameras','CamerasCameraDepthMapNear'] },
	'cameradepthmapsoftware' => { 139 => [\'Cameras','CamerasCameraDepthMapSoftware'] },
	'cameradepthmapunits' => { 139 => [\'Cameras','CamerasCameraDepthMapUnits'] },
	'cameradirection' => { 430 => 'direction.facing' },
	'camerae-mountversion' => { 516 => 0xb },
	'cameraelevationangle' => { 126 => 0x9405, 542 => 'CameraElevationAngle' },
	'camerafilename' => { 523 => 'CameraFilename' },
	'camerafirmware' => { 126 => 0xa439, 542 => 'CameraFirmware' },
	'cameraid' => { 351 => 0x209, 436 => 'cmid', 455 => 0x209 },
	'cameraidentifier' => { 437 => 'camera.identifier' },
	'cameraimage' => { 139 => [\'Cameras','CamerasCameraImage'] },
	'cameraimageitemsemantic' => { 139 => [\'Cameras','CamerasCameraImageItemSemantic'] },
	'cameraimageitemuri' => { 139 => [\'Cameras','CamerasCameraImageItemURI'] },
	'cameraimagingmodel' => { 139 => [\'Cameras','CamerasCameraImagingModel'] },
	'cameraimagingmodeldistortion' => { 139 => [\'Cameras','CamerasCameraImagingModelDistortion'] },
	'cameraimagingmodeldistortioncount' => { 139 => [\'Cameras','CamerasCameraImagingModelDistortionCount'] },
	'cameraimagingmodelfocallengthx' => { 139 => [\'Cameras','CamerasCameraImagingModelFocalLengthX'] },
	'cameraimagingmodelfocallengthy' => { 139 => [\'Cameras','CamerasCameraImagingModelFocalLengthY'] },
	'cameraimagingmodelimageheight' => { 139 => [\'Cameras','CamerasCameraImagingModelImageHeight'] },
	'cameraimagingmodelimagewidth' => { 139 => [\'Cameras','CamerasCameraImagingModelImageWidth'] },
	'cameraimagingmodelpixelaspectratio' => { 139 => [\'Cameras','CamerasCameraImagingModelPixelAspectRatio'] },
	'cameraimagingmodelprincipalpointx' => { 139 => [\'Cameras','CamerasCameraImagingModelPrincipalPointX'] },
	'cameraimagingmodelprincipalpointy' => { 139 => [\'Cameras','CamerasCameraImagingModelPrincipalPointY'] },
	'cameraimagingmodelskew' => { 139 => [\'Cameras','CamerasCameraImagingModelSkew'] },
	'cameraiso' => { 38 => 0x10 },
	'cameralabel' => { 126 => 0xc7a1, 565 => 'cameraLabel' },
	'cameralightestimate' => { 139 => [\'Cameras','CamerasCameraLightEstimate'] },
	'cameralightestimatecolorcorrectionb' => { 139 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionB'] },
	'cameralightestimatecolorcorrectiong' => { 139 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionG'] },
	'cameralightestimatecolorcorrectionr' => { 139 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionR'] },
	'cameralightestimatepixelintensity' => { 139 => [\'Cameras','CamerasCameraLightEstimatePixelIntensity'] },
	'cameramakemodel' => { 523 => 'CameraMakeModel' },
	'cameramodel' => { 419 => 0x410, 565 => 'cameraModel' },
	'cameramodelid' => { 194 => 'CameraModelID' },
	'cameramodelrestriction' => { 535 => 'CameraModelRestriction', 537 => 'CameraModelRestriction' },
	'cameramotion' => { 430 => 'direction.motion' },
	'cameramove' => { 565 => 'cameraMove' },
	'cameraorientation' => { 7 => 0x30, 9 => 0x7d, 11 => 0x30, 13 => 0x35, 14 => 0x30, 15 => 0x30, 16 => 0x31, 17 => 0x31, 18 => 0x35, 19 => 0x27, 20 => 0x31, 21 => 0x7d, 22 => 0x38, 23 => [0x36,0x3a], 24 => 0x7d, 25 => 0x83, 26 => 0x84, 27 => 0x96, 28 => 0x35, 29 => 0x96, 371 => 0x8f, 409 => 0x1, 414 => 0x1, 419 => 0x100, 472 => [0x16,0x18], 503 => 0x28, 504 => 0x24, 505 => 0x29 },
	'cameraowner' => { 159 => 0xc353 },
	'cameraparameters' => { 351 => 0x2050 },
	'camerapicturestyle' => { 28 => 0xaf },
	'camerapitch' => { 122 => 0x9, 436 => "\xa9gpt" },
	'camerapointcloud' => { 139 => [\'Cameras','CamerasCameraPointCloud'] },
	'camerapointcloudmetric' => { 139 => [\'Cameras','CamerasCameraPointCloudMetric'] },
	'camerapointcloudpointcloud' => { 139 => [\'Cameras','CamerasCameraPointCloudPointCloud'] },
	'camerapointcloudpoints' => { 139 => [\'Cameras','CamerasCameraPointCloudPoints'] },
	'camerapose' => { 139 => [\'Cameras','CamerasCameraPose'] },
	'cameraposepositionx' => { 139 => [\'Cameras','CamerasCameraPosePositionX'] },
	'cameraposepositiony' => { 139 => [\'Cameras','CamerasCameraPosePositionY'] },
	'cameraposepositionz' => { 139 => [\'Cameras','CamerasCameraPosePositionZ'] },
	'cameraposerotationw' => { 139 => [\'Cameras','CamerasCameraPoseRotationW'] },
	'cameraposerotationx' => { 139 => [\'Cameras','CamerasCameraPoseRotationX'] },
	'cameraposerotationy' => { 139 => [\'Cameras','CamerasCameraPoseRotationY'] },
	'cameraposerotationz' => { 139 => [\'Cameras','CamerasCameraPoseRotationZ'] },
	'cameraposetimestamp' => { 139 => [\'Cameras','CamerasCameraPoseTimestamp'] },
	'cameraprofile' => { 535 => 'CameraProfile', 537 => 'CameraProfile' },
	'cameraprofiledigest' => { 535 => 'CameraProfileDigest', 537 => 'CameraProfileDigest' },
	'cameraprofiles' => { 553 => 'CameraProfiles' },
	'cameraprofilesaperturevalue' => { 553 => [\'CameraProfiles','CameraProfilesApertureValue'] },
	'cameraprofilesauthor' => { 553 => [\'CameraProfiles','CameraProfilesAuthor'] },
	'cameraprofilesautoscale' => { 553 => [\'CameraProfiles','CameraProfilesAutoScale'] },
	'cameraprofilescameraprettyname' => { 553 => [\'CameraProfiles','CameraProfilesCameraPrettyName'] },
	'cameraprofilescamerarawprofile' => { 553 => [\'CameraProfiles','CameraProfilesCameraRawProfile'] },
	'cameraprofilesfocallength' => { 553 => [\'CameraProfiles','CameraProfilesFocalLength'] },
	'cameraprofilesfocusdistance' => { 553 => [\'CameraProfiles','CameraProfilesFocusDistance'] },
	'cameraprofileslens' => { 553 => [\'CameraProfiles','CameraProfilesLens'] },
	'cameraprofileslensprettyname' => { 553 => [\'CameraProfiles','CameraProfilesLensPrettyName'] },
	'cameraprofilesmake' => { 553 => [\'CameraProfiles','CameraProfilesMake'] },
	'cameraprofilesmodel' => { 553 => [\'CameraProfiles','CameraProfilesModel'] },
	'cameraprofilesperspectivemodel' => { 553 => [\'CameraProfiles','CameraProfilesPerspectiveModel'] },
	'cameraprofilesperspectivemodelimagexcenter' => { 553 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageXCenter'] },
	'cameraprofilesperspectivemodelimageycenter' => { 553 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageYCenter'] },
	'cameraprofilesperspectivemodelradialdistortparam1' => { 553 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam1'] },
	'cameraprofilesperspectivemodelradialdistortparam2' => { 553 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam2'] },
	'cameraprofilesperspectivemodelradialdistortparam3' => { 553 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam3'] },
	'cameraprofilesperspectivemodelscalefactor' => { 553 => [\'CameraProfiles','CameraProfilesPerspectiveModelScaleFactor'] },
	'cameraprofilesperspectivemodelversion' => { 553 => [\'CameraProfiles','CameraProfilesPerspectiveModelVersion'] },
	'cameraprofilesprofilename' => { 553 => [\'CameraProfiles','CameraProfilesProfileName'] },
	'cameraprofilessensorformatfactor' => { 553 => [\'CameraProfiles','CameraProfilesSensorFormatFactor'] },
	'cameraprofilesuniquecameramodel' => { 553 => [\'CameraProfiles','CameraProfilesUniqueCameraModel'] },
	'camerarawcolortone' => { 116 => 0xe1 },
	'camerarawcontrast' => { 116 => 0xe3 },
	'camerarawhighlightpoint' => { 116 => 0xe6 },
	'camerarawlinear' => { 116 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 116 => 0xe8 },
	'camerarawoutputshadowpoint' => { 116 => 0xe9 },
	'camerarawsaturation' => { 116 => 0xe2 },
	'camerarawshadowpoint' => { 116 => 0xe7 },
	'camerarawsharpness' => { 116 => 0xe5 },
	'cameraroll' => { 122 => 0xb, 436 => "\xa9grl" },
	'cameras' => { 139 => 'Cameras' },
	'cameraserialnumber' => { 126 => 0xc62f, 196 => 'CameraSerialNumber', 523 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 346 => 0x0 },
	'cameratemperature' => { 7 => 0x18, 9 => 0x1b, 11 => 0x18, 13 => 0x19, 14 => 0x18, 15 => 0x18, 16 => 0x19, 17 => 0x19, 18 => 0x19, 19 => 0x17, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => 0x19, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x1b, 28 => 0x19, 29 => 0x1b, 31 => [0x87,0x91], 32 => [0x99,0x9f,0xa4,0xa8,0x105], 37 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 83 => 0xc, 156 => 0x406, 350 => 0x1306, 366 => 0x320, 373 => 0x3402, 410 => 0x47, 453 => 0x43, 507 => 0x5 },
	'cameratemperature4' => { 415 => 0x14 },
	'cameratemperature5' => { 415 => 0x16 },
	'cameratemperaturerangemax' => { 128 => 0x5 },
	'cameratemperaturerangemin' => { 128 => 0x6 },
	'cameratrait' => { 139 => [\'Cameras','CamerasCameraTrait'] },
	'cameratype' => { 1 => 0x2e, 83 => 0x1a, 351 => 0x207 },
	'cameratype2' => { 347 => 0x100 },
	'cameravendorinfo' => { 139 => [\'Cameras','CamerasCameraVendorInfo'] },
	'cameravendorinfomanufacturer' => { 139 => [\'Cameras','CamerasCameraVendorInfoManufacturer'] },
	'cameravendorinfomodel' => { 139 => [\'Cameras','CamerasCameraVendorInfoModel'] },
	'cameravendorinfonotes' => { 139 => [\'Cameras','CamerasCameraVendorInfoNotes'] },
	'camerayaw' => { 122 => 0xa, 436 => "\xa9gyw" },
	'camreverse' => { 123 => 'CamReverse' },
	'canondr4' => { 127 => 'CanonDR4' },
	'canonexposuremode' => { 38 => 0x14 },
	'canonfiledescription' => { 104 => 0x805 },
	'canonfilelength' => { 70 => 0xe },
	'canonfirmwareversion' => { 70 => 0x7, 104 => 0x80b },
	'canonflashinfo' => { 104 => 0x1028 },
	'canonflashmode' => { 38 => 0x4 },
	'canonimagesize' => { 10 => 0x39, 38 => 0xa },
	'canonimagetype' => { 70 => 0x6, 104 => 0x815 },
	'canonlogversion' => { 69 => 0xb },
	'canonmodelid' => { 70 => 0x10, 104 => 0x1834 },
	'canonvrd' => { 127 => 'CanonVRD' },
	'caption' => { 529 => 'caption' },
	'caption-abstract' => { 149 => 0x78 },
	'captionsauthornames' => { 540 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 540 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 553 => 'CaptionWriter' },
	'captureframerate' => { 120 => 0x4001 },
	'captureheightnormal' => { 156 => 0x1839 },
	'capturelook' => { 156 => 0xc48 },
	'capturemode' => { 437 => 'com.apple.photos.captureMode' },
	'capturesoftware' => { 147 => 'CaptureSoftware' },
	'capturewidthnormal' => { 156 => 0x1838 },
	'capturewidthtest' => { 156 => 0x1842 },
	'cardshutterlock' => { 202 => 0x49 },
	'caseautosetting' => { 2 => 0x1c },
	'casioimagesize' => { 120 => 0x9 },
	'catalogsets' => { 149 => 0xff, 522 => 'CatalogSets', 527 => 'CatalogSets' },
	'categories' => { 70 => 0x23, 529 => 'categories' },
	'category' => { 149 => 0xf, 197 => 'WM/Category', 344 => 0x30, 428 => 'catg', 553 => 'Category' },
	'cbcrgain' => { 453 => 0xa036 },
	'cbcrgaindefault' => { 453 => 0xa035 },
	'cbcrmatrix' => { 453 => 0xa034 },
	'cbcrmatrixdefault' => { 453 => 0xa033 },
	'ccdboardversion' => { 366 => 0x331 },
	'ccdscanmode' => { 351 => 0x1039 },
	'ccdsensitivity' => { 306 => 0x6 },
	'ccdversion' => { 366 => 0x330 },
	'ccvavgluminancenits' => { 545 => 'ccv_avg_luminance_nits' },
	'ccvmaxluminancenits' => { 545 => 'ccv_max_luminance_nits' },
	'ccvminluminancenits' => { 545 => 'ccv_min_luminance_nits' },
	'ccvprimariesxy' => { 545 => 'ccv_primaries_xy' },
	'ccvwhitexy' => { 545 => 'ccv_white_xy' },
	'cellglobalid' => { 534 => 'cgi' },
	'celllength' => { 126 => 0x109 },
	'cellr' => { 534 => 'r' },
	'celltowerid' => { 534 => 'cellid' },
	'cellwidth' => { 126 => 0x108 },
	'centerafarea' => { 335 => '15.1' },
	'centerfocuspoint' => { 339 => '2.2' },
	'centerpixel' => { 156 => 0x40c },
	'centerweightedareasize' => { 324 => '7.1', 325 => '8.1', 327 => '8.1', 328 => '8.1', 332 => '7.1', 333 => '5.1', 334 => '7.1', 335 => '6.3', 337 => '8.1', 338 => '8.1', 339 => '8.1', 340 => 0x21, 341 => 0x1f, 342 => 0x1f, 343 => 0x1f },
	'certificate' => { 569 => 'Certificate' },
	'cfainterpolationalgorithm' => { 156 => 0xe60 },
	'cfainterpolationmetric' => { 156 => 0xe61 },
	'cfaoffsetcols' => { 156 => 0xc71 },
	'cfaoffsetrows' => { 156 => 0xc6f },
	'cfapattern' => { 126 => 0xa302, 376 => 0x9, 541 => 'CFAPattern' },
	'cfapattern2' => { 126 => 0x828e },
	'cfapatterncolumns' => { 541 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 541 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 541 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 126 => 0x828d },
	'cfazipperfixthreshold' => { 156 => 0xe62 },
	'channel' => { 555 => 'channel' },
	'channela-lang' => { 555 => [\'channel','channelA-lang'] },
	'channelchannel' => { 555 => [\'channel','channelChannel'] },
	'channels' => { 173 => 'Channels' },
	'channelsubchannel1' => { 555 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 555 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 555 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 555 => [\'channel','channelSubchannel4'] },
	'chapterlist' => { 436 => 'chpl' },
	'checkmark' => { 110 => 0x10101, 115 => 0x26a },
	'checkmark2' => { 116 => 0x8e },
	'childfontfiles' => { 570 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 324 => '10.3', 325 => '11.2', 341 => 0x10b, 342 => 0x10b, 343 => 0x121 },
	'chromablurradius' => { 126 => 0xc631 },
	'chromanoisecolorspace' => { 156 => 0xe6d },
	'chromanoiseedgemapthresh' => { 156 => 0xe6c },
	'chromanoisehighfthresh' => { 156 => 0xe6a },
	'chromanoiselowfthresh' => { 156 => 0xe6b },
	'chromaticaberration' => { 110 => 0x20703, 116 => 0x66, 453 => 0xa051 },
	'chromaticaberrationb' => { 535 => 'ChromaticAberrationB', 537 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 110 => 0x20708, 116 => 0x6b },
	'chromaticaberrationcorr' => { 85 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 126 => 0x7034, 399 => 0x1, 517 => 0x900d },
	'chromaticaberrationcorrparams' => { 126 => 0x7035, 511 => 0x66a, 512 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 110 => '0x20703.0', 116 => 0x62 },
	'chromaticaberrationr' => { 535 => 'ChromaticAberrationR', 537 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 110 => 0x20707, 116 => 0x6a },
	'chromaticaberrationsetting' => { 86 => 0x6 },
	'chrominancenoisereduction' => { 110 => 0x20601, 116 => 0x5e, 456 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 116 => 0x60 },
	'circadatecreated' => { 549 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrblacks2012' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'] },
	'circgradbasedcorrbrightness' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrcorrectionname' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'] },
	'circgradbasedcorrcorrectionsyncid' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'] },
	'circgradbasedcorrdefringe' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrdehaze' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'] },
	'circgradbasedcorrexposure' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'] },
	'circgradbasedcorrluminancenoise' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskinputdigest' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'circgradbasedcorrmaskleft' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmaskactive' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'circgradbasedcorrmaskmaskblendmode' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmaskdigest' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'circgradbasedcorrmaskmaskinverted' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'circgradbasedcorrmaskmaskname' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'] },
	'circgradbasedcorrmaskmasks' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'] },
	'circgradbasedcorrmaskmasksalpha' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'circgradbasedcorrmaskmasksangle' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'circgradbasedcorrmaskmasksbottom' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'circgradbasedcorrmaskmaskscentervalue' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'circgradbasedcorrmaskmaskscenterweight' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'circgradbasedcorrmaskmasksdabs' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'circgradbasedcorrmaskmasksfeather' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'circgradbasedcorrmaskmasksflipped' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'circgradbasedcorrmaskmasksflow' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'circgradbasedcorrmaskmasksfullx' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'circgradbasedcorrmaskmasksfully' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'circgradbasedcorrmaskmasksinputdigest' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'circgradbasedcorrmaskmasksleft' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'circgradbasedcorrmaskmasksmaskactive' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'circgradbasedcorrmaskmasksmaskblendmode' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmasksmaskdigest' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'circgradbasedcorrmaskmasksmaskinverted' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'circgradbasedcorrmaskmasksmaskname' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'circgradbasedcorrmaskmasksmasksubtype' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksmasksyncid' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'circgradbasedcorrmaskmasksmaskversion' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'circgradbasedcorrmaskmasksmidpoint' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'circgradbasedcorrmaskmasksorigin' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'circgradbasedcorrmaskmasksperimetervalue' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'circgradbasedcorrmaskmasksradius' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'circgradbasedcorrmaskmasksreferencepoint' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'circgradbasedcorrmaskmasksright' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'circgradbasedcorrmaskmasksroundness' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'circgradbasedcorrmaskmaskssizex' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'circgradbasedcorrmaskmaskssizey' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'circgradbasedcorrmaskmaskstop' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'circgradbasedcorrmaskmasksubtype' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksvalue' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'circgradbasedcorrmaskmasksversion' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'circgradbasedcorrmaskmaskswhat' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'circgradbasedcorrmaskmaskswholeimagearea' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'circgradbasedcorrmaskmasksx' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'] },
	'circgradbasedcorrmaskmasksy' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'] },
	'circgradbasedcorrmaskmasksyncid' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'circgradbasedcorrmaskmaskszerox' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'circgradbasedcorrmaskmaskszeroy' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'circgradbasedcorrmaskmaskversion' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'circgradbasedcorrmaskmidpoint' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskorigin' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'] },
	'circgradbasedcorrmaskperimetervalue' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskrange' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'circgradbasedcorrmaskrangeareamodels' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrmaskrangeareamodelscolorsampleinfo' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrmaskrangeareamodelscomponents' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrmaskrangecoloramount' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrmaskrangedepthfeather' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrmaskrangedepthmax' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrmaskrangedepthmin' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrmaskrangeinvert' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'circgradbasedcorrmaskrangelumfeather' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrmaskrangeluminancedepthsampleinfo' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrmaskrangelummax' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrmaskrangelummin' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrmaskrangelumrange' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrmaskrangesampletype' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrmaskrangetype' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'circgradbasedcorrmaskrangeversion' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'circgradbasedcorrmaskreferencepoint' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'circgradbasedcorrmaskright' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskwholeimagearea' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'circgradbasedcorrmaskx' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrrangemask' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'] },
	'circgradbasedcorrrangemaskareamodels' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrrangemaskareamodelscolorsampleinfo' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrrangemaskareamodelscomponents' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrrangemaskcoloramount' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrrangemaskdepthfeather' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrrangemaskdepthmax' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrrangemaskdepthmin' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrrangemaskinvert' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'circgradbasedcorrrangemasklumfeather' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrrangemaskluminancedepthsampleinfo' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrrangemasklummax' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrrangemasklummin' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrrangemasklumrange' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrrangemasksampletype' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrrangemasktype' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'] },
	'circgradbasedcorrrangemaskversion' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'circgradbasedcorrsaturation' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'] },
	'circgradbasedcorrshadows2012' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtexture' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'] },
	'circgradbasedcorrtint' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrtoninghue' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrtoningsaturation' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrwhat' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circgradbasedcorrwhites2012' => { 535 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'], 537 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'] },
	'circulargradientbasedcorrections' => { 535 => 'CircularGradientBasedCorrections', 537 => 'CircularGradientBasedCorrections' },
	'city' => { 149 => 0x5a, 179 => 'City', 371 => 0x6d, 553 => 'City' },
	'city2' => { 371 => 0x80 },
	'clarity' => { 38 => 0x33, 134 => 0x100f, 276 => 0x35, 277 => 0x3d, 480 => 0x2036, 535 => 'Clarity', 537 => 'Clarity' },
	'clarity2012' => { 535 => 'Clarity2012', 537 => 'Clarity2012' },
	'claritycontrol' => { 410 => 0x96 },
	'classification' => { 436 => 'clsf' },
	'classifystate' => { 149 => 0xe1 },
	'clearretouch' => { 371 => 0x7c },
	'clearretouchvalue' => { 371 => 0xa3 },
	'client' => { 565 => 'client' },
	'clientname' => { 543 => 'ClientName' },
	'clipboardaspectratio' => { 535 => 'ClipboardAspectRatio', 537 => 'ClipboardAspectRatio' },
	'clipboardorientation' => { 535 => 'ClipboardOrientation', 537 => 'ClipboardOrientation' },
	'clipfilename' => { 436 => 'clfn' },
	'clipid' => { 436 => 'clid' },
	'clmodeshootingspeed' => { 324 => '10.2', 325 => '11.3', 327 => '11.2', 328 => '11.2', 333 => '11.2', 334 => '10.2', 337 => '11.2', 338 => '11.2', 339 => '11.1', 340 => 0x3f, 341 => 0x3b, 342 => 0x3b, 343 => 0x3b },
	'cluster' => { 535 => 'Cluster', 537 => 'Cluster' },
	'cmcontrast' => { 354 => 0x2022 },
	'cmddialsreverserotation' => { 340 => 0xbe, 341 => 0xba, 342 => 0xba, 343 => 0xba },
	'cmexposurecompensation' => { 354 => 0x2000 },
	'cmhue' => { 354 => 0x2021 },
	'cmsaturation' => { 354 => 0x2020 },
	'cmsharpness' => { 354 => 0x2023 },
	'cmwhitebalance' => { 354 => 0x2001 },
	'cmwhitebalancecomp' => { 354 => 0x2002 },
	'cmwhitebalancegraypoint' => { 354 => 0x2010 },
	'codec' => { 187 => 'Codec' },
	'codedcharacterset' => { 150 => 0x5a },
	'codeversion' => { 436 => 'cver' },
	'collection' => { 360 => 'Collection' },
	'collectionname' => { 188 => [\'Collections','CollectionsCollectionName'], 436 => 'coll' },
	'collections' => { 188 => 'Collections', 529 => 'collections' },
	'collectionuri' => { 188 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 430 => 'player.movie.visual.color', 554 => 'color' },
	'coloraberrationcontrol' => { 317 => 0xc89224b },
	'coloradjustment' => { 456 => 0x14 },
	'coloradjustmentmode' => { 455 => 0x210 },
	'coloranta' => { 570 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 570 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 570 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 570 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 570 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 570 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 570 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 570 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 570 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 570 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 570 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 570 => 'Colorants' },
	'colorantswatchname' => { 570 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 570 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 570 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 570 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 174 => 'ColorBalance' },
	'colorbalanceadj' => { 317 => 0x76a43202 },
	'colorbalanceblue' => { 199 => 0x1e },
	'colorbalancegreen' => { 199 => 0x1d },
	'colorbalancered' => { 199 => 0x1c },
	'colorbalanceversion' => { 227 => 0x4, 228 => 0x4, 229 => 0x0, 230 => 0x0 },
	'colorblur' => { 116 => 0x65 },
	'colorbluron' => { 110 => 0x20704 },
	'colorbooster' => { 317 => 0x5f0e7d23 },
	'colorboostlevel' => { 311 => 0x1 },
	'colorboosttype' => { 311 => 0x0 },
	'colorchromeeffect' => { 134 => 0x1048 },
	'colorchromefxblue' => { 134 => 0x104e },
	'colorclass' => { 421 => 0xde, 422 => 'ColorClass' },
	'colorcompensationfilter' => { 202 => [0x3a,0x5f], 204 => 0x111, 480 => 0xb022 },
	'colorcompensationfiltercustom' => { 466 => 0xd, 467 => 0xc },
	'colorcompensationfilterset' => { 466 => 0x8, 467 => 0x7, 468 => 0x18, 485 => 0xf },
	'colorcontrol' => { 351 => 0x102b },
	'colorcorrection' => { 517 => 0x8015 },
	'colorcorrectionmatrix' => { 1 => 0x3e },
	'colorcreatoreffect' => { 346 => 0x532 },
	'colordataversion' => { 45 => 0x0, 46 => 0x0, 47 => 0x0, 49 => 0x0, 50 => 0x0, 51 => 0x0, 52 => 0x0, 53 => 0x0, 54 => 0x0, 55 => 0x0 },
	'coloreffect' => { 371 => 0x28 },
	'colorfilter' => { 119 => 0x17, 120 => 0x3017, 199 => 0x29, 207 => [0x38,0x4d,0x4f], 417 => 0x17 },
	'colorgain' => { 283 => 0x51 },
	'colorgradeblending' => { 535 => 'ColorGradeBlending', 537 => 'ColorGradeBlending' },
	'colorgradeglobalhue' => { 535 => 'ColorGradeGlobalHue', 537 => 'ColorGradeGlobalHue' },
	'colorgradegloballum' => { 535 => 'ColorGradeGlobalLum', 537 => 'ColorGradeGlobalLum' },
	'colorgradeglobalsat' => { 535 => 'ColorGradeGlobalSat', 537 => 'ColorGradeGlobalSat' },
	'colorgradehighlightlum' => { 535 => 'ColorGradeHighlightLum', 537 => 'ColorGradeHighlightLum' },
	'colorgrademidtonehue' => { 535 => 'ColorGradeMidtoneHue', 537 => 'ColorGradeMidtoneHue' },
	'colorgrademidtonelum' => { 535 => 'ColorGradeMidtoneLum', 537 => 'ColorGradeMidtoneLum' },
	'colorgrademidtonesat' => { 535 => 'ColorGradeMidtoneSat', 537 => 'ColorGradeMidtoneSat' },
	'colorgradeshadowlum' => { 535 => 'ColorGradeShadowLum', 537 => 'ColorGradeShadowLum' },
	'colorhue' => { 110 => 0x20900, 257 => 0x8d },
	'colorimetricreference' => { 126 => 0xc6bf },
	'colorlabel' => { 540 => 'ColorLabel' },
	'colormatrix' => { 69 => 0xa, 350 => 0x200, 351 => 0x1011, 453 => 0xa030 },
	'colormatrix1' => { 126 => 0xc621, 419 => 0x106 },
	'colormatrix2' => { 126 => 0xc622, 354 => 0x200, 419 => 0x226 },
	'colormatrix3' => { 126 => 0xcd33 },
	'colormatrixa' => { 410 => 0x203 },
	'colormatrixa2' => { 410 => 0x21c },
	'colormatrixadobergb' => { 453 => 0xa032 },
	'colormatrixb' => { 410 => 0x204 },
	'colormatrixb2' => { 410 => 0x21d },
	'colormatrixnumber' => { 351 => 0x1019 },
	'colormatrixsrgb' => { 453 => 0xa031 },
	'colormode' => { 120 => 0x3015, 134 => 0x1210, 158 => 0x66, 199 => 0x28, 202 => 0x16, 204 => 0x101, 205 => 0x36, 207 => 0x7, 257 => 0x3, 306 => 0x4, 371 => 0x32, 456 => 0x2c, 480 => 0xb029, 553 => 'ColorMode' },
	'colormoirereduction' => { 110 => 0x20670, 318 => 0x15 },
	'colormoirereductionmode' => { 318 => 0x5 },
	'colormoirereductionon' => { 110 => '0x20670.0' },
	'colornoisereduction' => { 517 => 0x8029, 535 => 'ColorNoiseReduction', 537 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 535 => 'ColorNoiseReductionDetail', 537 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 318 => 0x18 },
	'colornoisereductionsharpness' => { 318 => 0x1c },
	'colornoisereductionsmoothness' => { 535 => 'ColorNoiseReductionSmoothness', 537 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 130 => 0x2 },
	'colorprofile' => { 199 => 0x33 },
	'colorprofilesettings' => { 346 => 0x539 },
	'colorrepresentation' => { 151 => 0x3c },
	'colorsaturationadj' => { 110 => 0x20305 },
	'colorsequence' => { 151 => 0x41 },
	'colorspace' => { 56 => 0x3, 70 => 0xb4, 104 => 0x10b4, 126 => 0xa001, 153 => 0x3, 180 => 'ColorSpace', 200 => 0x2f, 201 => 0x25, 202 => 0x17, 257 => 0x1e, 346 => 0x507, 410 => 0x37, 453 => 0xa011, 456 => 0xb, 466 => 0x1b, 467 => 0x83, 468 => 0xe, 485 => 0x6, 541 => 'ColorSpace' },
	'colorspace2' => { 69 => 0x9 },
	'colorspecapproximation' => { 153 => 0x2 },
	'colorspecdata' => { 153 => 0x3 },
	'colorspecmethod' => { 153 => 0x0 },
	'colorspecprecedence' => { 153 => 0x1 },
	'colortempasshot' => { 42 => 0x4, 43 => 0x7, 44 => 0x1d, 45 => 0x59, 46 => 0x6d, 47 => 0x6d, 48 => 0x26, 49 => 0x43, 52 => 0x43, 53 => 0x43, 54 => 0x43, 55 => 0x4b },
	'colortempauto' => { 42 => 0x9, 43 => 0xf, 44 => 0x22, 45 => 0x5e, 46 => 0x72, 48 => 0x1c, 49 => 0x48, 52 => 0x48, 53 => 0x48, 54 => 0x48, 55 => 0x50 },
	'colortempcloudy' => { 42 => 0x22, 43 => 0x37, 44 => 0x31, 45 => 0xa4, 46 => 0xdb, 47 => 0x7c, 48 => 0x35, 49 => 0x5c, 52 => 0x75, 53 => 0x8e, 54 => 0x93, 55 => 0x96, 410 => 0x55 },
	'colortempcustom' => { 49 => 0x84 },
	'colortempcustom1' => { 44 => 0x45 },
	'colortempcustom2' => { 44 => 0x4a },
	'colortempdaylight' => { 42 => 0x18, 43 => 0x27, 44 => 0x27, 45 => 0x9a, 46 => 0xd1, 47 => 0x72, 48 => 0x2b, 49 => 0x52, 52 => 0x6b, 53 => 0x84, 54 => 0x89, 55 => 0x8c, 410 => 0x53 },
	'colortemperature' => { 1 => 0x2d, 7 => 0x73, 8 => [0x48,0x4e], 9 => 0xc0, 10 => 0x37, 11 => 0x62, 12 => 0x37, 13 => 0x7c, 14 => 0x73, 15 => 0x73, 16 => 0x77, 17 => 0x73, 18 => 0x7c, 19 => 0x58, 20 => 0x73, 21 => 0xc0, 22 => 0x7f, 23 => 0x7d, 24 => 0xc0, 25 => 0xc6, 26 => 0xc7, 27 => 0x135, 28 => 0x7b, 29 => 0x13a, 70 => 0xae, 80 => 0x9, 104 => 0x10ae, 134 => 0x1005, 156 => 0x846, 174 => 'ColorTemperature', 200 => [0x6e,0x49], 201 => 0x3f, 202 => [0x39,0x5e], 204 => 0x10b, 207 => [0x3c,0x4c,0x4e], 366 => 0x321, 410 => 0x50, 446 => 0x1308, 480 => 0xb021, 535 => 'Temperature', 537 => 'Temperature' },
	'colortemperatureadj' => { 517 => 0x8013 },
	'colortemperatureauto' => { 257 => 0x4f },
	'colortemperaturebg' => { 351 => 0x1013 },
	'colortemperaturecustom' => { 466 => 0xc, 467 => 0xb },
	'colortemperaturerg' => { 351 => 0x1014 },
	'colortemperatureset' => { 466 => 0x7, 467 => 0x6 },
	'colortemperaturesetting' => { 202 => 0x25, 468 => 0x17, 485 => 0xe },
	'colortempflash' => { 42 => 0x36, 43 => 0x57, 44 => 0x40, 45 => 0xb8, 46 => 0xef, 47 => 0x8b, 48 => 0x49, 49 => 0x70, 52 => 0x89, 53 => 0xa2, 54 => 0xa7, 55 => 0xaa, 410 => 0x5a },
	'colortempflashdata' => { 49 => 0x24a },
	'colortempfluorescent' => { 42 => 0x2c, 43 => 0x47, 44 => 0x3b, 45 => 0xae, 46 => 0xe5, 47 => 0x86, 48 => 0x3f, 49 => 0x66, 52 => 0x7f, 53 => 0x98, 54 => 0x9d, 55 => 0xa0 },
	'colortempfluorescentd' => { 410 => 0x57 },
	'colortempfluorescentn' => { 410 => 0x58 },
	'colortempfluorescentw' => { 410 => 0x59 },
	'colortempkelvin' => { 42 => 0x31, 43 => 0x4f, 45 => 0xb3, 46 => 0xea, 48 => 0x44, 49 => 0x6b, 52 => 0x84, 53 => 0x9d, 54 => 0xa2, 55 => 0xa5, 371 => 0x44, 446 => 0x1307 },
	'colortempmeasured' => { 42 => 0xe, 43 => 0x17, 45 => 0x63, 46 => 0x77, 49 => 0x4d, 52 => 0x4d, 53 => 0x4d, 54 => 0x4d, 55 => 0x55 },
	'colortemppc1' => { 48 => 0x94, 49 => 0x75 },
	'colortemppc2' => { 48 => 0x99, 49 => 0x7a },
	'colortemppc3' => { 48 => 0x9e, 49 => 0x7f },
	'colortempshade' => { 42 => 0x1d, 43 => 0x2f, 44 => 0x2c, 45 => 0x9f, 46 => 0xd6, 47 => 0x77, 48 => 0x30, 49 => 0x57, 52 => 0x70, 53 => 0x89, 54 => 0x8e, 55 => 0x91, 410 => 0x54 },
	'colortemptungsten' => { 42 => 0x27, 43 => 0x3f, 44 => 0x36, 45 => 0xa9, 46 => 0xe0, 47 => 0x81, 48 => 0x3a, 49 => 0x61, 52 => 0x7a, 53 => 0x93, 54 => 0x98, 55 => 0x9b, 410 => 0x56 },
	'colortempunknown' => { 42 => 0x13, 43 => 0x1f, 45 => 0x68, 46 => 0x7c, 48 => 0x21, 52 => 0x52, 53 => 0x52, 54 => 0x52, 55 => 0x5a },
	'colortempunknown10' => { 42 => 0x63, 43 => 0x9f, 45 => 0x95, 46 => 0xa9, 47 => 0xb8, 48 => 0x76, 52 => 0xa2, 53 => 0x7f, 54 => 0x7f, 55 => 0x87 },
	'colortempunknown11' => { 42 => 0x68, 43 => 0xa7, 45 => 0xbd, 46 => [0xae,0xb3], 47 => 0xbd, 48 => 0x7b, 52 => 0xa7, 53 => 0xa7, 54 => 0x84, 55 => 0xaf },
	'colortempunknown12' => { 42 => 0x6d, 43 => 0xaf, 45 => 0xc2, 46 => 0xb8, 47 => 0xc2, 48 => 0x80, 52 => 0xac, 53 => 0xac, 54 => 0xac, 55 => 0xb4 },
	'colortempunknown13' => { 42 => 0x72, 43 => 0xb7, 45 => 0xc7, 46 => 0xbd, 47 => 0xc7, 48 => 0x85, 52 => 0xb1, 53 => 0xb1, 54 => 0xb1, 55 => 0xb9 },
	'colortempunknown14' => { 45 => 0xcc, 46 => 0xc2, 47 => 0xcc, 48 => 0x8a, 52 => 0xb6, 53 => 0xb6, 54 => 0xb6, 55 => 0xbe },
	'colortempunknown15' => { 45 => 0xd1, 46 => 0xc7, 47 => 0xd1, 48 => 0x8f, 52 => 0xbb, 53 => 0xbb, 54 => 0xbb, 55 => 0xc3 },
	'colortempunknown16' => { 45 => 0xd6, 46 => 0xcc, 47 => 0xd6, 48 => 0xa3, 53 => 0xc0, 54 => 0xc0, 55 => 0xc8 },
	'colortempunknown17' => { 45 => 0xdb, 46 => 0xf4, 47 => 0xdb, 53 => 0xc5, 54 => 0xc5, 55 => 0xcd },
	'colortempunknown18' => { 45 => 0xe0, 46 => 0xf9, 47 => 0xe0, 53 => 0xca, 54 => 0xca, 55 => 0xd2 },
	'colortempunknown19' => { 45 => 0xe5, 46 => 0xfe, 47 => 0xe5, 53 => 0xcf, 54 => 0xcf, 55 => 0xd7 },
	'colortempunknown2' => { 42 => 0x3b, 43 => 0x5f, 45 => 0x6d, 46 => 0x81, 47 => 0x90, 48 => 0x4e, 52 => 0x57, 53 => 0x57, 54 => 0x57, 55 => 0x5f },
	'colortempunknown20' => { 45 => 0xea, 46 => 0x103, 47 => 0xea, 53 => 0xd4, 54 => 0xd4, 55 => 0xdc },
	'colortempunknown21' => { 45 => 0xef, 46 => 0x108, 47 => 0xef, 54 => 0xd9, 55 => 0xe1 },
	'colortempunknown22' => { 45 => 0xf4, 46 => 0x10d, 47 => 0xf4, 54 => 0xde, 55 => 0xe6 },
	'colortempunknown23' => { 45 => 0xf9, 46 => 0x112, 47 => 0xf9, 54 => 0xe3, 55 => 0xeb },
	'colortempunknown24' => { 45 => 0xfe, 46 => 0x117, 47 => 0xfe, 54 => 0xe8, 55 => 0xf0 },
	'colortempunknown25' => { 45 => 0x103, 46 => 0x11c, 47 => 0x103, 54 => 0xed, 55 => 0xf5 },
	'colortempunknown26' => { 45 => 0x108, 46 => 0x121, 47 => 0x108, 54 => 0xf2, 55 => 0xfa },
	'colortempunknown27' => { 45 => 0x10d, 46 => 0x126, 47 => 0x10d, 54 => 0xf7, 55 => 0xff },
	'colortempunknown28' => { 45 => 0x112, 47 => 0x112, 54 => 0xfc, 55 => 0x104 },
	'colortempunknown29' => { 45 => 0x117, 47 => 0x117, 54 => 0x101, 55 => 0x109 },
	'colortempunknown3' => { 42 => 0x40, 43 => 0x67, 45 => 0x72, 46 => 0x86, 47 => 0x95, 48 => 0x53, 52 => 0x5c, 53 => 0x5c, 54 => 0x5c, 55 => 0x64 },
	'colortempunknown30' => { 47 => 0x11c, 54 => 0x106 },
	'colortempunknown31' => { 47 => 0x121 },
	'colortempunknown32' => { 47 => 0x126 },
	'colortempunknown33' => { 47 => 0x12b },
	'colortempunknown4' => { 42 => 0x45, 43 => 0x6f, 45 => 0x77, 46 => 0x8b, 47 => 0x9a, 48 => 0x58, 52 => 0x61, 53 => 0x61, 54 => 0x61, 55 => 0x69 },
	'colortempunknown5' => { 42 => 0x4a, 43 => 0x77, 45 => 0x7c, 46 => 0x90, 47 => 0x9f, 48 => 0x5d, 52 => 0x66, 53 => 0x66, 54 => 0x66, 55 => 0x6e },
	'colortempunknown6' => { 42 => 0x4f, 43 => 0x7f, 45 => 0x81, 46 => 0x95, 47 => 0xa4, 48 => 0x62, 52 => 0x8e, 53 => 0x6b, 54 => 0x6b, 55 => 0x73 },
	'colortempunknown7' => { 42 => 0x54, 43 => 0x87, 45 => 0x86, 46 => 0x9a, 47 => 0xa9, 48 => 0x67, 52 => 0x93, 53 => 0x70, 54 => 0x70, 55 => 0x78 },
	'colortempunknown8' => { 42 => 0x59, 43 => 0x8f, 45 => 0x8b, 46 => 0x9f, 47 => 0xae, 48 => 0x6c, 52 => 0x98, 53 => 0x75, 54 => 0x75, 55 => 0x7d },
	'colortempunknown9' => { 42 => 0x5e, 43 => 0x97, 45 => 0x90, 46 => 0xa4, 47 => 0xb3, 48 => 0x71, 52 => 0x9d, 53 => 0x7a, 54 => 0x7a, 55 => 0x82 },
	'colortint' => { 370 => 0x35c },
	'colortone' => { 10 => 0x6f, 12 => 0x77, 38 => 0x2a, 56 => 0x2, 69 => 0x8 },
	'colortoneadj' => { 110 => 0x20304, 115 => 0x11e },
	'colortoneauto' => { 77 => 0x9c },
	'colortonefaithful' => { 19 => 0x107, 76 => 0x6c, 77 => 0x6c },
	'colortonelandscape' => { 19 => 0x105, 76 => 0x3c, 77 => 0x3c },
	'colortonemonochrome' => { 76 => 0x84, 77 => 0x84 },
	'colortoneneutral' => { 19 => 0x106, 76 => 0x54, 77 => 0x54 },
	'colortoneportrait' => { 19 => 0x104, 76 => 0x24, 77 => 0x24 },
	'colortonestandard' => { 19 => 0x103, 76 => 0xc, 77 => 0xc },
	'colortoneuserdef1' => { 19 => 0x109, 76 => 0x9c, 77 => 0xb4 },
	'colortoneuserdef2' => { 19 => 0x10a, 76 => 0xb4, 77 => 0xcc },
	'colortoneuserdef3' => { 19 => 0x10b, 76 => 0xcc, 77 => 0xe4 },
	'columninterleavefactor' => { 126 => 0xcd43 },
	'comlenblksize' => { 156 => 0xfde8 },
	'commanddialframeadvancezoom' => { 268 => 0x804 },
	'commanddialplaybackmode' => { 341 => 0x1cb, 342 => 0x1cb, 343 => 0x1e3 },
	'commanddials' => { 335 => '5.1' },
	'commanddialsaperturesetting' => { 324 => '17.3', 325 => '18.3', 327 => '18.3', 328 => '18.3', 333 => '33.3', 334 => '17.3', 337 => '18.3', 338 => '18.3' },
	'commanddialschangemainsub' => { 324 => '17.2', 325 => '18.1', 327 => '18.1', 328 => '18.1', 333 => '33.2', 334 => '17.2', 337 => '18.1', 338 => '18.1' },
	'commanddialsmenuandplayback' => { 324 => '17.4', 325 => '18.2', 327 => '18.2', 328 => '18.2', 333 => '33.4', 334 => '17.4', 337 => '18.2', 338 => '18.2' },
	'commanddialsreverserotation' => { 324 => '17.1', 325 => '6.4', 327 => '6.2', 328 => '6.2', 329 => '16.2', 330 => '17.2', 333 => '33.1', 334 => '17.1', 337 => '6.2', 338 => '6.2', 339 => '18.1' },
	'commanddialvideoplaybackmode' => { 341 => 0x1cd, 343 => 0x1e5 },
	'commanderchannel' => { 335 => '10.2', 336 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 335 => '13.1', 336 => '31.1' },
	'commandergroupa_ttlcomp' => { 339 => '32.1' },
	'commandergroupamanualoutput' => { 335 => '13.2', 336 => '28.2' },
	'commandergroupamode' => { 335 => '11.2', 336 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 335 => '14.1', 336 => '32.1' },
	'commandergroupb_ttlcomp' => { 339 => '33.1' },
	'commandergroupbmanualoutput' => { 335 => '14.2', 336 => '29.2' },
	'commandergroupbmode' => { 335 => '11.3', 336 => '29.1' },
	'commanderinternalflash' => { 335 => '11.1', 336 => '27.1' },
	'commanderinternalmanualoutput' => { 335 => '12.2', 336 => '27.2' },
	'commanderinternalttlchannel' => { 333 => '18.2' },
	'commanderinternalttlcomp' => { 335 => '12.1', 336 => '30.2', 339 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 333 => '20.1', 334 => '26.1' },
	'commanderinternalttlcompgroupa' => { 333 => '21.1', 334 => '27.1' },
	'commanderinternalttlcompgroupb' => { 333 => '22.1', 334 => '28.1' },
	'comment' => { 0 => 0x2, 127 => 'Comment', 175 => 'Comment', 360 => 'Comment', 428 => "\xa9cmt", 430 => 'comment', 436 => "\xa9cmt" },
	'compass' => { 449 => 0x4 },
	'compatiblebrands' => { 430 => 'compatible_brands' },
	'compatibleversion' => { 535 => 'CompatibleVersion', 537 => 'CompatibleVersion' },
	'compilation' => { 428 => 'cpil' },
	'compimageimagespersequence' => { 542 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfImagesInSequences'] },
	'compimagemaxexposureall' => { 542 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfAll'] },
	'compimagemaxexposureused' => { 542 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfUsed'] },
	'compimageminexposureall' => { 542 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfAll'] },
	'compimageminexposureused' => { 542 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfUsed'] },
	'compimagenumsequences' => { 542 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfSequences'] },
	'compimagesumexposureall' => { 542 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfAll'] },
	'compimagesumexposureused' => { 542 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfUsed'] },
	'compimagetotalexposureperiod' => { 542 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesTotalExposurePeriod'] },
	'compimagevalues' => { 542 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesValues'] },
	'complianceprofile' => { 555 => 'complianceProfile' },
	'componentsconfiguration' => { 126 => 0x9101, 180 => 'Components', 541 => 'ComponentsConfiguration' },
	'componentversion' => { 104 => 0x80c },
	'composer' => { 197 => 'WM/Composer', 428 => ["\xa9com","\xa9wrt"], 436 => ["\xa9com","\xa9wrt"], 565 => 'composer' },
	'composerid' => { 428 => 'cmID' },
	'composerkeywords' => { 436 => "\xa9cok" },
	'compositeimage' => { 126 => 0xa460, 542 => 'CompositeImage' },
	'compositeimagecount' => { 126 => 0xa461, 542 => 'CompositeImageCount' },
	'compositeimagecount1' => { 134 => 0x1151 },
	'compositeimagecount2' => { 134 => 0x1152 },
	'compositeimageexposuretimes' => { 126 => 0xa462, 542 => 'CompositeImageExposureTimes' },
	'compositeimagemode' => { 134 => 0x1150 },
	'composition' => { 523 => 'Composition' },
	'compositionadjust' => { 408 => '0.1' },
	'compositionadjustrotation' => { 408 => 0x7 },
	'compositionadjustx' => { 408 => 0x5 },
	'compositionadjusty' => { 408 => 0x6 },
	'compressedbitsperpixel' => { 126 => 0x9102, 541 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 204 => 0x40, 351 => 0x40 },
	'compression' => { 126 => 0x103, 376 => 0xb, 561 => 'Compression' },
	'compressionfactor' => { 346 => 0x50d },
	'compressionformat' => { 69 => 0x4 },
	'compressionratio' => { 180 => 'Compression', 351 => 0x1034 },
	'compressorversion' => { 436 => 'CNCV' },
	'condadobvfactor' => { 156 => 0xf3e },
	'condadodaybvthresh' => { 156 => 0xf3c },
	'condadodayoffsets' => { 156 => 0xf42 },
	'condadofluoffsets' => { 156 => 0xf44 },
	'condadofluthresh' => { 156 => 0xf41 },
	'condadoillfactor' => { 156 => 0xf3f },
	'condadoneurange' => { 156 => 0xf3d },
	'condadotunoffsets' => { 156 => 0xf43 },
	'condadotunthresh' => { 156 => 0xf40 },
	'conductor' => { 197 => 'WM/Conductor', 428 => "\xa9con" },
	'confidence' => { 144 => 'Confidence' },
	'confidencelevel' => { 531 => 'ConfidenceLevel' },
	'confidencemime' => { 144 => 'ConfidenceMime' },
	'constrainedcropheight' => { 115 => 0x266, 421 => 0xd6 },
	'constrainedcropwidth' => { 115 => 0x262, 421 => 0xd5 },
	'contact' => { 149 => 0x76 },
	'contactinfo' => { 535 => 'ContactInfo', 537 => 'ContactInfo', 554 => 'contactInfo' },
	'container' => { 139 => 'Container' },
	'containerdirectory' => { 139 => [\'Container','ContainerDirectory'], 142 => 'Directory' },
	'containerdirectoryitem' => { 139 => [\'Container','ContainerDirectoryItem'] },
	'containerdirectoryitemdatauri' => { 139 => [\'Container','ContainerDirectoryItemDataURI'] },
	'containerdirectoryitemlength' => { 139 => [\'Container','ContainerDirectoryItemLength'] },
	'containerdirectoryitemmime' => { 139 => [\'Container','ContainerDirectoryItemMime'] },
	'containerdirectoryitempadding' => { 139 => [\'Container','ContainerDirectoryItemPadding'] },
	'containerformat' => { 549 => 'ContainerFormat' },
	'containerformatidentifier' => { 549 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 549 => [\'ContainerFormat','ContainerFormatName'] },
	'contentcreatedate' => { 428 => "\xa9day", 436 => ['@day',"\xa9day"] },
	'contentdistributor' => { 197 => 'WM/ContentDistributor' },
	'contentdistributorid' => { 436 => 'cdis' },
	'contentid' => { 436 => 'ccid' },
	'contentidentifier' => { 1 => 0x11, 430 => 'content.identifier' },
	'contentlocationcode' => { 149 => 0x1a },
	'contentlocationname' => { 149 => 0x1b },
	'contenttype' => { 555 => 'contentType' },
	'continuousbracketing' => { 202 => 0x20 },
	'continuousdrive' => { 38 => 0x5 },
	'continuousmodedisplay' => { 340 => 0x55, 341 => 0x51, 342 => 0x51, 343 => 0x51 },
	'continuousmodeliveview' => { 338 => '77.2' },
	'continuousshootingspeed' => { 91 => 0x610 },
	'continuousshotlimit' => { 91 => 0x611 },
	'contrast' => { 10 => 0x73, 12 => 0x75, 38 => 0xd, 119 => 0xc, 120 => [0x3012,0x20], 126 => [0xa408,0xfe54], 134 => [0x1004,0x1006], 174 => 'Contrast', 194 => 'Contrast', 199 => 0x20, 200 => 0x31, 201 => 0x27, 202 => 0x19, 207 => 0x2, 275 => 0x33, 276 => 0x37, 277 => 0x3f, 351 => 0x1029, 371 => 0x39, 373 => 0x300a, 410 => 0x20, 417 => 0xc, 430 => 'player.movie.visual.contrast', 438 => 0x24, 439 => 0x52, 440 => 0x3c, 441 => 0x62, 446 => 0x1012, 456 => 0xd, 466 => 0x1d, 467 => 0x1a, 480 => 0x2004, 535 => 'Contrast', 537 => 'Contrast', 541 => 'Contrast' },
	'contrast2012' => { 535 => 'Contrast2012', 537 => 'Contrast2012' },
	'contrastadj' => { 110 => 0x20303, 115 => 0x115, 320 => 0x2c, 517 => 0x8017 },
	'contrastauto' => { 77 => 0x90 },
	'contrastcurve' => { 257 => 0x8c },
	'contrastdetectafarea' => { 410 => 0x231 },
	'contrastdetectafinfocus' => { 211 => 0x1c, 212 => [0x1c,0x52] },
	'contrastfaithful' => { 19 => 0xec, 76 => 0x60, 77 => 0x60 },
	'contrasthighlight' => { 410 => 0x6d },
	'contrasthighlightshadowadj' => { 410 => 0x6f },
	'contrastlandscape' => { 19 => 0xea, 76 => 0x30, 77 => 0x30 },
	'contrastmode' => { 371 => 0x2c },
	'contrastmonochrome' => { 19 => 0xed, 76 => 0x78, 77 => 0x78 },
	'contrastneutral' => { 19 => 0xeb, 76 => 0x48, 77 => 0x48 },
	'contrastportrait' => { 19 => 0xe9, 76 => 0x18, 77 => 0x18 },
	'contrastsetting' => { 346 => 0x505, 354 => 0x1012, 468 => 0x10, 485 => 0x8 },
	'contrastshadow' => { 410 => 0x6e },
	'contraststandard' => { 19 => 0xe8, 76 => 0x0, 77 => 0x0 },
	'contrastuserdef1' => { 19 => 0xee, 76 => 0x90, 77 => 0xa8 },
	'contrastuserdef2' => { 19 => 0xef, 76 => 0xa8, 77 => 0xc0 },
	'contrastuserdef3' => { 19 => 0xf0, 76 => 0xc0, 77 => 0xd8 },
	'contributedmedia' => { 565 => 'contributedMedia' },
	'contributedmediaduration' => { 565 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 565 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 565 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 565 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 565 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 565 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 565 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 565 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 565 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 565 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 538 => 'contributor', 549 => 'Contributor' },
	'contributoridentifier' => { 549 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 549 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 549 => [\'Contributor','ContributorRole'] },
	'contributors' => { 175 => 'Contributors' },
	'controldialset' => { 202 => 0x46 },
	'controlledvocabularyterm' => { 549 => 'CVterm' },
	'controllerboardversion' => { 366 => 0x332 },
	'controlmode' => { 83 => 0x12 },
	'controlringresponse' => { 340 => 0x1cf, 341 => 0x1d5, 342 => 0x1d5, 343 => 0x1ed },
	'controlringrotation' => { 91 => 0x712 },
	'conversionlens' => { 347 => 0x403, 371 => 0x35 },
	'converter' => { 126 => 0xfe4d, 306 => 0xb, 535 => 'Converter', 537 => 'Converter' },
	'converttograyscale' => { 535 => 'ConvertToGrayscale', 537 => 'ConvertToGrayscale' },
	'cookingequipment' => { 557 => 'cookingEquipment' },
	'cookingmethod' => { 557 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 126 => 0x8298, 175 => 'Copyright', 360 => 'Copyright', 376 => 0x8298, 410 => 0x22f, 426 => 'Copyright', 428 => ['cprt',"\xa9cpy"], 430 => 'copyright', 436 => ['cprt',"\xa9cpy"], 535 => 'Copyright', 537 => 'Copyright', 551 => 'Copyright', 558 => 'copyright', 561 => 'Copyright', 565 => 'copyright' },
	'copyrightflag' => { 424 => 0x40a },
	'copyrightnotice' => { 149 => 0x74 },
	'copyrightowner' => { 357 => 'CopyrightOwner' },
	'copyrightownerid' => { 357 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 357 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 357 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 357 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 357 => 'CopyrightStatus' },
	'copyrightyear' => { 549 => 'CopyrightYear', 555 => 'copyrightYear' },
	'coringfilter' => { 350 => 0x310, 351 => 0x102d, 354 => 0x310 },
	'coringvalues' => { 350 => 0x311, 354 => 0x311 },
	'corporateentity' => { 555 => 'corporateEntity' },
	'correctionalreadyapplied' => { 361 => 'CorrectionAlreadyApplied' },
	'correlatedcolortemp' => { 370 => 0x35b },
	'country' => { 179 => 'Country', 371 => 0x69, 553 => 'Country' },
	'country-primarylocationcode' => { 149 => 0x64 },
	'country-primarylocationname' => { 149 => 0x65 },
	'countrycode' => { 256 => 0x5, 422 => 'CountryCode', 548 => 'CountryCode' },
	'course' => { 557 => 'course' },
	'coverage' => { 538 => 'coverage' },
	'coverart' => { 428 => 'covr' },
	'coverdate' => { 555 => 'coverDate' },
	'coverdisplaydate' => { 555 => 'coverDisplayDate' },
	'coveruri' => { 436 => 'cvru' },
	'cpufirmwareversion' => { 410 => 0x28 },
	'crc32' => { 539 => 'crc32' },
	'createdate' => { 126 => 0x9004, 175 => 'CreateDate', 356 => 'CreationDate', 360 => 'create-date', 426 => 'CreationDate', 433 => 0x1, 563 => 'CreateDate' },
	'creationdate' => { 430 => 'creationdate', 551 => 'CreationDate', 555 => 'creationDate' },
	'creationtime' => { 360 => 'Creation Time', 430 => 'creation_time' },
	'creativestyle' => { 466 => 0x1a, 467 => 0x18, 477 => 0x41, 480 => 0xb020, 512 => 0x4a },
	'creativestylesetting' => { 468 => 0xf, 485 => 0x7 },
	'creativestylewaschanged' => { 517 => 0x8001 },
	'creator' => { 356 => 'Creator', 426 => 'Creator', 538 => 'creator', 549 => 'Creator', 551 => 'Creator' },
	'creatoraddress' => { 548 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 196 => 'CreatorAppId' },
	'creatorcity' => { 548 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 548 => 'CreatorContactInfo' },
	'creatorcountry' => { 548 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 549 => [\'Creator','CreatorIdentifier'] },
	'creatoridentity' => { 422 => 'CreatorIdentity' },
	'creatorname' => { 549 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 196 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 548 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 548 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 549 => [\'Creator','CreatorRole'] },
	'creatortool' => { 563 => 'CreatorTool' },
	'creatorworkemail' => { 548 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 548 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 548 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 149 => 0x6e, 553 => 'Credit' },
	'creditline' => { 558 => 'creditLine' },
	'creditlinereq' => { 568 => 'CreditLineReq' },
	'creditlinerequired' => { 357 => 'CreditLineRequired' },
	'cropactive' => { 108 => 0x0, 115 => 0x244 },
	'cropangle' => { 108 => 0x8, 535 => 'CropAngle', 537 => 'CropAngle' },
	'croparea' => { 257 => 0x45, 517 => 0x9011 },
	'cropaspectratio' => { 110 => 0x30101, 115 => 0x260 },
	'cropaspectratiocustom' => { 110 => 0x30102 },
	'cropbottom' => { 130 => 0x9, 312 => 0x36, 376 => 0x31, 421 => 0xdc, 535 => 'CropBottom', 537 => 'CropBottom' },
	'cropbottommargin' => { 58 => 0x3 },
	'cropcircleactive' => { 116 => 0xd6 },
	'cropcircleradius' => { 116 => 0xd9 },
	'cropcirclex' => { 116 => 0xd7 },
	'cropcircley' => { 116 => 0xd8 },
	'cropconstraintowarp' => { 535 => 'CropConstrainToWarp', 537 => 'CropConstrainToWarp' },
	'cropflag' => { 134 => 0x1051 },
	'croph' => { 528 => 'CropH' },
	'cropheight' => { 108 => 0x6, 115 => 0x24c, 350 => 0x615, 354 => 0x615, 535 => 'CropHeight', 537 => 'CropHeight' },
	'crophispeed' => { 257 => 0x1b },
	'cropleft' => { 115 => 0x246, 130 => 0x6, 312 => 0x1e, 350 => 0x612, 354 => 0x612, 376 => 0x30, 421 => 0xd9, 535 => 'CropLeft', 537 => 'CropLeft' },
	'cropleftmargin' => { 58 => 0x0 },
	'cropmode' => { 134 => 0x104d, 446 => 0x1018 },
	'croporiginalheight' => { 108 => 0xb },
	'croporiginalwidth' => { 108 => 0xa },
	'cropoutputheight' => { 312 => 0xce },
	'cropoutputheightinches' => { 312 => 0x96 },
	'cropoutputpixels' => { 312 => 0xd6 },
	'cropoutputresolution' => { 312 => 0xb6 },
	'cropoutputscale' => { 312 => 0xbe },
	'cropoutputwidth' => { 312 => 0xc6 },
	'cropoutputwidthinches' => { 312 => 0x8e },
	'croppedareaimageheightpixels' => { 147 => 'CroppedAreaImageHeightPixels', 148 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 147 => 'CroppedAreaImageWidthPixels', 148 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 147 => 'CroppedAreaLeftPixels', 148 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 147 => 'CroppedAreaTopPixels', 148 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 446 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 446 => 0x1603 },
	'cropping' => { 517 => 0x9010 },
	'cropright' => { 130 => 0x8, 312 => 0x2e, 376 => 0x32, 421 => 0xdb, 535 => 'CropRight', 537 => 'CropRight' },
	'croprightmargin' => { 58 => 0x1 },
	'croprotatedoriginalheight' => { 108 => 0x2 },
	'croprotatedoriginalwidth' => { 108 => 0x1 },
	'croprotation' => { 108 => 0x7, 130 => 0xb },
	'cropscaledresolution' => { 312 => 0x9e },
	'cropsize' => { 134 => 0x1053 },
	'cropsourceresolution' => { 312 => 0xae },
	'croptop' => { 115 => 0x248, 130 => 0x7, 312 => 0x26, 350 => 0x613, 354 => 0x613, 376 => 0x2f, 421 => 0xda, 535 => 'CropTop', 537 => 'CropTop' },
	'croptopleft' => { 134 => 0x1052 },
	'croptopmargin' => { 58 => 0x2 },
	'cropunit' => { 535 => 'CropUnit', 537 => 'CropUnit' },
	'cropunits' => { 535 => 'CropUnits', 537 => 'CropUnits' },
	'cropw' => { 528 => 'CropW' },
	'cropwidth' => { 108 => 0x5, 115 => 0x24a, 350 => 0x614, 354 => 0x614, 535 => 'CropWidth', 537 => 'CropWidth' },
	'cropx' => { 108 => 0x3, 528 => 'CropX' },
	'cropy' => { 108 => 0x4, 528 => 'CropY' },
	'crossprocess' => { 410 => 0x7b },
	'crossprocessparams' => { 410 => 0x235 },
	'cuisine' => { 557 => 'cuisine' },
	'currenticcprofile' => { 126 => 0xc691 },
	'currentpreprofilematrix' => { 126 => 0xc692 },
	'currentversion' => { 517 => 0xd000 },
	'curve0x' => { 528 => 'Curve0x' },
	'curve0y' => { 528 => 'Curve0y' },
	'curve1x' => { 528 => 'Curve1x' },
	'curve1y' => { 528 => 'Curve1y' },
	'curve2x' => { 528 => 'Curve2x' },
	'curve2y' => { 528 => 'Curve2y' },
	'curve3x' => { 528 => 'Curve3x' },
	'curve3y' => { 528 => 'Curve3y' },
	'curve4x' => { 528 => 'Curve4x' },
	'curve4y' => { 528 => 'Curve4y' },
	'curves' => { 317 => 0x76a43201 },
	'custom1' => { 357 => 'Custom1' },
	'custom10' => { 357 => 'Custom10' },
	'custom2' => { 357 => 'Custom2' },
	'custom3' => { 357 => 'Custom3' },
	'custom4' => { 357 => 'Custom4' },
	'custom5' => { 357 => 'Custom5' },
	'custom6' => { 357 => 'Custom6' },
	'custom7' => { 357 => 'Custom7' },
	'custom8' => { 357 => 'Custom8' },
	'custom9' => { 357 => 'Custom9' },
	'customcolortone' => { 116 => 0x4c },
	'customcontrast' => { 116 => 0x4e },
	'customcontrols' => { 91 => 0x70c },
	'customdefaultunsharpfineness' => { 116 => 0xbe },
	'customdefaultunsharpstrength' => { 116 => 0xbc },
	'customdefaultunsharpthreshold' => { 116 => 0xc0 },
	'customilluminant' => { 156 => 0x405 },
	'customizedials' => { 91 => 0x715 },
	'customlinear' => { 116 => 0x4f },
	'customoutputhighlightpoint' => { 116 => 0x53 },
	'customoutputshadowpoint' => { 116 => 0x54 },
	'custompicturestyle' => { 110 => 0x10021 },
	'custompicturestyledata' => { 110 => 0xf0500 },
	'custompicturestylefilename' => { 70 => 0x4010 },
	'customrawhighlight' => { 116 => 0x7c },
	'customrawhighlightpoint' => { 116 => 0x51 },
	'customrawshadow' => { 116 => 0x85 },
	'customrawshadowpoint' => { 116 => 0x52 },
	'customrendered' => { 126 => 0xa401, 209 => 0x6420, 541 => 'CustomRendered' },
	'customsaturation' => { 116 => 0x4d, 346 => 0x503 },
	'customsettingsalldefault' => { 324 => '0.2', 333 => '0.2' },
	'customsettingsbank' => { 324 => '0.1', 325 => '0.1', 327 => '0.1', 328 => '0.1', 333 => '0.1', 337 => '0.2', 338 => '0.2', 341 => 0x1, 342 => 0x1, 343 => 0x1 },
	'customsharpness' => { 116 => 0x50 },
	'customunsharpmaskfineness' => { 116 => 0xb8 },
	'customunsharpmaskstrength' => { 116 => 0xb6 },
	'customunsharpmaskthreshold' => { 116 => 0xba },
	'customwb_rblevels' => { 485 => 0x1a },
	'customwb_rgblevels' => { 467 => 0x8, 468 => 0x19 },
	'customwbbluelevel' => { 202 => 0x36 },
	'customwberror' => { 202 => 0x37 },
	'customwbgreenlevel' => { 202 => 0x35 },
	'customwbredlevel' => { 202 => 0x34 },
	'customwbsetting' => { 202 => 0x26 },
	'cx' => { 436 => '_cx_' },
	'cy' => { 436 => '_cy_' },
	'd-lightinghq' => { 317 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 313 => 0x2 },
	'd-lightinghqhighlight' => { 313 => 0x1 },
	'd-lightinghqselected' => { 317 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 313 => 0x0 },
	'd-lightinghs' => { 317 => 0xce5554aa },
	'd-lightinghsadjustment' => { 314 => 0x0 },
	'd-lightinghscolorboost' => { 314 => 0x1 },
	'd-rangeoptimizerhighlight' => { 517 => 0x8024 },
	'd-rangeoptimizermode' => { 517 => 0x8022 },
	'd-rangeoptimizershadow' => { 517 => 0x802d },
	'd-rangeoptimizervalue' => { 517 => 0x8023 },
	'darkblacksegrows' => { 156 => 0x18d8 },
	'darkfocusenvironment' => { 371 => 0x8003 },
	'darkframecountfactor' => { 156 => 0xc85 },
	'darkframelongexposure' => { 156 => 0xc84 },
	'darkframeshortexposure' => { 156 => 0xc83 },
	'darkpedestal' => { 156 => 0xc7f },
	'datacompressionmethod' => { 151 => 0x6e },
	'dataimprint' => { 199 => 0x34 },
	'datamining' => { 357 => 'DataMining' },
	'dataonscreen' => { 549 => 'DataOnScreen' },
	'dataonscreenregion' => { 549 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 549 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 549 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 549 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 549 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 549 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 549 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 549 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 410 => 0x3d },
	'date' => { 410 => 0x6, 538 => 'date' },
	'dateacquired' => { 196 => 'DateAcquired', 197 => '{2CBAA8F5-D81F-47CA-B17A-F8D822300131} 100' },
	'datecreated' => { 149 => 0x37, 553 => 'DateCreated' },
	'datedisplayformat' => { 309 => 0x3 },
	'dateidentified' => { 125 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 329 => '4.2' },
	'daterecieved' => { 555 => 'dateRecieved' },
	'datesent' => { 150 => 0x46 },
	'datestampmode' => { 70 => 0x1c, 257 => 0x9d },
	'datetime' => { 529 => 'datetime', 561 => 'DateTime' },
	'datetimedigitized' => { 541 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 107 => 0x0, 126 => 0x9003, 172 => 0x14, 175 => 'OriginalDate', 431 => 'IDIT', 436 => 'date', 438 => 0xb, 439 => 0x3e, 440 => 0x2f, 441 => 0x4e, 442 => 0x3b, 541 => 'DateTimeOriginal' },
	'datetimestamp' => { 158 => 0x64 },
	'datetimeutc' => { 346 => 0x908 },
	'daylightsavings' => { 84 => 0x3, 309 => 0x2 },
	'dayofweek' => { 439 => 0x4a, 440 => 0x36, 441 => 0x5a, 442 => 0x42 },
	'dccontinent' => { 125 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 125 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 125 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 125 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 125 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 125 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 125 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 125 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 125 => 'Event' },
	'dcfootprintspatialfit' => { 125 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 125 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 125 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 125 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 125 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 125 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 125 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 125 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 125 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 125 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 125 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 125 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 125 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 125 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 125 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 125 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 125 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 125 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 125 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 125 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 125 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 125 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 125 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 125 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 125 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 125 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 125 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 125 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 125 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 125 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 125 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 125 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 125 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 125 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 125 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 125 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcverticaldatum' => { 125 => [\'dctermsLocation','dctermsLocationVerticalDatum'] },
	'dcwaterbody' => { 125 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 183 => 'Declination' },
	'decposition' => { 199 => 0x32 },
	'defaultautogray' => { 535 => 'DefaultAutoGray', 537 => 'DefaultAutoGray' },
	'defaultautotone' => { 535 => 'DefaultAutoTone', 537 => 'DefaultAutoTone' },
	'defaultblackrender' => { 126 => 0xc7a6 },
	'defaultcroporigin' => { 126 => 0xc61f },
	'defaultcropsize' => { 126 => 0xc620 },
	'defaulteraseoption' => { 91 => 0x813 },
	'defaultscale' => { 126 => 0xc61e },
	'defaultsspecifictoiso' => { 535 => 'DefaultsSpecificToISO', 537 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 535 => 'DefaultsSpecificToSerial', 537 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 126 => 0xc7b5 },
	'defectisocode' => { 156 => 0x90f },
	'defringe' => { 535 => 'Defringe', 537 => 'Defringe' },
	'defringegreenamount' => { 535 => 'DefringeGreenAmount', 537 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 535 => 'DefringeGreenHueHi', 537 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 535 => 'DefringeGreenHueLo', 537 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 535 => 'DefringePurpleAmount', 537 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 535 => 'DefringePurpleHueHi', 537 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 535 => 'DefringePurpleHueLo', 537 => 'DefringePurpleHueLo' },
	'dehaze' => { 535 => 'Dehaze', 537 => 'Dehaze' },
	'deletedimagecount' => { 257 => 0xa6, 288 => 0x6e },
	'deprecatedon' => { 533 => 'deprecatedOn' },
	'depthbasedcorrcorrectionactive' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionActive'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionActive'] },
	'depthbasedcorrcorrectionamount' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionAmount'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionAmount'] },
	'depthbasedcorrcorrectionsyncid' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionSyncID'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionSyncID'] },
	'depthbasedcorrections' => { 535 => 'DepthBasedCorrections', 537 => 'DepthBasedCorrections' },
	'depthbasedcorrlocalcorrecteddepth' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCorrectedDepth'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCorrectedDepth'] },
	'depthbasedcorrlocalcurverefinesaturation' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCurveRefineSaturation'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCurveRefineSaturation'] },
	'depthbasedcorrmask' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasks'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasks'] },
	'depthbasedcorrmaskalpha' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAlpha'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAlpha'] },
	'depthbasedcorrmaskangle' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAngle'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAngle'] },
	'depthbasedcorrmaskbottom' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksBottom'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksBottom'] },
	'depthbasedcorrmaskcentervalue' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterValue'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterValue'] },
	'depthbasedcorrmaskcenterweight' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterWeight'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterWeight'] },
	'depthbasedcorrmaskdabs' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksDabs'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksDabs'] },
	'depthbasedcorrmaskfeather' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFeather'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFeather'] },
	'depthbasedcorrmaskflipped' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlipped'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlipped'] },
	'depthbasedcorrmaskflow' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlow'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlow'] },
	'depthbasedcorrmaskfullx' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullX'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullX'] },
	'depthbasedcorrmaskfully' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullY'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullY'] },
	'depthbasedcorrmaskinputdigest' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksInputDigest'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksInputDigest'] },
	'depthbasedcorrmaskleft' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksLeft'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksLeft'] },
	'depthbasedcorrmaskmaskactive' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskActive'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskActive'] },
	'depthbasedcorrmaskmaskblendmode' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskBlendMode'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'depthbasedcorrmaskmaskdigest' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskDigest'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskDigest'] },
	'depthbasedcorrmaskmaskinverted' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskInverted'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskInverted'] },
	'depthbasedcorrmaskmaskname' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskName'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskName'] },
	'depthbasedcorrmaskmasks' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasks'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasks'] },
	'depthbasedcorrmaskmasksalpha' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAlpha'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'depthbasedcorrmaskmasksangle' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAngle'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAngle'] },
	'depthbasedcorrmaskmasksbottom' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksBottom'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksBottom'] },
	'depthbasedcorrmaskmaskscentervalue' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterValue'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'depthbasedcorrmaskmaskscenterweight' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterWeight'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'depthbasedcorrmaskmasksdabs' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksDabs'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksDabs'] },
	'depthbasedcorrmaskmasksfeather' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFeather'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFeather'] },
	'depthbasedcorrmaskmasksflipped' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlipped'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'depthbasedcorrmaskmasksflow' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlow'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlow'] },
	'depthbasedcorrmaskmasksfullx' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullX'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullX'] },
	'depthbasedcorrmaskmasksfully' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullY'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullY'] },
	'depthbasedcorrmaskmasksinputdigest' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksInputDigest'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'depthbasedcorrmaskmasksleft' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksLeft'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksLeft'] },
	'depthbasedcorrmaskmasksmaskactive' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskActive'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'depthbasedcorrmaskmasksmaskblendmode' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'depthbasedcorrmaskmasksmaskdigest' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskDigest'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'depthbasedcorrmaskmasksmaskinverted' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskInverted'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'depthbasedcorrmaskmasksmaskname' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskName'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'depthbasedcorrmaskmasksmasksubtype' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSubType'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'depthbasedcorrmaskmasksmasksyncid' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'depthbasedcorrmaskmasksmaskversion' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskVersion'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'depthbasedcorrmaskmasksmidpoint' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMidpoint'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'depthbasedcorrmaskmasksorigin' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksOrigin'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'depthbasedcorrmaskmasksperimetervalue' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'depthbasedcorrmaskmasksradius' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRadius'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRadius'] },
	'depthbasedcorrmaskmasksreferencepoint' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksReferencePoint'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'depthbasedcorrmaskmasksright' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRight'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRight'] },
	'depthbasedcorrmaskmasksroundness' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRoundness'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'depthbasedcorrmaskmaskssizex' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeX'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'depthbasedcorrmaskmaskssizey' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeY'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'depthbasedcorrmaskmaskstop' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksTop'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksTop'] },
	'depthbasedcorrmaskmasksubtype' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSubType'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSubType'] },
	'depthbasedcorrmaskmasksvalue' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskValue'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'depthbasedcorrmaskmasksversion' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksVersion'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksVersion'] },
	'depthbasedcorrmaskmaskswhat' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWhat'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWhat'] },
	'depthbasedcorrmaskmaskswholeimagearea' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'depthbasedcorrmaskmasksx' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksX'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksX'] },
	'depthbasedcorrmaskmasksy' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksY'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksY'] },
	'depthbasedcorrmaskmasksyncid' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSyncID'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'depthbasedcorrmaskmaskszerox' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroX'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'depthbasedcorrmaskmaskszeroy' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroY'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'depthbasedcorrmaskmaskversion' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskVersion'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskVersion'] },
	'depthbasedcorrmaskmidpoint' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMidpoint'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMidpoint'] },
	'depthbasedcorrmaskorigin' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksOrigin'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksOrigin'] },
	'depthbasedcorrmaskperimetervalue' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksPerimeterValue'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'depthbasedcorrmaskradius' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRadius'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRadius'] },
	'depthbasedcorrmaskrange' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'depthbasedcorrmaskrangeareamodels' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'depthbasedcorrmaskrangeareamodelscolorsampleinfo' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'depthbasedcorrmaskrangeareamodelscomponents' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'depthbasedcorrmaskrangecoloramount' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'depthbasedcorrmaskrangedepthfeather' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'depthbasedcorrmaskrangedepthmax' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'depthbasedcorrmaskrangedepthmin' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'depthbasedcorrmaskrangeinvert' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'depthbasedcorrmaskrangelumfeather' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'depthbasedcorrmaskrangeluminancedepthsampleinfo' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'depthbasedcorrmaskrangelummax' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'depthbasedcorrmaskrangelummin' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'depthbasedcorrmaskrangelumrange' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'depthbasedcorrmaskrangesampletype' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'depthbasedcorrmaskrangetype' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'depthbasedcorrmaskrangeversion' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'depthbasedcorrmaskreferencepoint' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksReferencePoint'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksReferencePoint'] },
	'depthbasedcorrmaskright' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRight'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRight'] },
	'depthbasedcorrmaskroundness' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRoundness'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRoundness'] },
	'depthbasedcorrmasksizex' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeX'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeX'] },
	'depthbasedcorrmasksizey' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeY'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeY'] },
	'depthbasedcorrmasktop' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksTop'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksTop'] },
	'depthbasedcorrmaskvalue' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskValue'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskValue'] },
	'depthbasedcorrmaskversion' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksVersion'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksVersion'] },
	'depthbasedcorrmaskwhat' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWhat'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWhat'] },
	'depthbasedcorrmaskwholeimagearea' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWholeImageArea'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'depthbasedcorrmaskx' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksX'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksX'] },
	'depthbasedcorrmasky' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksY'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksY'] },
	'depthbasedcorrmaskzerox' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroX'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroX'] },
	'depthbasedcorrmaskzeroy' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroY'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroY'] },
	'depthbasedcorrwhat' => { 535 => [\'DepthBasedCorrections','DepthBasedCorrectionsWhat'], 537 => [\'DepthBasedCorrections','DepthBasedCorrectionsWhat'] },
	'depthfar' => { 126 => 0xc7eb },
	'depthformat' => { 126 => 0xc7e9 },
	'depthimage' => { 144 => 'Data' },
	'depthmapinfo' => { 535 => 'DepthMapInfo', 537 => 'DepthMapInfo' },
	'depthmapinfobasehighlightguideinputdigest' => { 535 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideInputDigest'], 537 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideInputDigest'] },
	'depthmapinfobasehighlightguidetable' => { 535 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideTable'], 537 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideTable'] },
	'depthmapinfobasehighlightguideversion' => { 535 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideVersion'], 537 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideVersion'] },
	'depthmapinfobaselayereddepthinputdigest' => { 535 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthInputDigest'], 537 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthInputDigest'] },
	'depthmapinfobaselayereddepthtable' => { 535 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthTable'], 537 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthTable'] },
	'depthmapinfobaselayereddepthversion' => { 535 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthVersion'], 537 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthVersion'] },
	'depthmapinfobaserawdepthinputdigest' => { 535 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthInputDigest'], 537 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthInputDigest'] },
	'depthmapinfobaserawdepthtable' => { 535 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthTable'], 537 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthTable'] },
	'depthmapinfobaserawdepthversion' => { 535 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthVersion'], 537 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthVersion'] },
	'depthmapinfodepthsource' => { 535 => [\'DepthMapInfo','DepthMapInfoDepthSource'], 537 => [\'DepthMapInfo','DepthMapInfoDepthSource'] },
	'depthmeasuretype' => { 126 => 0xc7ed },
	'depthnear' => { 126 => 0xc7ea },
	'depthunits' => { 126 => 0xc7ec },
	'derivedfrom' => { 566 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 566 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 566 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 566 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 566 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 566 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 566 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 566 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 566 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 566 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 566 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 566 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 566 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 566 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 566 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 566 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 566 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 566 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 566 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 566 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 566 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 566 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 566 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 566 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 197 => 'Description', 360 => 'Description', 428 => ['desc','dscp',"\xa9des"], 430 => 'description', 436 => 'dscp', 535 => 'Description', 537 => 'Description', 538 => 'description', 563 => 'Description' },
	'destination' => { 150 => 0x5 },
	'destinationcity' => { 410 => 0x24, 416 => 0x3 },
	'destinationcitycode' => { 417 => 0x1001 },
	'destinationdst' => { 410 => 0x26, 416 => '0.3' },
	'developmentdynamicrange' => { 134 => 0x1403 },
	'deviantmatrixcustom' => { 156 => 0x7de },
	'deviantmatrixdaylight' => { 156 => 0x7da },
	'deviantmatrixflash' => { 156 => 0x7dd },
	'deviantmatrixfluorescent' => { 156 => 0x7dc },
	'deviantmatrixtungsten' => { 156 => 0x7db },
	'deviantwhitecustom' => { 156 => 0x842 },
	'deviantwhitedaylight' => { 156 => 0x83e },
	'deviantwhiteflash' => { 156 => 0x841 },
	'deviantwhitefluorescent' => { 156 => 0x840 },
	'deviantwhitetungsten' => { 156 => 0x83f },
	'device' => { 555 => 'device' },
	'devicesettingdescription' => { 541 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 541 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 541 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 541 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 453 => 0x2 },
	'dewarpdata' => { 123 => 'DewarpData' },
	'dewarpflag' => { 123 => 'DewarpFlag' },
	'dialdirectiontvav' => { 91 => 0x706 },
	'dietaryneeds' => { 557 => 'dietaryNeeds' },
	'diffractioncompensation' => { 246 => 0x20e, 261 => 0x2ce, 262 => 0x142, 263 => 0x1b2, 266 => 0x1a2, 267 => 0x1b6, 268 => 0x1b6 },
	'diffractioncorrection' => { 371 => 0xbc, 399 => 0x3 },
	'diffractioncorrectionon' => { 110 => 0x2070b },
	'digitalcreationdate' => { 149 => 0x3e },
	'digitalcreationtime' => { 149 => 0x3f },
	'digitaldeehighlightadj' => { 283 => 0x202 },
	'digitaldeeshadowadj' => { 283 => 0x200 },
	'digitaldeethreshold' => { 283 => 0x201 },
	'digitalfilter' => { 456 => 0x59 },
	'digitalfilter01' => { 396 => 0x5 },
	'digitalfilter02' => { 396 => 0x16 },
	'digitalfilter03' => { 396 => 0x27 },
	'digitalfilter04' => { 396 => 0x38 },
	'digitalfilter05' => { 396 => 0x49 },
	'digitalfilter06' => { 396 => 0x5a },
	'digitalfilter07' => { 396 => 0x6b },
	'digitalfilter08' => { 396 => 0x7c },
	'digitalfilter09' => { 396 => 0x8d },
	'digitalfilter10' => { 396 => 0x9e },
	'digitalfilter11' => { 396 => 0xaf },
	'digitalfilter12' => { 396 => 0xc0 },
	'digitalfilter13' => { 396 => 0xd1 },
	'digitalfilter14' => { 396 => 0xe2 },
	'digitalfilter15' => { 396 => 0xf3 },
	'digitalfilter16' => { 396 => 0x104 },
	'digitalfilter17' => { 396 => 0x115 },
	'digitalfilter18' => { 396 => 0x126 },
	'digitalfilter19' => { 396 => 0x137 },
	'digitalfilter20' => { 396 => 0x148 },
	'digitalgain' => { 80 => 0xb },
	'digitalgem' => { 241 => 0x0 },
	'digitalice' => { 283 => 0x100 },
	'digitalimageguid' => { 549 => 'DigImageGUID' },
	'digitallensoptimizer' => { 68 => 0xa },
	'digitallensoptimizersetting' => { 86 => 0x9 },
	'digitalroc' => { 280 => 0x0 },
	'digitalsourcefiletype' => { 549 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 549 => 'DigitalSourceType' },
	'digitalzoom' => { 38 => 0xc, 119 => 0xa, 134 => 0x1044, 158 => 0x68, 169 => 0x22, 170 => 0x1e, 174 => 'DigitalZoom', 199 => 0xc, 257 => 0x86, 306 => 0xa, 351 => 0x204, 410 => 0x1e, 417 => 0xa, 455 => 0x204, 503 => 0x12, 504 => 0x12 },
	'digitalzoomon' => { 455 => 0x21b },
	'digitalzoomratio' => { 126 => 0xa404, 491 => 0x200, 493 => 0x21c, 541 => 'DigitalZoomRatio' },
	'director' => { 197 => 'WM/Director', 428 => "\xa9dir", 430 => 'director', 436 => "\xa9dir", 565 => 'director' },
	'directorphotography' => { 565 => 'directorPhotography' },
	'directory' => { 127 => 'Directory' },
	'directorycreatedate' => { 439 => 0x14, 441 => 0x14 },
	'directoryindex' => { 7 => 0x137, 9 => 0x2dc, 11 => 0x17e, 13 => 0x238, 14 => 0x13f, 15 => 0x133, 16 => 0x1df, 17 => 0x1a7, 18 => 0x1f0, 19 => 0xcc, 20 => 0x1c7, 21 => 0x298, 22 => 0x1e7, 23 => 0x1e5, 24 => [0x27c,0x280], 25 => 0x2b6, 26 => 0x2bf, 28 => 0x1f7, 29 => 0x4ba, 30 => 0xb21 },
	'directoryindex2' => { 21 => 0x29c },
	'directoryitem' => { 142 => [\'Directory','DirectoryItem'] },
	'directoryitemlabel' => { 142 => [\'Directory','DirectoryItemLabel'] },
	'directoryitemlength' => { 142 => [\'Directory','DirectoryItemLength'] },
	'directoryitemmime' => { 142 => [\'Directory','DirectoryItemMime'] },
	'directoryitempadding' => { 142 => [\'Directory','DirectoryItemPadding'] },
	'directoryitemsemantic' => { 142 => [\'Directory','DirectoryItemSemantic'] },
	'directoryitemuri' => { 142 => [\'Directory','DirectoryItemURI'] },
	'directorynumber' => { 234 => 0x3, 439 => 0x12, 440 => 0x93, 441 => 0x12 },
	'disableautocreation' => { 141 => 'DisableAutoCreation' },
	'disablesuggestedaction' => { 141 => 'DisableSuggestedAction' },
	'disclaimer' => { 360 => 'Disclaimer' },
	'discnumber' => { 565 => 'discNumber' },
	'dishtype' => { 557 => 'dishType' },
	'disknumber' => { 428 => 'disk' },
	'dispbutton' => { 268 => 0x7d4, 341 => 0x2ab },
	'displayallafpoints' => { 91 => 0x514 },
	'displayaperture' => { 38 => 0x23 },
	'displayedunitsx' => { 425 => 0x2 },
	'displayedunitsy' => { 425 => 0x6 },
	'displayname' => { 430 => 'displayname', 554 => 'displayName' },
	'distance1' => { 158 => 0x28 },
	'distance2' => { 158 => 0x2c },
	'distance3' => { 158 => 0x30 },
	'distance4' => { 158 => 0x34 },
	'distortion' => { 453 => 0xa050 },
	'distortioncompensation' => { 517 => 0x8040 },
	'distortioncontrol' => { 288 => 0x10 },
	'distortioncorrection' => { 85 => 0x3, 110 => 0x20705, 116 => 0x67, 126 => 0x7036, 232 => 0x4, 346 => 0x50b, 375 => '7.1', 399 => 0x0, 511 => 0x601, 512 => 0x5b },
	'distortioncorrection2' => { 350 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 532 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 110 => '0x20705.0', 116 => 0x63 },
	'distortioncorrectionsetting' => { 86 => 0x7, 480 => 0x2013 },
	'distortioncorrectionvalue' => { 85 => 0x9 },
	'distortioncorrectionversion' => { 232 => 0x0 },
	'distortioncorrparams' => { 126 => 0x7037, 490 => 0x1a23, 493 => 0x1870, 495 => 0x189c, 496 => 0x18cc, 497 => 0x17d0, 511 => 0x6ca, 512 => 0x64 },
	'distortioncorrparamsnumber' => { 493 => 0x1899, 495 => 0x18c5, 496 => 0x18f5, 497 => 0x17f9 },
	'distortioncorrparamspresent' => { 493 => 0x1898, 495 => 0x18c4, 496 => 0x18f4, 497 => 0x17f8, 499 => 0x10b, 500 => 0x10b, 511 => 0x600, 512 => 0x5a },
	'distortioneffect' => { 110 => 0x20709 },
	'distortionn' => { 375 => 0xc },
	'distortionparam02' => { 375 => 0x2 },
	'distortionparam04' => { 375 => 0x4 },
	'distortionparam08' => { 375 => 0x8 },
	'distortionparam09' => { 375 => 0x9 },
	'distortionparam11' => { 375 => 0xb },
	'distortionscale' => { 375 => 0x5 },
	'distributor' => { 555 => 'distributor' },
	'distributorproductid' => { 554 => 'distributorProductID' },
	'dloon' => { 110 => '0x20706.0', 116 => 0xdc },
	'dlosetting' => { 110 => 0x20706, 116 => 0xdd },
	'dlosettingapplied' => { 109 => 0x4 },
	'dloshootingdistance' => { 116 => 0xde },
	'dloversion' => { 109 => 0x5 },
	'dmcomment' => { 565 => 'comment' },
	'dmdithermatrix' => { 156 => 0xc7a },
	'dmdithermatrixheight' => { 156 => 0xc7c },
	'dmdithermatrixwidth' => { 156 => 0xc7b },
	'dngadobedata' => { 126 => 0xc634 },
	'dngbackwardversion' => { 126 => 0xc613 },
	'dngignoresidecars' => { 535 => 'DNGIgnoreSidecars', 537 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 126 => 0xc630 },
	'dngprivatedata' => { 126 => 0xc634 },
	'dngversion' => { 126 => 0xc612 },
	'document' => { 360 => 'Document' },
	'documentancestors' => { 553 => 'DocumentAncestors' },
	'documenthistory' => { 149 => 0xe7 },
	'documentid' => { 566 => 'DocumentID' },
	'documentname' => { 126 => 0x10d },
	'documentnotes' => { 149 => 0xe6 },
	'doi' => { 555 => 'doi' },
	'dopesheet' => { 549 => 'Dopesheet' },
	'dopesheetlink' => { 549 => 'DopesheetLink' },
	'dopesheetlinklink' => { 549 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 549 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 156 => 0xc82 },
	'dpp' => { 529 => 'dpp' },
	'dprawbokehshift' => { 110 => 0x20b20 },
	'dprawbokehshiftarea' => { 110 => 0x20b21 },
	'dprawghostingreductionarea' => { 110 => 0x20b30 },
	'dprawmicroadjustbackfront' => { 110 => 0x20b10 },
	'dprawmicroadjuststrength' => { 110 => 0x20b12 },
	'dr4cameramodel' => { 111 => 0x3 },
	'drangepriority' => { 134 => 0x1443 },
	'drangepriorityauto' => { 134 => 0x1444 },
	'drangepriorityfixed' => { 134 => 0x1445 },
	'drivemode' => { 120 => 0x3103, 132 => '0.1', 199 => 0x6, 202 => 0x1e, 205 => 0xe, 209 => 0x64d0, 346 => 0x600, 410 => 0x34, 446 => 0x1002, 456 => 0x3, 466 => 0x4, 467 => 0x7e, 468 => 0x34 },
	'drivemode2' => { 202 => 0xa, 389 => 0x7, 477 => 0xe, 485 => 0x1 },
	'drivemodesetting' => { 468 => 0x4 },
	'drivespeed' => { 132 => '0.2' },
	'dspfirmwareversion' => { 410 => 0x27 },
	'dualpixelraw' => { 68 => 0xb },
	'duration' => { 73 => 0x6a, 173 => 'Duration', 187 => 'Duration', 557 => 'duration', 565 => 'duration' },
	'durationscale' => { 565 => [\'duration','durationScale'] },
	'durationvalue' => { 565 => [\'duration','durationValue'] },
	'dustremovaldata' => { 70 => 0x97 },
	'dxcropalert' => { 263 => 0x250, 266 => 0x23c, 267 => 0x250, 268 => 0x250 },
	'dynamicafarea' => { 324 => '1.4', 333 => '1.4' },
	'dynamicafareasize' => { 261 => 0x370, 263 => 0x254, 266 => 0x240, 267 => 0x254, 268 => 0x254 },
	'dynamicareaafassist' => { 340 => 0x18, 341 => 0x18, 342 => 0x18, 343 => 0x18 },
	'dynamicareaafdisplay' => { 325 => '46.1', 327 => '47.1', 328 => '47.1', 337 => '47.1', 338 => '47.1' },
	'dynamicrange' => { 134 => 0x1400 },
	'dynamicrangeboost' => { 371 => 0xee },
	'dynamicrangeexpansion' => { 410 => 0x69, 446 => 0x100e },
	'dynamicrangemax' => { 115 => 0x7c },
	'dynamicrangemin' => { 115 => 0x7a },
	'dynamicrangeoptimizer' => { 202 => 0x15, 480 => [0xb025,0xb04f], 489 => 0x1144, 490 => [0x1144,0x324], 491 => [0x1120,0x300], 492 => [0x119c,0x37c], 493 => [0x1178,0x328], 494 => [0x1030,0x50], 495 => [0x228,0x50], 496 => [0x228,0x50], 497 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 477 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 466 => 0x19, 467 => 0x17, 468 => 0xd, 477 => 0x79, 485 => 0x5 },
	'dynamicrangeoptimizermode' => { 205 => 0x15, 466 => 0x18, 467 => 0x16, 477 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 202 => 0x27, 468 => 0xc, 485 => 0x4 },
	'dynamicrangesetting' => { 134 => 0x1402 },
	'e-dialinprogram' => { 389 => '1.3' },
	'earliestageorloweststage' => { 125 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 125 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 125 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 125 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 125 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'earthpos' => { 139 => 'EarthPos' },
	'earthposaltitude' => { 139 => [\'EarthPos','EarthPosAltitude'] },
	'earthposlatitude' => { 139 => [\'EarthPos','EarthPosLatitude'] },
	'earthposlongitude' => { 139 => [\'EarthPos','EarthPosLongitude'] },
	'earthposrotationw' => { 139 => [\'EarthPos','EarthPosRotationW'] },
	'earthposrotationx' => { 139 => [\'EarthPos','EarthPosRotationX'] },
	'earthposrotationy' => { 139 => [\'EarthPos','EarthPosRotationY'] },
	'earthposrotationz' => { 139 => [\'EarthPos','EarthPosRotationZ'] },
	'earthpostimestamp' => { 139 => [\'EarthPos','EarthPosTimestamp'] },
	'easyexposurecomp' => { 339 => '6.1' },
	'easyexposurecompensation' => { 324 => '6.4', 325 => '6.5', 327 => '6.3', 328 => '6.3', 332 => '5.1', 333 => '4.4', 334 => '5.2', 337 => '6.3', 338 => '6.3', 340 => 0x1f, 341 => 0x1d, 342 => 0x1d, 343 => 0x1d },
	'easymode' => { 38 => 0xb },
	'edgemapslope' => { 156 => 0x930 },
	'edgemapx1' => { 156 => 0x931 },
	'edgemapx2' => { 156 => 0x932 },
	'edgemapx3' => { 156 => 0x934 },
	'edgemapx4' => { 156 => 0x935 },
	'edgenoisereduction' => { 318 => 0x4, 517 => 0x8028 },
	'edit1' => { 436 => "\xa9ed1" },
	'edit2' => { 436 => "\xa9ed2" },
	'edit3' => { 436 => "\xa9ed3" },
	'edit4' => { 436 => "\xa9ed4" },
	'edit5' => { 436 => "\xa9ed5" },
	'edit6' => { 436 => "\xa9ed6" },
	'edit7' => { 436 => "\xa9ed7" },
	'edit8' => { 436 => "\xa9ed8" },
	'edit9' => { 436 => "\xa9ed9" },
	'edition' => { 555 => 'edition' },
	'editorialupdate' => { 149 => 0x8 },
	'editstatus' => { 149 => 0x7, 422 => 'EditStatus', 529 => 'EditStatus' },
	'editversionname' => { 317 => 0x3d136244 },
	'effectivelv' => { 410 => 0x2d },
	'effectivemaxaperture' => { 250 => 0x12, 251 => 0x13, 255 => 0x14 },
	'eissn' => { 555 => 'eIssn' },
	'electricalblackcolumns' => { 156 => 0x1810 },
	'electronicfront-curtainshutter' => { 327 => '5.2', 328 => '5.2', 337 => '5.3', 338 => '5.2' },
	'electronicfrontcurtainshutter' => { 480 => 0x201a },
	'elevation' => { 183 => 'Elevation' },
	'email' => { 175 => 'EMail' },
	'embargodate' => { 558 => 'embargoDate' },
	'embdencrightsexpr' => { 549 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 549 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 549 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 549 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 553 => 'EmbeddedXMPDigest' },
	'emissivity' => { 128 => 0x3 },
	'emptyslotrelease' => { 261 => 0x98c, 264 => 0x723, 265 => 0x783, 266 => 0x625, 267 => 0x655, 268 => 0x6bd },
	'enablechromanoisereduction' => { 156 => 0xe6e },
	'enablesharpening' => { 156 => 0x92e },
	'encodedby' => { 197 => 'WM/EncodedBy', 428 => "\xa9enc" },
	'encodedwith' => { 430 => 'Encoded_With' },
	'encoder' => { 428 => "\xa9too", 430 => 'encoder', 436 => "\xa9too" },
	'encoderid' => { 436 => "\xa9enc" },
	'encodingtime' => { 197 => 'WM/EncodingTime' },
	'encryptionkey' => { 453 => 0xa020 },
	'endingpage' => { 555 => 'endingPage' },
	'enduser' => { 357 => 'EndUser' },
	'enduserid' => { 357 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 357 => [\'EndUser','EndUserEndUserName'] },
	'energysavingmode' => { 261 => 0x992, 264 => 0x746, 265 => 0x7a6, 266 => 0x648, 267 => 0x678, 268 => 0x6e0 },
	'engineer' => { 565 => 'engineer' },
	'enhancedarktones' => { 310 => 0x8 },
	'enhancedenoisealreadyapplied' => { 532 => 'EnhanceDenoiseAlreadyApplied' },
	'enhancedenoiselumaamount' => { 532 => 'EnhanceDenoiseLumaAmount' },
	'enhancedenoiseversion' => { 532 => 'EnhanceDenoiseVersion' },
	'enhancedetailsalreadyapplied' => { 532 => 'EnhanceDetailsAlreadyApplied' },
	'enhancedetailsversion' => { 532 => 'EnhanceDetailsVersion' },
	'enhancement' => { 119 => 0x16, 120 => 0x3016 },
	'enhanceparams' => { 126 => 0xc7ee },
	'enhancer' => { 350 => 0x300 },
	'enhancervalues' => { 350 => 0x301 },
	'enhancesuperresolutionalreadyapplied' => { 532 => 'EnhanceSuperResolutionAlreadyApplied' },
	'enhancesuperresolutionscale' => { 532 => 'EnhanceSuperResolutionScale' },
	'enhancesuperresolutionversion' => { 532 => 'EnhanceSuperResolutionVersion' },
	'envelopenumber' => { 150 => 0x28 },
	'envelopepriority' => { 150 => 0x3c },
	'enveloperecordversion' => { 150 => 0x0 },
	'episode' => { 549 => 'Episode' },
	'episodeglobaluniqueid' => { 428 => 'egid' },
	'episodeidentifier' => { 549 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 549 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 549 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 351 => 0x20c },
	'epsonimagewidth' => { 351 => 0x20b },
	'epsonsoftware' => { 351 => 0x20d },
	'equipmentinstitution' => { 520 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 520 => 'EquipmentManufacturer' },
	'equipmentversion' => { 347 => 0x0 },
	'ettlii' => { 91 => 0x304, 92 => 0xd, 93 => 0xe, 94 => 0x7, 95 => 0x7, 96 => 0xe },
	'event' => { 522 => 'Event', 527 => 'Event', 549 => 'Event', 555 => 'event' },
	'eventalias' => { 554 => 'eventAlias' },
	'eventdate' => { 125 => [\'Event','EventEventDate'] },
	'eventday' => { 125 => [\'Event','EventDay'] },
	'eventearliestdate' => { 125 => [\'Event','EventEarliestDate'] },
	'eventend' => { 554 => 'eventEnd' },
	'eventenddayofyear' => { 125 => [\'Event','EventEndDayOfYear'] },
	'eventeventtype' => { 125 => [\'Event','EventEventType'] },
	'eventfieldnotes' => { 125 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 125 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 125 => [\'Event','EventHabitat'] },
	'eventid' => { 125 => [\'Event','EventEventID'], 549 => 'EventId' },
	'eventlatestdate' => { 125 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 125 => [\'Event','EventMonth'] },
	'eventnumber' => { 438 => 0x9, 439 => 0x3a, 440 => 0x2b, 441 => 0x4a, 442 => 0x37 },
	'eventparenteventid' => { 125 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 125 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 125 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 125 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 125 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 125 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 554 => 'eventStart' },
	'eventstartdayofyear' => { 125 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 554 => 'eventSubtype' },
	'eventtime' => { 125 => [\'Event','EventEventTime'] },
	'eventtype' => { 554 => 'eventType' },
	'eventverbatimeventdate' => { 125 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 125 => [\'Event','EventYear'] },
	'evfgrid' => { 340 => 0x15f, 341 => 0x165, 342 => 0x165, 343 => 0x17d },
	'evfimageframe' => { 340 => 0x15e, 341 => 0x164, 342 => 0x164, 343 => 0x17c },
	'evfreleaseindicator' => { 341 => 0x24f, 342 => 0x24f, 343 => 0x267 },
	'evfwarmdisplaybrightness' => { 341 => 0x24d, 342 => 0x24d, 343 => 0x265 },
	'evfwarmdisplaymode' => { 341 => 0x24b, 342 => 0x24b, 343 => 0x263 },
	'evsteps' => { 389 => '1.2', 391 => 0x0 },
	'evstepsize' => { 329 => '5.1', 330 => '6.1', 331 => '6.1', 335 => '0.7' },
	'exclusivecoverage' => { 523 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 558 => 'exclusivityEndDate' },
	'excursiontolerance' => { 151 => 0x82 },
	'executiveproducer' => { 428 => "\xa9xpd" },
	'exif' => { 127 => 'EXIF' },
	'exifbyteorder' => { 127 => 'ExifByteOrder' },
	'exifcamerainfo' => { 149 => 0xe8 },
	'exifimageheight' => { 126 => 0xa003, 541 => 'PixelYDimension' },
	'exifimagewidth' => { 126 => 0xa002, 541 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 127 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 126 => 0x9000, 541 => 'ExifVersion' },
	'exitpupilposition' => { 250 => 0x4, 251 => 0x4, 255 => 0x4 },
	'expirationdate' => { 149 => 0x25, 558 => 'expirationDate' },
	'expirationtime' => { 149 => 0x26 },
	'exposure' => { 126 => 0xfe51, 535 => 'Exposure', 537 => 'Exposure' },
	'exposure2012' => { 535 => 'Exposure2012', 537 => 'Exposure2012' },
	'exposureadj' => { 315 => 0x0 },
	'exposureadj2' => { 315 => 0x12 },
	'exposureadjust' => { 456 => 0xc },
	'exposurebracketingindicatorlast' => { 202 => 0x52 },
	'exposurebracketshotnumber' => { 205 => 0x2d, 477 => 0x2f },
	'exposurebracketstepsize' => { 389 => 0x8 },
	'exposurebracketvalue' => { 257 => 0x19 },
	'exposurecompautocancel' => { 91 => 0x113 },
	'exposurecompensation' => { 83 => 0x6, 100 => 0x0, 126 => 0x9204, 158 => 0x24, 174 => 'ExposureComp', 194 => 'ExposureCompensation', 199 => 0xd, 200 => 0x53, 201 => 0x1e, 205 => 0x49c0, 351 => 0x1006, 410 => 0x16, 419 => 0x402, 453 => 0xa013, 456 => [0xc,0x35,0x47,0x4d], 489 => 0x114c, 490 => 0x114c, 491 => 0x1128, 493 => 0x1180, 494 => 0x1038, 495 => 0x230, 496 => 0x230, 497 => 0x223, 541 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 485 => [0x24,0x26,0x2a] },
	'exposurecompensationbutton' => { 268 => 0x794 },
	'exposurecompensationmode' => { 202 => 0x47, 205 => 0x2a },
	'exposurecompensationset' => { 466 => 0x3, 467 => 0x3, 468 => 0x3, 485 => 0x1e },
	'exposurecompensationsetting' => { 202 => 0x1 },
	'exposurecompstepsize' => { 324 => '6.3', 325 => '7.3', 327 => '7.3', 328 => '7.3', 333 => '4.3', 337 => '7.3', 338 => '7.3' },
	'exposurecontrolstep' => { 332 => '6.1', 334 => '6.1' },
	'exposurecontrolstepsize' => { 324 => '6.2', 325 => '7.1', 327 => '7.1', 328 => '7.1', 333 => '4.2', 337 => '7.1', 338 => '7.1', 339 => '7.1', 340 => 0x1d, 341 => 0x1b, 342 => 0x1b, 343 => 0x1b },
	'exposurecount' => { 134 => 0x1032 },
	'exposuredelay' => { 268 => 0x800, 341 => 0x2f1 },
	'exposuredelaymode' => { 324 => '10.1', 325 => '11.1', 327 => '11.1', 328 => '11.1', 329 => '9.1', 330 => '10.1', 331 => '10.1', 333 => '10.4', 334 => '10.1', 335 => '6.4', 337 => '11.1', 338 => '11.1', 339 => '11.2' },
	'exposuredifference' => { 257 => 0xe },
	'exposuregaincustom' => { 156 => 0x89c },
	'exposuregaindaylight' => { 156 => 0x898 },
	'exposuregainflash' => { 156 => 0x89b },
	'exposuregainfluorescent' => { 156 => 0x89a },
	'exposuregaintungsten' => { 156 => 0x899 },
	'exposureindex' => { 126 => 0xa215, 541 => 'ExposureIndex' },
	'exposureindicator' => { 202 => 0x50 },
	'exposurelevelincrements' => { 89 => 0x6, 90 => 0x6, 91 => 0x101, 92 => 0x5, 93 => 0x6, 94 => 0x5, 95 => 0x5, 96 => 0x6, 97 => 0x4, 466 => 0x58, 467 => 0x58 },
	'exposurelockused' => { 147 => 'ExposureLockUsed' },
	'exposuremode' => { 126 => 0xa402, 174 => 'ExposureMode', 199 => 0x1, 200 => 0xa, 201 => 0x0, 202 => 0x0, 205 => 0x34, 346 => 0x200, 368 => 0x40d, 456 => 0x8, 480 => 0xb041, 541 => 'ExposureMode' },
	'exposuremodeinmanual' => { 91 => 0x10b },
	'exposureprogram' => { 126 => 0x8822, 446 => 0x1001, 459 => [0x17e,0x43], 466 => 0x3c, 467 => 0x3c, 468 => 0x5, 472 => 0x14, 477 => 0x3f, 485 => 0x2, 489 => 0x1175, 490 => 0x1179, 491 => 0x1155, 492 => 0x11d1, 493 => 0x11ad, 494 => 0x1065, 495 => 0x25d, 496 => 0x25d, 497 => 0x24c, 508 => 0xb, 509 => 0xc, 510 => 0xb, 512 => 0x48, 541 => 'ExposureProgram' },
	'exposureshift' => { 346 => 0x203 },
	'exposurestandardadjustment' => { 480 => 0x202d },
	'exposuretime' => { 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x4, 31 => 0x6, 32 => 0x7, 83 => 0x16, 126 => 0x829a, 155 => 0xfd05, 158 => 0x20, 160 => 0xfa24, 162 => 0xf104, 165 => 0x12, 167 => 0x38, 169 => 0x14, 170 => 0x10, 172 => 0x10, 174 => 'ExposureTime', 199 => 0x9, 200 => 0x35, 201 => 0x48, 202 => 0x8, 205 => 0x49b8, 410 => 0x12, 453 => 0xa018, 456 => [0x32,0x4a], 466 => 0x0, 467 => 0x0, 485 => [0x21,0x23,0x27], 512 => 0x10, 541 => 'ExposureTime' },
	'exposuretime2' => { 456 => [0x33,0x4b] },
	'exposuretuning' => { 257 => 0x1c },
	'exposurevalue' => { 156 => 0x3 },
	'exposurewarning' => { 134 => 0x1302 },
	'exrauto' => { 134 => 0x1033 },
	'exrmode' => { 134 => 0x1034 },
	'extdescraccessibility' => { 548 => 'ExtDescrAccessibility' },
	'extendedmenubanks' => { 263 => 0x120, 266 => 0x114, 267 => 0x124, 268 => 0x124 },
	'extendedshutterspeeds' => { 340 => 0xf2, 341 => 0x102, 342 => 0x102, 343 => 0x118 },
	'extendedwbdetect' => { 346 => 0x902 },
	'extender' => { 347 => 0x301 },
	'extenderfirmwareversion' => { 347 => 0x304 },
	'extendermagnification' => { 176 => 'Magnification' },
	'extendermake' => { 176 => 'Make' },
	'extendermodel' => { 176 => 'Model', 347 => 0x303 },
	'extenderserialnumber' => { 176 => 'SerialNumber', 347 => 0x302 },
	'extenderstatus' => { 407 => 0x3 },
	'externalflash' => { 349 => 0x1201 },
	'externalflashae1' => { 351 => 0x101f },
	'externalflashae1_0' => { 351 => 0x101b },
	'externalflashae2' => { 351 => 0x1020 },
	'externalflashae2_0' => { 351 => 0x101c },
	'externalflashbounce' => { 349 => 0x1204, 351 => 0x1026, 397 => 0x1a },
	'externalflashcompensation' => { 237 => 0x1b },
	'externalflashexposurecomp' => { 257 => 0x17, 397 => 0x19 },
	'externalflashfirmware' => { 235 => 0x6, 236 => 0x6, 237 => 0x6, 238 => 0x6, 239 => 0x6, 240 => 0x6 },
	'externalflashflags' => { 235 => 0x8, 236 => 0x8, 237 => 0x8, 238 => 0x8, 240 => 0x8 },
	'externalflashguidenumber' => { 349 => 0x1203, 397 => '24.1' },
	'externalflashgvalue' => { 351 => 0x1025 },
	'externalflashmode' => { 351 => 0x1028, 397 => 0x2 },
	'externalflashreadystate' => { 239 => '9.1' },
	'externalflashstatus' => { 239 => '8.2' },
	'externalflashzoom' => { 349 => 0x1205, 351 => 0x1027 },
	'externalflashzoomoverride' => { 239 => '8.1' },
	'externalmetadatalink' => { 549 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 366 => 0x311, 369 => 0x311, 370 => 0x311, 373 => 0x3408 },
	'extrainfoversion' => { 470 => 0x1a },
	'eyedetection' => { 2 => 0x18 },
	'eyestartaf' => { 202 => 0x40 },
	'fac100per' => { 156 => 0xe94 },
	'fac170per' => { 156 => 0xe93 },
	'fac18per' => { 156 => 0xe92 },
	'face10aarea' => { 393 => 0xbe },
	'face10aeye1' => { 393 => 0xc2 },
	'face10aeye2' => { 393 => 0xc6 },
	'face10barea' => { 393 => 0x186 },
	'face10beye1' => { 393 => 0x18a },
	'face10beye2' => { 393 => 0x18e },
	'face10position' => { 117 => 0x3f4, 118 => 0x1ec, 233 => 0x28, 394 => 0x12 },
	'face10size' => { 395 => 0x12 },
	'face11position' => { 233 => 0x2c, 394 => 0x14 },
	'face11size' => { 395 => 0x14 },
	'face12position' => { 233 => 0x30, 394 => 0x16 },
	'face12size' => { 395 => 0x16 },
	'face13position' => { 394 => 0x18 },
	'face13size' => { 395 => 0x18 },
	'face14position' => { 394 => 0x1a },
	'face14size' => { 395 => 0x1a },
	'face15position' => { 394 => 0x1c },
	'face15size' => { 395 => 0x1c },
	'face16position' => { 394 => 0x1e },
	'face16size' => { 395 => 0x1e },
	'face17position' => { 394 => 0x20 },
	'face17size' => { 395 => 0x20 },
	'face18position' => { 394 => 0x22 },
	'face18size' => { 395 => 0x22 },
	'face19position' => { 394 => 0x24 },
	'face19size' => { 395 => 0x24 },
	'face1aarea' => { 393 => 0xa },
	'face1aeye1' => { 393 => 0xe },
	'face1aeye2' => { 393 => 0x12 },
	'face1barea' => { 393 => 0xd2 },
	'face1beye1' => { 393 => 0xd6 },
	'face1beye2' => { 393 => 0xda },
	'face1position' => { 59 => 0x8, 117 => 0xd, 118 => 0x18, 233 => 0x4, 363 => 0x1, 394 => 0x0, 443 => 0xbc, 473 => 0x1, 474 => 0x0, 475 => 0x0, 476 => 0x5b },
	'face1size' => { 395 => 0x0 },
	'face20position' => { 394 => 0x26 },
	'face20size' => { 395 => 0x26 },
	'face21position' => { 394 => 0x28 },
	'face21size' => { 395 => 0x28 },
	'face22position' => { 394 => 0x2a },
	'face22size' => { 395 => 0x2a },
	'face23position' => { 394 => 0x2c },
	'face23size' => { 395 => 0x2c },
	'face24position' => { 394 => 0x2e },
	'face24size' => { 395 => 0x2e },
	'face25position' => { 394 => 0x30 },
	'face25size' => { 395 => 0x30 },
	'face26position' => { 394 => 0x32 },
	'face26size' => { 395 => 0x32 },
	'face27position' => { 394 => 0x34 },
	'face27size' => { 395 => 0x34 },
	'face28position' => { 394 => 0x36 },
	'face28size' => { 395 => 0x36 },
	'face29position' => { 394 => 0x38 },
	'face29size' => { 395 => 0x38 },
	'face2aarea' => { 393 => 0x1e },
	'face2aeye1' => { 393 => 0x22 },
	'face2aeye2' => { 393 => 0x26 },
	'face2barea' => { 393 => 0xe6 },
	'face2beye1' => { 393 => 0xea },
	'face2beye2' => { 393 => 0xee },
	'face2position' => { 59 => 0xa, 117 => 0x7c, 118 => 0x4c, 233 => 0x8, 363 => 0x5, 394 => 0x2, 443 => 0xc8, 473 => 0x6, 474 => 0x20, 475 => 0x25, 476 => 0x65 },
	'face2size' => { 395 => 0x2 },
	'face30position' => { 394 => 0x3a },
	'face30size' => { 395 => 0x3a },
	'face31position' => { 394 => 0x3c },
	'face31size' => { 395 => 0x3c },
	'face32position' => { 394 => 0x3e },
	'face32size' => { 395 => 0x3e },
	'face3aarea' => { 393 => 0x32 },
	'face3aeye1' => { 393 => 0x36 },
	'face3aeye2' => { 393 => 0x3a },
	'face3barea' => { 393 => 0xfa },
	'face3beye1' => { 393 => 0xfe },
	'face3beye2' => { 393 => 0x102 },
	'face3position' => { 59 => 0xc, 117 => 0xeb, 118 => 0x80, 233 => 0xc, 363 => 0x9, 394 => 0x4, 443 => 0xd4, 473 => 0xb, 474 => 0x40, 475 => 0x4a, 476 => 0x6f },
	'face3size' => { 395 => 0x4 },
	'face4aarea' => { 393 => 0x46 },
	'face4aeye1' => { 393 => 0x4a },
	'face4aeye2' => { 393 => 0x4e },
	'face4barea' => { 393 => 0x10e },
	'face4beye1' => { 393 => 0x112 },
	'face4beye2' => { 393 => 0x116 },
	'face4position' => { 59 => 0xe, 117 => 0x15a, 118 => 0xb4, 233 => 0x10, 363 => 0xd, 394 => 0x6, 443 => 0xe0, 473 => 0x10, 474 => 0x60, 475 => 0x6f, 476 => 0x79 },
	'face4size' => { 395 => 0x6 },
	'face5aarea' => { 393 => 0x5a },
	'face5aeye1' => { 393 => 0x5e },
	'face5aeye2' => { 393 => 0x62 },
	'face5barea' => { 393 => 0x122 },
	'face5beye1' => { 393 => 0x126 },
	'face5beye2' => { 393 => 0x12a },
	'face5position' => { 59 => 0x10, 117 => 0x1c9, 118 => 0xe8, 233 => 0x14, 363 => 0x11, 394 => 0x8, 443 => 0xec, 473 => 0x15, 474 => 0x80, 475 => 0x94 },
	'face5size' => { 395 => 0x8 },
	'face6aarea' => { 393 => 0x6e },
	'face6aeye1' => { 393 => 0x72 },
	'face6aeye2' => { 393 => 0x76 },
	'face6barea' => { 393 => 0x136 },
	'face6beye1' => { 393 => 0x13a },
	'face6beye2' => { 393 => 0x13e },
	'face6position' => { 59 => 0x12, 117 => 0x238, 118 => 0x11c, 233 => 0x18, 394 => 0xa, 443 => 0xf8, 473 => 0x1a, 474 => 0xa0, 475 => 0xb9 },
	'face6size' => { 395 => 0xa },
	'face7aarea' => { 393 => 0x82 },
	'face7aeye1' => { 393 => 0x86 },
	'face7aeye2' => { 393 => 0x8a },
	'face7barea' => { 393 => 0x14a },
	'face7beye1' => { 393 => 0x14e },
	'face7beye2' => { 393 => 0x152 },
	'face7position' => { 59 => 0x14, 117 => 0x2a7, 118 => 0x150, 233 => 0x1c, 394 => 0xc, 443 => 0x104, 473 => 0x1f, 474 => 0xc0, 475 => 0xde },
	'face7size' => { 395 => 0xc },
	'face8aarea' => { 393 => 0x96 },
	'face8aeye1' => { 393 => 0x9a },
	'face8aeye2' => { 393 => 0x9e },
	'face8barea' => { 393 => 0x15e },
	'face8beye1' => { 393 => 0x162 },
	'face8beye2' => { 393 => 0x166 },
	'face8position' => { 59 => 0x16, 117 => 0x316, 118 => 0x184, 233 => 0x20, 394 => 0xe, 443 => 0x110, 473 => 0x24, 474 => 0xe0, 475 => 0x103 },
	'face8size' => { 395 => 0xe },
	'face9aarea' => { 393 => 0xaa },
	'face9aeye1' => { 393 => 0xae },
	'face9aeye2' => { 393 => 0xb2 },
	'face9barea' => { 393 => 0x172 },
	'face9beye1' => { 393 => 0x176 },
	'face9beye2' => { 393 => 0x17a },
	'face9position' => { 59 => 0x18, 117 => 0x385, 118 => 0x1b8, 233 => 0x24, 394 => 0x10 },
	'face9size' => { 395 => 0x10 },
	'facebalanceorigi' => { 528 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 528 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 528 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 528 => 'FaceBalanceWarmth' },
	'facedetect' => { 410 => 0x76, 453 => 0x100 },
	'facedetectarea' => { 350 => 0x1201 },
	'facedetectframecrop' => { 350 => 0x1207 },
	'facedetectframesize' => { 59 => 0x3, 117 => 0x1, 118 => 0x4, 233 => 0x1, 350 => 0x1203, 410 => 0x77, 443 => 0xb6 },
	'facedetection' => { 468 => 0x30, 485 => 0x19 },
	'faceelementpositions' => { 134 => 0x4203 },
	'faceelementselected' => { 134 => 0x4005 },
	'faceelementtypes' => { 134 => 0x4201 },
	'faceid' => { 531 => 'FaceID' },
	'faceimagesize' => { 393 => 0x0 },
	'faceinfok3iii' => { 393 => '0.1' },
	'faceinfounknown' => { 120 => 0x2089 },
	'facename' => { 453 => 0x123 },
	'faceorientation' => { 118 => 0x8 },
	'faceposition' => { 392 => 0x2, 454 => 0x4 },
	'facepositions' => { 134 => 0x4103 },
	'facerecognition' => { 453 => 0x120 },
	'facesdetected' => { 59 => 0x2, 60 => 0x2, 61 => 0x3, 117 => 0x0, 118 => 0x2, 120 => 0x211c, 134 => 0x4100, 233 => 0x3, 350 => 0x1200, 371 => 0x3f, 392 => 0x0, 443 => 0xb5, 454 => 0x0, 473 => 0x0, 476 => 0x3, 488 => 0x30 },
	'facesdetecteda' => { 393 => 0x6 },
	'facesdetectedb' => { 393 => 0x8 },
	'facesrecognized' => { 364 => 0x0 },
	'facewidth' => { 60 => 0x1 },
	'fade' => { 456 => 0x138, 480 => 0x2034 },
	'faithfuloutputhighlightpoint' => { 116 => 0x38 },
	'faithfuloutputshadowpoint' => { 116 => 0x39 },
	'faithfulrawcolortone' => { 116 => 0x31 },
	'faithfulrawcontrast' => { 116 => 0x33 },
	'faithfulrawhighlight' => { 116 => 0x79 },
	'faithfulrawhighlightpoint' => { 116 => 0x36 },
	'faithfulrawlinear' => { 116 => 0x34 },
	'faithfulrawsaturation' => { 116 => 0x32 },
	'faithfulrawshadow' => { 116 => 0x82 },
	'faithfulrawshadowpoint' => { 116 => 0x37 },
	'faithfulrawsharpness' => { 116 => 0x35 },
	'faithfulunsharpmaskfineness' => { 116 => 0xac },
	'faithfulunsharpmaskstrength' => { 116 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 116 => 0xae },
	'far' => { 144 => 'Far' },
	'fastresetlinetime' => { 156 => 0x1860 },
	'feedidentifier' => { 549 => 'FeedIdentifier' },
	'femicroadjustment' => { 91 => 0x111 },
	'ffid' => { 539 => 'ffid' },
	'field' => { 554 => 'field' },
	'fieldcount' => { 351 => 0x103f },
	'fieldofview' => { 436 => "FOV\x00" },
	'fifoenonepixeldelay' => { 156 => 0x1901 },
	'filecreatedate' => { 127 => 'FileCreateDate' },
	'filedatarate' => { 565 => 'fileDataRate' },
	'fileformat' => { 102 => 0x0, 150 => 0x14, 456 => [0x22,0x26], 480 => 0xb000 },
	'filegroupid' => { 127 => 'FileGroupID' },
	'fileindex' => { 7 => 0x143, 9 => 0x2d0, 11 => 0x172, 13 => 0x22c, 14 => 0x133, 15 => 0x13f, 16 => 0x1d3, 17 => 0x19b, 18 => 0x1e4, 19 => 0xd0, 20 => 0x1bb, 21 => 0x28c, 22 => 0x1db, 23 => 0x1d9, 24 => [0x270,0x274], 25 => 0x2aa, 26 => 0x2b3, 28 => 0x1eb, 29 => 0x4ae, 30 => 0xb2d, 372 => 0x0 },
	'fileindex2' => { 21 => 0x290 },
	'filemodifydate' => { 127 => 'FileModifyDate' },
	'filename' => { 127 => 'FileName' },
	'filenameasdelivered' => { 357 => 'FileNameAsDelivered' },
	'filenumber' => { 62 => 0x1, 70 => 0x8, 104 => 0x1817, 121 => 'Canon-FileNumber', 234 => 0x4, 439 => 0x10, 440 => 0x95, 441 => 0x10 },
	'filenumbermemory' => { 199 => 0x1a },
	'filenumbersequence' => { 324 => '12.2', 329 => '3.1', 330 => '4.1', 331 => '4.1', 333 => '11.1', 334 => '4.3', 339 => '5.2', 340 => 0x4e, 341 => 0x48, 342 => 0x48, 343 => 0x48 },
	'filepermissions' => { 127 => 'FilePermissions' },
	'filesource' => { 126 => 0xa300, 134 => 0x8000, 541 => 'FileSource' },
	'fileuserid' => { 127 => 'FileUserID' },
	'fileversion' => { 150 => 0x16 },
	'fillflashautoreduction' => { 89 => 0xe, 90 => 0xe, 97 => 0xa },
	'filllight' => { 535 => 'FillLight', 537 => 'FillLight' },
	'fillorder' => { 126 => 0x10a },
	'filmgraineffect' => { 346 => 0x538 },
	'filmmode' => { 134 => 0x1401, 368 => 0x412, 371 => 0x42 },
	'filmtype' => { 283 => 0x2 },
	'filtereffect' => { 62 => 0xe, 275 => 0x37, 276 => 0x3f, 277 => 0x47, 371 => 0xa1 },
	'filtereffectauto' => { 77 => 0xa0 },
	'filtereffectfaithful' => { 76 => 0x70, 77 => 0x70 },
	'filtereffectlandscape' => { 76 => 0x40, 77 => 0x40 },
	'filtereffectmonochrome' => { 19 => 0xff, 76 => 0x88, 77 => 0x88 },
	'filtereffectneutral' => { 76 => 0x58, 77 => 0x58 },
	'filtereffectportrait' => { 76 => 0x28, 77 => 0x28 },
	'filtereffectstandard' => { 76 => 0x10, 77 => 0x10 },
	'filtereffectuserdef1' => { 76 => 0xa0, 77 => 0xb8 },
	'filtereffectuserdef2' => { 76 => 0xb8, 77 => 0xd0 },
	'filtereffectuserdef3' => { 76 => 0xd0, 77 => 0xe8 },
	'finderdisplayduringexposure' => { 90 => 0x1 },
	'finesharpness' => { 410 => 0x70 },
	'finetuneoptcenterweighted' => { 324 => '7.2', 325 => '9.1', 327 => '9.1', 328 => '9.1', 332 => '8.1', 337 => '9.1', 338 => '9.1', 339 => '9.1', 340 => 0x25, 341 => 0x23, 342 => 0x23, 343 => 0x23 },
	'finetuneopthighlightweighted' => { 327 => '46.1', 328 => '46.1', 337 => '46.1', 338 => '46.1', 340 => 0x29, 341 => 0x27, 342 => 0x27, 343 => 0x27 },
	'finetuneoptmatrixmetering' => { 324 => '8.1', 325 => '8.2', 327 => '8.2', 328 => '8.2', 332 => '7.2', 333 => '6.1', 337 => '8.2', 338 => '8.2', 339 => '8.2', 340 => 0x23, 341 => 0x21, 342 => 0x21, 343 => 0x21 },
	'finetuneoptspotmetering' => { 324 => '8.2', 325 => '9.2', 327 => '9.2', 328 => '9.2', 332 => '8.2', 333 => '6.2', 337 => '9.2', 338 => '9.2', 339 => '9.2', 340 => 0x27, 341 => 0x25, 342 => 0x25, 343 => 0x25 },
	'finishexposure' => { 156 => 0xdbd },
	'finishfiletype' => { 156 => 0xdb8 },
	'finishlook' => { 156 => 0xdbc },
	'finishnoise' => { 156 => 0xdba },
	'finishresolution' => { 156 => 0xdb9 },
	'finishsharpening' => { 156 => 0xdbb },
	'firmware' => { 351 => 0x405, 456 => [0x8c,0x17,0x3b], 532 => 'Firmware' },
	'firmware2' => { 456 => 0x57 },
	'firmwaredate' => { 119 => 0x15, 120 => 0x2001, 438 => 0x4, 439 => 0x30, 441 => 0x30 },
	'firmwareid' => { 206 => 0x0 },
	'firmwarename' => { 453 => 0xa001 },
	'firmwarerevision' => { 19 => 0xa4, 70 => 0x1e, 444 => 0x0 },
	'firmwarerevision2' => { 444 => 0xc },
	'firmwareversion' => { 7 => 0x10b, 11 => 0x136, 14 => 0xff, 15 => 0x107, 156 => [0x415,0xce5], 172 => 0x57, 174 => 'FirmwareVersion', 369 => 0x320, 371 => 0x2, 373 => 0x3109, 410 => 0x230, 436 => ['CNFV','FIRM','info'], 439 => 0x2a, 440 => 0x1a, 441 => 0x2a, 442 => 0x18, 446 => 0x2 },
	'firmwareversions' => { 419 => 0x301 },
	'firstframeactioninafc' => { 382 => 0x21f },
	'firstphotodate' => { 147 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 357 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 149 => 0x16, 529 => 'FixtureIdentifier' },
	'flash' => { 121 => 'XMP-Flash', 126 => 0x9209, 170 => 0x22, 200 => 0x1f, 201 => 0x15, 439 => 0x5a, 440 => 0x44, 441 => 0x6a, 541 => 'Flash' },
	'flashaction' => { 466 => 0x3e, 467 => 0x3e, 480 => 0x2017, 485 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 466 => 0x4c, 467 => 0x4c, 485 => 0x77 },
	'flashactionexternal' => { 485 => [0x78,0x7c] },
	'flashactivity' => { 38 => 0x1c },
	'flashbatterylevel' => { 49 => 0x249 },
	'flashbias' => { 371 => 0x24 },
	'flashbits' => { 38 => 0x1d },
	'flashburstpriority' => { 340 => 0x101, 341 => 0x111, 342 => 0x111, 343 => 0x129 },
	'flashbuttonfunction' => { 91 => 0x70e },
	'flashchargelevel' => { 351 => 0x1010 },
	'flashcolorfilter' => { 237 => 0x10, 238 => 0x10, 240 => 0x10 },
	'flashcommandermode' => { 235 => '9.1', 236 => '9.1', 237 => '9.1', 238 => '9.1', 240 => '9.1' },
	'flashcompensation' => { 156 => 0x3f3, 235 => 0xa, 236 => 0xa, 237 => 0xa, 238 => 0x27, 239 => 0xa, 240 => 0xa, 532 => 'FlashCompensation' },
	'flashcontrol' => { 466 => 0x23, 467 => 0x1f, 468 => 0x21 },
	'flashcontrolbuilt-in' => { 333 => '16.1', 334 => '23.1', 336 => '23.1', 337 => '24.1' },
	'flashcontrolmode' => { 235 => '9.2', 236 => '9.2', 237 => '9.2', 238 => '9.2', 240 => '9.2', 246 => 0x214, 261 => 0x2d4, 262 => 0x148, 263 => 0x1b8, 266 => 0x1a8, 267 => 0x1bc, 268 => 0x1bc, 346 => 0x404 },
	'flashcurtain' => { 371 => 0x48 },
	'flashdefault' => { 202 => 0x42 },
	'flashdevice' => { 351 => 0x1005 },
	'flashdistance' => { 120 => 0x2034 },
	'flashenergy' => { 126 => 0xa20b, 541 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 257 => 0x18 },
	'flashexposurecomp' => { 83 => 0xf, 134 => 0x1011, 177 => 'ExposureComp', 199 => 0x23, 204 => 0x104, 205 => 0x49c1, 257 => 0x12, 346 => 0x401, 351 => 0x1023, 410 => 0x4d, 446 => 0x100b, 456 => [0x3a,0x56], 480 => 0x104 },
	'flashexposurecomp2' => { 304 => 0x4d2 },
	'flashexposurecomp3' => { 237 => 0x1d },
	'flashexposurecomp4' => { 237 => 0x27 },
	'flashexposurecomparea' => { 325 => '38.4', 327 => '38.4', 328 => '38.4', 337 => '38.4', 338 => '38.4', 340 => 0x5d, 341 => 0x59, 342 => 0x59, 343 => 0x59 },
	'flashexposurecompset' => { 202 => 0x10, 379 => 0xe, 466 => 0x14, 467 => 0x12, 468 => 0x23, 485 => 0x1f },
	'flashexposurecompset2' => { 485 => [0x26,0x2c] },
	'flashexposureindicator' => { 202 => 0x54 },
	'flashexposureindicatorlast' => { 202 => 0x56 },
	'flashexposureindicatornext' => { 202 => 0x55 },
	'flashexposurelock' => { 62 => 0x19 },
	'flashfired' => { 158 => 0x5d, 177 => 'Fired', 199 => 0x14, 303 => '590.3', 541 => [\'Flash','FlashFired'] },
	'flashfiring' => { 91 => 0x306, 92 => 0x6, 93 => 0x7, 96 => 0x7 },
	'flashfirmwareversion' => { 347 => 0x1002 },
	'flashfocallength' => { 235 => 0xb, 236 => 0xc, 237 => 0xc, 238 => 0xc, 239 => 0xc, 240 => 0x26 },
	'flashfunction' => { 205 => 0x31, 541 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 235 => 0xe, 236 => 0xf, 237 => 0xf, 238 => 0xf, 239 => 0xf, 240 => 0xf, 246 => 0x21a, 261 => 0x2da, 262 => 0x14e, 266 => 0x1ae, 267 => 0x1c2, 268 => 0x1c2 },
	'flashgroupacompensation' => { 235 => 0x11, 236 => 0x12, 237 => 0x13, 238 => 0x28, 239 => 0x28, 240 => 0x28 },
	'flashgroupacontrolmode' => { 235 => 0xf, 236 => '16.1', 237 => '17.1', 238 => '17.1', 239 => '17.1', 240 => '17.1' },
	'flashgroupaoutput' => { 235 => 0x11, 236 => 0x12, 237 => 0x13, 238 => 0x28, 239 => 0x28, 240 => 0x28 },
	'flashgroupbcompensation' => { 235 => 0x12, 236 => 0x13, 237 => 0x14, 238 => 0x29, 239 => 0x29, 240 => 0x29 },
	'flashgroupbcontrolmode' => { 235 => 0x10, 236 => '17.1', 237 => '18.1', 238 => '18.1', 239 => '18.1', 240 => '18.1' },
	'flashgroupboutput' => { 235 => 0x12, 236 => 0x13, 237 => 0x14, 238 => 0x29, 239 => 0x29, 240 => 0x29 },
	'flashgroupccompensation' => { 236 => 0x14, 237 => 0x15, 238 => 0x2a, 239 => 0x2a, 240 => 0x2a },
	'flashgroupccontrolmode' => { 236 => '17.2', 237 => '18.2', 238 => '18.2', 239 => '18.2', 240 => '18.2' },
	'flashgroupcoutput' => { 236 => 0x14, 237 => 0x15, 238 => 0x2a, 239 => 0x2a, 240 => 0x2a },
	'flashguidenumber' => { 83 => 0xd, 101 => 0x0, 177 => 'GuideNumber' },
	'flashilluminationpattern' => { 240 => 0x25 },
	'flashintensity' => { 119 => [0x19,0x5], 346 => 0x405 },
	'flashlevel' => { 326 => 0x9, 480 => 0xb048 },
	'flashmake' => { 177 => 'Make' },
	'flashmanufacturer' => { 196 => 'FlashManufacturer' },
	'flashmastercompensation' => { 246 => 0x22e, 261 => 0x2ee, 262 => 0x162, 266 => 0x1aa, 267 => 0x1be, 268 => 0x1be },
	'flashmastercontrolmode' => { 246 => 0x22c, 261 => 0x2ec, 262 => 0x160 },
	'flashmasteroutput' => { 246 => 0x232, 261 => 0x2f2, 262 => 0x166 },
	'flashmetering' => { 199 => 0x3f, 202 => 0x1c },
	'flashmeteringmode' => { 7 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 18 => 0x15, 20 => 0x15, 22 => 0x15, 28 => 0x15 },
	'flashmeteringsegments' => { 410 => 0x20a },
	'flashmode' => { 119 => 0x4, 156 => 0x3f2, 158 => 0x5c, 169 => 0x27, 177 => 'Mode', 199 => 0x2, 200 => 0x20, 201 => 0x16, 202 => 0xf, 257 => 0x87, 346 => 0x400, 351 => 0x1004, 410 => 0xc, 417 => 0x4, 445 => 0x20, 446 => 0x100a, 455 => 0x225, 466 => 0x13, 467 => 0x7f, 468 => 0x20, 485 => 0x10, 489 => 0x1138, 490 => 0x1138, 491 => 0x1114, 492 => 0x1190, 493 => 0x116c, 494 => 0x1024, 495 => 0x21c, 496 => 0x21c, 497 => 0x211, 541 => [\'Flash','FlashMode'] },
	'flashmodebutton' => { 268 => 0x80e },
	'flashmodebuttonplaybackmode' => { 268 => 0x818 },
	'flashmodel' => { 177 => 'Model', 196 => 'FlashModel', 347 => 0x1001 },
	'flashoptions' => { 389 => 0x2 },
	'flashoptions2' => { 389 => 0x10 },
	'flashoutput' => { 49 => 0x248, 83 => 0x21, 235 => 0xa, 236 => 0xa, 237 => 0xa, 238 => 0x27, 240 => 0x21, 246 => 0x21e, 261 => 0x2de, 262 => 0x152, 266 => 0x1b2, 267 => 0x1c6, 268 => 0x1c6 },
	'flashpixversion' => { 126 => 0xa000, 541 => 'FlashpixVersion' },
	'flashredeyemode' => { 541 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 246 => 0x228, 261 => 0x2e8, 262 => 0x15c, 266 => 0x1bc, 346 => 0x403 },
	'flashreturn' => { 541 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 177 => 'SerialNumber', 347 => 0x1003 },
	'flashsetting' => { 257 => 0x8 },
	'flashshutterspeed' => { 324 => '20.2', 325 => '23.2', 327 => '23.2', 328 => '23.2', 333 => '15.2', 334 => '22.2', 335 => '7.2', 336 => '22.2', 337 => '23.2', 338 => '23.2', 339 => '23.1', 340 => 0x5b, 341 => 0x57, 342 => 0x57, 343 => 0x57 },
	'flashsource' => { 235 => 0x4, 236 => 0x4, 237 => 0x4, 238 => 0x4, 239 => 0x4, 240 => 0x4 },
	'flashstatus' => { 397 => 0x0, 485 => [0x82,0x86], 499 => 0x31, 500 => 0x39, 501 => 0x39 },
	'flashstatusbuilt-in' => { 468 => [0x87,0x287] },
	'flashstatusexternal' => { 468 => [0x88,0x288] },
	'flashsyncspeed' => { 324 => '20.1', 325 => '23.1', 327 => '23.1', 328 => '23.1', 333 => '15.1', 334 => '22.1', 336 => '22.1', 337 => '23.1', 338 => '23.1', 340 => 0x57, 341 => 0x53, 342 => 0x53, 343 => 0x53 },
	'flashsyncspeedav' => { 89 => 0x3, 91 => 0x10f, 92 => 0x2, 93 => 0x3, 94 => 0x2, 95 => 0x2, 96 => 0x3, 97 => 0x6 },
	'flashthreshold' => { 101 => 0x1 },
	'flashtype' => { 177 => 'Type', 202 => 0x59, 257 => 0x9, 347 => 0x1000 },
	'flashwarning' => { 334 => '30.1', 335 => '7.1', 339 => '31.1', 371 => 0x62 },
	'flashwirelessoption' => { 246 => 0x234, 261 => 0x2e6, 262 => 0x15a, 266 => 0x1c8 },
	'flexiblespotposition' => { 480 => 0x201d },
	'flickadvancedirection' => { 341 => 0x25f, 342 => 0x25f, 343 => 0x277 },
	'flickerreduce' => { 455 => 0x218 },
	'flickerreduction' => { 134 => 0x1446, 287 => 0x7 },
	'flickerreductionindicator' => { 282 => 0x532 },
	'flickerreductionshooting' => { 261 => 0x2d0, 263 => 0x1b4, 266 => 0x1a4, 267 => 0x1b8, 268 => 0x1b8 },
	'flightpitchdegree' => { 123 => 'FlightPitchDegree' },
	'flightrolldegree' => { 123 => 'FlightRollDegree' },
	'flightxspeed' => { 123 => 'FlightXSpeed' },
	'flightyawdegree' => { 123 => 'FlightYawDegree' },
	'flightyspeed' => { 123 => 'FlightYSpeed' },
	'flightzspeed' => { 123 => 'FlightZSpeed' },
	'fliphorizontal' => { 317 => 0x76a43206 },
	'fnumber' => { 7 => 0x3, 9 => 0x3, 11 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x3, 31 => 0x5, 32 => 0x6, 83 => 0x15, 126 => 0x829d, 155 => 0xfd04, 158 => 0x1e, 160 => 0xfa23, 162 => 0xf103, 165 => 0x13, 167 => 0x3c, 169 => 0x1c, 170 => 0x18, 172 => 0xc, 181 => 'FNumber', 199 => 0xa, 200 => 0x36, 201 => 0x47, 202 => 0x9, 205 => 0x49c7, 255 => 0x38, 370 => 0x35a, 410 => 0x13, 453 => 0xa019, 456 => [0x31,0x49], 466 => 0x1, 467 => 0x1, 485 => [0x20,0x22,0x26], 541 => 'FNumber' },
	'focaldistance' => { 145 => 'FocalDistance' },
	'focallength' => { 7 => 0x1d, 8 => 0xa, 9 => 0x23, 10 => 0x9, 11 => 0x1d, 12 => 0x9, 13 => 0x1e, 14 => 0x1d, 15 => 0x1d, 16 => 0x1e, 17 => 0x1e, 18 => 0x1e, 19 => 0x28, 20 => 0x1e, 21 => 0x23, 22 => 0x1e, 23 => 0x1e, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x23, 28 => 0x1e, 29 => 0x23, 64 => 0x1, 67 => 0x7, 120 => 0x1d, 126 => 0x920a, 165 => 0x1d, 181 => 'FocalLength', 199 => 0x12, 250 => 0xa, 251 => 0xb, 255 => [0xc,0x3c], 365 => 0x1, 410 => 0x1d, 419 => 0x403, 446 => 0x1500, 465 => 0xe, 493 => 0x1278, 494 => 0x1134, 495 => 0x32c, 496 => 0x32c, 497 => 0x30a, 541 => 'FocalLength' },
	'focallength2' => { 485 => [0x23,0x25,0x29] },
	'focallength35mm' => { 361 => 'FocalLength35mm' },
	'focallengthin35mmformat' => { 126 => 0xa405, 437 => 'camera.focal_length.35mm_equivalent', 453 => 0xa01a, 541 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 465 => 0x10 },
	'focalplaneafpointarea' => { 498 => 0x2 },
	'focalplaneafpointlocation1' => { 498 => 0x6 },
	'focalplaneafpointlocation10' => { 498 => 0x2a },
	'focalplaneafpointlocation11' => { 498 => 0x2e },
	'focalplaneafpointlocation12' => { 498 => 0x32 },
	'focalplaneafpointlocation13' => { 498 => 0x36 },
	'focalplaneafpointlocation14' => { 498 => 0x3a },
	'focalplaneafpointlocation15' => { 498 => 0x3e },
	'focalplaneafpointlocation2' => { 498 => 0xa },
	'focalplaneafpointlocation3' => { 498 => 0xe },
	'focalplaneafpointlocation4' => { 498 => 0x12 },
	'focalplaneafpointlocation5' => { 498 => 0x16 },
	'focalplaneafpointlocation6' => { 498 => 0x1a },
	'focalplaneafpointlocation7' => { 498 => 0x1e },
	'focalplaneafpointlocation8' => { 498 => 0x22 },
	'focalplaneafpointlocation9' => { 498 => 0x26 },
	'focalplaneafpointsused' => { 498 => 0x1 },
	'focalplanediagonal' => { 347 => 0x103, 351 => 0x205 },
	'focalplaneresolutionunit' => { 126 => 0xa210, 541 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 126 => 0xa20e, 541 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 64 => 0x2 },
	'focalplanexunknown' => { 64 => 0x2 },
	'focalplaneyresolution' => { 126 => 0xa20f, 541 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 64 => 0x3 },
	'focalplaneyunknown' => { 64 => 0x3 },
	'focalpointx' => { 145 => 'FocalPointX' },
	'focalpointy' => { 145 => 'FocalPointY' },
	'focaltype' => { 10 => 0x2d, 64 => 0x0 },
	'focalunits' => { 38 => 0x19 },
	'focus' => { 306 => 0x8 },
	'focusarea' => { 199 => 0x31 },
	'focusareaselection' => { 335 => '15.2' },
	'focusbracket' => { 371 => 0xbd },
	'focusbracketing' => { 38 => 0x32 },
	'focusbracketstepsize' => { 346 => 0x308 },
	'focuscontinuous' => { 38 => 0x20 },
	'focusdisplayaiservoandmf' => { 91 => 0x515 },
	'focusdistance' => { 181 => 'FocusDistance', 199 => 0x13, 205 => 0x49bb, 250 => 0x9, 251 => 0xa, 255 => [0xb,0x4e], 349 => 0x305, 365 => 0x0, 369 => 0x304, 370 => 0x304 },
	'focusdistancelower' => { 7 => 0x45, 9 => 0x8e, 11 => 0x45, 13 => 0x56, 14 => 0x45, 15 => 0x45, 16 => 0x52, 17 => 0x52, 18 => 0x56, 20 => 0x52, 21 => 0x8e, 22 => 0x59, 23 => 0x57, 24 => 0x8e, 25 => 0x94, 26 => 0x95, 27 => 0xa7, 28 => 0x56, 29 => 0xa7, 62 => 0x15, 83 => 0x14 },
	'focusdistancerange' => { 1 => 0xc },
	'focusdistancerangewidth' => { 255 => 0x4c },
	'focusdistanceupper' => { 7 => 0x43, 9 => 0x8c, 11 => 0x43, 13 => 0x54, 14 => 0x43, 15 => 0x43, 16 => 0x50, 17 => 0x50, 18 => 0x54, 20 => 0x50, 21 => 0x8c, 22 => 0x57, 23 => 0x55, 24 => 0x8c, 25 => 0x92, 26 => 0x93, 27 => 0xa5, 28 => 0x54, 29 => 0xa5, 62 => 0x14, 83 => 0x13 },
	'focusholdbutton' => { 202 => 0x44 },
	'focusinfoversion' => { 349 => 0x0 },
	'focusingscreen' => { 90 => 0x0, 91 => 0x80b, 96 => 0x0 },
	'focuslocation' => { 480 => 0x2027 },
	'focuslocation2' => { 480 => 0x204a },
	'focuslocked' => { 198 => 0x14 },
	'focusmode' => { 38 => 0x7, 119 => 0x3, 120 => [0x3003,0xd], 134 => 0x1021, 156 => 0x3f5, 158 => 0x38, 174 => 'FocusMode', 199 => 0x30, 201 => 0xe, 202 => 0xc, 257 => 0x7, 346 => 0x301, 351 => 0x100b, 371 => 0x7, 410 => 0xd, 417 => 0x3, 446 => 0x1006, 459 => [0xb,0x5], 465 => [0x15,0x1d], 466 => 0x4d, 467 => 0x4d, 480 => [0xb042,0xb04e,0x201b], 485 => 0x13, 506 => 0x16 },
	'focusmode2' => { 133 => '0.1', 389 => '3.1', 485 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 326 => '10.1', 463 => 0x14, 464 => 0x15, 466 => 0x10, 467 => 0xf, 468 => 0x6 },
	'focusmodeswitch' => { 202 => 0x58, 466 => 0x2e },
	'focuspeakingdisplay' => { 340 => 0x22f, 341 => 0x235, 342 => 0x235, 343 => 0x24d },
	'focuspeakinghighlightcolor' => { 340 => 0x53, 341 => 0x4b, 342 => 0x4b, 343 => 0x4b },
	'focuspeakinglevel' => { 340 => 0x51, 341 => 0x49, 342 => 0x49, 343 => 0x49 },
	'focuspixel' => { 134 => 0x1023 },
	'focuspointlock' => { 341 => 0x1d3, 342 => 0x1d3, 343 => 0x1eb },
	'focuspointpersistence' => { 340 => 0xf5, 341 => 0x105, 342 => 0x105, 343 => 0x11b },
	'focuspointwrap' => { 324 => '2.2', 325 => '2.2', 327 => '2.1', 328 => '2.1', 332 => '1.1', 333 => '2.2', 334 => '1.1', 337 => '2.2', 338 => '2.1', 339 => '2.5', 340 => 0x16, 341 => 0x16, 342 => 0x16, 343 => 0x16 },
	'focusposition' => { 1 => 0x2f, 250 => 0x8, 251 => 0x8, 410 => 0x10, 477 => 0x9bb },
	'focusposition2' => { 485 => [0x29,0x2b,0x2f], 506 => 0x2d, 509 => 0x20 },
	'focuspositionhorizontal' => { 214 => 0x2f, 215 => 0x43 },
	'focuspositionvertical' => { 214 => 0x31, 215 => 0x45 },
	'focusprocess' => { 346 => 0x302 },
	'focusrange' => { 38 => 0x12, 351 => 0x100a },
	'focusrangeindex' => { 400 => '3.1' },
	'focusresult' => { 215 => 0x4a },
	'focusringrotation' => { 91 => 0x713 },
	'focussetting' => { 456 => 0x6 },
	'focusshiftautoreset' => { 267 => 0x6da, 268 => 0x748 },
	'focusshiftexposurelock' => { 246 => 0x1b4, 261 => 0x224, 262 => 0xe8, 263 => 0x100, 266 => 0xf4, 267 => 0x104, 268 => 0x104 },
	'focusshiftinterval' => { 246 => 0x1b0, 261 => 0x220, 262 => 0xe4, 263 => 0xfc, 266 => 0xf0, 267 => 0x100, 268 => 0x100 },
	'focusshiftnumbershots' => { 246 => 0x1a8, 261 => 0x218, 262 => 0xdc, 263 => 0xf4, 266 => 0xe8, 267 => 0xf8, 268 => 0xf8 },
	'focusshiftshooting' => { 285 => 0x20 },
	'focusshiftstepwidth' => { 246 => 0x1ac, 261 => 0x21c, 262 => 0xe0, 263 => 0xf8, 266 => 0xec, 267 => 0xfc, 268 => 0xfc },
	'focusstatus' => { 465 => 0x19, 466 => 0x53, 467 => 0x53 },
	'focusstepcount' => { 349 => 0x301, 351 => 0x100e },
	'focusstepinfinity' => { 349 => 0x303, 351 => 0x103b },
	'focusstepnear' => { 349 => 0x304, 351 => 0x103c },
	'focusstepsfrominfinity' => { 255 => 0x58 },
	'focustrackinglockon' => { 324 => ['1.5','4.1'], 325 => '1.4', 332 => '0.4', 333 => '3.1', 334 => '0.4', 337 => '1.4' },
	'focuswarning' => { 134 => 0x1301 },
	'foldername' => { 199 => 0x27 },
	'foldernumber' => { 466 => 0x9a, 468 => [0x402,0x114,0x316] },
	'fontcomposite' => { 570 => [\'Fonts','FontsComposite'] },
	'fontface' => { 570 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 570 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 570 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 570 => [\'Fonts','FontsFontName'] },
	'fonts' => { 570 => 'Fonts' },
	'fonttype' => { 570 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 570 => [\'Fonts','FontsVersionString'] },
	'for' => { 426 => 'For' },
	'forcewrite' => { 127 => 'ForceWrite' },
	'format' => { 144 => 'Format', 436 => "\xa9fmt", 538 => 'format', 563 => 'Format' },
	'forwardlock' => { 560 => 'forwardlock' },
	'forwardmatrix1' => { 126 => 0xc714 },
	'forwardmatrix2' => { 126 => 0xc715 },
	'forwardmatrix3' => { 126 => 0xcd34 },
	'fossilspecimen' => { 125 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 125 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 73 => [0x2,0x4] },
	'frameheight' => { 134 => 0x3822 },
	'framenum' => { 421 => 0xd7 },
	'framenumber' => { 134 => 0x8003, 205 => 0x3c, 410 => 0x29 },
	'framerate' => { 73 => [0x1,0x6], 126 => 0xc764, 134 => 0x3820 },
	'framereadouttime' => { 437 => 'camera.framereadouttimeinmicroseconds' },
	'framewidth' => { 134 => 0x3821 },
	'framing' => { 554 => 'framing' },
	'freebytes' => { 104 => 0x1 },
	'freememorycardimages' => { 200 => [0x37,0x54], 201 => [0x2d,0x4a], 202 => 0x32 },
	'fujiflashmode' => { 134 => 0x1010 },
	'fujimodel' => { 134 => 0x1447 },
	'fujimodel2' => { 134 => 0x1448 },
	'fullframerateplaybackintent' => { 430 => 'full-frame-rate-playback-intent' },
	'fullhdhighspeedrec' => { 134 => 0x3824 },
	'fullimagesize' => { 480 => 0xb02b },
	'fullpanoheightpixels' => { 147 => 'FullPanoHeightPixels', 148 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 147 => 'FullPanoWidthPixels', 148 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 446 => 0x100d },
	'fullsizeimage' => { 180 => 'data' },
	'fullsizeimagename' => { 180 => '1Name' },
	'fullsizeimagetype' => { 180 => '0Type' },
	'func1button' => { 327 => '14.1', 328 => '14.1', 338 => '14.1', 340 => 0x67, 341 => 0x63, 342 => 0x63, 343 => 0x63 },
	'func1buttonplaybackmode' => { 340 => 0x19f, 341 => 0x1a5, 342 => 0x1a5, 343 => 0x1bd },
	'func1buttonplusdials' => { 327 => '42.1', 328 => '42.1', 338 => '42.1' },
	'func2button' => { 327 => '80.1', 328 => '80.1', 338 => '80.1', 340 => 0x77, 341 => 0x73, 342 => 0x73, 343 => 0x73 },
	'func2buttonplaybackmode' => { 340 => 0x1a1, 341 => 0x1a7, 342 => 0x1a7, 343 => 0x1bf },
	'func2buttonplusdials' => { 327 => '81.1' },
	'func3button' => { 327 => '83.1', 341 => 0x119, 342 => 0x119, 343 => 0x131 },
	'func3buttonplaybackmode' => { 342 => 0x1a9, 343 => 0x1c1 },
	'func4button' => { 342 => 0x175, 343 => 0x18d },
	'func4buttonplaybackmode' => { 342 => 0x1af, 343 => 0x1c7 },
	'funcbutton' => { 324 => ['14.1','15.1'], 325 => '14.1', 333 => '28.1', 334 => '13.1', 337 => '14.1', 339 => '14.1' },
	'funcbuttonplusdials' => { 324 => ['14.2','15.2'], 325 => '14.2', 333 => '31.1', 337 => '42.1' },
	'functionbutton' => { 331 => '13.1', 335 => '5.2' },
	'gainbase' => { 350 => 0x610 },
	'gaincontrol' => { 126 => 0xa407, 541 => 'GainControl' },
	'gainmapmax' => { 546 => 'GainMapMax' },
	'gainmapmin' => { 546 => 'GainMapMin' },
	'gamma' => { 126 => 0xa500, 156 => 0x8fe, 358 => 'gAMA', 376 => 0x11c, 542 => 'Gamma', 546 => 'Gamma' },
	'gammablackpoint' => { 112 => 0xc },
	'gammacolortone' => { 112 => 0x3 },
	'gammacompensatedvalue' => { 151 => 0x91 },
	'gammacontrast' => { 112 => 0x2 },
	'gammacurveoutputrange' => { 112 => 0xf },
	'gammahighlight' => { 112 => 0xa },
	'gammalinear' => { 110 => 0x20200 },
	'gammamidpoint' => { 112 => 0xe },
	'gammasaturation' => { 112 => 0x4 },
	'gammashadow' => { 112 => 0x9 },
	'gammasharpnessstrength' => { 112 => 0x8 },
	'gammaunsharpmaskfineness' => { 112 => 0x6 },
	'gammaunsharpmaskstrength' => { 112 => 0x5 },
	'gammaunsharpmaskthreshold' => { 112 => 0x7 },
	'gammawhitepoint' => { 112 => 0xd },
	'garminsettings' => { 436 => 'pmcc' },
	'garminsoftware' => { 436 => 'uuid' },
	'gdalmetadata' => { 126 => 0xa480 },
	'gdalnodata' => { 126 => 0xa481 },
	'geimagesize' => { 134 => 0x1304 },
	'gemake' => { 136 => 0x300 },
	'gemodel' => { 136 => 0x207 },
	'genre' => { 428 => ['gnre',"\xa9gen"], 430 => 'genre', 436 => ['gnre',"\xa9gen"], 549 => 'Genre', 555 => 'genre', 565 => 'genre' },
	'genrecvid' => { 549 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 549 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 549 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 549 => [\'Genre','GenreCvTermRefinedAbout'] },
	'genreid' => { 428 => 'geID' },
	'geography' => { 556 => 'geography' },
	'geolocate' => { 127 => 'Geolocate' },
	'geologicalcontext' => { 125 => 'GeologicalContext' },
	'geologicalcontextbed' => { 125 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 125 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 125 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 125 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 125 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 127 => 'Geosync' },
	'geotag' => { 127 => 'Geotag' },
	'geotiffasciiparams' => { 126 => 0x87b1 },
	'geotiffdirectory' => { 126 => 0x87af },
	'geotiffdoubleparams' => { 126 => 0x87b0 },
	'geotime' => { 127 => 'Geotime' },
	'giftftppriority' => { 523 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 123 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 123 => 'GimbalReverse' },
	'gimbalrolldegree' => { 123 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 123 => 'GimbalYawDegree' },
	'globalaltitude' => { 424 => 0x419 },
	'globalangle' => { 424 => 0x40d },
	'gndfiltertype' => { 350 => 0x2110 },
	'good' => { 565 => 'good' },
	'googlehostheader' => { 428 => 'gshh' },
	'googlepingmessage' => { 428 => 'gspm' },
	'googlepingurl' => { 428 => 'gspu' },
	'googleplusuploadcode' => { 126 => 0x9009 },
	'googlesourcedata' => { 428 => 'gssd' },
	'googlestarttime' => { 428 => 'gsst' },
	'googletrackduration' => { 428 => 'gstd' },
	'goprotype' => { 436 => 'GoPr' },
	'gpsaltitude' => { 138 => 0x6, 178 => 'Altitude', 541 => 'GPSAltitude' },
	'gpsaltituderef' => { 138 => 0x5, 541 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 138 => 0x1c, 541 => 'GPSAreaInformation' },
	'gpscoordinates' => { 428 => "\xa9xyz", 430 => 'location.ISO6709', 436 => ['@xyz',"\xa9xyz"] },
	'gpsdatestamp' => { 138 => 0x1d },
	'gpsdatetime' => { 178 => 'DateTime', 541 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 138 => 0x18, 178 => 'Bearing', 541 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 138 => 0x17, 541 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 138 => 0x1a, 178 => 'Distance', 541 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 138 => 0x19, 541 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 138 => 0x14, 541 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 138 => 0x13 },
	'gpsdestlongitude' => { 138 => 0x16, 541 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 138 => 0x15 },
	'gpsdifferential' => { 138 => 0x1e, 178 => 'Differential', 541 => 'GPSDifferential' },
	'gpsdop' => { 138 => 0xb, 541 => 'GPSDOP' },
	'gpshpositioningerror' => { 138 => 0x1f, 541 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 138 => 0x11, 541 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 138 => 0x10, 541 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 121 => 'GPS-GPSLatitude', 123 => 'GpsLatitude', 138 => 0x2, 178 => 'Latitude', 541 => 'GPSLatitude' },
	'gpslatituderef' => { 138 => 0x1 },
	'gpslongitude' => { 121 => 'GPS-GPSLongitude', 123 => 'GpsLongitude', 138 => 0x4, 178 => 'Longitude', 541 => 'GPSLongitude' },
	'gpslongituderef' => { 138 => 0x3 },
	'gpslongtitude' => { 123 => 'GpsLongtitude' },
	'gpsmapdatum' => { 138 => 0x12, 178 => 'Datum', 541 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 138 => 0xa, 178 => 'MeasureMode', 541 => 'GPSMeasureMode' },
	'gpsposition' => { 121 => 'Exif-GPSPosition' },
	'gpsprocessingmethod' => { 138 => 0x1b, 541 => 'GPSProcessingMethod' },
	'gpssatellites' => { 138 => 0x8, 178 => 'Satellites', 541 => 'GPSSatellites' },
	'gpsspeed' => { 138 => 0xd, 178 => 'Speed', 541 => 'GPSSpeed' },
	'gpsspeedref' => { 138 => 0xc, 541 => 'GPSSpeedRef' },
	'gpsstatus' => { 138 => 0x9, 541 => 'GPSStatus' },
	'gpsstring' => { 156 => 0x402 },
	'gpstimestamp' => { 138 => 0x7 },
	'gpstrack' => { 138 => 0xf, 178 => 'Heading', 541 => 'GPSTrack' },
	'gpstrackref' => { 138 => 0xe, 541 => 'GPSTrackRef' },
	'gpsversionid' => { 138 => 0x0, 541 => 'GPSVersionID' },
	'gradation' => { 346 => 0x50f },
	'gradientbasedcorractive' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrblacks2012' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'] },
	'gradientbasedcorrbrightness' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrcorrectionname' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'] },
	'gradientbasedcorrcorrectionsyncid' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'] },
	'gradientbasedcorrdefringe' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrdehaze' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'] },
	'gradientbasedcorrections' => { 535 => 'GradientBasedCorrections', 537 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'] },
	'gradientbasedcorrluminancenoise' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskinputdigest' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'gradientbasedcorrmaskleft' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmaskactive' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'gradientbasedcorrmaskmaskblendmode' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmaskdigest' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'gradientbasedcorrmaskmaskinverted' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'gradientbasedcorrmaskmaskname' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'] },
	'gradientbasedcorrmaskmasks' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'] },
	'gradientbasedcorrmaskmasksalpha' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'gradientbasedcorrmaskmasksangle' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'gradientbasedcorrmaskmasksbottom' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'gradientbasedcorrmaskmaskscentervalue' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'gradientbasedcorrmaskmaskscenterweight' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'gradientbasedcorrmaskmasksdabs' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'gradientbasedcorrmaskmasksfeather' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'gradientbasedcorrmaskmasksflipped' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'gradientbasedcorrmaskmasksflow' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'gradientbasedcorrmaskmasksfullx' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'gradientbasedcorrmaskmasksfully' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'gradientbasedcorrmaskmasksinputdigest' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'gradientbasedcorrmaskmasksleft' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'gradientbasedcorrmaskmasksmaskactive' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'gradientbasedcorrmaskmasksmaskblendmode' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmasksmaskdigest' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'gradientbasedcorrmaskmasksmaskinverted' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'gradientbasedcorrmaskmasksmaskname' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'gradientbasedcorrmaskmasksmasksubtype' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksmasksyncid' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'gradientbasedcorrmaskmasksmaskversion' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'gradientbasedcorrmaskmasksmidpoint' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'gradientbasedcorrmaskmasksorigin' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'gradientbasedcorrmaskmasksperimetervalue' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'gradientbasedcorrmaskmasksradius' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'gradientbasedcorrmaskmasksreferencepoint' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'gradientbasedcorrmaskmasksright' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'gradientbasedcorrmaskmasksroundness' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'gradientbasedcorrmaskmaskssizex' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'gradientbasedcorrmaskmaskssizey' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'gradientbasedcorrmaskmaskstop' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'gradientbasedcorrmaskmasksubtype' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksvalue' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'gradientbasedcorrmaskmasksversion' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'gradientbasedcorrmaskmaskswhat' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'gradientbasedcorrmaskmaskswholeimagearea' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'gradientbasedcorrmaskmasksx' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'] },
	'gradientbasedcorrmaskmasksy' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'] },
	'gradientbasedcorrmaskmasksyncid' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'gradientbasedcorrmaskmaskszerox' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'gradientbasedcorrmaskmaskszeroy' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'gradientbasedcorrmaskmaskversion' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'gradientbasedcorrmaskmidpoint' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskorigin' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'] },
	'gradientbasedcorrmaskperimetervalue' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskrange' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'gradientbasedcorrmaskrangeareamodels' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrmaskrangeareamodelscolorsampleinfo' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrmaskrangeareamodelscomponents' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrmaskrangecoloramount' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrmaskrangedepthfeather' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrmaskrangedepthmax' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrmaskrangedepthmin' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrmaskrangeinvert' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'gradientbasedcorrmaskrangelumfeather' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrmaskrangeluminancedepthsampleinfo' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrmaskrangelummax' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrmaskrangelummin' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrmaskrangelumrange' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrmaskrangesampletype' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrmaskrangetype' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'gradientbasedcorrmaskrangeversion' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'gradientbasedcorrmaskreferencepoint' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'gradientbasedcorrmaskright' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskwholeimagearea' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'gradientbasedcorrmaskx' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrrangemask' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'] },
	'gradientbasedcorrrangemaskareamodels' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrrangemaskareamodelscolorsampleinfo' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrrangemaskareamodelscomponents' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrrangemaskcoloramount' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrrangemaskdepthfeather' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrrangemaskdepthmax' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrrangemaskdepthmin' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrrangemaskinvert' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'gradientbasedcorrrangemasklumfeather' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrrangemaskluminancedepthsampleinfo' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrrangemasklummax' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrrangemasklummin' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrrangemasklumrange' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrrangemasksampletype' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrrangemasktype' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'] },
	'gradientbasedcorrrangemaskversion' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'gradientbasedcorrsaturation' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'] },
	'gradientbasedcorrshadows2012' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtexture' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'] },
	'gradientbasedcorrtint' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrtoninghue' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrtoningsaturation' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrwhat' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'gradientbasedcorrwhites2012' => { 535 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'], 537 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'] },
	'grainamount' => { 535 => 'GrainAmount', 537 => 'GrainAmount' },
	'graineffectroughness' => { 134 => 0x1047 },
	'graineffectsize' => { 134 => 0x104c },
	'grainfrequency' => { 535 => 'GrainFrequency', 537 => 'GrainFrequency' },
	'grainseed' => { 535 => 'GrainSeed', 537 => 'GrainSeed' },
	'grainsize' => { 535 => 'GrainSize', 537 => 'GrainSize' },
	'graymixeraqua' => { 535 => 'GrayMixerAqua', 537 => 'GrayMixerAqua' },
	'graymixerblue' => { 535 => 'GrayMixerBlue', 537 => 'GrayMixerBlue' },
	'graymixergreen' => { 535 => 'GrayMixerGreen', 537 => 'GrayMixerGreen' },
	'graymixermagenta' => { 535 => 'GrayMixerMagenta', 537 => 'GrayMixerMagenta' },
	'graymixerorange' => { 535 => 'GrayMixerOrange', 537 => 'GrayMixerOrange' },
	'graymixerpurple' => { 535 => 'GrayMixerPurple', 537 => 'GrayMixerPurple' },
	'graymixerred' => { 535 => 'GrayMixerRed', 537 => 'GrayMixerRed' },
	'graymixeryellow' => { 535 => 'GrayMixerYellow', 537 => 'GrayMixerYellow' },
	'graypoint' => { 517 => 0x8021 },
	'grayresponseunit' => { 126 => 0x122 },
	'greencurvelimits' => { 115 => 0x1c4 },
	'greencurvepoints' => { 114 => 0x53, 115 => 0x19a },
	'greenghostmitigationstatus' => { 1 => 0x3f },
	'greenhsl' => { 110 => 0x20913 },
	'greenhue' => { 535 => 'GreenHue', 537 => 'GreenHue' },
	'greensaturation' => { 535 => 'GreenSaturation', 537 => 'GreenSaturation' },
	'griddisplay' => { 324 => '13.3', 325 => '4.3', 327 => '4.2', 328 => '4.2', 329 => '2.2', 333 => '10.5', 334 => '3.4', 335 => '6.1', 337 => '4.4', 338 => '4.2', 339 => '4.2' },
	'gripbatteryadload' => { 386 => 0x5 },
	'gripbatteryadnoload' => { 386 => 0x4 },
	'gripbatterypercent' => { 386 => 0x11 },
	'gripbatterystate' => { 386 => ['1.2',0x10] },
	'gripbatteryvoltage' => { 386 => 0x12 },
	'group' => { 535 => 'Group', 537 => 'Group' },
	'groupareaafillumination' => { 325 => '46.4', 328 => '47.4', 337 => '47.4' },
	'grouping' => { 428 => ['grup',"\xa9grp"], 436 => "\xa9grp" },
	'guid' => { 428 => 'GUID' },
	'h2resetblackpixels' => { 156 => 0x18a6 },
	'h3resetblackcolumns' => { 156 => 0x18ce },
	'h3resetblackpixels' => { 156 => 0x18b0 },
	'halftonehints' => { 126 => 0x141 },
	'hardlink' => { 127 => 'HardLink' },
	'hasalternative' => { 555 => 'hasAlternative' },
	'hascorrection' => { 555 => 'hasCorrection' },
	'hascorrectiona-lang' => { 555 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 555 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 555 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 535 => 'HasCrop', 537 => 'HasCrop' },
	'hasextendedxmp' => { 567 => 'HasExtendedXMP' },
	'hassettings' => { 535 => 'HasSettings', 537 => 'HasSettings' },
	'hastranslation' => { 555 => 'hasTranslation' },
	'hasvisibleoverprint' => { 570 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 570 => 'HasVisibleTransparency' },
	'hdmioutputn-log' => { 262 => 0x35a },
	'hdmioutputresolution' => { 264 => 0x710, 265 => 0x770, 266 => 0x610, 267 => 0x640, 268 => 0x6a8 },
	'hdmiviewassist' => { 342 => 0x20f, 343 => 0x227 },
	'hdr' => { 65 => 0x1, 242 => 0x4, 243 => 0x4, 261 => 0x354, 263 => 0x23a, 268 => 0x23a, 371 => 0x9e, 410 => 0x85, 480 => 0x200a },
	'hdr-pq' => { 38 => 0x34 },
	'hdrcapacitymax' => { 546 => 'HDRCapacityMax' },
	'hdrcapacitymin' => { 546 => 'HDRCapacityMin' },
	'hdreditmode' => { 535 => 'HDREditMode', 537 => 'HDREditMode' },
	'hdreffect' => { 65 => 0x2 },
	'hdrgain' => { 1 => 0x30 },
	'hdrgainmapversion' => { 524 => 'HDRGainMapVersion' },
	'hdrheadroom' => { 1 => 0x21 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrlevel' => { 242 => 0x5, 243 => 0x5, 261 => 0x360, 263 => 0x246, 268 => 0x246, 468 => 0x2e, 485 => 0x17 },
	'hdrlevel2' => { 242 => 0x7 },
	'hdrplusmakernote' => { 141 => 'HdrPlusMakernote' },
	'hdrpmakernote' => { 141 => 'hdrp_makernote' },
	'hdrsetting' => { 468 => 0x2d, 485 => 0x16, 489 => 0x1148, 490 => 0x1148, 491 => 0x1124, 492 => 0x11a0, 493 => 0x117c, 494 => 0x1034, 495 => 0x22c, 496 => 0x22c, 497 => 0x21f },
	'hdrsmoothing' => { 242 => 0x6 },
	'hdvideo' => { 428 => 'hdvd' },
	'headline' => { 149 => 0x69, 549 => 'Headline', 553 => 'Headline' },
	'hiddendatalength' => { 478 => 0x1 },
	'hiddendataoffset' => { 478 => 0x0 },
	'hierarchicalkeywords' => { 189 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 189 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 189 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 189 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 189 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 189 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 189 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 189 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 189 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 189 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 189 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 189 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 189 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 189 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 189 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 189 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 189 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 189 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 526 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 125 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highframerate' => { 261 => 0x16c, 263 => 0x48, 267 => 0x48, 268 => 0x48 },
	'highfrequencyflickerreduction' => { 261 => 0x386, 263 => 0x27c, 267 => 0x27c, 268 => 0x27c },
	'highisomultiplierblue' => { 376 => 0x1a },
	'highisomultipliergreen' => { 376 => 0x19 },
	'highisomultiplierred' => { 376 => 0x18 },
	'highisonoisereduction' => { 16 => 0xbc, 17 => 0xbd, 20 => 0xbd, 28 => 0xc9, 68 => 0x5, 91 => 0x202, 257 => 0xb1, 410 => 0x71, 466 => 0x2c, 467 => 0x26, 468 => 0x26, 480 => 0x2009, 485 => 0x12, 512 => 0x42 },
	'highisonoisereduction2' => { 480 => 0xb050 },
	'highlight' => { 456 => 0xf },
	'highlight2012' => { 535 => 'Highlight2012', 537 => 'Highlight2012' },
	'highlightadj' => { 110 => 0x2030c },
	'highlightcolordistortreduct' => { 517 => 0x8026 },
	'highlightlinearitylimit' => { 453 => 0xa025 },
	'highlightprotection' => { 316 => 0x6 },
	'highlightrecovery' => { 535 => 'HighlightRecovery', 537 => 'HighlightRecovery' },
	'highlights' => { 480 => 0x2033, 528 => 'Highlights' },
	'highlights2012' => { 535 => 'Highlights2012', 537 => 'Highlights2012' },
	'highlightsadj' => { 517 => 0x9019 },
	'highlightshadow' => { 371 => 0xad },
	'highlighttone' => { 134 => 0x1041 },
	'highlighttonepriority' => { 13 => 0x7, 16 => 0x7, 17 => 0x7, 18 => 0x7, 20 => 0x7, 22 => 0x7, 28 => 0x7, 68 => 0x3, 91 => 0x203 },
	'highlightwarning' => { 371 => 0x8002 },
	'highlowkeyadj' => { 410 => 0x6c },
	'highspeedsync' => { 202 => 0x5, 340 => 0x59, 341 => 0x55, 342 => 0x55, 343 => 0x55, 466 => 0x2, 467 => 0x2 },
	'hintversion' => { 436 => 'hinv' },
	'histogramxml' => { 317 => 0x83a1a25 },
	'history' => { 553 => 'History', 566 => 'History' },
	'historyaction' => { 566 => [\'History','HistoryAction'] },
	'historychanged' => { 566 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 566 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 566 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 566 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 566 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 156 => 0xc88 },
	'holefilldeltathreshold' => { 156 => 0xc7e },
	'hometowncity' => { 120 => 0x3006, 410 => 0x23, 416 => 0x2 },
	'hometowncitycode' => { 417 => 0x1000 },
	'hometowndst' => { 410 => 0x25, 416 => '0.2' },
	'hostcomputer' => { 126 => 0x13c },
	'hostsoftwarerendering' => { 156 => 0xce7 },
	'hue' => { 207 => 0x3b, 276 => 0x3d, 277 => 0x45, 410 => 0x67 },
	'hueadj' => { 320 => 0x2f, 517 => 0x8019 },
	'hueadjust' => { 446 => 0x1016 },
	'hueadjustment' => { 200 => 0x4a, 201 => 0x40, 257 => 0x92, 275 => 0x36 },
	'hueadjustmentaqua' => { 535 => 'HueAdjustmentAqua', 537 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 535 => 'HueAdjustmentBlue', 537 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 535 => 'HueAdjustmentGreen', 537 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 535 => 'HueAdjustmentMagenta', 537 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 535 => 'HueAdjustmentOrange', 537 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 535 => 'HueAdjustmentPurple', 537 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 535 => 'HueAdjustmentRed', 537 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 535 => 'HueAdjustmentYellow', 537 => 'HueAdjustmentYellow' },
	'huesetting' => { 354 => 0x1011 },
	'humanobservation' => { 125 => 'HumanObservation' },
	'humanobservationday' => { 125 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 125 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 125 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 125 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 125 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 125 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 125 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationeventtype' => { 125 => [\'HumanObservation','HumanObservationEventType'] },
	'humanobservationfieldnotes' => { 125 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 125 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 125 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 125 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 125 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 125 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 125 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 125 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 125 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 125 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 125 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 125 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 125 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 126 => 0x9401, 542 => 'Humidity' },
	'icc_profile' => { 127 => 'ICC_Profile', 137 => 'ICCRGBG1/012' },
	'iccprofilename' => { 553 => 'ICCProfile' },
	'iconuri' => { 436 => 'icnu' },
	'idccreativestyle' => { 517 => 0x8000 },
	'idcpreviewlength' => { 517 => 0x202 },
	'idcpreviewstart' => { 517 => 0x201 },
	'identification' => { 125 => 'Identification' },
	'identificationid' => { 125 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 125 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 125 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 125 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 125 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 125 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifiedbyid' => { 125 => [\'Identification','IdentificationIdentifiedByID'] },
	'identifier' => { 538 => 'identifier', 563 => 'Identifier' },
	'ifcameramodel' => { 156 => 0x9c8 },
	'illuminantdata1' => { 126 => 0xcd35 },
	'illuminantdata2' => { 126 => 0xcd36 },
	'illuminantdata3' => { 126 => 0xcd37 },
	'illumination' => { 335 => '0.5', 442 => 0x48 },
	'imageabsolutex' => { 156 => 0x3fe },
	'imageabsolutey' => { 156 => 0x3ff },
	'imageadjustment' => { 257 => 0x80, 306 => 0x5 },
	'imagealterationconstraints' => { 357 => 'ImageAlterationConstraints' },
	'imagearea' => { 247 => 0x2b, 284 => 0x2b, 292 => 0x10, 295 => 0x10 },
	'imageareaoffset' => { 410 => 0x38 },
	'imageauthentication' => { 257 => 0x20 },
	'imageboundary' => { 257 => 0x16 },
	'imagecapturerequestid' => { 1 => 0x20 },
	'imagecapturetype' => { 1 => 0x14 },
	'imagecount' => { 134 => 0x1438, 257 => 0xa5, 483 => 0x11b },
	'imagecreator' => { 357 => 'ImageCreator' },
	'imagecreatorid' => { 357 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 357 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 357 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 156 => 0x41f },
	'imagecropy' => { 156 => 0x420 },
	'imagedata' => { 146 => 'Data' },
	'imagedatasize' => { 257 => 0xa2 },
	'imagedescription' => { 126 => 0x10e, 561 => 'ImageDescription' },
	'imageduplicationconstraints' => { 357 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 317 => 0xfe443a45 },
	'imageeditcount' => { 410 => 0x41 },
	'imageediting' => { 410 => 0x32 },
	'imageeditingsoftware' => { 126 => 0xa43b, 542 => 'ImageEditingSoftware' },
	'imageeditor' => { 126 => 0xa438, 542 => 'ImageEditor' },
	'imageeffects' => { 446 => 0x1010 },
	'imagefileconstraints' => { 357 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 357 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 357 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 134 => 0x1436 },
	'imageheight' => { 126 => 0x101, 144 => 'ImageHeight', 206 => 0xc, 419 => 0x10d, 561 => 'ImageLength' },
	'imagehistory' => { 126 => 0x9213, 540 => 'ImageHistory' },
	'imageidnumber' => { 366 => 0x340 },
	'imagemimetype' => { 146 => 'Mime' },
	'imagenumber' => { 126 => 0x9211, 174 => 'ImageNumber', 200 => 0xae, 201 => 0x5e, 419 => 0x113, 466 => 0x9b, 468 => [0x400,'276.1',0x314], 532 => 'ImageNumber' },
	'imagenumber2' => { 201 => 0x62 },
	'imageoptimization' => { 257 => 0xa9 },
	'imageorientation' => { 149 => 0x83 },
	'imageprocessing' => { 257 => 0x1a },
	'imageprocessingfiledatecreated' => { 156 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 156 => 0xc80 },
	'imageprocessingflags' => { 1 => 0x19 },
	'imageprocessingversion' => { 350 => 0x0 },
	'imagequality' => { 174 => 'ImageQuality', 294 => '723.2', 295 => '732.2', 303 => '708.1', 371 => 0x1 },
	'imagequality2' => { 346 => 0x603 },
	'imagerank' => { 523 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 156 => 0x600 },
	'imagerboardversion' => { 156 => 0x439 },
	'imagercols' => { 156 => 0x17d4 },
	'imageref' => { 547 => 'ImageRef' },
	'imageregion' => { 549 => 'ImageRegion' },
	'imageregionboundary' => { 549 => [\'ImageRegion','ImageRegionRegionBoundary'] },
	'imageregionboundaryh' => { 549 => [\'ImageRegion','ImageRegionRegionBoundaryRbH'] },
	'imageregionboundaryrx' => { 549 => [\'ImageRegion','ImageRegionRegionBoundaryRbRx'] },
	'imageregionboundaryshape' => { 549 => [\'ImageRegion','ImageRegionRegionBoundaryRbShape'] },
	'imageregionboundaryunit' => { 549 => [\'ImageRegion','ImageRegionRegionBoundaryRbUnit'] },
	'imageregionboundaryvertices' => { 549 => [\'ImageRegion','ImageRegionRegionBoundaryRbVertices'] },
	'imageregionboundaryverticesx' => { 549 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbX'] },
	'imageregionboundaryverticesy' => { 549 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbY'] },
	'imageregionboundaryw' => { 549 => [\'ImageRegion','ImageRegionRegionBoundaryRbW'] },
	'imageregionboundaryx' => { 549 => [\'ImageRegion','ImageRegionRegionBoundaryRbX'] },
	'imageregionboundaryy' => { 549 => [\'ImageRegion','ImageRegionRegionBoundaryRbY'] },
	'imageregionctype' => { 549 => [\'ImageRegion','ImageRegionRCtype'] },
	'imageregionctypeidentifier' => { 549 => [\'ImageRegion','ImageRegionRCtypeIdentifier'] },
	'imageregionctypename' => { 549 => [\'ImageRegion','ImageRegionRCtypeName'] },
	'imageregionid' => { 549 => [\'ImageRegion','ImageRegionRId'] },
	'imageregionname' => { 549 => [\'ImageRegion','ImageRegionName'] },
	'imageregionrole' => { 549 => [\'ImageRegion','ImageRegionRRole'] },
	'imageregionroleidentifier' => { 549 => [\'ImageRegion','ImageRegionRRoleIdentifier'] },
	'imageregionrolename' => { 549 => [\'ImageRegion','ImageRegionRRoleName'] },
	'imageresolution' => { 156 => 0x944 },
	'imageresolutionjpg' => { 156 => 0x945 },
	'imagereview' => { 326 => '0.4', 335 => '0.4' },
	'imagereviewmonitorofftime' => { 325 => '21.1', 327 => '21.1', 328 => '21.1', 332 => '20.1', 337 => '21.1', 338 => '21.1', 340 => 0x3b, 341 => 0x39, 342 => 0x39, 343 => 0x39 },
	'imagereviewtime' => { 324 => '25.1', 326 => '2.1', 329 => '19.1', 330 => '20.1', 331 => '20.1', 333 => '9.2', 334 => '20.1', 339 => '21.2' },
	'imagerfiledatecreated' => { 156 => 0x9c5 },
	'imagerfileproductionlevel' => { 156 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 156 => 0x9c7 },
	'imagerotated' => { 169 => 0x2a },
	'imagerpowerondelaymsec' => { 156 => 0x5fd },
	'imagerrows' => { 156 => 0x17de },
	'imagesegmentlines' => { 156 => 0x184d },
	'imagesegmentstartline' => { 156 => 0x184c },
	'imagesequenceinfo' => { 126 => 0xcd44 },
	'imagesize' => { 180 => 'ImageSize' },
	'imagesizeraw' => { 257 => 0x3e },
	'imagesizerestriction' => { 558 => 'imageSizeRestriction' },
	'imagesourcedata' => { 126 => 0x935c },
	'imagespace' => { 156 => 0x909 },
	'imagestabilization' => { 38 => 0x22, 120 => 0x3020, 134 => 0x1422, 174 => 'ImageStabilization', 200 => 0xbd, 201 => 0x71, 202 => 0x57, 203 => 0x0, 204 => [0x18,0x107,0x113], 205 => 0x49c2, 257 => 0xac, 346 => 0x604, 349 => 0x1600, 371 => 0x1a, 471 => 0x12, 472 => 0x11, 480 => 0xb026 },
	'imagestabilization2' => { 470 => 0xa },
	'imagestabilizationsetting' => { 205 => 0x14, 466 => 0x3d, 467 => 0x3d, 477 => 0x14 },
	'imagestats' => { 126 => 0xcd46 },
	'imagestyle' => { 466 => 0x2d, 467 => 0x27 },
	'imagesupplier' => { 357 => 'ImageSupplier' },
	'imagesupplierid' => { 357 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 357 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 357 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 128 => 0x1 },
	'imagetemperaturemin' => { 128 => 0x2 },
	'imagetitle' => { 126 => 0xa436, 542 => 'ImageTitle' },
	'imagetone' => { 410 => 0x4f },
	'imagetype' => { 149 => 0x82, 357 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 70 => 0x28, 126 => 0xa420, 540 => 'ImageUniqueID', 541 => 'ImageUniqueID', 542 => 'ImageUniqueID' },
	'imagewidth' => { 126 => 0x100, 144 => 'ImageWidth', 206 => 0xe, 419 => 0x10c, 561 => 'ImageWidth' },
	'inclinationangle' => { 517 => 0x900f },
	'inclinationcorrection' => { 517 => 0x900e },
	'incrementaltemperature' => { 535 => 'IncrementalTemperature', 537 => 'IncrementalTemperature' },
	'incrementaltint' => { 535 => 'IncrementalTint', 537 => 'IncrementalTint' },
	'industry' => { 555 => 'industry', 556 => 'industry' },
	'infobuttonwhenshooting' => { 91 => 0x409 },
	'information' => { 430 => 'information', 436 => "\xa9inf" },
	'infourl' => { 436 => 'infu' },
	'infraredilluminator' => { 438 => 0x28 },
	'ingredientexclusion' => { 557 => 'ingredientExclusion' },
	'ingredients' => { 566 => 'Ingredients' },
	'ingredientsalternatepaths' => { 566 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 566 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 566 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 566 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 566 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 566 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 566 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 566 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 566 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 566 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 566 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 566 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 566 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 566 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 566 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 566 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 566 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 566 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 566 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 566 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 566 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 566 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 566 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 91 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 147 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 147 => 'InitialHorizontalFOVDegrees' },
	'initialkey' => { 197 => 'WM/InitialKey' },
	'initialverticalfovdegrees' => { 147 => 'InitialVerticalFOVDegrees' },
	'initialviewheadingdegrees' => { 147 => 'InitialViewHeadingDegrees', 148 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 147 => 'InitialViewPitchDegrees', 148 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 147 => 'InitialViewRollDegrees', 148 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 324 => '4.4' },
	'initialzoomsetting' => { 324 => '9.3', 333 => '27.3' },
	'inkset' => { 126 => 0x14c },
	'inputprofile' => { 156 => 0x1389 },
	'instanceid' => { 566 => 'InstanceID' },
	'instantplaybacksetup' => { 202 => 0x3e },
	'instantplaybacktime' => { 202 => 0x3d },
	'instructions' => { 553 => 'Instructions' },
	'instrument' => { 565 => 'instrument' },
	'integrationtime' => { 156 => 0x423 },
	'intellectualgenre' => { 548 => 'IntellectualGenre' },
	'intelligentauto' => { 480 => 0xb052, 508 => 0xd, 509 => 0xe, 510 => 0xd },
	'intelligentcontrast' => { 57 => 0x4 },
	'intelligentd-range' => { 371 => 0x79 },
	'intelligentexposure' => { 371 => 0x5d },
	'intelligentresolution' => { 371 => 0x70 },
	'interchangecolorspace' => { 151 => 0x40 },
	'intergraphmatrix' => { 126 => 0x8480 },
	'internalflash' => { 199 => 0x2b, 324 => '23.1', 326 => '8.1', 329 => '22.1', 331 => '23.1', 335 => '8.1', 339 => '24.1', 349 => 0x1208 },
	'internalflashae1' => { 351 => 0x1021 },
	'internalflashae1_0' => { 351 => 0x101d },
	'internalflashae2' => { 351 => 0x1022 },
	'internalflashae2_0' => { 351 => 0x101e },
	'internalflashmode' => { 397 => 0x1 },
	'internalflashstrength' => { 397 => 0x3 },
	'internalflashtable' => { 351 => 0x1024 },
	'internallensserialnumber' => { 453 => 0xa005 },
	'internalndfilter' => { 371 => 0x9d },
	'internalserialnumber' => { 70 => 0x96, 82 => 0x9, 134 => 0x10, 205 => 0x49dc, 344 => 0x18, 347 => 0x102, 368 => 0x500, 371 => 0x25, 388 => 0x4, 446 => 0x5, 499 => [0x7c,0xf0], 500 => 0x88, 501 => [0x88,0x8a], 502 => 0x38 },
	'interopindex' => { 126 => 0x1, 542 => 'InteroperabilityIndex' },
	'interopversion' => { 126 => 0x2 },
	'interval' => { 282 => 0x20 },
	'intervaldurationhours' => { 261 => 0x1dc, 262 => 0xa0, 263 => 0xb8 },
	'intervaldurationminutes' => { 261 => 0x1e0, 262 => 0xa4, 263 => 0xbc },
	'intervaldurationseconds' => { 261 => 0x1e4, 262 => 0xa8, 263 => 0xc0 },
	'intervalexposuresmoothing' => { 246 => 0x184, 261 => 0x1f4, 262 => 0xb8, 263 => 0xd0 },
	'intervalframe' => { 282 => 0x24 },
	'intervallength' => { 199 => 0x10 },
	'intervalmode' => { 199 => 0x26 },
	'intervalnumber' => { 199 => 0x11 },
	'intervalpriority' => { 246 => 0x186, 261 => 0x1f6, 262 => 0xba, 263 => 0xd2 },
	'intervals' => { 246 => 0x17c, 261 => 0x1ec, 262 => 0xb0, 263 => 0xc8, 266 => 0xbc, 267 => 0xcc, 268 => 0xcc },
	'intervalshooting' => { 247 => 0x24, 284 => 0x24, 285 => 0x28, 410 => 0x92 },
	'introtime' => { 565 => 'introTime' },
	'introtimescale' => { 565 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 565 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 156 => 0xdae },
	'ipfcameramodel' => { 156 => 0xe4d },
	'iptc' => { 127 => 'IPTC' },
	'iptc-naa' => { 126 => 0x83bb, 376 => 0x83bb },
	'iptcbitspersample' => { 151 => 0x56 },
	'iptcdigest' => { 424 => 0x425 },
	'iptcimageheight' => { 151 => 0x1e },
	'iptcimagerotation' => { 151 => 0x66 },
	'iptcimagewidth' => { 151 => 0x14 },
	'iptclastedited' => { 549 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 151 => 0xa },
	'iptcpixelheight' => { 151 => 0x32 },
	'iptcpixelwidth' => { 151 => 0x28 },
	'isalternativeof' => { 555 => 'isAlternativeOf' },
	'isbn' => { 555 => 'isbn' },
	'iscorrectionof' => { 555 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 116 => 0x3 },
	'ismergedhdr' => { 532 => 'IsMergedHDR' },
	'ismergedpanorama' => { 532 => 'IsMergedPanorama' },
	'iso' => { 7 => 0x6, 9 => 0x6, 10 => 0x75, 11 => 0x6, 12 => 0x79, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x6, 31 => 0x0, 32 => 0x1, 119 => 0x14, 120 => [0x3014,0x14], 126 => 0x8827, 155 => 0xfd06, 156 => 0x1784, 158 => 0x60, 160 => [0xfa2e,0xfa46], 161 => [0x27,0x28], 162 => 0xf105, 165 => 0x14, 167 => 0x4e, 169 => 0x1e, 170 => 0x1a, 172 => 0x34, 174 => 'ISO', 199 => 0x8, 205 => 0x49ba, 245 => 0x0, 257 => 0x2, 371 => 0xd1, 376 => [0x17,0x37], 410 => [0x8b,0x14], 417 => 0x14, 419 => 0x105, 453 => 0xa014, 456 => 0x86, 477 => 0x6f, 485 => [0x1f,0x21,0x25], 541 => 'ISOSpeedRatings' },
	'iso2' => { 245 => 0x6, 289 => 0x265, 290 => 0x25c, 291 => 0x265, 292 => 0x221, 293 => 0x25d, 294 => 0x256, 295 => 0x25d, 298 => 0x2b5, 301 => 0x265, 305 => 0x2b5 },
	'isoauto' => { 389 => '14.4' },
	'isoautoflashlimit' => { 263 => 0x156, 266 => 0x146, 267 => 0x15a, 268 => 0x15a },
	'isoautohilimit' => { 244 => 0x5, 261 => 0x28a, 263 => 0x154, 266 => 0x144, 267 => 0x158, 268 => 0x158, 287 => 0x5, 297 => 0x18eb },
	'isoautomax' => { 479 => 0x4 },
	'isoautomin' => { 479 => 0x2 },
	'isoautominspeed' => { 410 => 0x7a },
	'isoautosettings' => { 346 => 0x821 },
	'isoautoshuttertime' => { 244 => 0x4, 263 => 0x15e, 266 => 0x14e, 267 => 0x162, 268 => 0x162, 287 => 0x4, 297 => 0x18ea },
	'isobutton' => { 268 => 0x796 },
	'isocalibrationgain' => { 156 => 0x89f },
	'isodisplay' => { 327 => '4.1', 328 => '4.1', 329 => '2.3', 330 => '3.3', 331 => '3.3', 334 => '3.3', 337 => '4.3', 338 => '4.1', 339 => '4.3' },
	'isoexpansion' => { 91 => 0x103, 92 => 0x7, 93 => 0x8, 96 => 0x8, 245 => 0x4 },
	'isoexpansion2' => { 245 => 0xa },
	'isofloor' => { 389 => 0x6 },
	'isoselected' => { 370 => 0x359 },
	'isoselection' => { 257 => 0xf },
	'isosensitivitystep' => { 332 => '6.2', 334 => '6.2' },
	'isosetting' => { 158 => 0x5e, 170 => 0x14, 174 => 'ISOSetting', 199 => 0x24, 200 => 0x26, 201 => 0x1c, 202 => 0x13, 207 => 0x6, 257 => 0x13, 389 => '17.3', 445 => 0x27, 466 => 0x16, 467 => 0x14, 468 => 0x2, 477 => 0x6d, 479 => 0x0 },
	'isospeed' => { 126 => 0x8833, 542 => 'ISOSpeed' },
	'isospeedexpansion' => { 90 => 0x3 },
	'isospeedincrements' => { 91 => 0x102 },
	'isospeedlatitudeyyy' => { 126 => 0x8834, 542 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 126 => 0x8835, 542 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 91 => 0x103 },
	'isostepsize' => { 324 => '6.1', 325 => '7.2', 327 => '7.2', 328 => '7.2', 333 => '4.1', 337 => '7.2', 338 => '7.2', 340 => 0x14d, 341 => 0x15d, 342 => 0x15d, 343 => 0x175 },
	'isovalue' => { 351 => 0x1001 },
	'isrc' => { 428 => 'xid ' },
	'isrccode' => { 436 => "\xa9isr" },
	'issn' => { 555 => 'issn' },
	'issueidentifier' => { 555 => 'issueIdentifier' },
	'issuename' => { 555 => 'issueName' },
	'issueteaser' => { 555 => 'issueTeaser' },
	'issuetype' => { 555 => 'issueType' },
	'istranslationof' => { 555 => 'isTranslationOf' },
	'itemsubtype' => { 196 => 'ItemSubType' },
	'itunesu' => { 428 => 'itnu' },
	'jobid' => { 149 => 0xb8 },
	'jobname' => { 543 => 'JobName' },
	'jobref' => { 564 => 'JobRef' },
	'jobrefid' => { 564 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 564 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 564 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 543 => 'JobStatus' },
	'jpeg-heifswitch' => { 480 => 0x2039 },
	'jpeghandling' => { 535 => 'JPEGHandling', 537 => 'JPEGHandling' },
	'jpegquality' => { 10 => 0x66, 371 => 0x43, 373 => 0x3034, 480 => 0xb047 },
	'jpegsize' => { 373 => 0x303a },
	'jpgcompression' => { 248 => 0x24, 257 => 0x44, 292 => '671.1' },
	'jpgfromraw' => { 104 => 0x2007, 121 => 'Exif-JpgFromRaw', 376 => 0x2e },
	'jpgfromrawlength' => { 126 => [0x117,0x202] },
	'jpgfromrawstart' => { 126 => [0x111,0x201] },
	'jpgrecordedpixels' => { 389 => '14.1' },
	'jurisdiction' => { 533 => 'jurisdiction' },
	'jxldecodespeed' => { 126 => 0xcd4b },
	'jxldistance' => { 126 => 0xcd49 },
	'jxleffort' => { 126 => 0xcd4a },
	'keepexposure' => { 341 => 0x237, 342 => 0x237, 343 => 0x24f },
	'kelvinwb_01' => { 398 => 0x5 },
	'kelvinwb_02' => { 398 => 0x9 },
	'kelvinwb_03' => { 398 => 0xd },
	'kelvinwb_04' => { 398 => 0x11 },
	'kelvinwb_05' => { 398 => 0x15 },
	'kelvinwb_06' => { 398 => 0x19 },
	'kelvinwb_07' => { 398 => 0x1d },
	'kelvinwb_08' => { 398 => 0x21 },
	'kelvinwb_09' => { 398 => 0x25 },
	'kelvinwb_10' => { 398 => 0x29 },
	'kelvinwb_11' => { 398 => 0x2d },
	'kelvinwb_12' => { 398 => 0x31 },
	'kelvinwb_13' => { 398 => 0x35 },
	'kelvinwb_14' => { 398 => 0x39 },
	'kelvinwb_15' => { 398 => 0x3d },
	'kelvinwb_16' => { 398 => 0x41 },
	'kelvinwb_daylight' => { 398 => 0x1 },
	'kerneldenominators' => { 156 => 0x933 },
	'key' => { 565 => 'key' },
	'keystonecompensation' => { 350 => 0x1900 },
	'keystonedirection' => { 350 => 0x1901 },
	'keystonevalue' => { 350 => 0x1906 },
	'keyword' => { 428 => 'keyw', 555 => 'keyword' },
	'keywordinfo' => { 189 => 'Keywords' },
	'keywords' => { 149 => 0x19, 175 => 'Keywords', 356 => 'Keywords', 426 => 'Keywords', 430 => 'keywords', 529 => 'keywords', 551 => 'Keywords', 563 => 'Keywords' },
	'killdate' => { 555 => 'killDate' },
	'killdatea-platform' => { 555 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 555 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 155 => 0xf908, 158 => 0xe, 160 => [0xfa1e,0xfa52], 166 => 0x70 },
	'kodakimagewidth' => { 155 => 0xf907, 158 => 0xc, 160 => [0xfa1d,0xfa51], 166 => 0x6c },
	'kodakinfotype' => { 155 => 0xfa00 },
	'kodaklook' => { 156 => 0xe4c },
	'kodaklookprofile' => { 156 => 0x138a },
	'kodakmaker' => { 166 => 0x8 },
	'kodakmodel' => { 158 => 0x0, 166 => 0x28 },
	'kodaktag' => { 156 => 0x3ea },
	'kodakversion' => { 156 => 0x0 },
	'label' => { 360 => 'Label', 563 => 'Label' },
	'labelname1' => { 547 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 547 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 547 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 547 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 547 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 547 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 371 => 0x6f },
	'landscapeoutputhighlightpoint' => { 116 => 0x26 },
	'landscapeoutputshadowpoint' => { 116 => 0x27 },
	'landscaperawcolortone' => { 116 => 0x1f },
	'landscaperawcontrast' => { 116 => 0x21 },
	'landscaperawhighlight' => { 116 => 0x77 },
	'landscaperawhighlightpoint' => { 116 => 0x24 },
	'landscaperawlinear' => { 116 => 0x22 },
	'landscaperawsaturation' => { 116 => 0x20 },
	'landscaperawshadow' => { 116 => 0x80 },
	'landscaperawshadowpoint' => { 116 => 0x25 },
	'landscaperawsharpness' => { 116 => 0x23 },
	'landscapeunsharpmaskfineness' => { 116 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 116 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 116 => 0xa2 },
	'language' => { 261 => 0x8fc, 264 => 0x6a2, 265 => 0x6a2, 266 => 0x592, 267 => 0x5c2, 268 => 0x5da, 538 => 'language' },
	'languageidentifier' => { 149 => 0x87 },
	'largestvalidinteriorrectheight' => { 147 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 147 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 147 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 147 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 199 => 0x1b },
	'lastkeywordiptc' => { 196 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 196 => 'LastKeywordXMP' },
	'lastphotodate' => { 147 => 'LastPhotoDate' },
	'lasturl' => { 566 => 'LastURL' },
	'lateralchromaticaberration' => { 480 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 532 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 125 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 125 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 125 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 125 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 125 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 123 => 'Latitude' },
	'lc1' => { 400 => 0x2 },
	'lc10' => { 400 => 0xb },
	'lc11' => { 400 => 0xc },
	'lc12' => { 400 => 0xd },
	'lc14' => { 400 => 0xf },
	'lc15' => { 400 => 0x10 },
	'lc3' => { 400 => 0x4 },
	'lc4' => { 400 => 0x5 },
	'lc5' => { 400 => 0x6 },
	'lc6' => { 400 => 0x7 },
	'lc7' => { 400 => 0x8 },
	'lc8' => { 400 => 0x9 },
	'lcddisplayatpoweron' => { 91 => 0x811, 95 => 0xa },
	'lcddisplayreturntoshoot' => { 96 => 0x12 },
	'lcdillumination' => { 324 => '17.5', 325 => '5.2', 327 => '5.1', 328 => '5.1', 333 => '10.3', 334 => '4.2', 337 => '5.2', 338 => '5.1', 339 => '5.4', 340 => 0xf1, 341 => 0x101, 342 => 0x101, 343 => 0x117 },
	'lcdilluminationduringbulb' => { 91 => 0x408 },
	'lcdmatrix' => { 156 => 0xe74 },
	'lcdmatrixchickfix' => { 156 => 0xe75 },
	'lcdmatrixmarvin' => { 156 => 0xe76 },
	'lcdpanels' => { 90 => 0x8 },
	'lcheditor' => { 317 => 0x8ae85e },
	'legacyiptcdigest' => { 553 => 'LegacyIPTCDigest' },
	'legalcode' => { 533 => 'legalcode' },
	'lens' => { 126 => 0xfdea, 257 => 0x84, 532 => 'Lens' },
	'lensafstopbutton' => { 89 => 0x11, 90 => 0x13, 91 => 0x506, 92 => 0x10, 93 => 0x12, 96 => 0x13, 97 => 0x9 },
	'lensaperturerange' => { 456 => [0x30,0x48] },
	'lensblur' => { 535 => 'LensBlur', 537 => 'LensBlur' },
	'lensbluractive' => { 535 => [\'LensBlur','LensBlurActive'], 537 => [\'LensBlur','LensBlurActive'] },
	'lensbluramount' => { 535 => [\'LensBlur','LensBlurBlurAmount'], 537 => [\'LensBlur','LensBlurBlurAmount'] },
	'lensblurbokehaspect' => { 535 => [\'LensBlur','LensBlurBokehAspect'], 537 => [\'LensBlur','LensBlurBokehAspect'] },
	'lensblurbokehrotation' => { 535 => [\'LensBlur','LensBlurBokehRotation'], 537 => [\'LensBlur','LensBlurBokehRotation'] },
	'lensblurbokehshape' => { 535 => [\'LensBlur','LensBlurBokehShape'], 537 => [\'LensBlur','LensBlurBokehShape'] },
	'lensblurbokehshapedetail' => { 535 => [\'LensBlur','LensBlurBokehShapeDetail'], 537 => [\'LensBlur','LensBlurBokehShapeDetail'] },
	'lensblurcateyeamount' => { 535 => [\'LensBlur','LensBlurCatEyeAmount'], 537 => [\'LensBlur','LensBlurCatEyeAmount'] },
	'lensblurcateyescale' => { 535 => [\'LensBlur','LensBlurCatEyeScale'], 537 => [\'LensBlur','LensBlurCatEyeScale'] },
	'lensblurfocalrange' => { 535 => [\'LensBlur','LensBlurFocalRange'], 537 => [\'LensBlur','LensBlurFocalRange'] },
	'lensblurfocalrangesource' => { 535 => [\'LensBlur','LensBlurFocalRangeSource'], 537 => [\'LensBlur','LensBlurFocalRangeSource'] },
	'lensblurhighlightsboost' => { 535 => [\'LensBlur','LensBlurHighlightsBoost'], 537 => [\'LensBlur','LensBlurHighlightsBoost'] },
	'lensblurhighlightsthreshold' => { 535 => [\'LensBlur','LensBlurHighlightsThreshold'], 537 => [\'LensBlur','LensBlurHighlightsThreshold'] },
	'lensblursampledarea' => { 535 => [\'LensBlur','LensBlurSampledArea'], 537 => [\'LensBlur','LensBlurSampledArea'] },
	'lensblursampledrange' => { 535 => [\'LensBlur','LensBlurSampledRange'], 537 => [\'LensBlur','LensBlurSampledRange'] },
	'lensblursphericalaberration' => { 535 => [\'LensBlur','LensBlurSphericalAberration'], 537 => [\'LensBlur','LensBlurSphericalAberration'] },
	'lensblursubjectrange' => { 535 => [\'LensBlur','LensBlurSubjectRange'], 537 => [\'LensBlur','LensBlurSubjectRange'] },
	'lensblurversion' => { 535 => [\'LensBlur','LensBlurVersion'], 537 => [\'LensBlur','LensBlurVersion'] },
	'lenscontrolring' => { 340 => 0xb1, 341 => 0xad, 342 => 0xad, 343 => 0xad },
	'lenscorrectionsettings' => { 540 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 532 => 'LensDistortInfo' },
	'lensdistortionparams' => { 351 => 0x206 },
	'lensdriveend' => { 255 => 0x56 },
	'lensdrivenoaf' => { 91 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 468 => 0x3f0, 516 => 0xd },
	'lensfirmware' => { 447 => 0x20, 453 => 0xa004 },
	'lensfirmwareversion' => { 255 => 0x34, 347 => 0x204, 371 => 0x60, 468 => 0x3f3, 516 => 0x14 },
	'lensfocallength' => { 110 => 0xf0512, 400 => 0x9 },
	'lensfocalrange' => { 456 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 325 => '55.1', 327 => '52.1', 328 => '52.1', 337 => '52.1', 338 => '52.1' },
	'lensformat' => { 493 => 0x1891, 495 => 0x18bd, 496 => 0x18ed, 497 => 0x17f1, 499 => 0x106, 500 => 0x106, 511 => 0x603, 512 => 0x5d },
	'lensfstops' => { 249 => 0x7, 250 => 0xc, 251 => 0xd, 255 => 0xe, 257 => 0x8b, 400 => '0.3' },
	'lensfunc1button' => { 340 => 0xa3, 341 => 0x9f, 342 => 0x9f, 343 => 0x9f },
	'lensfunc1buttonplaybackmode' => { 265 => 0x80a, 268 => 0x810 },
	'lensfunc2button' => { 340 => 0xab, 341 => 0xa7, 342 => 0xa7, 343 => 0xa7 },
	'lensfunc2buttonplaybackmode' => { 265 => 0x80c, 268 => 0x812 },
	'lensid' => { 255 => 0x30, 532 => 'LensID' },
	'lensidnumber' => { 249 => 0x6, 250 => 0xb, 251 => 0xc, 255 => 0xd },
	'lensinfo' => { 126 => 0xa432, 406 => 0x2a, 532 => 'LensInfo', 542 => 'LensSpecification' },
	'lenskind' => { 400 => 0x1 },
	'lensmake' => { 126 => 0xa433, 181 => 'Make', 542 => 'LensMake' },
	'lensmanualdistortionamount' => { 535 => 'LensManualDistortionAmount', 537 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 196 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 456 => 0x2b },
	'lensmodel' => { 7 => 0x937, 14 => 0x92b, 15 => 0x933, 70 => 0x95, 126 => 0xa434, 181 => 'Model', 196 => 'LensModel', 252 => 0x18a, 253 => 0x18b, 254 => 0x2ac, 347 => 0x203, 406 => 0xc, 419 => 0x412, 437 => 'camera.lens_model', 542 => 'LensModel' },
	'lensmodulationoptimizer' => { 134 => 0x1045 },
	'lensmount' => { 468 => 0x99, 493 => 0x1892, 495 => 0x18be, 496 => 0x18ee, 497 => 0x17f2, 499 => 0x105, 500 => 0x105, 511 => 0x604, 512 => 0x5e },
	'lensmount2' => { 516 => 0x8 },
	'lensmounttype' => { 255 => 0x5f },
	'lenspositionabsolute' => { 255 => 0x5a },
	'lensprofilechromaticaberrationscale' => { 535 => 'LensProfileChromaticAberrationScale', 537 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 535 => 'LensProfileDigest', 537 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 535 => 'LensProfileDistortionScale', 537 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 535 => 'LensProfileEnable', 537 => 'LensProfileEnable' },
	'lensprofilefilename' => { 535 => 'LensProfileFilename', 537 => 'LensProfileFilename' },
	'lensprofileisembedded' => { 535 => 'LensProfileIsEmbedded', 537 => 'LensProfileIsEmbedded' },
	'lensprofilematchkeycameramodelname' => { 535 => 'LensProfileMatchKeyCameraModelName', 537 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 535 => 'LensProfileMatchKeyExifMake', 537 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 535 => 'LensProfileMatchKeyExifModel', 537 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 535 => 'LensProfileMatchKeyIsRaw', 537 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 535 => 'LensProfileMatchKeyLensID', 537 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 535 => 'LensProfileMatchKeyLensInfo', 537 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 535 => 'LensProfileMatchKeyLensName', 537 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 535 => 'LensProfileMatchKeySensorFormatFactor', 537 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 370 => 0x370, 535 => 'LensProfileName', 537 => 'LensProfileName' },
	'lensprofilesetup' => { 535 => 'LensProfileSetup', 537 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 535 => 'LensProfileVignettingScale', 537 => 'LensProfileVignettingScale' },
	'lensproperties' => { 347 => 0x20b },
	'lensserialnumber' => { 21 => 0x164, 36 => 0x16b, 66 => 0x0, 126 => 0xa435, 181 => 'SerialNumber', 347 => 0x202, 369 => 0x321, 371 => 0x52, 436 => 'LENS', 447 => 0x30, 532 => 'LensSerialNumber', 542 => 'LensSerialNumber' },
	'lensshutterlock' => { 202 => 0x4a },
	'lensspec' => { 463 => 0x0, 464 => 0x0, 465 => 0x0, 480 => 0xb02a },
	'lensspecfeatures' => { 499 => [0x115,0x116], 500 => [0x116,0x1ed,0x1f0,0x21c,0x21e] },
	'lenstemperature' => { 351 => 0x1008 },
	'lenstype' => { 7 => 0xe2, 8 => 0xd, 9 => 0x1a7, 10 => 0xc, 11 => 0x111, 12 => 0xc, 13 => 0x14f, 14 => 0xd6, 15 => 0xde, 16 => 0xf6, 17 => 0xea, 18 => 0xff, 19 => [0xc,0x97], 20 => 0xe6, 21 => 0x153, 22 => 0xea, 23 => 0xe8, 24 => 0x127, 25 => 0x161, 26 => 0x166, 27 => 0x184, 28 => 0x112, 29 => 0x189, 38 => 0x16, 204 => 0x10c, 205 => 0x49bd, 257 => 0x83, 347 => 0x201, 362 => 0x16, 366 => 0x310, 368 => 0x303, 369 => 0x303, 371 => 0x51, 373 => 0x3405, 401 => 0x0, 402 => 0x0, 403 => 0x1, 404 => 0x1, 405 => 0x1, 407 => 0x0, 453 => 0xa003, 456 => 0x27, 480 => 0xb027, 493 => 0x1896, 495 => 0x18c2, 496 => 0x18f2, 497 => 0x17f6, 499 => 0x109, 500 => 0x109, 511 => 0x608, 512 => 0x62 },
	'lenstype2' => { 468 => 0x3f7, 493 => 0x1893, 495 => 0x18bf, 496 => 0x18ef, 497 => 0x17f3, 499 => 0x107, 500 => 0x107, 511 => 0x605, 512 => 0x60 },
	'lenstype3' => { 516 => 0x9 },
	'lenstypemake' => { 371 => 0xc4 },
	'lenstypemodel' => { 371 => [0xc5,0xe4] },
	'lenszoomposition' => { 508 => 0x19, 509 => 0x1e, 512 => [0x342,0x34e,0x35a] },
	'levelindicator' => { 379 => 0x15 },
	'levelmeter' => { 436 => ['Lvlm','lvlm'] },
	'levelorientation' => { 408 => 0x0 },
	'license' => { 533 => 'license' },
	'licensee' => { 357 => 'Licensee' },
	'licenseeid' => { 357 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 357 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 357 => 'LicenseeImageNotes' },
	'licenseename' => { 357 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 357 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 357 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 357 => 'LicenseeTransactionID' },
	'licenseid' => { 357 => 'LicenseID' },
	'licensestartdate' => { 357 => 'LicenseStartDate' },
	'licensetransactiondate' => { 357 => 'LicenseTransactionDate' },
	'licensetype' => { 539 => 'licensetype' },
	'licensor' => { 357 => 'Licensor' },
	'licensorcity' => { 357 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 357 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 357 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 357 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 357 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 357 => 'LicensorImageID' },
	'licensorname' => { 357 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 357 => 'LicensorNotes' },
	'licensorpostalcode' => { 357 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 357 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 357 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 357 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 357 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 357 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 357 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 357 => 'LicensorTransactionID' },
	'licensorurl' => { 357 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 351 => 0x1009 },
	'lightingmode' => { 120 => 0x302a },
	'lightreading' => { 410 => 0x15 },
	'lightsource' => { 126 => 0x9208, 257 => 0x90, 354 => 0x1000, 541 => 'LightSource' },
	'lightsourcespecial' => { 455 => 0x21d },
	'lightswitch' => { 337 => '0.1', 339 => '0.1' },
	'lightvaluecenter' => { 351 => 0x103d },
	'lightvalueperiphery' => { 351 => 0x103e },
	'limitaf-areamodesel3dtracking' => { 340 => 0x143, 341 => 0x153, 342 => 0x153, 343 => 0x16b },
	'limitaf-areamodeseldynamic_l' => { 340 => 0x141, 341 => 0x151, 342 => 0x151, 343 => 0x169 },
	'limitaf-areamodeseldynamic_m' => { 340 => 0x140, 341 => 0x150, 342 => 0x150, 343 => 0x168 },
	'limitaf-areamodeseldynamic_s' => { 340 => 0x13f, 341 => 0x14f, 342 => 0x14f, 343 => 0x167 },
	'limitaf-areamodeselpinpoint' => { 340 => 0x11, 341 => 0x11, 342 => 0x11, 343 => 0x11 },
	'limitaf-areamodeselwideaf_l' => { 340 => 0x14, 341 => 0x14, 342 => 0x14, 343 => 0x14 },
	'limitaf-areamodeselwideaf_s' => { 340 => 0x13, 341 => 0x13, 342 => 0x13, 343 => 0x13 },
	'limitafareamodeselauto' => { 340 => 0x15, 341 => 0x15, 342 => 0x15, 343 => 0x15 },
	'limitafareamodeselection' => { 325 => '51.1', 327 => '49.1', 328 => '49.1', 337 => '49.1', 338 => '49.1' },
	'limitreleasemodeselc120' => { 342 => '269.4', 343 => '293.4' },
	'limitreleasemodeselc30' => { 342 => '269.3', 343 => '293.3' },
	'limitreleasemodeselch' => { 342 => '269.2', 343 => '293.2' },
	'limitreleasemodeselcl' => { 342 => '269.1', 343 => '293.1' },
	'limitreleasemodeselself' => { 342 => '269.5', 343 => '293.5' },
	'limitselectableimagearea16to9' => { 340 => 0x4d, 341 => 0x47, 342 => 0x47, 343 => 0x47 },
	'limitselectableimagearea1to1' => { 340 => 0x4c, 341 => 0x46, 342 => 0x46, 343 => 0x46 },
	'limitselectableimageareadx' => { 340 => 0x4b, 341 => 0x45, 342 => 0x45, 343 => 0x45 },
	'linearitylimitblue' => { 376 => 0x10 },
	'linearitylimitgreen' => { 376 => 0xf },
	'linearitylimitred' => { 376 => 0xe },
	'linearityuppermargin' => { 45 => 0x32c, 46 => 0x282, 47 => 0x296, 50 => [0x2ba,0x2d1,0x2d5], 52 => 0x1e5, 53 => [0x1fe,0x2de], 54 => [0x232,0x310], 55 => 0x31e },
	'linearizationtable' => { 126 => 0xc618 },
	'linearresponselimit' => { 126 => 0xc62e },
	'link' => { 555 => 'link' },
	'linkaetoafpoint' => { 389 => '14.2' },
	'linkedencodedrightsexpr' => { 549 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 549 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 549 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 549 => 'LinkedEncRightsExpr' },
	'linkvrtofocuspoint' => { 261 => 0x3ec },
	'linlogcoring' => { 156 => 0x904 },
	'lithostratigraphicterms' => { 125 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'livephotoauto' => { 430 => 'live-photo.auto' },
	'livephotovideoindex' => { 1 => 0x17 },
	'livephotovitalityscore' => { 430 => 'live-photo.vitality-score' },
	'livephotovitalityscoringversion' => { 430 => 'live-photo.vitality-scoring-version' },
	'liveview' => { 382 => 0x1fa, 391 => 0x3 },
	'liveviewaf' => { 329 => '32.1', 339 => '34.1' },
	'liveviewafareamode' => { 334 => '34.1' },
	'liveviewafmethod' => { 485 => 0x20 },
	'liveviewafmode' => { 334 => '34.2' },
	'liveviewafsetting' => { 468 => 0x36 },
	'liveviewbuttonoptions' => { 325 => '50.2', 327 => '48.2', 328 => '48.2', 337 => '48.2', 338 => '48.2' },
	'liveviewexposuresimulation' => { 91 => 0x810 },
	'liveviewfocusmode' => { 468 => [0x8b,0x28b] },
	'liveviewmetering' => { 468 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 325 => '21.2', 327 => '21.2', 328 => '21.2', 330 => '20.2', 331 => '20.2', 332 => '20.2', 334 => '20.2', 337 => '21.2', 338 => '21.2' },
	'liveviewshooting' => { 62 => 0x13 },
	'livingspecimen' => { 125 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 125 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 149 => 0x79 },
	'localizedcameramodel' => { 126 => 0xc615 },
	'locallocationname' => { 453 => 0x30 },
	'location' => { 256 => 0x9, 371 => 0x67, 527 => 'Location', 548 => 'Location', 554 => 'location', 555 => 'location' },
	'locationaccuracyhorizontal' => { 430 => 'location.accuracy.horizontal' },
	'locationareacode' => { 534 => 'lac' },
	'locationbody' => { 430 => 'location.body' },
	'locationcreated' => { 549 => 'LocationCreated' },
	'locationcreatedcity' => { 549 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 549 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 549 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 549 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpsaltituderef' => { 549 => [\'LocationCreated','LocationCreatedGPSAltitudeRef'] },
	'locationcreatedgpslatitude' => { 549 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 549 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 549 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 549 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 549 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 549 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 549 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 549 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationdate' => { 430 => 'location.date' },
	'locationinformation' => { 436 => 'loci' },
	'locationinfoversion' => { 256 => 0x0 },
	'locationname' => { 430 => 'location.name', 453 => 0x31 },
	'locationnote' => { 430 => 'location.note' },
	'locationrole' => { 430 => 'location.role' },
	'locationshown' => { 549 => 'LocationShown' },
	'locationshowncity' => { 549 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 549 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 549 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 549 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpsaltituderef' => { 549 => [\'LocationShown','LocationShownGPSAltitudeRef'] },
	'locationshowngpslatitude' => { 549 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 549 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 549 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 549 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 549 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 549 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 549 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 549 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 91 => 0x709 },
	'logcomment' => { 565 => 'logComment' },
	'logscale' => { 156 => 0x902 },
	'longdescription' => { 428 => 'ldes' },
	'longexposurenoisereduction' => { 68 => 0x4, 91 => 0x201, 92 => 0x1, 93 => 0x2, 94 => 0x1, 95 => 0x1, 96 => 0x2, 97 => 0x1, 371 => 0x49, 466 => 0x2b, 467 => 0x25, 468 => 0x25, 480 => 0x2008, 485 => 0x11, 512 => 0x44 },
	'longexposurenoisereduction2' => { 62 => 0x8 },
	'longexposurenrused' => { 371 => 0xbe },
	'longitude' => { 123 => 'Longitude' },
	'look' => { 535 => 'Look', 537 => 'Look' },
	'lookamount' => { 535 => [\'Look','LookAmount'], 537 => [\'Look','LookAmount'] },
	'lookcluster' => { 535 => [\'Look','LookCluster'], 537 => [\'Look','LookCluster'] },
	'lookcopyright' => { 535 => [\'Look','LookCopyright'], 537 => [\'Look','LookCopyright'] },
	'lookgroup' => { 535 => [\'Look','LookGroup'], 537 => [\'Look','LookGroup'] },
	'lookname' => { 535 => 'LookName', 537 => 'LookName' },
	'lookparameters' => { 535 => [\'Look','LookParameters'], 537 => [\'Look','LookParameters'] },
	'lookparameterscameraprofile' => { 535 => [\'Look','LookParametersCameraProfile'], 537 => [\'Look','LookParametersCameraProfile'] },
	'lookparametersclarity2012' => { 535 => [\'Look','LookParametersClarity2012'], 537 => [\'Look','LookParametersClarity2012'] },
	'lookparametersconverttograyscale' => { 535 => [\'Look','LookParametersConvertToGrayscale'], 537 => [\'Look','LookParametersConvertToGrayscale'] },
	'lookparametershighlights2012' => { 535 => [\'Look','LookParametersHighlights2012'], 537 => [\'Look','LookParametersHighlights2012'] },
	'lookparameterslooktable' => { 535 => [\'Look','LookParametersLookTable'], 537 => [\'Look','LookParametersLookTable'] },
	'lookparametersprocessversion' => { 535 => [\'Look','LookParametersProcessVersion'], 537 => [\'Look','LookParametersProcessVersion'] },
	'lookparametersshadows2012' => { 535 => [\'Look','LookParametersShadows2012'], 537 => [\'Look','LookParametersShadows2012'] },
	'lookparameterstonecurvepv2012' => { 535 => [\'Look','LookParametersToneCurvePV2012'], 537 => [\'Look','LookParametersToneCurvePV2012'] },
	'lookparameterstonecurvepv2012blue' => { 535 => [\'Look','LookParametersToneCurvePV2012Blue'], 537 => [\'Look','LookParametersToneCurvePV2012Blue'] },
	'lookparameterstonecurvepv2012green' => { 535 => [\'Look','LookParametersToneCurvePV2012Green'], 537 => [\'Look','LookParametersToneCurvePV2012Green'] },
	'lookparameterstonecurvepv2012red' => { 535 => [\'Look','LookParametersToneCurvePV2012Red'], 537 => [\'Look','LookParametersToneCurvePV2012Red'] },
	'lookparametersversion' => { 535 => [\'Look','LookParametersVersion'], 537 => [\'Look','LookParametersVersion'] },
	'looksupportsamount' => { 535 => [\'Look','LookSupportsAmount'], 537 => [\'Look','LookSupportsAmount'] },
	'looksupportsmonochrome' => { 535 => [\'Look','LookSupportsMonochrome'], 537 => [\'Look','LookSupportsMonochrome'] },
	'looksupportsoutputreferred' => { 535 => [\'Look','LookSupportsOutputReferred'], 537 => [\'Look','LookSupportsOutputReferred'] },
	'lookuuid' => { 535 => [\'Look','LookUUID'], 537 => [\'Look','LookUUID'] },
	'loop' => { 565 => 'loop' },
	'loopstyle' => { 436 => 'LOOP' },
	'lowestbiostratigraphiczone' => { 125 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 535 => 'LuminanceAdjustmentAqua', 537 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 535 => 'LuminanceAdjustmentBlue', 537 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 535 => 'LuminanceAdjustmentGreen', 537 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 535 => 'LuminanceAdjustmentMagenta', 537 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 535 => 'LuminanceAdjustmentOrange', 537 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 535 => 'LuminanceAdjustmentPurple', 537 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 535 => 'LuminanceAdjustmentRed', 537 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 535 => 'LuminanceAdjustmentYellow', 537 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 115 => 0x150 },
	'luminancecurvepoints' => { 115 => 0x126 },
	'luminancenoiseamplitude' => { 1 => 0x1d },
	'luminancenoisereduction' => { 110 => 0x20600, 116 => 0x5f, 456 => 0x1b },
	'luminancenoisereductioncontrast' => { 535 => 'LuminanceNoiseReductionContrast', 537 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 535 => 'LuminanceNoiseReductionDetail', 537 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 116 => 0x6d },
	'luminancesmoothing' => { 535 => 'LuminanceSmoothing', 537 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 91 => [0x40b,0x40c] },
	'lyrics' => { 428 => "\xa9lyr", 436 => "\xa9lyr", 565 => 'lyrics' },
	'lyricsuri' => { 436 => 'lrcu' },
	'm16cversion' => { 366 => 0x333 },
	'macatom' => { 536 => 'macAtom' },
	'macatomapplicationcode' => { 536 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 536 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 536 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 125 => 'MachineObservation' },
	'machineobservationday' => { 125 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 125 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 125 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 125 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 125 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 125 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 125 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationeventtype' => { 125 => [\'MachineObservation','MachineObservationEventType'] },
	'machineobservationfieldnotes' => { 125 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 125 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 125 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 125 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 125 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 125 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 125 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 125 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 125 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 125 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 125 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 125 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 125 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 134 => 0x1020, 136 => 0x202, 169 => 0x2b, 351 => 0x202, 445 => 0x21, 455 => 0x202, 480 => 0xb040 },
	'macroled' => { 349 => 0x120a },
	'macromagnification' => { 7 => 0x1b, 11 => 0x1b, 14 => 0x1b, 15 => 0x1b, 19 => 0x1b, 20 => 0x1b, 62 => 0x10 },
	'macromode' => { 38 => 0x1, 199 => 0xb, 346 => 0x300, 371 => 0x1c, 446 => 0x1009 },
	'magentahsl' => { 110 => 0x20917 },
	'magicfilter' => { 346 => 0x52c },
	'magnifiedview' => { 93 => 0x11, 95 => 0x9 },
	'mainboardversion' => { 156 => 0x438 },
	'maindialexposurecomp' => { 335 => '0.6' },
	'mainingredient' => { 557 => 'mainIngredient' },
	'majorbrand' => { 430 => 'major_brand' },
	'majorversion' => { 525 => 'MajorVersion' },
	'make' => { 105 => 0x0, 122 => 0x1, 126 => 0x10f, 174 => 'Make', 360 => 'Make', 376 => 0x10f, 430 => 'make', 436 => ['@mak',"\xa9mak"], 554 => 'make', 561 => 'Make' },
	'makernote' => { 541 => 'MakerNote' },
	'makernoteapple' => { 124 => 'MakN', 126 => 0x927c },
	'makernotecanon' => { 88 => 'CMT3', 124 => 'MakN', 126 => 0x927c },
	'makernotecasio' => { 124 => 'MakN', 126 => 0x927c },
	'makernotecasio2' => { 124 => 'MakN', 126 => 0x927c },
	'makernotedji' => { 124 => 'MakN', 126 => 0x927c },
	'makernotedjiinfo' => { 124 => 'MakN', 126 => 0x927c },
	'makernoteflir' => { 124 => 'MakN', 126 => 0x927c },
	'makernotefujifilm' => { 124 => 'MakN', 126 => 0x927c },
	'makernotege' => { 124 => 'MakN', 126 => 0x927c },
	'makernotege2' => { 124 => 'MakN', 126 => 0x927c },
	'makernotegoogle' => { 124 => 'MakN', 126 => 0x927c },
	'makernotehasselblad' => { 124 => 'MakN', 126 => 0x927c },
	'makernotehp' => { 124 => 'MakN', 126 => 0x927c },
	'makernotehp2' => { 124 => 'MakN', 126 => 0x927c },
	'makernotehp4' => { 124 => 'MakN', 126 => 0x927c },
	'makernotehp6' => { 124 => 'MakN', 126 => 0x927c },
	'makernoteisl' => { 124 => 'MakN', 126 => 0x927c },
	'makernotejvc' => { 124 => 'MakN', 126 => 0x927c },
	'makernotejvctext' => { 124 => 'MakN', 126 => 0x927c },
	'makernotekodak10' => { 124 => 'MakN', 126 => 0x927c },
	'makernotekodak11' => { 124 => 'MakN', 126 => 0x927c },
	'makernotekodak12' => { 124 => 'MakN', 126 => 0x927c },
	'makernotekodak1a' => { 124 => 'MakN', 126 => 0x927c },
	'makernotekodak1b' => { 124 => 'MakN', 126 => 0x927c },
	'makernotekodak2' => { 124 => 'MakN', 126 => 0x927c },
	'makernotekodak3' => { 124 => 'MakN', 126 => 0x927c },
	'makernotekodak4' => { 124 => 'MakN', 126 => 0x927c },
	'makernotekodak5' => { 124 => 'MakN', 126 => 0x927c },
	'makernotekodak6a' => { 124 => 'MakN', 126 => 0x927c },
	'makernotekodak6b' => { 124 => 'MakN', 126 => 0x927c },
	'makernotekodak7' => { 124 => 'MakN', 126 => 0x927c },
	'makernotekodak8a' => { 124 => 'MakN', 126 => 0x927c },
	'makernotekodak8b' => { 124 => 'MakN', 126 => 0x927c },
	'makernotekodak8c' => { 124 => 'MakN', 126 => 0x927c },
	'makernotekodak9' => { 124 => 'MakN', 126 => 0x927c },
	'makernotekodakunknown' => { 124 => 'MakN', 126 => 0x927c },
	'makernotekyocera' => { 124 => 'MakN', 126 => 0x927c },
	'makernoteleica' => { 124 => 'MakN', 126 => 0x927c },
	'makernoteleica10' => { 124 => 'MakN', 126 => 0x927c },
	'makernoteleica2' => { 124 => 'MakN', 126 => 0x927c },
	'makernoteleica3' => { 124 => 'MakN', 126 => 0x927c },
	'makernoteleica4' => { 124 => 'MakN', 126 => 0x927c },
	'makernoteleica5' => { 124 => 'MakN', 126 => 0x927c },
	'makernoteleica6' => { 124 => 'MakN', 126 => 0x927c },
	'makernoteleica7' => { 124 => 'MakN', 126 => 0x927c },
	'makernoteleica8' => { 124 => 'MakN', 126 => 0x927c },
	'makernoteleica9' => { 124 => 'MakN', 126 => 0x927c },
	'makernoteminolta' => { 124 => 'MakN', 126 => 0x927c },
	'makernoteminolta2' => { 124 => 'MakN', 126 => 0x927c },
	'makernoteminolta3' => { 124 => 'MakN', 126 => 0x927c },
	'makernotemotorola' => { 124 => 'MakN', 126 => 0x927c },
	'makernotenikon' => { 124 => 'MakN', 126 => 0x927c },
	'makernotenikon2' => { 124 => 'MakN', 126 => 0x927c },
	'makernotenikon3' => { 124 => 'MakN', 126 => 0x927c },
	'makernotenintendo' => { 124 => 'MakN', 126 => 0x927c },
	'makernoteoffset' => { 455 => 0xff },
	'makernoteolympus' => { 124 => 'MakN', 126 => 0x927c },
	'makernoteolympus2' => { 124 => 'MakN', 126 => 0x927c },
	'makernoteolympus3' => { 124 => 'MakN', 126 => 0x927c },
	'makernotepanasonic' => { 124 => 'MakN', 126 => 0x927c },
	'makernotepanasonic2' => { 124 => 'MakN', 126 => 0x927c },
	'makernotepanasonic3' => { 124 => 'MakN', 126 => 0x927c },
	'makernotepentax' => { 124 => 'MakN', 126 => 0x927c },
	'makernotepentax2' => { 124 => 'MakN', 126 => 0x927c },
	'makernotepentax3' => { 124 => 'MakN', 126 => 0x927c },
	'makernotepentax4' => { 124 => 'MakN', 126 => 0x927c },
	'makernotepentax5' => { 124 => 'MakN', 126 => 0x927c },
	'makernotepentax6' => { 124 => 'MakN', 126 => 0x927c },
	'makernotepentaxunknown' => { 436 => 'PXMN' },
	'makernotephaseone' => { 124 => 'MakN', 126 => 0x927c },
	'makernotereconyxhyperfire' => { 124 => 'MakN', 126 => 0x927c },
	'makernotereconyxhyperfire2' => { 124 => 'MakN', 126 => 0x927c },
	'makernotereconyxhyperfire4k' => { 124 => 'MakN', 126 => 0x927c },
	'makernotereconyxmicrofire' => { 124 => 'MakN', 126 => 0x927c },
	'makernotereconyxultrafire' => { 124 => 'MakN', 126 => 0x927c },
	'makernotericoh' => { 124 => 'MakN', 126 => 0x927c },
	'makernotericoh2' => { 124 => 'MakN', 126 => 0x927c },
	'makernotericohpentax' => { 124 => 'MakN', 126 => 0x927c },
	'makernotericohtext' => { 124 => 'MakN', 126 => 0x927c },
	'makernotesafety' => { 126 => 0xc635 },
	'makernotesamsung1a' => { 124 => 'MakN', 126 => 0x927c },
	'makernotesamsung1b' => { 124 => 'MakN', 126 => 0x927c },
	'makernotesamsung2' => { 124 => 'MakN', 126 => 0x927c },
	'makernotesanyo' => { 124 => 'MakN', 126 => 0x927c },
	'makernotesanyoc4' => { 124 => 'MakN', 126 => 0x927c },
	'makernotesanyopatch' => { 124 => 'MakN', 126 => 0x927c },
	'makernotesigma' => { 124 => 'MakN', 126 => 0x927c },
	'makernotesony' => { 124 => 'MakN', 126 => 0x927c },
	'makernotesony2' => { 124 => 'MakN', 126 => 0x927c },
	'makernotesony3' => { 124 => 'MakN', 126 => 0x927c },
	'makernotesony4' => { 124 => 'MakN', 126 => 0x927c },
	'makernotesony5' => { 124 => 'MakN', 126 => 0x927c },
	'makernotesonyericsson' => { 124 => 'MakN', 126 => 0x927c },
	'makernotesonysrf' => { 124 => 'MakN', 126 => 0x927c },
	'makernotetype' => { 446 => 0x1 },
	'makernoteunknown' => { 124 => 'MakN', 126 => 0x927c },
	'makernoteunknownbinary' => { 124 => 'MakN', 126 => 0x927c },
	'makernoteunknowntext' => { 124 => 'MakN', 126 => 0x927c },
	'makernoteversion' => { 1 => 0x1, 204 => 0x0, 257 => 0x1, 351 => 0x0, 371 => 0x8000, 450 => 0x0, 453 => 0x1, 456 => [0x1d,0x1f], 469 => 0x2000 },
	'makerurl' => { 436 => "\xa9mal" },
	'managedfrom' => { 566 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 566 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 566 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 566 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 566 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 566 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 566 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 566 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 566 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 566 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 566 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 566 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 566 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 566 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 566 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 566 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 566 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 566 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 566 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 566 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 566 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 566 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 566 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 566 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 566 => 'Manager' },
	'managervariant' => { 566 => 'ManagerVariant' },
	'manageto' => { 566 => 'ManageTo' },
	'manageui' => { 566 => 'ManageUI' },
	'manifest' => { 566 => 'Manifest' },
	'manifestlinkform' => { 566 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 566 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 566 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 566 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 566 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 566 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 566 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 566 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 566 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 566 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 566 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 566 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 566 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 566 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 566 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 566 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 566 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 566 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 566 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 566 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 566 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 566 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 566 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 566 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 566 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 566 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 566 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 566 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 346 => 0x900, 371 => 0x86 },
	'manometerreading' => { 346 => 0x901 },
	'manualafpointselectpattern' => { 91 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 349 => 0x1209 },
	'manualflashoutput' => { 38 => 0x29, 326 => '8.2', 329 => '22.2', 330 => '23.1', 331 => '23.2', 333 => '16.2', 334 => '23.2', 335 => '8.2', 336 => '23.2', 339 => '24.2', 446 => 0x100c },
	'manualflashstrength' => { 346 => 0x406 },
	'manualfocusdistance' => { 257 => 0x85, 351 => 0x100c, 455 => 0x223 },
	'manualfocuspointillumination' => { 340 => 0x17, 341 => 0x17, 342 => 0x17, 343 => 0x17 },
	'manualfocusringinafmode' => { 340 => 0x1b, 341 => 0x1a, 342 => 0x1a, 343 => 0x1a },
	'manualtv' => { 90 => 0x5, 91 => 0x705 },
	'manufacturedate' => { 209 => 0x6705, 388 => 0x1 },
	'manufacturedate1' => { 448 => 0x4 },
	'manufacturedate2' => { 448 => 0x5 },
	'manufacturer' => { 144 => 'Manufacturer', 554 => 'manufacturer' },
	'mariahchromablursize' => { 156 => 0xf0d },
	'mariahmaphithreshold' => { 156 => 0xf0c },
	'mariahmaplothreshold' => { 156 => 0xf0b },
	'mariahsigmathreshold' => { 156 => 0xf0e },
	'mariahtexturethreshold' => { 156 => 0xf0a },
	'marked' => { 551 => 'Marked', 569 => 'Marked' },
	'markers' => { 565 => 'markers' },
	'markerscomment' => { 565 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 565 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 565 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 565 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 565 => [\'markers','markersCuePointType'] },
	'markersduration' => { 565 => [\'markers','markersDuration'] },
	'markerslocation' => { 565 => [\'markers','markersLocation'] },
	'markersname' => { 565 => [\'markers','markersName'] },
	'markersprobability' => { 565 => [\'markers','markersProbability'] },
	'markersspeaker' => { 565 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 565 => [\'markers','markersStartTime'] },
	'markerstarget' => { 565 => [\'markers','markersTarget'] },
	'markerstype' => { 565 => [\'markers','markersType'] },
	'maskedareas' => { 126 => 0xc68e },
	'maskgroupbasedcorractive' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'] },
	'maskgroupbasedcorramount' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'] },
	'maskgroupbasedcorrblacks2012' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'] },
	'maskgroupbasedcorrbrightness' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'] },
	'maskgroupbasedcorrclarity' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'] },
	'maskgroupbasedcorrclarity2012' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'] },
	'maskgroupbasedcorrcontrast' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'] },
	'maskgroupbasedcorrcontrast2012' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'] },
	'maskgroupbasedcorrcorrectionname' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'] },
	'maskgroupbasedcorrcorrectionsyncid' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'] },
	'maskgroupbasedcorrdefringe' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'] },
	'maskgroupbasedcorrdehaze' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'] },
	'maskgroupbasedcorrections' => { 535 => 'MaskGroupBasedCorrections', 537 => 'MaskGroupBasedCorrections' },
	'maskgroupbasedcorrexposure' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'] },
	'maskgroupbasedcorrexposure2012' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'] },
	'maskgroupbasedcorrhighlights2012' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'] },
	'maskgroupbasedcorrhue' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'] },
	'maskgroupbasedcorrluminancenoise' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'] },
	'maskgroupbasedcorrmask' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'] },
	'maskgroupbasedcorrmaskalpha' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'] },
	'maskgroupbasedcorrmaskangle' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'] },
	'maskgroupbasedcorrmaskbottom' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'] },
	'maskgroupbasedcorrmaskcentervalue' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'] },
	'maskgroupbasedcorrmaskcenterweight' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'] },
	'maskgroupbasedcorrmaskdabs' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'] },
	'maskgroupbasedcorrmaskfeather' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'] },
	'maskgroupbasedcorrmaskflipped' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'] },
	'maskgroupbasedcorrmaskflow' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'] },
	'maskgroupbasedcorrmaskfullx' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'] },
	'maskgroupbasedcorrmaskfully' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'] },
	'maskgroupbasedcorrmaskinputdigest' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'] },
	'maskgroupbasedcorrmaskleft' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'] },
	'maskgroupbasedcorrmaskmaskactive' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'] },
	'maskgroupbasedcorrmaskmaskblendmode' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmaskdigest' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmaskinverted' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmaskname' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'] },
	'maskgroupbasedcorrmaskmasks' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'] },
	'maskgroupbasedcorrmaskmasksalpha' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'maskgroupbasedcorrmaskmasksangle' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'] },
	'maskgroupbasedcorrmaskmasksbottom' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'] },
	'maskgroupbasedcorrmaskmaskscentervalue' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'maskgroupbasedcorrmaskmaskscenterweight' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'maskgroupbasedcorrmaskmasksdabs' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'] },
	'maskgroupbasedcorrmaskmasksfeather' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'] },
	'maskgroupbasedcorrmaskmasksflipped' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'maskgroupbasedcorrmaskmasksflow' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'] },
	'maskgroupbasedcorrmaskmasksfullx' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'] },
	'maskgroupbasedcorrmaskmasksfully' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'] },
	'maskgroupbasedcorrmaskmasksinputdigest' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'maskgroupbasedcorrmaskmasksleft' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'] },
	'maskgroupbasedcorrmaskmasksmaskactive' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'maskgroupbasedcorrmaskmasksmaskblendmode' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmasksmaskdigest' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmasksmaskinverted' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmasksmaskname' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'maskgroupbasedcorrmaskmasksmasksubtype' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksmasksyncid' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmasksmaskversion' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmasksmidpoint' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'maskgroupbasedcorrmaskmasksorigin' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'maskgroupbasedcorrmaskmasksperimetervalue' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskmasksradius' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'] },
	'maskgroupbasedcorrmaskmasksreferencepoint' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'maskgroupbasedcorrmaskmasksright' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'] },
	'maskgroupbasedcorrmaskmasksroundness' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'maskgroupbasedcorrmaskmaskssizex' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'maskgroupbasedcorrmaskmaskssizey' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'maskgroupbasedcorrmaskmaskstop' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'] },
	'maskgroupbasedcorrmaskmasksubtype' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksvalue' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'maskgroupbasedcorrmaskmasksversion' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'] },
	'maskgroupbasedcorrmaskmaskswhat' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'] },
	'maskgroupbasedcorrmaskmaskswholeimagearea' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskmasksx' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'] },
	'maskgroupbasedcorrmaskmasksy' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'] },
	'maskgroupbasedcorrmaskmasksyncid' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmaskszerox' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'maskgroupbasedcorrmaskmaskszeroy' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'maskgroupbasedcorrmaskmaskversion' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmidpoint' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'] },
	'maskgroupbasedcorrmaskorigin' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'] },
	'maskgroupbasedcorrmaskperimetervalue' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskradius' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'] },
	'maskgroupbasedcorrmaskrange' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'maskgroupbasedcorrmaskrangeareamodels' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrmaskrangeareamodelscolorsampleinfo' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrmaskrangeareamodelscomponents' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrmaskrangecoloramount' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrmaskrangedepthfeather' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrmaskrangedepthmax' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrmaskrangedepthmin' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrmaskrangeinvert' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrmaskrangelumfeather' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrmaskrangeluminancedepthsampleinfo' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrmaskrangelummax' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrmaskrangelummin' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrmaskrangelumrange' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrmaskrangesampletype' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrmaskrangetype' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'maskgroupbasedcorrmaskrangeversion' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrmaskreferencepoint' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'] },
	'maskgroupbasedcorrmaskright' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'] },
	'maskgroupbasedcorrmaskroundness' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'] },
	'maskgroupbasedcorrmasksizex' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'] },
	'maskgroupbasedcorrmasksizey' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'] },
	'maskgroupbasedcorrmasktop' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'] },
	'maskgroupbasedcorrmaskvalue' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'] },
	'maskgroupbasedcorrmaskversion' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'] },
	'maskgroupbasedcorrmaskwhat' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'] },
	'maskgroupbasedcorrmaskwholeimagearea' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskx' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'] },
	'maskgroupbasedcorrmasky' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'] },
	'maskgroupbasedcorrmaskzerox' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'] },
	'maskgroupbasedcorrmaskzeroy' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'] },
	'maskgroupbasedcorrmoire' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'] },
	'maskgroupbasedcorrrangemask' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'] },
	'maskgroupbasedcorrrangemaskareamodels' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrrangemaskareamodelscolorsampleinfo' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrrangemaskareamodelscomponents' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrrangemaskcoloramount' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrrangemaskdepthfeather' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrrangemaskdepthmax' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrrangemaskdepthmin' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrrangemaskinvert' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrrangemasklumfeather' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrrangemaskluminancedepthsampleinfo' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrrangemasklummax' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrrangemasklummin' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrrangemasklumrange' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrrangemasksampletype' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrrangemasktype' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'] },
	'maskgroupbasedcorrrangemaskversion' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrsaturation' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'] },
	'maskgroupbasedcorrshadows2012' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'] },
	'maskgroupbasedcorrsharpness' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'] },
	'maskgroupbasedcorrtemperature' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'] },
	'maskgroupbasedcorrtexture' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'] },
	'maskgroupbasedcorrtint' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'] },
	'maskgroupbasedcorrtoninghue' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'] },
	'maskgroupbasedcorrtoningsaturation' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'] },
	'maskgroupbasedcorrwhat' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'] },
	'maskgroupbasedcorrwhites2012' => { 535 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'], 537 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'] },
	'masterdocumentid' => { 149 => 0xb9 },
	'mastergain' => { 283 => 0x50 },
	'materialsample' => { 125 => 'MaterialSample' },
	'materialsampleid' => { 125 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 325 => '50.1', 327 => '48.1', 328 => '48.1', 337 => '48.1', 338 => '48.1', 341 => 0x233, 342 => 0x233, 343 => 0x24b },
	'matrixselectk' => { 156 => 0x91b },
	'matrixselectthreshold' => { 156 => 0x91a },
	'matrixselectthreshold1' => { 156 => 0x91e },
	'matrixselectthreshold2' => { 156 => 0x91f },
	'matrixstructure' => { 435 => 0xa },
	'maxaperture' => { 38 => 0x1a, 156 => 0x3f9, 162 => 0x6103, 181 => 'MaxAperture', 199 => 0x17, 205 => 0x49c5, 255 => 0x36, 347 => 0x20a, 400 => '14.1' },
	'maxapertureatmaxfocal' => { 134 => 0x1407, 181 => 'MaxApertureAtMaxFocal', 249 => 0xb, 250 => 0x10, 251 => 0x11, 255 => 0x12, 347 => 0x206 },
	'maxapertureatminfocal' => { 134 => 0x1406, 249 => 0xa, 250 => 0xf, 251 => 0x10, 255 => 0x11, 347 => 0x205 },
	'maxaperturevalue' => { 126 => 0x9205, 419 => 0x414, 541 => 'MaxApertureValue' },
	'maxavailheight' => { 549 => 'MaxAvailHeight' },
	'maxavailwidth' => { 549 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 324 => 0xb, 325 => 0xc, 327 => '12.1', 328 => '12.1', 333 => 0xc, 334 => 0xb, 337 => '12.1', 338 => '12.1', 340 => 0x41, 341 => 0x3d, 342 => 0x3d, 343 => 0x3d },
	'maxfaces' => { 350 => 0x1202 },
	'maxfocallength' => { 7 => 0xe6, 8 => 0x10, 9 => 0x1ab, 10 => 0x13, 11 => 0x115, 12 => 0x13, 13 => 0x153, 14 => 0xda, 16 => 0xfa, 17 => 0xee, 18 => 0x103, 19 => 0x95, 20 => 0xea, 21 => 0x157, 22 => 0xee, 23 => 0xec, 24 => 0x12b, 25 => 0x165, 26 => 0x16a, 27 => 0x188, 28 => 0x116, 29 => 0x18d, 38 => 0x17, 134 => 0x1405, 181 => 'MaxFocalLength', 249 => 0x9, 250 => 0xe, 251 => 0xf, 255 => 0x10, 347 => 0x208, 493 => 0x127c, 494 => 0x1138, 495 => 0x330, 496 => 0x330, 497 => 0x30e },
	'maxfocallength2' => { 67 => 0x9 },
	'maximumaperturelv' => { 265 => 0x89e },
	'maximumdensityrange' => { 151 => 0x8c },
	'maxnumafpoints' => { 383 => 0x2 },
	'maxpagesize' => { 570 => 'MaxPageSize' },
	'maxpagesizeh' => { 570 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 570 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 570 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 156 => 0xc7d },
	'maxsamplevalue' => { 126 => 0x119 },
	'maxstorage' => { 560 => 'maxstorage' },
	'mb-d10batteries' => { 324 => '12.6' },
	'mb-d10batterytype' => { 333 => '13.3' },
	'mb-d11batterytype' => { 334 => '2.3' },
	'mb-d12batterytype' => { 337 => '3.2' },
	'mb-d80batteries' => { 335 => '6.5' },
	'mb-d80batterytype' => { 339 => '3.2' },
	'mcuversion' => { 249 => 0xc, 250 => 0x11, 251 => 0x12, 255 => 0x13 },
	'md5digest' => { 182 => 'zmd5' },
	'mditemfindercomment' => { 191 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 191 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 191 => 'MDItemFSLabel' },
	'mditemusertags' => { 191 => 'MDItemUserTags' },
	'meal' => { 557 => 'meal' },
	'measuredev' => { 28 => 0x9, 83 => 0x3, 104 => 0x1814, 174 => 'MeasuredEV' },
	'measuredev2' => { 13 => 0x8, 28 => 0x8, 83 => 0x17 },
	'measuredev3' => { 13 => 0x9 },
	'measuredlv' => { 205 => 0x690, 366 => 0x312, 369 => 0x312, 370 => 0x312, 373 => 0x3407 },
	'measuredrggb' => { 71 => 0x1 },
	'measuredrggbdata' => { 49 => 0x287 },
	'measurementaccuracy' => { 125 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 125 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 125 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 125 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 125 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 125 => 'MeasurementOrFact' },
	'measurementremarks' => { 125 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 125 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 125 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 125 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 144 => 'MeasureType' },
	'mechanicalshuttercount' => { 257 => 0x37 },
	'mediaclassprimaryid' => { 197 => 'WM/MediaClassPrimaryID' },
	'mediaclasssecondaryid' => { 197 => 'WM/MediaClassSecondaryID' },
	'mediaconstraints' => { 357 => 'MediaConstraints' },
	'mediacreatedate' => { 432 => 0x1 },
	'mediaeventiddate' => { 523 => 'MediaEventIdDate' },
	'mediamodifydate' => { 432 => 0x2 },
	'mediasummarycode' => { 357 => 'MediaSummaryCode' },
	'mediatype' => { 428 => 'stik' },
	'mediauid' => { 436 => 'MUID' },
	'memoaudioquality' => { 91 => 0x812 },
	'memorycardconfiguration' => { 472 => 0x16 },
	'memorycardnumber' => { 234 => 0x2 },
	'menubuttondisplayposition' => { 89 => 0xb, 92 => 0xa, 93 => 0xb, 96 => 0xb },
	'menubuttonreturn' => { 97 => 0xb },
	'menumonitorofftime' => { 324 => '26.1', 325 => '22.1', 327 => '22.1', 328 => '22.1', 332 => '21.1', 333 => '8.2', 334 => '21.1', 337 => '22.1', 338 => '22.1', 339 => '22.1', 340 => 0x39, 341 => 0x35, 342 => 0x35, 343 => 0x35 },
	'mergedimages' => { 371 => 0x76 },
	'metadataauthority' => { 549 => 'metadataAuthority' },
	'metadataauthorityidentifier' => { 549 => [\'metadataAuthority','metadataAuthorityIdentifier'] },
	'metadataauthorityname' => { 549 => [\'metadataAuthority','metadataAuthorityName'] },
	'metadatadate' => { 563 => 'MetadataDate' },
	'metadataeditingsoftware' => { 126 => 0xa43c, 542 => 'MetadataEditingSoftware' },
	'metadatalastedited' => { 549 => 'metadataLastEdited' },
	'metadatalasteditor' => { 549 => 'metadataLastEditor' },
	'metadatalasteditoridentifier' => { 549 => [\'metadataLastEditor','metadataLastEditorIdentifier'] },
	'metadatalasteditorname' => { 549 => [\'metadataLastEditor','metadataLastEditorName'] },
	'metadatamoddate' => { 565 => 'metadataModDate' },
	'metaversion' => { 488 => 0x34 },
	'meterinfo1row1' => { 481 => 0x0, 482 => 0x0 },
	'meterinfo1row2' => { 481 => 0x6c, 482 => 0x5a },
	'meterinfo1row3' => { 481 => 0xd8, 482 => 0xb4 },
	'meterinfo1row4' => { 481 => 0x144, 482 => 0x10e },
	'meterinfo1row5' => { 481 => 0x1b0, 482 => 0x168 },
	'meterinfo1row6' => { 481 => 0x21c, 482 => 0x1c2 },
	'meterinfo1row7' => { 481 => 0x288, 482 => 0x21c },
	'meterinfo2row1' => { 481 => 0x2f4, 482 => 0x276 },
	'meterinfo2row2' => { 481 => 0x378, 482 => 0x2e4 },
	'meterinfo2row3' => { 481 => 0x3fc, 482 => 0x352 },
	'meterinfo2row4' => { 481 => 0x480, 482 => 0x3c0 },
	'meterinfo2row5' => { 481 => 0x504, 482 => 0x42e },
	'meterinfo2row6' => { 481 => 0x588, 482 => 0x49c },
	'meterinfo2row7' => { 481 => 0x60c, 482 => 0x50a },
	'meterinfo2row8' => { 481 => 0x690, 482 => 0x578 },
	'meterinfo2row9' => { 481 => 0x714, 482 => 0x5e6 },
	'metering' => { 326 => '6.1' },
	'meteringmode' => { 38 => 0x11, 126 => 0x9207, 158 => 0x1c, 199 => 0x7, 200 => 0x25, 202 => 0x12, 346 => 0x202, 410 => 0x17, 456 => 0x9, 466 => 0x15, 467 => 0x13, 468 => 0x7, 485 => 0x3, 489 => 0x1174, 490 => 0x1178, 491 => 0x1154, 492 => 0x11d0, 493 => 0x11ac, 494 => 0x1064, 495 => 0x25c, 496 => 0x25c, 497 => 0x24b, 541 => 'MeteringMode' },
	'meteringmode2' => { 389 => '2.1', 480 => 0x202c },
	'meteringmode3' => { 389 => '16.1' },
	'meteringoffscaleindicator' => { 202 => 0x53 },
	'meteringtime' => { 324 => '22.2', 326 => '3.2', 329 => '17.1', 330 => '18.1', 333 => '7.3', 334 => '18.1', 335 => '3.2', 339 => '19.1' },
	'micro1version' => { 442 => 0x1f },
	'micro2version' => { 442 => 0x2d },
	'microphoneattenuator' => { 263 => 0x34e, 266 => 0x2d2, 267 => 0x2fa, 268 => 0x2fa },
	'microphonefrequencyresponse' => { 263 => 0x350, 266 => 0x2d4, 267 => 0x2fc, 268 => 0x2fc },
	'microphonejackpower' => { 263 => 0x376, 266 => 0x2fa, 267 => 0x322, 268 => 0x322 },
	'microphonesensitivity' => { 263 => 0x34c, 266 => 0x2d0, 267 => 0x2f8, 268 => 0x2f8 },
	'microvideo' => { 141 => 'MicroVideo' },
	'microvideooffset' => { 141 => 'MicroVideoOffset' },
	'microvideopresentationtimestampus' => { 141 => 'MicroVideoPresentationTimestampUs' },
	'microvideoversion' => { 141 => 'MicroVideoVersion' },
	'midrangesharpness' => { 277 => 0x3b },
	'mieversion' => { 182 => '0Vers' },
	'mime' => { 144 => 'Mime' },
	'minaperture' => { 38 => 0x1b, 156 => 0x3f8, 181 => 'MinAperture', 400 => '0.2' },
	'minaperturevalue' => { 419 => 0x415 },
	'minfocallength' => { 7 => 0xe4, 8 => 0xe, 9 => 0x1a9, 10 => 0x11, 11 => 0x113, 12 => 0x11, 13 => 0x151, 14 => 0xd8, 16 => 0xf8, 17 => 0xec, 18 => 0x101, 19 => 0x93, 20 => 0xe8, 21 => 0x155, 22 => 0xec, 23 => 0xea, 24 => 0x129, 25 => 0x163, 26 => 0x168, 27 => 0x186, 28 => 0x114, 29 => 0x18b, 38 => 0x18, 134 => 0x1404, 181 => 'MinFocalLength', 249 => 0x8, 250 => 0xd, 251 => 0xe, 255 => 0xf, 347 => 0x207, 493 => 0x127a, 494 => 0x1136, 495 => 0x32e, 496 => 0x32e, 497 => 0x30c },
	'minfocallength2' => { 67 => 0x8 },
	'minfocusdistance' => { 400 => 0x3 },
	'minimumiso' => { 371 => 0xe8 },
	'minintegrationrows' => { 156 => 0x1874 },
	'minoltadate' => { 199 => 0x15 },
	'minoltaimagesize' => { 199 => 0x4, 200 => 0xc, 201 => 0x2, 204 => 0x103 },
	'minoltamodelid' => { 199 => 0x25 },
	'minoltaquality' => { 199 => 0x5, 200 => 0xd, 201 => 0x3, 204 => [0x102,0x103] },
	'minoltatime' => { 199 => 0x16 },
	'minormodelagedisclosure' => { 357 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 430 => 'minor_version', 525 => 'MinorVersion' },
	'minsamplevalue' => { 126 => 0x118 },
	'mirroring' => { 429 => 'imir' },
	'mirrorlockup' => { 89 => 0xc, 90 => 0xc, 91 => 0x60f, 92 => 0xb, 93 => 0xc, 94 => 0x6, 95 => 0x6, 96 => 0xc, 97 => 0x3 },
	'mobilecountrycode' => { 534 => 'mcc' },
	'mobilenetworkcode' => { 534 => 'mnc' },
	'moddate' => { 360 => 'modify-date', 551 => 'ModDate' },
	'modedialposition' => { 472 => 0x14 },
	'model' => { 105 => 0x6, 126 => 0x110, 144 => 'Model', 174 => 'Model', 360 => 'Model', 376 => 0x110, 410 => 0x23f, 430 => 'model', 436 => ['@mod','CNMN','cmnm',"\xa9mdl","\xa9mod"], 456 => 0x84, 554 => 'model', 561 => 'Model' },
	'modelage' => { 549 => 'ModelAge' },
	'modelid' => { 344 => 0x0 },
	'modelingflash' => { 324 => '21.4', 325 => '31.1', 327 => '31.1', 328 => '31.1', 333 => '26.4', 334 => '30.2', 335 => '7.4', 336 => '30.1', 337 => '31.1', 338 => '31.1', 339 => '31.3', 340 => 0x61, 341 => 0x5d, 342 => 0x5d, 343 => 0x5d },
	'modelreleaseid' => { 357 => 'ModelReleaseID' },
	'modelreleasestatus' => { 357 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 503 => 0x52, 504 => 0x46, 505 => 0x53 },
	'modeltiepoint' => { 126 => 0x8482 },
	'modeltransform' => { 126 => 0x85d8 },
	'modelyear' => { 554 => 'modelYear' },
	'modificationdate' => { 555 => 'modificationDate' },
	'modifiedcolortemp' => { 72 => 0x9 },
	'modifieddigitalgain' => { 72 => 0xb },
	'modifiedparamflag' => { 63 => 0x1 },
	'modifiedpicturestyle' => { 72 => 0xa },
	'modifiedsaturation' => { 346 => 0x504 },
	'modifiedsensorbluelevel' => { 72 => 0x5 },
	'modifiedsensorredlevel' => { 72 => 0x4 },
	'modifiedsharpness' => { 72 => 0x2 },
	'modifiedsharpnessfreq' => { 72 => 0x3 },
	'modifiedtonecurve' => { 72 => 0x1 },
	'modifiedwhitebalance' => { 72 => 0x8 },
	'modifiedwhitebalanceblue' => { 72 => 0x7 },
	'modifiedwhitebalancered' => { 72 => 0x6 },
	'modifydate' => { 126 => 0x132, 175 => 'ModifyDate', 356 => 'ModDate', 358 => 'tIME', 426 => 'ModDate', 433 => 0x2, 563 => 'ModifyDate' },
	'moirefilter' => { 126 => 0xfe58, 535 => 'MoireFilter', 537 => 'MoireFilter' },
	'monitorbrightness' => { 261 => 0x904, 264 => 0x69a, 265 => 0x6aa, 266 => 0x59a, 267 => 0x5ca, 268 => 0x5e2 },
	'monitordisplayoff' => { 202 => 0x4c },
	'monitormatrix' => { 156 => 0x8fc },
	'monitorofftime' => { 324 => '18.2', 326 => '3.1', 335 => '3.1' },
	'monochromecolor' => { 346 => 0x53b },
	'monochromecontrast' => { 116 => 0x3c },
	'monochromefiltereffect' => { 110 => 0x20307, 116 => 0x3a, 371 => 0xac, 410 => 0x73 },
	'monochromegraineffect' => { 371 => 0xd2 },
	'monochromelinear' => { 116 => 0x3d },
	'monochromeoutputhighlightpoint' => { 116 => 0x41 },
	'monochromeoutputshadowpoint' => { 116 => 0x42 },
	'monochromeprofilesettings' => { 346 => 0x537 },
	'monochromerawhighlight' => { 116 => 0x7a },
	'monochromerawhighlightpoint' => { 116 => 0x3f },
	'monochromerawshadow' => { 116 => 0x83 },
	'monochromerawshadowpoint' => { 116 => 0x40 },
	'monochromesharpness' => { 116 => 0x3e },
	'monochrometoning' => { 410 => 0x74 },
	'monochrometoningeffect' => { 110 => 0x20306, 116 => 0x3b },
	'monochromeunsharpmaskfineness' => { 116 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 116 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 116 => 0xb4 },
	'monochromevignetting' => { 346 => 0x53a },
	'monthdaycreated' => { 158 => 0x12, 167 => 0xe },
	'mood' => { 197 => 'WM/Mood' },
	'moonphase' => { 438 => 0x12, 439 => 0x4c, 440 => 0x37, 441 => 0x5c, 442 => 0x43 },
	'morepermissions' => { 533 => 'morePermissions' },
	'motionphoto' => { 141 => 'MotionPhoto' },
	'motionphotopresentationtimestampus' => { 141 => 'MotionPhotoPresentationTimestampUs' },
	'motionphotoversion' => { 141 => 'MotionPhotoVersion' },
	'motionphotovideo' => { 431 => 'mpvd' },
	'motionsensitivity' => { 438 => 0x29, 439 => 0x60, 440 => 0x49, 441 => 0x70 },
	'movementcount' => { 428 => "\xa9mvc" },
	'movementname' => { 428 => "\xa9mvn" },
	'movementnumber' => { 428 => "\xa9mvi" },
	'movieactived-lighting' => { 262 => 0x238, 263 => 0x334, 266 => 0x2b8, 267 => 0x2e0, 268 => 0x2e0 },
	'movieaelockbuttonassignment' => { 337 => '40.1' },
	'movieaf-onbutton' => { 340 => 0xd3, 341 => 0xcb, 342 => 0xcb, 343 => 0xcb },
	'movieafareamode' => { 263 => 0x342, 266 => 0x2c6, 267 => 0x2ee, 268 => 0x2ee, 342 => 0x203 },
	'movieafspeed' => { 340 => 0xe5, 341 => 0xdd, 342 => 0xdd, 343 => 0xdd },
	'movieafspeedapply' => { 340 => 0xe7, 341 => 0xdf, 342 => 0xdf, 343 => 0xdf },
	'movieaftrackingsensitivity' => { 340 => 0xe9, 341 => 0xe1, 342 => 0xe1, 343 => 0xe1 },
	'movieaperturelock' => { 341 => 0x259, 342 => 0x259, 343 => 0x271 },
	'movieautodistortioncontrol' => { 262 => 0x242 },
	'moviediffractioncompensation' => { 262 => 0x241 },
	'moviedxcropalert' => { 263 => 0x377, 266 => 0x2fb, 267 => 0x323, 268 => 0x323 },
	'movieelectronicvr' => { 263 => 0x348, 266 => 0x2cc, 267 => 0x2f4, 268 => 0x2f4 },
	'movieevfgrid' => { 341 => 0x21d, 342 => 0x21d, 343 => 0x235 },
	'movieflickerreduction' => { 263 => 0x33c, 266 => 0x2c0, 267 => 0x2e8, 268 => 0x2e8 },
	'moviefocusmode' => { 262 => 0x248, 263 => 0x340, 266 => 0x2c4, 267 => 0x2ec, 268 => 0x2ec },
	'moviefocuspointlock' => { 341 => 0x226, 342 => 0x226, 343 => 0x23e },
	'movieframerate' => { 261 => 0x48c, 262 => 0x1f8, 263 => 0x374, 266 => 0x2f4, 267 => 0x31c, 268 => 0x31c },
	'movieframesize' => { 261 => 0x48a, 262 => 0x1f6, 263 => 0x372, 266 => 0x2f2, 267 => 0x31a, 268 => 0x31a },
	'moviefunc1button' => { 327 => '41.1', 328 => '41.1', 338 => '41.1', 340 => 0xc7, 341 => 0xc3, 342 => 0xc3, 343 => 0xc3 },
	'moviefunc2button' => { 340 => 0xcd, 341 => 0xc7, 342 => 0xc7, 343 => 0xc7 },
	'moviefunc3button' => { 342 => 0x127, 343 => 0x13f },
	'moviefunctionbutton' => { 325 => '41.1', 337 => '41.1' },
	'moviefunctionbuttonplusdials' => { 325 => '52.1' },
	'moviehighisonoisereduction' => { 262 => 0x23c, 263 => 0x336, 266 => 0x2ba, 267 => 0x2e2, 268 => 0x2e2 },
	'moviehighlightdisplaythreshold' => { 341 => 0x215, 342 => 0x215, 343 => 0x22d },
	'moviehighreszoom' => { 263 => 0x380, 267 => 0x32c, 268 => 0x32c },
	'movieimagearea' => { 263 => 0x2da, 266 => 0x25c, 267 => 0x286, 268 => 0x286 },
	'movieisoautocontrolmanualmode' => { 263 => 0x2e8, 266 => 0x26a, 267 => 0x294, 268 => 0x294 },
	'movieisoautohilimit' => { 263 => 0x2e6, 266 => 0x268, 267 => 0x292, 268 => 0x292 },
	'movieisoautomanualmode' => { 262 => 0x204, 263 => 0x2ea, 266 => 0x26c, 267 => 0x296, 268 => 0x296 },
	'movielenscontrolring' => { 340 => 0xdf, 341 => 0xd7, 342 => 0xd7, 343 => 0xd7 },
	'moviemeteringmode' => { 263 => 0x33e, 266 => 0x2c2, 267 => 0x2ea, 268 => 0x2ea },
	'moviemidtonedisplayrange' => { 341 => 0x219, 342 => 0x219, 343 => 0x231 },
	'moviemidtonedisplayvalue' => { 341 => 0x217, 342 => 0x217, 343 => 0x22f },
	'moviemultiselector' => { 340 => 0xe1, 341 => 0xd9, 342 => 0xcf, 343 => 0xcf },
	'moviepreviewbutton' => { 325 => '41.2', 327 => '41.2', 328 => '41.2', 337 => '41.2', 338 => '41.2' },
	'moviepreviewbuttonplusdials' => { 325 => '52.2' },
	'movierecordbuttonplaybackmode' => { 340 => 0x1af, 341 => 0x1b5, 342 => 0x1b5, 343 => 0x1cd },
	'movieshutterbutton' => { 325 => '38.3', 327 => '38.3', 328 => '38.3', 337 => '38.3', 338 => '38.3' },
	'movieshutterspeedlock' => { 341 => 0x225, 342 => 0x225, 343 => 0x23d },
	'movieslowmotion' => { 261 => 0x416, 262 => 0x1fa },
	'moviesoundrecording' => { 263 => 0x34a, 266 => 0x2ce, 267 => 0x2f6, 268 => 0x2f6 },
	'moviesubjectdetection' => { 263 => 0x378, 266 => 0x2fc, 267 => 0x324, 268 => 0x324 },
	'moviesubselectorassignment' => { 325 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 325 => '53.1' },
	'movietonemap' => { 266 => 0x2ec, 267 => 0x314, 268 => 0x314 },
	'movietype' => { 246 => 0x2ca, 261 => 0x41a, 262 => 0x1fe, 263 => 0x2e4, 266 => 0x266, 267 => 0x290, 268 => 0x290 },
	'movievibrationreduction' => { 262 => 0x24e },
	'movievibrationreductionsameasphoto' => { 262 => 0x24f },
	'movievignettecontrol' => { 262 => 0x23e, 263 => 0x1b0, 266 => 0x1a0, 267 => 0x1b4, 268 => 0x1b4 },
	'movievignettecontrolsameasphoto' => { 262 => 0x240 },
	'movievrmode' => { 263 => 0x344, 266 => 0x2c8, 267 => 0x2f0, 268 => 0x2f0 },
	'moviezebrapattern' => { 341 => 0x213, 342 => 0x213, 343 => 0x22b },
	'multiburstimageheight' => { 480 => 0x1002 },
	'multiburstimagewidth' => { 480 => 0x1001 },
	'multiburstmode' => { 480 => 0x1000 },
	'multicontrollerwhilemetering' => { 91 => 0x517 },
	'multiexposure' => { 74 => 0x1, 371 => 0xb4 },
	'multiexposureautogain' => { 270 => 0x3 },
	'multiexposurecontrol' => { 74 => 0x2 },
	'multiexposuremode' => { 270 => 0x1, 271 => 0x1 },
	'multiexposureoverlaymode' => { 271 => 0x3 },
	'multiexposureshots' => { 74 => 0x3, 261 => 0x1be, 263 => 0x9a, 266 => 0x8e, 267 => 0x9c, 268 => 0x9c, 270 => 0x2, 271 => 0x2 },
	'multiframenoisereduction' => { 468 => 0x35, 480 => 0x200b, 485 => 0x15 },
	'multiframenreffect' => { 480 => 0x2023 },
	'multifunctionlock' => { 91 => 0x70f },
	'multipleexposure' => { 134 => 0x1037 },
	'multipleexposuremode' => { 261 => 0x1bc, 263 => 0x98, 266 => 0x8c, 267 => 0x9a, 268 => 0x9a, 350 => 0x101c },
	'multipleexposureset' => { 389 => '10.1' },
	'multisample' => { 283 => 0x40 },
	'multiselector' => { 324 => '9.4', 325 => '10.3', 327 => '10.3', 328 => '10.3', 333 => '27.4', 337 => '10.3', 338 => '10.3' },
	'multiselectorliveview' => { 324 => '4.3', 327 => '37.1', 328 => '37.1', 337 => '37.1', 338 => '37.1' },
	'multiselectorliveviewmode' => { 297 => 0x18c2 },
	'multiselectorplaybackmode' => { 324 => ['13.5','9.2'], 325 => '10.2', 328 => '10.2', 333 => '27.2', 337 => '10.2', 338 => '10.2', 340 => 0xb7, 341 => 0xb3, 342 => 0xb3, 343 => 0xb3 },
	'multiselectorshootmode' => { 324 => '9.1', 325 => '10.1', 327 => '10.1', 328 => '10.1', 333 => '27.1', 337 => '10.1', 338 => '10.1', 340 => 0xb3, 341 => 0xaf, 342 => 0xaf, 343 => 0xaf },
	'multishot' => { 376 => 0x121 },
	'mute' => { 427 => 'player.movie.audio.mute', 430 => 'player.movie.audio.mute' },
	'mycolormode' => { 75 => 0x2 },
	'name' => { 436 => 'name', 535 => 'Name', 537 => 'Name' },
	'narrator' => { 428 => "\xa9nrt" },
	'nationalcatalognumber' => { 555 => 'nationalCatalogNumber' },
	'nativedigest' => { 541 => 'NativeDigest', 561 => 'NativeDigest' },
	'nativeformat' => { 530 => 'NativeFormat' },
	'ndfilter' => { 83 => 0x1c, 346 => 0x204, 446 => 0x1019 },
	'near' => { 144 => 'Near' },
	'nefbitdepth' => { 257 => 0xe22 },
	'nefcompression' => { 257 => 0x93, 258 => 0xa },
	'neflinearizationtable' => { 257 => 0x96 },
	'negativecachelargepreviewsize' => { 535 => 'NegativeCacheLargePreviewSize', 537 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 535 => 'NegativeCacheMaximumSize', 537 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 535 => 'NegativeCachePath', 537 => 'NegativeCachePath' },
	'neutraldensityfactor' => { 532 => 'NeutralDensityFactor' },
	'neutraldensityfilter' => { 410 => 0x88 },
	'neutraloutputhighlightpoint' => { 116 => 0x2f },
	'neutraloutputshadowpoint' => { 116 => 0x30 },
	'neutralrawcolortone' => { 116 => 0x28 },
	'neutralrawcontrast' => { 116 => 0x2a },
	'neutralrawhighlight' => { 116 => 0x78 },
	'neutralrawhighlightpoint' => { 116 => 0x2d },
	'neutralrawlinear' => { 116 => 0x2b },
	'neutralrawsaturation' => { 116 => 0x29 },
	'neutralrawshadow' => { 116 => 0x81 },
	'neutralrawshadowpoint' => { 116 => 0x2e },
	'neutralrawsharpness' => { 116 => 0x2c },
	'neutralunsharpmaskfineness' => { 116 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 116 => 0xa8 },
	'neutraunsharpmaskstrength' => { 116 => 0xa4 },
	'newlensdata' => { 255 => 0x2f },
	'newrawimagedigest' => { 126 => 0xc7a7 },
	'newsphotoversion' => { 151 => 0x0 },
	'nickname' => { 563 => 'Nickname' },
	'nikoncapturedata' => { 257 => 0xe01 },
	'nikoncaptureeditversions' => { 257 => 0xe13 },
	'nikoncaptureoffsets' => { 257 => 0xe0e },
	'nikoncaptureoutput' => { 257 => 0xe1e },
	'nikoncaptureversion' => { 257 => 0xe09 },
	'nikoniccprofile' => { 257 => 0xe1d },
	'nikonimagesize' => { 294 => '723.1', 295 => '732.1', 303 => 0x2c4 },
	'nikonmeteringmode' => { 220 => 0x17, 261 => 0x2d2, 262 => 0x146, 274 => 0x214 },
	'nikonsettings' => { 257 => 0x4e },
	'noisefilter' => { 346 => 0x527 },
	'noiseprofile' => { 126 => 0xc761 },
	'noisereduction' => { 134 => [0x100b,0x100e], 200 => 0xb0, 201 => 0x60, 202 => 0x3f, 257 => 0x95, 317 => 0x753dcbc0, 318 => 0x17, 346 => 0x50a, 351 => 0x103a, 371 => 0x2d, 410 => 0x49, 446 => 0x100f, 448 => 0x2a },
	'noisereduction2' => { 350 => 0x1010 },
	'noisereductionapplied' => { 126 => 0xc6f7 },
	'noisereductionintensity' => { 318 => 0x9 },
	'noisereductionmethod' => { 318 => 0x11 },
	'noisereductionmode' => { 517 => 0x801e },
	'noisereductionparametersatcapture' => { 156 => 0xe73 },
	'noisereductionparameterscamera' => { 156 => 0xe72 },
	'noisereductionparametershost3mp' => { 156 => 0xe71 },
	'noisereductionparametershost6mp' => { 156 => 0xe70 },
	'noisereductionparametershostrgb' => { 156 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 156 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 156 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 156 => 0xe63 },
	'noisereductionparams' => { 376 => 0x1b },
	'noisereductionsharpness' => { 318 => 0xd },
	'noisereductionstrength' => { 371 => 0xd6 },
	'noisereductionvalue' => { 517 => 0x8027 },
	'nomemorycard' => { 324 => '22.1', 325 => '4.2', 326 => '0.3', 329 => '2.4', 330 => '3.2', 331 => '3.2', 333 => '33.7', 334 => '3.2', 335 => '0.3', 337 => '4.2', 339 => '4.5' },
	'nominalmaxaperture' => { 400 => 0xa },
	'nominalminaperture' => { 400 => '10.1' },
	'noncpulens10focallength' => { 264 => 0x6c6, 265 => 0x6d6, 268 => 0x620 },
	'noncpulens10maxaperture' => { 264 => 0x6ee, 265 => 0x738, 268 => 0x670 },
	'noncpulens11focallength' => { 264 => 0x6c8, 265 => 0x6d8, 268 => 0x624 },
	'noncpulens11maxaperture' => { 264 => 0x6f0, 265 => 0x73c, 268 => 0x674 },
	'noncpulens12focallength' => { 264 => 0x6ca, 265 => 0x6da, 268 => 0x628 },
	'noncpulens12maxaperture' => { 264 => 0x6f2, 265 => 0x740, 268 => 0x678 },
	'noncpulens13focallength' => { 264 => 0x6cc, 265 => 0x6dc, 268 => 0x62c },
	'noncpulens13maxaperture' => { 264 => 0x6f4, 265 => 0x744, 268 => 0x67c },
	'noncpulens14focallength' => { 264 => 0x6ce, 265 => 0x6de, 268 => 0x630 },
	'noncpulens14maxaperture' => { 264 => 0x6f6, 265 => 0x748, 268 => 0x680 },
	'noncpulens15focallength' => { 264 => 0x6d0, 265 => 0x6e0, 268 => 0x634 },
	'noncpulens15maxaperture' => { 264 => 0x6f8, 265 => 0x74c, 268 => 0x684 },
	'noncpulens16focallength' => { 264 => 0x6d2, 265 => 0x6e2, 268 => 0x638 },
	'noncpulens16maxaperture' => { 264 => 0x6fa, 265 => 0x750, 268 => 0x688 },
	'noncpulens17focallength' => { 264 => 0x6d4, 265 => 0x6e4, 268 => 0x63c },
	'noncpulens17maxaperture' => { 264 => 0x6fc, 265 => 0x754, 268 => 0x68c },
	'noncpulens18focallength' => { 264 => 0x6d6, 265 => 0x6e6, 268 => 0x640 },
	'noncpulens18maxaperture' => { 264 => 0x6fe, 265 => 0x758, 268 => 0x690 },
	'noncpulens19focallength' => { 264 => 0x6d8, 265 => 0x6e8, 268 => 0x644 },
	'noncpulens19maxaperture' => { 264 => 0x700, 265 => 0x75c, 268 => 0x694 },
	'noncpulens1focallength' => { 264 => 0x6b4, 265 => 0x6c4, 268 => 0x5fc },
	'noncpulens1maxaperture' => { 264 => 0x6dc, 265 => 0x714, 268 => 0x64c },
	'noncpulens20focallength' => { 264 => 0x6da, 265 => 0x6ea, 268 => 0x648 },
	'noncpulens20maxaperture' => { 264 => 0x702, 265 => 0x760, 268 => 0x698 },
	'noncpulens2focallength' => { 264 => 0x6b6, 265 => 0x6c6, 268 => 0x600 },
	'noncpulens2maxaperture' => { 264 => 0x6de, 265 => 0x718, 268 => 0x650 },
	'noncpulens3focallength' => { 264 => 0x6b8, 265 => 0x6c8, 268 => 0x604 },
	'noncpulens3maxaperture' => { 264 => 0x6e0, 265 => 0x71c, 268 => 0x654 },
	'noncpulens4focallength' => { 264 => 0x6ba, 265 => 0x6ca, 268 => 0x608 },
	'noncpulens4maxaperture' => { 264 => 0x6e2, 265 => 0x720, 268 => 0x658 },
	'noncpulens5focallength' => { 264 => 0x6bc, 265 => 0x6cc, 268 => 0x60c },
	'noncpulens5maxaperture' => { 264 => 0x6e4, 265 => 0x724, 268 => 0x65c },
	'noncpulens6focallength' => { 264 => 0x6be, 265 => 0x6ce, 268 => 0x610 },
	'noncpulens6maxaperture' => { 264 => 0x6e6, 265 => 0x728, 268 => 0x660 },
	'noncpulens7focallength' => { 264 => 0x6c0, 265 => 0x6d0, 268 => 0x614 },
	'noncpulens7maxaperture' => { 264 => 0x6e8, 265 => 0x72c, 268 => 0x664 },
	'noncpulens8focallength' => { 264 => 0x6c2, 265 => 0x6d2, 268 => 0x618 },
	'noncpulens8maxaperture' => { 264 => 0x6ea, 265 => 0x730, 268 => 0x668 },
	'noncpulens9focallength' => { 264 => 0x6c4, 265 => 0x6d4, 268 => 0x61c },
	'noncpulens9maxaperture' => { 264 => 0x6ec, 265 => 0x734, 268 => 0x66c },
	'normalizedcropcorners' => { 361 => 'NormalizedCropCorners' },
	'normallinetime' => { 156 => 0x186a },
	'normalwhitelevel' => { 45 => 0x32a, 46 => 0x280, 47 => 0x294, 50 => [0x2b8,0x2cf,0x2d3], 51 => 0x569, 52 => 0x1e3, 53 => [0x1fc,0x2dc], 54 => [0x230,0x30e], 55 => 0x31c },
	'notes' => { 519 => 'Notes', 529 => 'notes' },
	'npages' => { 570 => 'NPages' },
	'nullrecord' => { 104 => 0x0 },
	'numafpoints' => { 383 => 0x3, 384 => 0x2 },
	'number' => { 555 => 'number' },
	'numberofbeats' => { 565 => 'numberOfBeats' },
	'numberoffocuspoints' => { 327 => '1.3', 328 => '1.3', 331 => '0.2', 332 => '0.3', 334 => '0.3' },
	'numcafpoints' => { 387 => 0x1 },
	'numfaceelements' => { 134 => 0x4200 },
	'numfacepositions' => { 363 => 0x0 },
	'numindexentries' => { 151 => 0x54 },
	'numwbentries' => { 377 => 0x0, 378 => 0x0 },
	'object' => { 555 => 'object' },
	'objectattributereference' => { 149 => 0x4 },
	'objectcycle' => { 149 => 0x4b, 529 => 'ObjectCycle' },
	'objectdescription' => { 554 => 'objectDescription' },
	'objectdistance' => { 119 => 0x6, 120 => 0x2022 },
	'objectname' => { 149 => 0x5 },
	'objectpreviewdata' => { 149 => 0xca },
	'objectpreviewfileformat' => { 149 => 0xc8 },
	'objectpreviewfileversion' => { 149 => 0xc9 },
	'objectsubtype' => { 554 => 'objectSubtype' },
	'objecttype' => { 554 => 'objectType' },
	'objecttypereference' => { 149 => 0x3 },
	'occurrence' => { 125 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 125 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 125 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 125 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 125 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 125 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 125 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecaste' => { 125 => [\'Occurrence','OccurrenceCaste'] },
	'occurrencecatalognumber' => { 125 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedegreeofestablishment' => { 125 => [\'Occurrence','OccurrenceDegreeOfEstablishment'] },
	'occurrencedetails' => { 125 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 125 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 125 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrencegeoreferenceverificationstatus' => { 125 => [\'Occurrence','OccurrenceGeoreferenceVerificationStatus'] },
	'occurrenceid' => { 125 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 125 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 125 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 125 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 125 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 125 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 125 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepathway' => { 125 => [\'Occurrence','OccurrencePathway'] },
	'occurrencepreparations' => { 125 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 125 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 125 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordedbyid' => { 125 => [\'Occurrence','OccurrenceRecordedByID'] },
	'occurrencerecordnumber' => { 125 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 125 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 125 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 125 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 125 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'occurrencevitality' => { 125 => [\'Occurrence','OccurrenceVitality'] },
	'oecfcolumns' => { 541 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 541 => [\'OECF','OECFNames'] },
	'oecfrows' => { 541 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 541 => [\'OECF','OECFValues'] },
	'offsaledate' => { 555 => 'offSaleDate' },
	'offsaledatea-platform' => { 555 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 555 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 156 => 0x190a },
	'offsethdr' => { 546 => 'OffsetHDR' },
	'offsetschema' => { 126 => 0xea1d },
	'offsetsdr' => { 546 => 'OffsetSDR' },
	'offsettime' => { 126 => 0x9010 },
	'offsettimedigitized' => { 126 => 0x9012 },
	'offsettimeoriginal' => { 126 => 0x9011 },
	'oismode' => { 1 => 0xf },
	'okbutton' => { 334 => '15.1', 339 => '16.1' },
	'oldsubfiletype' => { 126 => 0xff },
	'olympusimageheight' => { 351 => 0x102f },
	'olympusimagewidth' => { 351 => 0x102e },
	'omenatcapturestrength' => { 156 => 0xa60 },
	'omenautostrength' => { 156 => 0xa5f },
	'omenearlystrength' => { 156 => 0xa5e },
	'omenfocallengthlimit' => { 156 => 0xa62 },
	'omeninitialipfstrength' => { 156 => 0xa5d },
	'omensurfaceindex' => { 156 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 351 => 0x302 },
	'onsaledate' => { 555 => 'onSaleDate' },
	'onsaledatea-platform' => { 555 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 555 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 555 => 'onSaleDay' },
	'onsaledaya-platform' => { 555 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 555 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 126 => 0xc740 },
	'opcodelist2' => { 126 => 0xc741 },
	'opcodelist3' => { 126 => 0xc74e },
	'opticalzoom' => { 160 => 0xfa3d, 162 => [0x6006,0xf006], 163 => 0x1000, 164 => 0xf, 167 => 0x1e, 169 => 0x20, 170 => 0x1c, 181 => 'OpticalZoom' },
	'opticalzoomcode' => { 83 => 0xa },
	'opticalzoommode' => { 371 => 0x34 },
	'opticalzoomon' => { 455 => 0x219 },
	'optionenddate' => { 558 => 'optionEndDate' },
	'opto-electricconvfactor' => { 541 => 'OECF' },
	'orangehsl' => { 110 => 0x20911 },
	'ordernumber' => { 134 => 0x8002 },
	'organisationinimagecode' => { 549 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 549 => 'OrganisationInImageName' },
	'organism' => { 125 => 'Organism' },
	'organismassociatedoccurrences' => { 125 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 125 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 125 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 125 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 125 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 125 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 125 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 555 => 'organization' },
	'orientation' => { 126 => 0x112, 376 => 0x112, 554 => 'orientation', 561 => 'Orientation' },
	'orientation2' => { 485 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 91 => 0x516 },
	'originalalbumtitle' => { 197 => 'WM/OriginalAlbumTitle' },
	'originalartist' => { 197 => 'WM/OriginalArtist', 428 => "\xa9ope" },
	'originalbestqualitysize' => { 126 => 0xc792 },
	'originalcreatedatetime' => { 523 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 121 => 'Canon-OriginalDecisionData' },
	'originaldecisiondataoffset' => { 70 => 0x83 },
	'originaldefaultcropsize' => { 126 => 0xc793 },
	'originaldefaultfinalsize' => { 126 => 0xc791 },
	'originaldirectory' => { 368 => 0x408 },
	'originaldocumentid' => { 566 => 'OriginalDocumentID' },
	'originalfilename' => { 104 => 0x816, 156 => 0x3e9, 168 => 0x20, 368 => 0x407, 523 => 'OriginalFilename' },
	'originalfilepath' => { 436 => 'fsid' },
	'originalimagehash' => { 521 => 'OriginalImageHash' },
	'originalimagehashtype' => { 521 => 'OriginalImageHashType' },
	'originalimageheight' => { 85 => 0xc, 130 => 0x1 },
	'originalimagemd5' => { 521 => 'OriginalImageMD5' },
	'originalimagesize' => { 180 => 'OriginalImageSize' },
	'originalimagewidth' => { 85 => 0xb, 130 => 0x0 },
	'originallyricist' => { 197 => 'WM/OriginalLyricist' },
	'originalrawfiledata' => { 126 => 0xc68c },
	'originalrawfiledigest' => { 126 => 0xc71d },
	'originalrawfilename' => { 126 => 0xc68b },
	'originaltransmissionreference' => { 149 => 0x67 },
	'originatingprogram' => { 149 => 0x41, 529 => 'OriginatingProgram' },
	'originplatform' => { 555 => 'originPlatform' },
	'os' => { 539 => 'os' },
	'otherconditions' => { 357 => 'OtherConditions' },
	'otherconstraints' => { 357 => 'OtherConstraints' },
	'otherimage' => { 121 => 'Exif-OtherImage' },
	'otherimageinfo' => { 357 => 'OtherImageInfo' },
	'otherimagelength' => { 126 => 0x202 },
	'otherimagestart' => { 126 => 0x201 },
	'otherlicensedocuments' => { 357 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 357 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 357 => 'OtherLicenseRequirements' },
	'outcue' => { 565 => 'outCue' },
	'outcuescale' => { 565 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 565 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 221 => 0x3 },
	'outputimagewidth' => { 221 => 0x2 },
	'outputlut' => { 371 => 0xa7 },
	'outputprofile' => { 156 => 0x138b },
	'outputresolution' => { 221 => 0x4 },
	'overclockcols' => { 156 => 0x189c },
	'overclockrows' => { 156 => 0x18c4 },
	'overridelookvignette' => { 535 => 'OverrideLookVignette', 537 => 'OverrideLookVignette' },
	'owner' => { 428 => 'ownr', 569 => 'Owner' },
	'ownerid' => { 149 => 0xbc },
	'ownername' => { 15 => 0x10f, 70 => 0x9, 104 => 0x810, 126 => [0xa430,0xfde8], 174 => 'OwnerName', 532 => 'OwnerName', 542 => 'CameraOwnerName' },
	'padding' => { 126 => 0xea1c },
	'pagecount' => { 555 => 'pageCount' },
	'pageimage' => { 563 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 563 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 563 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 563 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 563 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 563 => 'PageInfo' },
	'pagename' => { 126 => 0x11d },
	'pagenumber' => { 126 => 0x129 },
	'pageprogressiondirection' => { 555 => 'pageProgressionDirection' },
	'pagerange' => { 555 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 535 => 'PaintBasedCorrections', 537 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionblacks2012' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'] },
	'paintcorrectionbrightness' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectioncorrectionname' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'] },
	'paintcorrectioncorrectionsyncid' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'] },
	'paintcorrectiondefringe' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectiondehaze' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'] },
	'paintcorrectionexposure' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'] },
	'paintcorrectionluminancenoise' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskinputdigest' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'] },
	'paintcorrectionmaskleft' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmaskactive' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'] },
	'paintcorrectionmaskmaskblendmode' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'paintcorrectionmaskmaskdigest' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'] },
	'paintcorrectionmaskmaskinverted' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'] },
	'paintcorrectionmaskmaskname' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'] },
	'paintcorrectionmaskmasks' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'] },
	'paintcorrectionmaskmasksalpha' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'paintcorrectionmaskmasksangle' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'] },
	'paintcorrectionmaskmasksbottom' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'] },
	'paintcorrectionmaskmaskscentervalue' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'paintcorrectionmaskmaskscenterweight' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'paintcorrectionmaskmasksdabs' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'] },
	'paintcorrectionmaskmasksfeather' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'] },
	'paintcorrectionmaskmasksflipped' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'paintcorrectionmaskmasksflow' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'] },
	'paintcorrectionmaskmasksfullx' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'] },
	'paintcorrectionmaskmasksfully' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'] },
	'paintcorrectionmaskmasksinputdigest' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'paintcorrectionmaskmasksleft' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'] },
	'paintcorrectionmaskmasksmaskactive' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'paintcorrectionmaskmasksmaskblendmode' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'paintcorrectionmaskmasksmaskdigest' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'paintcorrectionmaskmasksmaskinverted' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'paintcorrectionmaskmasksmaskname' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'paintcorrectionmaskmasksmasksubtype' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'paintcorrectionmaskmasksmasksyncid' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'paintcorrectionmaskmasksmaskversion' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'paintcorrectionmaskmasksmidpoint' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'paintcorrectionmaskmasksorigin' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'paintcorrectionmaskmasksperimetervalue' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'paintcorrectionmaskmasksradius' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'] },
	'paintcorrectionmaskmasksreferencepoint' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'paintcorrectionmaskmasksright' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'] },
	'paintcorrectionmaskmasksroundness' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'paintcorrectionmaskmaskssizex' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'paintcorrectionmaskmaskssizey' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'paintcorrectionmaskmaskstop' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'] },
	'paintcorrectionmaskmasksubtype' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'] },
	'paintcorrectionmaskmasksvalue' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'paintcorrectionmaskmasksversion' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'] },
	'paintcorrectionmaskmaskswhat' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'] },
	'paintcorrectionmaskmaskswholeimagearea' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'paintcorrectionmaskmasksx' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'] },
	'paintcorrectionmaskmasksy' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'] },
	'paintcorrectionmaskmasksyncid' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'paintcorrectionmaskmaskszerox' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'paintcorrectionmaskmaskszeroy' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'paintcorrectionmaskmaskversion' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'] },
	'paintcorrectionmaskmidpoint' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskorigin' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'] },
	'paintcorrectionmaskperimetervalue' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskrange' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'paintcorrectionmaskrangeareamodels' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'paintcorrectionmaskrangeareamodelscolorsampleinfo' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionmaskrangeareamodelscomponents' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionmaskrangecoloramount' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'paintcorrectionmaskrangedepthfeather' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionmaskrangedepthmax' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'paintcorrectionmaskrangedepthmin' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'paintcorrectionmaskrangeinvert' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'paintcorrectionmaskrangelumfeather' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'paintcorrectionmaskrangeluminancedepthsampleinfo' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionmaskrangelummax' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'paintcorrectionmaskrangelummin' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'paintcorrectionmaskrangelumrange' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'paintcorrectionmaskrangesampletype' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'paintcorrectionmaskrangetype' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'paintcorrectionmaskrangeversion' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'paintcorrectionmaskreferencepoint' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'] },
	'paintcorrectionmaskright' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskwholeimagearea' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'paintcorrectionmaskx' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionrangemask' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'] },
	'paintcorrectionrangemaskareamodels' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'paintcorrectionrangemaskareamodelscolorsampleinfo' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionrangemaskareamodelscomponents' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionrangemaskcoloramount' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'paintcorrectionrangemaskdepthfeather' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionrangemaskdepthmax' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'paintcorrectionrangemaskdepthmin' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'paintcorrectionrangemaskinvert' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'] },
	'paintcorrectionrangemasklumfeather' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'paintcorrectionrangemaskluminancedepthsampleinfo' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionrangemasklummax' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'paintcorrectionrangemasklummin' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'paintcorrectionrangemasklumrange' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'paintcorrectionrangemasksampletype' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'paintcorrectionrangemasktype' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'] },
	'paintcorrectionrangemaskversion' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'] },
	'paintcorrectionsaturation' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'] },
	'paintcorrectionshadows2012' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontexture' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'] },
	'paintcorrectiontint' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectiontoninghue' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectiontoningsaturation' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionwhat' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'paintcorrectionwhites2012' => { 535 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'], 537 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'] },
	'panasonicdatetime' => { 374 => 0x0 },
	'panasonicexifversion' => { 371 => 0x26 },
	'panasonicimageheight' => { 371 => 0x4c },
	'panasonicimagewidth' => { 371 => 0x4b },
	'panasonicrawversion' => { 376 => 0x1 },
	'panasonictitle' => { 126 => 0xc6d2 },
	'panasonictitle2' => { 126 => 0xc6d3 },
	'panoramaangle' => { 134 => 0x1153 },
	'panoramacropbottom' => { 486 => 0x7 },
	'panoramacropleft' => { 486 => 0x4 },
	'panoramacropright' => { 486 => 0x6 },
	'panoramacroptop' => { 486 => 0x5 },
	'panoramadirection' => { 78 => 0x5, 134 => 0x1154, 486 => 0x3 },
	'panoramaframeheight' => { 486 => 0x9 },
	'panoramaframenumber' => { 78 => 0x2 },
	'panoramaframewidth' => { 486 => 0x8 },
	'panoramafullheight' => { 486 => 0x2 },
	'panoramafullwidth' => { 486 => 0x1 },
	'panoramamode' => { 158 => 0x3c, 346 => 0x601 },
	'panoramasize3d' => { 468 => 0x38 },
	'panoramasourceheight' => { 486 => 0xb },
	'panoramasourcewidth' => { 486 => 0xa },
	'panoramicstitchcameramotion' => { 194 => 'PanoramicStitchCameraMotion', 195 => 0x1 },
	'panoramicstitchmaptype' => { 194 => 'PanoramicStitchMapType', 195 => 0x2 },
	'panoramicstitchphi0' => { 194 => 'PanoramicStitchPhi0', 195 => 0x5 },
	'panoramicstitchphi1' => { 194 => 'PanoramicStitchPhi1', 195 => 0x6 },
	'panoramicstitchtheta0' => { 194 => 'PanoramicStitchTheta0', 195 => 0x3 },
	'panoramicstitchtheta1' => { 194 => 'PanoramicStitchTheta1', 195 => 0x4 },
	'panoramicstitchversion' => { 195 => 0x0 },
	'pantry' => { 566 => 'Pantry' },
	'pantryinstanceid' => { 566 => [\'Pantry','PantryInstanceID'] },
	'parallax' => { 134 => 0xb211, 344 => 0x28 },
	'parameters' => { 360 => 'parameters' },
	'parametricdarks' => { 535 => 'ParametricDarks', 537 => 'ParametricDarks' },
	'parametrichighlights' => { 535 => 'ParametricHighlights', 537 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 535 => 'ParametricHighlightSplit', 537 => 'ParametricHighlightSplit' },
	'parametriclights' => { 535 => 'ParametricLights', 537 => 'ParametricLights' },
	'parametricmidtonesplit' => { 535 => 'ParametricMidtoneSplit', 537 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 535 => 'ParametricShadows', 537 => 'ParametricShadows' },
	'parametricshadowsplit' => { 535 => 'ParametricShadowSplit', 537 => 'ParametricShadowSplit' },
	'parentalrating' => { 197 => 'WM/ParentalRating' },
	'parentid' => { 549 => 'parentId' },
	'parentmeasurementid' => { 125 => [\'MeasurementOrFact','MeasurementOrFactParentMeasurementID'] },
	'parentmediaeventid' => { 523 => 'ParentMediaEventID' },
	'parentmeid' => { 523 => 'ParentMEID' },
	'parentproductid' => { 428 => '@ppi' },
	'parentreference1' => { 547 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 547 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 547 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 547 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 547 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 547 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentshorttitle' => { 428 => '@PST' },
	'parenttitle' => { 428 => '@pti' },
	'partialactivecols1' => { 156 => 0x17e8 },
	'partialactivecols2' => { 156 => 0x17f2 },
	'partialactiverows1' => { 156 => 0x17fc },
	'partialactiverows2' => { 156 => 0x1806 },
	'partofcompilation' => { 565 => 'partOfCompilation' },
	'patientbirthdate' => { 520 => 'PatientDOB' },
	'patientid' => { 520 => 'PatientID' },
	'patientname' => { 520 => 'PatientName' },
	'patientsex' => { 520 => 'PatientSex' },
	'patternareaheight' => { 156 => 0x963 },
	'patternareawidth' => { 156 => 0x962 },
	'patterncorrectionfactorscale' => { 156 => 0x969 },
	'patterncropcols1' => { 156 => 0x96c },
	'patterncropcols2' => { 156 => 0x96d },
	'patterncroprows1' => { 156 => 0x96a },
	'patterncroprows2' => { 156 => 0x96b },
	'patternimagerheight' => { 156 => 0x961 },
	'patternimagerwidth' => { 156 => 0x960 },
	'patternx' => { 156 => 0x966 },
	'patterny' => { 156 => 0x967 },
	'pdfversion' => { 551 => 'PDFVersion' },
	'pentaximagesize' => { 410 => 0x9 },
	'pentaxmodelid' => { 388 => 0x0, 410 => 0x5 },
	'pentaxmodeltype' => { 410 => 0x1 },
	'pentaxversion' => { 410 => 0x0 },
	'people' => { 522 => 'People', 527 => 'People' },
	'perchannelblacklevel' => { 45 => 0x157, 46 => 0x16b, 47 => 0x17f, 49 => 0xc4, 50 => [0x2b4,0x2cb,0x2cf], 51 => [0x108,0x14d], 52 => 0x1df, 53 => [0x1f8,0x2d8], 54 => [0x22c,0x30a], 55 => 0x149 },
	'performer' => { 428 => 'perf', 436 => 'perf' },
	'performerkeywords' => { 436 => "\xa9prk" },
	'performers' => { 436 => "\xa9prf" },
	'performerurl' => { 436 => "\xa9prl" },
	'period' => { 197 => 'WM/Period' },
	'peripheralillumcentralradius' => { 517 => 0x8030 },
	'peripheralillumcentralvalue' => { 517 => 0x8031 },
	'peripheralillumination' => { 110 => 0x20702, 116 => 0x68 },
	'peripheralilluminationcorr' => { 68 => 0x1, 399 => 0x2 },
	'peripheralilluminationon' => { 110 => '0x20702.0', 116 => 0x64 },
	'peripheralillumperiphvalue' => { 517 => 0x8032 },
	'peripherallighting' => { 85 => 0x2, 134 => 0x3804 },
	'peripherallightingsetting' => { 86 => 0x5 },
	'peripherallightingvalue' => { 85 => 0x6 },
	'permissions' => { 558 => 'permissions' },
	'permits' => { 533 => 'permits' },
	'person' => { 555 => 'person' },
	'personality' => { 523 => 'Personality' },
	'personheard' => { 549 => 'PersonHeard' },
	'personheardidentifier' => { 549 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 549 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 549 => 'PersonInImage' },
	'personinimagecharacteristic' => { 549 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 549 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 549 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 549 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 549 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 549 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 549 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 549 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 549 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 535 => 'PerspectiveAspect', 537 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 535 => 'PerspectiveHorizontal', 537 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 535 => 'PerspectiveRotate', 537 => 'PerspectiveRotate' },
	'perspectivescale' => { 535 => 'PerspectiveScale', 537 => 'PerspectiveScale' },
	'perspectiveupright' => { 535 => 'PerspectiveUpright', 537 => 'PerspectiveUpright' },
	'perspectivevertical' => { 535 => 'PerspectiveVertical', 537 => 'PerspectiveVertical' },
	'perspectivex' => { 535 => 'PerspectiveX', 537 => 'PerspectiveX' },
	'perspectivey' => { 535 => 'PerspectiveY', 537 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 99 => 0x1 },
	'pf10retainprogramshift' => { 99 => 0xb },
	'pf13drivepriority' => { 99 => 0xe },
	'pf14disablefocussearch' => { 99 => 0xf },
	'pf15disableafassistbeam' => { 99 => 0x10 },
	'pf16autofocuspointshoot' => { 99 => 0x11 },
	'pf17disableafpointsel' => { 99 => 0x12 },
	'pf18enableautoafpointsel' => { 99 => 0x13 },
	'pf19continuousshootspeed' => { 99 => 0x14 },
	'pf19shootingspeedhigh' => { 98 => 0xa },
	'pf19shootingspeedlow' => { 98 => 0x9 },
	'pf1disableshootingmodes' => { 99 => 0x2 },
	'pf1value' => { 98 => 0x1 },
	'pf20limitcontinousshots' => { 99 => 0x15 },
	'pf20maxcontinousshots' => { 98 => 0xb },
	'pf21enablequietoperation' => { 99 => 0x16 },
	'pf23felocktime' => { 98 => 0xd },
	'pf23postreleasetime' => { 98 => 0xe },
	'pf23settimerlengths' => { 99 => 0x18 },
	'pf23shutterbuttontime' => { 98 => 0xc },
	'pf24lightlcdduringbulb' => { 99 => 0x19 },
	'pf25aemode' => { 98 => 0xf },
	'pf25afmode' => { 98 => 0x12 },
	'pf25afpointsel' => { 98 => 0x13 },
	'pf25colormatrix' => { 98 => 0x17 },
	'pf25defaultclearsettings' => { 99 => 0x1a },
	'pf25drivemode' => { 98 => 0x11 },
	'pf25imagesize' => { 98 => 0x14 },
	'pf25meteringmode' => { 98 => 0x10 },
	'pf25parameters' => { 98 => 0x16 },
	'pf25wbmode' => { 98 => 0x15 },
	'pf26shortenreleaselag' => { 99 => 0x1b },
	'pf27reversedialrotation' => { 99 => 0x1c },
	'pf27value' => { 98 => 0x18 },
	'pf28noquickdialexpcomp' => { 99 => 0x1d },
	'pf29quickdialswitchoff' => { 99 => 0x1e },
	'pf2disablemeteringmodes' => { 99 => 0x3 },
	'pf2value' => { 98 => 0x2 },
	'pf30enlargementmode' => { 99 => 0x1f },
	'pf31originaldecisiondata' => { 99 => 0x20 },
	'pf3manualexposuremetering' => { 99 => 0x4 },
	'pf3value' => { 98 => 0x3 },
	'pf4exposuretimelimits' => { 99 => 0x5 },
	'pf4exposuretimemax' => { 98 => 0x5 },
	'pf4exposuretimemin' => { 98 => 0x4 },
	'pf5aperturelimits' => { 99 => 0x6 },
	'pf5aperturemax' => { 98 => 0x7 },
	'pf5aperturemin' => { 98 => 0x6 },
	'pf6presetshootingmodes' => { 99 => 0x7 },
	'pf7bracketcontinuousshoot' => { 99 => 0x8 },
	'pf8bracketshots' => { 98 => 0x8 },
	'pf8setbracketshots' => { 99 => 0x9 },
	'pf9changebracketsequence' => { 99 => 0xa },
	'phasedetectaf' => { 213 => 0x6 },
	'phonenumber' => { 175 => 'Phone' },
	'photoeffect' => { 38 => 0x28 },
	'photoeffecthistoryxml' => { 317 => 0xe9651831 },
	'photoeffects' => { 317 => 0xab5eca5e },
	'photoeffectsblue' => { 319 => 0x8 },
	'photoeffectsgreen' => { 319 => 0x6 },
	'photoeffectsred' => { 319 => 0x4 },
	'photoeffectstype' => { 319 => 0x0 },
	'photographer' => { 126 => 0xa437, 542 => 'Photographer' },
	'photographicsensitivity' => { 542 => 'PhotographicSensitivity' },
	'photoidentifier' => { 1 => 0x2b },
	'photoinfoplayback' => { 324 => '17.6', 333 => '33.6' },
	'photometricinterpretation' => { 126 => 0x106, 561 => 'PhotometricInterpretation' },
	'photosappfeatureflags' => { 1 => 0x1f },
	'photoshootingmenubank' => { 263 => 0x11e, 266 => 0x112, 267 => 0x122, 268 => 0x122, 269 => 0x24, 287 => 0x0 },
	'photoshootingmenubankimagearea' => { 260 => 0x6dd, 263 => 0x144, 266 => 0x134, 267 => 0x148, 268 => 0x148, 287 => '7.1' },
	'photoshopbgrthumbnail' => { 424 => 0x409 },
	'photoshopquality' => { 423 => 0x0 },
	'photoshopthumbnail' => { 424 => 0x40c },
	'photostyle' => { 371 => 0x89 },
	'picasawebgphotoid' => { 540 => 'picasawebGPhotoId' },
	'pick' => { 565 => 'pick' },
	'picklabel' => { 540 => 'PickLabel' },
	'pictinfo' => { 455 => 0x208 },
	'picturecontrol' => { 317 => 0xe2173c47 },
	'picturecontrolactive' => { 320 => 0x0 },
	'picturecontroladjust' => { 275 => 0x30, 276 => 0x30, 277 => 0x36 },
	'picturecontrolbase' => { 275 => 0x18, 276 => 0x18, 277 => 0x1c },
	'picturecontroldata' => { 257 => [0xbd,0x23] },
	'picturecontrolmode' => { 320 => 0x13 },
	'picturecontrolname' => { 275 => 0x4, 276 => 0x4, 277 => 0x8 },
	'picturecontrolquickadjust' => { 275 => 0x31, 276 => 0x31, 277 => 0x37 },
	'pictureeffect' => { 480 => 0x200e },
	'pictureeffect2' => { 489 => 0x1163, 490 => 0x1167, 491 => 0x1143, 492 => 0x11bf, 493 => 0x119b, 494 => 0x1053, 495 => 0x24b, 496 => 0x24b, 497 => 0x23c, 512 => 0x46 },
	'picturefinish' => { 200 => 0x71 },
	'picturemode' => { 134 => 0x1031, 346 => 0x520, 410 => [0xb,0x33], 456 => 0x3d },
	'picturemode2' => { 389 => 0x0 },
	'picturemodebwfilter' => { 346 => 0x525 },
	'picturemodecontrast' => { 346 => 0x523 },
	'picturemodeeffect' => { 346 => 0x52d },
	'picturemodehue' => { 346 => 0x522 },
	'picturemodesaturation' => { 346 => 0x521 },
	'picturemodesharpness' => { 346 => 0x524 },
	'picturemodestrength' => { 456 => 0x113 },
	'picturemodetone' => { 346 => 0x526 },
	'pictureprofile' => { 489 => [0x115e,0x115f], 490 => [0x1162,0x1163], 491 => [0x113e,0x113f], 492 => [0x11ba,0x11bb], 493 => [0x1196,0x1197], 494 => [0x104e,0x104f], 495 => [0x246,0x247], 496 => [0x246,0x247], 497 => [0x237,0x238] },
	'picturestyle' => { 8 => [0x4b,0x51], 9 => 0xf4, 10 => 0x6c, 11 => 0x86, 12 => 0x73, 16 => 0xab, 17 => 0xa7, 18 => 0xb0, 19 => 0x6c, 20 => 0xa7, 21 => 0xf4, 22 => 0xb3, 24 => 0xf4, 25 => 0xfa, 27 => 0x169, 80 => 0xa, 110 => 0x20301, 116 => 0x2 },
	'picturestylepc' => { 70 => 0x4009 },
	'picturestyleuserdef' => { 70 => 0x4008 },
	'picturewizard' => { 453 => 0x21 },
	'picturewizardcolor' => { 452 => 0x1 },
	'picturewizardcontrast' => { 452 => 0x4 },
	'picturewizardmode' => { 452 => 0x0 },
	'picturewizardsaturation' => { 452 => 0x2 },
	'picturewizardsharpness' => { 452 => 0x3 },
	'pipelineversion' => { 194 => 'PipelineVersion' },
	'pitch' => { 122 => 0x6, 325 => '4.1', 337 => '4.1', 436 => ['ptch',"\xa9fpt"] },
	'pitchangle' => { 67 => 0x5, 273 => 0x4, 346 => 0x904, 361 => 'PitchAngle', 371 => 0x91, 408 => 0x2, 409 => 0x5, 451 => 0x1 },
	'pitchshift' => { 427 => 'player.movie.audio.pitchshift', 430 => 'player.movie.audio.pitchshift' },
	'pixelaspectratio' => { 429 => 'pasp' },
	'pixelclockfrequency' => { 156 => 0x40b },
	'pixelcorrectionoffset' => { 156 => 0x972 },
	'pixelcorrectionscale' => { 156 => 0x971 },
	'pixelscale' => { 126 => 0x830e },
	'pixelshiftdelay' => { 261 => 0x38c, 265 => 0x802 },
	'pixelshiftinfo' => { 480 => 0x202f },
	'pixelshiftinterval' => { 261 => 0x38e },
	'pixelshiftnumbershots' => { 261 => 0x38a, 265 => 0x800 },
	'pixelshiftoffset' => { 134 => 0x1106 },
	'pixelshiftresolution' => { 411 => 0x0 },
	'pixelshiftshooting' => { 261 => 0x388, 265 => 0x7fe },
	'pixelshiftshots' => { 134 => 0x1105 },
	'pixelsperunitx' => { 359 => 0x0 },
	'pixelsperunity' => { 359 => 0x4 },
	'pixelunits' => { 359 => 0x8 },
	'planarconfiguration' => { 126 => 0x11c, 561 => 'PlanarConfiguration' },
	'plane' => { 139 => [\'Planes','PlanesPlane'] },
	'planeboundary' => { 139 => [\'Planes','PlanesPlaneBoundary'] },
	'planeboundaryvertexcount' => { 139 => [\'Planes','PlanesPlaneBoundaryVertexCount'] },
	'planeextentx' => { 139 => [\'Planes','PlanesPlaneExtentX'] },
	'planeextentz' => { 139 => [\'Planes','PlanesPlaneExtentZ'] },
	'planepose' => { 139 => [\'Planes','PlanesPlanePose'] },
	'planeposepositionx' => { 139 => [\'Planes','PlanesPlanePosePositionX'] },
	'planeposepositiony' => { 139 => [\'Planes','PlanesPlanePosePositionY'] },
	'planeposepositionz' => { 139 => [\'Planes','PlanesPlanePosePositionZ'] },
	'planeposerotationw' => { 139 => [\'Planes','PlanesPlanePoseRotationW'] },
	'planeposerotationx' => { 139 => [\'Planes','PlanesPlanePoseRotationX'] },
	'planeposerotationy' => { 139 => [\'Planes','PlanesPlanePoseRotationY'] },
	'planeposerotationz' => { 139 => [\'Planes','PlanesPlanePoseRotationZ'] },
	'planeposetimestamp' => { 139 => [\'Planes','PlanesPlanePoseTimestamp'] },
	'planes' => { 139 => 'Planes' },
	'planningref' => { 549 => 'PlanningRef' },
	'planningrefidentifier' => { 549 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 549 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 549 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 570 => 'PlateNames' },
	'platform' => { 555 => 'platform' },
	'playallframes' => { 436 => 'AllF' },
	'playbackbutton' => { 265 => 0x804, 268 => 0x808 },
	'playbackbuttonplaybackmode' => { 265 => 0x80e, 268 => 0x814 },
	'playbackflickdown' => { 340 => 0x149, 341 => 0x159, 342 => 0x159, 343 => 0x171 },
	'playbackflickup' => { 340 => 0x145, 341 => 0x155, 342 => 0x155, 343 => 0x16d },
	'playbackmenustime' => { 329 => '20.1', 330 => '21.1', 331 => '21.1' },
	'playbackmonitorofftime' => { 324 => '25.2', 325 => '36.1', 327 => '36.1', 328 => '36.1', 332 => '35.1', 333 => '8.1', 334 => '35.1', 337 => '36.1', 338 => '36.1', 339 => '21.1', 340 => 0x37, 341 => 0x33, 342 => 0x33, 343 => 0x33 },
	'playbackzoom' => { 325 => '37.1' },
	'playdisplay' => { 202 => 0x4e },
	'playerversion' => { 430 => 'player.version' },
	'playgap' => { 428 => 'pgap' },
	'playmode' => { 436 => 'SDLN' },
	'playselection' => { 436 => 'SelO' },
	'plusversion' => { 357 => 'Version' },
	'pmversion' => { 422 => 'PMVersion' },
	'pngwarning' => { 360 => 'Warning' },
	'podcast' => { 428 => 'pcst' },
	'podcasturl' => { 428 => 'purl' },
	'poilevel' => { 256 => 0x8 },
	'portraitimpressionbalance' => { 261 => 0x378, 263 => 0x26e, 278 => 0xa0 },
	'portraitnote' => { 141 => 'PortraitNote' },
	'portraitoutputhighlightpoint' => { 116 => 0x1d },
	'portraitoutputshadowpoint' => { 116 => 0x1e },
	'portraitrawcolortone' => { 116 => 0x16 },
	'portraitrawcontrast' => { 116 => 0x18 },
	'portraitrawhighlight' => { 116 => 0x76 },
	'portraitrawhighlightpoint' => { 116 => 0x1b },
	'portraitrawlinear' => { 116 => 0x19 },
	'portraitrawsaturation' => { 116 => 0x17 },
	'portraitrawshadow' => { 116 => 0x7f },
	'portraitrawshadowpoint' => { 116 => 0x1c },
	'portraitrawsharpness' => { 116 => 0x1a },
	'portraitrefiner' => { 120 => 0x302b },
	'portraitrequest' => { 141 => 'PortraitRequest' },
	'portraitunsharpmaskfineness' => { 116 => 0x9a },
	'portraitunsharpmaskstrength' => { 116 => 0x98 },
	'portraitunsharpmaskthreshold' => { 116 => 0x9c },
	'portraitversion' => { 141 => 'PortraitVersion' },
	'pose' => { 139 => 'Pose' },
	'poseheadingdegrees' => { 147 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 147 => 'PosePitchDegrees' },
	'posepositionx' => { 139 => [\'Pose','PosePositionX'] },
	'posepositiony' => { 139 => [\'Pose','PosePositionY'] },
	'posepositionz' => { 139 => [\'Pose','PosePositionZ'] },
	'poserolldegrees' => { 147 => 'PoseRollDegrees' },
	'poserotationw' => { 139 => [\'Pose','PoseRotationW'] },
	'poserotationx' => { 139 => [\'Pose','PoseRotationX'] },
	'poserotationy' => { 139 => [\'Pose','PoseRotationY'] },
	'poserotationz' => { 139 => [\'Pose','PoseRotationZ'] },
	'posetimestamp' => { 139 => [\'Pose','PoseTimestamp'] },
	'positiondescriptor' => { 554 => 'positionDescriptor' },
	'postalcode' => { 179 => 'PostalCode' },
	'postcropvignetteamount' => { 535 => 'PostCropVignetteAmount', 537 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 535 => 'PostCropVignetteFeather', 537 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 535 => 'PostCropVignetteHighlightContrast', 537 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 535 => 'PostCropVignetteMidpoint', 537 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 535 => 'PostCropVignetteRoundness', 537 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 535 => 'PostCropVignetteStyle', 537 => 'PostCropVignetteStyle' },
	'postfocusmerging' => { 371 => 0xbf },
	'postreleaseburstlength' => { 267 => 0x714, 268 => 0x784, 341 => 0x289 },
	'potentialface1position' => { 476 => 0xb },
	'potentialface2position' => { 476 => 0x15 },
	'potentialface3position' => { 476 => 0x1f },
	'potentialface4position' => { 476 => 0x29 },
	'potentialface5position' => { 476 => 0x33 },
	'potentialface6position' => { 476 => 0x3d },
	'potentialface7position' => { 476 => 0x47 },
	'potentialface8position' => { 476 => 0x51 },
	'poweravailable' => { 386 => '0.2' },
	'powersource' => { 386 => '0.1' },
	'poweruptime' => { 257 => 0xb6 },
	'preaf' => { 133 => '0.2' },
	'precaptureframes' => { 351 => 0x300 },
	'predictor' => { 126 => 0x13d },
	'preflashreturnstrength' => { 295 => 0x28a },
	'prefs' => { 149 => 0xdd, 422 => 'Prefs' },
	'prereadfastresetcount' => { 156 => 0x187e },
	'prereleaseburstlength' => { 267 => 0x712, 268 => 0x782, 341 => 0x287 },
	'preservedfilename' => { 566 => 'PreservedFileName' },
	'preservedspecimen' => { 125 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 125 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presettype' => { 535 => 'PresetType', 537 => 'PresetType' },
	'presetwhitebalance' => { 202 => 0x24, 517 => 0x8002 },
	'presetwhitebalanceadj' => { 517 => 0x8014 },
	'pressure' => { 126 => 0x9402, 542 => 'Pressure' },
	'previewapplicationname' => { 126 => 0xc716 },
	'previewapplicationversion' => { 126 => 0xc717 },
	'previewbutton' => { 324 => ['14.1','15.1'], 325 => '15.1', 327 => '15.1', 328 => '15.1', 333 => '29.1', 334 => '14.1', 337 => '15.1', 338 => '15.1' },
	'previewbuttonplusdials' => { 324 => ['14.2','15.2'], 325 => '15.2', 327 => '43.1', 328 => '43.1', 333 => '31.2', 337 => '43.1', 338 => '43.1' },
	'previewcolorspace' => { 126 => 0xc71a },
	'previewcropbottom' => { 421 => 0xef },
	'previewcropleft' => { 421 => 0xec },
	'previewcropright' => { 421 => 0xee },
	'previewcroptop' => { 421 => 0xed },
	'previewdate' => { 434 => 0x0 },
	'previewdatetime' => { 126 => 0xc71b },
	'previewimage' => { 120 => 0x2000, 121 => 'Exif-PreviewImage', 127 => 'PreviewImage', 129 => 0x4, 184 => 'data', 204 => 0x81, 351 => 0x280, 369 => 0x300, 428 => 'snal', 436 => ['SIGM','mcvr'], 480 => 0x2001 },
	'previewimageborders' => { 410 => 0x3e },
	'previewimageheight' => { 79 => 0x4, 160 => 0xfa58 },
	'previewimagelength' => { 79 => 0x2, 120 => 0x3, 126 => [0x117,0x202], 204 => 0x89, 279 => 0x202, 346 => 0x102, 351 => 0x1037, 410 => 0x3, 445 => 0x1e, 450 => 0x3, 456 => [0x1b,0x1d], 469 => 0x202 },
	'previewimagename' => { 184 => '1Name' },
	'previewimagesize' => { 120 => 0x2, 165 => 0x2, 184 => 'ImageSize', 410 => 0x2, 456 => [0x1c,0x1e], 480 => 0xb02c, 517 => 0x9012 },
	'previewimagestart' => { 79 => 0x5, 120 => 0x4, 126 => [0x111,0x201], 204 => 0x88, 279 => 0x201, 346 => 0x101, 351 => 0x1036, 410 => 0x4, 445 => 0x1c, 450 => 0x2, 456 => [0x1a,0x1c], 469 => 0x201 },
	'previewimagetype' => { 184 => '0Type' },
	'previewimagevalid' => { 346 => 0x100, 351 => 0x1035 },
	'previewimagewidth' => { 79 => 0x3, 160 => 0xfa57 },
	'previewquality' => { 79 => 0x1 },
	'previewsettingsdigest' => { 126 => 0xc719 },
	'previewsettingsname' => { 126 => 0xc718 },
	'primaryafpoint' => { 211 => 0x7, 212 => 0x44, 213 => 0x7, 214 => 0x38 },
	'primarychromaticities' => { 126 => 0x13f, 561 => 'PrimaryChromaticities' },
	'primaryftp' => { 523 => 'PrimaryFTP' },
	'primaryslot' => { 269 => 0x25, 287 => 0x2 },
	'printim' => { 126 => 0xc4a5 },
	'prioritysetinawb' => { 480 => 0x202b },
	'prioritysetupshutterrelease' => { 202 => 0x1d, 466 => 0x28 },
	'privatertkinfo' => { 526 => 'privateRTKInfo' },
	'processbordercolsleft' => { 156 => 0xc61 },
	'processbordercolsright' => { 156 => 0xc62 },
	'processborderrowsbottom' => { 156 => 0xc64 },
	'processborderrowstop' => { 156 => 0xc63 },
	'processingsoftware' => { 126 => 0xb },
	'processversion' => { 535 => 'ProcessVersion', 537 => 'ProcessVersion' },
	'producer' => { 197 => 'WM/Producer', 356 => 'Producer', 428 => "\xa9prd", 430 => 'producer', 436 => "\xa9prd", 551 => 'Producer' },
	'producerkeywords' => { 436 => "\xa9pdk" },
	'productcode' => { 555 => 'productCode' },
	'productid' => { 150 => 0x32, 428 => 'prID', 554 => 'productID' },
	'productidtype' => { 554 => 'productIDType' },
	'productinimage' => { 549 => 'ProductInImage' },
	'productinimagedescription' => { 549 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 549 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 549 => [\'ProductInImage','ProductInImageProductName'] },
	'productinimageproductid' => { 549 => [\'ProductInImage','ProductInImageProductId'] },
	'productioncode' => { 388 => 0x2 },
	'productorserviceconstraints' => { 357 => 'ProductOrServiceConstraints' },
	'productversion' => { 428 => 'VERS' },
	'profession' => { 555 => 'profession' },
	'profile' => { 139 => [\'Profiles','ProfilesProfile'] },
	'profilecalibrationsig' => { 126 => 0xc6f4 },
	'profilecameraindices' => { 139 => [\'Profiles','ProfilesProfileCameraIndices'] },
	'profilecopyright' => { 126 => 0xc6fe },
	'profiledynamicrange' => { 126 => 0xcd47 },
	'profileembedpolicy' => { 126 => 0xc6fd },
	'profilegaintablemap' => { 126 => 0xcd2d },
	'profilegaintablemap2' => { 126 => 0xcd40 },
	'profilegroupname' => { 126 => 0xcd48 },
	'profilehuesatmapdata1' => { 126 => 0xc6fa },
	'profilehuesatmapdata2' => { 126 => 0xc6fb },
	'profilehuesatmapdata3' => { 126 => 0xcd39 },
	'profilehuesatmapdims' => { 126 => 0xc6f9 },
	'profilehuesatmapencoding' => { 126 => 0xc7a3 },
	'profilelooktabledata' => { 126 => 0xc726 },
	'profilelooktabledims' => { 126 => 0xc725 },
	'profilelooktableencoding' => { 126 => 0xc7a4 },
	'profilename' => { 126 => 0xc6f8, 358 => 'iCCP-name' },
	'profiles' => { 139 => 'Profiles' },
	'profiletonecurve' => { 126 => 0xc6fc },
	'profiletype' => { 139 => [\'Profiles','ProfilesProfileType'] },
	'programiso' => { 371 => 0x3c },
	'programline' => { 389 => '1.1' },
	'programmode' => { 207 => 0x5 },
	'programshift' => { 257 => 0xd },
	'programversion' => { 149 => 0x46 },
	'prohibits' => { 533 => 'prohibits' },
	'projectiontype' => { 147 => 'ProjectionType', 148 => 'ProjectionType' },
	'projectname' => { 565 => 'projectName' },
	'projectref' => { 565 => 'projectRef' },
	'projectrefpath' => { 565 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 565 => [\'projectRef','projectRefType'] },
	'promotionurl' => { 197 => 'WM/PromotionURL' },
	'propertyreleaseid' => { 357 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 357 => 'PropertyReleaseStatus' },
	'provider' => { 197 => 'WM/Provider' },
	'province-state' => { 149 => 0x5f },
	'publicationdate' => { 555 => 'publicationDate' },
	'publicationdatea-platform' => { 555 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 555 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 555 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 555 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 555 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 549 => 'PublicationEvent' },
	'publicationeventdate' => { 549 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 549 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 549 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 555 => 'publicationName' },
	'publisher' => { 197 => 'WM/Publisher', 428 => "\xa9pub", 430 => 'publisher', 538 => 'publisher' },
	'publishingfrequency' => { 555 => 'publishingFrequency' },
	'pulldown' => { 565 => 'pullDown' },
	'purchasedate' => { 428 => 'purd' },
	'purplehsl' => { 110 => 0x20916 },
	'pxshiftperiphedgenr' => { 517 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 517 => 0x9014 },
	'quality' => { 0 => 0x1, 38 => 0x3, 119 => 0x2, 120 => 0x3002, 134 => 0x1000, 158 => 0x9, 257 => 0x4, 306 => 0x3, 351 => 0x201, 366 => 0x300, 410 => 0x8, 417 => 0x2, 456 => 0x16, 466 => 0x56, 467 => 0x56, 468 => 0xb, 480 => [0x102,0x202e] },
	'quality2' => { 489 => 0x1170, 490 => 0x1174, 491 => 0x1150, 493 => 0x11a8, 494 => 0x1060, 495 => 0x258, 496 => 0x258, 497 => 0x247, 503 => 0x29, 504 => 0x25, 505 => 0x2a },
	'qualitybutton' => { 342 => 0x17d, 343 => 0x195 },
	'qualitybuttonplaybackmode' => { 342 => 0x1bf, 343 => 0x1d7 },
	'qualityhint' => { 1 => 0x1a },
	'qualitymode' => { 120 => 0x8 },
	'quantizationmethod' => { 151 => 0x78 },
	'quickadjust' => { 320 => 0x2a },
	'quickcontroldialinmeter' => { 91 => 0x703 },
	'quickfix' => { 317 => 0x416391c6 },
	'quickshot' => { 455 => 0x213 },
	'quiettime' => { 156 => 0x188a },
	'radialdistortioncoefficient1' => { 232 => 0x14 },
	'radialdistortioncoefficient2' => { 232 => 0x1c },
	'radialdistortioncoefficient3' => { 232 => 0x24 },
	'rads' => { 436 => 'rads' },
	'rangefinder' => { 329 => '4.1', 330 => '5.1', 331 => '5.1' },
	'rangemask' => { 535 => 'RangeMaskMapInfo', 537 => 'RangeMaskMapInfo' },
	'rangemaskmapinfo' => { 535 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'], 537 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'] },
	'rangemaskmapinfolabmax' => { 535 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'], 537 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'] },
	'rangemaskmapinfolabmin' => { 535 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'], 537 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'] },
	'rangemaskmapinfolumeq' => { 535 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'], 537 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'] },
	'rangemaskmapinforgbmax' => { 535 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'], 537 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'] },
	'rangemaskmapinforgbmin' => { 535 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'], 537 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'] },
	'rasterizedcaption' => { 149 => 0x7d },
	'rating' => { 110 => 0x10100, 126 => 0x4746, 134 => 0x1431, 421 => 0xdf, 428 => 'rtng', 436 => 'rtng', 480 => 0x2002, 529 => 'rating', 539 => 'rating', 549 => 'Rating', 555 => 'rating', 563 => 'Rating' },
	'ratingpercent' => { 126 => 0x4749, 196 => 'Rating', 428 => 'rate', 563 => 'RatingPercent' },
	'ratingregion' => { 549 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 549 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 549 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 549 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 549 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpsaltituderef' => { 549 => [\'Rating','RatingRatingRegionGPSAltitudeRef'] },
	'ratingregiongpslatitude' => { 549 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 549 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 549 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 549 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 549 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 549 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 549 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 549 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 549 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 549 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 549 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 549 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 549 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 89 => 0x8, 204 => 0x109, 389 => 0xd },
	'rawbrightnessadj' => { 110 => 0x20001, 115 => 0x38 },
	'rawburstimagecount' => { 81 => 0x2 },
	'rawburstimagenum' => { 81 => 0x1 },
	'rawcoloradj' => { 115 => 0x2e },
	'rawcropbottom' => { 421 => 0xd4 },
	'rawcropleft' => { 421 => 0xd1 },
	'rawcropright' => { 421 => 0xd3 },
	'rawcroptop' => { 421 => 0xd2 },
	'rawcustomsaturation' => { 115 => 0x30 },
	'rawcustomtone' => { 115 => 0x34 },
	'rawdata' => { 453 => 0xa048 },
	'rawdatabyteorder' => { 453 => 0x40 },
	'rawdatacfapattern' => { 453 => 0x50 },
	'rawdatauniqueid' => { 126 => 0xc65d },
	'rawdepth' => { 206 => 0x10 },
	'rawdevartfilter' => { 353 => 0x121 },
	'rawdevautogradation' => { 353 => 0x119 },
	'rawdevcolorspace' => { 352 => 0x108, 353 => 0x109 },
	'rawdevcontrastvalue' => { 352 => 0x106, 353 => 0x105 },
	'rawdeveditstatus' => { 352 => 0x10b },
	'rawdevelopingsoftware' => { 126 => 0xa43a, 542 => 'RAWDevelopingSoftware' },
	'rawdevelopmentprocess' => { 410 => 0x62 },
	'rawdevengine' => { 352 => 0x109, 353 => 0x10b },
	'rawdevexposurebiasvalue' => { 352 => 0x100, 353 => 0x100 },
	'rawdevgradation' => { 353 => 0x112 },
	'rawdevgraypoint' => { 352 => 0x103, 353 => 0x104 },
	'rawdevmemorycoloremphasis' => { 352 => 0x105, 353 => 0x108 },
	'rawdevnoisereduction' => { 352 => 0x10a, 353 => 0x10a },
	'rawdevpicturemode' => { 353 => 0x10c },
	'rawdevpm_bwfilter' => { 353 => 0x110 },
	'rawdevpmcontrast' => { 353 => 0x10e },
	'rawdevpmnoisefilter' => { 353 => 0x120 },
	'rawdevpmpicturetone' => { 353 => 0x111 },
	'rawdevpmsaturation' => { 353 => 0x10d },
	'rawdevpmsharpness' => { 353 => 0x10f },
	'rawdevsaturation3' => { 353 => 0x113 },
	'rawdevsaturationemphasis' => { 352 => 0x104, 353 => 0x107 },
	'rawdevsettings' => { 352 => 0x10c },
	'rawdevsharpnessvalue' => { 352 => 0x107, 353 => 0x106 },
	'rawdevversion' => { 352 => 0x0, 353 => 0x0 },
	'rawdevwbfineadjustment' => { 352 => 0x102, 353 => 0x103 },
	'rawdevwhitebalance' => { 353 => 0x101 },
	'rawdevwhitebalancevalue' => { 352 => 0x101, 353 => 0x102 },
	'rawfile' => { 126 => 0xfe4c },
	'rawfilename' => { 535 => 'RawFileName', 537 => 'RawFileName' },
	'rawfiletype' => { 480 => 0x2029 },
	'rawformat' => { 376 => 0x2d, 419 => 0x10e },
	'rawimagecenter' => { 257 => 0x99 },
	'rawimagedigest' => { 126 => 0xc71c },
	'rawimagesize' => { 410 => 0x39 },
	'rawinfoversion' => { 354 => 0x0 },
	'rawjpgheight' => { 106 => 0x4 },
	'rawjpgquality' => { 62 => 0x6, 106 => 0x1 },
	'rawjpgsize' => { 62 => 0x7, 106 => 0x2 },
	'rawjpgwidth' => { 106 => 0x3 },
	'rawmeasuredrggb' => { 48 => 0x26a, 50 => 0x280, 52 => 0x194, 53 => [0x1ad,0x26b] },
	'rawrppused' => { 529 => 'rawrppused' },
	'rawtopreviewgain' => { 126 => 0xc7a8 },
	'readouttypeactual' => { 156 => 0x1903 },
	'readouttyperequested' => { 156 => 0x1902 },
	'reardisplay' => { 324 => '12.3', 325 => '6.2' },
	'recdevice' => { 549 => 'RecDevice' },
	'recdeviceattlensdescription' => { 549 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 549 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 549 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 549 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 549 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 557 => 'recipeEndingPage' },
	'recipepagerange' => { 557 => 'recipePageRange' },
	'recipesource' => { 557 => 'recipeSource' },
	'recipestartingpage' => { 557 => 'recipeStartingPage' },
	'recipetitle' => { 557 => 'recipeTitle' },
	'recognizedface1age' => { 364 => 0x20 },
	'recognizedface1name' => { 364 => 0x4 },
	'recognizedface1position' => { 364 => 0x18 },
	'recognizedface2age' => { 364 => 0x50 },
	'recognizedface2name' => { 364 => 0x34 },
	'recognizedface2position' => { 364 => 0x48 },
	'recognizedface3age' => { 364 => 0x80 },
	'recognizedface3name' => { 364 => 0x64 },
	'recognizedface3position' => { 364 => 0x78 },
	'recognizedfaceflags' => { 371 => 0x63 },
	'recommendedexposureindex' => { 126 => 0x8832, 542 => 'RecommendedExposureIndex' },
	'record' => { 125 => 'Record' },
	'recordbasisofrecord' => { 125 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 125 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 125 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 125 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 125 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 125 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 202 => 0x4d },
	'recorddynamicproperties' => { 125 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 104 => 0x1804 },
	'recordinformationwithheld' => { 125 => [\'Record','RecordInformationWithheld'] },
	'recordingcopyright' => { 436 => "\xa9phg" },
	'recordingformat' => { 446 => 0x1000 },
	'recordingmode' => { 119 => 0x1, 417 => 0x1 },
	'recordinstitutioncode' => { 125 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 125 => [\'Record','RecordInstitutionID'] },
	'recordlabelname' => { 436 => "\xa9lab" },
	'recordlabelurl' => { 436 => "\xa9lal" },
	'recordlocationdata' => { 266 => 0x660, 267 => 0x690, 268 => 0x6f8 },
	'recordmode' => { 38 => 0x9, 120 => 0x3000 },
	'recordownerinstitutioncode' => { 125 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 455 => 0x217 },
	'redbalance' => { 351 => 0x1017, 376 => 0x11, 410 => 0x1c },
	'redcurvelimits' => { 115 => 0x18a },
	'redcurvepoints' => { 114 => 0x2d, 115 => 0x160 },
	'redeyecorrection' => { 321 => 0x0 },
	'redeyeinfo' => { 535 => 'RedEyeInfo', 537 => 'RedEyeInfo' },
	'redeyereduction' => { 202 => 0x41, 466 => 0x6a, 468 => 0x28 },
	'redeyeremoval' => { 371 => 0xb9 },
	'redhsl' => { 110 => 0x20910 },
	'redhue' => { 535 => 'RedHue', 537 => 'RedHue' },
	'redsaturation' => { 535 => 'RedSaturation', 537 => 'RedSaturation' },
	'reductionmatrix1' => { 126 => 0xc625 },
	'reductionmatrix2' => { 126 => 0xc626 },
	'reductionmatrix3' => { 126 => 0xcd3a },
	'reelname' => { 126 => 0xc789, 436 => 'reel' },
	'reference1' => { 547 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 547 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 547 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 547 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 547 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 547 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 126 => 0x214, 561 => 'ReferenceBlackWhite' },
	'referencedate' => { 149 => 0x2f },
	'referencenumber' => { 149 => 0x32 },
	'references' => { 175 => 'References' },
	'referenceservice' => { 149 => 0x2d },
	'regionappliedtodimensions' => { 190 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 190 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 190 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 190 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 190 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 190 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 190 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 190 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 190 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 190 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 190 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 190 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 357 => 'RegionConstraints' },
	'regiondescription' => { 190 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 190 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 190 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 190 => 'Regions' },
	'regioninfoacdsee' => { 518 => 'Regions' },
	'regioninfodateregionsvalid' => { 193 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 193 => 'RegionInfo' },
	'regioninforegions' => { 193 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 190 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 190 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 193 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 193 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 193 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 193 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 193 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 190 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 190 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 190 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 549 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 549 => 'RegistryId' },
	'registryitemid' => { 549 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 549 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 173 => 'data' },
	'relatedaudiofilename' => { 173 => '1Name' },
	'relatedaudiofiletype' => { 173 => '0Type' },
	'relatedimagefileformat' => { 126 => 0x1000 },
	'relatedimageheight' => { 126 => 0x1002 },
	'relatedimagewidth' => { 126 => 0x1001 },
	'relatedresourceid' => { 125 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 126 => 0xa004, 541 => 'RelatedSoundFile' },
	'relatedvideofile' => { 187 => 'data' },
	'relatedvideofilename' => { 187 => '1Name' },
	'relatedvideofiletype' => { 187 => '0Type' },
	'relation' => { 538 => 'relation' },
	'relationshipaccordingto' => { 125 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 125 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 125 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipofresourceid' => { 125 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResourceID'] },
	'relationshipremarks' => { 125 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 123 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 565 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 565 => 'relativeTimestamp' },
	'relativetimestampscale' => { 565 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 565 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 324 => '17.8', 325 => '18.5', 327 => '18.4', 328 => '18.4', 333 => '33.8', 334 => '17.6', 337 => '18.5', 338 => '18.4' },
	'releasedate' => { 149 => 0x1e, 428 => 'rldt', 529 => 'ReleaseDate', 565 => 'releaseDate' },
	'releasemode' => { 120 => 0x3001, 262 => 0x5c, 297 => 0x184d, 480 => 0xb049 },
	'releasemode2' => { 489 => 0x112c, 490 => [0x112c,0x8], 491 => [0x1108,0x8], 492 => [0x1184,0x8], 493 => [0x1160,0x8], 494 => [0x4,0x1018], 495 => [0x4,0x210], 496 => [0x4,0x210], 497 => [0x4,0x208], 499 => [0x67,0x3f], 500 => [0x6b,0x6d,0x73,0x4b], 501 => [0x6b,0x4b], 502 => 0x1f, 503 => 0x10, 504 => 0x10, 505 => 0x9, 512 => 0x34 },
	'releasemode3' => { 489 => 0x1128, 490 => 0x1128, 491 => 0x1104, 492 => 0x1180, 493 => 0x115c, 494 => 0x1014, 495 => 0x20c, 496 => 0x20c, 497 => 0x204 },
	'releasemodebutton' => { 265 => 0x8a0 },
	'releasemodebuttonplaybackmode' => { 265 => 0x8a8 },
	'releaseready' => { 549 => 'ReleaseReady' },
	'releasesetting' => { 104 => 0x1016 },
	'releasetime' => { 149 => 0x23, 529 => 'ReleaseTime' },
	'remoteonduration' => { 326 => '3.4', 329 => '17.2', 330 => '18.2', 331 => '18.2', 332 => '18.2', 334 => '18.2', 335 => '4.3', 339 => '19.2' },
	'renditionclass' => { 566 => 'RenditionClass' },
	'renditionof' => { 566 => 'RenditionOf' },
	'renditionofalternatepaths' => { 566 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 566 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 566 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 566 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 566 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 566 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 566 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 566 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 566 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 566 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 566 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 566 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 566 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 566 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 566 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 566 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 566 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 566 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 566 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 566 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 566 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 566 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 566 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 566 => 'RenditionParams' },
	'repeatingflashcount' => { 235 => 0xd, 236 => 0xe, 237 => 0xe, 238 => 0xe, 239 => 0xe, 240 => 0xe, 333 => '17.2', 334 => '24.2', 335 => '9.2', 336 => '24.2', 339 => '25.2' },
	'repeatingflashcountbuilt-in' => { 304 => 0x4db },
	'repeatingflashcountexternal' => { 304 => 0x4c3 },
	'repeatingflashoutput' => { 333 => '17.1', 334 => '24.1', 335 => '9.1', 336 => '24.1', 339 => '25.1' },
	'repeatingflashoutputexternal' => { 304 => 0x4c0 },
	'repeatingflashrate' => { 235 => 0xc, 236 => 0xd, 237 => 0xd, 238 => 0xd, 239 => 0xd, 240 => 0xd, 333 => '18.1', 334 => '25.1', 335 => '10.1', 336 => '25.1', 339 => '26.1' },
	'repeatingflashratebuilt-in' => { 304 => 0x4da },
	'repeatingflashrateexternal' => { 304 => 0x4c2 },
	'requirements' => { 436 => "\xa9req" },
	'requires' => { 533 => 'requires' },
	'resampleparams' => { 565 => 'resampleParams' },
	'resampleparamsquality' => { 565 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 156 => 0xe50 },
	'resamplingkerneldenominators067' => { 156 => 0xe4f },
	'resamplingkerneldenominators100' => { 156 => 0xe51 },
	'resaved' => { 455 => 0x21e },
	'resetblacksegrows' => { 156 => 0x181a },
	'resolution' => { 180 => 'Resolution' },
	'resolutionmode' => { 456 => [0x87,0x4] },
	'resolutionunit' => { 126 => 0x128, 152 => 0x2, 561 => 'ResolutionUnit' },
	'resourceid' => { 125 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 125 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 125 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 91 => 0x612 },
	'restrictions' => { 558 => 'restrictions' },
	'retouchareafeather' => { 535 => [\'RetouchAreas','RetouchAreasFeather'], 537 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 535 => [\'RetouchAreas','RetouchAreasMasksAlpha'], 537 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 535 => [\'RetouchAreas','RetouchAreasMasksAngle'], 537 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 535 => [\'RetouchAreas','RetouchAreasMasksBottom'], 537 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 535 => [\'RetouchAreas','RetouchAreasMasksCenterValue'], 537 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 535 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'], 537 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 535 => [\'RetouchAreas','RetouchAreasMasksDabs'], 537 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 535 => [\'RetouchAreas','RetouchAreasMasksFeather'], 537 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 535 => [\'RetouchAreas','RetouchAreasMasksFlipped'], 537 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 535 => [\'RetouchAreas','RetouchAreasMasksFlow'], 537 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 535 => [\'RetouchAreas','RetouchAreasMasksFullX'], 537 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 535 => [\'RetouchAreas','RetouchAreasMasksFullY'], 537 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskinputdigest' => { 535 => [\'RetouchAreas','RetouchAreasMasksInputDigest'], 537 => [\'RetouchAreas','RetouchAreasMasksInputDigest'] },
	'retouchareamaskleft' => { 535 => [\'RetouchAreas','RetouchAreasMasksLeft'], 537 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmaskactive' => { 535 => [\'RetouchAreas','RetouchAreasMasksMaskActive'], 537 => [\'RetouchAreas','RetouchAreasMasksMaskActive'] },
	'retouchareamaskmaskblendmode' => { 535 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'], 537 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'] },
	'retouchareamaskmaskdigest' => { 535 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'], 537 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'] },
	'retouchareamaskmaskinverted' => { 535 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'], 537 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'] },
	'retouchareamaskmaskname' => { 535 => [\'RetouchAreas','RetouchAreasMasksMaskName'], 537 => [\'RetouchAreas','RetouchAreasMasksMaskName'] },
	'retouchareamaskmasks' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasks'], 537 => [\'RetouchAreas','RetouchAreasMasksMasks'] },
	'retouchareamaskmasksalpha' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'] },
	'retouchareamaskmasksangle' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'] },
	'retouchareamaskmasksbottom' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'] },
	'retouchareamaskmaskscentervalue' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'] },
	'retouchareamaskmaskscenterweight' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'] },
	'retouchareamaskmasksdabs' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'] },
	'retouchareamaskmasksfeather' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'] },
	'retouchareamaskmasksflipped' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'] },
	'retouchareamaskmasksflow' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'] },
	'retouchareamaskmasksfullx' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'] },
	'retouchareamaskmasksfully' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'] },
	'retouchareamaskmasksinputdigest' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'] },
	'retouchareamaskmasksleft' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'] },
	'retouchareamaskmasksmaskactive' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'] },
	'retouchareamaskmasksmaskblendmode' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'] },
	'retouchareamaskmasksmaskdigest' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'] },
	'retouchareamaskmasksmaskinverted' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'] },
	'retouchareamaskmasksmaskname' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'] },
	'retouchareamaskmasksmasksubtype' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'] },
	'retouchareamaskmasksmasksyncid' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'] },
	'retouchareamaskmasksmaskversion' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'] },
	'retouchareamaskmasksmidpoint' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'] },
	'retouchareamaskmasksorigin' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'] },
	'retouchareamaskmasksperimetervalue' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'] },
	'retouchareamaskmasksradius' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'] },
	'retouchareamaskmasksreferencepoint' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'] },
	'retouchareamaskmasksright' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksRight'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksRight'] },
	'retouchareamaskmasksroundness' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'] },
	'retouchareamaskmaskssizex' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'] },
	'retouchareamaskmaskssizey' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'] },
	'retouchareamaskmaskstop' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksTop'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksTop'] },
	'retouchareamaskmasksubtype' => { 535 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'], 537 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'] },
	'retouchareamaskmasksvalue' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'] },
	'retouchareamaskmasksversion' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'] },
	'retouchareamaskmaskswhat' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'] },
	'retouchareamaskmaskswholeimagearea' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'] },
	'retouchareamaskmasksx' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksX'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksX'] },
	'retouchareamaskmasksy' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksY'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksY'] },
	'retouchareamaskmasksyncid' => { 535 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'], 537 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'] },
	'retouchareamaskmaskszerox' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'] },
	'retouchareamaskmaskszeroy' => { 535 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'], 537 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'] },
	'retouchareamaskmaskversion' => { 535 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'], 537 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'] },
	'retouchareamaskmidpoint' => { 535 => [\'RetouchAreas','RetouchAreasMasksMidpoint'], 537 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskorigin' => { 535 => [\'RetouchAreas','RetouchAreasMasksOrigin'], 537 => [\'RetouchAreas','RetouchAreasMasksOrigin'] },
	'retouchareamaskperimetervalue' => { 535 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'], 537 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 535 => [\'RetouchAreas','RetouchAreasMasksRadius'], 537 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskrange' => { 535 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'], 537 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'] },
	'retouchareamaskrangeareamodels' => { 535 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'], 537 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'] },
	'retouchareamaskrangeareamodelscolorsampleinfo' => { 535 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 537 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'retouchareamaskrangeareamodelscomponents' => { 535 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'], 537 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'retouchareamaskrangecoloramount' => { 535 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'], 537 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'] },
	'retouchareamaskrangedepthfeather' => { 535 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'], 537 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'] },
	'retouchareamaskrangedepthmax' => { 535 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'], 537 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'] },
	'retouchareamaskrangedepthmin' => { 535 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'], 537 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'] },
	'retouchareamaskrangeinvert' => { 535 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'], 537 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'] },
	'retouchareamaskrangelumfeather' => { 535 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'], 537 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'] },
	'retouchareamaskrangeluminancedepthsampleinfo' => { 535 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 537 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'retouchareamaskrangelummax' => { 535 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'], 537 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'] },
	'retouchareamaskrangelummin' => { 535 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'], 537 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'] },
	'retouchareamaskrangelumrange' => { 535 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'], 537 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'] },
	'retouchareamaskrangesampletype' => { 535 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'], 537 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'] },
	'retouchareamaskrangetype' => { 535 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'], 537 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'] },
	'retouchareamaskrangeversion' => { 535 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'], 537 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'] },
	'retouchareamaskreferencepoint' => { 535 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'], 537 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'] },
	'retouchareamaskright' => { 535 => [\'RetouchAreas','RetouchAreasMasksRight'], 537 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 535 => [\'RetouchAreas','RetouchAreasMasksRoundness'], 537 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 535 => [\'RetouchAreas','RetouchAreasMasks'], 537 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 535 => [\'RetouchAreas','RetouchAreasMasksSizeX'], 537 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 535 => [\'RetouchAreas','RetouchAreasMasksSizeY'], 537 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 535 => [\'RetouchAreas','RetouchAreasMasksTop'], 537 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 535 => [\'RetouchAreas','RetouchAreasMasksMaskValue'], 537 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 535 => [\'RetouchAreas','RetouchAreasMasksVersion'], 537 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 535 => [\'RetouchAreas','RetouchAreasMasksWhat'], 537 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskwholeimagearea' => { 535 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'], 537 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'] },
	'retouchareamaskx' => { 535 => [\'RetouchAreas','RetouchAreasMasksX'], 537 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 535 => [\'RetouchAreas','RetouchAreasMasksY'], 537 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 535 => [\'RetouchAreas','RetouchAreasMasksZeroX'], 537 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 535 => [\'RetouchAreas','RetouchAreasMasksZeroY'], 537 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 535 => [\'RetouchAreas','RetouchAreasMethod'], 537 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 535 => [\'RetouchAreas','RetouchAreasOffsetY'], 537 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 535 => [\'RetouchAreas','RetouchAreasOpacity'], 537 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 535 => 'RetouchAreas', 537 => 'RetouchAreas' },
	'retouchareaseed' => { 535 => [\'RetouchAreas','RetouchAreasSeed'], 537 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 535 => [\'RetouchAreas','RetouchAreasSourceState'], 537 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 535 => [\'RetouchAreas','RetouchAreasSourceX'], 537 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 535 => [\'RetouchAreas','RetouchAreasSpotType'], 537 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 257 => 0x9e },
	'retouchinfo' => { 535 => 'RetouchInfo', 537 => 'RetouchInfo' },
	'retouchnefprocessing' => { 281 => 0x5 },
	'retractlensonpoweroff' => { 91 => 0x814 },
	'reuse' => { 357 => 'Reuse' },
	'reuseallowed' => { 568 => 'ReuseAllowed' },
	'reuseprohibited' => { 558 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 331 => '5.2' },
	'reversefocusring' => { 341 => 0x163, 342 => 0x163, 343 => 0x17b },
	'reverseindicators' => { 324 => '12.1', 325 => '6.1', 327 => '6.1', 328 => '6.1', 329 => '4.3', 330 => '5.2', 331 => '5.4', 333 => '33.5', 334 => '5.1', 337 => '6.1', 338 => '6.1', 339 => '6.2', 340 => 0xc5, 341 => 0xc1, 342 => 0xc1, 343 => 0xc1 },
	'reverseshutterspeedaperture' => { 331 => '5.3' },
	'revision' => { 539 => 'revision' },
	'rflensmffocusringsensitivity' => { 91 => 0x714 },
	'rflenstype' => { 62 => 0x3d },
	'rgbcurvelimits' => { 115 => 0x238 },
	'rgbcurvepoints' => { 114 => 0x7, 115 => 0x20e },
	'rgbtables' => { 126 => 0xcd3f },
	'richtextcomment' => { 544 => 'RichTextComment' },
	'ricohdate' => { 445 => 0x6 },
	'ricohimageheight' => { 445 => 0x2 },
	'ricohimagewidth' => { 445 => 0x0 },
	'rightalbedo' => { 525 => 'RightAlbedo' },
	'rightascension' => { 183 => 'RightAscension' },
	'rights' => { 538 => 'rights' },
	'rightsagent' => { 558 => 'rightsAgent' },
	'rightsowner' => { 558 => 'rightsOwner' },
	'roll' => { 122 => 0x8, 436 => ['roll',"\xa9frl"] },
	'rollangle' => { 67 => 0x4, 134 => 0x144d, 273 => 0x0, 346 => 0x903, 361 => 'RollAngle', 371 => 0x90, 408 => 0x1, 409 => 0x3, 451 => 0x2 },
	'romoperationmode' => { 104 => 0x80d },
	'rotation' => { 31 => 0x17, 32 => 0x18, 103 => 0x3, 110 => 0x10002, 115 => 0x26e, 121 => 'QuickTime-Rotation', 130 => 0x4, 183 => 'Rotation', 200 => [0x65,0x50], 201 => 0x46, 202 => 0x5a, 205 => 0x10, 282 => 0x1a, 297 => 0x3693, 303 => '590.1', 317 => 0x76a43207, 371 => 0x30, 389 => '17.2', 421 => 0xd8, 429 => 'irot', 466 => 0x3f, 467 => 0x3f, 477 => 0x10 },
	'routedto' => { 543 => 'RoutedTo' },
	'routing' => { 426 => 'Routing' },
	'routingdestinations' => { 523 => 'RoutingDestinations' },
	'routingexclusions' => { 523 => 'RoutingExclusions' },
	'routingnotes' => { 543 => 'RoutingNotes' },
	'rowsperstrip' => { 126 => 0x116 },
	'rpp' => { 529 => 'rpp' },
	'rtkflag' => { 123 => 'RtkFlag' },
	'rtkstdhgt' => { 123 => 'RtkStdHgt' },
	'rtkstdlat' => { 123 => 'RtkStdLat' },
	'rtkstdlon' => { 123 => 'RtkStdLon' },
	'safetyshift' => { 91 => 0x108 },
	'safetyshiftinavortv' => { 89 => 0x10, 90 => 0x10, 92 => 0xf, 93 => 0x10, 96 => 0x10 },
	'sameexposurefornewaperture' => { 91 => 0x112 },
	'samplebits' => { 173 => 'SampleBits' },
	'samplepagerange' => { 555 => 'samplePageRange' },
	'samplerate' => { 173 => 'SampleRate' },
	'samplesperpixel' => { 126 => 0x115, 376 => 0x8, 561 => 'SamplesPerPixel' },
	'samplestructure' => { 151 => 0x5a },
	'samsungmodelid' => { 453 => 0x3 },
	'sanyoquality' => { 455 => 0x201 },
	'sanyothumbnail' => { 455 => 0x100 },
	'saturation' => { 10 => 0x6e, 12 => 0x76, 38 => 0xe, 56 => 0x1, 69 => 0x7, 119 => 0xd, 120 => [0x3013,0x1f], 126 => [0xa409,0xfe55], 134 => 0x1003, 174 => 'Saturation', 199 => 0x1f, 200 => 0x32, 201 => 0x28, 202 => 0x1a, 207 => 0x1, 257 => 0xaa, 275 => 0x35, 276 => 0x3b, 277 => 0x43, 371 => 0x40, 373 => 0x300d, 410 => 0x1f, 417 => 0xd, 438 => 0x27, 439 => 0x58, 440 => 0x42, 441 => 0x68, 445 => 0x28, 446 => 0x1013, 456 => 0x10, 466 => 0x1e, 467 => 0x1b, 480 => 0x2005, 535 => 'Saturation', 537 => 'Saturation', 541 => 'Saturation' },
	'saturationadj' => { 110 => 0x20901, 115 => 0x116, 257 => 0x94, 316 => 0x1, 320 => 0x2e, 517 => 0x8016 },
	'saturationadjustmentaqua' => { 535 => 'SaturationAdjustmentAqua', 537 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 535 => 'SaturationAdjustmentBlue', 537 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 535 => 'SaturationAdjustmentGreen', 537 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 535 => 'SaturationAdjustmentMagenta', 537 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 535 => 'SaturationAdjustmentOrange', 537 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 535 => 'SaturationAdjustmentPurple', 537 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 535 => 'SaturationAdjustmentRed', 537 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 535 => 'SaturationAdjustmentYellow', 537 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 77 => 0x98 },
	'saturationfaithful' => { 19 => 0xfe, 76 => 0x68, 77 => 0x68 },
	'saturationlandscape' => { 19 => 0xfc, 76 => 0x38, 77 => 0x38 },
	'saturationmonochrome' => { 76 => 0x80, 77 => 0x80 },
	'saturationneutral' => { 19 => 0xfd, 76 => 0x50, 77 => 0x50 },
	'saturationportrait' => { 19 => 0xfb, 76 => 0x20, 77 => 0x20 },
	'saturationsetting' => { 354 => 0x1010, 468 => 0x11, 485 => 0x9 },
	'saturationstandard' => { 19 => 0xfa, 76 => 0x8, 77 => 0x8 },
	'saturationuserdef1' => { 19 => 0x100, 76 => 0x98, 77 => 0xb0 },
	'saturationuserdef2' => { 19 => 0x101, 76 => 0xb0, 77 => 0xc8 },
	'saturationuserdef3' => { 19 => 0x102, 76 => 0xc8, 77 => 0xe0 },
	'savefocusposition' => { 261 => 0x9b0 },
	'saveid' => { 566 => 'SaveID' },
	'sbaanalysiscomplete' => { 156 => 0xc35 },
	'sbablack' => { 156 => 0xc25 },
	'sbagmoffset' => { 156 => 0xc4a },
	'sbagray' => { 156 => 0xc26 },
	'sbagreenmagentabal' => { 156 => 0xc33 },
	'sbahighgray' => { 156 => 0xc46 },
	'sbailloffset' => { 156 => 0xc49 },
	'sbailluminantbal' => { 156 => 0xc34 },
	'sbalowgray' => { 156 => 0xc47 },
	'sbaneutralbal' => { 156 => 0xc32 },
	'sbawhite' => { 156 => 0xc27 },
	'scaletype' => { 565 => 'scaleType' },
	'scalingfactorheight' => { 361 => 'ScalingFactorHeight' },
	'scanimageenhancer' => { 283 => 0x60 },
	'scanningdirection' => { 151 => 0x64 },
	'scene' => { 436 => 'scen', 548 => 'Scene', 565 => 'scene' },
	'scenearea' => { 349 => 0x211, 351 => 0x1031 },
	'sceneassist' => { 257 => 0x9c },
	'scenecapturetype' => { 126 => 0xa406, 541 => 'SceneCaptureType' },
	'scenedetect' => { 349 => 0x210, 351 => 0x1030 },
	'scenedetectdata' => { 349 => 0x212, 351 => 0x1033 },
	'sceneflags' => { 1 => 0x25 },
	'scenemode' => { 160 => 0xfa02, 204 => 0x100, 257 => 0x8f, 346 => 0x509, 351 => 0x403, 371 => 0x8001, 380 => 0xf, 480 => 0xb023 },
	'scenemodeused' => { 162 => [0x6002,0xf002] },
	'scenerecognition' => { 134 => 0x1425 },
	'scenereferred' => { 545 => 'scene_referred' },
	'sceneselect' => { 455 => 0x21f },
	'scenetype' => { 126 => 0xa301, 541 => 'SceneType' },
	'screentips' => { 324 => '12.7', 325 => '5.3', 333 => '13.1', 334 => '4.4', 337 => '5.4', 339 => '5.1' },
	'scriptversion' => { 156 => 0x1770 },
	'sdcardid' => { 441 => 0x18 },
	'sdrblend' => { 535 => 'SDRBlend', 537 => 'SDRBlend' },
	'sdrbrightness' => { 535 => 'SDRBrightness', 537 => 'SDRBrightness' },
	'sdrcontrast' => { 535 => 'SDRContrast', 537 => 'SDRContrast' },
	'sdrhighlights' => { 535 => 'SDRHighlights', 537 => 'SDRHighlights' },
	'sdrshadows' => { 535 => 'SDRShadows', 537 => 'SDRShadows' },
	'sdrwhites' => { 535 => 'SDRWhites', 537 => 'SDRWhites' },
	'seal' => { 126 => 0xcea1 },
	'season' => { 549 => 'Season', 554 => 'season' },
	'seasonidentifier' => { 549 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 549 => [\'Season','SeasonName'] },
	'seasonnumber' => { 549 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 523 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 261 => 0x35a, 263 => 0x240, 266 => 0x22c, 267 => 0x240, 268 => 0x240, 286 => 0x13c, 297 => 0x1d0 },
	'section' => { 555 => 'section' },
	'securityclassification' => { 126 => 0x9212 },
	'selectableafpoint' => { 91 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 91 => 0x512 },
	'selfdata' => { 123 => 'SelfData' },
	'selftimer' => { 38 => 0x2, 371 => 0x2e, 455 => 0x214, 489 => 0x1134, 490 => 0x1134, 491 => 0x1110, 492 => 0x118c, 493 => 0x1168, 494 => 0x1020, 495 => 0x218, 496 => 0x218, 497 => 0x210 },
	'selftimer2' => { 83 => 0x1d },
	'selftimerinterval' => { 334 => '19.2' },
	'selftimermode' => { 126 => 0x882b },
	'selftimershotcount' => { 325 => '20.2', 327 => '20.3', 328 => '20.3', 329 => '18.2', 330 => '19.2', 331 => '19.2', 332 => '19.3', 334 => '19.3', 337 => '20.3', 338 => '20.3', 339 => '20.2', 340 => 0x31, 341 => 0x2d, 342 => 0x2d, 343 => 0x2d },
	'selftimershotinterval' => { 325 => '20.3', 327 => '20.2', 328 => '20.2', 332 => '19.2', 337 => '20.2', 338 => '20.2', 340 => 0x35, 341 => 0x31, 342 => 0x31, 343 => 0x31 },
	'selftimertime' => { 104 => 0x1806, 202 => 0x1f, 324 => '18.1', 325 => '20.1', 326 => '3.3', 327 => '20.1', 328 => '20.1', 329 => '18.1', 330 => '19.1', 331 => '19.1', 332 => '19.1', 333 => '7.2', 334 => '19.1', 335 => '3.3', 337 => '20.1', 338 => '20.1', 339 => '20.1', 340 => 0x2d, 341 => 0x2b, 342 => 0x2b, 343 => 0x2b },
	'sellingagency' => { 555 => 'sellingAgency' },
	'semanticstyle' => { 1 => 0x40 },
	'semanticstylepreset' => { 1 => 0x42 },
	'semanticstylerenderingver' => { 1 => 0x41 },
	'seminfo' => { 126 => 0x8546 },
	'sensingmethod' => { 126 => 0xa217, 541 => 'SensingMethod' },
	'sensitivityadjust' => { 410 => 0x40 },
	'sensitivitysteps' => { 389 => ['14.3','17.4'], 391 => 0x1 },
	'sensitivitytype' => { 126 => 0x8830, 542 => 'SensitivityType' },
	'sensor' => { 209 => 0x665e },
	'sensorarea' => { 351 => 0x400 },
	'sensorareas' => { 453 => 0xa010 },
	'sensorbitdepth' => { 373 => 0x312d },
	'sensorbluelevel' => { 80 => 0x5 },
	'sensorcalibration' => { 350 => 0x805 },
	'sensorcleaning' => { 97 => 0xd },
	'sensorfullheight' => { 155 => 0xf904 },
	'sensorfullwidth' => { 155 => 0xf903 },
	'sensorheight' => { 155 => 0xf901, 160 => 0xfa21, 206 => 0x8, 373 => 0x312c, 419 => 0x109, 446 => 0x1602 },
	'sensorimageheight' => { 156 => 0x3ee },
	'sensorimagewidth' => { 156 => 0x3ed },
	'sensorleftborder' => { 156 => 0x3eb },
	'sensorleftmargin' => { 419 => 0x10a },
	'sensorpixelsize' => { 257 => 0x9a },
	'sensorredlevel' => { 80 => 0x4 },
	'sensorserialnumber' => { 156 => 0x9ce },
	'sensorshield' => { 264 => 0x76b, 265 => 0x7cb, 266 => 0x66d, 267 => 0x69d, 268 => 0x705 },
	'sensorsize' => { 174 => 'SensorSize', 410 => 0x35 },
	'sensortemperature' => { 349 => 0x1500, 351 => 0x1007, 415 => [0xc,0x2a], 419 => 0x210, 456 => [0x39,0x55] },
	'sensortemperature2' => { 415 => 0xe, 419 => 0x211 },
	'sensortopborder' => { 156 => 0x3ec },
	'sensortopmargin' => { 419 => 0x10b },
	'sensortype' => { 371 => 0xca },
	'sensorwidth' => { 155 => 0xf900, 160 => 0xfa20, 206 => 0xa, 373 => 0x312b, 419 => 0x108, 446 => 0x1601 },
	'sequence' => { 438 => 0x7, 439 => 0x36, 440 => 0x29, 441 => 0x46, 442 => 0x35 },
	'sequencefilenumber' => { 490 => 0x4, 491 => 0x4, 492 => 0x4, 493 => 0x4, 503 => 0xc, 504 => 0xc, 505 => 0x1a },
	'sequenceimagenumber' => { 490 => 0x0, 491 => 0x0, 492 => 0x0, 493 => 0x0, 503 => 0x8, 504 => 0x8, 505 => 0x12, 512 => 0x24 },
	'sequencelength' => { 503 => 0x22, 504 => 0x1e, 505 => [0x16,0x1e] },
	'sequencename' => { 554 => 'sequenceName' },
	'sequencenumber' => { 83 => 0x9, 120 => 0x301c, 134 => 0x1101, 158 => 0x1d, 304 => 0x51c, 371 => 0x2b, 468 => [0x10c,0x30c], 480 => 0xb04a, 554 => 'sequenceNumber' },
	'sequenceshotinterval' => { 455 => 0x224 },
	'sequencetotalnumber' => { 554 => 'sequenceTotalNumber' },
	'sequentialshot' => { 455 => 0x20e },
	'serialnumber' => { 70 => 0xc, 104 => 0x180b, 126 => [0xa431,0xfde9], 155 => 0xfa04, 157 => 0xfa00, 159 => 0xc354, 160 => 0xfa19, 171 => 0x0, 174 => 'SerialNumber', 209 => 0x5501, 257 => [0xa0,0x1d], 347 => 0x101, 351 => [0x404,0x101a], 366 => 0x303, 368 => 0x305, 373 => 0x3103, 410 => 0x229, 419 => 0x102, 420 => 0x407, 436 => ['SNum','slno'], 438 => 0x15, 439 => 0x7e, 440 => 0x84, 441 => 0x8c, 442 => 0x4b, 446 => 0x5, 453 => 0xa002, 456 => 0x2, 480 => 0x2031, 532 => 'SerialNumber', 542 => 'BodySerialNumber' },
	'serialnumberformat' => { 70 => 0x15, 104 => 0x183b },
	'serialnumberhash' => { 436 => 'CAME' },
	'series' => { 549 => 'Series' },
	'seriesdatetime' => { 520 => 'SeriesDateTime' },
	'seriesdescription' => { 520 => 'SeriesDescription' },
	'seriesidentifier' => { 549 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 520 => 'SeriesModality' },
	'seriesname' => { 549 => [\'Series','SeriesName'] },
	'seriesnumber' => { 520 => 'SeriesNumber', 555 => 'seriesNumber' },
	'seriestitle' => { 555 => 'seriesTitle' },
	'serviceidentifier' => { 150 => 0x1e },
	'servingsize' => { 557 => 'servingSize' },
	'servoafcharacteristics' => { 2 => 0x1b },
	'setbuttoncrosskeysfunc' => { 94 => 0x0, 95 => 0x0 },
	'setbuttonwhenshooting' => { 89 => 0x1, 91 => 0x704, 97 => 0xc },
	'setclockfromlocationdata' => { 266 => 0x61d, 267 => 0x64d, 268 => 0x6b5 },
	'setfunctionwhenshooting' => { 92 => 0x0, 93 => 0x1, 96 => 0x1 },
	'setting' => { 554 => 'setting' },
	'shadingcompensation' => { 346 => 0x50c, 371 => 0x8a },
	'shadingcompensation2' => { 350 => 0x1012 },
	'shadow' => { 456 => 0xe },
	'shadowadj' => { 110 => 0x2030b },
	'shadowcorrection' => { 410 => 0x79 },
	'shadowprotection' => { 316 => 0x0 },
	'shadows' => { 126 => 0xfe52, 480 => 0x2032, 528 => 'Shadows', 535 => 'Shadows', 537 => 'Shadows' },
	'shadows2012' => { 535 => 'Shadows2012', 537 => 'Shadows2012' },
	'shadowsadj' => { 517 => 0x901a },
	'shadowscale' => { 126 => 0xc633 },
	'shadowtint' => { 535 => 'ShadowTint', 537 => 'ShadowTint' },
	'shadowtone' => { 134 => 0x1040 },
	'shakereduction' => { 412 => 0x1, 413 => 0x1 },
	'shareduserrating' => { 197 => 'WM/SharedUserRating' },
	'sharpendetail' => { 535 => 'SharpenDetail', 537 => 'SharpenDetail' },
	'sharpenedgemasking' => { 535 => 'SharpenEdgeMasking', 537 => 'SharpenEdgeMasking' },
	'sharpening' => { 373 => 0x300b },
	'sharpeningadj' => { 320 => 0x2b },
	'sharpeningkernel' => { 156 => 0x92f },
	'sharpenradius' => { 535 => 'SharpenRadius', 537 => 'SharpenRadius' },
	'sharpness' => { 8 => [0x42,0x48], 10 => 0x72, 12 => 0x74, 38 => 0xf, 69 => 0x6, 80 => 0x2, 119 => 0xb, 120 => [0x3011,0x21], 126 => [0xa40a,0xfe56], 134 => 0x1001, 158 => 0x6b, 167 => 0x37, 174 => 'Sharpness', 199 => 0x21, 200 => 0x30, 201 => 0x26, 202 => 0x18, 207 => 0x3, 257 => 0x6, 275 => 0x32, 276 => 0x33, 277 => 0x39, 351 => 0x100f, 371 => 0x41, 410 => 0x21, 417 => 0xb, 438 => 0x26, 439 => 0x56, 440 => 0x40, 441 => 0x66, 445 => 0x22, 446 => [0x1003,0x1014], 456 => 0x11, 466 => 0x1c, 467 => 0x19, 480 => 0x2006, 512 => 0x52, 535 => 'Sharpness', 537 => 'Sharpness', 541 => 'Sharpness' },
	'sharpnessadj' => { 110 => 0x20310, 115 => 0x25a, 517 => 0x801a },
	'sharpnessadjon' => { 110 => '0x20310.0' },
	'sharpnessauto' => { 77 => 0x94 },
	'sharpnessfactor' => { 351 => 0x102a },
	'sharpnessfaithful' => { 19 => 0xf5, 76 => 0x64, 77 => 0x64 },
	'sharpnessfrequency' => { 8 => [0x41,0x47], 80 => 0x3 },
	'sharpnesslandscape' => { 19 => 0xf3, 76 => 0x34, 77 => 0x34 },
	'sharpnessmonochrome' => { 19 => 0xf6, 76 => 0x7c, 77 => 0x7c },
	'sharpnessneutral' => { 19 => 0xf4, 76 => 0x4c, 77 => 0x4c },
	'sharpnessovershoot' => { 517 => 0x801b },
	'sharpnessportrait' => { 19 => 0xf2, 76 => 0x1c, 77 => 0x1c },
	'sharpnessrange' => { 480 => 0x2035 },
	'sharpnesssetting' => { 346 => 0x506, 354 => 0x1013, 468 => 0x12, 485 => 0xa },
	'sharpnessstandard' => { 19 => 0xf1, 76 => 0x4, 77 => 0x4 },
	'sharpnessstrength' => { 110 => 0x20311 },
	'sharpnessthreshold' => { 517 => 0x801d },
	'sharpnessundershoot' => { 517 => 0x801c },
	'sharpnessuserdef1' => { 19 => 0xf7, 76 => 0x94, 77 => 0xac },
	'sharpnessuserdef2' => { 19 => 0xf8, 76 => 0xac, 77 => 0xc4 },
	'sharpnessuserdef3' => { 19 => 0xf9, 76 => 0xc4, 77 => 0xdc },
	'shiftcols' => { 156 => 0xc70 },
	'shootid' => { 554 => 'shootID' },
	'shootingdistance' => { 110 => 0x20701 },
	'shootinginfodisplay' => { 324 => '13.2', 325 => '5.1', 333 => '10.2', 334 => '4.1', 337 => '5.1', 339 => '5.3' },
	'shootinginfomonitorofftime' => { 324 => '26.2', 325 => '22.2', 327 => '22.2', 328 => '22.2', 332 => '21.2', 333 => '9.1', 334 => '21.2', 337 => '22.2', 338 => '22.2', 339 => '22.2', 340 => 0x3d, 341 => 0x37, 342 => 0x37, 343 => 0x37 },
	'shootingmode' => { 174 => 'ShootingMode', 257 => 0x89, 371 => 0x1f },
	'shootingmodesetting' => { 326 => '5.1' },
	'shortdescription' => { 539 => 'shortdescription' },
	'shortdocumentid' => { 149 => 0xba },
	'shortname' => { 535 => 'ShortName', 537 => 'ShortName' },
	'shortownername' => { 19 => 0xac },
	'shortreleasetimelag' => { 91 => 0x80d },
	'shorttitle' => { 428 => '@sti' },
	'shotdate' => { 565 => 'shotDate' },
	'shotday' => { 565 => 'shotDay' },
	'shotlocation' => { 565 => 'shotLocation' },
	'shotlogdata' => { 141 => 'shot_log_data' },
	'shotname' => { 436 => 'shot', 565 => 'shotName' },
	'shotnumber' => { 415 => 0xa, 565 => 'shotNumber' },
	'shotnumbersincepowerup' => { 484 => 0x44e, 503 => 0x1a, 504 => 0x16, 505 => 0xa },
	'shotnumbersincepowerup2' => { 468 => 0x200 },
	'shotsize' => { 565 => 'shotSize' },
	'shotsperinterval' => { 246 => 0x180, 261 => 0x1f0, 262 => 0xb4, 263 => 0xcc, 266 => 0xc0, 267 => 0xd0, 268 => 0xd0 },
	'showmovement' => { 428 => 'shwm' },
	'shownevent' => { 549 => 'EventExt' },
	'showneventidentifier' => { 549 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 549 => [\'EventExt','EventExtName'] },
	'shutter' => { 499 => 0x20, 500 => 0x26, 501 => 0x26 },
	'shutter-aelock' => { 89 => 0x4, 91 => 0x701, 92 => 0x3, 93 => 0x4, 94 => 0x3, 95 => 0x3, 96 => 0x4, 97 => 0x2 },
	'shutteraelbutton' => { 90 => 0x4 },
	'shutterbuttonafonbutton' => { 91 => 0x701 },
	'shuttercount' => { 11 => 0x176, 30 => [0xa95,0x293], 33 => 0xaf1, 34 => 0xd29, 35 => 0x86d, 62 => 0x1, 257 => 0xa7, 288 => [0x6a,0x157,0x24d], 289 => 0x286, 290 => 0x279, 291 => 0x284, 292 => 0x242, 293 => 0x280, 294 => 0x276, 295 => [0x27d,0x27f], 296 => 0x246, 298 => 0x2d6, 299 => 0x321, 300 => 0xbd8, 301 => 0x287, 302 => 0x320, 303 => 0x24a, 304 => 0x5fb, 305 => 0x2d5, 410 => 0x5d, 477 => 0x846, 483 => [0x125,0x14a], 499 => 0x32, 500 => 0x3a, 501 => 0x3a, 502 => 0xa },
	'shuttercount2' => { 499 => 0x4c, 500 => [0x50,0x52,0x58], 501 => 0x50 },
	'shuttercount3' => { 499 => [0x1a0,0x1aa,0x1bd], 500 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 89 => 0xf, 90 => 0xf, 91 => 0x305, 92 => 0xe, 93 => 0xf, 94 => 0x8, 95 => 0x8, 96 => 0xf, 97 => 0x8 },
	'shuttermode' => { 62 => 0x17, 158 => 0x1b, 257 => 0x34 },
	'shutterreleasebuttonae-l' => { 324 => '17.7', 325 => '18.4', 327 => '78.4', 328 => '78.4', 329 => '16.1', 330 => '17.1', 331 => '17.1', 332 => '17.1', 333 => '7.1', 334 => '17.5', 337 => '18.4', 338 => '78.4', 339 => '18.2', 340 => 0x2b, 341 => 0x29, 342 => 0x29, 343 => 0x29 },
	'shutterreleasemethod' => { 104 => 0x1010 },
	'shutterreleasenocfcard' => { 89 => 0x2, 90 => 0x2, 97 => 0xf },
	'shutterreleasetiming' => { 104 => 0x1011 },
	'shutterreleasewithoutlens' => { 91 => 0x711 },
	'shutterspeedlock' => { 325 => '38.1', 327 => '38.1', 328 => '38.1', 337 => '38.1', 338 => '38.1', 340 => 0xbb, 341 => 0xb7, 342 => 0xb7, 343 => 0xb7 },
	'shutterspeedrange' => { 91 => 0x10c },
	'shutterspeedsetting' => { 202 => 0x6, 466 => 0x2f, 467 => 0x28, 468 => 0x0 },
	'shutterspeedvalue' => { 100 => 0x1, 126 => 0x9201, 351 => 0x1000, 419 => 0x400, 541 => 'ShutterSpeedValue' },
	'shuttertype' => { 134 => 0x1050, 371 => 0x9f, 410 => 0x87, 505 => [0x133,0x139,0x13f] },
	'sidecarforextension' => { 553 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 156 => 0xe0d },
	'sigmascalingfactorcamera' => { 156 => 0xe0c },
	'sigmascalingfactorlowres' => { 156 => 0xe0b },
	'sigmasizetable' => { 156 => 0xe0f },
	'signaltonoiseratio' => { 1 => 0x27 },
	'signaltonoiseratiotype' => { 1 => 0x26 },
	'silentphotography' => { 257 => 0xbf, 261 => 0x9b7 },
	'similarityindex' => { 149 => 0xe4 },
	'singleframebracketing' => { 202 => 0x21 },
	'skilllevel' => { 557 => 'skillLevel' },
	'skintonecorrection' => { 410 => 0x95 },
	'skiplinetime' => { 156 => 0x184e },
	'slaveflashmeteringsegments' => { 410 => 0x20b },
	'slideshowname' => { 554 => 'slideshowName' },
	'slideshownumber' => { 554 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 554 => 'slideshowTotalNumber' },
	'slot2jpgsize' => { 261 => 0x364, 263 => 0x24a, 268 => 0x24a },
	'slowshutter' => { 83 => 0x8 },
	'slowsync' => { 134 => 0x1030 },
	'smartalbumcolor' => { 453 => 0x20 },
	'smartrange' => { 453 => 0xa012 },
	'smileshutter' => { 468 => 0x31 },
	'smileshuttermode' => { 468 => 0x27 },
	'smoothness' => { 126 => 0xfe57, 535 => 'Smoothness', 537 => 'Smoothness' },
	'snapshot' => { 549 => 'SnapshotLink' },
	'snapshotformat' => { 549 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 549 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 549 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 549 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 549 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 529 => 'Snapshots' },
	'snapshotusedvideoframe' => { 549 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 549 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 549 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 549 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 549 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 480 => 0x200f },
	'software' => { 126 => 0x131, 144 => 'Software', 175 => 'Software', 360 => 'Software', 419 => 0x203, 430 => 'software', 456 => 0x18, 561 => 'Software' },
	'softwareversion' => { 436 => ['@swr',"\xa9swr"], 455 => 0x207 },
	'soloist' => { 428 => "\xa9sol" },
	'songwriter' => { 436 => "\xa9swf" },
	'songwriterkeywords' => { 436 => "\xa9swk" },
	'sonycropsize' => { 126 => 0x74c8 },
	'sonycroptopleft' => { 126 => 0x74c7 },
	'sonydatetime' => { 488 => 0x6, 490 => 0x1b6, 491 => 0x210, 492 => 0x1fe, 493 => 0x22c },
	'sonydatetime2' => { 499 => 0x51 },
	'sonyexposuretime' => { 499 => 0x3a, 500 => 0x46, 501 => [0x66,0x46], 502 => 0x1a },
	'sonyexposuretime2' => { 512 => 0xe },
	'sonyfnumber' => { 499 => 0x3c, 500 => 0x48, 501 => [0x68,0x48], 502 => 0x1c, 512 => 0x14 },
	'sonyimageheight' => { 488 => 0x1a, 503 => 0x44, 504 => 0x3f },
	'sonyimageheightmax' => { 512 => 0x40 },
	'sonyimagesize' => { 202 => 0x3b, 466 => 0x54, 467 => 0x54, 468 => 0x9 },
	'sonyimagewidth' => { 488 => 0x1c },
	'sonyimagewidthmax' => { 512 => 0x3e },
	'sonyiso' => { 490 => 0x1218, 491 => 0x11f4, 492 => 0x1270, 493 => [0x1254,0x1258,0x1280], 494 => 0x113c, 495 => 0x344, 496 => 0x346, 497 => 0x320, 512 => 0x4 },
	'sonymaxaperture' => { 499 => 0x0, 500 => 0x0 },
	'sonymaxaperturevalue' => { 512 => 0x16 },
	'sonyminaperture' => { 499 => 0x1, 500 => 0x1 },
	'sonymodelid' => { 480 => 0xb001 },
	'sonyquality' => { 202 => 0x3c },
	'sonyrawimagesize' => { 126 => 0x7038 },
	'sonytimeminsec' => { 500 => 0x61 },
	'sortalbum' => { 428 => 'soal' },
	'sortalbumartist' => { 428 => 'soaa' },
	'sortartist' => { 428 => 'soar' },
	'sortcomposer' => { 428 => 'soco' },
	'sortname' => { 428 => 'sonm', 535 => 'SortName', 537 => 'SortName' },
	'sortshow' => { 428 => 'sosn' },
	'soundengineer' => { 428 => "\xa9sne" },
	'source' => { 149 => 0x73, 360 => 'Source', 538 => 'source', 539 => 'source', 553 => 'Source' },
	'sourcecount' => { 148 => 'SourceCount' },
	'sourcecredits' => { 436 => "\xa9src" },
	'sourcedirectoryindex' => { 396 => 0x0 },
	'sourcefileindex' => { 396 => 0x2 },
	'sourcemodified' => { 356 => 'SourceModified', 552 => 'SourceModified' },
	'sourcephotoscount' => { 147 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 156 => 0x1390 },
	'spatialfrequencyresponse' => { 541 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 541 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 541 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 541 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 541 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 565 => 'speakerPlacement' },
	'specialeffectlevel' => { 120 => 0x3030 },
	'specialeffectmode' => { 120 => 0x2076 },
	'specialeffectsetting' => { 120 => 0x3031 },
	'specialinstructions' => { 149 => 0x28 },
	'specialmode' => { 351 => 0x200, 455 => 0x200 },
	'specialoccasion' => { 557 => 'specialOccasion' },
	'specialtypeid' => { 141 => 'SpecialTypeID' },
	'spectralsensitivity' => { 126 => 0x8824, 541 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 45 => 0x32b, 46 => 0x281, 47 => 0x295, 50 => [0x2b9,0x2d0,0x2d4], 51 => [0x56a,0x296], 52 => 0x1e4, 53 => [0x1fd,0x2dd], 54 => [0x231,0x30f], 55 => 0x31d },
	'speedx' => { 122 => 0x3, 436 => "\xa9xsp" },
	'speedy' => { 122 => 0x4, 436 => "\xa9ysp" },
	'speedz' => { 122 => 0x5, 436 => "\xa9zsp" },
	'spherical' => { 148 => 'Spherical' },
	'sphericalvideoxml' => { 127 => 'SphericalVideoXML' },
	'splitcolumn' => { 419 => 0x222 },
	'splittoningbalance' => { 535 => 'SplitToningBalance', 537 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 535 => 'SplitToningHighlightHue', 537 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 535 => 'SplitToningHighlightSaturation', 537 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 535 => 'SplitToningShadowHue', 537 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 535 => 'SplitToningShadowSaturation', 537 => 'SplitToningShadowSaturation' },
	'sport' => { 555 => 'sport' },
	'sportevents' => { 2 => 0x1e },
	'spotfocuspointx' => { 199 => 0x2d },
	'spotfocuspointy' => { 199 => 0x2e },
	'spotmeteringmode' => { 38 => 0x27 },
	'spotmeterlinktoafpoint' => { 91 => 0x107 },
	'sractive' => { 389 => '17.1' },
	'srawquality' => { 38 => 0x2e },
	'srfocallength' => { 412 => 0x3 },
	'srgbrendering' => { 358 => 'sRGB' },
	'srhalfpresstime' => { 412 => 0x2 },
	'srresult' => { 412 => 0x0, 413 => 0x0 },
	'stackedimage' => { 346 => 0x804 },
	'standardmatrixcustom' => { 156 => 0x7d4 },
	'standardmatrixdaylight' => { 156 => 0x7d0 },
	'standardmatrixflash' => { 156 => 0x7d3 },
	'standardmatrixfluorescent' => { 156 => 0x7d2 },
	'standardmatrixtungsten' => { 156 => 0x7d1 },
	'standardoutputhighlightpoint' => { 116 => 0x14 },
	'standardoutputsensitivity' => { 126 => 0x8831, 542 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 116 => 0x15 },
	'standardrawcolortone' => { 116 => 0xd },
	'standardrawcontrast' => { 116 => 0xf },
	'standardrawhighlight' => { 116 => 0x75 },
	'standardrawhighlightpoint' => { 116 => 0x12 },
	'standardrawlinear' => { 116 => 0x10 },
	'standardrawsaturation' => { 116 => 0xe },
	'standardrawshadow' => { 116 => 0x7e },
	'standardrawshadowpoint' => { 116 => 0x13 },
	'standardrawsharpness' => { 116 => 0x11 },
	'standardunsharpmaskfineness' => { 116 => 0x94 },
	'standardunsharpmaskstrength' => { 116 => 0x92 },
	'standardunsharpmaskthreshold' => { 116 => 0x96 },
	'standardwhitecustom' => { 156 => 0x838 },
	'standardwhitedaylight' => { 156 => 0x834 },
	'standardwhiteflash' => { 156 => 0x837 },
	'standardwhitefluorescent' => { 156 => 0x836 },
	'standardwhitetungsten' => { 156 => 0x835 },
	'standbytimer' => { 325 => '19.1', 327 => '19.1', 328 => '19.1', 331 => '18.1', 332 => '18.1', 337 => '19.1', 338 => '19.1' },
	'starlightview' => { 341 => 0x249, 342 => 0x249, 343 => 0x261 },
	'startingpage' => { 555 => 'startingPage' },
	'startmovieshooting' => { 91 => 0x70d },
	'starttimecode' => { 436 => "\xa9TIM", 565 => 'startTimecode' },
	'starttimecodetimeformat' => { 565 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 565 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 565 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 436 => "\xa9TSZ", 565 => 'startTimeSampleSize' },
	'starttimescale' => { 436 => "\xa9TSC", 565 => 'startTimeScale' },
	'state' => { 179 => 'State', 371 => 0x6b, 553 => 'State' },
	'status' => { 522 => 'Status', 527 => 'Status' },
	'stepcropshooting' => { 480 => 0x205c },
	'stereomode' => { 148 => 'StereoMode' },
	'stitched' => { 148 => 'Stitched' },
	'stitchingsoftware' => { 147 => 'StitchingSoftware', 148 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 489 => 0x113e, 490 => 0x113e, 491 => 0x111a, 492 => 0x1196, 493 => 0x1172, 494 => 0x102a, 495 => 0x222, 496 => 0x222, 497 => 0x217, 512 => 0xa },
	'storagemethod' => { 206 => 0x12 },
	'storebyorientation' => { 325 => '46.3', 327 => '47.3', 328 => '47.3', 337 => '47.3', 338 => '47.3', 340 => 0xd, 341 => 0xd, 342 => 0xd, 343 => 0xd },
	'storedescription' => { 428 => 'sdes' },
	'storedformat' => { 530 => 'StoredFormat' },
	'storylineidentifier' => { 549 => 'StorylineIdentifier' },
	'straightenangle' => { 317 => 0x2fc08431 },
	'streamready' => { 549 => 'StreamReady' },
	'streamtype' => { 194 => 'StreamType' },
	'stretchmode' => { 565 => 'stretchMode' },
	'studydatetime' => { 520 => 'StudyDateTime' },
	'studydescription' => { 520 => 'StudyDescription' },
	'studyid' => { 520 => 'StudyID' },
	'studyphysician' => { 520 => 'StudyPhysician' },
	'styleperiod' => { 549 => 'StylePeriod' },
	'sub-location' => { 149 => 0x5c },
	'subcommanddialframeadvancezoom' => { 268 => 0x806 },
	'subcommanddialplaybackmode' => { 341 => 0x1cf, 342 => 0x1cf, 343 => 0x1e7 },
	'subcommanddialvideoplaybackmode' => { 341 => 0x1d1, 343 => 0x1e9 },
	'subfiledata' => { 182 => 'data' },
	'subfiledirectory' => { 182 => '1Directory' },
	'subfilemimetype' => { 182 => '2MIME' },
	'subfilename' => { 182 => '1Name' },
	'subfileresource' => { 182 => 'rsrc' },
	'subfiletype' => { 126 => 0xfe, 182 => '0Type' },
	'subject' => { 356 => 'Subject', 426 => 'Subject', 538 => 'subject', 551 => 'Subject', 566 => 'subject' },
	'subjectarea' => { 126 => 0x9214, 541 => 'SubjectArea' },
	'subjectcode' => { 548 => 'SubjectCode' },
	'subjectdetectarea' => { 355 => 0x2 },
	'subjectdetectdetail' => { 355 => 0x6 },
	'subjectdetectframesize' => { 355 => 0x0 },
	'subjectdetectinfo' => { 346 => 0x30b },
	'subjectdetection' => { 261 => 0x36e, 263 => 0x252, 266 => 0x23e, 267 => 0x252, 268 => 0x252 },
	'subjectdetectionareamf' => { 261 => 0x3ea },
	'subjectdetectstatus' => { 355 => 0xa },
	'subjectdistance' => { 126 => 0x9206, 158 => 0x3e, 541 => 'SubjectDistance' },
	'subjectdistancerange' => { 126 => 0xa40c, 541 => 'SubjectDistanceRange' },
	'subjectlocation' => { 126 => 0xa214, 541 => 'SubjectLocation' },
	'subjectmotion' => { 327 => '78.2', 328 => '78.2', 338 => '78.2', 341 => 0x103, 342 => 0x103, 343 => 0x119 },
	'subjectprogram' => { 199 => 0x22 },
	'subjectrecognition' => { 382 => 0x960 },
	'subjectreference' => { 149 => 0xc },
	'subjectswitching' => { 2 => 0x15 },
	'subjecttodetect' => { 2 => 0x14 },
	'sublabels1' => { 547 => [\'TagStructure','TagStructureSubLabels'] },
	'sublabels2' => { 547 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublabels3' => { 547 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'sublabels4' => { 547 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 547 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 121 => 'Exif-SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 121 => 'Exif-SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 121 => 'Exif-SubSecModifyDate' },
	'subsectime' => { 126 => 0x9290 },
	'subsectimedigitized' => { 126 => 0x9292 },
	'subsectimeoriginal' => { 126 => 0x9291 },
	'subsection1' => { 555 => 'subsection1' },
	'subsection2' => { 555 => 'subsection2' },
	'subsection3' => { 555 => 'subsection3' },
	'subsection4' => { 555 => 'subsection4' },
	'subselector' => { 325 => '49.1', 327 => '71.1', 328 => '71.1', 338 => '71.1', 340 => 0x93, 341 => 0x8f, 342 => 0x8f, 343 => 0x8f },
	'subselectorassignment' => { 325 => '48.1' },
	'subselectorcenter' => { 327 => '72.1', 328 => '72.1', 338 => '72.1' },
	'subselectorplusdials' => { 325 => '49.2', 327 => '73.1', 328 => '73.1', 338 => '73.1' },
	'subtitle' => { 197 => 'WM/SubTitle', 428 => "\xa9st3", 436 => "\xa9snm", 555 => 'subtitle' },
	'subtitlekeywords' => { 436 => "\xa9snk" },
	'subversionfilename' => { 547 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 547 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 547 => 'SubVersions' },
	'superimposeddisplay' => { 89 => 0xa, 91 => 0x510, 92 => 0x9, 93 => 0xa, 96 => 0xa, 97 => 0xe },
	'supermacro' => { 70 => 0x1a },
	'supplementalcategories' => { 149 => 0x14, 553 => 'SupplementalCategories' },
	'supplementaltype' => { 151 => 0x37 },
	'supplementdisplayid' => { 555 => 'supplementDisplayID' },
	'supplementstartingpage' => { 555 => 'supplementStartingPage' },
	'supplementtitle' => { 555 => 'supplementTitle' },
	'supplychainsource' => { 549 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 549 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 549 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'supportsamount' => { 535 => 'SupportsAmount', 537 => 'SupportsAmount' },
	'supportscolor' => { 535 => 'SupportsColor', 537 => 'SupportsColor' },
	'supportshighdynamicrange' => { 535 => 'SupportsHighDynamicRange', 537 => 'SupportsHighDynamicRange' },
	'supportsmonochrome' => { 535 => 'SupportsMonochrome', 537 => 'SupportsMonochrome' },
	'supportsnormaldynamicrange' => { 535 => 'SupportsNormalDynamicRange', 537 => 'SupportsNormalDynamicRange' },
	'supportsoutputreferred' => { 535 => 'SupportsOutputReferred', 537 => 'SupportsOutputReferred' },
	'supportsscenereferred' => { 535 => 'SupportsSceneReferred', 537 => 'SupportsSceneReferred' },
	'svisosetting' => { 389 => 0x14 },
	'swatchcoloranta' => { 570 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 570 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 570 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 570 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 570 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 570 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 570 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 570 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 570 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 570 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 570 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 570 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 570 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 570 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 570 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 570 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 570 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 570 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 570 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 371 => 0x93, 468 => 0x33 },
	'sweeppanoramafieldofview' => { 371 => 0x94 },
	'sweeppanoramasize' => { 468 => 0x32 },
	'switchtoregisteredafpoint' => { 90 => 0x12, 91 => 0x50a },
	'symlink' => { 127 => 'SymLink' },
	'syncreleasemode' => { 327 => '77.1', 328 => '77.1', 338 => '77.1', 340 => 0x45, 341 => 0x41, 342 => 0x41, 343 => 0x41 },
	'system' => { 419 => 0x204 },
	'tagged' => { 421 => 0xdd, 422 => 'Tagged', 529 => 'tagged' },
	'tagslist' => { 540 => 'TagsList' },
	'tagstructure' => { 547 => 'TagStructure' },
	'takenumber' => { 565 => 'takeNumber' },
	'tapename' => { 565 => 'tapeName' },
	'targetaperture' => { 83 => 0x4 },
	'targetaspectratio' => { 361 => 'TargetAspectRatio' },
	'targetcompressionratio' => { 102 => 0x1 },
	'targetdistancesetting' => { 104 => 0x1807 },
	'targetexposuretime' => { 83 => 0x5 },
	'targetimagetype' => { 104 => 0x100a },
	'targetprinter' => { 126 => 0x151 },
	'taxon' => { 125 => 'Taxon' },
	'taxonacceptednameusage' => { 125 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 125 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 125 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 125 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxoncultivarepithet' => { 125 => [\'Taxon','TaxonCultivarEpithet'] },
	'taxonfamily' => { 125 => [\'Taxon','TaxonFamily'] },
	'taxongenericname' => { 125 => [\'Taxon','TaxonGenericName'] },
	'taxongenus' => { 125 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 125 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 125 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfragenericepithet' => { 125 => [\'Taxon','TaxonInfragenericEpithet'] },
	'taxoninfraspecificepithet' => { 125 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 125 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 125 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 125 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 125 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 125 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 125 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 125 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 125 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 125 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 125 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 125 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 125 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 125 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 125 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 125 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 125 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 125 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 125 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 125 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 125 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubfamily' => { 125 => [\'Taxon','TaxonSubFamily'] },
	'taxonsubgenus' => { 125 => [\'Taxon','TaxonSubgenus'] },
	'taxonsubtribe' => { 125 => [\'Taxon','TaxonSubTribe'] },
	'taxonsuperfamily' => { 125 => [\'Taxon','TaxonSuperFamily'] },
	'taxontaxonomicstatus' => { 125 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxontribe' => { 125 => [\'Taxon','TaxonTribe'] },
	'taxonverbatimtaxonrank' => { 125 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 125 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 156 => 0x196f },
	'tda1edgepolarity' => { 156 => 0x1971 },
	'tda1gain' => { 156 => 0x1970 },
	'tda1offset' => { 156 => 0x196e },
	'tda2bandwidth' => { 156 => 0x1979 },
	'tda2edgepolarity' => { 156 => 0x197b },
	'tda2gain' => { 156 => 0x197a },
	'tda2offset' => { 156 => 0x1978 },
	'tda3bandwidth' => { 156 => 0x1983 },
	'tda3edgepolarity' => { 156 => 0x1985 },
	'tda3gain' => { 156 => 0x1984 },
	'tda3offset' => { 156 => 0x1982 },
	'tda4bandwidth' => { 156 => 0x198d },
	'tda4edgepolarity' => { 156 => 0x198f },
	'tda4gain' => { 156 => 0x198e },
	'tda4offset' => { 156 => 0x198c },
	'teaser' => { 555 => 'teaser' },
	'teleconverter' => { 204 => 0x105, 480 => 0x105 },
	'tempampgainx100' => { 156 => 0x1914 },
	'tempo' => { 565 => 'tempo' },
	'temporalcoverage' => { 549 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 549 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 549 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 357 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 357 => 'TermsAndConditionsURL' },
	'testname' => { 127 => 'TestName' },
	'textencoding' => { 256 => 0x4 },
	'textlayername' => { 553 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 553 => 'TextLayers' },
	'textlayertext' => { 553 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 371 => [0x8008,0x8009,0x3b,0x3e] },
	'texture' => { 535 => 'Texture', 537 => 'Texture' },
	'three-dtrackingfacedetection' => { 327 => '1.4', 328 => '1.4', 338 => '1.4' },
	'three-dtrackingwatcharea' => { 327 => '78.1', 328 => '78.1', 338 => '78.1' },
	'thresholding' => { 126 => 0x107 },
	'thumbnailfilename' => { 104 => 0x817 },
	'thumbnailformat' => { 563 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 160 => 0xfa55, 563 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 6 => 'CNDA', 104 => 0x2008, 121 => 'Exif-ThumbnailImage', 129 => 0x3, 185 => 'data', 351 => 0x100, 428 => 'tnal', 436 => 'thmb', 563 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 185 => '1Name' },
	'thumbnailimagesize' => { 185 => 'ImageSize' },
	'thumbnailimagetype' => { 185 => '0Type' },
	'thumbnailimagevalidarea' => { 70 => 0x13 },
	'thumbnaillength' => { 126 => 0x202 },
	'thumbnailoffset' => { 126 => 0x201 },
	'thumbnailpng' => { 436 => 'thmb' },
	'thumbnails' => { 563 => 'Thumbnails' },
	'thumbnailwidth' => { 160 => 0xfa54, 563 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 555 => 'ticker' },
	'tiffhandling' => { 535 => 'TIFFHandling', 537 => 'TIFFHandling' },
	'tiffmeteringimage' => { 205 => 0x104c, 477 => 0x1110 },
	'tilelength' => { 126 => 0x143 },
	'tilewidth' => { 126 => 0x142 },
	'time' => { 156 => 0x401, 410 => 0x7 },
	'timecodes' => { 126 => 0xc763 },
	'timecreated' => { 149 => 0x3c, 158 => 0x14, 167 => 0x10, 422 => 'TimeCreated' },
	'timelapseshotnumber' => { 374 => 0x10 },
	'timeperiod' => { 555 => 'timePeriod' },
	'timerfunctionbutton' => { 326 => '5.2', 329 => '12.1', 330 => '13.1' },
	'timerlength' => { 91 => 0x80c },
	'timerrecording' => { 371 => 0x96 },
	'timescaleparams' => { 565 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 565 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 565 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 565 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 150 => 0x50 },
	'timeshot' => { 523 => 'TimeShot' },
	'timesignature' => { 565 => 'timeSignature' },
	'timesincepoweron' => { 371 => 0x29 },
	'timestamp' => { 11 => 0x45e, 19 => 0x11c, 148 => 'Timestamp', 344 => 0x8, 360 => 'TimeStamp', 371 => 0xaf, 531 => 'Timestamp', 547 => 'TimeStamp' },
	'timestamp1' => { 11 => 0x45a },
	'timezone' => { 84 => 0x1, 261 => 0x8fe, 264 => 0x694, 265 => 0x6a4, 266 => 0x594, 267 => 0x5c4, 268 => 0x5dc, 309 => 0x0, 449 => 0xa },
	'timezonecity' => { 84 => 0x2 },
	'timezonecode' => { 107 => 0x1 },
	'timezoneinfo' => { 107 => 0x2 },
	'timezoneoffset' => { 126 => 0x882a },
	'tint' => { 430 => 'player.movie.visual.tint', 535 => 'Tint', 537 => 'Tint' },
	'title' => { 175 => 'Title', 356 => 'Title', 360 => 'Title', 371 => 0x65, 426 => 'Title', 428 => ['titl',"\xa9nam"], 430 => 'title', 436 => ['titl',"\xa9nam"], 538 => 'title', 551 => 'Title', 563 => 'Title' },
	'togglestyleamount' => { 535 => 'ToggleStyleAmount', 537 => 'ToggleStyleAmount' },
	'togglestyledigest' => { 535 => 'ToggleStyleDigest', 537 => 'ToggleStyleDigest' },
	'tonecomp' => { 257 => 0x81 },
	'tonecurve' => { 80 => 0x1, 410 => 0x402, 535 => 'ToneCurve', 537 => 'ToneCurve' },
	'tonecurveactive' => { 115 => 0x110 },
	'tonecurveadobergb' => { 453 => 0xa043 },
	'tonecurveadobergbdefault' => { 453 => 0xa041 },
	'tonecurveblue' => { 535 => 'ToneCurveBlue', 537 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 517 => 0x9003 },
	'tonecurvebluey' => { 517 => 0x9007 },
	'tonecurvebrightness' => { 110 => 0x20410 },
	'tonecurvebrightnessx' => { 517 => 0x9000 },
	'tonecurvebrightnessy' => { 517 => 0x9004 },
	'tonecurvecolorspace' => { 114 => 0x0 },
	'tonecurvecontrast' => { 110 => 0x20411 },
	'tonecurvegreen' => { 535 => 'ToneCurveGreen', 537 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 517 => 0x9002 },
	'tonecurvegreeny' => { 517 => 0x9006 },
	'tonecurveinputrange' => { 114 => 0x3 },
	'tonecurveinterpolation' => { 115 => 0x159 },
	'tonecurvemode' => { 115 => 0x113 },
	'tonecurvename' => { 535 => 'ToneCurveName', 537 => 'ToneCurveName' },
	'tonecurvename2012' => { 535 => 'ToneCurveName2012', 537 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 110 => '0x20400.1' },
	'tonecurveoutputrange' => { 114 => 0x5 },
	'tonecurveprofilename' => { 156 => 0x1391 },
	'tonecurveproperty' => { 115 => 0x3c },
	'tonecurvepv2012' => { 535 => 'ToneCurvePV2012', 537 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 535 => 'ToneCurvePV2012Blue', 537 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 535 => 'ToneCurvePV2012Green', 537 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 535 => 'ToneCurvePV2012Red', 537 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 535 => 'ToneCurveRed', 537 => 'ToneCurveRed' },
	'tonecurveredx' => { 517 => 0x9001 },
	'tonecurveredy' => { 517 => 0x9005 },
	'tonecurves' => { 410 => 0x403 },
	'tonecurveshape' => { 114 => 0x1 },
	'tonecurvesrgb' => { 453 => 0xa042 },
	'tonecurvesrgbdefault' => { 453 => 0xa040 },
	'tonecurvex' => { 114 => 0xa },
	'tonecurvey' => { 114 => 0xb },
	'tonelevel' => { 346 => 0x52e },
	'tonemap' => { 261 => 0x374, 263 => 0x26a },
	'tonemapstrength' => { 535 => 'ToneMapStrength', 537 => 'ToneMapStrength' },
	'toningeffect' => { 62 => 0xf, 257 => 0xb3, 275 => 0x38, 276 => 0x40, 277 => 0x48, 446 => 0x1015 },
	'toningeffectauto' => { 77 => 0xa4 },
	'toningeffectfaithful' => { 76 => 0x74, 77 => 0x74 },
	'toningeffectlandscape' => { 76 => 0x44, 77 => 0x44 },
	'toningeffectmonochrome' => { 19 => 0x108, 76 => 0x8c, 77 => 0x8c },
	'toningeffectneutral' => { 76 => 0x5c, 77 => 0x5c },
	'toningeffectportrait' => { 76 => 0x2c, 77 => 0x2c },
	'toningeffectstandard' => { 76 => 0x14, 77 => 0x14 },
	'toningeffectuserdef1' => { 76 => 0xa4, 77 => 0xbc },
	'toningeffectuserdef2' => { 76 => 0xbc, 77 => 0xd4 },
	'toningeffectuserdef3' => { 76 => 0xd4, 77 => 0xec },
	'toningsaturation' => { 275 => 0x39, 276 => 0x41, 277 => 0x49 },
	'totalzoom' => { 158 => 0x62 },
	'touchae' => { 371 => 0xab },
	'touchfn' => { 340 => 0x154 },
	'touchfnareatall' => { 340 => 0x15b },
	'touchfnareawide' => { 340 => 0x159 },
	'touchfnrole' => { 340 => 0x155 },
	'track' => { 428 => "\xa9trk", 436 => "\xa9trk" },
	'trackcreatedate' => { 435 => 0x1 },
	'trackmodifydate' => { 435 => 0x2 },
	'trackname' => { 436 => 'tnam' },
	'tracknumber' => { 428 => 'trkn', 565 => 'trackNumber' },
	'tracks' => { 565 => 'Tracks' },
	'tracksframerate' => { 565 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 565 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 565 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 565 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 565 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 565 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 565 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 565 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 565 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 565 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 565 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 565 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 565 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 565 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 565 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 565 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 565 => [\'Tracks','TracksTrackType'] },
	'tracktype' => { 436 => 'kgtt' },
	'trailer' => { 127 => 'Trailer' },
	'trailersignature' => { 182 => 'zmie' },
	'transcript' => { 549 => 'Transcript' },
	'transcriptlink' => { 549 => 'TranscriptLink' },
	'transcriptlinklink' => { 549 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 549 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 126 => 0x12d, 561 => 'TransferFunction' },
	'transfertimenormal' => { 156 => 0x1888 },
	'transfertimetest' => { 156 => 0x1889 },
	'transform' => { 371 => [0x8012,0x59] },
	'transformation' => { 550 => 'Transformation' },
	'transmissionreference' => { 553 => 'TransmissionReference' },
	'trapped' => { 356 => 'Trapped', 551 => 'Trapped' },
	'trashbuttonfunction' => { 91 => 0x710 },
	'travelday' => { 371 => 0x36 },
	'treble' => { 427 => 'player.movie.audio.treble', 430 => 'player.movie.audio.treble' },
	'triggermode' => { 438 => 0x6, 439 => 0x34, 440 => 0x28, 441 => 0x44, 442 => 0x34 },
	'tstop' => { 126 => 0xc772 },
	'ttl_da_adown' => { 397 => 0x5 },
	'ttl_da_aup' => { 397 => 0x4 },
	'ttl_da_bdown' => { 397 => 0x7 },
	'ttl_da_bup' => { 397 => 0x6 },
	'tungstenawb' => { 385 => 0x1 },
	'tvepisode' => { 428 => 'tves' },
	'tvepisodeid' => { 428 => 'tven' },
	'tvexposuretimesetting' => { 389 => 0x12 },
	'tvnetworkname' => { 428 => 'tvnn' },
	'tvseason' => { 428 => 'tvsn' },
	'tvshow' => { 428 => 'tvsh' },
	'type' => { 143 => 'Type', 538 => 'type', 560 => 'type' },
	'typestatus' => { 125 => [\'Identification','IdentificationTypeStatus'] },
	'uibfirmwareversion' => { 440 => 0x21 },
	'uniquecameramodel' => { 126 => 0xc614 },
	'uniquedocumentid' => { 149 => 0xbb },
	'uniquematrixauto' => { 156 => 0x7e9 },
	'uniquematrixcustom' => { 156 => 0x7e8 },
	'uniquematrixdaylight' => { 156 => 0x7e4 },
	'uniquematrixflash' => { 156 => 0x7e7 },
	'uniquematrixfluorescent' => { 156 => 0x7e6 },
	'uniquematrixtungsten' => { 156 => 0x7e5 },
	'uniqueobjectname' => { 150 => 0x64 },
	'units' => { 144 => 'Units' },
	'unknown_aacr' => { 428 => 'AACR' },
	'unknown_cdek' => { 428 => 'CDEK' },
	'unknown_cdet' => { 428 => 'CDET' },
	'unknownblock' => { 410 => 0x405 },
	'unknownblock1' => { 350 => 0x635 },
	'unknownblock2' => { 350 => 0x636 },
	'unknownblock3' => { 350 => 0x1103 },
	'unknownblock4' => { 350 => 0x1104 },
	'unknowncontrast' => { 116 => 0x45 },
	'unknowndate' => { 419 => 0x212 },
	'unknownev' => { 156 => 0x1 },
	'unknownlinear' => { 116 => 0x46 },
	'unknownnumber' => { 104 => 0x180b },
	'unknownoutputhighlightpoint' => { 116 => 0x4a },
	'unknownoutputshadowpoint' => { 116 => 0x4b },
	'unknownrawhighlight' => { 116 => 0x7b },
	'unknownrawhighlightpoint' => { 116 => 0x48 },
	'unknownrawshadow' => { 116 => 0x84 },
	'unknownrawshadowpoint' => { 116 => 0x49 },
	'unknownsharpness' => { 116 => 0x47 },
	'unknowntags' => { 436 => 'TAGS' },
	'unknowntemperature' => { 128 => 0x4 },
	'unknownthumbnail' => { 436 => 'thmb' },
	'unsharp1color' => { 322 => 0x13 },
	'unsharp1halowidth' => { 322 => 0x19 },
	'unsharp1intensity' => { 322 => 0x17 },
	'unsharp1threshold' => { 322 => 0x1b },
	'unsharp2color' => { 322 => 0x2e },
	'unsharp2halowidth' => { 322 => 0x34 },
	'unsharp2intensity' => { 322 => 0x32 },
	'unsharp2threshold' => { 322 => 0x36 },
	'unsharp3color' => { 322 => 0x49 },
	'unsharp3halowidth' => { 322 => 0x4f },
	'unsharp3intensity' => { 322 => 0x4d },
	'unsharp3threshold' => { 322 => 0x51 },
	'unsharp4color' => { 322 => 0x64 },
	'unsharp4halowidth' => { 322 => 0x6a },
	'unsharp4intensity' => { 322 => 0x68 },
	'unsharp4threshold' => { 322 => 0x6c },
	'unsharpcount' => { 322 => 0x0 },
	'unsharpmask' => { 116 => 0x90, 317 => 0x76a43200 },
	'unsharpmaskfineness' => { 80 => 0xe, 110 => 0x20309 },
	'unsharpmaskstrength' => { 110 => 0x20308 },
	'unsharpmaskthreshold' => { 80 => 0xf, 110 => 0x2030a },
	'uprightcentermode' => { 535 => 'UprightCenterMode', 537 => 'UprightCenterMode' },
	'uprightcenternormx' => { 535 => 'UprightCenterNormX', 537 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 535 => 'UprightCenterNormY', 537 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 535 => 'UprightDependentDigest', 537 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 535 => 'UprightFocalLength35mm', 537 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 535 => 'UprightFocalMode', 537 => 'UprightFocalMode' },
	'uprightfoursegments_0' => { 535 => 'UprightFourSegments_0', 537 => 'UprightFourSegments_0' },
	'uprightfoursegments_1' => { 535 => 'UprightFourSegments_1', 537 => 'UprightFourSegments_1' },
	'uprightfoursegments_2' => { 535 => 'UprightFourSegments_2', 537 => 'UprightFourSegments_2' },
	'uprightfoursegments_3' => { 535 => 'UprightFourSegments_3', 537 => 'UprightFourSegments_3' },
	'uprightfoursegmentscount' => { 535 => 'UprightFourSegmentsCount', 537 => 'UprightFourSegmentsCount' },
	'uprightguideddependentdigest' => { 535 => 'UprightGuidedDependentDigest', 537 => 'UprightGuidedDependentDigest' },
	'uprightpreview' => { 535 => 'UprightPreview', 537 => 'UprightPreview' },
	'uprighttransform_0' => { 535 => 'UprightTransform_0', 537 => 'UprightTransform_0' },
	'uprighttransform_1' => { 535 => 'UprightTransform_1', 537 => 'UprightTransform_1' },
	'uprighttransform_2' => { 535 => 'UprightTransform_2', 537 => 'UprightTransform_2' },
	'uprighttransform_3' => { 535 => 'UprightTransform_3', 537 => 'UprightTransform_3' },
	'uprighttransform_4' => { 535 => 'UprightTransform_4', 537 => 'UprightTransform_4' },
	'uprighttransform_5' => { 535 => 'UprightTransform_5', 537 => 'UprightTransform_5' },
	'uprighttransformcount' => { 535 => 'UprightTransformCount', 537 => 'UprightTransformCount' },
	'uprightversion' => { 535 => 'UprightVersion', 537 => 'UprightVersion' },
	'urgency' => { 149 => 0xa, 553 => 'Urgency' },
	'url' => { 175 => 'URL', 360 => 'URL', 424 => 0x40b, 555 => 'url' },
	'url_list' => { 424 => 0x41e },
	'urla-platform' => { 555 => [\'url','urlA-platform'] },
	'urlurl' => { 555 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 91 => 0x10a },
	'usableshootingmodes' => { 91 => 0x109 },
	'usage' => { 556 => 'usage' },
	'usageterms' => { 569 => 'UsageTerms' },
	'usbpowerdelivery' => { 261 => 0x9ac, 264 => 0x762, 265 => 0x7c2, 266 => 0x664, 267 => 0x694, 268 => 0x6fc },
	'usedialwithouthold' => { 340 => 0xc3, 341 => 0xbf, 342 => 0xbf, 343 => 0xbf },
	'useguidelines' => { 533 => 'useGuidelines' },
	'usepanoramaviewer' => { 147 => 'UsePanoramaViewer' },
	'usercollection' => { 430 => 'collection.user' },
	'usercomment' => { 104 => 0x805, 126 => 0x9286, 541 => 'UserComment' },
	'userdef1picturestyle' => { 19 => 0x10c, 76 => 0xd8, 77 => 0xf0 },
	'userdef2picturestyle' => { 19 => 0x10e, 76 => 0xda, 77 => 0xf2 },
	'userdef3picturestyle' => { 19 => 0x110, 76 => 0xdc, 77 => 0xf4 },
	'userfields' => { 527 => 'UserFields' },
	'userlabel' => { 438 => 0x2b, 439 => 0x68, 440 => 0x51, 441 => 0x76, 442 => 0x5a },
	'userprofile' => { 366 => 0x302, 370 => 0x34c, 373 => 0x3038 },
	'userrating' => { 430 => 'rating.user', 436 => 'urat' },
	'usmlenselectronicmf' => { 2 => 0x7, 90 => 0x7, 91 => 0x501 },
	'uspsnumber' => { 555 => 'uspsNumber' },
	'utmeasting' => { 186 => 'Easting' },
	'utmmapdatum' => { 186 => 'Datum' },
	'utmnorthing' => { 186 => 'Northing' },
	'utmzone' => { 186 => 'Zone' },
	'uuid' => { 535 => 'UUID', 537 => 'UUID' },
	'uv-irfiltercorrection' => { 366 => 0x325 },
	'validbits' => { 350 => 0x611, 351 => 0x102c },
	'validcropcorners' => { 361 => 'ValidCropCorners' },
	'validpixeldepth' => { 354 => 0x611 },
	'variablelowpassfilter' => { 480 => 0x2028 },
	'variousmodes' => { 158 => 0x26 },
	'variousmodes2' => { 158 => 0x3a },
	'variprogram' => { 257 => 0xab },
	'varraydacnominalvalues' => { 156 => 0x191e },
	'vendor' => { 436 => 'vndr' },
	'vendorinfo' => { 139 => 'VendorInfo' },
	'vendorinfomanufacturer' => { 139 => [\'VendorInfo','VendorInfoManufacturer'] },
	'vendorinfomodel' => { 139 => [\'VendorInfo','VendorInfoModel'] },
	'vendorinfonotes' => { 139 => [\'VendorInfo','VendorInfoNotes'] },
	'verbatimidentification' => { 125 => [\'Identification','IdentificationVerbatimIdentification'] },
	'version' => { 134 => 0x0, 361 => 'Version', 426 => 'Version', 430 => 'version', 535 => 'Version', 537 => 'Version', 546 => 'Version' },
	'versioncreatedate' => { 517 => 0xd100 },
	'versionid' => { 566 => 'VersionID' },
	'versionidentifier' => { 555 => 'versionIdentifier' },
	'versionmodifydate' => { 517 => 0xd101 },
	'versions' => { 566 => 'Versions' },
	'versionscomments' => { 566 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 566 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 566 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 566 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 566 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 566 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 566 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 566 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 566 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 566 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 566 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 324 => '3.2', 325 => '47.2', 327 => '79.1', 342 => 0x11d, 343 => 0x135 },
	'verticalclockoverlaps' => { 156 => 0x412 },
	'verticalfuncbutton' => { 325 => '42.2', 327 => '67.1', 342 => 0x115, 343 => 0x12d },
	'verticalfuncbuttonplaybackmode' => { 342 => 0x1b7, 343 => 0x1cf },
	'verticalfuncbuttonplusdials' => { 325 => '43.1' },
	'verticalfuncplusdials' => { 327 => '68.1' },
	'verticalisobutton' => { 268 => 0x792 },
	'verticalmovieafonbutton' => { 342 => 0x1f9, 343 => 0x211 },
	'verticalmoviefuncbutton' => { 342 => 0x1e1, 343 => 0x1f9 },
	'verticalmultiselector' => { 325 => '42.1', 327 => '66.1', 328 => '66.1', 338 => '66.1', 342 => 0x18f, 343 => 0x1a7 },
	'verticalmultiselectorplaybackmode' => { 342 => 0x125, 343 => 0x13d },
	'vfdisplayillumination' => { 2 => 0x11, 91 => [0x510,0x51d] },
	'vibrance' => { 528 => 'Vibrance', 535 => 'Vibrance', 537 => 'Vibrance' },
	'vibrationreduction' => { 288 => [0x75,0x82,0x1ae], 296 => '586.1', 303 => '590.2', 307 => 0x4 },
	'videoalphamode' => { 565 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 565 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 565 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 565 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 565 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 565 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 565 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 565 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 565 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 565 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 565 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 565 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 565 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 565 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 565 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 565 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 565 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 565 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 549 => 'videoBitRate' },
	'videobitratemode' => { 549 => 'videoBitRateMode' },
	'videoburstmode' => { 371 => 0xbb },
	'videoburstresolution' => { 371 => 0xb3 },
	'videocodec' => { 73 => 0x74 },
	'videocolorspace' => { 565 => 'videoColorSpace' },
	'videocompression' => { 134 => 0x3806 },
	'videocompressor' => { 565 => 'videoCompressor' },
	'videodisplayaspectratio' => { 549 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 549 => 'videoEncodingProfile' },
	'videofieldorder' => { 565 => 'videoFieldOrder' },
	'videoframerate' => { 371 => 0x27, 565 => 'videoFrameRate' },
	'videoframesize' => { 565 => 'videoFrameSize' },
	'videoframesizeh' => { 565 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 565 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 565 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 565 => 'videoModDate' },
	'videopixelaspectratio' => { 565 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 565 => 'videoPixelDepth' },
	'videopreburst' => { 371 => 0xc1 },
	'videoquality' => { 120 => 0x4003 },
	'videorecordingmode' => { 134 => 0x3803 },
	'videoshottype' => { 549 => 'VideoShotType' },
	'videoshottypeidentifier' => { 549 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 549 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 549 => 'videoStreamsCount' },
	'viewfinder' => { 419 => 0x455 },
	'viewfinderdisplay' => { 324 => '12.4', 325 => '6.3' },
	'viewfinderwarning' => { 324 => '13.4', 334 => '3.5', 335 => '6.2', 339 => '4.4' },
	'viewfinderwarnings' => { 91 => 0x40a },
	'viewinfoduringexposure' => { 91 => 0x407 },
	'viewingmode' => { 468 => 0x2f, 485 => 0x18 },
	'viewingmode2' => { 468 => [0x85,0x285] },
	'viewmodeshoweffectsofsettings' => { 268 => 0x7d2, 341 => 0x2a9 },
	'viewpoint' => { 554 => 'viewpoint' },
	'vignette' => { 456 => 0x139 },
	'vignetteamount' => { 535 => 'VignetteAmount', 537 => 'VignetteAmount' },
	'vignettecoefficient1' => { 308 => 0x24 },
	'vignettecoefficient2' => { 308 => 0x34 },
	'vignettecoefficient3' => { 308 => 0x44 },
	'vignettecontrol' => { 257 => 0x2a, 317 => 0x76a43205 },
	'vignettecontrolintensity' => { 317 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 532 => 'VignetteCorrectionAlreadyApplied' },
	'vignettecorrectionversion' => { 308 => 0x0 },
	'vignettemidpoint' => { 535 => 'VignetteMidpoint', 537 => 'VignetteMidpoint' },
	'vignetting' => { 446 => 0x1011, 453 => 0xa052 },
	'vignettingcorrection' => { 126 => 0x7031, 453 => 0xa053, 480 => 0x2011 },
	'vignettingcorrparams' => { 126 => 0x7032, 511 => 0x64a, 512 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 453 => 0xa054 },
	'virtualfocallength' => { 550 => 'VirtualFocalLength' },
	'virtualhorizonstyle' => { 340 => 0x161, 341 => 0x167, 342 => 0x167, 343 => 0x17f },
	'virtualimagexcenter' => { 550 => 'VirtualImageXCenter' },
	'virtualimageycenter' => { 550 => 'VirtualImageYCenter' },
	'visualcolor' => { 549 => 'VisualColour' },
	'visualtechnique' => { 554 => 'visualTechnique' },
	'voicememo' => { 455 => 0x216 },
	'volume' => { 555 => 'volume' },
	'vr_0x66' => { 288 => 0x66 },
	'vrdoffset' => { 70 => 0xd0 },
	'vrmode' => { 261 => 0x342, 263 => 0x226, 266 => 0x212, 267 => 0x226, 268 => 0x226, 307 => 0x6 },
	'vrtype' => { 307 => 0x8 },
	'waterdepth' => { 126 => 0x9403, 542 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 205 => 0x19a },
	'wb_bluelevel6500k' => { 205 => 0x18a },
	'wb_bluelevelcustom' => { 205 => 0x18e },
	'wb_bluelevelscloudy' => { 205 => 0x106 },
	'wb_bluelevelsdaylight' => { 205 => 0xea },
	'wb_bluelevelsflash' => { 205 => 0x122 },
	'wb_bluelevelsfluorescent' => { 205 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 205 => 0x254 },
	'wb_bluelevelsshade' => { 205 => 0x176 },
	'wb_bluelevelstungsten' => { 205 => 0xce },
	'wb_gbrglevels' => { 205 => 0xae, 208 => 0x4 },
	'wb_glevel' => { 350 => 0x11f },
	'wb_glevel3000k' => { 350 => 0x113 },
	'wb_glevel3300k' => { 350 => 0x114 },
	'wb_glevel3600k' => { 350 => 0x115 },
	'wb_glevel3900k' => { 350 => 0x116 },
	'wb_glevel4000k' => { 350 => 0x117 },
	'wb_glevel4300k' => { 350 => 0x118 },
	'wb_glevel4500k' => { 350 => 0x119 },
	'wb_glevel4800k' => { 350 => 0x11a },
	'wb_glevel5300k' => { 350 => 0x11b },
	'wb_glevel6000k' => { 350 => 0x11c },
	'wb_glevel6600k' => { 350 => 0x11d },
	'wb_glevel7500k' => { 350 => 0x11e },
	'wb_grbglevels' => { 225 => 0x0, 487 => 0x7303 },
	'wb_grbglevelsauto' => { 87 => 0x2, 487 => 0x7302 },
	'wb_grbglevelscloudy' => { 87 => 0x12 },
	'wb_grbglevelscustom1' => { 87 => 0x42 },
	'wb_grbglevelscustom2' => { 87 => 0x4a },
	'wb_grbglevelsdaylight' => { 87 => 0xa },
	'wb_grbglevelsflash' => { 87 => 0x32 },
	'wb_grbglevelsfluorescent' => { 87 => 0x22 },
	'wb_grbglevelsfluorhigh' => { 87 => 0x2a },
	'wb_grbglevelstungsten' => { 87 => 0x1a },
	'wb_grbglevelsunderwater' => { 87 => 0x3a },
	'wb_rbgglevels' => { 222 => 0x0 },
	'wb_rblevels' => { 226 => 0x270, 257 => 0xc, 350 => 0x100 },
	'wb_rblevels1' => { 377 => 0x2 },
	'wb_rblevels2' => { 377 => 0x5 },
	'wb_rblevels3' => { 377 => 0x8 },
	'wb_rblevels3000k' => { 350 => 0x102 },
	'wb_rblevels3300k' => { 350 => 0x103 },
	'wb_rblevels3500k' => { 205 => 0x430 },
	'wb_rblevels3600k' => { 350 => 0x104 },
	'wb_rblevels3900k' => { 350 => 0x105 },
	'wb_rblevels4' => { 377 => 0xb },
	'wb_rblevels4000k' => { 350 => 0x106 },
	'wb_rblevels4300k' => { 350 => 0x107 },
	'wb_rblevels4500k' => { 350 => 0x108 },
	'wb_rblevels4800k' => { 350 => 0x109 },
	'wb_rblevels5' => { 377 => 0xe },
	'wb_rblevels5300k' => { 350 => 0x10a },
	'wb_rblevels6' => { 377 => 0x11 },
	'wb_rblevels6000k' => { 350 => 0x10b },
	'wb_rblevels6500k' => { 205 => 0x420 },
	'wb_rblevels6600k' => { 350 => 0x10c },
	'wb_rblevels7' => { 377 => 0x14 },
	'wb_rblevels7500k' => { 350 => 0x10d },
	'wb_rblevelsauto' => { 226 => 0x272, 354 => 0x110 },
	'wb_rblevelscloudy' => { 205 => 0x3f0, 207 => 0x10, 226 => 0x296, 354 => 0x121 },
	'wb_rblevelscoolwhitef' => { 205 => 0x308, 207 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 354 => 0x132 },
	'wb_rblevelscustom' => { 205 => 0x424, 207 => 0x1c },
	'wb_rblevelscwb1' => { 350 => 0x10e },
	'wb_rblevelscwb2' => { 350 => 0x10f },
	'wb_rblevelscwb3' => { 350 => 0x110 },
	'wb_rblevelscwb4' => { 350 => 0x111 },
	'wb_rblevelsdaylight' => { 205 => [0x3ec,0x528], 207 => 0xc, 226 => 0x274 },
	'wb_rblevelsdaylightf' => { 207 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 354 => 0x130 },
	'wb_rblevelsdaywhitef' => { 207 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 354 => 0x131 },
	'wb_rblevelseveningsunlight' => { 354 => 0x124 },
	'wb_rblevelsfineweather' => { 354 => 0x122 },
	'wb_rblevelsflash' => { 205 => [0x3f4,0x304], 207 => 0x18, 226 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 226 => 0x290 },
	'wb_rblevelsincandescent' => { 226 => 0x282 },
	'wb_rblevelsshade' => { 205 => 0x418, 207 => 0x20, 226 => 0x2b2, 354 => 0x120 },
	'wb_rblevelstungsten' => { 205 => 0x3e8, 207 => 0x8, 354 => 0x123 },
	'wb_rblevelsused' => { 354 => 0x100 },
	'wb_rblevelswhitef' => { 207 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 354 => 0x133 },
	'wb_redlevel3500k' => { 205 => 0x198 },
	'wb_redlevel6500k' => { 205 => 0x188 },
	'wb_redlevelcustom' => { 205 => 0x18c },
	'wb_redlevelscloudy' => { 205 => 0xf8 },
	'wb_redlevelsdaylight' => { 205 => 0xdc },
	'wb_redlevelsflash' => { 205 => 0x114 },
	'wb_redlevelsfluorescent' => { 205 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 205 => 0x1be },
	'wb_redlevelsshade' => { 205 => 0x168 },
	'wb_redlevelstungsten' => { 205 => 0xc0 },
	'wb_rgbglevels' => { 224 => 0x0 },
	'wb_rgblevels' => { 205 => [0x546,0x96], 367 => 0xd, 368 => 0x413, 373 => 0x3036, 419 => 0x107, 489 => 0x117c, 490 => 0x1180, 491 => 0x115c, 492 => 0x11d8, 493 => 0x11b4, 494 => 0x106c, 495 => 0x264, 496 => 0x264, 497 => 0x252 },
	'wb_rgblevels1' => { 378 => 0x2 },
	'wb_rgblevels2' => { 378 => 0x6 },
	'wb_rgblevels2500k' => { 487 => 0x782d },
	'wb_rgblevels3' => { 378 => 0xa },
	'wb_rgblevels3200k' => { 487 => 0x782c },
	'wb_rgblevels4' => { 378 => 0xe },
	'wb_rgblevels4500k' => { 487 => [0x7484,0x7824] },
	'wb_rgblevels5' => { 378 => 0x12 },
	'wb_rgblevels6' => { 378 => 0x16 },
	'wb_rgblevels6000k' => { 487 => 0x782b },
	'wb_rgblevels7' => { 378 => 0x1a },
	'wb_rgblevels8500k' => { 487 => 0x782a },
	'wb_rgblevelsauto' => { 457 => 0x0 },
	'wb_rgblevelscloudy' => { 487 => [0x7481,0x7821] },
	'wb_rgblevelscustom1' => { 457 => 0x15 },
	'wb_rgblevelscustom2' => { 457 => 0x18 },
	'wb_rgblevelscustom3' => { 457 => 0x1b },
	'wb_rgblevelsdaylight' => { 457 => 0x3, 487 => [0x7480,0x7820] },
	'wb_rgblevelsflash' => { 457 => 0x12, 487 => [0x7483,0x7823] },
	'wb_rgblevelsfluorescent' => { 457 => 0xf, 487 => [0x7486,0x7826] },
	'wb_rgblevelsfluorescentm1' => { 487 => 0x7829 },
	'wb_rgblevelsfluorescentp1' => { 487 => 0x7827 },
	'wb_rgblevelsfluorescentp2' => { 487 => 0x7828 },
	'wb_rgblevelsincandescent' => { 457 => 0xc },
	'wb_rgblevelsovercast' => { 457 => 0x9 },
	'wb_rgblevelsshade' => { 457 => 0x6, 487 => 0x7825 },
	'wb_rgblevelstungsten' => { 487 => [0x7482,0x7822] },
	'wb_rgblevelsunknown0' => { 458 => 0x0 },
	'wb_rgblevelsunknown1' => { 458 => 0x3 },
	'wb_rgblevelsunknown2' => { 458 => 0x6 },
	'wb_rgblevelsunknown3' => { 458 => 0x9 },
	'wb_rgblevelsunknown4' => { 458 => 0xc },
	'wb_rgblevelsunknown5' => { 458 => 0xf },
	'wb_rgblevelsunknown6' => { 458 => 0x12 },
	'wb_rgblevelsunknown7' => { 458 => 0x15 },
	'wb_rgblevelsunknown8' => { 458 => 0x18 },
	'wb_rgblevelsunknown9' => { 458 => 0x1b },
	'wb_rgbmuldaylight' => { 156 => 0x852 },
	'wb_rgbmulflash' => { 156 => 0x855 },
	'wb_rgbmulfluorescent' => { 156 => 0x854 },
	'wb_rgbmultungsten' => { 156 => 0x853 },
	'wb_rggbblacklevels' => { 39 => 0x25 },
	'wb_rggblevels' => { 126 => 0x7313, 208 => 0x4, 223 => 0x0, 227 => 0x13e8, 228 => 0x38, 487 => 0x7313 },
	'wb_rggblevelsasshot' => { 42 => 0x0, 43 => 0x0, 44 => 0x19, 45 => 0x55, 46 => 0x69, 47 => 0x69, 48 => 0x22, 49 => 0x3f, 52 => 0x3f, 53 => 0x3f, 54 => 0x3f, 55 => 0x47 },
	'wb_rggblevelsauto' => { 39 => 0x1, 42 => 0x5, 43 => 0x8, 44 => 0x1e, 45 => 0x5a, 46 => 0x6e, 48 => 0x18, 49 => 0x44, 52 => 0x44, 53 => 0x44, 54 => 0x44, 55 => 0x4c, 227 => 0x1478, 228 => 0x114, 453 => 0xa022, 487 => 0x7312 },
	'wb_rggblevelsblack' => { 453 => 0xa028 },
	'wb_rggblevelscloudy' => { 39 => 0xd, 42 => 0x1e, 43 => 0x30, 44 => 0x2d, 45 => 0xa0, 46 => 0xd7, 47 => 0x78, 48 => 0x31, 49 => 0x58, 52 => 0x71, 53 => 0x8a, 54 => 0x8f, 55 => 0x92, 227 => 0x1408, 228 => 0x60, 410 => 0x20f, 418 => 0x14 },
	'wb_rggblevelscustom' => { 39 => 0x1d, 49 => 0x80, 227 => 0x1468, 228 => 0x100 },
	'wb_rggblevelscustom1' => { 44 => 0x41 },
	'wb_rggblevelscustom2' => { 44 => 0x46 },
	'wb_rggblevelsdaylight' => { 39 => 0x5, 42 => 0x14, 43 => 0x20, 44 => 0x23, 45 => 0x96, 46 => 0xcd, 47 => 0x6e, 48 => 0x27, 49 => 0x4e, 52 => 0x67, 53 => 0x80, 54 => 0x85, 55 => 0x88, 227 => 0x13f8, 228 => 0x4c, 410 => 0x20d, 418 => 0x2 },
	'wb_rggblevelsflash' => { 39 => 0x19, 42 => 0x32, 43 => 0x50, 44 => 0x3c, 45 => 0xb4, 46 => 0xeb, 47 => 0x87, 48 => 0x45, 49 => 0x6c, 52 => 0x85, 53 => 0x9e, 54 => 0xa3, 55 => 0xa6, 227 => 0x1448, 410 => 0x214, 418 => 0x41 },
	'wb_rggblevelsfluorescent' => { 39 => 0x15, 42 => 0x28, 43 => 0x40, 44 => 0x37, 45 => 0xaa, 46 => 0xe1, 47 => 0x82, 48 => 0x3b, 49 => 0x62, 52 => 0x7b, 53 => 0x94, 54 => 0x99, 55 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 228 => 0xc4, 410 => 0x211, 418 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 418 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 228 => 0xb0, 410 => 0x212, 418 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 227 => 0x1438, 228 => 0x9c, 410 => 0x213, 418 => 0x38 },
	'wb_rggblevelshtmercury' => { 228 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 453 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 453 => 0xa024 },
	'wb_rggblevelskelvin' => { 39 => 0x21, 42 => 0x2d, 43 => 0x48, 45 => 0xaf, 46 => 0xe6, 48 => 0x40, 49 => 0x67, 52 => 0x80, 53 => 0x99, 54 => 0x9e, 55 => 0xa1 },
	'wb_rggblevelsmeasured' => { 42 => 0xa, 43 => 0x10, 45 => 0x5f, 46 => 0x73, 49 => 0x49, 52 => 0x49, 53 => 0x49, 54 => 0x49, 55 => 0x51 },
	'wb_rggblevelspc1' => { 48 => 0x90, 49 => 0x71 },
	'wb_rggblevelspc2' => { 48 => 0x95, 49 => 0x76 },
	'wb_rggblevelspc3' => { 48 => 0x9a, 49 => 0x7b },
	'wb_rggblevelsshade' => { 39 => 0x9, 42 => 0x19, 43 => 0x28, 44 => 0x28, 45 => 0x9b, 46 => 0xd2, 47 => 0x73, 48 => 0x2c, 49 => 0x53, 52 => 0x6c, 53 => 0x85, 54 => 0x8a, 55 => 0x8d, 228 => 0x74, 410 => 0x20e, 418 => 0xb },
	'wb_rggblevelstungsten' => { 39 => 0x11, 42 => 0x23, 43 => 0x38, 44 => 0x32, 45 => 0xa5, 46 => 0xdc, 47 => 0x7d, 48 => 0x36, 49 => 0x5d, 52 => 0x76, 53 => 0x8f, 54 => 0x94, 55 => 0x97, 227 => 0x1428, 228 => 0x88, 410 => 0x210, 418 => 0x1d },
	'wb_rggblevelsuncorrected' => { 453 => 0xa021 },
	'wb_rggblevelsunknown' => { 42 => 0xf, 43 => 0x18, 45 => 0x64, 46 => 0x78, 48 => 0x1d, 52 => 0x4e, 53 => 0x4e, 54 => 0x4e, 55 => 0x56, 418 => 0x53 },
	'wb_rggblevelsunknown10' => { 42 => 0x5f, 43 => 0x98, 45 => 0x91, 46 => 0xa5, 47 => 0xb4, 48 => 0x72, 52 => 0x9e, 53 => 0x7b, 54 => 0x7b, 55 => 0x83 },
	'wb_rggblevelsunknown11' => { 42 => 0x64, 43 => 0xa0, 45 => 0xb9, 46 => [0xaa,0xaf], 47 => 0xb9, 48 => 0x77, 52 => 0xa3, 53 => 0xa3, 54 => 0x80, 55 => 0xab },
	'wb_rggblevelsunknown12' => { 42 => 0x69, 43 => 0xa8, 45 => 0xbe, 46 => 0xb4, 47 => 0xbe, 48 => 0x7c, 52 => 0xa8, 53 => 0xa8, 54 => 0xa8, 55 => 0xb0 },
	'wb_rggblevelsunknown13' => { 42 => 0x6e, 43 => 0xb0, 45 => 0xc3, 46 => 0xb9, 47 => 0xc3, 48 => 0x81, 52 => 0xad, 53 => 0xad, 54 => 0xad, 55 => 0xb5 },
	'wb_rggblevelsunknown14' => { 45 => 0xc8, 46 => 0xbe, 47 => 0xc8, 48 => 0x86, 52 => 0xb2, 53 => 0xb2, 54 => 0xb2, 55 => 0xba },
	'wb_rggblevelsunknown15' => { 45 => 0xcd, 46 => 0xc3, 47 => 0xcd, 48 => 0x8b, 52 => 0xb7, 53 => 0xb7, 54 => 0xb7, 55 => 0xbf },
	'wb_rggblevelsunknown16' => { 45 => 0xd2, 46 => 0xc8, 47 => 0xd2, 48 => 0x9f, 53 => 0xbc, 54 => 0xbc, 55 => 0xc4 },
	'wb_rggblevelsunknown17' => { 45 => 0xd7, 46 => 0xf0, 47 => 0xd7, 53 => 0xc1, 54 => 0xc1, 55 => 0xc9 },
	'wb_rggblevelsunknown18' => { 45 => 0xdc, 46 => 0xf5, 47 => 0xdc, 53 => 0xc6, 54 => 0xc6, 55 => 0xce },
	'wb_rggblevelsunknown19' => { 45 => 0xe1, 46 => 0xfa, 47 => 0xe1, 53 => 0xcb, 54 => 0xcb, 55 => 0xd3 },
	'wb_rggblevelsunknown2' => { 42 => 0x37, 43 => 0x58, 45 => 0x69, 46 => 0x7d, 47 => 0x8c, 48 => 0x4a, 52 => 0x53, 53 => 0x53, 54 => 0x53, 55 => 0x5b },
	'wb_rggblevelsunknown20' => { 45 => 0xe6, 46 => 0xff, 47 => 0xe6, 53 => 0xd0, 54 => 0xd0, 55 => 0xd8 },
	'wb_rggblevelsunknown21' => { 45 => 0xeb, 46 => 0x104, 47 => 0xeb, 54 => 0xd5, 55 => 0xdd },
	'wb_rggblevelsunknown22' => { 45 => 0xf0, 46 => 0x109, 47 => 0xf0, 54 => 0xda, 55 => 0xe2 },
	'wb_rggblevelsunknown23' => { 45 => 0xf5, 46 => 0x10e, 47 => 0xf5, 54 => 0xdf, 55 => 0xe7 },
	'wb_rggblevelsunknown24' => { 45 => 0xfa, 46 => 0x113, 47 => 0xfa, 54 => 0xe4, 55 => 0xec },
	'wb_rggblevelsunknown25' => { 45 => 0xff, 46 => 0x118, 47 => 0xff, 54 => 0xe9, 55 => 0xf1 },
	'wb_rggblevelsunknown26' => { 45 => 0x104, 46 => 0x11d, 47 => 0x104, 54 => 0xee, 55 => 0xf6 },
	'wb_rggblevelsunknown27' => { 45 => 0x109, 46 => 0x122, 47 => 0x109, 54 => 0xf3, 55 => 0xfb },
	'wb_rggblevelsunknown28' => { 45 => 0x10e, 47 => 0x10e, 54 => 0xf8, 55 => 0x100 },
	'wb_rggblevelsunknown29' => { 45 => 0x113, 47 => 0x113, 54 => 0xfd, 55 => 0x105 },
	'wb_rggblevelsunknown3' => { 42 => 0x3c, 43 => 0x60, 45 => 0x6e, 46 => 0x82, 47 => 0x91, 48 => 0x4f, 52 => 0x58, 53 => 0x58, 54 => 0x58, 55 => 0x60 },
	'wb_rggblevelsunknown30' => { 47 => 0x118, 54 => 0x102 },
	'wb_rggblevelsunknown31' => { 47 => 0x11d },
	'wb_rggblevelsunknown32' => { 47 => 0x122 },
	'wb_rggblevelsunknown33' => { 47 => 0x127 },
	'wb_rggblevelsunknown4' => { 42 => 0x41, 43 => 0x68, 45 => 0x73, 46 => 0x87, 47 => 0x96, 48 => 0x54, 52 => 0x5d, 53 => 0x5d, 54 => 0x5d, 55 => 0x65 },
	'wb_rggblevelsunknown5' => { 42 => 0x46, 43 => 0x70, 45 => 0x78, 46 => 0x8c, 47 => 0x9b, 48 => 0x59, 52 => 0x62, 53 => 0x62, 54 => 0x62, 55 => 0x6a },
	'wb_rggblevelsunknown6' => { 42 => 0x4b, 43 => 0x78, 45 => 0x7d, 46 => 0x91, 47 => 0xa0, 48 => 0x5e, 52 => 0x8a, 53 => 0x67, 54 => 0x67, 55 => 0x6f },
	'wb_rggblevelsunknown7' => { 42 => 0x50, 43 => 0x80, 45 => 0x82, 46 => 0x96, 47 => 0xa5, 48 => 0x63, 52 => 0x8f, 53 => 0x6c, 54 => 0x6c, 55 => 0x74 },
	'wb_rggblevelsunknown8' => { 42 => 0x55, 43 => 0x88, 45 => 0x87, 46 => 0x9b, 47 => 0xaa, 48 => 0x68, 52 => 0x94, 53 => 0x71, 54 => 0x71, 55 => 0x79 },
	'wb_rggblevelsunknown9' => { 42 => 0x5a, 43 => 0x90, 45 => 0x8c, 46 => 0xa0, 47 => 0xaf, 48 => 0x6d, 52 => 0x99, 53 => 0x76, 54 => 0x76, 55 => 0x7e },
	'wb_rggblevelsuserselected' => { 418 => 0x5c },
	'wbadjblueamber' => { 110 => 0x20106 },
	'wbadjbluebalance' => { 323 => 0x8 },
	'wbadjcolortemp' => { 110 => 0x20102, 115 => 0x1a },
	'wbadjlighting' => { 323 => 0x14 },
	'wbadjmagentagreen' => { 110 => 0x20105 },
	'wbadjmode' => { 323 => 0x10 },
	'wbadjredbalance' => { 323 => 0x0 },
	'wbadjrggblevels' => { 110 => 0x20125, 115 => 0x6 },
	'wbadjtemperature' => { 323 => 0x18 },
	'wbadjtint' => { 323 => 0x25 },
	'wbblue' => { 134 => 0x144c },
	'wbbluelevel' => { 366 => 0x324, 371 => 0x8006, 376 => 0x26 },
	'wbbracketingsteps' => { 219 => 0x10, 220 => 0x10, 297 => 0x174d },
	'wbbracketmode' => { 62 => 0x9 },
	'wbbracketshotnumber' => { 205 => 0x2b, 446 => 0x101a },
	'wbbracketvalueab' => { 62 => 0xc },
	'wbbracketvaluegm' => { 62 => 0xd },
	'wbbutton' => { 265 => 0x806, 268 => 0x80a },
	'wbbuttonplaybackmode' => { 341 => 0x1c5 },
	'wbfinetuneactive' => { 115 => 0x24 },
	'wbfinetunesaturation' => { 115 => 0x28 },
	'wbfinetunetone' => { 115 => 0x2c },
	'wbgreen' => { 134 => 0x144b },
	'wbgreenlevel' => { 366 => 0x323, 371 => 0x8005, 376 => 0x25 },
	'wbmediaimagesizesetting' => { 91 => 0x708 },
	'wbmode' => { 207 => 0x4, 351 => 0x1015 },
	'wbred' => { 134 => 0x144a },
	'wbredlevel' => { 366 => 0x322, 371 => 0x8004, 376 => 0x24 },
	'wbscale' => { 208 => 0x0 },
	'wbshiftab' => { 80 => 0xc, 371 => 0x46, 390 => 0x10 },
	'wbshiftab_gm' => { 480 => 0x2014 },
	'wbshiftab_gm_precise' => { 480 => 0x2026 },
	'wbshiftcreativecontrol' => { 371 => 0x92 },
	'wbshiftgm' => { 80 => 0xd, 371 => 0x47, 390 => 0x11 },
	'wbshiftintelligentauto' => { 371 => 0x8b },
	'wbtype1' => { 377 => 0x1, 378 => 0x1 },
	'wbtype2' => { 377 => 0x4, 378 => 0x5 },
	'wbtype3' => { 377 => 0x7, 378 => 0x9 },
	'wbtype4' => { 377 => 0xa, 378 => 0xd },
	'wbtype5' => { 377 => 0xd, 378 => 0x11 },
	'wbtype6' => { 377 => 0x10, 378 => 0x15 },
	'wbtype7' => { 377 => 0x13, 378 => 0x19 },
	'webstatement' => { 569 => 'WebStatement' },
	'weightedflatsubject' => { 526 => 'weightedFlatSubject' },
	'what' => { 535 => 'What', 537 => 'What' },
	'whitebalance' => { 7 => 0x6f, 8 => [0x44,0x4a], 9 => 0xbc, 10 => 0x36, 11 => 0x5e, 12 => 0x36, 13 => 0x78, 14 => 0x6f, 15 => 0x6f, 16 => 0x73, 17 => 0x6f, 18 => 0x78, 19 => 0x54, 20 => 0x6f, 21 => 0xbc, 22 => 0x7b, 24 => 0xbc, 25 => 0xc2, 27 => 0x131, 28 => 0x77, 80 => 0x8, 83 => 0x7, 119 => 0x7, 120 => [0x19,0x2012], 126 => [0xa403,0xfe4e], 134 => 0x1002, 156 => 0x3fc, 157 => 0xfa0d, 158 => 0x40, 169 => 0x1a, 199 => 0x3, 200 => 0xe, 201 => 0x4, 202 => 0xb, 204 => 0x115, 257 => 0x5, 306 => 0x7, 366 => 0x304, 371 => 0x3, 373 => 0x3033, 410 => 0x19, 417 => 0x7, 445 => 0x26, 446 => 0x1003, 456 => [0x88,0x3c,0x7,0x58], 466 => 0xf, 467 => 0xe, 480 => [0x115,0xb054], 535 => 'WhiteBalance', 537 => 'WhiteBalance', 541 => 'WhiteBalance' },
	'whitebalance0' => { 194 => 'WhiteBalance0' },
	'whitebalance1' => { 194 => 'WhiteBalance1' },
	'whitebalance2' => { 194 => 'WhiteBalance2', 346 => 0x500 },
	'whitebalanceadj' => { 110 => 0x20101, 115 => 0x18, 317 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 385 => 0x0 },
	'whitebalancebias' => { 120 => 0x2011, 351 => 0x304, 371 => 0x23 },
	'whitebalanceblue' => { 80 => 0x7 },
	'whitebalancebracket' => { 346 => 0x502, 351 => 0x303 },
	'whitebalancebracketing' => { 134 => 0x1102, 202 => 0x22, 205 => 0x2c, 477 => 0x2c },
	'whitebalancebuttonplaybackmode' => { 342 => 0x1c5, 343 => 0x1dd },
	'whitebalancecomp' => { 354 => 0x1001 },
	'whitebalancedetected' => { 156 => 0x3fb },
	'whitebalancefinetune' => { 134 => 0x100a, 202 => 0x38, 204 => 0x112, 257 => [0xb,0x3f], 446 => 0x1004, 466 => 0x6, 467 => 0x5, 480 => 0x112 },
	'whitebalancemode' => { 156 => 0x3fa, 410 => 0x1a },
	'whitebalancered' => { 80 => 0x6 },
	'whitebalanceset' => { 389 => 0xa },
	'whitebalancesetting' => { 202 => 0x23, 466 => 0x5, 467 => 0x4, 468 => 0x16, 485 => 0xd },
	'whitebalancesetup' => { 453 => 0x41 },
	'whitebalancetemperature' => { 346 => 0x501 },
	'whiteboard' => { 351 => 0x301 },
	'whitelevel' => { 126 => 0xc61d, 410 => 0x7e, 487 => 0x787f },
	'whitepoint' => { 126 => 0x13e, 370 => 0x35d, 410 => 0x201, 561 => 'WhitePoint' },
	'whites2012' => { 535 => 'Whites2012', 537 => 'Whites2012' },
	'whitesadj' => { 517 => 0x9017 },
	'wholeareatracking' => { 2 => 0x1a },
	'wideadapter' => { 446 => 0x1017 },
	'widefocuszone' => { 199 => 0x2f },
	'widerange' => { 455 => 0x20f },
	'wififirmwaredate' => { 441 => 0x42 },
	'wififirmwareversion' => { 441 => 0x3c },
	'windmode' => { 156 => 0x3f4 },
	'windnoisereduction' => { 263 => 0x352, 266 => 0x2d6, 267 => 0x2fe, 268 => 0x2fe },
	'windowlocation' => { 436 => 'WLOC' },
	'windowsatom' => { 536 => 'windowsAtom' },
	'windowsatomextension' => { 536 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 536 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 536 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 555 => 'wordCount' },
	'work' => { 428 => "\xa9wrk" },
	'workcolorspace' => { 110 => 0x10200, 115 => 0x270 },
	'workflowtag' => { 549 => 'WorkflowTag' },
	'workflowtagcvid' => { 549 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 549 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 549 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 549 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 543 => 'WorkToDo' },
	'worldtimelocation' => { 371 => 0x3a, 410 => 0x22, 416 => '0.1' },
	'writer' => { 197 => 'WM/Writer' },
	'writer-editor' => { 149 => 0x7a },
	'x3filllight' => { 456 => 0x12 },
	'xattrmditemwherefroms' => { 192 => 'com.apple.metadata:kMDItemWhereFroms' },
	'xattrquarantine' => { 192 => 'com.apple.quarantine' },
	'xiaomiexifinfo' => { 430 => 'xiaomi.exifInfo.videoinfo' },
	'xiaomihdr10' => { 430 => 'com.xiaomi.hdr10' },
	'xiaomimodel' => { 126 => 0x9a00 },
	'xiaomipreviewvideocover' => { 430 => 'com.xiaomi.preview_video_cover' },
	'xiaomisettings' => { 126 => 0x9999 },
	'xilinxversion' => { 156 => 0x414 },
	'xml' => { 154 => 'xml ' },
	'xmp' => { 113 => 0xffff00f6, 127 => 'XMP', 137 => 'XMP Data/XMP' },
	'xmptoolkit' => { 562 => 'xmptk' },
	'xpauthor' => { 126 => 0x9c9d },
	'xpcomment' => { 126 => 0x9c9c },
	'xpkeywords' => { 126 => 0x9c9e },
	'xposition' => { 126 => 0x11e },
	'xpsubject' => { 126 => 0x9c9f },
	'xptitle' => { 126 => 0x9c9b },
	'xresolution' => { 126 => 0x11a, 152 => 0x3, 425 => 0x0, 561 => 'XResolution' },
	'xyresolution' => { 130 => 0x3 },
	'yaw' => { 122 => 0x7, 436 => ['_yaw',"\xa9fyw"] },
	'yawangle' => { 273 => 0x8, 451 => 0x0 },
	'ycbcrcoefficients' => { 126 => 0x211, 561 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 126 => 0x213, 561 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 126 => 0x212, 561 => 'YCbCrSubSampling' },
	'year' => { 428 => 'yrrc', 430 => 'year', 436 => 'yrrc' },
	'yearcreated' => { 158 => 0x10, 167 => 0xc },
	'yellowhsl' => { 110 => 0x20912 },
	'yield' => { 557 => 'yield' },
	'yposition' => { 126 => 0x11f },
	'yresolution' => { 126 => 0x11b, 152 => 0x5, 425 => 0x4, 561 => 'YResolution' },
	'zebrapatterntonerange' => { 341 => 0x211, 342 => 0x211, 343 => 0x229 },
	'zoneidentifier' => { 127 => 'ZoneIdentifier' },
	'zonematching' => { 204 => 0x10a, 207 => [0x3a,0x4a], 480 => 0xb024 },
	'zonematchingmode' => { 202 => 0x14 },
	'zonematchingon' => { 201 => 0x75 },
	'zonematchingvalue' => { 466 => 0x1f },
	'zoomedpreviewlength' => { 351 => 0xf05 },
	'zoomedpreviewsize' => { 351 => 0xf06 },
	'zoomedpreviewstart' => { 351 => 0xf04 },
	'zoomsourcewidth' => { 38 => 0x24 },
	'zoomstepcount' => { 349 => 0x300, 351 => 0x100d },
	'zoomtargetwidth' => { 38 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_misb' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accel360fly' => 1,
	'acceldata' => 1,
	'accelerometermatrix' => 1,
	'accelerometertime' => 1,
	'accelerometerunknown' => 1,
	'accelmode' => 1,
	'accelypr' => 1,
	'accessdate' => 1,
	'accessrights' => 1,
	'accompaniment' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acdsee-rs' => 1,
	'acidizer' => 1,
	'acidizerflags' => 1,
	'acnespotremoval' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actors' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'additionalinfo' => 1,
	'adjdebuginfo' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adjustmentdata' => 1,
	'adjustmentssettingsstatisticslightmap' => 1,
	'adjustmentvalue' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aedebuginfo' => 1,
	'aeflags' => 1,
	'aehistograminfo' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'aeliveviewhistograminfo' => 1,
	'aeliveviewlocalhistogram' => 1,
	'aelocalhistogram' => 1,
	'af' => 1,
	'af-cprioritysel' => 1,
	'af-sprioritysel' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'afdebuginfo' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfok3iii' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afpointsspecial' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airfieldbarometricpressure' => 1,
	'airfieldelevation' => 1,
	'airspeed' => 1,
	'airtemperature' => 1,
	'airulerunits' => 1,
	'aistream' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartistsortorder' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitlesortorder' => 1,
	'alerts' => 1,
	'alexa' => 1,
	'alexa-paireddevicename' => 1,
	'alexa-pairing' => 1,
	'alexa-privacymode' => 1,
	'alexa-wakewordlanguage' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaisused' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alphavalue' => 1,
	'alternatealtitude' => 1,
	'alternateduotonecolors' => 1,
	'alternateellipsoidheight' => 1,
	'alternateellipsoidheightextended' => 1,
	'alternateformattrack' => 1,
	'alternateheading' => 1,
	'alternatelatitude' => 1,
	'alternatelongitude' => 1,
	'alternatename' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'altitudefromtakeoff' => 1,
	'ambienceinfo' => 1,
	'ambisonicchannelmap' => 1,
	'ambisonicchannelordering' => 1,
	'ambisonicchannels' => 1,
	'ambisonicnormalization' => 1,
	'ambisonicorder' => 1,
	'ambisonictype' => 1,
	'amendlocalset' => 1,
	'androidrelease' => 1,
	'angleaxis' => 1,
	'angleofattack' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'apdi' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'appledataoffsets' => 1,
	'applemaildatereceived' => 1,
	'applemaildatesent' => 1,
	'applemailflagged' => 1,
	'applemailisremoteattachment' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'application' => 1,
	'application_riff' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationunknown' => 1,
	'applicationversion' => 1,
	'applysettingstoliveview' => 1,
	'appname' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arcoreaccel' => 1,
	'arcoreaccel0' => 1,
	'arcorecustom' => 1,
	'arcoregyro' => 1,
	'arcoregyro0' => 1,
	'arcorevideo' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artists' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiounwarped' => 1,
	'aspectratiowarped' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantdirector' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'associateddatalist' => 1,
	'associatedimagefile' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'ast' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atob3' => 1,
	'atom0' => 1,
	'atsccontent' => 1,
	'attachbinary' => 1,
	'attachfileextension' => 1,
	'attachfilename' => 1,
	'attachlongfilename' => 1,
	'attachlongpathname' => 1,
	'attachments' => 1,
	'attachmethod' => 1,
	'attachmimetype' => 1,
	'attachnum' => 1,
	'attachpathname' => 1,
	'attachsize' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attr' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobluetooth' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiokeys' => 1,
	'audiolayer' => 1,
	'audiolevel' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioprotuneoption' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoridentifier' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorname' => 1,
	'authors' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'autoareaafstartingpoint' => 1,
	'autoboostscore' => 1,
	'autocaptureoffset' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'automationanimation' => 1,
	'automationflags' => 1,
	'autopoweroff' => 1,
	'autoprotune' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimageref' => 1,
	'av1configuration' => 1,
	'av1configurationversion' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averageframerate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbdebuginfo' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'axml' => 1,
	'b1' => 1,
	'b2' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barcodes' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'basename' => 1,
	'baseviewpointnum' => 1,
	'basicfileinfo' => 1,
	'basisobject' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats' => 1,
	'beats-per-minute' => 1,
	'beautycolorlevel' => 1,
	'beautyenable' => 1,
	'beautyretouchlevel' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bibliographicreferences' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binarydata' => 1,
	'binarydatatype' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'binning' => 1,
	'birthday' => 1,
	'bitdepthchroma' => 1,
	'bitdepthluma' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitratesetting' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetoothmacaddress' => 1,
	'bluetoothname' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'blurstrength' => 1,
	'blush' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'body' => 1,
	'bokehshape' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bpm' => 1,
	'bps' => 1,
	'bracketingburstoptions' => 1,
	'bracketingcounter' => 1,
	'bracketingmode' => 1,
	'bracketingoffset' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'brdfatob0' => 1,
	'brdfatob1' => 1,
	'brdfatob2' => 1,
	'brdfatob3' => 1,
	'brdfbtoa0' => 1,
	'brdfbtoa1' => 1,
	'brdfbtoa2' => 1,
	'brdfbtoa3' => 1,
	'brdfbtod0' => 1,
	'brdfbtod1' => 1,
	'brdfbtod2' => 1,
	'brdfbtod3' => 1,
	'brdfcolorimetricparam0' => 1,
	'brdfcolorimetricparam1' => 1,
	'brdfcolorimetricparam2' => 1,
	'brdfcolorimetricparam3' => 1,
	'brdfdtob0' => 1,
	'brdfdtob1' => 1,
	'brdfdtob2' => 1,
	'brdfdtob3' => 1,
	'brdfmtob0' => 1,
	'brdfmtob1' => 1,
	'brdfmtob2' => 1,
	'brdfmtob3' => 1,
	'brdfmtos0' => 1,
	'brdfmtos1' => 1,
	'brdfmtos2' => 1,
	'brdfmtos3' => 1,
	'brdfspectralparam0' => 1,
	'brdfspectralparam1' => 1,
	'brdfspectralparam2' => 1,
	'brdfspectralparam3' => 1,
	'breakchar' => 1,
	'briefdescription' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'brotliexif' => 1,
	'brotlijumb' => 1,
	'brotlixmp' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btoa3' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwf_umid' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'byteordermark' => 1,
	'byterange' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'bytespersample' => 1,
	'c2pa' => 1,
	'c2pasalthash' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'cafpointinfo' => 1,
	'cafpointsinfocus' => 1,
	'cafpointsselected' => 1,
	'cafsensitivity' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'callsign' => 1,
	'camcore' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapan' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'cameratilt' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfog5xii' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfor6' => 1,
	'canoncamerainfor6m2' => 1,
	'canoncamerainfor6m3' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedelaytimer' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'car' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'catalognumber' => 1,
	'caveats' => 1,
	'cbor' => 1,
	'cbordata' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel01' => 1,
	'channel01description' => 1,
	'channel01dispmax' => 1,
	'channel01dispmin' => 1,
	'channel01flags' => 1,
	'channel01id' => 1,
	'channel01interval' => 1,
	'channel01max' => 1,
	'channel01min' => 1,
	'channel01multiplier' => 1,
	'channel01name' => 1,
	'channel01num' => 1,
	'channel01offset' => 1,
	'channel01type' => 1,
	'channel01units' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelcolordata' => 1,
	'channelcolorindicates' => 1,
	'channelcolorspace' => 1,
	'channelcount' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelopacity' => 1,
	'channeloptions' => 1,
	'channeltype' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'character' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'checksum' => 1,
	'children' => 1,
	'chmversion' => 1,
	'choregrapher' => 1,
	'chromaformat' => 1,
	'chromasampleposition' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chrominancetable' => 1,
	'chunkcount' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'churchillnav' => 1,
	'cicodepoints' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classificationandmarkingsystem' => 1,
	'classificationcomments' => 1,
	'classificationdatapresent' => 1,
	'classificationreason' => 1,
	'classifiedby' => 1,
	'classifyingcountry' => 1,
	'classifyingcountrycodemethod' => 1,
	'classifyingcountrycodingmethoddate' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipcenterx' => 1,
	'clipcentery' => 1,
	'clipheight' => 1,
	'cliphflip' => 1,
	'cliphflipeffect' => 1,
	'cliphozperspective' => 1,
	'clipinfovalue' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cliprotate' => 1,
	'cliprotateeffect' => 1,
	'cliprotation' => 1,
	'cliprotationeffect' => 1,
	'clipverperspective' => 1,
	'clipvflip' => 1,
	'clipvflipeffect' => 1,
	'clipwidth' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'closedcaptiontrack' => 1,
	'cmddialsaperturesetting' => 1,
	'cmddialschangemainsub' => 1,
	'cmddialschangemainsubexposure' => 1,
	'cmddialsmenuandplayback' => 1,
	'cmddialsreverserotexposurecomp' => 1,
	'cmmflags' => 1,
	'cmp1' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantinfoout' => 1,
	'colorantorder' => 1,
	'colorantorderout' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalance0219' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown1' => 1,
	'colorbalanceunknown2' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata10' => 1,
	'colordata11' => 1,
	'colordata12' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorencodingparams' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetricspecification' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorpopstrength' => 1,
	'colorprimaries' => 1,
	'colorprofiles' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspacename' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransferfunction' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columncount' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblefontname' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composernationality' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositeimaginglocalset' => 1,
	'compositinglayerheader' => 1,
	'compositionlocation' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressioncodecs' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductors' => 1,
	'confidencemapimage' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'connectortype' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'constantframerate' => 1,
	'constraintindicatorflags' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contentbranding' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentlightlevel' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstatus' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastdetectaf' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'controllevel' => 1,
	'conttake' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'coordinateunits' => 1,
	'coproducer' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'cornerlatitude1' => 1,
	'cornerlatitude2' => 1,
	'cornerlatitude3' => 1,
	'cornerlatitude4' => 1,
	'cornerlongitude1' => 1,
	'cornerlongitude2' => 1,
	'cornerlongitude3' => 1,
	'cornerlongitude4' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crc' => 1,
	'crcdevelparams' => 1,
	'crd' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapp' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatormodule' => 1,
	'creatoros' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'creditclass' => 1,
	'creditdir' => 1,
	'creditname' => 1,
	'creditrole' => 1,
	'crediturl' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs0' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepointlabel' => 1,
	'cuepointnote' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'custominfo' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'customsettingsz6iii' => 1,
	'customsettingsz8' => 1,
	'customsettingsz9' => 1,
	'customsettingsz9v4' => 1,
	'customtostandardpcc' => 1,
	'cxf' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'd2' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcircle' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'dataformat' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'date1' => 1,
	'date2' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateencoded' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datepurchased' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetagged' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'datewritten' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'db' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'declassificationdate' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultcmyk' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultsettings' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'definition' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delimiter' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'densityaltitude' => 1,
	'densityaltitudeextended' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthhwheight' => 1,
	'depthhwwidth' => 1,
	'depthmapdata' => 1,
	'depthmapdata2' => 1,
	'depthmapheight' => 1,
	'depthmapimage' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'depthswheight' => 1,
	'depthswwidth' => 1,
	'derivedimageref' => 1,
	'desc' => 1,
	'descender' => 1,
	'descriptionurl' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecodename' => 1,
	'devicecontainer' => 1,
	'devicehardwarerevision' => 1,
	'deviceid' => 1,
	'devicemake' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'deviceorientation' => 1,
	'devicesettings' => 1,
	'devicesounds' => 1,
	'dex' => 1,
	'diagonalfieldofview' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'differentialpressure' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digestalgorithm' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'digitalzoomamount' => 1,
	'dimensions' => 1,
	'directionalatob0' => 1,
	'directionalatob1' => 1,
	'directionalatob2' => 1,
	'directionalatob3' => 1,
	'directionalbtoa0' => 1,
	'directionalbtoa1' => 1,
	'directionalbtoa2' => 1,
	'directionalbtoa3' => 1,
	'directionalbtod0' => 1,
	'directionalbtod1' => 1,
	'directionalbtod2' => 1,
	'directionalbtod3' => 1,
	'directionaldtob0' => 1,
	'directionaldtob1' => 1,
	'directionaldtob2' => 1,
	'directionaldtob3' => 1,
	'directorofphotography' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distance' => 1,
	'distancefromhome' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'dji-dbg' => 1,
	'dji_dtat' => 1,
	'djidebug' => 1,
	'djimetadata' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'docversion' => 1,
	'dof' => 1,
	'domain' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'droneinfo' => 1,
	'dronepitch' => 1,
	'dronequaternion' => 1,
	'droneroll' => 1,
	'droneyaw' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualfiles' => 1,
	'dualshotextra' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'durationsetting' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'dynamicranger128' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit4data' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'ef' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectleveloriginal' => 1,
	'effectstrength' => 1,
	'effectsvisible' => 1,
	'effecttype' => 1,
	'effectvalue' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electricalextendermagnification' => 1,
	'electronicimagestabilization' => 1,
	'electronicstabilizationon' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimage2' => 1,
	'embeddedimageclass' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagerectangle' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideo' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emergencysos' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endianness' => 1,
	'endmotionvideo' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'environmenttarget' => 1,
	'environmenttargetunicode' => 1,
	'envvardata' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'et' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'eventstarttime' => 1,
	'evstepinfo' => 1,
	'exceptionendtime' => 1,
	'exceptionstarttime' => 1,
	'exefilename' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimemax' => 1,
	'exposuretimemin' => 1,
	'exposuretimes' => 1,
	'exposuretype' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedalbumname' => 1,
	'extendedartistname' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedlanguagetag' => 1,
	'extendedstreamprops' => 1,
	'extendedtracktitle' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionid' => 1,
	'extensionitemid' => 1,
	'extensionitemname' => 1,
	'extensionitemvalue' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'extremeweathermode' => 1,
	'eyebrows' => 1,
	'eyeenlarge' => 1,
	'f-stop' => 1,
	'f_' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'faceslimming' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'fax' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fcc-id' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileguid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterindication' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterparametersbinary' => 1,
	'filterparameterscustomcustomdata' => 1,
	'filterparametersexportexportdata' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'filtertype' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finetune' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishedimage' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firmwareversion51' => 1,
	'firmwareversion56' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfo0300' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flightdegree' => 1,
	'flightspeed' => 1,
	'flipstatus' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'flirdata' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'flyingstate' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusframesize' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspointbrightness' => 1,
	'focuspointselectionspeed' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'follow-meanimation' => 1,
	'follow-memode' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'forcedsubtitletrack' => 1,
	'form' => 1,
	'formatid' => 1,
	'formatsdcard' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fps' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framebaseview' => 1,
	'framecenterelevation' => 1,
	'framecenterheightaboveellipsoid' => 1,
	'framecenterlatitude' => 1,
	'framecenterlongitude' => 1,
	'framedelay' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'frameview' => 1,
	'framinggriddisplay' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fuelremaining' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullangleofattack' => 1,
	'fullname' => 1,
	'fullpitchangle' => 1,
	'fullrollangle' => 1,
	'fullscreen' => 1,
	'fullsideslipangle' => 1,
	'fusion360fly' => 1,
	'fusionmode' => 1,
	'fusionypr' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gainmapimage' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gamutboundarydescription0' => 1,
	'gamutboundarydescription1' => 1,
	'gamutboundarydescription2' => 1,
	'gamutboundarydescription3' => 1,
	'gapless' => 1,
	'garmingps' => 1,
	'garminmodel' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gcamera' => 1,
	'gcontainer' => 1,
	'gcreations' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generalencapsulatedobject' => 1,
	'generallevelidc' => 1,
	'generalprofileidc' => 1,
	'generalprofilespace' => 1,
	'generaltierflag' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genericflagdata01' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genimageversion' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genprofilecompatibilityflags' => 1,
	'genr' => 1,
	'geo' => 1,
	'geob-data' => 1,
	'geob-desc' => 1,
	'geob-file' => 1,
	'geob-mime' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geolocationbearing' => 1,
	'geolocationcity' => 1,
	'geolocationcountry' => 1,
	'geolocationcountrycode' => 1,
	'geolocationdistance' => 1,
	'geolocationfeaturecode' => 1,
	'geolocationfeaturetype' => 1,
	'geolocationpopulation' => 1,
	'geolocationposition' => 1,
	'geolocationregion' => 1,
	'geolocationsubregion' => 1,
	'geolocationtimezone' => 1,
	'geolocationwarning' => 1,
	'geometricdistortionparams' => 1,
	'georegistrationlocalset' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbaldegree' => 1,
	'gimbalinfo' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'gkudata' => 1,
	'glamoursettings' => 1,
	'globalinfo' => 1,
	'globalpalette' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'google' => 1,
	'googlebot' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'goudarequesttext' => 1,
	'gpano' => 1,
	'gpmd_fmas' => 1,
	'gpmd_gopro' => 1,
	'gpmd_kingslim' => 1,
	'gpmd_rove' => 1,
	'gpmd_wolfbox' => 1,
	'gps' => 1,
	'gps360fly' => 1,
	'gpsaltituderaw' => 1,
	'gpsaltitudesystem' => 1,
	'gpsdata' => 1,
	'gpsdatalist' => 1,
	'gpsdatalist2' => 1,
	'gpsdatetimeraw' => 1,
	'gpsdestaltitude' => 1,
	'gpsframingaltitude' => 1,
	'gpsframinglatitude' => 1,
	'gpsframinglongitude' => 1,
	'gpshomelatitude' => 1,
	'gpshomelongitude' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpsinfo9' => 1,
	'gpslatitude2' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongitude2' => 1,
	'gpslongituderaw' => 1,
	'gpsmode' => 1,
	'gpspos' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpsstamp' => 1,
	'gpstargetaltitude' => 1,
	'gpstargetlatitude' => 1,
	'gpstargetlongitude' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocitydown' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'gravityvector' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'gridsize' => 1,
	'groundrange' => 1,
	'groupareac1' => 1,
	'groupcaption' => 1,
	'groupmutualexclusion' => 1,
	'groups' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guano' => 1,
	'gyro360fly' => 1,
	'gyromode' => 1,
	'gyroscope' => 1,
	'gyroscopeunknown' => 1,
	'gyroypr' => 1,
	'halftonedegree' => 1,
	'halftonelpi' => 1,
	'halftonelpiunit' => 1,
	'halftonemisc' => 1,
	'halftonescreen' => 1,
	'halftoneshape' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasselbladexif' => 1,
	'hasselbladrawimage' => 1,
	'hasselbladxml' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdgainmapinfo' => 1,
	'hdmibitdepth' => 1,
	'hdmiexternalrecorder' => 1,
	'hdmioutputhdr' => 1,
	'hdmioutputrange' => 1,
	'hdrgaincurve' => 1,
	'hdrgaincurvesize' => 1,
	'hdrgaininfo' => 1,
	'hdrgainmap' => 1,
	'hdrgm' => 1,
	'hdrimage' => 1,
	'hdrinfo' => 1,
	'hdrinfo2' => 1,
	'hdrinfoversion' => 1,
	'hdrl' => 1,
	'hdrpsoftware' => 1,
	'hdrtoninginfo' => 1,
	'hdrvideo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'headshrinking' => 1,
	'healthlogs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hevcconfigurationversion' => 1,
	'hiddendata' => 1,
	'hiddeninfo' => 1,
	'hiddenslides' => 1,
	'highbitdepth' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'highlightmarkers' => 1,
	'highnote' => 1,
	'highvelocity' => 1,
	'hindsightsettings' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintmaxoutputvalue' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizoncontrol' => 1,
	'horizontalfieldofview' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'hotspotx' => 1,
	'hotspoty' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huawei' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlapsdebuginfo' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'iad1' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iccprofilelocation' => 1,
	'icingdetected' => 1,
	'icondir' => 1,
	'iconenvdata' => 1,
	'iconfile' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3-2' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idlist' => 1,
	'idsbasevalue' => 1,
	'idstring' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagecoordinatesystem' => 1,
	'imagedatadiscard' => 1,
	'imagedatahash' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imagegeometry' => 1,
	'imageheader' => 1,
	'imageheightinches' => 1,
	'imagehorizonpixelpack' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagelocation' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imagename' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imagepixeloffset' => 1,
	'imagepixelstorage' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesampleformat' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestabilisation' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imagewidthinches' => 1,
	'imageworkstationmake' => 1,
	'imagingdata' => 1,
	'imdb' => 1,
	'imdb_id' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexbackground' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'indextransparent' => 1,
	'indicatedairspeed' => 1,
	'indications' => 1,
	'infirayfactory' => 1,
	'infirayisothermal' => 1,
	'infiraymixmode' => 1,
	'infirayopmode' => 1,
	'infiraypicture' => 1,
	'infiraysensor' => 1,
	'infirayversion' => 1,
	'info' => 1,
	'ingrreserved' => 1,
	'initialdelaysamples' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'initparamstext' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputheight' => 1,
	'inputorientation' => 1,
	'inputuniformity' => 1,
	'inputwidth' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'insta360' => 1,
	'insta360info' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'instruments' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'intervaloffset' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isaifilterreeditonly' => 1,
	'isapplyshapecorrection' => 1,
	'isartbokeh' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'isblending' => 1,
	'isbrightnessipe' => 1,
	'iscompleted' => 1,
	'iscontrastipe' => 1,
	'isdecoreeditonly' => 1,
	'isdeleted' => 1,
	'isexposureipe' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'ismotionvideomute' => 1,
	'isnetworkfeed' => 1,
	'isnewreeditonly' => 1,
	'isnotreedit' => 1,
	'isoautooffset' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isomax' => 1,
	'isomin' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'issaturationipe' => 1,
	'isscaleai' => 1,
	'istrimmotionvideo' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemdesignatorid' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'ixml' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpegimagelength' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jpgfromraw2' => 1,
	'jpginfooffset' => 1,
	'jplcartoifd' => 1,
	'jps' => 1,
	'jpscomment' => 1,
	'jpsflags' => 1,
	'jpslayout' => 1,
	'jpsseparation' => 1,
	'jpstype' => 1,
	'jsondata' => 1,
	'jsoninfo' => 1,
	'jsonmetadata' => 1,
	'jumbf' => 1,
	'jumbfbox' => 1,
	'jumbfdescr' => 1,
	'jumdid' => 1,
	'jumdlabel' => 1,
	'jumdsignature' => 1,
	'jumdtoggles' => 1,
	'jumdtype' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'jxlcodestream' => 1,
	'k1' => 1,
	'k2' => 1,
	'k3' => 1,
	'k4' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepexposurewithteleconverter' => 1,
	'keepuntil' => 1,
	'keepusersettings' => 1,
	'kelvinwb' => 1,
	'kenwooddata' => 1,
	'keyalgorithm' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'keyversion' => 1,
	'kf' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kilocalories' => 1,
	'kinds' => 1,
	'kj' => 1,
	'kk' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelcode' => 1,
	'labeledtext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'languages' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'laserprfcode' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'lawrating' => 1,
	'layerblendmodes' => 1,
	'layercolors' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layersections' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layervisible' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lccn' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leglonger' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfacing' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensprojection' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'levelinfok3iii' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseeclass' => 1,
	'licenseedir' => 1,
	'licenseinfourl' => 1,
	'licenseurl' => 1,
	'lightbalance' => 1,
	'lightingopt' => 1,
	'lightleveloriginal' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'ligogpsinfo' => 1,
	'ligojson' => 1,
	'limage' => 1,
	'limitaf-areamodeselautoanimals' => 1,
	'limitaf-areamodeselautopeople' => 1,
	'limitaf-areamodeseldynamic' => 1,
	'limitaf-areamodeselwidelanimals' => 1,
	'limitaf-areamodeselwidelpeople' => 1,
	'limitafareamodesel3d' => 1,
	'limitafareamodeseld105' => 1,
	'limitafareamodeseld25' => 1,
	'limitafareamodeseld49' => 1,
	'limitafareamodeseld9' => 1,
	'limitafareamodeselgroup' => 1,
	'limitafareamodeselgroupc1' => 1,
	'limitafareamodeselgroupc2' => 1,
	'limitreleasemodeselmirror-up' => 1,
	'limitreleasemodeselq' => 1,
	'limitreleasemodeseltimer' => 1,
	'limitselectableimagearea5to4' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'linecount' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedfilename' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkgoodput' => 1,
	'linkinfo' => 1,
	'linkquality' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'linux' => 1,
	'lipstick' => 1,
	'listtype' => 1,
	'lit' => 1,
	'livephotoinfo' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationinfo' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loggingmetadatatext' => 1,
	'loginfo' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopcount' => 1,
	'lotus' => 1,
	'lowlightaf' => 1,
	'lownote' => 1,
	'lowvelocity' => 1,
	'lr' => 1,
	'lslv' => 1,
	'lucasjunk' => 1,
	'lumaaverage' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'luminancetable' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'mag360fly' => 1,
	'magmode' => 1,
	'magneticfield' => 1,
	'magneticheading' => 1,
	'magneticvariation' => 1,
	'magnetometer' => 1,
	'magnetometerxyz' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotebyteorder' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotericohpentax2' => 1,
	'makernotericohpentax3' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mappingsignature' => 1,
	'mappingxcoefficients' => 1,
	'mappingxmode' => 1,
	'mappingycoefficients' => 1,
	'mappingymode' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'marl' => 1,
	'marlindataversion' => 1,
	'marlindictionary' => 1,
	'marlinheader' => 1,
	'marlinvalues' => 1,
	'masksubarea' => 1,
	'masteredby' => 1,
	'mastergainadjustment' => 1,
	'matrixcoefficients' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxanalogiso' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxcontentlightlevel' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxpicaveragelightlevel' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mccdata' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemaudiobitrate' => 1,
	'mditemaudiochannelcount' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcodecs' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentcreationdateranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemdurationseconds' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditeminterestingdateranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlastuseddate_ranking' => 1,
	'mditemlatitude' => 1,
	'mditemlensmodel' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemmediatypes' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemstreamable' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemtotalbitrate' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemuserdownloadeddate' => 1,
	'mditemuserdownloadeduserhandle' => 1,
	'mditemusersharedreceiveddate' => 1,
	'mditemusersharedreceivedrecipient' => 1,
	'mditemusersharedreceivedrecipienthandle' => 1,
	'mditemusersharedreceivedsender' => 1,
	'mditemusersharedreceivedsenderhandle' => 1,
	'mditemusersharedreceivedtransport' => 1,
	'mditemversion' => 1,
	'mditemvideobitrate' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measure' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementinputinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediabox' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediadataoffset' => 1,
	'mediadatasize' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'mediamode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediauniqueid' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'menuoffset' => 1,
	'menusettingsoffset' => 1,
	'menusettingsoffsetz7ii' => 1,
	'menusettingsoffsetz8v1' => 1,
	'menusettingsoffsetz8v2' => 1,
	'menusettingsoffsetz9' => 1,
	'menusettingsoffsetz9v3' => 1,
	'menusettingsoffsetz9v4' => 1,
	'menusettingsz8' => 1,
	'mergedimage' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metadataversion' => 1,
	'metaformat' => 1,
	'metaimagesize' => 1,
	'metarelation' => 1,
	'metasampledesc' => 1,
	'metatype' => 1,
	'metdata' => 1,
	'meter' => 1,
	'meterinfo' => 1,
	'meteringbutton' => 1,
	'meteringframecount' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'mett' => 1,
	'microphonewet' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midipitchfraction' => 1,
	'midisong' => 1,
	'midiunitynote' => 1,
	'mie' => 1,
	'miiscoreidentifier' => 1,
	'mileage' => 1,
	'mimeencoding' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'minspatialsegmentationidc' => 1,
	'mintransmissiontime' => 1,
	'missionid' => 1,
	'mixedby' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modelstamp' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modified' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monostrength' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'moresettingsoffset' => 1,
	'mosaicpattern' => 1,
	'mouthmodify' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviefragment' => 1,
	'moviefragmentheader' => 1,
	'moviefragmentsequence' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'moviehighlightdisplaypattern' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'moviewhitebalancesameasphoto' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'mtoa0' => 1,
	'mtob0' => 1,
	'mtob1' => 1,
	'mtob2' => 1,
	'mtob3' => 1,
	'mtos0' => 1,
	'mtos1' => 1,
	'mtos2' => 1,
	'mtos3' => 1,
	'multiexp' => 1,
	'multiexposure2' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiplexdefaultvalues' => 1,
	'multiplextypearray' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'mynextbase-paireddevicename' => 1,
	'mynextbase-pairing' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'nbcd' => 1,
	'ncc' => 1,
	'ndeversion' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'newlines' => 1,
	'nextbasemeta' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikonapp' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'nine' => 1,
	'nineedits' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'non-primarysourcetrack' => 1,
	'normallinetransfertiming' => 1,
	'noseslimming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlicenseplate' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numplanes' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numsampleloops' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'numtemporallayers' => 1,
	'objectcountrycodes' => 1,
	'objectcountrycodingmethod' => 1,
	'objectcountrycodingmethoddate' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectorientation' => 1,
	'objectsizeannounced' => 1,
	'observationdate' => 1,
	'observationdateend' => 1,
	'observationtime' => 1,
	'observationtimeend' => 1,
	'observer' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offset13' => 1,
	'offsetcornerlatitude1' => 1,
	'offsetcornerlatitude2' => 1,
	'offsetcornerlatitude3' => 1,
	'offsetcornerlatitude4' => 1,
	'offsetcornerlongitude1' => 1,
	'offsetcornerlongitude2' => 1,
	'offsetcornerlongitude3' => 1,
	'offsetcornerlongitude4' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'oleinfo' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'on1_settingsdata' => 1,
	'on1_settingsmetadatacreated' => 1,
	'on1_settingsmetadatamodified' => 1,
	'on1_settingsmetadataname' => 1,
	'on1_settingsmetadatapluginid' => 1,
	'on1_settingsmetadatatimestamp' => 1,
	'on1_settingsmetadatausage' => 1,
	'on1_settingsmetadatavisibletouser' => 1,
	'oneplus' => 1,
	'oneplustrailerlen' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationalmode' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'opticalvr' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationdatapresent' => 1,
	'orientationinfo' => 1,
	'orientationoffset' => 1,
	'orientoffset' => 1,
	'original' => 1,
	'originalalbum' => 1,
	'originaldate' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originalmedia' => 1,
	'originalmediatype' => 1,
	'originalmedium' => 1,
	'originalpath' => 1,
	'originalpathhashkey' => 1,
	'originalpayloadframecount' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originalyear' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'othermeta' => 1,
	'othername' => 1,
	'otheroffset' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputheight' => 1,
	'outputorientation' => 1,
	'outputresponse' => 1,
	'outputwidth' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parallelismtype' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalratingreason' => 1,
	'parkingmode' => 1,
	'parrotautomation' => 1,
	'parrotfollowme' => 1,
	'parrottimestamp' => 1,
	'parrotv1' => 1,
	'parrotv2' => 1,
	'parrotv3' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialjxlcodestream' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partoffset' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadframe' => 1,
	'payloadmetadatatext' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdbage' => 1,
	'pdbcreatedate' => 1,
	'pdbfilename' => 1,
	'pdbmodifydate' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'pdrversion' => 1,
	'peakbitrate' => 1,
	'peaklevelr128' => 1,
	'peaklevelsample' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'peg_info' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'perfmode' => 1,
	'performersortorder' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'phone' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'photoshopstream' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pilotingmode' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchrollyaw' => 1,
	'pittasoft' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'playbackflickdownrating' => 1,
	'playbackflickuprating' => 1,
	'playbackframerate' => 1,
	'playcounter' => 1,
	'playlist' => 1,
	'playlistdelay' => 1,
	'playlistindex' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'pointsize' => 1,
	'polynomialcoefficients' => 1,
	'polynomialpower' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraiteffectid' => 1,
	'portraiteffectidoriginal' => 1,
	'portraiteffectlevel' => 1,
	'portraiteffectvalue' => 1,
	'portraitexifrotation' => 1,
	'portraitlightlevel' => 1,
	'portraitmatrix' => 1,
	'portraitoffset' => 1,
	'portraitrefocusx' => 1,
	'portraitrefocusy' => 1,
	'portraittonescaletable' => 1,
	'portraittouchx' => 1,
	'portraittouchy' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'powerprofile' => 1,
	'pragma' => 1,
	'predominanthue' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'prefersubselectorcenter' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewjxl' => 1,
	'previewjxllength' => 1,
	'previewjxlstart' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryfileguid' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsbleedwidth' => 1,
	'printflagsbleedwidthscale' => 1,
	'printflagscrop' => 1,
	'printflagsinfo' => 1,
	'printflagsversion' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingnotes' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productioncopyright' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversionnumber' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesequenceinfo' => 1,
	'profilesize' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projectidcode' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protocol' => 1,
	'protune' => 1,
	'protuneisomode' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'ptrh' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasecurrency' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purchaseitem' => 1,
	'purchaseowner' => 1,
	'purchaseprice' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'qualcommdualcamera' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'quietshuttershootingspeed' => 1,
	'quoting' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafcompression' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rangeimagelocalset' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawburstmoderoll' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawdevsubifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimageaspectratio' => 1,
	'rawimagecroppedsize' => 1,
	'rawimagecroptopleft' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagenumber' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawvaluerangemax' => 1,
	'rawvaluerangemin' => 1,
	'rawzoomactive' => 1,
	'rawzoomsize' => 1,
	'rawzoomtopleft' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'rearcontropaneldisplay' => 1,
	'recallshootfuncaf-on' => 1,
	'recallshootfuncafareamode' => 1,
	'recallshootfuncaperture' => 1,
	'recallshootfuncexposurecomp' => 1,
	'recallshootfuncexposuremode' => 1,
	'recallshootfuncfocustracking' => 1,
	'recallshootfunciso' => 1,
	'recallshootfuncmeteringmode' => 1,
	'recallshootfuncshutterspeed' => 1,
	'recallshootfuncwhitebalance' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordinghistory' => 1,
	'recordinglocation' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'records' => 1,
	'recordsv2' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'rectifacetext' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reeditdata' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencename' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectedtemperature' => 1,
	'reflection' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refocusxoriginal' => 1,
	'refocusyoriginal' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relatedresources' => 1,
	'relationship' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'releasinginstructions' => 1,
	'remasterinfo' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'remixedby' => 1,
	'remotefuncbutton' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaingain' => 1,
	'replaygainpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replaytrackgain' => 1,
	'replaytrackpeak' => 1,
	'replayvolumelevel' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeframeloc' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resize' => 1,
	'resolutioninfo' => 1,
	'resolutionxlengthunit' => 1,
	'resolutionxunit' => 1,
	'resolutionylengthunit' => 1,
	'resolutionyunit' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'reversingcamera' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohinfo' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrdta' => 1,
	'ricohrdtb' => 1,
	'ricohrdtc' => 1,
	'ricohrdtg' => 1,
	'ricohrdtl' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'roamed' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rootnote' => 1,
	'rot360fly' => 1,
	'rotationangle' => 1,
	'rotationinfooffset' => 1,
	'rotationxyz' => 1,
	'rotmode' => 1,
	'roundtripversion' => 1,
	'rovegps' => 1,
	'rowcount' => 1,
	'rowinterleavefactor' => 1,
	'rsrc' => 1,
	'rtmd' => 1,
	'rtos' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	'rvtlocalset' => 1,
	's2n' => 1,
	'sample' => 1,
	'sampleblacksequence' => 1,
	'samplecount' => 1,
	'sampledatetime' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'sampleperiod' => 1,
	'sampler' => 1,
	'samplerate2' => 1,
	'samplerdata' => 1,
	'samplerdatalen' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungcaptureinfo' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungmodel' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsungtrailer' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'sarmotionimagerydata' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'savefocus' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'sceneclassification' => 1,
	'scenecolorimetryestimates' => 1,
	'sceneilluminance' => 1,
	'schedulecapture' => 1,
	'schedulecapturetime' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screendimming' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenplayby' => 1,
	'screensaver' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'script' => 1,
	'scriptcommand' => 1,
	'sdc' => 1,
	'sdcardclass' => 1,
	'sdcardformat' => 1,
	'sdcardmanfdate' => 1,
	'sdcardmanfid' => 1,
	'sdcardmodelno' => 1,
	'sdcardoemid' => 1,
	'sdcardserialno' => 1,
	'sdcardsize' => 1,
	'sdcardtype' => 1,
	'sdcardusedspace' => 1,
	'sdcc-flp' => 1,
	'sealcomment' => 1,
	'sealversion' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondcam' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'securitylocalmetadataset' => 1,
	'securitysci-shiinformation' => 1,
	'securityversion' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'segheight' => 1,
	'segmentlocalset' => 1,
	'segwidth' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'semanticinstanceid' => 1,
	'semanticname' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensitivityvalue' => 1,
	'sensorbottomborder' => 1,
	'sensordata' => 1,
	'sensordefects' => 1,
	'sensorellipsoidheight' => 1,
	'sensorellipsoidheightextended' => 1,
	'sensorfieldofviewname' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorname' => 1,
	'sensorreadouttime' => 1,
	'sensorrelativeazimuthangle' => 1,
	'sensorrelativeelevationangle' => 1,
	'sensorrelativerollangle' => 1,
	'sensorrightborder' => 1,
	'sensorvelocityeast' => 1,
	'sensorvelocitynorth' => 1,
	'sepversion' => 1,
	'seqcount' => 1,
	'seqfinal' => 1,
	'seqframeinfo' => 1,
	'seqid' => 1,
	'seqindex' => 1,
	'seqlevelidx0' => 1,
	'seqprofile' => 1,
	'seqtier0' => 1,
	'seqtype' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'sequenceoffset' => 1,
	'serialinfo' => 1,
	'serialnumber2' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'settingsoffset' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod6' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod7500' => 1,
	'shotinfod780' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'shotinfoz6iii' => 1,
	'shotinfoz7ii' => 1,
	'shotinfoz8' => 1,
	'shotinfoz9' => 1,
	'shotlogdatatext' => 1,
	'shotparamstext' => 1,
	'showcommand' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutterangle' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sidelightstrength' => 1,
	'sideslipangle' => 1,
	'sigma' => 1,
	'sigmaexif' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureformat' => 1,
	'signaturelength' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'singleshotdepthmap' => 1,
	'singleshotdepthmaptiff' => 1,
	'singleshotmeta' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'skipinfo' => 1,
	'slantrange' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'slowmotionrate' => 1,
	'slowmotionregions' => 1,
	'slowmotionregionsdurationepoch' => 1,
	'slowmotionregionsdurationflags' => 1,
	'slowmotionregionsdurationtimescale' => 1,
	'slowmotionregionsdurationvalue' => 1,
	'slowmotionregionsstarttimeepoch' => 1,
	'slowmotionregionsstarttimeflags' => 1,
	'slowmotionregionsstarttimescale' => 1,
	'slowmotionregionsstarttimevalue' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'smoother' => 1,
	'smpteformat' => 1,
	'smpteoffset' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwaredate' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sony_0x9416' => 1,
	'sonyfnumber2' => 1,
	'sonyhiddendata' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'sortwith' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialaudio' => 1,
	'spatialaudioversion' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'spectralviewingconditions' => 1,
	'spectralwhitepoint' => 1,
	'speed' => 1,
	'speedrampsetting' => 1,
	'speedstamp' => 1,
	'speedunits' => 1,
	'sphericalvideo' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spinstrength' => 1,
	'spothalftone' => 1,
	'spotmeter' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'standardtocustompcc' => 1,
	'standbymonitorofftime' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startmotionvideo' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'staticmetadatatext' => 1,
	'staticpressure' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stillimagetime' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streamid' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdialframeadvance' => 1,
	'subdialframeadvancerating0' => 1,
	'subdialframeadvancerating1' => 1,
	'subdialframeadvancerating2' => 1,
	'subdialframeadvancerating3' => 1,
	'subdialframeadvancerating4' => 1,
	'subdialframeadvancerating5' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'subtitletrack' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'summarytext' => 1,
	'surfacemap' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncronizedtrack' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'synopsis' => 1,
	'systeminfo' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9050c' => 1,
	'tag9050d' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag9406b' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tailnumber' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targeterrorestimatece90' => 1,
	'targeterrorestimatele90' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetlocationcovariancematrix' => 1,
	'targetlocationelevation' => 1,
	'targetlocationlatitude' => 1,
	'targetlocationlongitude' => 1,
	'targettrackgateheight' => 1,
	'targettrackgatewidth' => 1,
	'targetwidth' => 1,
	'targetwidthextended' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'teethwhitening' => 1,
	'telephonenumber' => 1,
	'telescope' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporalidnested' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'thanksto' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thermalcalibration' => 1,
	'thermaldata' => 1,
	'thermalparams' => 1,
	'thermalparams2' => 1,
	'thermalparams3' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailartist' => 1,
	'thumbnailbitspersample' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcolordepth' => 1,
	'thumbnailcompressedsize' => 1,
	'thumbnailcompression' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailcopyright' => 1,
	'thumbnaildata' => 1,
	'thumbnaildatetime' => 1,
	'thumbnaildescription' => 1,
	'thumbnailequipmake' => 1,
	'thumbnailequipmodel' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailhash' => 1,
	'thumbnailimageheight' => 1,
	'thumbnailimagewidth' => 1,
	'thumbnailorientation' => 1,
	'thumbnailphotometricinterp' => 1,
	'thumbnailplanarconfig' => 1,
	'thumbnailplanes' => 1,
	'thumbnailprimarychromaticities' => 1,
	'thumbnailrawbytes' => 1,
	'thumbnailref' => 1,
	'thumbnailrefblackwhite' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailresolutionunit' => 1,
	'thumbnailresolutionx' => 1,
	'thumbnailresolutiony' => 1,
	'thumbnailrowsperstrip' => 1,
	'thumbnailsamplesperpixel' => 1,
	'thumbnailsoftware' => 1,
	'thumbnailstripbytecounts' => 1,
	'thumbnailstripoffsets' => 1,
	'thumbnailtiff' => 1,
	'thumbnailtransferfunction' => 1,
	'thumbnailurl' => 1,
	'thumbnailwhitepoint' => 1,
	'thumbnailycbcrcoefficients' => 1,
	'thumbnailycbcrpositioning' => 1,
	'thumbnailycbcrsubsampling' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'time1' => 1,
	'time2' => 1,
	'timeanddate' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timecodetrack' => 1,
	'timeinfo' => 1,
	'timelapse' => 1,
	'timelineinfo' => 1,
	'timelogtext' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamplist' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'timezonedst' => 1,
	'tipl' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'tmdb' => 1,
	'tmdb_id' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonevalue' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalparts' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'touchxoriginal' => 1,
	'touchyoriginal' => 1,
	'toycamerafilter' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transcripttrack' => 1,
	'transfercharacteristic' => 1,
	'transfercharacteristics' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentcolor' => 1,
	'transparentindex' => 1,
	'transportstreamid' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'trim' => 1,
	'trueairspeed' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'tuning' => 1,
	'tvdb' => 1,
	'twelvebit' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'uas_lsversionnumber' => 1,
	'uasdatalink' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'umid' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uniformresourcename' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'uniqueidentifier' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_cndb' => 1,
	'unknown_grpl' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknownexif' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unsharpdata' => 1,
	'unshiftednote' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'unusedloggingmetadata' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'usertext' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-c2paclaimsignature' => 1,
	'uuid-canon' => 1,
	'uuid-canon2' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-signature' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendorclass' => 1,
	'vendordir' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalaf-onbutton' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalfieldofview' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalspeed' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoeditedtimezone' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videofullrangeflag' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videokeys' => 1,
	'videolength' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotimestamp' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignetteinfo' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'vintagestrength' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'visualsampledesc' => 1,
	'vivo' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmtidataset' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumelevelr128' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarkremoved' => 1,
	'watermarkremovedoriginal' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelscustom' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wbsettings' => 1,
	'wbsettings2' => 1,
	'wbtemperature' => 1,
	'wcsprofiles' => 1,
	'weaponfired' => 1,
	'weaponload' => 1,
	'webp_flags' => 1,
	'webpage' => 1,
	'weight' => 1,
	'what3words' => 1,
	'whatsnew' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitening' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wi-fimacaddress' => 1,
	'wi-fipassword' => 1,
	'wi-fissid' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'wifirssi' => 1,
	'winddirection' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'windprocessing' => 1,
	'windspeed' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'woffversion' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wpgversion' => 1,
	'wrapmodes' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrapplemaildatereceived' => 1,
	'xattrapplemaildatesent' => 1,
	'xattrapplemailisremoteattachment' => 1,
	'xattrfinderinfo' => 1,
	'xattrlastuseddate' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xidiri' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmlpackets' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpdsa' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zifannotations' => 1,
	'zifmetadata' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilecomment' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zisrawversion' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zoomscalenormalization' => 1,
	'zoomstrength' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'gpslatitude' => 'Image::ExifTool::GPS',
	'gpslongitude' => 'Image::ExifTool::GPS',
	'gpsposition' => 'Image::ExifTool::Exif',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names to lookup corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level structure
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                my $lcFlat = $$newInfo{FlatName} ? lc($$newInfo{FlatName}) : $lcTag;
                AddFields($tagTablePtr, $tagID, $lcFlat, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        no strict 'refs';
                        $reload = 1 if &$writeProc();
                    }
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2025, Phil Harvey (philharvey66 at gmail.com)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
