<?php
/* Driver template for the PHP_PHP_Parser_CorerGenerator parser generator. (PHP port of LEMON)
*/

/**
 * This can be used to store both the string representation of
 * a token, and any useful meta-data associated with the token.
 *
 * meta-data should be stored as an array
 */
class PHP_Parser_CoreyyToken implements ArrayAccess
{
    public $string = '';
    public $metadata = array();

    function __construct($s, $m = array())
    {
        if ($s instanceof PHP_Parser_CoreyyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof PHP_Parser_CoreyyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    function __toString()
    {
        return $this->string;
    }

    function offsetExists($offset)
    {
        return isset($this->metadata[$offset]);
    }

    function offsetGet($offset)
    {
        return $this->metadata[$offset];
    }

    function offsetSet($offset, $value)
    {
        if ($offset === null) {
            if (isset($value[0])) {
                $x = ($value instanceof PHP_Parser_CoreyyToken) ?
                    $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);
                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof PHP_Parser_CoreyyToken) {
            if ($value->metadata) {
                $this->metadata[$offset] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[$offset] = $value;
        }
    }

    function offsetUnset($offset)
    {
        unset($this->metadata[$offset]);
    }
}

/** The following structure represents a single element of the
 * parser's stack.  Information stored includes:
 *
 *   +  The state number for the parser at this level of the stack.
 *
 *   +  The value of the token stored at this level of the stack.
 *      (In other words, the "major" token.)
 *
 *   +  The semantic value stored at this level of the stack.  This is
 *      the information used by the action routines in the grammar.
 *      It is sometimes called the "minor" token.
 */
class PHP_Parser_CoreyyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};

// code external to the class is included here

// declare_class is output here
#line 2 "Core.y"
class PHP_Parser_Core#line 102 "Core.php"
{
/* First off, code is included which follows the "include_class" declaration
** in the input file. */
#line 21 "Core.y"

    static public $transTable = array();
    public $lex;
    public $functions = array();
    public $classes = array();
    public $interfaces = array();
    public $includes = array();
    public $globals = array();
    

    function __construct($lex)
    {
        $this->lex = $lex;
        if (!count(self::$transTable)) {
            $start = 240; // start nice and low to be sure
            while (token_name($start) == 'UNKNOWN') {
                $start++;
            }
            $hash = array_flip(self::$yyTokenName);
            $map =
                array(
                    ord(',') => self::COMMA,
                    ord('=') => self::EQUALS,
                    ord('?') => self::QUESTION,
                    ord(':') => self::COLON,
                    ord('|') => self::BAR,
                    ord('^') => self::CARAT,
                    ord('&') => self::AMPERSAND,
                    ord('<') => self::LESSTHAN,
                    ord('>') => self::GREATERTHAN,
                    ord('+') => self::PLUS,
                    ord('-') => self::MINUS,
                    ord('.') => self::DOT,
                    ord('*') => self::TIMES,
                    ord('/') => self::DIVIDE,
                    ord('%') => self::PERCENT,
                    ord('!') => self::EXCLAM,
                    ord('~') => self::TILDE,
                    ord('@') => self::AT,
                    ord('[') => self::LBRACKET,
                    ord('(') => self::LPAREN,
                    ord(')') => self::RPAREN,
                    ord(';') => self::SEMI,
                    ord('{') => self::LCURLY,
                    ord('}') => self::RCURLY,
                    ord('`') => self::BACKQUOTE,
                    ord('$') => self::DOLLAR,
                    ord(']') => self::RBRACKET,
                    ord('"') => self::DOUBLEQUOTE,
                    ord("'") => self::SINGLEQUOTE,
                );
            for ($i = $start; $i < self::YYERRORSYMBOL + $start; $i++) {
                $lt = token_name($i);
                $lt = ($lt == 'T_DOUBLE_COLON') ?  'T_PAAMAYIM_NEKUDOTAYIM' : $lt;
//                echo "$lt has hash? ".$hash[$lt]."\n";
                if (!isset($hash[$lt])) {
                    continue;
                }
                
                //echo "compare $lt with {$tokens[$i]}\n";
                $map[$i] = $hash[$lt];
            }
            //print_r($map);
            // set the map to false if nothing in there.
            self::$transTable = $map;
        }
    }

    public $data;
#line 177 "Core.php"

/* Next is all token values, as class constants
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
    const T_INCLUDE                      =  1;
    const T_INCLUDE_ONCE                 =  2;
    const T_EVAL                         =  3;
    const T_REQUIRE                      =  4;
    const T_REQUIRE_ONCE                 =  5;
    const COMMA                          =  6;
    const T_LOGICAL_OR                   =  7;
    const T_LOGICAL_XOR                  =  8;
    const T_LOGICAL_AND                  =  9;
    const T_PRINT                        = 10;
    const EQUALS                         = 11;
    const T_PLUS_EQUAL                   = 12;
    const T_MINUS_EQUAL                  = 13;
    const T_MUL_EQUAL                    = 14;
    const T_DIV_EQUAL                    = 15;
    const T_CONCAT_EQUAL                 = 16;
    const T_MOD_EQUAL                    = 17;
    const T_AND_EQUAL                    = 18;
    const T_OR_EQUAL                     = 19;
    const T_XOR_EQUAL                    = 20;
    const T_SL_EQUAL                     = 21;
    const T_SR_EQUAL                     = 22;
    const QUESTION                       = 23;
    const COLON                          = 24;
    const T_BOOLEAN_OR                   = 25;
    const T_BOOLEAN_AND                  = 26;
    const BAR                            = 27;
    const CARAT                          = 28;
    const AMPERSAND                      = 29;
    const T_IS_EQUAL                     = 30;
    const T_IS_NOT_EQUAL                 = 31;
    const T_IS_IDENTICAL                 = 32;
    const T_IS_NOT_IDENTICAL             = 33;
    const LESSTHAN                       = 34;
    const T_IS_SMALLER_OR_EQUAL          = 35;
    const GREATERTHAN                    = 36;
    const T_IS_GREATER_OR_EQUAL          = 37;
    const T_SL                           = 38;
    const T_SR                           = 39;
    const PLUS                           = 40;
    const MINUS                          = 41;
    const DOT                            = 42;
    const TIMES                          = 43;
    const DIVIDE                         = 44;
    const PERCENT                        = 45;
    const EXCLAM                         = 46;
    const T_INSTANCEOF                   = 47;
    const TILDE                          = 48;
    const T_INC                          = 49;
    const T_DEC                          = 50;
    const T_INT_CAST                     = 51;
    const T_DOUBLE_CAST                  = 52;
    const T_STRING_CAST                  = 53;
    const T_UNICODE_CAST                 = 54;
    const T_BINARY_CAST                  = 55;
    const T_ARRAY_CAST                   = 56;
    const T_OBJECT_CAST                  = 57;
    const T_BOOL_CAST                    = 58;
    const T_UNSET_CAST                   = 59;
    const AT                             = 60;
    const LBRACKET                       = 61;
    const T_NEW                          = 62;
    const T_CLONE                        = 63;
    const T_ELSEIF                       = 64;
    const T_ELSE                         = 65;
    const T_ENDIF                        = 66;
    const T_STATIC                       = 67;
    const T_ABSTRACT                     = 68;
    const T_FINAL                        = 69;
    const T_PRIVATE                      = 70;
    const T_PROTECTED                    = 71;
    const T_PUBLIC                       = 72;
    const T_HALT_COMPILER                = 73;
    const LPAREN                         = 74;
    const RPAREN                         = 75;
    const SEMI                           = 76;
    const LCURLY                         = 77;
    const RCURLY                         = 78;
    const T_IF                           = 79;
    const T_WHILE                        = 80;
    const T_DO                           = 81;
    const T_FOR                          = 82;
    const T_SWITCH                       = 83;
    const T_BREAK                        = 84;
    const T_CONTINUE                     = 85;
    const T_RETURN                       = 86;
    const T_GLOBAL                       = 87;
    const T_ECHO                         = 88;
    const T_INLINE_HTML                  = 89;
    const T_USE                          = 90;
    const T_UNSET                        = 91;
    const T_FOREACH                      = 92;
    const T_AS                           = 93;
    const T_DECLARE                      = 94;
    const T_TRY                          = 95;
    const T_CATCH                        = 96;
    const T_VARIABLE                     = 97;
    const T_THROW                        = 98;
    const T_FUNCTION                     = 99;
    const T_STRING                       = 100;
    const T_CLASS                        = 101;
    const T_EXTENDS                      = 102;
    const T_INTERFACE                    = 103;
    const T_IMPLEMENTS                   = 104;
    const T_LIST                         = 105;
    const T_EXIT                         = 106;
    const BACKQUOTE                      = 107;
    const T_ARRAY                        = 108;
    const T_LNUMBER                      = 109;
    const T_DNUMBER                      = 110;
    const T_CONSTANT_ENCAPSED_STRING     = 111;
    const T_LINE                         = 112;
    const T_FILE                         = 113;
    const T_CLASS_C                      = 114;
    const T_METHOD_C                     = 115;
    const T_FUNC_C                       = 116;
    const T_DOUBLE_ARROW                 = 117;
    const T_PAAMAYIM_NEKUDOTAYIM         = 118;
    const T_ENDFOR                       = 119;
    const T_ENDFOREACH                   = 120;
    const T_ENDDECLARE                   = 121;
    const T_ENDSWITCH                    = 122;
    const T_CASE                         = 123;
    const T_DEFAULT                      = 124;
    const T_ENDWHILE                     = 125;
    const DOLLAR                         = 126;
    const T_VAR                          = 127;
    const T_CONST                        = 128;
    const T_OBJECT_OPERATOR              = 129;
    const RBRACKET                       = 130;
    const T_NUM_STRING                   = 131;
    const T_ENCAPSED_AND_WHITESPACE      = 132;
    const T_CHARACTER                    = 133;
    const T_BAD_CHARACTER                = 134;
    const T_DOLLAR_OPEN_CURLY_BRACES     = 135;
    const T_STRING_VARNAME               = 136;
    const T_CURLY_OPEN                   = 137;
    const T_ISSET                        = 138;
    const T_EMPTY                        = 139;
    const DOUBLEQUOTE                    = 140;
    const SINGLEQUOTE                    = 141;
    const T_START_HEREDOC                = 142;
    const T_END_HEREDOC                  = 143;
    const YY_NO_ACTION = 1068;
    const YY_ACCEPT_ACTION = 1067;
    const YY_ERROR_ACTION = 1066;

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < self::YYNSTATE                              Shift N.  That is,
**                                                        push the lookahead
**                                                        token onto the stack
**                                                        and goto state N.
**
**   self::YYNSTATE <= N < self::YYNSTATE+self::YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == self::YYNSTATE+self::YYNRULE                    A syntax error has occurred.
**
**   N == self::YYNSTATE+self::YYNRULE+1                  The parser accepts its
**                                                        input. (and concludes parsing)
**
**   N == self::YYNSTATE+self::YYNRULE+2                  No such action.  Denotes unused
**                                                        slots in the yy_action[] table.
**
** The action table is constructed as a single large static array $yy_action.
** Given state S and lookahead X, the action is computed as
**
**      self::$yy_action[self::$yy_shift_ofst[S] + X ]
**
** If the index value self::$yy_shift_ofst[S]+X is out of range or if the value
** self::$yy_lookahead[self::$yy_shift_ofst[S]+X] is not equal to X or if
** self::$yy_shift_ofst[S] is equal to self::YY_SHIFT_USE_DFLT, it means that
** the action is not in the table and that self::$yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the static $yy_reduce_ofst array is used in place of
** the static $yy_shift_ofst array and self::YY_REDUCE_USE_DFLT is used in place of
** self::YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  self::$yy_action        A single table containing all actions.
**  self::$yy_lookahead     A table containing the lookahead for each entry in
**                          yy_action.  Used to detect hash collisions.
**  self::$yy_shift_ofst    For each state, the offset into self::$yy_action for
**                          shifting terminals.
**  self::$yy_reduce_ofst   For each state, the offset into self::$yy_action for
**                          shifting non-terminals after a reduce.
**  self::$yy_default       Default action for each state.
*/
    const YY_SZ_ACTTAB = 12756;
static public $yy_action = array(
 /*     0 */   551,  586,  397,  528,  683,  400,   65,  201,   54,   63,
 /*    10 */   105,  101,  119,  113,  110,   58,   61,   53,   57,   60,
 /*    20 */    62,   48,   49,   67,   55,  115,  112,  116,  122,  120,
 /*    30 */   123,  561,  150,  531,  531,  531,  531,  531,  531,   79,
 /*    40 */    78,   29,  642,  579,  485,   77,  633,   81,  133,  138,
 /*    50 */    86,   85,   84,   38,   68,   76,   75,   66,   64,   69,
 /*    60 */   477,  148,  106,  673,  131,  936,  214,  441,  442,   97,
 /*    70 */   898,  673,  368,   82,   28,  598,  245,  697,  398,  458,
 /*    80 */    23,  468,  454,   46,   47,   40,  184,   36,  631,  199,
 /*    90 */   376,  380,   31,  452,  378,  673,  561,  124,  699,  344,
 /*   100 */   535,  145,  506,  673,  406,  227,  235,  565,  545,  545,
 /*   110 */   545,  545,  545,  545,  545,  545,  337,  551,  586,  397,
 /*   120 */   528,  683,  540,  137,  580,  393,   63,  115,  112,  116,
 /*   130 */   122,  120,  123,  682,  150,  702, 1037,  427,  373,  242,
 /*   140 */   240,  238,   60,   62,   48,   49,   67,   55,  115,  112,
 /*   150 */   116,  122,  120,  123,   52,  150,   79,   78,  350,  642,
 /*   160 */   667,  485,   77,  633,   81,  133,  138,   86,   85,   84,
 /*   170 */   670,   68,   76,   75,   66,   64,   69,  463,  148,  106,
 /*   180 */   590,  362,  183,  214,  441,  442,  204,  540,  159,  368,
 /*   190 */    82,  561,  598,  245,  420,  398,  458,   23,  468,  454,
 /*   200 */    46,   47,   40,  184,   36,  631,  199,  376,  380,  604,
 /*   210 */   452,  378,  128,  561,  124,  699,  344,  535,  404,  506,
 /*   220 */   393,  406,  227,  235,  565,  545,  545,  545,  545,  545,
 /*   230 */   545,  545,  545,  175,  551,  586,  397,  528,  683,  213,
 /*   240 */   449,  417,  393,   63,  122,  120,  123,  624,  150,  642,
 /*   250 */   678,  485,  702,  633,  427,  373,  242,  240,  238,  507,
 /*   260 */   489,  362,  183,  533,  362,  183,  131,  540,  426,  341,
 /*   270 */   540,  353,  502,   79,   78,  451,  642,  636,  485,   77,
 /*   280 */   633,   81,  133,  138,   86,   85,   84,   21,   68,   76,
 /*   290 */    75,   66,   64,   69,  161,  148,  106,  399,   65,  201,
 /*   300 */   214,  441,  442,  426,  341,  700,  368,   82,  561,  598,
 /*   310 */   245,  420,  398,  458,   23,  468,  454,   46,   47,   40,
 /*   320 */   184,   36,  631,  199,  376,  380,  914,  452,  378,  627,
 /*   330 */   561,  124,  699,  344,  535,  423,  506,  393,  406,  227,
 /*   340 */   235,  565,  545,  545,  545,  545,  545,  545,  545,  545,
 /*   350 */    65,  201,  408,   59,  551,  586,  397,  528,  683,  393,
 /*   360 */   642,  652,  485,   63,  633,   43,  642,  671,  485,  702,
 /*   370 */   633,  427,  373,  242,  240,  238,  225, 1067,   14,  236,
 /*   380 */   533,  362,  183,  533,  362,  183,  142,  540,  353,  502,
 /*   390 */   540,  353,  502,   79,   78,  914,  642,  630,  485,   77,
 /*   400 */   633,   81,  133,  138,   86,   85,   84,   37,   68,   76,
 /*   410 */    75,   66,   64,   69,  578,  148,  106,  617,  215,  504,
 /*   420 */   214,  441,  442,   51,  508,  520,  368,   82,  561,  598,
 /*   430 */   245,  498,  398,  458,   23,  468,  454,   46,   47,   40,
 /*   440 */   184,   36,  631,  199,  376,  380,  911,  452,  378,  428,
 /*   450 */   561,  124,  699,  344,  535,  389,  506,  393,  406,  227,
 /*   460 */   235,  565,  545,  545,  545,  545,  545,  545,  545,  545,
 /*   470 */   195,  551,  586,  397,  528,  683,  564,  334,  575,  393,
 /*   480 */    63,  711,  642,  366,  485,  480,  633,  492,  527,  702,
 /*   490 */   585,  427,  373,  242,  240,  238,  642,  659,  485,  155,
 /*   500 */   633,  228,   87,  354,  443,  533,  362,  183,   26,  540,
 /*   510 */    79,   78,  540,  353,  502,  911,   77,  394,   81,  133,
 /*   520 */   138,   86,   85,   84,  217,   68,   76,   75,   66,   64,
 /*   530 */    69,  375,  148,  106,  601,   65,  201,  214,  441,  442,
 /*   540 */   610,  593,  167,  368,   82,  487,  598,  245,  374,  398,
 /*   550 */   458,   23,  468,  454,   46,   47,   40,  184,   36,  631,
 /*   560 */   199,  376,  380,  130,  452,  378,  111,  561,  124,  699,
 /*   570 */   344,  535,  626,  506,  169,  406,  227,  235,  565,  545,
 /*   580 */   545,  545,  545,  545,  545,  545,  545,  567,  551,  586,
 /*   590 */   397,  528,  683,  593,  663,  482,  393,   63,  482,  642,
 /*   600 */   637,  485,  537,  633,  402,   24,  702,  114,  427,  373,
 /*   610 */   242,  240,  238,  411,  413,  249,  704,  185,  246,  342,
 /*   620 */   392,  218,  555,  193,  532,  248,  553,   79,   78,  482,
 /*   630 */   642,  478,  485,   77,  633,   81,  133,  138,   86,   85,
 /*   640 */    84,  352,   68,   76,   75,   66,   64,   69,  431,  148,
 /*   650 */   106,  448,  514,  241,  214,  441,  442,  651,  200,  126,
 /*   660 */   368,   82,  546,  598,  245,  707,  398,  458,   23,  468,
 /*   670 */   454,   46,   47,   40,  184,   36,  631,  199,  376,  380,
 /*   680 */   209,  452,  378,  349,  561,  124,  699,  344,  535,  540,
 /*   690 */   506,  549,  406,  227,  235,  565,  545,  545,  545,  545,
 /*   700 */   545,  545,  545,  545,  527,  551,  586,  397,  528,  683,
 /*   710 */   686,  446,   92,  393,   63,  146,   71,  642,  518,  485,
 /*   720 */   439,  633,   37,  702,   91,  427,  373,  242,  240,  238,
 /*   730 */   642,  713,  485,   37,  633,  966,  561,  202,   51,  501,
 /*   740 */   561,  170,  403,  420,   79,   78,  967,  168,  491,   51,
 /*   750 */    77,  219,   81,  133,  138,   86,   85,   84,  433,   68,
 /*   760 */    76,   75,   66,   64,   69,  393,  148,  106,  415,  393,
 /*   770 */   176,  214,  441,  442,  150,  153,  437,  368,   82,  447,
 /*   780 */   598,  245,  180,  398,  458,   23,  468,  454,   46,   47,
 /*   790 */    40,  184,   36,  631,  199,  376,  380,  134,  452,  378,
 /*   800 */   206,  561,  124,  699,  344,  535,  162,  506,  171,  406,
 /*   810 */   227,  235,  565,  545,  545,  545,  545,  545,  545,  545,
 /*   820 */   545,  685,  551,  586,  397,  528,  683,  230,  231,  561,
 /*   830 */   393,   63,  473,   83,  642,  664,  485,  941,  633,  222,
 /*   840 */   702,  164,  427,  373,  242,  240,  238,  642,  529,  485,
 /*   850 */   198,  633,  424,  561,  418,   31,  420,  561,  393,  542,
 /*   860 */   396,   79,   78,  560,  642,  635,  485,   77,  633,   81,
 /*   870 */   133,  138,   86,   85,   84,  494,   68,   76,   75,   66,
 /*   880 */    64,   69,  393,  148,  106,  419,  393,  179,  214,  441,
 /*   890 */   442,  165,   98,  497,  368,   82,  561,  598,  245,  486,
 /*   900 */   398,  458,   23,  468,  454,   46,   47,   40,  184,   36,
 /*   910 */   631,  199,  376,  380,  576,  452,  378,   99,  561,  124,
 /*   920 */   699,  344,  535,   74,  506,  393,  406,  227,  235,  565,
 /*   930 */   545,  545,  545,  545,  545,  545,  545,  545,  369,  642,
 /*   940 */   577,  485,  422,  633,  391,  147,  621,  393,  648,  551,
 /*   950 */   586,  397,  528,  683,  689,   35,  129,  702,   63,  427,
 /*   960 */   373,  242,  240,  238,  101,  119,  113,  110,   58,   61,
 /*   970 */    53,   57,   60,   62,   48,   49,   67,   55,  115,  112,
 /*   980 */   116,  122,  120,  123,  701,  150,  640,  210,   79,   78,
 /*   990 */   665,  642,  632,  485,   77,  633,   81,  133,  138,   86,
 /*  1000 */    85,   84,   34,   68,   76,   75,   66,   64,   69,  371,
 /*  1010 */   148,  106,   18,  521, 1037,  214,  441,  442,   33,  510,
 /*  1020 */    73,  368,   82,  365,  598,  245,  583,  398,  458,   23,
 /*  1030 */   468,  454,   46,   47,   40,  184,   36,  631,  199,  376,
 /*  1040 */   380,  158,  452,  378,  149,  561,  124,  699,  344,  535,
 /*  1050 */   178,  506,  469,  406,  227,  235,  565,  545,  545,  545,
 /*  1060 */   545,  545,  545,  545,  545,  239,  551,  586,  397,  528,
 /*  1070 */   683,  455,  151,  234,  393,   63,  649,  641,   72,  561,
 /*  1080 */   370,  548,  420,   19,  702,  174,  427,  373,  242,  240,
 /*  1090 */   238,  166,  216,  232,  372,  177,  511,   50,  476,   17,
 /*  1100 */   160,  387,  386,  541,   30,   79,   78,  647,  393,  657,
 /*  1110 */   435,   77,  152,   81,  133,  138,   86,   85,   84,  684,
 /*  1120 */    68,   76,   75,   66,   64,   69,  223,  148,  106,  523,
 /*  1130 */     8,    9,  214,  441,  442,  203,    2,  192,  368,   82,
 /*  1140 */   367,  598,  245,  505,  398,  458,   23,  468,  454,   46,
 /*  1150 */    47,   40,  184,   36,  631,  199,  376,  380,  660,  452,
 /*  1160 */   378,  383,  561,  124,  699,  344,  535,  430,  506,  190,
 /*  1170 */   406,  227,  235,  565,  545,  545,  545,  545,  545,  545,
 /*  1180 */   545,  545,  340,  250,   27,  407,  388,  163,  385,  611,
 /*  1190 */   194,  393,  356,  551,  586,  397,  528,  683,  526,    1,
 /*  1200 */   208,  702,   63,  427,  373,  242,  240,  238,  119,  113,
 /*  1210 */   110,   58,   61,   53,   57,   60,   62,   48,   49,   67,
 /*  1220 */    55,  115,  112,  116,  122,  120,  123,   45,  150,   16,
 /*  1230 */   669,    7,   79,   78,  695,  156,    3,  339,   77,   32,
 /*  1240 */    81,  133,  138,   86,   85,   84,  154,   68,   76,   75,
 /*  1250 */    66,   64,   69,   12,  148,  106,   15,  425,    5,  214,
 /*  1260 */   441,  442,  233,  676,   11,  368,   82,  336,  598,  245,
 /*  1270 */   658,  398,  458,   23,  468,  454,   46,   47,   40,  184,
 /*  1280 */    36,  631,  199,  376,  380,  534,  452,  378,  547,  561,
 /*  1290 */   124,  699,  344,  535,  708,  506,  157,  406,  227,  235,
 /*  1300 */   565,  545,  545,  545,  545,  545,  545,  545,  545,  345,
 /*  1310 */   551,  586,  397,  528,  683,  416,  581,  600,  393,   63,
 /*  1320 */    13,  390,   44,  226,  186,  252,  220,  515,  702,  436,
 /*  1330 */   427,  373,  242,  240,  238,  522,    4,  191,  237,  666,
 /*  1340 */   445,  187,  440,  503,  382,  434,  358,  405,  189,   79,
 /*  1350 */    78,  125,  379,  338,   10,   77,    6,   81,  133,  138,
 /*  1360 */    86,   85,   84,  525,   68,   76,   75,   66,   64,   69,
 /*  1370 */   395,  148,  106,  244,  611,  611,  214,  441,  442,  611,
 /*  1380 */   611,  611,  421,   82,  611,  598,  245,  611,  398,  458,
 /*  1390 */    23,  468,  454,   46,   47,   40,  184,   36,  631,  199,
 /*  1400 */   376,  380,  611,  452,  378,  611,  561,  124,  699,  344,
 /*  1410 */   535,  611,  506,  611,  406,  227,  235,  565,  545,  545,
 /*  1420 */   545,  545,  545,  545,  545,  545,  611,  611,  611,  611,
 /*  1430 */   611,  611,  611,  611,  611,  393,  611,  551,  586,  397,
 /*  1440 */   528,  683,  611,  611,  611,  702,   63,  427,  373,  242,
 /*  1450 */   240,  238,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  1460 */   253,  611,   42,  103,   89,   93,   96,   95,  107,  109,
 /*  1470 */   117,  118,   88,   56,  611,  611,   79,   78,  611,  611,
 /*  1480 */   611,  611,   77,  611,   81,  133,  138,   86,   85,   84,
 /*  1490 */   611,   68,   76,   75,   66,   64,   69,  611,  148,  106,
 /*  1500 */   958,  958,  611,  214,  611,  611,  611,  611,  611,  611,
 /*  1510 */    82,  611,  598,  245,  611,  398,  458,   23,  468,  454,
 /*  1520 */    46,   47,   40,  184,   36,  631,  199,  376,  380,  611,
 /*  1530 */   452,  378,  611,  561,  124,  611,  344,  611,  611,  611,
 /*  1540 */   611,  406,  227,  235,  565,  545,  545,  545,  545,  545,
 /*  1550 */   545,  545,  545,  611,  611,  611,  611,  611,  611,  611,
 /*  1560 */   611,  611,  393,  611,  551,  586,  397,  528,  683,  611,
 /*  1570 */   611,  611,  702,   63,  427,  373,  242,  240,  238,  611,
 /*  1580 */   611,  611,  611,  611,  611,  611,  611,  255,  611,  611,
 /*  1590 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  1600 */   611,  611,  611,   79,   78,  611,  611,  611,  611,   77,
 /*  1610 */   611,   81,  133,  138,   86,   85,   84,  611,   68,   76,
 /*  1620 */    75,   66,   64,   69,  611,  148,  106,  611,  611,  611,
 /*  1630 */   214,  611,  611,  611,  611,  611,  611,   82,  611,  598,
 /*  1640 */   245,  611,  398,  458,   23,  468,  454,   46,   47,   40,
 /*  1650 */   184,   36,  631,  199,  376,  380,  611,  452,  378,  611,
 /*  1660 */   561,  124,  611,  344,  611,  611,  611,  611,  406,  227,
 /*  1670 */   235,  565,  545,  545,  545,  545,  545,  545,  545,  545,
 /*  1680 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  393,
 /*  1690 */   611,  551,  586,  397,  528,  683,  611,  611,  611,  702,
 /*  1700 */    63,  427,  373,  242,  240,  238,  611,  611,  611,  611,
 /*  1710 */   611,  611,  611,  611,  243,  611,  611,  611,  611,  611,
 /*  1720 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  1730 */    79,   78,  611,  611,  611,  611,   77,  611,   81,  133,
 /*  1740 */   138,   86,   85,   84,  611,   68,   76,   75,   66,   64,
 /*  1750 */    69,  611,  148,  106,  611,  611,  611,  214,  611,  611,
 /*  1760 */   611,  611,  611,  611,   82,  611,  598,  245,  611,  398,
 /*  1770 */   458,   23,  468,  454,   46,   47,   40,  184,   36,  631,
 /*  1780 */   199,  376,  380,  611,  452,  378,  611,  561,  124,  611,
 /*  1790 */   344,  611,  611,  611,  611,  406,  227,  235,  565,  545,
 /*  1800 */   545,  545,  545,  545,  545,  545,  545,  611,  611,  611,
 /*  1810 */   611,  611,  611,  611,  611,  611,  393,  611,  551,  586,
 /*  1820 */   397,  528,  683,  611,  611,  611,  702,   63,  427,  373,
 /*  1830 */   242,  240,  238,  611,  611,  611,  611,  611,  611,  611,
 /*  1840 */   611,  251,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  1850 */   611,  611,  611,  611,  611,  611,  611,   79,   78,  611,
 /*  1860 */   611,  611,  611,   77,  611,   81,  133,  138,   86,   85,
 /*  1870 */    84,  611,   68,   76,   75,   66,   64,   69,  611,  148,
 /*  1880 */   106,  611,  611,  611,  214,  611,  611,  611,  611,  611,
 /*  1890 */   611,   82,  611,  598,  245,  611,  398,  458,   23,  468,
 /*  1900 */   454,   46,   47,   40,  184,   36,  631,  199,  376,  380,
 /*  1910 */   611,  452,  378,  611,  561,  124,  611,  344,  611,  611,
 /*  1920 */   611,  611,  406,  227,  235,  565,  545,  545,  545,  545,
 /*  1930 */   545,  545,  545,  545,  611,  611,  611,  611,  611,  611,
 /*  1940 */   611,  611,  611,  393,  611,  551,  586,  397,  528,  683,
 /*  1950 */   611,  611,  611,  702,   63,  427,  373,  242,  240,  238,
 /*  1960 */   611,  611,  611,  611,  611,  611,  611,  611,  247,  611,
 /*  1970 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  1980 */   611,  611,  611,  611,   79,   78,  611,  611,  611,  611,
 /*  1990 */    77,  611,   81,  133,  138,   86,   85,   84,  611,   68,
 /*  2000 */    76,   75,   66,   64,   69,  611,  148,  106,  611,  611,
 /*  2010 */   611,  214,  611,  611,  611,  611,  611,  611,   82,  611,
 /*  2020 */   598,  245,  611,  398,  458,   23,  468,  454,   46,   47,
 /*  2030 */    40,  184,   36,  631,  199,  376,  380,  611,  452,  378,
 /*  2040 */   611,  561,  124,  611,  344,  611,  611,  611,  611,  406,
 /*  2050 */   227,  235,  565,  545,  545,  545,  545,  545,  545,  545,
 /*  2060 */   545,  611,  551,  586,  397,  528,  683,  611,  611,  611,
 /*  2070 */   393,   63,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  2080 */   702,  611,  427,  373,  242,  240,  238,  611,  611,  611,
 /*  2090 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  2100 */   611,   79,   78,  611,  611,  611,  611,   77,  611,   81,
 /*  2110 */   133,  138,   86,   85,   84,  611,   68,   76,   75,   66,
 /*  2120 */    64,   69,  611,  148,  106,  611,  611,  611,  214,  611,
 /*  2130 */   611,  611,  611,  611,  611,   82,  611,  598,  245,  611,
 /*  2140 */   398,  458,   23,  468,  454,   46,   47,   40,  184,   36,
 /*  2150 */   631,  199,  376,  380,  611,  452,  378,  611,  561,  124,
 /*  2160 */   611,  344,  611,  611,  611,  611,  406,  227,  235,  565,
 /*  2170 */   545,  545,  545,  545,  545,  545,  545,  545,  611,  551,
 /*  2180 */   586,  397,  528,  683,  611,  611,  611,  393,   63,  611,
 /*  2190 */   611,  611,  611,  611,  611,  611,  611,  702,  611,  427,
 /*  2200 */   373,  242,  240,  238,  611,  611,  611,  141,  611,  611,
 /*  2210 */   611,  611,  611,  611,  611,  611,  611,  611,   79,   78,
 /*  2220 */   611,  611,  611,  611,   77,  611,   81,  133,  138,   86,
 /*  2230 */    85,   84,  611,   68,   76,   75,   66,   64,   69,  611,
 /*  2240 */   148,  106,  531,  531,  531,  531,  531,  531,  611,  611,
 /*  2250 */   611,  611,   82,  512,  105,  101,  119,  113,  110,   58,
 /*  2260 */    61,   53,   57,   60,   62,   48,   49,   67,   55,  115,
 /*  2270 */   112,  116,  122,  120,  123,  561,  150,  611,  344,  611,
 /*  2280 */   611,  611,  611,  406,  227,  235,  565,  545,  545,  545,
 /*  2290 */   545,  545,  545,  545,  545,  611,  551,  586,  397,  528,
 /*  2300 */   683,  611,  530,  207,  393,   63,  611,  611,  611,  611,
 /*  2310 */   611,  611,  611,  611,  702,  611,  427,  373,  242,  240,
 /*  2320 */   238,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  2330 */   611,  611,  611,  611,  611,   79,   78,  611,  611,  611,
 /*  2340 */   611,   77,  611,   81,  133,  138,   86,   85,   84,  611,
 /*  2350 */    68,   76,   75,   66,   64,   69,  611,  148,  106,  611,
 /*  2360 */   611,  611,  611,  611,  611,  611,  611,  611,  611,   82,
 /*  2370 */   591,  611,  113,  110,   58,   61,   53,   57,   60,   62,
 /*  2380 */    48,   49,   67,   55,  115,  112,  116,  122,  120,  123,
 /*  2390 */   611,  150,  561,  611,  611,  344,  611,  611,  611,  611,
 /*  2400 */   406,  227,  235,  565,  545,  545,  545,  545,  545,  545,
 /*  2410 */   545,  545,  611,  551,  586,  397,  528,  683,  611,  611,
 /*  2420 */   611,  393,   63,  611,  611,  611,  611,  611,  611,  611,
 /*  2430 */   611,  702,  611,  427,  373,  242,  240,  238,  611,  611,
 /*  2440 */   611,  140,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  2450 */   611,  611,   79,   78,  611,  611,  611,  611,   77,  611,
 /*  2460 */    81,  133,  138,   86,   85,   84,  611,   68,   76,   75,
 /*  2470 */    66,   64,   69,  611,  148,  106,  531,  531,  531,  531,
 /*  2480 */   531,  531,  611,  611,  611,  611,   82,  703,  110,   58,
 /*  2490 */    61,   53,   57,   60,   62,   48,   49,   67,   55,  115,
 /*  2500 */   112,  116,  122,  120,  123,  611,  150,  611,  611,  561,
 /*  2510 */   611,  611,  344,  611,  611,  611,  611,  406,  227,  235,
 /*  2520 */   565,  545,  545,  545,  545,  545,  545,  545,  545,  611,
 /*  2530 */   551,  586,  397,  528,  683,  611,  530,  207,  393,   63,
 /*  2540 */   611,  611,  611,  611,  611,  611,  611,  611,  702,  611,
 /*  2550 */   427,  373,  242,  240,  238,  611,  611,  611,  135,  611,
 /*  2560 */   611,  611,  611,  611,  611,  611,  611,  611,  611,   79,
 /*  2570 */    78,  611,  611,  611,  611,   77,  611,   81,  133,  138,
 /*  2580 */    86,   85,   84,  611,   68,   76,   75,   66,   64,   69,
 /*  2590 */   611,  148,  106,  611,  611,  611,  611,  611,  611,  611,
 /*  2600 */   611,  611,  611,   82,  611,  611,   58,   61,   53,   57,
 /*  2610 */    60,   62,   48,   49,   67,   55,  115,  112,  116,  122,
 /*  2620 */   120,  123,  611,  150,  611,  611,  561,  611,  611,  344,
 /*  2630 */   611,  611,  611,  611,  406,  227,  235,  565,  545,  545,
 /*  2640 */   545,  545,  545,  545,  545,  545,  611,  551,  586,  397,
 /*  2650 */   528,  683,  611,  611,  611,  393,   63,  173,  172,  611,
 /*  2660 */   611,  611,  611,  611,  611,  702,  611,  427,  373,  242,
 /*  2670 */   240,  238,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  2680 */   611,  611,  611,  611,  611,  611,   79,   78,  611,  611,
 /*  2690 */   611,  611,   77,  611,   81,  133,  138,   86,   85,   84,
 /*  2700 */   611,   68,   76,   75,   66,   64,   69,  611,  148,  106,
 /*  2710 */   611,  611,  611,  611,  611,  611,  611,  461,  611,  611,
 /*  2720 */    82,  611,  655,  611,  611,  638,  545,  545,  545,  545,
 /*  2730 */   545,  545,  545,  545,  611,  611,  611,  611,  611,  611,
 /*  2740 */   611,  611,  611,  561,  611,  611,  344,  611,  611,  611,
 /*  2750 */   611,  406,  227,  235,  565,  545,  545,  545,  545,  545,
 /*  2760 */   545,  545,  545,  611,  551,  586,  397,  528,  683,  611,
 /*  2770 */   677,  611,  393,   63,  611,  611,  611,  611,  611,  611,
 /*  2780 */   611,  444,  702,  611,  427,  373,  242,  240,  238,  611,
 /*  2790 */   611,  611,  132,  611,  611,  611,  611,  611,  611,  351,
 /*  2800 */   611,  611,  611,   79,   78,  611,  611,  611,  611,   77,
 /*  2810 */   611,   81,  133,  138,   86,   85,   84,  611,   68,   76,
 /*  2820 */    75,   66,   64,   69,  611,  148,  106,  611,  611,  611,
 /*  2830 */   611,  611,  381,  611,  611,  438,  611,   82,  611,  611,
 /*  2840 */   410,  335,  181,  622,  613,  629,  611,  540,  611,  611,
 /*  2850 */   681,  224,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  2860 */   561,  611,  611,  344,  611,  611,  611,  611,  406,  227,
 /*  2870 */   235,  565,  545,  545,  545,  545,  545,  545,  545,  545,
 /*  2880 */   611,  551,  586,  397,  528,  683,  646,  611,  611,  393,
 /*  2890 */    63,  360,  355,  182,  622,  457,  611,  444,  540,  702,
 /*  2900 */   611,  427,  373,  242,  240,  238,  611,  611,  611,  136,
 /*  2910 */   611,  568,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  2920 */    79,   78,  611,  611,  611,  611,   77,  611,   81,  133,
 /*  2930 */   138,   86,   85,   84,  611,   68,   76,   75,   66,   64,
 /*  2940 */    69,  611,  148,  106,  611,  611,  611,  611,  381,  611,
 /*  2950 */   645,  438,  611,  611,   82,  611,  410,  335,  181,  622,
 /*  2960 */   613,  629,  611,  540,  611,  611,  611,  229,  611,  611,
 /*  2970 */   611,  611,  611,  611,  611,  611,  611,  561,  611,  611,
 /*  2980 */   344,  611,  611,  611,  611,  406,  227,  235,  565,  545,
 /*  2990 */   545,  545,  545,  545,  545,  545,  545,  611,  551,  586,
 /*  3000 */   397,  528,  683,  611,  677,  611,  393,   63,  355,  182,
 /*  3010 */   622,  457,  611,  611,  540,  444,  702,  611,  427,  373,
 /*  3020 */   242,  240,  238,  611,  611,  611,  611,  568,  611,  611,
 /*  3030 */   611,  611,  611,  346,  611,  611,  611,   79,   78,  611,
 /*  3040 */   611,  611,  611,   77,  611,   81,  133,  138,   86,   85,
 /*  3050 */    84,  611,   68,   76,   75,   66,   64,   69,  611,  148,
 /*  3060 */   106,  611,  611,  611,  611,  611,  381,  611,  611,  438,
 /*  3070 */   611,   82,  611,  623,  410,  335,  181,  622,  613,  629,
 /*  3080 */   611,  540,  611,  611,  681,  625,  611,  611,  611,  611,
 /*  3090 */   611,  611,  611,  611,  561,  611,  611,  344,  611,  611,
 /*  3100 */   611,  611,  406,  227,  235,  565,  545,  545,  545,  545,
 /*  3110 */   545,  545,  545,  545,  611,  551,  586,  397,  528,  683,
 /*  3120 */   499,  611,  611,  393,   63,  611,  355,  182,  622,  457,
 /*  3130 */   611,  444,  540,  702,  611,  427,  373,  242,  240,  238,
 /*  3140 */   611,  611,  611,  143,  611,  568,  611,  611,  611,  611,
 /*  3150 */   611,  611,  611,  611,   79,   78,  611,  611,  611,  611,
 /*  3160 */    77,  611,   81,  133,  138,   86,   85,   84,  611,   68,
 /*  3170 */    76,   75,   66,   64,   69,  611,  148,  106,  611,  611,
 /*  3180 */   611,  611,  611,  611,  611,  438,  611,  611,   82,  611,
 /*  3190 */   410,  335,  181,  622,  613,  629,  611,  540,  611,  611,
 /*  3200 */   611,  611,  611,  611,  347,  611,  611,  611,  611,  611,
 /*  3210 */   611,  561,  611,  611,  344,  611,  611,  611,  611,  406,
 /*  3220 */   227,  235,  565,  545,  545,  545,  545,  545,  545,  545,
 /*  3230 */   545,  611,  551,  586,  397,  528,  683,  606,  611,  611,
 /*  3240 */   393,   63,  611,  611,  611,  611,  611,  611,  444,  611,
 /*  3250 */   702,  611,  427,  373,  242,  240,  238,  611,  611,  611,
 /*  3260 */   139,  611,  611,  611,  611,  597,  611,  611,  611,  611,
 /*  3270 */   611,   79,   78,  611,  611,  611,  611,   77,  611,   81,
 /*  3280 */   133,  138,   86,   85,   84,  611,   68,   76,   75,   66,
 /*  3290 */    64,   69,  611,  148,  106,  611,  611,  611,  611,  611,
 /*  3300 */   611,  611,  438,  611,  611,   82,  611,  410,  335,  181,
 /*  3310 */   622,  613,  629,  611,  540,  611,  611,  611,  611,  611,
 /*  3320 */   611,  611,  611,  611,  611,  611,  611,  611,  561,  611,
 /*  3330 */   611,  344,  611,  611,  611,  611,  406,  227,  235,  565,
 /*  3340 */   545,  545,  545,  545,  545,  545,  545,  545,  611,  551,
 /*  3350 */   586,  397,  528,  683,  611,  677,  611,  393,   63,  611,
 /*  3360 */   611,  611,  611,  611,  611,  611,  444,  702,  611,  427,
 /*  3370 */   373,  242,  240,  238,  611,  611,  611,  611,  611,  611,
 /*  3380 */   611,  611,  611,  611,  611,  611,  611,  611,   79,   78,
 /*  3390 */   611,  611,  611,  611,   77,  611,   81,  133,  138,   86,
 /*  3400 */    85,   84,  611,   68,   76,   75,   66,   64,   69,  611,
 /*  3410 */   148,  106,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  3420 */   438,  611,   82,  611,  614,  410,  335,  181,  622,  613,
 /*  3430 */   629,  611,  540,  611,  611,  672,  611,  611,  611,  611,
 /*  3440 */   611,  611,  611,  611,  611,  561,  611,  611,  344,  611,
 /*  3450 */   611,  611,  611,  406,  227,  235,  565,  545,  545,  545,
 /*  3460 */   545,  545,  545,  545,  545,  611,  551,  586,  397,  528,
 /*  3470 */   683,  675,  611,  611,  393,   63,  611,  611,  611,  611,
 /*  3480 */   611,  611,  444,  611,  702,  611,  427,  373,  242,  240,
 /*  3490 */   238,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  3500 */   611,  611,  611,  516,  611,   79,   78,  611,  611,  611,
 /*  3510 */   611,   77,  611,   81,  133,  138,   86,   85,   84,  611,
 /*  3520 */    68,   76,   75,   66,   64,   69,  611,  148,  106,  611,
 /*  3530 */   611,  611,  611,  611,  611,  611,  438,  611,  611,   82,
 /*  3540 */   611,  410,  335,  181,  622,  613,  629,  611,  540,  611,
 /*  3550 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  3560 */   611,  611,  561,  611,  611,  344,  611,  611,  611,  611,
 /*  3570 */   406,  227,  235,  565,  545,  545,  545,  545,  545,  545,
 /*  3580 */   545,  545,  611,  551,  586,  397,  528,  683,  675,  611,
 /*  3590 */   611,  393,   63,  611,  611,  611,  611,  611,  611,  444,
 /*  3600 */   611,  702,  611,  427,  373,  242,  240,  238,  611,  611,
 /*  3610 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  3620 */   662,  611,   79,   78,  611,  611,  611,  611,   77,  611,
 /*  3630 */    81,  133,  138,   86,   85,   84,  611,   68,   76,   75,
 /*  3640 */    66,   64,   69,  611,  148,  106,  611,  611,  611,  611,
 /*  3650 */   611,  611,  611,  438,  611,  611,   82,  611,  410,  335,
 /*  3660 */   181,  622,  613,  629,  611,  540,  611,  611,  611,  611,
 /*  3670 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  561,
 /*  3680 */   611,  611,  344,  611,  611,  611,  611,  406,  227,  235,
 /*  3690 */   565,  545,  545,  545,  545,  545,  545,  545,  545,  611,
 /*  3700 */   611,  611,  611,  611,  611,  611,  611,  611,  393,  611,
 /*  3710 */   611,  693,  692,  687,  538,  611,  277,  611,  488,  196,
 /*  3720 */   427,  373,  242,  240,  238,  536,  322,  611,  611,  611,
 /*  3730 */   611,  611,  611,  611,  611,  611,  611,  490,  611,  611,
 /*  3740 */   611,  698,  691,  690,  221,  611,  611,  432,  611,  611,
 /*  3750 */   611,  450,   94,  611,  569,  611,  611,  611,  348,  653,
 /*  3760 */   611,  710,  460,  611,  611,  694,   54,  611,  105,  101,
 /*  3770 */   119,  113,  110,   58,   61,   53,   57,   60,   62,   48,
 /*  3780 */    49,   67,   55,  115,  112,  116,  122,  120,  123,  611,
 /*  3790 */   150,  438,  611,  611,  611,  611,  410,  335,  181,  622,
 /*  3800 */   613,  629,  611,  540,  611,  693,  692,  687,  538,  611,
 /*  3810 */   277,  108,   90,  100,  102,  712,  611,  611,  611,  536,
 /*  3820 */   322,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  3830 */   611,  490,  611,  611,  611,  698,  691,  690,  221,  611,
 /*  3840 */   611,  432,  611,  611,  611,  450,  611,  611,  569,  611,
 /*  3850 */   611,  611,  348,  653,  611,  710,  460,  611,  611,  694,
 /*  3860 */   915,  611,  674,  611,  611,   42,  103,   89,   93,   96,
 /*  3870 */    95,  107,  109,  117,  118,   88,   56,  611,  517,  509,
 /*  3880 */   611,  611,  611,  611,  611,  438,  611,  611,  611,  611,
 /*  3890 */   410,  335,  181,  622,  613,  629,  611,  540,  361,  611,
 /*  3900 */   611,  668,  611,  958,  958,  108,   90,  100,  102,  712,
 /*  3910 */   556,  557,  552,  559,  538,  611,  277,  611,  611,  611,
 /*  3920 */   611,  611,  611,  611,  611,  536,  322,  611,  611,  915,
 /*  3930 */   524,  573,  661,  680,  679,  595,   70,  490,  144,  611,
 /*  3940 */   611,  628,  691,  690,  221,  611,  611,  432,  611,  611,
 /*  3950 */   611,  450,  611,  611,  569,  611,  611,  611,  348,  653,
 /*  3960 */   611,  710,  460,  611,  611,  694,  611,  611,  611,  611,
 /*  3970 */    42,  103,   89,   93,   96,   95,  107,  109,  117,  118,
 /*  3980 */    88,   56,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  3990 */   611,  438,  611,  611,  611,  611,  410,  335,  181,  622,
 /*  4000 */   613,  629,  611,  540,  104,  121,   94,  611,  958,  958,
 /*  4010 */   611,  108,   90,  100,  102,  712,  611,  611,  611,  611,
 /*  4020 */    54,  593,  105,  101,  119,  113,  110,   58,   61,   53,
 /*  4030 */    57,   60,   62,   48,   49,   67,   55,  115,  112,  116,
 /*  4040 */   122,  120,  123,  611,  150,  611,  611,  264,  611,  611,
 /*  4050 */   611,  611,  127,  611,  611,  611,  536,  322,  611,  611,
 /*  4060 */   611,  611,  611,  611,  611,  611,  611,  611,  490,  611,
 /*  4070 */   611,  611,  611,  593,  611,  611,  611,  611,  611,  611,
 /*  4080 */   611,  104,  121,   94,  611,  569,  611,  611,  611,  348,
 /*  4090 */   653,  611,  710,  460,  456,  611,  694,   54,  611,  105,
 /*  4100 */   101,  119,  113,  110,   58,   61,   53,   57,   60,   62,
 /*  4110 */    48,   49,   67,   55,  115,  112,  116,  122,  120,  123,
 /*  4120 */   611,  150,  438,  611,  611,  611,  611,  410,  335,  181,
 /*  4130 */   622,  613,  629,  611,  540,  611,  646,  611,  212,  611,
 /*  4140 */   611,  611,  108,   90,  100,  102,  712,  444,  611,  412,
 /*  4150 */   611,  611,  611,  611,  611,  611,  611,  104,  121,   94,
 /*  4160 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  4170 */   611,  611,  611,   54,  611,  105,  101,  119,  113,  110,
 /*  4180 */    58,   61,   53,   57,   60,   62,   48,   49,   67,   55,
 /*  4190 */   115,  112,  116,  122,  120,  123,  611,  150,  611,  611,
 /*  4200 */   644,  438,  611,  611,  611,  611,  410,  335,  181,  622,
 /*  4210 */   613,  629,  611,  540,  611,  611,  611,  611,  611,  611,
 /*  4220 */   611,  611,  611,  611,  611,  611,  611,  611,  608,  611,
 /*  4230 */   611,  611,  611,  611,  611,  611,  104,  121,   94,  611,
 /*  4240 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  4250 */   611,  611,   54,  611,  105,  101,  119,  113,  110,   58,
 /*  4260 */    61,   53,   57,   60,   62,   48,   49,   67,   55,  115,
 /*  4270 */   112,  116,  122,  120,  123,  611,  150,  611,  611,  611,
 /*  4280 */   611,  283,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  4290 */   536,  322,  611,  611,  357,  611,  611,  611,  611,  611,
 /*  4300 */   611,  611,  490,  611,  611,  696,  611,  611,  611,  611,
 /*  4310 */   611,  611,  611,  104,  121,   94,  611,  611,  611,  569,
 /*  4320 */   611,  611,  611,  348,  653,  611,  710,  460,  611,   54,
 /*  4330 */   694,  105,  101,  119,  113,  110,   58,   61,   53,   57,
 /*  4340 */    60,   62,   48,   49,   67,   55,  115,  112,  116,  122,
 /*  4350 */   120,  123,  611,  150,  611,  611,  438,  611,  611,  611,
 /*  4360 */   611,  410,  335,  181,  622,  613,  629,  611,  540,  611,
 /*  4370 */   611,  611,  611,  611,  611,  611,  108,   90,  100,  102,
 /*  4380 */   712,  611,  611,  611,  589,  611,  611,  611,  611,  611,
 /*  4390 */   611,  611,  104,  121,   94,  611,  611,  611,  611,  611,
 /*  4400 */   611,  611,  611,  611,  611,  611,  611,  611,   54,   80,
 /*  4410 */   105,  101,  119,  113,  110,   58,   61,   53,   57,   60,
 /*  4420 */    62,   48,   49,   67,   55,  115,  112,  116,  122,  120,
 /*  4430 */   123,  912,  150,  104,  121,   94,   42,  103,   89,   93,
 /*  4440 */    96,   95,  107,  109,  117,  118,   88,   56,  611,   54,
 /*  4450 */   611,  105,  101,  119,  113,  110,   58,   61,   53,   57,
 /*  4460 */    60,   62,   48,   49,   67,   55,  115,  112,  116,  122,
 /*  4470 */   120,  123,  611,  150,  958,  958,  611,  290,  611,  611,
 /*  4480 */   611,  611,  611,  611,  611,  611,  536,  322,  611,  611,
 /*  4490 */   611,  611,  611,  611,  611,  611,  611,  611,  490,  611,
 /*  4500 */   912,   22,  611,  611,  611,  611,  611,  611,  611,  104,
 /*  4510 */   121,   94,  611,  611,  611,  569,  611,  611,  611,  348,
 /*  4520 */   653,  611,  710,  460,  611,   54,  694,  105,  101,  119,
 /*  4530 */   113,  110,   58,   61,   53,   57,   60,   62,   48,   49,
 /*  4540 */    67,   55,  115,  112,  116,  122,  120,  123,  611,  150,
 /*  4550 */   611,  611,  438,  611,  611,  611,  611,  410,  335,  181,
 /*  4560 */   622,  613,  629,  471,  540,  611,  611,  611,  611,  611,
 /*  4570 */   611,  611,  108,   90,  100,  102,  712,  611,  611,  611,
 /*  4580 */   554,  611,  611,  611,  611,  611,  611,  611,  104,  121,
 /*  4590 */    94,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  4600 */   611,  611,  611,  611,   54,  611,  105,  101,  119,  113,
 /*  4610 */   110,   58,   61,   53,   57,   60,   62,   48,   49,   67,
 /*  4620 */    55,  115,  112,  116,  122,  120,  123,  611,  150,  611,
 /*  4630 */   611,  611,  611,  611,  611,  611,  611,  611,   42,  103,
 /*  4640 */    89,   93,   96,   95,  107,  109,  117,  118,   88,   56,
 /*  4650 */   500,  611,  611,  611,  611,  611,  197,  611,  611,  611,
 /*  4660 */   611,  444,  611,  611,  104,  121,   94,  611,  611,  611,
 /*  4670 */   611,  611,  611,  611,  611,  611,  958,  958,  611,  611,
 /*  4680 */    54,  611,  105,  101,  119,  113,  110,   58,   61,   53,
 /*  4690 */    57,   60,   62,   48,   49,   67,   55,  115,  112,  116,
 /*  4700 */   122,  120,  123,  619,  150,  611,  611,  611,  611,  611,
 /*  4710 */   611,  611,  611,  611,  611,  438,  611,  611,  611,  611,
 /*  4720 */   410,  335,  181,  622,  613,  629,  519,  540,  611,  611,
 /*  4730 */   611,  611,  611,  612,  611,  611,  611,  444,  611,  611,
 /*  4740 */   611,  104,  121,   94,  611,  611,  611,  611,  611,  611,
 /*  4750 */   611,  611,  611,  611,  611,  611,  611,   54,  611,  105,
 /*  4760 */   101,  119,  113,  110,   58,   61,   53,   57,   60,   62,
 /*  4770 */    48,   49,   67,   55,  115,  112,  116,  122,  120,  123,
 /*  4780 */   611,  150,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  4790 */   611,  438,  611,  611,  611,  611,  410,  335,  181,  622,
 /*  4800 */   613,  629,  377,  540,  611,  611,  611,  611,  611,  611,
 /*  4810 */   615,  611,  611,  444,  611,  611,  611,  611,  104,  121,
 /*  4820 */    94,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  4830 */   611,  611,  611,  611,   54,  611,  105,  101,  119,  113,
 /*  4840 */   110,   58,   61,   53,   57,   60,   62,   48,   49,   67,
 /*  4850 */    55,  115,  112,  116,  122,  120,  123,  611,  150,  611,
 /*  4860 */   611,  611,  611,  611,  611,  611,  611,  438,  611,  611,
 /*  4870 */   611,  611,  410,  335,  181,  622,  613,  629,  611,  540,
 /*  4880 */   611,  611,  611,  611,  611,  611,  688,  611,  611,  611,
 /*  4890 */   611,  611,  611,  611,  104,  121,   94,  611,  611,  611,
 /*  4900 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  4910 */    54,  611,  105,  101,  119,  113,  110,   58,   61,   53,
 /*  4920 */    57,   60,   62,   48,   49,   67,   55,  115,  112,  116,
 /*  4930 */   122,  120,  123,  611,  150,  104,  121,   94,  611,  611,
 /*  4940 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  4950 */   611,   54,  611,  105,  101,  119,  113,  110,   58,   61,
 /*  4960 */    53,   57,   60,   62,   48,   49,   67,   55,  115,  112,
 /*  4970 */   116,  122,  120,  123,  611,  150,  611,  611,  611,  611,
 /*  4980 */   611,  611,  611,  611,  674,  611,  611,  611,  611,  611,
 /*  4990 */   611,  611,  611,  611,  611,  611,  611,  611,  414,  611,
 /*  5000 */   517,  509,  611,  465,   41,  611,  611,  611,  611,  444,
 /*  5010 */   611,  104,  121,   94,  611,  611,  611,  611,  611,  611,
 /*  5020 */   361,  611,  611,  668,  611,  611,  611,   54,  611,  105,
 /*  5030 */   101,  119,  113,  110,   58,   61,   53,   57,   60,   62,
 /*  5040 */    48,   49,   67,   55,  115,  112,  116,  122,  120,  123,
 /*  5050 */   611,  150,  524,  573,  661,  680,  679,  595,   70,  611,
 /*  5060 */   144,  611,  611,  438,  611,  611,  654,  611,  410,  335,
 /*  5070 */   181,  622,  613,  629,  611,  540,  611,  611,  611,   20,
 /*  5080 */   611,  611,  611,  611,  611,  611,  611,  104,  121,   94,
 /*  5090 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  5100 */   611,  611,  611,   54,  611,  105,  101,  119,  113,  110,
 /*  5110 */    58,   61,   53,   57,   60,   62,   48,   49,   67,   55,
 /*  5120 */   115,  112,  116,  122,  120,  123,  611,  150,  611,  288,
 /*  5130 */   611,  611,  611,  611,  611,  472,  611,  611,  536,  322,
 /*  5140 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  5150 */   490,  611,  611,  611,  611,   25,  611,  611,  611,  611,
 /*  5160 */   611,  611,  611,  104,  121,   94,  611,  569,  611,  611,
 /*  5170 */   611,  348,  653,  611,  710,  460,  611,  611,  694,   54,
 /*  5180 */   611,  105,  101,  119,  113,  110,   58,   61,   53,   57,
 /*  5190 */    60,   62,   48,   49,   67,   55,  115,  112,  116,  122,
 /*  5200 */   120,  123,  611,  150,  438,  611,  611,  611,  611,  410,
 /*  5210 */   335,  181,  622,  613,  629,  611,  540,  611,  611,  611,
 /*  5220 */   611,  611,  611,  611,  108,   90,  100,  102,  712,  611,
 /*  5230 */   611,  611,  409,  611,  496,  611,  611,  611,  611,  611,
 /*  5240 */   611,  611,  104,  121,   94,  611,  611,  611,  611,  611,
 /*  5250 */   611,  611,  611,  611,  611,  611,  611,  611,   54,  611,
 /*  5260 */   105,  101,  119,  113,  110,   58,   61,   53,   57,   60,
 /*  5270 */    62,   48,   49,   67,   55,  115,  112,  116,  122,  120,
 /*  5280 */   123,  611,  150,  104,  121,   94,  611,  611,  611,  611,
 /*  5290 */   611,  611,  611,  611,  611,  611,  611,  611,  611,   54,
 /*  5300 */   611,  105,  101,  119,  113,  110,   58,   61,   53,   57,
 /*  5310 */    60,   62,   48,   49,   67,   55,  115,  112,  116,  122,
 /*  5320 */   120,  123,  611,  150,  611,  611,  611,  611,  288,  611,
 /*  5330 */   611,  611,  611,  611,  466,  611,  611,  536,  322,  611,
 /*  5340 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  490,
 /*  5350 */   611,  611,  611,  611,  594,  611,  611,  611,  611,  611,
 /*  5360 */   611,  611,  104,  121,   94,  459,  569,  611,  611,  611,
 /*  5370 */   348,  653,  611,  710,  460,  611,  611,  694,   54,  611,
 /*  5380 */   105,  101,  119,  113,  110,   58,   61,   53,   57,   60,
 /*  5390 */    62,   48,   49,   67,   55,  115,  112,  116,  122,  120,
 /*  5400 */   123,  611,  150,  438,  611,  611,  611,  611,  410,  335,
 /*  5410 */   181,  622,  613,  629,  611,  540,  611,  611,  611,  611,
 /*  5420 */   611,  611,  611,  108,   90,  100,  102,  712,  611,  611,
 /*  5430 */   611,  409,  611,  584,  611,  611,  611,  611,  611,  611,
 /*  5440 */   611,  104,  121,   94,  611,  611,  611,  611,  611,  611,
 /*  5450 */   611,  611,  611,  611,  611,  611,  611,   54,  611,  105,
 /*  5460 */   101,  119,  113,  110,   58,   61,   53,   57,   60,   62,
 /*  5470 */    48,   49,   67,   55,  115,  112,  116,  122,  120,  123,
 /*  5480 */   611,  150,  611,  104,  121,   94,  611,  611,  611,  611,
 /*  5490 */   611,  611,  611,  611,  611,  611,  611,  611,  611,   54,
 /*  5500 */   611,  105,  101,  119,  113,  110,   58,   61,   53,   57,
 /*  5510 */    60,   62,   48,   49,   67,   55,  115,  112,  116,  122,
 /*  5520 */   120,  123,  611,  150,  611,  288,  611,  611,  611,  611,
 /*  5530 */   611,  474,  611,  611,  536,  322,  611,  611,  611,  611,
 /*  5540 */   611,  611,  611,  611,  611,  611,  490,  611,  611,  611,
 /*  5550 */   611,   39,  639,  611,  611,  611,  611,  611,  611,  104,
 /*  5560 */   121,   94,  611,  569,  611,  611,  611,  348,  653,  611,
 /*  5570 */   710,  460,  611,  611,  694,   54,  611,  105,  101,  119,
 /*  5580 */   113,  110,   58,   61,   53,   57,   60,   62,   48,   49,
 /*  5590 */    67,   55,  115,  112,  116,  122,  120,  123,  611,  150,
 /*  5600 */   438,  611,  611,  611,  611,  410,  335,  181,  622,  613,
 /*  5610 */   629,  611,  540,  611,  611,  611,  611,  611,  611,  611,
 /*  5620 */   108,   90,  100,  102,  712,  611,  611,  650,  409,  611,
 /*  5630 */   611,  611,  611,  611,  611,  104,  121,   94,  611,  611,
 /*  5640 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  5650 */   611,   54,  611,  105,  101,  119,  113,  110,   58,   61,
 /*  5660 */    53,   57,   60,   62,   48,   49,   67,   55,  115,  112,
 /*  5670 */   116,  122,  120,  123,  611,  150,  611,  290,  611,  611,
 /*  5680 */   611,  611,  611,  611,  611,  611,  536,  322,  611,  611,
 /*  5690 */   611,  611,  611,  611,  611,  611,  611,  611,  490,  611,
 /*  5700 */   611,  611,  611,  493,  611,  611,  611,  611,  611,  611,
 /*  5710 */   611,  104,  121,   94,  611,  569,  611,  611,  611,  348,
 /*  5720 */   653,  611,  710,  460,  611,  611,  694,   54,  611,  105,
 /*  5730 */   101,  119,  113,  110,   58,   61,   53,   57,   60,   62,
 /*  5740 */    48,   49,   67,   55,  115,  112,  116,  122,  120,  123,
 /*  5750 */   611,  150,  438,  611,  611,  611,  611,  410,  335,  181,
 /*  5760 */   622,  613,  629,  479,  540,  611,  611,  611,  611,  611,
 /*  5770 */   611,  611,  108,   90,  100,  102,  712,  674,  611,  611,
 /*  5780 */   611,  611,  611,  611,  544,  611,  611,  538,  611,  277,
 /*  5790 */   611,  611,  611,  517,  509,  611,  706,  611,  536,  322,
 /*  5800 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  5810 */   490,  611,  611,  361,  611,  611,  668,  611,  611,  611,
 /*  5820 */   611,  611,  611,  611,  611,  205,  611,  569,  611,  611,
 /*  5830 */   611,  348,  653,  611,  710,  460,  444,  611,  694,  611,
 /*  5840 */   611,  611,  611,  611,  611,  524,  573,  661,  680,  679,
 /*  5850 */   595,   70,  611,  144,  611,  611,  611,  603,  611,  611,
 /*  5860 */   611,  611,  611,  611,  438,  611,  611,  611,  611,  410,
 /*  5870 */   335,  181,  622,  613,  629,  611,  540,  611,  574,  611,
 /*  5880 */   611,  538,  611,  277,  108,   90,  100,  102,  712,  611,
 /*  5890 */   438,  611,  536,  322,  611,  410,  335,  181,  622,  613,
 /*  5900 */   629,  607,  540,  611,  490,  611,  611,  611,  611,  611,
 /*  5910 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  5920 */   611,  569,  611,  611,  611,  348,  653,  611,  710,  460,
 /*  5930 */   611,  611,  694,  611,  611,  611,  611,  611,  611,  611,
 /*  5940 */   543,  611,  611,  611,  611,  611,  570,  611,  611,  611,
 /*  5950 */   611,  444,  611,  611,  611,  611,  611,  611,  438,  611,
 /*  5960 */   611,  611,  611,  410,  335,  181,  622,  613,  629,  611,
 /*  5970 */   540,  611,  611,  611,  611,  611,  611,  611,  108,   90,
 /*  5980 */   100,  102,  712,  574,  611,  572,  538,  611,  277,  611,
 /*  5990 */   611,  611,  611,  611,  611,  611,  611,  536,  322,  611,
 /*  6000 */   611,  611,  611,  611,  611,  438,  592,  611,  611,  490,
 /*  6010 */   410,  335,  181,  622,  613,  629,  611,  540,  611,  611,
 /*  6020 */   611,  611,  611,  611,  611,  611,  569,  611,  611,  611,
 /*  6030 */   348,  653,  611,  710,  460,  611,  611,  694,  611,  611,
 /*  6040 */   611,  611,  674,  611,  611,  611,  611,  611,  611,  611,
 /*  6050 */   550,  611,  611,  538,  611,  277,  611,  611,  517,  509,
 /*  6060 */   656,  611,  611,  438,  536,  322,  611,  611,  410,  335,
 /*  6070 */   181,  622,  613,  629,  611,  540,  490,  495,  361,  611,
 /*  6080 */   538,  668,  277,  108,   90,  100,  102,  712,  705,  611,
 /*  6090 */   611,  536,  322,  569,  611,  611,  611,  348,  653,  611,
 /*  6100 */   710,  460,  596,  490,  694,  611,  611,  611,  611,  611,
 /*  6110 */   524,  573,  661,  680,  679,  595,   70,  611,  144,  611,
 /*  6120 */   569,  611,  611,  611,  348,  653,  611,  710,  460,  611,
 /*  6130 */   438,  694,  611,  611,  611,  410,  335,  181,  622,  613,
 /*  6140 */   629,  611,  540,  611,  611,  611,  611,  611,  611,  611,
 /*  6150 */   108,   90,  100,  102,  712,  611,  611,  438,  611,  611,
 /*  6160 */   611,  611,  410,  335,  181,  622,  613,  629,  611,  540,
 /*  6170 */   611,  611,  611,  611,  611,  611,  611,  108,   90,  100,
 /*  6180 */   102,  712,  611,  611,  286,  611,  611,  611,  611,  611,
 /*  6190 */   611,  611,  611,  359,  319,  611,  611,  611,  611,  611,
 /*  6200 */   611,  611,  611,  611,  611,  490,  611,  611,  611,  611,
 /*  6210 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  6220 */   611,  611,  569,  611,  611,  611,  348,  653,  611,  710,
 /*  6230 */   460,  611,  611,  694,  611,  611,  611,  611,  611,  611,
 /*  6240 */   611,  611,  611,  611,  464,  481,  611,  611,  611,  611,
 /*  6250 */   611,  286,  611,  611,  611,  611,  611,  611,  611,  438,
 /*  6260 */   359,  319,  611,  611,  410,  335,  181,  622,  613,  629,
 /*  6270 */   611,  540,  490,  611,  611,  611,  611,  611,  611,  108,
 /*  6280 */    90,  100,  102,  712,  611,  611,  611,  611,  611,  569,
 /*  6290 */   611,  611,  611,  348,  653,  611,  710,  460,  611,  611,
 /*  6300 */   694,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  6310 */   611,  462,  481,  611,  611,  611,  611,  611,  286,  611,
 /*  6320 */   611,  611,  611,  611,  611,  611,  438,  359,  319,  611,
 /*  6330 */   611,  410,  335,  181,  622,  613,  629,  611,  540,  490,
 /*  6340 */   611,  611,  611,  611,  611,  611,  108,   90,  100,  102,
 /*  6350 */   712,  611,  611,  611,  611,  611,  569,  611,  611,  611,
 /*  6360 */   348,  653,  611,  710,  460,  611,  611,  694,  611,  611,
 /*  6370 */   611,  611,  611,  611,  611,  611,  611,  611,  484,  481,
 /*  6380 */   611,  611,  611,  611,  611,  611,  611,  286,  611,  611,
 /*  6390 */   611,  611,  611,  438,  611,  611,  359,  319,  410,  335,
 /*  6400 */   181,  622,  613,  629,  611,  540,  611,  611,  490,  611,
 /*  6410 */   611,  611,  611,  108,   90,  100,  102,  712,  611,  611,
 /*  6420 */   611,  611,  611,  611,  611,  569,  611,  611,  611,  348,
 /*  6430 */   653,  611,  710,  460,  611,  611,  694,  611,  611,  611,
 /*  6440 */   611,  611,  611,  611,  611,  611,  611,  483,  481,  611,
 /*  6450 */   611,  611,  611,  611,  286,  611,  611,  611,  611,  611,
 /*  6460 */   611,  611,  438,  359,  319,  611,  611,  410,  335,  181,
 /*  6470 */   622,  613,  629,  611,  540,  490,  470,  611,  611,  538,
 /*  6480 */   611,  277,  108,   90,  100,  102,  712,  611,  611,  611,
 /*  6490 */   536,  322,  569,  611,  611,  611,  348,  653,  611,  710,
 /*  6500 */   460,  611,  490,  694,  611,  611,  611,  611,  611,  611,
 /*  6510 */   611,  611,  611,  611,  475,  481,  611,  611,  611,  569,
 /*  6520 */   611,  611,  611,  348,  653,  611,  710,  460,  611,  438,
 /*  6530 */   694,  611,  611,  611,  410,  335,  181,  622,  613,  629,
 /*  6540 */   611,  540,  611,  543,  611,  611,  611,  611,  611,  108,
 /*  6550 */    90,  100,  102,  712,  444,  611,  438,  611,  611,  611,
 /*  6560 */   611,  410,  335,  181,  622,  613,  629,  611,  540,  611,
 /*  6570 */   611,  611,  611,  611,  611,  611,  108,   90,  100,  102,
 /*  6580 */   712,  254,  611,  611,  538,  611,  277,  611,  566,  611,
 /*  6590 */   611,  611,  611,  611,  611,  536,  322,  611,  611,  611,
 /*  6600 */   611,  611,  611,  611,  611,  611,  611,  490,  438,  611,
 /*  6610 */   611,  611,  611,  410,  335,  181,  622,  613,  629,  611,
 /*  6620 */   540,  611,  611,  611,  569,  611,  611,  611,  348,  653,
 /*  6630 */   611,  710,  460,  611,  611,  694,  611,  611,  611,  611,
 /*  6640 */   611,  611,  611,  611,  611,  611,  611,  611,  563,  611,
 /*  6650 */   611,  538,  611,  277,  611,  611,  611,  611,  611,  611,
 /*  6660 */   611,  438,  536,  322,  611,  611,  410,  335,  181,  622,
 /*  6670 */   613,  629,  611,  540,  490,  562,  611,  611,  538,  611,
 /*  6680 */   277,  108,   90,  100,  102,  712,  611,  611,  611,  536,
 /*  6690 */   322,  569,  611,  611,  611,  348,  653,  611,  710,  460,
 /*  6700 */   611,  490,  694,  611,  611,  611,  611,  611,  611,  611,
 /*  6710 */   611,  611,  611,  611,  611,  611,  611,  611,  569,  611,
 /*  6720 */   611,  611,  348,  653,  611,  710,  460,  611,  438,  694,
 /*  6730 */   611,  611,  611,  410,  335,  181,  622,  613,  629,  611,
 /*  6740 */   540,  611,  543,  611,  611,  611,  611,  611,  108,   90,
 /*  6750 */   100,  102,  712,  444,  611,  438,  611,  611,  611,  611,
 /*  6760 */   410,  335,  181,  622,  613,  629,  611,  540,  611,  611,
 /*  6770 */   611,  611,  611,  611,  611,  108,   90,  100,  102,  712,
 /*  6780 */   611,  611,  286,  611,  611,  611,  611,  558,  611,  611,
 /*  6790 */   611,  359,  319,  611,  611,  611,  611,  611,  611,  611,
 /*  6800 */   611,  611,  611,  490,  611,  611,  611,  438,  611,  611,
 /*  6810 */   611,  611,  410,  335,  181,  622,  613,  629,  611,  540,
 /*  6820 */   569,  611,  611,  611,  348,  653,  611,  710,  460,  611,
 /*  6830 */   611,  694,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  6840 */   611,  611,  453,  481,  611,  611,  611,  611,  611,  611,
 /*  6850 */   611,  611,  611,  611,  611,  611,  611,  438,  611,  611,
 /*  6860 */   611,  611,  410,  335,  181,  622,  613,  629,  611,  540,
 /*  6870 */   611,  121,   94,  611,  611,  611,  611,  108,   90,  100,
 /*  6880 */   102,  712,  611,  611,  611,  611,   54,  611,  105,  101,
 /*  6890 */   119,  113,  110,   58,   61,   53,   57,   60,   62,   48,
 /*  6900 */    49,   67,   55,  115,  112,  116,  122,  120,  123,  332,
 /*  6910 */   150,  611,  611,  611,  611,  611,  611,  611,  536,  322,
 /*  6920 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  6930 */   490,  611,  611,  611,  611,  611,  331,  611,  611,  611,
 /*  6940 */   611,  611,  611,  611,  611,  536,  322,  569,  611,  611,
 /*  6950 */   611,  348,  653,  611,  710,  460,  611,  490,  694,  611,
 /*  6960 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  6970 */   611,  611,  611,  611,  569,  611,  611,  611,  348,  653,
 /*  6980 */   611,  710,  460,  611,  438,  694,  611,  611,  611,  410,
 /*  6990 */   335,  181,  622,  613,  629,  611,  540,  611,  611,  611,
 /*  7000 */   611,  611,  611,  611,  108,   90,  100,  102,  712,  611,
 /*  7010 */   611,  438,  611,  611,  611,  611,  410,  335,  181,  622,
 /*  7020 */   613,  629,  611,  540,  611,  611,  611,  611,  611,  611,
 /*  7030 */   543,  108,   90,  100,  102,  712,  211,  611,  611,  611,
 /*  7040 */   269,  444,  611,  611,  611,  611,  611,  611,  611,  536,
 /*  7050 */   322,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  7060 */   611,  490,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  7070 */   611,  611,  611,  611,  611,  572,  611,  611,  569,  611,
 /*  7080 */   611,  611,  348,  653,  611,  710,  460,  611,  611,  694,
 /*  7090 */   611,  611,  611,  611,  611,  438,  611,  611,  611,  611,
 /*  7100 */   410,  335,  181,  622,  613,  629,  611,  540,  273,  611,
 /*  7110 */   611,  611,  611,  611,  611,  438,  611,  536,  322,  611,
 /*  7120 */   410,  335,  181,  622,  613,  629,  611,  540,  611,  490,
 /*  7130 */   611,  611,  611,  611,  611,  108,   90,  100,  102,  712,
 /*  7140 */   611,  611,  611,  611,  611,  611,  569,  611,  611,  611,
 /*  7150 */   348,  653,  611,  710,  460,  611,  611,  694,  611,  611,
 /*  7160 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  7170 */   611,  611,  611,  611,  611,  311,  611,  611,  611,  611,
 /*  7180 */   611,  611,  611,  438,  536,  322,  611,  611,  410,  335,
 /*  7190 */   181,  622,  613,  629,  611,  540,  490,  611,  611,  611,
 /*  7200 */   611,  611,  611,  108,   90,  100,  102,  712,  611,  611,
 /*  7210 */   611,  611,  611,  569,  611,  611,  611,  348,  653,  611,
 /*  7220 */   710,  460,  611,  611,  694,  611,  611,  611,  611,  611,
 /*  7230 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  7240 */   611,  611,  611,  363,  611,  611,  611,  611,  611,  611,
 /*  7250 */   438,  611,  536,  322,  611,  410,  335,  181,  622,  613,
 /*  7260 */   629,  611,  540,  611,  490,  611,  611,  611,  611,  611,
 /*  7270 */   108,   90,  100,  102,  712,  611,  611,  611,  611,  611,
 /*  7280 */   611,  569,  611,  611,  611,  348,  653,  611,  710,  460,
 /*  7290 */   611,  611,  694,  611,  611,  611,  611,  611,  611,  543,
 /*  7300 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  7310 */   444,  312,  611,  611,  611,  611,  611,  611,  438,  611,
 /*  7320 */   536,  322,  611,  410,  335,  181,  622,  613,  629,  611,
 /*  7330 */   540,  611,  490,  611,  611,  611,  611,  611,  108,   90,
 /*  7340 */   100,  102,  712,  611,  571,  611,  611,  611,  611,  569,
 /*  7350 */   611,  611,  611,  348,  653,  611,  710,  460,  611,  611,
 /*  7360 */   694,  611,  611,  611,  438,  611,  611,  611,  543,  410,
 /*  7370 */   335,  181,  622,  613,  629,  611,  540,  611,  292,  444,
 /*  7380 */   611,  611,  611,  611,  611,  611,  438,  536,  322,  611,
 /*  7390 */   611,  410,  335,  181,  622,  613,  629,  611,  540,  490,
 /*  7400 */   611,  611,  611,  611,  611,  611,  108,   90,  100,  102,
 /*  7410 */   712,  611,  611,  587,  611,  611,  569,  611,  611,  611,
 /*  7420 */   348,  653,  611,  710,  460,  611,  611,  694,  611,  611,
 /*  7430 */   611,  611,  611,  438,  611,  611,  543,  611,  410,  335,
 /*  7440 */   181,  622,  613,  629,  611,  540,  306,  444,  611,  611,
 /*  7450 */   611,  611,  611,  438,  611,  536,  322,  611,  410,  335,
 /*  7460 */   181,  622,  613,  629,  611,  540,  611,  490,  611,  611,
 /*  7470 */   611,  611,  611,  108,   90,  100,  102,  712,  611,  611,
 /*  7480 */   611,  588,  611,  611,  569,  611,  611,  611,  348,  653,
 /*  7490 */   611,  710,  460,  611,  611,  694,  611,  611,  611,  611,
 /*  7500 */   611,  438,  611,  611,  611,  543,  410,  335,  181,  622,
 /*  7510 */   613,  629,  611,  540,  302,  611,  444,  611,  611,  611,
 /*  7520 */   611,  438,  611,  536,  322,  611,  410,  335,  181,  622,
 /*  7530 */   613,  629,  611,  540,  611,  490,  611,  611,  611,  611,
 /*  7540 */   611,  108,   90,  100,  102,  712,  611,  611,  611,  611,
 /*  7550 */   582,  611,  569,  611,  611,  611,  348,  653,  611,  710,
 /*  7560 */   460,  611,  611,  694,  611,  611,  611,  611,  611,  611,
 /*  7570 */   438,  611,  611,  543,  611,  410,  335,  181,  622,  613,
 /*  7580 */   629,  364,  540,  611,  444,  611,  611,  611,  611,  438,
 /*  7590 */   536,  322,  611,  611,  410,  335,  181,  622,  613,  629,
 /*  7600 */   611,  540,  490,  611,  611,  611,  611,  611,  611,  108,
 /*  7610 */    90,  100,  102,  712,  611,  611,  611,  611,  539,  569,
 /*  7620 */   611,  611,  611,  348,  653,  611,  710,  460,  611,  611,
 /*  7630 */   694,  611,  611,  611,  611,  611,  611,  611,  438,  611,
 /*  7640 */   611,  611,  611,  410,  335,  181,  622,  613,  629,  384,
 /*  7650 */   540,  611,  611,  611,  611,  611,  438,  611,  536,  322,
 /*  7660 */   611,  410,  335,  181,  622,  613,  629,  611,  540,  611,
 /*  7670 */   490,  611,  611,  611,  611,  611,  108,   90,  100,  102,
 /*  7680 */   712,  611,  611,  611,  611,  611,  611,  569,  611,  611,
 /*  7690 */   611,  348,  653,  611,  710,  460,  611,  611,  694,  611,
 /*  7700 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  7710 */   611,  611,  611,  611,  611,  611,  611,  266,  611,  611,
 /*  7720 */   611,  611,  611,  611,  438,  611,  536,  322,  611,  410,
 /*  7730 */   335,  181,  622,  613,  629,  611,  540,  611,  490,  611,
 /*  7740 */   611,  611,  611,  611,  108,   90,  100,  102,  712,  611,
 /*  7750 */   611,  611,  611,  611,  611,  569,  611,  611,  611,  348,
 /*  7760 */   653,  611,  710,  460,  611,  611,  694,  611,  611,  611,
 /*  7770 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  7780 */   611,  611,  611,  611,  618,  611,  611,  611,  611,  611,
 /*  7790 */   611,  611,  438,  536,  322,  611,  611,  410,  335,  181,
 /*  7800 */   622,  613,  629,  611,  540,  490,  611,  611,  611,  611,
 /*  7810 */   611,  611,  108,   90,  100,  102,  712,  611,  611,  611,
 /*  7820 */   611,  611,  569,  611,  611,  611,  348,  653,  611,  710,
 /*  7830 */   460,  611,  611,  694,  611,  611,  611,  611,  611,  611,
 /*  7840 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  7850 */   611,  611,  327,  611,  611,  611,  611,  611,  611,  438,
 /*  7860 */   611,  536,  322,  611,  410,  335,  181,  622,  613,  629,
 /*  7870 */   611,  540,  611,  490,  611,  611,  611,  611,  611,  108,
 /*  7880 */    90,  100,  102,  712,  611,  611,  611,  611,  611,  611,
 /*  7890 */   569,  611,  611,  611,  348,  653,  611,  710,  460,  611,
 /*  7900 */   611,  694,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  7910 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  7920 */   620,  611,  611,  611,  611,  611,  611,  438,  611,  536,
 /*  7930 */   322,  611,  410,  335,  181,  622,  613,  629,  611,  540,
 /*  7940 */   611,  490,  611,  611,  611,  611,  611,  108,   90,  100,
 /*  7950 */   102,  712,  611,  611,  611,  611,  611,  611,  569,  611,
 /*  7960 */   611,  611,  348,  653,  611,  710,  460,  611,  611,  694,
 /*  7970 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  7980 */   611,  611,  611,  611,  611,  611,  611,  709,  611,  611,
 /*  7990 */   611,  611,  611,  611,  611,  438,  536,  322,  611,  611,
 /*  8000 */   410,  335,  181,  622,  613,  629,  611,  540,  490,  611,
 /*  8010 */   611,  611,  611,  611,  611,  108,   90,  100,  102,  712,
 /*  8020 */   611,  611,  611,  611,  611,  569,  611,  611,  611,  348,
 /*  8030 */   653,  611,  710,  460,  611,  611,  694,  611,  611,  611,
 /*  8040 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  8050 */   611,  611,  611,  611,  611,  188,  611,  611,  611,  611,
 /*  8060 */   611,  611,  438,  611,  536,  322,  611,  410,  335,  181,
 /*  8070 */   622,  613,  629,  611,  540,  611,  490,  611,  611,  611,
 /*  8080 */   611,  611,  108,   90,  100,  102,  712,  611,  611,  611,
 /*  8090 */   611,  611,  611,  569,  611,  611,  611,  348,  653,  611,
 /*  8100 */   710,  460,  611,  611,  694,  611,  611,  611,  611,  611,
 /*  8110 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  8120 */   611,  611,  611,  616,  611,  611,  611,  611,  611,  611,
 /*  8130 */   438,  611,  536,  322,  611,  410,  335,  181,  622,  613,
 /*  8140 */   629,  611,  540,  611,  490,  611,  611,  611,  611,  611,
 /*  8150 */   108,   90,  100,  102,  712,  611,  611,  611,  611,  611,
 /*  8160 */   611,  569,  611,  611,  611,  348,  653,  611,  710,  460,
 /*  8170 */   611,  611,  694,  611,  611,  611,  611,  611,  611,  611,
 /*  8180 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  8190 */   313,  611,  611,  611,  611,  611,  611,  611,  438,  536,
 /*  8200 */   322,  611,  611,  410,  335,  181,  622,  613,  629,  611,
 /*  8210 */   540,  490,  611,  611,  611,  611,  611,  611,  108,   90,
 /*  8220 */   100,  102,  712,  611,  611,  611,  611,  611,  569,  611,
 /*  8230 */   611,  611,  348,  653,  611,  710,  460,  611,  611,  694,
 /*  8240 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  8250 */   611,  611,  611,  611,  611,  611,  611,  611,  324,  611,
 /*  8260 */   611,  611,  611,  611,  611,  438,  611,  536,  322,  611,
 /*  8270 */   410,  335,  181,  622,  613,  629,  611,  540,  611,  490,
 /*  8280 */   611,  611,  611,  611,  611,  108,   90,  100,  102,  712,
 /*  8290 */   611,  611,  611,  611,  611,  611,  569,  611,  611,  611,
 /*  8300 */   348,  653,  611,  710,  460,  611,  611,  694,  611,  611,
 /*  8310 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  8320 */   611,  611,  611,  611,  611,  611,  295,  611,  611,  611,
 /*  8330 */   611,  611,  611,  438,  611,  536,  322,  611,  410,  335,
 /*  8340 */   181,  622,  613,  629,  611,  540,  611,  490,  611,  611,
 /*  8350 */   611,  611,  611,  108,   90,  100,  102,  712,  611,  611,
 /*  8360 */   611,  611,  611,  611,  569,  611,  611,  611,  348,  653,
 /*  8370 */   611,  710,  460,  611,  611,  694,  611,  611,  611,  611,
 /*  8380 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  8390 */   611,  611,  611,  262,  611,  611,  611,  611,  611,  611,
 /*  8400 */   611,  438,  536,  322,  611,  611,  410,  335,  181,  622,
 /*  8410 */   613,  629,  611,  540,  490,  611,  611,  611,  611,  611,
 /*  8420 */   611,  108,   90,  100,  102,  712,  611,  611,  611,  611,
 /*  8430 */   611,  569,  611,  611,  611,  348,  653,  611,  710,  460,
 /*  8440 */   611,  611,  694,  611,  611,  611,  611,  611,  611,  611,
 /*  8450 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  8460 */   611,  259,  611,  611,  611,  611,  611,  611,  438,  611,
 /*  8470 */   536,  322,  611,  410,  335,  181,  622,  613,  629,  611,
 /*  8480 */   540,  611,  490,  611,  611,  611,  611,  611,  108,   90,
 /*  8490 */   100,  102,  712,  611,  611,  611,  611,  611,  611,  569,
 /*  8500 */   611,  611,  611,  348,  653,  611,  710,  460,  611,  611,
 /*  8510 */   694,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  8520 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  329,
 /*  8530 */   611,  611,  611,  611,  611,  611,  438,  611,  536,  322,
 /*  8540 */   611,  410,  335,  181,  622,  613,  629,  611,  540,  611,
 /*  8550 */   490,  611,  611,  611,  611,  611,  108,   90,  100,  102,
 /*  8560 */   712,  611,  611,  611,  611,  611,  611,  569,  611,  611,
 /*  8570 */   611,  348,  653,  611,  710,  460,  611,  611,  694,  611,
 /*  8580 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  8590 */   611,  611,  611,  611,  611,  611,  429,  611,  611,  611,
 /*  8600 */   611,  611,  611,  611,  438,  536,  322,  611,  611,  410,
 /*  8610 */   335,  181,  622,  613,  629,  611,  540,  490,  611,  611,
 /*  8620 */   611,  611,  611,  611,  108,   90,  100,  102,  712,  611,
 /*  8630 */   611,  611,  611,  611,  569,  611,  611,  611,  348,  653,
 /*  8640 */   611,  710,  460,  611,  611,  694,  611,  611,  611,  611,
 /*  8650 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  8660 */   611,  611,  611,  611,  330,  611,  611,  611,  611,  611,
 /*  8670 */   611,  438,  611,  536,  322,  611,  410,  335,  181,  622,
 /*  8680 */   613,  629,  611,  540,  611,  490,  611,  611,  611,  611,
 /*  8690 */   611,  108,   90,  100,  102,  712,  611,  611,  611,  611,
 /*  8700 */   611,  611,  569,  611,  611,  611,  348,  653,  611,  710,
 /*  8710 */   460,  611,  611,  694,  611,  611,  611,  611,  611,  611,
 /*  8720 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  8730 */   611,  611,  333,  611,  611,  611,  611,  611,  611,  438,
 /*  8740 */   611,  536,  322,  611,  410,  335,  181,  622,  613,  629,
 /*  8750 */   611,  540,  611,  490,  611,  611,  611,  611,  611,  108,
 /*  8760 */    90,  100,  102,  712,  611,  611,  611,  611,  611,  611,
 /*  8770 */   569,  611,  611,  611,  348,  653,  611,  710,  460,  611,
 /*  8780 */   611,  694,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  8790 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  599,
 /*  8800 */   611,  611,  611,  611,  611,  611,  611,  438,  536,  322,
 /*  8810 */   611,  611,  410,  335,  181,  622,  613,  629,  611,  540,
 /*  8820 */   490,  611,  611,  611,  611,  611,  611,  108,   90,  100,
 /*  8830 */   102,  712,  611,  611,  611,  611,  611,  569,  611,  611,
 /*  8840 */   611,  348,  653,  611,  710,  460,  611,  611,  694,  611,
 /*  8850 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  8860 */   611,  611,  611,  611,  611,  611,  611,  609,  611,  611,
 /*  8870 */   611,  611,  611,  611,  438,  611,  536,  322,  611,  410,
 /*  8880 */   335,  181,  622,  613,  629,  611,  540,  611,  490,  611,
 /*  8890 */   611,  611,  611,  611,  108,   90,  100,  102,  712,  611,
 /*  8900 */   611,  611,  611,  611,  611,  569,  611,  611,  611,  348,
 /*  8910 */   653,  611,  710,  460,  611,  611,  694,  611,  611,  611,
 /*  8920 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  8930 */   611,  611,  611,  611,  611,  257,  611,  611,  611,  611,
 /*  8940 */   611,  611,  438,  611,  536,  322,  611,  410,  335,  181,
 /*  8950 */   622,  613,  629,  611,  540,  611,  490,  611,  611,  611,
 /*  8960 */   611,  611,  108,   90,  100,  102,  712,  611,  611,  611,
 /*  8970 */   611,  611,  611,  569,  611,  611,  611,  348,  653,  611,
 /*  8980 */   710,  460,  611,  611,  694,  611,  611,  611,  611,  611,
 /*  8990 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  9000 */   611,  611,  258,  611,  611,  611,  611,  611,  611,  611,
 /*  9010 */   438,  536,  322,  611,  611,  410,  335,  181,  622,  613,
 /*  9020 */   629,  611,  540,  490,  611,  611,  611,  611,  611,  611,
 /*  9030 */   108,   90,  100,  102,  712,  611,  611,  611,  611,  611,
 /*  9040 */   569,  611,  611,  611,  348,  653,  611,  710,  460,  611,
 /*  9050 */   611,  694,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  9060 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  9070 */   276,  611,  611,  611,  611,  611,  611,  438,  611,  536,
 /*  9080 */   322,  611,  410,  335,  181,  622,  613,  629,  611,  540,
 /*  9090 */   611,  490,  611,  611,  611,  611,  611,  108,   90,  100,
 /*  9100 */   102,  712,  611,  611,  611,  611,  611,  611,  569,  611,
 /*  9110 */   611,  611,  348,  653,  611,  710,  460,  611,  611,  694,
 /*  9120 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  9130 */   611,  611,  611,  611,  611,  611,  611,  611,  323,  611,
 /*  9140 */   611,  611,  611,  611,  611,  438,  611,  536,  322,  611,
 /*  9150 */   410,  335,  181,  622,  613,  629,  611,  540,  611,  490,
 /*  9160 */   611,  611,  611,  611,  611,  108,   90,  100,  102,  712,
 /*  9170 */   611,  611,  611,  611,  611,  611,  569,  611,  611,  611,
 /*  9180 */   348,  653,  611,  710,  460,  611,  611,  694,  611,  611,
 /*  9190 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  9200 */   611,  611,  611,  611,  611,  260,  611,  611,  611,  611,
 /*  9210 */   611,  611,  611,  438,  536,  322,  611,  611,  410,  335,
 /*  9220 */   181,  622,  613,  629,  611,  540,  490,  611,  611,  611,
 /*  9230 */   611,  611,  611,  108,   90,  100,  102,  712,  611,  611,
 /*  9240 */   611,  611,  611,  569,  611,  611,  611,  348,  653,  611,
 /*  9250 */   710,  460,  611,  611,  694,  611,  611,  611,  611,  611,
 /*  9260 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  9270 */   611,  611,  611,  261,  611,  611,  611,  611,  611,  611,
 /*  9280 */   438,  611,  536,  322,  611,  410,  335,  181,  622,  613,
 /*  9290 */   629,  611,  540,  611,  490,  611,  611,  611,  611,  611,
 /*  9300 */   108,   90,  100,  102,  712,  611,  611,  611,  611,  611,
 /*  9310 */   611,  569,  611,  611,  611,  348,  653,  611,  710,  460,
 /*  9320 */   611,  611,  694,  611,  611,  611,  611,  611,  611,  611,
 /*  9330 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  9340 */   611,  265,  611,  611,  611,  611,  611,  611,  438,  611,
 /*  9350 */   536,  322,  611,  410,  335,  181,  622,  613,  629,  611,
 /*  9360 */   540,  611,  490,  611,  611,  611,  611,  611,  108,   90,
 /*  9370 */   100,  102,  712,  611,  611,  611,  611,  611,  611,  569,
 /*  9380 */   611,  611,  611,  348,  653,  611,  710,  460,  611,  611,
 /*  9390 */   694,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  9400 */   611,  611,  611,  611,  611,  611,  611,  611,  274,  611,
 /*  9410 */   611,  611,  611,  611,  611,  611,  438,  536,  322,  611,
 /*  9420 */   611,  410,  335,  181,  622,  613,  629,  611,  540,  490,
 /*  9430 */   611,  611,  611,  611,  611,  611,  108,   90,  100,  102,
 /*  9440 */   712,  611,  611,  611,  611,  611,  569,  611,  611,  611,
 /*  9450 */   348,  653,  611,  710,  460,  611,  611,  694,  611,  611,
 /*  9460 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  9470 */   611,  611,  611,  611,  611,  611,  275,  611,  611,  611,
 /*  9480 */   611,  611,  611,  438,  611,  536,  322,  611,  410,  335,
 /*  9490 */   181,  622,  613,  629,  611,  540,  611,  490,  611,  611,
 /*  9500 */   611,  611,  611,  108,   90,  100,  102,  712,  611,  611,
 /*  9510 */   611,  611,  611,  611,  569,  611,  611,  611,  348,  653,
 /*  9520 */   611,  710,  460,  611,  611,  694,  611,  611,  611,  611,
 /*  9530 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  9540 */   611,  611,  611,  611,  286,  611,  611,  611,  611,  611,
 /*  9550 */   611,  438,  611,  343,  318,  611,  410,  335,  181,  622,
 /*  9560 */   613,  629,  611,  540,  611,  490,  611,  611,  611,  611,
 /*  9570 */   611,  108,   90,  100,  102,  712,  611,  611,  611,  611,
 /*  9580 */   611,  611,  569,  611,  611,  611,  348,  653,  611,  710,
 /*  9590 */   460,  611,  611,  694,  611,  611,  611,  611,  611,  611,
 /*  9600 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  9610 */   611,  298,  611,  611,  611,  611,  611,  611,  611,  438,
 /*  9620 */   536,  322,  611,  611,  410,  335,  181,  622,  613,  629,
 /*  9630 */   611,  540,  490,  611,  611,  611,  611,  611,  611,  108,
 /*  9640 */    90,  100,  102,  712,  611,  611,  611,  611,  611,  569,
 /*  9650 */   611,  611,  611,  348,  653,  611,  710,  460,  611,  611,
 /*  9660 */   694,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  9670 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  284,
 /*  9680 */   611,  611,  611,  611,  611,  611,  438,  611,  536,  322,
 /*  9690 */   611,  410,  335,  181,  622,  613,  629,  611,  540,  611,
 /*  9700 */   490,  611,  611,  611,  611,  611,  108,   90,  100,  102,
 /*  9710 */   712,  611,  611,  611,  611,  611,  611,  569,  611,  611,
 /*  9720 */   611,  348,  653,  611,  710,  460,  611,  611,  694,  611,
 /*  9730 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  9740 */   611,  611,  611,  611,  611,  611,  611,  286,  611,  611,
 /*  9750 */   611,  611,  611,  611,  438,  611,  467,  321,  611,  410,
 /*  9760 */   335,  181,  622,  613,  629,  611,  540,  611,  490,  611,
 /*  9770 */   611,  611,  611,  611,  108,   90,  100,  102,  712,  611,
 /*  9780 */   611,  611,  611,  611,  611,  569,  611,  611,  611,  348,
 /*  9790 */   653,  611,  710,  460,  611,  611,  694,  611,  611,  611,
 /*  9800 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  9810 */   611,  611,  611,  611,  287,  611,  611,  611,  611,  611,
 /*  9820 */   611,  611,  438,  536,  322,  611,  611,  410,  335,  181,
 /*  9830 */   622,  613,  629,  611,  540,  490,  611,  611,  611,  611,
 /*  9840 */   611,  611,  108,   90,  100,  102,  712,  611,  611,  611,
 /*  9850 */   611,  611,  569,  611,  611,  611,  348,  653,  611,  710,
 /*  9860 */   460,  611,  611,  694,  611,  611,  611,  611,  611,  611,
 /*  9870 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  9880 */   611,  611,  326,  611,  611,  611,  611,  611,  611,  438,
 /*  9890 */   611,  536,  322,  611,  410,  335,  181,  622,  613,  629,
 /*  9900 */   611,  540,  611,  490,  611,  611,  611,  611,  611,  108,
 /*  9910 */    90,  100,  102,  712,  611,  611,  611,  611,  611,  611,
 /*  9920 */   569,  611,  611,  611,  348,  653,  611,  710,  460,  611,
 /*  9930 */   611,  694,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  9940 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*  9950 */   325,  611,  611,  611,  611,  611,  611,  438,  611,  536,
 /*  9960 */   322,  611,  410,  335,  181,  622,  613,  629,  611,  540,
 /*  9970 */   611,  490,  611,  611,  611,  611,  611,  108,   90,  100,
 /*  9980 */   102,  712,  611,  611,  611,  611,  611,  611,  569,  611,
 /*  9990 */   611,  611,  348,  653,  611,  710,  460,  611,  611,  694,
 /* 10000 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 10010 */   611,  611,  611,  611,  611,  611,  611,  328,  611,  611,
 /* 10020 */   611,  611,  611,  611,  611,  438,  536,  322,  611,  611,
 /* 10030 */   410,  335,  181,  622,  613,  629,  611,  540,  490,  611,
 /* 10040 */   611,  611,  611,  611,  611,  108,   90,  100,  102,  712,
 /* 10050 */   611,  611,  611,  611,  611,  569,  611,  611,  611,  348,
 /* 10060 */   653,  611,  710,  460,  611,  611,  694,  611,  611,  611,
 /* 10070 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 10080 */   611,  611,  611,  611,  611,  304,  611,  611,  611,  611,
 /* 10090 */   611,  611,  438,  611,  536,  322,  611,  410,  335,  181,
 /* 10100 */   622,  613,  629,  611,  540,  611,  490,  611,  611,  611,
 /* 10110 */   611,  611,  108,   90,  100,  102,  712,  611,  611,  611,
 /* 10120 */   611,  611,  611,  569,  611,  611,  611,  348,  653,  611,
 /* 10130 */   710,  460,  611,  611,  694,  611,  611,  611,  611,  611,
 /* 10140 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 10150 */   611,  611,  611,  317,  611,  611,  611,  611,  611,  611,
 /* 10160 */   438,  611,  536,  322,  611,  410,  335,  181,  622,  613,
 /* 10170 */   629,  611,  540,  611,  490,  611,  611,  611,  611,  611,
 /* 10180 */   108,   90,  100,  102,  712,  611,  611,  611,  611,  611,
 /* 10190 */   611,  569,  611,  611,  611,  348,  653,  611,  710,  460,
 /* 10200 */   611,  611,  694,  611,  611,  611,  611,  611,  611,  611,
 /* 10210 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 10220 */   316,  611,  611,  611,  611,  611,  611,  611,  438,  536,
 /* 10230 */   322,  611,  611,  410,  335,  181,  622,  613,  629,  611,
 /* 10240 */   540,  490,  611,  611,  611,  611,  611,  611,  108,   90,
 /* 10250 */   100,  102,  712,  611,  611,  611,  611,  611,  569,  611,
 /* 10260 */   611,  611,  348,  653,  611,  710,  460,  611,  611,  694,
 /* 10270 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 10280 */   611,  611,  611,  611,  611,  611,  611,  611,  267,  611,
 /* 10290 */   611,  611,  611,  611,  611,  438,  611,  536,  322,  611,
 /* 10300 */   410,  335,  181,  622,  613,  629,  611,  540,  611,  490,
 /* 10310 */   611,  611,  611,  611,  611,  108,   90,  100,  102,  712,
 /* 10320 */   611,  611,  611,  611,  611,  611,  569,  611,  611,  611,
 /* 10330 */   348,  653,  611,  710,  460,  611,  611,  694,  611,  611,
 /* 10340 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 10350 */   611,  611,  611,  611,  611,  611,  315,  611,  611,  611,
 /* 10360 */   611,  611,  611,  438,  611,  536,  322,  611,  410,  335,
 /* 10370 */   181,  622,  613,  629,  611,  540,  611,  490,  611,  611,
 /* 10380 */   611,  611,  611,  108,   90,  100,  102,  712,  611,  611,
 /* 10390 */   611,  611,  611,  611,  569,  611,  611,  611,  348,  653,
 /* 10400 */   611,  710,  460,  611,  611,  694,  611,  611,  611,  611,
 /* 10410 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 10420 */   611,  611,  611,  286,  611,  611,  611,  611,  611,  611,
 /* 10430 */   611,  438,  401,  320,  611,  611,  410,  335,  181,  622,
 /* 10440 */   613,  629,  611,  540,  490,  611,  611,  611,  611,  611,
 /* 10450 */   611,  108,   90,  100,  102,  712,  611,  611,  611,  611,
 /* 10460 */   611,  569,  611,  611,  611,  348,  653,  611,  710,  460,
 /* 10470 */   611,  611,  694,  611,  611,  611,  611,  611,  611,  611,
 /* 10480 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 10490 */   611,  268,  611,  611,  611,  611,  611,  611,  438,  611,
 /* 10500 */   536,  322,  611,  410,  335,  181,  622,  613,  629,  611,
 /* 10510 */   540,  611,  490,  611,  611,  611,  611,  611,  108,   90,
 /* 10520 */   100,  102,  712,  611,  611,  611,  611,  611,  611,  569,
 /* 10530 */   611,  611,  611,  348,  653,  611,  710,  460,  611,  611,
 /* 10540 */   694,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 10550 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  272,
 /* 10560 */   611,  611,  611,  611,  611,  611,  438,  611,  536,  322,
 /* 10570 */   611,  410,  335,  181,  622,  613,  629,  611,  540,  611,
 /* 10580 */   490,  611,  611,  611,  611,  611,  108,   90,  100,  102,
 /* 10590 */   712,  611,  611,  611,  611,  611,  611,  569,  611,  611,
 /* 10600 */   611,  348,  653,  611,  710,  460,  611,  611,  694,  611,
 /* 10610 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 10620 */   611,  611,  611,  611,  611,  611,  634,  611,  611,  611,
 /* 10630 */   611,  611,  611,  611,  438,  536,  322,  611,  611,  410,
 /* 10640 */   335,  181,  622,  613,  629,  611,  540,  490,  611,  611,
 /* 10650 */   611,  611,  611,  611,  108,   90,  100,  102,  712,  611,
 /* 10660 */   611,  611,  611,  611,  569,  611,  611,  611,  348,  653,
 /* 10670 */   611,  710,  460,  611,  611,  694,  611,  611,  611,  611,
 /* 10680 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 10690 */   611,  611,  611,  611,  308,  611,  611,  611,  611,  611,
 /* 10700 */   611,  438,  611,  536,  322,  611,  410,  335,  181,  622,
 /* 10710 */   613,  629,  611,  540,  611,  490,  611,  611,  611,  611,
 /* 10720 */   611,  108,   90,  100,  102,  712,  611,  611,  611,  611,
 /* 10730 */   611,  611,  569,  611,  611,  611,  348,  653,  611,  710,
 /* 10740 */   460,  611,  611,  694,  611,  611,  611,  611,  611,  611,
 /* 10750 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 10760 */   611,  611,  310,  611,  611,  611,  611,  611,  611,  438,
 /* 10770 */   611,  536,  322,  611,  410,  335,  181,  622,  613,  629,
 /* 10780 */   611,  540,  611,  490,  611,  611,  611,  611,  611,  108,
 /* 10790 */    90,  100,  102,  712,  611,  611,  611,  611,  611,  611,
 /* 10800 */   569,  611,  611,  611,  348,  653,  611,  710,  460,  611,
 /* 10810 */   611,  694,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 10820 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  279,
 /* 10830 */   611,  611,  611,  611,  611,  611,  611,  438,  536,  322,
 /* 10840 */   611,  611,  410,  335,  181,  622,  613,  629,  611,  540,
 /* 10850 */   490,  611,  611,  611,  611,  611,  611,  108,   90,  100,
 /* 10860 */   102,  712,  611,  611,  611,  611,  611,  569,  611,  611,
 /* 10870 */   611,  348,  653,  611,  710,  460,  611,  611,  694,  611,
 /* 10880 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 10890 */   611,  611,  611,  611,  611,  611,  611,  280,  611,  611,
 /* 10900 */   611,  611,  611,  611,  438,  611,  536,  322,  611,  410,
 /* 10910 */   335,  181,  622,  613,  629,  611,  540,  611,  490,  611,
 /* 10920 */   611,  611,  611,  611,  108,   90,  100,  102,  712,  611,
 /* 10930 */   611,  611,  611,  611,  611,  569,  611,  611,  611,  348,
 /* 10940 */   653,  611,  710,  460,  611,  611,  694,  611,  611,  611,
 /* 10950 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 10960 */   611,  611,  611,  611,  611,  285,  611,  611,  611,  611,
 /* 10970 */   611,  611,  438,  611,  536,  322,  611,  410,  335,  181,
 /* 10980 */   622,  613,  629,  611,  540,  611,  490,  611,  611,  611,
 /* 10990 */   611,  611,  108,   90,  100,  102,  712,  611,  611,  611,
 /* 11000 */   611,  611,  611,  569,  611,  611,  611,  348,  653,  611,
 /* 11010 */   710,  460,  611,  611,  694,  611,  611,  611,  611,  611,
 /* 11020 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 11030 */   611,  611,  278,  611,  611,  611,  611,  611,  611,  611,
 /* 11040 */   438,  536,  322,  611,  611,  410,  335,  181,  622,  613,
 /* 11050 */   629,  611,  540,  490,  611,  611,  611,  611,  611,  611,
 /* 11060 */   108,   90,  100,  102,  712,  611,  611,  611,  611,  611,
 /* 11070 */   569,  611,  611,  611,  348,  653,  611,  710,  460,  611,
 /* 11080 */   611,  694,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 11090 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 11100 */   293,  611,  611,  611,  611,  611,  611,  438,  611,  536,
 /* 11110 */   322,  611,  410,  335,  181,  622,  613,  629,  611,  540,
 /* 11120 */   611,  490,  611,  611,  611,  611,  611,  108,   90,  100,
 /* 11130 */   102,  712,  611,  611,  611,  611,  611,  611,  569,  611,
 /* 11140 */   611,  611,  348,  653,  611,  710,  460,  611,  611,  694,
 /* 11150 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 11160 */   611,  611,  611,  611,  611,  611,  611,  611,  256,  611,
 /* 11170 */   611,  611,  611,  611,  611,  438,  611,  536,  322,  611,
 /* 11180 */   410,  335,  181,  622,  613,  629,  611,  540,  611,  490,
 /* 11190 */   611,  611,  611,  611,  611,  108,   90,  100,  102,  712,
 /* 11200 */   611,  611,  611,  611,  611,  611,  569,  611,  611,  611,
 /* 11210 */   348,  653,  611,  710,  460,  611,  611,  694,  611,  611,
 /* 11220 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 11230 */   611,  611,  611,  611,  611,  271,  611,  611,  611,  611,
 /* 11240 */   611,  611,  611,  438,  536,  322,  611,  611,  410,  335,
 /* 11250 */   181,  622,  613,  629,  611,  540,  490,  611,  611,  611,
 /* 11260 */   611,  611,  611,  108,   90,  100,  102,  712,  611,  611,
 /* 11270 */   611,  611,  611,  569,  611,  611,  611,  348,  653,  611,
 /* 11280 */   710,  460,  611,  611,  694,  611,  611,  611,  611,  611,
 /* 11290 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 11300 */   611,  611,  611,  263,  611,  611,  611,  611,  611,  611,
 /* 11310 */   438,  611,  536,  322,  611,  410,  335,  181,  622,  613,
 /* 11320 */   629,  611,  540,  611,  490,  611,  611,  611,  611,  611,
 /* 11330 */   108,   90,  100,  102,  712,  611,  611,  611,  611,  611,
 /* 11340 */   611,  569,  611,  611,  611,  348,  653,  611,  710,  460,
 /* 11350 */   611,  611,  694,  611,  611,  611,  611,  611,  611,  611,
 /* 11360 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 11370 */   611,  300,  611,  611,  611,  611,  611,  611,  438,  611,
 /* 11380 */   536,  322,  611,  410,  335,  181,  622,  613,  629,  611,
 /* 11390 */   540,  611,  490,  611,  611,  611,  611,  611,  108,   90,
 /* 11400 */   100,  102,  712,  611,  611,  611,  611,  611,  611,  569,
 /* 11410 */   611,  611,  611,  348,  653,  611,  710,  460,  611,  611,
 /* 11420 */   694,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 11430 */   611,  611,  611,  611,  611,  611,  611,  611,  301,  611,
 /* 11440 */   611,  611,  611,  611,  611,  611,  438,  536,  322,  611,
 /* 11450 */   611,  410,  335,  181,  622,  613,  629,  611,  540,  490,
 /* 11460 */   611,  611,  611,  611,  611,  611,  108,   90,  100,  102,
 /* 11470 */   712,  611,  611,  611,  611,  611,  569,  611,  611,  611,
 /* 11480 */   348,  653,  611,  710,  460,  611,  611,  694,  611,  611,
 /* 11490 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 11500 */   611,  611,  611,  611,  611,  611,  297,  611,  611,  611,
 /* 11510 */   611,  611,  611,  438,  611,  536,  322,  611,  410,  335,
 /* 11520 */   181,  622,  613,  629,  611,  540,  611,  490,  611,  611,
 /* 11530 */   611,  611,  611,  108,   90,  100,  102,  712,  611,  611,
 /* 11540 */   611,  611,  611,  611,  569,  611,  611,  611,  348,  653,
 /* 11550 */   611,  710,  460,  611,  611,  694,  611,  611,  611,  611,
 /* 11560 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 11570 */   611,  611,  611,  611,  299,  611,  611,  611,  611,  611,
 /* 11580 */   611,  438,  611,  536,  322,  611,  410,  335,  181,  622,
 /* 11590 */   613,  629,  611,  540,  611,  490,  611,  611,  611,  611,
 /* 11600 */   611,  108,   90,  100,  102,  712,  611,  611,  611,  611,
 /* 11610 */   611,  611,  569,  611,  611,  611,  348,  653,  611,  710,
 /* 11620 */   460,  611,  611,  694,  611,  611,  611,  611,  611,  611,
 /* 11630 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 11640 */   611,  294,  611,  611,  611,  611,  611,  611,  611,  438,
 /* 11650 */   536,  322,  611,  611,  410,  335,  181,  622,  613,  629,
 /* 11660 */   611,  540,  490,  611,  611,  611,  611,  611,  611,  108,
 /* 11670 */    90,  100,  102,  712,  611,  611,  611,  611,  611,  569,
 /* 11680 */   611,  611,  611,  348,  653,  611,  710,  460,  611,  611,
 /* 11690 */   694,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 11700 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  296,
 /* 11710 */   611,  611,  611,  611,  611,  611,  438,  611,  536,  322,
 /* 11720 */   611,  410,  335,  181,  622,  613,  629,  611,  540,  611,
 /* 11730 */   490,  611,  611,  611,  611,  611,  108,   90,  100,  102,
 /* 11740 */   712,  611,  611,  611,  611,  611,  611,  569,  611,  611,
 /* 11750 */   611,  348,  653,  611,  710,  460,  611,  611,  694,  611,
 /* 11760 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 11770 */   611,  611,  611,  611,  611,  611,  611,  303,  611,  611,
 /* 11780 */   611,  611,  611,  611,  438,  611,  536,  322,  611,  410,
 /* 11790 */   335,  181,  622,  613,  629,  611,  540,  611,  490,  611,
 /* 11800 */   611,  611,  611,  611,  108,   90,  100,  102,  712,  611,
 /* 11810 */   611,  611,  611,  611,  611,  569,  611,  611,  611,  348,
 /* 11820 */   653,  611,  710,  460,  611,  611,  694,  611,  611,  611,
 /* 11830 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 11840 */   611,  611,  611,  611,  314,  611,  611,  611,  611,  611,
 /* 11850 */   611,  611,  438,  536,  322,  611,  611,  410,  335,  181,
 /* 11860 */   622,  613,  629,  611,  540,  490,  611,  611,  611,  611,
 /* 11870 */   611,  611,  108,   90,  100,  102,  712,  611,  611,  611,
 /* 11880 */   611,  611,  569,  611,  611,  611,  348,  653,  611,  710,
 /* 11890 */   460,  611,  611,  694,  611,  611,  611,  611,  611,  611,
 /* 11900 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 11910 */   611,  611,  282,  611,  611,  611,  611,  611,  611,  438,
 /* 11920 */   611,  536,  322,  611,  410,  335,  181,  622,  613,  629,
 /* 11930 */   611,  540,  611,  490,  611,  611,  611,  611,  611,  108,
 /* 11940 */    90,  100,  102,  712,  611,  611,  611,  611,  611,  611,
 /* 11950 */   569,  611,  611,  611,  348,  653,  611,  710,  460,  611,
 /* 11960 */   611,  694,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 11970 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 11980 */   307,  611,  611,  611,  611,  611,  611,  438,  611,  536,
 /* 11990 */   322,  611,  410,  335,  181,  622,  613,  629,  611,  540,
 /* 12000 */   611,  490,  611,  611,  611,  611,  611,  108,   90,  100,
 /* 12010 */   102,  712,  611,  611,  611,  611,  611,  611,  569,  611,
 /* 12020 */   611,  611,  348,  653,  611,  710,  460,  611,  611,  694,
 /* 12030 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 12040 */   611,  611,  611,  611,  611,  611,  611,  602,  611,  611,
 /* 12050 */   611,  611,  611,  611,  611,  438,  536,  322,  611,  611,
 /* 12060 */   410,  335,  181,  622,  613,  629,  611,  540,  490,  611,
 /* 12070 */   611,  611,  611,  611,  611,  108,   90,  100,  102,  712,
 /* 12080 */   611,  611,  611,  611,  611,  569,  611,  611,  611,  348,
 /* 12090 */   653,  611,  710,  460,  611,  611,  694,  611,  611,  611,
 /* 12100 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 12110 */   611,  611,  611,  611,  611,  270,  611,  611,  611,  611,
 /* 12120 */   611,  611,  438,  611,  536,  322,  611,  410,  335,  181,
 /* 12130 */   622,  613,  629,  611,  540,  611,  490,  611,  611,  611,
 /* 12140 */   611,  611,  108,   90,  100,  102,  712,  611,  611,  611,
 /* 12150 */   611,  611,  611,  569,  611,  611,  611,  348,  653,  611,
 /* 12160 */   710,  460,  611,  611,  694,  611,  611,  611,  611,  611,
 /* 12170 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 12180 */   611,  611,  611,  513,  611,  611,  611,  611,  611,  611,
 /* 12190 */   438,  611,  536,  322,  611,  410,  335,  181,  622,  613,
 /* 12200 */   629,  611,  540,  611,  490,  611,  611,  611,  611,  611,
 /* 12210 */   108,   90,  100,  102,  712,  611,  611,  611,  611,  611,
 /* 12220 */   611,  569,  611,  611,  611,  348,  653,  611,  710,  460,
 /* 12230 */   611,  611,  694,  611,  611,  611,  611,  611,  611,  611,
 /* 12240 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 12250 */   305,  611,  611,  611,  611,  611,  611,  611,  438,  536,
 /* 12260 */   322,  611,  611,  410,  335,  181,  622,  613,  629,  611,
 /* 12270 */   540,  490,  611,  611,  611,  611,  611,  611,  108,   90,
 /* 12280 */   100,  102,  712,  611,  611,  611,  611,  611,  569,  611,
 /* 12290 */   611,  611,  348,  653,  611,  710,  460,  611,  611,  694,
 /* 12300 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 12310 */   611,  611,  611,  611,  611,  611,  611,  611,  291,  611,
 /* 12320 */   611,  611,  611,  611,  611,  438,  611,  536,  322,  611,
 /* 12330 */   410,  335,  181,  622,  613,  629,  611,  540,  611,  490,
 /* 12340 */   611,  611,  611,  611,  611,  108,   90,  100,  102,  712,
 /* 12350 */   611,  611,  611,  611,  611,  611,  569,  611,  611,  611,
 /* 12360 */   348,  653,  611,  710,  460,  611,  611,  694,  611,  611,
 /* 12370 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 12380 */   611,  611,  611,  611,  611,  611,  281,  611,  611,  611,
 /* 12390 */   611,  611,  611,  438,  611,  536,  322,  611,  410,  335,
 /* 12400 */   181,  622,  613,  629,  611,  540,  611,  490,  611,  611,
 /* 12410 */   611,  611,  611,  108,   90,  100,  102,  712,  611,  611,
 /* 12420 */   611,  611,  611,  611,  569,  611,  611,  611,  348,  653,
 /* 12430 */   611,  710,  460,  611,  611,  694,  611,  611,  611,  611,
 /* 12440 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 12450 */   611,  611,  611,  643,  611,  611,  611,  611,  611,  611,
 /* 12460 */   611,  438,  536,  322,  611,  611,  410,  335,  181,  622,
 /* 12470 */   613,  629,  611,  540,  490,  611,  611,  611,  611,  611,
 /* 12480 */   611,  108,   90,  100,  102,  712,  611,  611,  611,  611,
 /* 12490 */   611,  569,  611,  611,  611,  348,  653,  611,  710,  460,
 /* 12500 */   611,  611,  694,  611,  611,  611,  611,  611,  611,  611,
 /* 12510 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 12520 */   611,  309,  611,  611,  611,  611,  611,  611,  438,  611,
 /* 12530 */   536,  322,  611,  410,  335,  181,  622,  613,  629,  611,
 /* 12540 */   540,  611,  490,  611,  611,  611,  611,  611,  108,   90,
 /* 12550 */   100,  102,  712,  611,  611,  611,  611,  611,  611,  569,
 /* 12560 */   611,  611,  611,  348,  653,  611,  710,  460,  611,  611,
 /* 12570 */   694,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 12580 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  605,
 /* 12590 */   611,  611,  611,  611,  611,  611,  438,  611,  536,  322,
 /* 12600 */   611,  410,  335,  181,  622,  613,  629,  611,  540,  611,
 /* 12610 */   490,  611,  611,  611,  611,  611,  108,   90,  100,  102,
 /* 12620 */   712,  611,  611,  611,  611,  611,  611,  569,  611,  611,
 /* 12630 */   611,  348,  653,  611,  710,  460,  611,  611,  694,  611,
 /* 12640 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 12650 */   611,  611,  611,  611,  611,  611,  289,  611,  611,  611,
 /* 12660 */   611,  611,  611,  611,  438,  536,  322,  611,  611,  410,
 /* 12670 */   335,  181,  622,  613,  629,  611,  540,  490,  611,  611,
 /* 12680 */   611,  611,  611,  611,  108,   90,  100,  102,  712,  611,
 /* 12690 */   611,  611,  611,  611,  569,  611,  611,  611,  348,  653,
 /* 12700 */   611,  710,  460,  611,  611,  694,  611,  611,  611,  611,
 /* 12710 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 12720 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /* 12730 */   611,  438,  611,  611,  611,  611,  410,  335,  181,  622,
 /* 12740 */   613,  629,  611,  540,  611,  611,  611,  611,  611,  611,
 /* 12750 */   611,  108,   90,  100,  102,  712,
    );
    static public $yy_lookahead = array(
 /*     0 */     1,    2,    3,    4,    5,  122,  123,  124,   23,   10,
 /*    10 */    25,   26,   27,   28,   29,   30,   31,   32,   33,   34,
 /*    20 */    35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*    30 */    45,   97,   47,   67,   68,   69,   70,   71,   72,   40,
 /*    40 */    41,   74,  202,  203,  204,   46,  206,   48,   49,   50,
 /*    50 */    51,   52,   53,   61,   55,   56,   57,   58,   59,   60,
 /*    60 */   126,   62,   63,  100,    6,   99,   67,   68,   69,   77,
 /*    70 */    75,  108,   73,   74,   74,   76,   77,   78,   79,   80,
 /*    80 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*    90 */    91,   92,   74,   94,   95,  100,   97,   98,   99,  100,
 /*   100 */   101,    6,  103,  108,  105,  106,  107,  108,  109,  110,
 /*   110 */   111,  112,  113,  114,  115,  116,  234,    1,    2,    3,
 /*   120 */     4,    5,  240,   29,  100,  126,   10,   40,   41,   42,
 /*   130 */    43,   44,   45,   75,   47,  136,  118,  138,  139,  140,
 /*   140 */   141,  142,   34,   35,   36,   37,   38,   39,   40,   41,
 /*   150 */    42,   43,   44,   45,   77,   47,   40,   41,  164,  202,
 /*   160 */   203,  204,   46,  206,   48,   49,   50,   51,   52,   53,
 /*   170 */    75,   55,   56,   57,   58,   59,   60,    6,   62,   63,
 /*   180 */   233,  234,  235,   67,   68,   69,   24,  240,    6,   73,
 /*   190 */    74,   97,   76,   77,  100,   79,   80,   81,   82,   83,
 /*   200 */    84,   85,   86,   87,   88,   89,   90,   91,   92,  215,
 /*   210 */    94,   95,   74,   97,   98,   99,  100,  101,    6,  103,
 /*   220 */   126,  105,  106,  107,  108,  109,  110,  111,  112,  113,
 /*   230 */   114,  115,  116,  118,    1,    2,    3,    4,    5,   77,
 /*   240 */   183,  125,  126,   10,   43,   44,   45,   76,   47,  202,
 /*   250 */   203,  204,  136,  206,  138,  139,  140,  141,  142,  229,
 /*   260 */   233,  234,  235,  233,  234,  235,    6,  240,  211,  212,
 /*   270 */   240,  241,  242,   40,   41,  183,  202,  203,  204,   46,
 /*   280 */   206,   48,   49,   50,   51,   52,   53,   75,   55,   56,
 /*   290 */    57,   58,   59,   60,  117,   62,   63,  122,  123,  124,
 /*   300 */    67,   68,   69,  211,  212,   78,   73,   74,   97,   76,
 /*   310 */    77,  100,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   320 */    87,   88,   89,   90,   91,   92,    6,   94,   95,   75,
 /*   330 */    97,   98,   99,  100,  101,   75,  103,  126,  105,  106,
 /*   340 */   107,  108,  109,  110,  111,  112,  113,  114,  115,  116,
 /*   350 */   123,  124,  119,   61,    1,    2,    3,    4,    5,  126,
 /*   360 */   202,  203,  204,   10,  206,    6,  202,  203,  204,  136,
 /*   370 */   206,  138,  139,  140,  141,  142,  229,  145,  146,  229,
 /*   380 */   233,  234,  235,  233,  234,  235,    6,  240,  241,  242,
 /*   390 */   240,  241,  242,   40,   41,   75,  202,  203,  204,   46,
 /*   400 */   206,   48,   49,   50,   51,   52,   53,   61,   55,   56,
 /*   410 */    57,   58,   59,   60,  130,   62,   63,  175,  176,  177,
 /*   420 */    67,   68,   69,   77,   49,   50,   73,   74,   97,   76,
 /*   430 */    77,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   440 */    87,   88,   89,   90,   91,   92,    6,   94,   95,   29,
 /*   450 */    97,   98,   99,  100,  101,   75,  103,  126,  105,  106,
 /*   460 */   107,  108,  109,  110,  111,  112,  113,  114,  115,  116,
 /*   470 */     6,    1,    2,    3,    4,    5,   75,   61,  130,  126,
 /*   480 */    10,   75,  202,  203,  204,  205,  206,  207,  174,  136,
 /*   490 */    78,  138,  139,  140,  141,  142,  202,  203,  204,   74,
 /*   500 */   206,  229,    6,  234,  190,  233,  234,  235,   74,  240,
 /*   510 */    40,   41,  240,  241,  242,   75,   46,   97,   48,   49,
 /*   520 */    50,   51,   52,   53,    6,   55,   56,   57,   58,   59,
 /*   530 */    60,   96,   62,   63,   97,  123,  124,   67,   68,   69,
 /*   540 */    76,   24,   11,   73,   74,  129,   76,   77,   78,   79,
 /*   550 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   560 */    90,   91,   92,  126,   94,   95,    6,   97,   98,   99,
 /*   570 */   100,  101,   76,  103,   11,  105,  106,  107,  108,  109,
 /*   580 */   110,  111,  112,  113,  114,  115,  116,   76,    1,    2,
 /*   590 */     3,    4,    5,   76,   76,   97,  126,   10,  100,  202,
 /*   600 */   203,  204,   76,  206,   64,   65,  136,   74,  138,  139,
 /*   610 */   140,  141,  142,   64,   65,   24,  216,  217,   77,  219,
 /*   620 */    74,  221,   75,  223,  224,   24,   76,   40,   41,  131,
 /*   630 */   202,  203,  204,   46,  206,   48,   49,   50,   51,   52,
 /*   640 */    53,  218,   55,   56,   57,   58,   59,   60,  225,   62,
 /*   650 */    63,   97,   76,   77,   67,   68,   69,  111,   75,   74,
 /*   660 */    73,   74,   76,   76,   77,   78,   79,   80,   81,   82,
 /*   670 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   680 */    74,   94,   95,  234,   97,   98,   99,  100,  101,  240,
 /*   690 */   103,   76,  105,  106,  107,  108,  109,  110,  111,  112,
 /*   700 */   113,  114,  115,  116,  174,    1,    2,    3,    4,    5,
 /*   710 */    75,   29,   74,  126,   10,   93,   77,  202,  203,  204,
 /*   720 */   190,  206,   61,  136,   74,  138,  139,  140,  141,  142,
 /*   730 */   202,  203,  204,   61,  206,   74,   97,  100,   77,  100,
 /*   740 */    97,   11,  100,  100,   40,   41,   74,   11,  105,   77,
 /*   750 */    46,    6,   48,   49,   50,   51,   52,   53,   75,   55,
 /*   760 */    56,   57,   58,   59,   60,  126,   62,   63,   66,  126,
 /*   770 */   118,   67,   68,   69,   47,  129,   97,   73,   74,   97,
 /*   780 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   790 */    86,   87,   88,   89,   90,   91,   92,   74,   94,   95,
 /*   800 */     6,   97,   98,   99,  100,  101,   11,  103,   11,  105,
 /*   810 */   106,  107,  108,  109,  110,  111,  112,  113,  114,  115,
 /*   820 */   116,   76,    1,    2,    3,    4,    5,   77,   77,   97,
 /*   830 */   126,   10,  100,   77,  202,  203,  204,   11,  206,  100,
 /*   840 */   136,   11,  138,  139,  140,  141,  142,  202,  203,  204,
 /*   850 */     6,  206,  100,   97,   75,   74,  100,   97,  126,   76,
 /*   860 */   100,   40,   41,   76,  202,  203,  204,   46,  206,   48,
 /*   870 */    49,   50,   51,   52,   53,  101,   55,   56,   57,   58,
 /*   880 */    59,   60,  126,   62,   63,   74,  126,   74,   67,   68,
 /*   890 */    69,   11,   11,  101,   73,   74,   97,   76,   77,  100,
 /*   900 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   910 */    89,   90,   91,   92,   76,   94,   95,   74,   97,   98,
 /*   920 */    99,  100,  101,   74,  103,  126,  105,  106,  107,  108,
 /*   930 */   109,  110,  111,  112,  113,  114,  115,  116,   75,  202,
 /*   940 */   203,  204,  121,  206,   75,   74,   76,  126,   75,    1,
 /*   950 */     2,    3,    4,    5,   76,   76,   74,  136,   10,  138,
 /*   960 */   139,  140,  141,  142,   26,   27,   28,   29,   30,   31,
 /*   970 */    32,   33,   34,   35,   36,   37,   38,   39,   40,   41,
 /*   980 */    42,   43,   44,   45,   75,   47,   78,   74,   40,   41,
 /*   990 */    76,  202,  203,  204,   46,  206,   48,   49,   50,   51,
 /*  1000 */    52,   53,   74,   55,   56,   57,   58,   59,   60,   74,
 /*  1010 */    62,   63,   75,  130,  118,   67,   68,   69,   76,   75,
 /*  1020 */    74,   73,   74,  100,   76,   77,   78,   79,   80,   81,
 /*  1030 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*  1040 */    92,  117,   94,   95,   62,   97,   98,   99,  100,  101,
 /*  1050 */    74,  103,   80,  105,  106,  107,  108,  109,  110,  111,
 /*  1060 */   112,  113,  114,  115,  116,   77,    1,    2,    3,    4,
 /*  1070 */     5,   97,  129,   77,  126,   10,   76,   76,   74,   97,
 /*  1080 */   111,   75,  100,   75,  136,   11,  138,  139,  140,  141,
 /*  1090 */   142,   11,   74,   77,   97,  118,   75,   74,  118,   75,
 /*  1100 */    11,   75,   97,   78,   74,   40,   41,  100,  126,  100,
 /*  1110 */   225,   46,  129,   48,   49,   50,   51,   52,   53,   97,
 /*  1120 */    55,   56,   57,   58,   59,   60,  220,   62,   63,  255,
 /*  1130 */   152,  152,   67,   68,   69,  102,  152,  201,   73,   74,
 /*  1140 */   182,   76,   77,   29,   79,   80,   81,   82,   83,   84,
 /*  1150 */    85,   86,   87,   88,   89,   90,   91,   92,   99,   94,
 /*  1160 */    95,   97,   97,   98,   99,  100,  101,  226,  103,  201,
 /*  1170 */   105,  106,  107,  108,  109,  110,  111,  112,  113,  114,
 /*  1180 */   115,  116,  209,   76,   74,  120,   96,   11,  174,  177,
 /*  1190 */   154,  126,  165,    1,    2,    3,    4,    5,  100,  152,
 /*  1200 */   185,  136,   10,  138,  139,  140,  141,  142,   27,   28,
 /*  1210 */    29,   30,   31,   32,   33,   34,   35,   36,   37,   38,
 /*  1220 */    39,   40,   41,   42,   43,   44,   45,   74,   47,  152,
 /*  1230 */   232,  152,   40,   41,  197,  187,  152,  209,   46,   74,
 /*  1240 */    48,   49,   50,   51,   52,   53,  129,   55,   56,   57,
 /*  1250 */    58,   59,   60,  152,   62,   63,  152,  182,  152,   67,
 /*  1260 */    68,   69,  230,  194,  152,   73,   74,  209,   76,   77,
 /*  1270 */   230,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*  1280 */    88,   89,   90,   91,   92,  194,   94,   95,  245,   97,
 /*  1290 */    98,   99,  100,  101,  161,  103,  187,  105,  106,  107,
 /*  1300 */   108,  109,  110,  111,  112,  113,  114,  115,  116,  212,
 /*  1310 */     1,    2,    3,    4,    5,  157,  155,  215,  126,   10,
 /*  1320 */   152,  167,    6,  231,  102,  210,  254,  222,  136,   97,
 /*  1330 */   138,  139,  140,  141,  142,  224,  152,  201,  210,  246,
 /*  1340 */   189,  104,  226,  174,  174,  186,  172,  100,  201,   40,
 /*  1350 */    41,  117,  170,  209,  152,   46,  152,   48,   49,   50,
 /*  1360 */    51,   52,   53,  174,   55,   56,   57,   58,   59,   60,
 /*  1370 */   170,   62,   63,   76,  257,  257,   67,   68,   69,  257,
 /*  1380 */   257,  257,   73,   74,  257,   76,   77,  257,   79,   80,
 /*  1390 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*  1400 */    91,   92,  257,   94,   95,  257,   97,   98,   99,  100,
 /*  1410 */   101,  257,  103,  257,  105,  106,  107,  108,  109,  110,
 /*  1420 */   111,  112,  113,  114,  115,  116,  257,  257,  257,  257,
 /*  1430 */   257,  257,  257,  257,  257,  126,  257,    1,    2,    3,
 /*  1440 */     4,    5,  257,  257,  257,  136,   10,  138,  139,  140,
 /*  1450 */   141,  142,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  1460 */    24,  257,   11,   12,   13,   14,   15,   16,   17,   18,
 /*  1470 */    19,   20,   21,   22,  257,  257,   40,   41,  257,  257,
 /*  1480 */   257,  257,   46,  257,   48,   49,   50,   51,   52,   53,
 /*  1490 */   257,   55,   56,   57,   58,   59,   60,  257,   62,   63,
 /*  1500 */    49,   50,  257,   67,  257,  257,  257,  257,  257,  257,
 /*  1510 */    74,  257,   76,   77,  257,   79,   80,   81,   82,   83,
 /*  1520 */    84,   85,   86,   87,   88,   89,   90,   91,   92,  257,
 /*  1530 */    94,   95,  257,   97,   98,  257,  100,  257,  257,  257,
 /*  1540 */   257,  105,  106,  107,  108,  109,  110,  111,  112,  113,
 /*  1550 */   114,  115,  116,  257,  257,  257,  257,  257,  257,  257,
 /*  1560 */   257,  257,  126,  257,    1,    2,    3,    4,    5,  257,
 /*  1570 */   257,  257,  136,   10,  138,  139,  140,  141,  142,  257,
 /*  1580 */   257,  257,  257,  257,  257,  257,  257,   24,  257,  257,
 /*  1590 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  1600 */   257,  257,  257,   40,   41,  257,  257,  257,  257,   46,
 /*  1610 */   257,   48,   49,   50,   51,   52,   53,  257,   55,   56,
 /*  1620 */    57,   58,   59,   60,  257,   62,   63,  257,  257,  257,
 /*  1630 */    67,  257,  257,  257,  257,  257,  257,   74,  257,   76,
 /*  1640 */    77,  257,   79,   80,   81,   82,   83,   84,   85,   86,
 /*  1650 */    87,   88,   89,   90,   91,   92,  257,   94,   95,  257,
 /*  1660 */    97,   98,  257,  100,  257,  257,  257,  257,  105,  106,
 /*  1670 */   107,  108,  109,  110,  111,  112,  113,  114,  115,  116,
 /*  1680 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  126,
 /*  1690 */   257,    1,    2,    3,    4,    5,  257,  257,  257,  136,
 /*  1700 */    10,  138,  139,  140,  141,  142,  257,  257,  257,  257,
 /*  1710 */   257,  257,  257,  257,   24,  257,  257,  257,  257,  257,
 /*  1720 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  1730 */    40,   41,  257,  257,  257,  257,   46,  257,   48,   49,
 /*  1740 */    50,   51,   52,   53,  257,   55,   56,   57,   58,   59,
 /*  1750 */    60,  257,   62,   63,  257,  257,  257,   67,  257,  257,
 /*  1760 */   257,  257,  257,  257,   74,  257,   76,   77,  257,   79,
 /*  1770 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*  1780 */    90,   91,   92,  257,   94,   95,  257,   97,   98,  257,
 /*  1790 */   100,  257,  257,  257,  257,  105,  106,  107,  108,  109,
 /*  1800 */   110,  111,  112,  113,  114,  115,  116,  257,  257,  257,
 /*  1810 */   257,  257,  257,  257,  257,  257,  126,  257,    1,    2,
 /*  1820 */     3,    4,    5,  257,  257,  257,  136,   10,  138,  139,
 /*  1830 */   140,  141,  142,  257,  257,  257,  257,  257,  257,  257,
 /*  1840 */   257,   24,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  1850 */   257,  257,  257,  257,  257,  257,  257,   40,   41,  257,
 /*  1860 */   257,  257,  257,   46,  257,   48,   49,   50,   51,   52,
 /*  1870 */    53,  257,   55,   56,   57,   58,   59,   60,  257,   62,
 /*  1880 */    63,  257,  257,  257,   67,  257,  257,  257,  257,  257,
 /*  1890 */   257,   74,  257,   76,   77,  257,   79,   80,   81,   82,
 /*  1900 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*  1910 */   257,   94,   95,  257,   97,   98,  257,  100,  257,  257,
 /*  1920 */   257,  257,  105,  106,  107,  108,  109,  110,  111,  112,
 /*  1930 */   113,  114,  115,  116,  257,  257,  257,  257,  257,  257,
 /*  1940 */   257,  257,  257,  126,  257,    1,    2,    3,    4,    5,
 /*  1950 */   257,  257,  257,  136,   10,  138,  139,  140,  141,  142,
 /*  1960 */   257,  257,  257,  257,  257,  257,  257,  257,   24,  257,
 /*  1970 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  1980 */   257,  257,  257,  257,   40,   41,  257,  257,  257,  257,
 /*  1990 */    46,  257,   48,   49,   50,   51,   52,   53,  257,   55,
 /*  2000 */    56,   57,   58,   59,   60,  257,   62,   63,  257,  257,
 /*  2010 */   257,   67,  257,  257,  257,  257,  257,  257,   74,  257,
 /*  2020 */    76,   77,  257,   79,   80,   81,   82,   83,   84,   85,
 /*  2030 */    86,   87,   88,   89,   90,   91,   92,  257,   94,   95,
 /*  2040 */   257,   97,   98,  257,  100,  257,  257,  257,  257,  105,
 /*  2050 */   106,  107,  108,  109,  110,  111,  112,  113,  114,  115,
 /*  2060 */   116,  257,    1,    2,    3,    4,    5,  257,  257,  257,
 /*  2070 */   126,   10,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  2080 */   136,  257,  138,  139,  140,  141,  142,  257,  257,  257,
 /*  2090 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  2100 */   257,   40,   41,  257,  257,  257,  257,   46,  257,   48,
 /*  2110 */    49,   50,   51,   52,   53,  257,   55,   56,   57,   58,
 /*  2120 */    59,   60,  257,   62,   63,  257,  257,  257,   67,  257,
 /*  2130 */   257,  257,  257,  257,  257,   74,  257,   76,   77,  257,
 /*  2140 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*  2150 */    89,   90,   91,   92,  257,   94,   95,  257,   97,   98,
 /*  2160 */   257,  100,  257,  257,  257,  257,  105,  106,  107,  108,
 /*  2170 */   109,  110,  111,  112,  113,  114,  115,  116,  257,    1,
 /*  2180 */     2,    3,    4,    5,  257,  257,  257,  126,   10,  257,
 /*  2190 */   257,  257,  257,  257,  257,  257,  257,  136,  257,  138,
 /*  2200 */   139,  140,  141,  142,  257,  257,  257,   29,  257,  257,
 /*  2210 */   257,  257,  257,  257,  257,  257,  257,  257,   40,   41,
 /*  2220 */   257,  257,  257,  257,   46,  257,   48,   49,   50,   51,
 /*  2230 */    52,   53,  257,   55,   56,   57,   58,   59,   60,  257,
 /*  2240 */    62,   63,   67,   68,   69,   70,   71,   72,  257,  257,
 /*  2250 */   257,  257,   74,   78,   25,   26,   27,   28,   29,   30,
 /*  2260 */    31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
 /*  2270 */    41,   42,   43,   44,   45,   97,   47,  257,  100,  257,
 /*  2280 */   257,  257,  257,  105,  106,  107,  108,  109,  110,  111,
 /*  2290 */   112,  113,  114,  115,  116,  257,    1,    2,    3,    4,
 /*  2300 */     5,  257,  127,  128,  126,   10,  257,  257,  257,  257,
 /*  2310 */   257,  257,  257,  257,  136,  257,  138,  139,  140,  141,
 /*  2320 */   142,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  2330 */   257,  257,  257,  257,  257,   40,   41,  257,  257,  257,
 /*  2340 */   257,   46,  257,   48,   49,   50,   51,   52,   53,  257,
 /*  2350 */    55,   56,   57,   58,   59,   60,  257,   62,   63,  257,
 /*  2360 */   257,  257,  257,  257,  257,  257,  257,  257,  257,   74,
 /*  2370 */    75,  257,   28,   29,   30,   31,   32,   33,   34,   35,
 /*  2380 */    36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
 /*  2390 */   257,   47,   97,  257,  257,  100,  257,  257,  257,  257,
 /*  2400 */   105,  106,  107,  108,  109,  110,  111,  112,  113,  114,
 /*  2410 */   115,  116,  257,    1,    2,    3,    4,    5,  257,  257,
 /*  2420 */   257,  126,   10,  257,  257,  257,  257,  257,  257,  257,
 /*  2430 */   257,  136,  257,  138,  139,  140,  141,  142,  257,  257,
 /*  2440 */   257,   29,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  2450 */   257,  257,   40,   41,  257,  257,  257,  257,   46,  257,
 /*  2460 */    48,   49,   50,   51,   52,   53,  257,   55,   56,   57,
 /*  2470 */    58,   59,   60,  257,   62,   63,   67,   68,   69,   70,
 /*  2480 */    71,   72,  257,  257,  257,  257,   74,   78,   29,   30,
 /*  2490 */    31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
 /*  2500 */    41,   42,   43,   44,   45,  257,   47,  257,  257,   97,
 /*  2510 */   257,  257,  100,  257,  257,  257,  257,  105,  106,  107,
 /*  2520 */   108,  109,  110,  111,  112,  113,  114,  115,  116,  257,
 /*  2530 */     1,    2,    3,    4,    5,  257,  127,  128,  126,   10,
 /*  2540 */   257,  257,  257,  257,  257,  257,  257,  257,  136,  257,
 /*  2550 */   138,  139,  140,  141,  142,  257,  257,  257,   29,  257,
 /*  2560 */   257,  257,  257,  257,  257,  257,  257,  257,  257,   40,
 /*  2570 */    41,  257,  257,  257,  257,   46,  257,   48,   49,   50,
 /*  2580 */    51,   52,   53,  257,   55,   56,   57,   58,   59,   60,
 /*  2590 */   257,   62,   63,  257,  257,  257,  257,  257,  257,  257,
 /*  2600 */   257,  257,  257,   74,  257,  257,   30,   31,   32,   33,
 /*  2610 */    34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
 /*  2620 */    44,   45,  257,   47,  257,  257,   97,  257,  257,  100,
 /*  2630 */   257,  257,  257,  257,  105,  106,  107,  108,  109,  110,
 /*  2640 */   111,  112,  113,  114,  115,  116,  257,    1,    2,    3,
 /*  2650 */     4,    5,  257,  257,  257,  126,   10,   40,   41,  257,
 /*  2660 */   257,  257,  257,  257,  257,  136,  257,  138,  139,  140,
 /*  2670 */   141,  142,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  2680 */   257,  257,  257,  257,  257,  257,   40,   41,  257,  257,
 /*  2690 */   257,  257,   46,  257,   48,   49,   50,   51,   52,   53,
 /*  2700 */   257,   55,   56,   57,   58,   59,   60,  257,   62,   63,
 /*  2710 */   257,  257,  257,  257,  257,  257,  257,  100,  257,  257,
 /*  2720 */    74,  257,   76,  257,  257,  108,  109,  110,  111,  112,
 /*  2730 */   113,  114,  115,  116,  257,  257,  257,  257,  257,  257,
 /*  2740 */   257,  257,  257,   97,  257,  257,  100,  257,  257,  257,
 /*  2750 */   257,  105,  106,  107,  108,  109,  110,  111,  112,  113,
 /*  2760 */   114,  115,  116,  257,    1,    2,    3,    4,    5,  257,
 /*  2770 */   163,  257,  126,   10,  257,  257,  257,  257,  257,  257,
 /*  2780 */   257,  174,  136,  257,  138,  139,  140,  141,  142,  257,
 /*  2790 */   257,  257,   29,  257,  257,  257,  257,  257,  257,  192,
 /*  2800 */   257,  257,  257,   40,   41,  257,  257,  257,  257,   46,
 /*  2810 */   257,   48,   49,   50,   51,   52,   53,  257,   55,   56,
 /*  2820 */    57,   58,   59,   60,  257,   62,   63,  257,  257,  257,
 /*  2830 */   257,  257,  174,  257,  257,  228,  257,   74,  257,  257,
 /*  2840 */   233,  234,  235,  236,  237,  238,  257,  240,  257,  257,
 /*  2850 */   243,  193,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  2860 */    97,  257,  257,  100,  257,  257,  257,  257,  105,  106,
 /*  2870 */   107,  108,  109,  110,  111,  112,  113,  114,  115,  116,
 /*  2880 */   257,    1,    2,    3,    4,    5,  163,  257,  257,  126,
 /*  2890 */    10,  168,  234,  235,  236,  237,  257,  174,  240,  136,
 /*  2900 */   257,  138,  139,  140,  141,  142,  257,  257,  257,   29,
 /*  2910 */   257,  253,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  2920 */    40,   41,  257,  257,  257,  257,   46,  257,   48,   49,
 /*  2930 */    50,   51,   52,   53,  257,   55,   56,   57,   58,   59,
 /*  2940 */    60,  257,   62,   63,  257,  257,  257,  257,  174,  257,
 /*  2950 */   227,  228,  257,  257,   74,  257,  233,  234,  235,  236,
 /*  2960 */   237,  238,  257,  240,  257,  257,  257,  193,  257,  257,
 /*  2970 */   257,  257,  257,  257,  257,  257,  257,   97,  257,  257,
 /*  2980 */   100,  257,  257,  257,  257,  105,  106,  107,  108,  109,
 /*  2990 */   110,  111,  112,  113,  114,  115,  116,  257,    1,    2,
 /*  3000 */     3,    4,    5,  257,  163,  257,  126,   10,  234,  235,
 /*  3010 */   236,  237,  257,  257,  240,  174,  136,  257,  138,  139,
 /*  3020 */   140,  141,  142,  257,  257,  257,  257,  253,  257,  257,
 /*  3030 */   257,  257,  257,  192,  257,  257,  257,   40,   41,  257,
 /*  3040 */   257,  257,  257,   46,  257,   48,   49,   50,   51,   52,
 /*  3050 */    53,  257,   55,   56,   57,   58,   59,   60,  257,   62,
 /*  3060 */    63,  257,  257,  257,  257,  257,  174,  257,  257,  228,
 /*  3070 */   257,   74,  257,   76,  233,  234,  235,  236,  237,  238,
 /*  3080 */   257,  240,  257,  257,  243,  193,  257,  257,  257,  257,
 /*  3090 */   257,  257,  257,  257,   97,  257,  257,  100,  257,  257,
 /*  3100 */   257,  257,  105,  106,  107,  108,  109,  110,  111,  112,
 /*  3110 */   113,  114,  115,  116,  257,    1,    2,    3,    4,    5,
 /*  3120 */   163,  257,  257,  126,   10,  257,  234,  235,  236,  237,
 /*  3130 */   257,  174,  240,  136,  257,  138,  139,  140,  141,  142,
 /*  3140 */   257,  257,  257,   29,  257,  253,  257,  257,  257,  257,
 /*  3150 */   257,  257,  257,  257,   40,   41,  257,  257,  257,  257,
 /*  3160 */    46,  257,   48,   49,   50,   51,   52,   53,  257,   55,
 /*  3170 */    56,   57,   58,   59,   60,  257,   62,   63,  257,  257,
 /*  3180 */   257,  257,  257,  257,  257,  228,  257,  257,   74,  257,
 /*  3190 */   233,  234,  235,  236,  237,  238,  257,  240,  257,  257,
 /*  3200 */   257,  257,  257,  257,  247,  257,  257,  257,  257,  257,
 /*  3210 */   257,   97,  257,  257,  100,  257,  257,  257,  257,  105,
 /*  3220 */   106,  107,  108,  109,  110,  111,  112,  113,  114,  115,
 /*  3230 */   116,  257,    1,    2,    3,    4,    5,  163,  257,  257,
 /*  3240 */   126,   10,  257,  257,  257,  257,  257,  257,  174,  257,
 /*  3250 */   136,  257,  138,  139,  140,  141,  142,  257,  257,  257,
 /*  3260 */    29,  257,  257,  257,  257,  191,  257,  257,  257,  257,
 /*  3270 */   257,   40,   41,  257,  257,  257,  257,   46,  257,   48,
 /*  3280 */    49,   50,   51,   52,   53,  257,   55,   56,   57,   58,
 /*  3290 */    59,   60,  257,   62,   63,  257,  257,  257,  257,  257,
 /*  3300 */   257,  257,  228,  257,  257,   74,  257,  233,  234,  235,
 /*  3310 */   236,  237,  238,  257,  240,  257,  257,  257,  257,  257,
 /*  3320 */   257,  257,  257,  257,  257,  257,  257,  257,   97,  257,
 /*  3330 */   257,  100,  257,  257,  257,  257,  105,  106,  107,  108,
 /*  3340 */   109,  110,  111,  112,  113,  114,  115,  116,  257,    1,
 /*  3350 */     2,    3,    4,    5,  257,  163,  257,  126,   10,  257,
 /*  3360 */   257,  257,  257,  257,  257,  257,  174,  136,  257,  138,
 /*  3370 */   139,  140,  141,  142,  257,  257,  257,  257,  257,  257,
 /*  3380 */   257,  257,  257,  257,  257,  257,  257,  257,   40,   41,
 /*  3390 */   257,  257,  257,  257,   46,  257,   48,   49,   50,   51,
 /*  3400 */    52,   53,  257,   55,   56,   57,   58,   59,   60,  257,
 /*  3410 */    62,   63,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  3420 */   228,  257,   74,  257,   76,  233,  234,  235,  236,  237,
 /*  3430 */   238,  257,  240,  257,  257,  243,  257,  257,  257,  257,
 /*  3440 */   257,  257,  257,  257,  257,   97,  257,  257,  100,  257,
 /*  3450 */   257,  257,  257,  105,  106,  107,  108,  109,  110,  111,
 /*  3460 */   112,  113,  114,  115,  116,  257,    1,    2,    3,    4,
 /*  3470 */     5,  163,  257,  257,  126,   10,  257,  257,  257,  257,
 /*  3480 */   257,  257,  174,  257,  136,  257,  138,  139,  140,  141,
 /*  3490 */   142,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  3500 */   257,  257,  257,  195,  257,   40,   41,  257,  257,  257,
 /*  3510 */   257,   46,  257,   48,   49,   50,   51,   52,   53,  257,
 /*  3520 */    55,   56,   57,   58,   59,   60,  257,   62,   63,  257,
 /*  3530 */   257,  257,  257,  257,  257,  257,  228,  257,  257,   74,
 /*  3540 */   257,  233,  234,  235,  236,  237,  238,  257,  240,  257,
 /*  3550 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  3560 */   257,  257,   97,  257,  257,  100,  257,  257,  257,  257,
 /*  3570 */   105,  106,  107,  108,  109,  110,  111,  112,  113,  114,
 /*  3580 */   115,  116,  257,    1,    2,    3,    4,    5,  163,  257,
 /*  3590 */   257,  126,   10,  257,  257,  257,  257,  257,  257,  174,
 /*  3600 */   257,  136,  257,  138,  139,  140,  141,  142,  257,  257,
 /*  3610 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  3620 */   195,  257,   40,   41,  257,  257,  257,  257,   46,  257,
 /*  3630 */    48,   49,   50,   51,   52,   53,  257,   55,   56,   57,
 /*  3640 */    58,   59,   60,  257,   62,   63,  257,  257,  257,  257,
 /*  3650 */   257,  257,  257,  228,  257,  257,   74,  257,  233,  234,
 /*  3660 */   235,  236,  237,  238,  257,  240,  257,  257,  257,  257,
 /*  3670 */   257,  257,  257,  257,  257,  257,  257,  257,  257,   97,
 /*  3680 */   257,  257,  100,  257,  257,  257,  257,  105,  106,  107,
 /*  3690 */   108,  109,  110,  111,  112,  113,  114,  115,  116,  257,
 /*  3700 */   257,  257,  257,  257,  257,  257,  257,  257,  126,  257,
 /*  3710 */   257,  148,  149,  150,  151,  257,  153,  257,  136,  156,
 /*  3720 */   138,  139,  140,  141,  142,  162,  163,  257,  257,  257,
 /*  3730 */   257,  257,  257,  257,  257,  257,  257,  174,  257,  257,
 /*  3740 */   257,  178,  179,  180,  181,  257,  257,  184,  257,  257,
 /*  3750 */   257,  188,    9,  257,  191,  257,  257,  257,  195,  196,
 /*  3760 */   257,  198,  199,  257,  257,  202,   23,  257,   25,   26,
 /*  3770 */    27,   28,   29,   30,   31,   32,   33,   34,   35,   36,
 /*  3780 */    37,   38,   39,   40,   41,   42,   43,   44,   45,  257,
 /*  3790 */    47,  228,  257,  257,  257,  257,  233,  234,  235,  236,
 /*  3800 */   237,  238,  257,  240,  257,  148,  149,  150,  151,  257,
 /*  3810 */   153,  248,  249,  250,  251,  252,  257,  257,  257,  162,
 /*  3820 */   163,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  3830 */   257,  174,  257,  257,  257,  178,  179,  180,  181,  257,
 /*  3840 */   257,  184,  257,  257,  257,  188,  257,  257,  191,  257,
 /*  3850 */   257,  257,  195,  196,  257,  198,  199,  257,  257,  202,
 /*  3860 */     6,  257,   61,  257,  257,   11,   12,   13,   14,   15,
 /*  3870 */    16,   17,   18,   19,   20,   21,   22,  257,   77,   78,
 /*  3880 */   257,  257,  257,  257,  257,  228,  257,  257,  257,  257,
 /*  3890 */   233,  234,  235,  236,  237,  238,  257,  240,   97,  257,
 /*  3900 */   257,  100,  257,   49,   50,  248,  249,  250,  251,  252,
 /*  3910 */   147,  148,  149,  150,  151,  257,  153,  257,  257,  257,
 /*  3920 */   257,  257,  257,  257,  257,  162,  163,  257,  257,   75,
 /*  3930 */   129,  130,  131,  132,  133,  134,  135,  174,  137,  257,
 /*  3940 */   257,  140,  179,  180,  181,  257,  257,  184,  257,  257,
 /*  3950 */   257,  188,  257,  257,  191,  257,  257,  257,  195,  196,
 /*  3960 */   257,  198,  199,  257,  257,  202,  257,  257,  257,  257,
 /*  3970 */    11,   12,   13,   14,   15,   16,   17,   18,   19,   20,
 /*  3980 */    21,   22,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  3990 */   257,  228,  257,  257,  257,  257,  233,  234,  235,  236,
 /*  4000 */   237,  238,  257,  240,    7,    8,    9,  257,   49,   50,
 /*  4010 */   257,  248,  249,  250,  251,  252,  257,  257,  257,  257,
 /*  4020 */    23,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*  4030 */    33,   34,   35,   36,   37,   38,   39,   40,   41,   42,
 /*  4040 */    43,   44,   45,  257,   47,  257,  257,  153,  257,  257,
 /*  4050 */   257,  257,   93,  257,  257,  257,  162,  163,  257,  257,
 /*  4060 */   257,  257,  257,  257,  257,  257,  257,  257,  174,  257,
 /*  4070 */   257,  257,  257,   76,  257,  257,  257,  257,  257,  257,
 /*  4080 */   257,    7,    8,    9,  257,  191,  257,  257,  257,  195,
 /*  4090 */   196,  257,  198,  199,  200,  257,  202,   23,  257,   25,
 /*  4100 */    26,   27,   28,   29,   30,   31,   32,   33,   34,   35,
 /*  4110 */    36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
 /*  4120 */   257,   47,  228,  257,  257,  257,  257,  233,  234,  235,
 /*  4130 */   236,  237,  238,  257,  240,  257,  163,  257,  244,  257,
 /*  4140 */   257,  257,  248,  249,  250,  251,  252,  174,  257,   75,
 /*  4150 */   257,  257,  257,  257,  257,  257,  257,    7,    8,    9,
 /*  4160 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  4170 */   257,  257,  257,   23,  257,   25,   26,   27,   28,   29,
 /*  4180 */    30,   31,   32,   33,   34,   35,   36,   37,   38,   39,
 /*  4190 */    40,   41,   42,   43,   44,   45,  257,   47,  257,  257,
 /*  4200 */   227,  228,  257,  257,  257,  257,  233,  234,  235,  236,
 /*  4210 */   237,  238,  257,  240,  257,  257,  257,  257,  257,  257,
 /*  4220 */   257,  257,  257,  257,  257,  257,  257,  257,   78,  257,
 /*  4230 */   257,  257,  257,  257,  257,  257,    7,    8,    9,  257,
 /*  4240 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  4250 */   257,  257,   23,  257,   25,   26,   27,   28,   29,   30,
 /*  4260 */    31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
 /*  4270 */    41,   42,   43,   44,   45,  257,   47,  257,  257,  257,
 /*  4280 */   257,  153,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  4290 */   162,  163,  257,  257,  166,  257,  257,  257,  257,  257,
 /*  4300 */   257,  257,  174,  257,  257,   76,  257,  257,  257,  257,
 /*  4310 */   257,  257,  257,    7,    8,    9,  257,  257,  257,  191,
 /*  4320 */   257,  257,  257,  195,  196,  257,  198,  199,  257,   23,
 /*  4330 */   202,   25,   26,   27,   28,   29,   30,   31,   32,   33,
 /*  4340 */    34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
 /*  4350 */    44,   45,  257,   47,  257,  257,  228,  257,  257,  257,
 /*  4360 */   257,  233,  234,  235,  236,  237,  238,  257,  240,  257,
 /*  4370 */   257,  257,  257,  257,  257,  257,  248,  249,  250,  251,
 /*  4380 */   252,  257,  257,  257,   78,  257,  257,  257,  257,  257,
 /*  4390 */   257,  257,    7,    8,    9,  257,  257,  257,  257,  257,
 /*  4400 */   257,  257,  257,  257,  257,  257,  257,  257,   23,   24,
 /*  4410 */    25,   26,   27,   28,   29,   30,   31,   32,   33,   34,
 /*  4420 */    35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*  4430 */    45,    6,   47,    7,    8,    9,   11,   12,   13,   14,
 /*  4440 */    15,   16,   17,   18,   19,   20,   21,   22,  257,   23,
 /*  4450 */   257,   25,   26,   27,   28,   29,   30,   31,   32,   33,
 /*  4460 */    34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
 /*  4470 */    44,   45,  257,   47,   49,   50,  257,  153,  257,  257,
 /*  4480 */   257,  257,  257,  257,  257,  257,  162,  163,  257,  257,
 /*  4490 */   257,  257,  257,  257,  257,  257,  257,  257,  174,  257,
 /*  4500 */    75,   75,  257,  257,  257,  257,  257,  257,  257,    7,
 /*  4510 */     8,    9,  257,  257,  257,  191,  257,  257,  257,  195,
 /*  4520 */   196,  257,  198,  199,  257,   23,  202,   25,   26,   27,
 /*  4530 */    28,   29,   30,   31,   32,   33,   34,   35,   36,   37,
 /*  4540 */    38,   39,   40,   41,   42,   43,   44,   45,  257,   47,
 /*  4550 */   257,  257,  228,  257,  257,  257,  257,  233,  234,  235,
 /*  4560 */   236,  237,  238,  239,  240,  257,  257,  257,  257,  257,
 /*  4570 */   257,  257,  248,  249,  250,  251,  252,  257,  257,  257,
 /*  4580 */    78,  257,  257,  257,  257,  257,  257,  257,    7,    8,
 /*  4590 */     9,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  4600 */   257,  257,  257,  257,   23,  257,   25,   26,   27,   28,
 /*  4610 */    29,   30,   31,   32,   33,   34,   35,   36,   37,   38,
 /*  4620 */    39,   40,   41,   42,   43,   44,   45,  257,   47,  257,
 /*  4630 */   257,  257,  257,  257,  257,  257,  257,  257,   11,   12,
 /*  4640 */    13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
 /*  4650 */   163,  257,  257,  257,  257,  257,   75,  257,  257,  257,
 /*  4660 */   257,  174,  257,  257,    7,    8,    9,  257,  257,  257,
 /*  4670 */   257,  257,  257,  257,  257,  257,   49,   50,  257,  257,
 /*  4680 */    23,  257,   25,   26,   27,   28,   29,   30,   31,   32,
 /*  4690 */    33,   34,   35,   36,   37,   38,   39,   40,   41,   42,
 /*  4700 */    43,   44,   45,   76,   47,  257,  257,  257,  257,  257,
 /*  4710 */   257,  257,  257,  257,  257,  228,  257,  257,  257,  257,
 /*  4720 */   233,  234,  235,  236,  237,  238,  163,  240,  257,  257,
 /*  4730 */   257,  257,  257,   76,  257,  257,  257,  174,  257,  257,
 /*  4740 */   257,    7,    8,    9,  257,  257,  257,  257,  257,  257,
 /*  4750 */   257,  257,  257,  257,  257,  257,  257,   23,  257,   25,
 /*  4760 */    26,   27,   28,   29,   30,   31,   32,   33,   34,   35,
 /*  4770 */    36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
 /*  4780 */   257,   47,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  4790 */   257,  228,  257,  257,  257,  257,  233,  234,  235,  236,
 /*  4800 */   237,  238,  163,  240,  257,  257,  257,  257,  257,  257,
 /*  4810 */    76,  257,  257,  174,  257,  257,  257,  257,    7,    8,
 /*  4820 */     9,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  4830 */   257,  257,  257,  257,   23,  257,   25,   26,   27,   28,
 /*  4840 */    29,   30,   31,   32,   33,   34,   35,   36,   37,   38,
 /*  4850 */    39,   40,   41,   42,   43,   44,   45,  257,   47,  257,
 /*  4860 */   257,  257,  257,  257,  257,  257,  257,  228,  257,  257,
 /*  4870 */   257,  257,  233,  234,  235,  236,  237,  238,  257,  240,
 /*  4880 */   257,  257,  257,  257,  257,  257,   75,  257,  257,  257,
 /*  4890 */   257,  257,  257,  257,    7,    8,    9,  257,  257,  257,
 /*  4900 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  4910 */    23,  257,   25,   26,   27,   28,   29,   30,   31,   32,
 /*  4920 */    33,   34,   35,   36,   37,   38,   39,   40,   41,   42,
 /*  4930 */    43,   44,   45,  257,   47,    7,    8,    9,  257,  257,
 /*  4940 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  4950 */   257,   23,  257,   25,   26,   27,   28,   29,   30,   31,
 /*  4960 */    32,   33,   34,   35,   36,   37,   38,   39,   40,   41,
 /*  4970 */    42,   43,   44,   45,  257,   47,  257,  257,  257,  257,
 /*  4980 */   257,  257,  257,  257,   61,  257,  257,  257,  257,  257,
 /*  4990 */   257,  257,  257,  257,  257,  257,  257,  257,  163,  257,
 /*  5000 */    77,   78,  257,   75,  117,  257,  257,  257,  257,  174,
 /*  5010 */   257,    7,    8,    9,  257,  257,  257,  257,  257,  257,
 /*  5020 */    97,  257,  257,  100,  257,  257,  257,   23,  257,   25,
 /*  5030 */    26,   27,   28,   29,   30,   31,   32,   33,   34,   35,
 /*  5040 */    36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
 /*  5050 */   257,   47,  129,  130,  131,  132,  133,  134,  135,  257,
 /*  5060 */   137,  257,  257,  228,  257,  257,  143,  257,  233,  234,
 /*  5070 */   235,  236,  237,  238,  257,  240,  257,  257,  257,   75,
 /*  5080 */   257,  257,  257,  257,  257,  257,  257,    7,    8,    9,
 /*  5090 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  5100 */   257,  257,  257,   23,  257,   25,   26,   27,   28,   29,
 /*  5110 */    30,   31,   32,   33,   34,   35,   36,   37,   38,   39,
 /*  5120 */    40,   41,   42,   43,   44,   45,  257,   47,  257,  153,
 /*  5130 */   257,  257,  257,  257,  257,  159,  257,  257,  162,  163,
 /*  5140 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  5150 */   174,  257,  257,  257,  257,   75,  257,  257,  257,  257,
 /*  5160 */   257,  257,  257,    7,    8,    9,  257,  191,  257,  257,
 /*  5170 */   257,  195,  196,  257,  198,  199,  257,  257,  202,   23,
 /*  5180 */   257,   25,   26,   27,   28,   29,   30,   31,   32,   33,
 /*  5190 */    34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
 /*  5200 */    44,   45,  257,   47,  228,  257,  257,  257,  257,  233,
 /*  5210 */   234,  235,  236,  237,  238,  257,  240,  257,  257,  257,
 /*  5220 */   257,  257,  257,  257,  248,  249,  250,  251,  252,  257,
 /*  5230 */   257,  257,  256,  257,   78,  257,  257,  257,  257,  257,
 /*  5240 */   257,  257,    7,    8,    9,  257,  257,  257,  257,  257,
 /*  5250 */   257,  257,  257,  257,  257,  257,  257,  257,   23,  257,
 /*  5260 */    25,   26,   27,   28,   29,   30,   31,   32,   33,   34,
 /*  5270 */    35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*  5280 */    45,  257,   47,    7,    8,    9,  257,  257,  257,  257,
 /*  5290 */   257,  257,  257,  257,  257,  257,  257,  257,  257,   23,
 /*  5300 */   257,   25,   26,   27,   28,   29,   30,   31,   32,   33,
 /*  5310 */    34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
 /*  5320 */    44,   45,  257,   47,  257,  257,  257,  257,  153,  257,
 /*  5330 */   257,  257,  257,  257,  159,  257,  257,  162,  163,  257,
 /*  5340 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  174,
 /*  5350 */   257,  257,  257,  257,   78,  257,  257,  257,  257,  257,
 /*  5360 */   257,  257,    7,    8,    9,  130,  191,  257,  257,  257,
 /*  5370 */   195,  196,  257,  198,  199,  257,  257,  202,   23,  257,
 /*  5380 */    25,   26,   27,   28,   29,   30,   31,   32,   33,   34,
 /*  5390 */    35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*  5400 */    45,  257,   47,  228,  257,  257,  257,  257,  233,  234,
 /*  5410 */   235,  236,  237,  238,  257,  240,  257,  257,  257,  257,
 /*  5420 */   257,  257,  257,  248,  249,  250,  251,  252,  257,  257,
 /*  5430 */   257,  256,  257,   78,  257,  257,  257,  257,  257,  257,
 /*  5440 */   257,    7,    8,    9,  257,  257,  257,  257,  257,  257,
 /*  5450 */   257,  257,  257,  257,  257,  257,  257,   23,  257,   25,
 /*  5460 */    26,   27,   28,   29,   30,   31,   32,   33,   34,   35,
 /*  5470 */    36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
 /*  5480 */   257,   47,  257,    7,    8,    9,  257,  257,  257,  257,
 /*  5490 */   257,  257,  257,  257,  257,  257,  257,  257,  257,   23,
 /*  5500 */   257,   25,   26,   27,   28,   29,   30,   31,   32,   33,
 /*  5510 */    34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
 /*  5520 */    44,   45,  257,   47,  257,  153,  257,  257,  257,  257,
 /*  5530 */   257,  159,  257,  257,  162,  163,  257,  257,  257,  257,
 /*  5540 */   257,  257,  257,  257,  257,  257,  174,  257,  257,  257,
 /*  5550 */   257,  117,   76,  257,  257,  257,  257,  257,  257,    7,
 /*  5560 */     8,    9,  257,  191,  257,  257,  257,  195,  196,  257,
 /*  5570 */   198,  199,  257,  257,  202,   23,  257,   25,   26,   27,
 /*  5580 */    28,   29,   30,   31,   32,   33,   34,   35,   36,   37,
 /*  5590 */    38,   39,   40,   41,   42,   43,   44,   45,  257,   47,
 /*  5600 */   228,  257,  257,  257,  257,  233,  234,  235,  236,  237,
 /*  5610 */   238,  257,  240,  257,  257,  257,  257,  257,  257,  257,
 /*  5620 */   248,  249,  250,  251,  252,  257,  257,   75,  256,  257,
 /*  5630 */   257,  257,  257,  257,  257,    7,    8,    9,  257,  257,
 /*  5640 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  5650 */   257,   23,  257,   25,   26,   27,   28,   29,   30,   31,
 /*  5660 */    32,   33,   34,   35,   36,   37,   38,   39,   40,   41,
 /*  5670 */    42,   43,   44,   45,  257,   47,  257,  153,  257,  257,
 /*  5680 */   257,  257,  257,  257,  257,  257,  162,  163,  257,  257,
 /*  5690 */   257,  257,  257,  257,  257,  257,  257,  257,  174,  257,
 /*  5700 */   257,  257,  257,   75,  257,  257,  257,  257,  257,  257,
 /*  5710 */   257,    7,    8,    9,  257,  191,  257,  257,  257,  195,
 /*  5720 */   196,  257,  198,  199,  257,  257,  202,   23,  257,   25,
 /*  5730 */    26,   27,   28,   29,   30,   31,   32,   33,   34,   35,
 /*  5740 */    36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
 /*  5750 */   257,   47,  228,  257,  257,  257,  257,  233,  234,  235,
 /*  5760 */   236,  237,  238,  239,  240,  257,  257,  257,  257,  257,
 /*  5770 */   257,  257,  248,  249,  250,  251,  252,   61,  257,  257,
 /*  5780 */   257,  257,  257,  257,  148,  257,  257,  151,  257,  153,
 /*  5790 */   257,  257,  257,   77,   78,  257,  160,  257,  162,  163,
 /*  5800 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  5810 */   174,  257,  257,   97,  257,  257,  100,  257,  257,  257,
 /*  5820 */   257,  257,  257,  257,  257,  163,  257,  191,  257,  257,
 /*  5830 */   257,  195,  196,  257,  198,  199,  174,  257,  202,  257,
 /*  5840 */   257,  257,  257,  257,  257,  129,  130,  131,  132,  133,
 /*  5850 */   134,  135,  257,  137,  257,  257,  257,  141,  257,  257,
 /*  5860 */   257,  257,  257,  257,  228,  257,  257,  257,  257,  233,
 /*  5870 */   234,  235,  236,  237,  238,  257,  240,  257,  148,  257,
 /*  5880 */   257,  151,  257,  153,  248,  249,  250,  251,  252,  257,
 /*  5890 */   228,  257,  162,  163,  257,  233,  234,  235,  236,  237,
 /*  5900 */   238,  171,  240,  257,  174,  257,  257,  257,  257,  257,
 /*  5910 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  5920 */   257,  191,  257,  257,  257,  195,  196,  257,  198,  199,
 /*  5930 */   257,  257,  202,  257,  257,  257,  257,  257,  257,  257,
 /*  5940 */   163,  257,  257,  257,  257,  257,  169,  257,  257,  257,
 /*  5950 */   257,  174,  257,  257,  257,  257,  257,  257,  228,  257,
 /*  5960 */   257,  257,  257,  233,  234,  235,  236,  237,  238,  257,
 /*  5970 */   240,  257,  257,  257,  257,  257,  257,  257,  248,  249,
 /*  5980 */   250,  251,  252,  148,  257,  208,  151,  257,  153,  257,
 /*  5990 */   257,  257,  257,  257,  257,  257,  257,  162,  163,  257,
 /*  6000 */   257,  257,  257,  257,  257,  228,  171,  257,  257,  174,
 /*  6010 */   233,  234,  235,  236,  237,  238,  257,  240,  257,  257,
 /*  6020 */   257,  257,  257,  257,  257,  257,  191,  257,  257,  257,
 /*  6030 */   195,  196,  257,  198,  199,  257,  257,  202,  257,  257,
 /*  6040 */   257,  257,   61,  257,  257,  257,  257,  257,  257,  257,
 /*  6050 */   148,  257,  257,  151,  257,  153,  257,  257,   77,   78,
 /*  6060 */   158,  257,  257,  228,  162,  163,  257,  257,  233,  234,
 /*  6070 */   235,  236,  237,  238,  257,  240,  174,  148,   97,  257,
 /*  6080 */   151,  100,  153,  248,  249,  250,  251,  252,  107,  257,
 /*  6090 */   257,  162,  163,  191,  257,  257,  257,  195,  196,  257,
 /*  6100 */   198,  199,  173,  174,  202,  257,  257,  257,  257,  257,
 /*  6110 */   129,  130,  131,  132,  133,  134,  135,  257,  137,  257,
 /*  6120 */   191,  257,  257,  257,  195,  196,  257,  198,  199,  257,
 /*  6130 */   228,  202,  257,  257,  257,  233,  234,  235,  236,  237,
 /*  6140 */   238,  257,  240,  257,  257,  257,  257,  257,  257,  257,
 /*  6150 */   248,  249,  250,  251,  252,  257,  257,  228,  257,  257,
 /*  6160 */   257,  257,  233,  234,  235,  236,  237,  238,  257,  240,
 /*  6170 */   257,  257,  257,  257,  257,  257,  257,  248,  249,  250,
 /*  6180 */   251,  252,  257,  257,  153,  257,  257,  257,  257,  257,
 /*  6190 */   257,  257,  257,  162,  163,  257,  257,  257,  257,  257,
 /*  6200 */   257,  257,  257,  257,  257,  174,  257,  257,  257,  257,
 /*  6210 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  6220 */   257,  257,  191,  257,  257,  257,  195,  196,  257,  198,
 /*  6230 */   199,  257,  257,  202,  257,  257,  257,  257,  257,  257,
 /*  6240 */   257,  257,  257,  257,  213,  214,  257,  257,  257,  257,
 /*  6250 */   257,  153,  257,  257,  257,  257,  257,  257,  257,  228,
 /*  6260 */   162,  163,  257,  257,  233,  234,  235,  236,  237,  238,
 /*  6270 */   257,  240,  174,  257,  257,  257,  257,  257,  257,  248,
 /*  6280 */   249,  250,  251,  252,  257,  257,  257,  257,  257,  191,
 /*  6290 */   257,  257,  257,  195,  196,  257,  198,  199,  257,  257,
 /*  6300 */   202,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  6310 */   257,  213,  214,  257,  257,  257,  257,  257,  153,  257,
 /*  6320 */   257,  257,  257,  257,  257,  257,  228,  162,  163,  257,
 /*  6330 */   257,  233,  234,  235,  236,  237,  238,  257,  240,  174,
 /*  6340 */   257,  257,  257,  257,  257,  257,  248,  249,  250,  251,
 /*  6350 */   252,  257,  257,  257,  257,  257,  191,  257,  257,  257,
 /*  6360 */   195,  196,  257,  198,  199,  257,  257,  202,  257,  257,
 /*  6370 */   257,  257,  257,  257,  257,  257,  257,  257,  213,  214,
 /*  6380 */   257,  257,  257,  257,  257,  257,  257,  153,  257,  257,
 /*  6390 */   257,  257,  257,  228,  257,  257,  162,  163,  233,  234,
 /*  6400 */   235,  236,  237,  238,  257,  240,  257,  257,  174,  257,
 /*  6410 */   257,  257,  257,  248,  249,  250,  251,  252,  257,  257,
 /*  6420 */   257,  257,  257,  257,  257,  191,  257,  257,  257,  195,
 /*  6430 */   196,  257,  198,  199,  257,  257,  202,  257,  257,  257,
 /*  6440 */   257,  257,  257,  257,  257,  257,  257,  213,  214,  257,
 /*  6450 */   257,  257,  257,  257,  153,  257,  257,  257,  257,  257,
 /*  6460 */   257,  257,  228,  162,  163,  257,  257,  233,  234,  235,
 /*  6470 */   236,  237,  238,  257,  240,  174,  148,  257,  257,  151,
 /*  6480 */   257,  153,  248,  249,  250,  251,  252,  257,  257,  257,
 /*  6490 */   162,  163,  191,  257,  257,  257,  195,  196,  257,  198,
 /*  6500 */   199,  257,  174,  202,  257,  257,  257,  257,  257,  257,
 /*  6510 */   257,  257,  257,  257,  213,  214,  257,  257,  257,  191,
 /*  6520 */   257,  257,  257,  195,  196,  257,  198,  199,  257,  228,
 /*  6530 */   202,  257,  257,  257,  233,  234,  235,  236,  237,  238,
 /*  6540 */   257,  240,  257,  163,  257,  257,  257,  257,  257,  248,
 /*  6550 */   249,  250,  251,  252,  174,  257,  228,  257,  257,  257,
 /*  6560 */   257,  233,  234,  235,  236,  237,  238,  257,  240,  257,
 /*  6570 */   257,  257,  257,  257,  257,  257,  248,  249,  250,  251,
 /*  6580 */   252,  148,  257,  257,  151,  257,  153,  257,  208,  257,
 /*  6590 */   257,  257,  257,  257,  257,  162,  163,  257,  257,  257,
 /*  6600 */   257,  257,  257,  257,  257,  257,  257,  174,  228,  257,
 /*  6610 */   257,  257,  257,  233,  234,  235,  236,  237,  238,  257,
 /*  6620 */   240,  257,  257,  257,  191,  257,  257,  257,  195,  196,
 /*  6630 */   257,  198,  199,  257,  257,  202,  257,  257,  257,  257,
 /*  6640 */   257,  257,  257,  257,  257,  257,  257,  257,  148,  257,
 /*  6650 */   257,  151,  257,  153,  257,  257,  257,  257,  257,  257,
 /*  6660 */   257,  228,  162,  163,  257,  257,  233,  234,  235,  236,
 /*  6670 */   237,  238,  257,  240,  174,  148,  257,  257,  151,  257,
 /*  6680 */   153,  248,  249,  250,  251,  252,  257,  257,  257,  162,
 /*  6690 */   163,  191,  257,  257,  257,  195,  196,  257,  198,  199,
 /*  6700 */   257,  174,  202,  257,  257,  257,  257,  257,  257,  257,
 /*  6710 */   257,  257,  257,  257,  257,  257,  257,  257,  191,  257,
 /*  6720 */   257,  257,  195,  196,  257,  198,  199,  257,  228,  202,
 /*  6730 */   257,  257,  257,  233,  234,  235,  236,  237,  238,  257,
 /*  6740 */   240,  257,  163,  257,  257,  257,  257,  257,  248,  249,
 /*  6750 */   250,  251,  252,  174,  257,  228,  257,  257,  257,  257,
 /*  6760 */   233,  234,  235,  236,  237,  238,  257,  240,  257,  257,
 /*  6770 */   257,  257,  257,  257,  257,  248,  249,  250,  251,  252,
 /*  6780 */   257,  257,  153,  257,  257,  257,  257,  208,  257,  257,
 /*  6790 */   257,  162,  163,  257,  257,  257,  257,  257,  257,  257,
 /*  6800 */   257,  257,  257,  174,  257,  257,  257,  228,  257,  257,
 /*  6810 */   257,  257,  233,  234,  235,  236,  237,  238,  257,  240,
 /*  6820 */   191,  257,  257,  257,  195,  196,  257,  198,  199,  257,
 /*  6830 */   257,  202,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  6840 */   257,  257,  213,  214,  257,  257,  257,  257,  257,  257,
 /*  6850 */   257,  257,  257,  257,  257,  257,  257,  228,  257,  257,
 /*  6860 */   257,  257,  233,  234,  235,  236,  237,  238,  257,  240,
 /*  6870 */   257,    8,    9,  257,  257,  257,  257,  248,  249,  250,
 /*  6880 */   251,  252,  257,  257,  257,  257,   23,  257,   25,   26,
 /*  6890 */    27,   28,   29,   30,   31,   32,   33,   34,   35,   36,
 /*  6900 */    37,   38,   39,   40,   41,   42,   43,   44,   45,  153,
 /*  6910 */    47,  257,  257,  257,  257,  257,  257,  257,  162,  163,
 /*  6920 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  6930 */   174,  257,  257,  257,  257,  257,  153,  257,  257,  257,
 /*  6940 */   257,  257,  257,  257,  257,  162,  163,  191,  257,  257,
 /*  6950 */   257,  195,  196,  257,  198,  199,  257,  174,  202,  257,
 /*  6960 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  6970 */   257,  257,  257,  257,  191,  257,  257,  257,  195,  196,
 /*  6980 */   257,  198,  199,  257,  228,  202,  257,  257,  257,  233,
 /*  6990 */   234,  235,  236,  237,  238,  257,  240,  257,  257,  257,
 /*  7000 */   257,  257,  257,  257,  248,  249,  250,  251,  252,  257,
 /*  7010 */   257,  228,  257,  257,  257,  257,  233,  234,  235,  236,
 /*  7020 */   237,  238,  257,  240,  257,  257,  257,  257,  257,  257,
 /*  7030 */   163,  248,  249,  250,  251,  252,  169,  257,  257,  257,
 /*  7040 */   153,  174,  257,  257,  257,  257,  257,  257,  257,  162,
 /*  7050 */   163,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  7060 */   257,  174,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  7070 */   257,  257,  257,  257,  257,  208,  257,  257,  191,  257,
 /*  7080 */   257,  257,  195,  196,  257,  198,  199,  257,  257,  202,
 /*  7090 */   257,  257,  257,  257,  257,  228,  257,  257,  257,  257,
 /*  7100 */   233,  234,  235,  236,  237,  238,  257,  240,  153,  257,
 /*  7110 */   257,  257,  257,  257,  257,  228,  257,  162,  163,  257,
 /*  7120 */   233,  234,  235,  236,  237,  238,  257,  240,  257,  174,
 /*  7130 */   257,  257,  257,  257,  257,  248,  249,  250,  251,  252,
 /*  7140 */   257,  257,  257,  257,  257,  257,  191,  257,  257,  257,
 /*  7150 */   195,  196,  257,  198,  199,  257,  257,  202,  257,  257,
 /*  7160 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  7170 */   257,  257,  257,  257,  257,  153,  257,  257,  257,  257,
 /*  7180 */   257,  257,  257,  228,  162,  163,  257,  257,  233,  234,
 /*  7190 */   235,  236,  237,  238,  257,  240,  174,  257,  257,  257,
 /*  7200 */   257,  257,  257,  248,  249,  250,  251,  252,  257,  257,
 /*  7210 */   257,  257,  257,  191,  257,  257,  257,  195,  196,  257,
 /*  7220 */   198,  199,  257,  257,  202,  257,  257,  257,  257,  257,
 /*  7230 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  7240 */   257,  257,  257,  153,  257,  257,  257,  257,  257,  257,
 /*  7250 */   228,  257,  162,  163,  257,  233,  234,  235,  236,  237,
 /*  7260 */   238,  257,  240,  257,  174,  257,  257,  257,  257,  257,
 /*  7270 */   248,  249,  250,  251,  252,  257,  257,  257,  257,  257,
 /*  7280 */   257,  191,  257,  257,  257,  195,  196,  257,  198,  199,
 /*  7290 */   257,  257,  202,  257,  257,  257,  257,  257,  257,  163,
 /*  7300 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  7310 */   174,  153,  257,  257,  257,  257,  257,  257,  228,  257,
 /*  7320 */   162,  163,  257,  233,  234,  235,  236,  237,  238,  257,
 /*  7330 */   240,  257,  174,  257,  257,  257,  257,  257,  248,  249,
 /*  7340 */   250,  251,  252,  257,  208,  257,  257,  257,  257,  191,
 /*  7350 */   257,  257,  257,  195,  196,  257,  198,  199,  257,  257,
 /*  7360 */   202,  257,  257,  257,  228,  257,  257,  257,  163,  233,
 /*  7370 */   234,  235,  236,  237,  238,  257,  240,  257,  153,  174,
 /*  7380 */   257,  257,  257,  257,  257,  257,  228,  162,  163,  257,
 /*  7390 */   257,  233,  234,  235,  236,  237,  238,  257,  240,  174,
 /*  7400 */   257,  257,  257,  257,  257,  257,  248,  249,  250,  251,
 /*  7410 */   252,  257,  257,  208,  257,  257,  191,  257,  257,  257,
 /*  7420 */   195,  196,  257,  198,  199,  257,  257,  202,  257,  257,
 /*  7430 */   257,  257,  257,  228,  257,  257,  163,  257,  233,  234,
 /*  7440 */   235,  236,  237,  238,  257,  240,  153,  174,  257,  257,
 /*  7450 */   257,  257,  257,  228,  257,  162,  163,  257,  233,  234,
 /*  7460 */   235,  236,  237,  238,  257,  240,  257,  174,  257,  257,
 /*  7470 */   257,  257,  257,  248,  249,  250,  251,  252,  257,  257,
 /*  7480 */   257,  208,  257,  257,  191,  257,  257,  257,  195,  196,
 /*  7490 */   257,  198,  199,  257,  257,  202,  257,  257,  257,  257,
 /*  7500 */   257,  228,  257,  257,  257,  163,  233,  234,  235,  236,
 /*  7510 */   237,  238,  257,  240,  153,  257,  174,  257,  257,  257,
 /*  7520 */   257,  228,  257,  162,  163,  257,  233,  234,  235,  236,
 /*  7530 */   237,  238,  257,  240,  257,  174,  257,  257,  257,  257,
 /*  7540 */   257,  248,  249,  250,  251,  252,  257,  257,  257,  257,
 /*  7550 */   208,  257,  191,  257,  257,  257,  195,  196,  257,  198,
 /*  7560 */   199,  257,  257,  202,  257,  257,  257,  257,  257,  257,
 /*  7570 */   228,  257,  257,  163,  257,  233,  234,  235,  236,  237,
 /*  7580 */   238,  153,  240,  257,  174,  257,  257,  257,  257,  228,
 /*  7590 */   162,  163,  257,  257,  233,  234,  235,  236,  237,  238,
 /*  7600 */   257,  240,  174,  257,  257,  257,  257,  257,  257,  248,
 /*  7610 */   249,  250,  251,  252,  257,  257,  257,  257,  208,  191,
 /*  7620 */   257,  257,  257,  195,  196,  257,  198,  199,  257,  257,
 /*  7630 */   202,  257,  257,  257,  257,  257,  257,  257,  228,  257,
 /*  7640 */   257,  257,  257,  233,  234,  235,  236,  237,  238,  153,
 /*  7650 */   240,  257,  257,  257,  257,  257,  228,  257,  162,  163,
 /*  7660 */   257,  233,  234,  235,  236,  237,  238,  257,  240,  257,
 /*  7670 */   174,  257,  257,  257,  257,  257,  248,  249,  250,  251,
 /*  7680 */   252,  257,  257,  257,  257,  257,  257,  191,  257,  257,
 /*  7690 */   257,  195,  196,  257,  198,  199,  257,  257,  202,  257,
 /*  7700 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  7710 */   257,  257,  257,  257,  257,  257,  257,  153,  257,  257,
 /*  7720 */   257,  257,  257,  257,  228,  257,  162,  163,  257,  233,
 /*  7730 */   234,  235,  236,  237,  238,  257,  240,  257,  174,  257,
 /*  7740 */   257,  257,  257,  257,  248,  249,  250,  251,  252,  257,
 /*  7750 */   257,  257,  257,  257,  257,  191,  257,  257,  257,  195,
 /*  7760 */   196,  257,  198,  199,  257,  257,  202,  257,  257,  257,
 /*  7770 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  7780 */   257,  257,  257,  257,  153,  257,  257,  257,  257,  257,
 /*  7790 */   257,  257,  228,  162,  163,  257,  257,  233,  234,  235,
 /*  7800 */   236,  237,  238,  257,  240,  174,  257,  257,  257,  257,
 /*  7810 */   257,  257,  248,  249,  250,  251,  252,  257,  257,  257,
 /*  7820 */   257,  257,  191,  257,  257,  257,  195,  196,  257,  198,
 /*  7830 */   199,  257,  257,  202,  257,  257,  257,  257,  257,  257,
 /*  7840 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  7850 */   257,  257,  153,  257,  257,  257,  257,  257,  257,  228,
 /*  7860 */   257,  162,  163,  257,  233,  234,  235,  236,  237,  238,
 /*  7870 */   257,  240,  257,  174,  257,  257,  257,  257,  257,  248,
 /*  7880 */   249,  250,  251,  252,  257,  257,  257,  257,  257,  257,
 /*  7890 */   191,  257,  257,  257,  195,  196,  257,  198,  199,  257,
 /*  7900 */   257,  202,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  7910 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  7920 */   153,  257,  257,  257,  257,  257,  257,  228,  257,  162,
 /*  7930 */   163,  257,  233,  234,  235,  236,  237,  238,  257,  240,
 /*  7940 */   257,  174,  257,  257,  257,  257,  257,  248,  249,  250,
 /*  7950 */   251,  252,  257,  257,  257,  257,  257,  257,  191,  257,
 /*  7960 */   257,  257,  195,  196,  257,  198,  199,  257,  257,  202,
 /*  7970 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  7980 */   257,  257,  257,  257,  257,  257,  257,  153,  257,  257,
 /*  7990 */   257,  257,  257,  257,  257,  228,  162,  163,  257,  257,
 /*  8000 */   233,  234,  235,  236,  237,  238,  257,  240,  174,  257,
 /*  8010 */   257,  257,  257,  257,  257,  248,  249,  250,  251,  252,
 /*  8020 */   257,  257,  257,  257,  257,  191,  257,  257,  257,  195,
 /*  8030 */   196,  257,  198,  199,  257,  257,  202,  257,  257,  257,
 /*  8040 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  8050 */   257,  257,  257,  257,  257,  153,  257,  257,  257,  257,
 /*  8060 */   257,  257,  228,  257,  162,  163,  257,  233,  234,  235,
 /*  8070 */   236,  237,  238,  257,  240,  257,  174,  257,  257,  257,
 /*  8080 */   257,  257,  248,  249,  250,  251,  252,  257,  257,  257,
 /*  8090 */   257,  257,  257,  191,  257,  257,  257,  195,  196,  257,
 /*  8100 */   198,  199,  257,  257,  202,  257,  257,  257,  257,  257,
 /*  8110 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  8120 */   257,  257,  257,  153,  257,  257,  257,  257,  257,  257,
 /*  8130 */   228,  257,  162,  163,  257,  233,  234,  235,  236,  237,
 /*  8140 */   238,  257,  240,  257,  174,  257,  257,  257,  257,  257,
 /*  8150 */   248,  249,  250,  251,  252,  257,  257,  257,  257,  257,
 /*  8160 */   257,  191,  257,  257,  257,  195,  196,  257,  198,  199,
 /*  8170 */   257,  257,  202,  257,  257,  257,  257,  257,  257,  257,
 /*  8180 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  8190 */   153,  257,  257,  257,  257,  257,  257,  257,  228,  162,
 /*  8200 */   163,  257,  257,  233,  234,  235,  236,  237,  238,  257,
 /*  8210 */   240,  174,  257,  257,  257,  257,  257,  257,  248,  249,
 /*  8220 */   250,  251,  252,  257,  257,  257,  257,  257,  191,  257,
 /*  8230 */   257,  257,  195,  196,  257,  198,  199,  257,  257,  202,
 /*  8240 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  8250 */   257,  257,  257,  257,  257,  257,  257,  257,  153,  257,
 /*  8260 */   257,  257,  257,  257,  257,  228,  257,  162,  163,  257,
 /*  8270 */   233,  234,  235,  236,  237,  238,  257,  240,  257,  174,
 /*  8280 */   257,  257,  257,  257,  257,  248,  249,  250,  251,  252,
 /*  8290 */   257,  257,  257,  257,  257,  257,  191,  257,  257,  257,
 /*  8300 */   195,  196,  257,  198,  199,  257,  257,  202,  257,  257,
 /*  8310 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  8320 */   257,  257,  257,  257,  257,  257,  153,  257,  257,  257,
 /*  8330 */   257,  257,  257,  228,  257,  162,  163,  257,  233,  234,
 /*  8340 */   235,  236,  237,  238,  257,  240,  257,  174,  257,  257,
 /*  8350 */   257,  257,  257,  248,  249,  250,  251,  252,  257,  257,
 /*  8360 */   257,  257,  257,  257,  191,  257,  257,  257,  195,  196,
 /*  8370 */   257,  198,  199,  257,  257,  202,  257,  257,  257,  257,
 /*  8380 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  8390 */   257,  257,  257,  153,  257,  257,  257,  257,  257,  257,
 /*  8400 */   257,  228,  162,  163,  257,  257,  233,  234,  235,  236,
 /*  8410 */   237,  238,  257,  240,  174,  257,  257,  257,  257,  257,
 /*  8420 */   257,  248,  249,  250,  251,  252,  257,  257,  257,  257,
 /*  8430 */   257,  191,  257,  257,  257,  195,  196,  257,  198,  199,
 /*  8440 */   257,  257,  202,  257,  257,  257,  257,  257,  257,  257,
 /*  8450 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  8460 */   257,  153,  257,  257,  257,  257,  257,  257,  228,  257,
 /*  8470 */   162,  163,  257,  233,  234,  235,  236,  237,  238,  257,
 /*  8480 */   240,  257,  174,  257,  257,  257,  257,  257,  248,  249,
 /*  8490 */   250,  251,  252,  257,  257,  257,  257,  257,  257,  191,
 /*  8500 */   257,  257,  257,  195,  196,  257,  198,  199,  257,  257,
 /*  8510 */   202,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  8520 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  153,
 /*  8530 */   257,  257,  257,  257,  257,  257,  228,  257,  162,  163,
 /*  8540 */   257,  233,  234,  235,  236,  237,  238,  257,  240,  257,
 /*  8550 */   174,  257,  257,  257,  257,  257,  248,  249,  250,  251,
 /*  8560 */   252,  257,  257,  257,  257,  257,  257,  191,  257,  257,
 /*  8570 */   257,  195,  196,  257,  198,  199,  257,  257,  202,  257,
 /*  8580 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  8590 */   257,  257,  257,  257,  257,  257,  153,  257,  257,  257,
 /*  8600 */   257,  257,  257,  257,  228,  162,  163,  257,  257,  233,
 /*  8610 */   234,  235,  236,  237,  238,  257,  240,  174,  257,  257,
 /*  8620 */   257,  257,  257,  257,  248,  249,  250,  251,  252,  257,
 /*  8630 */   257,  257,  257,  257,  191,  257,  257,  257,  195,  196,
 /*  8640 */   257,  198,  199,  257,  257,  202,  257,  257,  257,  257,
 /*  8650 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  8660 */   257,  257,  257,  257,  153,  257,  257,  257,  257,  257,
 /*  8670 */   257,  228,  257,  162,  163,  257,  233,  234,  235,  236,
 /*  8680 */   237,  238,  257,  240,  257,  174,  257,  257,  257,  257,
 /*  8690 */   257,  248,  249,  250,  251,  252,  257,  257,  257,  257,
 /*  8700 */   257,  257,  191,  257,  257,  257,  195,  196,  257,  198,
 /*  8710 */   199,  257,  257,  202,  257,  257,  257,  257,  257,  257,
 /*  8720 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  8730 */   257,  257,  153,  257,  257,  257,  257,  257,  257,  228,
 /*  8740 */   257,  162,  163,  257,  233,  234,  235,  236,  237,  238,
 /*  8750 */   257,  240,  257,  174,  257,  257,  257,  257,  257,  248,
 /*  8760 */   249,  250,  251,  252,  257,  257,  257,  257,  257,  257,
 /*  8770 */   191,  257,  257,  257,  195,  196,  257,  198,  199,  257,
 /*  8780 */   257,  202,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  8790 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  153,
 /*  8800 */   257,  257,  257,  257,  257,  257,  257,  228,  162,  163,
 /*  8810 */   257,  257,  233,  234,  235,  236,  237,  238,  257,  240,
 /*  8820 */   174,  257,  257,  257,  257,  257,  257,  248,  249,  250,
 /*  8830 */   251,  252,  257,  257,  257,  257,  257,  191,  257,  257,
 /*  8840 */   257,  195,  196,  257,  198,  199,  257,  257,  202,  257,
 /*  8850 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  8860 */   257,  257,  257,  257,  257,  257,  257,  153,  257,  257,
 /*  8870 */   257,  257,  257,  257,  228,  257,  162,  163,  257,  233,
 /*  8880 */   234,  235,  236,  237,  238,  257,  240,  257,  174,  257,
 /*  8890 */   257,  257,  257,  257,  248,  249,  250,  251,  252,  257,
 /*  8900 */   257,  257,  257,  257,  257,  191,  257,  257,  257,  195,
 /*  8910 */   196,  257,  198,  199,  257,  257,  202,  257,  257,  257,
 /*  8920 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  8930 */   257,  257,  257,  257,  257,  153,  257,  257,  257,  257,
 /*  8940 */   257,  257,  228,  257,  162,  163,  257,  233,  234,  235,
 /*  8950 */   236,  237,  238,  257,  240,  257,  174,  257,  257,  257,
 /*  8960 */   257,  257,  248,  249,  250,  251,  252,  257,  257,  257,
 /*  8970 */   257,  257,  257,  191,  257,  257,  257,  195,  196,  257,
 /*  8980 */   198,  199,  257,  257,  202,  257,  257,  257,  257,  257,
 /*  8990 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  9000 */   257,  257,  153,  257,  257,  257,  257,  257,  257,  257,
 /*  9010 */   228,  162,  163,  257,  257,  233,  234,  235,  236,  237,
 /*  9020 */   238,  257,  240,  174,  257,  257,  257,  257,  257,  257,
 /*  9030 */   248,  249,  250,  251,  252,  257,  257,  257,  257,  257,
 /*  9040 */   191,  257,  257,  257,  195,  196,  257,  198,  199,  257,
 /*  9050 */   257,  202,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  9060 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  9070 */   153,  257,  257,  257,  257,  257,  257,  228,  257,  162,
 /*  9080 */   163,  257,  233,  234,  235,  236,  237,  238,  257,  240,
 /*  9090 */   257,  174,  257,  257,  257,  257,  257,  248,  249,  250,
 /*  9100 */   251,  252,  257,  257,  257,  257,  257,  257,  191,  257,
 /*  9110 */   257,  257,  195,  196,  257,  198,  199,  257,  257,  202,
 /*  9120 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  9130 */   257,  257,  257,  257,  257,  257,  257,  257,  153,  257,
 /*  9140 */   257,  257,  257,  257,  257,  228,  257,  162,  163,  257,
 /*  9150 */   233,  234,  235,  236,  237,  238,  257,  240,  257,  174,
 /*  9160 */   257,  257,  257,  257,  257,  248,  249,  250,  251,  252,
 /*  9170 */   257,  257,  257,  257,  257,  257,  191,  257,  257,  257,
 /*  9180 */   195,  196,  257,  198,  199,  257,  257,  202,  257,  257,
 /*  9190 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  9200 */   257,  257,  257,  257,  257,  153,  257,  257,  257,  257,
 /*  9210 */   257,  257,  257,  228,  162,  163,  257,  257,  233,  234,
 /*  9220 */   235,  236,  237,  238,  257,  240,  174,  257,  257,  257,
 /*  9230 */   257,  257,  257,  248,  249,  250,  251,  252,  257,  257,
 /*  9240 */   257,  257,  257,  191,  257,  257,  257,  195,  196,  257,
 /*  9250 */   198,  199,  257,  257,  202,  257,  257,  257,  257,  257,
 /*  9260 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  9270 */   257,  257,  257,  153,  257,  257,  257,  257,  257,  257,
 /*  9280 */   228,  257,  162,  163,  257,  233,  234,  235,  236,  237,
 /*  9290 */   238,  257,  240,  257,  174,  257,  257,  257,  257,  257,
 /*  9300 */   248,  249,  250,  251,  252,  257,  257,  257,  257,  257,
 /*  9310 */   257,  191,  257,  257,  257,  195,  196,  257,  198,  199,
 /*  9320 */   257,  257,  202,  257,  257,  257,  257,  257,  257,  257,
 /*  9330 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  9340 */   257,  153,  257,  257,  257,  257,  257,  257,  228,  257,
 /*  9350 */   162,  163,  257,  233,  234,  235,  236,  237,  238,  257,
 /*  9360 */   240,  257,  174,  257,  257,  257,  257,  257,  248,  249,
 /*  9370 */   250,  251,  252,  257,  257,  257,  257,  257,  257,  191,
 /*  9380 */   257,  257,  257,  195,  196,  257,  198,  199,  257,  257,
 /*  9390 */   202,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  9400 */   257,  257,  257,  257,  257,  257,  257,  257,  153,  257,
 /*  9410 */   257,  257,  257,  257,  257,  257,  228,  162,  163,  257,
 /*  9420 */   257,  233,  234,  235,  236,  237,  238,  257,  240,  174,
 /*  9430 */   257,  257,  257,  257,  257,  257,  248,  249,  250,  251,
 /*  9440 */   252,  257,  257,  257,  257,  257,  191,  257,  257,  257,
 /*  9450 */   195,  196,  257,  198,  199,  257,  257,  202,  257,  257,
 /*  9460 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  9470 */   257,  257,  257,  257,  257,  257,  153,  257,  257,  257,
 /*  9480 */   257,  257,  257,  228,  257,  162,  163,  257,  233,  234,
 /*  9490 */   235,  236,  237,  238,  257,  240,  257,  174,  257,  257,
 /*  9500 */   257,  257,  257,  248,  249,  250,  251,  252,  257,  257,
 /*  9510 */   257,  257,  257,  257,  191,  257,  257,  257,  195,  196,
 /*  9520 */   257,  198,  199,  257,  257,  202,  257,  257,  257,  257,
 /*  9530 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  9540 */   257,  257,  257,  257,  153,  257,  257,  257,  257,  257,
 /*  9550 */   257,  228,  257,  162,  163,  257,  233,  234,  235,  236,
 /*  9560 */   237,  238,  257,  240,  257,  174,  257,  257,  257,  257,
 /*  9570 */   257,  248,  249,  250,  251,  252,  257,  257,  257,  257,
 /*  9580 */   257,  257,  191,  257,  257,  257,  195,  196,  257,  198,
 /*  9590 */   199,  257,  257,  202,  257,  257,  257,  257,  257,  257,
 /*  9600 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  9610 */   257,  153,  257,  257,  257,  257,  257,  257,  257,  228,
 /*  9620 */   162,  163,  257,  257,  233,  234,  235,  236,  237,  238,
 /*  9630 */   257,  240,  174,  257,  257,  257,  257,  257,  257,  248,
 /*  9640 */   249,  250,  251,  252,  257,  257,  257,  257,  257,  191,
 /*  9650 */   257,  257,  257,  195,  196,  257,  198,  199,  257,  257,
 /*  9660 */   202,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  9670 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  153,
 /*  9680 */   257,  257,  257,  257,  257,  257,  228,  257,  162,  163,
 /*  9690 */   257,  233,  234,  235,  236,  237,  238,  257,  240,  257,
 /*  9700 */   174,  257,  257,  257,  257,  257,  248,  249,  250,  251,
 /*  9710 */   252,  257,  257,  257,  257,  257,  257,  191,  257,  257,
 /*  9720 */   257,  195,  196,  257,  198,  199,  257,  257,  202,  257,
 /*  9730 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  9740 */   257,  257,  257,  257,  257,  257,  257,  153,  257,  257,
 /*  9750 */   257,  257,  257,  257,  228,  257,  162,  163,  257,  233,
 /*  9760 */   234,  235,  236,  237,  238,  257,  240,  257,  174,  257,
 /*  9770 */   257,  257,  257,  257,  248,  249,  250,  251,  252,  257,
 /*  9780 */   257,  257,  257,  257,  257,  191,  257,  257,  257,  195,
 /*  9790 */   196,  257,  198,  199,  257,  257,  202,  257,  257,  257,
 /*  9800 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  9810 */   257,  257,  257,  257,  153,  257,  257,  257,  257,  257,
 /*  9820 */   257,  257,  228,  162,  163,  257,  257,  233,  234,  235,
 /*  9830 */   236,  237,  238,  257,  240,  174,  257,  257,  257,  257,
 /*  9840 */   257,  257,  248,  249,  250,  251,  252,  257,  257,  257,
 /*  9850 */   257,  257,  191,  257,  257,  257,  195,  196,  257,  198,
 /*  9860 */   199,  257,  257,  202,  257,  257,  257,  257,  257,  257,
 /*  9870 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  9880 */   257,  257,  153,  257,  257,  257,  257,  257,  257,  228,
 /*  9890 */   257,  162,  163,  257,  233,  234,  235,  236,  237,  238,
 /*  9900 */   257,  240,  257,  174,  257,  257,  257,  257,  257,  248,
 /*  9910 */   249,  250,  251,  252,  257,  257,  257,  257,  257,  257,
 /*  9920 */   191,  257,  257,  257,  195,  196,  257,  198,  199,  257,
 /*  9930 */   257,  202,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  9940 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /*  9950 */   153,  257,  257,  257,  257,  257,  257,  228,  257,  162,
 /*  9960 */   163,  257,  233,  234,  235,  236,  237,  238,  257,  240,
 /*  9970 */   257,  174,  257,  257,  257,  257,  257,  248,  249,  250,
 /*  9980 */   251,  252,  257,  257,  257,  257,  257,  257,  191,  257,
 /*  9990 */   257,  257,  195,  196,  257,  198,  199,  257,  257,  202,
 /* 10000 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 10010 */   257,  257,  257,  257,  257,  257,  257,  153,  257,  257,
 /* 10020 */   257,  257,  257,  257,  257,  228,  162,  163,  257,  257,
 /* 10030 */   233,  234,  235,  236,  237,  238,  257,  240,  174,  257,
 /* 10040 */   257,  257,  257,  257,  257,  248,  249,  250,  251,  252,
 /* 10050 */   257,  257,  257,  257,  257,  191,  257,  257,  257,  195,
 /* 10060 */   196,  257,  198,  199,  257,  257,  202,  257,  257,  257,
 /* 10070 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 10080 */   257,  257,  257,  257,  257,  153,  257,  257,  257,  257,
 /* 10090 */   257,  257,  228,  257,  162,  163,  257,  233,  234,  235,
 /* 10100 */   236,  237,  238,  257,  240,  257,  174,  257,  257,  257,
 /* 10110 */   257,  257,  248,  249,  250,  251,  252,  257,  257,  257,
 /* 10120 */   257,  257,  257,  191,  257,  257,  257,  195,  196,  257,
 /* 10130 */   198,  199,  257,  257,  202,  257,  257,  257,  257,  257,
 /* 10140 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 10150 */   257,  257,  257,  153,  257,  257,  257,  257,  257,  257,
 /* 10160 */   228,  257,  162,  163,  257,  233,  234,  235,  236,  237,
 /* 10170 */   238,  257,  240,  257,  174,  257,  257,  257,  257,  257,
 /* 10180 */   248,  249,  250,  251,  252,  257,  257,  257,  257,  257,
 /* 10190 */   257,  191,  257,  257,  257,  195,  196,  257,  198,  199,
 /* 10200 */   257,  257,  202,  257,  257,  257,  257,  257,  257,  257,
 /* 10210 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 10220 */   153,  257,  257,  257,  257,  257,  257,  257,  228,  162,
 /* 10230 */   163,  257,  257,  233,  234,  235,  236,  237,  238,  257,
 /* 10240 */   240,  174,  257,  257,  257,  257,  257,  257,  248,  249,
 /* 10250 */   250,  251,  252,  257,  257,  257,  257,  257,  191,  257,
 /* 10260 */   257,  257,  195,  196,  257,  198,  199,  257,  257,  202,
 /* 10270 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 10280 */   257,  257,  257,  257,  257,  257,  257,  257,  153,  257,
 /* 10290 */   257,  257,  257,  257,  257,  228,  257,  162,  163,  257,
 /* 10300 */   233,  234,  235,  236,  237,  238,  257,  240,  257,  174,
 /* 10310 */   257,  257,  257,  257,  257,  248,  249,  250,  251,  252,
 /* 10320 */   257,  257,  257,  257,  257,  257,  191,  257,  257,  257,
 /* 10330 */   195,  196,  257,  198,  199,  257,  257,  202,  257,  257,
 /* 10340 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 10350 */   257,  257,  257,  257,  257,  257,  153,  257,  257,  257,
 /* 10360 */   257,  257,  257,  228,  257,  162,  163,  257,  233,  234,
 /* 10370 */   235,  236,  237,  238,  257,  240,  257,  174,  257,  257,
 /* 10380 */   257,  257,  257,  248,  249,  250,  251,  252,  257,  257,
 /* 10390 */   257,  257,  257,  257,  191,  257,  257,  257,  195,  196,
 /* 10400 */   257,  198,  199,  257,  257,  202,  257,  257,  257,  257,
 /* 10410 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 10420 */   257,  257,  257,  153,  257,  257,  257,  257,  257,  257,
 /* 10430 */   257,  228,  162,  163,  257,  257,  233,  234,  235,  236,
 /* 10440 */   237,  238,  257,  240,  174,  257,  257,  257,  257,  257,
 /* 10450 */   257,  248,  249,  250,  251,  252,  257,  257,  257,  257,
 /* 10460 */   257,  191,  257,  257,  257,  195,  196,  257,  198,  199,
 /* 10470 */   257,  257,  202,  257,  257,  257,  257,  257,  257,  257,
 /* 10480 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 10490 */   257,  153,  257,  257,  257,  257,  257,  257,  228,  257,
 /* 10500 */   162,  163,  257,  233,  234,  235,  236,  237,  238,  257,
 /* 10510 */   240,  257,  174,  257,  257,  257,  257,  257,  248,  249,
 /* 10520 */   250,  251,  252,  257,  257,  257,  257,  257,  257,  191,
 /* 10530 */   257,  257,  257,  195,  196,  257,  198,  199,  257,  257,
 /* 10540 */   202,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 10550 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  153,
 /* 10560 */   257,  257,  257,  257,  257,  257,  228,  257,  162,  163,
 /* 10570 */   257,  233,  234,  235,  236,  237,  238,  257,  240,  257,
 /* 10580 */   174,  257,  257,  257,  257,  257,  248,  249,  250,  251,
 /* 10590 */   252,  257,  257,  257,  257,  257,  257,  191,  257,  257,
 /* 10600 */   257,  195,  196,  257,  198,  199,  257,  257,  202,  257,
 /* 10610 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 10620 */   257,  257,  257,  257,  257,  257,  153,  257,  257,  257,
 /* 10630 */   257,  257,  257,  257,  228,  162,  163,  257,  257,  233,
 /* 10640 */   234,  235,  236,  237,  238,  257,  240,  174,  257,  257,
 /* 10650 */   257,  257,  257,  257,  248,  249,  250,  251,  252,  257,
 /* 10660 */   257,  257,  257,  257,  191,  257,  257,  257,  195,  196,
 /* 10670 */   257,  198,  199,  257,  257,  202,  257,  257,  257,  257,
 /* 10680 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 10690 */   257,  257,  257,  257,  153,  257,  257,  257,  257,  257,
 /* 10700 */   257,  228,  257,  162,  163,  257,  233,  234,  235,  236,
 /* 10710 */   237,  238,  257,  240,  257,  174,  257,  257,  257,  257,
 /* 10720 */   257,  248,  249,  250,  251,  252,  257,  257,  257,  257,
 /* 10730 */   257,  257,  191,  257,  257,  257,  195,  196,  257,  198,
 /* 10740 */   199,  257,  257,  202,  257,  257,  257,  257,  257,  257,
 /* 10750 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 10760 */   257,  257,  153,  257,  257,  257,  257,  257,  257,  228,
 /* 10770 */   257,  162,  163,  257,  233,  234,  235,  236,  237,  238,
 /* 10780 */   257,  240,  257,  174,  257,  257,  257,  257,  257,  248,
 /* 10790 */   249,  250,  251,  252,  257,  257,  257,  257,  257,  257,
 /* 10800 */   191,  257,  257,  257,  195,  196,  257,  198,  199,  257,
 /* 10810 */   257,  202,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 10820 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  153,
 /* 10830 */   257,  257,  257,  257,  257,  257,  257,  228,  162,  163,
 /* 10840 */   257,  257,  233,  234,  235,  236,  237,  238,  257,  240,
 /* 10850 */   174,  257,  257,  257,  257,  257,  257,  248,  249,  250,
 /* 10860 */   251,  252,  257,  257,  257,  257,  257,  191,  257,  257,
 /* 10870 */   257,  195,  196,  257,  198,  199,  257,  257,  202,  257,
 /* 10880 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 10890 */   257,  257,  257,  257,  257,  257,  257,  153,  257,  257,
 /* 10900 */   257,  257,  257,  257,  228,  257,  162,  163,  257,  233,
 /* 10910 */   234,  235,  236,  237,  238,  257,  240,  257,  174,  257,
 /* 10920 */   257,  257,  257,  257,  248,  249,  250,  251,  252,  257,
 /* 10930 */   257,  257,  257,  257,  257,  191,  257,  257,  257,  195,
 /* 10940 */   196,  257,  198,  199,  257,  257,  202,  257,  257,  257,
 /* 10950 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 10960 */   257,  257,  257,  257,  257,  153,  257,  257,  257,  257,
 /* 10970 */   257,  257,  228,  257,  162,  163,  257,  233,  234,  235,
 /* 10980 */   236,  237,  238,  257,  240,  257,  174,  257,  257,  257,
 /* 10990 */   257,  257,  248,  249,  250,  251,  252,  257,  257,  257,
 /* 11000 */   257,  257,  257,  191,  257,  257,  257,  195,  196,  257,
 /* 11010 */   198,  199,  257,  257,  202,  257,  257,  257,  257,  257,
 /* 11020 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 11030 */   257,  257,  153,  257,  257,  257,  257,  257,  257,  257,
 /* 11040 */   228,  162,  163,  257,  257,  233,  234,  235,  236,  237,
 /* 11050 */   238,  257,  240,  174,  257,  257,  257,  257,  257,  257,
 /* 11060 */   248,  249,  250,  251,  252,  257,  257,  257,  257,  257,
 /* 11070 */   191,  257,  257,  257,  195,  196,  257,  198,  199,  257,
 /* 11080 */   257,  202,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 11090 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 11100 */   153,  257,  257,  257,  257,  257,  257,  228,  257,  162,
 /* 11110 */   163,  257,  233,  234,  235,  236,  237,  238,  257,  240,
 /* 11120 */   257,  174,  257,  257,  257,  257,  257,  248,  249,  250,
 /* 11130 */   251,  252,  257,  257,  257,  257,  257,  257,  191,  257,
 /* 11140 */   257,  257,  195,  196,  257,  198,  199,  257,  257,  202,
 /* 11150 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 11160 */   257,  257,  257,  257,  257,  257,  257,  257,  153,  257,
 /* 11170 */   257,  257,  257,  257,  257,  228,  257,  162,  163,  257,
 /* 11180 */   233,  234,  235,  236,  237,  238,  257,  240,  257,  174,
 /* 11190 */   257,  257,  257,  257,  257,  248,  249,  250,  251,  252,
 /* 11200 */   257,  257,  257,  257,  257,  257,  191,  257,  257,  257,
 /* 11210 */   195,  196,  257,  198,  199,  257,  257,  202,  257,  257,
 /* 11220 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 11230 */   257,  257,  257,  257,  257,  153,  257,  257,  257,  257,
 /* 11240 */   257,  257,  257,  228,  162,  163,  257,  257,  233,  234,
 /* 11250 */   235,  236,  237,  238,  257,  240,  174,  257,  257,  257,
 /* 11260 */   257,  257,  257,  248,  249,  250,  251,  252,  257,  257,
 /* 11270 */   257,  257,  257,  191,  257,  257,  257,  195,  196,  257,
 /* 11280 */   198,  199,  257,  257,  202,  257,  257,  257,  257,  257,
 /* 11290 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 11300 */   257,  257,  257,  153,  257,  257,  257,  257,  257,  257,
 /* 11310 */   228,  257,  162,  163,  257,  233,  234,  235,  236,  237,
 /* 11320 */   238,  257,  240,  257,  174,  257,  257,  257,  257,  257,
 /* 11330 */   248,  249,  250,  251,  252,  257,  257,  257,  257,  257,
 /* 11340 */   257,  191,  257,  257,  257,  195,  196,  257,  198,  199,
 /* 11350 */   257,  257,  202,  257,  257,  257,  257,  257,  257,  257,
 /* 11360 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 11370 */   257,  153,  257,  257,  257,  257,  257,  257,  228,  257,
 /* 11380 */   162,  163,  257,  233,  234,  235,  236,  237,  238,  257,
 /* 11390 */   240,  257,  174,  257,  257,  257,  257,  257,  248,  249,
 /* 11400 */   250,  251,  252,  257,  257,  257,  257,  257,  257,  191,
 /* 11410 */   257,  257,  257,  195,  196,  257,  198,  199,  257,  257,
 /* 11420 */   202,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 11430 */   257,  257,  257,  257,  257,  257,  257,  257,  153,  257,
 /* 11440 */   257,  257,  257,  257,  257,  257,  228,  162,  163,  257,
 /* 11450 */   257,  233,  234,  235,  236,  237,  238,  257,  240,  174,
 /* 11460 */   257,  257,  257,  257,  257,  257,  248,  249,  250,  251,
 /* 11470 */   252,  257,  257,  257,  257,  257,  191,  257,  257,  257,
 /* 11480 */   195,  196,  257,  198,  199,  257,  257,  202,  257,  257,
 /* 11490 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 11500 */   257,  257,  257,  257,  257,  257,  153,  257,  257,  257,
 /* 11510 */   257,  257,  257,  228,  257,  162,  163,  257,  233,  234,
 /* 11520 */   235,  236,  237,  238,  257,  240,  257,  174,  257,  257,
 /* 11530 */   257,  257,  257,  248,  249,  250,  251,  252,  257,  257,
 /* 11540 */   257,  257,  257,  257,  191,  257,  257,  257,  195,  196,
 /* 11550 */   257,  198,  199,  257,  257,  202,  257,  257,  257,  257,
 /* 11560 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 11570 */   257,  257,  257,  257,  153,  257,  257,  257,  257,  257,
 /* 11580 */   257,  228,  257,  162,  163,  257,  233,  234,  235,  236,
 /* 11590 */   237,  238,  257,  240,  257,  174,  257,  257,  257,  257,
 /* 11600 */   257,  248,  249,  250,  251,  252,  257,  257,  257,  257,
 /* 11610 */   257,  257,  191,  257,  257,  257,  195,  196,  257,  198,
 /* 11620 */   199,  257,  257,  202,  257,  257,  257,  257,  257,  257,
 /* 11630 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 11640 */   257,  153,  257,  257,  257,  257,  257,  257,  257,  228,
 /* 11650 */   162,  163,  257,  257,  233,  234,  235,  236,  237,  238,
 /* 11660 */   257,  240,  174,  257,  257,  257,  257,  257,  257,  248,
 /* 11670 */   249,  250,  251,  252,  257,  257,  257,  257,  257,  191,
 /* 11680 */   257,  257,  257,  195,  196,  257,  198,  199,  257,  257,
 /* 11690 */   202,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 11700 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  153,
 /* 11710 */   257,  257,  257,  257,  257,  257,  228,  257,  162,  163,
 /* 11720 */   257,  233,  234,  235,  236,  237,  238,  257,  240,  257,
 /* 11730 */   174,  257,  257,  257,  257,  257,  248,  249,  250,  251,
 /* 11740 */   252,  257,  257,  257,  257,  257,  257,  191,  257,  257,
 /* 11750 */   257,  195,  196,  257,  198,  199,  257,  257,  202,  257,
 /* 11760 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 11770 */   257,  257,  257,  257,  257,  257,  257,  153,  257,  257,
 /* 11780 */   257,  257,  257,  257,  228,  257,  162,  163,  257,  233,
 /* 11790 */   234,  235,  236,  237,  238,  257,  240,  257,  174,  257,
 /* 11800 */   257,  257,  257,  257,  248,  249,  250,  251,  252,  257,
 /* 11810 */   257,  257,  257,  257,  257,  191,  257,  257,  257,  195,
 /* 11820 */   196,  257,  198,  199,  257,  257,  202,  257,  257,  257,
 /* 11830 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 11840 */   257,  257,  257,  257,  153,  257,  257,  257,  257,  257,
 /* 11850 */   257,  257,  228,  162,  163,  257,  257,  233,  234,  235,
 /* 11860 */   236,  237,  238,  257,  240,  174,  257,  257,  257,  257,
 /* 11870 */   257,  257,  248,  249,  250,  251,  252,  257,  257,  257,
 /* 11880 */   257,  257,  191,  257,  257,  257,  195,  196,  257,  198,
 /* 11890 */   199,  257,  257,  202,  257,  257,  257,  257,  257,  257,
 /* 11900 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 11910 */   257,  257,  153,  257,  257,  257,  257,  257,  257,  228,
 /* 11920 */   257,  162,  163,  257,  233,  234,  235,  236,  237,  238,
 /* 11930 */   257,  240,  257,  174,  257,  257,  257,  257,  257,  248,
 /* 11940 */   249,  250,  251,  252,  257,  257,  257,  257,  257,  257,
 /* 11950 */   191,  257,  257,  257,  195,  196,  257,  198,  199,  257,
 /* 11960 */   257,  202,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 11970 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 11980 */   153,  257,  257,  257,  257,  257,  257,  228,  257,  162,
 /* 11990 */   163,  257,  233,  234,  235,  236,  237,  238,  257,  240,
 /* 12000 */   257,  174,  257,  257,  257,  257,  257,  248,  249,  250,
 /* 12010 */   251,  252,  257,  257,  257,  257,  257,  257,  191,  257,
 /* 12020 */   257,  257,  195,  196,  257,  198,  199,  257,  257,  202,
 /* 12030 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 12040 */   257,  257,  257,  257,  257,  257,  257,  153,  257,  257,
 /* 12050 */   257,  257,  257,  257,  257,  228,  162,  163,  257,  257,
 /* 12060 */   233,  234,  235,  236,  237,  238,  257,  240,  174,  257,
 /* 12070 */   257,  257,  257,  257,  257,  248,  249,  250,  251,  252,
 /* 12080 */   257,  257,  257,  257,  257,  191,  257,  257,  257,  195,
 /* 12090 */   196,  257,  198,  199,  257,  257,  202,  257,  257,  257,
 /* 12100 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 12110 */   257,  257,  257,  257,  257,  153,  257,  257,  257,  257,
 /* 12120 */   257,  257,  228,  257,  162,  163,  257,  233,  234,  235,
 /* 12130 */   236,  237,  238,  257,  240,  257,  174,  257,  257,  257,
 /* 12140 */   257,  257,  248,  249,  250,  251,  252,  257,  257,  257,
 /* 12150 */   257,  257,  257,  191,  257,  257,  257,  195,  196,  257,
 /* 12160 */   198,  199,  257,  257,  202,  257,  257,  257,  257,  257,
 /* 12170 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 12180 */   257,  257,  257,  153,  257,  257,  257,  257,  257,  257,
 /* 12190 */   228,  257,  162,  163,  257,  233,  234,  235,  236,  237,
 /* 12200 */   238,  257,  240,  257,  174,  257,  257,  257,  257,  257,
 /* 12210 */   248,  249,  250,  251,  252,  257,  257,  257,  257,  257,
 /* 12220 */   257,  191,  257,  257,  257,  195,  196,  257,  198,  199,
 /* 12230 */   257,  257,  202,  257,  257,  257,  257,  257,  257,  257,
 /* 12240 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 12250 */   153,  257,  257,  257,  257,  257,  257,  257,  228,  162,
 /* 12260 */   163,  257,  257,  233,  234,  235,  236,  237,  238,  257,
 /* 12270 */   240,  174,  257,  257,  257,  257,  257,  257,  248,  249,
 /* 12280 */   250,  251,  252,  257,  257,  257,  257,  257,  191,  257,
 /* 12290 */   257,  257,  195,  196,  257,  198,  199,  257,  257,  202,
 /* 12300 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 12310 */   257,  257,  257,  257,  257,  257,  257,  257,  153,  257,
 /* 12320 */   257,  257,  257,  257,  257,  228,  257,  162,  163,  257,
 /* 12330 */   233,  234,  235,  236,  237,  238,  257,  240,  257,  174,
 /* 12340 */   257,  257,  257,  257,  257,  248,  249,  250,  251,  252,
 /* 12350 */   257,  257,  257,  257,  257,  257,  191,  257,  257,  257,
 /* 12360 */   195,  196,  257,  198,  199,  257,  257,  202,  257,  257,
 /* 12370 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 12380 */   257,  257,  257,  257,  257,  257,  153,  257,  257,  257,
 /* 12390 */   257,  257,  257,  228,  257,  162,  163,  257,  233,  234,
 /* 12400 */   235,  236,  237,  238,  257,  240,  257,  174,  257,  257,
 /* 12410 */   257,  257,  257,  248,  249,  250,  251,  252,  257,  257,
 /* 12420 */   257,  257,  257,  257,  191,  257,  257,  257,  195,  196,
 /* 12430 */   257,  198,  199,  257,  257,  202,  257,  257,  257,  257,
 /* 12440 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 12450 */   257,  257,  257,  153,  257,  257,  257,  257,  257,  257,
 /* 12460 */   257,  228,  162,  163,  257,  257,  233,  234,  235,  236,
 /* 12470 */   237,  238,  257,  240,  174,  257,  257,  257,  257,  257,
 /* 12480 */   257,  248,  249,  250,  251,  252,  257,  257,  257,  257,
 /* 12490 */   257,  191,  257,  257,  257,  195,  196,  257,  198,  199,
 /* 12500 */   257,  257,  202,  257,  257,  257,  257,  257,  257,  257,
 /* 12510 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 12520 */   257,  153,  257,  257,  257,  257,  257,  257,  228,  257,
 /* 12530 */   162,  163,  257,  233,  234,  235,  236,  237,  238,  257,
 /* 12540 */   240,  257,  174,  257,  257,  257,  257,  257,  248,  249,
 /* 12550 */   250,  251,  252,  257,  257,  257,  257,  257,  257,  191,
 /* 12560 */   257,  257,  257,  195,  196,  257,  198,  199,  257,  257,
 /* 12570 */   202,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 12580 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  153,
 /* 12590 */   257,  257,  257,  257,  257,  257,  228,  257,  162,  163,
 /* 12600 */   257,  233,  234,  235,  236,  237,  238,  257,  240,  257,
 /* 12610 */   174,  257,  257,  257,  257,  257,  248,  249,  250,  251,
 /* 12620 */   252,  257,  257,  257,  257,  257,  257,  191,  257,  257,
 /* 12630 */   257,  195,  196,  257,  198,  199,  257,  257,  202,  257,
 /* 12640 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 12650 */   257,  257,  257,  257,  257,  257,  153,  257,  257,  257,
 /* 12660 */   257,  257,  257,  257,  228,  162,  163,  257,  257,  233,
 /* 12670 */   234,  235,  236,  237,  238,  257,  240,  174,  257,  257,
 /* 12680 */   257,  257,  257,  257,  248,  249,  250,  251,  252,  257,
 /* 12690 */   257,  257,  257,  257,  191,  257,  257,  257,  195,  196,
 /* 12700 */   257,  198,  199,  257,  257,  202,  257,  257,  257,  257,
 /* 12710 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 12720 */   257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
 /* 12730 */   257,  228,  257,  257,  257,  257,  233,  234,  235,  236,
 /* 12740 */   237,  238,  257,  240,  257,  257,  257,  257,  257,  257,
 /* 12750 */   257,  248,  249,  250,  251,  252,
);
    const YY_SHIFT_USE_DFLT = -118;
    const YY_SHIFT_MAX = 492;
    static public $yy_shift_ofst = array(
 /*     0 */  -118, 1192, 1065,  948,  704,  821,   -1,  233,  353,  587,
 /*    10 */   470,  116, 1192, 1192, 1309, 1192, 1192, 1563, 1690, 1563,
 /*    20 */  1817, 1436, 1944, 2061, 2061, 2061, 2178, 2178, 2178, 2178,
 /*    30 */  2412, 2178, 2178, 3465, 3465, 3465, 3465, 3465, 3465, 2529,
 /*    40 */  2997, 3231, 3114, 2763, 2880, 2295, 2646, 3348, 3465, 3465,
 /*    50 */  3465, 3465, 3465, 3465, 3465, 3465, 3465, 3465, 3465, 3465,
 /*    60 */  3465, 3465, 3465, 3465, 3465, 3465, 3465, 3465, 3465, 3465,
 /*    70 */  3582, 3465, 3465, 3465, 3465, 3465, 3465, 3465, 3465, 3465,
 /*    80 */  3465, 3465, 3465, 3465, 3465, 3465, 3465, 3465, 3465, 3465,
 /*    90 */  3465, 3465, 3465, 3465, 3465, 3465, 3465, 3465, 3465, 3465,
 /*   100 */  3465, 3465, 3465, 3465, 3465, 3465, 3465, 3465, 3465, 3465,
 /*   110 */  3465, 3465, 3465, 3465, 3465, 3465, 3465, 3465, 3465, 3465,
 /*   120 */  3465, 3465, 3465, 3465, 3465,   94,  643,   94,  643,  211,
 /*   130 */   756,  643,  211,  211,  211,  211,  211,  211,  211,  211,
 /*   140 */   211,  211,  211,  982,  211,  211,  211,  211,  732,  732,
 /*   150 */   732,  639,  639,  639,  639, 2617, 2175, 2409, 2617, 2617,
 /*   160 */  2617, 2617, 2617, 2617, 2617, 2617, 2617, 2617, 2617, 2617,
 /*   170 */  2617, 2617, 2617, 2617, 2617,  799,  760,  331,   -5,   -5,
 /*   180 */  1090,  -66,  -66,  -66,  437, 1232, 1098, 1098, 3997, 4923,
 /*   190 */  5716, 5981, 3801,  -34,  540,  437,  549,  162,  -37,  546,
 /*   200 */   576,  517, 1222, 1098, 1297, 1234, 1098, 1009, 1237, 1247,
 /*   210 */  1098, 1234, 1316, 1107, 1064, 1090, 1098, 1009, 1059, 1022,
 /*   220 */   983, 1114, 1033, 1114, 1110, 1165, 1117, 1153, 1165, 1110,
 /*   230 */  -118, -118, -118, -118, -118, -118, -118, -118, -118, -118,
 /*   240 */  -118, -118, -118, -118, -118, -118, -118, -118, -118, -118,
 /*   250 */  -118, -118, -118, -118, -118, -118, 5080, 5004, 4928, 5156,
 /*   260 */  5235, 5434, 5355, 5276, 4887, 4811, 5552, 4385, 4306, 4229,
 /*   270 */  4150, 4426, 4502, 4074, 4734, 4657, 4581, 5476, 5628, 5704,
 /*   280 */  5704, 5704, 5704, 5704, 5704, 5704, 5704, 5704, 5704, 5704,
 /*   290 */  5704, 6863, 3743,  -15,  -15,  -15,  -15,  -15,  -15,  -15,
 /*   300 */   -15,  -15,  -15,  -15,  -15,  -15,  -15,  -15, 2229,  938,
 /*   310 */  1181, 2344, 2459, 2576, 2576, 2576, 2576, 2576, 3854, 4425,
 /*   320 */  3959, 4627, 1451,  108,  108,  108,  108,   87,   87,  201,
 /*   330 */   201,  201,  201,  201,  498,  661,  412,  672, -117,  175,
 /*   340 */   227,  682,  518,  320,   18,  420,   58,   95,  375,  346,
 /*   350 */   464,  260,  745,   -8,  346,  346,  171,  496,  212,  440,
 /*   360 */   380,  416,  346,  727,  727,  976,  924,  923,  935,  878,
 /*   370 */   873,  863,  869,  871,  435,  913,  882,  908,  988, 1024,
 /*   380 */  1023,  977,  997, 1089,  727, 1005, 1026, 1016, 1018, 1001,
 /*   390 */  1000,  996,  969,   77, 1080, 1008,  -33,  843,  638,  615,
 /*   400 */   586,  622,  650,  736,  642,  730,  585,  511,  526,  560,
 /*   410 */   434,  533,  591,  601,  547,  550,  702,  787,  783,  779,
 /*   420 */   781,  811,  838,  881,  813,  752,  844,  723,  679,  727,
 /*   430 */   795,  830,  739,  750,  751, 1176,  826,  797,  646,  794,
 /*   440 */   880,  792,  774,  794,  652,  541,  554,  531,  563,  583,
 /*   450 */   637,  683,  606,  635,  849, 1074, 1006,  943, 1004, 1025,
 /*   460 */  1030,  980, 1021,  974,  909,  914,  879,  870,  928,  946,
 /*   470 */   972,  883,  937,  896,  942,  944, 1007,   77,  177,  348,
 /*   480 */   254,  359,  284,  406,  401,  425,  -33,   24,  292,    0,
 /*   490 */   115,  138,  182,
);
    const YY_REDUCE_USE_DFLT = -161;
    const YY_REDUCE_MAX = 255;
    static public $yy_reduce_ofst = array(
 /*     0 */   232, 3563, 3657, 3657, 3657, 3657, 3657, 3657, 3657, 3657,
 /*    10 */  3657, 3657, 3657, 3657, 3763, 3657, 3657, 5730, 5636, 5835,
 /*    20 */  5902, 5929, 6433, 6328, 6500, 6527, 6629, 6301, 6165, 6031,
 /*    30 */  3894, 6234, 6098, 4976, 5175, 5372, 4128, 4324, 5524, 9526,
 /*    40 */  9594, 9661, 9458, 9391, 9120, 9188, 9255, 9323, 9729, 9797,
 /*    50 */  10270, 10338, 10406, 10203, 10135, 9864, 9932, 10000, 10067, 9052,
 /*    60 */  8985, 8037, 8105, 8173, 7970, 7902, 7631, 7699, 7767, 7834,
 /*    70 */  8240, 8308, 8782, 8849, 8917, 8714, 8646, 8443, 8511, 8579,
 /*    80 */  10541, 10473, 7564, 11962, 11894, 12436, 12300, 11759, 11624, 10947,
 /*    90 */  10744, 11015, 11082, 11421, 11488, 11353, 11285, 11150, 11218, 10879,
 /*   100 */  10676, 10609, 10812, 11556, 12165, 12368, 12030, 11827, 12503, 12097,
 /*   110 */  11691, 12233, 8376, 7158, 6955, 6783, 6756, 7293, 7361, 7022,
 /*   120 */  7090, 7225, 7428, 7496, 6887, 5777, 2607, 6867, 2841, 2723,
 /*   130 */  3074, 3192, 6579, 3308, 2957, 6380, 7205, 7136, 3425, 7410,
 /*   140 */  7273, 7342, 3973, 4563, 4639, 4487, 5662, 4835, 2774, 2658,
 /*   150 */  2892,  150,   30,  272,  147,  280,  400,  400,   74,  428,
 /*   160 */   789,  662,  294,  632,  -43,  645,   47,  528,  737,  515,
 /*   170 */  -160,  164,  194,  158,  397,   27,   27,  -53,   92,   57,
 /*   180 */   242, -118,  269,  449,   -6,  423,  530,  314, 1128, 1093,
 /*   190 */  1093, 1093, 1093, 1111, 1161, 1102, 1158, 1133, 1097, 1154,
 /*   200 */  1105, 1115, 1151, 1169, 1144, 1200, 1189, 1116, 1159, 1174,
 /*   210 */  1170, 1182, 1043,  973, 1027, 1012, 1014,  941,  906,  885,
 /*   220 */   874,  958, 1015, 1075, 1069, 1040,  998, 1037, 1032, 1091,
 /*   230 */   979, 1109, 1204, 1092, 1184, 1136, 1072, 1168, 1147, 1202,
 /*   240 */   968,  978,  936, 1079, 1028, 1084, 1048, 1047, 1077, 1101,
 /*   250 */  1058, 1112, 1104, 1106, 1036,  984,
);
    static public $yyExpectedTokens = array(
        /* 0 */ array(),
        /* 1 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 2 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 120, 126, 136, 138, 139, 140, 141, 142, ),
        /* 3 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 4 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 5 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 121, 126, 136, 138, 139, 140, 141, 142, ),
        /* 6 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 7 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 119, 126, 136, 138, 139, 140, 141, 142, ),
        /* 8 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 9 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 10 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 11 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 125, 126, 136, 138, 139, 140, 141, 142, ),
        /* 12 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 13 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 14 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 15 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 16 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 68, 69, 73, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 99, 100, 101, 103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 17 */ array(1, 2, 3, 4, 5, 10, 24, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 18 */ array(1, 2, 3, 4, 5, 10, 24, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 19 */ array(1, 2, 3, 4, 5, 10, 24, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 20 */ array(1, 2, 3, 4, 5, 10, 24, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 21 */ array(1, 2, 3, 4, 5, 10, 24, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 22 */ array(1, 2, 3, 4, 5, 10, 24, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 23 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 24 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 25 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 67, 74, 76, 77, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 94, 95, 97, 98, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 26 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 27 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 28 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 29 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 30 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 31 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 32 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 33 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 34 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 35 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 36 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 37 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 38 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 39 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 40 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 76, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 41 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 42 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 43 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 44 */ array(1, 2, 3, 4, 5, 10, 29, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 45 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 75, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 46 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 76, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 47 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 76, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 48 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 49 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 50 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 51 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 52 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 53 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 54 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 55 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 56 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 57 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 58 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 59 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 60 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 61 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 62 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 63 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 64 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 65 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 66 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 67 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 68 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 69 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 70 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 71 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 72 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 73 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 74 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 75 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 76 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 77 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 78 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 79 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 80 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 81 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 82 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 83 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 84 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 85 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 86 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 87 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 88 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 89 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 90 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 91 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 92 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 93 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 94 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 95 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 96 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 97 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 98 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 99 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 100 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 101 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 102 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 103 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 104 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 105 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 106 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 107 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 108 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 109 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 110 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 111 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 112 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 113 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 114 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 115 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 116 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 117 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 118 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 119 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 120 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 121 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 122 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 123 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 124 */ array(1, 2, 3, 4, 5, 10, 40, 41, 46, 48, 49, 50, 51, 52, 53, 55, 56, 57, 58, 59, 60, 62, 63, 74, 97, 100, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 126, 136, 138, 139, 140, 141, 142, ),
        /* 125 */ array(29, 97, 100, 126, ),
        /* 126 */ array(97, 100, 105, 126, ),
        /* 127 */ array(29, 97, 100, 126, ),
        /* 128 */ array(97, 100, 105, 126, ),
        /* 129 */ array(97, 100, 126, ),
        /* 130 */ array(77, 97, 100, 126, ),
        /* 131 */ array(97, 100, 105, 126, ),
        /* 132 */ array(97, 100, 126, ),
        /* 133 */ array(97, 100, 126, ),
        /* 134 */ array(97, 100, 126, ),
        /* 135 */ array(97, 100, 126, ),
        /* 136 */ array(97, 100, 126, ),
        /* 137 */ array(97, 100, 126, ),
        /* 138 */ array(97, 100, 126, ),
        /* 139 */ array(97, 100, 126, ),
        /* 140 */ array(97, 100, 126, ),
        /* 141 */ array(97, 100, 126, ),
        /* 142 */ array(97, 100, 126, ),
        /* 143 */ array(62, 97, 100, 126, ),
        /* 144 */ array(97, 100, 126, ),
        /* 145 */ array(97, 100, 126, ),
        /* 146 */ array(97, 100, 126, ),
        /* 147 */ array(97, 100, 126, ),
        /* 148 */ array(97, 100, 126, ),
        /* 149 */ array(97, 100, 126, ),
        /* 150 */ array(97, 100, 126, ),
        /* 151 */ array(77, 97, 100, 126, ),
        /* 152 */ array(77, 97, 100, 126, ),
        /* 153 */ array(77, 97, 100, 126, ),
        /* 154 */ array(77, 97, 100, 126, ),
        /* 155 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 156 */ array(67, 68, 69, 70, 71, 72, 78, 127, 128, ),
        /* 157 */ array(67, 68, 69, 70, 71, 72, 78, 127, 128, ),
        /* 158 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 159 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 160 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 161 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 162 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 163 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 164 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 165 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 166 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 167 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 168 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 169 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 170 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 171 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 172 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 173 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 174 */ array(40, 41, 100, 108, 109, 110, 111, 112, 113, 114, 115, 116, ),
        /* 175 */ array(97, 100, 126, ),
        /* 176 */ array(97, 100, 126, ),
        /* 177 */ array(97, 126, ),
        /* 178 */ array(75, 100, 108, ),
        /* 179 */ array(75, 100, 108, ),
        /* 180 */ array(96, ),
        /* 181 */ array(97, 126, ),
        /* 182 */ array(97, 126, ),
        /* 183 */ array(97, 126, ),
        /* 184 */ array(97, 126, ),
        /* 185 */ array(97, ),
        /* 186 */ array(100, ),
        /* 187 */ array(100, ),
        /* 188 */ array(7, 8, 9, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 76, ),
        /* 189 */ array(61, 77, 78, 97, 100, 129, 130, 131, 132, 133, 134, 135, 137, 143, ),
        /* 190 */ array(61, 77, 78, 97, 100, 129, 130, 131, 132, 133, 134, 135, 137, 141, ),
        /* 191 */ array(61, 77, 78, 97, 100, 107, 129, 130, 131, 132, 133, 134, 135, 137, ),
        /* 192 */ array(61, 77, 78, 97, 100, 129, 130, 131, 132, 133, 134, 135, 137, 140, ),
        /* 193 */ array(67, 68, 69, 70, 71, 72, 99, ),
        /* 194 */ array(64, 65, ),
        /* 195 */ array(97, 126, ),
        /* 196 */ array(64, 65, ),
        /* 197 */ array(24, 77, ),
        /* 198 */ array(100, 108, ),
        /* 199 */ array(74, 111, ),
        /* 200 */ array(76, 77, ),
        /* 201 */ array(24, 76, ),
        /* 202 */ array(102, ),
        /* 203 */ array(100, ),
        /* 204 */ array(76, ),
        /* 205 */ array(117, ),
        /* 206 */ array(100, ),
        /* 207 */ array(100, ),
        /* 208 */ array(104, ),
        /* 209 */ array(100, ),
        /* 210 */ array(100, ),
        /* 211 */ array(117, ),
        /* 212 */ array(6, ),
        /* 213 */ array(76, ),
        /* 214 */ array(97, ),
        /* 215 */ array(96, ),
        /* 216 */ array(100, ),
        /* 217 */ array(100, ),
        /* 218 */ array(99, ),
        /* 219 */ array(97, ),
        /* 220 */ array(129, ),
        /* 221 */ array(29, ),
        /* 222 */ array(102, ),
        /* 223 */ array(29, ),
        /* 224 */ array(74, ),
        /* 225 */ array(74, ),
        /* 226 */ array(129, ),
        /* 227 */ array(74, ),
        /* 228 */ array(74, ),
        /* 229 */ array(74, ),
        /* 230 */ array(),
        /* 231 */ array(),
        /* 232 */ array(),
        /* 233 */ array(),
        /* 234 */ array(),
        /* 235 */ array(),
        /* 236 */ array(),
        /* 237 */ array(),
        /* 238 */ array(),
        /* 239 */ array(),
        /* 240 */ array(),
        /* 241 */ array(),
        /* 242 */ array(),
        /* 243 */ array(),
        /* 244 */ array(),
        /* 245 */ array(),
        /* 246 */ array(),
        /* 247 */ array(),
        /* 248 */ array(),
        /* 249 */ array(),
        /* 250 */ array(),
        /* 251 */ array(),
        /* 252 */ array(),
        /* 253 */ array(),
        /* 254 */ array(),
        /* 255 */ array(),
        /* 256 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 75, ),
        /* 257 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 75, ),
        /* 258 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 75, ),
        /* 259 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 78, ),
        /* 260 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 130, ),
        /* 261 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 117, ),
        /* 262 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 78, ),
        /* 263 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 78, ),
        /* 264 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 117, ),
        /* 265 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 75, ),
        /* 266 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 75, ),
        /* 267 */ array(7, 8, 9, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 268 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 78, ),
        /* 269 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 76, ),
        /* 270 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 78, ),
        /* 271 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 75, ),
        /* 272 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 78, ),
        /* 273 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 75, ),
        /* 274 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 76, ),
        /* 275 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 76, ),
        /* 276 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 75, ),
        /* 277 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 76, ),
        /* 278 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 75, ),
        /* 279 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 280 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 281 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 282 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 283 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 284 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 285 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 286 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 287 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 288 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 289 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 290 */ array(7, 8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 291 */ array(8, 9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 292 */ array(9, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 293 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 294 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 295 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 296 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 297 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 298 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 299 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 300 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 301 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 302 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 303 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 304 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 305 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 306 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 307 */ array(23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 308 */ array(25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 309 */ array(26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 310 */ array(27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 311 */ array(28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 312 */ array(29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 313 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 314 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 315 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 316 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 317 */ array(30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 318 */ array(6, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 49, 50, 75, ),
        /* 319 */ array(6, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 49, 50, 75, ),
        /* 320 */ array(11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 49, 50, 93, ),
        /* 321 */ array(11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 49, 50, 76, ),
        /* 322 */ array(11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 49, 50, ),
        /* 323 */ array(34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 324 */ array(34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 325 */ array(34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 326 */ array(34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, ),
        /* 327 */ array(40, 41, 42, 43, 44, 45, 47, ),
        /* 328 */ array(40, 41, 42, 43, 44, 45, 47, ),
        /* 329 */ array(43, 44, 45, 47, ),
        /* 330 */ array(43, 44, 45, 47, ),
        /* 331 */ array(43, 44, 45, 47, ),
        /* 332 */ array(43, 44, 45, 47, ),
        /* 333 */ array(43, 44, 45, 47, ),
        /* 334 */ array(97, 100, 131, ),
        /* 335 */ array(61, 74, 77, ),
        /* 336 */ array(78, 123, 124, ),
        /* 337 */ array(61, 74, 77, ),
        /* 338 */ array(122, 123, 124, ),
        /* 339 */ array(122, 123, 124, ),
        /* 340 */ array(78, 123, 124, ),
        /* 341 */ array(29, 97, ),
        /* 342 */ array(6, 76, ),
        /* 343 */ array(6, 75, ),
        /* 344 */ array(74, 118, ),
        /* 345 */ array(29, 97, ),
        /* 346 */ array(6, 75, ),
        /* 347 */ array(6, 75, ),
        /* 348 */ array(49, 50, ),
        /* 349 */ array(61, 77, ),
        /* 350 */ array(6, 76, ),
        /* 351 */ array(6, 75, ),
        /* 352 */ array(6, 76, ),
        /* 353 */ array(61, 77, ),
        /* 354 */ array(61, 77, ),
        /* 355 */ array(61, 77, ),
        /* 356 */ array(6, 76, ),
        /* 357 */ array(6, 76, ),
        /* 358 */ array(6, 75, ),
        /* 359 */ array(6, 75, ),
        /* 360 */ array(6, 75, ),
        /* 361 */ array(61, 129, ),
        /* 362 */ array(61, 77, ),
        /* 363 */ array(47, ),
        /* 364 */ array(47, ),
        /* 365 */ array(74, ),
        /* 366 */ array(117, ),
        /* 367 */ array(100, ),
        /* 368 */ array(74, ),
        /* 369 */ array(76, ),
        /* 370 */ array(75, ),
        /* 371 */ array(75, ),
        /* 372 */ array(75, ),
        /* 373 */ array(74, ),
        /* 374 */ array(96, ),
        /* 375 */ array(74, ),
        /* 376 */ array(74, ),
        /* 377 */ array(78, ),
        /* 378 */ array(77, ),
        /* 379 */ array(75, ),
        /* 380 */ array(74, ),
        /* 381 */ array(118, ),
        /* 382 */ array(97, ),
        /* 383 */ array(11, ),
        /* 384 */ array(47, ),
        /* 385 */ array(97, ),
        /* 386 */ array(75, ),
        /* 387 */ array(77, ),
        /* 388 */ array(74, ),
        /* 389 */ array(76, ),
        /* 390 */ array(76, ),
        /* 391 */ array(77, ),
        /* 392 */ array(111, ),
        /* 393 */ array(77, ),
        /* 394 */ array(11, ),
        /* 395 */ array(75, ),
        /* 396 */ array(74, ),
        /* 397 */ array(74, ),
        /* 398 */ array(74, ),
        /* 399 */ array(76, ),
        /* 400 */ array(76, ),
        /* 401 */ array(93, ),
        /* 402 */ array(74, ),
        /* 403 */ array(11, ),
        /* 404 */ array(100, ),
        /* 405 */ array(11, ),
        /* 406 */ array(74, ),
        /* 407 */ array(76, ),
        /* 408 */ array(76, ),
        /* 409 */ array(6, ),
        /* 410 */ array(74, ),
        /* 411 */ array(74, ),
        /* 412 */ array(24, ),
        /* 413 */ array(24, ),
        /* 414 */ array(75, ),
        /* 415 */ array(76, ),
        /* 416 */ array(66, ),
        /* 417 */ array(76, ),
        /* 418 */ array(76, ),
        /* 419 */ array(75, ),
        /* 420 */ array(74, ),
        /* 421 */ array(74, ),
        /* 422 */ array(76, ),
        /* 423 */ array(11, ),
        /* 424 */ array(74, ),
        /* 425 */ array(100, ),
        /* 426 */ array(6, ),
        /* 427 */ array(74, ),
        /* 428 */ array(97, ),
        /* 429 */ array(47, ),
        /* 430 */ array(11, ),
        /* 431 */ array(11, ),
        /* 432 */ array(100, ),
        /* 433 */ array(77, ),
        /* 434 */ array(77, ),
        /* 435 */ array(11, ),
        /* 436 */ array(11, ),
        /* 437 */ array(11, ),
        /* 438 */ array(129, ),
        /* 439 */ array(6, ),
        /* 440 */ array(11, ),
        /* 441 */ array(101, ),
        /* 442 */ array(101, ),
        /* 443 */ array(6, ),
        /* 444 */ array(118, ),
        /* 445 */ array(77, ),
        /* 446 */ array(97, ),
        /* 447 */ array(11, ),
        /* 448 */ array(11, ),
        /* 449 */ array(75, ),
        /* 450 */ array(100, ),
        /* 451 */ array(75, ),
        /* 452 */ array(74, ),
        /* 453 */ array(75, ),
        /* 454 */ array(74, ),
        /* 455 */ array(11, ),
        /* 456 */ array(75, ),
        /* 457 */ array(129, ),
        /* 458 */ array(74, ),
        /* 459 */ array(78, ),
        /* 460 */ array(74, ),
        /* 461 */ array(118, ),
        /* 462 */ array(75, ),
        /* 463 */ array(97, ),
        /* 464 */ array(75, ),
        /* 465 */ array(76, ),
        /* 466 */ array(76, ),
        /* 467 */ array(76, ),
        /* 468 */ array(74, ),
        /* 469 */ array(74, ),
        /* 470 */ array(80, ),
        /* 471 */ array(130, ),
        /* 472 */ array(75, ),
        /* 473 */ array(118, ),
        /* 474 */ array(76, ),
        /* 475 */ array(75, ),
        /* 476 */ array(100, ),
        /* 477 */ array(77, ),
        /* 478 */ array(117, ),
        /* 479 */ array(130, ),
        /* 480 */ array(75, ),
        /* 481 */ array(6, ),
        /* 482 */ array(130, ),
        /* 483 */ array(75, ),
        /* 484 */ array(75, ),
        /* 485 */ array(74, ),
        /* 486 */ array(74, ),
        /* 487 */ array(100, ),
        /* 488 */ array(61, ),
        /* 489 */ array(74, ),
        /* 490 */ array(118, ),
        /* 491 */ array(74, ),
        /* 492 */ array(6, ),
        /* 493 */ array(),
        /* 494 */ array(),
        /* 495 */ array(),
        /* 496 */ array(),
        /* 497 */ array(),
        /* 498 */ array(),
        /* 499 */ array(),
        /* 500 */ array(),
        /* 501 */ array(),
        /* 502 */ array(),
        /* 503 */ array(),
        /* 504 */ array(),
        /* 505 */ array(),
        /* 506 */ array(),
        /* 507 */ array(),
        /* 508 */ array(),
        /* 509 */ array(),
        /* 510 */ array(),
        /* 511 */ array(),
        /* 512 */ array(),
        /* 513 */ array(),
        /* 514 */ array(),
        /* 515 */ array(),
        /* 516 */ array(),
        /* 517 */ array(),
        /* 518 */ array(),
        /* 519 */ array(),
        /* 520 */ array(),
        /* 521 */ array(),
        /* 522 */ array(),
        /* 523 */ array(),
        /* 524 */ array(),
        /* 525 */ array(),
        /* 526 */ array(),
        /* 527 */ array(),
        /* 528 */ array(),
        /* 529 */ array(),
        /* 530 */ array(),
        /* 531 */ array(),
        /* 532 */ array(),
        /* 533 */ array(),
        /* 534 */ array(),
        /* 535 */ array(),
        /* 536 */ array(),
        /* 537 */ array(),
        /* 538 */ array(),
        /* 539 */ array(),
        /* 540 */ array(),
        /* 541 */ array(),
        /* 542 */ array(),
        /* 543 */ array(),
        /* 544 */ array(),
        /* 545 */ array(),
        /* 546 */ array(),
        /* 547 */ array(),
        /* 548 */ array(),
        /* 549 */ array(),
        /* 550 */ array(),
        /* 551 */ array(),
        /* 552 */ array(),
        /* 553 */ array(),
        /* 554 */ array(),
        /* 555 */ array(),
        /* 556 */ array(),
        /* 557 */ array(),
        /* 558 */ array(),
        /* 559 */ array(),
        /* 560 */ array(),
        /* 561 */ array(),
        /* 562 */ array(),
        /* 563 */ array(),
        /* 564 */ array(),
        /* 565 */ array(),
        /* 566 */ array(),
        /* 567 */ array(),
        /* 568 */ array(),
        /* 569 */ array(),
        /* 570 */ array(),
        /* 571 */ array(),
        /* 572 */ array(),
        /* 573 */ array(),
        /* 574 */ array(),
        /* 575 */ array(),
        /* 576 */ array(),
        /* 577 */ array(),
        /* 578 */ array(),
        /* 579 */ array(),
        /* 580 */ array(),
        /* 581 */ array(),
        /* 582 */ array(),
        /* 583 */ array(),
        /* 584 */ array(),
        /* 585 */ array(),
        /* 586 */ array(),
        /* 587 */ array(),
        /* 588 */ array(),
        /* 589 */ array(),
        /* 590 */ array(),
        /* 591 */ array(),
        /* 592 */ array(),
        /* 593 */ array(),
        /* 594 */ array(),
        /* 595 */ array(),
        /* 596 */ array(),
        /* 597 */ array(),
        /* 598 */ array(),
        /* 599 */ array(),
        /* 600 */ array(),
        /* 601 */ array(),
        /* 602 */ array(),
        /* 603 */ array(),
        /* 604 */ array(),
        /* 605 */ array(),
        /* 606 */ array(),
        /* 607 */ array(),
        /* 608 */ array(),
        /* 609 */ array(),
        /* 610 */ array(),
        /* 611 */ array(),
        /* 612 */ array(),
        /* 613 */ array(),
        /* 614 */ array(),
        /* 615 */ array(),
        /* 616 */ array(),
        /* 617 */ array(),
        /* 618 */ array(),
        /* 619 */ array(),
        /* 620 */ array(),
        /* 621 */ array(),
        /* 622 */ array(),
        /* 623 */ array(),
        /* 624 */ array(),
        /* 625 */ array(),
        /* 626 */ array(),
        /* 627 */ array(),
        /* 628 */ array(),
        /* 629 */ array(),
        /* 630 */ array(),
        /* 631 */ array(),
        /* 632 */ array(),
        /* 633 */ array(),
        /* 634 */ array(),
        /* 635 */ array(),
        /* 636 */ array(),
        /* 637 */ array(),
        /* 638 */ array(),
        /* 639 */ array(),
        /* 640 */ array(),
        /* 641 */ array(),
        /* 642 */ array(),
        /* 643 */ array(),
        /* 644 */ array(),
        /* 645 */ array(),
        /* 646 */ array(),
        /* 647 */ array(),
        /* 648 */ array(),
        /* 649 */ array(),
        /* 650 */ array(),
        /* 651 */ array(),
        /* 652 */ array(),
        /* 653 */ array(),
        /* 654 */ array(),
        /* 655 */ array(),
        /* 656 */ array(),
        /* 657 */ array(),
        /* 658 */ array(),
        /* 659 */ array(),
        /* 660 */ array(),
        /* 661 */ array(),
        /* 662 */ array(),
        /* 663 */ array(),
        /* 664 */ array(),
        /* 665 */ array(),
        /* 666 */ array(),
        /* 667 */ array(),
        /* 668 */ array(),
        /* 669 */ array(),
        /* 670 */ array(),
        /* 671 */ array(),
        /* 672 */ array(),
        /* 673 */ array(),
        /* 674 */ array(),
        /* 675 */ array(),
        /* 676 */ array(),
        /* 677 */ array(),
        /* 678 */ array(),
        /* 679 */ array(),
        /* 680 */ array(),
        /* 681 */ array(),
        /* 682 */ array(),
        /* 683 */ array(),
        /* 684 */ array(),
        /* 685 */ array(),
        /* 686 */ array(),
        /* 687 */ array(),
        /* 688 */ array(),
        /* 689 */ array(),
        /* 690 */ array(),
        /* 691 */ array(),
        /* 692 */ array(),
        /* 693 */ array(),
        /* 694 */ array(),
        /* 695 */ array(),
        /* 696 */ array(),
        /* 697 */ array(),
        /* 698 */ array(),
        /* 699 */ array(),
        /* 700 */ array(),
        /* 701 */ array(),
        /* 702 */ array(),
        /* 703 */ array(),
        /* 704 */ array(),
        /* 705 */ array(),
        /* 706 */ array(),
        /* 707 */ array(),
        /* 708 */ array(),
        /* 709 */ array(),
        /* 710 */ array(),
        /* 711 */ array(),
        /* 712 */ array(),
        /* 713 */ array(),
);
    static public $yy_default = array(
 /*     0 */   716,  892, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066,
 /*    10 */  1066, 1066,  891,  883,  714,  884,  895, 1066, 1066, 1066,
 /*    20 */  1066, 1066, 1066, 1066, 1066, 1066,  910,  910,  910,  910,
 /*    30 */   996,  910,  910, 1061, 1061, 1061, 1066,  980,  980, 1066,
 /*    40 */  1066, 1066, 1066, 1066, 1058, 1066, 1066, 1066, 1066, 1066,
 /*    50 */  1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066,
 /*    60 */  1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066,
 /*    70 */  1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066,
 /*    80 */  1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066,
 /*    90 */  1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066,
 /*   100 */  1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066,
 /*   110 */  1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066,
 /*   120 */  1066, 1066, 1066, 1066, 1066, 1066,  994, 1066,  994, 1066,
 /*   130 */  1066,  994, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066,
 /*   140 */  1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066,
 /*   150 */  1066, 1066, 1066, 1066, 1066,  861,  937,  937, 1066,  860,
 /*   160 */  1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066,
 /*   170 */  1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066,  908,  908,
 /*   180 */   750, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066,
 /*   190 */  1066, 1066, 1066,  934,  894, 1066,  896, 1066,  908, 1066,
 /*   200 */  1066, 1066,  773, 1066,  885,  868, 1066, 1066,  774, 1066,
 /*   210 */  1066,  868, 1059,  885, 1066,  749, 1066, 1066, 1066, 1066,
 /*   220 */  1051, 1065,  770, 1065, 1057,  965,  959,  850,  965, 1057,
 /*   230 */   755,  927,  755,  962,  755, 1016, 1054,  755, 1016,  755,
 /*   240 */  1016,  755, 1016,  755,  885,  755,  927,  755,  755,  755,
 /*   250 */   885,  755,  755,  755,  890,  755, 1066, 1066, 1066, 1066,
 /*   260 */  1066, 1001, 1066, 1066,  998, 1066, 1066, 1066, 1066, 1066,
 /*   270 */  1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1031,
 /*   280 */  1028, 1062,  949,  950, 1000, 1033, 1066, 1002, 1063, 1026,
 /*   290 */   979,  803,  805,  787,  804,  846,  786,  790,  781,  788,
 /*   300 */   780,  789,  794,  795,  796,  792,  793,  791,  831,  801,
 /*   310 */   802,  806,  808,  824,  807,  821,  823,  822,  956,  956,
 /*   320 */   956,  956,  956,  825,  826,  828,  827,  815,  816,  811,
 /*   330 */   818,  810,  809,  817, 1066,  971, 1066,  972, 1066, 1066,
 /*   340 */  1066, 1066, 1066,  779, 1042, 1066, 1066, 1066, 1066,  967,
 /*   350 */  1066, 1066, 1066,  981,  972,  971, 1066, 1066, 1066,  779,
 /*   360 */  1066, 1017,  966,  813,  812, 1066,  865, 1066, 1066, 1066,
 /*   370 */  1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066,
 /*   380 */  1066, 1066, 1066,  924,  814, 1066, 1066, 1066, 1066, 1066,
 /*   390 */  1066, 1066, 1066,  988,  903, 1066, 1066, 1066, 1066, 1066,
 /*   400 */  1066,  779, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1060,
 /*   410 */  1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066, 1066,
 /*   420 */  1037, 1066, 1066, 1066, 1066, 1066,  897, 1066, 1066,  819,
 /*   430 */  1066, 1066, 1066, 1066, 1066,  942,  944,  904,  960,  772,
 /*   440 */  1066, 1066, 1066,  775, 1066, 1066, 1066,  899,  900, 1066,
 /*   450 */  1066, 1066, 1066, 1066, 1066,  922, 1066, 1052, 1066, 1066,
 /*   460 */  1066,  853, 1066, 1066, 1066, 1066, 1066,  779, 1066, 1066,
 /*   470 */  1066, 1066, 1066, 1049, 1066, 1066, 1066,  989,  863, 1066,
 /*   480 */  1066,  909, 1066, 1066, 1066, 1066, 1036, 1066, 1043,  968,
 /*   490 */  1066, 1066,  859, 1029,  768,  875,  987,  767,  933, 1034,
 /*   500 */  1035,  986,  985,  769,  751, 1064,  771, 1055,  797, 1014,
 /*   510 */  1056,  964,  765,  785,  932,  931,  798, 1013,  901,  782,
 /*   520 */   799,  974,  939, 1053, 1015,  777, 1037,  776, 1030,  948,
 /*   530 */   935,  940,  938,  982,  784,  766,  779,  872,  721,  997,
 /*   540 */   976, 1021,  720,  957,  871,  851,  881,  995,  844,  882,
 /*   550 */   887, 1025,  718,  724,  978, 1024,  715,  717,  916,  719,
 /*   560 */   888,  977,  889,  893, 1040,  847, 1003,  874, 1050,  778,
 /*   570 */   867,  870,  869, 1012,  873,  983,  876,  878, 1018,  877,
 /*   580 */  1019,  723,  913,  722, 1020,  880, 1027, 1004,  999,  975,
 /*   590 */   968,  848,  744,  886,  984, 1010,  745,  920,  746,  836,
 /*   600 */   917,  919,  835, 1047,  918,  834,  956,  743,  921,  837,
 /*   610 */   736,  752,  732,  969,  731,  730,  840,  747,  839,  735,
 /*   620 */   838,  734,  973,  733,  737,  829,  738,  856, 1046,  970,
 /*   630 */   855,  739,  925,  857,  820,  862,  864,  923,  858,  740,
 /*   640 */  1022,  742,  852,  833,  952,  951,  953,  866,  955,  741,
 /*   650 */   830,  954,  854,  832, 1048,  729,  725,  946,  963,  947,
 /*   660 */   930, 1007,  800,  929,  943,  726, 1005,  945, 1006,  961,
 /*   670 */  1023,  905,  990,  907, 1011,  958,  783,  992,  906, 1009,
 /*   680 */  1008,  991,  993, 1032,  941,  928, 1041,  758,  849,  759,
 /*   690 */   761,  760,  757,  756, 1045,  841,  748,  753,  754,  762,
 /*   700 */   879, 1039, 1043,  764,  926,  845,  727,  763,  728,  842,
 /*   710 */   843, 1038, 1044,  902,
);
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    self::YYNOCODE      is a number which corresponds
**                        to no legal terminal or nonterminal number.  This
**                        number is used to fill in empty slots of the hash 
**                        table.
**    self::YYFALLBACK    If defined, this indicates that one or more tokens
**                        have fall-back values which should be used if the
**                        original value of the token will not parse.
**    self::YYSTACKDEPTH  is the maximum depth of the parser's stack.
**    self::YYNSTATE      the combined number of states.
**    self::YYNRULE       the number of rules in the grammar
**    self::YYERRORSYMBOL is the code number of the error symbol.  If not
**                        defined, then do no error processing.
*/
    const YYNOCODE = 258;
    const YYSTACKDEPTH = 100;
    const YYNSTATE = 714;
    const YYNRULE = 352;
    const YYERRORSYMBOL = 144;
    const YYERRSYMDT = 'yy0';
    const YYFALLBACK = 0;
    /** The next table maps tokens into fallback tokens.  If a construct
     * like the following:
     * 
     *      %fallback ID X Y Z.
     *
     * appears in the grammer, then ID becomes a fallback token for X, Y,
     * and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
     * but it does not parse, the type of the token is changed to ID and
     * the parse is retried before an error is thrown.
     */
    static public $yyFallback = array(
    );
    /**
     * Turn parser tracing on by giving a stream to which to write the trace
     * and a prompt to preface each trace message.  Tracing is turned off
     * by making either argument NULL 
     *
     * Inputs:
     * 
     * - A stream resource to which trace output should be written.
     *   If NULL, then tracing is turned off.
     * - A prefix string written at the beginning of every
     *   line of trace output.  If NULL, then tracing is
     *   turned off.
     *
     * Outputs:
     * 
     * - None.
     * @param resource
     * @param string
     */
    static function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        self::$yyTraceFILE = $TraceFILE;
        self::$yyTracePrompt = $zTracePrompt;
    }

    /**
     * Output debug information to output (php://output stream)
     */
    static function PrintTrace()
    {
        self::$yyTraceFILE = fopen('php://output', 'w');
        self::$yyTracePrompt = '';
    }

    /**
     * @var resource|0
     */
    static public $yyTraceFILE;
    /**
     * String to prepend to debug output
     * @var string|0
     */
    static public $yyTracePrompt;
    /**
     * @var int
     */
    public $yyidx;                    /* Index of top element in stack */
    /**
     * @var int
     */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    /**
     * @var array
     */
    public $yystack = array();  /* The parser's stack */

    /**
     * For tracing shifts, the names of all terminals and nonterminals
     * are required.  The following table supplies these names
     * @var array
     */
    static public $yyTokenName = array( 
  '$',             'T_INCLUDE',     'T_INCLUDE_ONCE',  'T_EVAL',      
  'T_REQUIRE',     'T_REQUIRE_ONCE',  'COMMA',         'T_LOGICAL_OR',
  'T_LOGICAL_XOR',  'T_LOGICAL_AND',  'T_PRINT',       'EQUALS',      
  'T_PLUS_EQUAL',  'T_MINUS_EQUAL',  'T_MUL_EQUAL',   'T_DIV_EQUAL', 
  'T_CONCAT_EQUAL',  'T_MOD_EQUAL',   'T_AND_EQUAL',   'T_OR_EQUAL',  
  'T_XOR_EQUAL',   'T_SL_EQUAL',    'T_SR_EQUAL',    'QUESTION',    
  'COLON',         'T_BOOLEAN_OR',  'T_BOOLEAN_AND',  'BAR',         
  'CARAT',         'AMPERSAND',     'T_IS_EQUAL',    'T_IS_NOT_EQUAL',
  'T_IS_IDENTICAL',  'T_IS_NOT_IDENTICAL',  'LESSTHAN',      'T_IS_SMALLER_OR_EQUAL',
  'GREATERTHAN',   'T_IS_GREATER_OR_EQUAL',  'T_SL',          'T_SR',        
  'PLUS',          'MINUS',         'DOT',           'TIMES',       
  'DIVIDE',        'PERCENT',       'EXCLAM',        'T_INSTANCEOF',
  'TILDE',         'T_INC',         'T_DEC',         'T_INT_CAST',  
  'T_DOUBLE_CAST',  'T_STRING_CAST',  'T_UNICODE_CAST',  'T_BINARY_CAST',
  'T_ARRAY_CAST',  'T_OBJECT_CAST',  'T_BOOL_CAST',   'T_UNSET_CAST',
  'AT',            'LBRACKET',      'T_NEW',         'T_CLONE',     
  'T_ELSEIF',      'T_ELSE',        'T_ENDIF',       'T_STATIC',    
  'T_ABSTRACT',    'T_FINAL',       'T_PRIVATE',     'T_PROTECTED', 
  'T_PUBLIC',      'T_HALT_COMPILER',  'LPAREN',        'RPAREN',      
  'SEMI',          'LCURLY',        'RCURLY',        'T_IF',        
  'T_WHILE',       'T_DO',          'T_FOR',         'T_SWITCH',    
  'T_BREAK',       'T_CONTINUE',    'T_RETURN',      'T_GLOBAL',    
  'T_ECHO',        'T_INLINE_HTML',  'T_USE',         'T_UNSET',     
  'T_FOREACH',     'T_AS',          'T_DECLARE',     'T_TRY',       
  'T_CATCH',       'T_VARIABLE',    'T_THROW',       'T_FUNCTION',  
  'T_STRING',      'T_CLASS',       'T_EXTENDS',     'T_INTERFACE', 
  'T_IMPLEMENTS',  'T_LIST',        'T_EXIT',        'BACKQUOTE',   
  'T_ARRAY',       'T_LNUMBER',     'T_DNUMBER',     'T_CONSTANT_ENCAPSED_STRING',
  'T_LINE',        'T_FILE',        'T_CLASS_C',     'T_METHOD_C',  
  'T_FUNC_C',      'T_DOUBLE_ARROW',  'T_PAAMAYIM_NEKUDOTAYIM',  'T_ENDFOR',    
  'T_ENDFOREACH',  'T_ENDDECLARE',  'T_ENDSWITCH',   'T_CASE',      
  'T_DEFAULT',     'T_ENDWHILE',    'DOLLAR',        'T_VAR',       
  'T_CONST',       'T_OBJECT_OPERATOR',  'RBRACKET',      'T_NUM_STRING',
  'T_ENCAPSED_AND_WHITESPACE',  'T_CHARACTER',   'T_BAD_CHARACTER',  'T_DOLLAR_OPEN_CURLY_BRACES',
  'T_STRING_VARNAME',  'T_CURLY_OPEN',  'T_ISSET',       'T_EMPTY',     
  'DOUBLEQUOTE',   'SINGLEQUOTE',   'T_START_HEREDOC',  'T_END_HEREDOC',
  'error',         'start',         'top_statement_list',  'top_statement',
  'statement',     'function_declaration_statement',  'class_declaration_statement',  'unticked_statement',
  'inner_statement_list',  'expr',          'elseif_list',   'else_single', 
  'new_elseif_list',  'new_else_single',  'while_statement',  'for_expr',    
  'for_statement',  'switch_case_list',  'expr_without_variable',  'variable',    
  'global_var_list',  'static_var_list',  'echo_expr_list',  'use_filename',
  'unset_variables',  'foreach_variable',  'foreach_optional_arg',  'foreach_statement',
  'declare_list',  'declare_statement',  'fully_qualified_class_name',  'additional_catches',
  'non_empty_additional_catches',  'additional_catch',  'inner_statement',  'unticked_function_declaration_statement',
  'unticked_class_declaration_statement',  'get_func_line',  'is_reference',  'parameter_list',
  'class_entry_type',  'extends_from',  'implements_list',  'class_statement_list',
  'interface_entry',  'interface_extends_list',  'interface_list',  'r_variable',  
  'assignment_list',  'class_name_reference',  'ctor_arguments',  'rw_variable', 
  'internal_functions_in_yacc',  'exit_expr',     'scalar',        'expr_without_variable_t_array',
  'array_pair_list',  'encaps_list',   'common_scalar',  'static_scalar',
  'static_scalar_t_array',  'static_array_pair_list',  'static_class_constant',  'non_empty_static_array_pair_list',
  'w_variable',    'case_list',     'case_separator',  'non_empty_parameter_list',
  'optional_class_type',  'function_call_parameter_list',  'non_empty_function_call_parameter_list',  'global_var',  
  'class_statement',  'variable_modifiers',  'class_variable_declaration',  'class_constant_declaration',
  'get_method_line',  'method_modifiers',  'method_body',   'non_empty_member_modifiers',
  'member_modifier',  'get_variable_line',  'get_constant_line',  'unset_variable',
  'base_variable_with_function_calls',  'object_property',  'method_or_not',  'variable_properties',
  'variable_property',  'variable_without_objects',  'reference_variable',  'simple_indirect_reference',
  'static_member',  'base_variable',  'function_call',  'dim_offset',  
  'compound_variable',  'object_dim_list',  'variable_name',  'assignment_list_element',
  'non_empty_array_pair_list',  'possible_comma',  'encaps_var',    'isset_variables',
  'get_include_line',  'get_include_once_line',  'get_require_line',  'get_require_once_line',
  'class_constant',  'dynamic_class_name_reference',  'dynamic_class_name_variable_properties',  'dynamic_class_name_variable_property',
  'non_empty_for_expr',
    );

    /**
     * For tracing reduce actions, the names of all rules are required.
     * @var array
     */
    static public $yyRuleName = array(
 /*   0 */ "start ::= top_statement_list",
 /*   1 */ "top_statement_list ::= top_statement_list top_statement",
 /*   2 */ "top_statement_list ::=",
 /*   3 */ "top_statement ::= statement",
 /*   4 */ "top_statement ::= function_declaration_statement",
 /*   5 */ "top_statement ::= class_declaration_statement",
 /*   6 */ "top_statement ::= T_HALT_COMPILER LPAREN RPAREN SEMI",
 /*   7 */ "statement ::= unticked_statement",
 /*   8 */ "unticked_statement ::= LCURLY inner_statement_list RCURLY",
 /*   9 */ "unticked_statement ::= T_IF LPAREN expr RPAREN statement elseif_list else_single",
 /*  10 */ "unticked_statement ::= T_IF LPAREN expr RPAREN COLON inner_statement_list new_elseif_list new_else_single T_ENDIF SEMI",
 /*  11 */ "unticked_statement ::= T_WHILE LPAREN expr RPAREN while_statement",
 /*  12 */ "unticked_statement ::= T_DO statement T_WHILE LPAREN expr RPAREN SEMI",
 /*  13 */ "unticked_statement ::= T_FOR LPAREN for_expr SEMI for_expr SEMI for_expr RPAREN for_statement",
 /*  14 */ "unticked_statement ::= T_SWITCH LPAREN expr RPAREN switch_case_list",
 /*  15 */ "unticked_statement ::= T_BREAK SEMI",
 /*  16 */ "unticked_statement ::= T_BREAK expr SEMI",
 /*  17 */ "unticked_statement ::= T_CONTINUE SEMI",
 /*  18 */ "unticked_statement ::= T_CONTINUE expr SEMI",
 /*  19 */ "unticked_statement ::= T_RETURN SEMI",
 /*  20 */ "unticked_statement ::= T_RETURN expr_without_variable SEMI",
 /*  21 */ "unticked_statement ::= T_RETURN variable SEMI",
 /*  22 */ "unticked_statement ::= T_GLOBAL global_var_list SEMI",
 /*  23 */ "unticked_statement ::= T_STATIC static_var_list SEMI",
 /*  24 */ "unticked_statement ::= T_ECHO echo_expr_list SEMI",
 /*  25 */ "unticked_statement ::= T_INLINE_HTML",
 /*  26 */ "unticked_statement ::= expr SEMI",
 /*  27 */ "unticked_statement ::= T_USE use_filename SEMI",
 /*  28 */ "unticked_statement ::= T_UNSET LPAREN unset_variables RPAREN SEMI",
 /*  29 */ "unticked_statement ::= T_FOREACH LPAREN variable T_AS foreach_variable foreach_optional_arg RPAREN foreach_statement",
 /*  30 */ "unticked_statement ::= T_FOREACH LPAREN expr_without_variable T_AS variable foreach_optional_arg RPAREN foreach_statement",
 /*  31 */ "unticked_statement ::= T_DECLARE LPAREN declare_list RPAREN declare_statement",
 /*  32 */ "unticked_statement ::= SEMI",
 /*  33 */ "unticked_statement ::= T_TRY LCURLY inner_statement_list RCURLY T_CATCH LPAREN fully_qualified_class_name T_VARIABLE RPAREN LCURLY inner_statement_list RCURLY additional_catches",
 /*  34 */ "unticked_statement ::= T_THROW expr SEMI",
 /*  35 */ "additional_catches ::= non_empty_additional_catches",
 /*  36 */ "additional_catches ::=",
 /*  37 */ "non_empty_additional_catches ::= additional_catch",
 /*  38 */ "non_empty_additional_catches ::= non_empty_additional_catches additional_catch",
 /*  39 */ "additional_catch ::= T_CATCH LPAREN fully_qualified_class_name T_VARIABLE RPAREN LCURLY inner_statement_list RCURLY",
 /*  40 */ "inner_statement_list ::= inner_statement_list inner_statement",
 /*  41 */ "inner_statement_list ::=",
 /*  42 */ "inner_statement ::= statement",
 /*  43 */ "inner_statement ::= function_declaration_statement",
 /*  44 */ "inner_statement ::= class_declaration_statement",
 /*  45 */ "inner_statement ::= T_HALT_COMPILER LPAREN RPAREN SEMI",
 /*  46 */ "function_declaration_statement ::= unticked_function_declaration_statement",
 /*  47 */ "class_declaration_statement ::= unticked_class_declaration_statement",
 /*  48 */ "get_func_line ::= T_FUNCTION",
 /*  49 */ "unticked_function_declaration_statement ::= get_func_line is_reference T_STRING LPAREN parameter_list RPAREN LCURLY inner_statement_list RCURLY",
 /*  50 */ "unticked_class_declaration_statement ::= class_entry_type T_STRING extends_from implements_list LCURLY class_statement_list RCURLY",
 /*  51 */ "unticked_class_declaration_statement ::= interface_entry T_STRING interface_extends_list LCURLY class_statement_list RCURLY",
 /*  52 */ "class_entry_type ::= T_CLASS",
 /*  53 */ "class_entry_type ::= T_ABSTRACT T_CLASS",
 /*  54 */ "class_entry_type ::= T_FINAL T_CLASS",
 /*  55 */ "extends_from ::= T_EXTENDS fully_qualified_class_name",
 /*  56 */ "extends_from ::=",
 /*  57 */ "interface_entry ::= T_INTERFACE",
 /*  58 */ "interface_extends_list ::= T_EXTENDS interface_list",
 /*  59 */ "interface_extends_list ::=",
 /*  60 */ "implements_list ::=",
 /*  61 */ "implements_list ::= T_IMPLEMENTS interface_list",
 /*  62 */ "interface_list ::= fully_qualified_class_name",
 /*  63 */ "interface_list ::= interface_list COMMA fully_qualified_class_name",
 /*  64 */ "expr ::= r_variable",
 /*  65 */ "expr ::= expr_without_variable",
 /*  66 */ "expr_without_variable ::= T_LIST LPAREN assignment_list RPAREN EQUALS expr",
 /*  67 */ "expr_without_variable ::= variable EQUALS expr",
 /*  68 */ "expr_without_variable ::= variable EQUALS AMPERSAND variable",
 /*  69 */ "expr_without_variable ::= variable EQUALS AMPERSAND T_NEW class_name_reference ctor_arguments",
 /*  70 */ "expr_without_variable ::= T_NEW class_name_reference ctor_arguments",
 /*  71 */ "expr_without_variable ::= T_CLONE expr",
 /*  72 */ "expr_without_variable ::= variable T_PLUS_EQUAL expr",
 /*  73 */ "expr_without_variable ::= variable T_MINUS_EQUAL expr",
 /*  74 */ "expr_without_variable ::= variable T_MUL_EQUAL expr",
 /*  75 */ "expr_without_variable ::= variable T_DIV_EQUAL expr",
 /*  76 */ "expr_without_variable ::= variable T_CONCAT_EQUAL expr",
 /*  77 */ "expr_without_variable ::= variable T_MOD_EQUAL expr",
 /*  78 */ "expr_without_variable ::= variable T_AND_EQUAL expr",
 /*  79 */ "expr_without_variable ::= variable T_OR_EQUAL expr",
 /*  80 */ "expr_without_variable ::= variable T_XOR_EQUAL expr",
 /*  81 */ "expr_without_variable ::= variable T_SL_EQUAL expr",
 /*  82 */ "expr_without_variable ::= variable T_SR_EQUAL expr",
 /*  83 */ "expr_without_variable ::= rw_variable T_INC",
 /*  84 */ "expr_without_variable ::= T_INC rw_variable",
 /*  85 */ "expr_without_variable ::= rw_variable T_DEC",
 /*  86 */ "expr_without_variable ::= T_DEC rw_variable",
 /*  87 */ "expr_without_variable ::= expr T_BOOLEAN_OR expr",
 /*  88 */ "expr_without_variable ::= expr T_BOOLEAN_AND expr",
 /*  89 */ "expr_without_variable ::= expr T_LOGICAL_OR expr",
 /*  90 */ "expr_without_variable ::= expr T_LOGICAL_AND expr",
 /*  91 */ "expr_without_variable ::= expr T_LOGICAL_XOR expr",
 /*  92 */ "expr_without_variable ::= expr BAR expr",
 /*  93 */ "expr_without_variable ::= expr AMPERSAND expr",
 /*  94 */ "expr_without_variable ::= expr CARAT expr",
 /*  95 */ "expr_without_variable ::= expr DOT expr",
 /*  96 */ "expr_without_variable ::= expr PLUS expr",
 /*  97 */ "expr_without_variable ::= expr MINUS expr",
 /*  98 */ "expr_without_variable ::= expr TIMES expr",
 /*  99 */ "expr_without_variable ::= expr DIVIDE expr",
 /* 100 */ "expr_without_variable ::= expr PERCENT expr",
 /* 101 */ "expr_without_variable ::= expr T_SL expr",
 /* 102 */ "expr_without_variable ::= expr T_SR expr",
 /* 103 */ "expr_without_variable ::= PLUS expr",
 /* 104 */ "expr_without_variable ::= MINUS expr",
 /* 105 */ "expr_without_variable ::= EXCLAM expr",
 /* 106 */ "expr_without_variable ::= TILDE expr",
 /* 107 */ "expr_without_variable ::= expr T_IS_IDENTICAL expr",
 /* 108 */ "expr_without_variable ::= expr T_IS_NOT_IDENTICAL expr",
 /* 109 */ "expr_without_variable ::= expr T_IS_EQUAL expr",
 /* 110 */ "expr_without_variable ::= expr T_IS_NOT_EQUAL expr",
 /* 111 */ "expr_without_variable ::= expr LESSTHAN expr",
 /* 112 */ "expr_without_variable ::= expr T_IS_SMALLER_OR_EQUAL expr",
 /* 113 */ "expr_without_variable ::= expr GREATERTHAN expr",
 /* 114 */ "expr_without_variable ::= expr T_IS_GREATER_OR_EQUAL expr",
 /* 115 */ "expr_without_variable ::= expr T_INSTANCEOF class_name_reference",
 /* 116 */ "expr_without_variable ::= LPAREN expr RPAREN",
 /* 117 */ "expr_without_variable ::= expr QUESTION expr COLON expr",
 /* 118 */ "expr_without_variable ::= internal_functions_in_yacc",
 /* 119 */ "expr_without_variable ::= T_INT_CAST expr",
 /* 120 */ "expr_without_variable ::= T_DOUBLE_CAST expr",
 /* 121 */ "expr_without_variable ::= T_STRING_CAST expr",
 /* 122 */ "expr_without_variable ::= T_ARRAY_CAST expr",
 /* 123 */ "expr_without_variable ::= T_OBJECT_CAST expr",
 /* 124 */ "expr_without_variable ::= T_BINARY_CAST expr",
 /* 125 */ "expr_without_variable ::= T_BOOL_CAST expr",
 /* 126 */ "expr_without_variable ::= T_UNSET_CAST expr",
 /* 127 */ "expr_without_variable ::= T_EXIT exit_expr",
 /* 128 */ "expr_without_variable ::= AT expr",
 /* 129 */ "expr_without_variable ::= scalar",
 /* 130 */ "expr_without_variable ::= expr_without_variable_t_array LPAREN array_pair_list RPAREN",
 /* 131 */ "expr_without_variable ::= BACKQUOTE encaps_list BACKQUOTE",
 /* 132 */ "expr_without_variable ::= T_PRINT expr",
 /* 133 */ "expr_without_variable_t_array ::= T_ARRAY",
 /* 134 */ "exit_expr ::= LPAREN RPAREN",
 /* 135 */ "exit_expr ::= LPAREN expr RPAREN",
 /* 136 */ "exit_expr ::=",
 /* 137 */ "common_scalar ::= T_LNUMBER|T_DNUMBER|T_CONSTANT_ENCAPSED_STRING|T_LINE|T_FILE|T_CLASS_C|T_METHOD_C|T_FUNC_C",
 /* 138 */ "static_scalar ::= common_scalar",
 /* 139 */ "static_scalar ::= T_STRING",
 /* 140 */ "static_scalar ::= PLUS static_scalar",
 /* 141 */ "static_scalar ::= MINUS static_scalar",
 /* 142 */ "static_scalar ::= static_scalar_t_array LPAREN static_array_pair_list RPAREN",
 /* 143 */ "static_scalar ::= static_class_constant",
 /* 144 */ "static_scalar_t_array ::= T_ARRAY",
 /* 145 */ "static_array_pair_list ::= non_empty_static_array_pair_list",
 /* 146 */ "static_array_pair_list ::= non_empty_static_array_pair_list COMMA",
 /* 147 */ "static_array_pair_list ::=",
 /* 148 */ "non_empty_static_array_pair_list ::= non_empty_static_array_pair_list COMMA static_scalar T_DOUBLE_ARROW static_scalar",
 /* 149 */ "non_empty_static_array_pair_list ::= non_empty_static_array_pair_list COMMA static_scalar",
 /* 150 */ "non_empty_static_array_pair_list ::= static_scalar T_DOUBLE_ARROW static_scalar",
 /* 151 */ "non_empty_static_array_pair_list ::= static_scalar",
 /* 152 */ "static_class_constant ::= T_STRING T_PAAMAYIM_NEKUDOTAYIM T_STRING",
 /* 153 */ "foreach_optional_arg ::= T_DOUBLE_ARROW foreach_variable",
 /* 154 */ "foreach_optional_arg ::=",
 /* 155 */ "foreach_variable ::= w_variable",
 /* 156 */ "foreach_variable ::= AMPERSAND w_variable",
 /* 157 */ "for_statement ::= statement",
 /* 158 */ "for_statement ::= COLON inner_statement_list T_ENDFOR SEMI",
 /* 159 */ "foreach_statement ::= statement",
 /* 160 */ "foreach_statement ::= COLON inner_statement_list T_ENDFOREACH SEMI",
 /* 161 */ "declare_statement ::= statement",
 /* 162 */ "declare_statement ::= COLON inner_statement_list T_ENDDECLARE SEMI",
 /* 163 */ "declare_list ::= T_STRING EQUALS static_scalar",
 /* 164 */ "declare_list ::= declare_list COMMA T_STRING EQUALS static_scalar",
 /* 165 */ "switch_case_list ::= LCURLY case_list RCURLY",
 /* 166 */ "switch_case_list ::= LCURLY SEMI case_list RCURLY",
 /* 167 */ "switch_case_list ::= COLON case_list T_ENDSWITCH SEMI",
 /* 168 */ "switch_case_list ::= COLON SEMI case_list T_ENDSWITCH SEMI",
 /* 169 */ "case_list ::= case_list T_CASE expr case_separator inner_statement_list",
 /* 170 */ "case_list ::= case_list T_DEFAULT case_separator inner_statement_list",
 /* 171 */ "case_list ::=",
 /* 172 */ "case_separator ::= COLON|SEMI",
 /* 173 */ "while_statement ::= statement",
 /* 174 */ "while_statement ::= COLON inner_statement_list T_ENDWHILE SEMI",
 /* 175 */ "elseif_list ::= elseif_list T_ELSEIF LPAREN expr RPAREN statement",
 /* 176 */ "elseif_list ::=",
 /* 177 */ "new_elseif_list ::= new_elseif_list T_ELSEIF LPAREN expr RPAREN COLON inner_statement_list",
 /* 178 */ "new_elseif_list ::=",
 /* 179 */ "else_single ::= T_ELSE statement",
 /* 180 */ "else_single ::=",
 /* 181 */ "new_else_single ::= T_ELSE COLON inner_statement_list",
 /* 182 */ "new_else_single ::=",
 /* 183 */ "parameter_list ::= non_empty_parameter_list",
 /* 184 */ "parameter_list ::=",
 /* 185 */ "non_empty_parameter_list ::= optional_class_type T_VARIABLE",
 /* 186 */ "non_empty_parameter_list ::= optional_class_type AMPERSAND T_VARIABLE",
 /* 187 */ "non_empty_parameter_list ::= optional_class_type AMPERSAND T_VARIABLE EQUALS static_scalar",
 /* 188 */ "non_empty_parameter_list ::= optional_class_type T_VARIABLE EQUALS static_scalar",
 /* 189 */ "non_empty_parameter_list ::= non_empty_parameter_list COMMA optional_class_type T_VARIABLE",
 /* 190 */ "non_empty_parameter_list ::= non_empty_parameter_list COMMA optional_class_type AMPERSAND T_VARIABLE",
 /* 191 */ "non_empty_parameter_list ::= non_empty_parameter_list COMMA optional_class_type AMPERSAND T_VARIABLE EQUALS static_scalar",
 /* 192 */ "non_empty_parameter_list ::= non_empty_parameter_list COMMA optional_class_type T_VARIABLE EQUALS static_scalar",
 /* 193 */ "optional_class_type ::= T_STRING|T_ARRAY",
 /* 194 */ "optional_class_type ::=",
 /* 195 */ "function_call_parameter_list ::= non_empty_function_call_parameter_list",
 /* 196 */ "function_call_parameter_list ::=",
 /* 197 */ "non_empty_function_call_parameter_list ::= expr_without_variable",
 /* 198 */ "non_empty_function_call_parameter_list ::= variable",
 /* 199 */ "non_empty_function_call_parameter_list ::= AMPERSAND w_variable",
 /* 200 */ "non_empty_function_call_parameter_list ::= non_empty_function_call_parameter_list COMMA expr_without_variable",
 /* 201 */ "non_empty_function_call_parameter_list ::= non_empty_function_call_parameter_list COMMA variable",
 /* 202 */ "non_empty_function_call_parameter_list ::= non_empty_function_call_parameter_list COMMA AMPERSAND w_variable",
 /* 203 */ "global_var_list ::= global_var_list COMMA global_var",
 /* 204 */ "global_var_list ::= global_var",
 /* 205 */ "global_var ::= T_VARIABLE",
 /* 206 */ "global_var ::= DOLLAR r_variable",
 /* 207 */ "global_var ::= DOLLAR LCURLY expr RCURLY",
 /* 208 */ "static_var_list ::= static_var_list COMMA T_VARIABLE",
 /* 209 */ "static_var_list ::= static_var_list COMMA T_VARIABLE EQUALS static_scalar",
 /* 210 */ "static_var_list ::= T_VARIABLE",
 /* 211 */ "static_var_list ::= T_VARIABLE EQUALS static_scalar",
 /* 212 */ "class_statement_list ::= class_statement_list class_statement",
 /* 213 */ "class_statement_list ::=",
 /* 214 */ "class_statement ::= variable_modifiers class_variable_declaration SEMI",
 /* 215 */ "class_statement ::= class_constant_declaration SEMI",
 /* 216 */ "get_method_line ::= T_FUNCTION",
 /* 217 */ "class_statement ::= method_modifiers get_method_line is_reference T_STRING LPAREN parameter_list RPAREN method_body",
 /* 218 */ "method_body ::= SEMI",
 /* 219 */ "method_body ::= LCURLY inner_statement_list RCURLY",
 /* 220 */ "variable_modifiers ::= non_empty_member_modifiers",
 /* 221 */ "variable_modifiers ::= T_VAR",
 /* 222 */ "method_modifiers ::= non_empty_member_modifiers",
 /* 223 */ "method_modifiers ::=",
 /* 224 */ "non_empty_member_modifiers ::= member_modifier",
 /* 225 */ "non_empty_member_modifiers ::= non_empty_member_modifiers member_modifier",
 /* 226 */ "member_modifier ::= T_PUBLIC|T_PROTECTED|T_PRIVATE|T_STATIC|T_ABSTRACT|T_FINAL",
 /* 227 */ "get_variable_line ::= T_VARIABLE",
 /* 228 */ "class_variable_declaration ::= class_variable_declaration COMMA get_variable_line",
 /* 229 */ "class_variable_declaration ::= class_variable_declaration COMMA get_variable_line EQUALS static_scalar",
 /* 230 */ "class_variable_declaration ::= T_VARIABLE",
 /* 231 */ "class_variable_declaration ::= get_variable_line EQUALS static_scalar",
 /* 232 */ "get_constant_line ::= T_STRING",
 /* 233 */ "class_constant_declaration ::= class_constant_declaration COMMA get_constant_line EQUALS static_scalar",
 /* 234 */ "class_constant_declaration ::= T_CONST get_constant_line EQUALS static_scalar",
 /* 235 */ "echo_expr_list ::= echo_expr_list COMMA expr",
 /* 236 */ "echo_expr_list ::= expr",
 /* 237 */ "unset_variables ::= unset_variable",
 /* 238 */ "unset_variables ::= unset_variables COMMA unset_variable",
 /* 239 */ "unset_variable ::= variable",
 /* 240 */ "use_filename ::= T_CONSTANT_ENCAPSED_STRING",
 /* 241 */ "use_filename ::= LPAREN T_CONSTANT_ENCAPSED_STRING RPAREN",
 /* 242 */ "r_variable ::= variable",
 /* 243 */ "w_variable ::= variable",
 /* 244 */ "rw_variable ::= variable",
 /* 245 */ "variable ::= base_variable_with_function_calls T_OBJECT_OPERATOR object_property method_or_not variable_properties",
 /* 246 */ "variable ::= base_variable_with_function_calls",
 /* 247 */ "variable_properties ::= variable_properties variable_property",
 /* 248 */ "variable_properties ::=",
 /* 249 */ "variable_property ::= T_OBJECT_OPERATOR object_property method_or_not",
 /* 250 */ "method_or_not ::= LPAREN function_call_parameter_list RPAREN",
 /* 251 */ "method_or_not ::=",
 /* 252 */ "variable_without_objects ::= reference_variable",
 /* 253 */ "variable_without_objects ::= simple_indirect_reference reference_variable",
 /* 254 */ "static_member ::= fully_qualified_class_name T_PAAMAYIM_NEKUDOTAYIM variable_without_objects",
 /* 255 */ "base_variable_with_function_calls ::= base_variable",
 /* 256 */ "base_variable_with_function_calls ::= function_call",
 /* 257 */ "base_variable ::= reference_variable",
 /* 258 */ "base_variable ::= simple_indirect_reference reference_variable",
 /* 259 */ "base_variable ::= static_member",
 /* 260 */ "reference_variable ::= reference_variable LBRACKET dim_offset RBRACKET",
 /* 261 */ "reference_variable ::= reference_variable LCURLY expr RCURLY",
 /* 262 */ "reference_variable ::= compound_variable",
 /* 263 */ "compound_variable ::= T_VARIABLE",
 /* 264 */ "compound_variable ::= DOLLAR LCURLY expr RCURLY",
 /* 265 */ "dim_offset ::= expr",
 /* 266 */ "dim_offset ::=",
 /* 267 */ "object_property ::= object_dim_list",
 /* 268 */ "object_property ::= variable_without_objects",
 /* 269 */ "object_dim_list ::= object_dim_list LBRACKET dim_offset RBRACKET",
 /* 270 */ "object_dim_list ::= object_dim_list LCURLY expr RCURLY",
 /* 271 */ "object_dim_list ::= variable_name",
 /* 272 */ "variable_name ::= T_STRING",
 /* 273 */ "variable_name ::= LCURLY expr RCURLY",
 /* 274 */ "simple_indirect_reference ::= DOLLAR",
 /* 275 */ "simple_indirect_reference ::= simple_indirect_reference DOLLAR",
 /* 276 */ "assignment_list ::= assignment_list COMMA assignment_list_element",
 /* 277 */ "assignment_list ::= assignment_list_element",
 /* 278 */ "assignment_list_element ::= variable",
 /* 279 */ "assignment_list_element ::= T_LIST LPAREN assignment_list RPAREN",
 /* 280 */ "assignment_list_element ::=",
 /* 281 */ "array_pair_list ::= non_empty_array_pair_list possible_comma",
 /* 282 */ "array_pair_list ::=",
 /* 283 */ "non_empty_array_pair_list ::= expr T_DOUBLE_ARROW AMPERSAND w_variable",
 /* 284 */ "non_empty_array_pair_list ::= expr",
 /* 285 */ "non_empty_array_pair_list ::= AMPERSAND w_variable",
 /* 286 */ "non_empty_array_pair_list ::= non_empty_array_pair_list COMMA expr T_DOUBLE_ARROW expr",
 /* 287 */ "non_empty_array_pair_list ::= non_empty_array_pair_list COMMA expr",
 /* 288 */ "non_empty_array_pair_list ::= expr T_DOUBLE_ARROW expr",
 /* 289 */ "non_empty_array_pair_list ::= non_empty_array_pair_list COMMA expr T_DOUBLE_ARROW AMPERSAND w_variable",
 /* 290 */ "non_empty_array_pair_list ::= non_empty_array_pair_list COMMA AMPERSAND w_variable",
 /* 291 */ "encaps_list ::= encaps_list encaps_var",
 /* 292 */ "encaps_list ::= encaps_list T_STRING",
 /* 293 */ "encaps_list ::= encaps_list T_NUM_STRING",
 /* 294 */ "encaps_list ::= encaps_list T_ENCAPSED_AND_WHITESPACE",
 /* 295 */ "encaps_list ::= encaps_list T_CHARACTER",
 /* 296 */ "encaps_list ::= encaps_list T_BAD_CHARACTER",
 /* 297 */ "encaps_list ::= encaps_list LBRACKET",
 /* 298 */ "encaps_list ::= encaps_list RBRACKET",
 /* 299 */ "encaps_list ::= encaps_list LCURLY",
 /* 300 */ "encaps_list ::= encaps_list RCURLY",
 /* 301 */ "encaps_list ::= encaps_list T_OBJECT_OPERATOR",
 /* 302 */ "encaps_list ::=",
 /* 303 */ "encaps_var ::= T_VARIABLE",
 /* 304 */ "encaps_var ::= T_VARIABLE LBRACKET T_STRING|T_NUM_STRING|T_VARIABLE RBRACKET",
 /* 305 */ "encaps_var ::= T_VARIABLE T_OBJECT_OPERATOR T_STRING",
 /* 306 */ "encaps_var ::= T_DOLLAR_OPEN_CURLY_BRACES expr RCURLY",
 /* 307 */ "encaps_var ::= T_DOLLAR_OPEN_CURLY_BRACES T_STRING_VARNAME LBRACKET expr RBRACKET RCURLY",
 /* 308 */ "encaps_var ::= T_CURLY_OPEN variable RCURLY",
 /* 309 */ "internal_functions_in_yacc ::= T_ISSET LPAREN isset_variables RPAREN",
 /* 310 */ "internal_functions_in_yacc ::= T_EMPTY LPAREN variable RPAREN",
 /* 311 */ "get_include_line ::= T_INCLUDE",
 /* 312 */ "internal_functions_in_yacc ::= get_include_line expr",
 /* 313 */ "get_include_once_line ::= T_INCLUDE_ONCE",
 /* 314 */ "internal_functions_in_yacc ::= get_include_once_line expr",
 /* 315 */ "internal_functions_in_yacc ::= T_EVAL LPAREN expr RPAREN",
 /* 316 */ "get_require_line ::= T_REQUIRE",
 /* 317 */ "internal_functions_in_yacc ::= get_require_line expr",
 /* 318 */ "get_require_once_line ::= T_REQUIRE_ONCE",
 /* 319 */ "internal_functions_in_yacc ::= get_require_once_line expr",
 /* 320 */ "isset_variables ::= variable",
 /* 321 */ "isset_variables ::= isset_variables COMMA variable",
 /* 322 */ "class_constant ::= fully_qualified_class_name T_PAAMAYIM_NEKUDOTAYIM T_STRING",
 /* 323 */ "fully_qualified_class_name ::= T_STRING",
 /* 324 */ "function_call ::= T_STRING LPAREN function_call_parameter_list RPAREN",
 /* 325 */ "function_call ::= fully_qualified_class_name T_PAAMAYIM_NEKUDOTAYIM T_STRING LPAREN function_call_parameter_list RPAREN",
 /* 326 */ "function_call ::= fully_qualified_class_name T_PAAMAYIM_NEKUDOTAYIM variable_without_objects LPAREN function_call_parameter_list RPAREN",
 /* 327 */ "function_call ::= variable_without_objects LPAREN function_call_parameter_list RPAREN",
 /* 328 */ "scalar ::= T_STRING",
 /* 329 */ "scalar ::= T_STRING_VARNAME",
 /* 330 */ "scalar ::= class_constant",
 /* 331 */ "scalar ::= common_scalar",
 /* 332 */ "scalar ::= DOUBLEQUOTE encaps_list DOUBLEQUOTE",
 /* 333 */ "scalar ::= SINGLEQUOTE encaps_list SINGLEQUOTE",
 /* 334 */ "scalar ::= T_START_HEREDOC encaps_list T_END_HEREDOC",
 /* 335 */ "class_name_reference ::= T_STRING",
 /* 336 */ "class_name_reference ::= dynamic_class_name_reference",
 /* 337 */ "dynamic_class_name_reference ::= base_variable T_OBJECT_OPERATOR object_property dynamic_class_name_variable_properties",
 /* 338 */ "dynamic_class_name_reference ::= base_variable",
 /* 339 */ "dynamic_class_name_variable_properties ::= dynamic_class_name_variable_properties dynamic_class_name_variable_property",
 /* 340 */ "dynamic_class_name_variable_properties ::=",
 /* 341 */ "dynamic_class_name_variable_property ::= T_OBJECT_OPERATOR object_property",
 /* 342 */ "ctor_arguments ::= LPAREN function_call_parameter_list RPAREN",
 /* 343 */ "ctor_arguments ::=",
 /* 344 */ "possible_comma ::= COMMA",
 /* 345 */ "possible_comma ::=",
 /* 346 */ "for_expr ::= non_empty_for_expr",
 /* 347 */ "for_expr ::=",
 /* 348 */ "non_empty_for_expr ::= non_empty_for_expr COMMA expr",
 /* 349 */ "non_empty_for_expr ::= expr",
 /* 350 */ "is_reference ::= AMPERSAND",
 /* 351 */ "is_reference ::=",
    );

    /**
     * This function returns the symbolic name associated with a token
     * value.
     * @param int
     * @return string
     */
    function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count(self::$yyTokenName)) {
            return self::$yyTokenName[$tokenType];
        } else {
            return "Unknown";
        }
    }

    /**
     * The following function deletes the value associated with a
     * symbol.  The symbol can be either a terminal or nonterminal.
     * @param int the symbol code
     * @param mixed the symbol's value
     */
    static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
        /* Here is inserted the actions which take place when a
        ** terminal or non-terminal is destroyed.  This can happen
        ** when the symbol is popped from the stack during a
        ** reduce or during error processing or when a parser is 
        ** being destroyed before it is finished parsing.
        **
        ** Note: during a reduce, the only symbols destroyed are those
        ** which appear on the RHS of the rule, but which are not used
        ** inside the C code.
        */
            default:  break;   /* If no destructor action specified: do nothing */
        }
    }

    /**
     * Pop the parser's stack once.
     *
     * If there is a destructor routine associated with the token which
     * is popped from the stack, then call it.
     *
     * Return the major token number for the symbol popped.
     * @param PHP_Parser_CoreyyParser
     * @return int
     */
    function yy_pop_parser_stack()
    {
        if (!count($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if (self::$yyTraceFILE && $this->yyidx >= 0) {
            fwrite(self::$yyTraceFILE,
                self::$yyTracePrompt . 'Popping ' . self::$yyTokenName[$yytos->major] .
                    "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx--;
        return $yymajor;
    }

    /**
     * Deallocate and destroy a parser.  Destructors are all called for
     * all stack elements before shutting the parser down.
     */
    function __destruct()
    {
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource(self::$yyTraceFILE)) {
            fclose(self::$yyTraceFILE);
        }
    }

    /**
     * Based on the current state and parser stack, get a list of all
     * possible lookahead tokens
     * @param int
     * @return array
     */
    function yy_get_expected_tokens($token)
    {
        $state = $this->yystack[$this->yyidx]->stateno;
        $expected = self::$yyExpectedTokens[$state];
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return $expected;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate])) {
                        $expected += self::$yyExpectedTokens[$nextstate];
                            if (in_array($token,
                                  self::$yyExpectedTokens[$nextstate], true)) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return array_unique($expected);
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new PHP_Parser_CoreyyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        return array_unique($expected);
    }

    /**
     * Based on the parser state and current parser stack, determine whether
     * the lookahead token is possible.
     * 
     * The parser will convert the token value to an error token if not.  This
     * catches some unusual edge cases where the parser would fail.
     * @param int
     * @return bool
     */
    function yy_is_expected_token($token)
    {
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[$this->yyidx]->stateno;
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return true;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate]) &&
                          in_array($token, self::$yyExpectedTokens[$nextstate], true)) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        return true;
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new PHP_Parser_CoreyyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;
        return true;
    }

    /**
     * Find the appropriate action for a parser given the terminal
     * look-ahead token iLookAhead.
     *
     * If the look-ahead token is YYNOCODE, then check to see if the action is
     * independent of the look-ahead.  If it is, return the action, otherwise
     * return YY_NO_ACTION.
     * @param int The look-ahead token
     */
    function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[$this->yyidx]->stateno;
     
        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[$stateno])) {
            // no shift actions
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_shift_ofst[$stateno];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback)
                   && ($iFallback = self::$yyFallback[$iLookAhead]) != 0) {
                if (self::$yyTraceFILE) {
                    fwrite(self::$yyTraceFILE, self::$yyTracePrompt . "FALLBACK " .
                        self::$yyTokenName[$iLookAhead] . " => " .
                        self::$yyTokenName[$iFallback] . "\n");
                }
                return $this->yy_find_shift_action($iFallback);
            }
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    /**
     * Find the appropriate action for a parser given the non-terminal
     * look-ahead token $iLookAhead.
     *
     * If the look-ahead token is self::YYNOCODE, then check to see if the action is
     * independent of the look-ahead.  If it is, return the action, otherwise
     * return self::YY_NO_ACTION.
     * @param int Current state number
     * @param int The look-ahead token
     */
    function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[$stateno])) {
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_reduce_ofst[$stateno];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    /**
     * Perform a shift action.
     * @param int The new state to shift in
     * @param int The major token to shift in
     * @param mixed the minor token to shift in
     */
    function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx--;
            if (self::$yyTraceFILE) {
                fprintf(self::$yyTraceFILE, "%sStack Overflow!\n", self::$yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
            /* Here code is inserted which will execute if the parser
            ** stack ever overflows */
            return;
        }
        $yytos = new PHP_Parser_CoreyyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        array_push($this->yystack, $yytos);
        if (self::$yyTraceFILE && $this->yyidx > 0) {
            fprintf(self::$yyTraceFILE, "%sShift %d\n", self::$yyTracePrompt,
                $yyNewState);
            fprintf(self::$yyTraceFILE, "%sStack:", self::$yyTracePrompt);
            for($i = 1; $i <= $this->yyidx; $i++) {
                fprintf(self::$yyTraceFILE, " %s",
                    self::$yyTokenName[$this->yystack[$i]->major]);
            }
            fwrite(self::$yyTraceFILE,"\n");
        }
    }

    /**
     * The following table contains information about every rule that
     * is used during the reduce.
     *
     * <pre>
     * array(
     *  array(
     *   int $lhs;         Symbol on the left-hand side of the rule
     *   int $nrhs;     Number of right-hand side symbols in the rule
     *  ),...
     * );
     * </pre>
     */
    static public $yyRuleInfo = array(
  array( 'lhs' => 145, 'rhs' => 1 ),
  array( 'lhs' => 146, 'rhs' => 2 ),
  array( 'lhs' => 146, 'rhs' => 0 ),
  array( 'lhs' => 147, 'rhs' => 1 ),
  array( 'lhs' => 147, 'rhs' => 1 ),
  array( 'lhs' => 147, 'rhs' => 1 ),
  array( 'lhs' => 147, 'rhs' => 4 ),
  array( 'lhs' => 148, 'rhs' => 1 ),
  array( 'lhs' => 151, 'rhs' => 3 ),
  array( 'lhs' => 151, 'rhs' => 7 ),
  array( 'lhs' => 151, 'rhs' => 10 ),
  array( 'lhs' => 151, 'rhs' => 5 ),
  array( 'lhs' => 151, 'rhs' => 7 ),
  array( 'lhs' => 151, 'rhs' => 9 ),
  array( 'lhs' => 151, 'rhs' => 5 ),
  array( 'lhs' => 151, 'rhs' => 2 ),
  array( 'lhs' => 151, 'rhs' => 3 ),
  array( 'lhs' => 151, 'rhs' => 2 ),
  array( 'lhs' => 151, 'rhs' => 3 ),
  array( 'lhs' => 151, 'rhs' => 2 ),
  array( 'lhs' => 151, 'rhs' => 3 ),
  array( 'lhs' => 151, 'rhs' => 3 ),
  array( 'lhs' => 151, 'rhs' => 3 ),
  array( 'lhs' => 151, 'rhs' => 3 ),
  array( 'lhs' => 151, 'rhs' => 3 ),
  array( 'lhs' => 151, 'rhs' => 1 ),
  array( 'lhs' => 151, 'rhs' => 2 ),
  array( 'lhs' => 151, 'rhs' => 3 ),
  array( 'lhs' => 151, 'rhs' => 5 ),
  array( 'lhs' => 151, 'rhs' => 8 ),
  array( 'lhs' => 151, 'rhs' => 8 ),
  array( 'lhs' => 151, 'rhs' => 5 ),
  array( 'lhs' => 151, 'rhs' => 1 ),
  array( 'lhs' => 151, 'rhs' => 13 ),
  array( 'lhs' => 151, 'rhs' => 3 ),
  array( 'lhs' => 175, 'rhs' => 1 ),
  array( 'lhs' => 175, 'rhs' => 0 ),
  array( 'lhs' => 176, 'rhs' => 1 ),
  array( 'lhs' => 176, 'rhs' => 2 ),
  array( 'lhs' => 177, 'rhs' => 8 ),
  array( 'lhs' => 152, 'rhs' => 2 ),
  array( 'lhs' => 152, 'rhs' => 0 ),
  array( 'lhs' => 178, 'rhs' => 1 ),
  array( 'lhs' => 178, 'rhs' => 1 ),
  array( 'lhs' => 178, 'rhs' => 1 ),
  array( 'lhs' => 178, 'rhs' => 4 ),
  array( 'lhs' => 149, 'rhs' => 1 ),
  array( 'lhs' => 150, 'rhs' => 1 ),
  array( 'lhs' => 181, 'rhs' => 1 ),
  array( 'lhs' => 179, 'rhs' => 9 ),
  array( 'lhs' => 180, 'rhs' => 7 ),
  array( 'lhs' => 180, 'rhs' => 6 ),
  array( 'lhs' => 184, 'rhs' => 1 ),
  array( 'lhs' => 184, 'rhs' => 2 ),
  array( 'lhs' => 184, 'rhs' => 2 ),
  array( 'lhs' => 185, 'rhs' => 2 ),
  array( 'lhs' => 185, 'rhs' => 0 ),
  array( 'lhs' => 188, 'rhs' => 1 ),
  array( 'lhs' => 189, 'rhs' => 2 ),
  array( 'lhs' => 189, 'rhs' => 0 ),
  array( 'lhs' => 186, 'rhs' => 0 ),
  array( 'lhs' => 186, 'rhs' => 2 ),
  array( 'lhs' => 190, 'rhs' => 1 ),
  array( 'lhs' => 190, 'rhs' => 3 ),
  array( 'lhs' => 153, 'rhs' => 1 ),
  array( 'lhs' => 153, 'rhs' => 1 ),
  array( 'lhs' => 162, 'rhs' => 6 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 4 ),
  array( 'lhs' => 162, 'rhs' => 6 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 2 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 2 ),
  array( 'lhs' => 162, 'rhs' => 2 ),
  array( 'lhs' => 162, 'rhs' => 2 ),
  array( 'lhs' => 162, 'rhs' => 2 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 2 ),
  array( 'lhs' => 162, 'rhs' => 2 ),
  array( 'lhs' => 162, 'rhs' => 2 ),
  array( 'lhs' => 162, 'rhs' => 2 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 5 ),
  array( 'lhs' => 162, 'rhs' => 1 ),
  array( 'lhs' => 162, 'rhs' => 2 ),
  array( 'lhs' => 162, 'rhs' => 2 ),
  array( 'lhs' => 162, 'rhs' => 2 ),
  array( 'lhs' => 162, 'rhs' => 2 ),
  array( 'lhs' => 162, 'rhs' => 2 ),
  array( 'lhs' => 162, 'rhs' => 2 ),
  array( 'lhs' => 162, 'rhs' => 2 ),
  array( 'lhs' => 162, 'rhs' => 2 ),
  array( 'lhs' => 162, 'rhs' => 2 ),
  array( 'lhs' => 162, 'rhs' => 2 ),
  array( 'lhs' => 162, 'rhs' => 1 ),
  array( 'lhs' => 162, 'rhs' => 4 ),
  array( 'lhs' => 162, 'rhs' => 3 ),
  array( 'lhs' => 162, 'rhs' => 2 ),
  array( 'lhs' => 199, 'rhs' => 1 ),
  array( 'lhs' => 197, 'rhs' => 2 ),
  array( 'lhs' => 197, 'rhs' => 3 ),
  array( 'lhs' => 197, 'rhs' => 0 ),
  array( 'lhs' => 202, 'rhs' => 1 ),
  array( 'lhs' => 203, 'rhs' => 1 ),
  array( 'lhs' => 203, 'rhs' => 1 ),
  array( 'lhs' => 203, 'rhs' => 2 ),
  array( 'lhs' => 203, 'rhs' => 2 ),
  array( 'lhs' => 203, 'rhs' => 4 ),
  array( 'lhs' => 203, 'rhs' => 1 ),
  array( 'lhs' => 204, 'rhs' => 1 ),
  array( 'lhs' => 205, 'rhs' => 1 ),
  array( 'lhs' => 205, 'rhs' => 2 ),
  array( 'lhs' => 205, 'rhs' => 0 ),
  array( 'lhs' => 207, 'rhs' => 5 ),
  array( 'lhs' => 207, 'rhs' => 3 ),
  array( 'lhs' => 207, 'rhs' => 3 ),
  array( 'lhs' => 207, 'rhs' => 1 ),
  array( 'lhs' => 206, 'rhs' => 3 ),
  array( 'lhs' => 170, 'rhs' => 2 ),
  array( 'lhs' => 170, 'rhs' => 0 ),
  array( 'lhs' => 169, 'rhs' => 1 ),
  array( 'lhs' => 169, 'rhs' => 2 ),
  array( 'lhs' => 160, 'rhs' => 1 ),
  array( 'lhs' => 160, 'rhs' => 4 ),
  array( 'lhs' => 171, 'rhs' => 1 ),
  array( 'lhs' => 171, 'rhs' => 4 ),
  array( 'lhs' => 173, 'rhs' => 1 ),
  array( 'lhs' => 173, 'rhs' => 4 ),
  array( 'lhs' => 172, 'rhs' => 3 ),
  array( 'lhs' => 172, 'rhs' => 5 ),
  array( 'lhs' => 161, 'rhs' => 3 ),
  array( 'lhs' => 161, 'rhs' => 4 ),
  array( 'lhs' => 161, 'rhs' => 4 ),
  array( 'lhs' => 161, 'rhs' => 5 ),
  array( 'lhs' => 209, 'rhs' => 5 ),
  array( 'lhs' => 209, 'rhs' => 4 ),
  array( 'lhs' => 209, 'rhs' => 0 ),
  array( 'lhs' => 210, 'rhs' => 1 ),
  array( 'lhs' => 158, 'rhs' => 1 ),
  array( 'lhs' => 158, 'rhs' => 4 ),
  array( 'lhs' => 154, 'rhs' => 6 ),
  array( 'lhs' => 154, 'rhs' => 0 ),
  array( 'lhs' => 156, 'rhs' => 7 ),
  array( 'lhs' => 156, 'rhs' => 0 ),
  array( 'lhs' => 155, 'rhs' => 2 ),
  array( 'lhs' => 155, 'rhs' => 0 ),
  array( 'lhs' => 157, 'rhs' => 3 ),
  array( 'lhs' => 157, 'rhs' => 0 ),
  array( 'lhs' => 183, 'rhs' => 1 ),
  array( 'lhs' => 183, 'rhs' => 0 ),
  array( 'lhs' => 211, 'rhs' => 2 ),
  array( 'lhs' => 211, 'rhs' => 3 ),
  array( 'lhs' => 211, 'rhs' => 5 ),
  array( 'lhs' => 211, 'rhs' => 4 ),
  array( 'lhs' => 211, 'rhs' => 4 ),
  array( 'lhs' => 211, 'rhs' => 5 ),
  array( 'lhs' => 211, 'rhs' => 7 ),
  array( 'lhs' => 211, 'rhs' => 6 ),
  array( 'lhs' => 212, 'rhs' => 1 ),
  array( 'lhs' => 212, 'rhs' => 0 ),
  array( 'lhs' => 213, 'rhs' => 1 ),
  array( 'lhs' => 213, 'rhs' => 0 ),
  array( 'lhs' => 214, 'rhs' => 1 ),
  array( 'lhs' => 214, 'rhs' => 1 ),
  array( 'lhs' => 214, 'rhs' => 2 ),
  array( 'lhs' => 214, 'rhs' => 3 ),
  array( 'lhs' => 214, 'rhs' => 3 ),
  array( 'lhs' => 214, 'rhs' => 4 ),
  array( 'lhs' => 164, 'rhs' => 3 ),
  array( 'lhs' => 164, 'rhs' => 1 ),
  array( 'lhs' => 215, 'rhs' => 1 ),
  array( 'lhs' => 215, 'rhs' => 2 ),
  array( 'lhs' => 215, 'rhs' => 4 ),
  array( 'lhs' => 165, 'rhs' => 3 ),
  array( 'lhs' => 165, 'rhs' => 5 ),
  array( 'lhs' => 165, 'rhs' => 1 ),
  array( 'lhs' => 165, 'rhs' => 3 ),
  array( 'lhs' => 187, 'rhs' => 2 ),
  array( 'lhs' => 187, 'rhs' => 0 ),
  array( 'lhs' => 216, 'rhs' => 3 ),
  array( 'lhs' => 216, 'rhs' => 2 ),
  array( 'lhs' => 220, 'rhs' => 1 ),
  array( 'lhs' => 216, 'rhs' => 8 ),
  array( 'lhs' => 222, 'rhs' => 1 ),
  array( 'lhs' => 222, 'rhs' => 3 ),
  array( 'lhs' => 217, 'rhs' => 1 ),
  array( 'lhs' => 217, 'rhs' => 1 ),
  array( 'lhs' => 221, 'rhs' => 1 ),
  array( 'lhs' => 221, 'rhs' => 0 ),
  array( 'lhs' => 223, 'rhs' => 1 ),
  array( 'lhs' => 223, 'rhs' => 2 ),
  array( 'lhs' => 224, 'rhs' => 1 ),
  array( 'lhs' => 225, 'rhs' => 1 ),
  array( 'lhs' => 218, 'rhs' => 3 ),
  array( 'lhs' => 218, 'rhs' => 5 ),
  array( 'lhs' => 218, 'rhs' => 1 ),
  array( 'lhs' => 218, 'rhs' => 3 ),
  array( 'lhs' => 226, 'rhs' => 1 ),
  array( 'lhs' => 219, 'rhs' => 5 ),
  array( 'lhs' => 219, 'rhs' => 4 ),
  array( 'lhs' => 166, 'rhs' => 3 ),
  array( 'lhs' => 166, 'rhs' => 1 ),
  array( 'lhs' => 168, 'rhs' => 1 ),
  array( 'lhs' => 168, 'rhs' => 3 ),
  array( 'lhs' => 227, 'rhs' => 1 ),
  array( 'lhs' => 167, 'rhs' => 1 ),
  array( 'lhs' => 167, 'rhs' => 3 ),
  array( 'lhs' => 191, 'rhs' => 1 ),
  array( 'lhs' => 208, 'rhs' => 1 ),
  array( 'lhs' => 195, 'rhs' => 1 ),
  array( 'lhs' => 163, 'rhs' => 5 ),
  array( 'lhs' => 163, 'rhs' => 1 ),
  array( 'lhs' => 231, 'rhs' => 2 ),
  array( 'lhs' => 231, 'rhs' => 0 ),
  array( 'lhs' => 232, 'rhs' => 3 ),
  array( 'lhs' => 230, 'rhs' => 3 ),
  array( 'lhs' => 230, 'rhs' => 0 ),
  array( 'lhs' => 233, 'rhs' => 1 ),
  array( 'lhs' => 233, 'rhs' => 2 ),
  array( 'lhs' => 236, 'rhs' => 3 ),
  array( 'lhs' => 228, 'rhs' => 1 ),
  array( 'lhs' => 228, 'rhs' => 1 ),
  array( 'lhs' => 237, 'rhs' => 1 ),
  array( 'lhs' => 237, 'rhs' => 2 ),
  array( 'lhs' => 237, 'rhs' => 1 ),
  array( 'lhs' => 234, 'rhs' => 4 ),
  array( 'lhs' => 234, 'rhs' => 4 ),
  array( 'lhs' => 234, 'rhs' => 1 ),
  array( 'lhs' => 240, 'rhs' => 1 ),
  array( 'lhs' => 240, 'rhs' => 4 ),
  array( 'lhs' => 239, 'rhs' => 1 ),
  array( 'lhs' => 239, 'rhs' => 0 ),
  array( 'lhs' => 229, 'rhs' => 1 ),
  array( 'lhs' => 229, 'rhs' => 1 ),
  array( 'lhs' => 241, 'rhs' => 4 ),
  array( 'lhs' => 241, 'rhs' => 4 ),
  array( 'lhs' => 241, 'rhs' => 1 ),
  array( 'lhs' => 242, 'rhs' => 1 ),
  array( 'lhs' => 242, 'rhs' => 3 ),
  array( 'lhs' => 235, 'rhs' => 1 ),
  array( 'lhs' => 235, 'rhs' => 2 ),
  array( 'lhs' => 192, 'rhs' => 3 ),
  array( 'lhs' => 192, 'rhs' => 1 ),
  array( 'lhs' => 243, 'rhs' => 1 ),
  array( 'lhs' => 243, 'rhs' => 4 ),
  array( 'lhs' => 243, 'rhs' => 0 ),
  array( 'lhs' => 200, 'rhs' => 2 ),
  array( 'lhs' => 200, 'rhs' => 0 ),
  array( 'lhs' => 244, 'rhs' => 4 ),
  array( 'lhs' => 244, 'rhs' => 1 ),
  array( 'lhs' => 244, 'rhs' => 2 ),
  array( 'lhs' => 244, 'rhs' => 5 ),
  array( 'lhs' => 244, 'rhs' => 3 ),
  array( 'lhs' => 244, 'rhs' => 3 ),
  array( 'lhs' => 244, 'rhs' => 6 ),
  array( 'lhs' => 244, 'rhs' => 4 ),
  array( 'lhs' => 201, 'rhs' => 2 ),
  array( 'lhs' => 201, 'rhs' => 2 ),
  array( 'lhs' => 201, 'rhs' => 2 ),
  array( 'lhs' => 201, 'rhs' => 2 ),
  array( 'lhs' => 201, 'rhs' => 2 ),
  array( 'lhs' => 201, 'rhs' => 2 ),
  array( 'lhs' => 201, 'rhs' => 2 ),
  array( 'lhs' => 201, 'rhs' => 2 ),
  array( 'lhs' => 201, 'rhs' => 2 ),
  array( 'lhs' => 201, 'rhs' => 2 ),
  array( 'lhs' => 201, 'rhs' => 2 ),
  array( 'lhs' => 201, 'rhs' => 0 ),
  array( 'lhs' => 246, 'rhs' => 1 ),
  array( 'lhs' => 246, 'rhs' => 4 ),
  array( 'lhs' => 246, 'rhs' => 3 ),
  array( 'lhs' => 246, 'rhs' => 3 ),
  array( 'lhs' => 246, 'rhs' => 6 ),
  array( 'lhs' => 246, 'rhs' => 3 ),
  array( 'lhs' => 196, 'rhs' => 4 ),
  array( 'lhs' => 196, 'rhs' => 4 ),
  array( 'lhs' => 248, 'rhs' => 1 ),
  array( 'lhs' => 196, 'rhs' => 2 ),
  array( 'lhs' => 249, 'rhs' => 1 ),
  array( 'lhs' => 196, 'rhs' => 2 ),
  array( 'lhs' => 196, 'rhs' => 4 ),
  array( 'lhs' => 250, 'rhs' => 1 ),
  array( 'lhs' => 196, 'rhs' => 2 ),
  array( 'lhs' => 251, 'rhs' => 1 ),
  array( 'lhs' => 196, 'rhs' => 2 ),
  array( 'lhs' => 247, 'rhs' => 1 ),
  array( 'lhs' => 247, 'rhs' => 3 ),
  array( 'lhs' => 252, 'rhs' => 3 ),
  array( 'lhs' => 174, 'rhs' => 1 ),
  array( 'lhs' => 238, 'rhs' => 4 ),
  array( 'lhs' => 238, 'rhs' => 6 ),
  array( 'lhs' => 238, 'rhs' => 6 ),
  array( 'lhs' => 238, 'rhs' => 4 ),
  array( 'lhs' => 198, 'rhs' => 1 ),
  array( 'lhs' => 198, 'rhs' => 1 ),
  array( 'lhs' => 198, 'rhs' => 1 ),
  array( 'lhs' => 198, 'rhs' => 1 ),
  array( 'lhs' => 198, 'rhs' => 3 ),
  array( 'lhs' => 198, 'rhs' => 3 ),
  array( 'lhs' => 198, 'rhs' => 3 ),
  array( 'lhs' => 193, 'rhs' => 1 ),
  array( 'lhs' => 193, 'rhs' => 1 ),
  array( 'lhs' => 253, 'rhs' => 4 ),
  array( 'lhs' => 253, 'rhs' => 1 ),
  array( 'lhs' => 254, 'rhs' => 2 ),
  array( 'lhs' => 254, 'rhs' => 0 ),
  array( 'lhs' => 255, 'rhs' => 2 ),
  array( 'lhs' => 194, 'rhs' => 3 ),
  array( 'lhs' => 194, 'rhs' => 0 ),
  array( 'lhs' => 245, 'rhs' => 1 ),
  array( 'lhs' => 245, 'rhs' => 0 ),
  array( 'lhs' => 159, 'rhs' => 1 ),
  array( 'lhs' => 159, 'rhs' => 0 ),
  array( 'lhs' => 256, 'rhs' => 3 ),
  array( 'lhs' => 256, 'rhs' => 1 ),
  array( 'lhs' => 182, 'rhs' => 1 ),
  array( 'lhs' => 182, 'rhs' => 0 ),
    );

    /**
     * The following table contains a mapping of reduce action to method name
     * that handles the reduction.
     * 
     * If a rule is not set, it has no handler.
     */
    static public $yyReduceMap = array(
        0 => 0,
        1 => 1,
        38 => 1,
        40 => 1,
        212 => 1,
        225 => 1,
        2 => 2,
        41 => 2,
        56 => 2,
        59 => 2,
        60 => 2,
        136 => 2,
        171 => 2,
        176 => 2,
        178 => 2,
        180 => 2,
        182 => 2,
        184 => 2,
        196 => 2,
        213 => 2,
        218 => 2,
        248 => 2,
        251 => 2,
        266 => 2,
        280 => 2,
        282 => 2,
        302 => 2,
        340 => 2,
        343 => 2,
        347 => 2,
        3 => 3,
        4 => 3,
        5 => 3,
        7 => 3,
        35 => 3,
        37 => 3,
        58 => 3,
        61 => 3,
        64 => 3,
        65 => 3,
        118 => 3,
        137 => 3,
        138 => 3,
        139 => 3,
        140 => 3,
        143 => 3,
        145 => 3,
        151 => 3,
        155 => 3,
        157 => 3,
        159 => 3,
        161 => 3,
        173 => 3,
        179 => 3,
        181 => 3,
        183 => 3,
        193 => 3,
        195 => 3,
        204 => 3,
        220 => 3,
        222 => 3,
        236 => 3,
        237 => 3,
        239 => 3,
        240 => 3,
        242 => 3,
        243 => 3,
        244 => 3,
        246 => 3,
        252 => 3,
        256 => 3,
        257 => 3,
        259 => 3,
        263 => 3,
        267 => 3,
        268 => 3,
        272 => 3,
        277 => 3,
        278 => 3,
        284 => 3,
        320 => 3,
        323 => 3,
        335 => 3,
        336 => 3,
        338 => 3,
        346 => 3,
        349 => 3,
        6 => 6,
        8 => 8,
        22 => 8,
        23 => 8,
        26 => 8,
        165 => 8,
        166 => 8,
        9 => 9,
        10 => 10,
        11 => 11,
        14 => 11,
        12 => 12,
        13 => 13,
        16 => 16,
        18 => 18,
        24 => 18,
        20 => 20,
        21 => 20,
        27 => 27,
        28 => 28,
        29 => 29,
        30 => 29,
        31 => 31,
        33 => 33,
        34 => 34,
        39 => 39,
        42 => 42,
        43 => 42,
        44 => 42,
        46 => 42,
        47 => 42,
        45 => 45,
        48 => 48,
        57 => 48,
        49 => 49,
        50 => 50,
        51 => 51,
        52 => 52,
        53 => 53,
        54 => 54,
        55 => 55,
        62 => 62,
        63 => 63,
        66 => 66,
        67 => 67,
        68 => 68,
        69 => 69,
        70 => 70,
        71 => 71,
        72 => 72,
        73 => 73,
        74 => 74,
        75 => 75,
        76 => 76,
        77 => 77,
        78 => 78,
        79 => 79,
        80 => 80,
        81 => 81,
        82 => 82,
        83 => 83,
        84 => 84,
        85 => 85,
        86 => 86,
        87 => 87,
        88 => 88,
        89 => 89,
        90 => 90,
        91 => 91,
        92 => 92,
        93 => 93,
        94 => 94,
        95 => 95,
        96 => 96,
        97 => 97,
        98 => 98,
        99 => 99,
        100 => 100,
        101 => 101,
        102 => 102,
        103 => 103,
        104 => 104,
        105 => 105,
        106 => 106,
        107 => 107,
        108 => 108,
        109 => 109,
        110 => 110,
        111 => 111,
        112 => 112,
        113 => 113,
        114 => 114,
        115 => 115,
        116 => 116,
        342 => 116,
        117 => 117,
        119 => 119,
        120 => 120,
        121 => 121,
        122 => 122,
        123 => 123,
        124 => 124,
        125 => 125,
        126 => 126,
        127 => 127,
        128 => 128,
        129 => 129,
        130 => 130,
        131 => 131,
        132 => 132,
        133 => 133,
        134 => 134,
        135 => 135,
        141 => 141,
        142 => 142,
        144 => 144,
        146 => 146,
        147 => 147,
        194 => 147,
        345 => 147,
        148 => 148,
        149 => 149,
        150 => 149,
        152 => 152,
        153 => 153,
        156 => 156,
        285 => 156,
        158 => 158,
        160 => 158,
        162 => 158,
        167 => 158,
        168 => 158,
        174 => 158,
        163 => 163,
        164 => 164,
        169 => 169,
        170 => 170,
        175 => 175,
        177 => 177,
        185 => 185,
        186 => 186,
        187 => 187,
        188 => 188,
        189 => 189,
        190 => 190,
        191 => 191,
        192 => 192,
        197 => 197,
        198 => 197,
        255 => 197,
        262 => 197,
        265 => 197,
        271 => 197,
        303 => 197,
        328 => 197,
        329 => 197,
        330 => 197,
        331 => 197,
        199 => 199,
        200 => 200,
        201 => 200,
        202 => 202,
        203 => 203,
        238 => 203,
        205 => 205,
        206 => 206,
        207 => 207,
        306 => 207,
        208 => 208,
        209 => 209,
        210 => 210,
        211 => 211,
        214 => 214,
        215 => 215,
        216 => 216,
        217 => 217,
        219 => 219,
        221 => 221,
        223 => 221,
        224 => 224,
        226 => 226,
        227 => 227,
        228 => 228,
        229 => 229,
        230 => 230,
        231 => 231,
        232 => 232,
        233 => 233,
        234 => 234,
        235 => 235,
        241 => 241,
        245 => 245,
        249 => 249,
        250 => 250,
        253 => 253,
        258 => 253,
        254 => 254,
        260 => 260,
        261 => 261,
        264 => 264,
        269 => 269,
        270 => 270,
        273 => 273,
        274 => 274,
        275 => 275,
        276 => 276,
        287 => 276,
        321 => 276,
        348 => 276,
        279 => 279,
        281 => 281,
        292 => 281,
        293 => 281,
        294 => 281,
        295 => 281,
        296 => 281,
        283 => 283,
        286 => 286,
        288 => 288,
        289 => 289,
        290 => 290,
        291 => 291,
        297 => 297,
        298 => 298,
        299 => 299,
        300 => 300,
        301 => 301,
        304 => 304,
        305 => 305,
        307 => 307,
        308 => 308,
        309 => 309,
        310 => 310,
        311 => 311,
        316 => 311,
        312 => 312,
        313 => 313,
        314 => 314,
        315 => 315,
        317 => 317,
        318 => 318,
        319 => 319,
        322 => 322,
        324 => 324,
        325 => 325,
        326 => 326,
        327 => 327,
        332 => 332,
        333 => 333,
        334 => 334,
        337 => 337,
        339 => 339,
        341 => 341,
        344 => 344,
        350 => 350,
        351 => 351,
    );
    /* Beginning here are the reduction cases.  A typical example
    ** follows:
    **  #line <lineno> <grammarfile>
    **   function yy_r0($yymsp){ ... }           // User supplied code
    **  #line <lineno> <thisfile>
    */
#line 123 "Core.y"
    function yy_r0(){$this->data = $this->yystack[$this->yyidx + 0]->minor->metadata;    }
#line 5420 "Core.php"
#line 125 "Core.y"
    function yy_r1(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5426 "Core.php"
#line 129 "Core.y"
    function yy_r2(){$this->_retvalue = new PHP_Parser_CoreyyToken('');    }
#line 5429 "Core.php"
#line 131 "Core.y"
    function yy_r3(){$this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;    }
#line 5432 "Core.php"
#line 134 "Core.y"
    function yy_r6(){ $this->lex->haltParsing();     }
#line 5435 "Core.php"
#line 138 "Core.y"
    function yy_r8(){$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;    }
#line 5438 "Core.php"
#line 139 "Core.y"
    function yy_r9(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('');
    $this->_retvalue[] = $this->yystack[$this->yyidx + -4]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -2]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -1]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5447 "Core.php"
#line 146 "Core.y"
    function yy_r10(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('if (' . $this->yystack[$this->yyidx + -7]->minor->string . '):' . $this->yystack[$this->yyidx + -4]->minor->string . $this->yystack[$this->yyidx + -3]->minor->string . $this->yystack[$this->yyidx + -2]->minor->string . 'endif;');
    $this->_retvalue[] = $this->yystack[$this->yyidx + -7]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -4]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -3]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -2]->minor;
    }
#line 5456 "Core.php"
#line 153 "Core.y"
    function yy_r11(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('');
    $this->_retvalue[] = $this->yystack[$this->yyidx + -2]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5463 "Core.php"
#line 158 "Core.y"
    function yy_r12(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('');
    $this->_retvalue[] = $this->yystack[$this->yyidx + -5]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -2]->minor;
    }
#line 5470 "Core.php"
#line 171 "Core.y"
    function yy_r13(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('');
    $this->_retvalue[] = $this->yystack[$this->yyidx + -6]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -4]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -2]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5479 "Core.php"
#line 184 "Core.y"
    function yy_r16(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('');
    $this->_retvalue[] = $this->yystack[$this->yyidx + -1]->minor;
    }
#line 5485 "Core.php"
#line 189 "Core.y"
    function yy_r18(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 5490 "Core.php"
#line 193 "Core.y"
    function yy_r20(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('return ' . $this->yystack[$this->yyidx + -1]->minor->string . ';', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 5495 "Core.php"
#line 206 "Core.y"
    function yy_r27(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('', array('uses' => trim($this->yystack[$this->yyidx + -1]->minor)));
    // not that "uses" would actually work in real life
    }
#line 5501 "Core.php"
#line 210 "Core.y"
    function yy_r28(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('', $this->yystack[$this->yyidx + -2]->minor);
    }
#line 5506 "Core.php"
#line 215 "Core.y"
    function yy_r29(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('', $this->yystack[$this->yyidx + -5]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5512 "Core.php"
#line 225 "Core.y"
    function yy_r31(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('', $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5518 "Core.php"
#line 235 "Core.y"
    function yy_r33(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('');
    $this->_retvalue[] = array('catches' => $this->yystack[$this->yyidx + -6]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + -10]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -2]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5527 "Core.php"
#line 242 "Core.y"
    function yy_r34(){
    if ($this->yystack[$this->yyidx + -1]->minor->metadata && isset($this->yystack[$this->yyidx + -1]->minor->metadata[0]) && isset($this->yystack[$this->yyidx + -1]->minor->metadata[0]['uses']) &&
          $this->yystack[$this->yyidx + -1]->minor->metadata[0]['uses'] === 'class') {
        $this->_retvalue = new PHP_Parser_CoreyyToken('throw ' . $this->yystack[$this->yyidx + -1]->minor->string, array('throws' => $this->yystack[$this->yyidx + -1]->minor->metadata[0]['name']));
    } else {
        $this->_retvalue = new PHP_Parser_CoreyyToken('throw ' . $this->yystack[$this->yyidx + -1]->minor->string);
        $this->_retvalue[] = $this->yystack[$this->yyidx + -1]->minor;
    }
    }
#line 5538 "Core.php"
#line 261 "Core.y"
    function yy_r39(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('', $this->yystack[$this->yyidx + -1]->minor);
    $this->_retvalue[] = array('catches' => $this->yystack[$this->yyidx + -5]->minor);
    }
#line 5544 "Core.php"
#line 272 "Core.y"
    function yy_r42(){
    $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5549 "Core.php"
#line 281 "Core.y"
    function yy_r45(){
    throw new Exception("Error on line " . $this->lex->line .
        ": __halt_compiler(); can only be used at the top level");
    }
#line 5555 "Core.php"
#line 294 "Core.y"
    function yy_r48(){$this->_retvalue = $this->lex->line;    }
#line 5558 "Core.php"
#line 297 "Core.y"
    function yy_r49(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('function ' . ($this->yystack[$this->yyidx + -7]->minor ? '&' : '') .
       $this->yystack[$this->yyidx + -6]->minor . '(' . $this->yystack[$this->yyidx + -4]->minor->string . ')');
    list($doc, $parsed, $line) = $this->lex->getLastComment();
    $this->_retvalue[] = array(
        'type' => 'function',
        'startline' => $this->yystack[$this->yyidx + -8]->minor,
        'endline' => $this->lex->line,
        'returnsref' => $this->yystack[$this->yyidx + -7]->minor,
        'name' => $this->yystack[$this->yyidx + -6]->minor,
        'parameters' => $this->yystack[$this->yyidx + -4]->minor->metadata,
        'info' => $this->yystack[$this->yyidx + -1]->minor->metadata,
        'doc' => $doc,
        'parseddoc' => $parsed,
        'docline' => $line,
    );
    $this->functions[$this->yystack[$this->yyidx + -6]->minor][] = array(
        'type' => 'function',
        'startline' => $this->yystack[$this->yyidx + -8]->minor,
        'endline' => $this->lex->line,
        'returnsref' => $this->yystack[$this->yyidx + -7]->minor,
        'name' => $this->yystack[$this->yyidx + -6]->minor,
        'parameters' => $this->yystack[$this->yyidx + -4]->minor->metadata,
        'info' => $this->yystack[$this->yyidx + -1]->minor->metadata,
        'doc' => $doc,
        'parseddoc' => $parsed,
        'docline' => $line,
    );
    }
#line 5589 "Core.php"
#line 332 "Core.y"
    function yy_r50(){
    list($doc, $parsed, $line) = $this->lex->getLastComment();
    $this->_retvalue = new PHP_Parser_CoreyyToken('', array(
       'type' => $this->yystack[$this->yyidx + -6]->minor['type'],
       'startline' => $this->yystack[$this->yyidx + -6]->minor['line'],
       'endline' => $this->lex->line,
       'modifiers' => $this->yystack[$this->yyidx + -6]->minor['modifiers'],
       'name' => $this->yystack[$this->yyidx + -5]->minor,
       'extends' => $this->yystack[$this->yyidx + -4]->minor->metadata,
       'implements' => $this->yystack[$this->yyidx + -3]->minor->metadata,
       'info' => $this->yystack[$this->yyidx + -1]->minor->metadata,
       'doc' => $doc,
       'parseddoc' => $parsed,
       'docline' => $line,
    ));
    $this->classes[$this->yystack[$this->yyidx + -5]->minor][] = array(
       'type' => $this->yystack[$this->yyidx + -6]->minor['type'],
       'startline' => $this->yystack[$this->yyidx + -6]->minor['line'],
       'endline' => $this->lex->line,
       'modifiers' => $this->yystack[$this->yyidx + -6]->minor['modifiers'],
       'name' => $this->yystack[$this->yyidx + -5]->minor,
       'extends' => $this->yystack[$this->yyidx + -4]->minor->metadata,
       'implements' => $this->yystack[$this->yyidx + -3]->minor->metadata,
       'info' => $this->yystack[$this->yyidx + -1]->minor->metadata,
       'doc' => $doc,
       'parseddoc' => $parsed,
       'docline' => $line,
    );
    }
#line 5620 "Core.php"
#line 366 "Core.y"
    function yy_r51(){
    list($doc, $parsed, $line) = $this->lex->getLastComment();
    $this->_retvalue = new PHP_Parser_CoreyyToken('', array(
       'type' => 'interface',
       'startline' => $this->yystack[$this->yyidx + -5]->minor,
       'endline' => $this->lex->line,
       'name' => $this->yystack[$this->yyidx + -4]->minor,
       'extends' => $this->yystack[$this->yyidx + -3]->minor->metadata,
       'info' => $this->yystack[$this->yyidx + -1]->minor->metadata,
       'doc' => $doc,
       'parseddoc' => $parsed,
       'docline' => $line,
    ));
    $this->interfaces[$this->yystack[$this->yyidx + -4]->minor][] = array(
       'type' => 'interface',
       'startline' => $this->yystack[$this->yyidx + -5]->minor,
       'endline' => $this->lex->line,
       'name' => $this->yystack[$this->yyidx + -4]->minor,
       'extends' => $this->yystack[$this->yyidx + -3]->minor->metadata,
       'info' => $this->yystack[$this->yyidx + -1]->minor->metadata,
       'doc' => $doc,
       'parseddoc' => $parsed,
       'docline' => $line,
    );
    }
#line 5647 "Core.php"
#line 392 "Core.y"
    function yy_r52(){ $this->_retvalue = new PHP_Parser_CoreyyToken('', array('type' => 'class', 'modifiers' => array(), 'line' => $this->lex->line));     }
#line 5650 "Core.php"
#line 393 "Core.y"
    function yy_r53(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('', array('type' => 'class', 'modifiers' => array('abstract'), 'line' => $this->lex->line));
    }
#line 5655 "Core.php"
#line 396 "Core.y"
    function yy_r54(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('', array('type' => 'class', 'modifiers' => array('final'), 'line' => $this->lex->line));
    }
#line 5660 "Core.php"
#line 400 "Core.y"
    function yy_r55(){$this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + 0]->minor, array($this->yystack[$this->yyidx + 0]->minor));    }
#line 5663 "Core.php"
#line 411 "Core.y"
    function yy_r62(){$this->_retvalue = new PHP_Parser_CoreyyToken('', array($this->yystack[$this->yyidx + 0]->minor));    }
#line 5666 "Core.php"
#line 412 "Core.y"
    function yy_r63(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;
    $this->_retvalue[] = array($this->yystack[$this->yyidx + 0]->minor);
    }
#line 5672 "Core.php"
#line 420 "Core.y"
    function yy_r66(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('list(' . $this->yystack[$this->yyidx + -3]->minor->string . ') = ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -3]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5678 "Core.php"
#line 424 "Core.y"
    function yy_r67(){
    if ($this->lex->globalSearch($this->yystack[$this->yyidx + -2]->minor->string)) {
        list($doc, $parsed, $line) = $this->lex->getLastComment();
        $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' = ' . $this->yystack[$this->yyidx + 0]->minor->string,
            array(
                'type' => 'global',
                'name' => $this->yystack[$this->yyidx + -2]->minor->string,
                'line' => $this->lex->line,
                'default' => $this->yystack[$this->yyidx + 0]->minor->string,
                'doc' => $doc,
                'parseddoc' => $parsed,
                'docline' => $line,
            ));
        $this->_retvalue[] = $this->yystack[$this->yyidx + -2]->minor;
        $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
        $this->globals[$this->yystack[$this->yyidx + -2]->minor->string][] = array(
                'type' => 'global',
                'name' => $this->yystack[$this->yyidx + -2]->minor->string,
                'line' => $this->lex->line,
                'default' => $this->yystack[$this->yyidx + 0]->minor->string,
                'doc' => $doc,
                'parseddoc' => $parsed,
                'docline' => $line,
            );
    } else {
        $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' = ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
        $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
    }
#line 5709 "Core.php"
#line 453 "Core.y"
    function yy_r68(){
    if ($this->lex->globalSearch($this->yystack[$this->yyidx + -3]->minor->string)) {
        list($doc, $parsed, $line) = $this->lex->getLastComment();
        $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -3]->minor->string . ' = ' . $this->yystack[$this->yyidx + 0]->minor->string,
            array(
                'type' => 'global',
                'name' => $this->yystack[$this->yyidx + -3]->minor->string,
                'line' => $this->lex->line,
                'default' => '&' . $this->yystack[$this->yyidx + 0]->minor->string,
                'doc' => $doc,
                'parseddoc' => $parsed,
                'docline' => $line,
            ));
        $this->_retvalue[] = $this->yystack[$this->yyidx + -3]->minor;
        $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
        $this->globals[$this->yystack[$this->yyidx + -3]->minor->string][] = 
            array(
                'type' => 'global',
                'name' => $this->yystack[$this->yyidx + -3]->minor->string,
                'line' => $this->lex->line,
                'default' => '&' . $this->yystack[$this->yyidx + 0]->minor->string,
                'doc' => $doc,
                'parseddoc' => $parsed,
                'docline' => $line,
            );
    } else {
        $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -3]->minor->string . ' = &' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -3]->minor);
        $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
    }
#line 5741 "Core.php"
#line 484 "Core.y"
    function yy_r69(){
    $c = is_string($this->yystack[$this->yyidx + -1]->minor) ? $this->yystack[$this->yyidx + -1]->minor : $this->yystack[$this->yyidx + -1]->minor->string;
    if ($this->lex->globalSearch($this->yystack[$this->yyidx + -5]->minor->string)) {
        list($doc, $parsed, $line) = $this->lex->getLastComment();
        $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -5]->minor->string . ' = &new ' . $c . $this->yystack[$this->yyidx + 0]->minor->string,
            array(
                'type' => 'global',
                'name' => $this->yystack[$this->yyidx + -5]->minor->string,
                'line' => $this->lex->line,
                'default' => '&new ' . $this->yystack[$this->yyidx + -1]->minor->string . $this->yystack[$this->yyidx + 0]->minor->string,
                'doc' => $doc,
                'parseddoc' => $parsed,
                'docline' => $line,
            ));
        $this->_retvalue[] = $this->yystack[$this->yyidx + -5]->minor;
        $this->globals[$this->yystack[$this->yyidx + -5]->minor->string][] =
            array(
                'type' => 'global',
                'name' => $this->yystack[$this->yyidx + -5]->minor->string,
                'line' => $this->lex->line,
                'default' => '&new ' . $this->yystack[$this->yyidx + -1]->minor->string . $this->yystack[$this->yyidx + 0]->minor->string,
                'doc' => $doc,
                'parseddoc' => $parsed,
                'docline' => $line,
            );
    } else {
        $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -5]->minor->string . ' = &new ' . $c . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -5]->minor);
    }
    if (is_string($this->yystack[$this->yyidx + -1]->minor)) {
        $this->_retvalue[] = array('uses' => 'class', 'name' => trim($this->yystack[$this->yyidx + -1]->minor));
    }
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5776 "Core.php"
#line 517 "Core.y"
    function yy_r70(){
    $b = is_string($this->yystack[$this->yyidx + -1]->minor) ? $this->yystack[$this->yyidx + -1]->minor : $this->yystack[$this->yyidx + -1]->minor->string;
    $this->_retvalue = new PHP_Parser_CoreyyToken('new ' . $b . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -1]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    if (is_string($this->yystack[$this->yyidx + -1]->minor)) {
        $this->_retvalue[] = array('uses' => 'class', 'name' => trim($this->yystack[$this->yyidx + -1]->minor));
    }
    }
#line 5786 "Core.php"
#line 525 "Core.y"
    function yy_r71(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('clone ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5791 "Core.php"
#line 528 "Core.y"
    function yy_r72(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' += ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5797 "Core.php"
#line 532 "Core.y"
    function yy_r73(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' -= ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5803 "Core.php"
#line 537 "Core.y"
    function yy_r74(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' *= ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5809 "Core.php"
#line 542 "Core.y"
    function yy_r75(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' /= ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5815 "Core.php"
#line 547 "Core.y"
    function yy_r76(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' .= ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5821 "Core.php"
#line 552 "Core.y"
    function yy_r77(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' %= ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5827 "Core.php"
#line 557 "Core.y"
    function yy_r78(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' &= ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5833 "Core.php"
#line 562 "Core.y"
    function yy_r79(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' |= ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5839 "Core.php"
#line 567 "Core.y"
    function yy_r80(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' ^= ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5845 "Core.php"
#line 572 "Core.y"
    function yy_r81(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' <<= ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5851 "Core.php"
#line 577 "Core.y"
    function yy_r82(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' >>= ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5857 "Core.php"
#line 582 "Core.y"
    function yy_r83(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -1]->minor->string . '++', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 5862 "Core.php"
#line 585 "Core.y"
    function yy_r84(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('++' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5867 "Core.php"
#line 588 "Core.y"
    function yy_r85(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -1]->minor->string . '--', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 5872 "Core.php"
#line 591 "Core.y"
    function yy_r86(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('--' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5877 "Core.php"
#line 594 "Core.y"
    function yy_r87(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' || ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5883 "Core.php"
#line 598 "Core.y"
    function yy_r88(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' && ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5889 "Core.php"
#line 602 "Core.y"
    function yy_r89(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' OR ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5895 "Core.php"
#line 606 "Core.y"
    function yy_r90(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' AND ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5901 "Core.php"
#line 610 "Core.y"
    function yy_r91(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' XOR ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5907 "Core.php"
#line 614 "Core.y"
    function yy_r92(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' | ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5913 "Core.php"
#line 618 "Core.y"
    function yy_r93(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' & ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5919 "Core.php"
#line 622 "Core.y"
    function yy_r94(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' ^ ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5925 "Core.php"
#line 626 "Core.y"
    function yy_r95(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' . ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5931 "Core.php"
#line 630 "Core.y"
    function yy_r96(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' + ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5937 "Core.php"
#line 634 "Core.y"
    function yy_r97(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' - ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5943 "Core.php"
#line 638 "Core.y"
    function yy_r98(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' * ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5949 "Core.php"
#line 642 "Core.y"
    function yy_r99(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' / ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5955 "Core.php"
#line 646 "Core.y"
    function yy_r100(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' % ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5961 "Core.php"
#line 650 "Core.y"
    function yy_r101(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' << ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5967 "Core.php"
#line 654 "Core.y"
    function yy_r102(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' >> ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5973 "Core.php"
#line 658 "Core.y"
    function yy_r103(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('+' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5978 "Core.php"
#line 661 "Core.y"
    function yy_r104(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('-' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5983 "Core.php"
#line 664 "Core.y"
    function yy_r105(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('!' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5988 "Core.php"
#line 667 "Core.y"
    function yy_r106(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('~' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 5993 "Core.php"
#line 670 "Core.y"
    function yy_r107(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' === ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 5999 "Core.php"
#line 674 "Core.y"
    function yy_r108(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' !== ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6005 "Core.php"
#line 678 "Core.y"
    function yy_r109(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' == ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6011 "Core.php"
#line 682 "Core.y"
    function yy_r110(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' != ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6017 "Core.php"
#line 686 "Core.y"
    function yy_r111(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' < ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6023 "Core.php"
#line 690 "Core.y"
    function yy_r112(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' <= ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6029 "Core.php"
#line 694 "Core.y"
    function yy_r113(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' > ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6035 "Core.php"
#line 698 "Core.y"
    function yy_r114(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' >= ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6041 "Core.php"
#line 702 "Core.y"
    function yy_r115(){
    $c = is_string($this->yystack[$this->yyidx + 0]->minor) ? $this->yystack[$this->yyidx + 0]->minor : $this->yystack[$this->yyidx + 0]->minor->string;
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' instanceof ' . $c, $this->yystack[$this->yyidx + -2]->minor);
    if (!is_string($this->yystack[$this->yyidx + 0]->minor)) {
        $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
    }
#line 6050 "Core.php"
#line 709 "Core.y"
    function yy_r116(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('(' . $this->yystack[$this->yyidx + -1]->minor->string . ')', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6055 "Core.php"
#line 714 "Core.y"
    function yy_r117(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -4]->minor->string . ' ? ' . $this->yystack[$this->yyidx + -2]->minor->string . ' : ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -4]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + -2]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6062 "Core.php"
#line 720 "Core.y"
    function yy_r119(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('(int) ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6067 "Core.php"
#line 723 "Core.y"
    function yy_r120(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('(double) ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6072 "Core.php"
#line 726 "Core.y"
    function yy_r121(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('(string) ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6077 "Core.php"
#line 729 "Core.y"
    function yy_r122(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('(array) ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6082 "Core.php"
#line 732 "Core.y"
    function yy_r123(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('(object) ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6087 "Core.php"
#line 735 "Core.y"
    function yy_r124(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('(binary) ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6092 "Core.php"
#line 738 "Core.y"
    function yy_r125(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('(bool) ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6097 "Core.php"
#line 741 "Core.y"
    function yy_r126(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('(unset) ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6102 "Core.php"
#line 744 "Core.y"
    function yy_r127(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('exit ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6107 "Core.php"
#line 747 "Core.y"
    function yy_r128(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('@' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6112 "Core.php"
#line 750 "Core.y"
    function yy_r129(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6117 "Core.php"
#line 753 "Core.y"
    function yy_r130(){
    $this->lex->stopTrackingWhitespace();
    $this->_retvalue = new PHP_Parser_CoreyyToken('array(' . $this->yystack[$this->yyidx + -1]->minor->string . ')', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6123 "Core.php"
#line 757 "Core.y"
    function yy_r131(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('`' . $this->yystack[$this->yyidx + -1]->minor->string . '`');
    }
#line 6128 "Core.php"
#line 760 "Core.y"
    function yy_r132(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('print ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6133 "Core.php"
#line 764 "Core.y"
    function yy_r133(){$this->lex->trackWhitespace();    }
#line 6136 "Core.php"
#line 766 "Core.y"
    function yy_r134(){$this->_retvalue = new PHP_Parser_CoreyyToken('()');    }
#line 6139 "Core.php"
#line 767 "Core.y"
    function yy_r135(){$this->_retvalue = new PHP_Parser_CoreyyToken('(' . $this->yystack[$this->yyidx + -1]->minor->string . ')', $this->yystack[$this->yyidx + -1]->minor);    }
#line 6142 "Core.php"
#line 784 "Core.y"
    function yy_r141(){$this->_retvalue = '-' . $this->yystack[$this->yyidx + 0]->minor;    }
#line 6145 "Core.php"
#line 785 "Core.y"
    function yy_r142(){
    $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . $this->yystack[$this->yyidx + -2]->minor . $this->yystack[$this->yyidx + -1]->minor . $this->yystack[$this->yyidx + 0]->minor;
    // have to do all because of nested arrays
    $this->lex->stopTrackingWhitespace(); // we only need whitespace for
                                          // array default values
    }
#line 6153 "Core.php"
#line 793 "Core.y"
    function yy_r144(){
    $this->lex->trackWhitespace();
    $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6159 "Core.php"
#line 799 "Core.y"
    function yy_r146(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor . $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6164 "Core.php"
#line 802 "Core.y"
    function yy_r147(){$this->_retvalue = '';    }
#line 6167 "Core.php"
#line 804 "Core.y"
    function yy_r148(){
    $this->_retvalue = $this->yystack[$this->yyidx + -4]->minor . $this->yystack[$this->yyidx + -3]->minor . $this->yystack[$this->yyidx + -2]->minor . $this->yystack[$this->yyidx + -1]->minor . $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6172 "Core.php"
#line 807 "Core.y"
    function yy_r149(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor . $this->yystack[$this->yyidx + -1]->minor . $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6177 "Core.php"
#line 815 "Core.y"
    function yy_r152(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor . '::' . $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6182 "Core.php"
#line 819 "Core.y"
    function yy_r153(){
    $this->_retvalue = new PHP_Parser_CoreyyToken(' => ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6187 "Core.php"
#line 825 "Core.y"
    function yy_r156(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('&' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6192 "Core.php"
#line 830 "Core.y"
    function yy_r158(){$this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;    }
#line 6195 "Core.php"
#line 839 "Core.y"
    function yy_r163(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor . ' = ' . $this->yystack[$this->yyidx + 0]->minor, array('declare' => $this->yystack[$this->yyidx + -2]->minor, 'default' => $this->yystack[$this->yyidx + 0]->minor));
    }
#line 6200 "Core.php"
#line 842 "Core.y"
    function yy_r164(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -4]->minor->string . ', ' . $this->yystack[$this->yyidx + -2]->minor . ' = ' . $this->yystack[$this->yyidx + 0]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + -4]->minor;
    $this->_retvalue[] = array('declare' => $this->yystack[$this->yyidx + -2]->minor, 'default' => $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6207 "Core.php"
#line 853 "Core.y"
    function yy_r169(){
    $this->_retvalue = $this->yystack[$this->yyidx + -4]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -2]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6214 "Core.php"
#line 858 "Core.y"
    function yy_r170(){
    $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6220 "Core.php"
#line 869 "Core.y"
    function yy_r175(){
    $this->_retvalue = $this->yystack[$this->yyidx + -5]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -2]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6227 "Core.php"
#line 876 "Core.y"
    function yy_r177(){
    $this->_retvalue = $this->yystack[$this->yyidx + -6]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -3]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6234 "Core.php"
#line 892 "Core.y"
    function yy_r185(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -1]->minor . $this->yystack[$this->yyidx + 0]->minor, array(
            array(
                'typehint' => $this->yystack[$this->yyidx + -1]->minor,
                'param' => $this->yystack[$this->yyidx + 0]->minor,
                'isreference' => false,
                'default' => null,
            )
        ));
    }
#line 6246 "Core.php"
#line 902 "Core.y"
    function yy_r186(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor . '&' . $this->yystack[$this->yyidx + 0]->minor, array(
            array(
                'typehint' => $this->yystack[$this->yyidx + -2]->minor,
                'param' => $this->yystack[$this->yyidx + 0]->minor,
                'isreference' => true,
                'default' => null,
            )
        ));
    }
#line 6258 "Core.php"
#line 912 "Core.y"
    function yy_r187(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -4]->minor . '&' . $this->yystack[$this->yyidx + -2]->minor . ' = ' . $this->yystack[$this->yyidx + 0]->minor, array(
            array(
                'typehint' => $this->yystack[$this->yyidx + -4]->minor,
                'param' => $this->yystack[$this->yyidx + -2]->minor,
                'isreference' => true,
                'default' => $this->yystack[$this->yyidx + 0]->minor,
            )
        ));
    }
#line 6270 "Core.php"
#line 922 "Core.y"
    function yy_r188(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -3]->minor . $this->yystack[$this->yyidx + -2]->minor . ' = ' . $this->yystack[$this->yyidx + 0]->minor, array(
            array(
                'typehint' => $this->yystack[$this->yyidx + -3]->minor,
                'param' => $this->yystack[$this->yyidx + -2]->minor,
                'isreference' => false,
                'default' => $this->yystack[$this->yyidx + 0]->minor,
            )
        ));
    }
#line 6282 "Core.php"
#line 932 "Core.y"
    function yy_r189(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -3]->minor->string . ', ' . $this->yystack[$this->yyidx + -1]->minor . $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -3]->minor);
    $this->_retvalue[] = 
        array(
            'typehint' => $this->yystack[$this->yyidx + -1]->minor,
            'param' => $this->yystack[$this->yyidx + 0]->minor,
            'isreference' => false,
            'default' => null,
        );
    }
#line 6294 "Core.php"
#line 942 "Core.y"
    function yy_r190(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -4]->minor->string . ', ' . $this->yystack[$this->yyidx + -2]->minor . '&' . $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -4]->minor);
    $this->_retvalue[] = 
        array(
            'typehint' => $this->yystack[$this->yyidx + -2]->minor,
            'param' => $this->yystack[$this->yyidx + 0]->minor,
            'isreference' => true,
            'default' => null,
        );
    }
#line 6306 "Core.php"
#line 952 "Core.y"
    function yy_r191(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -6]->minor->string . ', ' . $this->yystack[$this->yyidx + -4]->minor . $this->yystack[$this->yyidx + -2]->minor . ' = ' . $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -6]->minor);
    $this->_retvalue[] = 
        array(
            'typehint' => $this->yystack[$this->yyidx + -4]->minor,
            'param' => $this->yystack[$this->yyidx + -2]->minor,
            'isreference' => true,
            'default' => $this->yystack[$this->yyidx + 0]->minor,
        );
    }
#line 6318 "Core.php"
#line 962 "Core.y"
    function yy_r192(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -5]->minor->string . ', ' . $this->yystack[$this->yyidx + -3]->minor . $this->yystack[$this->yyidx + -2]->minor . ' = ' . $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -5]->minor);
    $this->_retvalue[] = 
        array(
            'typehint' => $this->yystack[$this->yyidx + -3]->minor,
            'param' => $this->yystack[$this->yyidx + -2]->minor,
            'isreference' => false,
            'default' => $this->yystack[$this->yyidx + 0]->minor,
        );
    }
#line 6330 "Core.php"
#line 980 "Core.y"
    function yy_r197(){$this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + 0]->minor);    }
#line 6333 "Core.php"
#line 982 "Core.y"
    function yy_r199(){
    if ($this->yystack[$this->yyidx + 0]->minor instanceof PHP_Parser_CoreyyToken) {
        $b = $this->yystack[$this->yyidx + 0]->minor->string;
    } else {
        $b = (string) $this->yystack[$this->yyidx + 0]->minor;
    }
    $this->_retvalue = new PHP_Parser_CoreyyToken('&' . $b, $this->yystack[$this->yyidx + 0]->minor);    }
#line 6342 "Core.php"
#line 989 "Core.y"
    function yy_r200(){
    if ($this->yystack[$this->yyidx + 0]->minor instanceof PHP_Parser_CoreyyToken) {
        $b = $this->yystack[$this->yyidx + 0]->minor->string;
    } else {
        $b = (string) $this->yystack[$this->yyidx + 0]->minor;
    }
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ', ' . $b, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6353 "Core.php"
#line 1007 "Core.y"
    function yy_r202(){
    if ($this->yystack[$this->yyidx + 0]->minor instanceof PHP_Parser_CoreyyToken) {
        $b = $this->yystack[$this->yyidx + 0]->minor->string;
    } else {
        $b = (string) $this->yystack[$this->yyidx + 0]->minor;
    }
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -3]->minor->string . ', &' . $b, $this->yystack[$this->yyidx + -3]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6364 "Core.php"
#line 1017 "Core.y"
    function yy_r203(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6370 "Core.php"
#line 1023 "Core.y"
    function yy_r205(){$this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + 0]->minor, array('global' => $this->yystack[$this->yyidx + 0]->minor));    }
#line 6373 "Core.php"
#line 1024 "Core.y"
    function yy_r206(){$this->_retvalue = new PHP_Parser_CoreyyToken('$' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);    }
#line 6376 "Core.php"
#line 1025 "Core.y"
    function yy_r207(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('${' . $this->yystack[$this->yyidx + -1]->minor->string . '}', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6381 "Core.php"
#line 1030 "Core.y"
    function yy_r208(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('');
    $this->_retvalue[] = $this->yystack[$this->yyidx + -2]->minor;
    $this->_retvalue[] = array('static' => $this->yystack[$this->yyidx + 0]->minor, 'default' => null);
    }
#line 6388 "Core.php"
#line 1035 "Core.y"
    function yy_r209(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('');
    $this->_retvalue[] = $this->yystack[$this->yyidx + -4]->minor;
    $this->_retvalue[] = array('static' => $this->yystack[$this->yyidx + -2]->minor, 'default' => $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6395 "Core.php"
#line 1040 "Core.y"
    function yy_r210(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('', array('static' => $this->yystack[$this->yyidx + 0]->minor, 'default' => null));
    }
#line 6400 "Core.php"
#line 1043 "Core.y"
    function yy_r211(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('', array('static' => $this->yystack[$this->yyidx + -2]->minor, 'default' => $this->yystack[$this->yyidx + 0]->minor));
    }
#line 6405 "Core.php"
#line 1053 "Core.y"
    function yy_r214(){
    $a = array();
    foreach ($this->yystack[$this->yyidx + -1]->minor as $item) {
        $a[] = array(
            'type' => 'var',
            'name' => $item['name'],
            'line' => $item['line'],
            'default' => $item['default'],
            'modifiers' => $this->yystack[$this->yyidx + -2]->minor,
            'doc' => $item['doc'],
            'parseddoc' => $item['parseddoc'],
            'docline' => $item['docline'],
        );
    }
    $this->_retvalue = new PHP_Parser_CoreyyToken('', $a);
    }
#line 6423 "Core.php"
#line 1069 "Core.y"
    function yy_r215(){
    $a = array();
    foreach ($this->yystack[$this->yyidx + -1]->minor as $item) {
        $a[] = array(
            'type' => 'const',
            'name' => $item['name'],
            'line' => $item['line'],
            'value' => $item['value'],
            'doc' => $item['doc'],
            'parseddoc' => $item['parseddoc'],
            'docline' => $item['docline'],
        );
    }
    $this->_retvalue = new PHP_Parser_CoreyyToken('', $a);
    }
#line 6440 "Core.php"
#line 1084 "Core.y"
    function yy_r216(){
    $this->_retvalue = array($this->lex->line, $lastcom);
    }
#line 6445 "Core.php"
#line 1087 "Core.y"
    function yy_r217(){
    list($doc, $parsed, $line) = $this->yystack[$this->yyidx + -6]->minor[1];
    $this->_retvalue = new PHP_Parser_CoreyyToken('', array(
            array(
                'type' => 'method',
                'name' => $this->yystack[$this->yyidx + -4]->minor,
                'startline' => $this->yystack[$this->yyidx + -6]->minor[0],
                'endline' => $this->lex->line,
                'parameters' => $this->yystack[$this->yyidx + -2]->minor->metadata,
                'modifiers' => $this->yystack[$this->yyidx + -7]->minor,
                'info' => $this->yystack[$this->yyidx + 0]->minor->metadata,
                'doc' => $doc,
                'parseddoc' => $parsed,
                'docline' => $line,
            )
        ));
    }
#line 6464 "Core.php"
#line 1107 "Core.y"
    function yy_r219(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
    }
#line 6469 "Core.php"
#line 1112 "Core.y"
    function yy_r221(){$this->_retvalue = array('public');    }
#line 6472 "Core.php"
#line 1117 "Core.y"
    function yy_r224(){$this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);    }
#line 6475 "Core.php"
#line 1123 "Core.y"
    function yy_r226(){$this->_retvalue = strtolower($this->yystack[$this->yyidx + 0]->minor);    }
#line 6478 "Core.php"
#line 1125 "Core.y"
    function yy_r227(){
    $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor, $this->lex->line);
    }
#line 6483 "Core.php"
#line 1129 "Core.y"
    function yy_r228(){
    list($doc, $parsed, $line) = $this->lex->getLastComment();
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;
    $this->_retvalue[] = array(
        'name' => $this->yystack[$this->yyidx + 0]->minor[0],
        'default' => null,
        'line' => $this->yystack[$this->yyidx + 0]->minor[1],
        'doc' => $doc,
        'parseddoc' => $parsed,
        'docline' => $line,
    );
    }
#line 6497 "Core.php"
#line 1141 "Core.y"
    function yy_r229(){
    list($doc, $parsed, $line) = $this->lex->getLastComment();
    $this->_retvalue = $this->yystack[$this->yyidx + -4]->minor;
    $this->_retvalue[] = array(
        'name' => $this->yystack[$this->yyidx + -2]->minor[0],
        'default' => $this->yystack[$this->yyidx + 0]->minor,
        'line' => $this->yystack[$this->yyidx + -2]->minor[1],
        'doc' => $doc,
        'parseddoc' => $parsed,
        'docline' => $line,
    );
    }
#line 6511 "Core.php"
#line 1153 "Core.y"
    function yy_r230(){
    list($doc, $parsed, $line) = $this->lex->getLastComment();
    $this->_retvalue = array(
            array(
                'name' => $this->yystack[$this->yyidx + 0]->minor,
                'default' => null,
                'line' => $this->lex->line,
                'doc' => $doc,
                'parseddoc' => $parsed,
                'docline' => $line,
            )
        );
    }
#line 6526 "Core.php"
#line 1166 "Core.y"
    function yy_r231(){
    list($doc, $parsed, $line) = $this->lex->getLastComment();
    $this->_retvalue = array(
            array(
                'name' => $this->yystack[$this->yyidx + -2]->minor[0],
                'default' => $this->yystack[$this->yyidx + 0]->minor,
                'line' => $this->yystack[$this->yyidx + -2]->minor[1],
                'doc' => $doc,
                'parseddoc' => $parsed,
                'docline' => $line,
            )
        );
    }
#line 6541 "Core.php"
#line 1180 "Core.y"
    function yy_r232(){
    $doc = $this->lex->getLastComment();
    $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor, $this->lex->line, $doc);
    }
#line 6547 "Core.php"
#line 1185 "Core.y"
    function yy_r233(){
    $this->_retvalue = $this->yystack[$this->yyidx + -4]->minor;
    list($doc, $parsed, $line) = $this->yystack[$this->yyidx + -2]->minor[2];
    $this->_retvalue[] = array('name' => $this->yystack[$this->yyidx + -2]->minor[0], 'value' => $this->yystack[$this->yyidx + 0]->minor, 'line' => $this->yystack[$this->yyidx + -2]->minor[1],
       'doc' => $doc,
       'parseddoc' => $parsed,
       'docline' => $line,
    );
    }
#line 6558 "Core.php"
#line 1194 "Core.y"
    function yy_r234(){
    list($doc, $parsed, $line) = $this->yystack[$this->yyidx + -2]->minor[2];
    $this->_retvalue = array(
        array('name' => $this->yystack[$this->yyidx + -2]->minor[0], 'value' => $this->yystack[$this->yyidx + 0]->minor, 'line' => $this->yystack[$this->yyidx + -2]->minor[1],
           'doc' => $doc,
           'parseddoc' => $parsed,
           'docline' => $line,
        )
    );
    }
#line 6570 "Core.php"
#line 1205 "Core.y"
    function yy_r235(){$this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;$this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;    }
#line 6573 "Core.php"
#line 1217 "Core.y"
    function yy_r241(){
    $this->_retvalue = '(' . $this->yystack[$this->yyidx + -1]->minor . ')';
    }
#line 6578 "Core.php"
#line 1227 "Core.y"
    function yy_r245(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -4]->minor->string . '->' . $this->yystack[$this->yyidx + -2]->minor->string .
        $this->yystack[$this->yyidx + -1]->minor->string . $this->yystack[$this->yyidx + 0]->minor->string, array());
    $this->_retvalue[] = $this->yystack[$this->yyidx + -4]->minor;
    if (is_array($this->yystack[$this->yyidx + -2]->minor)) {
        $this->_retvalue[] = $this->yystack[$this->yyidx + -2]->minor;
    } else {
        if ($this->yystack[$this->yyidx + -1]->minor->string) {
            $this->_retvalue[] = array(
                'uses' => 'method',
                'name' => trim($this->yystack[$this->yyidx + -2]->minor),
            );
        } else {
            $this->_retvalue[] = array(
                'uses' => 'var',
                'name' => trim($this->yystack[$this->yyidx + -2]->minor),
            );
        }
    }
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6601 "Core.php"
#line 1253 "Core.y"
    function yy_r249(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('->' . $this->yystack[$this->yyidx + -1]->minor->string . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -1]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6607 "Core.php"
#line 1258 "Core.y"
    function yy_r250(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('(' . $this->yystack[$this->yyidx + -1]->minor . ')', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6612 "Core.php"
#line 1264 "Core.y"
    function yy_r253(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -1]->minor . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6617 "Core.php"
#line 1268 "Core.y"
    function yy_r254(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor . '::' . $this->yystack[$this->yyidx + 0]->minor->string, array(
        array(
            'usedclass' => $this->yystack[$this->yyidx + -2]->minor,
        )
    ));
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6627 "Core.php"
#line 1286 "Core.y"
    function yy_r260(){
    if (in_array($this->yystack[$this->yyidx + -3]->minor->string, array('$_GET', '$_POST', '$GLOBALS', '$_COOKIE', '$_REQUEST',
        '$_ENV', '$_FILES', '$_SERVER', '$HTTP_COOKIE_VARS', '$HTTP_ENV_VARS',
        '$HTTP_POST_FILES', '$HTTP_POST_VARS', '$HTTP_SERVER_VARS'))) {
        $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -3]->minor->string . '[' . $this->yystack[$this->yyidx + -1]->minor->string . ']',
        array(
            array(
            'superglobal' => B,
            'contents' => C
        )));
    } else {
        $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -3]->minor->string . '[' . $this->yystack[$this->yyidx + -1]->minor->string . ']', array());
    }
    $this->_retvalue[] = $this->yystack[$this->yyidx + -3]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -1]->minor;
    }
#line 6645 "Core.php"
#line 1302 "Core.y"
    function yy_r261(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -3]->minor->string . '{' . $this->yystack[$this->yyidx + -1]->minor->string . '}', array());
    $this->_retvalue[] = $this->yystack[$this->yyidx + -3]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + -1]->minor;
    }
#line 6652 "Core.php"
#line 1310 "Core.y"
    function yy_r264(){$this->_retvalue = new PHP_Parser_CoreyyToken('${' . $this->yystack[$this->yyidx + -1]->minor->string . '}', $this->yystack[$this->yyidx + -1]->minor);    }
#line 6655 "Core.php"
#line 1318 "Core.y"
    function yy_r269(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -3]->minor->string . '[' . $this->yystack[$this->yyidx + -1]->minor->string . ']', $this->yystack[$this->yyidx + -3]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + -1]->minor;
    }
#line 6661 "Core.php"
#line 1322 "Core.y"
    function yy_r270(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -3]->minor->string . '{' . $this->yystack[$this->yyidx + -1]->minor->string . '}', $this->yystack[$this->yyidx + -3]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + -1]->minor;
    }
#line 6667 "Core.php"
#line 1329 "Core.y"
    function yy_r273(){$this->_retvalue = new PHP_Parser_CoreyyToken('{' . $this->yystack[$this->yyidx + -1]->minor->string . '}', $this->yystack[$this->yyidx + -1]->minor);    }
#line 6670 "Core.php"
#line 1331 "Core.y"
    function yy_r274(){$this->_retvalue = '$';    }
#line 6673 "Core.php"
#line 1332 "Core.y"
    function yy_r275(){$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor . '$';    }
#line 6676 "Core.php"
#line 1334 "Core.y"
    function yy_r276(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ', ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6682 "Core.php"
#line 1341 "Core.y"
    function yy_r279(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('list(' . $this->yystack[$this->yyidx + -1]->minor->string . ')', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6687 "Core.php"
#line 1346 "Core.y"
    function yy_r281(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -1]->minor->string . $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6692 "Core.php"
#line 1351 "Core.y"
    function yy_r283(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -3]->minor->string . ' => &' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -3]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6698 "Core.php"
#line 1359 "Core.y"
    function yy_r286(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -4]->minor->string . ', ' . $this->yystack[$this->yyidx + -2]->minor->string . ' => ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -4]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + -2]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6705 "Core.php"
#line 1368 "Core.y"
    function yy_r288(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . ' => ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -2]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6711 "Core.php"
#line 1372 "Core.y"
    function yy_r289(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -5]->minor->string . ', ' . $this->yystack[$this->yyidx + -3]->minor->string . ' => &' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -5]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + -3]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6718 "Core.php"
#line 1377 "Core.y"
    function yy_r290(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -3]->minor->string . ', &' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -3]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6724 "Core.php"
#line 1383 "Core.y"
    function yy_r291(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -1]->minor->string . $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -1]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6730 "Core.php"
#line 1402 "Core.y"
    function yy_r297(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -1]->minor->string . '[', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6735 "Core.php"
#line 1405 "Core.y"
    function yy_r298(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -1]->minor->string . ']', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6740 "Core.php"
#line 1408 "Core.y"
    function yy_r299(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -1]->minor->string . '{', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6745 "Core.php"
#line 1411 "Core.y"
    function yy_r300(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -1]->minor->string . '}', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6750 "Core.php"
#line 1414 "Core.y"
    function yy_r301(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -1]->minor->string . '->', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6755 "Core.php"
#line 1420 "Core.y"
    function yy_r304(){
    if (in_array($this->yystack[$this->yyidx + -3]->minor, array('$_GET', '$_POST', '$GLOBALS', '$_COOKIE', '$_REQUEST',
        '$_ENV', '$_FILES', '$_SERVER', '$HTTP_COOKIE_VARS', '$HTTP_ENV_VARS',
        '$HTTP_POST_FILES', '$HTTP_POST_VARS', '$HTTP_SERVER_VARS'))) {
        $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -3]->minor . '[' . $this->yystack[$this->yyidx + -1]->minor . ']',
        array(
            array(
            'superglobal' => $this->yystack[$this->yyidx + -3]->minor,
            'contents' => $this->yystack[$this->yyidx + -1]->minor
        )));
    } else {
        $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -3]->minor . '[' . $this->yystack[$this->yyidx + -1]->minor . ']');
    }
    }
#line 6771 "Core.php"
#line 1434 "Core.y"
    function yy_r305(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor . '->' . $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6776 "Core.php"
#line 1440 "Core.y"
    function yy_r307(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('${' . $this->yystack[$this->yyidx + -4]->minor . '[' . $this->yystack[$this->yyidx + -2]->minor->string . ']}', $this->yystack[$this->yyidx + -2]->minor);
    }
#line 6781 "Core.php"
#line 1443 "Core.y"
    function yy_r308(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('{' . $this->yystack[$this->yyidx + -1]->minor->string, '}', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6786 "Core.php"
#line 1447 "Core.y"
    function yy_r309(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('isset(' . $this->yystack[$this->yyidx + -1]->minor->string . ')', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6791 "Core.php"
#line 1450 "Core.y"
    function yy_r310(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('empty(' . $this->yystack[$this->yyidx + -1]->minor->string . ')', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6796 "Core.php"
#line 1453 "Core.y"
    function yy_r311(){$this->_retvalue=array($this->lex->line, $this->lex->getLastComment());    }
#line 6799 "Core.php"
#line 1454 "Core.y"
    function yy_r312(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('include ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    list($doc, $parsed, $line) = $this->yystack[$this->yyidx + -1]->minor[1];
    $this->_retvalue[] = array(
        'type' => 'include',
        'file' => $this->yystack[$this->yyidx + 0]->minor->string,
        'line' => $this->yystack[$this->yyidx + -1]->minor[0],
        'doc' => $doc,
        'parseddoc' => $parsed,
        'docline' => $line,
    );
    $this->includes[] = array(
        'type' => 'include',
        'file' => $this->yystack[$this->yyidx + 0]->minor->string,
        'line' => $this->yystack[$this->yyidx + -1]->minor[0],
        'doc' => $doc,
        'parseddoc' => $parsed,
        'docline' => $line,
    );
    }
#line 6821 "Core.php"
#line 1474 "Core.y"
    function yy_r313(){$this->_retvalue=$this->lex->line;    }
#line 6824 "Core.php"
#line 1475 "Core.y"
    function yy_r314(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('include_once ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    list($doc, $parsed, $line) = $this->yystack[$this->yyidx + -1]->minor[1];
    $this->_retvalue[] = array(
        'type' => 'include_once',
        'file' => $this->yystack[$this->yyidx + 0]->minor->string,
        'line' => $this->yystack[$this->yyidx + -1]->minor[0],
        'doc' => $doc,
        'parseddoc' => $parsed,
        'docline' => $line,
    );
    $this->includes[] = array(
        'type' => 'include_once',
        'file' => $this->yystack[$this->yyidx + 0]->minor->string,
        'line' => $this->yystack[$this->yyidx + -1]->minor[0],
        'doc' => $doc,
        'parseddoc' => $parsed,
        'docline' => $line,
    );
    }
#line 6846 "Core.php"
#line 1495 "Core.y"
    function yy_r315(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('eval ' . $this->yystack[$this->yyidx + -1]->minor->string, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6851 "Core.php"
#line 1499 "Core.y"
    function yy_r317(){
    list($doc, $parsed, $line) = $this->yystack[$this->yyidx + -1]->minor[1];
    $this->_retvalue = new PHP_Parser_CoreyyToken('require ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    $this->_retvalue[] = array(
        'type' => 'require',
        'file' => $this->yystack[$this->yyidx + 0]->minor->string,
        'line' => $this->yystack[$this->yyidx + -1]->minor[0],
        'doc' => $doc,
        'parseddoc' => $parsed,
        'docline' => $line,
    );
    $this->includes[] = array(
        'type' => 'require',
        'file' => $this->yystack[$this->yyidx + 0]->minor->string,
        'line' => $this->yystack[$this->yyidx + -1]->minor[0],
        'doc' => $doc,
        'parseddoc' => $parsed,
        'docline' => $line,
    );
    }
#line 6873 "Core.php"
#line 1519 "Core.y"
    function yy_r318(){$this->_retvalue=array($this->lex->line,$this->lex->getLastComment());    }
#line 6876 "Core.php"
#line 1520 "Core.y"
    function yy_r319(){
    list($doc, $parsed, $line) = $this->yystack[$this->yyidx + -1]->minor[1];
    $this->_retvalue = new PHP_Parser_CoreyyToken('require_once ' . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + 0]->minor);
    $this->_retvalue[] = array(
        'type' => 'require_once',
        'file' => $this->yystack[$this->yyidx + 0]->minor->string,
        'line' => $this->yystack[$this->yyidx + -1]->minor[0],
        'doc' => $doc,
        'parseddoc' => $parsed,
        'docline' => $line,
    );
    $this->includes[] = array(
        'type' => 'require_once',
        'file' => $this->yystack[$this->yyidx + 0]->minor->string,
        'line' => $this->yystack[$this->yyidx + -1]->minor[0],
        'doc' => $doc,
        'parseddoc' => $parsed,
        'docline' => $line,
    );
    }
#line 6898 "Core.php"
#line 1547 "Core.y"
    function yy_r322(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor . '::' . $this->yystack[$this->yyidx + 0]->minor, array('usedclass' => $this->yystack[$this->yyidx + -2]->minor));
    $this->_retvalue[] = array('usedclassconstant' => $this->yystack[$this->yyidx + -2]->minor . '::' . $this->yystack[$this->yyidx + 0]->minor);
    }
#line 6904 "Core.php"
#line 1554 "Core.y"
    function yy_r324(){$this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -3]->minor . '(' . $this->yystack[$this->yyidx + -1]->minor->string . ')', $this->yystack[$this->yyidx + -1]->minor);    }
#line 6907 "Core.php"
#line 1555 "Core.y"
    function yy_r325(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -5]->minor . '::' . $this->yystack[$this->yyidx + -3]->minor . '(' . $this->yystack[$this->yyidx + -1]->minor->string . ')',
            $this->yystack[$this->yyidx + -1]->minor);
    $this->_retvalue[] = array(
        'uses' => 'class',
        'name' => trim($this->yystack[$this->yyidx + -5]->minor),
    );
    $this->_retvalue[] = array(
        'uses' => 'method',
        'class' => trim($this->yystack[$this->yyidx + -5]->minor),
        'name' => trim($this->yystack[$this->yyidx + -3]->minor),
    );
    }
#line 6922 "Core.php"
#line 1568 "Core.y"
    function yy_r326(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -5]->minor . '::' . $this->yystack[$this->yyidx + -3]->minor->string . '(' . $this->yystack[$this->yyidx + -1]->minor->string . ')', $this->yystack[$this->yyidx + -3]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + -1]->minor;
    $this->_retvalue[] = array(
        'uses' => 'class',
        'name' => trim($this->yystack[$this->yyidx + -5]->minor),
    );
    }
#line 6932 "Core.php"
#line 1576 "Core.y"
    function yy_r327(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -3]->minor->string . '(' . $this->yystack[$this->yyidx + -1]->minor->string . ')', $this->yystack[$this->yyidx + -3]->minor);
    $this->_retvalue[] = $this->yystack[$this->yyidx + -1]->minor;
    }
#line 6938 "Core.php"
#line 1585 "Core.y"
    function yy_r332(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('"' . $this->yystack[$this->yyidx + -1]->minor->string . '"', $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6943 "Core.php"
#line 1588 "Core.y"
    function yy_r333(){
    $this->_retvalue = new PHP_Parser_CoreyyToken("'" . $this->yystack[$this->yyidx + -1]->minor->string . "'", $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6948 "Core.php"
#line 1591 "Core.y"
    function yy_r334(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -2]->minor->string . $this->yystack[$this->yyidx + -1]->minor->string . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -1]->minor);
    }
#line 6953 "Core.php"
#line 1598 "Core.y"
    function yy_r337(){
    $this->_retvalue = new PHP_Parser_CoreyyToken($this->yystack[$this->yyidx + -3]->minor->string . '->' . $this->yystack[$this->yyidx + -1]->minor->string . $this->yystack[$this->yyidx + 0]->minor->string, $this->yystack[$this->yyidx + -3]->minor);
    $this->_retvalue[] = array('usedmember' => array($this->yystack[$this->yyidx + -3]->minor->string, $this->yystack[$this->yyidx + -1]->minor->string));
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6960 "Core.php"
#line 1605 "Core.y"
    function yy_r339(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
    $this->yystack[$this->yyidx + -1]->minor[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 6966 "Core.php"
#line 1611 "Core.y"
    function yy_r341(){
    $this->_retvalue = new PHP_Parser_CoreyyToken('->' . $this->yystack[$this->yyidx + 0]->minor->string, array('usedmember' => $this->yystack[$this->yyidx + 0]->minor->string));
    }
#line 6971 "Core.php"
#line 1620 "Core.y"
    function yy_r344(){$this->_retvalue = ',';    }
#line 6974 "Core.php"
#line 1632 "Core.y"
    function yy_r350(){$this->_retvalue = true;    }
#line 6977 "Core.php"
#line 1633 "Core.y"
    function yy_r351(){$this->_retvalue = false;    }
#line 6980 "Core.php"

    /**
     * placeholder for the left hand side in a reduce operation.
     * 
     * For a parser with a rule like this:
     * <pre>
     * rule(A) ::= B. { A = 1; }
     * </pre>
     * 
     * The parser will translate to something like:
     * 
     * <code>
     * function yy_r0(){$this->_retvalue = 1;}
     * </code>
     */
    private $_retvalue;

    /**
     * Perform a reduce action and the shift that must immediately
     * follow the reduce.
     * 
     * For a rule such as:
     * 
     * <pre>
     * A ::= B blah C. { dosomething(); }
     * </pre>
     * 
     * This function will first call the action, if any, ("dosomething();" in our
     * example), and then it will pop three states from the stack,
     * one for each entry on the right-hand side of the expression
     * (B, blah, and C in our example rule), and then push the result of the action
     * back on to the stack with the resulting state reduced to (as described in the .out
     * file)
     * @param int Number of the rule by which to reduce
     */
    function yy_reduce($yyruleno)
    {
        //int $yygoto;                     /* The next state */
        //int $yyact;                      /* The next action */
        //mixed $yygotominor;        /* The LHS of the rule reduced */
        //PHP_Parser_CoreyyStackEntry $yymsp;            /* The top of the parser's stack */
        //int $yysize;                     /* Amount to pop the stack */
        $yymsp = $this->yystack[$this->yyidx];
        if (self::$yyTraceFILE && $yyruleno >= 0 
              && $yyruleno < count(self::$yyRuleName)) {
            fprintf(self::$yyTraceFILE, "%sReduce (%d) [%s].\n",
                self::$yyTracePrompt, $yyruleno,
                self::$yyRuleName[$yyruleno]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (array_key_exists($yyruleno, self::$yyReduceMap)) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[$yyruleno]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[$yyruleno]['lhs'];
        $yysize = self::$yyRuleInfo[$yyruleno]['rhs'];
        $this->yyidx -= $yysize;
        for($i = $yysize; $i; $i--) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[$this->yyidx]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            /* If we are not debugging and the reduce action popped at least
            ** one element off the stack, then we can push the new element back
            ** onto the stack here, and skip the stack overflow test in yy_shift().
            ** That gives a significant speed improvement. */
            if (!self::$yyTraceFILE && $yysize) {
                $this->yyidx++;
                $x = new PHP_Parser_CoreyyStackEntry;
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[$this->yyidx] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact == self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    /**
     * The following code executes when the parse fails
     * 
     * Code from %parse_fail is inserted here
     */
    function yy_parse_failed()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sFail!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
        /* Here code is inserted which will be executed whenever the
        ** parser fails */
    }

    /**
     * The following code executes when a syntax error first occurs.
     * 
     * %syntax_error code is inserted here
     * @param int The major type of the error token
     * @param mixed The minor type of the error token
     */
    function yy_syntax_error($yymajor, $TOKEN)
    {
#line 4 "Core.y"

/* ?><?php */
    echo "Syntax Error on line " . $this->lex->line . ": token '" . 
        $this->lex->value . "' while parsing rule:";
    foreach ($this->yystack as $entry) {
        echo $this->tokenName($entry->major) . ' ';
    }
    foreach ($this->yy_get_expected_tokens($yymajor) as $token) {
        $expect[] = self::$yyTokenName[$token];
    }
    if (count($expect) > 5) {
        $expect = array_slice($expect, 0, 5);
        $expect[] = '...';
    }
    throw new Exception('Unexpected ' . $this->tokenName($yymajor) . '(' . $TOKEN
        . '), expected one of: ' . implode(',', $expect));
#line 7110 "Core.php"
    }

    /**
     * The following is executed when the parser accepts
     * 
     * %parse_accept code is inserted here
     */
    function yy_accept()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sAccept!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $stack = $this->yy_pop_parser_stack();
        }
        /* Here code is inserted which will be executed whenever the
        ** parser accepts */
#line 120 "Core.y"

#line 7131 "Core.php"
    }

    /**
     * The main parser program.
     * 
     * The first argument is the major token number.  The second is
     * the token value string as scanned from the input.
     *
     * @param int the token number
     * @param mixed the token value
     * @param mixed any extra arguments that should be passed to handlers
     */
    function doParse($yymajor, $yytokenvalue)
    {
//        $yyact;            /* The parser action. */
//        $yyendofinput;     /* True if we are at the end of input */
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */
        
        /* (re)initialize the parser, if necessary */
        if ($this->yyidx === null || $this->yyidx < 0) {
            /* if ($yymajor == 0) return; // not sure why this was here... */
            $this->yyidx = 0;
            $this->yyerrcnt = -1;
            $x = new PHP_Parser_CoreyyStackEntry;
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            array_push($this->yystack, $x);
        }
        $yyendofinput = ($yymajor==0);
        
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sInput %s\n",
                self::$yyTracePrompt, self::$yyTokenName[$yymajor]);
        }
        
        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL &&
                  !$this->yy_is_expected_token($yymajor)) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt--;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact == self::YY_ERROR_ACTION) {
                if (self::$yyTraceFILE) {
                    fprintf(self::$yyTraceFILE, "%sSyntax Error!\n",
                        self::$yyTracePrompt);
                }
                if (self::YYERRORSYMBOL) {
                    /* A syntax error has occurred.
                    ** The response to an error depends upon whether or not the
                    ** grammar defines an error token "ERROR".  
                    **
                    ** This is what we do if the grammar does define ERROR:
                    **
                    **  * Call the %syntax_error function.
                    **
                    **  * Begin popping the stack until we enter a state where
                    **    it is legal to shift the error symbol, then shift
                    **    the error symbol.
                    **
                    **  * Set the error count to three.
                    **
                    **  * Begin accepting and shifting new tokens.  No new error
                    **    processing will occur until three tokens have been
                    **    shifted successfully.
                    **
                    */
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[$this->yyidx]->major;
                    if ($yymx == self::YYERRORSYMBOL || $yyerrorhit ){
                        if (self::$yyTraceFILE) {
                            fprintf(self::$yyTraceFILE, "%sDiscard input token %s\n",
                                self::$yyTracePrompt, self::$yyTokenName[$yymajor]);
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0 &&
                                 $yymx != self::YYERRORSYMBOL &&
        ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE
                              ){
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor==0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx != self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    /* YYERRORSYMBOL is not defined */
                    /* This is what we do if the grammar does not define ERROR:
                    **
                    **  * Report an error message, and throw away the input token.
                    **
                    **  * If the input token is $, then fail the parse.
                    **
                    ** As before, subsequent error messages are suppressed until
                    ** three input tokens have been successfully shifted.
                    */
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }            
        } while ($yymajor != self::YYNOCODE && $this->yyidx >= 0);
    }
}
