/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

public class UncommentedMainCheck
extends Check {
    private String mExcludedClasses = "^$";
    private Pattern mExcludedClassesPattern = Utils.createPattern(this.mExcludedClasses);
    private String mCurrentClass;
    private FullIdent mPackage;
    private int mClassDepth;

    public void setExcludedClasses(String aExcludedClasses) throws ConversionException {
        try {
            this.mExcludedClasses = aExcludedClasses;
            this.mExcludedClassesPattern = Utils.getPattern(this.mExcludedClasses);
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + this.mExcludedClasses, e);
        }
    }

    public int[] getDefaultTokens() {
        return new int[]{9, 14, 16};
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void beginTree(DetailAST aRootAST) {
        this.mPackage = FullIdent.createFullIdent(null);
        this.mCurrentClass = null;
        this.mClassDepth = 0;
    }

    public void leaveToken(DetailAST aAst) {
        if (aAst.getType() == 14) {
            if (this.mClassDepth == 1) {
                this.mCurrentClass = null;
            }
            --this.mClassDepth;
        }
    }

    public void visitToken(DetailAST aAst) {
        switch (aAst.getType()) {
            case 16: {
                this.visitPackageDef(aAst);
                break;
            }
            case 14: {
                this.visitClassDef(aAst);
                break;
            }
            case 9: {
                this.visitMethodDef(aAst);
                break;
            }
            default: {
                throw new IllegalStateException(aAst.toString());
            }
        }
    }

    private void visitPackageDef(DetailAST aPackage) {
        this.mPackage = FullIdent.createFullIdent(aPackage.getLastChild().getPreviousSibling());
    }

    private void visitClassDef(DetailAST aClass) {
        if (this.mClassDepth == 0) {
            DetailAST ident = aClass.findFirstToken(58);
            this.mCurrentClass = this.mPackage.getText() + "." + ident.getText();
            ++this.mClassDepth;
        }
    }

    private void visitMethodDef(DetailAST aMethod) {
        if (this.mClassDepth != 1) {
            return;
        }
        if (this.checkClassName() && this.checkName(aMethod) && this.checkModifiers(aMethod) && this.checkType(aMethod) && this.checkParams(aMethod)) {
            this.log(aMethod.getLineNo(), "uncommented.main");
        }
    }

    private boolean checkClassName() {
        return !this.mExcludedClassesPattern.matcher(this.mCurrentClass).find();
    }

    private boolean checkName(DetailAST aMethod) {
        DetailAST ident = aMethod.findFirstToken(58);
        return "main".equals(ident.getText());
    }

    private boolean checkModifiers(DetailAST aMethod) {
        DetailAST modifiers = aMethod.findFirstToken(5);
        return modifiers.branchContains(62) && modifiers.branchContains(64);
    }

    private boolean checkType(DetailAST aMethod) {
        DetailAST type = (DetailAST)aMethod.findFirstToken(13).getFirstChild();
        return type.getType() == 49;
    }

    private boolean checkParams(DetailAST aMethod) {
        DetailAST params = aMethod.findFirstToken(20);
        if (params.getChildCount() != 1) {
            return false;
        }
        DetailAST paramType = ((DetailAST)params.getFirstChild()).findFirstToken(13);
        DetailAST arrayDecl = paramType.findFirstToken(17);
        if (arrayDecl == null) {
            return false;
        }
        DetailAST arrayType = (DetailAST)arrayDecl.getFirstChild();
        if (arrayType.getType() == 58 || arrayType.getType() == 59) {
            FullIdent type = FullIdent.createFullIdent(arrayType);
            return "String".equals(type.getText()) || "java.lang.String".equals(type.getText());
        }
        return false;
    }
}

