/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.io;

import java.io.IOException;
import java.io.OutputStream;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSObject;
import org.pdfbox.io.RandomAccess;

public class RandomAccessFileOutputStream
extends OutputStream {
    private RandomAccess file;
    private long position;
    private long lengthWritten = 0L;
    private COSBase expectedLength = null;

    public RandomAccessFileOutputStream(RandomAccess raf) throws IOException {
        this.file = raf;
        this.position = raf.length();
    }

    public long getPosition() {
        return this.position;
    }

    public long getLength() {
        long length = -1L;
        if (this.expectedLength instanceof COSNumber) {
            length = ((COSNumber)this.expectedLength).intValue();
        } else if (this.expectedLength instanceof COSObject && ((COSObject)this.expectedLength).getObject() instanceof COSNumber) {
            length = ((COSNumber)((COSObject)this.expectedLength).getObject()).intValue();
        }
        if (length == -1L) {
            length = this.lengthWritten;
        }
        return length;
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        this.file.seek(this.position + this.lengthWritten);
        this.lengthWritten += (long)length;
        this.file.write(b, offset, length);
    }

    public void write(int b) throws IOException {
        this.file.seek(this.position + this.lengthWritten);
        ++this.lengthWritten;
        this.file.write(b);
    }

    public COSBase getExpectedLength() {
        return this.expectedLength;
    }

    public void setExpectedLength(COSBase value) {
        this.expectedLength = value;
    }
}

