/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.filter.Filter;

public class CCITTFaxDecodeFilter
implements Filter {
    private static final int TAG_COUNT = 15;
    private int offset = 8;
    private int tailingBytesCount = 0;
    private final ByteArrayOutputStream tailer = new ByteArrayOutputStream();

    public void decode(InputStream compressedData, OutputStream result, COSDictionary options) throws IOException {
        int lentoread;
        COSDictionary dict = (COSDictionary)options.getDictionaryObject("DecodeParms");
        int width = options.getInt("Width");
        int height = options.getInt("Height");
        int length = options.getInt(COSName.LENGTH);
        int compressionType = dict.getInt("K");
        boolean blackIs1 = dict.getBoolean("BlackIs1", false);
        this.writeTagHeader(result, length);
        int i = 0;
        byte[] buffer = new byte[32768];
        for (lentoread = length; lentoread > 0 && (i = compressedData.read(buffer, 0, Math.min(lentoread, 32768))) != -1; lentoread -= i) {
            result.write(buffer, 0, i);
        }
        while (lentoread > 0) {
            result.write(buffer, 0, Math.min(lentoread, 32768));
            lentoread -= Math.min(lentoread, 32738);
        }
        this.writeTagCount(result);
        this.writeTagWidth(result, width);
        this.writeTagHeight(result, height);
        this.writeTagBitsPerSample(result, 1);
        this.writeTagCompression(result, compressionType);
        this.writeTagPhotometric(result, blackIs1);
        this.writeTagStripOffset(result, 8);
        this.writeTagOrientation(result, 1);
        this.writeTagSamplesPerPixel(result, 1);
        this.writeTagRowsPerStrip(result, height);
        this.writeTagStripByteCount(result, length);
        this.writeTagXRes(result, 200, 1);
        this.writeTagYRes(result, 200, 1);
        this.writeTagResolutionUnit(result, 2);
        this.writeTagSoftware(result, "pdfbox".getBytes());
        this.writeTagDateTime(result, new Date());
        this.writeTagTailer(result);
    }

    private void writeTagHeader(OutputStream result, int length) throws IOException {
        byte[] header = new byte[]{77, 77, 0, 42};
        result.write(header);
        this.offset += length;
        int i1 = this.offset / 0x1000000;
        int i2 = (this.offset - i1 * 0x1000000) / 65536;
        int i3 = (this.offset - i1 * 0x1000000 - i2 * 65536) / 256;
        int i4 = this.offset % 256;
        result.write(i1);
        result.write(i2);
        result.write(i3);
        result.write(i4);
    }

    private void writeTagCount(OutputStream result) throws IOException {
        result.write(0);
        result.write(15);
    }

    private void writeTagWidth(OutputStream result, int width) throws IOException {
        result.write(1);
        result.write(0);
        result.write(0);
        result.write(3);
        result.write(0);
        result.write(0);
        result.write(0);
        result.write(1);
        result.write(width / 256);
        result.write(width % 256);
        result.write(0);
        result.write(0);
    }

    private void writeTagHeight(OutputStream result, int height) throws IOException {
        result.write(1);
        result.write(1);
        result.write(0);
        result.write(3);
        result.write(0);
        result.write(0);
        result.write(0);
        result.write(1);
        result.write(height / 256);
        result.write(height % 256);
        result.write(0);
        result.write(0);
    }

    private void writeTagBitsPerSample(OutputStream result, int value) throws IOException {
        result.write(1);
        result.write(2);
        result.write(0);
        result.write(3);
        result.write(0);
        result.write(0);
        result.write(0);
        result.write(1);
        result.write(value / 256);
        result.write(value % 256);
        result.write(0);
        result.write(0);
    }

    public void writeTagCompression(OutputStream result, int type) throws IOException {
        result.write(1);
        result.write(3);
        result.write(0);
        result.write(3);
        result.write(0);
        result.write(0);
        result.write(0);
        result.write(1);
        result.write(0);
        if (type < 0) {
            result.write(4);
        } else if (type == 0) {
            result.write(3);
        } else {
            result.write(2);
        }
        result.write(0);
        result.write(0);
    }

    private void writeTagPhotometric(OutputStream result, boolean blackIs1) throws IOException {
        result.write(1);
        result.write(6);
        result.write(0);
        result.write(3);
        result.write(0);
        result.write(0);
        result.write(0);
        result.write(1);
        result.write(0);
        if (blackIs1) {
            result.write(1);
        } else {
            result.write(0);
        }
        result.write(0);
        result.write(0);
    }

    private void writeTagStripOffset(OutputStream result, int value) throws IOException {
        result.write(1);
        result.write(17);
        result.write(0);
        result.write(4);
        result.write(0);
        result.write(0);
        result.write(0);
        result.write(1);
        int i1 = value / 0x1000000;
        int i2 = (value - i1 * 0x1000000) / 65536;
        int i3 = (value - i1 * 0x1000000 - i2 * 65536) / 256;
        int i4 = value % 256;
        result.write(i1);
        result.write(i2);
        result.write(i3);
        result.write(i4);
    }

    private void writeTagSamplesPerPixel(OutputStream result, int value) throws IOException {
        result.write(1);
        result.write(21);
        result.write(0);
        result.write(3);
        result.write(0);
        result.write(0);
        result.write(0);
        result.write(1);
        result.write(value / 256);
        result.write(value % 256);
        result.write(0);
        result.write(0);
    }

    private void writeTagRowsPerStrip(OutputStream result, int value) throws IOException {
        result.write(1);
        result.write(22);
        result.write(0);
        result.write(3);
        result.write(0);
        result.write(0);
        result.write(0);
        result.write(1);
        result.write(value / 256);
        result.write(value % 256);
        result.write(0);
        result.write(0);
    }

    private void writeTagStripByteCount(OutputStream result, int value) throws IOException {
        result.write(1);
        result.write(23);
        result.write(0);
        result.write(4);
        result.write(0);
        result.write(0);
        result.write(0);
        result.write(1);
        int i1 = value / 0x1000000;
        int i2 = (value - i1 * 0x1000000) / 65536;
        int i3 = (value - i1 * 0x1000000 - i2 * 65536) / 256;
        int i4 = value % 256;
        result.write(i1);
        result.write(i2);
        result.write(i3);
        result.write(i4);
    }

    private void writeTagXRes(OutputStream result, int value1, int value2) throws IOException {
        result.write(1);
        result.write(26);
        result.write(0);
        result.write(5);
        result.write(0);
        result.write(0);
        result.write(0);
        result.write(1);
        int valueOffset = this.offset + 6 + 180 + this.tailer.size();
        int i1 = valueOffset / 0x1000000;
        int i2 = (valueOffset - i1 * 0x1000000) / 65536;
        int i3 = (valueOffset - i1 * 0x1000000 - i2 * 65536) / 256;
        int i4 = valueOffset % 256;
        result.write(i1);
        result.write(i2);
        result.write(i3);
        result.write(i4);
        i1 = value1 / 0x1000000;
        i2 = (value1 - i1 * 0x1000000) / 65536;
        i3 = (value1 - i1 * 0x1000000 - i2 * 65536) / 256;
        i4 = value1 % 256;
        this.tailer.write(i1);
        this.tailer.write(i2);
        this.tailer.write(i3);
        this.tailer.write(i4);
        i1 = value2 / 0x1000000;
        i2 = (value2 - i1 * 0x1000000) / 65536;
        i3 = (value2 - i1 * 0x1000000 - i2 * 65536) / 256;
        i4 = value2 % 256;
        this.tailer.write(i1);
        this.tailer.write(i2);
        this.tailer.write(i3);
        this.tailer.write(i4);
        this.tailingBytesCount += 8;
    }

    private void writeTagYRes(OutputStream result, int value1, int value2) throws IOException {
        result.write(1);
        result.write(27);
        result.write(0);
        result.write(5);
        result.write(0);
        result.write(0);
        result.write(0);
        result.write(1);
        int valueOffset = this.offset + 6 + 180 + this.tailer.size();
        int i1 = valueOffset / 0x1000000;
        int i2 = (valueOffset - i1 * 0x1000000) / 65536;
        int i3 = (valueOffset - i1 * 0x1000000 - i2 * 65536) / 256;
        int i4 = valueOffset % 256;
        result.write(i1);
        result.write(i2);
        result.write(i3);
        result.write(i4);
        i1 = value1 / 0x1000000;
        i2 = (value1 - i1 * 0x1000000) / 65536;
        i3 = (value1 - i1 * 0x1000000 - i2 * 65536) / 256;
        i4 = value1 % 256;
        this.tailer.write(i1);
        this.tailer.write(i2);
        this.tailer.write(i3);
        this.tailer.write(i4);
        i1 = value2 / 0x1000000;
        i2 = (value2 - i1 * 0x1000000) / 65536;
        i3 = (value2 - i1 * 0x1000000 - i2 * 65536) / 256;
        i4 = value2 % 256;
        this.tailer.write(i1);
        this.tailer.write(i2);
        this.tailer.write(i3);
        this.tailer.write(i4);
        this.tailingBytesCount += 8;
    }

    private void writeTagResolutionUnit(OutputStream result, int value) throws IOException {
        result.write(1);
        result.write(40);
        result.write(0);
        result.write(3);
        result.write(0);
        result.write(0);
        result.write(0);
        result.write(1);
        result.write(value / 256);
        result.write(value % 256);
        result.write(0);
        result.write(0);
    }

    private void writeTagOrientation(OutputStream result, int value) throws IOException {
        result.write(1);
        result.write(18);
        result.write(0);
        result.write(3);
        result.write(0);
        result.write(0);
        result.write(0);
        result.write(1);
        result.write(value / 256);
        result.write(value % 256);
        result.write(0);
        result.write(0);
    }

    private void writeTagTailer(OutputStream result) throws IOException {
        result.write(0);
        result.write(0);
        result.write(0);
        result.write(0);
        result.write(this.tailer.toByteArray());
    }

    private void writeTagSoftware(OutputStream result, byte[] text) throws IOException {
        result.write(1);
        result.write(49);
        result.write(0);
        result.write(2);
        result.write(0);
        result.write(0);
        result.write((text.length + 1) / 256);
        result.write((text.length + 1) % 256);
        int valueOffset = this.offset + 6 + 180 + this.tailer.size();
        int i1 = valueOffset / 0x1000000;
        int i2 = (valueOffset - i1 * 0x1000000) / 65536;
        int i3 = (valueOffset - i1 * 0x1000000 - i2 * 65536) / 256;
        int i4 = valueOffset % 256;
        result.write(i1);
        result.write(i2);
        result.write(i3);
        result.write(i4);
        this.tailer.write(text);
        this.tailer.write(0);
        this.tailingBytesCount += text.length + 1;
    }

    private void writeTagDateTime(OutputStream result, Date date) throws IOException {
        result.write(1);
        result.write(50);
        result.write(0);
        result.write(2);
        result.write(0);
        result.write(0);
        result.write(0);
        result.write(20);
        int valueOffset = this.offset + 6 + 180 + this.tailer.size();
        int i1 = valueOffset / 0x1000000;
        int i2 = (valueOffset - i1 * 0x1000000) / 65536;
        int i3 = (valueOffset - i1 * 0x1000000 - i2 * 65536) / 256;
        int i4 = valueOffset % 256;
        result.write(i1);
        result.write(i2);
        result.write(i3);
        result.write(i4);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
        String datetime = sdf.format(date);
        this.tailer.write(datetime.getBytes());
        this.tailer.write(0);
        this.tailingBytesCount += 20;
    }

    public void encode(InputStream rawData, OutputStream result, COSDictionary options) throws IOException {
        System.err.println("Warning: CCITTFaxDecode.encode is not implemented yet, skipping this stream.");
    }
}

