/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.popup;

import java.awt.Component;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.jmol.popup.MainPopupResourceBundle;
import org.jmol.popup.SimplePopup;
import org.jmol.util.Elements;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmolPopup
extends SimplePopup {
    private int aboutComputedMenuBaseCount;
    private static String strMenuStructure;
    private JMenu mainMenu;
    private static final int MENUITEM_HEIGHT = 20;
    private static final int MAX_ITEMS = 25;
    private static final int TITLE_MAX_WIDTH = 20;
    String group3List;
    int[] group3Counts;
    private String configurationSelected = "";
    private Object[][] frankList = new Object[10][];
    private int nFrankList = 0;
    private String currentFrankId = null;

    public static JmolPopup newJmolPopup(JmolViewer jmolViewer, boolean bl, String string, boolean bl2) {
        JmolPopup jmolPopup;
        strMenuStructure = string;
        GT.setDoTranslate((boolean)true);
        try {
            jmolPopup = new JmolPopup(jmolViewer, bl2);
        }
        catch (Exception exception) {
            Logger.error((String)"JmolPopup not loaded");
            jmolPopup = null;
        }
        if (jmolPopup != null) {
            try {
                jmolPopup.updateComputedMenus();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        GT.setDoTranslate((boolean)bl);
        return jmolPopup;
    }

    private JmolPopup(JmolViewer jmolViewer, boolean bl) {
        super(jmolViewer);
        this.asPopup = bl;
        MainPopupResourceBundle mainPopupResourceBundle = new MainPopupResourceBundle(strMenuStructure, this.menuText);
        String string = "popupMenu";
        if (bl) {
            this.swingPopup = new JPopupMenu("Jmol");
            this.build(string, this.swingPopup, mainPopupResourceBundle);
        } else {
            this.mainMenu = new JMenu("Jmol");
            this.build(string, this.mainMenu, mainPopupResourceBundle);
        }
    }

    public String getMenu(String string) {
        int n = string.indexOf("|");
        if (n >= 0) {
            String string2 = string.substring(n);
            string = string.substring(0, n);
            if (string2.indexOf("current") >= 0) {
                return this.getMenuCurrent();
            }
        }
        return new MainPopupResourceBundle(strMenuStructure, null).getMenu(string);
    }

    @Override
    protected void checkSpecialMenu(String string, Object object, String string2) {
        if ("aboutComputedMenu".equals(string)) {
            this.aboutComputedMenuBaseCount = this.getMenuItemCount(object);
        } else if ("modelSetMenu".equals(string)) {
            this.nullModelSetName = string2;
            this.enableMenu(object, false);
        }
    }

    public void updateComputedMenus() {
        this.updateMode = 0;
        this.getViewerData();
        this.updateSelectMenu();
        this.updateFileMenu();
        this.updateElementsComputedMenu(this.viewer.getElementsPresentBitSet(this.modelIndex));
        this.updateHeteroComputedMenu(this.viewer.getHeteroList(this.modelIndex));
        this.updateSurfMoComputedMenu((Map)this.modelInfo.get("moData"));
        this.updateFileTypeDependentMenus();
        this.updatePDBComputedMenus();
        this.updateMode = 1;
        this.updateConfigurationComputedMenu();
        this.updateSYMMETRYComputedMenus();
        this.updateFRAMESbyModelComputedMenu();
        this.updateModelSetComputedMenu();
        this.updateLanguageSubmenu();
        this.updateAboutSubmenu();
    }

    private void updateFileMenu() {
        Object v = this.htMenus.get("SIGNEDfileMenu");
        if (v == null) {
            return;
        }
        String string = this.getMenuText("writeFileTextVARIABLE");
        v = this.htMenus.get("writeFileTextVARIABLE");
        if (this.modelSetFileName.equals("zapped") || this.modelSetFileName.equals("")) {
            this.setLabel(v, GT._((String)"No atoms loaded"));
            this.enableMenuItem(v, false);
        } else {
            this.setLabel(v, GT._((String)string, (String)this.modelSetFileName, (boolean)true));
            this.enableMenuItem(v, true);
        }
    }

    @Override
    boolean checkBoolean(Map<String, Object> map, String string) {
        if (map == null || !map.containsKey(string)) {
            return false;
        }
        return (Boolean)map.get(string);
    }

    void updateSelectMenu() {
        Object v = this.htMenus.get("selectMenuText");
        if (v == null) {
            return;
        }
        this.enableMenu(v, this.atomCount != 0);
        this.setLabel(v, GT._((String)this.getMenuText("selectMenuText"), (int)this.viewer.getSelectionCount(), (boolean)true));
    }

    void updateElementsComputedMenu(BitSet bitSet) {
        String string;
        String string2;
        Object v = this.htMenus.get("elementsComputedMenu");
        if (v == null) {
            return;
        }
        this.removeAll(v);
        this.enableMenu(v, false);
        if (bitSet == null) {
            return;
        }
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            String string3 = Elements.elementNameFromNumber((int)n);
            string2 = Elements.elementSymbolFromNumber((int)n);
            string = string2 + " - " + string3;
            this.addMenuItem(v, string, "SELECT " + string3, null);
            n = bitSet.nextSetBit(n + 1);
        }
        for (n = 4; n < Elements.altElementMax; ++n) {
            int n2 = Elements.elementNumberMax + n;
            if (!bitSet.get(n2)) continue;
            n2 = Elements.altElementNumberFromIndex((int)n);
            string2 = Elements.elementNameFromNumber((int)n2);
            string = Elements.elementSymbolFromNumber((int)n2);
            String string4 = string + " - " + string2;
            this.addMenuItem(v, string4, "SELECT " + string2, null);
        }
        this.enableMenu(v, true);
    }

    void updateHeteroComputedMenu(Map<String, String> map) {
        Object v = this.htMenus.get("PDBheteroComputedMenu");
        if (v == null) {
            return;
        }
        this.removeAll(v);
        this.enableMenu(v, false);
        if (map == null) {
            return;
        }
        int n = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (string2.length() > 20) {
                string2 = string2.substring(0, 20) + "...";
            }
            String string3 = string + " - " + string2;
            this.addMenuItem(v, string3, "SELECT [" + string + "]", null);
            ++n;
        }
        this.enableMenu(v, n > 0);
    }

    void updateSurfMoComputedMenu(Map<String, Object> map) {
        Object v = this.htMenus.get("surfMoComputedMenuText");
        if (v == null) {
            return;
        }
        this.removeAll(v);
        List list = map == null ? null : (List)map.get("mos");
        int n = list == null ? 0 : list.size();
        String string = this.getMenuText("surfMoComputedMenuText");
        if (n == 0) {
            this.setLabel(v, GT._((String)string, (String)""));
            this.enableMenu(v, false);
            return;
        }
        this.setLabel(v, GT._((String)string, (int)n));
        this.enableMenu(v, true);
        Object object = v;
        int n2 = n % 25;
        if (n2 == 0) {
            n2 = 25;
        }
        int n3 = n > 25 ? 0 : Integer.MIN_VALUE;
        int n4 = n;
        while (--n4 >= 0) {
            Object object2;
            if (n3 >= 0 && n3++ % n2 == 0) {
                if (n3 == n2 + 1) {
                    n2 = 25;
                }
                object2 = "mo" + n3 + "Menu";
                object = this.newMenu(Math.max(n4 + 2 - n2, 1) + "..." + (n4 + 1), this.getId(v) + "." + (String)object2);
                this.addMenuSubMenu(v, object);
                this.htMenus.put(object2, object);
                n3 = 1;
            }
            object2 = (Map)list.get(n4);
            String string2 = "#" + (n4 + 1) + " " + (object2.containsKey("type") ? (String)object2.get("type") + " " : "") + (object2.containsKey("symmetry") ? (String)object2.get("symmetry") + " " : "") + (object2.containsKey("energy") ? object2.get("energy") : "");
            String string3 = "mo " + (n4 + 1);
            this.addMenuItem(object, string2, string3, null);
        }
    }

    void updatePDBComputedMenus() {
        Object v = this.htMenus.get("PDBaaResiduesComputedMenu");
        if (v == null) {
            return;
        }
        this.removeAll(v);
        this.enableMenu(v, false);
        Object v2 = this.htMenus.get("PDBnucleicResiduesComputedMenu");
        if (v2 == null) {
            return;
        }
        this.removeAll(v2);
        this.enableMenu(v2, false);
        Object v3 = this.htMenus.get("PDBcarboResiduesComputedMenu");
        if (v3 == null) {
            return;
        }
        this.removeAll(v3);
        this.enableMenu(v3, false);
        if (this.modelSetInfo == null) {
            return;
        }
        int n = this.modelIndex < 0 ? 0 : this.modelIndex + 1;
        String[] stringArray = (String[])this.modelSetInfo.get("group3Lists");
        this.group3List = stringArray == null ? null : stringArray[n];
        int[] nArray = this.group3Counts = stringArray == null ? null : ((int[][])this.modelSetInfo.get("group3Counts"))[n];
        if (this.group3List == null) {
            return;
        }
        int n2 = 0;
        for (int i = 1; i < 24; ++i) {
            n2 += this.updateGroup3List(v, JmolConstants.predefinedGroup3Names[i]);
        }
        this.enableMenu(v, (n2 += this.augmentGroup3List(v, "p>", true)) > 0);
        this.enableMenu(this.htMenus.get("PDBproteinMenu"), n2 > 0);
        n2 = this.augmentGroup3List(v2, "n>", false);
        this.enableMenu(v2, n2 > 0);
        this.enableMenu(this.htMenus.get("PDBnucleicMenu"), n2 > 0);
        n2 = this.augmentGroup3List(v3, "c>", false);
        this.enableMenu(v3, n2 > 0);
        this.enableMenu(this.htMenus.get("PDBcarboMenu"), n2 > 0);
    }

    int updateGroup3List(Object object, String string) {
        int n = 0;
        int n2 = this.group3Counts[this.group3List.indexOf(string) / 6];
        String string2 = null;
        if (n2 > 0) {
            string2 = "SELECT " + string;
            string = string + "  (" + n2 + ")";
            ++n;
        } else {
            string2 = null;
        }
        Object object2 = this.addMenuItem(object, string, string2, this.getId(object) + "." + string);
        if (n2 == 0) {
            this.enableMenuItem(object2, false);
        }
        return n;
    }

    int augmentGroup3List(Object object, String string, boolean bl) {
        int n = 138;
        int n2 = 0;
        while ((n = this.group3List.indexOf(string, n)) >= 0) {
            if (n2++ == 0 && bl) {
                this.addMenuSeparator(object);
            }
            int n3 = this.group3Counts[n / 6];
            String string2 = this.group3List.substring(n + 2, n + 5);
            String string3 = string2 + "  (" + n3 + ")";
            this.addMenuItem(object, string3, "SELECT [" + string2 + "]", this.getId(object) + "." + string3);
            ++n;
        }
        return n2;
    }

    void updateSYMMETRYComputedMenus() {
        this.updateSYMMETRYSelectComputedMenu();
        this.updateSYMMETRYShowComputedMenu();
    }

    private void updateSYMMETRYShowComputedMenu() {
        Object v = this.htMenus.get("SYMMETRYShowComputedMenu");
        if (v == null) {
            return;
        }
        this.removeAll(v);
        this.enableMenu(v, false);
        if (!this.isSymmetry || this.modelIndex < 0) {
            return;
        }
        Map map = (Map)this.viewer.getProperty("DATA_API", "spaceGroupInfo", null);
        if (map == null) {
            return;
        }
        Object[][] objectArray = (Object[][])map.get("operations");
        if (objectArray == null) {
            return;
        }
        String string = (String)map.get("spaceGroupName");
        this.setLabel(v, string == null ? GT._((String)"Space Group") : string);
        Object object = v;
        int n = 25;
        int n2 = objectArray.length > 25 ? 0 : Integer.MIN_VALUE;
        for (int i = 0; i < objectArray.length; ++i) {
            String string2;
            if (n2 >= 0 && n2++ % n == 0) {
                string2 = "drawsymop" + n2 + "Menu";
                object = this.newMenu(i + 1 + "..." + Math.min(i + 25, objectArray.length), this.getId(v) + "." + string2);
                this.addMenuSubMenu(v, object);
                this.htMenus.put(string2, object);
                n2 = 1;
            }
            string2 = i + 1 + " " + objectArray[i][2] + " (" + objectArray[i][0] + ")";
            this.enableMenuItem(this.addMenuItem(object, string2, "draw SYMOP " + (i + 1), null), true);
        }
        this.enableMenu(v, true);
    }

    private void updateSYMMETRYSelectComputedMenu() {
        Object v = this.htMenus.get("SYMMETRYSelectComputedMenu");
        if (v == null) {
            return;
        }
        this.removeAll(v);
        this.enableMenu(v, false);
        if (!this.isSymmetry || this.modelIndex < 0) {
            return;
        }
        String[] stringArray = (String[])this.modelInfo.get("symmetryOperations");
        if (stringArray == null) {
            return;
        }
        int[] nArray = (int[])this.modelInfo.get("unitCellRange");
        boolean bl = nArray != null;
        Object object = v;
        int n = 25;
        int n2 = stringArray.length > 25 ? 0 : Integer.MIN_VALUE;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (n2 >= 0 && n2++ % n == 0) {
                string = "symop" + n2 + "Menu";
                object = this.newMenu(i + 1 + "..." + Math.min(i + 25, stringArray.length), this.getId(v) + "." + string);
                this.addMenuSubMenu(v, object);
                this.htMenus.put(string, object);
                n2 = 1;
            }
            string = "symop=" + (i + 1) + " # " + stringArray[i];
            this.enableMenuItem(this.addMenuItem(object, string, "SELECT symop=" + (i + 1), null), bl);
        }
        this.enableMenu(v, true);
    }

    void updateFRAMESbyModelComputedMenu() {
        Object v = this.htMenus.get("FRAMESbyModelComputedMenu");
        if (v == null) {
            return;
        }
        this.enableMenu(v, this.modelCount > 1);
        this.setLabel(v, this.modelIndex < 0 ? GT._((String)this.getMenuText("allModelsText"), (int)this.modelCount, (boolean)true) : this.getModelLabel());
        this.removeAll(v);
        if (this.modelCount < 2) {
            return;
        }
        this.addCheckboxMenuItem(v, GT._((String)"All", (boolean)true), "frame 0 ##", null, this.modelIndex < 0, false);
        Object object = v;
        int n = 25;
        int n2 = this.modelCount > 25 ? 0 : Integer.MIN_VALUE;
        for (int i = 0; i < this.modelCount; ++i) {
            String string;
            if (n2 >= 0 && n2++ % n == 0) {
                string = "model" + n2 + "Menu";
                object = this.newMenu(i + 1 + "..." + Math.min(i + 25, this.modelCount), this.getId(v) + "." + string);
                this.addMenuSubMenu(v, object);
                this.htMenus.put(string, object);
                n2 = 1;
            }
            string = "" + this.viewer.getModelNumberDotted(i);
            String string2 = this.viewer.getModelName(i);
            if (!string2.equals(string)) {
                string2 = string + ": " + string2;
            }
            if (string2.length() > 50) {
                string2 = string2.substring(0, 45) + "...";
            }
            this.addCheckboxMenuItem(object, string2, "model " + string + " ##", null, this.modelIndex == i, false);
        }
    }

    private void updateConfigurationComputedMenu() {
        Object v = this.htMenus.get("configurationComputedMenu");
        if (v == null) {
            return;
        }
        this.enableMenu(v, this.isMultiConfiguration);
        if (!this.isMultiConfiguration) {
            return;
        }
        int n = this.altlocs.length();
        this.setLabel(v, GT._((String)this.getMenuText("configurationMenuText"), (int)n, (boolean)true));
        this.removeAll(v);
        String string = "hide none ##CONFIG";
        this.addCheckboxMenuItem(v, GT._((String)"All", (boolean)true), string, null, this.updateMode == 1 && this.configurationSelected.equals(string), false);
        for (int i = 0; i < n; ++i) {
            string = "configuration " + (i + 1) + "; hide thisModel and not selected ##CONFIG";
            String string2 = "" + (i + 1) + " -- \"" + this.altlocs.charAt(i) + "\"";
            this.addCheckboxMenuItem(v, string2, string, null, this.updateMode == 1 && this.configurationSelected.equals(string), false);
        }
    }

    private void updateModelSetComputedMenu() {
        Object v = this.htMenus.get("modelSetMenu");
        if (v == null) {
            return;
        }
        this.removeAll(v);
        this.renameMenu(v, this.nullModelSetName);
        this.enableMenu(v, false);
        this.enableMenu(this.htMenus.get("surfaceMenu"), !this.isZapped);
        this.enableMenu(this.htMenus.get("measureMenu"), !this.isZapped);
        this.enableMenu(this.htMenus.get("pickingMenu"), !this.isZapped);
        this.enableMenu(this.htMenus.get("computationMenu"), !this.isZapped);
        if (this.modelSetName == null || this.isZapped) {
            return;
        }
        if (this.isMultiFrame) {
            this.modelSetName = GT._((String)this.getMenuText("modelSetCollectionText"), (int)this.modelCount);
            if (this.modelSetName.length() > 20) {
                this.modelSetName = this.modelSetName.substring(0, 20) + "...";
            }
        } else if (this.viewer.getBooleanProperty("hideNameInPopup")) {
            this.modelSetName = this.getMenuText("hiddenModelSetText");
        } else if (this.modelSetName.length() > 20) {
            this.modelSetName = this.modelSetName.substring(0, 20) + "...";
        }
        this.renameMenu(v, this.modelSetName);
        this.enableMenu(v, true);
        this.enableMenu(this.htMenus.get("computationMenu"), this.atomCount <= 100);
        this.addMenuItem(v, GT._((String)this.getMenuText("atomsText"), (int)this.atomCount, (boolean)true));
        this.addMenuItem(v, GT._((String)this.getMenuText("bondsText"), (int)this.viewer.getBondCountInModel(this.modelIndex), (boolean)true));
        if (this.isPDB) {
            List list;
            this.addMenuSeparator(v);
            this.addMenuItem(v, GT._((String)this.getMenuText("groupsText"), (int)this.viewer.getGroupCountInModel(this.modelIndex), (boolean)true));
            this.addMenuItem(v, GT._((String)this.getMenuText("chainsText"), (int)this.viewer.getChainCountInModel(this.modelIndex), (boolean)true));
            this.addMenuItem(v, GT._((String)this.getMenuText("polymersText"), (int)this.viewer.getPolymerCountInModel(this.modelIndex), (boolean)true));
            Object object = this.htMenus.get("BiomoleculesMenu");
            if (object == null) {
                object = this.newMenu(GT._((String)this.getMenuText("biomoleculesMenuText")), this.getId(v) + ".biomolecules");
                this.addMenuSubMenu(v, object);
            }
            this.removeAll(object);
            this.enableMenu(object, false);
            if (this.modelIndex >= 0 && (list = (List)this.viewer.getModelAuxiliaryInfo(this.modelIndex, "biomolecules")) != null) {
                this.enableMenu(object, true);
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    String string = this.isMultiFrame ? "" : "save orientation;load \"\" FILTER \"biomolecule " + (i + 1) + "\";restore orientation;";
                    int n2 = (Integer)((Map)list.get(i)).get("atomCount");
                    String string2 = GT._((String)this.getMenuText(this.isMultiFrame ? "biomoleculeText" : "loadBiomoleculeText"), (Object[])new Object[]{i + 1, n2});
                    this.addMenuItem(object, string2, string, null);
                }
            }
        }
        if (this.isApplet && this.viewer.showModelSetDownload() && !this.viewer.getBooleanProperty("hideNameInPopup")) {
            this.addMenuSeparator(v);
            this.addMenuItem(v, GT._((String)this.getMenuText("viewMenuText"), (String)this.modelSetFileName, (boolean)true), "show url", null);
        }
    }

    private String getModelLabel() {
        return GT._((String)this.getMenuText("modelMenuText"), (String)(this.modelIndex + 1 + "/" + this.modelCount), (boolean)true);
    }

    private void updateAboutSubmenu() {
        Object v = this.htMenus.get("aboutComputedMenu");
        if (v == null) {
            return;
        }
        int n = this.getMenuItemCount(v);
        while (--n >= this.aboutComputedMenuBaseCount) {
            this.removeMenuItem(v, n);
        }
        Object object = this.newMenu("About molecule", "modelSetMenu");
        this.addMenuSubMenu(v, object);
        this.htMenus.put("modelSetMenu", object);
        this.updateModelSetComputedMenu();
        object = this.newMenu("Jmol " + JmolConstants.version + (this.isSigned ? " (signed)" : ""), "aboutJmolMenu");
        this.addMenuSubMenu(v, object);
        this.htMenus.put("aboutJmolMenu", object);
        this.addMenuItem(object, JmolConstants.date);
        this.addMenuItem(object, "http://www.jmol.org", "show url \"http://www.jmol.org\"", null);
        this.addMenuItem(object, GT._((String)"Mouse Manual"), "show url \"http://wiki.jmol.org/index.php/Mouse_Manual\"", null);
        this.addMenuItem(object, GT._((String)"Translations"), "show url \"http://wiki.jmol.org/index.php/Internationalisation\"", null);
        object = this.newMenu(GT._((String)"System", (boolean)true), "systemMenu");
        this.addMenuSubMenu(v, object);
        this.htMenus.put("systemMenu", object);
        this.addMenuItem(object, this.viewer.getOperatingSystemName());
        int n2 = Runtime.getRuntime().availableProcessors();
        if (n2 > 0) {
            this.addMenuItem(object, n2 == 1 ? GT._((String)"1 processor", (boolean)true) : GT._((String)"{0} processors", (int)n2, (boolean)true));
        } else {
            this.addMenuItem(object, GT._((String)"unknown processor count", (boolean)true));
        }
        this.addMenuSeparator(object);
        this.addMenuItem(object, GT._((String)"Java version:", (boolean)true));
        this.addMenuItem(object, this.viewer.getJavaVendor());
        this.addMenuItem(object, this.viewer.getJavaVersion());
        this.addMenuSeparator(object);
        this.addMenuItem(object, GT._((String)"Java memory usage:", (boolean)true));
        Runtime runtime = Runtime.getRuntime();
        long l = this.convertToMegabytes(runtime.totalMemory());
        long l2 = this.convertToMegabytes(runtime.freeMemory());
        long l3 = this.convertToMegabytes(this.maxMemoryForNewerJvm());
        this.addMenuItem(object, GT._((String)"{0} MB total", (Object[])new Object[]{new Long(l)}, (boolean)true));
        this.addMenuItem(object, GT._((String)"{0} MB free", (Object[])new Object[]{new Long(l2)}, (boolean)true));
        if (l3 > 0L) {
            this.addMenuItem(object, GT._((String)"{0} MB maximum", (Object[])new Object[]{new Long(l3)}, (boolean)true));
        } else {
            this.addMenuItem(object, GT._((String)"unknown maximum", (boolean)true));
        }
    }

    private void updateLanguageSubmenu() {
        Object v = this.htMenus.get("languageComputedMenu");
        if (v == null) {
            return;
        }
        int n = this.getMenuItemCount(v);
        while (--n >= 0) {
            this.removeMenuItem(v, n);
        }
        String string = GT.getLanguage();
        String string2 = this.getId(v);
        GT.Language[] languageArray = GT.getLanguageList();
        for (int i = 0; i < languageArray.length; ++i) {
            if (!languageArray[i].display) continue;
            String string3 = languageArray[i].code;
            String string4 = languageArray[i].language;
            this.addCheckboxMenuItem(v, GT._((String)string4, (boolean)true) + " (" + string3 + ")", "language = \"" + string3 + "\" ##" + string4, string2 + "." + string3, string.equals(string3), false);
        }
    }

    private long convertToMegabytes(long l) {
        if (l <= 0x7FFFFFFFFFF7FFFFL) {
            l += 524288L;
        }
        return l / 0x100000L;
    }

    @Override
    protected void setCheckBoxValue(JMenuItem jMenuItem, String string, boolean bl) {
        super.setCheckBoxValue(jMenuItem, string, bl);
        if (string.indexOf("#CONFIG") >= 0) {
            this.configurationSelected = string;
            this.updateConfigurationComputedMenu();
            this.updateModelSetComputedMenu();
            return;
        }
    }

    @Override
    protected void updateForShow() {
        this.updateMode = 2;
        this.updateSelectMenu();
        this.updateFRAMESbyModelComputedMenu();
        this.updateModelSetComputedMenu();
        this.updateAboutSubmenu();
    }

    @Override
    public void show(int n, int n2) {
        super.show(n, n2, false);
        if (n < 0) {
            this.setFrankMenu(this.currentMenuItemId);
            this.thisx = -n - 50;
            if (this.nFrankList > 1) {
                this.thisy = n2 - this.nFrankList * 20;
                this.showFrankMenu(this.thisx, this.thisy);
                return;
            }
        }
        this.restorePopupMenu();
        if (this.asPopup) {
            this.showPopupMenu(this.thisx, this.thisy);
        }
    }

    private void setFrankMenu(String string) {
        int n;
        if (this.currentFrankId != null && this.currentFrankId == string && this.nFrankList > 0) {
            return;
        }
        if (this.frankPopup == null) {
            this.createFrankPopup();
        }
        this.resetFrankMenu();
        if (string == null) {
            return;
        }
        this.currentFrankId = string;
        this.nFrankList = 0;
        this.frankList[this.nFrankList++] = new Object[]{null, null, null};
        this.addMenuItem(this.frankPopup, this.getMenuText("mainMenuText"), "MAIN", "");
        int n2 = string.indexOf(".", 2) + 1;
        while ((n = string.indexOf(".", n2)) >= 0) {
            String string2 = string.substring(n2, n);
            Object v = this.htMenus.get(string2);
            this.frankList[this.nFrankList++] = new Object[]{this.getParent(v), v, this.getPosition(v)};
            this.addMenuSubMenu(this.frankPopup, v);
            n2 = n + 1;
        }
    }

    protected Object getParent(Object object) {
        return ((JMenu)object).getParent();
    }

    protected int getPosition(Object object) {
        Object object2 = this.getParent(object);
        if (object2 instanceof JPopupMenu) {
            int n = ((JPopupMenu)object2).getComponentCount();
            while (--n >= 0) {
                if (((JPopupMenu)object2).getComponent(n) != object) continue;
                return n;
            }
        } else {
            int n = ((JMenu)object2).getItemCount();
            while (--n >= 0) {
                if (((JMenu)object2).getItem(n) != object) continue;
                return n;
            }
        }
        return -1;
    }

    @Override
    void restorePopupMenu() {
        if (this.nFrankList < 2) {
            return;
        }
        int n = this.nFrankList;
        while (--n > 0) {
            this.insertMenuSubMenu(this.frankList[n][0], this.frankList[n][1], (Integer)this.frankList[n][2]);
        }
        this.nFrankList = 1;
    }

    public void installMainMenu(Object object) {
        if (object instanceof JMenuBar) {
            JMenuBar jMenuBar = (JMenuBar)object;
            jMenuBar.remove(0);
            jMenuBar.add((Component)this.mainMenu, 0);
        }
    }

    void insertMenuSubMenu(Object object, Object object2, int n) {
        if (object instanceof JPopupMenu) {
            ((JPopupMenu)object).insert((JMenu)object2, n);
        } else {
            ((JMenu)object).insert((JMenu)object2, n);
        }
    }

    void createFrankPopup() {
        this.frankPopup = new JPopupMenu("Frank");
    }

    void showFrankMenu(int n, int n2) {
        if (this.display == null) {
            return;
        }
        try {
            this.frankPopup.show(this.display, n, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void resetFrankMenu() {
        this.frankPopup.removeAll();
    }

    long maxMemoryForNewerJvm() {
        return Runtime.getRuntime().maxMemory();
    }

    private String getMenuCurrent() {
        StringBuffer stringBuffer = new StringBuffer();
        Object v = this.htMenus.get("popupMenu");
        this.getMenuCurrent(stringBuffer, 0, v, "PopupMenu");
        return stringBuffer.toString();
    }

    private void getMenuCurrent(StringBuffer stringBuffer, int n, Object object, String string) {
        String string2 = string;
        Component[] componentArray = object instanceof JPopupMenu ? ((JPopupMenu)object).getComponents() : ((JMenu)object).getPopupMenu().getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            String string3;
            JMenuItem jMenuItem;
            Component component = componentArray[i];
            if (component instanceof JMenu) {
                jMenuItem = (JMenu)component;
                string2 = jMenuItem.getName();
                string3 = "enabled:" + jMenuItem.isEnabled();
                JmolPopup.addCurrentItem(stringBuffer, 'M', n, string2, jMenuItem.getText(), null, string3);
                this.getMenuCurrent(stringBuffer, n + 1, ((JMenu)component).getPopupMenu(), string2);
                continue;
            }
            if (component instanceof JMenuItem) {
                jMenuItem = (JMenuItem)component;
                string3 = "enabled:" + jMenuItem.isEnabled();
                if (component instanceof JCheckBoxMenuItem) {
                    string3 = string3 + ";checked:" + ((JCheckBoxMenuItem)component).getState();
                }
                String string4 = this.fixScript(jMenuItem.getName(), jMenuItem.getActionCommand());
                JmolPopup.addCurrentItem(stringBuffer, 'I', n, jMenuItem.getName(), jMenuItem.getText(), string4, string3);
                continue;
            }
            JmolPopup.addCurrentItem(stringBuffer, 'S', n, string2, null, null, null);
        }
    }
}

