/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.api.JmolSelectionListener;
import org.jmol.i18n.GT;
import org.jmol.modelset.ModelSet;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

class SelectionManager {
    private Viewer viewer;
    private JmolSelectionListener[] listeners = new JmolSelectionListener[0];
    private final BitSet bsHidden = new BitSet();
    private final BitSet bsSelection = new BitSet();
    private final BitSet bsFixed = new BitSet();
    BitSet bsSubset;
    private BitSet bsDeleted;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private static final int UNKNOWN = -1;
    private int empty = 1;
    private boolean hideNotSelected;
    private final BitSet bsTemp = new BitSet();

    SelectionManager(Viewer viewer) {
        this.viewer = viewer;
    }

    void deleteModelAtoms(BitSet bitSet) {
        BitSetUtil.deleteBits(this.bsHidden, bitSet);
        BitSetUtil.deleteBits(this.bsSelection, bitSet);
        BitSetUtil.deleteBits(this.bsSubset, bitSet);
        BitSetUtil.deleteBits(this.bsFixed, bitSet);
        BitSetUtil.deleteBits(this.bsDeleted, bitSet);
    }

    void clear() {
        this.clearSelection(true);
        this.hide(null, true);
        this.setSelectionSubset(null);
        this.bsDeleted = null;
        this.setMotionFixedAtoms(null);
    }

    void hide(BitSet bitSet, boolean bl) {
        ModelSet modelSet;
        this.bsHidden.clear();
        if (bitSet != null) {
            this.bsHidden.or(bitSet);
        }
        if ((modelSet = this.viewer.getModelSet()) != null) {
            modelSet.setBsHidden(this.bsHidden);
        }
        if (!bl) {
            this.viewer.reportSelection(GT._("{0} atoms hidden", "" + this.bsHidden.cardinality()));
        }
    }

    void display(BitSet bitSet, BitSet bitSet2, boolean bl) {
        if (bitSet2 == null) {
            this.bsHidden.clear();
        } else {
            this.bsHidden.or(bitSet);
            this.bsHidden.andNot(bitSet2);
        }
        BitSetUtil.andNot(this.bsHidden, this.bsDeleted);
        ModelSet modelSet = this.viewer.getModelSet();
        if (modelSet != null) {
            modelSet.setBsHidden(this.bsHidden);
        }
        if (!bl) {
            this.viewer.reportSelection(GT._("{0} atoms hidden", "" + this.bsHidden.cardinality()));
        }
    }

    BitSet getHiddenSet() {
        return this.bsHidden;
    }

    boolean getHideNotSelected() {
        return this.hideNotSelected;
    }

    void setHideNotSelected(boolean bl) {
        this.hideNotSelected = bl;
        if (bl) {
            this.selectionChanged(false);
        }
    }

    boolean isSelected(int n) {
        return n >= 0 && this.bsSelection.get(n);
    }

    void select(BitSet bitSet, boolean bl) {
        if (bitSet == null) {
            this.selectAll(true);
            if (!this.viewer.getRasmolSetting(1613758468)) {
                this.excludeSelectionSet(this.viewer.getAtomBits(1613758468, null));
            }
            if (!this.viewer.getRasmolSetting(0x60300003)) {
                this.excludeSelectionSet(this.viewer.getAtomBits(0x60300003, null));
            }
            this.selectionChanged(false);
        } else {
            this.setSelectionSet(bitSet);
        }
        boolean bl2 = this.viewer.getMessageStyleChime();
        if (!bl2 && bl) {
            return;
        }
        int n = this.getSelectionCount();
        if (bl2) {
            this.viewer.reportSelection((n == 0 ? "No atoms" : (n == 1 ? "1 atom" : n + " atoms")) + " selected!");
        } else if (!bl) {
            this.viewer.reportSelection(GT._("{0} atoms selected", n));
        }
    }

    void selectAll(boolean bl) {
        int n = this.viewer.getAtomCount();
        this.empty = n == 0 ? 1 : 0;
        int n2 = n;
        while (--n2 >= 0) {
            this.bsSelection.set(n2);
        }
        BitSetUtil.andNot(this.bsSelection, this.bsDeleted);
        this.selectionChanged(bl);
    }

    void clearSelection(boolean bl) {
        this.setHideNotSelected(false);
        this.bsSelection.clear();
        this.empty = 1;
        this.selectionChanged(bl);
    }

    public boolean isAtomSelected(int n) {
        return ((this.bsSubset == null || this.bsSubset.get(n)) && this.bsDeleted == null || !this.bsDeleted.get(n)) && this.bsSelection.get(n);
    }

    public void setSelectedAtom(int n, boolean bl) {
        if (n < 0) {
            this.selectionChanged(true);
            return;
        }
        if (this.bsSubset != null && !this.bsSubset.get(n) || this.bsDeleted != null && this.bsDeleted.get(n)) {
            return;
        }
        this.bsSelection.set(n, bl);
        this.empty = bl ? 0 : -1;
    }

    void setSelectionSet(BitSet bitSet) {
        this.bsSelection.clear();
        if (bitSet != null) {
            this.bsSelection.or(bitSet);
        }
        this.empty = -1;
        this.selectionChanged(false);
    }

    void setSelectionSubset(BitSet bitSet) {
        this.bsSubset = bitSet;
    }

    boolean isInSelectionSubset(int n) {
        return n < 0 || this.bsSubset == null || this.bsSubset.get(n);
    }

    void invertSelection() {
        BitSetUtil.invertInPlace(this.bsSelection, this.viewer.getAtomCount());
        this.empty = this.bsSelection.length() > 0 ? 0 : 1;
        this.selectionChanged(false);
    }

    private void excludeSelectionSet(BitSet bitSet) {
        if (bitSet == null || this.empty == 1) {
            return;
        }
        this.bsSelection.andNot(bitSet);
        this.empty = -1;
    }

    int getSelectionCount() {
        BitSet bitSet;
        if (this.empty == 1) {
            return 0;
        }
        this.empty = 1;
        if (this.bsSubset != null) {
            this.bsTemp.clear();
            this.bsTemp.or(this.bsSubset);
            this.bsTemp.and(this.bsSelection);
            bitSet = this.bsTemp;
        } else {
            bitSet = this.bsSelection;
        }
        int n = bitSet.cardinality();
        if (n > 0) {
            this.empty = 0;
        }
        return n;
    }

    void addListener(JmolSelectionListener jmolSelectionListener) {
        int n = this.listeners.length;
        while (--n >= 0) {
            if (this.listeners[n] != jmolSelectionListener) continue;
            this.listeners[n] = null;
            break;
        }
        int n2 = n = this.listeners.length;
        while (--n2 >= 0) {
            if (this.listeners[n2] != null) continue;
            this.listeners[n2] = jmolSelectionListener;
            return;
        }
        this.listeners = this.listeners.length == 0 ? new JmolSelectionListener[1] : (JmolSelectionListener[])ArrayUtil.doubleLength(this.listeners);
        this.listeners[n] = jmolSelectionListener;
    }

    private void selectionChanged(boolean bl) {
        if (this.hideNotSelected) {
            this.hide(BitSetUtil.copyInvert(this.bsSelection, this.viewer.getAtomCount()), bl);
        }
        if (bl || this.listeners.length == 0) {
            return;
        }
        int n = this.listeners.length;
        while (--n >= 0) {
            if (this.listeners[n] == null) continue;
            this.listeners[n].selectionChanged(this.bsSelection);
        }
    }

    String getState(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        if (stringBuffer != null) {
            stringBuffer.append("  _setSelectionState;\n");
            stringBuffer2.append("function _setSelectionState() {\n");
        }
        StateManager.appendCmd(stringBuffer2, this.viewer.getTrajectoryInfo());
        Hashtable<String, BitSet> hashtable = new Hashtable<String, BitSet>();
        String string = null;
        SelectionManager.addBs(stringBuffer2, "hide ", this.bsHidden);
        SelectionManager.addBs(stringBuffer2, "subset ", this.bsSubset);
        SelectionManager.addBs(stringBuffer2, "delete ", this.bsDeleted);
        SelectionManager.addBs(stringBuffer2, "fix ", this.bsFixed);
        hashtable.put("-", this.bsSelection);
        string = StateManager.getCommands(hashtable, null);
        if (string == null) {
            StateManager.appendCmd(stringBuffer2, "select none");
        } else {
            stringBuffer2.append(string);
        }
        StateManager.appendCmd(stringBuffer2, "set hideNotSelected " + this.hideNotSelected);
        stringBuffer2.append(this.viewer.getShapeProperty(1, "selectionState"));
        if (this.viewer.getSelectionHaloEnabled()) {
            StateManager.appendCmd(stringBuffer2, "SelectionHalos ON");
        }
        if (stringBuffer != null) {
            stringBuffer2.append("}\n\n");
        }
        return stringBuffer2.toString();
    }

    private static void addBs(StringBuffer stringBuffer, String string, BitSet bitSet) {
        if (bitSet == null || bitSet.length() == 0) {
            return;
        }
        StateManager.appendCmd(stringBuffer, string + Escape.escape(bitSet));
    }

    int deleteAtoms(BitSet bitSet) {
        BitSet bitSet2 = BitSetUtil.copy(bitSet);
        if (this.bsDeleted == null) {
            this.bsDeleted = bitSet2;
        } else {
            bitSet2.andNot(this.bsDeleted);
            this.bsDeleted.or(bitSet);
        }
        this.bsHidden.andNot(this.bsDeleted);
        this.bsSelection.andNot(this.bsDeleted);
        return bitSet2.cardinality();
    }

    BitSet getDeletedAtoms() {
        return this.bsDeleted;
    }

    BitSet getSelectionSet(boolean bl) {
        if (bl || this.bsDeleted == null && this.bsSubset == null) {
            return this.bsSelection;
        }
        BitSet bitSet = new BitSet();
        bitSet.or(this.bsSelection);
        this.excludeAtoms(bitSet, false);
        return bitSet;
    }

    BitSet getSelectionSubset() {
        return this.bsSubset;
    }

    void excludeAtoms(BitSet bitSet, boolean bl) {
        if (this.bsDeleted != null) {
            bitSet.andNot(this.bsDeleted);
        }
        if (!bl && this.bsSubset != null) {
            bitSet.and(this.bsSubset);
        }
    }

    void processDeletedModelAtoms(BitSet bitSet) {
        if (this.bsDeleted != null) {
            BitSetUtil.deleteBits(this.bsDeleted, bitSet);
        }
        if (this.bsSubset != null) {
            BitSetUtil.deleteBits(this.bsSubset, bitSet);
        }
        BitSetUtil.deleteBits(this.bsFixed, bitSet);
        BitSetUtil.deleteBits(this.bsHidden, bitSet);
        BitSet bitSet2 = BitSetUtil.copy(this.bsSelection);
        BitSetUtil.deleteBits(bitSet2, bitSet);
        this.setSelectionSet(bitSet2);
    }

    void setMotionFixedAtoms(BitSet bitSet) {
        if (bitSet == null) {
            this.bsFixed.clear();
        } else {
            this.bsFixed.or(bitSet);
        }
    }

    BitSet getMotionFixedAtoms() {
        return this.bsFixed;
    }
}

