/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondIterator;
import org.jmol.shape.Shape;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Point3fi;
import org.jmol.viewer.JmolConstants;

public class Sticks
extends Shape {
    private int myMask;
    private boolean reportAll;
    private BitSet bsOrderSet;
    private BitSet bsSizeSet;
    private BitSet bsColixSet;
    private BitSet selectedBonds;
    private static final int MAX_BOND_CLICK_DISTANCE_SQUARED = 100;
    private final Point3i ptXY = new Point3i();

    public void initShape() {
        super.initShape();
        this.myMask = 1023;
        this.reportAll = false;
    }

    public void setSize(int n, BitSet bitSet) {
        if (n == Integer.MAX_VALUE) {
            this.selectedBonds = BitSetUtil.copy(bitSet);
            return;
        }
        if (n == Integer.MIN_VALUE) {
            if (this.bsOrderSet == null) {
                this.bsOrderSet = new BitSet();
            }
            this.bsOrderSet.or(bitSet);
            return;
        }
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BitSet();
        }
        BondIterator bondIterator = this.selectedBonds != null ? this.modelSet.getBondIterator(this.selectedBonds) : this.modelSet.getBondIterator(this.myMask, bitSet);
        short s = (short)n;
        while (bondIterator.hasNext()) {
            this.bsSizeSet.set(bondIterator.nextIndex());
            bondIterator.next().setMad(s);
        }
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if ("type" == string) {
            this.myMask = (Integer)object;
            return;
        }
        if ("reportAll" == string) {
            this.reportAll = true;
            return;
        }
        if ("reset" == string) {
            this.bsOrderSet = null;
            this.bsSizeSet = null;
            this.bsColixSet = null;
            this.selectedBonds = null;
            return;
        }
        if ("bondOrder" == string) {
            BondIterator bondIterator;
            if (this.bsOrderSet == null) {
                this.bsOrderSet = new BitSet();
            }
            short s = ((Integer)object).shortValue();
            BondIterator bondIterator2 = bondIterator = this.selectedBonds != null ? this.modelSet.getBondIterator(this.selectedBonds) : this.modelSet.getBondIterator(65535, bitSet);
            while (bondIterator.hasNext()) {
                this.bsOrderSet.set(bondIterator.nextIndex());
                bondIterator.next().setOrder(s);
            }
            return;
        }
        if ("color" == string) {
            BondIterator bondIterator;
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            short s = Graphics3D.getColix(object);
            byte by = JmolConstants.pidOf(object);
            if (by == 18 || by == 19) {
                BondIterator bondIterator3;
                boolean bl = by == 19;
                BondIterator bondIterator4 = bondIterator3 = this.selectedBonds != null ? this.modelSet.getBondIterator(this.selectedBonds) : this.modelSet.getBondIterator(this.myMask, bitSet);
                while (bondIterator3.hasNext()) {
                    this.bsColixSet.set(bondIterator3.nextIndex());
                    Bond bond = bondIterator3.next();
                    if (bl) {
                        bond.setColix(this.setColix(s, by, bond));
                        bond.setPaletteID(by);
                        continue;
                    }
                    bond.setColix(Graphics3D.getColix(JmolConstants.getArgbHbondType(bond.getOrder())));
                }
                return;
            }
            if (s == 2 && by != 1) {
                return;
            }
            BondIterator bondIterator5 = bondIterator = this.selectedBonds != null ? this.modelSet.getBondIterator(this.selectedBonds) : this.modelSet.getBondIterator(this.myMask, bitSet);
            while (bondIterator.hasNext()) {
                int n = bondIterator.nextIndex();
                Bond bond = bondIterator.next();
                bond.setColix(s);
                this.bsColixSet.set(n, s != 0 && s != 2);
            }
            return;
        }
        if ("translucency" == string) {
            BondIterator bondIterator;
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            boolean bl = ((String)object).equals("translucent");
            BondIterator bondIterator6 = bondIterator = this.selectedBonds != null ? this.modelSet.getBondIterator(this.selectedBonds) : this.modelSet.getBondIterator(this.myMask, bitSet);
            while (bondIterator.hasNext()) {
                this.bsColixSet.set(bondIterator.nextIndex());
                bondIterator.next().setTranslucent(bl, this.translucentLevel);
            }
            return;
        }
        if ("deleteModelAtoms" == string) {
            return;
        }
        super.setProperty(string, object, bitSet);
    }

    public Object getProperty(String string, int n) {
        if (string.equals("selectionState")) {
            return this.selectedBonds != null ? "select BONDS " + Escape.escape(this.selectedBonds) + "\n" : "";
        }
        if (string.equals("sets")) {
            return new BitSet[]{this.bsOrderSet, this.bsSizeSet, this.bsColixSet};
        }
        return null;
    }

    public void setModelClickability() {
        Bond[] bondArray = this.modelSet.getBonds();
        int n = this.modelSet.getBondCount();
        while (--n >= 0) {
            Bond bond = bondArray[n];
            if ((bond.getShapeVisibilityFlags() & this.myVisibilityFlag) == 0 || this.modelSet.isAtomHidden(bond.getAtomIndex1()) || this.modelSet.isAtomHidden(bond.getAtomIndex2())) continue;
            bond.getAtom1().setClickable(this.myVisibilityFlag);
            bond.getAtom2().setClickable(this.myVisibilityFlag);
        }
    }

    public String getShapeState() {
        int n;
        int n2;
        Hashtable<String, BitSet> hashtable = new Hashtable<String, BitSet>();
        Hashtable<String, BitSet> hashtable2 = new Hashtable<String, BitSet>();
        boolean bl = false;
        Bond[] bondArray = this.modelSet.getBonds();
        int n3 = this.modelSet.getBondCount();
        if (this.reportAll || this.bsSizeSet != null) {
            n = n2 = this.reportAll ? n3 - 1 : this.bsSizeSet.nextSetBit(0);
            while (n >= 0) {
                short s;
                Sticks.setStateInfo(hashtable, n, "wireframe " + ((s = bondArray[n].getMad()) == 1 ? "on" : "" + (float)s / 2000.0f));
                n = this.reportAll ? n - 1 : this.bsSizeSet.nextSetBit(n + 1);
            }
        }
        if (this.reportAll || this.bsOrderSet != null) {
            n = n2 = this.reportAll ? n3 - 1 : this.bsOrderSet.nextSetBit(0);
            while (n >= 0) {
                Bond bond = bondArray[n];
                if (this.reportAll || (bond.getOrder() & 0x20000) == 0) {
                    Sticks.setStateInfo(hashtable, n, "bondOrder " + JmolConstants.getBondOrderNameFromOrder(bond.getOrder()));
                }
                n = this.reportAll ? n - 1 : this.bsOrderSet.nextSetBit(n + 1);
            }
        }
        if (this.bsColixSet != null) {
            n2 = this.bsColixSet.nextSetBit(0);
            while (n2 >= 0) {
                n = bondArray[n2].getColix();
                if ((n & 0xFFFF87FF) == 2) {
                    Sticks.setStateInfo(hashtable, n2, this.getColorCommand("bonds", (byte)1, (short)n));
                } else {
                    Sticks.setStateInfo(hashtable, n2, this.getColorCommand("bonds", (short)n));
                }
                n2 = this.bsColixSet.nextSetBit(n2 + 1);
            }
        }
        return Sticks.getShapeCommands(hashtable, null, "select BONDS") + "\n" + (bl ? Sticks.getShapeCommands(hashtable2, null, "select BONDS") + "\n" : "");
    }

    public boolean checkObjectHovered(int n, int n2, BitSet bitSet) {
        Point3fi point3fi = new Point3fi();
        Bond bond = this.findPickedBond(n, n2, bitSet, point3fi);
        if (bond == null) {
            return false;
        }
        this.viewer.highlightBond(bond.getIndex(), true);
        return true;
    }

    public Point3fi checkObjectClicked(int n, int n2, int n3, BitSet bitSet) {
        Point3fi point3fi = new Point3fi();
        Bond bond = this.findPickedBond(n, n2, bitSet, point3fi);
        if (bond == null) {
            return null;
        }
        point3fi.index = bond.getIndex();
        this.viewer.setStatusAtomPicked(-3, "[\"bond\",\"" + bond.getIdentity() + "\"," + point3fi.x + "," + point3fi.y + "," + point3fi.z + "]");
        return point3fi;
    }

    private Bond findPickedBond(int n, int n2, BitSet bitSet, Point3fi point3fi) {
        int n3 = 100;
        if (this.g3d.isAntialiased()) {
            n <<= 1;
            n2 <<= 1;
            n3 <<= 1;
        }
        Bond bond = null;
        Point3f point3f = new Point3f();
        Bond[] bondArray = this.modelSet.getBonds();
        int n4 = this.modelSet.getBondCount();
        while (--n4 >= 0) {
            float f;
            Bond bond2 = bondArray[n4];
            if (bond2.getShapeVisibilityFlags() == 0) continue;
            Atom atom = bond2.getAtom1();
            Atom atom2 = bond2.getAtom2();
            if (!atom.isVisible(0) || !atom2.isVisible(0)) continue;
            point3f.set(atom);
            point3f.add(atom2);
            point3f.scale(0.5f);
            int n5 = this.coordinateInRange(n, n2, point3f, n3, this.ptXY);
            if (n5 < 0 || (f = 1.0f * (float)(this.ptXY.x - atom.screenX) / (float)(atom2.screenX - atom.screenX)) < 0.4f || f > 0.6f) continue;
            n3 = n5;
            bond = bond2;
            point3fi.set(point3f);
            point3fi.modelIndex = atom.modelIndex;
        }
        return bond;
    }
}

