/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

final class Rgb16 {
    int rScaled;
    int gScaled;
    int bScaled;

    Rgb16() {
    }

    Rgb16(int n) {
        this.set(n);
    }

    void set(int n) {
        this.rScaled = n >> 8 & 0xFF00 | 0x80;
        this.gScaled = n & 0xFF00 | 0x80;
        this.bScaled = n << 8 & 0xFF00 | 0x80;
    }

    void set(Rgb16 rgb16) {
        this.rScaled = rgb16.rScaled;
        this.gScaled = rgb16.gScaled;
        this.bScaled = rgb16.bScaled;
    }

    void diffDiv(Rgb16 rgb16, Rgb16 rgb162, int n) {
        this.rScaled = (rgb16.rScaled - rgb162.rScaled) / n;
        this.gScaled = (rgb16.gScaled - rgb162.gScaled) / n;
        this.bScaled = (rgb16.bScaled - rgb162.bScaled) / n;
    }

    void setAndIncrement(Rgb16 rgb16, Rgb16 rgb162) {
        this.rScaled = rgb16.rScaled;
        rgb16.rScaled += rgb162.rScaled;
        this.gScaled = rgb16.gScaled;
        rgb16.gScaled += rgb162.gScaled;
        this.bScaled = rgb16.bScaled;
        rgb16.bScaled += rgb162.bScaled;
    }

    int getArgb() {
        return 0xFF000000 | this.rScaled << 8 & 0xFF0000 | this.gScaled & 0xFF00 | this.bScaled >> 8;
    }

    public String toString() {
        return new StringBuffer("Rgb16(").append(this.rScaled).append(',').append(this.gScaled).append(',').append(this.bScaled).append(" -> ").append(this.rScaled >> 8 & 0xFF).append(',').append(this.gScaled >> 8 & 0xFF).append(',').append(this.bScaled >> 8 & 0xFF).append(')').toString();
    }
}

