#!/bin/sh

# Build zipfiles for Pango on Win32: separate runtime and developer packages

ZIP=/tmp/pangopdf-1.6.0.3-`date +%Y%m%d`.zip
DEVZIP=/tmp/pangopdf-dev-1.6.0.3-`date +%Y%m%d`.zip
cd /usr/local

rm $ZIP
zip $ZIP -@ <<EOF
bin/pangopdf-querymodules.exe
etc/pangopdf/pango.aliases
etc/pangopdf/pango.modules
lib/pangopdf/libpango-1.0-0.dll
lib/pangopdf/libpangoft2-1.0-0.dll
lib/pangopdf/libpangogp-1.0-0.dll
lib/pangopdf/libpangopdflib-1.0-0.dll
lib/pangopdf/libpangowin32-1.0-0.dll
EOF

zip $ZIP lib/pangopdf/pango/1.2.0/modules/*.dll

rm $DEVZIP
zip -r $DEVZIP -@ <<EOF
include/pango-1.0
lib/pangopdf/libpango-1.0.dll.a
lib/pangopdf/pango-1.0.lib
lib/pangopdf/libpangoft2-1.0.dll.a
lib/pangopdf/pangoft2-1.0.lib
lib/pangopdf/libpangowin32-1.0.dll.a
lib/pangopdf/pangowin32-1.0.lib
lib/pkgconfig/pangopdf-pango.pc
lib/pkgconfig/pangopdf-pangowin32.pc
lib/pkgconfig/pangopdf-pangoft2.pc
lib/pkgconfig/pangopdf-pangogp.pc
lib/pkgconfig/pangopdf-pangopdflib.pc
EOF
