//
//  SignedPlistTest.m
//  autoinstaller
//
//  Created by Greg Miller on 7/18/08.
//  Copyright 2008 Google Inc. All rights reserved.
//

#import <SenTestingKit/SenTestingKit.h>
#import "PlistSigner.h"
#import "Signer.h"


static unsigned char private_key_der[] = {
0x30, 0x82, 0x02, 0x5c, 0x02, 0x01, 0x00, 0x02, 0x81, 0x81, 0x00, 0xf1,
0x66, 0x86, 0xc8, 0xca, 0x65, 0xb5, 0x40, 0x31, 0x1c, 0xd1, 0x10, 0x62,
0x46, 0xcb, 0x60, 0x01, 0xd3, 0x32, 0x80, 0xb8, 0x2f, 0x75, 0x2a, 0x46,
0xbd, 0x42, 0xb1, 0xb6, 0xcf, 0x81, 0xd9, 0xe9, 0xb9, 0xdd, 0x02, 0xbf,
0xf6, 0xfa, 0x6f, 0x9e, 0x06, 0x16, 0x22, 0xb8, 0x95, 0x1a, 0x53, 0xba,
0xdb, 0x6e, 0x55, 0x66, 0x94, 0xfb, 0xe8, 0xab, 0xcd, 0xfa, 0xd2, 0x05,
0xdf, 0xf4, 0xfd, 0x9c, 0x08, 0x3a, 0x23, 0x9c, 0xe3, 0x95, 0xc3, 0x59,
0x17, 0xe9, 0xfb, 0xea, 0xf1, 0x6c, 0x3f, 0x42, 0xc8, 0xfb, 0xfb, 0x0e,
0x6a, 0x6c, 0xec, 0x40, 0x0d, 0x0d, 0x1f, 0x31, 0x5c, 0xa8, 0x94, 0x7b,
0x54, 0x0e, 0x44, 0xf0, 0x27, 0xa3, 0xb1, 0x72, 0xbb, 0x5d, 0x78, 0xd4,
0x76, 0x05, 0x1c, 0x78, 0x9d, 0x12, 0xae, 0x37, 0xff, 0x45, 0x9f, 0x57,
0xf9, 0x98, 0xdc, 0xd0, 0x03, 0xec, 0xa3, 0x02, 0x03, 0x01, 0x00, 0x01,
0x02, 0x81, 0x80, 0x24, 0x5a, 0xfa, 0x85, 0x96, 0xe5, 0xc6, 0x6c, 0x4a,
0x79, 0x3a, 0x8b, 0x2b, 0x21, 0xda, 0x53, 0x35, 0x33, 0x27, 0x71, 0xf7,
0x4b, 0x3e, 0x6c, 0x05, 0x87, 0x4f, 0x5a, 0x10, 0x5c, 0x24, 0x04, 0x3b,
0x8d, 0x00, 0x59, 0xff, 0xab, 0x24, 0x80, 0x56, 0xde, 0x37, 0xcb, 0x36,
0xdd, 0x4d, 0xbf, 0xba, 0x6e, 0x7d, 0xa9, 0x62, 0xef, 0xa1, 0x18, 0xa3,
0x77, 0x3c, 0x05, 0x11, 0x59, 0x6f, 0x3d, 0xcf, 0xb6, 0x1f, 0x54, 0x21,
0x84, 0xbe, 0xb6, 0xbd, 0x03, 0x4c, 0x4e, 0x9d, 0x4c, 0x56, 0x4f, 0x60,
0x81, 0xf7, 0xeb, 0x28, 0x08, 0xd3, 0xfd, 0xbe, 0x1b, 0x0b, 0xea, 0x4e,
0x8c, 0xdd, 0x01, 0x6b, 0xbd, 0x1e, 0xae, 0xa6, 0xb1, 0x63, 0x6b, 0x9d,
0xcf, 0xbc, 0x29, 0x59, 0xc1, 0x3e, 0xa1, 0x36, 0xe7, 0x17, 0x8f, 0x00,
0x3c, 0xd6, 0x8c, 0x8f, 0x3b, 0xe1, 0x08, 0x57, 0xb4, 0xbc, 0x61, 0x02,
0x41, 0x00, 0xfb, 0x1e, 0x15, 0x06, 0x51, 0xcc, 0x9b, 0x11, 0xc1, 0xcb,
0x3a, 0xf5, 0x8a, 0x8c, 0xab, 0x86, 0xe2, 0x0e, 0x16, 0xa7, 0x7e, 0x84,
0x2b, 0xc0, 0xf2, 0xd9, 0x49, 0x2d, 0x33, 0xde, 0x09, 0xbf, 0x01, 0xee,
0xe3, 0x8a, 0x74, 0x19, 0xb3, 0x63, 0x79, 0x28, 0x6a, 0x55, 0xc3, 0x26,
0x8e, 0xa7, 0xb8, 0xda, 0x40, 0x4e, 0xc9, 0x09, 0xe0, 0x38, 0xaa, 0x95,
0xa1, 0x55, 0x37, 0x63, 0x41, 0x4b, 0x02, 0x41, 0x00, 0xf6, 0x18, 0x14,
0x25, 0x1a, 0xb8, 0x5a, 0xba, 0x00, 0x72, 0xac, 0x61, 0xaf, 0x87, 0x77,
0x88, 0x6c, 0xba, 0xe2, 0x7e, 0xfb, 0x6f, 0x76, 0x2b, 0x81, 0xad, 0xb8,
0xb4, 0x8f, 0x13, 0x5b, 0x14, 0x1e, 0x7f, 0x4c, 0xf8, 0xb2, 0xba, 0xa0,
0x21, 0xf4, 0x17, 0x97, 0xdc, 0x9f, 0xd8, 0x81, 0x3b, 0xe8, 0x29, 0xc7,
0xc9, 0xba, 0xb3, 0x07, 0x43, 0xc5, 0x80, 0x2d, 0xfd, 0xf4, 0x50, 0x43,
0x09, 0x02, 0x41, 0x00, 0xa2, 0xb4, 0x80, 0x0c, 0xe3, 0x2d, 0x3e, 0x00,
0x48, 0x5f, 0x84, 0xa9, 0x19, 0x87, 0x41, 0x90, 0x18, 0xa1, 0xe6, 0x3d,
0xca, 0x34, 0x9b, 0x20, 0xde, 0x78, 0xb8, 0xf8, 0x27, 0xd6, 0x22, 0xdc,
0x76, 0xc5, 0x30, 0xfb, 0x41, 0x74, 0x71, 0x8d, 0xef, 0x2f, 0xa7, 0x8e,
0x3f, 0xee, 0x98, 0x99, 0xc5, 0xa4, 0xeb, 0xeb, 0xe0, 0x48, 0x9c, 0xd6,
0x3a, 0x78, 0xce, 0xda, 0xa7, 0x13, 0x91, 0x77, 0x02, 0x40, 0x60, 0xdd,
0x71, 0x70, 0x79, 0x67, 0xff, 0x2e, 0x1f, 0x67, 0x03, 0xbb, 0x1f, 0xa0,
0x2e, 0xc8, 0xa0, 0x23, 0x9f, 0x6b, 0x64, 0x04, 0xa7, 0x7a, 0xd0, 0x7c,
0x54, 0xab, 0x9d, 0x75, 0x7c, 0xf0, 0x1a, 0x60, 0xf9, 0x27, 0x1b, 0x12,
0xa2, 0x5d, 0x3a, 0xfa, 0xde, 0x67, 0x94, 0xf3, 0x5f, 0x4a, 0xf9, 0x43,
0x18, 0xc4, 0xaa, 0x9c, 0x35, 0x4b, 0xd3, 0xbd, 0x74, 0x5c, 0xf5, 0x81,
0x72, 0x21, 0x02, 0x40, 0x28, 0x37, 0x6e, 0x33, 0xfe, 0x31, 0x15, 0x7e,
0x39, 0xa0, 0x55, 0x02, 0x33, 0x84, 0x0f, 0x25, 0xa0, 0xad, 0x27, 0xd3,
0x47, 0x04, 0xf1, 0x62, 0x6b, 0x30, 0x7b, 0x45, 0xe7, 0x8c, 0x8c, 0xbb,
0xb6, 0x80, 0xfb, 0xfb, 0x4d, 0x6e, 0x9e, 0x4f, 0x5c, 0x39, 0xfd, 0x6c,
0xee, 0xfd, 0x63, 0xa0, 0x12, 0x76, 0x81, 0x4e, 0x9e, 0x94, 0x69, 0xb4,
0x42, 0xac, 0x01, 0xdf, 0xac, 0xff, 0x39, 0x02
};
static unsigned int private_key_der_len = 608;


static unsigned char public_key_der[] = {
0x30, 0x81, 0x9f, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7,
0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x81, 0x8d, 0x00, 0x30, 0x81,
0x89, 0x02, 0x81, 0x81, 0x00, 0xf1, 0x66, 0x86, 0xc8, 0xca, 0x65, 0xb5,
0x40, 0x31, 0x1c, 0xd1, 0x10, 0x62, 0x46, 0xcb, 0x60, 0x01, 0xd3, 0x32,
0x80, 0xb8, 0x2f, 0x75, 0x2a, 0x46, 0xbd, 0x42, 0xb1, 0xb6, 0xcf, 0x81,
0xd9, 0xe9, 0xb9, 0xdd, 0x02, 0xbf, 0xf6, 0xfa, 0x6f, 0x9e, 0x06, 0x16,
0x22, 0xb8, 0x95, 0x1a, 0x53, 0xba, 0xdb, 0x6e, 0x55, 0x66, 0x94, 0xfb,
0xe8, 0xab, 0xcd, 0xfa, 0xd2, 0x05, 0xdf, 0xf4, 0xfd, 0x9c, 0x08, 0x3a,
0x23, 0x9c, 0xe3, 0x95, 0xc3, 0x59, 0x17, 0xe9, 0xfb, 0xea, 0xf1, 0x6c,
0x3f, 0x42, 0xc8, 0xfb, 0xfb, 0x0e, 0x6a, 0x6c, 0xec, 0x40, 0x0d, 0x0d,
0x1f, 0x31, 0x5c, 0xa8, 0x94, 0x7b, 0x54, 0x0e, 0x44, 0xf0, 0x27, 0xa3,
0xb1, 0x72, 0xbb, 0x5d, 0x78, 0xd4, 0x76, 0x05, 0x1c, 0x78, 0x9d, 0x12,
0xae, 0x37, 0xff, 0x45, 0x9f, 0x57, 0xf9, 0x98, 0xdc, 0xd0, 0x03, 0xec,
0xa3, 0x02, 0x03, 0x01, 0x00, 0x01
};
static unsigned int public_key_der_len = 162;


static NSString *const kSignedPlist = 
@"<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
@"<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">"
@"<plist version=\"1.0\">"
@"<dict>"
@"	<key>Rules</key>"
@"	<array>"
@"		<dict>"
@"			<key>Codebase</key>"
@"			<string>http://macfuse.googlecode.com/svn/releases/MacFUSE-1.7.dmg</string>"
@"			<key>Hash</key>"
@"			<string>9I5CFGd/dHClCLycl2UJlvW3LKg=</string>"
@"			<key>Predicate</key>"
@"			<string>1 == 1</string>"
@"			<key>ProductID</key>"
@"			<string>com.google.filesystems.fusefs</string>"
@"			<key>Size</key>"
@"			<string>1732368</string>"
@"			<key>Version</key>"
@"			<string>1.7.1</string>"
@"		</dict>"
@"	</array>"
@"	<key>Signature</key>"
@"	<data>"
@"	juw5jH4IfedUlYYZI+I8D2p5V95pzwFElFVC5U3q34HpLG0gSNDvEFaPMdkhenv4Chgd"
@"	dGBufYefSMA9qQrSkUWVXTeENAzJJ765Wt82D+ttJ6l3vAvh9GzdUe3rchJGTFnB71lZ"
@"	ChS8nOXZRvmsS4PT+5Bx2mRq/FJQPzgadD8="
@"	</data>"
@"</dict>"
@"</plist>"
;

static NSString *const kSignedTigerPlist = 
@"<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
@"<!DOCTYPE plist PUBLIC \"-//Apple Computer//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">"
@"<plist version=\"1.0\">"
@"<dict>"
@"	<key>Rules</key>"
@"	<array>"
@"		<dict>"
@"			<key>Codebase</key>"
@"			<string>http://macfuse.googlecode.com/svn/releases/MacFUSE-1.7.dmg</string>"
@"			<key>Hash</key>"
@"			<string>9I5CFGd/dHClCLycl2UJlvW3LKg=</string>"
@"			<key>Predicate</key>"
@"			<string>1 == 1</string>"
@"			<key>ProductID</key>"
@"			<string>com.google.filesystems.fusefs</string>"
@"			<key>Size</key>"
@"			<string>1732368</string>"
@"			<key>Version</key>"
@"			<string>1.7.1</string>"
@"		</dict>"
@"	</array>"
@"	<key>Signature</key>"
@"	<data>"
@"	juw5jH4IfedUlYYZI+I8D2p5V95pzwFElFVC5U3q34HpLG0gSNDvEFaPMdkhenv4Chgd"
@"	dGBufYefSMA9qQrSkUWVXTeENAzJJ765Wt82D+ttJ6l3vAvh9GzdUe3rchJGTFnB71lZ"
@"	ChS8nOXZRvmsS4PT+5Bx2mRq/FJQPzgadD8="
@"	</data>"
@"</dict>"
@"</plist>"
;


@interface PlistSignerTest : SenTestCase {
 @private
  Signer *signer_;
}
@end

@implementation PlistSignerTest

- (void)setUp {
  NSData *publicKey = [NSData dataWithBytes:public_key_der
                                     length:public_key_der_len];
  NSData *privateKey = [NSData dataWithBytes:private_key_der
                                      length:private_key_der_len];  
  signer_ = [[Signer alloc] initWithPublicKey:publicKey privateKey:privateKey];
}

- (void)tearDown {
  [signer_ release];
}

- (void)testCreation {
  PlistSigner *plistSigner = [[[PlistSigner alloc] init] autorelease];
  STAssertNil(plistSigner, nil);
  
  plistSigner = [[[PlistSigner alloc] initWithSigner:nil plist:nil] autorelease];
  STAssertNil(plistSigner, nil);
  
  plistSigner = [[[PlistSigner alloc] initWithSigner:signer_
                                               plist:nil] autorelease];
  STAssertNil(plistSigner, nil);
  
  plistSigner = [[[PlistSigner alloc] initWithSigner:nil
                                               plist:[NSDictionary dictionary]] autorelease];
  STAssertNil(plistSigner, nil);
  
  plistSigner = [[[PlistSigner alloc] initWithSigner:signer_
                                               plist:[NSDictionary dictionary]] autorelease];
  STAssertNotNil(plistSigner, nil);
}

- (void)ensureUnsignedPlist:(NSDictionary *)plist {
  PlistSigner *plistSigner = [[[PlistSigner alloc]
                               initWithSigner:signer_
                                        plist:plist] autorelease];
  STAssertNotNil(plistSigner, nil);
  STAssertFalse([plistSigner isPlistSigned], nil);
  STAssertTrue([plistSigner signPlist], nil);
  STAssertTrue([plistSigner isPlistSigned], nil);
  STAssertTrue([plistSigner unsignedPlist], nil);
  STAssertFalse([plistSigner isPlistSigned], nil);
  STAssertEqualObjects([plistSigner plist], plist, nil);
}

- (void)testSigningEmpty {
  [self ensureUnsignedPlist:[NSDictionary dictionary]];
}

- (void)testSigningOneKey {
  NSDictionary *plist = [NSDictionary dictionaryWithObject:@"foo"
                                                    forKey:@"bar"];
  [self ensureUnsignedPlist:plist];
}

- (void)testSigningMultipleKeys {
  NSDictionary *plist = [NSDictionary dictionaryWithObjectsAndKeys:
                         @"foo", @"bar",
                         @"baz", @"quux",
                         @"blah", @"greeble",
                         nil];
  [self ensureUnsignedPlist:plist];
}

- (void)testRulesPlist {
  NSDictionary *plist = [kSignedPlist propertyList];
  PlistSigner *plistSigner = [[[PlistSigner alloc]
                               initWithSigner:signer_
                               plist:plist] autorelease];
  STAssertNotNil(plistSigner, nil);
  STAssertTrue([plistSigner isPlistSigned], nil);
}

- (void)testTigerRulesPlist {
  NSDictionary *plist = [kSignedTigerPlist propertyList];
  PlistSigner *plistSigner = [[[PlistSigner alloc]
                               initWithSigner:signer_
                               plist:plist] autorelease];
  STAssertNotNil(plistSigner, nil);
  STAssertTrue([plistSigner isPlistSigned], nil);
}

@end
