<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

November 30, 2020

Host: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Mei Chu (_TSC_) - Sony Pictures Imageworks
  * [ ] Sean Cooper (_TSC ACES TAC Rep_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Patrick Hodoul (_TSC_) - Autodesk
  * [ ] John Mertic - Academy Software Foundation / Linux Foundation
  * [X] Carol Payne (_TSC_) - Netflix
  * [X] Mark Titchener (_TSC_) - Foundry
  * [X] Carl Rand (_TSC_) - Weta Digital
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [x] Bernard Lefebvre - Autodesk
  * [x] Deke Kincaid - Digital Domain
  * [x] Joseph Goldstone - ARRI
  * [x] Matthias Scharfenberg - Industrial Light & Magic
  * [x] Nick Shaw - Antler Post
  * [x] J Schulte - Industrial Light & Magic
  * [x] Alessandra Tomassi - Industrial Light & Magic

# **OCIO TSC Meeting Notes**

* Doug to recap goals of OCIO v2 and relation to OCIO mission:
    - Some recent discussions about controversial topics. Thought it would be 
      useful to recap what we're doing with v2 from AD point of view - clarify 
      motivation for some of these new features. As written in origin proposal, 
      goal is to be able to use OCIO across apps more broadly, and to rely on 
      it entirely as our color management system (CMS). We would like to 
      standardize on OCIO across apps. Need OCIO to do a variety of color 
      management tasks. When thinking about how OCIO is used, there's color 
      space based transformations (OCIOColorSpaceNode, etc.) and other 
      operations which are more ignorant of color spaces (OCIOFileTransform, 
      etc.). In ideal world, only the former would exist, since it requires the 
      least knowledge from user. Reality is though there is need for people to 
      apply independent transforms, in apps where it's expected the user knows 
      a reasonable amount about color management (e.g. Flame - users know how 
      to load a LUT and apply it). Don't want two separate libs for applying 
      LUTs. For things like dynamic properties and NamedTransform, it's more 
      the latter case, using the same CMS to apply the independent transforms. 
      We aren't trying to change the existing config way of working - very 
      supportive of that workflow. Don't want to enable people with ability to 
      edit individual transforms in a config to edit look of a config.
    - Mark B: Caught up with Doug offline to discuss. The way Doug describes it 
      now, it makes sense. Objections were based more around how these features 
      would map to configs. Some of the objectional features don't map to 
      configs, so we're ok with that.
    - Deke: Really useful for tools like Nuke, where you have to jump over a 
      wall to implement things differently based on what workflow you are 
      doing. Would be nice if Foundry could have one code path instead of two 
      separate ways.
    - Mark T: Agree. We would like that too and hope to standardize on OCIO in 
      Nuke and across products.
    - Doug: Would be helpful to write whitepaper to try to establish best 
      practices. Sometimes we have people who are asked to implement color 
      management but are not color management experts, and implement without 
      being aware of best practices. Think having something that documents this 
      more extensively than current docs would be helpful. Hope TSC can focus 
      on this once v2 is out. Help people understand color management and 
      implement it correctly.
    - Deke: Any support for deep merging of multiple configs?
    - Doug: There is a way to convert between multiple configs in OCIO v2. USD 
      for example could reference one scene config, and import an asset using 
      another config. We added a processor command which can convert between a 
      known color space present in both configs. Looks for these two roles that 
      have been added which act as an interchange. Also added a version where 
      you can provide your own interchange (common color space used across 
      studio).
    - Deke: No way to merge two configs though? To support vendors having 
      configs which inherit from each other.
    - Doug: No.
    - Mark B: Any use case where you're trying todo that?
    - Deke: If vendors could have their own internal config and add it on top 
      of yours. You could add it above or below and merge them together and 
      have access to those transforms. Also for MaterialX, USD, etc. Point to 
      someone else's config to get transforms without cleaning up and 
      ingesting.
    - Mark B: Need to use the solution Doug describes since you don't know if 
      the two config are compatible.
    - Deke: Could also be a studio vs show level config.
    - Mark B: We have same thing, facility, show, shot. We merge them through 
      custom sanitizing tools.
    - Deke: Same. Inherit from ACES config and build on it.
    - Mark B: Might put out another doc to clarify what was discussed with Doug 
      offline. Might be more to discuss but inconsequential compared to other 
      stuff.
  
* Named Color Transforms - Continued discussion:
    - Michael: Is this topic still up for debate? Or was it resolved through 
      offline discussion?
    - Mark B: Didn't cover this topic. Still up for discussion.
    - Doug: We implemented ability to make NamedTransforms inactive. Commit 
      pushed to existing PR that does this. Zach proposed alternative way to 
      make them inactive. I replied that we are open to implementing that 
      instead of or along with what was done. His idea was to use env var to 
      disable named transforms all together, instead of treating them as 
      inactive color spaces where they are disabled one at a time.
    - Michael: Could be good to have a config attribute in that case too since 
      the env could be cleared accidentally when shelling out to a process. 
      That would prevent it in a persistent way. Like how active displays and 
      views are handled currently, with env var or config property.
    - Doug: The individual inactive flags are persistent, so can be used in 
      that way.
    - Michael: Does that answer ILM concerns?
    - Mark B: Our concern is feature itself, not the implementation. And how 
      it's exposed inside of tools. Does processor take NamedTransform 
      constructor?
    - Doug: Would call getProcessor which takes generic transform, and pass 
      in NamedTransform. Same approach as using FileTransform.
    - Mark B: Based on conversation earlier, don't have strong objection. If 
      intent to enable DCC to expose individual transforms where they won't get 
      confused with other transforms.
    - J: Yes, and this is progress on previous discussion. With beta going out 
      and implementation being considered, need to get standardized view on 
      implementation.
    - Mark B: In terms of enabling/disabling, like active displays/active 
      users, sounds reasonable.
    - Carol: As aside, another useful case Matthias and I were discussing. This 
      would be the perfect vehicle for the ACES gamut compression transform. 
      Would be nice to be able to do that separately, in ACES config. Fits 
      nicely.
    - Mark B: One point we discussed. Two very separate use cases for OCIO. One 
      we're trying to defend is config author creating black box, being 
      represented properly. Second use case with graph and a skilled artists 
      making decisions with toolbox of consistent math. In terms of first 
      users, don't see much use for NamedTransforms. Can see benefit for second 
      group of people though.
    - Michael: Use of NamedTransforms could be covered in Doug's proposed 
      whitepaper too.
    - Nick: Would that be a separate node in Nuke?
    - Mark B: Think so
    - Mark T: Yes, think that would be the case.
    - Michael: Wanted to propose we form a UX working group to discuss these 
      topics and forming standards for OCIO v2 implementation in DCCs. We could
      transition from the doc working group to that. If anyone is interested in
      helping lead that, please reach out.
    - Others: Agree. 
    - Deke: ACES has own UI rules, could collaborate between projects.
    - J: Don't think OCIO UX being involved with ACES is good fit, since there 
      are workflows that don't involve ACES.
    - Doug: As config working group moves forward a lot of the same questions 
      are going to come up. A lot of questions from initial config discussion 
      was on things like naming and interface.
    - **TODO**: Michael will help organize a UX working group. 

* Categories discussion (Issue #1222):
    - Doug: At last TSC meeting talked about this. Created issue #1222. Trying 
      to collect a number of new features and discussions on how color spaces 
      appear in application menus. Motivation is the new categories attribute. 
      Hadn't gotten to the list of proposed categories, or sorted out how we 
      expect applications to use this. Want to make sure we're all on the same 
      page in case tweaks are needed to get this working as expected. Proposed 
      some tweaks in the issue. One of the things that came up in v2 working 
      group meetings was request from people that they want to specify, from 
      studio perspective, env vars to filter color spaces for artist 
      groups, like compositors, lighting artists, modelers, etc. Different from 
      app developer point of view with different menus for tasks. Proposed both 
      use cases and something which could work on both ends. Want feedback on 
      whether I've captured this correctly. See issue content:
      https://github.com/AcademySoftwareFoundation/OpenColorIO/issues/1222
    - Kevin: Have existing concept of roles. Fixed set of assumed roles plus 
      extended set. How would we choose to filter those with this. Nuke now 
      shows roles in menus, and would be good to filter those as well.
    - Doug: App helpers code has setting to show roles or not.
    - Kevin: Want users to find the roles they want to find. Artists trained 
      to use particular roles for certain tasks.
    - Deke: Mari has roles listed too, and has its own roles.
    - Mark B: Intention for roles was just to make sure basic color spaces were 
      there. Roles have been misused since then. Don't think roles should 
      appear at all in menus.
    - Deke: Like roles there, but need to filter them.
    - Mark B: Category system is powerful. If DCCs have prefs as to what 
      category might be associated with a dropdown (i.e. texture in Maya). DCCs 
      can assign categories to UI elements and only show those. Don't think 
      this should be OCIO-wide env var. Should be per-DCC.
    - Doug: Yes, would be fixed for certain menu. Specific documented category 
      so config authors know what an app uses.
    - Mark B: Could end up with overlapping categories. If up to user they 
      could define that themselves.
    - Doug: Proposing standard categories to encourage consistency, but doesn't 
      need to be limited to this. The key part is there is a set pre-defined to 
      an application. So Maya would say what categories it's using for different 
      menus. There is another set that is end-user defined and would expect to 
      find those at runtime.
    - Mark B: What if you have both types of categories?
    - Doug: Then would use the intersection. So for texture, you could have 
      file-io intersected with an end-user environment variable (basic-3d etc.)
    - Mark B: If either is empty, defaults to other?
    - Doug: Yes.
    - Mark B: Would make these categories configured by the config author. DCC 
      authors would allow users to customize the category names, or fallback on 
      the default list.
    - Carol: Something to fall back on is good. Most people just use defaults. 
      Don't have a problem with proposed options.
    - Mark: Defaults from DCC (as documented) is fine. Want to avoid problem 
      with roles where categories are inconsistent between apps. If all left to 
      user can be very explicit.
    - Michael: More topics for discussion at UX group.
    - Mark T: Agree. Highlights importance of best practice to show how things 
      are intended to be used. Developer may not find the right thing and use 
      something outside standard use. UX stuff really important.
    - Mark B: App helpers has concrete implementation for reference.
    - **TODO**: All: Read through issue #1222 and provide feedback there or in 
      next TSC meeting.

* Items for next TSC meeting agenda:
    - Finish discussion on standard categories.
