// This file has been generated by Py++.

#include "boost/python.hpp"
#include "bindings/geometric.h"
#include "SPARStwo.pypp.hpp"

namespace bp = boost::python;

struct SPARStwo_wrapper : ompl::geometric::SPARStwo, bp::wrapper< ompl::geometric::SPARStwo > {

    void abandonLists( ::ompl::base::State * st ){
        ompl::geometric::SPARStwo::abandonLists( boost::python::ptr(st) );
    }

    long unsigned int addGuard( ::ompl::base::State * state, ::ompl::geometric::SPARStwo::GuardType type ){
        return ompl::geometric::SPARStwo::addGuard( boost::python::ptr(state), type );
    }

    void approachGraph( long unsigned int v ){
        ompl::geometric::SPARStwo::approachGraph( v );
    }

    bool checkAddConnectivity( ::ompl::base::State const * qNew, ::std::vector< unsigned long > & visibleNeighborhood ){
        return ompl::geometric::SPARStwo::checkAddConnectivity( boost::python::ptr(qNew), boost::ref(visibleNeighborhood) );
    }

    bool checkAddCoverage( ::ompl::base::State const * qNew, ::std::vector< unsigned long > & visibleNeighborhood ){
        return ompl::geometric::SPARStwo::checkAddCoverage( boost::python::ptr(qNew), boost::ref(visibleNeighborhood) );
    }

    bool checkAddInterface( ::ompl::base::State const * qNew, ::std::vector< unsigned long > & graphNeighborhood, ::std::vector< unsigned long > & visibleNeighborhood ){
        return ompl::geometric::SPARStwo::checkAddInterface( boost::python::ptr(qNew), boost::ref(graphNeighborhood), boost::ref(visibleNeighborhood) );
    }

    bool checkAddPath( long unsigned int v ){
        return ompl::geometric::SPARStwo::checkAddPath( v );
    }

    void checkForSolution( ::ompl::base::PlannerTerminationCondition const & ptc, ::ompl::base::PathPtr & solution ){
        ompl::geometric::SPARStwo::checkForSolution( boost::ref(ptc), solution );
    }

    void checkQueryStateInitialization(  ){
        ompl::geometric::SPARStwo::checkQueryStateInitialization(  );
    }

    virtual void clear(  ) {
        if( bp::override func_clear = this->get_override( "clear" ) )
            func_clear(  );
        else{
            this->ompl::geometric::SPARStwo::clear(  );
        }
    }
    
    void default_clear(  ) {
        ompl::geometric::SPARStwo::clear( );
    }

    void computeVPP( long unsigned int v, long unsigned int vp, ::std::vector< unsigned long > & VPPs ){
        ompl::geometric::SPARStwo::computeVPP( v, vp, boost::ref(VPPs) );
    }

    void computeX( long unsigned int v, long unsigned int vp, long unsigned int vpp, ::std::vector< unsigned long > & Xs ){
        ompl::geometric::SPARStwo::computeX( v, vp, vpp, boost::ref(Xs) );
    }

    void connectGuards( long unsigned int v, long unsigned int vp ){
        ompl::geometric::SPARStwo::connectGuards( v, vp );
    }

    ::ompl::base::PathPtr constructSolution( long unsigned int const start, long unsigned int const goal ) const {
        return ompl::geometric::SPARStwo::constructSolution( start, goal );
    }

    ::ompl::base::Cost costHeuristic( long unsigned int u, long unsigned int v ) const {
        return ompl::geometric::SPARStwo::costHeuristic( u, v );
    }

    void distanceCheck( long unsigned int rep, ::ompl::base::State const * q, long unsigned int r, ::ompl::base::State const * s, long unsigned int rp ){
        ompl::geometric::SPARStwo::distanceCheck( rep, boost::python::ptr(q), r, boost::python::ptr(s), rp );
    }

    double distanceFunction( long unsigned int const a, long unsigned int const b ) const {
        return ompl::geometric::SPARStwo::distanceFunction( a, b );
    }

    void findCloseRepresentatives( ::ompl::base::State * workArea, ::ompl::base::State const * qNew, long unsigned int qRep, ::std::map< unsigned long, ompl::base::State* > & closeRepresentatives, ::ompl::base::PlannerTerminationCondition const & ptc ){
        ompl::geometric::SPARStwo::findCloseRepresentatives( boost::python::ptr(workArea), boost::python::ptr(qNew), qRep, boost::ref(closeRepresentatives), boost::ref(ptc) );
    }

    void findGraphNeighbors( ::ompl::base::State * st, ::std::vector< unsigned long > & graphNeighborhood, ::std::vector< unsigned long > & visibleNeighborhood ){
        ompl::geometric::SPARStwo::findGraphNeighbors( boost::python::ptr(st), boost::ref(graphNeighborhood), boost::ref(visibleNeighborhood) );
    }

    long unsigned int findGraphRepresentative( ::ompl::base::State * st ){
        return ompl::geometric::SPARStwo::findGraphRepresentative( boost::python::ptr(st) );
    }

    void freeMemory(  ){
        ompl::geometric::SPARStwo::freeMemory(  );
    }

    ::ompl::geometric::SPARStwo::InterfaceData & getData( long unsigned int v, long unsigned int vp, long unsigned int vpp ){
        return ompl::geometric::SPARStwo::getData( v, vp, vpp );
    }

    virtual void getPlannerData( ::ompl::base::PlannerData & data ) const  {
        if( bp::override func_getPlannerData = this->get_override( "getPlannerData" ) )
            func_getPlannerData( boost::ref(data) );
        else{
            this->ompl::geometric::SPARStwo::getPlannerData( boost::ref(data) );
        }
    }
    
    void default_getPlannerData( ::ompl::base::PlannerData & data ) const  {
        ompl::geometric::SPARStwo::getPlannerData( boost::ref(data) );
    }

    bool haveSolution( ::std::vector< unsigned long > const & start, ::std::vector< unsigned long > const & goal, ::ompl::base::PathPtr & solution ){
        return ompl::geometric::SPARStwo::haveSolution( boost::ref(start), boost::ref(goal), solution );
    }

    ::std::pair< long unsigned int, long unsigned int > index( long unsigned int vp, long unsigned int vpp ){
        return ompl::geometric::SPARStwo::index( vp, vpp );
    }

    bool reachedFailureLimit(  ) const {
        return ompl::geometric::SPARStwo::reachedFailureLimit(  );
    }

    bool reachedTerminationCriterion(  ) const {
        return ompl::geometric::SPARStwo::reachedTerminationCriterion(  );
    }

    void resetFailures(  ){
        ompl::geometric::SPARStwo::resetFailures(  );
    }

    bool sameComponent( long unsigned int m1, long unsigned int m2 ){
        return ompl::geometric::SPARStwo::sameComponent( m1, m2 );
    }

    virtual void setProblemDefinition( ::ompl::base::ProblemDefinitionPtr const & pdef ) {
        if( bp::override func_setProblemDefinition = this->get_override( "setProblemDefinition" ) )
            func_setProblemDefinition( pdef );
        else{
            this->ompl::geometric::SPARStwo::setProblemDefinition( pdef );
        }
    }
    
    void default_setProblemDefinition( ::ompl::base::ProblemDefinitionPtr const & pdef ) {
        ompl::geometric::SPARStwo::setProblemDefinition( pdef );
    }

    virtual void setup(  ) {
        if( bp::override func_setup = this->get_override( "setup" ) )
            func_setup(  );
        else{
            this->ompl::geometric::SPARStwo::setup(  );
        }
    }
    
    void default_setup(  ) {
        ompl::geometric::SPARStwo::setup( );
    }

    virtual ::ompl::base::PlannerStatus solve( ::ompl::base::PlannerTerminationCondition const & ptc ) {
        if( bp::override func_solve = this->get_override( "solve" ) )
            return func_solve( boost::ref(ptc) );
        else{
            return this->ompl::geometric::SPARStwo::solve( boost::ref(ptc) );
        }
    }
    
    ::ompl::base::PlannerStatus default_solve( ::ompl::base::PlannerTerminationCondition const & ptc ) {
        return ompl::geometric::SPARStwo::solve( boost::ref(ptc) );
    }

    void updatePairPoints( long unsigned int rep, ::ompl::base::State const * q, long unsigned int r, ::ompl::base::State const * s ){
        ompl::geometric::SPARStwo::updatePairPoints( rep, boost::python::ptr(q), r, boost::python::ptr(s) );
    }

    virtual void checkValidity(  ) {
        if( bp::override func_checkValidity = this->get_override( "checkValidity" ) )
            func_checkValidity(  );
        else{
            this->ompl::base::Planner::checkValidity(  );
        }
    }
    
    void default_checkValidity(  ) {
        ompl::base::Planner::checkValidity( );
    }

    SPARStwo_wrapper(::ompl::base::SpaceInformationPtr const &si) : ompl::geometric::SPARStwo(si),
                    bp::wrapper<ompl::geometric::SPARStwo>()
                {
                    OMPL_WARN("%s: this planner uses multiple threads and might crash if your StateValidityChecker, OptimizationObjective, etc., are allocated within Python.", getName().c_str());
                }

};

std::string __printDebug(::ompl::geometric::SPARStwo* obj)
        {
            std::ostringstream s;
            obj->printDebug(s);
            return s.str();
        }

void register_SPARStwo_class(){

    { //::ompl::geometric::SPARStwo
        typedef bp::class_< SPARStwo_wrapper, bp::bases< ::ompl::base::Planner >, boost::noncopyable > SPARStwo_exposer_t;
        SPARStwo_exposer_t SPARStwo_exposer = SPARStwo_exposer_t( "SPARStwo", bp::no_init );
        bp::scope SPARStwo_scope( SPARStwo_exposer );
        bp::enum_< ompl::geometric::SPARStwo::GuardType>("GuardType")
            .value("START", ompl::geometric::SPARStwo::START)
            .value("GOAL", ompl::geometric::SPARStwo::GOAL)
            .value("COVERAGE", ompl::geometric::SPARStwo::COVERAGE)
            .value("CONNECTIVITY", ompl::geometric::SPARStwo::CONNECTIVITY)
            .value("INTERFACE", ompl::geometric::SPARStwo::INTERFACE)
            .value("QUALITY", ompl::geometric::SPARStwo::QUALITY)
            .export_values()
            ;
        { //::ompl::geometric::SPARStwo::InterfaceData
            typedef bp::class_< ompl::geometric::SPARStwo::InterfaceData > InterfaceData_exposer_t;
            InterfaceData_exposer_t InterfaceData_exposer = InterfaceData_exposer_t( "InterfaceData", bp::init< >() );
            bp::scope InterfaceData_scope( InterfaceData_exposer );
            { //::ompl::geometric::SPARStwo::InterfaceData::clear
            
                typedef void ( ::ompl::geometric::SPARStwo::InterfaceData::*clear_function_type )( ::ompl::base::SpaceInformationPtr const & ) ;
                
                InterfaceData_exposer.def( 
                    "clear"
                    , clear_function_type( &::ompl::geometric::SPARStwo::InterfaceData::clear )
                    , ( bp::arg("si") ) );
            
            }
            { //::ompl::geometric::SPARStwo::InterfaceData::setFirst
            
                typedef void ( ::ompl::geometric::SPARStwo::InterfaceData::*setFirst_function_type )( ::ompl::base::State const *,::ompl::base::State const *,::ompl::base::SpaceInformationPtr const & ) ;
                
                InterfaceData_exposer.def( 
                    "setFirst"
                    , setFirst_function_type( &::ompl::geometric::SPARStwo::InterfaceData::setFirst )
                    , ( bp::arg("p"), bp::arg("s"), bp::arg("si") ) );
            
            }
            { //::ompl::geometric::SPARStwo::InterfaceData::setSecond
            
                typedef void ( ::ompl::geometric::SPARStwo::InterfaceData::*setSecond_function_type )( ::ompl::base::State const *,::ompl::base::State const *,::ompl::base::SpaceInformationPtr const & ) ;
                
                InterfaceData_exposer.def( 
                    "setSecond"
                    , setSecond_function_type( &::ompl::geometric::SPARStwo::InterfaceData::setSecond )
                    , ( bp::arg("p"), bp::arg("s"), bp::arg("si") ) );
            
            }
            InterfaceData_exposer.def_readwrite( "d_", &ompl::geometric::SPARStwo::InterfaceData::d_ );
        }
        { //::ompl::geometric::SPARStwo::InterfaceHashStruct
            typedef bp::class_< ompl::geometric::SPARStwo::InterfaceHashStruct > InterfaceHashStruct_exposer_t;
            InterfaceHashStruct_exposer_t InterfaceHashStruct_exposer = InterfaceHashStruct_exposer_t( "InterfaceHashStruct" );
            bp::scope InterfaceHashStruct_scope( InterfaceHashStruct_exposer );
            { //::ompl::geometric::SPARStwo::InterfaceHashStruct::operator=
            
                typedef ::ompl::geometric::SPARStwo::InterfaceHashStruct & ( ::ompl::geometric::SPARStwo::InterfaceHashStruct::*assign_function_type )( ::ompl::geometric::SPARStwo::InterfaceHashStruct const & ) ;
                
                InterfaceHashStruct_exposer.def( 
                    "assign"
                    , assign_function_type( &::ompl::geometric::SPARStwo::InterfaceHashStruct::operator= )
                    , ( bp::arg("rhs") )
                    , bp::return_value_policy< bp::reference_existing_object >() );
            
            }
            InterfaceHashStruct_exposer.def_readwrite( "interfaceHash", &ompl::geometric::SPARStwo::InterfaceHashStruct::interfaceHash );
        }
        { //::ompl::geometric::SPARStwo::vertex_color_t
            typedef bp::class_< ompl::geometric::SPARStwo::vertex_color_t > vertex_color_t_exposer_t;
            vertex_color_t_exposer_t vertex_color_t_exposer = vertex_color_t_exposer_t( "vertex_color_t" );
            bp::scope vertex_color_t_scope( vertex_color_t_exposer );
        }
        { //::ompl::geometric::SPARStwo::vertex_interface_data_t
            typedef bp::class_< ompl::geometric::SPARStwo::vertex_interface_data_t > vertex_interface_data_t_exposer_t;
            vertex_interface_data_t_exposer_t vertex_interface_data_t_exposer = vertex_interface_data_t_exposer_t( "vertex_interface_data_t" );
            bp::scope vertex_interface_data_t_scope( vertex_interface_data_t_exposer );
        }
        { //::ompl::geometric::SPARStwo::vertex_state_t
            typedef bp::class_< ompl::geometric::SPARStwo::vertex_state_t > vertex_state_t_exposer_t;
            vertex_state_t_exposer_t vertex_state_t_exposer = vertex_state_t_exposer_t( "vertex_state_t" );
            bp::scope vertex_state_t_scope( vertex_state_t_exposer );
        }
        { //::ompl::geometric::SPARStwo::abandonLists
        
            typedef void ( SPARStwo_wrapper::*abandonLists_function_type )( ::ompl::base::State * ) ;
            
            SPARStwo_exposer.def( 
                "abandonLists"
                , abandonLists_function_type( &SPARStwo_wrapper::abandonLists )
                , ( bp::arg("st") ) );
        
        }
        { //::ompl::geometric::SPARStwo::addGuard
        
            typedef long unsigned int ( SPARStwo_wrapper::*addGuard_function_type )( ::ompl::base::State *,::ompl::geometric::SPARStwo::GuardType ) ;
            
            SPARStwo_exposer.def( 
                "addGuard"
                , addGuard_function_type( &SPARStwo_wrapper::addGuard )
                , ( bp::arg("state"), bp::arg("type") ) );
        
        }
        { //::ompl::geometric::SPARStwo::approachGraph
        
            typedef void ( SPARStwo_wrapper::*approachGraph_function_type )( long unsigned int ) ;
            
            SPARStwo_exposer.def( 
                "approachGraph"
                , approachGraph_function_type( &SPARStwo_wrapper::approachGraph )
                , ( bp::arg("v") ) );
        
        }
        { //::ompl::geometric::SPARStwo::checkAddConnectivity
        
            typedef bool ( SPARStwo_wrapper::*checkAddConnectivity_function_type )( ::ompl::base::State const *,::std::vector< unsigned long > & ) ;
            
            SPARStwo_exposer.def( 
                "checkAddConnectivity"
                , checkAddConnectivity_function_type( &SPARStwo_wrapper::checkAddConnectivity )
                , ( bp::arg("qNew"), bp::arg("visibleNeighborhood") ) );
        
        }
        { //::ompl::geometric::SPARStwo::checkAddCoverage
        
            typedef bool ( SPARStwo_wrapper::*checkAddCoverage_function_type )( ::ompl::base::State const *,::std::vector< unsigned long > & ) ;
            
            SPARStwo_exposer.def( 
                "checkAddCoverage"
                , checkAddCoverage_function_type( &SPARStwo_wrapper::checkAddCoverage )
                , ( bp::arg("qNew"), bp::arg("visibleNeighborhood") ) );
        
        }
        { //::ompl::geometric::SPARStwo::checkAddInterface
        
            typedef bool ( SPARStwo_wrapper::*checkAddInterface_function_type )( ::ompl::base::State const *,::std::vector< unsigned long > &,::std::vector< unsigned long > & ) ;
            
            SPARStwo_exposer.def( 
                "checkAddInterface"
                , checkAddInterface_function_type( &SPARStwo_wrapper::checkAddInterface )
                , ( bp::arg("qNew"), bp::arg("graphNeighborhood"), bp::arg("visibleNeighborhood") ) );
        
        }
        { //::ompl::geometric::SPARStwo::checkAddPath
        
            typedef bool ( SPARStwo_wrapper::*checkAddPath_function_type )( long unsigned int ) ;
            
            SPARStwo_exposer.def( 
                "checkAddPath"
                , checkAddPath_function_type( &SPARStwo_wrapper::checkAddPath )
                , ( bp::arg("v") ) );
        
        }
        { //::ompl::geometric::SPARStwo::checkForSolution
        
            typedef void ( SPARStwo_wrapper::*checkForSolution_function_type )( ::ompl::base::PlannerTerminationCondition const &,::ompl::base::PathPtr & ) ;
            
            SPARStwo_exposer.def( 
                "checkForSolution"
                , checkForSolution_function_type( &SPARStwo_wrapper::checkForSolution )
                , ( bp::arg("ptc"), bp::arg("solution") ) );
        
        }
        { //::ompl::geometric::SPARStwo::checkQueryStateInitialization
        
            typedef void ( SPARStwo_wrapper::*checkQueryStateInitialization_function_type )(  ) ;
            
            SPARStwo_exposer.def( 
                "checkQueryStateInitialization"
                , checkQueryStateInitialization_function_type( &SPARStwo_wrapper::checkQueryStateInitialization ) );
        
        }
        { //::ompl::geometric::SPARStwo::clear
        
            typedef void ( ::ompl::geometric::SPARStwo::*clear_function_type )(  ) ;
            typedef void ( SPARStwo_wrapper::*default_clear_function_type )(  ) ;
            
            SPARStwo_exposer.def( 
                "clear"
                , clear_function_type(&::ompl::geometric::SPARStwo::clear)
                , default_clear_function_type(&SPARStwo_wrapper::default_clear) );
        
        }
        { //::ompl::geometric::SPARStwo::clearQuery
        
            typedef void ( ::ompl::geometric::SPARStwo::*clearQuery_function_type )(  ) ;
            
            SPARStwo_exposer.def( 
                "clearQuery"
                , clearQuery_function_type( &::ompl::geometric::SPARStwo::clearQuery ) );
        
        }
        { //::ompl::geometric::SPARStwo::computeVPP
        
            typedef void ( SPARStwo_wrapper::*computeVPP_function_type )( long unsigned int,long unsigned int,::std::vector< unsigned long > & ) ;
            
            SPARStwo_exposer.def( 
                "computeVPP"
                , computeVPP_function_type( &SPARStwo_wrapper::computeVPP )
                , ( bp::arg("v"), bp::arg("vp"), bp::arg("VPPs") ) );
        
        }
        { //::ompl::geometric::SPARStwo::computeX
        
            typedef void ( SPARStwo_wrapper::*computeX_function_type )( long unsigned int,long unsigned int,long unsigned int,::std::vector< unsigned long > & ) ;
            
            SPARStwo_exposer.def( 
                "computeX"
                , computeX_function_type( &SPARStwo_wrapper::computeX )
                , ( bp::arg("v"), bp::arg("vp"), bp::arg("vpp"), bp::arg("Xs") ) );
        
        }
        { //::ompl::geometric::SPARStwo::connectGuards
        
            typedef void ( SPARStwo_wrapper::*connectGuards_function_type )( long unsigned int,long unsigned int ) ;
            
            SPARStwo_exposer.def( 
                "connectGuards"
                , connectGuards_function_type( &SPARStwo_wrapper::connectGuards )
                , ( bp::arg("v"), bp::arg("vp") ) );
        
        }
        { //::ompl::geometric::SPARStwo::constructRoadmap
        
            typedef void ( ::ompl::geometric::SPARStwo::*constructRoadmap_function_type )( ::ompl::base::PlannerTerminationCondition const & ) ;
            
            SPARStwo_exposer.def( 
                "constructRoadmap"
                , constructRoadmap_function_type( &::ompl::geometric::SPARStwo::constructRoadmap )
                , ( bp::arg("ptc") ) );
        
        }
        { //::ompl::geometric::SPARStwo::constructRoadmap
        
            typedef void ( ::ompl::geometric::SPARStwo::*constructRoadmap_function_type )( ::ompl::base::PlannerTerminationCondition const &,bool ) ;
            
            SPARStwo_exposer.def( 
                "constructRoadmap"
                , constructRoadmap_function_type( &::ompl::geometric::SPARStwo::constructRoadmap )
                , ( bp::arg("ptc"), bp::arg("stopOnMaxFail") ) );
        
        }
        { //::ompl::geometric::SPARStwo::constructSolution
        
            typedef ::ompl::base::PathPtr ( SPARStwo_wrapper::*constructSolution_function_type )( long unsigned int const,long unsigned int const ) const;
            
            SPARStwo_exposer.def( 
                "constructSolution"
                , constructSolution_function_type( &SPARStwo_wrapper::constructSolution )
                , ( bp::arg("start"), bp::arg("goal") ) );
        
        }
        { //::ompl::geometric::SPARStwo::costHeuristic
        
            typedef ::ompl::base::Cost ( SPARStwo_wrapper::*costHeuristic_function_type )( long unsigned int,long unsigned int ) const;
            
            SPARStwo_exposer.def( 
                "costHeuristic"
                , costHeuristic_function_type( &SPARStwo_wrapper::costHeuristic )
                , ( bp::arg("u"), bp::arg("v") ) );
        
        }
        { //::ompl::geometric::SPARStwo::distanceCheck
        
            typedef void ( SPARStwo_wrapper::*distanceCheck_function_type )( long unsigned int,::ompl::base::State const *,long unsigned int,::ompl::base::State const *,long unsigned int ) ;
            
            SPARStwo_exposer.def( 
                "distanceCheck"
                , distanceCheck_function_type( &SPARStwo_wrapper::distanceCheck )
                , ( bp::arg("rep"), bp::arg("q"), bp::arg("r"), bp::arg("s"), bp::arg("rp") ) );
        
        }
        { //::ompl::geometric::SPARStwo::distanceFunction
        
            typedef double ( SPARStwo_wrapper::*distanceFunction_function_type )( long unsigned int const,long unsigned int const ) const;
            
            SPARStwo_exposer.def( 
                "distanceFunction"
                , distanceFunction_function_type( &SPARStwo_wrapper::distanceFunction )
                , ( bp::arg("a"), bp::arg("b") ) );
        
        }
        { //::ompl::geometric::SPARStwo::findCloseRepresentatives
        
            typedef void ( SPARStwo_wrapper::*findCloseRepresentatives_function_type )( ::ompl::base::State *,::ompl::base::State const *,long unsigned int,::std::map< unsigned long, ompl::base::State* > &,::ompl::base::PlannerTerminationCondition const & ) ;
            
            SPARStwo_exposer.def( 
                "findCloseRepresentatives"
                , findCloseRepresentatives_function_type( &SPARStwo_wrapper::findCloseRepresentatives )
                , ( bp::arg("workArea"), bp::arg("qNew"), bp::arg("qRep"), bp::arg("closeRepresentatives"), bp::arg("ptc") ) );
        
        }
        { //::ompl::geometric::SPARStwo::findGraphNeighbors
        
            typedef void ( SPARStwo_wrapper::*findGraphNeighbors_function_type )( ::ompl::base::State *,::std::vector< unsigned long > &,::std::vector< unsigned long > & ) ;
            
            SPARStwo_exposer.def( 
                "findGraphNeighbors"
                , findGraphNeighbors_function_type( &SPARStwo_wrapper::findGraphNeighbors )
                , ( bp::arg("st"), bp::arg("graphNeighborhood"), bp::arg("visibleNeighborhood") ) );
        
        }
        { //::ompl::geometric::SPARStwo::findGraphRepresentative
        
            typedef long unsigned int ( SPARStwo_wrapper::*findGraphRepresentative_function_type )( ::ompl::base::State * ) ;
            
            SPARStwo_exposer.def( 
                "findGraphRepresentative"
                , findGraphRepresentative_function_type( &SPARStwo_wrapper::findGraphRepresentative )
                , ( bp::arg("st") ) );
        
        }
        { //::ompl::geometric::SPARStwo::freeMemory
        
            typedef void ( SPARStwo_wrapper::*freeMemory_function_type )(  ) ;
            
            SPARStwo_exposer.def( 
                "freeMemory"
                , freeMemory_function_type( &SPARStwo_wrapper::freeMemory ) );
        
        }
        { //::ompl::geometric::SPARStwo::getBestCost
        
            typedef ::std::string ( ::ompl::geometric::SPARStwo::*getBestCost_function_type )(  ) const;
            
            SPARStwo_exposer.def( 
                "getBestCost"
                , getBestCost_function_type( &::ompl::geometric::SPARStwo::getBestCost ) );
        
        }
        { //::ompl::geometric::SPARStwo::getData
        
            typedef ::ompl::geometric::SPARStwo::InterfaceData & ( SPARStwo_wrapper::*getData_function_type )( long unsigned int,long unsigned int,long unsigned int ) ;
            
            SPARStwo_exposer.def( 
                "getData"
                , getData_function_type( &SPARStwo_wrapper::getData )
                , ( bp::arg("v"), bp::arg("vp"), bp::arg("vpp") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::ompl::geometric::SPARStwo::getDenseDeltaFraction
        
            typedef double ( ::ompl::geometric::SPARStwo::*getDenseDeltaFraction_function_type )(  ) const;
            
            SPARStwo_exposer.def( 
                "getDenseDeltaFraction"
                , getDenseDeltaFraction_function_type( &::ompl::geometric::SPARStwo::getDenseDeltaFraction ) );
        
        }
        { //::ompl::geometric::SPARStwo::getIterationCount
        
            typedef ::std::string ( ::ompl::geometric::SPARStwo::*getIterationCount_function_type )(  ) const;
            
            SPARStwo_exposer.def( 
                "getIterationCount"
                , getIterationCount_function_type( &::ompl::geometric::SPARStwo::getIterationCount ) );
        
        }
        { //::ompl::geometric::SPARStwo::getMaxFailures
        
            typedef unsigned int ( ::ompl::geometric::SPARStwo::*getMaxFailures_function_type )(  ) const;
            
            SPARStwo_exposer.def( 
                "getMaxFailures"
                , getMaxFailures_function_type( &::ompl::geometric::SPARStwo::getMaxFailures ) );
        
        }
        { //::ompl::geometric::SPARStwo::getPlannerData
        
            typedef void ( ::ompl::geometric::SPARStwo::*getPlannerData_function_type )( ::ompl::base::PlannerData & ) const;
            typedef void ( SPARStwo_wrapper::*default_getPlannerData_function_type )( ::ompl::base::PlannerData & ) const;
            
            SPARStwo_exposer.def( 
                "getPlannerData"
                , getPlannerData_function_type(&::ompl::geometric::SPARStwo::getPlannerData)
                , default_getPlannerData_function_type(&SPARStwo_wrapper::default_getPlannerData)
                , ( bp::arg("data") ) );
        
        }
        { //::ompl::geometric::SPARStwo::getRoadmap
        
            typedef ::boost::adjacency_list< boost::vecS, boost::vecS, boost::undirectedS, boost::property< ompl::geometric::SPARStwo::vertex_state_t, ompl::base::State*, boost::property< boost::vertex_predecessor_t, unsigned long, boost::property< boost::vertex_rank_t, unsigned long, boost::property< ompl::geometric::SPARStwo::vertex_color_t, ompl::geometric::SPARStwo::GuardType, boost::property< ompl::geometric::SPARStwo::vertex_interface_data_t, ompl::geometric::SPARStwo::InterfaceHashStruct, boost::no_property > > > > >, boost::property< boost::edge_weight_t, ompl::base::Cost, boost::no_property >, boost::no_property, boost::listS > const & ( ::ompl::geometric::SPARStwo::*getRoadmap_function_type )(  ) const;
            
            SPARStwo_exposer.def( 
                "getRoadmap"
                , getRoadmap_function_type( &::ompl::geometric::SPARStwo::getRoadmap )
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::ompl::geometric::SPARStwo::getSparseDeltaFraction
        
            typedef double ( ::ompl::geometric::SPARStwo::*getSparseDeltaFraction_function_type )(  ) const;
            
            SPARStwo_exposer.def( 
                "getSparseDeltaFraction"
                , getSparseDeltaFraction_function_type( &::ompl::geometric::SPARStwo::getSparseDeltaFraction ) );
        
        }
        { //::ompl::geometric::SPARStwo::getStretchFactor
        
            typedef double ( ::ompl::geometric::SPARStwo::*getStretchFactor_function_type )(  ) const;
            
            SPARStwo_exposer.def( 
                "getStretchFactor"
                , getStretchFactor_function_type( &::ompl::geometric::SPARStwo::getStretchFactor ) );
        
        }
        { //::ompl::geometric::SPARStwo::haveSolution
        
            typedef bool ( SPARStwo_wrapper::*haveSolution_function_type )( ::std::vector< unsigned long > const &,::std::vector< unsigned long > const &,::ompl::base::PathPtr & ) ;
            
            SPARStwo_exposer.def( 
                "haveSolution"
                , haveSolution_function_type( &SPARStwo_wrapper::haveSolution )
                , ( bp::arg("start"), bp::arg("goal"), bp::arg("solution") ) );
        
        }
        { //::ompl::geometric::SPARStwo::index
        
            typedef ::std::pair< long unsigned int, long unsigned int > ( SPARStwo_wrapper::*index_function_type )( long unsigned int,long unsigned int ) ;
            
            SPARStwo_exposer.def( 
                "index"
                , index_function_type( &SPARStwo_wrapper::index )
                , ( bp::arg("vp"), bp::arg("vpp") ) );
        
        }
        { //::ompl::geometric::SPARStwo::milestoneCount
        
            typedef unsigned int ( ::ompl::geometric::SPARStwo::*milestoneCount_function_type )(  ) const;
            
            SPARStwo_exposer.def( 
                "milestoneCount"
                , milestoneCount_function_type( &::ompl::geometric::SPARStwo::milestoneCount ) );
        
        }
        { //::ompl::geometric::SPARStwo::reachedFailureLimit
        
            typedef bool ( SPARStwo_wrapper::*reachedFailureLimit_function_type )(  ) const;
            
            SPARStwo_exposer.def( 
                "reachedFailureLimit"
                , reachedFailureLimit_function_type( &SPARStwo_wrapper::reachedFailureLimit ) );
        
        }
        { //::ompl::geometric::SPARStwo::reachedTerminationCriterion
        
            typedef bool ( SPARStwo_wrapper::*reachedTerminationCriterion_function_type )(  ) const;
            
            SPARStwo_exposer.def( 
                "reachedTerminationCriterion"
                , reachedTerminationCriterion_function_type( &SPARStwo_wrapper::reachedTerminationCriterion ) );
        
        }
        { //::ompl::geometric::SPARStwo::resetFailures
        
            typedef void ( SPARStwo_wrapper::*resetFailures_function_type )(  ) ;
            
            SPARStwo_exposer.def( 
                "resetFailures"
                , resetFailures_function_type( &SPARStwo_wrapper::resetFailures ) );
        
        }
        { //::ompl::geometric::SPARStwo::sameComponent
        
            typedef bool ( SPARStwo_wrapper::*sameComponent_function_type )( long unsigned int,long unsigned int ) ;
            
            SPARStwo_exposer.def( 
                "sameComponent"
                , sameComponent_function_type( &SPARStwo_wrapper::sameComponent )
                , ( bp::arg("m1"), bp::arg("m2") ) );
        
        }
        { //::ompl::geometric::SPARStwo::setDenseDeltaFraction
        
            typedef void ( ::ompl::geometric::SPARStwo::*setDenseDeltaFraction_function_type )( double ) ;
            
            SPARStwo_exposer.def( 
                "setDenseDeltaFraction"
                , setDenseDeltaFraction_function_type( &::ompl::geometric::SPARStwo::setDenseDeltaFraction )
                , ( bp::arg("d") ) );
        
        }
        { //::ompl::geometric::SPARStwo::setMaxFailures
        
            typedef void ( ::ompl::geometric::SPARStwo::*setMaxFailures_function_type )( unsigned int ) ;
            
            SPARStwo_exposer.def( 
                "setMaxFailures"
                , setMaxFailures_function_type( &::ompl::geometric::SPARStwo::setMaxFailures )
                , ( bp::arg("m") ) );
        
        }
        { //::ompl::geometric::SPARStwo::setProblemDefinition
        
            typedef void ( ::ompl::geometric::SPARStwo::*setProblemDefinition_function_type )( ::ompl::base::ProblemDefinitionPtr const & ) ;
            typedef void ( SPARStwo_wrapper::*default_setProblemDefinition_function_type )( ::ompl::base::ProblemDefinitionPtr const & ) ;
            
            SPARStwo_exposer.def( 
                "setProblemDefinition"
                , setProblemDefinition_function_type(&::ompl::geometric::SPARStwo::setProblemDefinition)
                , default_setProblemDefinition_function_type(&SPARStwo_wrapper::default_setProblemDefinition)
                , ( bp::arg("pdef") ) );
        
        }
        { //::ompl::geometric::SPARStwo::setSparseDeltaFraction
        
            typedef void ( ::ompl::geometric::SPARStwo::*setSparseDeltaFraction_function_type )( double ) ;
            
            SPARStwo_exposer.def( 
                "setSparseDeltaFraction"
                , setSparseDeltaFraction_function_type( &::ompl::geometric::SPARStwo::setSparseDeltaFraction )
                , ( bp::arg("D") ) );
        
        }
        { //::ompl::geometric::SPARStwo::setStretchFactor
        
            typedef void ( ::ompl::geometric::SPARStwo::*setStretchFactor_function_type )( double ) ;
            
            SPARStwo_exposer.def( 
                "setStretchFactor"
                , setStretchFactor_function_type( &::ompl::geometric::SPARStwo::setStretchFactor )
                , ( bp::arg("t") ) );
        
        }
        { //::ompl::geometric::SPARStwo::setup
        
            typedef void ( ::ompl::geometric::SPARStwo::*setup_function_type )(  ) ;
            typedef void ( SPARStwo_wrapper::*default_setup_function_type )(  ) ;
            
            SPARStwo_exposer.def( 
                "setup"
                , setup_function_type(&::ompl::geometric::SPARStwo::setup)
                , default_setup_function_type(&SPARStwo_wrapper::default_setup) );
        
        }
        { //::ompl::geometric::SPARStwo::solve
        
            typedef ::ompl::base::PlannerStatus ( ::ompl::geometric::SPARStwo::*solve_function_type )( ::ompl::base::PlannerTerminationCondition const & ) ;
            typedef ::ompl::base::PlannerStatus ( SPARStwo_wrapper::*default_solve_function_type )( ::ompl::base::PlannerTerminationCondition const & ) ;
            
            SPARStwo_exposer.def( 
                "solve"
                , solve_function_type(&::ompl::geometric::SPARStwo::solve)
                , default_solve_function_type(&SPARStwo_wrapper::default_solve)
                , ( bp::arg("ptc") ) );
        
        }
        { //::ompl::geometric::SPARStwo::updatePairPoints
        
            typedef void ( SPARStwo_wrapper::*updatePairPoints_function_type )( long unsigned int,::ompl::base::State const *,long unsigned int,::ompl::base::State const * ) ;
            
            SPARStwo_exposer.def( 
                "updatePairPoints"
                , updatePairPoints_function_type( &SPARStwo_wrapper::updatePairPoints )
                , ( bp::arg("rep"), bp::arg("q"), bp::arg("r"), bp::arg("s") ) );
        
        }
        SPARStwo_exposer.def("printDebug", &__printDebug);
        SPARStwo_exposer.def("solve", (::ompl::base::PlannerStatus(::ompl::base::Planner::*)( double ))(&::ompl::base::Planner::solve), (bp::arg("solveTime")) );
        SPARStwo_exposer.def("setProblemDefinition",&::ompl::base::Planner::setProblemDefinition,
                            &SPARStwo_wrapper::default_setProblemDefinition, (bp::arg("pdef")) );
        SPARStwo_exposer.def("checkValidity",&::ompl::base::Planner::checkValidity,
                        &SPARStwo_wrapper::default_checkValidity );
        SPARStwo_exposer.def(bp::init<ompl::base::SpaceInformationPtr const &>(bp::arg("si")));
    }

}
