from asdl import pybase
from mycpp import mops
from typing import Optional, List, Tuple, Dict, Any, cast, TYPE_CHECKING


from asdl import runtime  # For runtime.NO_SPID
from asdl.runtime import NewRecord, NewLeaf, TraversalState
from _devbuild.gen.hnode_asdl import color_e, hnode, hnode_e, hnode_t, Field

class doc_e(object):
  Newline = 1
  Text = 2
  Indent = 3
  Cat = 4

_doc_str = {
  1: 'Newline',
  2: 'Text',
  3: 'Indent',
  4: 'Cat',
}

def doc_str(tag, dot=True):
  # type: (int, bool) -> str
  v = _doc_str[tag]
  if dot:
    return "doc.%s" % v
  else:
    return v

class doc_t(pybase.CompoundObj):
  def tag(self):
    # type: () -> int
    return self._type_tag
  pass

class doc__Newline(doc_t):
  _type_tag = 1
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('doc__Newline')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('doc__Newline')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class doc(object):
  Newline = doc__Newline()
  
  class Text(doc_t):
    _type_tag = 2
    __slots__ = ('s', 'width')
  
    def __init__(self, s, width):
      # type: (str, int) -> None
      self.s = s
      self.width = width
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> doc.Text
      return doc.Text('', -1)
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('doc.Text')
      L = out_node.fields
  
      x0 = NewLeaf(self.s, color_e.StringConst)
      L.append(Field('s', x0))
  
      x1 = hnode.Leaf(str(self.width), color_e.OtherConst)
      L.append(Field('width', x1))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('doc.Text')
      L = out_node.fields
      x0 = NewLeaf(self.s, color_e.StringConst)
      L.append(Field('s', x0))
  
      x1 = hnode.Leaf(str(self.width), color_e.OtherConst)
      L.append(Field('width', x1))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class Indent(doc_t):
    _type_tag = 3
    __slots__ = ('ind', 'children')
  
    def __init__(self, ind, children):
      # type: (int, List[doc_t]) -> None
      self.ind = ind
      self.children = children
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> doc.Indent
      return doc.Indent(-1, [] if alloc_lists else cast('List[doc_t]', None))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('doc.Indent')
      L = out_node.fields
  
      x0 = hnode.Leaf(str(self.ind), color_e.OtherConst)
      L.append(Field('ind', x0))
  
      if self.children is not None:  # List
        x1 = hnode.Array([])
        for i1 in self.children:
          h = (hnode.Leaf("_", color_e.OtherConst) if i1 is None else
               i1.PrettyTree(trav=trav))
          x1.children.append(h)
        L.append(Field('children', x1))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('doc.Indent')
      L = out_node.fields
      x0 = hnode.Leaf(str(self.ind), color_e.OtherConst)
      L.append(Field('ind', x0))
  
      if self.children is not None:  # List
        x1 = hnode.Array([])
        for i1 in self.children:
          h = (hnode.Leaf("_", color_e.OtherConst) if i1 is None else
               i1.AbbreviatedTree(trav=trav))
          x1.children.append(h)
        L.append(Field('children', x1))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class Cat(doc_t):
    _type_tag = 4
    __slots__ = ('left', 'right')
  
    def __init__(self, left, right):
      # type: (doc_t, doc_t) -> None
      self.left = left
      self.right = right
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> doc.Cat
      return doc.Cat(cast(doc_t, None), cast(doc_t, None))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('doc.Cat')
      L = out_node.fields
  
      assert self.left is not None
      x0 = self.left.PrettyTree(trav=trav)
      L.append(Field('left', x0))
  
      assert self.right is not None
      x1 = self.right.PrettyTree(trav=trav)
      L.append(Field('right', x1))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('doc.Cat')
      L = out_node.fields
      assert self.left is not None
      x0 = self.left.AbbreviatedTree(trav=trav)
      L.append(Field('left', x0))
  
      assert self.right is not None
      x1 = self.right.AbbreviatedTree(trav=trav)
      L.append(Field('right', x1))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  pass

