<?PHP
###################################################################
#
# snmptt trap viewer based on the one from Hobbit
#
###################################################################

$NEDIWWWURL = "/html";

# these should match up with your SNMPTT settings for SQL logging.
$MYSQLSERVER = "localhost";
$MYSQLUSER   = "snmptt";
$MYSQLPASSWD = "itisprivate";
$MYSQLDB     = "snmptt";


##### Print header HTML stuff #####
print <<<HEAD
<HEAD>
<TITLE>SNMP Traps </TITLE>
</HEAD>
<!-- The favicon image -->
<link rel="shortcut icon" href="$NEDIWWWURL/img/favicon-blue.ico">

<BR>
HEAD;


##### Get any previous form data #####
if (!isset($match)) {
	$match="and"; }
$checked[$match]="CHECKED";

$agentip    = $_GET['agentip'];
$hostname   = $_GET['hostname'];
$trapoid    = $_GET['trapoid'];
$severity   = $_GET['severity'];
$snmpttdb   = $_GET['snmptt'];

if (isset($_GET['last'])) {
    $last = $_GET['last'];
} else {
    $last = 500;
}

if (isset($snmpttdb)) {
   if ($snmpttdb == 1) {
       $SNMPDB = "snmptt";
   } elseif ($snmpttdb == 2) {
       $SNMPDB = "snmptt_unknown";
   } else {
       $SNMPDB = "snmptt";
   }
} else {
   $SNMPDB = "snmptt";
}

##### Print Form #####
print <<<FORM
<form action=trap.php method=GET>
<table>
<tr><TD><label>Agent IP: </label></TD>
    <td><input type=text name=agentip value='$agentip' size=30></td></tr>
<tr><TD><label>Hostname: </label></TD>
    <td><input type=text name=hostname value='$hostname' size=30></td></tr>
<tr><TD><label>Trap OID: </label></TD>
    <td><input type=text name=trapoid value='$trapoid' size=30></td></tr>
<tr><TD><label>Severity: </label></TD>
    <td><input type=text name=severity value='$severity' size=30></td></tr>
<tr><TD><label>Match type: </label></TD>
    <td><input type=radio name=match value='and' $checked[and]>AND <input type=radio name=match value='or' $checked[or]>OR</td></tr>
<tr><td><label>Last: </label></td>
    <td><select name=last>
      <option>5
      <option>25
      <option>50
      <option>100
    </select> 
    <select name=snmpttdb>
      <option value=1>Known
      <option value=2>Unknown
    </select> Traps
    </td></tr>

</table><br>
<input type=submit><br>
<hr>
FORM;

##### Setup MySQL connection and clean up SQL input #####

# Must connect to MySQL first before testing with
# magic_quotes or real_escape
$link = mysql_connect($MYSQLSERVER,$MYSQLUSER,$MYSQLPASSWD);

function quote_smart($value)
{
   // Stripslashes
   if (get_magic_quotes_gpc()) {
       $value = stripslashes($value);
   }
   // Quote if not a number or a numeric string
   if (!is_numeric($value)) {
       $value = "'" . mysql_real_escape_string($value) . "'";
   }
   return $value;
}

unset($criteria);
if ($agentip !=  '') {
        $agentip = quote_smart($agentip);
	$criteria[] = "agentip LIKE $agentip";
	}
if ($hostname != '') {
        $hostname = quote_smart($hostname);
	$criteria[] = "hostname RLIKE $hostname";
	}
if ($trapoid != '') {
        $trapoid = quote_smart($trapoid);
	$criteria[] = "trapoid LIKE $trapoid";
	}
if ($severity != '') {
        $severity = quote_smart($severity);
        if ($SNMPDB == 'snmptt') {
	    $criteria[] = "severity RLIKE $severity";
            }
	}

$wherestr = "";

if (isset($criteria)) {
	$wherestr = "WHERE " .implode(" $match ",$criteria);
}


if ($SNMPDB == 'snmptt_unknown') {
   $SELECT = "SELECT id, traptime, agentip, hostname, trapoid, formatline ";
} else {
   $SELECT = "SELECT id, traptime, agentip, hostname, trapoid, severity, formatline ";
}


##### Execute SQL query and print results #####

mysql_select_db($MYSQLDB) or die(mysql_error());
$SQLSELECT = "$SELECT
               FROM $SNMPDB $wherestr
               ORDER BY id DESC
               LIMIT $last";

#print "$SQLSELECT";

print <<<TABLEHEAD
<table boder=1 frame=border rules=all>
<tr>
<th WIDTH=160>Date</th>
<th>Agent IP</th>
<th>Hostname</th>
<th>Trap OID</th>
<th WIDTH=130>Severity</th>
<th>Message</th>
</tr>
TABLEHEAD;


$cas =  mysql_query("$SQLSELECT") or die(mysql_error());

while ($car = mysql_fetch_array($cas)) {

        $color = "clear";
        if ($car[severity] == 'Normal')          { $color = "green"; }
        if ($car[severity] == 'INFORMATIONAL')   { $color = "green"; }
        if ($car[severity] == 'WARNING')         { $color = "yellow"; }
        if ($car[severity] == 'MINOR')           { $color = "yellow"; }
        if ($car[severity] == 'SEVERE')          { $color = "red"; }
        if ($car[severity] == 'MAJOR')           { $color = "red"; }
        if ($car[severity] == 'CRITICAL')        { $color = "red"; }

        if ($SNMPDB == 'snmptt_unknown') {
            $severity = "Unknown";
        } else {
            $severity = $car[severity];
        }

	print <<<LINE
<TR>
<TD><FONT FACE="Arial, Helvetica" SIZE="-1">$car[traptime]</FONT></td>
<TD><FONT FACE="Arial, Helvetica" SIZE="-1">$car[agentip]</FONT></td>
<TD><FONT FACE="Arial, Helvetica" SIZE="-1">$car[hostname]</FONT></td>
<TD><FONT FACE="Arial, Helvetica" SIZE="-1">$car[trapoid]</FONT></td>
<TD><FONT FACE="Arial, Helvetica" SIZE="-1"><IMG SRC="$NEDIWWWURL/img/$color.gif" HEIGHT="16" WIDTH="16" BORDER="0">$severity</FONT></TD>
<TD><FONT FACE="Arial, Helvetica" SIZE="-1">$car[formatline]</FONT></TD>
</TR>
LINE;
}
print "</TABLE>\n";

mysql_close($link);

?>

</body>
</html>
