# Sample databases

Public sample image databases across various imaging modalities.

If you come across image databases that are missing from the list below, create an issue or submit a pull request on [napari/docs](https://github.com/napari/docs) to help us expand it.



| **Database**                                               | **Description**                                                                                                                                                                               |
|------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [Allen Brain Atlases](http://portal.brain-map.org)                                        | Human and mouse brain atlas containing gene expression, anatomic, and genomic data                                                                                                            |
| [Allen Cell Explorer](https://www.allencell.org)                                        | Database of cell data, segmentations, and analyses with multiple experimental parameters.                                                                                                     |
| [Berkeley Drosophila Genome Project (BDGP) in situ database](http://insitu.fruitfly.org/cgi-bin/ex/insitu.pl) | Patterns of gene expression in Drosophila embryogenesis.                                                                                                                                      |
| [The Cell Image Library](http://www.cellimagelibrary.org/home)                                     | Public resource database of images, videos, and animations of cells, capturing a wide diversity of organisms, cell types, and cellular processes.                                             |
| [FlyLight Imagery](https://open.quiltdata.com/b/janelia-flylight-imagery)                                           | 3D fly's central nervous system captured by confocal laser scanning microscope.                                                                                                               |
| [OpenCell](https://opencell.czbiohub.org/download)                                                   | A proteome-scale collection of protein localization and interaction measurements in human cells. Contains fluorescence microscopy and IP-MS data.                                             |
| [Whole Slide Imaging Repository](https://digitalpathologyassociation.org/whole-slide-imaging-repository)                             | Collections of whole slide imaging repositories.                                                                                                                                              |
| [BioImage Archive](https://www.ebi.ac.uk/biostudies/bioimages/studies)                                           | Description and data of biological studies; links to databases at EMBL-EBI (European Molecular Biology Laboratory–European Bioinformatics Institute).                                         |
| [Image Data Resource (IDR)](https://idr.openmicroscopy.org)                                  | Public data repository for storing and integrating image data sets from published scientific studies.                                                                                         |
| [Systems Science of Biological Dynamics (SSBD)](https://ssbd.riken.jp/database/)              | Set of quantitative data and microscopy images from a variety of species, sources, and methods.                                                                                               |
| [Cancer Imaging Archive](https://www.cancerimagingarchive.net/collections/)                                     | Collections of cancer medical images.                                                                                                                                                         |
| [Brain Image Library](https://www.brainimagelibrary.org/)                                        | A public resource to deposit, analyze, mine, share, and interact with large brain image datasets.                                                                                             |
| [EMPIAR](https://www.ebi.ac.uk/empiar/)                                                     | The Electron Microscopy Public Image Archive (EMPIAR) is a public resource for raw images underpinning 3D cryo-EM maps and tomograms.                                                         |
| [OME-NGFF files on IDR](https://idr.github.io/ome-ngff-samples/)                                      | Catalog of IDR images formatted as OME-NGFF.                                                                                                                                                  |
| [Cell Tracking Challenge](http://celltrackingchallenge.net/datasets)                                    | Repository of annotated videos from the Cell Tracking Challenge; contains contrast-enhancing (PhC, DIC) or fluorescence (widefield, confocal, multiphoton, and light sheet microsocopy) data. |
| [Bio-Formats supported formats](https://docs.openmicroscopy.org/bio-formats/6.9.1/supported-formats.html)                              | Example files for Bio-Formats supported formats.                                                                                                                                              |
| [BioImage Informatics Index (BIII) datasets](http://biii.eu/dataset)                 | Mix of datasets and links to other data repositories.                                                                                                                                         |
| [SCIFIO](https://scif.io/images/)                                                     | Example images with CC0 licenses.                                                                                                                                                             |
| [EPFL Super-resolution microscopy datasets](https://srm.epfl.ch/Datasets)                  | Super-resolution microscopy datasets.                                                                                                                                                         |
| [Brain Observatory Storage Service & Database](https://bossdb.org/)               | BossDB is a volumetric database for 3D and 4D neuroscience data, with API access.                                                                                                             |
| [Mouse Brain Atlas](http://mousebrain.org/)                                          | Spatiotranscriptomics data of mouse brain.                                                                                                                                                    |
| [Broad Bioimage Benchmark Collection](https://bbbc.broadinstitute.org/image_sets)                        | Benchmark images with ground truth segmentation.                                                                                                                                              |