-- Copyright (c) 2003, 2019, Oracle and/or its affiliates. All rights reserved.
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License, version 2.0,
-- as published by the Free Software Foundation.
--
-- This program is also distributed with certain software (including
-- but not limited to OpenSSL) that is licensed under separate terms,
-- as designated in a particular file or component or in included license
-- documentation.  The authors of MySQL hereby grant you an additional
-- permission to link the program and your derivative works with the
-- separately licensed software that they have included with MySQL.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License, version 2.0, for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA


-- DO NOT EDIT THIS FILE. It is generated automatically by the MySQL
-- documentation team. If you require changes to the content of this
-- file, contact the documentation team.

-- File generation date: 2019-02-20
-- MySQL series: 8.0
-- Document repository revision: 61006

-- To use this file, load its contents into the mysql database. For example,
-- with the mysql client program, process the file like this, where
-- file_name is the name of this file:

--     mysql -u root -p mysql < file_name

SET sql_log_bin=0;
SET NAMES 'utf8';

TRUNCATE TABLE help_topic;
TRUNCATE TABLE help_category;
TRUNCATE TABLE help_keyword;
TRUNCATE TABLE help_relation;

START TRANSACTION;

INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (1,'Account Management',7,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (2,'Administration',7,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (3,'Bit Functions',14,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (4,'Comparison operators',14,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (5,'Components',7,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (6,'Compound Statements',7,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (7,'Contents',0,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (8,'Control flow functions',14,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (9,'Data Definition',7,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (10,'Data Manipulation',7,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (11,'Data Types',7,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (12,'Date and Time Functions',14,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (13,'Encryption Functions',14,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (14,'Functions',7,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (15,'Functions and Modifiers for Use with GROUP BY',7,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (16,'Geographic',0,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (17,'Geographic Features',7,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (18,'Geometry constructors',17,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (19,'Geometry properties',17,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (20,'Geometry relations',17,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (21,'GeometryCollection properties',16,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (22,'Help Metadata',7,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (23,'Information Functions',14,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (24,'Language Structure',7,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (25,'LineString properties',17,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (26,'Locking Functions',14,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (27,'Logical operators',14,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (28,'MBR',17,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (29,'Miscellaneous Functions',14,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (30,'Numeric Functions',14,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (31,'Plugins',7,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (32,'Point properties',17,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (33,'Polygon properties',17,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (34,'Storage Engines',7,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (35,'String Functions',14,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (36,'Table Maintenance',7,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (37,'Transactions',7,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (38,'User-Defined Functions',7,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (39,'Utility',7,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (40,'WKB',17,'');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (41,'WKT',17,'');

INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (0,27,'!','Syntax:\nNOT, !\n\nLogical NOT. Evaluates to 1 if the operand is 0, to 0 if the operand is\nnonzero, and NOT NULL returns NULL.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/logical-operators.html\n\n','mysql> SELECT NOT 10;\n        -> 0\nmysql> SELECT NOT 0;\n        -> 1\nmysql> SELECT NOT NULL;\n        -> NULL\nmysql> SELECT ! (1+1);\n        -> 0\nmysql> SELECT ! 1+1;\n        -> 1\n','http://dev.mysql.com/doc/refman/8.0/en/logical-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (1,4,'!=','Syntax:\n<>, !=\n\nNot equal:\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html\n\n','mysql> SELECT \'.01\' <> \'0.01\';\n        -> 1\nmysql> SELECT .01 <> \'0.01\';\n        -> 0\nmysql> SELECT \'zapp\' <> \'zappp\';\n        -> 1\n','http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (2,30,'%','Syntax:\nN % M, N MOD M\n\nModulo operation. Returns the remainder of N divided by M. For more\ninformation, see the description for the MOD() function in\nhttp://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/arithmetic-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/arithmetic-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (3,3,'&','Syntax:\n&\n\nBitwise AND.\n\nThe result type depends on whether the arguments are evaluated as\nbinary strings or numbers:\n\no Binary-string evaluation occurs when the arguments have a binary\n  string type, and at least one of them is not a hexadecimal literal,\n  bit literal, or NULL literal. Numeric evaluation occurs otherwise,\n  with argument conversion to unsigned 64-bit integers as necessary.\n\no Binary-string evaluation produces a binary string of the same length\n  as the arguments. If the arguments have unequal lengths, an\n  ER_INVALID_BITWISE_OPERANDS_SIZE error occurs. Numeric evaluation\n  produces an unsigned 64-bit integer.\n\nFor more information, see the introductory discussion in this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/bit-functions.html\n\n','mysql> SELECT 29 & 15;\n        -> 13\nmysql> SELECT HEX(_binary X\'FF\' & b\'11110000\');\n        -> \'F0\'\n','http://dev.mysql.com/doc/refman/8.0/en/bit-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (4,30,'*','Syntax:\n*\n\nMultiplication:\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/arithmetic-functions.html\n\n','mysql> SELECT 3*5;\n        -> 15\nmysql> SELECT 18014398509481984*18014398509481984.0;\n        -> 324518553658426726783156020576256.0\nmysql> SELECT 18014398509481984*18014398509481984;\n        -> out-of-range error\n','http://dev.mysql.com/doc/refman/8.0/en/arithmetic-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (5,30,'+','Syntax:\n+\n\nAddition:\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/arithmetic-functions.html\n\n','mysql> SELECT 3+5;\n        -> 8\n','http://dev.mysql.com/doc/refman/8.0/en/arithmetic-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (6,30,'- BINARY','Syntax:\n-\n\nSubtraction:\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/arithmetic-functions.html\n\n','mysql> SELECT 3-5;\n        -> -2\n','http://dev.mysql.com/doc/refman/8.0/en/arithmetic-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (7,30,'- UNARY','Syntax:\n-\n\nUnary minus. This operator changes the sign of the operand.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/arithmetic-functions.html\n\n','mysql> SELECT - 2;\n        -> -2\n','http://dev.mysql.com/doc/refman/8.0/en/arithmetic-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (8,28,'->','Syntax:\ncolumn->path\n\nThe -> operator serves as an alias for the JSON_EXTRACT() function when\nused with two arguments, a column identifier on the left and a JSON\npath on the right that is evaluated against the JSON document (the\ncolumn value). You can use such expressions in place of column\nidentifiers wherever they occur in SQL statements.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-search-functions.html\n\n','mysql> SELECT c, JSON_EXTRACT(c, "$.id"), g\n     > FROM jemp\n     > WHERE JSON_EXTRACT(c, "$.id") > 1\n     > ORDER BY JSON_EXTRACT(c, "$.name");\n+-------------------------------+-----------+------+\n| c                             | c->"$.id" | g    |\n+-------------------------------+-----------+------+\n| {"id": "3", "name": "Barney"} | "3"       |    3 |\n| {"id": "4", "name": "Betty"}  | "4"       |    4 |\n| {"id": "2", "name": "Wilma"}  | "2"       |    2 |\n+-------------------------------+-----------+------+\n3 rows in set (0.00 sec)\n\nmysql> SELECT c, c->"$.id", g\n     > FROM jemp\n     > WHERE c->"$.id" > 1\n     > ORDER BY c->"$.name";\n+-------------------------------+-----------+------+\n| c                             | c->"$.id" | g    |\n+-------------------------------+-----------+------+\n| {"id": "3", "name": "Barney"} | "3"       |    3 |\n| {"id": "4", "name": "Betty"}  | "4"       |    4 |\n| {"id": "2", "name": "Wilma"}  | "2"       |    2 |\n+-------------------------------+-----------+------+\n3 rows in set (0.00 sec)\n\nmysql> ALTER TABLE jemp ADD COLUMN n INT;\nQuery OK, 0 rows affected (0.68 sec)\nRecords: 0  Duplicates: 0  Warnings: 0\n\nmysql> UPDATE jemp SET n=1 WHERE c->"$.id" = "4";\nQuery OK, 1 row affected (0.04 sec)\nRows matched: 1  Changed: 1  Warnings: 0\n\nmysql> SELECT c, c->"$.id", g, n\n     > FROM jemp\n     > WHERE JSON_EXTRACT(c, "$.id") > 1\n     > ORDER BY c->"$.name";\n+-------------------------------+-----------+------+------+\n| c                             | c->"$.id" | g    | n    |\n+-------------------------------+-----------+------+------+\n| {"id": "3", "name": "Barney"} | "3"       |    3 | NULL |\n| {"id": "4", "name": "Betty"}  | "4"       |    4 |    1 |\n| {"id": "2", "name": "Wilma"}  | "2"       |    2 | NULL |\n+-------------------------------+-----------+------+------+\n3 rows in set (0.00 sec)\n\nmysql> DELETE FROM jemp WHERE c->"$.id" = "4";\nQuery OK, 1 row affected (0.04 sec)\n\nmysql> SELECT c, c->"$.id", g, n\n     > FROM jemp\n     > WHERE JSON_EXTRACT(c, "$.id") > 1\n     > ORDER BY c->"$.name";\n+-------------------------------+-----------+------+------+\n| c                             | c->"$.id" | g    | n    |\n+-------------------------------+-----------+------+------+\n| {"id": "3", "name": "Barney"} | "3"       |    3 | NULL |\n| {"id": "2", "name": "Wilma"}  | "2"       |    2 | NULL |\n+-------------------------------+-----------+------+------+\n2 rows in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/8.0/en/json-search-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (9,28,'->>','Syntax:\ncolumn->>path\n\nThis is an improved, unquoting extraction operator. Whereas the ->\noperator simply extracts a value, the ->> operator in addition unquotes\nthe extracted result. In other words, given a JSON column value column\nand a path expression path, the following three expressions return the\nsame value:\n\no JSON_UNQUOTE( JSON_EXTRACT(column, path) )\n\no JSON_UNQUOTE(column -> path)\n\no column->>path\n\nThe ->> operator can be used wherever JSON_UNQUOTE(JSON_EXTRACT())\nwould be allowed. This includes (but is not limited to) SELECT lists,\nWHERE and HAVING clauses, and ORDER BY and GROUP BY clauses.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-search-functions.html\n\n','mysql> SELECT * FROM jemp WHERE g > 2;\n+-------------------------------+------+\n| c                             | g    |\n+-------------------------------+------+\n| {"id": "3", "name": "Barney"} |    3 |\n| {"id": "4", "name": "Betty"}  |    4 |\n+-------------------------------+------+\n2 rows in set (0.01 sec)\n\nmysql> SELECT c->\'$.name\' AS name\n    ->     FROM jemp WHERE g > 2;\n+----------+\n| name     |\n+----------+\n| "Barney" |\n| "Betty"  |\n+----------+\n2 rows in set (0.00 sec)\n\nmysql> SELECT JSON_UNQUOTE(c->\'$.name\') AS name\n    ->     FROM jemp WHERE g > 2;\n+--------+\n| name   |\n+--------+\n| Barney |\n| Betty  |\n+--------+\n2 rows in set (0.00 sec)\n\nmysql> SELECT c->>\'$.name\' AS name\n    ->     FROM jemp WHERE g > 2;\n+--------+\n| name   |\n+--------+\n| Barney |\n| Betty  |\n+--------+\n2 rows in set (0.00 sec)\n\nmysql> CREATE TABLE tj10 (a JSON, b INT);\nQuery OK, 0 rows affected (0.26 sec)\n\nmysql> INSERT INTO tj10 VALUES\n    ->     (\'[3,10,5,"x",44]\', 33),\n    ->     (\'[3,10,5,17,[22,"y",66]]\', 0);\nQuery OK, 2 rows affected (0.04 sec)\nRecords: 2  Duplicates: 0  Warnings: 0\n\nmysql> SELECT a->"$[3]", a->"$[4][1]" FROM tj10;\n+-----------+--------------+\n| a->"$[3]" | a->"$[4][1]" |\n+-----------+--------------+\n| "x"       | NULL         |\n| 17        | "y"          |\n+-----------+--------------+\n2 rows in set (0.00 sec)\n\nmysql> SELECT a->>"$[3]", a->>"$[4][1]" FROM tj10;\n+------------+---------------+\n| a->>"$[3]" | a->>"$[4][1]" |\n+------------+---------------+\n| x          | NULL          |\n| 17         | y             |\n+------------+---------------+\n2 rows in set (0.00 sec)\n\nmysql> EXPLAIN SELECT c->>\'$.name\' AS name\n    ->     FROM jemp WHERE g > 2\\G\n*************************** 1. row ***************************\n           id: 1\n  select_type: SIMPLE\n        table: jemp\n   partitions: NULL\n         type: range\npossible_keys: i\n          key: i\n      key_len: 5\n          ref: NULL\n         rows: 2\n     filtered: 100.00\n        Extra: Using where\n1 row in set, 1 warning (0.00 sec)\n\nmysql> SHOW WARNINGS\\G\n*************************** 1. row ***************************\n  Level: Note\n   Code: 1003\nMessage: /* select#1 */ select\njson_unquote(json_extract(`jtest`.`jemp`.`c`,\'$.name\')) AS `name` from\n`jtest`.`jemp` where (`jtest`.`jemp`.`g` > 2)\n1 row in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/8.0/en/json-search-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (10,30,'/','Syntax:\n/\n\nDivision:\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/arithmetic-functions.html\n\n','mysql> SELECT 3/5;\n        -> 0.60\n','http://dev.mysql.com/doc/refman/8.0/en/arithmetic-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (11,4,'<','Syntax:\n<\n\nLess than:\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html\n\n','mysql> SELECT 2 < 2;\n        -> 0\n','http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (12,3,'<<','Syntax:\n<<\n\nShifts a longlong (BIGINT) number or binary string to the left.\n\nThe result type depends on whether the bit argument is evaluated as a\nbinary string or number:\n\no Binary-string evaluation occurs when the bit argument has a binary\n  string type, and is not a hexadecimal literal, bit literal, or NULL\n  literal. Numeric evaluation occurs otherwise, with argument\n  conversion to an unsigned 64-bit integer as necessary.\n\no Binary-string evaluation produces a binary string of the same length\n  as the bit argument. Numeric evaluation produces an unsigned 64-bit\n  integer.\n\nBits shifted off the end of the value are lost without warning,\nregardless of the argument type. In particular, if the shift count is\ngreater or equal to the number of bits in the bit argument, all bits in\nthe result are 0.\n\nFor more information, see the introductory discussion in this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/bit-functions.html\n\n','mysql> SELECT 1 << 2;\n        -> 4\nmysql> SELECT HEX(_binary X\'00FF00FF00FF\' << 8);\n        -> \'FF00FF00FF00\'\n','http://dev.mysql.com/doc/refman/8.0/en/bit-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (13,4,'<=','Syntax:\n<=\n\nLess than or equal:\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html\n\n','mysql> SELECT 0.1 <= 2;\n        -> 1\n','http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (14,4,'<=>','Syntax:\n<=>\n\nNULL-safe equal. This operator performs an equality comparison like the\n= operator, but returns 1 rather than NULL if both operands are NULL,\nand 0 rather than NULL if one operand is NULL.\n\nThe <=> operator is equivalent to the standard SQL IS NOT DISTINCT FROM\noperator.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html\n\n','mysql> SELECT 1 <=> 1, NULL <=> NULL, 1 <=> NULL;\n        -> 1, 1, 0\nmysql> SELECT 1 = 1, NULL = NULL, 1 = NULL;\n        -> 1, NULL, NULL\n','http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (15,4,'=','=\n\nEqual:\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html\n\n','mysql> SELECT 1 = 0;\n        -> 0\nmysql> SELECT \'0\' = 0;\n        -> 1\nmysql> SELECT \'0.0\' = 0;\n        -> 1\nmysql> SELECT \'0.01\' = 0;\n        -> 0\nmysql> SELECT \'.01\' = 0.01;\n        -> 1\n','http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (16,4,'>','Syntax:\n>\n\nGreater than:\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html\n\n','mysql> SELECT 2 > 2;\n        -> 0\n','http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (17,4,'>=','Syntax:\n>=\n\nGreater than or equal:\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html\n\n','mysql> SELECT 2 >= 2;\n        -> 1\n','http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (18,3,'>>','Syntax:\n>>\n\nShifts a longlong (BIGINT) number or binary string to the right.\n\nThe result type depends on whether the bit argument is evaluated as a\nbinary string or number:\n\no Binary-string evaluation occurs when the bit argument has a binary\n  string type, and is not a hexadecimal literal, bit literal, or NULL\n  literal. Numeric evaluation occurs otherwise, with argument\n  conversion to an unsigned 64-bit integer as necessary.\n\no Binary-string evaluation produces a binary string of the same length\n  as the bit argument. Numeric evaluation produces an unsigned 64-bit\n  integer.\n\nBits shifted off the end of the value are lost without warning,\nregardless of the argument type. In particular, if the shift count is\ngreater or equal to the number of bits in the bit argument, all bits in\nthe result are 0.\n\nFor more information, see the introductory discussion in this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/bit-functions.html\n\n','mysql> SELECT 4 >> 2;\n        -> 1\nmysql> SELECT HEX(_binary X\'00FF00FF00FF\' >> 8);\n        -> \'0000FF00FF00\'\n','http://dev.mysql.com/doc/refman/8.0/en/bit-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (19,30,'ABS','Syntax:\nABS(X)\n\nReturns the absolute value of X.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT ABS(2);\n        -> 2\nmysql> SELECT ABS(-32);\n        -> 32\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (20,30,'ACOS','Syntax:\nACOS(X)\n\nReturns the arc cosine of X, that is, the value whose cosine is X.\nReturns NULL if X is not in the range -1 to 1.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT ACOS(1);\n        -> 0\nmysql> SELECT ACOS(1.0001);\n        -> NULL\nmysql> SELECT ACOS(0);\n        -> 1.5707963267949\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (21,12,'ADDDATE','Syntax:\nADDDATE(date,INTERVAL expr unit), ADDDATE(expr,days)\n\nWhen invoked with the INTERVAL form of the second argument, ADDDATE()\nis a synonym for DATE_ADD(). The related function SUBDATE() is a\nsynonym for DATE_SUB(). For information on the INTERVAL unit argument,\nsee\nhttp://dev.mysql.com/doc/refman/8.0/en/expressions.html#temporal-interv\nals.\n\nmysql> SELECT DATE_ADD(\'2008-01-02\', INTERVAL 31 DAY);\n        -> \'2008-02-02\'\nmysql> SELECT ADDDATE(\'2008-01-02\', INTERVAL 31 DAY);\n        -> \'2008-02-02\'\n\nWhen invoked with the days form of the second argument, MySQL treats it\nas an integer number of days to be added to expr.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT ADDDATE(\'2008-01-02\', 31);\n        -> \'2008-02-02\'\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (22,12,'ADDTIME','Syntax:\nADDTIME(expr1,expr2)\n\nADDTIME() adds expr2 to expr1 and returns the result. expr1 is a time\nor datetime expression, and expr2 is a time expression.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT ADDTIME(\'2007-12-31 23:59:59.999999\', \'1 1:1:1.000002\');\n        -> \'2008-01-02 01:01:01.000001\'\nmysql> SELECT ADDTIME(\'01:00:00.999999\', \'02:00:00.999998\');\n        -> \'03:00:01.999997\'\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (23,13,'AES_DECRYPT','Syntax:\nAES_DECRYPT(crypt_str,key_str[,init_vector])\n\nThis function decrypts data using the official AES (Advanced Encryption\nStandard) algorithm. For more information, see the description of\nAES_ENCRYPT().\n\nThe optional initialization vector argument, init_vector. Statements\nthat use AES_DECRYPT() are unsafe for statement-based replication.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (24,13,'AES_ENCRYPT','Syntax:\nAES_ENCRYPT(str,key_str[,init_vector])\n\nAES_ENCRYPT() and AES_DECRYPT() implement encryption and decryption of\ndata using the official AES (Advanced Encryption Standard) algorithm,\npreviously known as "Rijndael." The AES standard permits various key\nlengths. By default these functions implement AES with a 128-bit key\nlength. Key lengths of 196 or 256 bits can be used, as described later.\nThe key length is a trade off between performance and security.\n\nAES_ENCRYPT() encrypts the string str using the key string key_str and\nreturns a binary string containing the encrypted output. AES_DECRYPT()\ndecrypts the encrypted string crypt_str using the key string key_str\nand returns the original cleartext string. If either function argument\nis NULL, the function returns NULL.\n\nThe str and crypt_str arguments can be any length, and padding is\nautomatically added to str so it is a multiple of a block as required\nby block-based algorithms such as AES. This padding is automatically\nremoved by the AES_DECRYPT() function. The length of crypt_str can be\ncalculated using this formula:\n\n16 * (trunc(string_length / 16) + 1)\n\nFor a key length of 128 bits, the most secure way to pass a key to the\nkey_str argument is to create a truly random 128-bit value and pass it\nas a binary value. For example:\n\nINSERT INTO t\nVALUES (1,AES_ENCRYPT(\'text\',UNHEX(\'F3229A0B371ED2D9441B830D21A390C3\')));\n\nA passphrase can be used to generate an AES key by hashing the\npassphrase. For example:\n\nINSERT INTO t\nVALUES (1,AES_ENCRYPT(\'text\', UNHEX(SHA2(\'My secret passphrase\',512))));\n\nDo not pass a password or passphrase directly to crypt_str, hash it\nfirst. Previous versions of this documentation suggested the former\napproach, but it is no longer recommended as the examples shown here\nare more secure.\n\nIf AES_DECRYPT() detects invalid data or incorrect padding, it returns\nNULL. However, it is possible for AES_DECRYPT() to return a non-NULL\nvalue (possibly garbage) if the input data or the key is invalid.\n\nAES_ENCRYPT() and AES_DECRYPT() permit control of the block encryption\nmode and take an optional init_vector initialization vector argument:\n\no The block_encryption_mode system variable controls the mode for\n  block-based encryption algorithms. Its default value is aes-128-ecb,\n  which signifies encryption using a key length of 128 bits and ECB\n  mode. For a description of the permitted values of this variable, see\n  http://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html.\n\no The optional init_vector argument provides an initialization vector\n  for block encryption modes that require it.\n\nFor modes that require the optional init_vector argument, it must be 16\nbytes or longer (bytes in excess of 16 are ignored). An error occurs if\ninit_vector is missing.\n\nFor modes that do not require init_vector, it is ignored and a warning\nis generated if it is specified.\n\nA random string of bytes to use for the initialization vector can be\nproduced by calling RANDOM_BYTES(16). For encryption modes that require\nan initialization vector, the same vector must be used for encryption\nand decryption.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html\n\n','mysql> SET block_encryption_mode = \'aes-256-cbc\';\nmysql> SET @key_str = SHA2(\'My secret passphrase\',512);\nmysql> SET @init_vector = RANDOM_BYTES(16);\nmysql> SET @crypt_str = AES_ENCRYPT(\'text\',@key_str,@init_vector);\nmysql> SELECT AES_DECRYPT(@crypt_str,@key_str,@init_vector);\n+-----------------------------------------------+\n| AES_DECRYPT(@crypt_str,@key_str,@init_vector) |\n+-----------------------------------------------+\n| text                                          |\n+-----------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (25,9,'ALTER DATABASE','Syntax:\nALTER {DATABASE | SCHEMA} [db_name]\n    alter_specification ...\n\nalter_specification:\n    [DEFAULT] CHARACTER SET [=] charset_name\n  | [DEFAULT] COLLATE [=] collation_name\n\nALTER DATABASE enables you to change the overall characteristics of a\ndatabase. These characteristics are stored in the data dictionary. To\nuse ALTER DATABASE, you need the ALTER privilege on the database. ALTER\nSCHEMA is a synonym for ALTER DATABASE.\n\nThe database name can be omitted from the first syntax, in which case\nthe statement applies to the default database.\n\nNational Language Characteristics\n\nThe CHARACTER SET clause changes the default database character set.\nThe COLLATE clause changes the default database collation.\nhttp://dev.mysql.com/doc/refman/8.0/en/charset.html, discusses\ncharacter set and collation names.\n\nYou can see what character sets and collations are available using,\nrespectively, the SHOW CHARACTER SET and SHOW COLLATION statements. See\n[HELP SHOW CHARACTER SET], and [HELP SHOW COLLATION], for more\ninformation.\n\nIf you change the default character set or collation for a database,\nstored routines that use the database defaults must be dropped and\nrecreated so that they use the new defaults. (In a stored routine,\nvariables with character data types use the database defaults if the\ncharacter set or collation are not specified explicitly. See [HELP\nCREATE PROCEDURE].)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/alter-database.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/alter-database.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (26,9,'ALTER EVENT','Syntax:\nALTER\n    [DEFINER = { user | CURRENT_USER }]\n    EVENT event_name\n    [ON SCHEDULE schedule]\n    [ON COMPLETION [NOT] PRESERVE]\n    [RENAME TO new_event_name]\n    [ENABLE | DISABLE | DISABLE ON SLAVE]\n    [COMMENT \'string\']\n    [DO event_body]\n\nThe ALTER EVENT statement changes one or more of the characteristics of\nan existing event without the need to drop and recreate it. The syntax\nfor each of the DEFINER, ON SCHEDULE, ON COMPLETION, COMMENT, ENABLE /\nDISABLE, and DO clauses is exactly the same as when used with CREATE\nEVENT. (See [HELP CREATE EVENT].)\n\nAny user can alter an event defined on a database for which that user\nhas the EVENT privilege. When a user executes a successful ALTER EVENT\nstatement, that user becomes the definer for the affected event.\n\nALTER EVENT works only with an existing event:\n\nmysql> ALTER EVENT no_such_event \n     >     ON SCHEDULE \n     >       EVERY \'2:3\' DAY_HOUR;\nERROR 1517 (HY000): Unknown event \'no_such_event\'\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/alter-event.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/alter-event.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (27,9,'ALTER FUNCTION','Syntax:\nALTER FUNCTION func_name [characteristic ...]\n\ncharacteristic:\n    COMMENT \'string\'\n  | LANGUAGE SQL\n  | { CONTAINS SQL | NO SQL | READS SQL DATA | MODIFIES SQL DATA }\n  | SQL SECURITY { DEFINER | INVOKER }\n\nThis statement can be used to change the characteristics of a stored\nfunction. More than one change may be specified in an ALTER FUNCTION\nstatement. However, you cannot change the parameters or body of a\nstored function using this statement; to make such changes, you must\ndrop and re-create the function using DROP FUNCTION and CREATE\nFUNCTION.\n\nYou must have the ALTER ROUTINE privilege for the function. (That\nprivilege is granted automatically to the function creator.) If binary\nlogging is enabled, the ALTER FUNCTION statement might also require the\nSUPER privilege, as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/stored-programs-logging.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/alter-function.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/alter-function.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (28,9,'ALTER INSTANCE','Syntax:\nALTER INSTANCE instance_action\n\ninstance_action: {\n    ROTATE INNODB MASTER KEY\n  | RELOAD TLS [NO ROLLBACK ON ERROR]\n}\n\nALTER INSTANCE defines actions applicable to a MySQL server instance.\nThe statement supports these actions:\n\no ALTER INSTANCE ROTATE INNODB MASTER KEY\n\n  This action rotates the master encryption key used for InnoDB\n  tablespace encryption. Key rotation requires the ENCRYPTION_KEY_ADMIN\n  or SUPER privilege. To perform this action, a keyring plugin must be\n  installed and configured. For instructions, see\n  http://dev.mysql.com/doc/refman/8.0/en/keyring.html.\n\n  ALTER INSTANCE ROTATE INNODB MASTER KEY supports concurrent DML.\n  However, it cannot be run concurrently with CREATE TABLE ...\n  ENCRYPTION or ALTER TABLE ... ENCRYPTION operations, and locks are\n  taken to prevent conflicts that could arise from concurrent execution\n  of these statements. If one of the conflicting statements is running,\n  it must complete before another can proceed.\n\n  ALTER INSTANCE ROTATE INNODB MASTER KEY statements are written to the\n  binary log so that they can be executed on replicated servers.\n\n  For additional ALTER INSTANCE ROTATE INNODB MASTER KEY usage\n  information, see\n  http://dev.mysql.com/doc/refman/8.0/en/innodb-tablespace-encryption.h\n  tml.\n\no ALTER INSTANCE RELOAD TLS\n\n  This action reconfigures the SSL context from the current values of\n  the system variables that define the context. It also updates the\n  status variables that reflect the active context values. This action\n  requires the CONNECTION_ADMIN privilege.\n\n  By default, the RELOAD TLS action rolls back with an error and has no\n  effect if the configuration values do not permit creation of a new\n  SSL context. The previous context values continue to be used for new\n  connections.\n\n  If the optional NO ROLLBACK ON ERROR clause is given and a new\n  context cannot be created, rollback does not occur. Instead, a\n  warning is generated and SSL is disabled for new connections.\n\n  ALTER INSTANCE RELOAD TLS statements are not written to the binary\n  log (and thus are not replicated). SSL configuration is local and\n  depends on local files not necessarily present on all servers\n  involved.\n\n  For additional information about reconfiguring the SSL context,\n  including which system and status variables are context-related, see\n  http://dev.mysql.com/doc/refman/8.0/en/using-encrypted-connections.ht\n  ml#using-encrypted-connections-server-side-runtime-configuration.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/alter-instance.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/alter-instance.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (29,9,'ALTER LOGFILE GROUP','Syntax:\nALTER LOGFILE GROUP logfile_group\n    ADD UNDOFILE \'file_name\'\n    [INITIAL_SIZE [=] size]\n    [WAIT]\n    ENGINE [=] engine_name\n\nThis statement adds an UNDO file named \'file_name\' to an existing log\nfile group logfile_group. An ALTER LOGFILE GROUP statement has one and\nonly one ADD UNDOFILE clause. No DROP UNDOFILE clause is currently\nsupported.\n\n*Note*:\n\nAll NDB Cluster Disk Data objects share the same namespace. This means\nthat each Disk Data object must be uniquely named (and not merely each\nDisk Data object of a given type). For example, you cannot have a\ntablespace and an undo log file with the same name, or an undo log file\nand a data file with the same name.\n\nThe optional INITIAL_SIZE parameter sets the UNDO file\'s initial size\nin bytes; if not specified, the initial size defaults to 134217728 (128\nMB). You may optionally follow size with a one-letter abbreviation for\nan order of magnitude, similar to those used in my.cnf. Generally, this\nis one of the letters M (megabytes) or G (gigabytes). (Bug #13116514,\nBug #16104705, Bug #62858)\n\nOn 32-bit systems, the maximum supported value for INITIAL_SIZE is\n4294967296 (4 GB). (Bug #29186)\n\nThe minimum allowed value for INITIAL_SIZE is 1048576 (1 MB). (Bug\n#29574)\n\n*Note*:\n\nWAIT is parsed but otherwise ignored. This keyword currently has no\neffect, and is intended for future expansion.\n\nThe ENGINE parameter (required) determines the storage engine which is\nused by this log file group, with engine_name being the name of the\nstorage engine. Currently, the only accepted values for engine_name are\n"NDBCLUSTER" and "NDB". The two values are equivalent.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/alter-logfile-group.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/alter-logfile-group.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (30,9,'ALTER PROCEDURE','Syntax:\nALTER PROCEDURE proc_name [characteristic ...]\n\ncharacteristic:\n    COMMENT \'string\'\n  | LANGUAGE SQL\n  | { CONTAINS SQL | NO SQL | READS SQL DATA | MODIFIES SQL DATA }\n  | SQL SECURITY { DEFINER | INVOKER }\n\nThis statement can be used to change the characteristics of a stored\nprocedure. More than one change may be specified in an ALTER PROCEDURE\nstatement. However, you cannot change the parameters or body of a\nstored procedure using this statement; to make such changes, you must\ndrop and re-create the procedure using DROP PROCEDURE and CREATE\nPROCEDURE.\n\nYou must have the ALTER ROUTINE privilege for the procedure. By\ndefault, that privilege is granted automatically to the procedure\ncreator. This behavior can be changed by disabling the\nautomatic_sp_privileges system variable. See\nhttp://dev.mysql.com/doc/refman/8.0/en/stored-routines-privileges.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/alter-procedure.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/alter-procedure.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (31,1,'ALTER RESOURCE GROUP','Syntax:\nALTER RESOURCE GROUP group_name\n    [VCPU [=] vcpu_spec [, vcpu_spec] ...]\n    [THREAD_PRIORITY [=] N]\n    [ENABLE|DISABLE [FORCE]]\n\nvcpu_spec: {N | M - N}\n\nALTER RESOURCE GROUP is used for resource group management (see\nhttp://dev.mysql.com/doc/refman/8.0/en/resource-groups.html). This\nstatement alters modifiable attributes of an existing resource group.\nIt requires the RESOURCE_GROUP_ADMIN privilege.\n\ngroup_name identifies which resource group to alter. If the group does\nnot exist, an error occurs.\n\nThe attributes for CPU affinity, priority, and whether the group is\nenabled can be modified with ALTER RESOURCE GROUP. These attributes are\nspecified the same way as described for CREATE RESOURCE GROUP (see\n[HELP CREATE RESOURCE GROUP]). Only the attributes specified are\naltered. Unspecified attributes retain their current values.\n\nThe FORCE modifier is used with DISABLE. It determines statement\nbehavior if the resource group has any threads assigned to it:\n\no If FORCE is not given, existing threads in the group continue to run\n  until they terminate, but new threads cannot be assigned to the\n  group.\n\no If FORCE is given, existing threads in the group are moved to their\n  respective default group (system threads to SYS_default, user threads\n  to USR_default).\n\nThe name and type attributes are set at group creation time and cannot\nbe modified thereafter with ALTER RESOURCE GROUP.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/alter-resource-group.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/alter-resource-group.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (32,9,'ALTER SERVER','Syntax:\nALTER SERVER  server_name\n    OPTIONS (option [, option] ...)\n\nAlters the server information for server_name, adjusting any of the\noptions permitted in the CREATE SERVER statement. The corresponding\nfields in the mysql.servers table are updated accordingly. This\nstatement requires the SUPER privilege.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/alter-server.html\n\n','ALTER SERVER s OPTIONS (USER \'sally\');\n','http://dev.mysql.com/doc/refman/8.0/en/alter-server.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (33,9,'ALTER TABLE','Syntax:\nALTER TABLE tbl_name\n    [alter_specification [, alter_specification] ...]\n    [partition_options]\n\nalter_specification:\n    table_options\n  | ADD [COLUMN] col_name column_definition\n        [FIRST | AFTER col_name]\n  | ADD [COLUMN] (col_name column_definition,...)\n  | ADD {INDEX|KEY} [index_name]\n        [index_type] (key_part,...) [index_option] ...\n  | ADD {FULLTEXT|SPATIAL} [INDEX|KEY] [index_name]\n        (key_part,...) [index_option] ...\n  | ADD [CONSTRAINT [symbol]] PRIMARY KEY\n        [index_type] (key_part,...)\n        [index_option] ...\n  | ADD [CONSTRAINT [symbol]] UNIQUE [INDEX|KEY]\n        [index_name] [index_type] (key_part,...)\n        [index_option] ...\n  | ADD [CONSTRAINT [symbol]] FOREIGN KEY\n        [index_name] (col_name,...)\n        reference_definition\n  | ADD check_constraint_definition\n  | DROP CHECK symbol\n  | ALTER CHECK symbol [NOT] ENFORCED\n  | ALGORITHM [=] {DEFAULT|INSTANT|INPLACE|COPY}\n  | ALTER [COLUMN] col_name {SET DEFAULT literal | DROP DEFAULT}\n  | ALTER INDEX index_name {VISIBLE | INVISIBLE}\n  | CHANGE [COLUMN] old_col_name new_col_name column_definition\n        [FIRST|AFTER col_name]\n  | [DEFAULT] CHARACTER SET [=] charset_name [COLLATE [=] collation_name]\n  | CONVERT TO CHARACTER SET charset_name [COLLATE collation_name]\n  | {DISABLE|ENABLE} KEYS\n  | {DISCARD|IMPORT} TABLESPACE\n  | DROP [COLUMN] col_name\n  | DROP {INDEX|KEY} index_name\n  | DROP PRIMARY KEY\n  | DROP FOREIGN KEY fk_symbol\n  | FORCE\n  | LOCK [=] {DEFAULT|NONE|SHARED|EXCLUSIVE}\n  | MODIFY [COLUMN] col_name column_definition\n        [FIRST | AFTER col_name]\n  | ORDER BY col_name [, col_name] ...\n  | RENAME COLUMN old_col_name TO new_col_name\n  | RENAME {INDEX|KEY} old_index_name TO new_index_name\n  | RENAME [TO|AS] new_tbl_name\n  | {WITHOUT|WITH} VALIDATION\n  | ADD PARTITION (partition_definition)\n  | DROP PARTITION partition_names\n  | DISCARD PARTITION {partition_names | ALL} TABLESPACE\n  | IMPORT PARTITION {partition_names | ALL} TABLESPACE\n  | TRUNCATE PARTITION {partition_names | ALL}\n  | COALESCE PARTITION number\n  | REORGANIZE PARTITION partition_names INTO (partition_definitions)\n  | EXCHANGE PARTITION partition_name WITH TABLE tbl_name [{WITH|WITHOUT} VALIDATION]\n  | ANALYZE PARTITION {partition_names | ALL}\n  | CHECK PARTITION {partition_names | ALL}\n  | OPTIMIZE PARTITION {partition_names | ALL}\n  | REBUILD PARTITION {partition_names | ALL}\n  | REPAIR PARTITION {partition_names | ALL}\n  | REMOVE PARTITIONING\n  | UPGRADE PARTITIONING\n\nkey_part: {col_name [(length)] | (expr)} [ASC | DESC]\n\nindex_type:\n    USING {BTREE | HASH}\n\nindex_option:\n    KEY_BLOCK_SIZE [=] value\n  | index_type\n  | WITH PARSER parser_name\n  | COMMENT \'string\'\n  | {VISIBLE | INVISIBLE}\n\ncheck_constraint_definition:\n    [CONSTRAINT [symbol]] CHECK (expr) [[NOT] ENFORCED]\n\ntable_options:\n    table_option [[,] table_option] ...\n\ntable_option:\n    AUTO_INCREMENT [=] value\n  | AVG_ROW_LENGTH [=] value\n  | [DEFAULT] CHARACTER SET [=] charset_name\n  | CHECKSUM [=] {0 | 1}\n  | [DEFAULT] COLLATE [=] collation_name\n  | COMMENT [=] \'string\'\n  | COMPRESSION [=] {\'ZLIB\'|\'LZ4\'|\'NONE\'}\n  | CONNECTION [=] \'connect_string\'\n  | {DATA|INDEX} DIRECTORY [=] \'absolute path to directory\'\n  | DELAY_KEY_WRITE [=] {0 | 1}\n  | ENCRYPTION [=] {\'Y\' | \'N\'}\n  | ENGINE [=] engine_name\n  | INSERT_METHOD [=] { NO | FIRST | LAST }\n  | KEY_BLOCK_SIZE [=] value\n  | MAX_ROWS [=] value\n  | MIN_ROWS [=] value\n  | PACK_KEYS [=] {0 | 1 | DEFAULT}\n  | PASSWORD [=] \'string\'\n  | ROW_FORMAT [=] {DEFAULT|DYNAMIC|FIXED|COMPRESSED|REDUNDANT|COMPACT}\n  | STATS_AUTO_RECALC [=] {DEFAULT|0|1}\n  | STATS_PERSISTENT [=] {DEFAULT|0|1}\n  | STATS_SAMPLE_PAGES [=] value\n  | TABLESPACE tablespace_name [STORAGE {DISK|MEMORY|DEFAULT}]\n  | UNION [=] (tbl_name[,tbl_name]...)\n\npartition_options:\n    (see CREATE TABLE options)\n\nALTER TABLE changes the structure of a table. For example, you can add\nor delete columns, create or destroy indexes, change the type of\nexisting columns, or rename columns or the table itself. You can also\nchange characteristics such as the storage engine used for the table or\nthe table comment.\n\no To use ALTER TABLE, you need ALTER, CREATE, and INSERT privileges for\n  the table. Renaming a table requires ALTER and DROP on the old table,\n  ALTER, CREATE, and INSERT on the new table.\n\no Following the table name, specify the alterations to be made. If none\n  are given, ALTER TABLE does nothing.\n\no The syntax for many of the permissible alterations is similar to\n  clauses of the CREATE TABLE statement. column_definition clauses use\n  the same syntax for ADD and CHANGE as for CREATE TABLE. For more\n  information, see [HELP CREATE TABLE].\n\no The word COLUMN is optional and can be omitted, except for RENAME\n  COLUMN (to distinguish a column-renaming operation from the RENAME\n  table-renaming operation).\n\no Multiple ADD, ALTER, DROP, and CHANGE clauses are permitted in a\n  single ALTER TABLE statement, separated by commas. This is a MySQL\n  extension to standard SQL, which permits only one of each clause per\n  ALTER TABLE statement. For example, to drop multiple columns in a\n  single statement, do this:\n\nALTER TABLE t2 DROP COLUMN c, DROP COLUMN d;\n\no If a storage engine does not support an attempted ALTER TABLE\n  operation, a warning may result. Such warnings can be displayed with\n  SHOW WARNINGS. See [HELP SHOW WARNINGS]. For information on\n  troubleshooting ALTER TABLE, see\n  http://dev.mysql.com/doc/refman/8.0/en/alter-table-problems.html.\n\no For information about generated columns, see\n  http://dev.mysql.com/doc/refman/8.0/en/alter-table-generated-columns.\n  html.\n\no For usage examples, see\n  http://dev.mysql.com/doc/refman/8.0/en/alter-table-examples.html.\n\no With the mysql_info() C API function, you can find out how many rows\n  were copied by ALTER TABLE. See\n  http://dev.mysql.com/doc/refman/8.0/en/mysql-info.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/alter-table.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/alter-table.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (34,9,'ALTER TABLESPACE','Syntax:\nALTER [UNDO] TABLESPACE tablespace_name\n  NDB only:  \n    {ADD|DROP} DATAFILE \'file_name\'\n    [INITIAL_SIZE [=] size]\n    [WAIT]\n  InnoDB and NDB:\n    [RENAME TO tablespace_name] \n  InnoDB only:\n    [SET {ACTIVE|INACTIVE}]\n    [ENCRYPTION [=] {\'Y\' | \'N\'}]\n  InnoDB and NDB:\n    [ENGINE [=] engine_name]\n\nThis statement is used with NDB and InnoDB tablespaces. It can be used\nto add a new data file to, or to drop a data file from an NDB\ntablespace. It can also be used to rename an NDB Cluster Disk Data\ntablespace, rename an InnoDB general tablespace, encrypt an InnoDB\ngeneral tablespace, or mark an InnoDB undo tablespace as active or\ninactive.\n\nThe UNDO keyword, introduced in MySQL 8.0.14, is used with the SET\n{ACTIVE|INACTIVE} clause to mark an InnoDB undo tablespace as active or\ninactive. For more information, see\nhttp://dev.mysql.com/doc/refman/8.0/en/innodb-undo-tablespaces.html.\n\nThe ADD DATAFILE variant enables you to specify an initial size for an\nNDB Disk Data tablespace using an INITIAL_SIZE clause, where size is\nmeasured in bytes; the default value is 134217728 (128 MB). You may\noptionally follow size with a one-letter abbreviation for an order of\nmagnitude, similar to those used in my.cnf. Generally, this is one of\nthe letters M (megabytes) or G (gigabytes).\n\nOn 32-bit systems, the maximum supported value for INITIAL_SIZE is\n4294967296 (4 GB). (Bug #29186)\n\nINITIAL_SIZE is rounded, explicitly, as for CREATE TABLESPACE.\n\nOnce a data file has been created, its size cannot be changed; however,\nyou can add more data files to an NDB tablespace using additional ALTER\nTABLESPACE ... ADD DATAFILE statements.\n\nWhen ALTER TABLESPACE ... ADD DATAFILE is used with ENGINE = NDB, a\ndata file is created on each Cluster data node, but only one row is\ngenerated in the INFORMATION_SCHEMA.FILES table. See the description of\nthis table, as well as\nhttp://dev.mysql.com/doc/refman/8.0/en/mysql-cluster-disk-data-objects.\nhtml, for more information. ADD DATAFILE is not supported with InnoDB\ntablespaces.\n\nUsing DROP DATAFILE with ALTER TABLESPACE drops the data file\n\'file_name\' from an NDB tablespace. You cannot drop a data file from a\ntablespace which is in use by any table; in other words, the data file\nmust be empty (no extents used). See\nhttp://dev.mysql.com/doc/refman/8.0/en/mysql-cluster-disk-data-objects.\nhtml. In addition, any data file to be dropped must previously have\nbeen added to the tablespace with CREATE TABLESPACE or ALTER\nTABLESPACE. DROP DATAFILE is not supported with InnoDB tablespaces.\n\nWAIT is parsed but otherwise ignored. It is intended for future\nexpansion.\n\nThe ENGINE clause, which specifies the storage engine used by the\ntablespace, is deprecated and will be removed in a future release. The\ntablespace storage engine is known by the data dictionary, making the\nENGINE clause obsolete. If the storage engine is specified, it must\nmatch the tablespace storage engine defined in the data dictionary. The\nonly values for engine_name compatible with NDB tablespaces are NDB and\nNDBCLUSTER.\n\nRENAME TO operations are implicitly performed in autocommit mode,\nregardless of the autocommit setting.\n\nA RENAME TO operation cannot be performed while LOCK TABLES or FLUSH\nTABLES WITH READ LOCK is in effect for tables that reside in the\ntablespace.\n\nExclusive metadata locks are taken on tables that reside in a general\ntablespace while the tablespace is renamed, which prevents concurrent\nDDL. Concurrent DML is supported.\n\nThe CREATE TABLESPACE privilege is required to rename an InnoDB general\ntablespace.\n\nThe ENCRYPTION option is used to enable or disable page-level data\nencryption for an InnoDB general tablespace or the mysql system\ntablespace. Option values are not case-sensitive. Encryption support\nfor general tablespaces was introduced in MySQL 8.0.13. Encryption\nsupport for the mysql system tablespace is available as of MySQL\n8.0.16. A keyring plugin must be installed and configured to encrypt a\ntablespace using the ENCRYPTION option.\n\nWhen a general tablespace or the mysql system tablespace is encrypted,\nall tables residing in the tablespace are encrypted. Likewise, a table\ncreated in an encrypted tablespace is encrypted.\n\nThe INPLACE algorithm is used when altering the ENCRYPTION attribute of\na general tablespace or the mysql system tablespace. The INPLACE\nalgorithm permits concurrent DML on tables that reside in the\ntablespace. Concurrent DDL is blocked.\n\nFor more information, see\nhttp://dev.mysql.com/doc/refman/8.0/en/innodb-tablespace-encryption.htm\nl.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/alter-tablespace.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/alter-tablespace.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (35,1,'ALTER USER','Syntax:\nALTER USER [IF EXISTS]\n    user [auth_option] [, user [auth_option]] ...\n    [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n    [WITH resource_option [resource_option] ...]\n    [password_option | lock_option] ...\n\nALTER USER [IF EXISTS] USER() user_func_auth_option\n\nALTER USER [IF EXISTS]\n    user DEFAULT ROLE\n    {NONE | ALL | role [, role ] ...}\n\nuser:\n    (see )\n\nauth_option: {\n    IDENTIFIED BY \'auth_string\'\n        [REPLACE \'current_auth_string\']\n        [RETAIN CURRENT PASSWORD]\n  | IDENTIFIED WITH auth_plugin\n  | IDENTIFIED WITH auth_plugin BY \'auth_string\'\n        [REPLACE \'current_auth_string\']\n        [RETAIN CURRENT PASSWORD]\n  | IDENTIFIED WITH auth_plugin AS \'hash_string\'\n  | DISCARD OLD PASSWORD\n}\n\nuser_func_auth_option: {\n    IDENTIFIED BY \'auth_string\'\n        [REPLACE \'current_auth_string\']\n        [RETAIN CURRENT PASSWORD]\n  | DISCARD OLD PASSWORD\n}\n\ntls_option: {\n   SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n}\n\nresource_option: {\n    MAX_QUERIES_PER_HOUR count\n  | MAX_UPDATES_PER_HOUR count\n  | MAX_CONNECTIONS_PER_HOUR count\n  | MAX_USER_CONNECTIONS count\n}\n\npassword_option: {\n    PASSWORD EXPIRE [DEFAULT | NEVER | INTERVAL N DAY]\n  | PASSWORD HISTORY {DEFAULT | N}\n  | PASSWORD REUSE INTERVAL {DEFAULT | N DAY}\n  | PASSWORD REQUIRE CURRENT [DEFAULT | OPTIONAL]\n}\n\nlock_option: {\n    ACCOUNT LOCK\n  | ACCOUNT UNLOCK\n}\n\nThe ALTER USER statement modifies MySQL accounts. It enables\nauthentication, role, SSL/TLS, resource-limit, and password-management\nproperties to be modified for existing accounts. It can also be used to\nlock and unlock accounts.\n\nIn most cases, ALTER USER requires the global CREATE USER privilege, or\nthe UPDATE privilege for the mysql system database. The exceptions are:\n\no Any client who connects to the server using a nonanonymous account\n  can change the password for that account. (In particular, you can\n  change your own password.) To see which account the server\n  authenticated you as, invoke the CURRENT_USER() function:\n\nSELECT CURRENT_USER();\n\no For DEFAULT ROLE syntax, ALTER USER requires these privileges:\n\n  o Setting the default roles for another user requires the global\n    CREATE USER privilege, or the UPDATE privilege for the\n    mysql.default_roles system table.\n\n  o Setting the default roles for yourself requires no special\n    privileges, as long as the roles you want as the default have been\n    granted to you.\n\no Statements that modify secondary passwords require these privileges:\n\n  o The APPLICATION_PASSWORD_ADMIN privilege is required to use the\n    RETAIN CURRENT PASSWORD or DISCARD OLD PASSWORD clause for ALTER\n    USER statements that apply to your own account. The privilege is\n    required to manipulate your own secondary password because most\n    users require only one password.\n\n  o If an account is to be permitted to manipulate secondary passwords\n    for all accounts, it should be granted the CREATE USER privilege\n    rather than APPLICATION_PASSWORD_ADMIN.\n\nWhen the read_only system variable is enabled, ALTER USER additionally\nrequires the CONNECTION_ADMIN or SUPER privilege.\n\nBy default, an error occurs if you try to modify a user that does not\nexist. If the IF EXISTS clause is given, the statement produces a\nwarning for each named user that does not exist, rather than an error.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/alter-user.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/alter-user.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (36,9,'ALTER VIEW','Syntax:\nALTER\n    [ALGORITHM = {UNDEFINED | MERGE | TEMPTABLE}]\n    [DEFINER = { user | CURRENT_USER }]\n    [SQL SECURITY { DEFINER | INVOKER }]\n    VIEW view_name [(column_list)]\n    AS select_statement\n    [WITH [CASCADED | LOCAL] CHECK OPTION]\n\nThis statement changes the definition of a view, which must exist. The\nsyntax is similar to that for CREATE VIEW see [HELP CREATE VIEW]). This\nstatement requires the CREATE VIEW and DROP privileges for the view,\nand some privilege for each column referred to in the SELECT statement.\nALTER VIEW is permitted only to the definer or users with the\nSET_USER_ID or SUPER privilege.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/alter-view.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/alter-view.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (37,36,'ANALYZE TABLE','Syntax:\nANALYZE [NO_WRITE_TO_BINLOG | LOCAL]\n    TABLE tbl_name [, tbl_name] ...\n\nANALYZE [NO_WRITE_TO_BINLOG | LOCAL]\n    TABLE tbl_name\n    UPDATE HISTOGRAM ON col_name [, col_name] ...\n        [WITH N BUCKETS]\n\nANALYZE [NO_WRITE_TO_BINLOG | LOCAL]\n    TABLE tbl_name\n    DROP HISTOGRAM ON col_name [, col_name] ...\n\nANALYZE TABLE generates table statistics:\n\no ANALYZE TABLE without either HISTOGRAM clause performs a key\n  distribution analysis and stores the distribution for the named table\n  or tables. For MyISAM tables, ANALYZE TABLE for key distribution\n  analysis is equivalent to using myisamchk --analyze.\n\no ANALYZE TABLE with the UPDATE HISTOGRAM clause generates histogram\n  statistics for the named table columns and stores them in the data\n  dictionary. Only one table name is permitted for this syntax.\n\no ANALYZE TABLE with the DROP HISTOGRAM clause removes histogram\n  statistics for the named table columns from the data dictionary. Only\n  one table name is permitted for this syntax.\n\n*Note*:\n\nIf the innodb_read_only system variable is enabled, ANALYZE TABLE may\nfail because it cannot update statistics tables in the data dictionary,\nwhich use InnoDB. For ANALYZE TABLE operations that update the key\ndistribution, failure may occur even if the operation updates the table\nitself (for example, if it is a MyISAM table). To obtain the updated\ndistribution statistics, set information_schema_stats_expiry=0.\n\nThis statement requires SELECT and INSERT privileges for the table.\n\nANALYZE TABLE works with InnoDB, NDB, and MyISAM tables. It does not\nwork with views.\n\nANALYZE TABLE is supported for partitioned tables, and you can use\nALTER TABLE ... ANALYZE PARTITION to analyze one or more partitions;\nfor more information, see [HELP ALTER TABLE], and\nhttp://dev.mysql.com/doc/refman/8.0/en/partitioning-maintenance.html.\n\nDuring the analysis, the table is locked with a read lock for InnoDB\nand MyISAM.\n\nBy default, the server writes ANALYZE TABLE statements to the binary\nlog so that they replicate to replication slaves. To suppress logging,\nspecify the optional NO_WRITE_TO_BINLOG keyword or its alias LOCAL.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/analyze-table.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/analyze-table.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (38,27,'AND','Syntax:\nAND, &&\n\nLogical AND. Evaluates to 1 if all operands are nonzero and not NULL,\nto 0 if one or more operands are 0, otherwise NULL is returned.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/logical-operators.html\n\n','mysql> SELECT 1 AND 1;\n        -> 1\nmysql> SELECT 1 AND 0;\n        -> 0\nmysql> SELECT 1 AND NULL;\n        -> NULL\nmysql> SELECT 0 AND NULL;\n        -> 0\nmysql> SELECT NULL AND 0;\n        -> 0\n','http://dev.mysql.com/doc/refman/8.0/en/logical-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (39,29,'ANY_VALUE','ANY_VALUE(arg)\n\nThis function is useful for GROUP BY queries when the\nONLY_FULL_GROUP_BY SQL mode is enabled, for cases when MySQL rejects a\nquery that you know is valid for reasons that MySQL cannot determine.\nThe function return value and type are the same as the return value and\ntype of its argument, but the function result is not checked for the\nONLY_FULL_GROUP_BY SQL mode.\n\nFor example, if name is a nonindexed column, the following query fails\nwith ONLY_FULL_GROUP_BY enabled:\n\nmysql> SELECT name, address, MAX(age) FROM t GROUP BY name;\nERROR 1055 (42000): Expression #2 of SELECT list is not in GROUP\nBY clause and contains nonaggregated column \'mydb.t.address\' which\nis not functionally dependent on columns in GROUP BY clause; this\nis incompatible with sql_mode=only_full_group_by\n\nThe failure occurs because address is a nonaggregated column that is\nneither named among GROUP BY columns nor functionally dependent on\nthem. As a result, the address value for rows within each name group is\nnondeterministic. There are multiple ways to cause MySQL to accept the\nquery:\n\no Alter the table to make name a primary key or a unique NOT NULL\n  column. This enables MySQL to determine that address is functionally\n  dependent on name; that is, address is uniquely determined by name.\n  (This technique is inapplicable if NULL must be permitted as a valid\n  name value.)\n\no Use ANY_VALUE() to refer to address:\n\nSELECT name, ANY_VALUE(address), MAX(age) FROM t GROUP BY name;\n\n  In this case, MySQL ignores the nondeterminism of address values\n  within each name group and accepts the query. This may be useful if\n  you simply do not care which value of a nonaggregated column is\n  chosen for each group. ANY_VALUE() is not an aggregate function,\n  unlike functions such as SUM() or COUNT(). It simply acts to suppress\n  the test for nondeterminism.\n\no Disable ONLY_FULL_GROUP_BY. This is equivalent to using ANY_VALUE()\n  with ONLY_FULL_GROUP_BY enabled, as described in the previous item.\n\nANY_VALUE() is also useful if functional dependence exists between\ncolumns but MySQL cannot determine it. The following query is valid\nbecause age is functionally dependent on the grouping column age-1, but\nMySQL cannot tell that and rejects the query with ONLY_FULL_GROUP_BY\nenabled:\n\nSELECT age FROM t GROUP BY age-1;\n\nTo cause MySQL to accept the query, use ANY_VALUE():\n\nSELECT ANY_VALUE(age) FROM t GROUP BY age-1;\n\nANY_VALUE() can be used for queries that refer to aggregate functions\nin the absence of a GROUP BY clause:\n\nmysql> SELECT name, MAX(age) FROM t;\nERROR 1140 (42000): In aggregated query without GROUP BY, expression\n#1 of SELECT list contains nonaggregated column \'mydb.t.name\'; this\nis incompatible with sql_mode=only_full_group_by\n\nWithout GROUP BY, there is a single group and it is nondeterministic\nwhich name value to choose for the group. ANY_VALUE() tells MySQL to\naccept the query:\n\nSELECT ANY_VALUE(name), MAX(age) FROM t;\n\nIt may be that, due to some property of a given data set, you know that\na selected nonaggregated column is effectively functionally dependent\non a GROUP BY column. For example, an application may enforce\nuniqueness of one column with respect to another. In this case, using\nANY_VALUE() for the effectively functionally dependent column may make\nsense.\n\nFor additional discussion, see\nhttp://dev.mysql.com/doc/refman/8.0/en/group-by-handling.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (40,35,'ASCII','Syntax:\nASCII(str)\n\nReturns the numeric value of the leftmost character of the string str.\nReturns 0 if str is the empty string. Returns NULL if str is NULL.\nASCII() works for 8-bit characters.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT ASCII(\'2\');\n        -> 50\nmysql> SELECT ASCII(2);\n        -> 50\nmysql> SELECT ASCII(\'dx\');\n        -> 100\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (41,30,'ASIN','Syntax:\nASIN(X)\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT ASIN(0.2);\n        -> 0.20135792079033\nmysql> SELECT ASIN(\'foo\');\n\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n1 row in set, 1 warning (0.00 sec)\n\nmysql> SHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (42,27,'ASSIGN-EQUAL','Syntax:\n=\n\nThis operator is used to perform value assignments in two cases,\ndescribed in the next two paragraphs.\n\nWithin a SET statement, = is treated as an assignment operator that\ncauses the user variable on the left hand side of the operator to take\non the value to its right. (In other words, when used in a SET\nstatement, = is treated identically to :=.) The value on the right hand\nside may be a literal value, another variable storing a value, or any\nlegal expression that yields a scalar value, including the result of a\nquery (provided that this value is a scalar value). You can perform\nmultiple assignments in the same SET statement.\n\nIn the SET clause of an UPDATE statement, = also acts as an assignment\noperator; in this case, however, it causes the column named on the left\nhand side of the operator to assume the value given to the right,\nprovided any WHERE conditions that are part of the UPDATE are met. You\ncan make multiple assignments in the same SET clause of an UPDATE\nstatement.\n\nIn any other context, = is treated as a comparison operator.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/assignment-operators.html\n\n','mysql> SELECT @var1, @var2;\n        -> NULL, NULL\nmysql> SELECT @var1 := 1, @var2;\n        -> 1, NULL\nmysql> SELECT @var1, @var2;\n        -> 1, NULL\nmysql> SELECT @var1, @var2 := @var1;\n        -> 1, 1\nmysql> SELECT @var1, @var2;\n        -> 1, 1\n','http://dev.mysql.com/doc/refman/8.0/en/assignment-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (43,27,'ASSIGN-VALUE','Syntax:\n:=\n\nAssignment operator. Causes the user variable on the left hand side of\nthe operator to take on the value to its right. The value on the right\nhand side may be a literal value, another variable storing a value, or\nany legal expression that yields a scalar value, including the result\nof a query (provided that this value is a scalar value). You can\nperform multiple assignments in the same SET statement. You can perform\nmultiple assignments in the same statement.\n\nUnlike =, the := operator is never interpreted as a comparison\noperator. This means you can use := in any valid SQL statement (not\njust in SET statements) to assign a value to a variable.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/assignment-operators.html\n\n','mysql> SELECT @var1, @var2;\n        -> NULL, NULL\nmysql> SELECT @var1 := 1, @var2;\n        -> 1, NULL\nmysql> SELECT @var1, @var2;\n        -> 1, NULL\nmysql> SELECT @var1, @var2 := @var1;\n        -> 1, 1\nmysql> SELECT @var1, @var2;\n        -> 1, 1\n\nmysql> SELECT @var1:=COUNT(*) FROM t1;\n        -> 4\nmysql> SELECT @var1;\n        -> 4\n','http://dev.mysql.com/doc/refman/8.0/en/assignment-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (44,28,'ASYMMETRIC_DECRYPT','Syntax:\nASYMMETRIC_DECRYPT(algorithm, crypt_str, key_str)\n\nDecrypts an encrypted string using the given algorithm and key string,\nand returns the resulting cleartext as a binary string. If decryption\nfails, the result is NULL.\n\nkey_str must be a valid key string in PEM format. For successful\ndecryption, it must be the public or private key string corresponding\nto the private or public key string used with ASYMMETRIC_ENCRYPT() to\nproduce the encrypted string. algorithm indicates the encryption\nalgorithm used to create the key.\n\nSupported algorithm values: \'RSA\'\n\nFor a usage example, see the description of ASYMMETRIC_ENCRYPT().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/enterprise-encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/enterprise-encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (45,28,'ASYMMETRIC_DERIVE','Syntax:\nASYMMETRIC_DERIVE(pub_key_str, priv_key_str)\n\nDerives a symmetric key using the private key of one party and the\npublic key of another, and returns the resulting key as a binary\nstring. If key derivation fails, the result is NULL.\n\npub_key_str and priv_key_str must be valid key strings in PEM format.\nThey must be created using the DH algorithm.\n\nSuppose that you have two pairs of public and private keys:\n\nSET @dhp = CREATE_DH_PARAMETERS(1024);\nSET @priv1 = CREATE_ASYMMETRIC_PRIV_KEY(\'DH\', @dhp);\nSET @pub1 = CREATE_ASYMMETRIC_PUB_KEY(\'DH\', @priv1);\nSET @priv2 = CREATE_ASYMMETRIC_PRIV_KEY(\'DH\', @dhp);\nSET @pub2 = CREATE_ASYMMETRIC_PUB_KEY(\'DH\', @priv2);\n\nSuppose further that you use the private key from one pair and the\npublic key from the other pair to create a symmetric key string. Then\nthis symmetric key identity relationship holds:\n\nASYMMETRIC_DERIVE(@pub1, @priv2) = ASYMMETRIC_DERIVE(@pub2, @priv1)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/enterprise-encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/enterprise-encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (46,28,'ASYMMETRIC_ENCRYPT','Syntax:\nASYMMETRIC_ENCRYPT(algorithm, str, key_str)\n\nEncrypts a string using the given algorithm and key string, and returns\nthe resulting ciphertext as a binary string. If encryption fails, the\nresult is NULL.\n\nThe str length cannot be greater than the key_str length − 11, in\nbytes\n\nkey_str must be a valid key string in PEM format. algorithm indicates\nthe encryption algorithm used to create the key.\n\nSupported algorithm values: \'RSA\'\n\nTo encrypt a string, pass a private or public key string to\nASYMMETRIC_ENCRYPT(). To recover the original unencrypted string, pass\nthe encrypted string to ASYMMETRIC_DECRYPT(), along with the public or\nprivate key string correponding to the private or public key string\nused for encryption.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/enterprise-encryption-functions.html\n\n','-- Generate private/public key pair\nSET @priv = CREATE_ASYMMETRIC_PRIV_KEY(\'RSA\', 1024);\nSET @pub = CREATE_ASYMMETRIC_PUB_KEY(\'RSA\', @priv);\n\n-- Encrypt using private key, decrypt using public key\nSET @ciphertext = ASYMMETRIC_ENCRYPT(\'RSA\', \'The quick brown fox\', @priv);\nSET @cleartext = ASYMMETRIC_DECRYPT(\'RSA\', @ciphertext, @pub);\n\n-- Encrypt using public key, decrypt using private key\nSET @ciphertext = ASYMMETRIC_ENCRYPT(\'RSA\', \'The quick brown fox\', @pub);\nSET @cleartext = ASYMMETRIC_DECRYPT(\'RSA\', @ciphertext, @priv);\n','http://dev.mysql.com/doc/refman/8.0/en/enterprise-encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (47,28,'ASYMMETRIC_SIGN','Syntax:\nASYMMETRIC_SIGN(algorithm, digest_str, priv_key_str, digest_type)\n\nSigns a digest string using a private key string, and returns the\nsignature as a binary string. If signing fails, the result is NULL.\n\ndigest_str is the digest string. It can be generated by calling\nCREATE_DIGEST(). digest_type indicates the digest algorithm used to\ngenerate the digest string.\n\npriv_key_str is the private key string to use for signing the digest\nstring. It must be a valid key string in PEM format. algorithm\nindicates the encryption algorithm used to create the key.\n\nSupported algorithm values: \'RSA\', \'DSA\'\n\nSupported digest_type values: \'SHA224\', \'SHA256\', \'SHA384\', \'SHA512\'\n\nFor a usage example, see the description of ASYMMETRIC_VERIFY().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/enterprise-encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/enterprise-encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (48,28,'ASYMMETRIC_VERIFY','Syntax:\nASYMMETRIC_VERIFY(algorithm, digest_str, sig_str, pub_key_str,\ndigest_type)\n\nVerifies whether the signature string matches the digest string, and\nreturns 1 or 0 to indicate whether verification succeeded or failed.\n\ndigest_str is the digest string. It can be generated by calling\nCREATE_DIGEST(). digest_type indicates the digest algorithm used to\ngenerate the digest string.\n\nsig_str is the signature string. It can be generated by calling\nASYMMETRIC_SIGN().\n\npub_key_str is the public key string of the signer. It corresponds to\nthe private key passed to ASYMMETRIC_SIGN() to generate the signature\nstring and must be a valid key string in PEM format. algorithm\nindicates the encryption algorithm used to create the key.\n\nSupported algorithm values: \'RSA\', \'DSA\'\n\nSupported digest_type values: \'SHA224\', \'SHA256\', \'SHA384\', \'SHA512\'\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/enterprise-encryption-functions.html\n\n','-- Set the encryption algorithm and digest type\nSET @algo = \'RSA\';\nSET @dig_type = \'SHA224\';\n\n-- Create private/public key pair\nSET @priv = CREATE_ASYMMETRIC_PRIV_KEY(@algo, 1024);\nSET @pub = CREATE_ASYMMETRIC_PUB_KEY(@algo, @priv);\n\n-- Generate digest from string\nSET @dig = CREATE_DIGEST(@dig_type, \'The quick brown fox\');\n\n-- Generate signature for digest and verify signature against digest\nSET @sig = ASYMMETRIC_SIGN(@algo, @dig, @priv, @dig_type);\nSET @verf = ASYMMETRIC_VERIFY(@algo, @dig, @sig, @pub, @dig_type);\n','http://dev.mysql.com/doc/refman/8.0/en/enterprise-encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (49,30,'ATAN','Syntax:\nATAN(X)\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT ATAN(2);\n        -> 1.1071487177941\nmysql> SELECT ATAN(-2);\n        -> -1.1071487177941\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (50,30,'ATAN2','Syntax:\nATAN(Y,X), ATAN2(Y,X)\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both\narguments are used to determine the quadrant of the result.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT ATAN(-2,2);\n        -> -0.78539816339745\nmysql> SELECT ATAN2(PI(),0);\n        -> 1.5707963267949\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (51,11,'AUTO_INCREMENT','The AUTO_INCREMENT attribute can be used to generate a unique identity\nfor new rows:\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/example-auto-increment.html\n\n','CREATE TABLE animals (\n     id MEDIUMINT NOT NULL AUTO_INCREMENT,\n     name CHAR(30) NOT NULL,\n     PRIMARY KEY (id)\n);\n\nINSERT INTO animals (name) VALUES\n    (\'dog\'),(\'cat\'),(\'penguin\'),\n    (\'lax\'),(\'whale\'),(\'ostrich\');\n\nSELECT * FROM animals;\n','http://dev.mysql.com/doc/refman/8.0/en/example-auto-increment.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (52,15,'AVG','Syntax:\nAVG([DISTINCT] expr) [over_clause]\n\nReturns the average value of expr. The DISTINCT option can be used to\nreturn the average of the distinct values of expr.\n\nIf there are no matching rows, AVG() returns NULL.\n\nThis function executes as a window function if over_clause is present.\nover_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html; it\ncannot be used with DISTINCT.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html\n\n','mysql> SELECT student_name, AVG(test_score)\n       FROM student\n       GROUP BY student_name;\n','http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (53,6,'BEGIN END','Syntax:\n[begin_label:] BEGIN\n    [statement_list]\nEND [end_label]\n\nBEGIN ... END syntax is used for writing compound statements, which can\nappear within stored programs (stored procedures and functions,\ntriggers, and events). A compound statement can contain multiple\nstatements, enclosed by the BEGIN and END keywords. statement_list\nrepresents a list of one or more statements, each terminated by a\nsemicolon (;) statement delimiter. The statement_list itself is\noptional, so the empty compound statement (BEGIN END) is legal.\n\nBEGIN ... END blocks can be nested.\n\nUse of multiple statements requires that a client is able to send\nstatement strings containing the ; statement delimiter. In the mysql\ncommand-line client, this is handled with the delimiter command.\nChanging the ; end-of-statement delimiter (for example, to //) permit ;\nto be used in a program body. For an example, see\nhttp://dev.mysql.com/doc/refman/8.0/en/stored-programs-defining.html.\n\nA BEGIN ... END block can be labeled. See [HELP labels].\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/begin-end.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/begin-end.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (54,23,'BENCHMARK','Syntax:\nBENCHMARK(count,expr)\n\nThe BENCHMARK() function executes the expression expr repeatedly count\ntimes. It may be used to time how quickly MySQL processes the\nexpression. The result value is always 0. The intended use is from\nwithin the mysql client, which reports query execution times:\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/information-functions.html\n\n','mysql> SELECT BENCHMARK(1000000,AES_ENCRYPT(\'hello\',\'goodbye\'));\n+---------------------------------------------------+\n| BENCHMARK(1000000,AES_ENCRYPT(\'hello\',\'goodbye\')) |\n+---------------------------------------------------+\n|                                                 0 |\n+---------------------------------------------------+\n1 row in set (4.74 sec)\n','http://dev.mysql.com/doc/refman/8.0/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (55,4,'BETWEEN AND','Syntax:\nexpr BETWEEN min AND max\n\nIf expr is greater than or equal to min and expr is less than or equal\nto max, BETWEEN returns 1, otherwise it returns 0. This is equivalent\nto the expression (min <= expr AND expr <= max) if all the arguments\nare of the same type. Otherwise type conversion takes place according\nto the rules described in\nhttp://dev.mysql.com/doc/refman/8.0/en/type-conversion.html, but\napplied to all the three arguments.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html\n\n','mysql> SELECT 2 BETWEEN 1 AND 3, 2 BETWEEN 3 and 1;\n        -> 1, 0\nmysql> SELECT 1 BETWEEN 2 AND 3;\n        -> 0\nmysql> SELECT \'b\' BETWEEN \'a\' AND \'c\';\n        -> 1\nmysql> SELECT 2 BETWEEN 2 AND \'3\';\n        -> 1\nmysql> SELECT 2 BETWEEN 2 AND \'x-3\';\n        -> 0\n','http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (56,11,'BIGINT','BIGINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA large integer. The signed range is -9223372036854775808 to\n9223372036854775807. The unsigned range is 0 to 18446744073709551615.\n\nSERIAL is an alias for BIGINT UNSIGNED NOT NULL AUTO_INCREMENT UNIQUE.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/numeric-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (57,35,'BIN','Syntax:\nBIN(N)\n\nReturns a string representation of the binary value of N, where N is a\nlonglong (BIGINT) number. This is equivalent to CONV(N,10,2). Returns\nNULL if N is NULL.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT BIN(12);\n        -> \'1100\'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (58,11,'BINARY','BINARY[(M)]\n\nThe BINARY type is similar to the CHAR type, but stores binary byte\nstrings rather than nonbinary character strings. An optional length M\nrepresents the column length in bytes. If omitted, M defaults to 1.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (59,35,'BINARY OPERATOR','Syntax:\nBINARY expr\n\nThe BINARY operator converts the expression to a binary string. A\ncommon use for BINARY is to force a character string comparison to be\ndone byte by byte rather than character by character, in effect\nbecoming case-sensitive. The BINARY operator also causes trailing\nspaces in comparisons to be significant.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/cast-functions.html\n\n','mysql> SELECT \'a\' = \'A\';\n        -> 1\nmysql> SELECT BINARY \'a\' = \'A\';\n        -> 0\nmysql> SELECT \'a\' = \'a \';\n        -> 1\nmysql> SELECT BINARY \'a\' = \'a \';\n        -> 0\n','http://dev.mysql.com/doc/refman/8.0/en/cast-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (60,2,'BINLOG','Syntax:\nBINLOG \'str\'\n\nBINLOG is an internal-use statement. It is generated by the mysqlbinlog\nprogram as the printable representation of certain events in binary log\nfiles. (See http://dev.mysql.com/doc/refman/8.0/en/mysqlbinlog.html.)\nThe \'str\' value is a base 64-encoded string the that server decodes to\ndetermine the data change indicated by the corresponding event. This\nstatement requires the BINLOG_ADMIN or SUPER privilege.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/binlog.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/binlog.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (61,29,'BIN_TO_UUID','BIN_TO_UUID(binary_uuid), BIN_TO_UUID(binary_uuid, swap_flag)\n\nBIN_TO_UUID() is the inverse of UUID_TO_BIN(). It converts a binary\nUUID to a string UUID and returns the result. The binary value should\nbe a UUID as a VARBINARY(16) value. The return value is a utf8 string\nof five hexadecimal numbers separated by dashes. (For details about\nthis format, see the UUID() function description.) If the UUID argument\nis NULL, the return value is NULL. If any argument is invalid, an error\noccurs.\n\nBIN_TO_UUID() takes one or two arguments:\n\no The one-argument form takes a binary UUID value. The UUID value is\n  assumed not to have its time-low and time-high parts swapped. The\n  string result is in the same order as the binary argument.\n\no The two-argument form takes a binary UUID value and a swap-flag\n  value:\n\n  o If swap_flag is 0, the two-argument form is equivalent to the\n    one-argument form. The string result is in the same order as the\n    binary argument.\n\n  o If swap_flag is 1, the UUID value is assumed to have its time-low\n    and time-high parts swapped. These parts are swapped back to their\n    original position in the result value.\n\nFor usage examples and information about time-part swapping, see the\nUUID_TO_BIN() function description.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (62,11,'BIT','BIT[(M)]\n\nA bit-value type. M indicates the number of bits per value, from 1 to\n64. The default is 1 if M is omitted.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/numeric-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (63,15,'BIT_AND','Syntax:\nBIT_AND(expr) [over_clause]\n\nReturns the bitwise AND of all bits in expr.\n\nThe result type depends on whether the function argument values are\nevaluated as binary strings or numbers:\n\no Binary-string evaluation occurs when the argument values have a\n  binary string type, and the argument is not a hexadecimal literal,\n  bit literal, or NULL literal. Numeric evaluation occurs otherwise,\n  with argument value conversion to unsigned 64-bit integers as\n  necessary.\n\no Binary-string evaluation produces a binary string of the same length\n  as the argument values. If argument values have unequal lengths, an\n  ER_INVALID_BITWISE_OPERANDS_SIZE error occurs. If the argument size\n  exceeds 511 bytes, an ER_INVALID_BITWISE_AGGREGATE_OPERANDS_SIZE\n  error occurs. Numeric evaluation produces an unsigned 64-bit integer.\n\nIf there are no matching rows, BIT_AND() returns a neutral value (all\nbits set to 1) having the same length as the argument values.\n\nNULL values do not affect the result unless all values are NULL. In\nthat case, the result is a neutral value having the same length as the\nargument values.\n\nFor more information discussion about argument evaluation and result\ntypes, see the introductory discussion in\nhttp://dev.mysql.com/doc/refman/8.0/en/bit-functions.html.\n\nAs of MySQL 8.0.12, this function executes as a window function if\nover_clause is present. over_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (64,3,'BIT_COUNT','Syntax:\nBIT_COUNT(N)\n\nReturns the number of bits that are set in the argument N as an\nunsigned 64-bit integer, or NULL if the argument is NULL.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/bit-functions.html\n\n','mysql> SELECT BIT_COUNT(64), BIT_COUNT(BINARY 64);\n        -> 1, 7\nmysql> SELECT BIT_COUNT(\'64\'), BIT_COUNT(_binary \'64\');\n        -> 1, 7\nmysql> SELECT BIT_COUNT(X\'40\'), BIT_COUNT(_binary X\'40\');\n        -> 1, 1\n','http://dev.mysql.com/doc/refman/8.0/en/bit-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (65,35,'BIT_LENGTH','Syntax:\nBIT_LENGTH(str)\n\nReturns the length of the string str in bits.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT BIT_LENGTH(\'text\');\n        -> 32\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (66,15,'BIT_OR','Syntax:\nBIT_OR(expr) [over_clause]\n\nReturns the bitwise OR of all bits in expr.\n\nThe result type depends on whether the function argument values are\nevaluated as binary strings or numbers:\n\no Binary-string evaluation occurs when the argument values have a\n  binary string type, and the argument is not a hexadecimal literal,\n  bit literal, or NULL literal. Numeric evaluation occurs otherwise,\n  with argument value conversion to unsigned 64-bit integers as\n  necessary.\n\no Binary-string evaluation produces a binary string of the same length\n  as the argument values. If argument values have unequal lengths, an\n  ER_INVALID_BITWISE_OPERANDS_SIZE error occurs. If the argument size\n  exceeds 511 bytes, an ER_INVALID_BITWISE_AGGREGATE_OPERANDS_SIZE\n  error occurs. Numeric evaluation produces an unsigned 64-bit integer.\n\nIf there are no matching rows, BIT_OR() returns a neutral value (all\nbits set to 0) having the same length as the argument values.\n\nNULL values do not affect the result unless all values are NULL. In\nthat case, the result is a neutral value having the same length as the\nargument values.\n\nFor more information discussion about argument evaluation and result\ntypes, see the introductory discussion in\nhttp://dev.mysql.com/doc/refman/8.0/en/bit-functions.html.\n\nAs of MySQL 8.0.12, this function executes as a window function if\nover_clause is present. over_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (67,15,'BIT_XOR','Syntax:\nBIT_XOR(expr) [over_clause]\n\nReturns the bitwise XOR of all bits in expr.\n\nThe result type depends on whether the function argument values are\nevaluated as binary strings or numbers:\n\no Binary-string evaluation occurs when the argument values have a\n  binary string type, and the argument is not a hexadecimal literal,\n  bit literal, or NULL literal. Numeric evaluation occurs otherwise,\n  with argument value conversion to unsigned 64-bit integers as\n  necessary.\n\no Binary-string evaluation produces a binary string of the same length\n  as the argument values. If argument values have unequal lengths, an\n  ER_INVALID_BITWISE_OPERANDS_SIZE error occurs. If the argument size\n  exceeds 511 bytes, an ER_INVALID_BITWISE_AGGREGATE_OPERANDS_SIZE\n  error occurs. Numeric evaluation produces an unsigned 64-bit integer.\n\nIf there are no matching rows, BIT_XOR() returns a neutral value (all\nbits set to 0) having the same length as the argument values.\n\nNULL values do not affect the result unless all values are NULL. In\nthat case, the result is a neutral value having the same length as the\nargument values.\n\nFor more information discussion about argument evaluation and result\ntypes, see the introductory discussion in\nhttp://dev.mysql.com/doc/refman/8.0/en/bit-functions.html.\n\nAs of MySQL 8.0.12, this function executes as a window function if\nover_clause is present. over_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (68,11,'BLOB','BLOB[(M)]\n\nA BLOB column with a maximum length of 65,535 (216 − 1) bytes. Each\nBLOB value is stored using a 2-byte length prefix that indicates the\nnumber of bytes in the value.\n\nAn optional length M can be given for this type. If this is done, MySQL\ncreates the column as the smallest BLOB type large enough to hold\nvalues M bytes long.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (69,11,'BLOB DATA TYPE','A BLOB is a binary large object that can hold a variable amount of\ndata. The four BLOB types are TINYBLOB, BLOB, MEDIUMBLOB, and LONGBLOB.\nThese differ only in the maximum length of the values they can hold.\nThe four TEXT types are TINYTEXT, TEXT, MEDIUMTEXT, and LONGTEXT. These\ncorrespond to the four BLOB types and have the same maximum lengths and\nstorage requirements. See\nhttp://dev.mysql.com/doc/refman/8.0/en/storage-requirements.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/blob.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/blob.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (70,11,'BOOLEAN','BOOL, BOOLEAN\n\nThese types are synonyms for TINYINT(1). A value of zero is considered\nfalse. Nonzero values are considered true:\n\nmysql> SELECT IF(0, \'true\', \'false\');\n+------------------------+\n| IF(0, \'true\', \'false\') |\n+------------------------+\n| false                  |\n+------------------------+\n\nmysql> SELECT IF(1, \'true\', \'false\');\n+------------------------+\n| IF(1, \'true\', \'false\') |\n+------------------------+\n| true                   |\n+------------------------+\n\nmysql> SELECT IF(2, \'true\', \'false\');\n+------------------------+\n| IF(2, \'true\', \'false\') |\n+------------------------+\n| true                   |\n+------------------------+\n\nHowever, the values TRUE and FALSE are merely aliases for 1 and 0,\nrespectively, as shown here:\n\nmysql> SELECT IF(0 = FALSE, \'true\', \'false\');\n+--------------------------------+\n| IF(0 = FALSE, \'true\', \'false\') |\n+--------------------------------+\n| true                           |\n+--------------------------------+\n\nmysql> SELECT IF(1 = TRUE, \'true\', \'false\');\n+-------------------------------+\n| IF(1 = TRUE, \'true\', \'false\') |\n+-------------------------------+\n| true                          |\n+-------------------------------+\n\nmysql> SELECT IF(2 = TRUE, \'true\', \'false\');\n+-------------------------------+\n| IF(2 = TRUE, \'true\', \'false\') |\n+-------------------------------+\n| false                         |\n+-------------------------------+\n\nmysql> SELECT IF(2 = FALSE, \'true\', \'false\');\n+--------------------------------+\n| IF(2 = FALSE, \'true\', \'false\') |\n+--------------------------------+\n| false                          |\n+--------------------------------+\n\nThe last two statements display the results shown because 2 is equal to\nneither 1 nor 0.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/numeric-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (71,2,'CACHE INDEX','Syntax:\nCACHE INDEX\n  tbl_index_list [, tbl_index_list] ...\n  [PARTITION (partition_list | ALL)]\n  IN key_cache_name\n\ntbl_index_list:\n  tbl_name [[INDEX|KEY] (index_name[, index_name] ...)]\n\npartition_list:\n  partition_name[, partition_name][, ...]\n\nThe CACHE INDEX statement assigns table indexes to a specific key\ncache. It is used only for MyISAM tables. After the indexes have been\nassigned, they can be preloaded into the cache if desired with LOAD\nINDEX INTO CACHE.\n\nThe following statement assigns indexes from the tables t1, t2, and t3\nto the key cache named hot_cache:\n\nmysql> CACHE INDEX t1, t2, t3 IN hot_cache;\n+---------+--------------------+----------+----------+\n| Table   | Op                 | Msg_type | Msg_text |\n+---------+--------------------+----------+----------+\n| test.t1 | assign_to_keycache | status   | OK       |\n| test.t2 | assign_to_keycache | status   | OK       |\n| test.t3 | assign_to_keycache | status   | OK       |\n+---------+--------------------+----------+----------+\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/cache-index.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/cache-index.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (72,10,'CALL','Syntax:\nCALL sp_name([parameter[,...]])\nCALL sp_name[()]\n\nThe CALL statement invokes a stored procedure that was defined\npreviously with CREATE PROCEDURE.\n\nStored procedures that take no arguments can be invoked without\nparentheses. That is, CALL p() and CALL p are equivalent.\n\nCALL can pass back values to its caller using parameters that are\ndeclared as OUT or INOUT parameters. When the procedure returns, a\nclient program can also obtain the number of rows affected for the\nfinal statement executed within the routine: At the SQL level, call the\nROW_COUNT() function; from the C API, call the mysql_affected_rows()\nfunction.\n\nFor information about the effect of unhandled conditions on procedure\nparameters, see\nhttp://dev.mysql.com/doc/refman/8.0/en/conditions-and-parameters.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/call.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/call.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (73,29,'CAN_ACCESS_COLUMN','CAN_ACCESS_COLUMN(ARGS)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (74,29,'CAN_ACCESS_DATABASE','CAN_ACCESS_DATABASE(ARGS)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (75,29,'CAN_ACCESS_TABLE','CAN_ACCESS_TABLE(ARGS)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (76,29,'CAN_ACCESS_VIEW','CAN_ACCESS_VIEW(ARGS)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (77,8,'CASE OPERATOR','Syntax:\nCASE value WHEN [compare_value] THEN result [WHEN [compare_value] THEN\nresult ...] [ELSE result] END\n\nCASE WHEN [condition] THEN result [WHEN [condition] THEN result ...]\n[ELSE result] END\n\nThe first CASE syntax returns the result for the first\nvalue=compare_value comparison that is true. The second syntax returns\nthe result for the first condition that is true. If no comparison or\ncondition is true, the result after ELSE is returned, or NULL if there\nis no ELSE part.\n\n*Note*:\n\nThe syntax of the CASE expr described here differs slightly from that\nof the SQL CASE statement described in [HELP CASE statement], for use\ninside stored programs. The CASE statement cannot have an ELSE NULL\nclause, and it is terminated with END CASE instead of END.\n\nThe return type of a CASE expression result is the aggregated type of\nall result values:\n\no If all types are numeric, the aggregated type is also numeric:\n\n  o If at least one argument is double precision, the result is double\n    precision.\n\n  o Otherwise, if at least one argument is DECIMAL, the result is\n    DECIMAL.\n\n  o Otherwise, the result is an integer type (with one exception):\n\n    o If all integer types are all signed or all unsigned, the result\n      is the same sign and the precision is the highest of all\n      specified integer types (that is, TINYINT, SMALLINT, MEDIUMINT,\n      INT, or BIGINT).\n\n    o If there is a combination of signed and unsigned integer types,\n      the result is signed and the precision may be higher. For\n      example, if the types are signed INT and unsigned INT, the result\n      is signed BIGINT.\n\n    o The exception is unsigned BIGINT combined with any signed integer\n      type. The result is DECIMAL with sufficient precision and scale\n      0.\n\no If all types are BIT, the result is BIT. Otherwise, BIT arguments are\n  treated similar to BIGINT.\n\no If all types are YEAR, the result is YEAR. Otherwise, YEAR arguments\n  are treated similar to INT.\n\no If all types are character string (CHAR or VARCHAR), the result is\n  VARCHAR with maximum length determined by the longest character\n  length of the operands.\n\no If all types are character or binary string, the result is VARBINARY.\n\no SET and ENUM are treated similar to VARCHAR; the result is VARCHAR.\n\no If all types are JSON, the result is JSON.\n\no If all types are temporal, the result is temporal:\n\n  o If all temporal types are DATE, TIME, or TIMESTAMP, the result is\n    DATE, TIME, or TIMESTAMP, respectively.\n\n  o Otherwise, for a mix of temporal types, the result is DATETIME.\n\no If all types are GEOMETRY, the result is GEOMETRY.\n\no If any type is BLOB, the result is BLOB.\n\no For all other type combinations, the result is VARCHAR.\n\no Literal NULL operands are ignored for type aggregation.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/control-flow-functions.html\n\n','mysql> SELECT CASE 1 WHEN 1 THEN \'one\'\n    ->     WHEN 2 THEN \'two\' ELSE \'more\' END;\n        -> \'one\'\nmysql> SELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n        -> \'true\'\nmysql> SELECT CASE BINARY \'B\'\n    ->     WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END;\n        -> NULL\n','http://dev.mysql.com/doc/refman/8.0/en/control-flow-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (78,6,'CASE STATEMENT','Syntax:\nCASE case_value\n    WHEN when_value THEN statement_list\n    [WHEN when_value THEN statement_list] ...\n    [ELSE statement_list]\nEND CASE\n\nOr:\n\nCASE\n    WHEN search_condition THEN statement_list\n    [WHEN search_condition THEN statement_list] ...\n    [ELSE statement_list]\nEND CASE\n\nThe CASE statement for stored programs implements a complex conditional\nconstruct.\n\n*Note*:\n\nThere is also a CASE expr, which differs from the CASE statement\ndescribed here. See\nhttp://dev.mysql.com/doc/refman/8.0/en/control-flow-functions.html. The\nCASE statement cannot have an ELSE NULL clause, and it is terminated\nwith END CASE instead of END.\n\nFor the first syntax, case_value is an expression. This value is\ncompared to the when_value expression in each WHEN clause until one of\nthem is equal. When an equal when_value is found, the corresponding\nTHEN clause statement_list executes. If no when_value is equal, the\nELSE clause statement_list executes, if there is one.\n\nThis syntax cannot be used to test for equality with NULL because NULL\n= NULL is false. See\nhttp://dev.mysql.com/doc/refman/8.0/en/working-with-null.html.\n\nFor the second syntax, each WHEN clause search_condition expression is\nevaluated until one is true, at which point its corresponding THEN\nclause statement_list executes. If no search_condition is equal, the\nELSE clause statement_list executes, if there is one.\n\nIf no when_value or search_condition matches the value tested and the\nCASE statement contains no ELSE clause, a Case not found for CASE\nstatement error results.\n\nEach statement_list consists of one or more SQL statements; an empty\nstatement_list is not permitted.\n\nTo handle situations where no value is matched by any WHEN clause, use\nan ELSE containing an empty BEGIN ... END block, as shown in this\nexample. (The indentation used here in the ELSE clause is for purposes\nof clarity only, and is not otherwise significant.)\n\nDELIMITER |\n\nCREATE PROCEDURE p()\n  BEGIN\n    DECLARE v INT DEFAULT 1;\n\n    CASE v\n      WHEN 2 THEN SELECT v;\n      WHEN 3 THEN SELECT 0;\n      ELSE\n        BEGIN\n        END;\n    END CASE;\n  END;\n  |\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/case.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/case.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (79,35,'CAST','Syntax:\nCAST(expr AS type)\n\nThe CAST() function takes an expression of any type and produces a\nresult value of the specified type, similar to CONVERT(). For more\ninformation, see the description of CONVERT().\n\nCAST() is standard SQL syntax.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/cast-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/cast-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (80,30,'CEIL','Syntax:\nCEIL(X)\n\nCEIL() is a synonym for CEILING().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (81,30,'CEILING','Syntax:\nCEILING(X)\n\nReturns the smallest integer value not less than X.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT CEILING(1.23);\n        -> 2\nmysql> SELECT CEILING(-1.23);\n        -> -1\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (82,37,'CHANGE MASTER TO','Syntax:\nCHANGE MASTER TO option [, option] ... [ channel_option ]\n\noption:\n    MASTER_BIND = \'interface_name\'\n  | MASTER_HOST = \'host_name\'\n  | MASTER_USER = \'user_name\'\n  | MASTER_PASSWORD = \'password\'\n  | MASTER_PORT = port_num\n  | MASTER_CONNECT_RETRY = interval\n  | MASTER_RETRY_COUNT = count\n  | MASTER_DELAY = interval\n  | MASTER_HEARTBEAT_PERIOD = interval\n  | MASTER_LOG_FILE = \'master_log_name\'\n  | MASTER_LOG_POS = master_log_pos\n  | MASTER_AUTO_POSITION = {0|1}\n  | RELAY_LOG_FILE = \'relay_log_name\'\n  | RELAY_LOG_POS = relay_log_pos\n  | MASTER_SSL = {0|1}\n  | MASTER_SSL_CA = \'ca_file_name\'\n  | MASTER_SSL_CAPATH = \'ca_directory_name\'\n  | MASTER_SSL_CERT = \'cert_file_name\'\n  | MASTER_SSL_CRL = \'crl_file_name\'\n  | MASTER_SSL_CRLPATH = \'crl_directory_name\'\n  | MASTER_SSL_KEY = \'key_file_name\'\n  | MASTER_SSL_CIPHER = \'cipher_list\'\n  | MASTER_SSL_VERIFY_SERVER_CERT = {0|1}\n  | MASTER_TLS_VERSION = \'protocol_list\'\n  | MASTER_PUBLIC_KEY_PATH = \'key_file_name\'\n  | GET_MASTER_PUBLIC_KEY = {0|1}\n  | IGNORE_SERVER_IDS = (server_id_list)\n\nchannel_option:\n    FOR CHANNEL channel\n\nserver_id_list:\n    [server_id [, server_id] ... ]\n\nCHANGE MASTER TO changes the parameters that the slave server uses for\nconnecting to the master server, for reading the master binary log, and\nreading the slave relay log. It also updates the contents of the master\ninfo and relay log info repositories (see\nhttp://dev.mysql.com/doc/refman/8.0/en/slave-logs.html). CHANGE MASTER\nTO requires the REPLICATION_SLAVE_ADMIN or SUPER privilege.\n\nYou can issue CHANGE MASTER TO statements on a running slave without\nfirst stopping it, depending on the states of the slave SQL thread and\nslave I/O thread. The rules governing such use are provided later in\nthis section.\n\nWhen using a multithreaded slave (in other words slave_parallel_workers\nis greater than 0), stopping the slave can cause "gaps" in the sequence\nof transactions that have been executed from the relay log, regardless\nof whether the slave was stopped intentionally or otherwise. When such\ngaps exist, issuing CHANGE MASTER TO fails. The solution in this\nsituation is to issue START SLAVE UNTIL SQL_AFTER_MTS_GAPS which\nensures that the gaps are closed.\n\nThe optional FOR CHANNEL channel clause enables you to name which\nreplication channel the statement applies to. Providing a FOR CHANNEL\nchannel clause applies the CHANGE MASTER TO statement to a specific\nreplication channel, and is used to add a new channel or modify an\nexisting channel. For example, to add a new channel called channel2:\n\nCHANGE MASTER TO MASTER_HOST=host1, MASTER_PORT=3002 FOR CHANNEL \'channel2\'\n\nIf no clause is named and no extra channels exist, the statement\napplies to the default channel.\n\nWhen using multiple replication channels, if a CHANGE MASTER TO\nstatement does not name a channel using a FOR CHANNEL channel clause,\nan error occurs. See\nhttp://dev.mysql.com/doc/refman/8.0/en/replication-channels.html for\nmore information.\n\nOptions not specified retain their value, except as indicated in the\nfollowing discussion. Thus, in most cases, there is no need to specify\noptions that do not change.\n\nMASTER_HOST, MASTER_USER, MASTER_PASSWORD, and MASTER_PORT provide\ninformation to the slave about how to connect to its master:\n\no MASTER_HOST and MASTER_PORT are the host name (or IP address) of the\n  master host and its TCP/IP port.\n\n  *Note*:\n\n  Replication cannot use Unix socket files. You must be able to connect\n  to the master MySQL server using TCP/IP.\n\n  If you specify the MASTER_HOST or MASTER_PORT option, the slave\n  assumes that the master server is different from before (even if the\n  option value is the same as its current value.) In this case, the old\n  values for the master binary log file name and position are\n  considered no longer applicable, so if you do not specify\n  MASTER_LOG_FILE and MASTER_LOG_POS in the statement,\n  MASTER_LOG_FILE=\'\' and MASTER_LOG_POS=4 are silently appended to it.\n\n  Setting MASTER_HOST=\'\' (that is, setting its value explicitly to an\n  empty string) is not the same as not setting MASTER_HOST at all.\n  Trying to set MASTER_HOST to an empty string fails with an error.\n\n  Values used for MASTER_HOST and other CHANGE MASTER TO options are\n  checked for linefeed (\\n or 0x0A) characters; the presence of such\n  characters in these values causes the statement to fail with\n  ER_MASTER_INFO. (Bug #11758581, Bug #50801)\n\no MASTER_USER and MASTER_PASSWORD are the user name and password of the\n  account to use for connecting to the master.\n\n  MASTER_USER cannot be made empty; setting MASTER_USER = \'\' or leaving\n  it unset when setting a value for MASTER_PASSWORD causes an error\n  (Bug #13427949).\n\n  The password used for a MySQL Replication slave account in a CHANGE\n  MASTER TO statement is limited to 32 characters in length; trying to\n  use a password of more than 32 characters causes CHANGE MASTER TO to\n  fail.\n\n  The text of a running CHANGE MASTER TO statement, including values\n  for MASTER_USER and MASTER_PASSWORD, can be seen in the output of a\n  concurrent SHOW PROCESSLIST statement. (The complete text of a START\n  SLAVE statement is also visible to SHOW PROCESSLIST.)\n\nThe MASTER_SSL_xxx options, and the MASTER_TLS_VERSION option, specify\nhow the slave uses encryption and ciphers to secure the replication\nconnection. These options can be changed even on slaves that are\ncompiled without SSL support. They are saved to the master info\nrepository, but are ignored if the slave does not have SSL support\nenabled. The MASTER_SSL_xxx options perform the same functions as the\n--ssl-xxx options described in\nhttp://dev.mysql.com/doc/refman/8.0/en/encrypted-connection-options.htm\nl. The correspondence between the two sets of options, and the use of\nthe MASTER_SSL_xxx and MASTER_TLS_VERSION options to set up a secure\nconnection, is explained in\nhttp://dev.mysql.com/doc/refman/8.0/en/replication-solutions-encrypted-\nconnections.html.\n\n*Important*:\n\nTo connect to the replication master using a user account that\nauthenticates with the caching_sha2_password plugin, you must either\nset up a secure connection as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/replication-solutions-encrypted-\nconnections.html, or enable the unencrypted connection to support\npassword exchange using an RSA key pair. The caching_sha2_password\nauthentication plugin is the default for new users created from MySQL\n8.0 (for details, see\nhttp://dev.mysql.com/doc/refman/8.0/en/caching-sha2-pluggable-authentic\nation.html). If the user account that you create or use for replication\n(as specified by the MASTER_USER option) uses this authentication\nplugin, and you are not using a secure connection, you must enable RSA\nkey pair-based password exchange for a successful connection.\n\nTo enable RSA key pair-based password exchange, specify either the\nMASTER_PUBLIC_KEY_PATH or the GET_MASTER_PUBLIC_KEY=1 option. Either of\nthese options provides the RSA public key to the slave:\n\no MASTER_PUBLIC_KEY_PATH indicates the path name to a file containing a\n  slave-side copy of the public key required by the master for RSA key\n  pair-based password exchange. The file must be in PEM format. This\n  option applies to slaves that authenticate with the sha256_password\n  or caching_sha2_password authentication plugin. (For sha256_password,\n  MASTER_PUBLIC_KEY_PATH can be used only if MySQL was built using\n  OpenSSL.)\n\no GET_MASTER_PUBLIC_KEY indicates whether to request from the master\n  the public key required for RSA key pair-based password exchange.\n  This option applies to slaves that authenticate with the\n  caching_sha2_password authentication plugin. For connections by\n  accounts that authenticate using this plugin, the master does not\n  send the public key unless requested, so it must be requested or\n  specified in the client. If MASTER_PUBLIC_KEY_PATH is given and\n  specifies a valid public key file, it takes precedence over\n  GET_MASTER_PUBLIC_KEY.\n\nThe MASTER_HEARTBEAT_PERIOD, MASTER_CONNECT_RETRY, and\nMASTER_RETRY_COUNT options control how the slave recognizes that the\nconnection to the master has been lost and makes attempts to reconnect.\n\no The slave_net_timeout system variable specifies the number of seconds\n  that the slave waits for either more data or a heartbeat signal from\n  the master, before the slave considers the connection broken, aborts\n  the read, and tries to reconnect. The default value is 60 seconds\n  (one minute).\n\no The heartbeat interval, which stops the connection timeout occurring\n  in the absence of data if the connection is still good, is controlled\n  by the MASTER_HEARTBEAT_PERIOD option. A heartbeat signal is sent to\n  the slave after that number of seconds, and the waiting period is\n  reset whenever the master\'s binary log is updated with an event.\n  Heartbeats are therefore sent by the master only if there are no\n  unsent events in the binary log file for a period longer than this.\n  The heartbeat interval interval is a decimal value having the range 0\n  to 4294967 seconds and a resolution in milliseconds; the smallest\n  nonzero value is 0.001. Setting interval to 0 disables heartbeats\n  altogether. The heartbeat interval defaults to half the value of the\n  slave_net_timeout system variable. It is recorded in the master info\n  log and shown in the replication_connection_configuration Performance\n  Schema table. Issuing RESET SLAVE resets the heartbeat interval to\n  the default value.\n\n  Note that a change to the value or default setting of\n  slave_net_timeout does not automatically change the heartbeat\n  interval, whether that has been set explicitly or is using a\n  previously calculated default. A warning is issued if you set\n  @@GLOBAL.slave_net_timeout to a value less than that of the current\n  heartbeat interval. If slave_net_timeout is changed, you must also\n  issue CHANGE MASTER TO to adjust the heartbeat interval to an\n  appropriate value so that the heartbeat signal occurs before the\n  connection timeout. If you do not do this, the heartbeat signal has\n  no effect, and if no data is received from the master, the slave can\n  make repeated reconnection attempts, creating zombie dump threads.\n\no If the slave does need to reconnect, the first retry occurs\n  immediately after the timeout. MASTER_CONNECT_RETRY specifies the\n  interval between reconnection attempts, and MASTER_RETRY_COUNT limits\n  the number of reconnection attempts. If both the default settings are\n  used, the slave waits 60 seconds between reconnection attempts\n  (MASTER_CONNECT_RETRY=60), and keeps attempting to reconnect at this\n  rate for 24 hours (MASTER_RETRY_COUNT=86400). These values are\n  recorded in the master info log and shown in the\n  replication_connection_configuration Performance Schema table.\n  MASTER_RETRY_COUNT supersedes the --master-retry-count server startup\n  option.\n\nMASTER_DELAY specifies how many seconds behind the master the slave\nmust lag. An event received from the master is not executed until at\nleast interval seconds later than its execution on the master. The\ndefault is 0. An error occurs if interval is not a nonnegative integer\nin the range from 0 to 231−1. For more information, see\nhttp://dev.mysql.com/doc/refman/8.0/en/replication-delayed.html.\n\nA CHANGE MASTER TO statement employing the MASTER_DELAY option can be\nexecuted on a running slave when the slave SQL thread is stopped.\n\nMASTER_BIND is for use on replication slaves having multiple network\ninterfaces, and determines which of the slave\'s network interfaces is\nchosen for connecting to the master.\n\nThe address configured with this option, if any, can be seen in the\nMaster_Bind column of the output from SHOW SLAVE STATUS. In the master\ninfo repository table mysql.slave_master_info, the value can be seen as\nthe Master_bind column.\n\nThe ability to bind a replication slave to a specific network interface\nis also supported by NDB Cluster.\n\nMASTER_LOG_FILE and MASTER_LOG_POS are the coordinates at which the\nslave I/O thread should begin reading from the master the next time the\nthread starts. RELAY_LOG_FILE and RELAY_LOG_POS are the coordinates at\nwhich the slave SQL thread should begin reading from the relay log the\nnext time the thread starts. If you specify either of MASTER_LOG_FILE\nor MASTER_LOG_POS, you cannot specify RELAY_LOG_FILE or RELAY_LOG_POS.\nIf you specify either of MASTER_LOG_FILE or MASTER_LOG_POS, you also\ncannot specify MASTER_AUTO_POSITION = 1 (described later in this\nsection). If neither of MASTER_LOG_FILE or MASTER_LOG_POS is specified,\nthe slave uses the last coordinates of the slave SQL thread before\nCHANGE MASTER TO was issued. This ensures that there is no\ndiscontinuity in replication, even if the slave SQL thread was late\ncompared to the slave I/O thread, when you merely want to change, say,\nthe password to use.\n\nA CHANGE MASTER TO statement employing RELAY_LOG_FILE, RELAY_LOG_POS,\nor both options can be executed on a running slave when the slave SQL\nthread is stopped. Relay logs are preserved if at least one of the\nslave SQL thread and the slave I/O thread is running; if both threads\nare stopped, all relay log files are deleted unless at least one of\nRELAY_LOG_FILE or RELAY_LOG_POS is specified.\n\nRELAY_LOG_FILE can use either an absolute or relative path, and uses\nthe same base name as MASTER_LOG_FILE.\n\nWhen MASTER_AUTO_POSITION = 1 is used with CHANGE MASTER TO, the slave\nattempts to connect to the master using the GTID-based replication\nprotocol. This option can be used with CHANGE MASTER TO only if both\nthe slave SQL and slave I/O threads are stopped. Both the slave and the\nmaster must have GTIDs enabled (GTID_MODE=ON, ON_PERMISSIVE, or\nOFF_PERMISSIVE on the slave, and GTID_MODE=ON on the master).\nAuto-positioning is used for the connection, so the coordinates\nrepresented by MASTER_LOG_FILE and MASTER_LOG_POS are not used, and the\nuse of either or both of these options together with\nMASTER_AUTO_POSITION = 1 causes an error. If multi-source replication\nis enabled on the slave, you need to set the MASTER_AUTO_POSITION = 1\noption for each applicable replication channel.\n\nWith MASTER_AUTO_POSITION = 1 set, in the initial connection handshake,\nthe slave sends a GTID set containing the transactions that it has\nalready received, committed, or both. The master responds by sending\nall transactions recorded in its binary log whose GTID is not included\nin the GTID set sent by the slave. This exchange ensures that the\nmaster only sends the transactions with a GTID that the slave has not\nalready recorded or committed. If the slave receives transactions from\nmore than one master, as in the case of a diamond topology, the\nauto-skip function ensures that the transactions are not applied twice.\nFor details of how the GTID set sent by the slave is computed, see\nhttp://dev.mysql.com/doc/refman/8.0/en/replication-gtids-auto-positioni\nng.html.\n\nIf any of the transactions that should be sent by the master have been\npurged from the master\'s binary log, or added to the set of GTIDs in\nthe gtid_purged system variable by another method, the master sends the\nerror ER_MASTER_HAS_PURGED_REQUIRED_GTIDS to the slave, and replication\ndoes not start. The GTIDs of the missing purged transactions are\nidentified and listed in the master\'s error log in the warning message\nER_FOUND_MISSING_GTIDS. Also, if during the exchange of transactions it\nis found that the slave has recorded or committed transactions with the\nmaster\'s UUID in the GTID, but the master itself has not committed\nthem, the master sends the error ER_SLAVE_HAS_MORE_GTIDS_THAN_MASTER to\nthe slave and replication does not start. For information on how to\nhandle these situations, see\nhttp://dev.mysql.com/doc/refman/8.0/en/replication-gtids-auto-positioni\nng.html.\n\nYou can see whether replication is running with auto-positioning\nenabled by checking the Performance Schema\nreplication_connection_status table or the output of SHOW SLAVE STATUS.\nDisabling the MASTER_AUTO_POSITION option again makes the slave revert\nto file-based replication, in which case you must also specify one or\nboth of the MASTER_LOG_FILE or MASTER_LOG_POS options.\n\nIGNORE_SERVER_IDS takes a comma-separated list of 0 or more server IDs.\nEvents originating from the corresponding servers are ignored, with the\nexception of log rotation and deletion events, which are still recorded\nin the relay log.\n\nIn circular replication, the originating server normally acts as the\nterminator of its own events, so that they are not applied more than\nonce. Thus, this option is useful in circular replication when one of\nthe servers in the circle is removed. Suppose that you have a circular\nreplication setup with 4 servers, having server IDs 1, 2, 3, and 4, and\nserver 3 fails. When bridging the gap by starting replication from\nserver 2 to server 4, you can include IGNORE_SERVER_IDS = (3) in the\nCHANGE MASTER TO statement that you issue on server 4 to tell it to use\nserver 2 as its master instead of server 3. Doing so causes it to\nignore and not to propagate any statements that originated with the\nserver that is no longer in use.\n\nIf IGNORE_SERVER_IDS contains the server\'s own ID and the server was\nstarted with the --replicate-same-server-id option enabled, an error\nresults.\n\n*Note*:\n\nWhen global transaction identifiers (GTIDs) are used for replication,\ntransactions that have already been applied are automatically ignored,\nso the IGNORE_SERVER_IDS function is not required and is deprecated. If\ngtid_mode=ON is set for the server, a deprecation warning is issued if\nyou include the IGNORE_SERVER_IDS option in a CHANGE MASTER TO\nstatement.\n\nThe master info repository and the output of SHOW SLAVE STATUS provide\nthe list of servers that are currently ignored. For more information,\nsee http://dev.mysql.com/doc/refman/8.0/en/slave-logs-status.html, and\n[HELP SHOW SLAVE STATUS].\n\nIf a CHANGE MASTER TO statement is issued without any IGNORE_SERVER_IDS\noption, any existing list is preserved. To clear the list of ignored\nservers, it is necessary to use the option with an empty list:\n\nCHANGE MASTER TO IGNORE_SERVER_IDS = ();\n\nRESET SLAVE ALL clears IGNORE_SERVER_IDS.\n\n*Note*:\n\nA deprecation warning is issued if SET GTID_MODE=ON is issued when any\nchannel has existing server IDs set with IGNORE_SERVER_IDS. Before\nstarting GTID-based replication, check for and clear all ignored server\nID lists on the servers involved. The SHOW_SLAVE_STATUS statement\ndisplays the list of ignored IDs, if there is one. If you do receive\nthe deprecation warning, you can still clear a list after gtid_mode=ON\nis set by issuing a CHANGE MASTER TO statement containing the\nIGNORE_SERVER_IDS option with an empty list.\n\nInvoking CHANGE MASTER TO causes the previous values for MASTER_HOST,\nMASTER_PORT, MASTER_LOG_FILE, and MASTER_LOG_POS to be written to the\nerror log, along with other information about the slave\'s state prior\nto execution.\n\nCHANGE MASTER TO causes an implicit commit of an ongoing transaction.\nSee http://dev.mysql.com/doc/refman/8.0/en/implicit-commit.html.\n\nFrom MySQL 5.7, the strict requirement to execute STOP SLAVE prior to\nissuing any CHANGE MASTER TO statement (and START SLAVE afterward) is\nremoved. Instead of depending on whether the slave is stopped, the\nbehavior of CHANGE MASTER TO depends on the states of the slave SQL\nthread and slave I/O threads; which of these threads is stopped or\nrunning now determines the options that can or cannot be used with a\nCHANGE MASTER TO statement at a given point in time. The rules for\nmaking this determination are listed here:\n\no If the SQL thread is stopped, you can execute CHANGE MASTER TO using\n  any combination that is otherwise allowed of RELAY_LOG_FILE,\n  RELAY_LOG_POS, and MASTER_DELAY options, even if the slave I/O thread\n  is running. No other options may be used with this statement when the\n  I/O thread is running.\n\no If the I/O thread is stopped, you can execute CHANGE MASTER TO using\n  any of the options for this statement (in any allowed combination)\n  except RELAY_LOG_FILE, RELAY_LOG_POS, or MASTER_DELAY, even when the\n  SQL thread is running. These three options may not be used when the\n  I/O thread is running.\n\no Both the SQL thread and the I/O thread must be stopped before issuing\n  a CHANGE MASTER TO statement that employs MASTER_AUTO_POSITION = 1.\n\nYou can check the current state of the slave SQL and I/O threads using\nSHOW SLAVE STATUS.\n\nFor more information, see\nhttp://dev.mysql.com/doc/refman/8.0/en/replication-solutions-switch.htm\nl.\n\nIf you are using statement-based replication and temporary tables, it\nis possible for a CHANGE MASTER TO statement following a STOP SLAVE\nstatement to leave behind temporary tables on the slave. A warning\n(ER_WARN_OPEN_TEMP_TABLES_MUST_BE_ZERO) is now issued whenever this\noccurs. You can avoid this in such cases by making sure that the value\nof the Slave_open_temp_tables system status variable is equal to 0\nprior to executing such a CHANGE MASTER TO statement.\n\nCHANGE MASTER TO is useful for setting up a slave when you have the\nsnapshot of the master and have recorded the master binary log\ncoordinates corresponding to the time of the snapshot. After loading\nthe snapshot into the slave to synchronize it with the master, you can\nrun CHANGE MASTER TO MASTER_LOG_FILE=\'log_name\', MASTER_LOG_POS=log_pos\non the slave to specify the coordinates at which the slave should begin\nreading the master binary log.\n\nThe following example changes the master server the slave uses and\nestablishes the master binary log coordinates from which the slave\nbegins reading. This is used when you want to set up the slave to\nreplicate the master:\n\nCHANGE MASTER TO\n  MASTER_HOST=\'master2.example.com\',\n  MASTER_USER=\'replication\',\n  MASTER_PASSWORD=\'password\',\n  MASTER_PORT=3306,\n  MASTER_LOG_FILE=\'master2-bin.001\',\n  MASTER_LOG_POS=4,\n  MASTER_CONNECT_RETRY=10;\n\nThe next example shows an operation that is less frequently employed.\nIt is used when the slave has relay log files that you want it to\nexecute again for some reason. To do this, the master need not be\nreachable. You need only use CHANGE MASTER TO and start the SQL thread\n(START SLAVE SQL_THREAD):\n\nCHANGE MASTER TO\n  RELAY_LOG_FILE=\'slave-relay-bin.006\',\n  RELAY_LOG_POS=4025;\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/change-master-to.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/change-master-to.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (83,37,'CHANGE REPLICATION FILTER','Syntax:\nCHANGE REPLICATION FILTER filter[, filter]\n	[, ...] [FOR CHANNEL channel]\n\nfilter:\n    REPLICATE_DO_DB = (db_list)\n  | REPLICATE_IGNORE_DB = (db_list)\n  | REPLICATE_DO_TABLE = (tbl_list)\n  | REPLICATE_IGNORE_TABLE = (tbl_list)\n  | REPLICATE_WILD_DO_TABLE = (wild_tbl_list)\n  | REPLICATE_WILD_IGNORE_TABLE = (wild_tbl_list)\n  | REPLICATE_REWRITE_DB = (db_pair_list)\n\ndb_list:\n    db_name[, db_name][, ...]\n\ntbl_list:\n    db_name.table_name[, db_name.table_name][, ...]\nwild_tbl_list:\n    \'db_pattern.table_pattern\'[, \'db_pattern.table_pattern\'][, ...]\n\ndb_pair_list:\n    (db_pair)[, (db_pair)][, ...]\n\ndb_pair:\n    from_db, to_db\n\nCHANGE REPLICATION FILTER sets one or more replication filtering rules\non the slave in the same way as starting the slave mysqld with\nreplication filtering options such as --replicate-do-db or\n--replicate-wild-ignore-table. Unlike the case with the server options,\nthis statement does not require restarting the server to take effect,\nonly that the slave SQL thread be stopped using STOP SLAVE SQL_THREAD\nfirst (and restarted with START SLAVE SQL_THREAD afterwards). CHANGE\nREPLICATION FILTER requires the REPLICATION_SLAVE_ADMIN or SUPER\nprivilege. Use the FOR CHANNEL channel clause to make a replication\nfilter specific to a replication channel, for example on a multi-source\nreplication slave. Filters applied without a specific FOR CHANNEL\nclause are considered global filters, meaning that they are applied to\nall replication channels.\n\nGlobal replication filters cannot be set on a MySQL server instance\nthat is configured for Group Replication, because filtering\ntransactions on some servers would make the group unable to reach\nagreement on a consistent state. Channel specific replication filters\ncan be set on replication channels that are not directly involved with\nGroup Replication, such as where a group member also acts as a\nreplication slave to a master that is outside the group. They cannot be\nset on the group_replication_applier or group_replication_recovery\nchannels.\n\nThe following list shows the CHANGE REPLICATION FILTER options and how\nthey relate to --replicate-* server options:\n\no REPLICATE_DO_DB: Include updates based on database name. Equivalent\n  to --replicate-do-db.\n\no REPLICATE_IGNORE_DB: Exclude updates based on database name.\n  Equivalent to --replicate-ignore-db.\n\no REPLICATE_DO_TABLE: Include updates based on table name. Equivalent\n  to --replicate-do-table.\n\no REPLICATE_IGNORE_TABLE: Exclude updates based on table name.\n  Equivalent to --replicate-ignore-table.\n\no REPLICATE_WILD_DO_TABLE: Include updates based on wildcard pattern\n  matching table name. Equivalent to --replicate-wild-do-table.\n\no REPLICATE_WILD_IGNORE_TABLE: Exclude updates based on wildcard\n  pattern matching table name. Equivalent to\n  --replicate-wild-ignore-table.\n\no REPLICATE_REWRITE_DB: Perform updates on slave after substituting new\n  name on slave for specified database on master. Equivalent to\n  --replicate-rewrite-db.\n\nThe precise effects of REPLICATE_DO_DB and REPLICATE_IGNORE_DB filters\nare dependent on whether statement-based or row-based replication is in\neffect. See\nhttp://dev.mysql.com/doc/refman/8.0/en/replication-rules.html, for more\ninformation.\n\nMultiple replication filtering rules can be created in a single CHANGE\nREPLICATION FILTER statement by separating the rules with commas, as\nshown here:\n\nCHANGE REPLICATION FILTER\n    REPLICATE_DO_DB = (d1), REPLICATE_IGNORE_DB = (d2);\n\nIssuing the statement just shown is equivalent to starting the slave\nmysqld with the options --replicate-do-db=d1 --replicate-ignore-db=d2.\n\nOn a multi-source replication slave, which uses multiple replication\nchannels to process transaction from different sources, use the FOR\nCHANNEL channel clause to set a replication filter on a replication\nchannel:\n\nCHANGE REPLICATION FILTER REPLICATE_DO_DB = (d1) FOR CHANNEL channel_1;\n\nThis enables you to create a channel specific replication filter to\nfilter out selected data from a source. When a FOR CHANNEL clause is\nprovided, the replication filter statement acts on that slave\nreplication channel removing any existing replication filter which has\nthe same filter type as the specified replication filters, and\nreplacing them with the specified filter. Filter types not explicitly\nlisted in the statement are not modified. If issued against a slave\nreplication channel which is not configured, the statement fails with\nan ER_SLAVE_CONFIGURATION error. If issued against Group Replication\nchannels, the statement fails with an\nER_SLAVE_CHANNEL_OPERATION_NOT_ALLOWED error.\n\nOn a replication slave with multiple replication channels configured,\nissuing CHANGE REPLICATION FILTER with no FOR CHANNEL clause configures\nthe replication filter for every configured slave replication channel,\nand for the global replication filters. For every filter type, if the\nfilter type is listed in the statement, then any existing filter rules\nof that type are replaced by the filter rules specified in the most\nrecently issued statement, otherwise the old value of the filter type\nis retained. For more information see\nhttp://dev.mysql.com/doc/refman/8.0/en/replication-rules-channel-based-\nfilters.html.\n\nIf the same filtering rule is specified multiple times, only the last\nsuch rule is actually used. For example, the two statements shown here\nhave exactly the same effect, because the first REPLICATE_DO_DB rule in\nthe first statement is ignored:\n\nCHANGE REPLICATION FILTER\n    REPLICATE_DO_DB = (db1, db2), REPLICATE_DO_DB = (db3, db4);\n\nCHANGE REPLICATION FILTER\n    REPLICATE_DO_DB = (db3, db4);\n\n*Caution*:\n\nThis behavior differs from that of the --replicate-* filter options\nwhere specifying the same option multiple times causes the creation of\nmultiple filter rules.\n\nNames of tables and database not containing any special characters need\nnot be quoted. Values used with REPLICATION_WILD_TABLE and\nREPLICATION_WILD_IGNORE_TABLE are string expressions, possibly\ncontaining (special) wildcard characters, and so must be quoted. This\nis shown in the following example statements:\n\nCHANGE REPLICATION FILTER\n    REPLICATE_WILD_DO_TABLE = (\'db1.old%\');\n\nCHANGE REPLICATION FILTER\n    REPLICATE_WILD_IGNORE_TABLE = (\'db1.new%\', \'db2.new%\');\n\nValues used with REPLICATE_REWRITE_DB represent pairs of database\nnames; each such value must be enclosed in parentheses. The following\nstatement rewrites statements occurring on database db1 on the master\nto database db2 on the slave:\n\nCHANGE REPLICATION FILTER REPLICATE_REWRITE_DB = ((db1, db2));\n\nThe statement just shown contains two sets of parentheses, one\nenclosing the pair of database names, and the other enclosing the\nentire list. This is perhaps more easily seen in the following example,\nwhich creates two rewrite-db rules, one rewriting database dbA to dbB,\nand one rewriting database dbC to dbD:\n\nCHANGE REPLICATION FILTER\n  REPLICATE_REWRITE_DB = ((dbA, dbB), (dbC, dbD));\n\nThe CHANGE REPLICATION FILTER statement replaces replication filtering\nrules only for the filter types and replication channels affected by\nthe statement, and leaves other rules and channels unchanged. If you\nwant to unset all filters of a given type, set the filter\'s value to an\nexplicitly empty list, as shown in this example, which removes all\nexisting REPLICATE_DO_DB and REPLICATE_IGNORE_DB rules:\n\nCHANGE REPLICATION FILTER\n    REPLICATE_DO_DB = (), REPLICATE_IGNORE_DB = ();\n\nSetting a filter to empty in this way removes all existing rules, does\nnot create any new ones, and does not restore any rules set at mysqld\nstartup using --replicate-* options on the command line or in the\nconfiguration file.\n\nThe RESET SLAVE ALL statement removes channel specific replication\nfilters that were set on channels deleted by the statement. When the\ndeleted channel or channels are recreated, any global replication\nfilters specified for the slave are copied to them, and no channel\nspecific replication filters are applied.\n\nFor more information, see\nhttp://dev.mysql.com/doc/refman/8.0/en/replication-rules.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/change-replication-filter.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/change-replication-filter.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (84,11,'CHAR','[NATIONAL] CHAR[(M)] [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nA fixed-length string that is always right-padded with spaces to the\nspecified length when stored. M represents the column length in\ncharacters. The range of M is 0 to 255. If M is omitted, the length is\n1.\n\n*Note*:\n\nTrailing spaces are removed when CHAR values are retrieved unless the\nPAD_CHAR_TO_FULL_LENGTH SQL mode is enabled.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (85,11,'CHAR BYTE','The CHAR BYTE data type is an alias for the BINARY data type. This is a\ncompatibility feature.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (86,35,'CHAR FUNCTION','Syntax:\nCHAR(N,... [USING charset_name])\n\nCHAR() interprets each argument N as an integer and returns a string\nconsisting of the characters given by the code values of those\nintegers. NULL values are skipped.\nBy default, CHAR() returns a binary string. To produce a string in a\ngiven character set, use the optional USING clause:\n\nmysql> SELECT CHARSET(CHAR(X\'65\')), CHARSET(CHAR(X\'65\' USING utf8));\n+----------------------+---------------------------------+\n| CHARSET(CHAR(X\'65\')) | CHARSET(CHAR(X\'65\' USING utf8)) |\n+----------------------+---------------------------------+\n| binary               | utf8                            |\n+----------------------+---------------------------------+\n\nIf USING is given and the result string is illegal for the given\ncharacter set, a warning is issued. Also, if strict SQL mode is\nenabled, the result from CHAR() becomes NULL.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT CHAR(77,121,83,81,\'76\');\n        -> \'MySQL\'\nmysql> SELECT CHAR(77,77.3,\'77.3\');\n        -> \'MMM\'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (87,35,'CHARACTER_LENGTH','Syntax:\nCHARACTER_LENGTH(str)\n\nCHARACTER_LENGTH() is a synonym for CHAR_LENGTH().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (88,23,'CHARSET','Syntax:\nCHARSET(str)\n\nReturns the character set of the string argument.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/information-functions.html\n\n','mysql> SELECT CHARSET(\'abc\');\n        -> \'utf8\'\nmysql> SELECT CHARSET(CONVERT(\'abc\' USING latin1));\n        -> \'latin1\'\nmysql> SELECT CHARSET(USER());\n        -> \'utf8\'\n','http://dev.mysql.com/doc/refman/8.0/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (89,35,'CHAR_LENGTH','Syntax:\nCHAR_LENGTH(str)\n\nReturns the length of the string str, measured in characters. A\nmultibyte character counts as a single character. This means that for a\nstring containing five 2-byte characters, LENGTH() returns 10, whereas\nCHAR_LENGTH() returns 5.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (90,36,'CHECK TABLE','Syntax:\nCHECK TABLE tbl_name [, tbl_name] ... [option] ...\n\noption: {\n    FOR UPGRADE\n  | QUICK\n  | FAST\n  | MEDIUM\n  | EXTENDED\n  | CHANGED\n}\n\nCHECK TABLE checks a table or tables for errors. CHECK TABLE can also\ncheck views for problems, such as tables that are referenced in the\nview definition that no longer exist.\n\nTo check a table, you must have some privilege for it.\n\nCHECK TABLE works for InnoDB, MyISAM, ARCHIVE, and CSV tables.\n\nBefore running CHECK TABLE on InnoDB tables, see\nhttp://dev.mysql.com/doc/refman/8.0/en/check-table.html#check-table-inn\nodb.\n\nCHECK TABLE is supported for partitioned tables, and you can use ALTER\nTABLE ... CHECK PARTITION to check one or more partitions; for more\ninformation, see [HELP ALTER TABLE], and\nhttp://dev.mysql.com/doc/refman/8.0/en/partitioning-maintenance.html.\n\nCHECK TABLE ignores virtual generated columns that are not indexed.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/check-table.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/check-table.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (91,36,'CHECKSUM TABLE','Syntax:\nCHECKSUM TABLE tbl_name [, tbl_name] ... [QUICK | EXTENDED]\n\nCHECKSUM TABLE reports a checksum for the contents of a table. You can\nuse this statement to verify that the contents are the same before and\nafter a backup, rollback, or other operation that is intended to put\nthe data back to a known state.\n\nThis statement requires the SELECT privilege for the table.\n\nThis statement is not supported for views. If you run CHECKSUM TABLE\nagainst a view, the Checksum value is always NULL, and a warning is\nreturned.\n\nFor a nonexistent table, CHECKSUM TABLE returns NULL and generates a\nwarning.\n\nDuring the checksum operation, the table is locked with a read lock for\nInnoDB and MyISAM.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/checksum-table.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/checksum-table.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (92,6,'CLOSE','Syntax:\nCLOSE cursor_name\n\nThis statement closes a previously opened cursor. For an example, see\nhttp://dev.mysql.com/doc/refman/8.0/en/cursors.html.\n\nAn error occurs if the cursor is not open.\n\nIf not closed explicitly, a cursor is closed at the end of the BEGIN\n... END block in which it was declared.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/close.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/close.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (93,4,'COALESCE','Syntax:\nCOALESCE(value,...)\n\nReturns the first non-NULL value in the list, or NULL if there are no\nnon-NULL values.\n\nThe return type of COALESCE() is the aggregated type of the argument\ntypes.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html\n\n','mysql> SELECT COALESCE(NULL,1);\n        -> 1\nmysql> SELECT COALESCE(NULL,NULL,NULL);\n        -> NULL\n','http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (94,23,'COERCIBILITY','Syntax:\nCOERCIBILITY(str)\n\nReturns the collation coercibility value of the string argument.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/information-functions.html\n\n','mysql> SELECT COERCIBILITY(\'abc\' COLLATE utf8_swedish_ci);\n        -> 0\nmysql> SELECT COERCIBILITY(USER());\n        -> 3\nmysql> SELECT COERCIBILITY(\'abc\');\n        -> 4\nmysql> SELECT COERCIBILITY(1000);\n        -> 5\n','http://dev.mysql.com/doc/refman/8.0/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (95,23,'COLLATION','Syntax:\nCOLLATION(str)\n\nReturns the collation of the string argument.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/information-functions.html\n\n','mysql> SELECT COLLATION(\'abc\');\n        -> \'utf8_general_ci\'\nmysql> SELECT COLLATION(_utf8mb4\'abc\');\n        -> \'utf8mb4_0900_ai_ci\'\nmysql> SELECT COLLATION(_latin1\'abc\');\n        -> \'latin1_swedish_ci\'\n','http://dev.mysql.com/doc/refman/8.0/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (96,13,'COMPRESS','Syntax:\nCOMPRESS(string_to_compress)\n\nCompresses a string and returns the result as a binary string. This\nfunction requires MySQL to have been compiled with a compression\nlibrary such as zlib. Otherwise, the return value is always NULL. The\ncompressed string can be uncompressed with UNCOMPRESS().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html\n\n','mysql> SELECT LENGTH(COMPRESS(REPEAT(\'a\',1000)));\n        -> 21\nmysql> SELECT LENGTH(COMPRESS(\'\'));\n        -> 0\nmysql> SELECT LENGTH(COMPRESS(\'a\'));\n        -> 13\nmysql> SELECT LENGTH(COMPRESS(REPEAT(\'a\',16)));\n        -> 15\n','http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (97,35,'CONCAT','Syntax:\nCONCAT(str1,str2,...)\n\nReturns the string that results from concatenating the arguments. May\nhave one or more arguments. If all arguments are nonbinary strings, the\nresult is a nonbinary string. If the arguments include any binary\nstrings, the result is a binary string. A numeric argument is converted\nto its equivalent nonbinary string form.\n\nCONCAT() returns NULL if any argument is NULL.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT CONCAT(\'My\', \'S\', \'QL\');\n        -> \'MySQL\'\nmysql> SELECT CONCAT(\'My\', NULL, \'QL\');\n        -> NULL\nmysql> SELECT CONCAT(14.3);\n        -> \'14.3\'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (98,35,'CONCAT_WS','Syntax:\nCONCAT_WS(separator,str1,str2,...)\n\nCONCAT_WS() stands for Concatenate With Separator and is a special form\nof CONCAT(). The first argument is the separator for the rest of the\narguments. The separator is added between the strings to be\nconcatenated. The separator can be a string, as can the rest of the\narguments. If the separator is NULL, the result is NULL.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT CONCAT_WS(\',\',\'First name\',\'Second name\',\'Last Name\');\n        -> \'First name,Second name,Last Name\'\nmysql> SELECT CONCAT_WS(\',\',\'First name\',NULL,\'Last Name\');\n        -> \'First name,Last Name\'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (99,23,'CONNECTION_ID','Syntax:\nCONNECTION_ID()\n\nReturns the connection ID (thread ID) for the connection. Every\nconnection has an ID that is unique among the set of currently\nconnected clients.\n\nThe value returned by CONNECTION_ID() is the same type of value as\ndisplayed in the ID column of the INFORMATION_SCHEMA.PROCESSLIST table,\nthe Id column of SHOW PROCESSLIST output, and the PROCESSLIST_ID column\nof the Performance Schema threads table.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/information-functions.html\n\n','mysql> SELECT CONNECTION_ID();\n        -> 23786\n','http://dev.mysql.com/doc/refman/8.0/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (100,9,'CONSTRAINT','MySQL supports foreign keys, which let you cross-reference related data\nacross tables, and foreign key constraints, which help keep this\nspread-out data consistent. The essential syntax for a foreign key\nconstraint definition in a CREATE TABLE or ALTER TABLE statement looks\nlike this:\n\n[CONSTRAINT [symbol]] FOREIGN KEY\n    [index_name] (col_name, ...)\n    REFERENCES tbl_name (col_name,...)\n    [ON DELETE reference_option]\n    [ON UPDATE reference_option]\n\nreference_option:\n    RESTRICT | CASCADE | SET NULL | NO ACTION | SET DEFAULT\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/create-table-foreign-keys.html\n\n','CREATE TABLE product (\n    category INT NOT NULL, id INT NOT NULL,\n    price DECIMAL,\n    PRIMARY KEY(category, id)\n)   ENGINE=INNODB;\n\nCREATE TABLE customer (\n    id INT NOT NULL,\n    PRIMARY KEY (id)\n)   ENGINE=INNODB;\n\nCREATE TABLE product_order (\n    no INT NOT NULL AUTO_INCREMENT,\n    product_category INT NOT NULL,\n    product_id INT NOT NULL,\n    customer_id INT NOT NULL,\n\n    PRIMARY KEY(no),\n    INDEX (product_category, product_id),\n    INDEX (customer_id),\n\n    FOREIGN KEY (product_category, product_id)\n      REFERENCES product(category, id)\n      ON UPDATE CASCADE ON DELETE RESTRICT,\n\n    FOREIGN KEY (customer_id)\n      REFERENCES customer(id)\n)   ENGINE=INNODB;\n','http://dev.mysql.com/doc/refman/8.0/en/create-table-foreign-keys.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (101,30,'CONV','Syntax:\nCONV(N,from_base,to_base)\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base\nto_base. Returns NULL if any argument is NULL. The argument N is\ninterpreted as an integer, but may be specified as an integer or a\nstring. The minimum base is 2 and the maximum base is 36. If from_base\nis a negative number, N is regarded as a signed number. Otherwise, N is\ntreated as unsigned. CONV() works with 64-bit precision.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT CONV(\'a\',16,2);\n        -> \'1010\'\nmysql> SELECT CONV(\'6E\',18,8);\n        -> \'172\'\nmysql> SELECT CONV(-17,10,-18);\n        -> \'-H\'\nmysql> SELECT CONV(10+\'10\'+\'10\'+X\'0a\',10,10);\n        -> \'40\'\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (102,35,'CONVERT','Syntax:\nCONVERT(expr,type), CONVERT(expr USING transcoding_name)\n\nThe CONVERT() function takes an expression of any type and produces a\nresult value of the specified type.\n\nDiscussion of CONVERT(expr, type) syntax here also applies to CAST(expr\nAS type), which is equivalent.\n\nCONVERT(... USING ...) is standard SQL syntax. The non-USING form of\nCONVERT() is ODBC syntax.\n\nCONVERT() with USING converts data between different character sets. In\nMySQL, transcoding names are the same as the corresponding character\nset names. For example, this statement converts the string \'abc\' in the\ndefault character set to the corresponding string in the utf8 character\nset:\n\nSELECT CONVERT(\'abc\' USING utf8);\n\nCONVERT() without USING and CAST() take an expression and a type value\nspecifying the result type. These type values are permitted:\n\no BINARY[(N)]\n\n  Produces a string with the BINARY data type. See\n  http://dev.mysql.com/doc/refman/8.0/en/binary-varbinary.html for a\n  description of how this affects comparisons. If the optional length N\n  is given, BINARY(N) causes the cast to use no more than N bytes of\n  the argument. Values shorter than N bytes are padded with 0x00 bytes\n  to a length of N.\n\no CHAR[(N)] [charset_info]\n\n  Produces a string with the CHAR data type. If the optional length N\n  is given, CHAR(N) causes the cast to use no more than N characters of\n  the argument. No padding occurs for values shorter than N characters.\n\n  With no charset_info clause, CHAR produces a string with the default\n  character set. To specify the character set explicitly, these\n  charset_info values are permitted:\n\n  o CHARACTER SET charset_name: Produces a string with the given\n    character set.\n\n  o ASCII: Shorthand for CHARACTER SET latin1.\n\n  o UNICODE: Shorthand for CHARACTER SET ucs2.\n\n  In all cases, the string has the default collation for the character\n  set.\n\no DATE\n\n  Produces a DATE value.\n\no DATETIME\n\n  Produces a DATETIME value.\n\no DECIMAL[(M[,D])]\n\n  Produces a DECIMAL value. If the optional M and D values are given,\n  they specify the maximum number of digits (the precision) and the\n  number of digits following the decimal point (the scale).\n\no JSON\n\n  Produces a JSON value. For details on the rules for conversion of\n  values between JSON and other types, see\n  http://dev.mysql.com/doc/refman/8.0/en/json.html#json-comparison.\n\no NCHAR[(N)]\n\n  Like CHAR, but produces a string with the national character set. See\n  http://dev.mysql.com/doc/refman/8.0/en/charset-national.html.\n\n  Unlike CHAR, NCHAR does not permit trailing character set information\n  to be specified.\n\no SIGNED [INTEGER]\n\n  Produces a signed integer value.\n\no TIME\n\n  Produces a TIME value.\n\no UNSIGNED [INTEGER]\n\n  Produces an unsigned integer value.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/cast-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/cast-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (103,12,'CONVERT_TZ','Syntax:\nCONVERT_TZ(dt,from_tz,to_tz)\n\nCONVERT_TZ() converts a datetime value dt from the time zone given by\nfrom_tz to the time zone given by to_tz and returns the resulting\nvalue. Time zones are specified as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/time-zone-support.html. This\nfunction returns NULL if the arguments are invalid.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT CONVERT_TZ(\'2004-01-01 12:00:00\',\'GMT\',\'MET\');\n        -> \'2004-01-01 13:00:00\'\nmysql> SELECT CONVERT_TZ(\'2004-01-01 12:00:00\',\'+00:00\',\'+10:00\');\n        -> \'2004-01-01 22:00:00\'\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (104,30,'COS','Syntax:\nCOS(X)\n\nReturns the cosine of X, where X is given in radians.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT COS(PI());\n        -> -1\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (105,30,'COT','Syntax:\nCOT(X)\n\nReturns the cotangent of X.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT COT(12);\n        -> -1.5726734063977\nmysql> SELECT COT(0);\n        -> out-of-range error\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (106,15,'COUNT','Syntax:\nCOUNT(expr) [over_clause]\n\nReturns a count of the number of non-NULL values of expr in the rows\nretrieved by a SELECT statement. The result is a BIGINT value.\n\nIf there are no matching rows, COUNT() returns 0.\n\nThis function executes as a window function if over_clause is present.\nover_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html\n\n','mysql> SELECT student.student_name,COUNT(*)\n       FROM student,course\n       WHERE student.student_id=course.student_id\n       GROUP BY student_name;\n','http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (107,15,'COUNT DISTINCT','Syntax:\nCOUNT(DISTINCT expr,[expr...])\n\nReturns a count of the number of rows with different non-NULL expr\nvalues.\n\nIf there are no matching rows, COUNT(DISTINCT) returns 0.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html\n\n','mysql> SELECT COUNT(DISTINCT results) FROM student;\n','http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (108,30,'CRC32','Syntax:\nCRC32(expr)\n\nComputes a cyclic redundancy check value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is\nexpected to be a string and (if possible) is treated as one if it is\nnot.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT CRC32(\'MySQL\');\n        -> 3259397556\nmysql> SELECT CRC32(\'mysql\');\n        -> 2501908538\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (109,9,'CREATE DATABASE','Syntax:\nCREATE {DATABASE | SCHEMA} [IF NOT EXISTS] db_name\n    [create_specification] ...\n\ncreate_specification:\n    [DEFAULT] CHARACTER SET [=] charset_name\n  | [DEFAULT] COLLATE [=] collation_name\n\nCREATE DATABASE creates a database with the given name. To use this\nstatement, you need the CREATE privilege for the database. CREATE\nSCHEMA is a synonym for CREATE DATABASE.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/create-database.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/create-database.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (110,9,'CREATE EVENT','Syntax:\nCREATE\n    [DEFINER = { user | CURRENT_USER }]\n    EVENT\n    [IF NOT EXISTS]\n    event_name\n    ON SCHEDULE schedule\n    [ON COMPLETION [NOT] PRESERVE]\n    [ENABLE | DISABLE | DISABLE ON SLAVE]\n    [COMMENT \'string\']\n    DO event_body;\n\nschedule:\n    AT timestamp [+ INTERVAL interval] ...\n  | EVERY interval\n    [STARTS timestamp [+ INTERVAL interval] ...]\n    [ENDS timestamp [+ INTERVAL interval] ...]\n\ninterval:\n    quantity {YEAR | QUARTER | MONTH | DAY | HOUR | MINUTE |\n              WEEK | SECOND | YEAR_MONTH | DAY_HOUR | DAY_MINUTE |\n              DAY_SECOND | HOUR_MINUTE | HOUR_SECOND | MINUTE_SECOND}\n\nThis statement creates and schedules a new event. The event will not\nrun unless the Event Scheduler is enabled. For information about\nchecking Event Scheduler status and enabling it if necessary, see\nhttp://dev.mysql.com/doc/refman/8.0/en/events-configuration.html.\n\nCREATE EVENT requires the EVENT privilege for the schema in which the\nevent is to be created. It might also require the SET_USER_ID or SUPER\nprivilege, depending on the DEFINER value, as described later in this\nsection.\n\nThe minimum requirements for a valid CREATE EVENT statement are as\nfollows:\n\no The keywords CREATE EVENT plus an event name, which uniquely\n  identifies the event in a database schema.\n\no An ON SCHEDULE clause, which determines when and how often the event\n  executes.\n\no A DO clause, which contains the SQL statement to be executed by an\n  event.\n\nThis is an example of a minimal CREATE EVENT statement:\n\nCREATE EVENT myevent\n    ON SCHEDULE AT CURRENT_TIMESTAMP + INTERVAL 1 HOUR\n    DO\n      UPDATE myschema.mytable SET mycol = mycol + 1;\n\nThe previous statement creates an event named myevent. This event\nexecutes once---one hour following its creation---by running an SQL\nstatement that increments the value of the myschema.mytable table\'s\nmycol column by 1.\n\nThe event_name must be a valid MySQL identifier with a maximum length\nof 64 characters. Event names are not case-sensitive, so you cannot\nhave two events named myevent and MyEvent in the same schema. In\ngeneral, the rules governing event names are the same as those for\nnames of stored routines. See\nhttp://dev.mysql.com/doc/refman/8.0/en/identifiers.html.\n\nAn event is associated with a schema. If no schema is indicated as part\nof event_name, the default (current) schema is assumed. To create an\nevent in a specific schema, qualify the event name with a schema using\nschema_name.event_name syntax.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/create-event.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/create-event.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (111,9,'CREATE FUNCTION','The CREATE FUNCTION statement is used to create stored functions and\nuser-defined functions (UDFs):\n\no For information about creating stored functions, see [HELP CREATE\n  PROCEDURE].\n\no For information about creating user-defined functions, see [HELP\n  CREATE FUNCTION UDF].\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/create-function.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/create-function.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (112,38,'CREATE FUNCTION UDF','Syntax:\nCREATE [AGGREGATE] FUNCTION function_name\n    RETURNS {STRING|INTEGER|REAL|DECIMAL}\n    SONAME shared_library_name\n\nA user-defined function (UDF) is a way to extend MySQL with a new\nfunction that works like a native (built-in) MySQL function such as\nABS() or CONCAT().\n\nfunction_name is the name that should be used in SQL statements to\ninvoke the function. The RETURNS clause indicates the type of the\nfunction\'s return value. DECIMAL is a legal value after RETURNS, but\ncurrently DECIMAL functions return string values and should be written\nlike STRING functions.\n\nshared_library_name is the base name of the shared library file that\ncontains the code that implements the function. The file must be\nlocated in the plugin directory. This directory is given by the value\nof the plugin_dir system variable. For more information, see\nhttp://dev.mysql.com/doc/refman/8.0/en/udf-loading.html.\n\nTo create a function, you must have the INSERT privilege for the mysql\nsystem database. This is necessary because CREATE FUNCTION adds a row\nto the mysql.func system table that records the function\'s name, type,\nand shared library name.\n\nUDFs registered using CREATE FUNCTION are listed in the Performance\nSchema user_defined_functions table; see\nhttp://dev.mysql.com/doc/refman/8.0/en/user-defined-functions-table.htm\nl.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/create-function-udf.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/create-function-udf.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (113,9,'CREATE INDEX','Syntax:\nCREATE [UNIQUE | FULLTEXT | SPATIAL] INDEX index_name\n    [index_type]\n    ON tbl_name (key_part,...)\n    [index_option]\n    [algorithm_option | lock_option] ...\n\nkey_part: {col_name [(length)] | (expr)} [ASC | DESC]\n\nindex_option:\n    KEY_BLOCK_SIZE [=] value\n  | index_type\n  | WITH PARSER parser_name\n  | COMMENT \'string\'\n  | {VISIBLE | INVISIBLE}\n\nindex_type:\n    USING {BTREE | HASH}\n\nalgorithm_option:\n    ALGORITHM [=] {DEFAULT | INPLACE | COPY}\n\nlock_option:\n    LOCK [=] {DEFAULT | NONE | SHARED | EXCLUSIVE}\n\nNormally, you create all indexes on a table at the time the table\nitself is created with CREATE TABLE. See [HELP CREATE TABLE]. This\nguideline is especially important for InnoDB tables, where the primary\nkey determines the physical layout of rows in the data file. CREATE\nINDEX enables you to add indexes to existing tables.\n\nCREATE INDEX is mapped to an ALTER TABLE statement to create indexes.\nSee [HELP ALTER TABLE]. CREATE INDEX cannot be used to create a PRIMARY\nKEY; use ALTER TABLE instead. For more information about indexes, see\nhttp://dev.mysql.com/doc/refman/8.0/en/mysql-indexes.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/create-index.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/create-index.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (114,9,'CREATE LOGFILE GROUP','Syntax:\nCREATE LOGFILE GROUP logfile_group\n    ADD UNDOFILE \'undo_file\'\n    [INITIAL_SIZE [=] initial_size]\n    [UNDO_BUFFER_SIZE [=] undo_buffer_size]\n    [REDO_BUFFER_SIZE [=] redo_buffer_size]\n    [NODEGROUP [=] nodegroup_id]\n    [WAIT]\n    [COMMENT [=] \'string\']\n    ENGINE [=] engine_name\n\nThis statement creates a new log file group named logfile_group having\na single UNDO file named \'undo_file\'. A CREATE LOGFILE GROUP statement\nhas one and only one ADD UNDOFILE clause. For rules covering the naming\nof log file groups, see\nhttp://dev.mysql.com/doc/refman/8.0/en/identifiers.html.\n\n*Note*:\n\nAll NDB Cluster Disk Data objects share the same namespace. This means\nthat each Disk Data object must be uniquely named (and not merely each\nDisk Data object of a given type). For example, you cannot have a\ntablespace and a log file group with the same name, or a tablespace and\na data file with the same name.\n\nThere can be only one log file group per NDB Cluster instance at any\ngiven time.\n\nThe optional INITIAL_SIZE parameter sets the UNDO file\'s initial size;\nif not specified, it defaults to 128M (128 megabytes). The optional\nUNDO_BUFFER_SIZE parameter sets the size used by the UNDO buffer for\nthe log file group; The default value for UNDO_BUFFER_SIZE is 8M (eight\nmegabytes); this value cannot exceed the amount of system memory\navailable. Both of these parameters are specified in bytes. You may\noptionally follow either or both of these with a one-letter\nabbreviation for an order of magnitude, similar to those used in\nmy.cnf. Generally, this is one of the letters M (for megabytes) or G\n(for gigabytes).\n\nMemory used for UNDO_BUFFER_SIZE comes from the global pool whose size\nis determined by the value of the SharedGlobalMemory data node\nconfiguration parameter. This includes any default value implied for\nthis option by the setting of the InitialLogFileGroup data node\nconfiguration parameter.\n\nThe maximum permitted for UNDO_BUFFER_SIZE is 629145600 (600 MB).\n\nOn 32-bit systems, the maximum supported value for INITIAL_SIZE is\n4294967296 (4 GB). (Bug #29186)\n\nThe minimum allowed value for INITIAL_SIZE is 1048576 (1 MB).\n\nThe ENGINE option determines the storage engine to be used by this log\nfile group, with engine_name being the name of the storage engine. In\nMySQL 8.0, this must be NDB (or NDBCLUSTER). If ENGINE is not set,\nMySQL tries to use the engine specified by the default_storage_engine\nserver system variable (formerly storage_engine\n(http://dev.mysql.com/doc/refman/5.7/en/server-system-variables.html#sy\nsvar_storage_engine)). In any case, if the engine is not specified as\nNDB or NDBCLUSTER, the CREATE LOGFILE GROUP statement appears to\nsucceed but actually fails to create the log file group, as shown here:\n\nmysql> CREATE LOGFILE GROUP lg1\n    ->     ADD UNDOFILE \'undo.dat\' INITIAL_SIZE = 10M;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nmysql> SHOW WARNINGS;\n+-------+------+------------------------------------------------------------------------------------------------+\n| Level | Code | Message                                                                                        |\n+-------+------+------------------------------------------------------------------------------------------------+\n| Error | 1478 | Table storage engine \'InnoDB\' does not support the create option \'TABLESPACE or LOGFILE GROUP\' |\n+-------+------+------------------------------------------------------------------------------------------------+\n1 row in set (0.00 sec)\n\nmysql> DROP LOGFILE GROUP lg1 ENGINE = NDB;            \nERROR 1529 (HY000): Failed to drop LOGFILE GROUP\n\nmysql> CREATE LOGFILE GROUP lg1\n    ->     ADD UNDOFILE \'undo.dat\' INITIAL_SIZE = 10M\n    ->     ENGINE = NDB;\nQuery OK, 0 rows affected (2.97 sec)\n\nThe fact that the CREATE LOGFILE GROUP statement does not actually\nreturn an error when a non-NDB storage engine is named, but rather\nappears to succeed, is a known issue which we hope to address in a\nfuture release of NDB Cluster.\n\nREDO_BUFFER_SIZE, NODEGROUP, WAIT, and COMMENT are parsed but ignored,\nand so have no effect in MySQL 8.0. These options are intended for\nfuture expansion.\n\nWhen used with ENGINE [=] NDB, a log file group and associated UNDO log\nfile are created on each Cluster data node. You can verify that the\nUNDO files were created and obtain information about them by querying\nthe INFORMATION_SCHEMA.FILES table. For example:\n\nmysql> SELECT LOGFILE_GROUP_NAME, LOGFILE_GROUP_NUMBER, EXTRA\n    -> FROM INFORMATION_SCHEMA.FILES\n    -> WHERE FILE_NAME = \'undo_10.dat\';\n+--------------------+----------------------+----------------+\n| LOGFILE_GROUP_NAME | LOGFILE_GROUP_NUMBER | EXTRA          |\n+--------------------+----------------------+----------------+\n| lg_3               |                   11 | CLUSTER_NODE=3 |\n| lg_3               |                   11 | CLUSTER_NODE=4 |\n+--------------------+----------------------+----------------+\n2 rows in set (0.06 sec)\n\nCREATE LOGFILE GROUP is useful only with Disk Data storage for NDB\nCluster. See\nhttp://dev.mysql.com/doc/refman/8.0/en/mysql-cluster-disk-data.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/create-logfile-group.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/create-logfile-group.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (115,9,'CREATE PROCEDURE','Syntax:\nCREATE\n    [DEFINER = { user | CURRENT_USER }]\n    PROCEDURE sp_name ([proc_parameter[,...]])\n    [characteristic ...] routine_body\n\nCREATE\n    [DEFINER = { user | CURRENT_USER }]\n    FUNCTION sp_name ([func_parameter[,...]])\n    RETURNS type\n    [characteristic ...] routine_body\n\nproc_parameter:\n    [ IN | OUT | INOUT ] param_name type\n\nfunc_parameter:\n    param_name type\n\ntype:\n    Any valid MySQL data type\n\ncharacteristic:\n    COMMENT \'string\'\n  | LANGUAGE SQL\n  | [NOT] DETERMINISTIC\n  | { CONTAINS SQL | NO SQL | READS SQL DATA | MODIFIES SQL DATA }\n  | SQL SECURITY { DEFINER | INVOKER }\n\nroutine_body:\n    Valid SQL routine statement\n\nThese statements create stored routines. By default, a routine is\nassociated with the default database. To associate the routine\nexplicitly with a given database, specify the name as db_name.sp_name\nwhen you create it.\n\nThe CREATE FUNCTION statement is also used in MySQL to support UDFs\n(user-defined functions). See\nhttp://dev.mysql.com/doc/refman/8.0/en/adding-functions.html. A UDF can\nbe regarded as an external stored function. Stored functions share\ntheir namespace with UDFs. See\nhttp://dev.mysql.com/doc/refman/8.0/en/function-resolution.html, for\nthe rules describing how the server interprets references to different\nkinds of functions.\n\nTo invoke a stored procedure, use the CALL statement (see [HELP CALL]).\nTo invoke a stored function, refer to it in an expression. The function\nreturns a value during expression evaluation.\n\nCREATE PROCEDURE and CREATE FUNCTION require the CREATE ROUTINE\nprivilege. They might also require the SET_USER_ID or SUPER privilege,\ndepending on the DEFINER value, as described later in this section. If\nbinary logging is enabled, CREATE FUNCTION might require the SUPER\nprivilege, as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/stored-programs-logging.html.\n\nBy default, MySQL automatically grants the ALTER ROUTINE and EXECUTE\nprivileges to the routine creator. This behavior can be changed by\ndisabling the automatic_sp_privileges system variable. See\nhttp://dev.mysql.com/doc/refman/8.0/en/stored-routines-privileges.html.\n\nThe DEFINER and SQL SECURITY clauses specify the security context to be\nused when checking access privileges at routine execution time, as\ndescribed later in this section.\n\nIf the routine name is the same as the name of a built-in SQL function,\na syntax error occurs unless you use a space between the name and the\nfollowing parenthesis when defining the routine or invoking it later.\nFor this reason, avoid using the names of existing SQL functions for\nyour own stored routines.\n\nThe IGNORE_SPACE SQL mode applies to built-in functions, not to stored\nroutines. It is always permissible to have spaces after a stored\nroutine name, regardless of whether IGNORE_SPACE is enabled.\n\nThe parameter list enclosed within parentheses must always be present.\nIf there are no parameters, an empty parameter list of () should be\nused. Parameter names are not case sensitive.\n\nEach parameter is an IN parameter by default. To specify otherwise for\na parameter, use the keyword OUT or INOUT before the parameter name.\n\n*Note*:\n\nSpecifying a parameter as IN, OUT, or INOUT is valid only for a\nPROCEDURE. For a FUNCTION, parameters are always regarded as IN\nparameters.\n\nAn IN parameter passes a value into a procedure. The procedure might\nmodify the value, but the modification is not visible to the caller\nwhen the procedure returns. An OUT parameter passes a value from the\nprocedure back to the caller. Its initial value is NULL within the\nprocedure, and its value is visible to the caller when the procedure\nreturns. An INOUT parameter is initialized by the caller, can be\nmodified by the procedure, and any change made by the procedure is\nvisible to the caller when the procedure returns.\n\nFor each OUT or INOUT parameter, pass a user-defined variable in the\nCALL statement that invokes the procedure so that you can obtain its\nvalue when the procedure returns. If you are calling the procedure from\nwithin another stored procedure or function, you can also pass a\nroutine parameter or local routine variable as an OUT or INOUT\nparameter. If you are calling the procedure from within a trigger, you\ncan also pass NEW.col_name as an OUT or INOUT parameter.\n\nFor information about the effect of unhandled conditions on procedure\nparameters, see\nhttp://dev.mysql.com/doc/refman/8.0/en/conditions-and-parameters.html.\n\nRoutine parameters cannot be referenced in statements prepared within\nthe routine; see\nhttp://dev.mysql.com/doc/refman/8.0/en/stored-program-restrictions.html\n.\n\nThe following example shows a simple stored procedure that uses an OUT\nparameter:\n\nmysql> delimiter //\n\nmysql> CREATE PROCEDURE simpleproc (OUT param1 INT)\n    -> BEGIN\n    ->   SELECT COUNT(*) INTO param1 FROM t;\n    -> END//\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> delimiter ;\n\nmysql> CALL simpleproc(@a);\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT @a;\n+------+\n| @a   |\n+------+\n| 3    |\n+------+\n1 row in set (0.00 sec)\n\nThe example uses the mysql client delimiter command to change the\nstatement delimiter from ; to // while the procedure is being defined.\nThis enables the ; delimiter used in the procedure body to be passed\nthrough to the server rather than being interpreted by mysql itself.\nSee\nhttp://dev.mysql.com/doc/refman/8.0/en/stored-programs-defining.html.\n\nThe RETURNS clause may be specified only for a FUNCTION, for which it\nis mandatory. It indicates the return type of the function, and the\nfunction body must contain a RETURN value statement. If the RETURN\nstatement returns a value of a different type, the value is coerced to\nthe proper type. For example, if a function specifies an ENUM or SET\nvalue in the RETURNS clause, but the RETURN statement returns an\ninteger, the value returned from the function is the string for the\ncorresponding ENUM member of set of SET members.\n\nThe following example function takes a parameter, performs an operation\nusing an SQL function, and returns the result. In this case, it is\nunnecessary to use delimiter because the function definition contains\nno internal ; statement delimiters:\n\nmysql> CREATE FUNCTION hello (s CHAR(20))\nmysql> RETURNS CHAR(50) DETERMINISTIC\n    -> RETURN CONCAT(\'Hello, \',s,\'!\');\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT hello(\'world\');\n+----------------+\n| hello(\'world\') |\n+----------------+\n| Hello, world!  |\n+----------------+\n1 row in set (0.00 sec)\n\nParameter types and function return types can be declared to use any\nvalid data type. The COLLATE attribute can be used if preceded by a\nCHARACTER SET specification.\n\nThe routine_body consists of a valid SQL routine statement. This can be\na simple statement such as SELECT or INSERT, or a compound statement\nwritten using BEGIN and END. Compound statements can contain\ndeclarations, loops, and other control structure statements. The syntax\nfor these statements is described in\nhttp://dev.mysql.com/doc/refman/8.0/en/sql-syntax-compound-statements.h\ntml.\n\nMySQL permits routines to contain DDL statements, such as CREATE and\nDROP. MySQL also permits stored procedures (but not stored functions)\nto contain SQL transaction statements such as COMMIT. Stored functions\nmay not contain statements that perform explicit or implicit commit or\nrollback. Support for these statements is not required by the SQL\nstandard, which states that each DBMS vendor may decide whether to\npermit them.\n\nStatements that return a result set can be used within a stored\nprocedure but not within a stored function. This prohibition includes\nSELECT statements that do not have an INTO var_list clause and other\nstatements such as SHOW, EXPLAIN, and CHECK TABLE. For statements that\ncan be determined at function definition time to return a result set, a\nNot allowed to return a result set from a function error occurs\n(ER_SP_NO_RETSET). For statements that can be determined only at\nruntime to return a result set, a PROCEDURE %s can\'t return a result\nset in the given context error occurs (ER_SP_BADSELECT).\n\nUSE statements within stored routines are not permitted. When a routine\nis invoked, an implicit USE db_name is performed (and undone when the\nroutine terminates). The causes the routine to have the given default\ndatabase while it executes. References to objects in databases other\nthan the routine default database should be qualified with the\nappropriate database name.\n\nFor additional information about statements that are not permitted in\nstored routines, see\nhttp://dev.mysql.com/doc/refman/8.0/en/stored-program-restrictions.html\n.\n\nFor information about invoking stored procedures from within programs\nwritten in a language that has a MySQL interface, see [HELP CALL].\n\nMySQL stores the sql_mode system variable setting in effect when a\nroutine is created or altered, and always executes the routine with\nthis setting in force, regardless of the current server SQL mode when\nthe routine begins executing.\n\nThe switch from the SQL mode of the invoker to that of the routine\noccurs after evaluation of arguments and assignment of the resulting\nvalues to routine parameters. If you define a routine in strict SQL\nmode but invoke it in nonstrict mode, assignment of arguments to\nroutine parameters does not take place in strict mode. If you require\nthat expressions passed to a routine be assigned in strict SQL mode,\nyou should invoke the routine with strict mode in effect.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/create-procedure.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/create-procedure.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (116,1,'CREATE RESOURCE GROUP','Syntax:\nCREATE RESOURCE GROUP group_name\n    TYPE = {SYSTEM|USER}\n    [VCPU [=] vcpu_spec [, vcpu_spec] ...]\n    [THREAD_PRIORITY [=] N]\n    [ENABLE|DISABLE]\n\nvcpu_spec: {N | M - N}\n\nCREATE RESOURCE GROUP is used for resource group management (see\nhttp://dev.mysql.com/doc/refman/8.0/en/resource-groups.html). This\nstatement creates a new resource group and assigns its initial\nattribute values. It requires the RESOURCE_GROUP_ADMIN privilege.\n\ngroup_name identifies which resource group to create. If the group\nalready exists, an error occurs.\n\nThe TYPE attribute is required. It should be SYSTEM for a system\nresource group, USER for a user resource group. The group type affects\npermitted THREAD_PRIORITY values, as described later.\n\nThe VCPU attribute indicates the CPU affinity; that is, the set of\nvirtual CPUs the group can use:\n\no If VCPU is not given, the resource group has no CPU affinity and can\n  use all available CPUs.\n\no If VCPU is given, the attribute value is a list of comma-separated\n  CPU numbers or ranges:\n\n  o Each number must be an integer in the range from 0 to the number of\n    CPUs − 1. For example, on a system with 64 CPUs, the number can\n    range from 0 to 63.\n\n  o A range is given in the form M − N, where M is less than or equal\n    to N and both numbers are in the CPU range.\n\n  o If a CPU number is an integer outside the permitted range or is not\n    an integer, an error occurs.\n\nExample VCPU specifiers (these are all equivalent):\n\nVCPU = 0,1,2,3,9,10\nVCPU = 0-3,9-10\nVCPU = 9,10,0-3\nVCPU = 0,10,1,9,3,2\n\nThe THREAD_PRIORITY attribute indicates the priority for threads\nassigned to the group:\n\no If THREAD_PRIORITY is not given, the default priority is 0.\n\no If THREAD_PRIORITY is given, the attribute value must be in the range\n  from -20 (highest priority) to 19 (lowest priority). The priority for\n  system resource groups must be in the range from -20 to 0. The\n  priority for user resource groups must be in the range from 0 to 19.\n  Use of different ranges for system and user groups ensures that user\n  threads never have a higher priority than system threads.\n\nENABLE and DISABLE specify that the resource group is initially enabled\nor disabled. If neither is specified, the group is enabled by default.\nA disabled group cannot have threads assigned to it.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/create-resource-group.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/create-resource-group.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (117,1,'CREATE ROLE','Syntax:\nCREATE ROLE [IF NOT EXISTS] role [, role ] ...\n\nCREATE ROLE creates one or more roles, which are named collections of\nprivileges. To use this statement, you must have the global CREATE ROLE\nor CREATE USER privilege. When the read_only system variable is\nenabled, CREATE ROLE additionally requires the CONNECTION_ADMIN or\nSUPER privilege.\n\nA role when created is locked, has no password, and is assigned the\ndefault authentication plugin. (These role attributes can be changed\nlater with the ALTER USER statement, by users who have the global\nCREATE USER privilege.)\n\nCREATE ROLE either succeeds for all named roles or rolls back and has\nno effect if any error occurs. By default, an error occurs if you try\nto create a role that already exists. If the IF NOT EXISTS clause is\ngiven, the statement produces a warning for each named role that\nalready exists, rather than an error.\n\nThe statement is written to the binary log if it succeeds, but not if\nit fails; in that case, rollback occurs and no changes are made. A\nstatement written to the binary log includes all named roles. If the IF\nNOT EXISTS clause is given, this includes even roles that already exist\nand were not created.\n\nEach role name uses the format described in\nhttp://dev.mysql.com/doc/refman/8.0/en/role-names.html. For example:\n\nCREATE ROLE \'administrator\', \'developer\';\nCREATE ROLE \'webapp\'@\'localhost\';\n\nThe host name part of the role name, if omitted, defaults to \'%\'.\n\nFor role usage examples, see\nhttp://dev.mysql.com/doc/refman/8.0/en/roles.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/create-role.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/create-role.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (118,9,'CREATE SERVER','Syntax:\nCREATE SERVER server_name\n    FOREIGN DATA WRAPPER wrapper_name\n    OPTIONS (option [, option] ...)\n\noption:\n  { HOST character-literal\n  | DATABASE character-literal\n  | USER character-literal\n  | PASSWORD character-literal\n  | SOCKET character-literal\n  | OWNER character-literal\n  | PORT numeric-literal }\n\nThis statement creates the definition of a server for use with the\nFEDERATED storage engine. The CREATE SERVER statement creates a new row\nin the servers table in the mysql database. This statement requires the\nSUPER privilege.\n\nThe server_name should be a unique reference to the server. Server\ndefinitions are global within the scope of the server, it is not\npossible to qualify the server definition to a specific database.\nserver_name has a maximum length of 64 characters (names longer than 64\ncharacters are silently truncated), and is case insensitive. You may\nspecify the name as a quoted string.\n\nThe wrapper_name is an identifier and may be quoted with single\nquotation marks.\n\nFor each option you must specify either a character literal or numeric\nliteral. Character literals are UTF-8, support a maximum length of 64\ncharacters and default to a blank (empty) string. String literals are\nsilently truncated to 64 characters. Numeric literals must be a number\nbetween 0 and 9999, default value is 0.\n\n*Note*:\n\nThe OWNER option is currently not applied, and has no effect on the\nownership or operation of the server connection that is created.\n\nThe CREATE SERVER statement creates an entry in the mysql.servers table\nthat can later be used with the CREATE TABLE statement when creating a\nFEDERATED table. The options that you specify will be used to populate\nthe columns in the mysql.servers table. The table columns are\nServer_name, Host, Db, Username, Password, Port and Socket.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/create-server.html\n\n','CREATE SERVER s\nFOREIGN DATA WRAPPER mysql\nOPTIONS (USER \'Remote\', HOST \'198.51.100.106\', DATABASE \'test\');\n','http://dev.mysql.com/doc/refman/8.0/en/create-server.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (119,9,'CREATE SPATIAL REFERENCE SYSTEM','Syntax:\nCREATE OR REPLACE SPATIAL REFERENCE SYSTEM\n    srid srs_attribute ...\n\nCREATE SPATIAL REFERENCE SYSTEM\n    [IF NOT EXISTS]\n    srid srs_attribute ...\n\nsrs_attribute: {\n    NAME \'srs_name\'\n  | DEFINITION \'definition\'\n  | ORGANIZATION \'org_name\' IDENTIFIED BY org_id\n  | DESCRIPTION \'description\'\n}\n\nsrid, org_id: 32-bit unsigned integer\n\nThis statement creates a spatial reference system (SRS) definition and\nstores it in the data dictionary. The definition can be inspected using\nthe INFORMATION_SCHEMA ST_SPATIAL_REFERENCE_SYSTEMS table. This\nstatement requires the SUPER privilege.\n\nIf neither OR REPLACE nor IF NOT EXISTS is specified, an error occurs\nif an SRS definition with the SRID value already exists.\n\nWith CREATE OR REPLACE syntax, any existing SRS definition with the\nsame SRID value is replaced, unless the SRID value is used by some\ncolumn in an existing table. In that case, an error occurs. For\nexample:\n\nmysql> CREATE OR REPLACE SPATIAL REFERENCE SYSTEM 4326 ...;\nERROR 3716 (SR005): Can\'t modify SRID 4326. There is at\nleast one column depending on it.\n\nTo identify which column or columns use the SRID, use this query:\n\nSELECT * FROM INFORMATION_SCHEMA.ST_GEOMETRY_COLUMNS WHERE SRS_ID=4326;\n\nWith CREATE ... IF NOT EXISTS syntax, any existing SRS definition with\nthe same SRID value causes the new definition to be ignored and a\nwarning occurs.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/create-spatial-reference-system.html\n\n','CREATE SPATIAL REFERENCE SYSTEM 4120\nNAME \'Greek\'\nORGANIZATION \'EPSG\' IDENTIFIED BY 4120\nDEFINITION\n  \'GEOGCS["Greek",DATUM["Greek",SPHEROID["Bessel 1841",\n  6377397.155,299.1528128,AUTHORITY["EPSG","7004"]],\n  AUTHORITY["EPSG","6120"]],PRIMEM["Greenwich",0,\n  AUTHORITY["EPSG","8901"]],UNIT["degree",0.017453292519943278,\n  AUTHORITY["EPSG","9122"]],AXIS["Lat",NORTH],AXIS["Lon",EAST],\n  AUTHORITY["EPSG","4120"]]\';\n','http://dev.mysql.com/doc/refman/8.0/en/create-spatial-reference-system.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (120,9,'CREATE TABLE','Syntax:\nCREATE [TEMPORARY] TABLE [IF NOT EXISTS] tbl_name\n    (create_definition,...)\n    [table_options]\n    [partition_options]\n\nCREATE [TEMPORARY] TABLE [IF NOT EXISTS] tbl_name\n    [(create_definition,...)]\n    [table_options]\n    [partition_options]\n    [IGNORE | REPLACE]\n    [AS] query_expression\n\nCREATE [TEMPORARY] TABLE [IF NOT EXISTS] tbl_name\n    { LIKE old_tbl_name | (LIKE old_tbl_name) }\n\ncreate_definition:\n    col_name column_definition\n  | {INDEX|KEY} [index_name] [index_type] (key_part,...)\n      [index_option] ...\n  | {FULLTEXT|SPATIAL} [INDEX|KEY] [index_name] (key_part,...)\n      [index_option] ...\n  | [CONSTRAINT [symbol]] PRIMARY KEY\n      [index_type] (key_part,...)\n      [index_option] ...\n  | [CONSTRAINT [symbol]] UNIQUE [INDEX|KEY]\n      [index_name] [index_type] (key_part,...)\n      [index_option] ...\n  | [CONSTRAINT [symbol]] FOREIGN KEY\n      [index_name] (col_name,...)\n      reference_definition\n  | check_constraint_definition\n\ncolumn_definition:\n    data_type [NOT NULL | NULL] [DEFAULT {literal | (expr)} ]\n      [AUTO_INCREMENT] [UNIQUE [KEY]] [[PRIMARY] KEY]\n      [COMMENT \'string\']\n      [COLLATE collation_name]\n      [COLUMN_FORMAT {FIXED|DYNAMIC|DEFAULT}]\n      [STORAGE {DISK|MEMORY|DEFAULT}]\n      [reference_definition]\n      [check_constraint_definition]\n  | data_type\n      [COLLATE collation_name]\n      [GENERATED ALWAYS] AS (expr)\n      [VIRTUAL | STORED] [NOT NULL | NULL]\n      [UNIQUE [KEY]] [[PRIMARY] KEY]\n      [COMMENT \'string\']\n      [reference_definition]\n      [check_constraint_definition]\n\ndata_type:\n    (see http://dev.mysql.com/doc/refman/8.0/en/data-types.html)\n\nkey_part: {col_name [(length)] | (expr)} [ASC | DESC]\n\nindex_type:\n    USING {BTREE | HASH}\n\nindex_option:\n    KEY_BLOCK_SIZE [=] value\n  | index_type\n  | WITH PARSER parser_name\n  | COMMENT \'string\'\n  | {VISIBLE | INVISIBLE}\n\ncheck_constraint_definition:\n    [CONSTRAINT [symbol]] CHECK (expr) [[NOT] ENFORCED]\n\nreference_definition:\n    REFERENCES tbl_name (key_part,...)\n      [MATCH FULL | MATCH PARTIAL | MATCH SIMPLE]\n      [ON DELETE reference_option]\n      [ON UPDATE reference_option]\n\nreference_option:\n    RESTRICT | CASCADE | SET NULL | NO ACTION | SET DEFAULT\n\ntable_options:\n    table_option [[,] table_option] ...\n\ntable_option:\n    AUTO_INCREMENT [=] value\n  | AVG_ROW_LENGTH [=] value\n  | [DEFAULT] CHARACTER SET [=] charset_name\n  | CHECKSUM [=] {0 | 1}\n  | [DEFAULT] COLLATE [=] collation_name\n  | COMMENT [=] \'string\'\n  | COMPRESSION [=] {\'ZLIB\'|\'LZ4\'|\'NONE\'}\n  | CONNECTION [=] \'connect_string\'\n  | {DATA|INDEX} DIRECTORY [=] \'absolute path to directory\'\n  | DELAY_KEY_WRITE [=] {0 | 1}\n  | ENCRYPTION [=] {\'Y\' | \'N\'}\n  | ENGINE [=] engine_name\n  | INSERT_METHOD [=] { NO | FIRST | LAST }\n  | KEY_BLOCK_SIZE [=] value\n  | MAX_ROWS [=] value\n  | MIN_ROWS [=] value\n  | PACK_KEYS [=] {0 | 1 | DEFAULT}\n  | PASSWORD [=] \'string\'\n  | ROW_FORMAT [=] {DEFAULT|DYNAMIC|FIXED|COMPRESSED|REDUNDANT|COMPACT}\n  | STATS_AUTO_RECALC [=] {DEFAULT|0|1}\n  | STATS_PERSISTENT [=] {DEFAULT|0|1}\n  | STATS_SAMPLE_PAGES [=] value\n  | TABLESPACE tablespace_name [STORAGE {DISK|MEMORY|DEFAULT}]\n  | UNION [=] (tbl_name[,tbl_name]...)\n\npartition_options:\n    PARTITION BY\n        { [LINEAR] HASH(expr)\n        | [LINEAR] KEY [ALGORITHM={1|2}] (column_list)\n        | RANGE{(expr) | COLUMNS(column_list)}\n        | LIST{(expr) | COLUMNS(column_list)} }\n    [PARTITIONS num]\n    [SUBPARTITION BY\n        { [LINEAR] HASH(expr)\n        | [LINEAR] KEY [ALGORITHM={1|2}] (column_list) }\n      [SUBPARTITIONS num]\n    ]\n    [(partition_definition [, partition_definition] ...)]\n\npartition_definition:\n    PARTITION partition_name\n        [VALUES\n            {LESS THAN {(expr | value_list) | MAXVALUE}\n            |\n            IN (value_list)}]\n        [[STORAGE] ENGINE [=] engine_name]\n        [COMMENT [=] \'string\' ]\n        [DATA DIRECTORY [=] \'data_dir\']\n        [INDEX DIRECTORY [=] \'index_dir\']\n        [MAX_ROWS [=] max_number_of_rows]\n        [MIN_ROWS [=] min_number_of_rows]\n        [TABLESPACE [=] tablespace_name]\n        [(subpartition_definition [, subpartition_definition] ...)]\n\nsubpartition_definition:\n    SUBPARTITION logical_name\n        [[STORAGE] ENGINE [=] engine_name]\n        [COMMENT [=] \'string\' ]\n        [DATA DIRECTORY [=] \'data_dir\']\n        [INDEX DIRECTORY [=] \'index_dir\']\n        [MAX_ROWS [=] max_number_of_rows]\n        [MIN_ROWS [=] min_number_of_rows]\n        [TABLESPACE [=] tablespace_name]\n\nquery_expression:\n    SELECT ...   (Some valid select or union statement)\n\nCREATE TABLE creates a table with the given name. You must have the\nCREATE privilege for the table.\n\nBy default, tables are created in the default database, using the\nInnoDB storage engine. An error occurs if the table exists, if there is\nno default database, or if the database does not exist.\n\nFor information about the physical representation of a table, see\nhttp://dev.mysql.com/doc/refman/8.0/en/create-table-files.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/create-table.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/create-table.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (121,9,'CREATE TABLESPACE','Syntax:\nCREATE [UNDO] TABLESPACE tablespace_name\n\n  InnoDB and NDB:\n    [ADD DATAFILE \'file_name\']\n\n  InnoDB only:\n    [FILE_BLOCK_SIZE = value]\n    [ENCRYPTION [=] {\'Y\' | \'N\'}]\n\n  NDB only:\n    USE LOGFILE GROUP logfile_group\n    [EXTENT_SIZE [=] extent_size]\n    [INITIAL_SIZE [=] initial_size]\n    [AUTOEXTEND_SIZE [=] autoextend_size]\n    [MAX_SIZE [=] max_size]\n    [NODEGROUP [=] nodegroup_id]\n    [WAIT]\n    [COMMENT [=] \'string\']\n\n  InnoDB and NDB:\n    [ENGINE [=] engine_name]\n\nThis statement is used to create a tablespace. The precise syntax and\nsemantics depend on the storage engine used. In standard MySQL\nreleases, this is always an InnoDB tablespace. MySQL NDB Cluster also\nsupports tablespaces using the NDB storage engine.\n\no http://dev.mysql.com/doc/refman/8.0/en/create-tablespace.html#create-\n  tablespace-innodb\n\no http://dev.mysql.com/doc/refman/8.0/en/create-tablespace.html#create-\n  tablespace-ndb\n\no http://dev.mysql.com/doc/refman/8.0/en/create-tablespace.html#create-\n  tablespace-options\n\no http://dev.mysql.com/doc/refman/8.0/en/create-tablespace.html#create-\n  tablespace-notes\n\no http://dev.mysql.com/doc/refman/8.0/en/create-tablespace.html#create-\n  tablespace-innodb-examples\n\no http://dev.mysql.com/doc/refman/8.0/en/create-tablespace.html#create-\n  tablespace-ndb-examples\n\nConsiderations for InnoDB\n\nCREATE TABLESPACE syntax is used to create general tablespaces or undo\ntablespaces. The UNDO keyword, introduced in MySQL 8.0.14, must be\nspecified to create an undo tablespace.\n\nA general tablespace is a shared tablespace. It can hold multiple\ntables, and supports all table row formats. General tablespaces can be\ncreated in a location relative to or independent of the data directory.\n\nAfter creating an InnoDB general tablespace, use CREATE TABLE tbl_name\n... TABLESPACE [=] tablespace_name or ALTER TABLE tbl_name TABLESPACE\n[=] tablespace_name to add tables to the tablespace. For more\ninformation, see\nhttp://dev.mysql.com/doc/refman/8.0/en/general-tablespaces.html.\n\nUndo tablespaces contain undo logs. Undo tablespaces can be created in\na chosen location by specifying a fully qualified data file path. For\nmore information, see\nhttp://dev.mysql.com/doc/refman/8.0/en/innodb-undo-tablespaces.html.\n\nConsiderations for NDB Cluster\n\nThis statement is used to create a tablespace, which can contain one or\nmore data files, providing storage space for NDB Cluster Disk Data\ntables (see\nhttp://dev.mysql.com/doc/refman/8.0/en/mysql-cluster-disk-data.html).\nOne data file is created and added to the tablespace using this\nstatement. Additional data files may be added to the tablespace by\nusing the ALTER TABLESPACE statement (see [HELP ALTER TABLESPACE]).\n\n*Note*:\n\nAll NDB Cluster Disk Data objects share the same namespace. This means\nthat each Disk Data object must be uniquely named (and not merely each\nDisk Data object of a given type). For example, you cannot have a\ntablespace and a log file group with the same name, or a tablespace and\na data file with the same name.\n\nA log file group of one or more UNDO log files must be assigned to the\ntablespace to be created with the USE LOGFILE GROUP clause.\nlogfile_group must be an existing log file group created with CREATE\nLOGFILE GROUP (see [HELP CREATE LOGFILE GROUP]). Multiple tablespaces\nmay use the same log file group for UNDO logging.\n\nWhen setting EXTENT_SIZE or INITIAL_SIZE, you may optionally follow the\nnumber with a one-letter abbreviation for an order of magnitude,\nsimilar to those used in my.cnf. Generally, this is one of the letters\nM (for megabytes) or G (for gigabytes).\n\nINITIAL_SIZE and EXTENT_SIZE are subject to rounding as follows:\n\no EXTENT_SIZE is rounded up to the nearest whole multiple of 32K.\n\no INITIAL_SIZE is rounded down to the nearest whole multiple of 32K;\n  this result is rounded up to the nearest whole multiple of\n  EXTENT_SIZE (after any rounding).\n\nThe rounding just described is done explicitly, and a warning is issued\nby the MySQL Server when any such rounding is performed. The rounded\nvalues are also used by the NDB kernel for calculating\nINFORMATION_SCHEMA.FILES column values and other purposes. However, to\navoid an unexpected result, we suggest that you always use whole\nmultiples of 32K in specifying these options.\n\nWhen CREATE TABLESPACE is used with ENGINE [=] NDB, a tablespace and\nassociated data file are created on each Cluster data node. You can\nverify that the data files were created and obtain information about\nthem by querying the INFORMATION_SCHEMA.FILES table. (See the example\nlater in this section.)\n\n(See http://dev.mysql.com/doc/refman/8.0/en/files-table.html.)\n\nOptions\n\no ADD DATAFILE: Defines the name of a tablespace data file. The ADD\n  DATAFILE clause is required when creating undo tablespaces.\n  Otherwise, it is optional as of MySQL 8.0.14.\n\n  An InnoDB tablespace supports only a single data file, whose name\n  must include a .ibd extension. An NDB Cluster tablespace supports\n  multiple data files which can have any legal file names; more data\n  files can be added to an NDB Cluster tablespace following its\n  creation by using an ALTER TABLESPACE statement.\n\n  To place a general tablespace data file in a location outside of the\n  data directory, include a fully qualified path or a path relative to\n  the data directory. Only a fully qualified path is permitted for undo\n  tablespaces. If you do not specify a path, a general tablespace is\n  created in the data directory. An undo tablespace created without\n  specifying a path is created in the directory defined by the\n  innodb_undo_directory variable. If the innodb_undo_directory variable\n  is undefined, undo tablespaces are created in the data directory.\n\n  Creating a general tablespace in a subdirectory under the data\n  directory is not supported to avoid conflicts with implicitly created\n  file-per-table tablespaces. When creating a general tablespace or\n  undo tablespace outside of the data directory, the directory must\n  exist and must be known to InnoDB prior to creating the tablespace.\n  To make a directory known to InnoDB, add it to the innodb_directories\n  value or to one of the variables whose values are appended to the\n  innodb_directories value. innodb_directories is a read-only variable.\n  Configuring it requires restarting the server.\n\n  The file_name, including any specified path, must be quoted with\n  single or double quotations marks. File names (not counting the file\n  extension) and directory names must be at least one byte in length.\n  Zero length file names and directory names are not supported.\n\n  If the ADD DATAFILE clause is not specified when creating a\n  tablespace, a tablespace data file with a unique file name is created\n  implicitly. The unique file name is a 128 bit UUID formatted into\n  five groups of hexadecimal numbers separated by dashes\n  (aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee). A file extension is added if\n  required by the storage engine. An .ibd file extension is added for\n  InnoDB general tablespace data files. In a replication environment,\n  the data file name created on the master is not the same as the data\n  file name created on the slave.\n\no FILE_BLOCK_SIZE: This option---which is specific to InnoDB general\n  tablespaces, and is ignored by NDB---defines the block size for the\n  tablespace data file. Values can be specified in bytes or kilobytes.\n  For example, an 8 kilobyte file block size can be specified as 8192\n  or 8K. If you do not specify this option, FILE_BLOCK_SIZE defaults to\n  the innodb_page_size value. FILE_BLOCK_SIZE is required when you\n  intend to use the tablespace for storing compressed InnoDB tables\n  (ROW_FORMAT=COMPRESSED). In this case, you must define the tablespace\n  FILE_BLOCK_SIZE when creating the tablespace.\n\n  If FILE_BLOCK_SIZE is equal the innodb_page_size value, the\n  tablespace can contain only tables having an uncompressed row format\n  (COMPACT, REDUNDANT, and DYNAMIC). Tables with a COMPRESSED row\n  format have a different physical page size than uncompressed tables.\n  Therefore, compressed tables cannot coexist in the same tablespace as\n  uncompressed tables.\n\n  For a general tablespace to contain compressed tables,\n  FILE_BLOCK_SIZE must be specified, and the FILE_BLOCK_SIZE value must\n  be a valid compressed page size in relation to the innodb_page_size\n  value. Also, the physical page size of the compressed table\n  (KEY_BLOCK_SIZE) must be equal to FILE_BLOCK_SIZE/1024. For example,\n  if innodb_page_size=16K, and FILE_BLOCK_SIZE=8K, the KEY_BLOCK_SIZE\n  of the table must be 8. For more information, see\n  http://dev.mysql.com/doc/refman/8.0/en/general-tablespaces.html.\n\no USE LOGFILE GROUP: Required for NDB, this is the name of a log file\n  group previously created using CREATE LOGFILE GROUP. Not supported\n  for InnoDB, where it fails with an error.\n\no EXTENT_SIZE: This option is specific to NDB, and is not supported by\n  InnoDB, where it fails with an error. EXTENT_SIZE sets the size, in\n  bytes, of the extents used by any files belonging to the tablespace.\n  The default value is 1M. The minimum size is 32K, and theoretical\n  maximum is 2G, although the practical maximum size depends on a\n  number of factors. In most cases, changing the extent size does not\n  have any measurable effect on performance, and the default value is\n  recommended for all but the most unusual situations.\n\n  An extent is a unit of disk space allocation. One extent is filled\n  with as much data as that extent can contain before another extent is\n  used. In theory, up to 65,535 (64K) extents may used per data file;\n  however, the recommended maximum is 32,768 (32K). The recommended\n  maximum size for a single data file is 32G---that is, 32K extents x 1\n  MB per extent. In addition, once an extent is allocated to a given\n  partition, it cannot be used to store data from a different\n  partition; an extent cannot store data from more than one partition.\n  This means, for example that a tablespace having a single datafile\n  whose INITIAL_SIZE (described in the following item) is 256 MB and\n  whose EXTENT_SIZE is 128M has just two extents, and so can be used to\n  store data from at most two different disk data table partitions.\n\n  You can see how many extents remain free in a given data file by\n  querying the INFORMATION_SCHEMA.FILES table, and so derive an\n  estimate for how much space remains free in the file. For further\n  discussion and examples, see\n  http://dev.mysql.com/doc/refman/8.0/en/files-table.html.\n\no INITIAL_SIZE: This option is specific to NDB, and is not supported by\n  InnoDB, where it fails with an error.\n\n  The INITIAL_SIZE parameter sets the total size in bytes of the data\n  file that was specific using ADD DATATFILE. Once this file has been\n  created, its size cannot be changed; however, you can add more data\n  files to the tablespace using ALTER TABLESPACE ... ADD DATAFILE.\n\n  INITIAL_SIZE is optional; its default value is 134217728 (128 MB).\n\n  On 32-bit systems, the maximum supported value for INITIAL_SIZE is\n  4294967296 (4 GB).\n\no AUTOEXTEND_SIZE: Currently ignored by MySQL; reserved for possible\n  future use. Has no effect in any release of MySQL 8.0 or MySQL NDB\n  Cluster 8.0, regardless of the storage engine used.\n\no MAX_SIZE: Currently ignored by MySQL; reserved for possible future\n  use. Has no effect in any release of MySQL 8.0 or MySQL NDB Cluster\n  8.0, regardless of the storage engine used.\n\no NODEGROUP: Currently ignored by MySQL; reserved for possible future\n  use. Has no effect in any release of MySQL 8.0 or MySQL NDB Cluster\n  8.0, regardless of the storage engine used.\n\no WAIT: Currently ignored by MySQL; reserved for possible future use.\n  Has no effect in any release of MySQL 8.0 or MySQL NDB Cluster 8.0,\n  regardless of the storage engine used.\n\no COMMENT: Currently ignored by MySQL; reserved for possible future\n  use. Has no effect in any release of MySQL 8.0 or MySQL NDB Cluster\n  8.0, regardless of the storage engine used.\n\no The ENCRYPTION option is used to enable or disable page-level data\n  encryption for an InnoDB general tablespace. Option values are not\n  case-sensitive. Encryption support for general tablespaces was\n  introduced in MySQL 8.0.13. A keyring plugin must be installed and\n  configured to use the ENCRYPTION option.\n\n  When a general tablespace is encrypted, all tables residing in the\n  tablespace are encrypted. Likewise, a table created in an encrypted\n  tablespace is encrypted.\n\n  For more information, see\n  http://dev.mysql.com/doc/refman/8.0/en/innodb-tablespace-encryption.h\n  tml\n\no ENGINE: Defines the storage engine which uses the tablespace, where\n  engine_name is the name of the storage engine. Currently, only the\n  InnoDB storage engine is supported by standard MySQL 8.0 releases.\n  MySQL NDB Cluster supports both NDB and InnoDB tablespaces. The value\n  of the default_storage_engine system variable is used for ENGINE if\n  the option is not specified.\n\nNotes\n\no For the rules covering the naming of MySQL tablespaces, see\n  http://dev.mysql.com/doc/refman/8.0/en/identifiers.html. In addition\n  to these rules, the slash character ("/") is not permitted, nor can\n  you use names beginning with innodb_, as this prefix is reserved for\n  system use.\n\no Creation of temporary general tablespaces is not supported.\n\no General tablespaces do not support temporary tables.\n\no The TABLESPACE option may be used with CREATE TABLE or ALTER TABLE to\n  assign an InnoDB table partition or subpartition to a file-per-table\n  tablespace. All partitions must belong to the same storage engine.\n  Assigning table partitions to shared InnoDB tablespaces is not\n  supported. Shared tablespaces include the InnoDB system tablespace\n  and general tablespaces.\n\no General tablespaces support the addition of tables of any row format\n  using CREATE TABLE ... TABLESPACE. innodb_file_per_table does not\n  need to be enabled.\n\no innodb_strict_mode is not applicable to general tablespaces.\n  Tablespace management rules are strictly enforced independently of\n  innodb_strict_mode. If CREATE TABLESPACE parameters are incorrect or\n  incompatible, the operation fails regardless of the\n  innodb_strict_mode setting. When a table is added to a general\n  tablespace using CREATE TABLE ... TABLESPACE or ALTER TABLE ...\n  TABLESPACE, innodb_strict_mode is ignored but the statement is\n  evaluated as if innodb_strict_mode is enabled.\n\no Use DROP TABLESPACE to remove a tablespace. All tables must be\n  dropped from a tablespace using DROP TABLE prior to dropping the\n  tablespace. Before dropping an NDB Cluster tablespace you must also\n  remove all its data files using one or more ALTER TABLESPACE ... DROP\n  DATATFILE statements. See\n  http://dev.mysql.com/doc/refman/8.0/en/mysql-cluster-disk-data-object\n  s.html.\n\no All parts of an InnoDB table added to an InnoDB general tablespace\n  reside in the general tablespace, including indexes and BLOB pages.\n\n  For an NDB table assigned to a tablespace, only those columns which\n  are not indexed are stored on disk, and actually use the tablespace\n  data files. Indexes and indexed columns for all NDB tables are always\n  kept in memory.\n\no Similar to the system tablespace, truncating or dropping tables\n  stored in a general tablespace creates free space internally in the\n  general tablespace .ibd data file which can only be used for new\n  InnoDB data. Space is not released back to the operating system as it\n  is for file-per-table tablespaces.\n\no A general tablespace is not associated with any database or schema.\n\no ALTER TABLE ... DISCARD TABLESPACE and ALTER TABLE ...IMPORT\n  TABLESPACE are not supported for tables that belong to a general\n  tablespace.\n\no The server uses tablespace-level metadata locking for DDL that\n  references general tablespaces. By comparison, the server uses\n  table-level metadata locking for DDL that references file-per-table\n  tablespaces.\n\no A generated or existing tablespace cannot be changed to a general\n  tablespace.\n\no There is no conflict between general tablespace names and\n  file-per-table tablespace names. The "/" character, which is present\n  in file-per-table tablespace names, is not permitted in general\n  tablespace names.\n\no mysqldump and mysqlpump do not dump InnoDB CREATE TABLESPACE\n  statements.\n\nInnoDB Examples\n\nThis example demonstrates creating a general tablespace and adding\nthree uncompressed tables of different row formats.\n\nmysql> CREATE TABLESPACE `ts1` ADD DATAFILE \'ts1.ibd\' ENGINE=INNODB;\n\nmysql> CREATE TABLE t1 (c1 INT PRIMARY KEY) TABLESPACE ts1 ROW_FORMAT=REDUNDANT;\n\nmysql> CREATE TABLE t2 (c1 INT PRIMARY KEY) TABLESPACE ts1 ROW_FORMAT=COMPACT;\n\nmysql> CREATE TABLE t3 (c1 INT PRIMARY KEY) TABLESPACE ts1 ROW_FORMAT=DYNAMIC;\n\nThis example demonstrates creating a general tablespace and adding a\ncompressed table. The example assumes a default innodb_page_size value\nof 16K. The FILE_BLOCK_SIZE of 8192 requires that the compressed table\nhave a KEY_BLOCK_SIZE of 8.\n\nmysql> CREATE TABLESPACE `ts2` ADD DATAFILE \'ts2.ibd\' FILE_BLOCK_SIZE = 8192 Engine=InnoDB;\n\nmysql> CREATE TABLE t4 (c1 INT PRIMARY KEY) TABLESPACE ts2 ROW_FORMAT=COMPRESSED KEY_BLOCK_SIZE=8;\n\nThis example demonstrates creating a general tablespace without\nspecifying the ADD DATAFILE clause, which is optional as of MySQL\n8.0.14.\n\nmysql> CREATE TABLESPACE `ts3` ENGINE=INNODB;\n\nThis example demonstrates creating an undo tablespace.\n\nmysql> CREATE UNDO TABLESPACE undo_003 ADD DATAFILE \'undo_003.ibu\';\n\nNDB Example\n\nSuppose that you wish to create an NDB Cluster Disk Data tablespace\nnamed myts using a datafile named mydata-1.dat. An NDB tablespace\nalways requires the use of a log file group consisting of one or more\nundo log files. For this example, we first create a log file group\nnamed mylg that contains one undo long file named myundo-1.dat, using\nthe CREATE LOGFILE GROUP statement shown here:\n\nmysql> CREATE LOGFILE GROUP myg1\n    ->     ADD UNDOFILE \'myundo-1.dat\'\n    ->     ENGINE=NDB;\nQuery OK, 0 rows affected (3.29 sec)\n\nNow you can create the tablespace previously described using the\nfollowing statement:\n\nmysql> CREATE TABLESPACE myts\n    ->     ADD DATAFILE \'mydata-1.dat\'\n    ->     USE LOGFILE GROUP mylg\n    ->     ENGINE=NDB;\nQuery OK, 0 rows affected (2.98 sec)\n\nYou can now create a Disk Data table using a CREATE TABLE statement\nwith the TABLESPACE and STORAGE DISK options, similar to what is shown\nhere:\n\nmysql> CREATE TABLE mytable (\n    ->     id INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,\n    ->     lname VARCHAR(50) NOT NULL,\n    ->     fname VARCHAR(50) NOT NULL,\n    ->     dob DATE NOT NULL,\n    ->     joined DATE NOT NULL,\n    ->     INDEX(last_name, first_name)\n    -> )\n    ->     TABLESPACE myts STORAGE DISK\n    ->     ENGINE=NDB;\nQuery OK, 0 rows affected (1.41 sec)\n\nIt is important to note that only the dob and joined columns from\nmytable are actually stored on disk, due to the fact that the id,\nlname, and fname columns are all indexed.\n\nAs mentioned previously, when CREATE TABLESPACE is used with ENGINE [=]\nNDB, a tablespace and associated data file are created on each NDB\nCluster data node. You can verify that the data files were created and\nobtain information about them by querying the INFORMATION_SCHEMA.FILES\ntable, as shown here:\n\nmysql> SELECT FILE_NAME, FILE_TYPE, LOGFILE_GROUP_NAME, STATUS, EXTRA\n    ->     FROM INFORMATION_SCHEMA.FILES\n    ->     WHERE TABLESPACE_NAME = \'myts\';\n\n+--------------+------------+--------------------+--------+----------------+\n| file_name    | file_type  | logfile_group_name | status | extra          |\n+--------------+------------+--------------------+--------+----------------+\n| mydata-1.dat | DATAFILE   | mylg               | NORMAL | CLUSTER_NODE=5 |\n| mydata-1.dat | DATAFILE   | mylg               | NORMAL | CLUSTER_NODE=6 |\n| NULL         | TABLESPACE | mylg               | NORMAL | NULL           |\n+--------------+------------+--------------------+--------+----------------+\n3 rows in set (0.01 sec)\n\nFor additional information and examples, see\nhttp://dev.mysql.com/doc/refman/8.0/en/mysql-cluster-disk-data-objects.\nhtml.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/create-tablespace.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/create-tablespace.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (122,9,'CREATE TRIGGER','Syntax:\nCREATE\n    [DEFINER = { user | CURRENT_USER }]\n    TRIGGER trigger_name\n    trigger_time trigger_event\n    ON tbl_name FOR EACH ROW\n    [trigger_order]\n    trigger_body\n\ntrigger_time: { BEFORE | AFTER }\n\ntrigger_event: { INSERT | UPDATE | DELETE }\n\ntrigger_order: { FOLLOWS | PRECEDES } other_trigger_name\n\nThis statement creates a new trigger. A trigger is a named database\nobject that is associated with a table, and that activates when a\nparticular event occurs for the table. The trigger becomes associated\nwith the table named tbl_name, which must refer to a permanent table.\nYou cannot associate a trigger with a TEMPORARY table or a view.\n\nTrigger names exist in the schema namespace, meaning that all triggers\nmust have unique names within a schema. Triggers in different schemas\ncan have the same name.\n\nThis section describes CREATE TRIGGER syntax. For additional\ndiscussion, see\nhttp://dev.mysql.com/doc/refman/8.0/en/trigger-syntax.html.\n\nCREATE TRIGGER requires the TRIGGER privilege for the table associated\nwith the trigger. The statement might also require the SET_USER_ID or\nSUPER privilege, depending on the DEFINER value, as described later in\nthis section. If binary logging is enabled, CREATE TRIGGER might\nrequire the SUPER privilege, as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/stored-programs-logging.html.\n\nThe DEFINER clause determines the security context to be used when\nchecking access privileges at trigger activation time, as described\nlater in this section.\n\ntrigger_time is the trigger action time. It can be BEFORE or AFTER to\nindicate that the trigger activates before or after each row to be\nmodified.\n\nBasic column value checks occur prior to trigger activation, so you\ncannot use BEFORE triggers to convert values inappropriate for the\ncolumn type to valid values.\n\ntrigger_event indicates the kind of operation that activates the\ntrigger. These trigger_event values are permitted:\n\no INSERT: The trigger activates whenever a new row is inserted into the\n  table; for example, through INSERT, LOAD DATA, and REPLACE\n  statements.\n\no UPDATE: The trigger activates whenever a row is modified; for\n  example, through UPDATE statements.\n\no DELETE: The trigger activates whenever a row is deleted from the\n  table; for example, through DELETE and REPLACE statements. DROP TABLE\n  and TRUNCATE TABLE statements on the table do not activate this\n  trigger, because they do not use DELETE. Dropping a partition does\n  not activate DELETE triggers, either.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/create-trigger.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/create-trigger.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (123,1,'CREATE USER','Syntax:\nCREATE USER [IF NOT EXISTS]\n    user [auth_option] [, user [auth_option]] ...\n    DEFAULT ROLE role [, role ] ...\n    [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n    [WITH resource_option [resource_option] ...]\n    [password_option | lock_option] ...\n\nuser:\n    (see )\n\nauth_option: {\n    IDENTIFIED BY \'auth_string\'\n  | IDENTIFIED WITH auth_plugin\n  | IDENTIFIED WITH auth_plugin BY \'auth_string\'\n  | IDENTIFIED WITH auth_plugin AS \'hash_string\'\n}\n\ntls_option: {\n   SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n}\n\nresource_option: {\n    MAX_QUERIES_PER_HOUR count\n  | MAX_UPDATES_PER_HOUR count\n  | MAX_CONNECTIONS_PER_HOUR count\n  | MAX_USER_CONNECTIONS count\n}\n\npassword_option: {\n    PASSWORD EXPIRE [DEFAULT | NEVER | INTERVAL N DAY]\n  | PASSWORD HISTORY {DEFAULT | N}\n  | PASSWORD REUSE INTERVAL {DEFAULT | N DAY}\n  | PASSWORD REQUIRE CURRENT [DEFAULT | OPTIONAL]\n}\n\nlock_option: {\n    ACCOUNT LOCK\n  | ACCOUNT UNLOCK\n}\n\nThe CREATE USER statement creates new MySQL accounts. It enables\nauthentication, role, SSL/TLS, resource-limit, and password-management\nproperties to be established for new accounts. It also controls whether\naccounts are initially locked or unlocked.\n\nTo use CREATE USER, you must have the global CREATE USER privilege, or\nthe INSERT privilege for the mysql system database. When the read_only\nsystem variable is enabled, CREATE USER additionally requires the\nCONNECTION_ADMIN or SUPER privilege.\n\nCREATE USER either succeeds for all named users or rolls back and has\nno effect if any error occurs. By default, an error occurs if you try\nto create a user that already exists. If the IF NOT EXISTS clause is\ngiven, the statement produces a warning for each named user that\nalready exists, rather than an error.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/create-user.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/create-user.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (124,9,'CREATE VIEW','Syntax:\nCREATE\n    [OR REPLACE]\n    [ALGORITHM = {UNDEFINED | MERGE | TEMPTABLE}]\n    [DEFINER = { user | CURRENT_USER }]\n    [SQL SECURITY { DEFINER | INVOKER }]\n    VIEW view_name [(column_list)]\n    AS select_statement\n    [WITH [CASCADED | LOCAL] CHECK OPTION]\n\nThe CREATE VIEW statement creates a new view, or replaces an existing\nview if the OR REPLACE clause is given. If the view does not exist,\nCREATE OR REPLACE VIEW is the same as CREATE VIEW. If the view does\nexist, CREATE OR REPLACE VIEW replaces it.\n\nFor information about restrictions on view use, see\nhttp://dev.mysql.com/doc/refman/8.0/en/view-restrictions.html.\n\nThe select_statement is a SELECT statement that provides the definition\nof the view. (Selecting from the view selects, in effect, using the\nSELECT statement.) The select_statement can select from base tables or\nother views.\n\nThe view definition is "frozen" at creation time and is not affected by\nsubsequent changes to the definitions of the underlying tables. For\nexample, if a view is defined as SELECT * on a table, new columns added\nto the table later do not become part of the view, and columns dropped\nfrom the table will result in an error when selecting from the view.\n\nThe ALGORITHM clause affects how MySQL processes the view. The DEFINER\nand SQL SECURITY clauses specify the security context to be used when\nchecking access privileges at view invocation time. The WITH CHECK\nOPTION clause can be given to constrain inserts or updates to rows in\ntables referenced by the view. These clauses are described later in\nthis section.\n\nThe CREATE VIEW statement requires the CREATE VIEW privilege for the\nview, and some privilege for each column selected by the SELECT\nstatement. For columns used elsewhere in the SELECT statement, you must\nhave the SELECT privilege. If the OR REPLACE clause is present, you\nmust also have the DROP privilege for the view. CREATE VIEW might also\nrequire the SET_USER_ID or SUPER privilege, depending on the DEFINER\nvalue, as described later in this section.\n\nWhen a view is referenced, privilege checking occurs as described later\nin this section.\n\nA view belongs to a database. By default, a new view is created in the\ndefault database. To create the view explicitly in a given database,\nuse db_name.view_name syntax to qualify the view name with the database\nname:\n\nCREATE VIEW test.v AS SELECT * FROM t;\n\nUnqualified table or view names in the SELECT statement are also\ninterpreted with respect to the default database. A view can refer to\ntables or views in other databases by qualifying the table or view name\nwith the appropriate database name.\n\nWithin a database, base tables and views share the same namespace, so a\nbase table and a view cannot have the same name.\n\nColumns retrieved by the SELECT statement can be simple references to\ntable columns, or expressions that use functions, constant values,\noperators, and so forth.\n\nA view must have unique column names with no duplicates, just like a\nbase table. By default, the names of the columns retrieved by the\nSELECT statement are used for the view column names. To define explicit\nnames for the view columns, specify the optional column_list clause as\na list of comma-separated identifiers. The number of names in\ncolumn_list must be the same as the number of columns retrieved by the\nSELECT statement.\n\nA view can be created from many kinds of SELECT statements. It can\nrefer to base tables or other views. It can use joins, UNION, and\nsubqueries. The SELECT need not even refer to any tables:\n\nCREATE VIEW v_today (today) AS SELECT CURRENT_DATE;\n\nThe following example defines a view that selects two columns from\nanother table as well as an expression calculated from those columns:\n\nmysql> CREATE TABLE t (qty INT, price INT);\nmysql> INSERT INTO t VALUES(3, 50);\nmysql> CREATE VIEW v AS SELECT qty, price, qty*price AS value FROM t;\nmysql> SELECT * FROM v;\n+------+-------+-------+\n| qty  | price | value |\n+------+-------+-------+\n|    3 |    50 |   150 |\n+------+-------+-------+\n\nA view definition is subject to the following restrictions:\n\no The SELECT statement cannot refer to system variables or user-defined\n  variables.\n\no Within a stored program, the SELECT statement cannot refer to program\n  parameters or local variables.\n\no The SELECT statement cannot refer to prepared statement parameters.\n\no Any table or view referred to in the definition must exist. If, after\n  the view has been created, a table or view that the definition refers\n  to is dropped, use of the view results in an error. To check a view\n  definition for problems of this kind, use the CHECK TABLE statement.\n\no The definition cannot refer to a TEMPORARY table, and you cannot\n  create a TEMPORARY view.\n\no You cannot associate a trigger with a view.\n\no Aliases for column names in the SELECT statement are checked against\n  the maximum column length of 64 characters (not the maximum alias\n  length of 256 characters).\n\nORDER BY is permitted in a view definition, but it is ignored if you\nselect from a view using a statement that has its own ORDER BY.\n\nFor other options or clauses in the definition, they are added to the\noptions or clauses of the statement that references the view, but the\neffect is undefined. For example, if a view definition includes a LIMIT\nclause, and you select from the view using a statement that has its own\nLIMIT clause, it is undefined which limit applies. This same principle\napplies to options such as ALL, DISTINCT, or SQL_SMALL_RESULT that\nfollow the SELECT keyword, and to clauses such as INTO, FOR UPDATE, FOR\nSHARE, LOCK IN SHARE MODE, and PROCEDURE.\n\nThe results obtained from a view may be affected if you change the\nquery processing environment by changing system variables:\n\nmysql> CREATE VIEW v (mycol) AS SELECT \'abc\';\nQuery OK, 0 rows affected (0.01 sec)\n\nmysql> SET sql_mode = \'\';\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT "mycol" FROM v;\n+-------+\n| mycol |\n+-------+\n| mycol |\n+-------+\n1 row in set (0.01 sec)\n\nmysql> SET sql_mode = \'ANSI_QUOTES\';\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT "mycol" FROM v;\n+-------+\n| mycol |\n+-------+\n| abc   |\n+-------+\n1 row in set (0.00 sec)\n\nThe DEFINER and SQL SECURITY clauses determine which MySQL account to\nuse when checking access privileges for the view when a statement is\nexecuted that references the view. The valid SQL SECURITY\ncharacteristic values are DEFINER (the default) and INVOKER. These\nindicate that the required privileges must be held by the user who\ndefined or invoked the view, respectively.\n\nIf a user value is given for the DEFINER clause, it should be a MySQL\naccount specified as \'user_name\'@\'host_name\', CURRENT_USER, or\nCURRENT_USER(). The default DEFINER value is the user who executes the\nCREATE VIEW statement. This is the same as specifying DEFINER =\nCURRENT_USER explicitly.\n\nIf the DEFINER clause is present, these rules determine the valid\nDEFINER user values:\n\no If you do not have the SET_USER_ID or SUPER privilege, the only valid\n  user value is your own account, either specified literally or by\n  using CURRENT_USER. You cannot set the definer to some other account.\n\no If you have the SET_USER_ID or SUPER privilege, you can specify any\n  syntactically valid account name. If the account does not exist, a\n  warning is generated.\n\no Although it is possible to create a view with a nonexistent DEFINER\n  account, an error occurs when the view is referenced if the SQL\n  SECURITY value is DEFINER but the definer account does not exist.\n\nFor more information about view security, see\nhttp://dev.mysql.com/doc/refman/8.0/en/stored-programs-security.html.\n\nWithin a view definition, CURRENT_USER returns the view\'s DEFINER value\nby default. For views defined with the SQL SECURITY INVOKER\ncharacteristic, CURRENT_USER returns the account for the view\'s\ninvoker. For information about user auditing within views, see\nhttp://dev.mysql.com/doc/refman/8.0/en/account-activity-auditing.html.\n\nWithin a stored routine that is defined with the SQL SECURITY DEFINER\ncharacteristic, CURRENT_USER returns the routine\'s DEFINER value. This\nalso affects a view defined within such a routine, if the view\ndefinition contains a DEFINER value of CURRENT_USER.\n\nMySQL checks view privileges like this:\n\no At view definition time, the view creator must have the privileges\n  needed to use the top-level objects accessed by the view. For\n  example, if the view definition refers to table columns, the creator\n  must have some privilege for each column in the select list of the\n  definition, and the SELECT privilege for each column used elsewhere\n  in the definition. If the definition refers to a stored function,\n  only the privileges needed to invoke the function can be checked. The\n  privileges required at function invocation time can be checked only\n  as it executes: For different invocations, different execution paths\n  within the function might be taken.\n\no The user who references a view must have appropriate privileges to\n  access it (SELECT to select from it, INSERT to insert into it, and so\n  forth.)\n\no When a view has been referenced, privileges for objects accessed by\n  the view are checked against the privileges held by the view DEFINER\n  account or invoker, depending on whether the SQL SECURITY\n  characteristic is DEFINER or INVOKER, respectively.\n\no If reference to a view causes execution of a stored function,\n  privilege checking for statements executed within the function depend\n  on whether the function SQL SECURITY characteristic is DEFINER or\n  INVOKER. If the security characteristic is DEFINER, the function runs\n  with the privileges of the DEFINER account. If the characteristic is\n  INVOKER, the function runs with the privileges determined by the\n  view\'s SQL SECURITY characteristic.\n\nExample: A view might depend on a stored function, and that function\nmight invoke other stored routines. For example, the following view\ninvokes a stored function f():\n\nCREATE VIEW v AS SELECT * FROM t WHERE t.id = f(t.name);\n\nSuppose that f() contains a statement such as this:\n\nIF name IS NULL then\n  CALL p1();\nELSE\n  CALL p2();\nEND IF;\n\nThe privileges required for executing statements within f() need to be\nchecked when f() executes. This might mean that privileges are needed\nfor p1() or p2(), depending on the execution path within f(). Those\nprivileges must be checked at runtime, and the user who must possess\nthe privileges is determined by the SQL SECURITY values of the view v\nand the function f().\n\nThe DEFINER and SQL SECURITY clauses for views are extensions to\nstandard SQL. In standard SQL, views are handled using the rules for\nSQL SECURITY DEFINER. The standard says that the definer of the view,\nwhich is the same as the owner of the view\'s schema, gets applicable\nprivileges on the view (for example, SELECT) and may grant them. MySQL\nhas no concept of a schema "owner", so MySQL adds a clause to identify\nthe definer. The DEFINER clause is an extension where the intent is to\nhave what the standard has; that is, a permanent record of who defined\nthe view. This is why the default DEFINER value is the account of the\nview creator.\n\nThe optional ALGORITHM clause is a MySQL extension to standard SQL. It\naffects how MySQL processes the view. ALGORITHM takes three values:\nMERGE, TEMPTABLE, or UNDEFINED. For more information, see\nhttp://dev.mysql.com/doc/refman/8.0/en/view-algorithms.html, as well as\nhttp://dev.mysql.com/doc/refman/8.0/en/derived-table-optimization.html.\n\nSome views are updatable. That is, you can use them in statements such\nas UPDATE, DELETE, or INSERT to update the contents of the underlying\ntable. For a view to be updatable, there must be a one-to-one\nrelationship between the rows in the view and the rows in the\nunderlying table. There are also certain other constructs that make a\nview nonupdatable.\n\nA generated column in a view is considered updatable because it is\npossible to assign to it. However, if such a column is updated\nexplicitly, the only permitted value is DEFAULT. For information about\ngenerated columns, see\nhttp://dev.mysql.com/doc/refman/8.0/en/create-table-generated-columns.h\ntml.\n\nThe WITH CHECK OPTION clause can be given for an updatable view to\nprevent inserts or updates to rows except those for which the WHERE\nclause in the select_statement is true.\n\nIn a WITH CHECK OPTION clause for an updatable view, the LOCAL and\nCASCADED keywords determine the scope of check testing when the view is\ndefined in terms of another view. The LOCAL keyword restricts the CHECK\nOPTION only to the view being defined. CASCADED causes the checks for\nunderlying views to be evaluated as well. When neither keyword is\ngiven, the default is CASCADED.\n\nFor more information about updatable views and the WITH CHECK OPTION\nclause, see\nhttp://dev.mysql.com/doc/refman/8.0/en/view-updatability.html, and\nhttp://dev.mysql.com/doc/refman/8.0/en/view-check-option.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/create-view.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/create-view.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (125,28,'CREATE_ASYMMETRIC_PRIV_KEY','Syntax:\nCREATE_ASYMMETRIC_PRIV_KEY(algorithm, {key_len|dh_secret})\n\nCreates a private key using the given algorithm and key length or DH\nsecret, and returns the key as a binary string in PEM format. If key\ngeneration fails, the result is NULL.\n\nSupported algorithm values: \'RSA\', \'DSA\', \'DH\'\n\nSupported key_len values: The minimum key length in bits is 1,024. The\nmaximum key length depends on the algorithm: 16,384 for RSA and 10,000\nfor DSA. These key-length limits are constraints imposed by OpenSSL.\nServer administrators can impose additional limits on maximum key\nlength by setting environment variables. See\nhttp://dev.mysql.com/doc/refman/8.0/en/enterprise-encryption-usage.html\n.\n\nFor DH keys, pass a shared DH secret instead of a key length. To create\nthe secret, pass the key length to CREATE_DH_PARAMETERS().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/enterprise-encryption-functions.html\n\n','SET @priv = CREATE_ASYMMETRIC_PRIV_KEY(\'DSA\', 2048);\nSET @pub = CREATE_ASYMMETRIC_PUB_KEY(\'DSA\', @priv);\n','http://dev.mysql.com/doc/refman/8.0/en/enterprise-encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (126,28,'CREATE_ASYMMETRIC_PUB_KEY','Syntax:\nCREATE_ASYMMETRIC_PUB_KEY(algorithm, priv_key_str)\n\nDerives a public key from the given private key using the given\nalgorithm, and returns the key as a binary string in PEM format. If key\nderivation fails, the result is NULL.\n\npriv_key_str must be a valid key string in PEM format. algorithm\nindicates the encryption algorithm used to create the key.\n\nSupported algorithm values: \'RSA\', \'DSA\', \'DH\'\n\nFor a usage example, see the description of\nCREATE_ASYMMETRIC_PRIV_KEY().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/enterprise-encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/enterprise-encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (127,28,'CREATE_DH_PARAMETERS','CREATE_DH_PARAMETERS(key_len)\n\nCreates a shared secret for generating a DH private/public key pair and\nreturns a binary string that can be passed to\nCREATE_ASYMMETRIC_PRIV_KEY(). If secret generation fails, the result is\nnull.\n\nSupported key_len values: The minimum and maximum key lengths in bits\nare 1,024 and 10,000. These key-length limits are constraints imposed\nby OpenSSL. Server administrators can impose additional limits on\nmaximum key length by setting environment variables. See\nhttp://dev.mysql.com/doc/refman/8.0/en/enterprise-encryption-usage.html\n.\n\nFor an example showing how to use the return value for generating\nsymmetric keys, see the description of ASYMMETRIC_DERIVE().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/enterprise-encryption-functions.html\n\n','SET @dhp = CREATE_DH_PARAMETERS(1024);\n','http://dev.mysql.com/doc/refman/8.0/en/enterprise-encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (128,28,'CREATE_DIGEST','Syntax:\nCREATE_DIGEST(digest_type, str)\n\nCreates a digest from the given string using the given digest type, and\nreturns the digest as a binary string. If digest generation fails, the\nresult is NULL.\n\nSupported digest_type values: \'SHA224\', \'SHA256\', \'SHA384\', \'SHA512\'\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/enterprise-encryption-functions.html\n\n','SET @dig = CREATE_DIGEST(\'SHA512\', The quick brown fox\');\n','http://dev.mysql.com/doc/refman/8.0/en/enterprise-encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (129,15,'CUME_DIST','CUME_DIST() over_clause\n\nReturns the cumulative distribution of a value within a group of\nvalues; that is, the percentage of partition values less than or equal\nto the value in the current row. This represents the number of rows\npreceding or peer with the current row in the window ordering of the\nwindow partition divided by the total number of rows in the window\npartition. Return values range from 0 to 1.\n\nThis function should be used with ORDER BY to sort partition rows into\nthe desired order. Without ORDER BY, all rows are peers and have value\nN/N = 1, where N is the partition size.\n\nover_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/window-function-descriptions.html\n\n','mysql> SELECT\n         val,\n         ROW_NUMBER()   OVER w AS \'row_number\',\n         CUME_DIST()    OVER w AS \'cume_dist\',\n         PERCENT_RANK() OVER w AS \'percent_rank\'\n       FROM numbers\n       WINDOW w AS (ORDER BY val);\n+------+------------+--------------------+--------------+\n| val  | row_number | cume_dist          | percent_rank |\n+------+------------+--------------------+--------------+\n|    1 |          1 | 0.2222222222222222 |            0 |\n|    1 |          2 | 0.2222222222222222 |            0 |\n|    2 |          3 | 0.3333333333333333 |         0.25 |\n|    3 |          4 | 0.6666666666666666 |        0.375 |\n|    3 |          5 | 0.6666666666666666 |        0.375 |\n|    3 |          6 | 0.6666666666666666 |        0.375 |\n|    4 |          7 | 0.8888888888888888 |         0.75 |\n|    4 |          8 | 0.8888888888888888 |         0.75 |\n|    5 |          9 |                  1 |            1 |\n+------+------------+--------------------+--------------+\n','http://dev.mysql.com/doc/refman/8.0/en/window-function-descriptions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (130,12,'CURDATE','Syntax:\nCURDATE()\n\nReturns the current date as a value in \'YYYY-MM-DD\' or YYYYMMDD format,\ndepending on whether the function is used in a string or numeric\ncontext.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT CURDATE();\n        -> \'2008-06-13\'\nmysql> SELECT CURDATE() + 0;\n        -> 20080613\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (131,12,'CURRENT_DATE','Syntax:\nCURRENT_DATE, CURRENT_DATE()\n\nCURRENT_DATE and CURRENT_DATE() are synonyms for CURDATE().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (132,23,'CURRENT_ROLE','CURRENT_ROLE()\n\nReturns a utf8 string containing the current active roles for the\ncurrent session, separated by commas, or NONE if there are none. The\nvalue reflects the setting of the sql_quote_show_create system\nvariable.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/information-functions.html\n\n','GRANT \'r1\', \'r2\' TO \'u1\'@\'localhost\';\nSET DEFAULT ROLE ALL TO \'u1\'@\'localhost\';\n\nmysql> SELECT CURRENT_ROLE();\n+-------------------+\n| CURRENT_ROLE()    |\n+-------------------+\n| `r1`@`%`,`r2`@`%` |\n+-------------------+\nmysql> SET ROLE \'r1\'; SELECT CURRENT_ROLE();\n+----------------+\n| CURRENT_ROLE() |\n+----------------+\n| `r1`@`%`       |\n+----------------+\n','http://dev.mysql.com/doc/refman/8.0/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (133,12,'CURRENT_TIME','Syntax:\nCURRENT_TIME, CURRENT_TIME([fsp])\n\nCURRENT_TIME and CURRENT_TIME() are synonyms for CURTIME().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (134,12,'CURRENT_TIMESTAMP','Syntax:\nCURRENT_TIMESTAMP, CURRENT_TIMESTAMP([fsp])\n\nCURRENT_TIMESTAMP and CURRENT_TIMESTAMP() are synonyms for NOW().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (135,23,'CURRENT_USER','Syntax:\nCURRENT_USER, CURRENT_USER()\n\nReturns the user name and host name combination for the MySQL account\nthat the server used to authenticate the current client. This account\ndetermines your access privileges. The return value is a string in the\nutf8 character set.\n\nThe value of CURRENT_USER() can differ from the value of USER().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/information-functions.html\n\n','mysql> SELECT USER();\n        -> \'davida@localhost\'\nmysql> SELECT * FROM mysql.user;\nERROR 1044: Access denied for user \'\'@\'localhost\' to\ndatabase \'mysql\'\nmysql> SELECT CURRENT_USER();\n        -> \'@localhost\'\n','http://dev.mysql.com/doc/refman/8.0/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (136,12,'CURTIME','Syntax:\nCURTIME([fsp])\n\nReturns the current time as a value in \'HH:MM:SS\' or HHMMSS format,\ndepending on whether the function is used in a string or numeric\ncontext. The value is expressed in the current time zone.\n\nIf the fsp argument is given to specify a fractional seconds precision\nfrom 0 to 6, the return value includes a fractional seconds part of\nthat many digits.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT CURTIME();\n        -> \'23:50:26\'\nmysql> SELECT CURTIME() + 0;\n        -> 235026.000000\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (137,23,'DATABASE','Syntax:\nDATABASE()\n\nReturns the default (current) database name as a string in the utf8\ncharacter set. If there is no default database, DATABASE() returns\nNULL. Within a stored routine, the default database is the database\nthat the routine is associated with, which is not necessarily the same\nas the database that is the default in the calling context.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/information-functions.html\n\n','mysql> SELECT DATABASE();\n        -> \'test\'\n','http://dev.mysql.com/doc/refman/8.0/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (138,11,'DATE','DATE\n\nA date. The supported range is \'1000-01-01\' to \'9999-12-31\'. MySQL\ndisplays DATE values in \'YYYY-MM-DD\' format, but permits assignment of\nvalues to DATE columns using either strings or numbers.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (139,12,'DATE FUNCTION','Syntax:\nDATE(expr)\n\nExtracts the date part of the date or datetime expression expr.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT DATE(\'2003-12-31 01:02:03\');\n        -> \'2003-12-31\'\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (140,12,'DATEDIFF','Syntax:\nDATEDIFF(expr1,expr2)\n\nDATEDIFF() returns expr1 − expr2 expressed as a value in days from\none date to the other. expr1 and expr2 are date or date-and-time\nexpressions. Only the date parts of the values are used in the\ncalculation.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT DATEDIFF(\'2007-12-31 23:59:59\',\'2007-12-30\');\n        -> 1\nmysql> SELECT DATEDIFF(\'2010-11-30 23:59:59\',\'2010-12-31\');\n        -> -31\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (141,11,'DATETIME','DATETIME[(fsp)]\n\nA date and time combination. The supported range is \'1000-01-01\n00:00:00.000000\' to \'9999-12-31 23:59:59.999999\'. MySQL displays\nDATETIME values in \'YYYY-MM-DD HH:MM:SS[.fraction]\' format, but permits\nassignment of values to DATETIME columns using either strings or\nnumbers.\n\nAn optional fsp value in the range from 0 to 6 may be given to specify\nfractional seconds precision. A value of 0 signifies that there is no\nfractional part. If omitted, the default precision is 0.\n\nAutomatic initialization and updating to the current date and time for\nDATETIME columns can be specified using DEFAULT and ON UPDATE column\ndefinition clauses, as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/timestamp-initialization.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (142,12,'DATE_ADD','Syntax:\nDATE_ADD(date,INTERVAL expr unit), DATE_SUB(date,INTERVAL expr unit)\n\nThese functions perform date arithmetic. The date argument specifies\nthe starting date or datetime value. expr is an expression specifying\nthe interval value to be added or subtracted from the starting date.\nexpr is evaluated as a string; it may start with a - for negative\nintervals. unit is a keyword indicating the units in which the\nexpression should be interpreted.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT DATE_ADD(\'2018-05-01\',INTERVAL 1 DAY);\n        -> \'2018-05-02\'\nmysql> SELECT DATE_SUB(\'2018-05-01\',INTERVAL 1 YEAR);\n        -> \'2017-05-01\'\nmysql> SELECT DATE_ADD(\'2020-12-31 23:59:59\',\n    ->                 INTERVAL 1 SECOND);\n        -> \'2021-01-01 00:00:00\'\nmysql> SELECT DATE_ADD(\'2018-12-31 23:59:59\',\n    ->                 INTERVAL 1 DAY);\n        -> \'2019-01-01 23:59:59\'\nmysql> SELECT DATE_ADD(\'2100-12-31 23:59:59\',\n    ->                 INTERVAL \'1:1\' MINUTE_SECOND);\n        -> \'2101-01-01 00:01:00\'\nmysql> SELECT DATE_SUB(\'2025-01-01 00:00:00\',\n    ->                 INTERVAL \'1 1:1:1\' DAY_SECOND);\n        -> \'2024-12-30 22:58:59\'\nmysql> SELECT DATE_ADD(\'1900-01-01 00:00:00\',\n    ->                 INTERVAL \'-1 10\' DAY_HOUR);\n        -> \'1899-12-30 14:00:00\'\nmysql> SELECT DATE_SUB(\'1998-01-02\', INTERVAL 31 DAY);\n        -> \'1997-12-02\'\nmysql> SELECT DATE_ADD(\'1992-12-31 23:59:59.000002\',\n    ->            INTERVAL \'1.999999\' SECOND_MICROSECOND);\n        -> \'1993-01-01 00:00:01.000001\'\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (143,12,'DATE_FORMAT','Syntax:\nDATE_FORMAT(date,format)\n\nFormats the date value according to the format string.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT DATE_FORMAT(\'2009-10-04 22:23:00\', \'%W %M %Y\');\n        -> \'Sunday October 2009\'\nmysql> SELECT DATE_FORMAT(\'2007-10-04 22:23:00\', \'%H:%i:%s\');\n        -> \'22:23:00\'\nmysql> SELECT DATE_FORMAT(\'1900-10-04 22:23:00\',\n    ->                 \'%D %y %a %d %m %b %j\');\n        -> \'4th 00 Thu 04 10 Oct 277\'\nmysql> SELECT DATE_FORMAT(\'1997-10-04 22:23:00\',\n    ->                 \'%H %k %I %r %T %S %w\');\n        -> \'22 22 10 10:23:00 PM 22:23:00 00 6\'\nmysql> SELECT DATE_FORMAT(\'1999-01-01\', \'%X %V\');\n        -> \'1998 52\'\nmysql> SELECT DATE_FORMAT(\'2006-06-00\', \'%d\');\n        -> \'00\'\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (144,12,'DATE_SUB','Syntax:\nDATE_SUB(date,INTERVAL expr unit)\n\nSee the description for DATE_ADD().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (145,12,'DAY','Syntax:\nDAY(date)\n\nDAY() is a synonym for DAYOFMONTH().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (146,12,'DAYNAME','Syntax:\nDAYNAME(date)\n\nReturns the name of the weekday for date. The language used for the\nname is controlled by the value of the lc_time_names system variable\n(http://dev.mysql.com/doc/refman/8.0/en/locale-support.html).\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT DAYNAME(\'2007-02-03\');\n        -> \'Saturday\'\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (147,12,'DAYOFMONTH','Syntax:\nDAYOFMONTH(date)\n\nReturns the day of the month for date, in the range 1 to 31, or 0 for\ndates such as \'0000-00-00\' or \'2008-00-00\' that have a zero day part.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT DAYOFMONTH(\'2007-02-03\');\n        -> 3\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (148,12,'DAYOFWEEK','Syntax:\nDAYOFWEEK(date)\n\nReturns the weekday index for date (1 = Sunday, 2 = Monday, ..., 7 =\nSaturday). These index values correspond to the ODBC standard.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT DAYOFWEEK(\'2007-02-03\');\n        -> 7\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (149,12,'DAYOFYEAR','Syntax:\nDAYOFYEAR(date)\n\nReturns the day of the year for date, in the range 1 to 366.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT DAYOFYEAR(\'2007-02-03\');\n        -> 34\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (150,37,'DEALLOCATE PREPARE','Syntax:\n{DEALLOCATE | DROP} PREPARE stmt_name\n\nTo deallocate a prepared statement produced with PREPARE, use a\nDEALLOCATE PREPARE statement that refers to the prepared statement\nname. Attempting to execute a prepared statement after deallocating it\nresults in an error. If too many prepared statements are created and\nnot deallocated by either the DEALLOCATE PREPARE statement or the end\nof the session, you might encounter the upper limit enforced by the\nmax_prepared_stmt_count system variable.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/deallocate-prepare.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/deallocate-prepare.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (151,11,'DEC','DEC[(M[,D])] [UNSIGNED] [ZEROFILL], NUMERIC[(M[,D])] [UNSIGNED]\n[ZEROFILL], FIXED[(M[,D])] [UNSIGNED] [ZEROFILL]\n\nThese types are synonyms for DECIMAL. The FIXED synonym is available\nfor compatibility with other database systems.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/numeric-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (152,11,'DECIMAL','DECIMAL[(M[,D])] [UNSIGNED] [ZEROFILL]\n\nA packed "exact" fixed-point number. M is the total number of digits\n(the precision) and D is the number of digits after the decimal point\n(the scale). The decimal point and (for negative numbers) the - sign\nare not counted in M. If D is 0, values have no decimal point or\nfractional part. The maximum number of digits (M) for DECIMAL is 65.\nThe maximum number of supported decimals (D) is 30. If D is omitted,\nthe default is 0. If M is omitted, the default is 10.\n\nUNSIGNED, if specified, disallows negative values.\n\nAll basic calculations (+, -, *, /) with DECIMAL columns are done with\na precision of 65 digits.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/numeric-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (153,6,'DECLARE CONDITION','Syntax:\nDECLARE condition_name CONDITION FOR condition_value\n\ncondition_value: {\n    mysql_error_code\n  | SQLSTATE [VALUE] sqlstate_value\n}\n\nThe DECLARE ... CONDITION statement declares a named error condition,\nassociating a name with a condition that needs specific handling. The\nname can be referred to in a subsequent DECLARE ... HANDLER statement\n(see [HELP DECLARE HANDLER]).\n\nCondition declarations must appear before cursor or handler\ndeclarations.\n\nThe condition_value for DECLARE ... CONDITION indicates the specific\ncondition or class of conditions to associate with the condition name.\nIt can take the following forms:\n\no mysql_error_code: An integer literal indicating a MySQL error code.\n\n  Do not use MySQL error code 0 because that indicates success rather\n  than an error condition. For a list of MySQL error codes, see\n  http://dev.mysql.com/doc/refman/8.0/en/server-error-reference.html.\n\no SQLSTATE [VALUE] sqlstate_value: A 5-character string literal\n  indicating an SQLSTATE value.\n\n  Do not use SQLSTATE values that begin with \'00\' because those\n  indicate success rather than an error condition. For a list of\n  SQLSTATE values, see\n  http://dev.mysql.com/doc/refman/8.0/en/server-error-reference.html.\n\nCondition names referred to in SIGNAL or use RESIGNAL statements must\nbe associated with SQLSTATE values, not MySQL error codes.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/declare-condition.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/declare-condition.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (154,6,'DECLARE CURSOR','Syntax:\nDECLARE cursor_name CURSOR FOR select_statement\n\nThis statement declares a cursor and associates it with a SELECT\nstatement that retrieves the rows to be traversed by the cursor. To\nfetch the rows later, use a FETCH statement. The number of columns\nretrieved by the SELECT statement must match the number of output\nvariables specified in the FETCH statement.\n\nThe SELECT statement cannot have an INTO clause.\n\nCursor declarations must appear before handler declarations and after\nvariable and condition declarations.\n\nA stored program may contain multiple cursor declarations, but each\ncursor declared in a given block must have a unique name. For an\nexample, see http://dev.mysql.com/doc/refman/8.0/en/cursors.html.\n\nFor information available through SHOW statements, it is possible in\nmany cases to obtain equivalent information by using a cursor with an\nINFORMATION_SCHEMA table.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/declare-cursor.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/declare-cursor.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (155,6,'DECLARE HANDLER','Syntax:\nDECLARE handler_action HANDLER\n    FOR condition_value [, condition_value] ...\n    statement\n\nhandler_action: {\n    CONTINUE\n  | EXIT\n  | UNDO\n}\n\ncondition_value: {\n    mysql_error_code\n  | SQLSTATE [VALUE] sqlstate_value\n  | condition_name\n  | SQLWARNING\n  | NOT FOUND\n  | SQLEXCEPTION\n}\n\nThe DECLARE ... HANDLER statement specifies a handler that deals with\none or more conditions. If one of these conditions occurs, the\nspecified statement executes. statement can be a simple statement such\nas SET var_name = value, or a compound statement written using BEGIN\nand END (see [HELP BEGIN END]).\n\nHandler declarations must appear after variable or condition\ndeclarations.\n\nThe handler_action value indicates what action the handler takes after\nexecution of the handler statement:\n\no CONTINUE: Execution of the current program continues.\n\no EXIT: Execution terminates for the BEGIN ... END compound statement\n  in which the handler is declared. This is true even if the condition\n  occurs in an inner block.\n\no UNDO: Not supported.\n\nThe condition_value for DECLARE ... HANDLER indicates the specific\ncondition or class of conditions that activates the handler. It can\ntake the following forms:\n\no mysql_error_code: An integer literal indicating a MySQL error code,\n  such as 1051 to specify "unknown table":\n\nDECLARE CONTINUE HANDLER FOR 1051\n  BEGIN\n    -- body of handler\n  END;\n\n  Do not use MySQL error code 0 because that indicates success rather\n  than an error condition. For a list of MySQL error codes, see\n  http://dev.mysql.com/doc/refman/8.0/en/server-error-reference.html.\n\no SQLSTATE [VALUE] sqlstate_value: A 5-character string literal\n  indicating an SQLSTATE value, such as \'42S01\' to specify "unknown\n  table":\n\nDECLARE CONTINUE HANDLER FOR SQLSTATE \'42S02\'\n  BEGIN\n    -- body of handler\n  END;\n\n  Do not use SQLSTATE values that begin with \'00\' because those\n  indicate success rather than an error condition. For a list of\n  SQLSTATE values, see\n  http://dev.mysql.com/doc/refman/8.0/en/server-error-reference.html.\n\no condition_name: A condition name previously specified with DECLARE\n  ... CONDITION. A condition name can be associated with a MySQL error\n  code or SQLSTATE value. See [HELP DECLARE CONDITION].\n\no SQLWARNING: Shorthand for the class of SQLSTATE values that begin\n  with \'01\'.\n\nDECLARE CONTINUE HANDLER FOR SQLWARNING\n  BEGIN\n    -- body of handler\n  END;\n\no NOT FOUND: Shorthand for the class of SQLSTATE values that begin with\n  \'02\'. This is relevant within the context of cursors and is used to\n  control what happens when a cursor reaches the end of a data set. If\n  no more rows are available, a No Data condition occurs with SQLSTATE\n  value \'02000\'. To detect this condition, you can set up a handler for\n  it or for a NOT FOUND condition.\n\nDECLARE CONTINUE HANDLER FOR NOT FOUND\n  BEGIN\n    -- body of handler\n  END;\n\n  For another example, see\n  http://dev.mysql.com/doc/refman/8.0/en/cursors.html. The NOT FOUND\n  condition also occurs for SELECT ... INTO var_list statements that\n  retrieve no rows.\n\no SQLEXCEPTION: Shorthand for the class of SQLSTATE values that do not\n  begin with \'00\', \'01\', or \'02\'.\n\nDECLARE CONTINUE HANDLER FOR SQLEXCEPTION\n  BEGIN\n    -- body of handler\n  END;\n\nFor information about how the server chooses handlers when a condition\noccurs, see http://dev.mysql.com/doc/refman/8.0/en/handler-scope.html.\n\nIf a condition occurs for which no handler has been declared, the\naction taken depends on the condition class:\n\no For SQLEXCEPTION conditions, the stored program terminates at the\n  statement that raised the condition, as if there were an EXIT\n  handler. If the program was called by another stored program, the\n  calling program handles the condition using the handler selection\n  rules applied to its own handlers.\n\no For SQLWARNING conditions, the program continues executing, as if\n  there were a CONTINUE handler.\n\no For NOT FOUND conditions, if the condition was raised normally, the\n  action is CONTINUE. If it was raised by SIGNAL or RESIGNAL, the\n  action is EXIT.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/declare-handler.html\n\n','mysql> CREATE TABLE test.t (s1 INT, PRIMARY KEY (s1));\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> delimiter //\n\nmysql> CREATE PROCEDURE handlerdemo ()\n       BEGIN\n         DECLARE CONTINUE HANDLER FOR SQLSTATE \'23000\' SET @x2 = 1;\n         SET @x = 1;\n         INSERT INTO test.t VALUES (1);\n         SET @x = 2;\n         INSERT INTO test.t VALUES (1);\n         SET @x = 3;\n       END;\n       //\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> CALL handlerdemo()//\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT @x//\n    +------+\n    | @x   |\n    +------+\n    | 3    |\n    +------+\n    1 row in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/8.0/en/declare-handler.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (156,6,'DECLARE VARIABLE','Syntax:\nDECLARE var_name [, var_name] ... type [DEFAULT value]\n\nThis statement declares local variables within stored programs. To\nprovide a default value for a variable, include a DEFAULT clause. The\nvalue can be specified as an expression; it need not be a constant. If\nthe DEFAULT clause is missing, the initial value is NULL.\n\nLocal variables are treated like stored routine parameters with respect\nto data type and overflow checking. See [HELP CREATE PROCEDURE].\n\nVariable declarations must appear before cursor or handler\ndeclarations.\n\nLocal variable names are not case-sensitive. Permissible characters and\nquoting rules are the same as for other identifiers, as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/identifiers.html.\n\nThe scope of a local variable is the BEGIN ... END block within which\nit is declared. The variable can be referred to in blocks nested within\nthe declaring block, except those blocks that declare a variable with\nthe same name.\n\nFor examples of variable declarations, see\nhttp://dev.mysql.com/doc/refman/8.0/en/local-variable-scope.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/declare-local-variable.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/declare-local-variable.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (157,13,'DECODE','Syntax:\nDECODE(crypt_str,pass_str)\n\nThis function was removed in MySQL 8.0.3.\n\nConsider using AES_ENCRYPT() and AES_DECRYPT() instead.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (158,29,'DEFAULT','Syntax:\nDEFAULT(col_name)\n\nReturns the default value for a table column. An error results if the\ncolumn has no default value.\n\nThe use of DEFAULT(col_name) to specify the default value for a named\ncolumn is permitted only for columns that have a literal default value,\nnot for columns that have an expression default value.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html\n\n','mysql> UPDATE t SET i = DEFAULT(i)+1 WHERE id < 100;\n','http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (159,30,'DEGREES','Syntax:\nDEGREES(X)\n\nReturns the argument X, converted from radians to degrees.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT DEGREES(PI());\n        -> 180\nmysql> SELECT DEGREES(PI() / 2);\n        -> 90\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (160,10,'DELETE','Syntax:\nDELETE is a DML statement that removes rows from a table.\n\nA DELETE statement can start with a WITH clause to define common table\nexpressions accessible within the DELETE. See\nhttp://dev.mysql.com/doc/refman/8.0/en/with.html.\n\nSingle-Table Syntax\n\nDELETE [LOW_PRIORITY] [QUICK] [IGNORE] FROM tbl_name [[AS] tbl_alias]\n    [PARTITION (partition_name [, partition_name] ...)]\n    [WHERE where_condition]\n    [ORDER BY ...]\n    [LIMIT row_count]\n\nThe DELETE statement deletes rows from tbl_name and returns the number\nof deleted rows. To check the number of deleted rows, call the\nROW_COUNT() function described in\nhttp://dev.mysql.com/doc/refman/8.0/en/information-functions.html.\n\nMain Clauses\n\nThe conditions in the optional WHERE clause identify which rows to\ndelete. With no WHERE clause, all rows are deleted.\n\nwhere_condition is an expression that evaluates to true for each row to\nbe deleted. It is specified as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/select.html.\n\nIf the ORDER BY clause is specified, the rows are deleted in the order\nthat is specified. The LIMIT clause places a limit on the number of\nrows that can be deleted. These clauses apply to single-table deletes,\nbut not multi-table deletes.\n\nMultiple-Table Syntax\n\nDELETE [LOW_PRIORITY] [QUICK] [IGNORE]\n    tbl_name[.*] [, tbl_name[.*]] ...\n    FROM table_references\n    [WHERE where_condition]\n\nDELETE [LOW_PRIORITY] [QUICK] [IGNORE]\n    FROM tbl_name[.*] [, tbl_name[.*]] ...\n    USING table_references\n    [WHERE where_condition]\n\nPrivileges\n\nYou need the DELETE privilege on a table to delete rows from it. You\nneed only the SELECT privilege for any columns that are only read, such\nas those named in the WHERE clause.\n\nPerformance\n\nWhen you do not need to know the number of deleted rows, the TRUNCATE\nTABLE statement is a faster way to empty a table than a DELETE\nstatement with no WHERE clause. Unlike DELETE, TRUNCATE TABLE cannot be\nused within a transaction or if you have a lock on the table. See [HELP\nTRUNCATE TABLE] and [HELP LOCK].\n\nThe speed of delete operations may also be affected by factors\ndiscussed in\nhttp://dev.mysql.com/doc/refman/8.0/en/delete-optimization.html.\n\nTo ensure that a given DELETE statement does not take too much time,\nthe MySQL-specific LIMIT row_count clause for DELETE specifies the\nmaximum number of rows to be deleted. If the number of rows to delete\nis larger than the limit, repeat the DELETE statement until the number\nof affected rows is less than the LIMIT value.\n\nSubqueries\n\nYou cannot delete from a table and select from the same table in a\nsubquery.\n\nPartitioned Table Support\n\nDELETE supports explicit partition selection using the PARTITION\noption, which takes a list of the comma-separated names of one or more\npartitions or subpartitions (or both) from which to select rows to be\ndropped. Partitions not included in the list are ignored. Given a\npartitioned table t with a partition named p0, executing the statement\nDELETE FROM t PARTITION (p0) has the same effect on the table as\nexecuting ALTER TABLE t TRUNCATE PARTITION (p0); in both cases, all\nrows in partition p0 are dropped.\n\nPARTITION can be used along with a WHERE condition, in which case the\ncondition is tested only on rows in the listed partitions. For example,\nDELETE FROM t PARTITION (p0) WHERE c < 5 deletes rows only from\npartition p0 for which the condition c < 5 is true; rows in any other\npartitions are not checked and thus not affected by the DELETE.\n\nThe PARTITION option can also be used in multiple-table DELETE\nstatements. You can use up to one such option per table named in the\nFROM option.\n\nFor more information and examples, see\nhttp://dev.mysql.com/doc/refman/8.0/en/partitioning-selection.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/delete.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/delete.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (161,15,'DENSE_RANK','DENSE_RANK() over_clause\n\nReturns the rank of the current row within its partition, without gaps.\nPeers are considered ties and receive the same rank. This function\nassigns consecutive ranks to peer groups; the result is that groups of\nsize greater than one do not produce noncontiguous rank numbers. For an\nexample, see the RANK() function description.\n\nThis function should be used with ORDER BY to sort partition rows into\nthe desired order. Without ORDER BY, all rows are peers.\n\nover_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/window-function-descriptions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/window-function-descriptions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (162,13,'DES_DECRYPT','Syntax:\nDES_DECRYPT(crypt_str[,key_str])\n\nThis function was removed in MySQL 8.0.3.\n\nConsider using AES_ENCRYPT() and AES_DECRYPT() instead.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (163,13,'DES_ENCRYPT','Syntax:\nDES_ENCRYPT(str[,{key_num|key_str}])\n\nThis function was removed in MySQL 8.0.3.\n\nConsider using AES_ENCRYPT() and AES_DECRYPT() instead.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (164,30,'DIV','Syntax:\nDIV\n\nInteger division. Discards from the division result any fractional part\nto the right of the decimal point.\n\nIf either operand has a noninteger type, the operands are converted to\nDECIMAL and divided using DECIMAL arithmetic before converting the\nresult to BIGINT. If the result exceeds BIGINT range, an error occurs.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/arithmetic-functions.html\n\n','mysql> SELECT 5 DIV 2, -5 DIV 2, 5 DIV -2, -5 DIV -2;\n        -> 2, -2, -2, 2\n','http://dev.mysql.com/doc/refman/8.0/en/arithmetic-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (165,10,'DO','Syntax:\nDO expr [, expr] ...\n\nDO executes the expressions but does not return any results. In most\nrespects, DO is shorthand for SELECT expr, ..., but has the advantage\nthat it is slightly faster when you do not care about the result.\n\nDO is useful primarily with functions that have side effects, such as\nRELEASE_LOCK().\n\nExample: This SELECT statement pauses, but also produces a result set:\n\nmysql> SELECT SLEEP(5);\n+----------+\n| SLEEP(5) |\n+----------+\n|        0 |\n+----------+\n1 row in set (5.02 sec)\n\nDO, on the other hand, pauses without producing a result set.:\n\nmysql> DO SLEEP(5);\nQuery OK, 0 rows affected (4.99 sec)\n\nThis could be useful, for example in a stored function or trigger,\nwhich prohibit statements that produce result sets.\n\nDO only executes expressions. It cannot be used in all cases where\nSELECT can be used. For example, DO id FROM t1 is invalid because it\nreferences a table.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/do.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/do.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (166,11,'DOUBLE','DOUBLE[(M,D)] [UNSIGNED] [ZEROFILL]\n\nA normal-size (double-precision) floating-point number. Permissible\nvalues are -1.7976931348623157E+308 to -2.2250738585072014E-308, 0, and\n2.2250738585072014E-308 to 1.7976931348623157E+308. These are the\ntheoretical limits, based on the IEEE standard. The actual range might\nbe slightly smaller depending on your hardware or operating system.\n\nM is the total number of digits and D is the number of digits following\nthe decimal point. If M and D are omitted, values are stored to the\nlimits permitted by the hardware. A double-precision floating-point\nnumber is accurate to approximately 15 decimal places.\n\nUNSIGNED, if specified, disallows negative values.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/numeric-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (167,11,'DOUBLE PRECISION','DOUBLE PRECISION[(M,D)] [UNSIGNED] [ZEROFILL], REAL[(M,D)] [UNSIGNED]\n[ZEROFILL]\n\nThese types are synonyms for DOUBLE. Exception: If the REAL_AS_FLOAT\nSQL mode is enabled, REAL is a synonym for FLOAT rather than DOUBLE.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/numeric-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (168,9,'DROP DATABASE','Syntax:\nDROP {DATABASE | SCHEMA} [IF EXISTS] db_name\n\nDROP DATABASE drops all tables in the database and deletes the\ndatabase. Be very careful with this statement! To use DROP DATABASE,\nyou need the DROP privilege on the database. DROP SCHEMA is a synonym\nfor DROP DATABASE.\n\n*Important*:\n\nWhen a database is dropped, privileges granted specifically for the\ndatabase are not automatically dropped. They must be dropped manually.\nSee [HELP GRANT].\n\nIF EXISTS is used to prevent an error from occurring if the database\ndoes not exist.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/drop-database.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/drop-database.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (169,9,'DROP EVENT','Syntax:\nDROP EVENT [IF EXISTS] event_name\n\nThis statement drops the event named event_name. The event immediately\nceases being active, and is deleted completely from the server.\n\nIf the event does not exist, the error ERROR 1517 (HY000): Unknown\nevent \'event_name\' results. You can override this and cause the\nstatement to generate a warning for nonexistent events instead using IF\nEXISTS.\n\nThis statement requires the EVENT privilege for the schema to which the\nevent to be dropped belongs.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/drop-event.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/drop-event.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (170,9,'DROP FUNCTION','The DROP FUNCTION statement is used to drop stored functions and\nuser-defined functions (UDFs):\n\no For information about dropping stored functions, see [HELP DROP\n  PROCEDURE].\n\no For information about dropping user-defined functions, see [HELP DROP\n  FUNCTION UDF].\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/drop-function.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/drop-function.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (171,38,'DROP FUNCTION UDF','Syntax:\nDROP FUNCTION function_name\n\nThis statement drops the user-defined function (UDF) named\nfunction_name.\n\nTo drop a function, you must have the DELETE privilege for the mysql\nsystem database. This is because DROP FUNCTION removes a row from the\nmysql.func system table that records the function\'s name, type, and\nshared library name.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/drop-function-udf.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/drop-function-udf.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (172,9,'DROP INDEX','Syntax:\nDROP INDEX index_name ON tbl_name\n    [algorithm_option | lock_option] ...\n\nalgorithm_option:\n    ALGORITHM [=] {DEFAULT|INPLACE|COPY}\n\nlock_option:\n    LOCK [=] {DEFAULT|NONE|SHARED|EXCLUSIVE}\n\nDROP INDEX drops the index named index_name from the table tbl_name.\nThis statement is mapped to an ALTER TABLE statement to drop the index.\nSee [HELP ALTER TABLE].\n\nTo drop a primary key, the index name is always PRIMARY, which must be\nspecified as a quoted identifier because PRIMARY is a reserved word:\n\nDROP INDEX `PRIMARY` ON t;\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/drop-index.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/drop-index.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (173,9,'DROP PROCEDURE','Syntax:\nDROP {PROCEDURE | FUNCTION} [IF EXISTS] sp_name\n\nThis statement is used to drop a stored procedure or function. That is,\nthe specified routine is removed from the server. You must have the\nALTER ROUTINE privilege for the routine. (If the\nautomatic_sp_privileges system variable is enabled, that privilege and\nEXECUTE are granted automatically to the routine creator when the\nroutine is created and dropped from the creator when the routine is\ndropped. See\nhttp://dev.mysql.com/doc/refman/8.0/en/stored-routines-privileges.html.\n)\n\nThe IF EXISTS clause is a MySQL extension. It prevents an error from\noccurring if the procedure or function does not exist. A warning is\nproduced that can be viewed with SHOW WARNINGS.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/drop-procedure.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/drop-procedure.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (174,1,'DROP RESOURCE GROUP','Syntax:\nDROP RESOURCE GROUP group_name [FORCE]\n\nDROP RESOURCE GROUP is used for resource group management (see\nhttp://dev.mysql.com/doc/refman/8.0/en/resource-groups.html). This\nstatement drops a resource group. It requires the RESOURCE_GROUP_ADMIN\nprivilege.\n\ngroup_name identifies which resource group to drop. If the group does\nnot exist, an error occurs.\n\nThe FORCE modifier determines statement behavior if the resource group\nhas any threads assigned to it:\n\no If FORCE is not given and any threads are assigned to the group, an\n  error occurs.\n\no If FORCE is given, existing threads in the group are moved to their\n  respective default group (system threads to SYS_default, user threads\n  to USR_default).\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/drop-resource-group.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/drop-resource-group.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (175,1,'DROP ROLE','Syntax:\nDROP ROLE [IF EXISTS] role [, role ] ...\n\nDROP ROLE removes one or more roles (named collections of privileges).\nTo use this statement, you must have the global DROP ROLE or CREATE\nUSER privilege. When the read_only system variable is enabled, DROP\nROLE additionally requires the CONNECTION_ADMIN or SUPER privilege.\n\nAs of MySQL 8.0.16, users who have the CREATE USER privilege can use\nthis statement to drop accounts that are locked or unlocked. Users who\nhave the DROP ROLE privilege can use this statement only to drop\naccounts that are locked (unlocked accounts are presumably user\naccounts used to log in to the server and not just as roles).\n\nRoles named in the mandatory_roles system variable value cannot be\ndropped.\n\nDROP ROLE either succeeds for all named roles or rolls back and has no\neffect if any error occurs. By default, an error occurs if you try to\ndrop a role that does not exist. If the IF EXISTS clause is given, the\nstatement produces a warning for each named role that does not exist,\nrather than an error.\n\nThe statement is written to the binary log if it succeeds, but not if\nit fails; in that case, rollback occurs and no changes are made. A\nstatement written to the binary log includes all named roles. If the IF\nEXISTS clause is given, this includes even roles that do not exist and\nwere not dropped.\n\nEach role name uses the format described in\nhttp://dev.mysql.com/doc/refman/8.0/en/role-names.html. For example:\n\nDROP ROLE \'administrator\', \'developer\';\nDROP ROLE \'webapp\'@\'localhost\';\n\nThe host name part of the role name, if omitted, defaults to \'%\'.\n\nA dropped role is automatically revoked from any user account (or role)\nto which the role was granted. Within any current session for such an\naccount, its adjusted privileges apply beginning with the next\nstatement executed.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/drop-role.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/drop-role.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (176,9,'DROP SERVER','Syntax:\nDROP SERVER [ IF EXISTS ] server_name\n\nDrops the server definition for the server named server_name. The\ncorresponding row in the mysql.servers table is deleted. This statement\nrequires the SUPER privilege.\n\nDropping a server for a table does not affect any FEDERATED tables that\nused this connection information when they were created. See [HELP\nCREATE SERVER].\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/drop-server.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/drop-server.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (177,9,'DROP SPATIAL REFERENCE SYSTEM','Syntax:\nDROP SPATIAL REFERENCE SYSTEM\n    [IF EXISTS]\n    srid\n\nsrid: 32-bit unsigned integer\n\nThis statement removes a spatial reference system (SRS) definition from\nthe data dictionary. It requires the SUPER privilege.\n\nExample:\n\nDROP SPATIAL REFERENCE SYSTEM 4120;\n\nIf no SRS definition with the SRID value exists, an error occurs unless\nIF EXISTS is specified. In that case, a warning occurs rather than an\nerror.\n\nIf the SRID value is used by some column in an existing table, an error\noccurs. For example:\n\nmysql> DROP SPATIAL REFERENCE SYSTEM 4326;\nERROR 3716 (SR005): Can\'t modify SRID 4326. There is at\nleast one column depending on it.\n\nTo identify which column or columns use the SRID, use this query:\n\nSELECT * FROM INFORMATION_SCHEMA.ST_GEOMETRY_COLUMNS WHERE SRS_ID=4326;\n\nSRID values must be in the range of 32-bit unsigned integers, with\nthese restrictions:\n\no SRID 0 is a valid SRID but cannot be used with DROP SPATIAL REFERENCE\n  SYSTEM.\n\no If the value is in a reserved SRID range, a warning occurs. Reserved\n  ranges are [0, 32767] (reserved by EPSG), [60,000,000, 69,999,999]\n  (reserved by EPSG), and [2,000,000,000, 2,147,483,647] (reserved by\n  MySQL). EPSG stands for the European Petroleum Survey Group\n  (http://epsg.org).\n\no Users should not drop SRSs with SRIDs in the reserved ranges. If\n  system-installed SRSs are dropped, the SRS definitions may be\n  recreated for MySQL upgrades.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/drop-spatial-reference-system.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/drop-spatial-reference-system.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (178,9,'DROP TABLE','Syntax:\nDROP [TEMPORARY] TABLE [IF EXISTS]\n    tbl_name [, tbl_name] ...\n    [RESTRICT | CASCADE]\n\nDROP TABLE removes one or more tables. You must have the DROP privilege\nfor each table.\n\nBe careful with this statement! It removes the table definition and all\ntable data. For a partitioned table, it permanently removes the table\ndefinition, all its partitions, and all data stored in those\npartitions. It also removes partition definitions associated with the\ndropped table.\n\nDropping a table also drops any triggers for the table.\n\nDROP TABLE causes an implicit commit, except when used with the\nTEMPORARY keyword. See\nhttp://dev.mysql.com/doc/refman/8.0/en/implicit-commit.html.\n\n*Important*:\n\nWhen a table is dropped, privileges granted specifically for the table\nare not automatically dropped. They must be dropped manually. See [HELP\nGRANT].\n\nIf any tables named in the argument list do not exist, the statement\nfails with an error indicating by name which nonexisting tables it was\nunable to drop, and no changes are made.\n\nUse IF EXISTS to prevent an error from occurring for tables that do not\nexist. Instead of an error, a NOTE is generated for each nonexistent\ntable; these notes can be displayed with SHOW WARNINGS. See [HELP SHOW\nWARNINGS].\n\nIF EXISTS can also be useful for dropping tables in unusual\ncircumstances under which there is an entry in the data dictionary but\nno table managed by the storage engine. (For example, if an abnormal\nserver exit occurs after removal of the table from the storage engine\nbut before removal of the data dictionary entry.)\n\nThe TEMPORARY keyword has the following effects:\n\no The statement drops only TEMPORARY tables.\n\no The statement does not cause an implicit commit.\n\no No access rights are checked. A TEMPORARY table is visible only with\n  the session that created it, so no check is necessary.\n\nUsing TEMPORARY is a good way to ensure that you do not accidentally\ndrop a non-TEMPORARY table.\n\nThe RESTRICT and CASCADE keywords do nothing. They are permitted to\nmake porting easier from other database systems.\n\nDROP TABLE is not supported with all innodb_force_recovery settings.\nSee\nhttp://dev.mysql.com/doc/refman/8.0/en/forcing-innodb-recovery.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/drop-table.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/drop-table.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (179,9,'DROP TABLESPACE','Syntax:\nDROP [UNDO] TABLESPACE tablespace_name\n    [ENGINE [=] engine_name]\n\nThis statement drops a tablespace that was previously created using\nCREATE TABLESPACE. It is supported by the NDB and InnoDB storage\nengines.\n\nThe UNDO keyword, introduced in MySQL 8.0.14, must be specified to drop\nan undo tablespace. Only undo tablespaces created using CREATE UNDO\nTABLESPACE syntax can be dropped. An undo tablespace must be in an\nempty state before it can be dropped. For more information, see\nhttp://dev.mysql.com/doc/refman/8.0/en/innodb-undo-tablespaces.html.\n\nENGINE sets the storage engine that uses the tablespace, where\nengine_name is the name of the storage engine. Currently, the values\nInnoDB and NDB are supported. If not set, the value of\ndefault_storage_engine is used. If it is not the same as the storage\nengine used to create the tablespace, the DROP TABLESPACE statement\nfails.\n\ntablespace_name is a case-sensitive identifier in MySQL.\n\nFor an InnoDB general tablespace, all tables must be dropped from the\ntablespace prior to a DROP TABLESPACE operation. If the tablespace is\nnot empty, DROP TABLESPACE returns an error.\n\nAn NDB tablespace to be dropped must not contain any data files; in\nother words, before you can drop an NDB tablespace, you must first drop\neach of its data files using ALTER TABLESPACE ... DROP DATAFILE.\n\nNotes\n\no A general InnoDB tablespace is not deleted automatically when the\n  last table in the tablespace is dropped. The tablespace must be\n  dropped explicitly using DROP TABLESPACE tablespace_name.\n\no A DROP DATABASE operation can drop tables that belong to a general\n  tablespace but it cannot drop the tablespace, even if the operation\n  drops all tables that belong to the tablespace. The tablespace must\n  be dropped explicitly using DROP TABLESPACE tablespace_name.\n\no Similar to the system tablespace, truncating or dropping tables\n  stored in a general tablespace creates free space internally in the\n  general tablespace .ibd data file which can only be used for new\n  InnoDB data. Space is not released back to the operating system as it\n  is for file-per-table tablespaces.\n\nInnoDB Examples\n\nThis example demonstrates how to drop an InnoDB general tablespace. The\ngeneral tablespace ts1 is created with a single table. Before dropping\nthe tablespace, the table must be dropped.\n\nmysql> CREATE TABLESPACE `ts1` ADD DATAFILE \'ts1.ibd\' Engine=InnoDB;     \n\nmysql> CREATE TABLE t1 (c1 INT PRIMARY KEY) TABLESPACE ts10 Engine=InnoDB;     \n\nmysql> DROP TABLE t1;\n\nmysql> DROP TABLESPACE ts1;\n\nThis example demonstrates dropping an undo tablespace. An undo\ntablespace must be in an empty state before it can be dropped. For more\ninformation, see\nhttp://dev.mysql.com/doc/refman/8.0/en/innodb-undo-tablespaces.html.\n\nmysql> DROP UNDO TABLESPACE undo_003;\n\nNDB Example\n\nThis example shows how to drop an NDB tablespace myts having a data\nfile named mydata-1.dat after first creating the tablespace, and\nassumes the existence of a log file group named mylg (see [HELP CREATE\nLOGFILE GROUP]).\n\nmysql> CREATE TABLESPACE myts\n    ->     ADD DATAFILE \'mydata-1.dat\'\n    ->     USE LOGFILE GROUP mylg\n    ->     ENGINE=NDB;\n\nYou must remove all data files from the tablespace using ALTER\nTABLESPACE, as shown here, before it can be dropped:\n\nmysql> ALTER TABLESPACE myts\n    ->     DROP DATAFILE \'mydata-1.dat\'\n    ->     ENGINE=NDB;\n\nmysql> DROP TABLESPACE myts;\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/drop-tablespace.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/drop-tablespace.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (180,9,'DROP TRIGGER','Syntax:\nDROP TRIGGER [IF EXISTS] [schema_name.]trigger_name\n\nThis statement drops a trigger. The schema (database) name is optional.\nIf the schema is omitted, the trigger is dropped from the default\nschema. DROP TRIGGER requires the TRIGGER privilege for the table\nassociated with the trigger.\n\nUse IF EXISTS to prevent an error from occurring for a trigger that\ndoes not exist. A NOTE is generated for a nonexistent trigger when\nusing IF EXISTS. See [HELP SHOW WARNINGS].\n\nTriggers for a table are also dropped if you drop the table.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/drop-trigger.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/drop-trigger.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (181,1,'DROP USER','Syntax:\nDROP USER [IF EXISTS] user [, user] ...\n\nThe DROP USER statement removes one or more MySQL accounts and their\nprivileges. It removes privilege rows for the account from all grant\ntables.\n\nRoles named in the mandatory_roles system variable value cannot be\ndropped.\n\nTo use DROP USER, you must have the global CREATE USER privilege, or\nthe DELETE privilege for the mysql system database. When the read_only\nsystem variable is enabled, DROP USER additionally requires the\nCONNECTION_ADMIN or SUPER privilege.\n\nDROP USER either succeeds for all named users or rolls back and has no\neffect if any error occurs. By default, an error occurs if you try to\ndrop a user that does not exist. If the IF EXISTS clause is given, the\nstatement produces a warning for each named user that does not exist,\nrather than an error.\n\nThe statement is written to the binary log if it succeeds, but not if\nit fails; in that case, rollback occurs and no changes are made. A\nstatement written to the binary log includes all named users. If the IF\nEXISTS clause is given, this includes even users that do not exist and\nwere not dropped.\n\nEach account name uses the format described in\nhttp://dev.mysql.com/doc/refman/8.0/en/account-names.html. For example:\n\nDROP USER \'jeffrey\'@\'localhost\';\n\nThe host name part of the account name, if omitted, defaults to \'%\'.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/drop-user.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/drop-user.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (182,9,'DROP VIEW','Syntax:\nDROP VIEW [IF EXISTS]\n    view_name [, view_name] ...\n    [RESTRICT | CASCADE]\n\nDROP VIEW removes one or more views. You must have the DROP privilege\nfor each view.\n\nIf any views named in the argument list do not exist, the statement\nfails with an error indicating by name which nonexisting views it was\nunable to drop, and no changes are made.\n\n*Note*:\n\nIn MySQL 5.7 and earlier, DROP VIEW returns an error if any views named\nin the argument list do not exist, but also drops all views in the list\nthat do exist. Due to the change in behavior in MySQL 8.0, a partially\ncompleted DROP VIEW operation on a MySQL 5.7 master fails when\nreplicated on a MySQL 8.0 slave. To avoid this failure scenario, use IF\nEXISTS syntax in DROP VIEW statements to prevent an error from\noccurring for views that do not exist. For more information, see\nhttp://dev.mysql.com/doc/refman/8.0/en/atomic-ddl.html.\n\nThe IF EXISTS clause prevents an error from occurring for views that\ndon\'t exist. When this clause is given, a NOTE is generated for each\nnonexistent view. See [HELP SHOW WARNINGS].\n\nRESTRICT and CASCADE, if given, are parsed and ignored.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/drop-view.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/drop-view.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (183,10,'DUAL','You are permitted to specify DUAL as a dummy table name in situations\nwhere no tables are referenced:\n\nmysql> SELECT 1 + 1 FROM DUAL;\n        -> 2\n\nDUAL is purely for the convenience of people who require that all\nSELECT statements should have FROM and possibly other clauses. MySQL\nmay ignore the clauses. MySQL does not require FROM DUAL if no tables\nare referenced.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/select.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/select.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (184,35,'ELT','Syntax:\nELT(N,str1,str2,str3,...)\n\nELT() returns the Nth element of the list of strings: str1 if N = 1,\nstr2 if N = 2, and so on. Returns NULL if N is less than 1 or greater\nthan the number of arguments. ELT() is the complement of FIELD().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT ELT(1, \'Aa\', \'Bb\', \'Cc\', \'Dd\');\n        -> \'Aa\'\nmysql> SELECT ELT(4, \'Aa\', \'Bb\', \'Cc\', \'Dd\');\n        -> \'Dd\'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (185,13,'ENCODE','Syntax:\nENCODE(str,pass_str)\n\nThis function was removed in MySQL 8.0.3.\n\nConsider using AES_ENCRYPT() and AES_DECRYPT() instead.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (186,13,'ENCRYPT','Syntax:\nENCRYPT(str[,salt])\n\nThis function was removed in MySQL 8.0.3. For one-way hashing, consider\nusing SHA2() instead.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (187,11,'ENUM','ENUM(\'value1\',\'value2\',...) [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nAn enumeration. A string object that can have only one value, chosen\nfrom the list of values \'value1\', \'value2\', ..., NULL or the special \'\'\nerror value. ENUM values are represented internally as integers.\n\nAn ENUM column can have a maximum of 65,535 distinct elements.\n\nThe maximum supported length of an individual ENUM element is M <= 255\nand (M x w) <= 1020, where M is the element literal length and w is the\nnumber of bytes required for the maximum-length character in the\ncharacter set.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (188,37,'EXECUTE STATEMENT','Syntax:\nEXECUTE stmt_name\n    [USING @var_name [, @var_name] ...]\n\nAfter preparing a statement with PREPARE, you execute it with an\nEXECUTE statement that refers to the prepared statement name. If the\nprepared statement contains any parameter markers, you must supply a\nUSING clause that lists user variables containing the values to be\nbound to the parameters. Parameter values can be supplied only by user\nvariables, and the USING clause must name exactly as many variables as\nthe number of parameter markers in the statement.\n\nYou can execute a given prepared statement multiple times, passing\ndifferent variables to it or setting the variables to different values\nbefore each execution.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/execute.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/execute.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (189,30,'EXP','Syntax:\nEXP(X)\n\nReturns the value of e (the base of natural logarithms) raised to the\npower of X. The inverse of this function is LOG() (using a single\nargument only) or LN().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT EXP(2);\n        -> 7.3890560989307\nmysql> SELECT EXP(-2);\n        -> 0.13533528323661\nmysql> SELECT EXP(0);\n        -> 1\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (190,39,'EXPLAIN','Syntax:\n{EXPLAIN | DESCRIBE | DESC}\n    tbl_name [col_name | wild]\n\n{EXPLAIN | DESCRIBE | DESC}\n    [explain_type]\n    {explainable_stmt | FOR CONNECTION connection_id}\n\nexplain_type: {\n    FORMAT = format_name\n}\n\nformat_name: {\n    TRADITIONAL\n  | JSON\n}\n\nexplainable_stmt: {\n    SELECT statement\n  | DELETE statement\n  | INSERT statement\n  | REPLACE statement\n  | UPDATE statement\n}\n\nThe DESCRIBE and EXPLAIN statements are synonyms. In practice, the\nDESCRIBE keyword is more often used to obtain information about table\nstructure, whereas EXPLAIN is used to obtain a query execution plan\n(that is, an explanation of how MySQL would execute a query).\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/explain.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/explain.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (191,35,'EXPORT_SET','Syntax:\nEXPORT_SET(bits,on,off[,separator[,number_of_bits]])\n\nReturns a string such that for every bit set in the value bits, you get\nan on string and for every bit not set in the value, you get an off\nstring. Bits in bits are examined from right to left (from low-order to\nhigh-order bits). Strings are added to the result from left to right,\nseparated by the separator string (the default being the comma\ncharacter ,). The number of bits examined is given by number_of_bits,\nwhich has a default of 64 if not specified. number_of_bits is silently\nclipped to 64 if larger than 64. It is treated as an unsigned integer,\nso a value of −1 is effectively the same as 64.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT EXPORT_SET(5,\'Y\',\'N\',\',\',4);\n        -> \'Y,N,Y,N\'\nmysql> SELECT EXPORT_SET(6,\'1\',\'0\',\',\',10);\n        -> \'0,1,1,0,0,0,0,0,0,0\'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (192,12,'EXTRACT','Syntax:\nEXTRACT(unit FROM date)\n\nThe EXTRACT() function uses the same kinds of unit specifiers as\nDATE_ADD() or DATE_SUB(), but extracts parts from the date rather than\nperforming date arithmetic. For information on the unit argument, see\nhttp://dev.mysql.com/doc/refman/8.0/en/expressions.html#temporal-interv\nals.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT EXTRACT(YEAR FROM \'2019-07-02\');\n        -> 2019\nmysql> SELECT EXTRACT(YEAR_MONTH FROM \'2019-07-02 01:02:03\');\n        -> 201907\nmysql> SELECT EXTRACT(DAY_MINUTE FROM \'2019-07-02 01:02:03\');\n        -> 20102\nmysql> SELECT EXTRACT(MICROSECOND\n    ->                FROM \'2003-01-02 10:30:00.000123\');\n        -> 123\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (193,35,'EXTRACTVALUE','Syntax:\nExtractValue(xml_frag, xpath_expr)\n\nExtractValue() takes two string arguments, a fragment of XML markup\nxml_frag and an XPath expression xpath_expr (also known as a locator);\nit returns the text (CDATA) of the first text node which is a child of\nthe element or elements matched by the XPath expression.\n\nUsing this function is the equivalent of performing a match using the\nxpath_expr after appending /text(). In other words,\nExtractValue(\'<a><b>Sakila</b></a>\', \'/a/b\') and\nExtractValue(\'<a><b>Sakila</b></a>\', \'/a/b/text()\') produce the same\nresult.\n\nIf multiple matches are found, the content of the first child text node\nof each matching element is returned (in the order matched) as a\nsingle, space-delimited string.\n\nIf no matching text node is found for the expression (including the\nimplicit /text())---for whatever reason, as long as xpath_expr is\nvalid, and xml_frag consists of elements which are properly nested and\nclosed---an empty string is returned. No distinction is made between a\nmatch on an empty element and no match at all. This is by design.\n\nIf you need to determine whether no matching element was found in\nxml_frag or such an element was found but contained no child text\nnodes, you should test the result of an expression that uses the XPath\ncount() function. For example, both of these statements return an empty\nstring, as shown here:\n\nmysql> SELECT ExtractValue(\'<a><b/></a>\', \'/a/b\');\n+-------------------------------------+\n| ExtractValue(\'<a><b/></a>\', \'/a/b\') |\n+-------------------------------------+\n|                                     |\n+-------------------------------------+\n1 row in set (0.00 sec)\n\nmysql> SELECT ExtractValue(\'<a><c/></a>\', \'/a/b\');\n+-------------------------------------+\n| ExtractValue(\'<a><c/></a>\', \'/a/b\') |\n+-------------------------------------+\n|                                     |\n+-------------------------------------+\n1 row in set (0.00 sec)\n\nHowever, you can determine whether there was actually a matching\nelement using the following:\n\nmysql> SELECT ExtractValue(\'<a><b/></a>\', \'count(/a/b)\');\n+-------------------------------------+\n| ExtractValue(\'<a><b/></a>\', \'count(/a/b)\') |\n+-------------------------------------+\n| 1                                   |\n+-------------------------------------+\n1 row in set (0.00 sec)\n\nmysql> SELECT ExtractValue(\'<a><c/></a>\', \'count(/a/b)\');\n+-------------------------------------+\n| ExtractValue(\'<a><c/></a>\', \'count(/a/b)\') |\n+-------------------------------------+\n| 0                                   |\n+-------------------------------------+\n1 row in set (0.01 sec)\n\n*Important*:\n\nExtractValue() returns only CDATA, and does not return any tags that\nmight be contained within a matching tag, nor any of their content (see\nthe result returned as val1 in the following example).\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/xml-functions.html\n\n','mysql> SELECT\n    ->   ExtractValue(\'<a>ccc<b>ddd</b></a>\', \'/a\') AS val1,\n    ->   ExtractValue(\'<a>ccc<b>ddd</b></a>\', \'/a/b\') AS val2,\n    ->   ExtractValue(\'<a>ccc<b>ddd</b></a>\', \'//b\') AS val3,\n    ->   ExtractValue(\'<a>ccc<b>ddd</b></a>\', \'/b\') AS val4,\n    ->   ExtractValue(\'<a>ccc<b>ddd</b><b>eee</b></a>\', \'//b\') AS val5;\n\n+------+------+------+------+---------+\n| val1 | val2 | val3 | val4 | val5    |\n+------+------+------+------+---------+\n| ccc  | ddd  | ddd  |      | ddd eee |\n+------+------+------+------+---------+\n','http://dev.mysql.com/doc/refman/8.0/en/xml-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (194,6,'FETCH','Syntax:\nFETCH [[NEXT] FROM] cursor_name INTO var_name [, var_name] ...\n\nThis statement fetches the next row for the SELECT statement associated\nwith the specified cursor (which must be open), and advances the cursor\npointer. If a row exists, the fetched columns are stored in the named\nvariables. The number of columns retrieved by the SELECT statement must\nmatch the number of output variables specified in the FETCH statement.\n\nIf no more rows are available, a No Data condition occurs with SQLSTATE\nvalue \'02000\'. To detect this condition, you can set up a handler for\nit (or for a NOT FOUND condition). For an example, see\nhttp://dev.mysql.com/doc/refman/8.0/en/cursors.html.\n\nBe aware that another operation, such as a SELECT or another FETCH, may\nalso cause the handler to execute by raising the same condition. If it\nis necessary to distinguish which operation raised the condition, place\nthe operation within its own BEGIN ... END block so that it can be\nassociated with its own handler.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/fetch.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/fetch.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (195,35,'FIELD','Syntax:\nFIELD(str,str1,str2,str3,...)\n\nReturns the index (position) of str in the str1, str2, str3, ... list.\nReturns 0 if str is not found.\n\nIf all arguments to FIELD() are strings, all arguments are compared as\nstrings. If all arguments are numbers, they are compared as numbers.\nOtherwise, the arguments are compared as double.\n\nIf str is NULL, the return value is 0 because NULL fails equality\ncomparison with any value. FIELD() is the complement of ELT().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT FIELD(\'Bb\', \'Aa\', \'Bb\', \'Cc\', \'Dd\', \'Ff\');\n        -> 2\nmysql> SELECT FIELD(\'Gg\', \'Aa\', \'Bb\', \'Cc\', \'Dd\', \'Ff\');\n        -> 0\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (196,35,'FIND_IN_SET','Syntax:\nFIND_IN_SET(str,strlist)\n\nReturns a value in the range of 1 to N if the string str is in the\nstring list strlist consisting of N substrings. A string list is a\nstring composed of substrings separated by , characters. If the first\nargument is a constant string and the second is a column of type SET,\nthe FIND_IN_SET() function is optimized to use bit arithmetic. Returns\n0 if str is not in strlist or if strlist is the empty string. Returns\nNULL if either argument is NULL. This function does not work properly\nif the first argument contains a comma (,) character.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT FIND_IN_SET(\'b\',\'a,b,c,d\');\n        -> 2\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (197,15,'FIRST_VALUE','FIRST_VALUE(expr) [null_treatment] over_clause\n\nReturns the value of expr from the first row of the window frame.\n\nover_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html.\nnull_treatment is as described in the section introduction.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/window-function-descriptions.html\n\n','mysql> SELECT\n         time, subject, val,\n         FIRST_VALUE(val)  OVER w AS \'first\',\n         LAST_VALUE(val)   OVER w AS \'last\',\n         NTH_VALUE(val, 2) OVER w AS \'second\',\n         NTH_VALUE(val, 4) OVER w AS \'fourth\'\n       FROM observations\n       WINDOW w AS (PARTITION BY subject ORDER BY time\n                    ROWS UNBOUNDED PRECEDING);\n+----------+---------+------+-------+------+--------+--------+\n| time     | subject | val  | first | last | second | fourth |\n+----------+---------+------+-------+------+--------+--------+\n| 07:00:00 | st113   |   10 |    10 |   10 |   NULL |   NULL |\n| 07:15:00 | st113   |    9 |    10 |    9 |      9 |   NULL |\n| 07:30:00 | st113   |   25 |    10 |   25 |      9 |   NULL |\n| 07:45:00 | st113   |   20 |    10 |   20 |      9 |     20 |\n| 07:00:00 | xh458   |    0 |     0 |    0 |   NULL |   NULL |\n| 07:15:00 | xh458   |   10 |     0 |   10 |     10 |   NULL |\n| 07:30:00 | xh458   |    5 |     0 |    5 |     10 |   NULL |\n| 07:45:00 | xh458   |   30 |     0 |   30 |     10 |     30 |\n| 08:00:00 | xh458   |   25 |     0 |   25 |     10 |     30 |\n+----------+---------+------+-------+------+--------+--------+\n','http://dev.mysql.com/doc/refman/8.0/en/window-function-descriptions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (198,11,'FLOAT','FLOAT[(M,D)] [UNSIGNED] [ZEROFILL]\n\nA small (single-precision) floating-point number. Permissible values\nare -3.402823466E+38 to -1.175494351E-38, 0, and 1.175494351E-38 to\n3.402823466E+38. These are the theoretical limits, based on the IEEE\nstandard. The actual range might be slightly smaller depending on your\nhardware or operating system.\n\nM is the total number of digits and D is the number of digits following\nthe decimal point. If M and D are omitted, values are stored to the\nlimits permitted by the hardware. A single-precision floating-point\nnumber is accurate to approximately 7 decimal places.\n\nUNSIGNED, if specified, disallows negative values.\n\nUsing FLOAT might give you some unexpected problems because all\ncalculations in MySQL are done with double precision. See\nhttp://dev.mysql.com/doc/refman/8.0/en/no-matching-rows.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/numeric-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (199,30,'FLOOR','Syntax:\nFLOOR(X)\n\nReturns the largest integer value not greater than X.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT FLOOR(1.23), FLOOR(-1.23);\n        -> 1, -2\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (200,2,'FLUSH','Syntax:\nFLUSH [NO_WRITE_TO_BINLOG | LOCAL] {\n    flush_option [, flush_option] ...\n  | tables_option\n}\n\nflush_option: {\n    BINARY LOGS\n  | ENGINE LOGS\n  | ERROR LOGS\n  | GENERAL LOGS\n  | HOSTS\n  | LOGS\n  | PRIVILEGES\n  | OPTIMIZER_COSTS\n  | RELAY LOGS [FOR CHANNEL channel]\n  | SLOW LOGS\n  | STATUS\n  | USER_RESOURCES\n}\n\ntables_option: {\n    TABLES\n  | TABLES tbl_name [, tbl_name] ...\n  | TABLES WITH READ LOCK\n  | TABLES tbl_name [, tbl_name] ... WITH READ LOCK\n  | TABLES tbl_name [, tbl_name] ... FOR EXPORT\n}\n\nThe FLUSH statement has several variant forms that clear or reload\nvarious internal caches, flush tables, or acquire locks. To execute\nFLUSH, you must have the RELOAD privilege. Specific flush options might\nrequire additional privileges, as described later.\n\n*Note*:\n\nIt is not possible to issue FLUSH statements within stored functions or\ntriggers. However, you may use FLUSH in stored procedures, so long as\nthese are not called from stored functions or triggers. See\nhttp://dev.mysql.com/doc/refman/8.0/en/stored-program-restrictions.html\n.\n\nBy default, the server writes FLUSH statements to the binary log so\nthat they replicate to replication slaves. To suppress logging, specify\nthe optional NO_WRITE_TO_BINLOG keyword or its alias LOCAL.\n\n*Note*:\n\nFLUSH LOGS, FLUSH BINARY LOGS, FLUSH TABLES WITH READ LOCK (with or\nwithout a table list), and FLUSH TABLES tbl_name ... FOR EXPORT are not\nwritten to the binary log in any case because they would cause problems\nif replicated to a slave.\n\nThe FLUSH statement causes an implicit commit. See\nhttp://dev.mysql.com/doc/refman/8.0/en/implicit-commit.html.\n\nThe mysqladmin utility provides a command-line interface to some flush\noperations, using commands such as flush-hosts, flush-logs,\nflush-privileges, flush-status, and flush-tables. See\nhttp://dev.mysql.com/doc/refman/8.0/en/mysqladmin.html.\n\nSending a SIGHUP signal to the server causes several flush operations\nto occur that are similar to various forms of the FLUSH statement. See\nhttp://dev.mysql.com/doc/refman/8.0/en/server-signal-response.html.\n\nThe RESET statement is similar to FLUSH. See [HELP RESET], for\ninformation about using the RESET statement with replication.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/flush.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/flush.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (201,35,'FORMAT','Syntax:\nFORMAT(X,D[,locale])\n\nFormats the number X to a format like \'#,###,###.##\', rounded to D\ndecimal places, and returns the result as a string. If D is 0, the\nresult has no decimal point or fractional part.\n\nThe optional third parameter enables a locale to be specified to be\nused for the result number\'s decimal point, thousands separator, and\ngrouping between separators. Permissible locale values are the same as\nthe legal values for the lc_time_names system variable (see\nhttp://dev.mysql.com/doc/refman/8.0/en/locale-support.html). If no\nlocale is specified, the default is \'en_US\'.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT FORMAT(12332.123456, 4);\n        -> \'12,332.1235\'\nmysql> SELECT FORMAT(12332.1,4);\n        -> \'12,332.1000\'\nmysql> SELECT FORMAT(12332.2,0);\n        -> \'12,332\'\nmysql> SELECT FORMAT(12332.2,2,\'de_DE\');\n        -> \'12.332,20\'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (202,23,'FOUND_ROWS','Syntax:\nFOUND_ROWS()\n\nA SELECT statement may include a LIMIT clause to restrict the number of\nrows the server returns to the client. In some cases, it is desirable\nto know how many rows the statement would have returned without the\nLIMIT, but without running the statement again. To obtain this row\ncount, include an SQL_CALC_FOUND_ROWS option in the SELECT statement,\nand then invoke FOUND_ROWS() afterward:\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/information-functions.html\n\n','mysql> SELECT SQL_CALC_FOUND_ROWS * FROM tbl_name\n    -> WHERE id > 100 LIMIT 10;\nmysql> SELECT FOUND_ROWS();\n','http://dev.mysql.com/doc/refman/8.0/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (203,35,'FROM_BASE64','Syntax:\nFROM_BASE64(str)\n\nTakes a string encoded with the base-64 encoded rules used by\nTO_BASE64() and returns the decoded result as a binary string. The\nresult is NULL if the argument is NULL or not a valid base-64 string.\nSee the description of TO_BASE64() for details about the encoding and\ndecoding rules.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT TO_BASE64(\'abc\'), FROM_BASE64(TO_BASE64(\'abc\'));\n        -> \'JWJj\', \'abc\'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (204,12,'FROM_DAYS','Syntax:\nFROM_DAYS(N)\n\nGiven a day number N, returns a DATE value.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT FROM_DAYS(730669);\n        -> \'2000-07-03\'\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (205,12,'FROM_UNIXTIME','Syntax:\nFROM_UNIXTIME(unix_timestamp), FROM_UNIXTIME(unix_timestamp,format)\n\nReturns a representation of the unix_timestamp argument as a value in\n\'YYYY-MM-DD HH:MM:SS\' or YYYYMMDDHHMMSS format, depending on whether\nthe function is used in a string or numeric context. The value is\nexpressed in the current time zone. unix_timestamp is an internal\ntimestamp value such as is produced by the UNIX_TIMESTAMP() function.\n\nIf format is given, the result is formatted according to the format\nstring, which is used the same way as listed in the entry for the\nDATE_FORMAT() function.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT FROM_UNIXTIME(1447430881);\n        -> \'2015-11-13 10:08:01\'\nmysql> SELECT FROM_UNIXTIME(1447430881) + 0;\n        -> 20151113100801\nmysql> SELECT FROM_UNIXTIME(UNIX_TIMESTAMP(),\n    ->                      \'%Y %D %M %h:%i:%s %x\');\n        -> \'2015 13th November 10:08:01 2015\'\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (206,18,'GEOMCOLLECTION','GeomCollection(g [, g] ...)\n\nConstructs a GeomCollection value from the geometry arguments.\n\nGeomCollection() returns all the proper geometries contained in the\narguments even if a nonsupported geometry is present.\n\nGeomCollection() with no arguments is permitted as a way to create an\nempty geometry. Also, functions such as ST_GeomFromText() that accept\nWKT geometry collection arguments understand both OpenGIS\n\'GEOMETRYCOLLECTION EMPTY\' standard syntax and MySQL\n\'GEOMETRYCOLLECTION()\' nonstandard syntax.\n\nGeomCollection() and GeometryCollection() are synonymous, with\nGeomCollection() the preferred function.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-mysql-specific-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-mysql-specific-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (207,17,'GEOMETRY','MySQL provides a standard way of creating spatial columns for geometry\ntypes, for example, with CREATE TABLE or ALTER TABLE. Spatial columns\nare supported for MyISAM, InnoDB, NDB, and ARCHIVE tables. See also the\nnotes about spatial indexes under [HELP SPATIAL].\n\nColumns with a spatial data type can have an SRID attribute, to\nexplicitly indicate the spatial reference system (SRS) for values\nstored in the column. For implications of an SRID-restricted column,\nsee http://dev.mysql.com/doc/refman/8.0/en/spatial-type-overview.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/creating-spatial-columns.html\n\n','CREATE TABLE geom (g GEOMETRY);\n','http://dev.mysql.com/doc/refman/8.0/en/creating-spatial-columns.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (208,17,'GEOMETRY HIERARCHY','Geometry is the base class. It is an abstract class. The instantiable\nsubclasses of Geometry are restricted to zero-, one-, and\ntwo-dimensional geometric objects that exist in two-dimensional\ncoordinate space. All instantiable geometry classes are defined so that\nvalid instances of a geometry class are topologically closed (that is,\nall defined geometries include their boundary).\n\nThe base Geometry class has subclasses for Point, Curve, Surface, and\nGeometryCollection:\n\no Point represents zero-dimensional objects.\n\no Curve represents one-dimensional objects, and has subclass\n  LineString, with sub-subclasses Line and LinearRing.\n\no Surface is designed for two-dimensional objects and has subclass\n  Polygon.\n\no GeometryCollection has specialized zero-, one-, and two-dimensional\n  collection classes named MultiPoint, MultiLineString, and\n  MultiPolygon for modeling geometries corresponding to collections of\n  Points, LineStrings, and Polygons, respectively. MultiCurve and\n  MultiSurface are introduced as abstract superclasses that generalize\n  the collection interfaces to handle Curves and Surfaces.\n\nGeometry, Curve, Surface, MultiCurve, and MultiSurface are defined as\nnoninstantiable classes. They define a common set of methods for their\nsubclasses and are included for extensibility.\n\nPoint, LineString, Polygon, GeometryCollection, MultiPoint,\nMultiLineString, and MultiPolygon are instantiable classes.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-geometry-class-hierarchy.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-geometry-class-hierarchy.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (209,18,'GEOMETRYCOLLECTION','GeometryCollection(g [, g] ...)\n\nConstructs a GeomCollection value from the geometry arguments.\n\nGeometryCollection() returns all the proper geometries contained in the\narguments even if a nonsupported geometry is present.\n\nGeometryCollection() with no arguments is permitted as a way to create\nan empty geometry. Also, functions such as ST_GeomFromText() that\naccept WKT geometry collection arguments understand both OpenGIS\n\'GEOMETRYCOLLECTION EMPTY\' standard syntax and MySQL\n\'GEOMETRYCOLLECTION()\' nonstandard syntax.\n\nGeomCollection() and GeometryCollection() are synonymous, with\nGeomCollection() the preferred function.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-mysql-specific-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-mysql-specific-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (210,6,'GET DIAGNOSTICS','Syntax:\nGET [CURRENT | STACKED] DIAGNOSTICS\n{\n    statement_information_item\n    [, statement_information_item] ...\n  | CONDITION condition_number\n    condition_information_item\n    [, condition_information_item] ...\n}\n\nstatement_information_item:\n    target = statement_information_item_name\n\ncondition_information_item:\n    target = condition_information_item_name\n\nstatement_information_item_name:\n    NUMBER\n  | ROW_COUNT\n\ncondition_information_item_name: {\n    CLASS_ORIGIN\n  | SUBCLASS_ORIGIN\n  | RETURNED_SQLSTATE\n  | MESSAGE_TEXT\n  | MYSQL_ERRNO\n  | CONSTRAINT_CATALOG\n  | CONSTRAINT_SCHEMA\n  | CONSTRAINT_NAME\n  | CATALOG_NAME\n  | SCHEMA_NAME\n  | TABLE_NAME\n  | COLUMN_NAME\n  | CURSOR_NAME\n}\n\ncondition_number, target:\n    (see following discussion)\n\nSQL statements produce diagnostic information that populates the\ndiagnostics area. The GET DIAGNOSTICS statement enables applications to\ninspect this information. (You can also use SHOW WARNINGS or SHOW\nERRORS to see conditions or errors.)\n\nNo special privileges are required to execute GET DIAGNOSTICS.\n\nThe keyword CURRENT means to retrieve information from the current\ndiagnostics area. The keyword STACKED means to retrieve information\nfrom the second diagnostics area, which is available only if the\ncurrent context is a condition handler. If neither keyword is given,\nthe default is to use the current diagnostics area.\n\nThe GET DIAGNOSTICS statement is typically used in a handler within a\nstored program. It is a MySQL extension that GET [CURRENT] DIAGNOSTICS\nis permitted outside handler context to check the execution of any SQL\nstatement. For example, if you invoke the mysql client program, you can\nenter these statements at the prompt:\n\nmysql> DROP TABLE test.no_such_table;\nERROR 1051 (42S02): Unknown table \'test.no_such_table\'\nmysql> GET DIAGNOSTICS CONDITION 1\n         @p1 = RETURNED_SQLSTATE, @p2 = MESSAGE_TEXT;\nmysql> SELECT @p1, @p2;\n+-------+------------------------------------+\n| @p1   | @p2                                |\n+-------+------------------------------------+\n| 42S02 | Unknown table \'test.no_such_table\' |\n+-------+------------------------------------+\n\nThis extension applies only to the current diagnostics area. It does\nnot apply to the second diagnostics area because GET STACKED\nDIAGNOSTICS is permitted only if the current context is a condition\nhandler. If that is not the case, a GET STACKED DIAGNOSTICS when\nhandler not active error occurs.\n\nFor a description of the diagnostics area, see\nhttp://dev.mysql.com/doc/refman/8.0/en/diagnostics-area.html. Briefly,\nit contains two kinds of information:\n\no Statement information, such as the number of conditions that occurred\n  or the affected-rows count.\n\no Condition information, such as the error code and message. If a\n  statement raises multiple conditions, this part of the diagnostics\n  area has a condition area for each one. If a statement raises no\n  conditions, this part of the diagnostics area is empty.\n\nFor a statement that produces three conditions, the diagnostics area\ncontains statement and condition information like this:\n\nStatement information:\n  row count\n  ... other statement information items ...\nCondition area list:\n  Condition area 1:\n    error code for condition 1\n    error message for condition 1\n    ... other condition information items ...\n  Condition area 2:\n    error code for condition 2:\n    error message for condition 2\n    ... other condition information items ...\n  Condition area 3:\n    error code for condition 3\n    error message for condition 3\n    ... other condition information items ...\n\nGET DIAGNOSTICS can obtain either statement or condition information,\nbut not both in the same statement:\n\no To obtain statement information, retrieve the desired statement items\n  into target variables. This instance of GET DIAGNOSTICS assigns the\n  number of available conditions and the rows-affected count to the\n  user variables @p1 and @p2:\n\nGET DIAGNOSTICS @p1 = NUMBER, @p2 = ROW_COUNT;\n\no To obtain condition information, specify the condition number and\n  retrieve the desired condition items into target variables. This\n  instance of GET DIAGNOSTICS assigns the SQLSTATE value and error\n  message to the user variables @p3 and @p4:\n\nGET DIAGNOSTICS CONDITION 1\n  @p3 = RETURNED_SQLSTATE, @p4 = MESSAGE_TEXT;\n\nThe retrieval list specifies one or more target = item_name\nassignments, separated by commas. Each assignment names a target\nvariable and either a statement_information_item_name or\ncondition_information_item_name designator, depending on whether the\nstatement retrieves statement or condition information.\n\nValid target designators for storing item information can be stored\nprocedure or function parameters, stored program local variables\ndeclared with DECLARE, or user-defined variables.\n\nValid condition_number designators can be stored procedure or function\nparameters, stored program local variables declared with DECLARE,\nuser-defined variables, system variables, or literals. A character\nliteral may include a _charset introducer. A warning occurs if the\ncondition number is not in the range from 1 to the number of condition\nareas that have information. In this case, the warning is added to the\ndiagnostics area without clearing it.\n\nWhen a condition occurs, MySQL does not populate all condition items\nrecognized by GET DIAGNOSTICS. For example:\n\nmysql> GET DIAGNOSTICS CONDITION 1\n         @p5 = SCHEMA_NAME, @p6 = TABLE_NAME;\nmysql> SELECT @p5, @p6;\n+------+------+\n| @p5  | @p6  |\n+------+------+\n|      |      |\n+------+------+\n\nIn standard SQL, if there are multiple conditions, the first condition\nrelates to the SQLSTATE value returned for the previous SQL statement.\nIn MySQL, this is not guaranteed. To get the main error, you cannot do\nthis:\n\nGET DIAGNOSTICS CONDITION 1 @errno = MYSQL_ERRNO;\n\nInstead, retrieve the condition count first, then use it to specify\nwhich condition number to inspect:\n\nGET DIAGNOSTICS @cno = NUMBER;\nGET DIAGNOSTICS CONDITION @cno @errno = MYSQL_ERRNO;\n\nFor information about permissible statement and condition information\nitems, and which ones are populated when a condition occurs, see\nhttp://dev.mysql.com/doc/refman/8.0/en/diagnostics-area.html#diagnostic\ns-area-information-items.\n\nHere is an example that uses GET DIAGNOSTICS and an exception handler\nin stored procedure context to assess the outcome of an insert\noperation. If the insert was successful, the procedure uses GET\nDIAGNOSTICS to get the rows-affected count. This shows that you can use\nGET DIAGNOSTICS multiple times to retrieve information about a\nstatement as long as the current diagnostics area has not been cleared.\n\nCREATE PROCEDURE do_insert(value INT)\nBEGIN\n  -- Declare variables to hold diagnostics area information\n  DECLARE code CHAR(5) DEFAULT \'00000\';\n  DECLARE msg TEXT;\n  DECLARE rows INT;\n  DECLARE result TEXT;\n  -- Declare exception handler for failed insert\n  DECLARE CONTINUE HANDLER FOR SQLEXCEPTION\n    BEGIN\n      GET DIAGNOSTICS CONDITION 1\n        code = RETURNED_SQLSTATE, msg = MESSAGE_TEXT;\n    END;\n\n  -- Perform the insert\n  INSERT INTO t1 (int_col) VALUES(value);\n  -- Check whether the insert was successful\n  IF code = \'00000\' THEN\n    GET DIAGNOSTICS rows = ROW_COUNT;\n    SET result = CONCAT(\'insert succeeded, row count = \',rows);\n  ELSE\n    SET result = CONCAT(\'insert failed, error = \',code,\', message = \',msg);\n  END IF;\n  -- Say what happened\n  SELECT result;\nEND;\n\nSuppose that t1.int_col is an integer column that is declared as NOT\nNULL. The procedure produces these results when invoked to insert\nnon-NULL and NULL values, respectively:\n\nmysql> CALL do_insert(1);\n+---------------------------------+\n| result                          |\n+---------------------------------+\n| insert succeeded, row count = 1 |\n+---------------------------------+\n\nmysql> CALL do_insert(NULL);\n+-------------------------------------------------------------------------+\n| result                                                                  |\n+-------------------------------------------------------------------------+\n| insert failed, error = 23000, message = Column \'int_col\' cannot be null |\n+-------------------------------------------------------------------------+\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/get-diagnostics.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/get-diagnostics.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (211,29,'GET_DD_COLUMN_PRIVILEGES','GET_DD_COLUMN_PRIVILEGES(ARGS)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (212,29,'GET_DD_CREATE_OPTIONS','GET_DD_CREATE_OPTIONS(ARGS)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (213,29,'GET_DD_INDEX_SUB_PART_LENGTH','GET_DD_INDEX_SUB_PART_LENGTH(ARGS)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (214,12,'GET_FORMAT','Syntax:\nGET_FORMAT({DATE|TIME|DATETIME}, {\'EUR\'|\'USA\'|\'JIS\'|\'ISO\'|\'INTERNAL\'})\n\nReturns a format string. This function is useful in combination with\nthe DATE_FORMAT() and the STR_TO_DATE() functions.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT DATE_FORMAT(\'2003-10-03\',GET_FORMAT(DATE,\'EUR\'));\n        -> \'03.10.2003\'\nmysql> SELECT STR_TO_DATE(\'10.31.2003\',GET_FORMAT(DATE,\'USA\'));\n        -> \'2003-10-31\'\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (215,26,'GET_LOCK','Syntax:\nGET_LOCK(str,timeout)\n\nTries to obtain a lock with a name given by the string str, using a\ntimeout of timeout seconds. A negative timeout value means infinite\ntimeout. The lock is exclusive. While held by one session, other\nsessions cannot obtain a lock of the same name.\n\nReturns 1 if the lock was obtained successfully, 0 if the attempt timed\nout (for example, because another client has previously locked the\nname), or NULL if an error occurred (such as running out of memory or\nthe thread was killed with mysqladmin kill).\n\nA lock obtained with GET_LOCK() is released explicitly by executing\nRELEASE_LOCK() or implicitly when your session terminates (either\nnormally or abnormally). Locks obtained with GET_LOCK() are not\nreleased when transactions commit or roll back.\n\nGET_LOCK() is implemented using the metadata locking (MDL) subsystem.\nMultiple simultaneous locks can be acquired and GET_LOCK() does not\nrelease any existing locks. For example, suppose that you execute these\nstatements:\n\nSELECT GET_LOCK(\'lock1\',10);\nSELECT GET_LOCK(\'lock2\',10);\nSELECT RELEASE_LOCK(\'lock2\');\nSELECT RELEASE_LOCK(\'lock1\');\n\nThe second GET_LOCK() acquires a second lock and both RELEASE_LOCK()\ncalls return 1 (success).\n\nIt is even possible for a given session to acquire multiple locks for\nthe same name. Other sessions cannot acquire a lock with that name\nuntil the acquiring session releases all its locks for the name.\n\nUniquely named locks acquired with GET_LOCK() appear in the Performance\nSchema metadata_locks table. The OBJECT_TYPE column says USER LEVEL\nLOCK and the OBJECT_NAME column indicates the lock name. In the case\nthat multiple locks are acquired for the same name, only the first lock\nfor the name registers a row in the metadata_locks table. Subsequent\nlocks for the name increment a counter in the lock but do not acquire\nadditional metadata locks. The metadata_locks row for the lock is\ndeleted when the last lock instance on the name is released.\n\nThe capability of acquiring multiple locks means there is the\npossibility of deadlock among clients. When this happens, the server\nchooses a caller and terminates its lock-acquisition request with an\nER_USER_LOCK_DEADLOCK error. This error does not cause transactions to\nroll back.\n\nMySQL enforces a maximum length on lock names of 64 characters.\n\nGET_LOCK() can be used to implement application locks or to simulate\nrecord locks. Names are locked on a server-wide basis. If a name has\nbeen locked within one session, GET_LOCK() blocks any request by\nanother session for a lock with the same name. This enables clients\nthat agree on a given lock name to use the name to perform cooperative\nadvisory locking. But be aware that it also enables a client that is\nnot among the set of cooperating clients to lock a name, either\ninadvertently or deliberately, and thus prevent any of the cooperating\nclients from locking that name. One way to reduce the likelihood of\nthis is to use lock names that are database-specific or\napplication-specific. For example, use lock names of the form\ndb_name.str or app_name.str.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/locking-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/locking-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (216,1,'GRANT','Syntax:\nGRANT\n    priv_type [(column_list)]\n      [, priv_type [(column_list)]] ...\n    ON [object_type] priv_level\n    TO user_or_role [, user_or_role] ...\n    [WITH GRANT OPTION]\n\nGRANT PROXY ON user_or_role\n    TO user_or_role [, user_or_role] ...\n    [WITH GRANT OPTION]\n\nGRANT role [, role] ...\n    TO user_or_role [, user_or_role] ...\n    [WITH ADMIN OPTION]\n\nobject_type: {\n    TABLE\n  | FUNCTION\n  | PROCEDURE\n}\n\npriv_level: {\n    *\n  | *.*\n  | db_name.*\n  | db_name.tbl_name\n  | tbl_name\n  | db_name.routine_name\n}\n\nuser_or_role: {\n    user\n  | role\n}\n\nuser:\n    (see http://dev.mysql.com/doc/refman/8.0/en/account-names.html)\n\nrole:\n    (see http://dev.mysql.com/doc/refman/8.0/en/role-names.html)\n\nThe GRANT statement enables system administrators to grant privileges\nand roles, which can be granted to user accounts and roles. These\nsyntax restrictions apply:\n\no GRANT cannot mix granting both privileges and roles in the same\n  statement. A given GRANT statement must grant either privileges or\n  roles.\n\no The ON clause distinguishes whether the statement grants privileges\n  or roles:\n\n  o With ON, the statement grants privileges.\n\n  o Without ON, the statement grants roles.\n\n  o It is permitted to assign both privileges and roles to an account,\n    but you must use separate GRANT statements, each with syntax\n    appropriate to what is to be granted.\n\nFor more information about roles, see\nhttp://dev.mysql.com/doc/refman/8.0/en/roles.html.\n\nTo use GRANT, you must have the GRANT OPTION privilege, and you must\nhave the privileges that you are granting. When the read_only system\nvariable is enabled, GRANT additionally requires the CONNECTION_ADMIN\nor SUPER privilege.\n\nGRANT either succeeds for all named users and roles or rolls back and\nhas no effect if any error occurs. The statement is written to the\nbinary log only if it succeeds for all named users and roles.\n\nThe REVOKE statement is related to GRANT and enables administrators to\nremove account privileges. See [HELP REVOKE].\n\nEach account name uses the format described in\nhttp://dev.mysql.com/doc/refman/8.0/en/account-names.html. Each role\nname uses the format described in\nhttp://dev.mysql.com/doc/refman/8.0/en/role-names.html. For example:\n\nGRANT ALL ON db1.* TO \'jeffrey\'@\'localhost\';\nGRANT \'role1\', \'role2\' TO \'user1\'@\'localhost\', \'user2\'@\'localhost\';\nGRANT SELECT ON world.* TO \'role3\';\n\nThe host name part of the account or role name, if omitted, defaults to\n\'%\'.\n\nNormally, a database administrator first uses CREATE USER to create an\naccount and define its nonprivilege characteristics such as its\npassword, whether it uses secure connections, and limits on access to\nserver resources, then uses GRANT to define its privileges. ALTER USER\nmay be used to change the nonprivilege characteristics of existing\naccounts. For example:\n\nCREATE USER \'jeffrey\'@\'localhost\' IDENTIFIED BY \'password\';\nGRANT ALL ON db1.* TO \'jeffrey\'@\'localhost\';\nGRANT SELECT ON db2.invoice TO \'jeffrey\'@\'localhost\';\nALTER USER \'jeffrey\'@\'localhost\' WITH MAX_QUERIES_PER_HOUR 90;\n\nFrom the mysql program, GRANT responds with Query OK, 0 rows affected\nwhen executed successfully. To determine what privileges result from\nthe operation, use SHOW GRANTS. See [HELP SHOW GRANTS].\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/grant.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/grant.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (217,4,'GREATEST','Syntax:\nGREATEST(value1,value2,...)\n\nWith two or more arguments, returns the largest (maximum-valued)\nargument. The arguments are compared using the same rules as for\nLEAST().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html\n\n','mysql> SELECT GREATEST(2,0);\n        -> 2\nmysql> SELECT GREATEST(34.0,3.0,5.0,767.0);\n        -> 767.0\nmysql> SELECT GREATEST(\'B\',\'A\',\'C\');\n        -> \'C\'\n','http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (218,29,'GROUPING','GROUPING(expr [, expr] ...)\n\nFor GROUP BY queries that include a WITH ROLLUP modifier, the ROLLUP\noperation produces super-aggregate output rows where NULL represents\nthe set of all values. The GROUPING() function enables you to\ndistinguish NULL values for super-aggregate rows from NULL values in\nregular grouped rows.\n\nGROUPING() is permitted only in the select list or HAVING clause.\n\nEach argument to GROUPING() must be an expression that exactly matches\nan expression in the GROUP BY clause. The expression cannot be a\npositional specifier. For each expression, GROUPING() produces 1 if the\nexpression value in the current row is a NULL representing a\nsuper-aggregate value. Otherwise, GROUPING() produces 0, indicating\nthat the expression value is a NULL for a regular result row or is not\nNULL.\n\nSuppose that table t1 contains these rows, where NULL indicates\nsomething like "other" or "unknown":\n\nmysql> SELECT * FROM t1;\n+------+-------+----------+\n| name | size  | quantity |\n+------+-------+----------+\n| ball | small |       10 |\n| ball | large |       20 |\n| ball | NULL  |        5 |\n| hoop | small |       15 |\n| hoop | large |        5 |\n| hoop | NULL  |        3 |\n+------+-------+----------+\n\nA summary of the table without WITH ROLLUP looks like this:\n\nmysql> SELECT name, size, SUM(quantity) AS quantity\n       FROM t1\n       GROUP BY name, size;\n+------+-------+----------+\n| name | size  | quantity |\n+------+-------+----------+\n| ball | small |       10 |\n| ball | large |       20 |\n| ball | NULL  |        5 |\n| hoop | small |       15 |\n| hoop | large |        5 |\n| hoop | NULL  |        3 |\n+------+-------+----------+\n\nThe result contains NULL values, but those do not represent\nsuper-aggregate rows because the query does not include WITH ROLLUP.\n\nAdding WITH ROLLUP produces super-aggregate summary rows containing\nadditional NULL values. However, without comparing this result to the\nprevious one, it is not easy to see which NULL values occur in\nsuper-aggregate rows and which occur in regular grouped rows:\n\nmysql> SELECT name, size, SUM(quantity) AS quantity\n       FROM t1\n       GROUP BY name, size WITH ROLLUP;\n+------+-------+----------+\n| name | size  | quantity |\n+------+-------+----------+\n| ball | NULL  |        5 |\n| ball | large |       20 |\n| ball | small |       10 |\n| ball | NULL  |       35 |\n| hoop | NULL  |        3 |\n| hoop | large |        5 |\n| hoop | small |       15 |\n| hoop | NULL  |       23 |\n| NULL | NULL  |       58 |\n+------+-------+----------+\n\nTo distinguish NULL values in in super-aggregate rows from those in\nregular grouped rows, use GROUPING(), which returns 1 only for\nsuper-aggregate NULL values:\n\nmysql> SELECT\n         name, size, SUM(quantity) AS quantity,\n         GROUPING(name) AS grp_name,\n         GROUPING(size) AS grp_size\n       FROM t1\n       GROUP BY name, size WITH ROLLUP;\n+------+-------+----------+----------+----------+\n| name | size  | quantity | grp_name | grp_size |\n+------+-------+----------+----------+----------+\n| ball | NULL  |        5 |        0 |        0 |\n| ball | large |       20 |        0 |        0 |\n| ball | small |       10 |        0 |        0 |\n| ball | NULL  |       35 |        0 |        1 |\n| hoop | NULL  |        3 |        0 |        0 |\n| hoop | large |        5 |        0 |        0 |\n| hoop | small |       15 |        0 |        0 |\n| hoop | NULL  |       23 |        0 |        1 |\n| NULL | NULL  |       58 |        1 |        1 |\n+------+-------+----------+----------+----------+\n\nCommon uses for GROUPING():\n\no Substitute a label for super-aggregate NULL values:\n\nmysql> SELECT\n         IF(GROUPING(name) = 1, \'All items\', name) AS name,\n         IF(GROUPING(size) = 1, \'All sizes\', size) AS size,\n         SUM(quantity) AS quantity\n       FROM t1\n       GROUP BY name, size WITH ROLLUP;\n+-----------+-----------+----------+\n| name      | size      | quantity |\n+-----------+-----------+----------+\n| ball      | NULL      |        5 |\n| ball      | large     |       20 |\n| ball      | small     |       10 |\n| ball      | All sizes |       35 |\n| hoop      | NULL      |        3 |\n| hoop      | large     |        5 |\n| hoop      | small     |       15 |\n| hoop      | All sizes |       23 |\n| All items | All sizes |       58 |\n+-----------+-----------+----------+\n\no Return only super-aggregate lines by filtering out the regular\n  grouped lines:\n\nmysql> SELECT name, size, SUM(quantity) AS quantity\n       FROM t1\n       GROUP BY name, size WITH ROLLUP\n       HAVING GROUPING(name) = 1 OR GROUPING(size) = 1;\n+------+------+----------+\n| name | size | quantity |\n+------+------+----------+\n| ball | NULL |       35 |\n| hoop | NULL |       23 |\n| NULL | NULL |       58 |\n+------+------+----------+\n\nGROUPING() permits multiple expression arguments. In this case, the\nGROUPING() return value represents a bitmask combined from the results\nfor each expression, where the lowest-order bit corresponds to the\nresult for the rightmost expression. For example, with three expression\narguments, GROUPING(expr1, expr2, expr3) is evaluated like this:\n\n  result for GROUPING(expr3)\n+ result for GROUPING(expr2) << 1\n+ result for GROUPING(expr1) << 2\n\nThe following query shows how GROUPING() results for single arguments\ncombine for a multiple-argument call to produce a bitmask value:\n\nmysql> SELECT\n         name, size, SUM(quantity) AS quantity,\n         GROUPING(name) AS grp_name,\n         GROUPING(size) AS grp_size,\n       GROUPING(name, size) AS grp_all\n       FROM t1\n       GROUP BY name, size WITH ROLLUP;\n+------+-------+----------+----------+----------+---------+\n| name | size  | quantity | grp_name | grp_size | grp_all |\n+------+-------+----------+----------+----------+---------+\n| ball | NULL  |        5 |        0 |        0 |       0 |\n| ball | large |       20 |        0 |        0 |       0 |\n| ball | small |       10 |        0 |        0 |       0 |\n| ball | NULL  |       35 |        0 |        1 |       1 |\n| hoop | NULL  |        3 |        0 |        0 |       0 |\n| hoop | large |        5 |        0 |        0 |       0 |\n| hoop | small |       15 |        0 |        0 |       0 |\n| hoop | NULL  |       23 |        0 |        1 |       1 |\n| NULL | NULL  |       58 |        1 |        1 |       3 |\n+------+-------+----------+----------+----------+---------+\n\nWith multiple expression arguments, the GROUPING() return value is\nnonzero if any expression represents a super-aggregate value.\nMultiple-argument GROUPING() syntax thus provides a simpler way to\nwrite the earlier query that returned only super-aggregate rows, by\nusing a single multiple-argument GROUPING() call rather than multiple\nsingle-argument calls:\n\nmysql> SELECT name, size, SUM(quantity) AS quantity\n       FROM t1\n       GROUP BY name, size WITH ROLLUP\n       HAVING GROUPING(name, size) <> 0;\n+------+------+----------+\n| name | size | quantity |\n+------+------+----------+\n| ball | NULL |       35 |\n| hoop | NULL |       23 |\n| NULL | NULL |       58 |\n+------+------+----------+\n\nUse of GROUPING() is subject to these limitations:\n\no Do not use subquery GROUP BY expressions as GROUPING() arguments\n  because matching might fail. For example, matching fails for this\n  query:\n\nmysql> SELECT GROUPING((SELECT MAX(name) FROM t1))\n       FROM t1\n       GROUP BY (SELECT MAX(name) FROM t1) WITH ROLLUP;\nERROR 3580 (HY000): Argument #1 of GROUPING function is not in GROUP BY\n\no GROUP BY literal expressions should not be used within a HAVING\n  clause as GROUPING() arguments. Due to differences between when the\n  optimizer evaluates GROUP BY and HAVING, matching may succeed but\n  GROUPING() evaluation does not produce the expected result. Consider\n  this query:\n\nSELECT a AS f1, \'w\' AS f2\nFROM t\nGROUP BY f1, f2 WITH ROLLUP\nHAVING GROUPING(f2) = 1;\n\n  GROUPING() is evaluated earlier for the literal constant expression\n  than for the HAVING clause as a whole and returns 0. To check whether\n  a query such as this is affected, use EXPLAIN and look for Impossible\n  having in the Extra column.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (219,15,'GROUP_CONCAT','Syntax:\nGROUP_CONCAT(expr)\n\nThis function returns a string result with the concatenated non-NULL\nvalues from a group. It returns NULL if there are no non-NULL values.\nThe full syntax is as follows:\n\nGROUP_CONCAT([DISTINCT] expr [,expr ...]\n             [ORDER BY {unsigned_integer | col_name | expr}\n                 [ASC | DESC] [,col_name ...]]\n             [SEPARATOR str_val])\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html\n\n','mysql> SELECT student_name,\n         GROUP_CONCAT(test_score)\n       FROM student\n       GROUP BY student_name;\n','http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (220,28,'GTID_SUBSET','Syntax:\nGTID_SUBSET(set1,set2)\n\nGiven two sets of global transaction identifiers set1 and set2, returns\ntrue if all GTIDs in set1 are also in set2. Returns false otherwise.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gtid-functions.html\n\n','mysql> SELECT GTID_SUBSET(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:23\',\n    ->     \'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\')\\G\n*************************** 1. row ***************************\nGTID_SUBSET(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:23\',\n    \'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\'): 1\n1 row in set (0.00 sec)\n\nmysql> SELECT GTID_SUBSET(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:23-25\',\n    ->     \'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\')\\G\n*************************** 1. row ***************************\nGTID_SUBSET(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:23-25\',\n    \'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\'): 1\n1 row in set (0.00 sec)\n\nmysql> SELECT GTID_SUBSET(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:20-25\',\n    ->     \'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\')\\G\n*************************** 1. row ***************************\nGTID_SUBSET(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:20-25\',\n    \'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\'): 0\n1 row in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/8.0/en/gtid-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (221,28,'GTID_SUBTRACT','Syntax:\nGTID_SUBTRACT(set1,set2)\n\nGiven two sets of global transaction identifiers set1 and set2, returns\nonly those GTIDs from set1 that are not in set2.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gtid-functions.html\n\n','mysql> SELECT GTID_SUBTRACT(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\',\n    ->     \'3E11FA47-71CA-11E1-9E33-C80AA9429562:21\')\\G\n*************************** 1. row ***************************\nGTID_SUBTRACT(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\',\n    \'3E11FA47-71CA-11E1-9E33-C80AA9429562:21\'): 3e11fa47-71ca-11e1-9e33-c80aa9429562:22-57\n1 row in set (0.00 sec)\n\nmysql> SELECT GTID_SUBTRACT(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\',\n    ->     \'3E11FA47-71CA-11E1-9E33-C80AA9429562:20-25\')\\G\n*************************** 1. row ***************************\nGTID_SUBTRACT(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\',\n    \'3E11FA47-71CA-11E1-9E33-C80AA9429562:20-25\'): 3e11fa47-71ca-11e1-9e33-c80aa9429562:26-57\n1 row in set (0.00 sec)\n\nmysql> SELECT GTID_SUBTRACT(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\',\n    ->     \'3E11FA47-71CA-11E1-9E33-C80AA9429562:23-24\')\\G\n*************************** 1. row ***************************\nGTID_SUBTRACT(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:21-57\',\n    \'3E11FA47-71CA-11E1-9E33-C80AA9429562:23-24\'): 3e11fa47-71ca-11e1-9e33-c80aa9429562:21-22:25-57\n1 row in set (0.01 sec)\n','http://dev.mysql.com/doc/refman/8.0/en/gtid-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (222,10,'HANDLER','Syntax:\nHANDLER tbl_name OPEN [ [AS] alias]\n\nHANDLER tbl_name READ index_name { = | <= | >= | < | > } (value1,value2,...)\n    [ WHERE where_condition ] [LIMIT ... ]\nHANDLER tbl_name READ index_name { FIRST | NEXT | PREV | LAST }\n    [ WHERE where_condition ] [LIMIT ... ]\nHANDLER tbl_name READ { FIRST | NEXT }\n    [ WHERE where_condition ] [LIMIT ... ]\n\nHANDLER tbl_name CLOSE\n\nThe HANDLER statement provides direct access to table storage engine\ninterfaces. It is available for InnoDB and MyISAM tables.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/handler.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/handler.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (223,2,'HELP COMMAND','Syntax:\nmysql> help search_string\n\nIf you provide an argument to the help command, mysql uses it as a\nsearch string to access server-side help from the contents of the MySQL\nReference Manual. The proper operation of this command requires that\nthe help tables in the mysql database be initialized with help topic\ninformation (see\nhttp://dev.mysql.com/doc/refman/8.0/en/server-side-help-support.html).\n\nIf there is no match for the search string, the search fails:\n\nmysql> help me\n\nNothing found\nPlease try to run \'help contents\' for a list of all accessible topics\n\nUse help contents to see a list of the help categories:\n\nmysql> help contents\nYou asked for help about help category: "Contents"\nFor more information, type \'help <item>\', where <item> is one of the\nfollowing categories:\n   Account Management\n   Administration\n   Data Definition\n   Data Manipulation\n   Data Types\n   Functions\n   Functions and Modifiers for Use with GROUP BY\n   Geographic Features\n   Language Structure\n   Plugins\n   Storage Engines\n   Stored Routines\n   Table Maintenance\n   Transactions\n   Triggers\n\nIf the search string matches multiple items, mysql shows a list of\nmatching topics:\n\nmysql> help logs\nMany help items for your request exist.\nTo make a more specific request, please type \'help <item>\',\nwhere <item> is one of the following topics:\n   SHOW\n   SHOW BINARY LOGS\n   SHOW ENGINE\n   SHOW LOGS\n\nUse a topic as the search string to see the help entry for that topic:\n\nmysql> help show binary logs\nName: \'SHOW BINARY LOGS\'\nDescription:\nSyntax:\nSHOW BINARY LOGS\nSHOW MASTER LOGS\n\nLists the binary log files on the server. This statement is used as\npart of the procedure described in [purge-binary-logs], that shows how\nto determine which logs can be purged.\n\nmysql> SHOW BINARY LOGS;\n+---------------+-----------+-----------+\n| Log_name      | File_size | Encrypted |\n+---------------+-----------+-----------+\n| binlog.000015 |    724935 | Yes       |\n| binlog.000016 |    733481 | Yes       |\n+---------------+-----------+-----------+\n\nThe search string can contain the wildcard characters % and _. These\nhave the same meaning as for pattern-matching operations performed with\nthe LIKE operator. For example, HELP rep% returns a list of topics that\nbegin with rep:\n\nmysql> HELP rep%\nMany help items for your request exist.\nTo make a more specific request, please type \'help <item>\',\nwhere <item> is one of the following\ntopics:\n   REPAIR TABLE\n   REPEAT FUNCTION\n   REPEAT LOOP\n   REPLACE\n   REPLACE FUNCTION\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mysql-server-side-help.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/mysql-server-side-help.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (224,39,'HELP STATEMENT','Syntax:\nHELP \'search_string\'\n\nThe HELP statement returns online information from the MySQL Reference\nManual. Its proper operation requires that the help tables in the mysql\ndatabase be initialized with help topic information (see\nhttp://dev.mysql.com/doc/refman/8.0/en/server-side-help-support.html).\n\nThe HELP statement searches the help tables for the given search string\nand displays the result of the search. The search string is not\ncase-sensitive.\n\nThe search string can contain the wildcard characters % and _. These\nhave the same meaning as for pattern-matching operations performed with\nthe LIKE operator. For example, HELP \'rep%\' returns a list of topics\nthat begin with rep.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/help.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/help.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (225,22,'HELP_DATE','This help information was generated from the MySQL 8.0 Reference Manual\non: 2019-02-20\n','','');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (226,22,'HELP_VERSION','This help information was generated from the MySQL 8.0 Reference Manual\non: 2019-02-20 (revision: 61006)\n\nThis information applies to MySQL 8.0 through 8.0.17.\n','','');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (227,35,'HEX','Syntax:\nHEX(str), HEX(N)\n\nFor a string argument str, HEX() returns a hexadecimal string\nrepresentation of str where each byte of each character in str is\nconverted to two hexadecimal digits. (Multibyte characters therefore\nbecome more than two digits.) The inverse of this operation is\nperformed by the UNHEX() function.\n\nFor a numeric argument N, HEX() returns a hexadecimal string\nrepresentation of the value of N treated as a longlong (BIGINT) number.\nThis is equivalent to CONV(N,10,16). The inverse of this operation is\nperformed by CONV(HEX(N),16,10).\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT X\'616263\', HEX(\'abc\'), UNHEX(HEX(\'abc\'));\n        -> \'abc\', 616263, \'abc\'\nmysql> SELECT HEX(255), CONV(HEX(255),16,10);\n        -> \'FF\', 255\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (228,12,'HOUR','Syntax:\nHOUR(time)\n\nReturns the hour for time. The range of the return value is 0 to 23 for\ntime-of-day values. However, the range of TIME values actually is much\nlarger, so HOUR can return values greater than 23.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT HOUR(\'10:05:03\');\n        -> 10\nmysql> SELECT HOUR(\'272:59:59\');\n        -> 272\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (229,23,'ICU_VERSION','ICU_VERSION()\n\nThe version of the International Components for Unicode (ICU) library\nused to support regular expression operations (see\nhttp://dev.mysql.com/doc/refman/8.0/en/regexp.html). This function is\nprimarily intended for use in test cases.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/information-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (230,8,'IF FUNCTION','Syntax:\nIF(expr1,expr2,expr3)\n\nIf expr1 is TRUE (expr1 <> 0 and expr1 <> NULL), IF() returns expr2.\nOtherwise, it returns expr3.\n\n*Note*:\n\nThere is also an IF statement, which differs from the IF() function\ndescribed here. See [HELP IF statement].\n\nIf only one of expr2 or expr3 is explicitly NULL, the result type of\nthe IF() function is the type of the non-NULL expression.\n\nThe default return type of IF() (which may matter when it is stored\ninto a temporary table) is calculated as follows:\n\no If expr2 or expr3 produce a string, the result is a string.\n\n  If expr2 and expr3 are both strings, the result is case-sensitive if\n  either string is case sensitive.\n\no If expr2 or expr3 produce a floating-point value, the result is a\n  floating-point value.\n\no If expr2 or expr3 produce an integer, the result is an integer.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/control-flow-functions.html\n\n','mysql> SELECT IF(1>2,2,3);\n        -> 3\nmysql> SELECT IF(1<2,\'yes\',\'no\');\n        -> \'yes\'\nmysql> SELECT IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\');\n        -> \'no\'\n','http://dev.mysql.com/doc/refman/8.0/en/control-flow-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (231,6,'IF STATEMENT','Syntax:\nIF search_condition THEN statement_list\n    [ELSEIF search_condition THEN statement_list] ...\n    [ELSE statement_list]\nEND IF\n\nThe IF statement for stored programs implements a basic conditional\nconstruct.\n\n*Note*:\n\nThere is also an IF() function, which differs from the IF statement\ndescribed here. See\nhttp://dev.mysql.com/doc/refman/8.0/en/control-flow-functions.html. The\nIF statement can have THEN, ELSE, and ELSEIF clauses, and it is\nterminated with END IF.\n\nIf a given search_condition evaluates to true, the corresponding THEN\nor ELSEIF clause statement_list executes. If no search_condition\nmatches, the ELSE clause statement_list executes.\n\nEach statement_list consists of one or more SQL statements; an empty\nstatement_list is not permitted.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/if.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/if.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (232,8,'IFNULL','Syntax:\nIFNULL(expr1,expr2)\n\nIf expr1 is not NULL, IFNULL() returns expr1; otherwise it returns\nexpr2.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/control-flow-functions.html\n\n','mysql> SELECT IFNULL(1,0);\n        -> 1\nmysql> SELECT IFNULL(NULL,10);\n        -> 10\nmysql> SELECT IFNULL(1/0,10);\n        -> 10\nmysql> SELECT IFNULL(1/0,\'yes\');\n        -> \'yes\'\n','http://dev.mysql.com/doc/refman/8.0/en/control-flow-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (233,10,'IMPORT TABLE','Syntax:\nIMPORT TABLE FROM sdi_file [, sdi_file] ...\n\nThe IMPORT TABLE statement imports MyISAM tables based on information\ncontained in .sdi (Serialized Dictionary Information) metadata files.\nIMPORT TABLE requires the FILE privilege to read the .sdi and table\ncontent files, and the CREATE privilege for the table to be created.\n\nTables can be exported from one server using mysqldump to write a file\nof SQL statements and imported into another server using mysql to\nprocess the dump file. IMPORT TABLE provides a faster alternative using\nthe "raw" table files.\n\nPrior to import, the files that provide the table content must be\nplaced in the appropriate schema directory for the import server, and\nthe .sdi file must be located in a directory accessible to the server.\nFor example, the .sdi file can be placed in the directory named by the\nsecure_file_priv system variable, or (if secure_file_priv is empty) in\na directory under the server data directory.\n\nThe following example describes how to export MyISAM tables named\nemployees and managers from the hr schema of one server and import them\ninto the hr schema of another server. The example uses these\nassumptions (to perform a similar operation on your own system, modify\nthe path names as appropriate):\n\no For the export server, export_basedir represents its base directory,\n  and its data directory is export_basedir/data.\n\no For the import server, import_basedir represents its base directory,\n  and its data directory is import_basedir/data.\n\no Table files are exported from the export server into the /tmp/export\n  directory and this directory is secure (not accessible to other\n  users).\n\no The import server uses /tmp/mysql-files as the directory named by its\n  secure_file_priv system variable.\n\nTo export tables from the export server, use this procedure:\n\n1. Ensure a consistent snapshot by executing this statement to lock the\n   tables so that they cannot be modified during export:\n\nmysql> FLUSH TABLES hr.employees, hr.managers WITH READ LOCK;\n\n   While the lock is in effect, the tables can still be used, but only\n   for read access.\n\n2. At the file system level, copy the .sdi and table content files from\n   the hr schema directory to the secure export directory:\n\n  o The .sdi file is located in the hr schema directory, but might not\n    have exactly the same basename as the table name. For example, the\n    .sdi files for the employees and managers tables might be named\n    employees_125.sdi and managers_238.sdi.\n\n  o For a MyISAM table, the content files are its .MYD data file and\n    .MYI index file.\n\n   Given those file names, the copy commands look like this:\n\nshell> cd export_basedir/data/hr\nshell> cp employees_125.sdi /tmp/export\nshell> cp managers_238.sdi /tmp/export\nshell> cp employees.{MYD,MYI} /tmp/export\nshell> cp managers.{MYD,MYI} /tmp/export\n\n3. Unlock the tables:\n\nmysql> UNLOCK TABLES;\n\nTo import tables into the import server, use this procedure:\n\n1. The import schema must exist. If necessary, execute this statement\n   to create it:\n\nmysql> CREATE SCHEMA hr;\n\n2. At the file system level, copy the .sdi files to the import server\n   secure_file_priv directory, /tmp/mysql-files. Also, copy the table\n   content files to the hr schema directory:\n\nshell> cd /tmp/export\nshell> cp employees_125.sdi /tmp/mysql-files\nshell> cp managers_238.sdi /tmp/mysql-files\nshell> cp employees.{MYD,MYI} import_basedir/data/hr\nshell> cp managers.{MYD,MYI} import_basedir/data/hr\n\n3. Import the tables by executing an IMPORT TABLE statement that names\n   the .sdi files:\n\nmysql> IMPORT TABLE FROM\n       \'/tmp/mysql-files/employees.sdi\',\n       \'/tmp/mysql-files/managers.sdi\';\n\nThe .sdi file need not be placed in the import server directory named\nby the secure_file_priv system variable if that variable is empty; it\ncan be in any directory accessible to the server, including the schema\ndirectory for the imported table. If the .sdi file is placed in that\ndirectory, however, it may be rewritten; the import operation creates a\nnew .sdi file for the table, which will overwrite the old .sdi file if\nthe operation uses the same file name for the new file.\n\nEach sdi_file value must be a string literal that names the .sdi file\nfor a table or is a pattern that matches .sdi files. If the string is a\npattern, any leading directory path and the .sdi file name suffix must\nbe given literally. Pattern characters are permitted only in the base\nname part of the file name:\n\no ? matches any single character\n\no * matches any sequence of characters, including no characters\n\nUsing a pattern, the previous IMPORT TABLE statement could have been\nwritten like this (assuming that the /tmp/mysql-files directory\ncontains no other .sdi files matching the pattern):\n\nIMPORT TABLE FROM \'/tmp/mysql-files/*.sdi\';\n\nTo interpret the location of .sdi file path names, the server uses the\nsame rules for IMPORT TABLE as the server-side rules for LOAD DATA\n(that is, the non-LOCAL rules). See [HELP LOAD DATA], paying particular\nattention to the rules used to interpret relative path names.\n\nIMPORT TABLE fails if the .sdi or table files cannot be located. After\nimporting a table, the server attempts to open it and reports as\nwarnings any problems detected. To attempt a repair to correct any\nreported issues, use REPAIR TABLE.\n\nIMPORT TABLE is not written to the binary log.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/import-table.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/import-table.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (234,4,'IN','Syntax:\nexpr IN (value,...)\n\nReturns 1 if expr is equal to any of the values in the IN list, else\nreturns 0. If all values are constants, they are evaluated according to\nthe type of expr and sorted. The search for the item then is done using\na binary search. This means IN is very quick if the IN value list\nconsists entirely of constants. Otherwise, type conversion takes place\naccording to the rules described in\nhttp://dev.mysql.com/doc/refman/8.0/en/type-conversion.html, but\napplied to all the arguments.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html\n\n','mysql> SELECT 2 IN (0,3,5,7);\n        -> 0\nmysql> SELECT \'wefwf\' IN (\'wee\',\'wefwf\',\'weg\');\n        -> 1\n','http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (235,29,'INET6_ATON','Syntax:\nINET6_ATON(expr)\n\nGiven an IPv6 or IPv4 network address as a string, returns a binary\nstring that represents the numeric value of the address in network byte\norder (big endian). Because numeric-format IPv6 addresses require more\nbytes than the largest integer type, the representation returned by\nthis function has the VARBINARY data type: VARBINARY(16) for IPv6\naddresses and VARBINARY(4) for IPv4 addresses. If the argument is not a\nvalid address, INET6_ATON() returns NULL.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html\n\n','mysql> SELECT HEX(INET6_ATON(\'fdfe::5a55:caff:fefa:9089\'));\n        -> \'FDFE0000000000005A55CAFFFEFA9089\'\nmysql> SELECT HEX(INET6_ATON(\'10.0.5.9\'));\n        -> \'0A000509\'\n','http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (236,29,'INET6_NTOA','Syntax:\nINET6_NTOA(expr)\n\nGiven an IPv6 or IPv4 network address represented in numeric form as a\nbinary string, returns the string representation of the address as a\nstring in the connection character set. If the argument is not a valid\naddress, INET6_NTOA() returns NULL.\n\nINET6_NTOA() has these properties:\n\no It does not use operating system functions to perform conversions,\n  thus the output string is platform independent.\n\no The return string has a maximum length of 39 (4 x 8 + 7). Given this\n  statement:\n\nCREATE TABLE t AS SELECT INET6_NTOA(expr) AS c1;\n\n  The resulting table would have this definition:\n\nCREATE TABLE t (c1 VARCHAR(39) CHARACTER SET utf8 DEFAULT NULL);\n\no The return string uses lowercase letters for IPv6 addresses.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html\n\n','mysql> SELECT INET6_NTOA(INET6_ATON(\'fdfe::5a55:caff:fefa:9089\'));\n        -> \'fdfe::5a55:caff:fefa:9089\'\nmysql> SELECT INET6_NTOA(INET6_ATON(\'10.0.5.9\'));\n        -> \'10.0.5.9\'\n\nmysql> SELECT INET6_NTOA(UNHEX(\'FDFE0000000000005A55CAFFFEFA9089\'));\n        -> \'fdfe::5a55:caff:fefa:9089\'\nmysql> SELECT INET6_NTOA(UNHEX(\'0A000509\'));\n        -> \'10.0.5.9\'\n','http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (237,29,'INET_ATON','Syntax:\nINET_ATON(expr)\n\nGiven the dotted-quad representation of an IPv4 network address as a\nstring, returns an integer that represents the numeric value of the\naddress in network byte order (big endian). INET_ATON() returns NULL if\nit does not understand its argument.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html\n\n','mysql> SELECT INET_ATON(\'10.0.5.9\');\n        -> 167773449\n','http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (238,29,'INET_NTOA','Syntax:\nINET_NTOA(expr)\n\nGiven a numeric IPv4 network address in network byte order, returns the\ndotted-quad string representation of the address as a string in the\nconnection character set. INET_NTOA() returns NULL if it does not\nunderstand its argument.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html\n\n','mysql> SELECT INET_NTOA(167773449);\n        -> \'10.0.5.9\'\n','http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (239,10,'INSERT','Syntax:\nINSERT [LOW_PRIORITY | DELAYED | HIGH_PRIORITY] [IGNORE]\n    [INTO] tbl_name\n    [PARTITION (partition_name [, partition_name] ...)]\n    [(col_name [, col_name] ...)]\n    {VALUES | VALUE} (value_list) [, (value_list)] ...\n    [ON DUPLICATE KEY UPDATE assignment_list]\n\nINSERT [LOW_PRIORITY | DELAYED | HIGH_PRIORITY] [IGNORE]\n    [INTO] tbl_name\n    [PARTITION (partition_name [, partition_name] ...)]\n    SET assignment_list\n    [ON DUPLICATE KEY UPDATE assignment_list]\n\nINSERT [LOW_PRIORITY | HIGH_PRIORITY] [IGNORE]\n    [INTO] tbl_name\n    [PARTITION (partition_name [, partition_name] ...)]\n    [(col_name [, col_name] ...)]\n    SELECT ...\n    [ON DUPLICATE KEY UPDATE assignment_list]\n\nvalue:\n    {expr | DEFAULT}\n\nvalue_list:\n    value [, value] ...\n\nassignment:\n    col_name = value\n\nassignment_list:\n    assignment [, assignment] ...\n\nINSERT inserts new rows into an existing table. The INSERT ... VALUES\nand INSERT ... SET forms of the statement insert rows based on\nexplicitly specified values. The INSERT ... SELECT form inserts rows\nselected from another table or tables. INSERT with an ON DUPLICATE KEY\nUPDATE clause enables existing rows to be updated if a row to be\ninserted would cause a duplicate value in a UNIQUE index or PRIMARY\nKEY.\n\nFor additional information about INSERT ... SELECT and INSERT ... ON\nDUPLICATE KEY UPDATE, see [HELP INSERT SELECT], and\nhttp://dev.mysql.com/doc/refman/8.0/en/insert-on-duplicate.html.\n\nIn MySQL 8.0, the DELAYED keyword is accepted but ignored by the\nserver. For the reasons for this, see [HELP INSERT DELAYED],\n\nInserting into a table requires the INSERT privilege for the table. If\nthe ON DUPLICATE KEY UPDATE clause is used and a duplicate key causes\nan UPDATE to be performed instead, the statement requires the UPDATE\nprivilege for the columns to be updated. For columns that are read but\nnot modified you need only the SELECT privilege (such as for a column\nreferenced only on the right hand side of an col_name=expr assignment\nin an ON DUPLICATE KEY UPDATE clause).\n\nWhen inserting into a partitioned table, you can control which\npartitions and subpartitions accept new rows. The PARTITION option\ntakes a list of the comma-separated names of one or more partitions or\nsubpartitions (or both) of the table. If any of the rows to be inserted\nby a given INSERT statement do not match one of the partitions listed,\nthe INSERT statement fails with the error Found a row not matching the\ngiven partition set. For more information and examples, see\nhttp://dev.mysql.com/doc/refman/8.0/en/partitioning-selection.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/insert.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/insert.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (240,10,'INSERT DELAYED','Syntax:\nINSERT DELAYED ...\n\nThe DELAYED option for the INSERT statement is a MySQL extension to\nstandard SQL. In previous versions of MySQL, it can be used for certain\nkinds of tables (such as MyISAM), such that when a client uses INSERT\nDELAYED, it gets an okay from the server at once, and the row is queued\nto be inserted when the table is not in use by any other thread.\n\nDELAYED inserts and replaces were deprecated in MySQL 5.6. In MySQL\n8.0, DELAYED is not supported. The server recognizes but ignores the\nDELAYED keyword, handles the insert as a nondelayed insert, and\ngenerates an ER_WARN_LEGACY_SYNTAX_CONVERTED warning ("INSERT DELAYED\nis no longer supported. The statement was converted to INSERT"). The\nDELAYED keyword is scheduled for removal in a future release.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/insert-delayed.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/insert-delayed.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (241,35,'INSERT FUNCTION','Syntax:\nINSERT(str,pos,len,newstr)\n\nReturns the string str, with the substring beginning at position pos\nand len characters long replaced by the string newstr. Returns the\noriginal string if pos is not within the length of the string. Replaces\nthe rest of the string from position pos if len is not within the\nlength of the rest of the string. Returns NULL if any argument is NULL.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT INSERT(\'Quadratic\', 3, 4, \'What\');\n        -> \'QuWhattic\'\nmysql> SELECT INSERT(\'Quadratic\', -1, 4, \'What\');\n        -> \'Quadratic\'\nmysql> SELECT INSERT(\'Quadratic\', 3, 100, \'What\');\n        -> \'QuWhat\'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (242,10,'INSERT SELECT','Syntax:\nINSERT [LOW_PRIORITY | HIGH_PRIORITY] [IGNORE]\n    [INTO] tbl_name\n    [PARTITION (partition_name [, partition_name] ...)]\n    [(col_name [, col_name] ...)]\n    SELECT ...\n    [ON DUPLICATE KEY UPDATE assignment_list]\n\nvalue:\n    {expr | DEFAULT}\n\nassignment:\n    col_name = value\n\nassignment_list:\n    assignment [, assignment] ...\n\nWith INSERT ... SELECT, you can quickly insert many rows into a table\nfrom the result of a SELECT statement, which can select from one or\nmany tables. For example:\n\nINSERT INTO tbl_temp2 (fld_id)\n  SELECT tbl_temp1.fld_order_id\n  FROM tbl_temp1 WHERE tbl_temp1.fld_order_id > 100;\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/insert-select.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/insert-select.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (243,5,'INSTALL COMPONENT','Syntax:\nINSTALL COMPONENT component_name [, component_name ] ...\n\nThis statement installs one or more server components, which become\nactive immediately. A component provides services that are available to\nthe server and other components; see\nhttp://dev.mysql.com/doc/refman/8.0/en/server-components.html. INSTALL\nCOMPONENT requires the INSERT privilege for the mysql.component system\ntable.\n\nExample:\n\nINSTALL COMPONENT \'file://component1\', \'file://component2\';\n\nComponent names are URNs that begin with file:// and indicate the base\nname of the file that implements the component, located in the\ndirectory named by the plugin_dir system variable. Component names do\nnot include any platform-dependent file name suffix such as .so or\n.dll. (These naming details are subject to change because component\nname interpretation is itself performed by a service and the component\ninfrastructure makes it possible to replace the default service\nimplementation with alternative implementations.)\n\nIf any error occurs, the statement fails and has no effect. For\nexample, this happens if a component name is erroneous, a named\ncomponent does not exist or is already installed, or component\ninitialization fails.\n\nA loader service handles component loading, which includes adding\ninstalled components to the mysql.component system table that serves as\na registry. For subsequent server restarts, any components listed in\nmysql.component are loaded by the loader service during the startup\nsequence. This occurs even if the server is started with the\n--skip-grant-tables option.\n\nIf a component depends on services not present in the registry and you\nattempt to install the component without also installing the component\nor components that provide the services on which it depends, an error\noccurs:\n\nERROR 3527 (HY000): Cannot satisfy dependency for service \'component_a\'\nrequired by component \'component_b\'.\n\nTo avoid this problem, either install all components in the same\nstatement, or install the dependent component after installing any\ncomponents on which it depends.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/install-component.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/install-component.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (244,31,'INSTALL PLUGIN','Syntax:\nINSTALL PLUGIN plugin_name SONAME \'shared_library_name\'\n\nThis statement installs a server plugin. It requires the INSERT\nprivilege for the mysql.plugin system table.\n\nplugin_name is the name of the plugin as defined in the plugin\ndescriptor structure contained in the library file (see\nhttp://dev.mysql.com/doc/refman/8.0/en/plugin-data-structures.html).\nPlugin names are not case-sensitive. For maximal compatibility, plugin\nnames should be limited to ASCII letters, digits, and underscore\nbecause they are used in C source files, shell command lines, M4 and\nBourne shell scripts, and SQL environments.\n\nshared_library_name is the name of the shared library that contains the\nplugin code. The name includes the file name extension (for example,\nlibmyplugin.so, libmyplugin.dll, or libmyplugin.dylib).\n\nThe shared library must be located in the plugin directory (the\ndirectory named by the plugin_dir system variable). The library must be\nin the plugin directory itself, not in a subdirectory. By default,\nplugin_dir is the plugin directory under the directory named by the\npkglibdir configuration variable, but it can be changed by setting the\nvalue of plugin_dir at server startup. For example, set its value in a\nmy.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\n\nIf the value of plugin_dir is a relative path name, it is taken to be\nrelative to the MySQL base directory (the value of the basedir system\nvariable).\n\nINSTALL PLUGIN loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its\ninitialization function, which handles any setup that the plugin must\nperform before it can be used. When the server shuts down, it executes\nthe deinitialization function for each plugin that is loaded so that\nthe plugin has a chance to perform any final cleanup.\n\nINSTALL PLUGIN also registers the plugin by adding a line that\nindicates the plugin name and library file name to the mysql.plugin\nsystem table. At server startup, the server loads and initializes any\nplugin that is listed in mysql.plugin. This means that a plugin is\ninstalled with INSTALL PLUGIN only once, not every time the server\nstarts. Plugin loading at startup does not occur if the server is\nstarted with the --skip-grant-tables option.\n\nA plugin library can contain multiple plugins. For each of them to be\ninstalled, use a separate INSTALL PLUGIN statement. Each statement\nnames a different plugin, but all of them specify the same library\nname.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/install-plugin.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/install-plugin.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (245,35,'INSTR','Syntax:\nINSTR(str,substr)\n\nReturns the position of the first occurrence of substring substr in\nstring str. This is the same as the two-argument form of LOCATE(),\nexcept that the order of the arguments is reversed.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT INSTR(\'foobarbar\', \'bar\');\n        -> 4\nmysql> SELECT INSTR(\'xbar\', \'foobar\');\n        -> 0\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (246,11,'INT','INT[(M)] [UNSIGNED] [ZEROFILL]\n\nA normal-size integer. The signed range is -2147483648 to 2147483647.\nThe unsigned range is 0 to 4294967295.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/numeric-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (247,11,'INTEGER','INTEGER[(M)] [UNSIGNED] [ZEROFILL]\n\nThis type is a synonym for INT.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/numeric-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (248,29,'INTERNAL_AUTO_INCREMENT','INTERNAL_AUTO_INCREMENT(ARGS)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (249,29,'INTERNAL_AVG_ROW_LENGTH','INTERNAL_AVG_ROW_LENGTH(ARGS)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (250,29,'INTERNAL_CHECKSUM','INTERNAL_CHECKSUM(ARGS)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (251,29,'INTERNAL_CHECK_TIME','INTERNAL_CHECK_TIME(ARGS)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (252,29,'INTERNAL_DATA_FREE','INTERNAL_DATA_FREE(ARGS)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (253,29,'INTERNAL_DATA_LENGTH','INTERNAL_DATA_LENGTH(ARGS)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (254,29,'INTERNAL_DD_CHAR_LENGTH','INTERNAL_DD_CHAR_LENGTH(ARGS)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (255,29,'INTERNAL_GET_COMMENT_OR_ERROR','INTERNAL_GET_COMMENT_OR_ERROR(ARGS)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (256,29,'INTERNAL_GET_VIEW_WARNING_OR_ERROR','INTERNAL_GET_VIEW_WARNING_OR_ERROR(ARGS)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (257,29,'INTERNAL_INDEX_COLUMN_CARDINALITY','INTERNAL_INDEX_COLUMN_CARDINALITY(ARGS)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (258,29,'INTERNAL_INDEX_LENGTH','INTERNAL_INDEX_LENGTH(ARGS)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (259,29,'INTERNAL_KEYS_DISABLED','INTERNAL_KEYS_DISABLED(ARGS)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (260,29,'INTERNAL_MAX_DATA_LENGTH','INTERNAL_MAX_DATA_LENGTH(ARGS)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (261,29,'INTERNAL_TABLE_ROWS','INTERNAL_TABLE_ROWS(ARGS)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (262,29,'INTERNAL_UPDATE_TIME','INTERNAL_UPDATE_TIME(ARGS)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (263,4,'INTERVAL','Syntax:\nINTERVAL(N,N1,N2,N3,...)\n\nReturns 0 if N < N1, 1 if N < N2 and so on or -1 if N is NULL. All\narguments are treated as integers. It is required that N1 < N2 < N3 <\n... < Nn for this function to work correctly. This is because a binary\nsearch is used (very fast).\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html\n\n','mysql> SELECT INTERVAL(23, 1, 15, 17, 30, 44, 200);\n        -> 3\nmysql> SELECT INTERVAL(10, 1, 10, 100, 1000);\n        -> 2\nmysql> SELECT INTERVAL(22, 23, 30, 44, 200);\n        -> 0\n','http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (264,4,'IS','Syntax:\nIS boolean_value\n\nTests a value against a boolean value, where boolean_value can be TRUE,\nFALSE, or UNKNOWN.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html\n\n','mysql> SELECT 1 IS TRUE, 0 IS FALSE, NULL IS UNKNOWN;\n        -> 1, 1, 1\n','http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (265,4,'IS NOT','Syntax:\nIS NOT boolean_value\n\nTests a value against a boolean value, where boolean_value can be TRUE,\nFALSE, or UNKNOWN.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html\n\n','mysql> SELECT 1 IS NOT UNKNOWN, 0 IS NOT UNKNOWN, NULL IS NOT UNKNOWN;\n        -> 1, 1, 0\n','http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (266,4,'IS NOT NULL','Syntax:\nIS NOT NULL\n\nTests whether a value is not NULL.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html\n\n','mysql> SELECT 1 IS NOT NULL, 0 IS NOT NULL, NULL IS NOT NULL;\n        -> 1, 1, 0\n','http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (267,4,'IS NULL','Syntax:\nIS NULL\n\nTests whether a value is NULL.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html\n\n','mysql> SELECT 1 IS NULL, 0 IS NULL, NULL IS NULL;\n        -> 0, 0, 1\n','http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (268,4,'ISNULL','Syntax:\nISNULL(expr)\n\nIf expr is NULL, ISNULL() returns 1, otherwise it returns 0.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html\n\n','mysql> SELECT ISNULL(1+1);\n        -> 0\nmysql> SELECT ISNULL(1/0);\n        -> 1\n','http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (269,37,'ISOLATION','Syntax:\nSET [GLOBAL | SESSION] TRANSACTION\n    transaction_characteristic [, transaction_characteristic] ...\n\ntransaction_characteristic: {\n    ISOLATION LEVEL level\n  | access_mode\n}\n\nlevel: {\n     REPEATABLE READ\n   | READ COMMITTED\n   | READ UNCOMMITTED\n   | SERIALIZABLE\n}\n\naccess_mode: {\n     READ WRITE\n   | READ ONLY\n}\n\nThis statement specifies transaction characteristics. It takes a list\nof one or more characteristic values separated by commas. Each\ncharacteristic value sets the transaction isolation level or access\nmode. The isolation level is used for operations on InnoDB tables. The\naccess mode specifies whether transactions operate in read/write or\nread-only mode.\n\nIn addition, SET TRANSACTION can include an optional GLOBAL or SESSION\nkeyword to indicate the scope of the statement.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/set-transaction.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/set-transaction.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (270,26,'IS_FREE_LOCK','Syntax:\nIS_FREE_LOCK(str)\n\nChecks whether the lock named str is free to use (that is, not locked).\nReturns 1 if the lock is free (no one is using the lock), 0 if the lock\nis in use, and NULL if an error occurs (such as an incorrect argument).\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/locking-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/locking-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (271,29,'IS_IPV4','Syntax:\nIS_IPV4(expr)\n\nReturns 1 if the argument is a valid IPv4 address specified as a\nstring, 0 otherwise.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html\n\n','mysql> SELECT IS_IPV4(\'10.0.5.9\'), IS_IPV4(\'10.0.5.256\');\n        -> 1, 0\n','http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (272,29,'IS_IPV4_COMPAT','Syntax:\nIS_IPV4_COMPAT(expr)\n\nThis function takes an IPv6 address represented in numeric form as a\nbinary string, as returned by INET6_ATON(). It returns 1 if the\nargument is a valid IPv4-compatible IPv6 address, 0 otherwise.\nIPv4-compatible addresses have the form ::ipv4_address.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html\n\n','mysql> SELECT IS_IPV4_COMPAT(INET6_ATON(\'::10.0.5.9\'));\n        -> 1\nmysql> SELECT IS_IPV4_COMPAT(INET6_ATON(\'::ffff:10.0.5.9\'));\n        -> 0\n','http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (273,29,'IS_IPV4_MAPPED','Syntax:\nIS_IPV4_MAPPED(expr)\n\nThis function takes an IPv6 address represented in numeric form as a\nbinary string, as returned by INET6_ATON(). It returns 1 if the\nargument is a valid IPv4-mapped IPv6 address, 0 otherwise. IPv4-mapped\naddresses have the form ::ffff:ipv4_address.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html\n\n','mysql> SELECT IS_IPV4_MAPPED(INET6_ATON(\'::10.0.5.9\'));\n        -> 0\nmysql> SELECT IS_IPV4_MAPPED(INET6_ATON(\'::ffff:10.0.5.9\'));\n        -> 1\n','http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (274,29,'IS_IPV6','Syntax:\nIS_IPV6(expr)\n\nReturns 1 if the argument is a valid IPv6 address specified as a\nstring, 0 otherwise. This function does not consider IPv4 addresses to\nbe valid IPv6 addresses.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html\n\n','mysql> SELECT IS_IPV6(\'10.0.5.9\'), IS_IPV6(\'::1\');\n        -> 0, 1\n','http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (275,26,'IS_USED_LOCK','Syntax:\nIS_USED_LOCK(str)\n\nChecks whether the lock named str is in use (that is, locked). If so,\nit returns the connection identifier of the client session that holds\nthe lock. Otherwise, it returns NULL.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/locking-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/locking-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (276,29,'IS_UUID','IS_UUID(string_uuid)\n\nReturns 1 if the argument is a valid string-format UUID, 0 if the\nargument is not a valid UUID, and NULL if the argument is NULL.\n\n"Valid" means that the value is in a format that can be parsed. That\nis, it has the correct length and contains only the permitted\ncharacters (hexadecimal digits in any lettercase and, optionally,\ndashes and curly braces). This format is most common:\n\naaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee\n\nThese other formats are also permitted:\n\naaaaaaaabbbbccccddddeeeeeeeeeeee\n{aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee}\n\nFor the meanings of fields within the value, see the UUID() function\ndescription.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html\n\n','mysql> SELECT IS_UUID(\'6ccd780c-baba-1026-9564-5b8c656024db\');\n+-------------------------------------------------+\n| IS_UUID(\'6ccd780c-baba-1026-9564-5b8c656024db\') |\n+-------------------------------------------------+\n|                                               1 |\n+-------------------------------------------------+\nmysql> SELECT IS_UUID(\'6CCD780C-BABA-1026-9564-5B8C656024DB\');\n+-------------------------------------------------+\n| IS_UUID(\'6CCD780C-BABA-1026-9564-5B8C656024DB\') |\n+-------------------------------------------------+\n|                                               1 |\n+-------------------------------------------------+\nmysql> SELECT IS_UUID(\'6ccd780cbaba102695645b8c656024db\');\n+---------------------------------------------+\n| IS_UUID(\'6ccd780cbaba102695645b8c656024db\') |\n+---------------------------------------------+\n|                                           1 |\n+---------------------------------------------+\nmysql> SELECT IS_UUID(\'{6ccd780c-baba-1026-9564-5b8c656024db}\');\n+---------------------------------------------------+\n| IS_UUID(\'{6ccd780c-baba-1026-9564-5b8c656024db}\') |\n+---------------------------------------------------+\n|                                                 1 |\n+---------------------------------------------------+\nmysql> SELECT IS_UUID(\'6ccd780c-baba-1026-9564-5b8c6560\');\n+---------------------------------------------+\n| IS_UUID(\'6ccd780c-baba-1026-9564-5b8c6560\') |\n+---------------------------------------------+\n|                                           0 |\n+---------------------------------------------+\nmysql> SELECT IS_UUID(RAND());\n+-----------------+\n| IS_UUID(RAND()) |\n+-----------------+\n|               0 |\n+-----------------+\n','http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (277,29,'IS_VISIBLE_DD_OBJECT','IS_VISIBLE_DD_OBJECT(ARGS)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/internal-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (278,6,'ITERATE','Syntax:\nITERATE label\n\nITERATE can appear only within LOOP, REPEAT, and WHILE statements.\nITERATE means "start the loop again."\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/iterate.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/iterate.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (279,10,'JOIN','MySQL supports the following JOIN syntax for the table_references part\nof SELECT statements and multiple-table DELETE and UPDATE statements:\n\ntable_references:\n    escaped_table_reference [, escaped_table_reference] ...\n\nescaped_table_reference:\n    table_reference\n  | { OJ table_reference }\n\ntable_reference:\n    table_factor\n  | joined_table\n\ntable_factor:\n    tbl_name [PARTITION (partition_names)]\n        [[AS] alias] [index_hint_list]\n  | table_subquery [AS] alias [(col_list)]\n  | ( table_references )\n\njoined_table:\n    table_reference {[INNER | CROSS] JOIN | STRAIGHT_JOIN} table_factor [join_specification]\n  | table_reference {LEFT|RIGHT} [OUTER] JOIN table_reference join_specification\n  | table_reference NATURAL [INNER | {LEFT|RIGHT} [OUTER]] JOIN table_factor\n\njoin_specification:\n    ON search_condition\n  | USING (join_column_list)\n\njoin_column_list:\n    column_name [, column_name] ...\n\nindex_hint_list:\n    index_hint [, index_hint] ...\n\nindex_hint:\n    USE {INDEX|KEY}\n      [FOR {JOIN|ORDER BY|GROUP BY}] ([index_list])\n  | {IGNORE|FORCE} {INDEX|KEY}\n      [FOR {JOIN|ORDER BY|GROUP BY}] (index_list)\n\nindex_list:\n    index_name [, index_name] ...\n\nA table reference is also known as a join expression.\n\nA table reference (when it refers to a partitioned table) may contain a\nPARTITION option, including a list of comma-separated partitions,\nsubpartitions, or both. This option follows the name of the table and\nprecedes any alias declaration. The effect of this option is that rows\nare selected only from the listed partitions or subpartitions. Any\npartitions or subpartitions not named in the list are ignored. For more\ninformation and examples, see\nhttp://dev.mysql.com/doc/refman/8.0/en/partitioning-selection.html.\n\nThe syntax of table_factor is extended in MySQL in comparison with\nstandard SQL. The standard accepts only table_reference, not a list of\nthem inside a pair of parentheses.\n\nThis is a conservative extension if each comma in a list of\ntable_reference items is considered as equivalent to an inner join. For\nexample:\n\nSELECT * FROM t1 LEFT JOIN (t2, t3, t4)\n                 ON (t2.a = t1.a AND t3.b = t1.b AND t4.c = t1.c)\n\nis equivalent to:\n\nSELECT * FROM t1 LEFT JOIN (t2 CROSS JOIN t3 CROSS JOIN t4)\n                 ON (t2.a = t1.a AND t3.b = t1.b AND t4.c = t1.c)\n\nIn MySQL, JOIN, CROSS JOIN, and INNER JOIN are syntactic equivalents\n(they can replace each other). In standard SQL, they are not\nequivalent. INNER JOIN is used with an ON clause, CROSS JOIN is used\notherwise.\n\nIn general, parentheses can be ignored in join expressions containing\nonly inner join operations. MySQL also supports nested joins. See\nhttp://dev.mysql.com/doc/refman/8.0/en/nested-join-optimization.html.\n\nIndex hints can be specified to affect how the MySQL optimizer makes\nuse of indexes. For more information, see\nhttp://dev.mysql.com/doc/refman/8.0/en/index-hints.html. Optimizer\nhints and the optimizer_switch system variable are other ways to\ninfluence optimizer use of indexes. See\nhttp://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html, and\nhttp://dev.mysql.com/doc/refman/8.0/en/switchable-optimizations.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/join.html\n\n','SELECT left_tbl.*\n  FROM left_tbl LEFT JOIN right_tbl ON left_tbl.id = right_tbl.id\n  WHERE right_tbl.id IS NULL;\n','http://dev.mysql.com/doc/refman/8.0/en/join.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (280,28,'JSON_ARRAY','Syntax:\nJSON_ARRAY([val[, val] ...])\n\nEvaluates a (possibly empty) list of values and returns a JSON array\ncontaining those values.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-creation-functions.html\n\n','mysql> SELECT JSON_ARRAY(1, "abc", NULL, TRUE, CURTIME());\n+---------------------------------------------+\n| JSON_ARRAY(1, "abc", NULL, TRUE, CURTIME()) |\n+---------------------------------------------+\n| [1, "abc", null, true, "11:30:24.000000"]   |\n+---------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/json-creation-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (281,15,'JSON_ARRAYAGG','Syntax:\nJSON_ARRAYAGG(col_or_expr) [over_clause]\n\nAggregates a result set as a single JSON array whose elements consist\nof the rows. The order of elements in this array is undefined. The\nfunction acts on a column or an expression that evaluates to a single\nvalue. Returns NULL if the result contains no rows, or in the event of\nan error.\n\nAs of MySQL 8.0.14, this function executes as a window function if\nover_clause is present. over_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html\n\n','mysql> SELECT o_id, attribute, value FROM t3;\n+------+-----------+--------+\n| o_id | attribute | value  |\n+------+-----------+--------+\n|    2 | color     | red    |\n|    2 | fabric    | silk   |\n|    3 | color     | green  |\n|    3 | shape     | square |\n+------+-----------+--------+\n4 rows in set (0.00 sec)\n\nmysql> SELECT o_id, JSON_ARRAYAGG(attribute) AS attributes \n       FROM t3 GROUP BY o_id;\n+------+---------------------+\n| o_id | attributes          |\n+------+---------------------+\n|    2 | ["color", "fabric"] |\n|    3 | ["color", "shape"]  |\n+------+---------------------+\n2 rows in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (282,28,'JSON_ARRAY_APPEND','Syntax:\nJSON_ARRAY_APPEND(json_doc, path, val[, path, val] ...)\n\nAppends values to the end of the indicated arrays within a JSON\ndocument and returns the result. Returns NULL if any argument is NULL.\nAn error occurs if the json_doc argument is not a valid JSON document\nor any path argument is not a valid path expression or contains a * or\n** wildcard.\n\nThe path-value pairs are evaluated left to right. The document produced\nby evaluating one pair becomes the new value against which the next\npair is evaluated.\n\nIf a path selects a scalar or object value, that value is autowrapped\nwithin an array and the new value is added to that array. Pairs for\nwhich the path does not identify any value in the JSON document are\nignored.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-modification-functions.html\n\n','mysql> SET @j = \'["a", ["b", "c"], "d"]\';\nmysql> SELECT JSON_ARRAY_APPEND(@j, \'$[1]\', 1);\n+----------------------------------+\n| JSON_ARRAY_APPEND(@j, \'$[1]\', 1) |\n+----------------------------------+\n| ["a", ["b", "c", 1], "d"]        |\n+----------------------------------+\nmysql> SELECT JSON_ARRAY_APPEND(@j, \'$[0]\', 2);\n+----------------------------------+\n| JSON_ARRAY_APPEND(@j, \'$[0]\', 2) |\n+----------------------------------+\n| [["a", 2], ["b", "c"], "d"]      |\n+----------------------------------+\nmysql> SELECT JSON_ARRAY_APPEND(@j, \'$[1][0]\', 3);\n+-------------------------------------+\n| JSON_ARRAY_APPEND(@j, \'$[1][0]\', 3) |\n+-------------------------------------+\n| ["a", [["b", 3], "c"], "d"]         |\n+-------------------------------------+\n\nmysql> SET @j = \'{"a": 1, "b": [2, 3], "c": 4}\';\nmysql> SELECT JSON_ARRAY_APPEND(@j, \'$.b\', \'x\');\n+------------------------------------+\n| JSON_ARRAY_APPEND(@j, \'$.b\', \'x\')  |\n+------------------------------------+\n| {"a": 1, "b": [2, 3, "x"], "c": 4} |\n+------------------------------------+\nmysql> SELECT JSON_ARRAY_APPEND(@j, \'$.c\', \'y\');\n+--------------------------------------+\n| JSON_ARRAY_APPEND(@j, \'$.c\', \'y\')    |\n+--------------------------------------+\n| {"a": 1, "b": [2, 3], "c": [4, "y"]} |\n+--------------------------------------+\n\nmysql> SET @j = \'{"a": 1}\';\nmysql> SELECT JSON_ARRAY_APPEND(@j, \'$\', \'z\');\n+---------------------------------+\n| JSON_ARRAY_APPEND(@j, \'$\', \'z\') |\n+---------------------------------+\n| [{"a": 1}, "z"]                 |\n+---------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/json-modification-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (283,28,'JSON_ARRAY_INSERT','Syntax:\nJSON_ARRAY_INSERT(json_doc, path, val[, path, val] ...)\n\nUpdates a JSON document, inserting into an array within the document\nand returning the modified document. Returns NULL if any argument is\nNULL. An error occurs if the json_doc argument is not a valid JSON\ndocument or any path argument is not a valid path expression or\ncontains a * or ** wildcard or does not end with an array element\nidentifier.\n\nThe path-value pairs are evaluated left to right. The document produced\nby evaluating one pair becomes the new value against which the next\npair is evaluated.\n\nPairs for which the path does not identify any array in the JSON\ndocument are ignored. If a path identifies an array element, the\ncorresponding value is inserted at that element position, shifting any\nfollowing values to the right. If a path identifies an array position\npast the end of an array, the value is inserted at the end of the\narray.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-modification-functions.html\n\n','mysql> SET @j = \'["a", {"b": [1, 2]}, [3, 4]]\';\nmysql> SELECT JSON_ARRAY_INSERT(@j, \'$[1]\', \'x\');\n+------------------------------------+\n| JSON_ARRAY_INSERT(@j, \'$[1]\', \'x\') |\n+------------------------------------+\n| ["a", "x", {"b": [1, 2]}, [3, 4]]  |\n+------------------------------------+\nmysql> SELECT JSON_ARRAY_INSERT(@j, \'$[100]\', \'x\');\n+--------------------------------------+\n| JSON_ARRAY_INSERT(@j, \'$[100]\', \'x\') |\n+--------------------------------------+\n| ["a", {"b": [1, 2]}, [3, 4], "x"]    |\n+--------------------------------------+\nmysql> SELECT JSON_ARRAY_INSERT(@j, \'$[1].b[0]\', \'x\');\n+-----------------------------------------+\n| JSON_ARRAY_INSERT(@j, \'$[1].b[0]\', \'x\') |\n+-----------------------------------------+\n| ["a", {"b": ["x", 1, 2]}, [3, 4]]       |\n+-----------------------------------------+\nmysql> SELECT JSON_ARRAY_INSERT(@j, \'$[2][1]\', \'y\');\n+---------------------------------------+\n| JSON_ARRAY_INSERT(@j, \'$[2][1]\', \'y\') |\n+---------------------------------------+\n| ["a", {"b": [1, 2]}, [3, "y", 4]]     |\n+---------------------------------------+\nmysql> SELECT JSON_ARRAY_INSERT(@j, \'$[0]\', \'x\', \'$[2][1]\', \'y\');\n+----------------------------------------------------+\n| JSON_ARRAY_INSERT(@j, \'$[0]\', \'x\', \'$[2][1]\', \'y\') |\n+----------------------------------------------------+\n| ["x", "a", {"b": [1, 2]}, [3, 4]]                  |\n+----------------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/json-modification-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (284,28,'JSON_CONTAINS','Syntax:\nJSON_CONTAINS(target, candidate[, path])\n\nIndicates by returning 1 or 0 whether a given candidate JSON document\nis contained within a target JSON document, or---if a path argument was\nsupplied---whether the candidate is found at a specific path within the\ntarget. Returns NULL if any argument is NULL, or if the path argument\ndoes not identify a section of the target document. An error occurs if\ntarget or candidate is not a valid JSON document, or if the path\nargument is not a valid path expression or contains a * or ** wildcard.\n\nTo check only whether any data exists at the path, use\nJSON_CONTAINS_PATH() instead.\n\nThe following rules define containment:\n\no A candidate scalar is contained in a target scalar if and only if\n  they are comparable and are equal. Two scalar values are comparable\n  if they have the same JSON_TYPE() types, with the exception that\n  values of types INTEGER and DECIMAL are also comparable to each\n  other.\n\no A candidate array is contained in a target array if and only if every\n  element in the candidate is contained in some element of the target.\n\no A candidate nonarray is contained in a target array if and only if\n  the candidate is contained in some element of the target.\n\no A candidate object is contained in a target object if and only if for\n  each key in the candidate there is a key with the same name in the\n  target and the value associated with the candidate key is contained\n  in the value associated with the target key.\n\nOtherwise, the candidate value is not contained in the target document.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-search-functions.html\n\n','mysql> SET @j = \'{"a": 1, "b": 2, "c": {"d": 4}}\';\nmysql> SET @j2 = \'1\';\nmysql> SELECT JSON_CONTAINS(@j, @j2, \'$.a\');\n+-------------------------------+\n| JSON_CONTAINS(@j, @j2, \'$.a\') |\n+-------------------------------+\n|                             1 |\n+-------------------------------+\nmysql> SELECT JSON_CONTAINS(@j, @j2, \'$.b\');\n+-------------------------------+\n| JSON_CONTAINS(@j, @j2, \'$.b\') |\n+-------------------------------+\n|                             0 |\n+-------------------------------+\n\nmysql> SET @j2 = \'{"d": 4}\';\nmysql> SELECT JSON_CONTAINS(@j, @j2, \'$.a\');\n+-------------------------------+\n| JSON_CONTAINS(@j, @j2, \'$.a\') |\n+-------------------------------+\n|                             0 |\n+-------------------------------+\nmysql> SELECT JSON_CONTAINS(@j, @j2, \'$.c\');\n+-------------------------------+\n| JSON_CONTAINS(@j, @j2, \'$.c\') |\n+-------------------------------+\n|                             1 |\n+-------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/json-search-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (285,28,'JSON_CONTAINS_PATH','Syntax:\nJSON_CONTAINS_PATH(json_doc, one_or_all, path[, path] ...)\n\nReturns 0 or 1 to indicate whether a JSON document contains data at a\ngiven path or paths. Returns NULL if any argument is NULL. An error\noccurs if the json_doc argument is not a valid JSON document, any path\nargument is not a valid path expression, or one_or_all is not \'one\' or\n\'all\'.\n\nTo check for a specific value at a path, use JSON_CONTAINS() instead.\n\nThe return value is 0 if no specified path exists within the document.\nOtherwise, the return value depends on the one_or_all argument:\n\no \'one\': 1 if at least one path exists within the document, 0\n  otherwise.\n\no \'all\': 1 if all paths exist within the document, 0 otherwise.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-search-functions.html\n\n','mysql> SET @j = \'{"a": 1, "b": 2, "c": {"d": 4}}\';\nmysql> SELECT JSON_CONTAINS_PATH(@j, \'one\', \'$.a\', \'$.e\');\n+---------------------------------------------+\n| JSON_CONTAINS_PATH(@j, \'one\', \'$.a\', \'$.e\') |\n+---------------------------------------------+\n|                                           1 |\n+---------------------------------------------+\nmysql> SELECT JSON_CONTAINS_PATH(@j, \'all\', \'$.a\', \'$.e\');\n+---------------------------------------------+\n| JSON_CONTAINS_PATH(@j, \'all\', \'$.a\', \'$.e\') |\n+---------------------------------------------+\n|                                           0 |\n+---------------------------------------------+\nmysql> SELECT JSON_CONTAINS_PATH(@j, \'one\', \'$.c.d\');\n+----------------------------------------+\n| JSON_CONTAINS_PATH(@j, \'one\', \'$.c.d\') |\n+----------------------------------------+\n|                                      1 |\n+----------------------------------------+\nmysql> SELECT JSON_CONTAINS_PATH(@j, \'one\', \'$.a.d\');\n+----------------------------------------+\n| JSON_CONTAINS_PATH(@j, \'one\', \'$.a.d\') |\n+----------------------------------------+\n|                                      0 |\n+----------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/json-search-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (286,28,'JSON_DEPTH','Syntax:\nJSON_DEPTH(json_doc)\n\nReturns the maximum depth of a JSON document. Returns NULL if the\nargument is NULL. An error occurs if the argument is not a valid JSON\ndocument.\n\nAn empty array, empty object, or scalar value has depth 1. A nonempty\narray containing only elements of depth 1 or nonempty object containing\nonly member values of depth 1 has depth 2. Otherwise, a JSON document\nhas depth greater than 2.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-attribute-functions.html\n\n','mysql> SELECT JSON_DEPTH(\'{}\'), JSON_DEPTH(\'[]\'), JSON_DEPTH(\'true\');\n+------------------+------------------+--------------------+\n| JSON_DEPTH(\'{}\') | JSON_DEPTH(\'[]\') | JSON_DEPTH(\'true\') |\n+------------------+------------------+--------------------+\n|                1 |                1 |                  1 |\n+------------------+------------------+--------------------+\nmysql> SELECT JSON_DEPTH(\'[10, 20]\'), JSON_DEPTH(\'[[], {}]\');\n+------------------------+------------------------+\n| JSON_DEPTH(\'[10, 20]\') | JSON_DEPTH(\'[[], {}]\') |\n+------------------------+------------------------+\n|                      2 |                      2 |\n+------------------------+------------------------+\nmysql> SELECT JSON_DEPTH(\'[10, {"a": 20}]\');\n+-------------------------------+\n| JSON_DEPTH(\'[10, {"a": 20}]\') |\n+-------------------------------+\n|                             3 |\n+-------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/json-attribute-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (287,28,'JSON_EXTRACT','Syntax:\nJSON_EXTRACT(json_doc, path[, path] ...)\n\nReturns data from a JSON document, selected from the parts of the\ndocument matched by the path arguments. Returns NULL if any argument is\nNULL or no paths locate a value in the document. An error occurs if the\njson_doc argument is not a valid JSON document or any path argument is\nnot a valid path expression.\n\nThe return value consists of all values matched by the path arguments.\nIf it is possible that those arguments could return multiple values,\nthe matched values are autowrapped as an array, in the order\ncorresponding to the paths that produced them. Otherwise, the return\nvalue is the single matched value.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-search-functions.html\n\n','mysql> SELECT JSON_EXTRACT(\'[10, 20, [30, 40]]\', \'$[1]\');\n+--------------------------------------------+\n| JSON_EXTRACT(\'[10, 20, [30, 40]]\', \'$[1]\') |\n+--------------------------------------------+\n| 20                                         |\n+--------------------------------------------+\nmysql> SELECT JSON_EXTRACT(\'[10, 20, [30, 40]]\', \'$[1]\', \'$[0]\');\n+----------------------------------------------------+\n| JSON_EXTRACT(\'[10, 20, [30, 40]]\', \'$[1]\', \'$[0]\') |\n+----------------------------------------------------+\n| [20, 10]                                           |\n+----------------------------------------------------+\nmysql> SELECT JSON_EXTRACT(\'[10, 20, [30, 40]]\', \'$[2][*]\');\n+-----------------------------------------------+\n| JSON_EXTRACT(\'[10, 20, [30, 40]]\', \'$[2][*]\') |\n+-----------------------------------------------+\n| [30, 40]                                      |\n+-----------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/json-search-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (288,28,'JSON_INSERT','Syntax:\nJSON_INSERT(json_doc, path, val[, path, val] ...)\n\nInserts data into a JSON document and returns the result. Returns NULL\nif any argument is NULL. An error occurs if the json_doc argument is\nnot a valid JSON document or any path argument is not a valid path\nexpression or contains a * or ** wildcard.\n\nThe path-value pairs are evaluated left to right. The document produced\nby evaluating one pair becomes the new value against which the next\npair is evaluated.\n\nA path-value pair for an existing path in the document is ignored and\ndoes not overwrite the existing document value. A path-value pair for a\nnonexisting path in the document adds the value to the document if the\npath identifies one of these types of values:\n\no A member not present in an existing object. The member is added to\n  the object and associated with the new value.\n\no A position past the end of an existing array. The array is extended\n  with the new value. If the existing value is not an array, it is\n  autowrapped as an array, then extended with the new value.\n\nOtherwise, a path-value pair for a nonexisting path in the document is\nignored and has no effect.\n\nFor a comparison of JSON_INSERT(), JSON_REPLACE(), and JSON_SET(), see\nthe discussion of JSON_SET().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-modification-functions.html\n\n','mysql> SET @j = \'{ "a": 1, "b": [2, 3]}\';\nmysql> SELECT JSON_INSERT(@j, \'$.a\', 10, \'$.c\', \'[true, false]\');\n+----------------------------------------------------+\n| JSON_INSERT(@j, \'$.a\', 10, \'$.c\', \'[true, false]\') |\n+----------------------------------------------------+\n| {"a": 1, "b": [2, 3], "c": "[true, false]"}        |\n+----------------------------------------------------+\n\nmysql> SELECT JSON_INSERT(@j, \'$.a\', 10, \'$.c\', CAST(\'[true, false]\' AS JSON));\n+------------------------------------------------------------------+\n| JSON_INSERT(@j, \'$.a\', 10, \'$.c\', CAST(\'[true, false]\' AS JSON)) |\n+------------------------------------------------------------------+\n| {"a": 1, "b": [2, 3], "c": [true, false]}                        |\n+------------------------------------------------------------------+\n1 row in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/8.0/en/json-modification-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (289,28,'JSON_KEYS','Syntax:\nJSON_KEYS(json_doc[, path])\n\nReturns the keys from the top-level value of a JSON object as a JSON\narray, or, if a path argument is given, the top-level keys from the\nselected path. Returns NULL if any argument is NULL, the json_doc\nargument is not an object, or path, if given, does not locate an\nobject. An error occurs if the json_doc argument is not a valid JSON\ndocument or the path argument is not a valid path expression or\ncontains a * or ** wildcard.\n\nThe result array is empty if the selected object is empty. If the\ntop-level value has nested subobjects, the return value does not\ninclude keys from those subobjects.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-search-functions.html\n\n','mysql> SELECT JSON_KEYS(\'{"a": 1, "b": {"c": 30}}\');\n+---------------------------------------+\n| JSON_KEYS(\'{"a": 1, "b": {"c": 30}}\') |\n+---------------------------------------+\n| ["a", "b"]                            |\n+---------------------------------------+\nmysql> SELECT JSON_KEYS(\'{"a": 1, "b": {"c": 30}}\', \'$.b\');\n+----------------------------------------------+\n| JSON_KEYS(\'{"a": 1, "b": {"c": 30}}\', \'$.b\') |\n+----------------------------------------------+\n| ["c"]                                        |\n+----------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/json-search-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (290,28,'JSON_LENGTH','Syntax:\nJSON_LENGTH(json_doc[, path])\n\nReturns the length of a JSON document, or, if a path argument is given,\nthe length of the value within the document identified by the path.\nReturns NULL if any argument is NULL or the path argument does not\nidentify a value in the document. An error occurs if the json_doc\nargument is not a valid JSON document or the path argument is not a\nvalid path expression or contains a * or ** wildcard.\n\nThe length of a document is determined as follows:\n\no The length of a scalar is 1.\n\no The length of an array is the number of array elements.\n\no The length of an object is the number of object members.\n\no The length does not count the length of nested arrays or objects.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-attribute-functions.html\n\n','mysql> SELECT JSON_LENGTH(\'[1, 2, {"a": 3}]\');\n+---------------------------------+\n| JSON_LENGTH(\'[1, 2, {"a": 3}]\') |\n+---------------------------------+\n|                               3 |\n+---------------------------------+\nmysql> SELECT JSON_LENGTH(\'{"a": 1, "b": {"c": 30}}\');\n+-----------------------------------------+\n| JSON_LENGTH(\'{"a": 1, "b": {"c": 30}}\') |\n+-----------------------------------------+\n|                                       2 |\n+-----------------------------------------+\nmysql> SELECT JSON_LENGTH(\'{"a": 1, "b": {"c": 30}}\', \'$.b\');\n+------------------------------------------------+\n| JSON_LENGTH(\'{"a": 1, "b": {"c": 30}}\', \'$.b\') |\n+------------------------------------------------+\n|                                              1 |\n+------------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/json-attribute-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (291,28,'JSON_MERGE','Syntax:\nJSON_MERGE(json_doc, json_doc[, json_doc] ...)\n\nMerges two or more JSON documents. Synonym for JSON_MERGE_PRESERVE();\ndeprecated in MySQL 8.0.3 and subject to removal in a future release.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-modification-functions.html\n\n','mysql> SELECT JSON_MERGE(\'[1, 2]\', \'[true, false]\');\n+---------------------------------------+\n| JSON_MERGE(\'[1, 2]\', \'[true, false]\') |\n+---------------------------------------+\n| [1, 2, true, false]                   |\n+---------------------------------------+\n1 row in set, 1 warning (0.00 sec)\n\nmysql> SHOW WARNINGS\\G\n*************************** 1. row ***************************\n  Level: Warning\n   Code: 1287\nMessage: \'JSON_MERGE\' is deprecated and will be removed in a future release. \\\n Please use JSON_MERGE_PRESERVE/JSON_MERGE_PATCH instead\n1 row in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/8.0/en/json-modification-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (292,28,'JSON_MERGE_PATCH()','Syntax:\nJSON_MERGE_PATCH(json_doc, json_doc[, json_doc] ...)\n\nPerforms an RFC 7396 (https://tools.ietf.org/html/rfc7396) compliant\nmerge of two or more JSON documents and returns the merged result,\nwithout preserving members having duplicate keys. Raises an error if at\nleast one of the documents passed as arguments to this function is not\nvalid.\n\n*Note*:\n\nFor an explanation and example of the differences between this function\nand JSON_MERGE_PRESERVE(), see\nhttp://dev.mysql.com/doc/refman/8.0/en/json-modification-functions.html\n#json-merge-patch-json-merge-preserve-compared.\n\nJSON_MERGE_PATCH() performs a merge as follows:\n\n1. If the first argument is not an object, the result of the merge is\n   the same as if an empty object had been merged with the second\n   argument.\n\n2. If the second argument is not an object, the result of the merge is\n   the second argument.\n\n3. If both arguments are objects, the result of the merge is an object\n   with the following members:\n\n  o All members of the first object which do not have a corresponding\n    member with the same key in the second object.\n\n  o All members of the second object which do not have a corresponding\n    key in the first object, and whose value is not the JSON null\n    literal.\n\n  o All members with a key that exists in both the first and the second\n    object, and whose value in the second object is not the JSON null\n    literal. The values of these members are the results of recursively\n    merging the value in the first object with the value in the second\n    object.\n\nFor additional information, see\nhttp://dev.mysql.com/doc/refman/8.0/en/json.html#json-normalization.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-modification-functions.html\n\n','mysql> SELECT JSON_MERGE_PATCH(\'[1, 2]\', \'[true, false]\');\n+---------------------------------------------+\n| JSON_MERGE_PATCH(\'[1, 2]\', \'[true, false]\') |\n+---------------------------------------------+\n| [true, false]                               |\n+---------------------------------------------+\n\nmysql> SELECT JSON_MERGE_PATCH(\'{"name": "x"}\', \'{"id": 47}\');\n+-------------------------------------------------+\n| JSON_MERGE_PATCH(\'{"name": "x"}\', \'{"id": 47}\') |\n+-------------------------------------------------+\n| {"id": 47, "name": "x"}                         |\n+-------------------------------------------------+\n\nmysql> SELECT JSON_MERGE_PATCH(\'1\', \'true\');\n+-------------------------------+\n| JSON_MERGE_PATCH(\'1\', \'true\') |\n+-------------------------------+\n| true                          |\n+-------------------------------+\n\nmysql> SELECT JSON_MERGE_PATCH(\'[1, 2]\', \'{"id": 47}\');\n+------------------------------------------+\n| JSON_MERGE_PATCH(\'[1, 2]\', \'{"id": 47}\') |\n+------------------------------------------+\n| {"id": 47}                               |\n+------------------------------------------+\n\nmysql> SELECT JSON_MERGE_PATCH(\'{ "a": 1, "b":2 }\',\n     >     \'{ "a": 3, "c":4 }\');\n+-----------------------------------------------------------+\n| JSON_MERGE_PATCH(\'{ "a": 1, "b":2 }\',\'{ "a": 3, "c":4 }\') |\n+-----------------------------------------------------------+\n| {"a": 3, "b": 2, "c": 4}                                  |\n+-----------------------------------------------------------+\n\nmysql> SELECT JSON_MERGE_PATCH(\'{ "a": 1, "b":2 }\',\'{ "a": 3, "c":4 }\',\n     >     \'{ "a": 5, "d":6 }\');\n+-------------------------------------------------------------------------------+\n| JSON_MERGE_PATCH(\'{ "a": 1, "b":2 }\',\'{ "a": 3, "c":4 }\',\'{ "a": 5, "d":6 }\') |\n+-------------------------------------------------------------------------------+\n| {"a": 5, "b": 2, "c": 4, "d": 6}                                              |\n+-------------------------------------------------------------------------------+\n\nmysql> SELECT JSON_MERGE_PATCH(\'{"a":1, "b":2}\', \'{"b":null}\');\n+--------------------------------------------------+\n| JSON_MERGE_PATCH(\'{"a":1, "b":2}\', \'{"b":null}\') |\n+--------------------------------------------------+\n| {"a": 1}                                         |\n+--------------------------------------------------+\n\nmysql> SELECT JSON_MERGE_PATCH(\'{"a":{"x":1}}\', \'{"a":{"y":2}}\');\n+----------------------------------------------------+\n| JSON_MERGE_PATCH(\'{"a":{"x":1}}\', \'{"a":{"y":2}}\') |\n+----------------------------------------------------+\n| {"a": {"x": 1, "y": 2}}                            |\n+----------------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/json-modification-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (293,28,'JSON_MERGE_PRESERVE()','Syntax:\nJSON_MERGE_PRESERVE(json_doc, json_doc[, json_doc] ...)\n\nMerges two or more JSON documents and returns the merged result.\nReturns NULL if any argument is NULL. An error occurs if any argument\nis not a valid JSON document.\n\nMerging takes place according to the following rules. For additional\ninformation, see\nhttp://dev.mysql.com/doc/refman/8.0/en/json.html#json-normalization.\n\no Adjacent arrays are merged to a single array.\n\no Adjacent objects are merged to a single object.\n\no A scalar value is autowrapped as an array and merged as an array.\n\no An adjacent array and object are merged by autowrapping the object as\n  an array and merging the two arrays.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-modification-functions.html\n\n','mysql> SELECT JSON_MERGE_PRESERVE(\'[1, 2]\', \'[true, false]\');\n+------------------------------------------------+\n| JSON_MERGE_PRESERVE(\'[1, 2]\', \'[true, false]\') |\n+------------------------------------------------+\n| [1, 2, true, false]                            |\n+------------------------------------------------+\n\nmysql> SELECT JSON_MERGE_PRESERVE(\'{"name": "x"}\', \'{"id": 47}\');\n+----------------------------------------------------+\n| JSON_MERGE_PRESERVE(\'{"name": "x"}\', \'{"id": 47}\') |\n+----------------------------------------------------+\n| {"id": 47, "name": "x"}                            |\n+----------------------------------------------------+\n\nmysql> SELECT JSON_MERGE_PRESERVE(\'1\', \'true\');\n+----------------------------------+\n| JSON_MERGE_PRESERVE(\'1\', \'true\') |\n+----------------------------------+\n| [1, true]                        |\n+----------------------------------+\n\nmysql> SELECT JSON_MERGE_PRESERVE(\'[1, 2]\', \'{"id": 47}\');\n+---------------------------------------------+\n| JSON_MERGE_PRESERVE(\'[1, 2]\', \'{"id": 47}\') |\n+---------------------------------------------+\n| [1, 2, {"id": 47}]                          |\n+---------------------------------------------+\n\nmysql> SELECT JSON_MERGE_PRESERVE(\'{ "a": 1, "b": 2 }\',\n     >    \'{ "a": 3, "c": 4 }\');\n+--------------------------------------------------------------+\n| JSON_MERGE_PRESERVE(\'{ "a": 1, "b": 2 }\',\'{ "a": 3, "c":4 }\') |\n+--------------------------------------------------------------+\n| {"a": [1, 3], "b": 2, "c": 4}                                |\n+--------------------------------------------------------------+\n\nmysql> SELECT JSON_MERGE_PRESERVE(\'{ "a": 1, "b": 2 }\',\'{ "a": 3, "c": 4 }\',\n     >    \'{ "a": 5, "d": 6 }\');\n+----------------------------------------------------------------------------------+\n| JSON_MERGE_PRESERVE(\'{ "a": 1, "b": 2 }\',\'{ "a": 3, "c": 4 }\',\'{ "a": 5, "d": 6 }\') |\n+----------------------------------------------------------------------------------+\n| {"a": [1, 3, 5], "b": 2, "c": 4, "d": 6}                                         |\n+----------------------------------------------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/json-modification-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (294,28,'JSON_OBJECT','Syntax:\nJSON_OBJECT([key, val[, key, val] ...])\n\nEvaluates a (possibly empty) list of key-value pairs and returns a JSON\nobject containing those pairs. An error occurs if any key name is NULL\nor the number of arguments is odd.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-creation-functions.html\n\n','mysql> SELECT JSON_OBJECT(\'id\', 87, \'name\', \'carrot\');\n+-----------------------------------------+\n| JSON_OBJECT(\'id\', 87, \'name\', \'carrot\') |\n+-----------------------------------------+\n| {"id": 87, "name": "carrot"}            |\n+-----------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/json-creation-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (295,15,'JSON_OBJECTAGG','Syntax:\nJSON_OBJECTAGG(key, value) [over_clause]\n\nTakes two column names or expressions as arguments, the first of these\nbeing used as a key and the second as a value, and returns a JSON\nobject containing key-value pairs. Returns NULL if the result contains\nno rows, or in the event of an error. An error occurs if any key name\nis NULL or the number of arguments is not equal to 2.\n\nAs of MySQL 8.0.14, this function executes as a window function if\nover_clause is present. over_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html\n\n','mysql> SELECT o_id, attribute, value FROM t3;\n+------+-----------+--------+\n| o_id | attribute | value  |\n+------+-----------+--------+\n|    2 | color     | red    |\n|    2 | fabric    | silk   |\n|    3 | color     | green  |\n|    3 | shape     | square |\n+------+-----------+--------+\n4 rows in set (0.00 sec)\n\nmysql> SELECT o_id, JSON_OBJECTAGG(attribute, value)\n       FROM t3 GROUP BY o_id;\n+------+---------------------------------------+\n| o_id | JSON_OBJECTAGG(attribute, value)      |\n+------+---------------------------------------+\n|    2 | {"color": "red", "fabric": "silk"}    |\n|    3 | {"color": "green", "shape": "square"} |\n+------+---------------------------------------+\n2 rows in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (296,28,'JSON_PRETTY','JSON_PRETTY(json_val)\n\nProvides pretty-printing of JSON values similar to that implemented in\nPHP and by other languages and database systems. The value supplied\nmust be a JSON value or a valid string representation of a JSON value.\nExtraneous whitespaces and newlines present in this value have no\neffect on the output. For a NULL value, the function returns NULL. If\nthe value is not a JSON document, or if it cannot cannot be parsed as\none, the function fails with an error.\n\nFormatting of the output from this function adheres to the following\nrules:\n\no Each array element or object member appears on a separate line,\n  indented by one additional level as compared to its parent.\n\no Each level of indentation adds two leading spaces.\n\no A comma separating individual array elements or object members is\n  printed before the newline that separates the two elements or\n  members.\n\no The key and the value of an object member are separated by a colon\n  followed by a space (\': \').\n\no An empty object or array is printed on a single line. No space is\n  printed between the opening and closing brace.\n\no Special characters in string scalars and key names are escaped\n  employing the same rules used by the JSON_QUOTE() function.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-utility-functions.html\n\n','mysql> SELECT JSON_PRETTY(\'123\'); # scalar\n+--------------------+\n| JSON_PRETTY(\'123\') |\n+--------------------+\n| 123                |\n+--------------------+\n\nmysql> SELECT JSON_PRETTY("[1,3,5]"); # array\n+------------------------+\n| JSON_PRETTY("[1,3,5]") |\n+------------------------+\n| [\n  1,\n  3,\n  5\n]      |\n+------------------------+\n\nmysql> SELECT JSON_PRETTY(\'{"a":"10","b":"15","x":"25"}\'); # object\n+---------------------------------------------+\n| JSON_PRETTY(\'{"a":"10","b":"15","x":"25"}\') |\n+---------------------------------------------+\n| {\n  "a": "10",\n  "b": "15",\n  "x": "25"\n}   |\n+---------------------------------------------+\n\nmysql> SELECT JSON_PRETTY(\'["a",1,{"key1":\n     >    "value1"},"5",     "77" ,\n     >       {"key2":["value3","valueX",\n     > "valueY"]},"j", "2"   ]\')\\G  # nested arrays and objects\n*************************** 1. row ***************************\nJSON_PRETTY(\'["a",1,{"key1":\n             "value1"},"5",     "77" ,\n                {"key2":["value3","valuex",\n          "valuey"]},"j", "2"   ]\'): [\n  "a",\n  1,\n  {\n    "key1": "value1"\n  },\n  "5",\n  "77",\n  {\n    "key2": [\n      "value3",\n      "valuex",\n      "valuey"\n    ]\n  },\n  "j",\n  "2"\n]\n','http://dev.mysql.com/doc/refman/8.0/en/json-utility-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (297,28,'JSON_QUOTE','Syntax:\nJSON_QUOTE(string)\n\nQuotes a string as a JSON value by wrapping it with double quote\ncharacters and escaping interior quote and other characters, then\nreturning the result as a utf8mb4 string. Returns NULL if the argument\nis NULL.\n\nThis function is typically used to produce a valid JSON string literal\nfor inclusion within a JSON document.\n\nCertain special characters are escaped with backslashes per the escape\nsequences shown in\nhttp://dev.mysql.com/doc/refman/8.0/en/json-modification-functions.html\n#json-unquote-character-escape-sequences.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-creation-functions.html\n\n','mysql> SELECT JSON_QUOTE(\'null\'), JSON_QUOTE(\'"null"\');\n+--------------------+----------------------+\n| JSON_QUOTE(\'null\') | JSON_QUOTE(\'"null"\') |\n+--------------------+----------------------+\n| "null"             | "\\"null\\""           |\n+--------------------+----------------------+\nmysql> SELECT JSON_QUOTE(\'[1, 2, 3]\');\n+-------------------------+\n| JSON_QUOTE(\'[1, 2, 3]\') |\n+-------------------------+\n| "[1, 2, 3]"             |\n+-------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/json-creation-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (298,28,'JSON_REMOVE','Syntax:\nJSON_REMOVE(json_doc, path[, path] ...)\n\nRemoves data from a JSON document and returns the result. Returns NULL\nif any argument is NULL. An error occurs if the json_doc argument is\nnot a valid JSON document or any path argument is not a valid path\nexpression or is $ or contains a * or ** wildcard.\n\nThe path arguments are evaluated left to right. The document produced\nby evaluating one path becomes the new value against which the next\npath is evaluated.\n\nIt is not an error if the element to be removed does not exist in the\ndocument; in that case, the path does not affect the document.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-modification-functions.html\n\n','mysql> SET @j = \'["a", ["b", "c"], "d"]\';\nmysql> SELECT JSON_REMOVE(@j, \'$[1]\');\n+-------------------------+\n| JSON_REMOVE(@j, \'$[1]\') |\n+-------------------------+\n| ["a", "d"]              |\n+-------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/json-modification-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (299,28,'JSON_REPLACE','Syntax:\nJSON_REPLACE(json_doc, path, val[, path, val] ...)\n\nReplaces existing values in a JSON document and returns the result.\nReturns NULL if any argument is NULL. An error occurs if the json_doc\nargument is not a valid JSON document or any path argument is not a\nvalid path expression or contains a * or ** wildcard.\n\nThe path-value pairs are evaluated left to right. The document produced\nby evaluating one pair becomes the new value against which the next\npair is evaluated.\n\nA path-value pair for an existing path in the document overwrites the\nexisting document value with the new value. A path-value pair for a\nnonexisting path in the document is ignored and has no effect.\n\nIn MySQL 8.0.4, the optimizer can perform a partial, in-place update of\na JSON column instead of removing the old document and writing the new\ndocument in its entirety to the column. This optimization can be\nperformed for an update statement that uses the JSON_REPLACE() function\nand meets the conditions outlined in\nhttp://dev.mysql.com/doc/refman/8.0/en/json.html#json-partial-updates.\n\nFor a comparison of JSON_INSERT(), JSON_REPLACE(), and JSON_SET(), see\nthe discussion of JSON_SET().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-modification-functions.html\n\n','mysql> SET @j = \'{ "a": 1, "b": [2, 3]}\';\nmysql> SELECT JSON_REPLACE(@j, \'$.a\', 10, \'$.c\', \'[true, false]\');\n+-----------------------------------------------------+\n| JSON_REPLACE(@j, \'$.a\', 10, \'$.c\', \'[true, false]\') |\n+-----------------------------------------------------+\n| {"a": 10, "b": [2, 3]}                              |\n+-----------------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/json-modification-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (300,28,'JSON_SEARCH','Syntax:\nJSON_SEARCH(json_doc, one_or_all, search_str[, escape_char[, path]\n...])\n\nReturns the path to the given string within a JSON document. Returns\nNULL if any of the json_doc, search_str, or path arguments are NULL; no\npath exists within the document; or search_str is not found. An error\noccurs if the json_doc argument is not a valid JSON document, any path\nargument is not a valid path expression, one_or_all is not \'one\' or\n\'all\', or escape_char is not a constant expression.\n\nThe one_or_all argument affects the search as follows:\n\no \'one\': The search terminates after the first match and returns one\n  path string. It is undefined which match is considered first.\n\no \'all\': The search returns all matching path strings such that no\n  duplicate paths are included. If there are multiple strings, they are\n  autowrapped as an array. The order of the array elements is\n  undefined.\n\nWithin the search_str search string argument, the % and _ characters\nwork as for the LIKE operator: % matches any number of characters\n(including zero characters), and _ matches exactly one character.\n\nTo specify a literal % or _ character in the search string, precede it\nby the escape character. The default is \\ if the escape_char argument\nis missing or NULL. Otherwise, escape_char must be a constant that is\nempty or one character.\n\nFor more information about matching and escape character behavior, see\nthe description of LIKE in\nhttp://dev.mysql.com/doc/refman/8.0/en/string-comparison-functions.html\n. For escape character handling, a difference from the LIKE behavior is\nthat the escape character for JSON_SEARCH() must evaluate to a constant\nat compile time, not just at execution time. For example, if\nJSON_SEARCH() is used in a prepared statement and the escape_char\nargument is supplied using a ? parameter, the parameter value might be\nconstant at execution time, but is not at compile time.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-search-functions.html\n\n','mysql> SET @j = \'["abc", [{"k": "10"}, "def"], {"x":"abc"}, {"y":"bcd"}]\';\n\nmysql> SELECT JSON_SEARCH(@j, \'one\', \'abc\');\n+-------------------------------+\n| JSON_SEARCH(@j, \'one\', \'abc\') |\n+-------------------------------+\n| "$[0]"                        |\n+-------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'abc\');\n+-------------------------------+\n| JSON_SEARCH(@j, \'all\', \'abc\') |\n+-------------------------------+\n| ["$[0]", "$[2].x"]            |\n+-------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'ghi\');\n+-------------------------------+\n| JSON_SEARCH(@j, \'all\', \'ghi\') |\n+-------------------------------+\n| NULL                          |\n+-------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'10\');\n+------------------------------+\n| JSON_SEARCH(@j, \'all\', \'10\') |\n+------------------------------+\n| "$[1][0].k"                  |\n+------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'10\', NULL, \'$\');\n+-----------------------------------------+\n| JSON_SEARCH(@j, \'all\', \'10\', NULL, \'$\') |\n+-----------------------------------------+\n| "$[1][0].k"                             |\n+-----------------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'10\', NULL, \'$[*]\');\n+--------------------------------------------+\n| JSON_SEARCH(@j, \'all\', \'10\', NULL, \'$[*]\') |\n+--------------------------------------------+\n| "$[1][0].k"                                |\n+--------------------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'10\', NULL, \'$**.k\');\n+---------------------------------------------+\n| JSON_SEARCH(@j, \'all\', \'10\', NULL, \'$**.k\') |\n+---------------------------------------------+\n| "$[1][0].k"                                 |\n+---------------------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'10\', NULL, \'$[*][0].k\');\n+-------------------------------------------------+\n| JSON_SEARCH(@j, \'all\', \'10\', NULL, \'$[*][0].k\') |\n+-------------------------------------------------+\n| "$[1][0].k"                                     |\n+-------------------------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'10\', NULL, \'$[1]\');\n+--------------------------------------------+\n| JSON_SEARCH(@j, \'all\', \'10\', NULL, \'$[1]\') |\n+--------------------------------------------+\n| "$[1][0].k"                                |\n+--------------------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'10\', NULL, \'$[1][0]\');\n+-----------------------------------------------+\n| JSON_SEARCH(@j, \'all\', \'10\', NULL, \'$[1][0]\') |\n+-----------------------------------------------+\n| "$[1][0].k"                                   |\n+-----------------------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'abc\', NULL, \'$[2]\');\n+---------------------------------------------+\n| JSON_SEARCH(@j, \'all\', \'abc\', NULL, \'$[2]\') |\n+---------------------------------------------+\n| "$[2].x"                                    |\n+---------------------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'%a%\');\n+-------------------------------+\n| JSON_SEARCH(@j, \'all\', \'%a%\') |\n+-------------------------------+\n| ["$[0]", "$[2].x"]            |\n+-------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'%b%\');\n+-------------------------------+\n| JSON_SEARCH(@j, \'all\', \'%b%\') |\n+-------------------------------+\n| ["$[0]", "$[2].x", "$[3].y"]  |\n+-------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'%b%\', NULL, \'$[0]\');\n+---------------------------------------------+\n| JSON_SEARCH(@j, \'all\', \'%b%\', NULL, \'$[0]\') |\n+---------------------------------------------+\n| "$[0]"                                      |\n+---------------------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'%b%\', NULL, \'$[2]\');\n+---------------------------------------------+\n| JSON_SEARCH(@j, \'all\', \'%b%\', NULL, \'$[2]\') |\n+---------------------------------------------+\n| "$[2].x"                                    |\n+---------------------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'%b%\', NULL, \'$[1]\');\n+---------------------------------------------+\n| JSON_SEARCH(@j, \'all\', \'%b%\', NULL, \'$[1]\') |\n+---------------------------------------------+\n| NULL                                        |\n+---------------------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'%b%\', \'\', \'$[1]\');\n+-------------------------------------------+\n| JSON_SEARCH(@j, \'all\', \'%b%\', \'\', \'$[1]\') |\n+-------------------------------------------+\n| NULL                                      |\n+-------------------------------------------+\n\nmysql> SELECT JSON_SEARCH(@j, \'all\', \'%b%\', \'\', \'$[3]\');\n+-------------------------------------------+\n| JSON_SEARCH(@j, \'all\', \'%b%\', \'\', \'$[3]\') |\n+-------------------------------------------+\n| "$[3].y"                                  |\n+-------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/json-search-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (301,28,'JSON_SET','Syntax:\nJSON_SET(json_doc, path, val[, path, val] ...)\n\nInserts or updates data in a JSON document and returns the result.\nReturns NULL if any argument is NULL or path, if given, does not locate\nan object. An error occurs if the json_doc argument is not a valid JSON\ndocument or any path argument is not a valid path expression or\ncontains a * or ** wildcard.\n\nThe path-value pairs are evaluated left to right. The document produced\nby evaluating one pair becomes the new value against which the next\npair is evaluated.\n\nA path-value pair for an existing path in the document overwrites the\nexisting document value with the new value. A path-value pair for a\nnonexisting path in the document adds the value to the document if the\npath identifies one of these types of values:\n\no A member not present in an existing object. The member is added to\n  the object and associated with the new value.\n\no A position past the end of an existing array. The array is extended\n  with the new value. If the existing value is not an array, it is\n  autowrapped as an array, then extended with the new value.\n\nOtherwise, a path-value pair for a nonexisting path in the document is\nignored and has no effect.\n\nIn MySQL 8.0.4, the optimizer can perform a partial, in-place update of\na JSON column instead of removing the old document and writing the new\ndocument in its entirety to the column. This optimization can be\nperformed for an update statement that uses the JSON_SET() function and\nmeets the conditions outlined in\nhttp://dev.mysql.com/doc/refman/8.0/en/json.html#json-partial-updates.\n\nThe JSON_SET(), JSON_INSERT(), and JSON_REPLACE() functions are\nrelated:\n\no JSON_SET() replaces existing values and adds nonexisting values.\n\no JSON_INSERT() inserts values without replacing existing values.\n\no JSON_REPLACE() replaces only existing values.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-modification-functions.html\n\n','mysql> SET @j = \'{ "a": 1, "b": [2, 3]}\';\nmysql> SELECT JSON_SET(@j, \'$.a\', 10, \'$.c\', \'[true, false]\');\n+-------------------------------------------------+\n| JSON_SET(@j, \'$.a\', 10, \'$.c\', \'[true, false]\') |\n+-------------------------------------------------+\n| {"a": 10, "b": [2, 3], "c": "[true, false]"}    |\n+-------------------------------------------------+\nmysql> SELECT JSON_INSERT(@j, \'$.a\', 10, \'$.c\', \'[true, false]\');\n+----------------------------------------------------+\n| JSON_INSERT(@j, \'$.a\', 10, \'$.c\', \'[true, false]\') |\n+----------------------------------------------------+\n| {"a": 1, "b": [2, 3], "c": "[true, false]"}        |\n+----------------------------------------------------+\nmysql> SELECT JSON_REPLACE(@j, \'$.a\', 10, \'$.c\', \'[true, false]\');\n+-----------------------------------------------------+\n| JSON_REPLACE(@j, \'$.a\', 10, \'$.c\', \'[true, false]\') |\n+-----------------------------------------------------+\n| {"a": 10, "b": [2, 3]}                              |\n+-----------------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/json-modification-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (302,28,'JSON_STORAGE_FREE','JSON_STORAGE_FREE(json_val)\n\nFor a JSON column value, this function shows how much storage space was\nfreed in its binary representation after it was updated in place using\nJSON_SET(), JSON_REPLACE(), or JSON_REMOVE(). The argument can also be\na valid JSON document or a string which can be parsed as one---either\nas a literal value or as the value of a user variable---in which case\nthe function returns 0. It returns a positive, nonzero value if the\nargument is a JSON column value which has been updated as described\npreviously, such that its binary representation takes up less space\nthan it did prior to the update. For a JSON column which has been\nupdated such that its binary representation is the same as or larger\nthan before, or if the update was not able to take advantage of a\npartial update, it returns 0; it returns NULL if the argument is NULL.\n\nIf json_val is not NULL, and neither is a valid JSON document nor can\nbe successfully parsed as one, an error results.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-utility-functions.html\n\n','mysql> CREATE TABLE jtable (jcol JSON);\nQuery OK, 0 rows affected (0.38 sec)\n\nmysql> INSERT INTO jtable VALUES\n    ->     (\'{"a": 10, "b": "wxyz", "c": "[true, false]"}\');\nQuery OK, 1 row affected (0.04 sec)\n\nmysql> SELECT * FROM jtable;\n+----------------------------------------------+\n| jcol                                         |\n+----------------------------------------------+\n| {"a": 10, "b": "wxyz", "c": "[true, false]"} |\n+----------------------------------------------+\n1 row in set (0.00 sec)\n\nmysql> UPDATE jtable\n    ->     SET jcol = JSON_SET(jcol, "$.a", 10, "$.b", "wxyz", "$.c", 1);\nQuery OK, 1 row affected (0.03 sec)\nRows matched: 1  Changed: 1  Warnings: 0\n\nmysql> SELECT * FROM jtable;\n+--------------------------------+\n| jcol                           |\n+--------------------------------+\n| {"a": 10, "b": "wxyz", "c": 1} |\n+--------------------------------+\n1 row in set (0.00 sec)\n\nmysql> SELECT JSON_STORAGE_FREE(jcol) FROM jtable;\n+-------------------------+\n| JSON_STORAGE_FREE(jcol) |\n+-------------------------+\n|                      14 |\n+-------------------------+\n1 row in set (0.00 sec)\n\nmysql> UPDATE jtable\n    ->     SET jcol = JSON_SET(jcol, "$.a", 10, "$.b", "wx", "$.c", 1);\nQuery OK, 1 row affected (0.03 sec)\nRows matched: 1  Changed: 1  Warnings: 0\n\nmysql> SELECT JSON_STORAGE_FREE(jcol) FROM jtable;\n+-------------------------+\n| JSON_STORAGE_FREE(jcol) |\n+-------------------------+\n|                      16 |\n+-------------------------+\n1 row in set (0.00 sec)\n\nmysql> UPDATE jtable SET jcol = \'{"a": 10, "b": 1}\';\nQuery OK, 1 row affected (0.05 sec)\nRows matched: 1  Changed: 1  Warnings: 0\n\nmysql> SELECT JSON_STORAGE_FREE(jcol) FROM jtable;\n+-------------------------+\n| JSON_STORAGE_FREE(jcol) |\n+-------------------------+\n|                       0 |\n+-------------------------+\n1 row in set (0.00 sec)\n\nmysql> SET @j = \'{"a": 10, "b": "wxyz", "c": "[true, false]"}\';\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SET @j = JSON_SET(@j, \'$.a\', 10, \'$.b\', \'wxyz\', \'$.c\', \'1\');\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT @j, JSON_STORAGE_FREE(@j) AS Free;\n+----------------------------------+------+\n| @j                               | Free |\n+----------------------------------+------+\n| {"a": 10, "b": "wxyz", "c": "1"} |    0 |\n+----------------------------------+------+\n1 row in set (0.00 sec)\n\nmysql> SELECT JSON_STORAGE_FREE(\'{"a": 10, "b": "wxyz", "c": "1"}\') AS Free;\n+------+\n| Free |\n+------+\n|    0 |\n+------+\n1 row in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/8.0/en/json-utility-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (303,28,'JSON_STORAGE_SIZE','JSON_STORAGE_SIZE(json_val)\n\nThis function returns the number of bytes used to store the binary\nrepresentation of a JSON document. When the argument is a JSON column,\nthis is the space used to store the JSON document as it was inserted\ninto the column, prior to any partial updates that may have been\nperformed on it afterwards. json_val must be a valid JSON document or a\nstring which can be parsed as one. In the case where it is string, the\nfunction returns the amount of storage space in the JSON binary\nrepresentation that is created by parsing the string as JSON and\nconverting it to binary. It returns NULL if the argument is NULL.\n\nAn error results when json_val is not NULL, and is not---or cannot be\nsuccessfully parsed as---a JSON document.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-utility-functions.html\n\n','mysql> CREATE TABLE jtable (jcol JSON);\nQuery OK, 0 rows affected (0.42 sec)\n\nmysql> INSERT INTO jtable VALUES\n    ->     (\'{"a": 1000, "b": "wxyz", "c": "[1, 3, 5, 7]"}\');\nQuery OK, 1 row affected (0.04 sec)\n\nmysql> SELECT\n    ->     jcol,\n    ->     JSON_STORAGE_SIZE(jcol) AS Size,\n    ->     JSON_STORAGE_FREE(jcol) AS Free\n    -> FROM jtable;\n+-----------------------------------------------+------+------+\n| jcol                                          | Size | Free |\n+-----------------------------------------------+------+------+\n| {"a": 1000, "b": "wxyz", "c": "[1, 3, 5, 7]"} |   47 |    0 |\n+-----------------------------------------------+------+------+\n1 row in set (0.00 sec)\n\nmysql> UPDATE jtable SET jcol = \n    ->     JSON_SET(jcol, "$.b", "a");\nQuery OK, 1 row affected (0.04 sec)\nRows matched: 1  Changed: 1  Warnings: 0\n\nmysql> SELECT\n    ->     jcol,\n    ->     JSON_STORAGE_SIZE(jcol) AS Size,\n    ->     JSON_STORAGE_FREE(jcol) AS Free\n    -> FROM jtable;\n+--------------------------------------------+------+------+\n| jcol                                       | Size | Free |\n+--------------------------------------------+------+------+\n| {"a": 1000, "b": "a", "c": "[1, 3, 5, 7]"} |   47 |    3 |\n+--------------------------------------------+------+------+\n1 row in set (0.00 sec)\n\nmysql> UPDATE jtable\nmysql>     SET jcol = \'{"a": 4.55, "b": "wxyz", "c": "[true, false]"}\';\nQuery OK, 1 row affected (0.04 sec)\nRows matched: 1  Changed: 1  Warnings: 0\n\nmysql> SELECT\n    ->     jcol,\n    ->     JSON_STORAGE_SIZE(jcol) AS Size,\n    ->     JSON_STORAGE_FREE(jcol) AS Free\n    -> FROM jtable;\n+------------------------------------------------+------+------+\n| jcol                                           | Size | Free |\n+------------------------------------------------+------+------+\n| {"a": 4.55, "b": "wxyz", "c": "[true, false]"} |   56 |    0 |\n+------------------------------------------------+------+------+\n1 row in set (0.00 sec)\n\nmysql> SET @j = \'[100, "sakila", [1, 3, 5], 425.05]\';\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT @j, JSON_STORAGE_SIZE(@j) AS Size;\n+------------------------------------+------+\n| @j                                 | Size |\n+------------------------------------+------+\n| [100, "sakila", [1, 3, 5], 425.05] |   45 |\n+------------------------------------+------+\n1 row in set (0.00 sec)\n\nmysql> SET @j = JSON_SET(@j, \'$[1]\', "json");\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT @j, JSON_STORAGE_SIZE(@j) AS Size;\n+----------------------------------+------+\n| @j                               | Size |\n+----------------------------------+------+\n| [100, "json", [1, 3, 5], 425.05] |   43 |\n+----------------------------------+------+\n1 row in set (0.00 sec)\n\nmysql> SET @j = JSON_SET(@j, \'$[2][0]\', JSON_ARRAY(10, 20, 30));\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT @j, JSON_STORAGE_SIZE(@j) AS Size;\n+---------------------------------------------+------+\n| @j                                          | Size |\n+---------------------------------------------+------+\n| [100, "json", [[10, 20, 30], 3, 5], 425.05] |   56 |\n+---------------------------------------------+------+\n1 row in set (0.00 sec)\n\nmysql> SELECT\n    ->     JSON_STORAGE_SIZE(\'[100, "sakila", [1, 3, 5], 425.05]\') AS A,\n    ->     JSON_STORAGE_SIZE(\'{"a": 1000, "b": "a", "c": "[1, 3, 5, 7]"}\') AS B,\n    ->     JSON_STORAGE_SIZE(\'{"a": 1000, "b": "wxyz", "c": "[1, 3, 5, 7]"}\') AS C,\n    ->     JSON_STORAGE_SIZE(\'[100, "json", [[10, 20, 30], 3, 5], 425.05]\') AS D;\n+----+----+----+----+\n| A  | B  | C  | D  |\n+----+----+----+----+\n| 45 | 44 | 47 | 56 |\n+----+----+----+----+\n1 row in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/8.0/en/json-utility-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (304,28,'JSON_TABLE','Syntax:\nJSON_TABLE(expr, path COLUMNS (column_list) [AS] alias)\n\nExtracts data from a JSON document and returns it as a relational table\nhaving the specified columns. The complete syntax for this function is\nshown here:\n\nJSON_TABLE(\n    expr,\n    path COLUMNS (column_list)\n)   [AS] alias\n\ncolumn_list:\n    column[, column][, ...]\n\ncolumn:\n    name FOR ORDINALITY\n    |  name type PATH string path [on_error] [on_empty]\n    |  name type EXISTS PATH string path\n    |  NESTED [PATH] path COLUMNS (column_list)\n\non_error:\n    {NULL | ERROR | DEFAULT json_string} ON ERROR\n\non_empty:\n    {NULL | ERROR | DEFAULT json_string} ON EMPTY\n\nexpr: This is an expression that returns JSON data. This can be a\nconstant (\'{"a":1}\'), a column (t1.json_data, given table t1 specified\nprior to JSON_TABLE() in the FROM clause), or a function call\n(JSON_EXTRACT(t1,jsn_data,\'$.post.comments\')).\n\npath: A JSON path expression, which is applied to the data source. We\nrefer to the JSON value matching the path as the row source; this is\nused to generate a row of relational data. The COLUMNS clause evaluates\nthe row source, finds specific JSON values within the row source, and\nreturns those JSON values as SQL values in individual columns of a row\nof relational data.\n\nThe alias is required. The usual rules for table aliases apply (see\nhttp://dev.mysql.com/doc/refman/8.0/en/identifiers.html).\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-table-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/json-table-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (305,28,'JSON_TYPE','Syntax:\nJSON_TYPE(json_val)\n\nReturns a utf8mb4 string indicating the type of a JSON value. This can\nbe an object, an array, or a scalar type, as shown here:\n\nmysql> SET @j = \'{"a": [10, true]}\';\nmysql> SELECT JSON_TYPE(@j);\n+---------------+\n| JSON_TYPE(@j) |\n+---------------+\n| OBJECT        |\n+---------------+\nmysql> SELECT JSON_TYPE(JSON_EXTRACT(@j, \'$.a\'));\n+------------------------------------+\n| JSON_TYPE(JSON_EXTRACT(@j, \'$.a\')) |\n+------------------------------------+\n| ARRAY                              |\n+------------------------------------+\nmysql> SELECT JSON_TYPE(JSON_EXTRACT(@j, \'$.a[0]\'));\n+---------------------------------------+\n| JSON_TYPE(JSON_EXTRACT(@j, \'$.a[0]\')) |\n+---------------------------------------+\n| INTEGER                               |\n+---------------------------------------+\nmysql> SELECT JSON_TYPE(JSON_EXTRACT(@j, \'$.a[1]\'));\n+---------------------------------------+\n| JSON_TYPE(JSON_EXTRACT(@j, \'$.a[1]\')) |\n+---------------------------------------+\n| BOOLEAN                               |\n+---------------------------------------+\n\nJSON_TYPE() returns NULL if the argument is NULL:\n\nmysql> SELECT JSON_TYPE(NULL);\n+-----------------+\n| JSON_TYPE(NULL) |\n+-----------------+\n| NULL            |\n+-----------------+\n\nAn error occurs if the argument is not a valid JSON value:\n\nmysql> SELECT JSON_TYPE(1);\nERROR 3146 (22032): Invalid data type for JSON data in argument 1\nto function json_type; a JSON string or JSON type is required.\n\nFor a non-NULL, non-error result, the following list describes the\npossible JSON_TYPE() return values:\n\no Purely JSON types:\n\n  o OBJECT: JSON objects\n\n  o ARRAY: JSON arrays\n\n  o BOOLEAN: The JSON true and false literals\n\n  o NULL: The JSON null literal\n\no Numeric types:\n\n  o INTEGER: MySQL TINYINT, SMALLINT, MEDIUMINT and INT and BIGINT\n    scalars\n\n  o DOUBLE: MySQL DOUBLE FLOAT scalars\n\n  o DECIMAL: MySQL DECIMAL and NUMERIC scalars\n\no Temporal types:\n\n  o DATETIME: MySQL DATETIME and TIMESTAMP scalars\n\n  o DATE: MySQL DATE scalars\n\n  o TIME: MySQL TIME scalars\n\no String types:\n\n  o STRING: MySQL utf8 character type scalars: CHAR, VARCHAR, TEXT,\n    ENUM, and SET\n\no Binary types:\n\n  o BLOB: MySQL binary type scalars including BINARY, VARBINARY, BLOB,\n    and BIT\n\no All other types:\n\n  o OPAQUE (raw bits)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-attribute-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/json-attribute-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (306,28,'JSON_UNQUOTE','Syntax:\nJSON_UNQUOTE(json_val)\n\nUnquotes JSON value and returns the result as a utf8mb4 string. Returns\nNULL if the argument is NULL. An error occurs if the value starts and\nends with double quotes but is not a valid JSON string literal.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-modification-functions.html\n\n','mysql> SET @j = \'"abc"\';\nmysql> SELECT @j, JSON_UNQUOTE(@j);\n+-------+------------------+\n| @j    | JSON_UNQUOTE(@j) |\n+-------+------------------+\n| "abc" | abc              |\n+-------+------------------+\nmysql> SET @j = \'[1, 2, 3]\';\nmysql> SELECT @j, JSON_UNQUOTE(@j);\n+-----------+------------------+\n| @j        | JSON_UNQUOTE(@j) |\n+-----------+------------------+\n| [1, 2, 3] | [1, 2, 3]        |\n+-----------+------------------+\n\nmysql> SELECT @@sql_mode;\n+------------+\n| @@sql_mode |\n+------------+\n|            |\n+------------+\n\nmysql> SELECT JSON_UNQUOTE(\'"\\\\t\\\\u0032"\');\n+------------------------------+\n| JSON_UNQUOTE(\'"\\\\t\\\\u0032"\') |\n+------------------------------+\n|       2                           |\n+------------------------------+\n\nmysql> SET @@sql_mode = \'NO_BACKSLASH_ESCAPES\';\nmysql> SELECT JSON_UNQUOTE(\'"\\\\t\\\\u0032"\');\n+------------------------------+\n| JSON_UNQUOTE(\'"\\\\t\\\\u0032"\') |\n+------------------------------+\n| \\t\\u0032                     |\n+------------------------------+\n\nmysql> SELECT JSON_UNQUOTE(\'"\\t\\u0032"\');\n+----------------------------+\n| JSON_UNQUOTE(\'"\\t\\u0032"\') |\n+----------------------------+\n|       2                         |\n+----------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/json-modification-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (307,28,'JSON_VALID','Syntax:\nJSON_VALID(val)\n\nReturns 0 or 1 to indicate whether a value is valid JSON. Returns NULL\nif the argument is NULL.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/json-attribute-functions.html\n\n','mysql> SELECT JSON_VALID(\'{"a": 1}\');\n+------------------------+\n| JSON_VALID(\'{"a": 1}\') |\n+------------------------+\n|                      1 |\n+------------------------+\nmysql> SELECT JSON_VALID(\'hello\'), JSON_VALID(\'"hello"\');\n+---------------------+-----------------------+\n| JSON_VALID(\'hello\') | JSON_VALID(\'"hello"\') |\n+---------------------+-----------------------+\n|                   0 |                     1 |\n+---------------------+-----------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/json-attribute-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (308,2,'KILL','Syntax:\nKILL [CONNECTION | QUERY] processlist_id\n\nEach connection to mysqld runs in a separate thread. You can kill a\nthread with the KILL processlist_id statement.\n\nThread processlist identifiers can be determined from the ID column of\nthe INFORMATION_SCHEMA PROCESSLIST table, the Id column of SHOW\nPROCESSLIST output, and the PROCESSLIST_ID column of the Performance\nSchema threads table. The value for the current thread is returned by\nthe CONNECTION_ID() function.\n\nKILL permits an optional CONNECTION or QUERY modifier:\n\no KILL CONNECTION is the same as KILL with no modifier: It terminates\n  the connection associated with the given processlist_id, after\n  terminating any statement the connection is executing.\n\no KILL QUERY terminates the statement the connection is currently\n  executing, but leaves the connection itself intact.\n\nIf you have the PROCESS privilege, you can see all threads. If you have\nthe CONNECTION_ADMIN or SUPER privilege, you can kill all threads and\nstatements. Otherwise, you can see and kill only your own threads and\nstatements.\n\nYou can also use the mysqladmin processlist and mysqladmin kill\ncommands to examine and kill threads.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/kill.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/kill.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (309,6,'LABELS','Syntax:\n[begin_label:] BEGIN\n    [statement_list]\nEND [end_label]\n\n[begin_label:] LOOP\n    statement_list\nEND LOOP [end_label]\n\n[begin_label:] REPEAT\n    statement_list\nUNTIL search_condition\nEND REPEAT [end_label]\n\n[begin_label:] WHILE search_condition DO\n    statement_list\nEND WHILE [end_label]\n\nLabels are permitted for BEGIN ... END blocks and for the LOOP, REPEAT,\nand WHILE statements. Label use for those statements follows these\nrules:\n\no begin_label must be followed by a colon.\n\no begin_label can be given without end_label. If end_label is present,\n  it must be the same as begin_label.\n\no end_label cannot be given without begin_label.\n\no Labels at the same nesting level must be distinct.\n\no Labels can be up to 16 characters long.\n\nTo refer to a label within the labeled construct, use an ITERATE or\nLEAVE statement. The following example uses those statements to\ncontinue iterating or terminate the loop:\n\nCREATE PROCEDURE doiterate(p1 INT)\nBEGIN\n  label1: LOOP\n    SET p1 = p1 + 1;\n    IF p1 < 10 THEN ITERATE label1; END IF;\n    LEAVE label1;\n  END LOOP label1;\nEND;\n\nThe scope of a block label does not include the code for handlers\ndeclared within the block. For details, see [HELP DECLARE HANDLER].\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/statement-labels.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/statement-labels.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (310,15,'LAG','LAG(expr [, N[, default]]) [null_treatment] over_clause\n\nReturns the value of expr from the row that lags (precedes) the current\nrow by N rows within its partition. If there is no such row, the return\nvalue is default. For example, if N is 3, the return value is default\nfor the first two rows. If N or default are missing, the defaults are 1\nand NULL, respectively.\n\nN must be a literal nonnegative integer. If N is 0, expr is evaluated\nfor the current row.\n\nover_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html.\nnull_treatment is as described in the section introduction.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/window-function-descriptions.html\n\n','mysql> SELECT\n         t, val,\n         LAG(val)        OVER w AS \'lag\',\n         LEAD(val)       OVER w AS \'lead\',\n         val - LAG(val)  OVER w AS \'lag diff\',\n         val - LEAD(val) OVER w AS \'lead diff\'\n       FROM series\n       WINDOW w AS (ORDER BY t);\n+----------+------+------+------+----------+-----------+\n| t        | val  | lag  | lead | lag diff | lead diff |\n+----------+------+------+------+----------+-----------+\n| 12:00:00 |  100 | NULL |  125 |     NULL |       -25 |\n| 13:00:00 |  125 |  100 |  132 |       25 |        -7 |\n| 14:00:00 |  132 |  125 |  145 |        7 |       -13 |\n| 15:00:00 |  145 |  132 |  140 |       13 |         5 |\n| 16:00:00 |  140 |  145 |  150 |       -5 |       -10 |\n| 17:00:00 |  150 |  140 |  200 |       10 |       -50 |\n| 18:00:00 |  200 |  150 | NULL |       50 |      NULL |\n+----------+------+------+------+----------+-----------+\n\nmysql> SELECT n FROM fib ORDER BY n;\n+------+\n| n    |\n+------+\n|    1 |\n|    1 |\n|    2 |\n|    3 |\n|    5 |\n|    8 |\n+------+\n\nmysql> SELECT\n         n,\n         LAG(n, 1, 0)      OVER w AS \'lag\',\n         LEAD(n, 1, 0)     OVER w AS \'lead\',\n         n + LAG(n, 1, 0)  OVER w AS \'next_n\',\n         n + LEAD(n, 1, 0) OVER w AS \'next_next_n\'\n       FROM fib\n       WINDOW w AS (ORDER BY n);\n+------+------+------+--------+-------------+\n| n    | lag  | lead | next_n | next_next_n |\n+------+------+------+--------+-------------+\n|    1 |    0 |    1 |      1 |           2 |\n|    1 |    1 |    2 |      2 |           3 |\n|    2 |    1 |    3 |      3 |           5 |\n|    3 |    2 |    5 |      5 |           8 |\n|    5 |    3 |    8 |      8 |          13 |\n|    8 |    5 |    0 |     13 |           8 |\n+------+------+------+--------+-------------+\n','http://dev.mysql.com/doc/refman/8.0/en/window-function-descriptions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (311,12,'LAST_DAY','Syntax:\nLAST_DAY(date)\n\nTakes a date or datetime value and returns the corresponding value for\nthe last day of the month. Returns NULL if the argument is invalid.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT LAST_DAY(\'2003-02-05\');\n        -> \'2003-02-28\'\nmysql> SELECT LAST_DAY(\'2004-02-05\');\n        -> \'2004-02-29\'\nmysql> SELECT LAST_DAY(\'2004-01-01 01:01:01\');\n        -> \'2004-01-31\'\nmysql> SELECT LAST_DAY(\'2003-03-32\');\n        -> NULL\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (312,23,'LAST_INSERT_ID','Syntax:\nLAST_INSERT_ID(), LAST_INSERT_ID(expr)\n\nWith no argument, LAST_INSERT_ID() returns a BIGINT UNSIGNED (64-bit)\nvalue representing the first automatically generated value successfully\ninserted for an AUTO_INCREMENT column as a result of the most recently\nexecuted INSERT statement. The value of LAST_INSERT_ID() remains\nunchanged if no rows are successfully inserted.\n\nWith an argument, LAST_INSERT_ID() returns an unsigned integer.\n\nFor example, after inserting a row that generates an AUTO_INCREMENT\nvalue, you can get the value like this:\n\nmysql> SELECT LAST_INSERT_ID();\n        -> 195\n\nThe currently executing statement does not affect the value of\nLAST_INSERT_ID(). Suppose that you generate an AUTO_INCREMENT value\nwith one statement, and then refer to LAST_INSERT_ID() in a\nmultiple-row INSERT statement that inserts rows into a table with its\nown AUTO_INCREMENT column. The value of LAST_INSERT_ID() will remain\nstable in the second statement; its value for the second and later rows\nis not affected by the earlier row insertions. (However, if you mix\nreferences to LAST_INSERT_ID() and LAST_INSERT_ID(expr), the effect is\nundefined.)\n\nIf the previous statement returned an error, the value of\nLAST_INSERT_ID() is undefined. For transactional tables, if the\nstatement is rolled back due to an error, the value of LAST_INSERT_ID()\nis left undefined. For manual ROLLBACK, the value of LAST_INSERT_ID()\nis not restored to that before the transaction; it remains as it was at\nthe point of the ROLLBACK.\n\nWithin the body of a stored routine (procedure or function) or a\ntrigger, the value of LAST_INSERT_ID() changes the same way as for\nstatements executed outside the body of these kinds of objects. The\neffect of a stored routine or trigger upon the value of\nLAST_INSERT_ID() that is seen by following statements depends on the\nkind of routine:\n\no If a stored procedure executes statements that change the value of\n  LAST_INSERT_ID(), the changed value is seen by statements that follow\n  the procedure call.\n\no For stored functions and triggers that change the value, the value is\n  restored when the function or trigger ends, so following statements\n  will not see a changed value.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/information-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (313,15,'LAST_VALUE','LAST_VALUE(expr) [null_treatment] over_clause\n\nReturns the value of expr from the last row of the window frame.\n\nover_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html.\nnull_treatment is as described in the section introduction.\n\nFor an example, see the FIRST_VALUE() function description.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/window-function-descriptions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/window-function-descriptions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (314,35,'LCASE','Syntax:\nLCASE(str)\n\nLCASE() is a synonym for LOWER().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (315,15,'LEAD','LEAD(expr [, N[, default]]) [null_treatment] over_clause\n\nReturns the value of expr from the row that leads (follows) the current\nrow by N rows within its partition. If there is no such row, the return\nvalue is default. For example, if N is 3, the return value is default\nfor the last two rows. If N or default are missing, the defaults are 1\nand NULL, respectively.\n\nN must be a literal nonnegative integer. If N is 0, expr is evaluated\nfor the current row.\n\nover_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html.\nnull_treatment is as described in the section introduction.\n\nFor an example, see the LAG() function description.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/window-function-descriptions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/window-function-descriptions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (316,4,'LEAST','Syntax:\nLEAST(value1,value2,...)\n\nWith two or more arguments, returns the smallest (minimum-valued)\nargument. The arguments are compared using the following rules:\n\no If any argument is NULL, the result is NULL. No comparison is needed.\n\no If all arguments are integer-valued, they are compared as integers.\n\no If at least one argument is double precision, they are compared as\n  double-precision values. Otherwise, if at least one argument is a\n  DECIMAL value, they are compared as DECIMAL values.\n\no If the arguments comprise a mix of numbers and strings, they are\n  compared as strings.\n\no If any argument is a nonbinary (character) string, the arguments are\n  compared as nonbinary strings.\n\no In all other cases, the arguments are compared as binary strings.\n\nThe return type of LEAST() is the aggregated type of the comparison\nargument types.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html\n\n','mysql> SELECT LEAST(2,0);\n        -> 0\nmysql> SELECT LEAST(34.0,3.0,5.0,767.0);\n        -> 3.0\nmysql> SELECT LEAST(\'B\',\'A\',\'C\');\n        -> \'A\'\n','http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (317,6,'LEAVE','Syntax:\nLEAVE label\n\nThis statement is used to exit the flow control construct that has the\ngiven label. If the label is for the outermost stored program block,\nLEAVE exits the program.\n\nLEAVE can be used within BEGIN ... END or loop constructs (LOOP,\nREPEAT, WHILE).\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/leave.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/leave.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (318,35,'LEFT','Syntax:\nLEFT(str,len)\n\nReturns the leftmost len characters from the string str, or NULL if any\nargument is NULL.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT LEFT(\'foobarbar\', 5);\n        -> \'fooba\'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (319,35,'LENGTH','Syntax:\nLENGTH(str)\n\nReturns the length of the string str, measured in bytes. A multibyte\ncharacter counts as multiple bytes. This means that for a string\ncontaining five 2-byte characters, LENGTH() returns 10, whereas\nCHAR_LENGTH() returns 5.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT LENGTH(\'text\');\n        -> 4\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (320,35,'LIKE','Syntax:\nexpr LIKE pat [ESCAPE \'escape_char\']\n\nPattern matching using an SQL pattern. Returns 1 (TRUE) or 0 (FALSE).\nIf either expr or pat is NULL, the result is NULL.\n\nThe pattern need not be a literal string. For example, it can be\nspecified as a string expression or table column.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-comparison-functions.html\n\n','mysql> SELECT \'David!\' LIKE \'David_\';\n        -> 1\nmysql> SELECT \'David!\' LIKE \'%D%v%\';\n        -> 1\n','http://dev.mysql.com/doc/refman/8.0/en/string-comparison-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (321,18,'LINESTRING','LineString(pt [, pt] ...)\n\nConstructs a LineString value from a number of Point or WKB Point\narguments. If the number of arguments is less than two, the return\nvalue is NULL.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-mysql-specific-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-mysql-specific-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (322,30,'LN','Syntax:\nLN(X)\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X.\nIf X is less than or equal to 0.0E0, the function returns NULL and a\nwarning "Invalid argument for logarithm" is reported.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT LN(2);\n        -> 0.69314718055995\nmysql> SELECT LN(-2);\n        -> NULL\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (323,10,'LOAD DATA','Syntax:\nLOAD DATA\n    [LOW_PRIORITY | CONCURRENT] [LOCAL]\n    INFILE \'file_name\'\n    [REPLACE | IGNORE]\n    INTO TABLE tbl_name\n    [PARTITION (partition_name [, partition_name] ...)]\n    [CHARACTER SET charset_name]\n    [{FIELDS | COLUMNS}\n        [TERMINATED BY \'string\']\n        [[OPTIONALLY] ENCLOSED BY \'char\']\n        [ESCAPED BY \'char\']\n    ]\n    [LINES\n        [STARTING BY \'string\']\n        [TERMINATED BY \'string\']\n    ]\n    [IGNORE number {LINES | ROWS}]\n    [(col_name_or_user_var\n        [, col_name_or_user_var] ...)]\n    [SET col_name={expr | DEFAULT},\n        [, col_name={expr | DEFAULT}] ...]\n\nThe LOAD DATA statement reads rows from a text file into a table at a\nvery high speed. LOAD DATA is the complement of SELECT ... INTO\nOUTFILE. (See http://dev.mysql.com/doc/refman/8.0/en/select-into.html.)\nTo write data from a table to a file, use SELECT ... INTO OUTFILE. To\nread the file back into a table, use LOAD DATA. The syntax of the\nFIELDS and LINES clauses is the same for both statements.\n\nYou can also load data files by using the mysqlimport utility; see\nhttp://dev.mysql.com/doc/refman/8.0/en/mysqlimport.html. mysqlimport\noperates by sending a LOAD DATA statement to the server.\n\nFor more information about the efficiency of INSERT versus LOAD DATA\nand speeding up LOAD DATA, see\nhttp://dev.mysql.com/doc/refman/8.0/en/insert-optimization.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/load-data.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/load-data.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (324,2,'LOAD INDEX','Syntax:\nLOAD INDEX INTO CACHE\n  tbl_index_list [, tbl_index_list] ...\n\ntbl_index_list:\n  tbl_name\n    [PARTITION (partition_list | ALL)]\n    [[INDEX|KEY] (index_name[, index_name] ...)]\n    [IGNORE LEAVES]\n\npartition_list:\n    partition_name[, partition_name][, ...]\n\nThe LOAD INDEX INTO CACHE statement preloads a table index into the key\ncache to which it has been assigned by an explicit CACHE INDEX\nstatement, or into the default key cache otherwise.\n\nLOAD INDEX INTO CACHE is used only for MyISAM tables. In MySQL 8.0, it\nis also supported for partitioned MyISAM tables; in addition, indexes\non partitioned tables can be preloaded for one, several, or all\npartitions.\n\nThe IGNORE LEAVES modifier causes only blocks for the nonleaf nodes of\nthe index to be preloaded.\n\nIGNORE LEAVES is also supported for partitioned MyISAM tables.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/load-index.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/load-index.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (325,10,'LOAD XML','Syntax:\nLOAD XML\n    [LOW_PRIORITY | CONCURRENT] [LOCAL]\n    INFILE \'file_name\'\n    [REPLACE | IGNORE]\n    INTO TABLE [db_name.]tbl_name\n    [CHARACTER SET charset_name]\n    [ROWS IDENTIFIED BY \'<tagname>\']\n    [IGNORE number {LINES | ROWS}]\n    [(field_name_or_user_var\n        [, field_name_or_user_var] ...)]\n    [SET col_name={expr | DEFAULT},\n        [, col_name={expr | DEFAULT}] ...]\n\nThe LOAD XML statement reads data from an XML file into a table. The\nfile_name must be given as a literal string. The tagname in the\noptional ROWS IDENTIFIED BY clause must also be given as a literal\nstring, and must be surrounded by angle brackets (< and >).\n\nLOAD XML acts as the complement of running the mysql client in XML\noutput mode (that is, starting the client with the --xml option). To\nwrite data from a table to an XML file, you can invoke the mysql client\nwith the --xml and -e options from the system shell, as shown here:\n\nshell> mysql --xml -e \'SELECT * FROM mydb.mytable\' > file.xml\n\nTo read the file back into a table, use LOAD XML. By default, the <row>\nelement is considered to be the equivalent of a database table row;\nthis can be changed using the ROWS IDENTIFIED BY clause.\n\nThis statement supports three different XML formats:\n\no Column names as attributes and column values as attribute values:\n\n<row column1="value1" column2="value2" .../>\n\no Column names as tags and column values as the content of these tags:\n\n<row>\n  <column1>value1</column1>\n  <column2>value2</column2>\n</row>\n\no Column names are the name attributes of <field> tags, and values are\n  the contents of these tags:\n\n<row>\n  <field name=\'column1\'>value1</field>\n  <field name=\'column2\'>value2</field>\n</row>\n\n  This is the format used by other MySQL tools, such as mysqldump.\n\nAll three formats can be used in the same XML file; the import routine\nautomatically detects the format for each row and interprets it\ncorrectly. Tags are matched based on the tag or attribute name and the\ncolumn name.\n\nThe following clauses work essentially the same way for LOAD XML as\nthey do for LOAD DATA:\n\no LOW_PRIORITY or CONCURRENT\n\no LOCAL\n\no REPLACE or IGNORE\n\no CHARACTER SET\n\no SET\n\nSee [HELP LOAD DATA], for more information about these clauses.\n\n(field_name_or_user_var, ...) is a list of one or more comma-separated\nXML fields or user variables. The name of a user variable used for this\npurpose must match the name of a field from the XML file, prefixed with\n@. You can use field names to select only desired fields. User\nvariables can be employed to store the corresponding field values for\nsubsequent re-use.\n\nThe IGNORE number LINES or IGNORE number ROWS clause causes the first\nnumber rows in the XML file to be skipped. It is analogous to the LOAD\nDATA statement\'s IGNORE ... LINES clause.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/load-xml.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/load-xml.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (326,35,'LOAD_FILE','Syntax:\nLOAD_FILE(file_name)\n\nReads the file and returns the file contents as a string. To use this\nfunction, the file must be located on the server host, you must specify\nthe full path name to the file, and you must have the FILE privilege.\nThe file must be readable by all and its size less than\nmax_allowed_packet bytes. If the secure_file_priv system variable is\nset to a nonempty directory name, the file to be loaded must be located\nin that directory.\n\nIf the file does not exist or cannot be read because one of the\npreceding conditions is not satisfied, the function returns NULL.\n\nThe character_set_filesystem system variable controls interpretation of\nfile names that are given as literal strings.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> UPDATE t\n            SET blob_col=LOAD_FILE(\'/tmp/picture\')\n            WHERE id=1;\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (327,12,'LOCALTIME','Syntax:\nLOCALTIME, LOCALTIME([fsp])\n\nLOCALTIME and LOCALTIME() are synonyms for NOW().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (328,12,'LOCALTIMESTAMP','Syntax:\nLOCALTIMESTAMP, LOCALTIMESTAMP([fsp])\n\nLOCALTIMESTAMP and LOCALTIMESTAMP() are synonyms for NOW().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (329,35,'LOCATE','Syntax:\nLOCATE(substr,str), LOCATE(substr,str,pos)\n\nThe first syntax returns the position of the first occurrence of\nsubstring substr in string str. The second syntax returns the position\nof the first occurrence of substring substr in string str, starting at\nposition pos. Returns 0 if substr is not in str. Returns NULL if any\nargument is NULL.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT LOCATE(\'bar\', \'foobarbar\');\n        -> 4\nmysql> SELECT LOCATE(\'xbar\', \'foobar\');\n        -> 0\nmysql> SELECT LOCATE(\'bar\', \'foobarbar\', 5);\n        -> 7\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (330,37,'LOCK','Syntax:\nLOCK TABLES\n    tbl_name [[AS] alias] lock_type\n    [, tbl_name [[AS] alias] lock_type] ...\n\nlock_type: {\n    READ [LOCAL]\n  | [LOW_PRIORITY] WRITE\n}\n\nUNLOCK TABLES\n\nMySQL enables client sessions to acquire table locks explicitly for the\npurpose of cooperating with other sessions for access to tables, or to\nprevent other sessions from modifying tables during periods when a\nsession requires exclusive access to them. A session can acquire or\nrelease locks only for itself. One session cannot acquire locks for\nanother session or release locks held by another session.\n\nLocks may be used to emulate transactions or to get more speed when\nupdating tables. This is explained in more detail in\nhttp://dev.mysql.com/doc/refman/8.0/en/lock-tables.html#lock-tables-res\ntrictions.\n\nLOCK TABLES explicitly acquires table locks for the current client\nsession. Table locks can be acquired for base tables or views. You must\nhave the LOCK TABLES privilege, and the SELECT privilege for each\nobject to be locked.\n\nFor view locking, LOCK TABLES adds all base tables used in the view to\nthe set of tables to be locked and locks them automatically. If you\nlock a table explicitly with LOCK TABLES, any tables used in triggers\nare also locked implicitly, as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/lock-tables.html#lock-tables-and\n-triggers.\n\nIf you lock a table explicitly with LOCK TABLES, any tables related by\na foreign key constraint are opened and locked implicitly. For foreign\nkey checks, a shared read-only lock (LOCK TABLES READ) is taken on\nrelated tables. For cascading updates, a shared-nothing write lock\n(LOCK TABLES WRITE) is taken on related tables that are involved in the\noperation.\n\nUNLOCK TABLES explicitly releases any table locks held by the current\nsession. LOCK TABLES implicitly releases any table locks held by the\ncurrent session before acquiring new locks.\n\nAnother use for UNLOCK TABLES is to release the global read lock\nacquired with the FLUSH TABLES WITH READ LOCK statement, which enables\nyou to lock all tables in all databases. See [HELP FLUSH]. (This is a\nvery convenient way to get backups if you have a file system such as\nVeritas that can take snapshots in time.)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/lock-tables.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/lock-tables.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (331,37,'LOCK INSTANCE FOR BACKUP','Syntax:\nLOCK INSTANCE FOR BACKUP\n\nUNLOCK INSTANCE\n\nLOCK INSTANCE FOR BACKUP acquires an instance-level backup lock that\npermits DML during an online backup while preventing operations that\ncould result in an inconsistent snapshot.\n\nExecuting the LOCK INSTANCE FOR BACKUP statement requires the\nBACKUP_ADMIN privilege. The BACKUP_ADMIN privilege is automatically\ngranted to users with the RELOAD privilege when performing an in-place\nupgrade to MySQL 8.0 from an earlier version.\n\nMultiple sessions can hold a backup lock simultaneously.\n\nUNLOCK INSTANCE releases a backup lock held by the current session. A\nbackup lock held by a session is also released if the session is\nterminated.\n\nLOCK INSTANCE FOR BACKUP prevents files from being created, renamed, or\nremoved. REPAIR TABLE TRUNCATE TABLE, OPTIMIZE TABLE, and account\nmanagement statements are blocked. See\nhttp://dev.mysql.com/doc/refman/8.0/en/account-management-sql.html.\nOperations that modify InnoDB files that are not recorded in the InnoDB\nredo log are also blocked.\n\nLOCK INSTANCE FOR BACKUP permits DDL operations that only affect\nuser-created temporary tables. In effect, files that belong to\nuser-created temporary tables can be created, renamed, or removed while\na backup lock is held. Creation of binary log files is also permitted.\n\nA backup lock acquired by LOCK INSTANCE FOR BACKUP is independent of\ntransactional locks and locks taken by FLUSH TABLES tbl_name [,\ntbl_name] ... WITH READ LOCK, and the following sequences of statements\nare permitted:\n\nLOCK INSTANCE FOR BACKUP;\nFLUSH TABLES tbl_name [, tbl_name] ... WITH READ LOCK;\nUNLOCK TABLES;\nUNLOCK INSTANCE;\n\nFLUSH TABLES tbl_name [, tbl_name] ... WITH READ LOCK;\nLOCK INSTANCE FOR BACKUP;\nUNLOCK INSTANCE;\nUNLOCK TABLES;\n\nThe lock_wait_timeout setting defines the amount of time that a LOCK\nINSTANCE FOR BACKUP statement waits to acquire a lock before giving up.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/lock-instance-for-backup.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/lock-instance-for-backup.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (332,30,'LOG','Syntax:\nLOG(X), LOG(B,X)\n\nIf called with one parameter, this function returns the natural\nlogarithm of X. If X is less than or equal to 0.0E0, the function\nreturns NULL and a warning "Invalid argument for logarithm" is\nreported.\n\nThe inverse of this function (when called with a single argument) is\nthe EXP() function.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT LOG(2);\n        -> 0.69314718055995\nmysql> SELECT LOG(-2);\n        -> NULL\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (333,30,'LOG10','Syntax:\nLOG10(X)\n\nReturns the base-10 logarithm of X. If X is less than or equal to\n0.0E0, the function returns NULL and a warning "Invalid argument for\nlogarithm" is reported.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT LOG10(2);\n        -> 0.30102999566398\nmysql> SELECT LOG10(100);\n        -> 2\nmysql> SELECT LOG10(-100);\n        -> NULL\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (334,30,'LOG2','Syntax:\nLOG2(X)\n\nReturns the base-2 logarithm of X. If X is less than or equal to 0.0E0,\nthe function returns NULL and a warning "Invalid argument for\nlogarithm" is reported.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT LOG2(65536);\n        -> 16\nmysql> SELECT LOG2(-100);\n        -> NULL\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (335,11,'LONGBLOB','LONGBLOB\n\nA BLOB column with a maximum length of 4,294,967,295 or 4GB (232 − 1)\nbytes. The effective maximum length of LONGBLOB columns depends on the\nconfigured maximum packet size in the client/server protocol and\navailable memory. Each LONGBLOB value is stored using a 4-byte length\nprefix that indicates the number of bytes in the value.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (336,11,'LONGTEXT','LONGTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nA TEXT column with a maximum length of 4,294,967,295 or 4GB (232 − 1)\ncharacters. The effective maximum length is less if the value contains\nmultibyte characters. The effective maximum length of LONGTEXT columns\nalso depends on the configured maximum packet size in the client/server\nprotocol and available memory. Each LONGTEXT value is stored using a\n4-byte length prefix that indicates the number of bytes in the value.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (337,6,'LOOP','Syntax:\n[begin_label:] LOOP\n    statement_list\nEND LOOP [end_label]\n\nLOOP implements a simple loop construct, enabling repeated execution of\nthe statement list, which consists of one or more statements, each\nterminated by a semicolon (;) statement delimiter. The statements\nwithin the loop are repeated until the loop is terminated. Usually,\nthis is accomplished with a LEAVE statement. Within a stored function,\nRETURN can also be used, which exits the function entirely.\n\nNeglecting to include a loop-termination statement results in an\ninfinite loop.\n\nA LOOP statement can be labeled. For the rules regarding label use, see\n[HELP labels].\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/loop.html\n\n','CREATE PROCEDURE doiterate(p1 INT)\nBEGIN\n  label1: LOOP\n    SET p1 = p1 + 1;\n    IF p1 < 10 THEN\n      ITERATE label1;\n    END IF;\n    LEAVE label1;\n  END LOOP label1;\n  SET @x = p1;\nEND;\n','http://dev.mysql.com/doc/refman/8.0/en/loop.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (338,35,'LOWER','Syntax:\nLOWER(str)\n\nReturns the string str with all characters changed to lowercase\naccording to the current character set mapping. The default is utf8mb4.\n\nmysql> SELECT LOWER(\'QUADRATICALLY\');\n        -> \'quadratically\'\n\nLOWER() (and UPPER()) are ineffective when applied to binary strings\n(BINARY, VARBINARY, BLOB). To perform lettercase conversion, convert\nthe string to a nonbinary string:\n\nmysql> SET @str = BINARY \'New York\';\nmysql> SELECT LOWER(@str), LOWER(CONVERT(@str USING utf8mb4));\n+-------------+------------------------------------+\n| LOWER(@str) | LOWER(CONVERT(@str USING utf8mb4)) |\n+-------------+------------------------------------+\n| New York    | new york                           |\n+-------------+------------------------------------+\n\nFor collations of Unicode character sets, LOWER() and UPPER() work\naccording to the Unicode Collation Algorithm (UCA) version in the\ncollation name, if there is one, and UCA 4.0.0 if no version is\nspecified. For example, utf8mb4_0900_ai_ci and utf8_unicode_520_ci work\naccording to UCA 9.0.0 and 5.2.0, respectively, whereas utf8_unicode_ci\nworks according to UCA 4.0.0. See\nhttp://dev.mysql.com/doc/refman/8.0/en/charset-unicode-sets.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (339,35,'LPAD','Syntax:\nLPAD(str,len,padstr)\n\nReturns the string str, left-padded with the string padstr to a length\nof len characters. If str is longer than len, the return value is\nshortened to len characters.\n\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT LPAD(\'hi\',4,\'??\');\n        -> \'??hi\'\nmysql> SELECT LPAD(\'hi\',1,\'??\');\n        -> \'h\'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (340,35,'LTRIM','Syntax:\nLTRIM(str)\n\nReturns the string str with leading space characters removed.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT LTRIM(\'  barbar\');\n        -> \'barbar\'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (341,12,'MAKEDATE','Syntax:\nMAKEDATE(year,dayofyear)\n\nReturns a date, given year and day-of-year values. dayofyear must be\ngreater than 0 or the result is NULL.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT MAKEDATE(2011,31), MAKEDATE(2011,32);\n        -> \'2011-01-31\', \'2011-02-01\'\nmysql> SELECT MAKEDATE(2011,365), MAKEDATE(2014,365);\n        -> \'2011-12-31\', \'2014-12-31\'\nmysql> SELECT MAKEDATE(2011,0);\n        -> NULL\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (342,12,'MAKETIME','Syntax:\nMAKETIME(hour,minute,second)\n\nReturns a time value calculated from the hour, minute, and second\narguments.\n\nThe second argument can have a fractional part.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT MAKETIME(12,15,30);\n        -> \'12:15:30\'\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (343,35,'MAKE_SET','Syntax:\nMAKE_SET(bits,str1,str2,...)\n\nReturns a set value (a string containing substrings separated by ,\ncharacters) consisting of the strings that have the corresponding bit\nin bits set. str1 corresponds to bit 0, str2 to bit 1, and so on. NULL\nvalues in str1, str2, ... are not appended to the result.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT MAKE_SET(1,\'a\',\'b\',\'c\');\n        -> \'a\'\nmysql> SELECT MAKE_SET(1 | 4,\'hello\',\'nice\',\'world\');\n        -> \'hello,world\'\nmysql> SELECT MAKE_SET(1 | 4,\'hello\',\'nice\',NULL,\'world\');\n        -> \'hello\'\nmysql> SELECT MAKE_SET(0,\'a\',\'b\',\'c\');\n        -> \'\'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (344,29,'MASTER_POS_WAIT','Syntax:\nMASTER_POS_WAIT(log_name,log_pos[,timeout][,channel])\n\nThis function is useful for control of master/slave synchronization. It\nblocks until the slave has read and applied all updates up to the\nspecified position in the master log. The return value is the number of\nlog events the slave had to wait for to advance to the specified\nposition. The function returns NULL if the slave SQL thread is not\nstarted, the slave\'s master information is not initialized, the\narguments are incorrect, or an error occurs. It returns -1 if the\ntimeout has been exceeded. If the slave SQL thread stops while\nMASTER_POS_WAIT() is waiting, the function returns NULL. If the slave\nis past the specified position, the function returns immediately.\n\nOn a multithreaded slave, the function waits until expiry of the limit\nset by the slave_checkpoint_group or slave_checkpoint_period system\nvariable, when the checkpoint operation is called to update the status\nof the slave. Depending on the setting for the system variables, the\nfunction might therefore return some time after the specified position\nwas reached.\n\nIf a timeout value is specified, MASTER_POS_WAIT() stops waiting when\ntimeout seconds have elapsed. timeout must be greater than 0; a zero or\nnegative timeout means no timeout.\n\nThe optional channel value enables you to name which replication\nchannel the function applies to. See\nhttp://dev.mysql.com/doc/refman/8.0/en/replication-channels.html for\nmore information.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (345,35,'MATCH AGAINST','Syntax:\nMATCH (col1,col2,...) AGAINST (expr [search_modifier])\n\nMySQL has support for full-text indexing and searching:\n\no A full-text index in MySQL is an index of type FULLTEXT.\n\no Full-text indexes can be used only with InnoDB or MyISAM tables, and\n  can be created only for CHAR, VARCHAR, or TEXT columns.\n\no MySQL provides a built-in full-text ngram parser that supports\n  Chinese, Japanese, and Korean (CJK), and an installable MeCab\n  full-text parser plugin for Japanese. Parsing differences are\n  outlined in\n  http://dev.mysql.com/doc/refman/8.0/en/fulltext-search-ngram.html,\n  and\n  http://dev.mysql.com/doc/refman/8.0/en/fulltext-search-mecab.html.\n\no A FULLTEXT index definition can be given in the CREATE TABLE\n  statement when a table is created, or added later using ALTER TABLE\n  or CREATE INDEX.\n\no For large data sets, it is much faster to load your data into a table\n  that has no FULLTEXT index and then create the index after that, than\n  to load data into a table that has an existing FULLTEXT index.\n\nFull-text searching is performed using MATCH() ... AGAINST syntax.\nMATCH() takes a comma-separated list that names the columns to be\nsearched. AGAINST takes a string to search for, and an optional\nmodifier that indicates what type of search to perform. The search\nstring must be a string value that is constant during query evaluation.\nThis rules out, for example, a table column because that can differ for\neach row.\n\nThere are three types of full-text searches:\n\no A natural language search interprets the search string as a phrase in\n  natural human language (a phrase in free text). There are no special\n  operators, with the exception of double quote (") characters. The\n  stopword list applies. For more information about stopword lists, see\n  http://dev.mysql.com/doc/refman/8.0/en/fulltext-stopwords.html.\n\n  Full-text searches are natural language searches if the IN NATURAL\n  LANGUAGE MODE modifier is given or if no modifier is given. For more\n  information, see\n  http://dev.mysql.com/doc/refman/8.0/en/fulltext-natural-language.html\n  .\n\no A boolean search interprets the search string using the rules of a\n  special query language. The string contains the words to search for.\n  It can also contain operators that specify requirements such that a\n  word must be present or absent in matching rows, or that it should be\n  weighted higher or lower than usual. Certain common words (stopwords)\n  are omitted from the search index and do not match if present in the\n  search string. The IN BOOLEAN MODE modifier specifies a boolean\n  search. For more information, see\n  http://dev.mysql.com/doc/refman/8.0/en/fulltext-boolean.html.\n\no A query expansion search is a modification of a natural language\n  search. The search string is used to perform a natural language\n  search. Then words from the most relevant rows returned by the search\n  are added to the search string and the search is done again. The\n  query returns the rows from the second search. The IN NATURAL\n  LANGUAGE MODE WITH QUERY EXPANSION or WITH QUERY EXPANSION modifier\n  specifies a query expansion search. For more information, see\n  http://dev.mysql.com/doc/refman/8.0/en/fulltext-query-expansion.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/fulltext-search.html\n\n','mysql> SELECT id, body, MATCH (title,body) AGAINST\n    (\'Security implications of running MySQL as root\'\n    IN NATURAL LANGUAGE MODE) AS score\n    FROM articles WHERE MATCH (title,body) AGAINST\n    (\'Security implications of running MySQL as root\'\n    IN NATURAL LANGUAGE MODE);\n+----+-------------------------------------+-----------------+\n| id | body                                | score           |\n+----+-------------------------------------+-----------------+\n|  4 | 1. Never run mysqld as root. 2. ... | 1.5219271183014 |\n|  6 | When configured properly, MySQL ... | 1.3114095926285 |\n+----+-------------------------------------+-----------------+\n2 rows in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/8.0/en/fulltext-search.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (346,15,'MAX','Syntax:\nMAX([DISTINCT] expr) [over_clause]\n\nReturns the maximum value of expr. MAX() may take a string argument; in\nsuch cases, it returns the maximum string value. See\nhttp://dev.mysql.com/doc/refman/8.0/en/mysql-indexes.html. The DISTINCT\nkeyword can be used to find the maximum of the distinct values of expr,\nhowever, this produces the same result as omitting DISTINCT.\n\nIf there are no matching rows, MAX() returns NULL.\n\nThis function executes as a window function if over_clause is present.\nover_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html; it\ncannot be used with DISTINCT.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html\n\n','mysql> SELECT student_name, MIN(test_score), MAX(test_score)\n       FROM student\n       GROUP BY student_name;\n','http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (347,28,'MBR DEFINITION','Its MBR (minimum bounding rectangle), or envelope. This is the bounding\ngeometry, formed by the minimum and maximum (X,Y) coordinates:\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-class-geometry.html\n\n','((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n','http://dev.mysql.com/doc/refman/8.0/en/gis-class-geometry.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (348,28,'MBRCONTAINS','MBRContains(g1, g2)\n\nReturns 1 or 0 to indicate whether the minimum bounding rectangle of g1\ncontains the minimum bounding rectangle of g2. This tests the opposite\nrelationship as MBRWithin().\n\nMBRContains() handles its arguments as described in the introduction to\nthis section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-mbr.html\n\n','mysql> SET @g1 = ST_GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nmysql> SET @g2 = ST_GeomFromText(\'Point(1 1)\');\nmysql> SELECT MBRContains(@g1,@g2), MBRWithin(@g2,@g1);\n+----------------------+--------------------+\n| MBRContains(@g1,@g2) | MBRWithin(@g2,@g1) |\n+----------------------+--------------------+\n|                    1 |                  1 |\n+----------------------+--------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-mbr.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (349,28,'MBRCOVEREDBY','MBRCoveredBy(g1, g2)\n\nReturns 1 or 0 to indicate whether the minimum bounding rectangle of g1\nis covered by the minimum bounding rectangle of g2. This tests the\nopposite relationship as MBRCovers().\n\nMBRCoveredBy() handles its arguments as described in the introduction\nto this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-mbr.html\n\n','mysql> SET @g1 = ST_GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nmysql> SET @g2 = ST_GeomFromText(\'Point(1 1)\');\nmysql> SELECT MBRCovers(@g1,@g2), MBRCoveredby(@g1,@g2);\n+--------------------+-----------------------+\n| MBRCovers(@g1,@g2) | MBRCoveredby(@g1,@g2) |\n+--------------------+-----------------------+\n|                  1 |                     0 |\n+--------------------+-----------------------+\nmysql> SELECT MBRCovers(@g2,@g1), MBRCoveredby(@g2,@g1);\n+--------------------+-----------------------+\n| MBRCovers(@g2,@g1) | MBRCoveredby(@g2,@g1) |\n+--------------------+-----------------------+\n|                  0 |                     1 |\n+--------------------+-----------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-mbr.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (350,28,'MBRCOVERS','MBRCovers(g1, g2)\n\nReturns 1 or 0 to indicate whether the minimum bounding rectangle of g1\ncovers the minimum bounding rectangle of g2. This tests the opposite\nrelationship as MBRCoveredBy(). See the description of MBRCoveredBy()\nfor examples.\n\nMBRCovers() handles its arguments as described in the introduction to\nthis section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-mbr.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-mbr.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (351,28,'MBRDISJOINT','MBRDisjoint(g1, g2)\n\nReturns 1 or 0 to indicate whether the minimum bounding rectangles of\nthe two geometries g1 and g2 are disjoint (do not intersect).\n\nMBRDisjoint() handles its arguments as described in the introduction to\nthis section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-mbr.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-mbr.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (352,28,'MBREQUALS','MBREquals(g1, g2)\n\nReturns 1 or 0 to indicate whether the minimum bounding rectangles of\nthe two geometries g1 and g2 are the same.\n\nMBREquals() handles its arguments as described in the introduction to\nthis section, except that it does not return NULL for empty geometry\narguments.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-mbr.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-mbr.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (353,28,'MBRINTERSECTS','MBRIntersects(g1, g2)\n\nReturns 1 or 0 to indicate whether the minimum bounding rectangles of\nthe two geometries g1 and g2 intersect.\n\nMBRIntersects() handles its arguments as described in the introduction\nto this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-mbr.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-mbr.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (354,28,'MBROVERLAPS','MBROverlaps(g1, g2)\n\nTwo geometries spatially overlap if they intersect and their\nintersection results in a geometry of the same dimension but not equal\nto either of the given geometries.\n\nThis function returns 1 or 0 to indicate whether the minimum bounding\nrectangles of the two geometries g1 and g2 overlap.\n\nMBROverlaps() handles its arguments as described in the introduction to\nthis section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-mbr.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-mbr.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (355,28,'MBRTOUCHES','MBRTouches(g1, g2)\n\nTwo geometries spatially touch if their interiors do not intersect, but\nthe boundary of one of the geometries intersects either the boundary or\nthe interior of the other.\n\nThis function returns 1 or 0 to indicate whether the minimum bounding\nrectangles of the two geometries g1 and g2 touch.\n\nMBRTouches() handles its arguments as described in the introduction to\nthis section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-mbr.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-mbr.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (356,28,'MBRWITHIN','MBRWithin(g1, g2)\n\nReturns 1 or 0 to indicate whether the minimum bounding rectangle of g1\nis within the minimum bounding rectangle of g2. This tests the opposite\nrelationship as MBRContains().\n\nMBRWithin() handles its arguments as described in the introduction to\nthis section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-mbr.html\n\n','mysql> SET @g1 = ST_GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nmysql> SET @g2 = ST_GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nmysql> SELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-mbr.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (357,13,'MD5','Syntax:\nMD5(str)\n\nCalculates an MD5 128-bit checksum for the string. The value is\nreturned as a string of 32 hexadecimal digits, or NULL if the argument\nwas NULL. The return value can, for example, be used as a hash key. See\nthe notes at the beginning of this section about storing hash values\nefficiently.\n\nThe return value is a string in the connection character set.\n\nIf FIPS mode is enabled, MD5() returns NULL. See\nhttp://dev.mysql.com/doc/refman/8.0/en/fips-mode.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html\n\n','mysql> SELECT MD5(\'testing\');\n        -> \'ae2b1fca515949e5d54fb22b8ed95575\'\n','http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (358,11,'MEDIUMBLOB','MEDIUMBLOB\n\nA BLOB column with a maximum length of 16,777,215 (224 − 1) bytes.\nEach MEDIUMBLOB value is stored using a 3-byte length prefix that\nindicates the number of bytes in the value.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (359,11,'MEDIUMINT','MEDIUMINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA medium-sized integer. The signed range is -8388608 to 8388607. The\nunsigned range is 0 to 16777215.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/numeric-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (360,11,'MEDIUMTEXT','MEDIUMTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nA TEXT column with a maximum length of 16,777,215 (224 − 1)\ncharacters. The effective maximum length is less if the value contains\nmultibyte characters. Each MEDIUMTEXT value is stored using a 3-byte\nlength prefix that indicates the number of bytes in the value.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (361,34,'MERGE','The MERGE storage engine, also known as the MRG_MyISAM engine, is a\ncollection of identical MyISAM tables that can be used as one.\n"Identical" means that all tables have identical column data types and\nindex information. You cannot merge MyISAM tables in which the columns\nare listed in a different order, do not have exactly the same data\ntypes in corresponding columns, or have the indexes in different order.\nHowever, any or all of the MyISAM tables can be compressed with\nmyisampack. See http://dev.mysql.com/doc/refman/8.0/en/myisampack.html.\nDifferences between tables such as these do not matter:\n\no Names of corresponding columns and indexes can differ.\n\no Comments for tables, columns, and indexes can differ.\n\no Table options such as AVG_ROW_LENGTH, MAX_ROWS, or PACK_KEYS can\n  differ.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/merge-storage-engine.html\n\n','mysql> CREATE TABLE t1 (\n    ->    a INT NOT NULL AUTO_INCREMENT PRIMARY KEY,\n    ->    message CHAR(20)) ENGINE=MyISAM;\nmysql> CREATE TABLE t2 (\n    ->    a INT NOT NULL AUTO_INCREMENT PRIMARY KEY,\n    ->    message CHAR(20)) ENGINE=MyISAM;\nmysql> INSERT INTO t1 (message) VALUES (\'Testing\'),(\'table\'),(\'t1\');\nmysql> INSERT INTO t2 (message) VALUES (\'Testing\'),(\'table\'),(\'t2\');\nmysql> CREATE TABLE total (\n    ->    a INT NOT NULL AUTO_INCREMENT,\n    ->    message CHAR(20), INDEX(a))\n    ->    ENGINE=MERGE UNION=(t1,t2) INSERT_METHOD=LAST;\n','http://dev.mysql.com/doc/refman/8.0/en/merge-storage-engine.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (362,12,'MICROSECOND','Syntax:\nMICROSECOND(expr)\n\nReturns the microseconds from the time or datetime expression expr as a\nnumber in the range from 0 to 999999.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT MICROSECOND(\'12:00:00.123456\');\n        -> 123456\nmysql> SELECT MICROSECOND(\'2019-12-31 23:59:59.000010\');\n        -> 10\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (363,35,'MID','Syntax:\nMID(str,pos,len)\n\nMID(str,pos,len) is a synonym for SUBSTRING(str,pos,len).\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (364,15,'MIN','Syntax:\nMIN([DISTINCT] expr) [over_clause]\n\nReturns the minimum value of expr. MIN() may take a string argument; in\nsuch cases, it returns the minimum string value. See\nhttp://dev.mysql.com/doc/refman/8.0/en/mysql-indexes.html. The DISTINCT\nkeyword can be used to find the minimum of the distinct values of expr,\nhowever, this produces the same result as omitting DISTINCT.\n\nIf there are no matching rows, MIN() returns NULL.\n\nThis function executes as a window function if over_clause is present.\nover_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html; it\ncannot be used with DISTINCT.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html\n\n','mysql> SELECT student_name, MIN(test_score), MAX(test_score)\n       FROM student\n       GROUP BY student_name;\n','http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (365,12,'MINUTE','Syntax:\nMINUTE(time)\n\nReturns the minute for time, in the range 0 to 59.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT MINUTE(\'2008-02-03 10:05:03\');\n        -> 5\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (366,30,'MOD','Syntax:\nMOD(N,M), N % M, N MOD M\n\nModulo operation. Returns the remainder of N divided by M.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT MOD(234, 10);\n        -> 4\nmysql> SELECT 253 % 7;\n        -> 1\nmysql> SELECT MOD(29,9);\n        -> 2\nmysql> SELECT 29 MOD 9;\n        -> 2\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (367,12,'MONTH','Syntax:\nMONTH(date)\n\nReturns the month for date, in the range 1 to 12 for January to\nDecember, or 0 for dates such as \'0000-00-00\' or \'2008-00-00\' that have\na zero month part.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT MONTH(\'2008-02-03\');\n        -> 2\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (368,12,'MONTHNAME','Syntax:\nMONTHNAME(date)\n\nReturns the full name of the month for date. The language used for the\nname is controlled by the value of the lc_time_names system variable\n(http://dev.mysql.com/doc/refman/8.0/en/locale-support.html).\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT MONTHNAME(\'2008-02-03\');\n        -> \'February\'\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (369,18,'MULTILINESTRING','MultiLineString(ls [, ls] ...)\n\nConstructs a MultiLineString value using LineString or WKB LineString\narguments.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-mysql-specific-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-mysql-specific-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (370,18,'MULTIPOINT','MultiPoint(pt [, pt2] ...)\n\nConstructs a MultiPoint value using Point or WKB Point arguments.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-mysql-specific-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-mysql-specific-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (371,18,'MULTIPOLYGON','MultiPolygon(poly [, poly] ...)\n\nConstructs a MultiPolygon value from a set of Polygon or WKB Polygon\narguments.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-mysql-specific-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-mysql-specific-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (372,29,'NAME_CONST','Syntax:\nNAME_CONST(name,value)\n\nReturns the given value. When used to produce a result set column,\nNAME_CONST() causes the column to have the given name. The arguments\nshould be constants.\n\nmysql> SELECT NAME_CONST(\'myname\', 14);\n+--------+\n| myname |\n+--------+\n|     14 |\n+--------+\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (373,4,'NOT BETWEEN','Syntax:\nexpr NOT BETWEEN min AND max\n\nThis is the same as NOT (expr BETWEEN min AND max).\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (374,4,'NOT IN','Syntax:\nexpr NOT IN (value,...)\n\nThis is the same as NOT (expr IN (value,...)).\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/comparison-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (375,35,'NOT LIKE','Syntax:\nexpr NOT LIKE pat [ESCAPE \'escape_char\']\n\nThis is the same as NOT (expr LIKE pat [ESCAPE \'escape_char\']).\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-comparison-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-comparison-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (376,35,'NOT REGEXP','Syntax:\nexpr NOT REGEXP pat, expr NOT RLIKE pat\n\nThis is the same as NOT (expr REGEXP pat).\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/regexp.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/regexp.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (377,12,'NOW','Syntax:\nNOW([fsp])\n\nReturns the current date and time as a value in \'YYYY-MM-DD HH:MM:SS\'\nor YYYYMMDDHHMMSS format, depending on whether the function is used in\na string or numeric context. The value is expressed in the current time\nzone.\n\nIf the fsp argument is given to specify a fractional seconds precision\nfrom 0 to 6, the return value includes a fractional seconds part of\nthat many digits.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT NOW();\n        -> \'2007-12-15 23:50:26\'\nmysql> SELECT NOW() + 0;\n        -> 20071215235026.000000\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (378,15,'NTH_VALUE','NTH_VALUE(expr, N) [from_first_last] [null_treatment] over_clause\n\nReturns the value of expr from the N-th row of the window frame. If\nthere is no such row, the return value is NULL.\n\nN must be a literal positive integer.\n\nfrom_first_last is part of the SQL standard, but the MySQL\nimplementation permits only FROM FIRST (which is also the default).\nThis means that calculations begin at the first row of the window. FROM\nLAST is parsed, but produces an error. To obtain the same effect as\nFROM LAST (begin calculations at the last row of the window), use ORDER\nBY to sort in reverse order.\n\nover_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html.\nnull_treatment is as described in the section introduction.\n\nFor an example, see the FIRST_VALUE() function description.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/window-function-descriptions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/window-function-descriptions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (379,15,'NTILE','NTILE(N) over_clause\n\nDivides a partition into N groups (buckets), assigns each row in the\npartition its bucket number, and returns the bucket number of the\ncurrent row within its partition. For example, if N is 4, NTILE()\ndivides rows into four buckets. If N is 100, NTILE() divides rows into\n100 buckets.\n\nN must be a literal positive integer. Bucket number return values range\nfrom 1 to N.\n\nThis function should be used with ORDER BY to sort partition rows into\nthe desired order.\n\nover_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/window-function-descriptions.html\n\n','mysql> SELECT\n         val,\n         ROW_NUMBER() OVER w AS \'row_number\',\n         NTILE(2)     OVER w AS \'ntile2\',\n         NTILE(4)     OVER w AS \'ntile4\'\n       FROM numbers\n       WINDOW w AS (ORDER BY val);\n+------+------------+--------+--------+\n| val  | row_number | ntile2 | ntile4 |\n+------+------------+--------+--------+\n|    1 |          1 |      1 |      1 |\n|    1 |          2 |      1 |      1 |\n|    2 |          3 |      1 |      1 |\n|    3 |          4 |      1 |      2 |\n|    3 |          5 |      1 |      2 |\n|    3 |          6 |      2 |      3 |\n|    4 |          7 |      2 |      3 |\n|    4 |          8 |      2 |      4 |\n|    5 |          9 |      2 |      4 |\n+------+------------+--------+--------+\n','http://dev.mysql.com/doc/refman/8.0/en/window-function-descriptions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (380,8,'NULLIF','Syntax:\nNULLIF(expr1,expr2)\n\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is\nthe same as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n\nThe return value has the same type as the first argument.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/control-flow-functions.html\n\n','mysql> SELECT NULLIF(1,1);\n        -> NULL\nmysql> SELECT NULLIF(1,2);\n        -> 1\n','http://dev.mysql.com/doc/refman/8.0/en/control-flow-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (381,35,'OCT','Syntax:\nOCT(N)\n\nReturns a string representation of the octal value of N, where N is a\nlonglong (BIGINT) number. This is equivalent to CONV(N,10,8). Returns\nNULL if N is NULL.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT OCT(12);\n        -> \'14\'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (382,35,'OCTET_LENGTH','Syntax:\nOCTET_LENGTH(str)\n\nOCTET_LENGTH() is a synonym for LENGTH().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (383,6,'OPEN','Syntax:\nOPEN cursor_name\n\nThis statement opens a previously declared cursor. For an example, see\nhttp://dev.mysql.com/doc/refman/8.0/en/cursors.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/open.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/open.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (384,36,'OPTIMIZE TABLE','Syntax:\nOPTIMIZE [NO_WRITE_TO_BINLOG | LOCAL]\n    TABLE tbl_name [, tbl_name] ...\n\nOPTIMIZE TABLE reorganizes the physical storage of table data and\nassociated index data, to reduce storage space and improve I/O\nefficiency when accessing the table. The exact changes made to each\ntable depend on the storage engine used by that table.\n\nUse OPTIMIZE TABLE in these cases, depending on the type of table:\n\no After doing substantial insert, update, or delete operations on an\n  InnoDB table that has its own .ibd file because it was created with\n  the innodb_file_per_table option enabled. The table and indexes are\n  reorganized, and disk space can be reclaimed for use by the operating\n  system.\n\no After doing substantial insert, update, or delete operations on\n  columns that are part of a FULLTEXT index in an InnoDB table. Set the\n  configuration option innodb_optimize_fulltext_only=1 first. To keep\n  the index maintenance period to a reasonable time, set the\n  innodb_ft_num_word_optimize option to specify how many words to\n  update in the search index, and run a sequence of OPTIMIZE TABLE\n  statements until the search index is fully updated.\n\no After deleting a large part of a MyISAM or ARCHIVE table, or making\n  many changes to a MyISAM or ARCHIVE table with variable-length rows\n  (tables that have VARCHAR, VARBINARY, BLOB, or TEXT columns). Deleted\n  rows are maintained in a linked list and subsequent INSERT operations\n  reuse old row positions. You can use OPTIMIZE TABLE to reclaim the\n  unused space and to defragment the data file. After extensive changes\n  to a table, this statement may also improve performance of statements\n  that use the table, sometimes significantly.\n\nThis statement requires SELECT and INSERT privileges for the table.\n\nOPTIMIZE TABLE works for InnoDB, MyISAM, and ARCHIVE tables. OPTIMIZE\nTABLE is also supported for dynamic columns of in-memory NDB tables. It\ndoes not work for fixed-width columns of in-memory tables, nor does it\nwork for Disk Data tables. The performance of OPTIMIZE on NDB Cluster\ntables can be tuned using --ndb_optimization_delay, which controls the\nlength of time to wait between processing batches of rows by OPTIMIZE\nTABLE. For more information, see Previous NDB Cluster Issues Resolved\nin NDB Cluster 7.3\n(http://dev.mysql.com/doc/refman/5.6/en/mysql-cluster-limitations-resol\nved.html).\n\nFor NDB Cluster tables, OPTIMIZE TABLE can be interrupted by (for\nexample) killing the SQL thread performing the OPTIMIZE operation.\n\nBy default, OPTIMIZE TABLE does not work for tables created using any\nother storage engine and returns a result indicating this lack of\nsupport. You can make OPTIMIZE TABLE work for other storage engines by\nstarting mysqld with the --skip-new option. In this case, OPTIMIZE\nTABLE is just mapped to ALTER TABLE.\n\nThis statement does not work with views.\n\nOPTIMIZE TABLE is supported for partitioned tables. For information\nabout using this statement with partitioned tables and table\npartitions, see\nhttp://dev.mysql.com/doc/refman/8.0/en/partitioning-maintenance.html.\n\nBy default, the server writes OPTIMIZE TABLE statements to the binary\nlog so that they replicate to replication slaves. To suppress logging,\nspecify the optional NO_WRITE_TO_BINLOG keyword or its alias LOCAL.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/optimize-table.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/optimize-table.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (385,27,'OR','Syntax:\nOR, ||\n\nLogical OR. When both operands are non-NULL, the result is 1 if any\noperand is nonzero, and 0 otherwise. With a NULL operand, the result is\n1 if the other operand is nonzero, and NULL otherwise. If both operands\nare NULL, the result is NULL.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/logical-operators.html\n\n','mysql> SELECT 1 OR 1;\n        -> 1\nmysql> SELECT 1 OR 0;\n        -> 1\nmysql> SELECT 0 OR 0;\n        -> 0\nmysql> SELECT 0 OR NULL;\n        -> NULL\nmysql> SELECT 1 OR NULL;\n        -> 1\n','http://dev.mysql.com/doc/refman/8.0/en/logical-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (386,35,'ORD','Syntax:\nORD(str)\n\nIf the leftmost character of the string str is a multibyte character,\nreturns the code for that character, calculated from the numeric values\nof its constituent bytes using this formula:\n\n  (1st byte code)\n+ (2nd byte code * 256)\n+ (3rd byte code * 256^2) ...\n\nIf the leftmost character is not a multibyte character, ORD() returns\nthe same value as the ASCII() function.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT ORD(\'2\');\n        -> 50\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (387,13,'PASSWORD','Syntax:\nPASSWORD(str)\n\nThis function was removed in MySQL 8.0.11.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (388,15,'PERCENT_RANK','PERCENT_RANK() over_clause\n\nReturns the the percentage of partition values less than the value in\nthe current row, excluding the highest value. Return values range from\n0 to 1 and represent the row relative rank, calculated as the result of\nthis formula, where rank is the row rank and rows is the number of\npartition rows:\n\n(rank - 1) / (rows - 1)\n\nThis function should be used with ORDER BY to sort partition rows into\nthe desired order. Without ORDER BY, all rows are peers.\n\nover_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html.\n\nFor an example, see the CUME_DIST() function description.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/window-function-descriptions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/window-function-descriptions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (389,12,'PERIOD_ADD','Syntax:\nPERIOD_ADD(P,N)\n\nAdds N months to period P (in the format YYMM or YYYYMM). Returns a\nvalue in the format YYYYMM. Note that the period argument P is not a\ndate value.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT PERIOD_ADD(200801,2);\n        -> 200803\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (390,12,'PERIOD_DIFF','Syntax:\nPERIOD_DIFF(P1,P2)\n\nReturns the number of months between periods P1 and P2. P1 and P2\nshould be in the format YYMM or YYYYMM. Note that the period arguments\nP1 and P2 are not date values.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT PERIOD_DIFF(200802,200703);\n        -> 11\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (391,30,'PI','Syntax:\nPI()\n\nReturns the value of π (pi). The default number of decimal places\ndisplayed is seven, but MySQL uses the full double-precision value\ninternally.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT PI();\n        -> 3.141593\nmysql> SELECT PI()+0.000000000000000000;\n        -> 3.141592653589793116\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (392,18,'POINT','Point(x, y)\n\nConstructs a Point using its coordinates.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-mysql-specific-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-mysql-specific-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (393,18,'POLYGON','Polygon(ls [, ls] ...)\n\nConstructs a Polygon value from a number of LineString or WKB\nLineString arguments. If any argument does not represent a LinearRing\n(that is, not a closed and simple LineString), the return value is\nNULL.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-mysql-specific-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-mysql-specific-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (394,35,'POSITION','Syntax:\nPOSITION(substr IN str)\n\nPOSITION(substr IN str) is a synonym for LOCATE(substr,str).\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (395,30,'POW','Syntax:\nPOW(X,Y)\n\nReturns the value of X raised to the power of Y.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT POW(2,2);\n        -> 4\nmysql> SELECT POW(2,-2);\n        -> 0.25\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (396,30,'POWER','Syntax:\nPOWER(X,Y)\n\nThis is a synonym for POW().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (397,37,'PREPARE','Syntax:\nPREPARE stmt_name FROM preparable_stmt\n\nThe PREPARE statement prepares a SQL statement and assigns it a name,\nstmt_name, by which to refer to the statement later. The prepared\nstatement is executed with EXECUTE and released with DEALLOCATE\nPREPARE. For examples, see\nhttp://dev.mysql.com/doc/refman/8.0/en/sql-syntax-prepared-statements.h\ntml.\n\nStatement names are not case-sensitive. preparable_stmt is either a\nstring literal or a user variable that contains the text of the SQL\nstatement. The text must represent a single statement, not multiple\nstatements. Within the statement, ? characters can be used as parameter\nmarkers to indicate where data values are to be bound to the query\nlater when you execute it. The ? characters should not be enclosed\nwithin quotation marks, even if you intend to bind them to string\nvalues. Parameter markers can be used only where data values should\nappear, not for SQL keywords, identifiers, and so forth.\n\nIf a prepared statement with the given name already exists, it is\ndeallocated implicitly before the new statement is prepared. This means\nthat if the new statement contains an error and cannot be prepared, an\nerror is returned and no statement with the given name exists.\n\nThe scope of a prepared statement is the session within which it is\ncreated, which as several implications:\n\no A prepared statement created in one session is not available to other\n  sessions.\n\no When a session ends, whether normally or abnormally, its prepared\n  statements no longer exist. If auto-reconnect is enabled, the client\n  is not notified that the connection was lost. For this reason,\n  clients may wish to disable auto-reconnect. See\n  http://dev.mysql.com/doc/refman/8.0/en/c-api-auto-reconnect.html.\n\no A prepared statement created within a stored program continues to\n  exist after the program finishes executing and can be executed\n  outside the program later.\n\no A statement prepared in stored program context cannot refer to stored\n  procedure or function parameters or local variables because they go\n  out of scope when the program ends and would be unavailable were the\n  statement to be executed later outside the program. As a workaround,\n  refer instead to user-defined variables, which also have session\n  scope; see\n  http://dev.mysql.com/doc/refman/8.0/en/user-variables.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/prepare.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/prepare.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (398,37,'PURGE BINARY LOGS','Syntax:\nPURGE { BINARY | MASTER } LOGS\n    { TO \'log_name\' | BEFORE datetime_expr }\n\nThe binary log is a set of files that contain information about data\nmodifications made by the MySQL server. The log consists of a set of\nbinary log files, plus an index file (see\nhttp://dev.mysql.com/doc/refman/8.0/en/binary-log.html).\n\nThe PURGE BINARY LOGS statement deletes all the binary log files listed\nin the log index file prior to the specified log file name or date.\nBINARY and MASTER are synonyms. Deleted log files also are removed from\nthe list recorded in the index file, so that the given log file becomes\nthe first in the list.\n\nThis statement has no effect if the server was not started with the\n--log-bin option to enable binary logging.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/purge-binary-logs.html\n\n','PURGE BINARY LOGS TO \'mysql-bin.010\';\nPURGE BINARY LOGS BEFORE \'2008-04-02 22:46:26\';\n','http://dev.mysql.com/doc/refman/8.0/en/purge-binary-logs.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (399,12,'QUARTER','Syntax:\nQUARTER(date)\n\nReturns the quarter of the year for date, in the range 1 to 4.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT QUARTER(\'2008-04-01\');\n        -> 2\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (400,35,'QUOTE','Syntax:\nQUOTE(str)\n\nQuotes a string to produce a result that can be used as a properly\nescaped data value in an SQL statement. The string is returned enclosed\nby single quotation marks and with each instance of backslash (\\),\nsingle quote (\'), ASCII NUL, and Control+Z preceded by a backslash. If\nthe argument is NULL, the return value is the word "NULL" without\nenclosing single quotation marks.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT QUOTE(\'Don\\\'t!\');\n        -> \'Don\\\'t!\'\nmysql> SELECT QUOTE(NULL);\n        -> NULL\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (401,30,'RADIANS','Syntax:\nRADIANS(X)\n\nReturns the argument X, converted from degrees to radians. (Note that\nπ radians equals 180 degrees.)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT RADIANS(90);\n        -> 1.5707963267949\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (402,30,'RAND','Syntax:\nRAND([N])\n\nReturns a random floating-point value v in the range 0 <= v < 1.0. To\nobtain a random integer R in the range i <= R < j, use the expression\nFLOOR(i + RAND() * (j − i)). For example, to obtain a random integer\nin the range the range 7 <= R < 12, use the following statement:\n\nSELECT FLOOR(7 + (RAND() * 5));\n\nIf an integer argument N is specified, it is used as the seed value:\n\no With a constant initializer argument, the seed is initialized once\n  when the statement is prepared, prior to execution.\n\no With a nonconstant initializer argument (such as a column name), the\n  seed is initialized with the value for each invocation of RAND().\n\nOne implication of this behavior is that for equal argument values,\nRAND(N) returns the same value each time, and thus produces a\nrepeatable sequence of column values. In the following example, the\nsequence of values produced by RAND(3) is the same both places it\noccurs.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> CREATE TABLE t (i INT);\nQuery OK, 0 rows affected (0.42 sec)\n\nmysql> INSERT INTO t VALUES(1),(2),(3);\nQuery OK, 3 rows affected (0.00 sec)\nRecords: 3  Duplicates: 0  Warnings: 0\n\nmysql> SELECT i, RAND() FROM t;\n+------+------------------+\n| i    | RAND()           |\n+------+------------------+\n|    1 | 0.61914388706828 |\n|    2 | 0.93845168309142 |\n|    3 | 0.83482678498591 |\n+------+------------------+\n3 rows in set (0.00 sec)\n\nmysql> SELECT i, RAND(3) FROM t;\n+------+------------------+\n| i    | RAND(3)          |\n+------+------------------+\n|    1 | 0.90576975597606 |\n|    2 | 0.37307905813035 |\n|    3 | 0.14808605345719 |\n+------+------------------+\n3 rows in set (0.00 sec)\n\nmysql> SELECT i, RAND() FROM t;\n+------+------------------+\n| i    | RAND()           |\n+------+------------------+\n|    1 | 0.35877890638893 |\n|    2 | 0.28941420772058 |\n|    3 | 0.37073435016976 |\n+------+------------------+\n3 rows in set (0.00 sec)\n\nmysql> SELECT i, RAND(3) FROM t;\n+------+------------------+\n| i    | RAND(3)          |\n+------+------------------+\n|    1 | 0.90576975597606 |\n|    2 | 0.37307905813035 |\n|    3 | 0.14808605345719 |\n+------+------------------+\n3 rows in set (0.01 sec)\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (403,13,'RANDOM_BYTES','Syntax:\nRANDOM_BYTES(len)\n\nThis function returns a binary string of len random bytes generated\nusing the random number generator of the SSL library. Permitted values\nof len range from 1 to 1024. For values outside that range,\nRANDOM_BYTES() generates a warning and returns NULL.\n\nRANDOM_BYTES() can be used to provide the initialization vector for the\nAES_DECRYPT() and AES_ENCRYPT() functions. For use in that context, len\nmust be at least 16. Larger values are permitted, but bytes in excess\nof 16 are ignored.\n\nRANDOM_BYTES() generates a random value, which makes its result\nnondeterministic. Consequently, statements that use this function are\nunsafe for statement-based replication.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (404,15,'RANK','RANK() over_clause\n\nReturns the rank of the current row within its partition, with gaps.\nPeers are considered ties and receive the same rank. This function does\nnot assign consecutive ranks to peer groups if groups of size greater\nthan one exist; the result is noncontiguous rank numbers.\n\nThis function should be used with ORDER BY to sort partition rows into\nthe desired order. Without ORDER BY, all rows are peers.\n\nover_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/window-function-descriptions.html\n\n','mysql> SELECT\n         val,\n         ROW_NUMBER() OVER w AS \'row_number\',\n         RANK()       OVER w AS \'rank\',\n         DENSE_RANK() OVER w AS \'dense_rank\'\n       FROM numbers\n       WINDOW w AS (ORDER BY val);\n+------+------------+------+------------+\n| val  | row_number | rank | dense_rank |\n+------+------------+------+------------+\n|    1 |          1 |    1 |          1 |\n|    1 |          2 |    1 |          1 |\n|    2 |          3 |    3 |          2 |\n|    3 |          4 |    4 |          3 |\n|    3 |          5 |    4 |          3 |\n|    3 |          6 |    4 |          3 |\n|    4 |          7 |    7 |          4 |\n|    4 |          8 |    7 |          4 |\n|    5 |          9 |    9 |          5 |\n+------+------------+------+------------+\n','http://dev.mysql.com/doc/refman/8.0/en/window-function-descriptions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (405,35,'REGEXP','Syntax:\nexpr REGEXP pat, expr RLIKE pat\n\nReturns 1 if the string expr matches the regular expression specified\nby the pattern pat, 0 otherwise. If expr or pat is NULL, the return\nvalue is NULL.\n\nREGEXP and RLIKE are synonyms for REGEXP_LIKE().\n\nFor additional information about how matching occurs, see the\ndescription for REGEXP_LIKE().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/regexp.html\n\n','mysql> SELECT \'Michael!\' REGEXP \'.*\';\n+------------------------+\n| \'Michael!\' REGEXP \'.*\' |\n+------------------------+\n|                      1 |\n+------------------------+\nmysql> SELECT \'new*\\n*line\' REGEXP \'new\\\\*.\\\\*line\';\n+---------------------------------------+\n| \'new*\\n*line\' REGEXP \'new\\\\*.\\\\*line\' |\n+---------------------------------------+\n|                                     0 |\n+---------------------------------------+\nmysql> SELECT \'a\' REGEXP \'^[a-d]\';\n+---------------------+\n| \'a\' REGEXP \'^[a-d]\' |\n+---------------------+\n|                   1 |\n+---------------------+\nmysql> SELECT \'a\' REGEXP \'A\', \'a\' REGEXP BINARY \'A\';\n+----------------+-----------------------+\n| \'a\' REGEXP \'A\' | \'a\' REGEXP BINARY \'A\' |\n+----------------+-----------------------+\n|              1 |                     0 |\n+----------------+-----------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/regexp.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (406,35,'REGEXP_INSTR','REGEXP_INSTR(expr, pat[, pos[, occurrence[, return_option[,\nmatch_type]]]])\n\nReturns the starting index of the substring of the string expr that\nmatches the regular expression specified by the pattern pat, 0 if there\nis no match. If expr or pat is NULL, the return value is NULL.\nCharacter indexes begin at 1.\n\nREGEXP_INSTR() takes these optional arguments:\n\no pos: The position in expr at which to start the search. If omitted,\n  the default is 1.\n\no occurrence: Which occurrence of a match to search for. If omitted,\n  the default is 1.\n\no return_option: Which type of position to return. If this value is 0,\n  REGEXP_INSTR() returns the position of the matched substring\'s first\n  character. If this value is 1, REGEXP_INSTR() returns the position\n  following the matched substring. If omitted, the default is 0.\n\no match_type: A string that specifies how to perform matching. The\n  meaning is as described for REGEXP_LIKE().\n\nFor additional information about how matching occurs, see the\ndescription for REGEXP_LIKE().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/regexp.html\n\n','mysql> SELECT REGEXP_INSTR(\'dog cat dog\', \'dog\');\n+------------------------------------+\n| REGEXP_INSTR(\'dog cat dog\', \'dog\') |\n+------------------------------------+\n|                                  1 |\n+------------------------------------+\nmysql> SELECT REGEXP_INSTR(\'dog cat dog\', \'dog\', 2);\n+---------------------------------------+\n| REGEXP_INSTR(\'dog cat dog\', \'dog\', 2) |\n+---------------------------------------+\n|                                     9 |\n+---------------------------------------+\nmysql> SELECT REGEXP_INSTR(\'aa aaa aaaa\', \'a{2}\');\n+-------------------------------------+\n| REGEXP_INSTR(\'aa aaa aaaa\', \'a{2}\') |\n+-------------------------------------+\n|                                   1 |\n+-------------------------------------+\nmysql> SELECT REGEXP_INSTR(\'aa aaa aaaa\', \'a{4}\');\n+-------------------------------------+\n| REGEXP_INSTR(\'aa aaa aaaa\', \'a{4}\') |\n+-------------------------------------+\n|                                   8 |\n+-------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/regexp.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (407,35,'REGEXP_LIKE','REGEXP_LIKE(expr, pat[, match_type])\n\nReturns 1 if the string expr matches the regular expression specified\nby the pattern pat, 0 otherwise. If expr or pat is NULL, the return\nvalue is NULL.\n\nThe pattern can be an extended regular expression, the syntax for which\nis discussed in\nhttp://dev.mysql.com/doc/refman/8.0/en/regexp.html#regexp-syntax. The\npattern need not be a literal string. For example, it can be specified\nas a string expression or table column.\n\nThe optional match_type argument is a string that may contain any or\nall the following characters specifying how to perform matching:\n\no c: Case sensitive matching.\n\no i: Case insensitive matching.\n\no m: Multiple-line mode. Recognize line terminators within the string.\n  The default behavior is to match line terminators only at the start\n  and end of the string expression.\n\no n: The . character matches line terminators. The default is for .\n  matching to stop at the end of a line.\n\no u: Unix-only line endings. Only the newline character is recognized\n  as a line ending by the ., ^, and $ match operators.\n\nIf characters specifying contradictory options are specified within\nmatch_type, the rightmost one takes precedence.\n\nBy default, regular expression operations use the character set and\ncollation of the expr and pat arguments when deciding the type of a\ncharacter and performing the comparison. If the arguments have\ndifferent character sets or collations, coercibility rules apply as\ndescribed in\nhttp://dev.mysql.com/doc/refman/8.0/en/charset-collation-coercibility.h\ntml. Arguments may be specified with explicit collation indicators to\nchange comparison behavior.\n\nmysql> SELECT REGEXP_LIKE(\'CamelCase\', \'CAMELCASE\');\n+---------------------------------------+\n| REGEXP_LIKE(\'CamelCase\', \'CAMELCASE\') |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\nmysql> SELECT REGEXP_LIKE(\'CamelCase\', \'CAMELCASE\' COLLATE utf8mb4_0900_as_cs);\n+------------------------------------------------------------------+\n| REGEXP_LIKE(\'CamelCase\', \'CAMELCASE\' COLLATE utf8mb4_0900_as_cs) |\n+------------------------------------------------------------------+\n|                                                                0 |\n+------------------------------------------------------------------+\n\nmatch_type may be specified with the c or i characters to override the\ndefault case sensitivity. Exception: If either argument is a binary\nstring, the arguments are handled in case-sensitive fashion as binary\nstrings, even if match_type contains the i character.\n\n*Note*:\n\nBecause MySQL uses the C escape syntax in strings (for example, \\n to\nrepresent the newline character), you must double any \\ that you use in\nyour expr and pat arguments.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/regexp.html\n\n','mysql> SELECT REGEXP_LIKE(\'Michael!\', \'.*\');\n+-------------------------------+\n| REGEXP_LIKE(\'Michael!\', \'.*\') |\n+-------------------------------+\n|                             1 |\n+-------------------------------+\nmysql> SELECT REGEXP_LIKE(\'new*\\n*line\', \'new\\\\*.\\\\*line\');\n+----------------------------------------------+\n| REGEXP_LIKE(\'new*\\n*line\', \'new\\\\*.\\\\*line\') |\n+----------------------------------------------+\n|                                            0 |\n+----------------------------------------------+\nmysql> SELECT REGEXP_LIKE(\'a\', \'^[a-d]\');\n+----------------------------+\n| REGEXP_LIKE(\'a\', \'^[a-d]\') |\n+----------------------------+\n|                          1 |\n+----------------------------+\nmysql> SELECT REGEXP_LIKE(\'a\', \'A\'), REGEXP_LIKE(\'a\', BINARY \'A\');\n+-----------------------+------------------------------+\n| REGEXP_LIKE(\'a\', \'A\') | REGEXP_LIKE(\'a\', BINARY \'A\') |\n+-----------------------+------------------------------+\n|                     1 |                            0 |\n+-----------------------+------------------------------+\n\nmysql> SELECT REGEXP_LIKE(\'abc\', \'ABC\');\n+---------------------------+\n| REGEXP_LIKE(\'abc\', \'ABC\') |\n+---------------------------+\n|                         1 |\n+---------------------------+\nmysql> SELECT REGEXP_LIKE(\'abc\', \'ABC\', \'c\');\n+--------------------------------+\n| REGEXP_LIKE(\'abc\', \'ABC\', \'c\') |\n+--------------------------------+\n|                              0 |\n+--------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/regexp.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (408,35,'REGEXP_REPLACE','REGEXP_REPLACE(expr, pat, repl[, pos[, occurrence[, match_type]]])\n\nReplaces occurrences in the string expr that match the regular\nexpression specified by the pattern pat with the replacement string\nrepl, and returns the resulting string. If expr, pat, or repl is NULL,\nthe return value is NULL.\n\nREGEXP_REPLACE() takes these optional arguments:\n\no pos: The position in expr at which to start the search. If omitted,\n  the default is 1.\n\no occurrence: Which occurrence of a match to replace. If omitted, the\n  default is 0 (which means "replace all occurrences").\n\no match_type: A string that specifies how to perform matching. The\n  meaning is as described for REGEXP_LIKE().\n\nFor additional information about how matching occurs, see the\ndescription for REGEXP_LIKE().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/regexp.html\n\n','mysql> SELECT REGEXP_REPLACE(\'a b c\', \'b\', \'X\');\n+-----------------------------------+\n| REGEXP_REPLACE(\'a b c\', \'b\', \'X\') |\n+-----------------------------------+\n| a X c                             |\n+-----------------------------------+\nmysql> SELECT REGEXP_REPLACE(\'abc def ghi\', \'[a-z]+\', \'X\', 1, 3);\n+----------------------------------------------------+\n| REGEXP_REPLACE(\'abc def ghi\', \'[a-z]+\', \'X\', 1, 3) |\n+----------------------------------------------------+\n| abc def X                                          |\n+----------------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/regexp.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (409,35,'REGEXP_SUBSTR','REGEXP_SUBSTR(expr, pat[, pos[, occurrence[, match_type]]])\n\nReturns the substring of the string expr that matches the regular\nexpression specified by the pattern pat, NULL if there is no match. If\nexpr or pat is NULL, the return value is NULL.\n\nREGEXP_SUBSTR() takes these optional arguments:\n\no pos: The position in expr at which to start the search. If omitted,\n  the default is 1.\n\no occurrence: Which occurrence of a match to search for. If omitted,\n  the default is 1.\n\no match_type: A string that specifies how to perform matching. The\n  meaning is as described for REGEXP_LIKE().\n\nFor additional information about how matching occurs, see the\ndescription for REGEXP_LIKE().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/regexp.html\n\n','mysql> SELECT REGEXP_SUBSTR(\'abc def ghi\', \'[a-z]+\');\n+----------------------------------------+\n| REGEXP_SUBSTR(\'abc def ghi\', \'[a-z]+\') |\n+----------------------------------------+\n| abc                                    |\n+----------------------------------------+\nmysql> SELECT REGEXP_SUBSTR(\'abc def ghi\', \'[a-z]+\', 1, 3);\n+----------------------------------------------+\n| REGEXP_SUBSTR(\'abc def ghi\', \'[a-z]+\', 1, 3) |\n+----------------------------------------------+\n| ghi                                          |\n+----------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/regexp.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (410,26,'RELEASE_ALL_LOCKS','Syntax:\nRELEASE_ALL_LOCKS()\n\nReleases all named locks held by the current session and returns the\nnumber of locks released (0 if there were none)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/locking-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/locking-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (411,26,'RELEASE_LOCK','Syntax:\nRELEASE_LOCK(str)\n\nReleases the lock named by the string str that was obtained with\nGET_LOCK(). Returns 1 if the lock was released, 0 if the lock was not\nestablished by this thread (in which case the lock is not released),\nand NULL if the named lock did not exist. The lock does not exist if it\nwas never obtained by a call to GET_LOCK() or if it has previously been\nreleased.\n\nThe DO statement is convenient to use with RELEASE_LOCK(). See [HELP\nDO].\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/locking-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/locking-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (412,9,'RENAME TABLE','Syntax:\nRENAME TABLE\n    tbl_name TO new_tbl_name\n    [, tbl_name2 TO new_tbl_name2] ...\n\nRENAME TABLE renames one or more tables. You must have ALTER and DROP\nprivileges for the original table, and CREATE and INSERT privileges for\nthe new table.\n\nFor example, to rename a table named old_table to to new_table, use\nthis statement:\n\nRENAME TABLE old_table TO new_table;\n\nThat statement is equivalent to the following ALTER TABLE statement:\n\nALTER TABLE old_table RENAME new_table;\n\nRENAME TABLE, unlike ALTER TABLE, can rename multiple tables within a\nsingle statement:\n\nRENAME TABLE old_table1 TO new_table1,\n             old_table2 TO new_table2,\n             old_table3 TO new_table3;\n\nRenaming operations are performed left to right. Thus, to swap two\ntable names, do this (assuming that a table with the intermediary name\ntmp_table does not already exist):\n\nRENAME TABLE old_table TO tmp_table,\n             new_table TO old_table,\n             tmp_table TO new_table;\n\nMetadata locks on tables are acquired in name order, which in some\ncases can make a difference in operation outcome when multiple\ntransactions execute concurrently. See\nhttp://dev.mysql.com/doc/refman/8.0/en/metadata-locking.html.\n\nAs of MySQL 8.0.13, you can rename tables locked with a LOCK TABLES\nstatement, provided that they are locked with a WRITE lock or are the\nproduct of renaming WRITE-locked tables from earlier steps in a\nmultiple-table rename operation. For example, this is permitted:\n\nLOCK TABLE old_table1 WRITE;\nRENAME TABLE old_table1 TO new_table1,\n             new_table1 TO new_table2;\n\nThis is not permitted:\n\nLOCK TABLE old_table1 READ;\nRENAME TABLE old_table1 TO new_table1,\n             new_table1 TO new_table2;\n\nPrior to MySQL 8.0.13, to execute RENAME TABLE, there must be no tables\nlocked with LOCK TABLES.\n\nWith the transaction table locking conditions satisfied, the rename\noperation is done atomically; no other session can access any of the\ntables while the rename is in progress.\n\nIf any errors occur during a RENAME TABLE, the statement fails and no\nchanges are made.\n\nYou can use RENAME TABLE to move a table from one database to another:\n\nRENAME TABLE current_db.tbl_name TO other_db.tbl_name;\n\nUsing this method to move all tables from one database to a different\none in effect renames the database (an operation for which MySQL has no\nsingle statement), except that the original database continues to\nexist, albeit with no tables.\n\nLike RENAME TABLE, ALTER TABLE ... RENAME can also be used to move a\ntable to a different database. Regardless of the statement used, if the\nrename operation would move the table to a database located on a\ndifferent file system, the success of the outcome is platform specific\nand depends on the underlying operating system calls used to move table\nfiles.\n\nIf a table has triggers, attempts to rename the table into a different\ndatabase fail with a Trigger in wrong schema (ER_TRG_IN_WRONG_SCHEMA)\nerror.\n\nTo rename TEMPORARY tables, RENAME TABLE does not work. Use ALTER TABLE\ninstead.\n\nRENAME TABLE works for views, except that views cannot be renamed into\na different database.\n\nAny privileges granted specifically for a renamed table or view are not\nmigrated to the new name. They must be changed manually.\n\nRENAME TABLE tbl_name TO new_tbl_name changes internally generated\nforeign key constraint names and user-defined foreign key constraint\nnames that begin with the string "tbl_name_ibfk_" to reflect the new\ntable name. InnoDB interprets foreign key constraint names that begin\nwith the string "tbl_name_ibfk_" as internally generated names.\n\nForeign key constraint names that point to the renamed table are\nautomatically updated unless there is a conflict, in which case the\nstatement fails with an error. A conflict occurs if the renamed\nconstraint name already exists. In such cases, you must drop and\nre-create the foreign keys for them to function properly.\n\nRENAME TABLE tbl_name TO new_tbl_name changes internally generated and\nuser-defined CHECK constraint names that begin with the string\n"tbl_name_chk_" to reflect the new table name. MySQL interprets CHECK\nconstraint names that begin with the string "tbl_name_chk_" as\ninternally generated names. Example:\n\nmysql> SHOW CREATE TABLE t1\\G\n*************************** 1. row ***************************\n       Table: t1\nCreate Table: CREATE TABLE `t1` (\n  `i1` int(11) DEFAULT NULL,\n  `i2` int(11) DEFAULT NULL,\n  CONSTRAINT `t1_chk_1` CHECK ((`i1` > 0)),\n  CONSTRAINT `t1_chk_2` CHECK ((`i2` < 0))\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci\n1 row in set (0.02 sec)\n\nmysql> RENAME TABLE t1 TO t3;\nQuery OK, 0 rows affected (0.03 sec)\n\nmysql> SHOW CREATE TABLE t3\\G\n*************************** 1. row ***************************\n       Table: t3\nCreate Table: CREATE TABLE `t3` (\n  `i1` int(11) DEFAULT NULL,\n  `i2` int(11) DEFAULT NULL,\n  CONSTRAINT `t3_chk_1` CHECK ((`i1` > 0)),\n  CONSTRAINT `t3_chk_2` CHECK ((`i2` < 0))\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci\n1 row in set (0.01 sec)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/rename-table.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/rename-table.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (413,1,'RENAME USER','Syntax:\nRENAME USER old_user TO new_user\n    [, old_user TO new_user] ...\n\nThe RENAME USER statement renames existing MySQL accounts. An error\noccurs for old accounts that do not exist or new accounts that already\nexist.\n\nTo use RENAME USER, you must have the global CREATE USER privilege, or\nthe UPDATE privilege for the mysql system database. When the read_only\nsystem variable is enabled, RENAME USER additionally requires the\nCONNECTION_ADMIN or SUPER privilege.\n\nEach account name uses the format described in\nhttp://dev.mysql.com/doc/refman/8.0/en/account-names.html. For example:\n\nRENAME USER \'jeffrey\'@\'localhost\' TO \'jeff\'@\'127.0.0.1\';\n\nThe host name part of the account name, if omitted, defaults to \'%\'.\n\nRENAME USER causes the privileges held by the old user to be those held\nby the new user. However, RENAME USER does not automatically drop or\ninvalidate databases or objects within them that the old user created.\nThis includes stored programs or views for which the DEFINER attribute\nnames the old user. Attempts to access such objects may produce an\nerror if they execute in definer security context. (For information\nabout security context, see\nhttp://dev.mysql.com/doc/refman/8.0/en/stored-programs-security.html.)\n\nThe privilege changes take effect as indicated in\nhttp://dev.mysql.com/doc/refman/8.0/en/privilege-changes.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/rename-user.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/rename-user.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (414,36,'REPAIR TABLE','Syntax:\nREPAIR [NO_WRITE_TO_BINLOG | LOCAL]\n    TABLE tbl_name [, tbl_name] ...\n    [QUICK] [EXTENDED] [USE_FRM]\n\nREPAIR TABLE repairs a possibly corrupted table, for certain storage\nengines only.\n\nThis statement requires SELECT and INSERT privileges for the table.\n\nAlthough normally you should never have to run REPAIR TABLE, if\ndisaster strikes, this statement is very likely to get back all your\ndata from a MyISAM table. If your tables become corrupted often, try to\nfind the reason for it, to eliminate the need to use REPAIR TABLE. See\nhttp://dev.mysql.com/doc/refman/8.0/en/crashing.html, and\nhttp://dev.mysql.com/doc/refman/8.0/en/myisam-table-problems.html.\n\nREPAIR TABLE checks the table to see whether an upgrade is required. If\nso, it performs the upgrade, following the same rules as CHECK TABLE\n... FOR UPGRADE. See [HELP CHECK TABLE], for more information.\n\n*Important*:\n\no Make a backup of a table before performing a table repair operation;\n  under some circumstances the operation might cause data loss.\n  Possible causes include but are not limited to file system errors.\n  See http://dev.mysql.com/doc/refman/8.0/en/backup-and-recovery.html.\n\no If the server crashes during a REPAIR TABLE operation, it is\n  essential after restarting it that you immediately execute another\n  REPAIR TABLE statement for the table before performing any other\n  operations on it. In the worst case, you might have a new clean index\n  file without information about the data file, and then the next\n  operation you perform could overwrite the data file. This is an\n  unlikely but possible scenario that underscores the value of making a\n  backup first.\n\no In the event that a table on the master becomes corrupted and you run\n  REPAIR TABLE on it, any resulting changes to the original table are\n  not propagated to slaves.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/repair-table.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/repair-table.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (415,35,'REPEAT FUNCTION','Syntax:\nREPEAT(str,count)\n\nReturns a string consisting of the string str repeated count times. If\ncount is less than 1, returns an empty string. Returns NULL if str or\ncount are NULL.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT REPEAT(\'MySQL\', 3);\n        -> \'MySQLMySQLMySQL\'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (416,6,'REPEAT LOOP','Syntax:\n[begin_label:] REPEAT\n    statement_list\nUNTIL search_condition\nEND REPEAT [end_label]\n\nThe statement list within a REPEAT statement is repeated until the\nsearch_condition expression is true. Thus, a REPEAT always enters the\nloop at least once. statement_list consists of one or more statements,\neach terminated by a semicolon (;) statement delimiter.\n\nA REPEAT statement can be labeled. For the rules regarding label use,\nsee [HELP labels].\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/repeat.html\n\n','mysql> delimiter //\n\nmysql> CREATE PROCEDURE dorepeat(p1 INT)\n       BEGIN\n         SET @x = 0;\n         REPEAT\n           SET @x = @x + 1;\n         UNTIL @x > p1 END REPEAT;\n       END\n       //\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> CALL dorepeat(1000)//\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT @x//\n+------+\n| @x   |\n+------+\n| 1001 |\n+------+\n1 row in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/8.0/en/repeat.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (417,10,'REPLACE','Syntax:\nREPLACE [LOW_PRIORITY | DELAYED]\n    [INTO] tbl_name\n    [PARTITION (partition_name [, partition_name] ...)]\n    [(col_name [, col_name] ...)]\n    {VALUES | VALUE} (value_list) [, (value_list)] ...\n\nREPLACE [LOW_PRIORITY | DELAYED]\n    [INTO] tbl_name\n    [PARTITION (partition_name [, partition_name] ...)]\n    SET assignment_list\n\nREPLACE [LOW_PRIORITY | DELAYED]\n    [INTO] tbl_name\n    [PARTITION (partition_name [, partition_name] ...)]\n    [(col_name [, col_name] ...)]\n    SELECT ...\n\nvalue:\n    {expr | DEFAULT}\n\nvalue_list:\n    value [, value] ...\n\nassignment:\n    col_name = value\n\nassignment_list:\n    assignment [, assignment] ...\n\nREPLACE works exactly like INSERT, except that if an old row in the\ntable has the same value as a new row for a PRIMARY KEY or a UNIQUE\nindex, the old row is deleted before the new row is inserted. See [HELP\nINSERT].\n\nREPLACE is a MySQL extension to the SQL standard. It either inserts, or\ndeletes and inserts. For another MySQL extension to standard SQL---that\neither inserts or updates---see\nhttp://dev.mysql.com/doc/refman/8.0/en/insert-on-duplicate.html.\n\nDELAYED inserts and replaces were deprecated in MySQL 5.6. In MySQL\n8.0, DELAYED is not supported. The server recognizes but ignores the\nDELAYED keyword, handles the replace as a nondelayed replace, and\ngenerates an ER_WARN_LEGACY_SYNTAX_CONVERTED warning. ("REPLACE DELAYED\nis no longer supported. The statement was converted to REPLACE.") The\nDELAYED keyword will be removed in a future release.\n\n*Note*:\n\nREPLACE makes sense only if a table has a PRIMARY KEY or UNIQUE index.\nOtherwise, it becomes equivalent to INSERT, because there is no index\nto be used to determine whether a new row duplicates another.\n\nValues for all columns are taken from the values specified in the\nREPLACE statement. Any missing columns are set to their default values,\njust as happens for INSERT. You cannot refer to values from the current\nrow and use them in the new row. If you use an assignment such as SET\ncol_name = col_name + 1, the reference to the column name on the right\nhand side is treated as DEFAULT(col_name), so the assignment is\nequivalent to SET col_name = DEFAULT(col_name) + 1.\n\nTo use REPLACE, you must have both the INSERT and DELETE privileges for\nthe table.\n\nIf a generated column is replaced explicitly, the only permitted value\nis DEFAULT. For information about generated columns, see\nhttp://dev.mysql.com/doc/refman/8.0/en/create-table-generated-columns.h\ntml.\n\nREPLACE supports explicit partition selection using the PARTITION\nkeyword with a list of comma-separated names of partitions,\nsubpartitions, or both. As with INSERT, if it is not possible to insert\nthe new row into any of these partitions or subpartitions, the REPLACE\nstatement fails with the error Found a row not matching the given\npartition set. For more information and examples, see\nhttp://dev.mysql.com/doc/refman/8.0/en/partitioning-selection.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/replace.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/replace.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (418,35,'REPLACE FUNCTION','Syntax:\nREPLACE(str,from_str,to_str)\n\nReturns the string str with all occurrences of the string from_str\nreplaced by the string to_str. REPLACE() performs a case-sensitive\nmatch when searching for from_str.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT REPLACE(\'www.mysql.com\', \'w\', \'Ww\');\n        -> \'WwWwWw.mysql.com\'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (419,2,'RESET','Syntax:\nRESET reset_option [, reset_option] ...\n\nreset_option: {\n    MASTER\n  | SLAVE\n}\n\nThe RESET statement is used to clear the state of various server\noperations. You must have the RELOAD privilege to execute RESET.\n\nFor information about the RESET PERSIST statement that removes\npersisted global system variables, see [HELP RESET PERSIST].\n\nRESET acts as a stronger version of the FLUSH statement. See [HELP\nFLUSH].\n\nThe RESET statement causes an implicit commit. See\nhttp://dev.mysql.com/doc/refman/8.0/en/implicit-commit.html.\n\nThe following list describes the permitted RESET statement reset_option\nvalues:\n\no RESET MASTER\n\n  Deletes all binary logs listed in the index file, resets the binary\n  log index file to be empty, and creates a new binary log file.\n\no RESET SLAVE\n\n  Makes the slave forget its replication position in the master binary\n  logs. Also resets the relay log by deleting any existing relay log\n  files and beginning a new one.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/reset.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/reset.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (420,37,'RESET MASTER','Syntax:\nRESET MASTER [TO binary_log_file_index_number]\n\nRESET MASTER enables you to delete any binary log files and their\nrelated binary log index file, returning the master to its state before\nbinary logging was started.\n\n*Warning*:\n\nUse this statement with caution to ensure you do not lose binary log\nfile data.\n\nIssuing RESET MASTER without the optional TO clause deletes all binary\nlog files listed in the index file, resets the binary log index file to\nbe empty, and creates a new binary log file starting at 1. Use the\noptional TO clause to start the binary log file index from a number\nother than 1 after the reset. Issuing RESET MASTER also clears the\nvalues of the gtid_purged system variable and the gtid_executed system\nvariable; that is, issuing this statement sets each of these values to\nan empty string (\'\'). This statement also clears the\nmysql.gtid_executed table (see\nhttp://dev.mysql.com/doc/refman/8.0/en/replication-gtids-concepts.html#\nreplication-gtids-gtid-executed-table).\n\nUsing RESET MASTER with the TO clause to specify a binary log file\nindex number to start from simplifies failover by providing a single\nstatement alternative to the FLUSH BINARY LOGS and PURGE BINARY LOGS TO\nstatements. Check that you are using a reasonable value for the index\nnumber. If you enter an incorrect value, you can correct this by\nissuing another RESET MASTER statement with or without the TO clause.\nIf you do not correct a value that is out of range, the server cannot\nbe restarted.\n\nThe following example demonstrates TO clause usage:\n\nRESET MASTER TO 1234;\n\nSHOW BINARY LOGS;\n+-------------------+-----------+-----------+\n| Log_name          | File_size | Encrypted |\n+-------------------+-----------+-----------+\n| master-bin.001234 |       154 | No        |\n+-------------------+-----------+-----------+\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/reset-master.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/reset-master.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (421,2,'RESET PERSIST','Syntax:\nRESET PERSIST [[IF EXISTS] system_var_name]\n\nRESET PERSIST removes persisted global system variable settings from\nthe mysqld-auto.cnf option file in the data directory. Removing a\npersisted system variable causes the variable no longer to be\ninitialized from mysqld-auto.cnf at server startup. For more\ninformation about persisting system variables and the mysqld-auto.cnf\nfile, see\nhttp://dev.mysql.com/doc/refman/8.0/en/persisted-system-variables.html.\n\nThe privileges required for RESET PERSIST depend on the type of system\nvariable to be removed:\n\no For dynamic system variables, this statement requires the\n  SYSTEM_VARIABLES_ADMIN or SUPER privilege.\n\no For read-only system variables, this statement requires the\n  SYSTEM_VARIABLES_ADMIN and PERSIST_RO_VARIABLES_ADMIN privileges.\n\nSee\nhttp://dev.mysql.com/doc/refman/8.0/en/system-variable-privileges.html.\n\nDepending on whether the variable name and IF EXISTS clauses are\npresent, the RESET PERSIST statement has these forms:\n\no To remove all persisted variables from mysqld-auto.cnf, use RESET\n  PERSIST without naming any system variable:\n\nRESET PERSIST;\n\n  You must have privileges for removing both dynamic and read-only\n  system variables if mysqld-auto.cnf contains both kinds of variables.\n\no To remove a specific persisted variable from mysqld-auto.cnf, name it\n  in the statement:\n\nRESET PERSIST system_var_name;\n\n  This includes plugin system variables, even if the plugin is not\n  currently installed. If the variable is not present in the file, an\n  error occurs.\n\no To remove a specific persisted variable from mysqld-auto.cnf, but\n  produce a warning rather than an error if the variable is not present\n  in the file, add an IF EXISTS clause to the previous syntax:\n\nRESET PERSIST IF EXISTS system_var_name;\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/reset-persist.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/reset-persist.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (422,37,'RESET SLAVE','Syntax:\nRESET SLAVE [ALL] [channel_option]\n\nchannel_option:\n    FOR CHANNEL channel\n\nRESET SLAVE makes the slave forget its replication position in the\nmaster\'s binary log. This statement is meant to be used for a clean\nstart: It clears the master info and relay log info repositories,\ndeletes all the relay log files, and starts a new relay log file. It\nalso resets to 0 the replication delay specified with the MASTER_DELAY\noption to CHANGE MASTER TO. RESET SLAVE does not change the values of\ngtid_executed or gtid_purged.\n\n*Note*:\n\nAll relay log files are deleted, even if they have not been completely\nexecuted by the slave SQL thread. (This is a condition likely to exist\non a replication slave if you have issued a STOP SLAVE statement or if\nthe slave is highly loaded.)\n\nTo use RESET SLAVE, the slave replication threads must be stopped, so\non a running slave use STOP SLAVE before issuing RESET SLAVE. To use\nRESET SLAVE on a Group Replication group member, the member status must\nbe OFFLINE, meaning that the plugin is loaded but the member does not\ncurrently belong to any group. A group member can be taken offline by\nusing a STOP GROUP REPLICATION statement.\n\nThe optional FOR CHANNEL channel clause enables you to name which\nreplication channel the statement applies to. Providing a FOR CHANNEL\nchannel clause applies the RESET SLAVE statement to a specific\nreplication channel. Combining a FOR CHANNEL channel clause with the\nALL option deletes the specified channel. If no channel is named and no\nextra channels exist, the statement applies to the default channel.\nIssuing a RESET SLAVE ALL statement without a FOR CHANNEL channel\nclause when multiple replication channels exist deletes all replication\nchannels and recreates only the default channel. See\nhttp://dev.mysql.com/doc/refman/8.0/en/replication-channels.html for\nmore information.\n\nRESET SLAVE does not change any replication connection parameters such\nas master host, master port, master user, or master password.\n\no From MySQL 8.0.13, when master_info_repository=TABLE is set on the\n  server (which is the default from MySQL 8.0), replication connection\n  parameters are preserved in the crash-safe InnoDB table\n  mysql.slave_master_info as part of the RESET SLAVE operation. They\n  are also retained in memory. In the event of a server crash or\n  deliberate restart after issuing RESET SLAVE but before issuing START\n  SLAVE, the replication connection parameters are retrieved from the\n  table and reused for the new connection.\n\no When master_info_repository=FILE is set on the server, replication\n  connection parameters are only retained in memory. If the slave\n  mysqld is restarted immediately after issuing RESET SLAVE due to a\n  server crash or deliberate restart, the connection parameters are\n  lost. In that case, you must issue a CHANGE MASTER TO statement after\n  the server start to respecify the connection parameters before\n  issuing START SLAVE.\n\nIf you want to reset the connection parameters intentionally, you need\nto use RESET SLAVE ALL, which clears the connection parameters. In that\ncase, you must issue a CHANGE MASTER TO statement after the server\nstart to specify the new connection parameters.\n\nRESET SLAVE ALL clears the IGNORE_SERVER_IDS list set by CHANGE MASTER\nTO.\n\nRESET SLAVE does not change any replication filter settings (such as\n--replicate-ignore-table) for channels affected by the statement.\nHowever, RESET SLAVE ALLremoves the replication filters that were set\non the channels deleted by the statement. When the deleted channel or\nchannels are recreated, any global replication filters specified for\nthe slave are copied to them, and no channel specific replication\nfilters are applied. For more information see\nhttp://dev.mysql.com/doc/refman/8.0/en/replication-rules-channel-based-\nfilters.html.\n\nRESET SLAVE causes an implicit commit of an ongoing transaction. See\nhttp://dev.mysql.com/doc/refman/8.0/en/implicit-commit.html.\n\nIf the slave SQL thread was in the middle of replicating temporary\ntables when it was stopped, and RESET SLAVE is issued, these replicated\ntemporary tables are deleted on the slave.\n\nRESET SLAVE does not reset the heartbeat period\n(Slave_heartbeat_period) or SSL_VERIFY_SERVER_CERT.\n\n*Note*:\n\nWhen used on an NDB Cluster replication slave SQL node, RESET SLAVE\nclears the mysql.ndb_apply_status table. You should keep in mind when\nusing this statement that ndb_apply_status uses the NDB storage engine\nand so is shared by all SQL nodes attached to the slave cluster.\n\nYou can override this behavior by issuing SET GLOBAL\n@@ndb_clear_apply_status=OFF prior to executing RESET SLAVE, which\nkeeps the slave from purging the ndb_apply_status table in such cases.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/reset-slave.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/reset-slave.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (423,6,'RESIGNAL','Syntax:\nRESIGNAL [condition_value]\n    [SET signal_information_item\n    [, signal_information_item] ...]\n\ncondition_value: {\n    SQLSTATE [VALUE] sqlstate_value\n  | condition_name\n}\n\nsignal_information_item:\n    condition_information_item_name = simple_value_specification\n\ncondition_information_item_name: {\n    CLASS_ORIGIN\n  | SUBCLASS_ORIGIN\n  | MESSAGE_TEXT\n  | MYSQL_ERRNO\n  | CONSTRAINT_CATALOG\n  | CONSTRAINT_SCHEMA\n  | CONSTRAINT_NAME\n  | CATALOG_NAME\n  | SCHEMA_NAME\n  | TABLE_NAME\n  | COLUMN_NAME\n  | CURSOR_NAME\n}\n\ncondition_name, simple_value_specification:\n    (see following discussion)\n\nRESIGNAL passes on the error condition information that is available\nduring execution of a condition handler within a compound statement\ninside a stored procedure or function, trigger, or event. RESIGNAL may\nchange some or all information before passing it on. RESIGNAL is\nrelated to SIGNAL, but instead of originating a condition as SIGNAL\ndoes, RESIGNAL relays existing condition information, possibly after\nmodifying it.\n\nRESIGNAL makes it possible to both handle an error and return the error\ninformation. Otherwise, by executing an SQL statement within the\nhandler, information that caused the handler\'s activation is destroyed.\nRESIGNAL also can make some procedures shorter if a given handler can\nhandle part of a situation, then pass the condition "up the line" to\nanother handler.\n\nNo privileges are required to execute the RESIGNAL statement.\n\nAll forms of RESIGNAL require that the current context be a condition\nhandler. Otherwise, RESIGNAL is illegal and a RESIGNAL when handler not\nactive error occurs.\n\nTo retrieve information from the diagnostics area, use the GET\nDIAGNOSTICS statement (see [HELP GET DIAGNOSTICS]). For information\nabout the diagnostics area, see\nhttp://dev.mysql.com/doc/refman/8.0/en/diagnostics-area.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/resignal.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/resignal.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (424,2,'RESTART','Syntax:\nRESTART\n\nThis statement stops and restarts the MySQL server. It requires the\nSHUTDOWN privilege.\n\nOne use for RESTART is when it is not possible or convenient to gain\ncommand-line access to the MySQL server on the server host to restart\nit. For example, SET PERSIST_ONLY can be used at runtime to make\nconfiguration changes to system variables that can be set only at\nserver startup, but the server must still be restarted for those\nchanges to take effect. The RESTART statement provides a way to do so\nfrom within client sessions, without requiring command-line access on\nthe server host.\n\n*Note*:\n\nAfter executing a RESTART statement, the client can expect the current\nconnection to be lost. If auto-reconnect is enabled, the connection\nwill be reestablished after the server restarts. Otherwise, the\nconnection must be reestablished manually.\n\nA successful RESTART operation requires mysqld to be running in an\nenvironment that has a monitoring process available to detect a server\nshutdown performed for restart purposes:\n\no In the presence of a monitoring process, RESTART causes mysqld to\n  terminate such that the monitoring process can determine that it\n  should start a new mysqld instance.\n\no If no monitoring process is present, RESTART fails with an error.\n\nThese platforms provide the necessary monitoring support for the\nRESTART statement:\n\no Windows, when mysqld is started as a Windows service or standalone.\n  (mysqld forks, and one process acts as a monitor to the other, which\n  acts as the server.)\n\no Unix and Unix-like systems that use systemd or mysqld_safe to manage\n  mysqld.\n\nOn Windows, the forking used to implement RESTART makes determining the\nserver process to attach to for debugging more difficult. To alleviate\nthis, starting the server with --gdb suppresses forking, in addition to\nits other actions done to set up a debugging environment. In non-debug\nsettings, --no-monitor may be used for the sole purpose of suppressing\nforking the monitor process. For a server started with either --gdb or\n--no-monitor, executing RESTART causes the server to simply exit\nwithout restarting.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/restart.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/restart.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (425,6,'RETURN','Syntax:\nRETURN expr\n\nThe RETURN statement terminates execution of a stored function and\nreturns the value expr to the function caller. There must be at least\none RETURN statement in a stored function. There may be more than one\nif the function has multiple exit points.\n\nThis statement is not used in stored procedures, triggers, or events.\nThe LEAVE statement can be used to exit a stored program of those\ntypes.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/return.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/return.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (426,35,'REVERSE','Syntax:\nREVERSE(str)\n\nReturns the string str with the order of the characters reversed.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT REVERSE(\'abc\');\n        -> \'cba\'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (427,1,'REVOKE','Syntax:\nREVOKE\n    priv_type [(column_list)]\n      [, priv_type [(column_list)]] ...\n    ON [object_type] priv_level\n    FROM user_or_role [, user_or_role] ...\n\nREVOKE ALL [PRIVILEGES], GRANT OPTION\n    FROM user_or_role [, user_or_role] ...\n\nREVOKE PROXY ON user_or_role\n    FROM user_or_role [, user_or_role] ...\n\nREVOKE role [, role ] ...\n    FROM user_or_role [, user_or_role ] ...\n\nuser_or_role: {\n    user\n  | role\n}\n\nuser:\n    (see http://dev.mysql.com/doc/refman/8.0/en/account-names.html)\n\nrole:\n    (see http://dev.mysql.com/doc/refman/8.0/en/role-names.html.\n\nThe REVOKE statement enables system administrators to revoke privileges\nand roles, which can be revoked from user accounts and roles.\n\nFor information about roles, see\nhttp://dev.mysql.com/doc/refman/8.0/en/roles.html.\n\nWhen the read_only system variable is enabled, REVOKE requires the\nCONNECTION_ADMIN or SUPER privilege in addition to any other required\nprivileges described in the following discussion.\n\nREVOKE either succeeds for all named users and roles or rolls back and\nhas no effect if any error occurs. The statement is written to the\nbinary log only if it succeeds for all named users and roles.\n\nEach account name uses the format described in\nhttp://dev.mysql.com/doc/refman/8.0/en/account-names.html. Each role\nname uses the format described in\nhttp://dev.mysql.com/doc/refman/8.0/en/role-names.html. For example:\n\nREVOKE INSERT ON *.* FROM \'jeffrey\'@\'localhost\';\nREVOKE \'role1\', \'role2\' FROM \'user1\'@\'localhost\', \'user2\'@\'localhost\';\nREVOKE SELECT ON world.* FROM \'role3\';\n\nThe host name part of the account or role name, if omitted, defaults to\n\'%\'.\n\nFor details on the levels at which privileges exist, the permissible\npriv_type, priv_level, and object_type values, and the syntax for\nspecifying users and passwords, see [HELP GRANT].\n\nTo use the first REVOKE syntax, you must have the GRANT OPTION\nprivilege, and you must have the privileges that you are revoking.\n\nTo revoke all privileges, use the second syntax, which drops all\nglobal, database, table, column, and routine privileges for the named\nusers or roles:\n\nREVOKE ALL PRIVILEGES, GRANT OPTION\n  FROM user_or_role [, user_or_role] ...\n\nREVOKE ALL PRIVILEGES, GRANT OPTION does not revoke any roles.\n\nTo use this REVOKE syntax, you must have the global CREATE USER\nprivilege, or the UPDATE privilege for the mysql system database.\n\nThe syntax for which the REVOKE keyword is followed by one or more role\nnames takes a FROM clause indicating one or more users or roles from\nwhich to revoke the roles.\n\nRoles named in the mandatory_roles system variable value cannot be\nrevoked.\n\nA revoked role immediately affects any user account from which it was\nrevoked, such that within any current session for the account, its\nprivileges are adjusted for the next statement executed.\n\nRevoking a role revokes the role itself, not the privileges that it\nrepresents. If an account is granted a role that includes a given\nprivilege, and is also granted the privilege explicitly or another role\nthat includes the privilege, the account still is granted that\nprivilege after the first role is revoked. For example, if an account\nis granted two roles that each include SELECT, the account still can\nselect after either role is revoked.\n\nREVOKE ALL ON *.* (at the global level) revokes all granted static\nglobal privileges and all granted dynamic privileges.\n\nUser accounts and roles from which privileges and roles are to be\nrevoked must exist, but the roles to be revoked need not be currently\ngranted to them.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/revoke.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/revoke.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (428,35,'RIGHT','Syntax:\nRIGHT(str,len)\n\nReturns the rightmost len characters from the string str, or NULL if\nany argument is NULL.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT RIGHT(\'foobarbar\', 4);\n        -> \'rbar\'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (429,23,'ROLES_GRAPHML','ROLES_GRAPHML()\n\nReturns a utf8 string containing a GraphML document representing memory\nrole subgraphs. The ROLE_ADMIN or SUPER privilege is required to see\ncontent in the <graphml> element. Otherwise, the result shows only an\nempty element:\n\nmysql> SELECT ROLES_GRAPHML();\n+---------------------------------------------------+\n| ROLES_GRAPHML()                                   |\n+---------------------------------------------------+\n| <?xml version="1.0" encoding="UTF-8"?><graphml /> |\n+---------------------------------------------------+\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/information-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (430,30,'ROUND','Syntax:\nROUND(X), ROUND(X,D)\n\nRounds the argument X to D decimal places. The rounding algorithm\ndepends on the data type of X. D defaults to 0 if not specified. D can\nbe negative to cause D digits left of the decimal point of the value X\nto become zero.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT ROUND(-1.23);\n        -> -1\nmysql> SELECT ROUND(-1.58);\n        -> -2\nmysql> SELECT ROUND(1.58);\n        -> 2\nmysql> SELECT ROUND(1.298, 1);\n        -> 1.3\nmysql> SELECT ROUND(1.298, 0);\n        -> 1\nmysql> SELECT ROUND(23.298, -1);\n        -> 20\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (431,23,'ROW_COUNT','Syntax:\nROW_COUNT()\n\nROW_COUNT() returns a value as follows:\n\no DDL statements: 0. This applies to statements such as CREATE TABLE or\n  DROP TABLE.\n\no DML statements other than SELECT: The number of affected rows. This\n  applies to statements such as UPDATE, INSERT, or DELETE (as before),\n  but now also to statements such as ALTER TABLE and LOAD DATA.\n\no SELECT: -1 if the statement returns a result set, or the number of\n  rows "affected" if it does not. For example, for SELECT * FROM t1,\n  ROW_COUNT() returns -1. For SELECT * FROM t1 INTO OUTFILE\n  \'file_name\', ROW_COUNT() returns the number of rows written to the\n  file.\n\no SIGNAL statements: 0.\n\nFor UPDATE statements, the affected-rows value by default is the number\nof rows actually changed. If you specify the CLIENT_FOUND_ROWS flag to\nmysql_real_connect() when connecting to mysqld, the affected-rows value\nis the number of rows "found"; that is, matched by the WHERE clause.\n\nFor REPLACE statements, the affected-rows value is 2 if the new row\nreplaced an old row, because in this case, one row was inserted after\nthe duplicate was deleted.\n\nFor INSERT ... ON DUPLICATE KEY UPDATE statements, the affected-rows\nvalue per row is 1 if the row is inserted as a new row, 2 if an\nexisting row is updated, and 0 if an existing row is set to its current\nvalues. If you specify the CLIENT_FOUND_ROWS flag, the affected-rows\nvalue is 1 (not 0) if an existing row is set to its current values.\n\nThe ROW_COUNT() value is similar to the value from the\nmysql_affected_rows() C API function and the row count that the mysql\nclient displays following statement execution.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/information-functions.html\n\n','mysql> INSERT INTO t VALUES(1),(2),(3);\nQuery OK, 3 rows affected (0.00 sec)\nRecords: 3  Duplicates: 0  Warnings: 0\n\nmysql> SELECT ROW_COUNT();\n+-------------+\n| ROW_COUNT() |\n+-------------+\n|           3 |\n+-------------+\n1 row in set (0.00 sec)\n\nmysql> DELETE FROM t WHERE i IN(1,2);\nQuery OK, 2 rows affected (0.00 sec)\n\nmysql> SELECT ROW_COUNT();\n+-------------+\n| ROW_COUNT() |\n+-------------+\n|           2 |\n+-------------+\n1 row in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/8.0/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (432,15,'ROW_NUMBER','ROW_NUMBER() over_clause\n\nReturns the number of the current row within its partition. Rows\nnumbers range from 1 to the number of partition rows.\n\nORDER BY affects the order in which rows are numbered. Without ORDER\nBY, row numbering is nondeterministic.\n\nROW_NUMBER() assigns peers different row numbers. To assign peers the\nsame value, use RANK() or DENSE_RANK(). For an example, see the RANK()\nfunction description.\n\nover_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/window-function-descriptions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/window-function-descriptions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (433,35,'RPAD','Syntax:\nRPAD(str,len,padstr)\n\nReturns the string str, right-padded with the string padstr to a length\nof len characters. If str is longer than len, the return value is\nshortened to len characters.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT RPAD(\'hi\',5,\'?\');\n        -> \'hi???\'\nmysql> SELECT RPAD(\'hi\',1,\'?\');\n        -> \'h\'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (434,35,'RTRIM','Syntax:\nRTRIM(str)\n\nReturns the string str with trailing space characters removed.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT RTRIM(\'barbar   \');\n        -> \'barbar\'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (435,37,'SAVEPOINT','Syntax:\nSAVEPOINT identifier\nROLLBACK [WORK] TO [SAVEPOINT] identifier\nRELEASE SAVEPOINT identifier\n\nInnoDB supports the SQL statements SAVEPOINT, ROLLBACK TO SAVEPOINT,\nRELEASE SAVEPOINT and the optional WORK keyword for ROLLBACK.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/savepoint.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/savepoint.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (436,23,'SCHEMA','Syntax:\nSCHEMA()\n\nThis function is a synonym for DATABASE().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/information-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (437,12,'SECOND','Syntax:\nSECOND(time)\n\nReturns the second for time, in the range 0 to 59.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT SECOND(\'10:05:03\');\n        -> 3\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (438,12,'SEC_TO_TIME','Syntax:\nSEC_TO_TIME(seconds)\n\nReturns the seconds argument, converted to hours, minutes, and seconds,\nas a TIME value. The range of the result is constrained to that of the\nTIME data type. A warning occurs if the argument corresponds to a value\noutside that range.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT SEC_TO_TIME(2378);\n        -> \'00:39:38\'\nmysql> SELECT SEC_TO_TIME(2378) + 0;\n        -> 3938\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (439,10,'SELECT','Syntax:\nSELECT\n    [ALL | DISTINCT | DISTINCTROW ]\n      [HIGH_PRIORITY]\n      [STRAIGHT_JOIN]\n      [SQL_SMALL_RESULT] [SQL_BIG_RESULT] [SQL_BUFFER_RESULT]\n      SQL_NO_CACHE [SQL_CALC_FOUND_ROWS]\n    select_expr [, select_expr ...]\n    [FROM table_references\n      [PARTITION partition_list]\n    [WHERE where_condition]\n    [GROUP BY {col_name | expr | position}, ... [WITH ROLLUP]]\n    [HAVING where_condition]\n    [WINDOW window_name AS (window_spec)\n        [, window_name AS (window_spec)] ...]\n    [ORDER BY {col_name | expr | position}\n      [ASC | DESC], ... [WITH ROLLUP]]\n    [LIMIT {[offset,] row_count | row_count OFFSET offset}]\n    [INTO OUTFILE \'file_name\'\n        [CHARACTER SET charset_name]\n        export_options\n      | INTO DUMPFILE \'file_name\'\n      | INTO var_name [, var_name]]\n    [FOR {UPDATE | SHARE} [OF tbl_name [, tbl_name] ...] [NOWAIT | SKIP LOCKED] \n      | LOCK IN SHARE MODE]]\n\nSELECT is used to retrieve rows selected from one or more tables, and\ncan include UNION statements and subqueries. See [HELP UNION], and\nhttp://dev.mysql.com/doc/refman/8.0/en/subqueries.html. A SELECT\nstatement can start with a WITH clause to define common table\nexpressions accessible within the SELECT. See\nhttp://dev.mysql.com/doc/refman/8.0/en/with.html.\n\nThe most commonly used clauses of SELECT statements are these:\n\no Each select_expr indicates a column that you want to retrieve. There\n  must be at least one select_expr.\n\no table_references indicates the table or tables from which to retrieve\n  rows. Its syntax is described in [HELP JOIN].\n\no SELECT supports explicit partition selection using the PARTITION with\n  a list of partitions or subpartitions (or both) following the name of\n  the table in a table_reference (see [HELP JOIN]). In this case, rows\n  are selected only from the partitions listed, and any other\n  partitions of the table are ignored. For more information and\n  examples, see\n  http://dev.mysql.com/doc/refman/8.0/en/partitioning-selection.html.\n\n  SELECT ... PARTITION from tables using storage engines such as MyISAM\n  that perform table-level locks (and thus partition locks) lock only\n  the partitions or subpartitions named by the PARTITION option.\n\n  For more information, see Partitioning and Locking\n  (http://dev.mysql.com/doc/refman/5.7/en/partitioning-limitations-lock\n  ing.html).\n\no The WHERE clause, if given, indicates the condition or conditions\n  that rows must satisfy to be selected. where_condition is an\n  expression that evaluates to true for each row to be selected. The\n  statement selects all rows if there is no WHERE clause.\n\n  In the WHERE expression, you can use any of the functions and\n  operators that MySQL supports, except for aggregate (summary)\n  functions. See\n  http://dev.mysql.com/doc/refman/8.0/en/expressions.html, and\n  http://dev.mysql.com/doc/refman/8.0/en/functions.html.\n\nSELECT can also be used to retrieve rows computed without reference to\nany table.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/select.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/select.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (440,23,'SESSION_USER','Syntax:\nSESSION_USER()\n\nSESSION_USER() is a synonym for USER().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/information-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (441,2,'SET','Syntax:\nSET variable = expr [, variable = expr] ...\n\nvariable: {\n    user_var_name\n  | param_name\n  | local_var_name\n  | {GLOBAL | @@GLOBAL.} system_var_name\n  | {PERSIST | @@PERSIST.} system_var_name\n  | {PERSIST_ONLY | @@PERSIST_ONLY.} system_var_name\n  | [SESSION | @@SESSION. | @@] system_var_name\n}\n\nSET syntax for variable assignment enables you to assign values to\ndifferent types of variables that affect the operation of the server or\nclients:\n\no User-defined variables. See\n  http://dev.mysql.com/doc/refman/8.0/en/user-variables.html.\n\no Stored procedure and function parameters, and stored program local\n  variables. See\n  http://dev.mysql.com/doc/refman/8.0/en/stored-program-variables.html.\n\no System variables. See\n  http://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html.\n  System variables also can be set at server startup, as described in\n  http://dev.mysql.com/doc/refman/8.0/en/using-system-variables.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/set-variable.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/set-variable.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (442,2,'SET CHARACTER SET','Syntax:\nSET {CHARACTER SET | CHARSET}\n    {\'charset_name\' | DEFAULT}\n\nThis statement maps all strings sent between the server and the current\nclient with the given mapping. SET CHARACTER SET sets three session\nsystem variables: character_set_client and character_set_results are\nset to the given character set, and character_set_connection to the\nvalue of character_set_database. See\nhttp://dev.mysql.com/doc/refman/8.0/en/charset-connection.html.\n\ncharset_name may be quoted or unquoted.\n\nThe default character set mapping can be restored by using the value\nDEFAULT. The default depends on the server configuration.\n\nSome character sets cannot be used as the client character set.\nAttempting to use them with SET CHARACTER SET produces an error. See\nhttp://dev.mysql.com/doc/refman/8.0/en/charset-connection.html#charset-\nconnection-impermissible-client-charset.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/set-character-set.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/set-character-set.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (443,11,'SET DATA TYPE','SET(\'value1\',\'value2\',...) [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nA set. A string object that can have zero or more values, each of which\nmust be chosen from the list of values \'value1\', \'value2\', ... SET\nvalues are represented internally as integers.\n\nA SET column can have a maximum of 64 distinct members.\n\nThe maximum supported length of an individual SET element is M <= 255\nand (M x w) <= 1020, where M is the element literal length and w is the\nnumber of bytes required for the maximum-length character in the\ncharacter set.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (444,1,'SET DEFAULT ROLE','Syntax:\nSET DEFAULT ROLE\n    {NONE | ALL | role [, role ] ...}\n    TO user [, user ] ...\n\nFor each user named immediately after the TO keyword, this statement\ndefines which roles become active when the user connects to the server\nand authenticates, or when the user executes the SET ROLE DEFAULT\nstatement during a session.\n\nSET DEFAULT ROLE is alternative syntax for ALTER USER ... DEFAULT ROLE\n(see [HELP ALTER USER]). However, ALTER USER can set the default for\nonly a single user, whereas SET DEFAULT ROLE can set the default for\nmultiple users. On the other hand, you can specify CURRENT_USER as the\nuser name for the ALTER USER statement, whereas you cannot for SET\nDEFAULT ROLE.\n\nSET DEFAULT ROLE requires these privileges:\n\no Setting the default roles for another user requires the global CREATE\n  USER privilege, or the UPDATE privilege for the mysql.default_roles\n  system table.\n\no Setting the default roles for yourself requires no special\n  privileges, as long as the roles you want as the default have been\n  granted to you.\n\nEach role name uses the format described in\nhttp://dev.mysql.com/doc/refman/8.0/en/role-names.html. For example:\n\nSET DEFAULT ROLE administrator, developer TO \'joe\'@\'10.0.0.1\';\n\nThe host name part of the role name, if omitted, defaults to \'%\'.\n\nThe clause following the DEFAULT ROLE keywords permits these values:\n\no NONE: Set the default to NONE (no roles).\n\no ALL: Set the default to all roles granted to the account.\n\no role [, role ] ...: Set the default to the named roles, which must\n  exist and be granted to the account at the time SET DEFAULT ROLE is\n  executed.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/set-default-role.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/set-default-role.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (445,37,'SET GLOBAL SQL_SLAVE_SKIP_COUNTER','Syntax:\nSET GLOBAL sql_slave_skip_counter = N\n\nThis statement skips the next N events from the master. This is useful\nfor recovering from replication stops caused by a statement.\n\nThis statement is valid only when the slave threads are not running.\nOtherwise, it produces an error.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/set-global-sql-slave-skip-counter.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/set-global-sql-slave-skip-counter.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (446,2,'SET NAMES','Syntax:\nSET NAMES {\'charset_name\'\n    [COLLATE \'collation_name\'] | DEFAULT}\n\nThis statement sets the three session system variables\ncharacter_set_client, character_set_connection, and\ncharacter_set_results to the given character set. Setting\ncharacter_set_connection to charset_name also sets collation_connection\nto the default collation for charset_name. See\nhttp://dev.mysql.com/doc/refman/8.0/en/charset-connection.html.\n\nThe optional COLLATE clause may be used to specify a collation\nexplicitly. If given, the collation must one of the permitted\ncollations for charset_name.\n\ncharset_name and collation_name may be quoted or unquoted.\n\nThe default mapping can be restored by using a value of DEFAULT. The\ndefault depends on the server configuration.\n\nSome character sets cannot be used as the client character set.\nAttempting to use them with SET NAMES produces an error. See\nhttp://dev.mysql.com/doc/refman/8.0/en/charset-connection.html#charset-\nconnection-impermissible-client-charset.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/set-names.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/set-names.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (447,1,'SET PASSWORD','Syntax:\nSET PASSWORD [FOR user] = \'auth_string\'\n    [REPLACE \'current_auth_string\']\n    [RETAIN CURRENT PASSWORD]\n\nThe SET PASSWORD statement assigns a password to a MySQL user account.\nIt may also include a password-verification clause that specifies the\naccount current password to be replaced, and a clause that manages\nwhether an account has a secondary password. \'auth_string\' and\n\'current_auth_string\' each represent a cleartext (unencrypted)\npassword.\n\n*Note*:\n\nClauses for password verification and secondary passwords apply only to\naccounts that store credentials internally in the mysql.user system\ntable (mysql_native_password, sha256_password, or\ncaching_sha2_password). For accounts that use plugins that perform\nauthentication against an external credential system, password\nmanagement must be handled externally against that system as well.\n\nThe REPLACE \'current_auth_string\' clause is available as of MySQL\n8.0.13. If given:\n\no REPLACE specifies the account current password to be replaced, as a\n  cleartext (unencrypted) string.\n\no The clause must be given if password changes for the account are\n  required to specify the current password, as verification that the\n  user attempting to make the change actually knows the current\n  password.\n\no The clause is optional if password changes for the account may but\n  need not specify the current password.\n\no The statement fails if the clause is given but does not match the\n  current password, even if the clause is optional.\n\no REPLACE can be specified only when changing the account password for\n  the current user.\n\nFor more information about password verification by specifying the\ncurrent password, see\nhttp://dev.mysql.com/doc/refman/8.0/en/password-management.html.\n\nThe RETAIN CURRENT PASSWORD clause implements dual-password capability\nand is available as of MySQL 8.0.14. If given:\n\no RETAIN CURRENT PASSWORD retains an account current password as its\n  secondary password, replacing any existing secondary password. The\n  new password becomes the primary password, but clients can use the\n  account to connect to the server using either the primary or\n  secondary password. (Exception: If the new password specified by the\n  SET PASSWORD statement is empty, the secondary password becomes empty\n  as well, even if RETAIN CURRENT PASSWORD is given.)\n\no If you specify RETAIN CURRENT PASSWORD for an account that has an\n  empty primary password, the statement fails.\n\no If an account has a secondary password and you change its primary\n  password without specifying RETAIN CURRENT PASSWORD, the secondary\n  password remains unchanged.\n\nFor more information about use of dual passwords, see\nhttp://dev.mysql.com/doc/refman/8.0/en/password-management.html.\n\n*Note*:\n\nRather than using SET PASSWORD ... = \'auth_string\' syntax, ALTER USER\nsyntax is the preferred statement for account alterations, including\nassigning passwords. For example:\n\nALTER USER user IDENTIFIED BY \'auth_string\';\n\n*Important*:\n\nUnder some circumstances, SET PASSWORD may be recorded in server logs\nor on the client side in a history file such as ~/.mysql_history, which\nmeans that cleartext passwords may be read by anyone having read access\nto that information. For information about the conditions under which\nthis occurs for the server logs and how to control it, see\nhttp://dev.mysql.com/doc/refman/8.0/en/password-logging.html. For\nsimilar information about client-side logging, see\nhttp://dev.mysql.com/doc/refman/8.0/en/mysql-logging.html.\n\nSET PASSWORD can be used with or without a FOR clause that explicitly\nnames a user account:\n\no With a FOR user clause, the statement sets the password for the named\n  account, which must exist:\n\nSET PASSWORD FOR \'jeffrey\'@\'localhost\' = \'auth_string\';\n\no With no FOR user clause, the statement sets the password for the\n  current user:\n\nSET PASSWORD = \'auth_string\';\n\n  Any client who connects to the server using a nonanonymous account\n  can change the password for that account. (In particular, you can\n  change your own password.) To see which account the server\n  authenticated you as, invoke the CURRENT_USER() function:\n\nSELECT CURRENT_USER();\n\nIf a FOR user clause is given, the account name uses the format\ndescribed in http://dev.mysql.com/doc/refman/8.0/en/account-names.html.\nFor example:\n\nSET PASSWORD FOR \'bob\'@\'%.example.org\' = \'auth_string\';\n\nThe host name part of the account name, if omitted, defaults to \'%\'.\n\nSET PASSWORD interprets the string as a cleartext string, passes it to\nthe authentication plugin associated with the account, and stores the\nresult returned by the plugin in the account row in the mysql.user\nsystem table. (The plugin is given the opportunity to hash the value\ninto the encryption format it expects. The plugin may use the value as\nspecified, in which case no hashing occurs.)\n\nSetting the password for a named account (with a FOR clause) requires\nthe UPDATE privilege for the mysql system database. Setting the\npassword for yourself (for a nonanonymous account with no FOR clause)\nrequires no special privileges.\n\nStatements that modify secondary passwords require these privileges:\n\no The APPLICATION_PASSWORD_ADMIN privilege is required to use the\n  RETAIN CURRENT PASSWORD clause for SET PASSWORD statements that apply\n  to your own account. The privilege is required to manipulate your own\n  secondary password because most users require only one password.\n\no If an account is to be permitted to manipulate secondary passwords\n  for all accounts, it should be granted the CREATE USER privilege\n  rather than APPLICATION_PASSWORD_ADMIN.\n\nWhen the read_only system variable is enabled, SET PASSWORD requires\nthe CONNECTION_ADMIN or SUPER privilege in addition to any other\nrequired privileges.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/set-password.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/set-password.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (448,1,'SET RESOURCE GROUP','Syntax:\nSET RESOURCE GROUP group_name\n    [FOR thread_id [, thread_id] ...]\n\nSET RESOURCE GROUP is used for resource group management (see\nhttp://dev.mysql.com/doc/refman/8.0/en/resource-groups.html). This\nstatement assigns threads to a resource group. It requires the\nRESOURCE_GROUP_ADMIN or RESOURCE_GROUP_USER privilege.\n\ngroup_name identifies which resource group to be assigned. Any\nthread_id values indicate threads to assign to the group. Thread IDs\ncan be determined from the Performance Schema threads table. If the\nresource group or any named thread ID does not exist, an error occurs.\n\nWith no FOR clause, the statement assigns the current thread for the\nsession to the resource group.\n\nWith a FOR clause that names thread IDs, the statement assigns those\nthreads to the resource group.\n\nFor attempts to assign a system thread to a user resource group or a\nuser thread to a system resource group, a warning occurs.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/set-resource-group.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/set-resource-group.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (449,1,'SET ROLE','Syntax:\nSET ROLE {\n    DEFAULT\n  | NONE\n  | ALL\n  | ALL EXCEPT role [, role ] ...\n  | role [, role ] ...\n}\n\nSET ROLE modifies the current user\'s effective privileges within the\ncurrent session by specifying which of its granted roles are active.\nGranted roles include those granted explicitly to the user and those\nnamed in the mandatory_roles system variable value.\n\nPrivileges that the user has been granted directly (rather than through\nroles) remain unaffected by changes to the active roles.\n\nEach role name uses the format described in\nhttp://dev.mysql.com/doc/refman/8.0/en/role-names.html. For example:\n\nSET ROLE DEFAULT;\nSET ROLE \'role1\', \'role2\';\nSET ROLE ALL;\nSET ROLE ALL EXCEPT \'role1\', \'role2\';\n\nThe host name part of the role name, if omitted, defaults to \'%\'.\n\nThe statement permits these role specifiers:\n\no DEFAULT: Activate the account default roles. Default roles are those\n  specified with SET DEFAULT ROLE.\n\n  When a user connects to the server and authenticates successfully,\n  the server determines which roles to activate as the default roles.\n  If the activate_all_roles_on_login system variable is enabled, the\n  server activates all granted roles. Otherwise, The server executes\n  SET ROLE DEFAULT implicitly. The server activates only default roles\n  that can be activated. The server writes warnings to its error log\n  for default roles that cannot be activated, but the client receives\n  no warnings.\n\n  If a user executes SET ROLE DEFAULT during a session, an error occurs\n  if any default role cannot be activated (for example, if it does not\n  exist or is not granted to the user). In this case, the current\n  active roles are not changed.\n\no NONE: Set the active roles to NONE (no active roles).\n\no ALL: Activate all roles granted to the account.\n\no ALL EXCEPT role [, role ] ...: Activate all roles granted to the\n  account except those named. The named roles need not exist or be\n  granted to the account.\n\no role [, role ] ...: Activate the named roles, which must be granted\n  to the account.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/set-role.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/set-role.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (450,37,'SET SQL_LOG_BIN','Syntax:\nSET sql_log_bin = {OFF|ON}\n\nThe sql_log_bin variable controls whether logging to the binary log is\nenabled for the current session (assuming that the binary log itself is\nenabled). The default value is ON. To disable or enable binary logging\nfor the current session, set the session sql_log_bin variable to OFF or\nON.\n\nSet this variable to OFF for a session to temporarily disable binary\nlogging while making changes to the master you do not want replicated\nto the slave.\n\nSetting the session value of this system variable is a restricted\noperation. The session user must have privileges sufficient to set\nrestricted session variables. See\nhttp://dev.mysql.com/doc/refman/8.0/en/system-variable-privileges.html.\n\nIt is not possible to set the session value of sql_log_bin within a\ntransaction or subquery.\n\nSetting this variable to OFF prevents GTIDs from being assigned to\ntransactions in the binary log. If you are using GTIDs for replication,\nthis means that even when binary logging is later enabled again, the\nGTIDs written into the log from this point do not account for any\ntransactions that occurred in the meantime, so in effect those\ntransactions are lost.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/set-sql-log-bin.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/set-sql-log-bin.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (451,13,'SHA1','Syntax:\nSHA1(str), SHA(str)\n\nCalculates an SHA-1 160-bit checksum for the string, as described in\nRFC 3174 (Secure Hash Algorithm). The value is returned as a string of\n40 hexadecimal digits, or NULL if the argument was NULL. One of the\npossible uses for this function is as a hash key. See the notes at the\nbeginning of this section about storing hash values efficiently. SHA()\nis synonymous with SHA1().\n\nThe return value is a string in the connection character set.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html\n\n','mysql> SELECT SHA1(\'abc\');\n        -> \'a9993e364706816aba3e25717850c26c9cd0d89d\'\n','http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (452,13,'SHA2','Syntax:\nSHA2(str, hash_length)\n\nCalculates the SHA-2 family of hash functions (SHA-224, SHA-256,\nSHA-384, and SHA-512). The first argument is the cleartext string to be\nhashed. The second argument indicates the desired bit length of the\nresult, which must have a value of 224, 256, 384, 512, or 0 (which is\nequivalent to 256). If either argument is NULL or the hash length is\nnot one of the permitted values, the return value is NULL. Otherwise,\nthe function result is a hash value containing the desired number of\nbits. See the notes at the beginning of this section about storing hash\nvalues efficiently.\n\nThe return value is a string in the connection character set.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html\n\n','mysql> SELECT SHA2(\'abc\', 224);\n        -> \'23097d223405d8228642a477bda255b32aadbce4bda0b3f7e36c9da7\'\n','http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (453,2,'SHOW','SHOW has many forms that provide information about databases, tables,\ncolumns, or status information about the server. This section describes\nthose following:\n\nSHOW {BINARY | MASTER} LOGS\nSHOW BINLOG EVENTS [IN \'log_name\'] [FROM pos] [LIMIT [offset,] row_count]\nSHOW CHARACTER SET [like_or_where]\nSHOW COLLATION [like_or_where]\nSHOW [FULL] COLUMNS FROM tbl_name [FROM db_name] [like_or_where]\nSHOW CREATE DATABASE db_name\nSHOW CREATE EVENT event_name\nSHOW CREATE FUNCTION func_name\nSHOW CREATE PROCEDURE proc_name\nSHOW CREATE TABLE tbl_name\nSHOW CREATE TRIGGER trigger_name\nSHOW CREATE VIEW view_name\nSHOW DATABASES [like_or_where]\nSHOW ENGINE engine_name {STATUS | MUTEX}\nSHOW [STORAGE] ENGINES\nSHOW ERRORS [LIMIT [offset,] row_count]\nSHOW EVENTS\nSHOW FUNCTION CODE func_name\nSHOW FUNCTION STATUS [like_or_where]\nSHOW GRANTS FOR user\nSHOW INDEX FROM tbl_name [FROM db_name]\nSHOW MASTER STATUS\nSHOW OPEN TABLES [FROM db_name] [like_or_where]\nSHOW PLUGINS\nSHOW PROCEDURE CODE proc_name\nSHOW PROCEDURE STATUS [like_or_where]\nSHOW PRIVILEGES\nSHOW [FULL] PROCESSLIST\nSHOW PROFILE [types] [FOR QUERY n] [OFFSET n] [LIMIT n]\nSHOW PROFILES\nSHOW RELAYLOG EVENTS [IN \'log_name\'] [FROM pos] [LIMIT [offset,] row_count]\nSHOW SLAVE HOSTS\nSHOW SLAVE STATUS [FOR CHANNEL channel]\nSHOW [GLOBAL | SESSION] STATUS [like_or_where]\nSHOW TABLE STATUS [FROM db_name] [like_or_where]\nSHOW [FULL] TABLES [FROM db_name] [like_or_where]\nSHOW TRIGGERS [FROM db_name] [like_or_where]\nSHOW [GLOBAL | SESSION] VARIABLES [like_or_where]\nSHOW WARNINGS [LIMIT [offset,] row_count]\n\nlike_or_where:\n    LIKE \'pattern\'\n  | WHERE expr\n\nIf the syntax for a given SHOW statement includes a LIKE \'pattern\'\npart, \'pattern\' is a string that can contain the SQL % and _ wildcard\ncharacters. The pattern is useful for restricting statement output to\nmatching values.\n\nSeveral SHOW statements also accept a WHERE clause that provides more\nflexibility in specifying which rows to display. See\nhttp://dev.mysql.com/doc/refman/8.0/en/extended-show.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (454,2,'SHOW BINARY LOGS','Syntax:\nSHOW BINARY LOGS\nSHOW MASTER LOGS\n\nLists the binary log files on the server. This statement is used as\npart of the procedure described in [HELP PURGE BINARY LOGS], that shows\nhow to determine which logs can be purged.\n\nEncrypted binary log files have a 512-byte file header that stores\ninformation required for encryption and decryption of the file. This is\nincluded in the file size displayed by SHOW BINARY LOGS. The Encrypted\ncolumn shows whether or not the binary log file is encrypted. Binary\nlog encryption is active if binlog_encryption=ON is set for the server.\nExisting binary log files are not encrypted or decrypted if binary log\nencryption is activated or deactivated while the server is running.\n\nmysql> SHOW BINARY LOGS;\n+---------------+-----------+-----------+\n| Log_name      | File_size | Encrypted |\n+---------------+-----------+-----------+\n| binlog.000015 |    724935 |       Yes |\n| binlog.000016 |    733481 |       Yes |\n+---------------+-----------+-----------+\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-binary-logs.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-binary-logs.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (455,2,'SHOW BINLOG EVENTS','Syntax:\nSHOW BINLOG EVENTS\n   [IN \'log_name\']\n   [FROM pos]\n   [LIMIT [offset,] row_count]\n\nShows the events in the binary log. If you do not specify \'log_name\',\nthe first binary log is displayed.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-binlog-events.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-binlog-events.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (456,2,'SHOW CHARACTER SET','Syntax:\nSHOW CHARACTER SET\n    [LIKE \'pattern\' | WHERE expr]\n\nThe SHOW CHARACTER SET statement shows all available character sets.\nThe LIKE clause, if present, indicates which character set names to\nmatch. The WHERE clause can be given to select rows using more general\nconditions, as discussed in\nhttp://dev.mysql.com/doc/refman/8.0/en/extended-show.html. For example:\n\nmysql> SHOW CHARACTER SET LIKE \'latin%\';\n+---------+-----------------------------+-------------------+--------+\n| Charset | Description                 | Default collation | Maxlen |\n+---------+-----------------------------+-------------------+--------+\n| latin1  | cp1252 West European        | latin1_swedish_ci |      1 |\n| latin2  | ISO 8859-2 Central European | latin2_general_ci |      1 |\n| latin5  | ISO 8859-9 Turkish          | latin5_turkish_ci |      1 |\n| latin7  | ISO 8859-13 Baltic          | latin7_general_ci |      1 |\n+---------+-----------------------------+-------------------+--------+\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-character-set.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-character-set.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (457,2,'SHOW COLLATION','Syntax:\nSHOW COLLATION\n    [LIKE \'pattern\' | WHERE expr]\n\nThis statement lists collations supported by the server. By default,\nthe output from SHOW COLLATION includes all available collations. The\nLIKE clause, if present, indicates which collation names to match. The\nWHERE clause can be given to select rows using more general conditions,\nas discussed in\nhttp://dev.mysql.com/doc/refman/8.0/en/extended-show.html. For example:\n\nmysql> SHOW COLLATION WHERE Charset = \'latin1\';\n+-------------------+---------+----+---------+----------+---------+\n| Collation         | Charset | Id | Default | Compiled | Sortlen |\n+-------------------+---------+----+---------+----------+---------+\n| latin1_german1_ci | latin1  |  5 |         | Yes      |       1 |\n| latin1_swedish_ci | latin1  |  8 | Yes     | Yes      |       1 |\n| latin1_danish_ci  | latin1  | 15 |         | Yes      |       1 |\n| latin1_german2_ci | latin1  | 31 |         | Yes      |       2 |\n| latin1_bin        | latin1  | 47 |         | Yes      |       1 |\n| latin1_general_ci | latin1  | 48 |         | Yes      |       1 |\n| latin1_general_cs | latin1  | 49 |         | Yes      |       1 |\n| latin1_spanish_ci | latin1  | 94 |         | Yes      |       1 |\n+-------------------+---------+----+---------+----------+---------+\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-collation.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-collation.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (458,2,'SHOW COLUMNS','Syntax:\nSHOW [EXTENDED] [FULL] {COLUMNS | FIELDS}\n    {FROM | IN} tbl_name\n    [{FROM | IN} db_name]\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW COLUMNS displays information about the columns in a given table.\nIt also works for views. SHOW COLUMNS displays information only for\nthose columns for which you have some privilege.\n\nmysql> SHOW COLUMNS FROM City;\n+-------------+----------+------+-----+---------+----------------+\n| Field       | Type     | Null | Key | Default | Extra          |\n+-------------+----------+------+-----+---------+----------------+\n| ID          | int(11)  | NO   | PRI | NULL    | auto_increment |\n| Name        | char(35) | NO   |     |         |                |\n| CountryCode | char(3)  | NO   | MUL |         |                |\n| District    | char(20) | NO   |     |         |                |\n| Population  | int(11)  | NO   |     | 0       |                |\n+-------------+----------+------+-----+---------+----------------+\n\nAn alternative to tbl_name FROM db_name syntax is db_name.tbl_name.\nThese two statements are equivalent:\n\nSHOW COLUMNS FROM mytable FROM mydb;\nSHOW COLUMNS FROM mydb.mytable;\n\nThe optional EXTENDED keyword causes the output to include information\nabout hidden columns that MySQL uses internally and are not accessible\nby users.\n\nThe optional FULL keyword causes the output to include the column\ncollation and comments, as well as the privileges you have for each\ncolumn.\n\nThe LIKE clause, if present, indicates which column names to match. The\nWHERE clause can be given to select rows using more general conditions,\nas discussed in\nhttp://dev.mysql.com/doc/refman/8.0/en/extended-show.html.\n\nThe data types may differ from what you expect them to be based on a\nCREATE TABLE statement because MySQL sometimes changes data types when\nyou create or alter a table. The conditions under which this occurs are\ndescribed in\nhttp://dev.mysql.com/doc/refman/8.0/en/silent-column-changes.html.\n\nSHOW COLUMNS displays the following values for each table column:\n\no Field\n\n  The name of the column.\n\no Type\n\n  The column data type.\n\no Collation\n\n  The collation for nonbinary string columns, or NULL for other\n  columns. This value is displayed only if you use the FULL keyword.\n\no Null\n\n  The column nullability. The value is YES if NULL values can be stored\n  in the column, NO if not.\n\no Key\n\n  Whether the column is indexed:\n\n  o If Key is empty, the column either is not indexed or is indexed\n    only as a secondary column in a multiple-column, nonunique index.\n\n  o If Key is PRI, the column is a PRIMARY KEY or is one of the columns\n    in a multiple-column PRIMARY KEY.\n\n  o If Key is UNI, the column is the first column of a UNIQUE index. (A\n    UNIQUE index permits multiple NULL values, but you can tell whether\n    the column permits NULL by checking the Null field.)\n\n  o If Key is MUL, the column is the first column of a nonunique index\n    in which multiple occurrences of a given value are permitted within\n    the column.\n\n  If more than one of the Key values applies to a given column of a\n  table, Key displays the one with the highest priority, in the order\n  PRI, UNI, MUL.\n\n  A UNIQUE index may be displayed as PRI if it cannot contain NULL\n  values and there is no PRIMARY KEY in the table. A UNIQUE index may\n  display as MUL if several columns form a composite UNIQUE index;\n  although the combination of the columns is unique, each column can\n  still hold multiple occurrences of a given value.\n\no Default\n\n  The default value for the column. This is NULL if the column has an\n  explicit default of NULL, or if the column definition includes no\n  DEFAULT clause.\n\no Extra\n\n  Any additional information that is available about a given column.\n  The value is nonempty in these cases:\n\n  o auto_increment for columns that have the AUTO_INCREMENT attribute.\n\n  o on update CURRENT_TIMESTAMP for TIMESTAMP or DATETIME columns that\n    have the ON UPDATE CURRENT_TIMESTAMP attribute.\n\n  o VIRTUAL GENERATED or VIRTUAL STORED for generated columns.\n\n  o DEFAULT_GENERATED for columns that have an expression default\n    value.\n\no Privileges\n\n  The privileges you have for the column. This value is displayed only\n  if you use the FULL keyword.\n\no Comment\n\n  Any comment included in the column definition. This value is\n  displayed only if you use the FULL keyword.\n\nTable column information is also available from the INFORMATION_SCHEMA\nCOLUMNS table. See\nhttp://dev.mysql.com/doc/refman/8.0/en/columns-table.html. The extended\ninformation about hidden columns is available only using SHOW EXTENDED\nCOLUMNS; it cannot be obtained from the COLUMNS table.\n\nYou can list a table\'s columns with the mysqlshow db_name tbl_name\ncommand.\n\nThe DESCRIBE statement provides information similar to SHOW COLUMNS.\nSee http://dev.mysql.com/doc/refman/8.0/en/describe.html.\n\nThe SHOW CREATE TABLE, SHOW TABLE STATUS, and SHOW INDEX statements\nalso provide information about tables. See [HELP SHOW].\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-columns.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-columns.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (459,2,'SHOW CREATE DATABASE','Syntax:\nSHOW CREATE {DATABASE | SCHEMA} [IF NOT EXISTS] db_name\n\nShows the CREATE DATABASE statement that creates the named database. If\nthe SHOW statement includes an IF NOT EXISTS clause, the output too\nincludes such a clause. SHOW CREATE SCHEMA is a synonym for SHOW CREATE\nDATABASE.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-create-database.html\n\n','mysql> SHOW CREATE DATABASE test\\G\n*************************** 1. row ***************************\n       Database: test\nCreate Database: CREATE DATABASE `test`\n                 /*!40100 DEFAULT CHARACTER SET utf8mb4 */\n\nmysql> SHOW CREATE SCHEMA test\\G\n*************************** 1. row ***************************\n       Database: test\nCreate Database: CREATE DATABASE `test`\n                 /*!40100 DEFAULT CHARACTER SET utf8mb4 */\n','http://dev.mysql.com/doc/refman/8.0/en/show-create-database.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (460,2,'SHOW CREATE EVENT','Syntax:\nSHOW CREATE EVENT event_name\n\nThis statement displays the CREATE EVENT statement needed to re-create\na given event. It requires the EVENT privilege for the database from\nwhich the event is to be shown. For example (using the same event\ne_daily defined and then altered in [HELP SHOW EVENTS]):\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-create-event.html\n\n','mysql> SHOW CREATE EVENT myschema.e_daily\\G\n*************************** 1. row ***************************\n               Event: e_daily\n            sql_mode: ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,\n                      NO_ZERO_IN_DATE,NO_ZERO_DATE,\n                      ERROR_FOR_DIVISION_BY_ZERO,\n                      NO_ENGINE_SUBSTITUTION\n           time_zone: SYSTEM\n        Create Event: CREATE DEFINER=`jon`@`ghidora` EVENT `e_daily`\n                        ON SCHEDULE EVERY 1 DAY\n                        STARTS CURRENT_TIMESTAMP + INTERVAL 6 HOUR\n                        ON COMPLETION NOT PRESERVE\n                        ENABLE\n                        COMMENT \'Saves total number of sessions then\n                                clears the table each day\'\n                        DO BEGIN\n                          INSERT INTO site_activity.totals (time, total)\n                            SELECT CURRENT_TIMESTAMP, COUNT(*)\n                              FROM site_activity.sessions;\n                          DELETE FROM site_activity.sessions;\n                        END\ncharacter_set_client: utf8mb4\ncollation_connection: utf8mb4_0900_ai_ci\n  Database Collation: utf8mb4_0900_ai_ci\n','http://dev.mysql.com/doc/refman/8.0/en/show-create-event.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (461,2,'SHOW CREATE FUNCTION','Syntax:\nSHOW CREATE FUNCTION func_name\n\nThis statement is similar to SHOW CREATE PROCEDURE but for stored\nfunctions. See [HELP SHOW CREATE PROCEDURE].\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-create-function.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-create-function.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (462,2,'SHOW CREATE PROCEDURE','Syntax:\nSHOW CREATE PROCEDURE proc_name\n\nThis statement is a MySQL extension. It returns the exact string that\ncan be used to re-create the named stored procedure. A similar\nstatement, SHOW CREATE FUNCTION, displays information about stored\nfunctions (see [HELP SHOW CREATE FUNCTION]).\n\nTo use either statement, you must have the global SELECT privilege.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-create-procedure.html\n\n','mysql> SHOW CREATE PROCEDURE test.simpleproc\\G\n*************************** 1. row ***************************\n           Procedure: simpleproc\n            sql_mode: ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,\n                      NO_ZERO_IN_DATE,NO_ZERO_DATE,\n                      ERROR_FOR_DIVISION_BY_ZERO,\n                      NO_ENGINE_SUBSTITUTION\n    Create Procedure: CREATE PROCEDURE `simpleproc`(OUT param1 INT)\n                      BEGIN\n                      SELECT COUNT(*) INTO param1 FROM t;\n                      END\ncharacter_set_client: utf8mb4\ncollation_connection: utf8mb4_0900_ai_ci\n  Database Collation: utf8mb4_0900_ai_ci\n\nmysql> SHOW CREATE FUNCTION test.hello\\G\n*************************** 1. row ***************************\n            Function: hello\n            sql_mode: ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,\n                      NO_ZERO_IN_DATE,NO_ZERO_DATE,\n                      ERROR_FOR_DIVISION_BY_ZERO,\n                      NO_ENGINE_SUBSTITUTION\n     Create Function: CREATE FUNCTION `hello`(s CHAR(20))\n                      RETURNS char(50) CHARSET utf8mb4\n                      RETURN CONCAT(\'Hello, \',s,\'!\')\ncharacter_set_client: utf8mb4\ncollation_connection: utf8mb4_0900_ai_ci\n  Database Collation: utf8mb4_0900_ai_ci\n','http://dev.mysql.com/doc/refman/8.0/en/show-create-procedure.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (463,2,'SHOW CREATE TABLE','Syntax:\nSHOW CREATE TABLE tbl_name\n\nShows the CREATE TABLE statement that creates the named table. To use\nthis statement, you must have some privilege for the table. This\nstatement also works with views.\nAs of MySQL 8.0.16, MySQL implements CHECK constraints and SHOW CREATE\nTABLE displays them. All CHECK constraints are displayed as table\nconstraints. That is, a CHECK constraint originally specified as part\nof a column definition displays as a separate clause not part of the\ncolumn definition. Example:\n\nmysql> CREATE TABLE t1 (\n         i1 INT CHECK (i1 <> 0),      -- column constraint\n         i2 INT,\n         CHECK (i2 > i1),             -- table constraint\n         CHECK (i2 <> 0) NOT ENFORCED -- table constraint, not enforced\n       );\n\nmysql> SHOW CREATE TABLE t1\\G\n*************************** 1. row ***************************\n       Table: t1\nCreate Table: CREATE TABLE `t1` (\n  `i1` int(11) DEFAULT NULL,\n  `i2` int(11) DEFAULT NULL,\n  CONSTRAINT `t1_chk_1` CHECK ((`i1` <> 0)),\n  CONSTRAINT `t1_chk_2` CHECK ((`i2` > `i1`)),\n  CONSTRAINT `t1_chk_3` CHECK ((`i2` <> 0)) /*!80016 NOT ENFORCED */\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci\n\nSHOW CREATE TABLE quotes table and column names according to the value\nof the sql_quote_show_create option. See\nhttp://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html.\n\nFor information about how CREATE TABLE statements are stored by MySQL,\nsee\nhttp://dev.mysql.com/doc/refman/8.0/en/create-table-statement-retention\n.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-create-table.html\n\n','mysql> SHOW CREATE TABLE t\\G\n*************************** 1. row ***************************\n       Table: t\nCreate Table: CREATE TABLE `t` (\n  `id` int(11) NOT NULL AUTO_INCREMENT,\n  `s` char(60) DEFAULT NULL,\n  PRIMARY KEY (`id`)\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4\n','http://dev.mysql.com/doc/refman/8.0/en/show-create-table.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (464,2,'SHOW CREATE TRIGGER','Syntax:\nSHOW CREATE TRIGGER trigger_name\n\nThis statement shows the CREATE TRIGGER statement that creates the\nnamed trigger. This statement requires the TRIGGER privilege for the\ntable associated with the trigger.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-create-trigger.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-create-trigger.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (465,2,'SHOW CREATE USER','Syntax:\nSHOW CREATE USER user\n\nThis statement shows the CREATE USER statement that creates the named\nuser. An error occurs if the user does not exist. The statement\nrequires the SELECT privilege for the mysql system database, except to\nsee information for the current user. For the current user, the SELECT\nprivilege for the mysql.user system table is required for display of\nthe password hash in the IDENTIFIED AS clause; otherwise, the hash\ndisplays as <secret>.\n\nTo name the account, use the format described in\nhttp://dev.mysql.com/doc/refman/8.0/en/account-names.html. The host\nname part of the account name, if omitted, defaults to \'%\'. It is also\npossible to specify CURRENT_USER or CURRENT_USER() to refer to the\naccount associated with the current session.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-create-user.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-create-user.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (466,2,'SHOW CREATE VIEW','Syntax:\nSHOW CREATE VIEW view_name\n\nThis statement shows the CREATE VIEW statement that creates the named\nview.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-create-view.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-create-view.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (467,2,'SHOW DATABASES','Syntax:\nSHOW {DATABASES | SCHEMAS}\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW DATABASES lists the databases on the MySQL server host. SHOW\nSCHEMAS is a synonym for SHOW DATABASES. The LIKE clause, if present,\nindicates which database names to match. The WHERE clause can be given\nto select rows using more general conditions, as discussed in\nhttp://dev.mysql.com/doc/refman/8.0/en/extended-show.html.\n\nYou see only those databases for which you have some kind of privilege,\nunless you have the global SHOW DATABASES privilege. You can also get\nthis list using the mysqlshow command.\n\nIf the server was started with the --skip-show-database option, you\ncannot use this statement at all unless you have the SHOW DATABASES\nprivilege.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-databases.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-databases.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (468,2,'SHOW ENGINE','Syntax:\nSHOW ENGINE engine_name {STATUS | MUTEX}\n\nSHOW ENGINE displays operational information about a storage engine. It\nrequires the PROCESS privilege. The statement has these variants:\n\nSHOW ENGINE INNODB STATUS\nSHOW ENGINE INNODB MUTEX\nSHOW ENGINE PERFORMANCE_SCHEMA STATUS\n\nSHOW ENGINE INNODB STATUS displays extensive information from the\nstandard InnoDB Monitor about the state of the InnoDB storage engine.\nFor information about the standard monitor and other InnoDB Monitors\nthat provide information about InnoDB processing, see\nhttp://dev.mysql.com/doc/refman/8.0/en/innodb-monitors.html.\n\nSHOW ENGINE INNODB MUTEX displays InnoDB mutex and rw-lock statistics.\n\n*Note*:\n\nInnoDB mutexes and rwlocks can also be monitored using Performance\nSchema tables. See\nhttp://dev.mysql.com/doc/refman/8.0/en/monitor-innodb-mutex-waits-perfo\nrmance-schema.html.\n\nMutex statistics collection is configured dynamically using the\nfollowing options:\n\no To enable the collection of mutex statistics, run:\n\nSET GLOBAL innodb_monitor_enable=\'latch\';\n\no To reset mutex statistics, run:\n\nSET GLOBAL innodb_monitor_reset=\'latch\';\n\no To disable the collection of mutex statistics, run:\n\nSET GLOBAL innodb_monitor_disable=\'latch\';\n\nCollection of mutex statistics for SHOW ENGINE INNODB MUTEX can also be\nenabled by setting innodb_monitor_enable=\'all\', or disabled by setting\ninnodb_monitor_disable=\'all\'.\n\nSHOW ENGINE INNODB MUTEX output has these columns:\n\no Type\n\n  Always InnoDB.\n\no Name\n\n  For mutexes, the Name field reports only the mutex name. For rwlocks,\n  the Name field reports the source file where the rwlock is\n  implemented, and the line number in the file where the rwlock is\n  created. The line number is specific to your version of MySQL.\n\no Status\n\n  The mutex status. This field reports the number of spins, waits, and\n  calls. Statistics for low-level operating system mutexes, which are\n  implemented outside of InnoDB, are not reported.\n\n  o spins indicates the number of spins.\n\n  o waits indicates the number of mutex waits.\n\n  o calls indicates how many times the mutex was requested.\n\nSHOW ENGINE INNODB MUTEX skips the mutexes and rw-locks of buffer pool\nblocks, as the amount of output can be overwhelming on systems with a\nlarge buffer pool. (There is one mutex and one rw-lock in each 16K\nbuffer pool block, and there are 65,536 blocks per gigabyte.) SHOW\nENGINE INNODB MUTEX also does not list any mutexes or rw-locks that\nhave never been waited on (os_waits=0). Thus, SHOW ENGINE INNODB MUTEX\nonly displays information about mutexes and rw-locks outside of the\nbuffer pool that have caused at least one OS-level wait.\n\nUse SHOW ENGINE PERFORMANCE_SCHEMA STATUS to inspect the internal\noperation of the Performance Schema code:\n\nmysql> SHOW ENGINE PERFORMANCE_SCHEMA STATUS\\G\n...\n*************************** 3. row ***************************\n  Type: performance_schema\n  Name: events_waits_history.size\nStatus: 76\n*************************** 4. row ***************************\n  Type: performance_schema\n  Name: events_waits_history.count\nStatus: 10000\n*************************** 5. row ***************************\n  Type: performance_schema\n  Name: events_waits_history.memory\nStatus: 760000\n...\n*************************** 57. row ***************************\n  Type: performance_schema\n  Name: performance_schema.memory\nStatus: 26459600\n...\n\nThis statement is intended to help the DBA understand the effects that\ndifferent Performance Schema options have on memory requirements.\n\nName values consist of two parts, which name an internal buffer and a\nbuffer attribute, respectively. Interpret buffer names as follows:\n\no An internal buffer that is not exposed as a table is named within\n  parentheses. Examples: (pfs_cond_class).size,\n  (pfs_mutex_class).memory.\n\no An internal buffer that is exposed as a table in the\n  performance_schema database is named after the table, without\n  parentheses. Examples: events_waits_history.size,\n  mutex_instances.count.\n\no A value that applies to the Performance Schema as a whole begins with\n  performance_schema. Example: performance_schema.memory.\n\nBuffer attributes have these meanings:\n\no size is the size of the internal record used by the implementation,\n  such as the size of a row in a table. size values cannot be changed.\n\no count is the number of internal records, such as the number of rows\n  in a table. count values can be changed using Performance Schema\n  configuration options.\n\no For a table, tbl_name.memory is the product of size and count. For\n  the Performance Schema as a whole, performance_schema.memory is the\n  sum of all the memory used (the sum of all other memory values).\n\nIn some cases, there is a direct relationship between a Performance\nSchema configuration parameter and a SHOW ENGINE value. For example,\nevents_waits_history_long.count corresponds to\nperformance_schema_events_waits_history_long_size. In other cases, the\nrelationship is more complex. For example, events_waits_history.count\ncorresponds to performance_schema_events_waits_history_size (the number\nof rows per thread) multiplied by\nperformance_schema_max_thread_instances ( the number of threads).\n\nSHOW ENGINE NDB STATUS If the server has the NDB storage engine\nenabled, SHOW ENGINE NDB STATUS displays cluster status information\nsuch as the number of connected data nodes, the cluster connectstring,\nand cluster binary log epochs, as well as counts of various Cluster API\nobjects created by the MySQL Server when connected to the cluster.\nSample output from this statement is shown here:\n\nmysql> SHOW ENGINE NDB STATUS;\n+------------+-----------------------+--------------------------------------------------+\n| Type       | Name                  | Status                                           |\n+------------+-----------------------+--------------------------------------------------+\n| ndbcluster | connection            | cluster_node_id=7,\n  connected_host=198.51.100.103, connected_port=1186, number_of_data_nodes=4,\n  number_of_ready_data_nodes=3, connect_count=0                                         |\n| ndbcluster | NdbTransaction        | created=6, free=0, sizeof=212                    |\n| ndbcluster | NdbOperation          | created=8, free=8, sizeof=660                    |\n| ndbcluster | NdbIndexScanOperation | created=1, free=1, sizeof=744                    |\n| ndbcluster | NdbIndexOperation     | created=0, free=0, sizeof=664                    |\n| ndbcluster | NdbRecAttr            | created=1285, free=1285, sizeof=60               |\n| ndbcluster | NdbApiSignal          | created=16, free=16, sizeof=136                  |\n| ndbcluster | NdbLabel              | created=0, free=0, sizeof=196                    |\n| ndbcluster | NdbBranch             | created=0, free=0, sizeof=24                     |\n| ndbcluster | NdbSubroutine         | created=0, free=0, sizeof=68                     |\n| ndbcluster | NdbCall               | created=0, free=0, sizeof=16                     |\n| ndbcluster | NdbBlob               | created=1, free=1, sizeof=264                    |\n| ndbcluster | NdbReceiver           | created=4, free=0, sizeof=68                     |\n| ndbcluster | binlog                | latest_epoch=155467, latest_trans_epoch=148126,\n  latest_received_binlog_epoch=0, latest_handled_binlog_epoch=0,\n  latest_applied_binlog_epoch=0                                                         |\n+------------+-----------------------+--------------------------------------------------+\n\nThe Status column in each of these rows provides information about the\nMySQL server\'s connection to the cluster and about the cluster binary\nlog\'s status, respectively. The Status information is in the form of\ncomma-delimited set of name/value pairs.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-engine.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-engine.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (469,2,'SHOW ENGINES','Syntax:\nSHOW [STORAGE] ENGINES\n\nSHOW ENGINES displays status information about the server\'s storage\nengines. This is particularly useful for checking whether a storage\nengine is supported, or to see what the default engine is.\n\nFor information about MySQL storage engines, see\nhttp://dev.mysql.com/doc/refman/8.0/en/innodb-storage-engine.html, and\nhttp://dev.mysql.com/doc/refman/8.0/en/storage-engines.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-engines.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-engines.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (470,2,'SHOW ERRORS','Syntax:\nSHOW ERRORS [LIMIT [offset,] row_count]\nSHOW COUNT(*) ERRORS\n\nSHOW ERRORS is a diagnostic statement that is similar to SHOW WARNINGS,\nexcept that it displays information only for errors, rather than for\nerrors, warnings, and notes.\n\nThe LIMIT clause has the same syntax as for the SELECT statement. See\nhttp://dev.mysql.com/doc/refman/8.0/en/select.html.\n\nThe SHOW COUNT(*) ERRORS statement displays the number of errors. You\ncan also retrieve this number from the error_count variable:\n\nSHOW COUNT(*) ERRORS;\nSELECT @@error_count;\n\nSHOW ERRORS and error_count apply only to errors, not warnings or\nnotes. In other respects, they are similar to SHOW WARNINGS and\nwarning_count. In particular, SHOW ERRORS cannot display information\nfor more than max_error_count messages, and error_count can exceed the\nvalue of max_error_count if the number of errors exceeds\nmax_error_count.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-errors.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-errors.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (471,2,'SHOW EVENTS','Syntax:\nSHOW EVENTS\n    [{FROM | IN} schema_name]\n    [LIKE \'pattern\' | WHERE expr]\n\nThis statement displays information about Event Manager events, which\nare discussed in\nhttp://dev.mysql.com/doc/refman/8.0/en/event-scheduler.html. It\nrequires the EVENT privilege for the database from which the events are\nto be shown.\n\nIn its simplest form, SHOW EVENTS lists all of the events in the\ncurrent schema:\n\nmysql> SELECT CURRENT_USER(), SCHEMA();\n+----------------+----------+\n| CURRENT_USER() | SCHEMA() |\n+----------------+----------+\n| jon@ghidora    | myschema |\n+----------------+----------+\n1 row in set (0.00 sec)\n\nmysql> SHOW EVENTS\\G\n*************************** 1. row ***************************\n                  Db: myschema\n                Name: e_daily\n             Definer: jon@ghidora\n           Time zone: SYSTEM\n                Type: RECURRING\n          Execute at: NULL\n      Interval value: 1\n      Interval field: DAY\n              Starts: 2018-08-08 11:06:34\n                Ends: NULL\n              Status: ENABLED\n          Originator: 1\ncharacter_set_client: utf8mb4\ncollation_connection: utf8mb4_0900_ai_ci\n  Database Collation: utf8mb4_0900_ai_ci\n\nTo see events for a specific schema, use the FROM clause. For example,\nto see events for the test schema, use the following statement:\n\nSHOW EVENTS FROM test;\n\nThe LIKE clause, if present, indicates which event names to match. The\nWHERE clause can be given to select rows using more general conditions,\nas discussed in\nhttp://dev.mysql.com/doc/refman/8.0/en/extended-show.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-events.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-events.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (472,2,'SHOW FUNCTION CODE','Syntax:\nSHOW FUNCTION CODE func_name\n\nThis statement is similar to SHOW PROCEDURE CODE but for stored\nfunctions. See [HELP SHOW PROCEDURE CODE].\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-function-code.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-function-code.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (473,2,'SHOW FUNCTION STATUS','Syntax:\nSHOW FUNCTION STATUS\n    [LIKE \'pattern\' | WHERE expr]\n\nThis statement is similar to SHOW PROCEDURE STATUS but for stored\nfunctions. See [HELP SHOW PROCEDURE STATUS].\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-function-status.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-function-status.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (474,2,'SHOW GRANTS','Syntax:\nSHOW GRANTS\n    [FOR user_or_role\n        [USING role [, role] ...]]\n\nuser_or_role: {\n    user\n  | role\n}\n\nThis statement displays the privileges and roles that are assigned to a\nMySQL user account or role, in the form of GRANT statements that must\nbe executed to duplicate the privilege and role assignments.\n\n*Note*:\n\nTo display nonprivilege information for MySQL accounts, use the SHOW\nCREATE USER statement. See [HELP SHOW CREATE USER].\n\nSHOW GRANTS requires the SELECT privilege for the mysql system\ndatabase, except to display privileges and roles for the current user.\n\nTo name the account or role for SHOW GRANTS, use the same format as for\nthe GRANT statement; for example, \'jeffrey\'@\'localhost\':\n\nmysql> SHOW GRANTS FOR \'jeffrey\'@\'localhost\';\n+------------------------------------------------------------------+\n| Grants for jeffrey@localhost                                     |\n+------------------------------------------------------------------+\n| GRANT USAGE ON *.* TO `jeffrey`@`localhost`                      |\n| GRANT SELECT, INSERT, UPDATE ON `db1`.* TO `jeffrey`@`localhost` |\n+------------------------------------------------------------------+\n\nThe host part, if omitted, defaults to \'%\'. For additional information\nabout specifying account and role names, see\nhttp://dev.mysql.com/doc/refman/8.0/en/account-names.html, and\nhttp://dev.mysql.com/doc/refman/8.0/en/role-names.html.\n\nTo display the privileges granted to the current user (the account you\nare using to connect to the server), you can use any of the following\nstatements:\n\nSHOW GRANTS;\nSHOW GRANTS FOR CURRENT_USER;\nSHOW GRANTS FOR CURRENT_USER();\n\nIf SHOW GRANTS FOR CURRENT_USER (or any of the equivalent syntaxes) is\nused in definer context, such as within a stored procedure that\nexecutes with definer rather than invoker privileges, the grants\ndisplayed are those of the definer and not the invoker.\n\nIn MySQL 8.0 compared to previous series, SHOW GRANTS no longer\ndisplays ALL PRIVILEGES in its global-privileges output because the\nmeaning of ALL PRIVILEGES at the global level varies depending on which\ndynamic privileges are defined. Instead, SHOW GRANTS explictly lists\neach granted global privilege:\n\nmysql> SHOW GRANTS FOR \'root\'@\'localhost\';\n+---------------------------------------------------------------------+\n| Grants for root@localhost                                           |\n+---------------------------------------------------------------------+\n| GRANT SELECT, INSERT, UPDATE, DELETE, CREATE, DROP, RELOAD,         |\n| SHUTDOWN, PROCESS, FILE, REFERENCES, INDEX, ALTER, SHOW DATABASES,  |\n| SUPER, CREATE TEMPORARY TABLES, LOCK TABLES, EXECUTE, REPLICATION   |\n| SLAVE, REPLICATION CLIENT, CREATE VIEW, SHOW VIEW, CREATE ROUTINE,  |\n| ALTER ROUTINE, CREATE USER, EVENT, TRIGGER, CREATE TABLESPACE,      |\n| CREATE ROLE, DROP ROLE ON *.* TO `root`@`localhost` WITH GRANT      |\n| OPTION                                                              |\n| GRANT PROXY ON \'\'@\'\' TO \'root\'@\'localhost\' WITH GRANT OPTION        |\n+---------------------------------------------------------------------+\n\nApplications that process SHOW GRANTS output should be adjusted\naccordingly.\n\nAt the global level, GRANT OPTION applies to all granted static global\nprivileges if granted for any of them, but applies individually to\ngranted dynamic privileges. SHOW GRANTS displays global privileges this\nway:\n\no One line listing all granted static privileges, if there are any,\n  including WITH GRANT OPTION if appropriate.\n\no One line listing all granted dynamic privileges for which GRANT\n  OPTION is granted, if there are any, including WITH GRANT OPTION.\n\no One line listing all granted dynamic privileges for which GRANT\n  OPTION is not granted, if there are any, without WITH GRANT OPTION.\n\nWith the optional USING clause, SHOW GRANTS enables you to examine the\nprivileges associated with roles for the user. Each role named in the\nUSING clause must be granted to the user.\n\nSuppose that user u1 is assigned roles r1 and r2, as follows:\n\nCREATE ROLE \'r1\', \'r2\';\nGRANT SELECT ON db1.* TO \'r1\';\nGRANT INSERT, UPDATE, DELETE ON db1.* TO \'r2\';\nCREATE USER \'u1\'@\'localhost\' IDENTIFIED BY \'u1pass\';\nGRANT \'r1\', \'r2\' TO \'u1\'@\'localhost\';\n\nSHOW GRANTS without USING shows the granted roles:\n\nmysql> SHOW GRANTS FOR \'u1\'@\'localhost\';\n+---------------------------------------------+\n| Grants for u1@localhost                     |\n+---------------------------------------------+\n| GRANT USAGE ON *.* TO `u1`@`localhost`      |\n| GRANT `r1`@`%`,`r2`@`%` TO `u1`@`localhost` |\n+---------------------------------------------+\n\nAdding a USING clause causes the statement to also display the\nprivileges associated with each role named in the clause:\n\nmysql> SHOW GRANTS FOR \'u1\'@\'localhost\' USING \'r1\';\n+---------------------------------------------+\n| Grants for u1@localhost                     |\n+---------------------------------------------+\n| GRANT USAGE ON *.* TO `u1`@`localhost`      |\n| GRANT SELECT ON `db1`.* TO `u1`@`localhost` |\n| GRANT `r1`@`%`,`r2`@`%` TO `u1`@`localhost` |\n+---------------------------------------------+\nmysql> SHOW GRANTS FOR \'u1\'@\'localhost\' USING \'r2\';\n+-------------------------------------------------------------+\n| Grants for u1@localhost                                     |\n+-------------------------------------------------------------+\n| GRANT USAGE ON *.* TO `u1`@`localhost`                      |\n| GRANT INSERT, UPDATE, DELETE ON `db1`.* TO `u1`@`localhost` |\n| GRANT `r1`@`%`,`r2`@`%` TO `u1`@`localhost`                 |\n+-------------------------------------------------------------+\nmysql> SHOW GRANTS FOR \'u1\'@\'localhost\' USING \'r1\', \'r2\';\n+---------------------------------------------------------------------+\n| Grants for u1@localhost                                             |\n+---------------------------------------------------------------------+\n| GRANT USAGE ON *.* TO `u1`@`localhost`                              |\n| GRANT SELECT, INSERT, UPDATE, DELETE ON `db1`.* TO `u1`@`localhost` |\n| GRANT `r1`@`%`,`r2`@`%` TO `u1`@`localhost`                         |\n+---------------------------------------------------------------------+\n\n*Note*:\n\nA privilege granted to an account is always in effect, but a role is\nnot. The active roles for an account can differ across and within\nsessions, depending on the value of the activate_all_roles_on_login\nsystem variable, the account default roles, and whether SET ROLE has\nbeen executed within a session.\n\nSHOW GRANTS does not display privileges that are available to the named\naccount but are granted to a different account. For example, if an\nanonymous account exists, the named account might be able to use its\nprivileges, but SHOW GRANTS does not display them.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-grants.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-grants.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (475,2,'SHOW INDEX','Syntax:\nSHOW [EXTENDED] {INDEX | INDEXES | KEYS}\n    {FROM | IN} tbl_name\n    [{FROM | IN} db_name]\n    [WHERE expr]\n\nSHOW INDEX returns table index information. The format resembles that\nof the SQLStatistics call in ODBC. This statement requires some\nprivilege for any column in the table.\n\nmysql> SHOW INDEX FROM City\\G\n*************************** 1. row ***************************\n        Table: city\n   Non_unique: 0\n     Key_name: PRIMARY\n Seq_in_index: 1\n  Column_name: ID\n    Collation: A\n  Cardinality: 4188\n     Sub_part: NULL\n       Packed: NULL\n         Null:\n   Index_type: BTREE\n      Comment:\nIndex_comment:\n      Visible: YES\n   Expression: NULL\n*************************** 2. row ***************************\n        Table: city\n   Non_unique: 1\n     Key_name: CountryCode\n Seq_in_index: 1\n  Column_name: CountryCode\n    Collation: A\n  Cardinality: 232\n     Sub_part: NULL\n       Packed: NULL\n         Null:\n   Index_type: BTREE\n      Comment:\nIndex_comment:\n      Visible: YES\n   Expression: NULL\n\nAn alternative to tbl_name FROM db_name syntax is db_name.tbl_name.\nThese two statements are equivalent:\n\nSHOW INDEX FROM mytable FROM mydb;\nSHOW INDEX FROM mydb.mytable;\n\nThe optional EXTENDED keyword causes the output to include information\nabout hidden indexes that MySQL uses internally and are not accessible\nby users.\n\nThe WHERE clause can be given to select rows using more general\nconditions, as discussed in\nhttp://dev.mysql.com/doc/refman/8.0/en/extended-show.html.\n\nSHOW INDEX returns the following fields:\n\no Table\n\n  The name of the table.\n\no Non_unique\n\n  0 if the index cannot contain duplicates, 1 if it can.\n\no Key_name\n\n  The name of the index. If the index is the primary key, the name is\n  always PRIMARY.\n\no Seq_in_index\n\n  The column sequence number in the index, starting with 1.\n\no Column_name\n\n  The column name. See also the description for the Expression column.\n\no Collation\n\n  How the column is sorted in the index. This can have values A\n  (ascending), D (descending), or NULL (not sorted).\n\no Cardinality\n\n  An estimate of the number of unique values in the index. To update\n  this number, run ANALYZE TABLE or (for MyISAM tables) myisamchk -a.\n\n  Cardinality is counted based on statistics stored as integers, so the\n  value is not necessarily exact even for small tables. The higher the\n  cardinality, the greater the chance that MySQL uses the index when\n  doing joins.\n\no Sub_part\n\n  The index prefix. That is, the number of indexed characters if the\n  column is only partly indexed, NULL if the entire column is indexed.\n\n  *Note*:\n\n  Prefix limits are measured in bytes. However, prefix lengths for\n  index specifications in CREATE TABLE, ALTER TABLE, and CREATE INDEX\n  statements are interpreted as number of characters for nonbinary\n  string types (CHAR, VARCHAR, TEXT) and number of bytes for binary\n  string types (BINARY, VARBINARY, BLOB). Take this into account when\n  specifying a prefix length for a nonbinary string column that uses a\n  multibyte character set.\n\n  For additional information about index prefixes, see\n  http://dev.mysql.com/doc/refman/8.0/en/column-indexes.html, and [HELP\n  CREATE INDEX].\n\no Packed\n\n  Indicates how the key is packed. NULL if it is not.\n\no Null\n\n  Contains YES if the column may contain NULL values and \'\' if not.\n\no Index_type\n\n  The index method used (BTREE, FULLTEXT, HASH, RTREE).\n\no Comment\n\n  Information about the index not described in its own column, such as\n  disabled if the index is disabled.\n\no Index_comment\n\n  Any comment provided for the index with a COMMENT attribute when the\n  index was created.\n\no Visible\n\n  Whether the index is visible to the optimizer. See\n  http://dev.mysql.com/doc/refman/8.0/en/invisible-indexes.html.\n\no Expression\n\n  MySQL 8.0.13 and higher supports functional key parts (see\n  http://dev.mysql.com/doc/refman/8.0/en/create-index.html#create-index\n  -functional-key-parts), which affects both the Column_name and\n  Expression columns:\n\n  o For a nonfunctional key part, Column_name indicates the column\n    indexed by the key part and Expression is NULL.\n\n  o For a functional key part, Column_name column is NULL and\n    Expression indicates the expression for the key part.\n\nInformation about table indexes is also available from the\nINFORMATION_SCHEMA STATISTICS table. See\nhttp://dev.mysql.com/doc/refman/8.0/en/statistics-table.html. The\nextended information about hidden indexes is available only using SHOW\nEXTENDED INDEX; it cannot be obtained from the STATISTICS table.\n\nYou can list a table\'s indexes with the mysqlshow -k db_name tbl_name\ncommand.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-index.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-index.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (476,2,'SHOW MASTER STATUS','Syntax:\nSHOW MASTER STATUS\n\nThis statement provides status information about the binary log files\nof the master. It requires either the SUPER or REPLICATION CLIENT\nprivilege.\n\nExample:\n\nmysql> SHOW MASTER STATUS\\G\n*************************** 1. row ***************************\n             File: master-bin.000002\n         Position: 1307\n     Binlog_Do_DB: test\n Binlog_Ignore_DB: manual, mysql\nExecuted_Gtid_Set: 3E11FA47-71CA-11E1-9E33-C80AA9429562:1-5\n1 row in set (0.00 sec)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-master-status.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-master-status.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (477,2,'SHOW OPEN TABLES','Syntax:\nSHOW OPEN TABLES\n    [{FROM | IN} db_name]\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW OPEN TABLES lists the non-TEMPORARY tables that are currently open\nin the table cache. See\nhttp://dev.mysql.com/doc/refman/8.0/en/table-cache.html. The FROM\nclause, if present, restricts the tables shown to those present in the\ndb_name database. The LIKE clause, if present, indicates which table\nnames to match. The WHERE clause can be given to select rows using more\ngeneral conditions, as discussed in\nhttp://dev.mysql.com/doc/refman/8.0/en/extended-show.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-open-tables.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-open-tables.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (478,2,'SHOW PLUGINS','Syntax:\nSHOW PLUGINS\n\nSHOW PLUGINS displays information about server plugins.\n\nExample of SHOW PLUGINS output:\n\nmysql> SHOW PLUGINS\\G\n*************************** 1. row ***************************\n   Name: binlog\n Status: ACTIVE\n   Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n*************************** 2. row ***************************\n   Name: CSV\n Status: ACTIVE\n   Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n*************************** 3. row ***************************\n   Name: MEMORY\n Status: ACTIVE\n   Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n*************************** 4. row ***************************\n   Name: MyISAM\n Status: ACTIVE\n   Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n...\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-plugins.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-plugins.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (479,2,'SHOW PRIVILEGES','Syntax:\nSHOW PRIVILEGES\n\nSHOW PRIVILEGES shows the list of system privileges that the MySQL\nserver supports. The privileges displayed include all static\nprivileges, and all currently registered dynamic privileges.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-privileges.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-privileges.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (480,2,'SHOW PROCEDURE CODE','Syntax:\nSHOW PROCEDURE CODE proc_name\n\nThis statement is a MySQL extension that is available only for servers\nthat have been built with debugging support. It displays a\nrepresentation of the internal implementation of the named stored\nprocedure. A similar statement, SHOW FUNCTION CODE, displays\ninformation about stored functions (see [HELP SHOW FUNCTION CODE]).\n\nTo use either statement, you must have the global SELECT privilege.\n\nIf the named routine is available, each statement produces a result\nset. Each row in the result set corresponds to one "instruction" in the\nroutine. The first column is Pos, which is an ordinal number beginning\nwith 0. The second column is Instruction, which contains an SQL\nstatement (usually changed from the original source), or a directive\nwhich has meaning only to the stored-routine handler.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-procedure-code.html\n\n','mysql> DELIMITER //\nmysql> CREATE PROCEDURE p1 ()\n    -> BEGIN\n    ->   DECLARE fanta INT DEFAULT 55;\n    ->   DROP TABLE t2;\n    ->   LOOP\n    ->     INSERT INTO t3 VALUES (fanta);\n    ->     END LOOP;\n    ->   END//\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SHOW PROCEDURE CODE p1//\n+-----+----------------------------------------+\n| Pos | Instruction                            |\n+-----+----------------------------------------+\n|   0 | set fanta@0 55                         |\n|   1 | stmt 9 "DROP TABLE t2"                 |\n|   2 | stmt 5 "INSERT INTO t3 VALUES (fanta)" |\n|   3 | jump 2                                 |\n+-----+----------------------------------------+\n4 rows in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/8.0/en/show-procedure-code.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (481,2,'SHOW PROCEDURE STATUS','Syntax:\nSHOW PROCEDURE STATUS\n    [LIKE \'pattern\' | WHERE expr]\n\nThis statement is a MySQL extension. It returns characteristics of a\nstored procedure, such as the database, name, type, creator, creation\nand modification dates, and character set information. A similar\nstatement, SHOW FUNCTION STATUS, displays information about stored\nfunctions (see [HELP SHOW FUNCTION STATUS]).\n\nThe LIKE clause, if present, indicates which procedure or function\nnames to match. The WHERE clause can be given to select rows using more\ngeneral conditions, as discussed in\nhttp://dev.mysql.com/doc/refman/8.0/en/extended-show.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-procedure-status.html\n\n','mysql> SHOW PROCEDURE STATUS LIKE \'sp1\'\\G\n*************************** 1. row ***************************\n                  Db: test\n                Name: sp1\n                Type: PROCEDURE\n             Definer: testuser@localhost\n            Modified: 2018-08-08 13:54:11\n             Created: 2018-08-08 13:54:11\n       Security_type: DEFINER\n             Comment:\ncharacter_set_client: utf8mb4\ncollation_connection: utf8mb4_0900_ai_ci\n  Database Collation: utf8mb4_0900_ai_ci\n','http://dev.mysql.com/doc/refman/8.0/en/show-procedure-status.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (482,2,'SHOW PROCESSLIST','Syntax:\nSHOW [FULL] PROCESSLIST\n\nSHOW PROCESSLIST shows which threads are running. If you have the\nPROCESS privilege, you can see all threads. Otherwise, you can see only\nyour own threads (that is, threads associated with the MySQL account\nthat you are using). If you do not use the FULL keyword, only the first\n100 characters of each statement are shown in the Info field.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-processlist.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-processlist.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (483,2,'SHOW PROFILE','Syntax:\nSHOW PROFILE [type [, type] ... ]\n    [FOR QUERY n]\n    [LIMIT row_count [OFFSET offset]]\n\ntype: {\n    ALL\n  | BLOCK IO\n  | CONTEXT SWITCHES\n  | CPU\n  | IPC\n  | MEMORY\n  | PAGE FAULTS\n  | SOURCE\n  | SWAPS\n}\n\nThe SHOW PROFILE and SHOW PROFILES statements display profiling\ninformation that indicates resource usage for statements executed\nduring the course of the current session.\n\n*Note*:\n\nThe SHOW PROFILE and SHOW PROFILES statements are deprecated and will\nbe removed in a future MySQL release. Use the Performance Schema\ninstead; see\nhttp://dev.mysql.com/doc/refman/8.0/en/performance-schema-query-profili\nng.html.\n\nTo control profiling, use the profiling session variable, which has a\ndefault value of 0 (OFF). Enable profiling by setting profiling to 1 or\nON:\n\nmysql> SET profiling = 1;\n\nSHOW PROFILES displays a list of the most recent statements sent to the\nserver. The size of the list is controlled by the\nprofiling_history_size session variable, which has a default value of\n15. The maximum value is 100. Setting the value to 0 has the practical\neffect of disabling profiling.\n\nAll statements are profiled except SHOW PROFILE and SHOW PROFILES, so\nyou will find neither of those statements in the profile list.\nMalformed statements are profiled. For example, SHOW PROFILING is an\nillegal statement, and a syntax error occurs if you try to execute it,\nbut it will show up in the profiling list.\n\nSHOW PROFILE displays detailed information about a single statement.\nWithout the FOR QUERY n clause, the output pertains to the most\nrecently executed statement. If FOR QUERY n is included, SHOW PROFILE\ndisplays information for statement n. The values of n correspond to the\nQuery_ID values displayed by SHOW PROFILES.\n\nThe LIMIT row_count clause may be given to limit the output to\nrow_count rows. If LIMIT is given, OFFSET offset may be added to begin\nthe output offset rows into the full set of rows.\n\nBy default, SHOW PROFILE displays Status and Duration columns. The\nStatus values are like the State values displayed by SHOW PROCESSLIST,\nalthough there might be some minor differences in interpretion for the\ntwo statements for some status values (see\nhttp://dev.mysql.com/doc/refman/8.0/en/thread-information.html).\n\nOptional type values may be specified to display specific additional\ntypes of information:\n\no ALL displays all information\n\no BLOCK IO displays counts for block input and output operations\n\no CONTEXT SWITCHES displays counts for voluntary and involuntary\n  context switches\n\no CPU displays user and system CPU usage times\n\no IPC displays counts for messages sent and received\n\no MEMORY is not currently implemented\n\no PAGE FAULTS displays counts for major and minor page faults\n\no SOURCE displays the names of functions from the source code, together\n  with the name and line number of the file in which the function\n  occurs\n\no SWAPS displays swap counts\n\nProfiling is enabled per session. When a session ends, its profiling\ninformation is lost.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-profile.html\n\n','mysql> SELECT @@profiling;\n+-------------+\n| @@profiling |\n+-------------+\n|           0 |\n+-------------+\n1 row in set (0.00 sec)\n\nmysql> SET profiling = 1;\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> DROP TABLE IF EXISTS t1;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nmysql> CREATE TABLE T1 (id INT);\nQuery OK, 0 rows affected (0.01 sec)\n\nmysql> SHOW PROFILES;\n+----------+----------+--------------------------+\n| Query_ID | Duration | Query                    |\n+----------+----------+--------------------------+\n|        0 | 0.000088 | SET PROFILING = 1        |\n|        1 | 0.000136 | DROP TABLE IF EXISTS t1  |\n|        2 | 0.011947 | CREATE TABLE t1 (id INT) |\n+----------+----------+--------------------------+\n3 rows in set (0.00 sec)\n\nmysql> SHOW PROFILE;\n+----------------------+----------+\n| Status               | Duration |\n+----------------------+----------+\n| checking permissions | 0.000040 |\n| creating table       | 0.000056 |\n| After create         | 0.011363 |\n| query end            | 0.000375 |\n| freeing items        | 0.000089 |\n| logging slow query   | 0.000019 |\n| cleaning up          | 0.000005 |\n+----------------------+----------+\n7 rows in set (0.00 sec)\n\nmysql> SHOW PROFILE FOR QUERY 1;\n+--------------------+----------+\n| Status             | Duration |\n+--------------------+----------+\n| query end          | 0.000107 |\n| freeing items      | 0.000008 |\n| logging slow query | 0.000015 |\n| cleaning up        | 0.000006 |\n+--------------------+----------+\n4 rows in set (0.00 sec)\n\nmysql> SHOW PROFILE CPU FOR QUERY 2;\n+----------------------+----------+----------+------------+\n| Status               | Duration | CPU_user | CPU_system |\n+----------------------+----------+----------+------------+\n| checking permissions | 0.000040 | 0.000038 |   0.000002 |\n| creating table       | 0.000056 | 0.000028 |   0.000028 |\n| After create         | 0.011363 | 0.000217 |   0.001571 |\n| query end            | 0.000375 | 0.000013 |   0.000028 |\n| freeing items        | 0.000089 | 0.000010 |   0.000014 |\n| logging slow query   | 0.000019 | 0.000009 |   0.000010 |\n| cleaning up          | 0.000005 | 0.000003 |   0.000002 |\n+----------------------+----------+----------+------------+\n7 rows in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/8.0/en/show-profile.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (484,2,'SHOW PROFILES','Syntax:\nSHOW PROFILES\n\nThe SHOW PROFILES statement, together with SHOW PROFILE, displays\nprofiling information that indicates resource usage for statements\nexecuted during the course of the current session. For more\ninformation, see [HELP SHOW PROFILE].\n\n*Note*:\n\nThe SHOW PROFILE and SHOW PROFILES statements are deprecated and will\nbe removed in a future MySQL release. Use the Performance Schema\ninstead; see\nhttp://dev.mysql.com/doc/refman/8.0/en/performance-schema-query-profili\nng.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-profiles.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-profiles.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (485,2,'SHOW RELAYLOG EVENTS','Syntax:\nSHOW RELAYLOG EVENTS\n    [IN \'log_name\']\n    [FROM pos]\n    [LIMIT [offset,] row_count]\n    [channel_option]\n\nchannel_option:\n    FOR CHANNEL channel\n\nShows the events in the relay log of a replication slave. If you do not\nspecify \'log_name\', the first relay log is displayed. This statement\nhas no effect on the master.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-relaylog-events.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-relaylog-events.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (486,2,'SHOW SLAVE HOSTS','Syntax:\nSHOW SLAVE HOSTS\n\nDisplays a list of replication slaves currently registered with the\nmaster.\n\nSHOW SLAVE HOSTS should be executed on a server that acts as a\nreplication master. The statement displays information about servers\nthat are or have been connected as replication slaves, with each row of\nthe result corresponding to one slave server, as shown here:\n\nmysql> SHOW SLAVE HOSTS;\n+------------+-----------+------+-----------+--------------------------------------+\n| Server_id  | Host      | Port | Master_id | Slave_UUID                           |\n+------------+-----------+------+-----------+--------------------------------------+\n|  192168010 | iconnect2 | 3306 | 192168011 | 14cb6624-7f93-11e0-b2c0-c80aa9429562 |\n| 1921680101 | athena    | 3306 | 192168011 | 07af4990-f41f-11df-a566-7ac56fdaf645 |\n+------------+-----------+------+-----------+--------------------------------------+\n\no Server_id: The unique server ID of the slave server, as configured in\n  the slave server\'s option file, or on the command line with\n  --server-id=value.\n\no Host: The host name of the slave server as specified on the slave\n  with the --report-host option. This can differ from the machine name\n  as configured in the operating system.\n\no User: The slave server user name as, specified on the slave with the\n  --report-user option. Statement output includes this column only if\n  the master server is started with the --show-slave-auth-info option.\n\no Password: The slave server password as, specified on the slave with\n  the --report-password option. Statement output includes this column\n  only if the master server is started with the --show-slave-auth-info\n  option.\n\no Port: The port on the master to which the slave server is listening,\n  as specified on the slave with the --report-port option.\n\n  A zero in this column means that the slave port (--report-port) was\n  not set.\n\no Master_id: The unique server ID of the master server that the slave\n  server is replicating from. This is the server ID of the server on\n  which SHOW SLAVE HOSTS is executed, so this same value is listed for\n  each row in the result.\n\no Slave_UUID: The globally unique ID of this slave, as generated on the\n  slave and found in the slave\'s auto.cnf file.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-slave-hosts.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-slave-hosts.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (487,2,'SHOW SLAVE STATUS','Syntax:\nSHOW SLAVE STATUS [FOR CHANNEL channel]\n\nThis statement provides status information on essential parameters of\nthe slave threads. It requires either the SUPER or REPLICATION CLIENT\nprivilege.\n\nSHOW SLAVE STATUS is nonblocking. When run concurrently with STOP\nSLAVE, SHOW SLAVE STATUS returns without waiting for STOP SLAVE to\nfinish shutting down the slave SQL thread or slave I/O thread (or\nboth). This permits use in monitoring and other applications where\ngetting an immediate response from SHOW SLAVE STATUS more important\nthan ensuring that it returned the latest data.\n\nIf you issue this statement using the mysql client, you can use a \\G\nstatement terminator rather than a semicolon to obtain a more readable\nvertical layout:\n\nmysql> SHOW SLAVE STATUS\\G\n*************************** 1. row ***************************\n               Slave_IO_State: Waiting for master to send event\n                  Master_Host: localhost\n                  Master_User: repl\n                  Master_Port: 13000\n                Connect_Retry: 60\n              Master_Log_File: master-bin.000002\n          Read_Master_Log_Pos: 1307\n               Relay_Log_File: slave-relay-bin.000003\n                Relay_Log_Pos: 1508\n        Relay_Master_Log_File: master-bin.000002\n             Slave_IO_Running: Yes\n            Slave_SQL_Running: Yes\n              Replicate_Do_DB:\n          Replicate_Ignore_DB:\n           Replicate_Do_Table:\n       Replicate_Ignore_Table:\n      Replicate_Wild_Do_Table:\n  Replicate_Wild_Ignore_Table:\n                   Last_Errno: 0\n                   Last_Error:\n                 Skip_Counter: 0\n          Exec_Master_Log_Pos: 1307\n              Relay_Log_Space: 1858\n              Until_Condition: None\n               Until_Log_File:\n                Until_Log_Pos: 0\n           Master_SSL_Allowed: No\n           Master_SSL_CA_File:\n           Master_SSL_CA_Path:\n              Master_SSL_Cert:\n            Master_SSL_Cipher:\n               Master_SSL_Key:\n        Seconds_Behind_Master: 0\nMaster_SSL_Verify_Server_Cert: No\n                Last_IO_Errno: 0\n                Last_IO_Error:\n               Last_SQL_Errno: 0\n               Last_SQL_Error:\n  Replicate_Ignore_Server_Ids:\n             Master_Server_Id: 1\n                  Master_UUID: 3e11fa47-71ca-11e1-9e33-c80aa9429562\n             Master_Info_File: /var/mysqld.2/data/master.info\n                    SQL_Delay: 0\n          SQL_Remaining_Delay: NULL\n      Slave_SQL_Running_State: Reading event from the relay log\n           Master_Retry_Count: 10\n                  Master_Bind:\n      Last_IO_Error_Timestamp:\n     Last_SQL_Error_Timestamp:\n               Master_SSL_Crl:\n           Master_SSL_Crlpath:\n           Retrieved_Gtid_Set: 3e11fa47-71ca-11e1-9e33-c80aa9429562:1-5\n            Executed_Gtid_Set: 3e11fa47-71ca-11e1-9e33-c80aa9429562:1-5\n                Auto_Position: 1\n         Replicate_Rewrite_DB:\n                 Channel_name:\n           Master_TLS_Version: TLSv1.2\n       Master_public_key_path: public_key.pem\n        Get_master_public_key: 0\n\nThe Performance Schema provides tables that expose replication\ninformation. This is similar to the information available from the SHOW\nSLAVE STATUS statement, but represented in table form. For details, see\nhttp://dev.mysql.com/doc/refman/8.0/en/performance-schema-replication-t\nables.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-slave-status.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-slave-status.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (488,2,'SHOW STATUS','Syntax:\nSHOW [GLOBAL | SESSION] STATUS\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW STATUS provides server status information (see\nhttp://dev.mysql.com/doc/refman/8.0/en/server-status-variables.html).\nThis statement does not require any privilege. It requires only the\nability to connect to the server.\n\nStatus variable information is also available from these sources:\n\no Performance Schema tables. See\n  http://dev.mysql.com/doc/refman/8.0/en/performance-schema-status-vari\n  able-tables.html.\n\no The mysqladmin extended-status command. See\n  http://dev.mysql.com/doc/refman/8.0/en/mysqladmin.html.\n\nFor SHOW STATUS, a LIKE clause, if present, indicates which variable\nnames to match. A WHERE clause can be given to select rows using more\ngeneral conditions, as discussed in\nhttp://dev.mysql.com/doc/refman/8.0/en/extended-show.html.\n\nSHOW STATUS accepts an optional GLOBAL or SESSION variable scope\nmodifier:\n\no With a GLOBAL modifier, the statement displays the global status\n  values. A global status variable may represent status for some aspect\n  of the server itself (for example, Aborted_connects), or the\n  aggregated status over all connections to MySQL (for example,\n  Bytes_received and Bytes_sent). If a variable has no global value,\n  the session value is displayed.\n\no With a SESSION modifier, the statement displays the status variable\n  values for the current connection. If a variable has no session\n  value, the global value is displayed. LOCAL is a synonym for SESSION.\n\no If no modifier is present, the default is SESSION.\n\nThe scope for each status variable is listed at\nhttp://dev.mysql.com/doc/refman/8.0/en/server-status-variables.html.\n\nEach invocation of the SHOW STATUS statement uses an internal temporary\ntable and increments the global Created_tmp_tables value.\nWith a LIKE clause, the statement displays only rows for those\nvariables with names that match the pattern:\n\nmysql> SHOW STATUS LIKE \'Key%\';\n+--------------------+----------+\n| Variable_name      | Value    |\n+--------------------+----------+\n| Key_blocks_used    | 14955    |\n| Key_read_requests  | 96854827 |\n| Key_reads          | 162040   |\n| Key_write_requests | 7589728  |\n| Key_writes         | 3813196  |\n+--------------------+----------+\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-status.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-status.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (489,2,'SHOW TABLE STATUS','Syntax:\nSHOW TABLE STATUS\n    [{FROM | IN} db_name]\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW TABLE STATUS works likes SHOW TABLES, but provides a lot of\ninformation about each non-TEMPORARY table. You can also get this list\nusing the mysqlshow --status db_name command. The LIKE clause, if\npresent, indicates which table names to match. The WHERE clause can be\ngiven to select rows using more general conditions, as discussed in\nhttp://dev.mysql.com/doc/refman/8.0/en/extended-show.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-table-status.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-table-status.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (490,2,'SHOW TABLES','Syntax:\nSHOW [EXTENDED] [FULL] TABLES\n    [{FROM | IN} db_name]\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW TABLES lists the non-TEMPORARY tables in a given database. You can\nalso get this list using the mysqlshow db_name command. The LIKE\nclause, if present, indicates which table names to match. The WHERE\nclause can be given to select rows using more general conditions, as\ndiscussed in http://dev.mysql.com/doc/refman/8.0/en/extended-show.html.\n\nMatching performed by the LIKE clause is dependent on the setting of\nthe lower_case_table_names system variable.\n\nThe optional EXTENDED modifier causes SHOW TABLES to list hidden tables\ncreated by failed ALTER TABLE statements. These temporary tables have\nnames beginning with #sql and can be dropped using DROP TABLE.\n\nThis statement also lists any views in the database. The optional FULL\nmodifier causes SHOW TABLES to display a second output column with\nvalues of BASE TABLE for a table, VIEW for a view, or SYSTEM VIEW for\nan INFORMATION_SCHEMA table.\n\nIf you have no privileges for a base table or view, it does not show up\nin the output from SHOW TABLES or mysqlshow db_name.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-tables.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-tables.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (491,2,'SHOW TRIGGERS','Syntax:\nSHOW TRIGGERS\n    [{FROM | IN} db_name]\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW TRIGGERS lists the triggers currently defined for tables in a\ndatabase (the default database unless a FROM clause is given). This\nstatement returns results only for databases and tables for which you\nhave the TRIGGER privilege. The LIKE clause, if present, indicates\nwhich table names (not trigger names) to match and causes the statement\nto display triggers for those tables. The WHERE clause can be given to\nselect rows using more general conditions, as discussed in\nhttp://dev.mysql.com/doc/refman/8.0/en/extended-show.html.\n\nFor the ins_sum trigger defined in\nhttp://dev.mysql.com/doc/refman/8.0/en/triggers.html, the output of\nSHOW TRIGGERS is as shown here:\n\nmysql> SHOW TRIGGERS LIKE \'acc%\'\\G\n*************************** 1. row ***************************\n             Trigger: ins_sum\n               Event: INSERT\n               Table: account\n           Statement: SET @sum = @sum + NEW.amount\n              Timing: BEFORE\n             Created: 2018-08-08 10:10:12.61\n            sql_mode: ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,\n                      NO_ZERO_IN_DATE,NO_ZERO_DATE,\n                      ERROR_FOR_DIVISION_BY_ZERO,\n                      NO_ENGINE_SUBSTITUTION\n             Definer: me@localhost\ncharacter_set_client: utf8mb4\ncollation_connection: utf8mb4_0900_ai_ci\n  Database Collation: utf8mb4_0900_ai_ci\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-triggers.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-triggers.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (492,2,'SHOW VARIABLES','Syntax:\nSHOW [GLOBAL | SESSION] VARIABLES\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW VARIABLES shows the values of MySQL system variables (see\nhttp://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html).\nThis statement does not require any privilege. It requires only the\nability to connect to the server.\n\nSystem variable information is also available from these sources:\n\no Performance Schema tables. See\n  http://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-vari\n  able-tables.html.\n\no The mysqladmin variables command. See\n  http://dev.mysql.com/doc/refman/8.0/en/mysqladmin.html.\n\nFor SHOW VARIABLES, a LIKE clause, if present, indicates which variable\nnames to match. A WHERE clause can be given to select rows using more\ngeneral conditions, as discussed in\nhttp://dev.mysql.com/doc/refman/8.0/en/extended-show.html.\n\nSHOW VARIABLES accepts an optional GLOBAL or SESSION variable scope\nmodifier:\n\no With a GLOBAL modifier, the statement displays global system variable\n  values. These are the values used to initialize the corresponding\n  session variables for new connections to MySQL. If a variable has no\n  global value, no value is displayed.\n\no With a SESSION modifier, the statement displays the system variable\n  values that are in effect for the current connection. If a variable\n  has no session value, the global value is displayed. LOCAL is a\n  synonym for SESSION.\n\no If no modifier is present, the default is SESSION.\n\nThe scope for each system variable is listed at\nhttp://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html.\n\nSHOW VARIABLES is subject to a version-dependent display-width limit.\nFor variables with very long values that are not completely displayed,\nuse SELECT as a workaround. For example:\n\nSELECT @@GLOBAL.innodb_data_file_path;\n\nMost system variables can be set at server startup (read-only variables\nsuch as version_comment are exceptions). Many can be changed at runtime\nwith the SET statement. See\nhttp://dev.mysql.com/doc/refman/8.0/en/using-system-variables.html, and\n[HELP SET].\nWith a LIKE clause, the statement displays only rows for those\nvariables with names that match the pattern. To obtain the row for a\nspecific variable, use a LIKE clause as shown:\n\nSHOW VARIABLES LIKE \'max_join_size\';\nSHOW SESSION VARIABLES LIKE \'max_join_size\';\n\nTo get a list of variables whose name match a pattern, use the %\nwildcard character in a LIKE clause:\n\nSHOW VARIABLES LIKE \'%size%\';\nSHOW GLOBAL VARIABLES LIKE \'%size%\';\n\nWildcard characters can be used in any position within the pattern to\nbe matched. Strictly speaking, because _ is a wildcard that matches any\nsingle character, you should escape it as \\_ to match it literally. In\npractice, this is rarely necessary.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-variables.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-variables.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (493,2,'SHOW WARNINGS','Syntax:\nSHOW WARNINGS [LIMIT [offset,] row_count]\nSHOW COUNT(*) WARNINGS\n\nSHOW WARNINGS is a diagnostic statement that displays information about\nthe conditions (errors, warnings, and notes) resulting from executing a\nstatement in the current session. Warnings are generated for DML\nstatements such as INSERT, UPDATE, and LOAD DATA as well as DDL\nstatements such as CREATE TABLE and ALTER TABLE.\n\nThe LIMIT clause has the same syntax as for the SELECT statement. See\nhttp://dev.mysql.com/doc/refman/8.0/en/select.html.\n\nSHOW WARNINGS is also used following EXPLAIN, to display the extended\ninformation generated by EXPLAIN. See\nhttp://dev.mysql.com/doc/refman/8.0/en/explain-extended.html.\n\nSHOW WARNINGS displays information about the conditions resulting from\nexecution of the most recent nondiagnostic statement in the current\nsession. If the most recent statement resulted in an error during\nparsing, SHOW WARNINGS shows the resulting conditions, regardless of\nstatement type (diagnostic or nondiagnostic).\n\nThe SHOW COUNT(*) WARNINGS diagnostic statement displays the total\nnumber of errors, warnings, and notes. You can also retrieve this\nnumber from the warning_count system variable:\n\nSHOW COUNT(*) WARNINGS;\nSELECT @@warning_count;\n\nA difference in these statements is that the first is a diagnostic\nstatement that does not clear the message list. The second, because it\nis a SELECT statement is considered nondiagnostic and does clear the\nmessage list.\n\nA related diagnostic statement, SHOW ERRORS, shows only error\nconditions (it excludes warnings and notes), and SHOW COUNT(*) ERRORS\nstatement displays the total number of errors. See [HELP SHOW ERRORS].\nGET DIAGNOSTICS can be used to examine information for individual\nconditions. See [HELP GET DIAGNOSTICS].\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/show-warnings.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/show-warnings.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (494,2,'SHUTDOWN','Syntax:\nSHUTDOWN\n\nThis statement stops the MySQL server. It requires the SHUTDOWN\nprivilege.\n\nSHUTDOWN provides an SQL-level interface to the same functionality\navailable using the mysqladmin shutdown command.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/shutdown.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/shutdown.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (495,30,'SIGN','Syntax:\nSIGN(X)\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X\nis negative, zero, or positive.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT SIGN(-32);\n        -> -1\nmysql> SELECT SIGN(0);\n        -> 0\nmysql> SELECT SIGN(234);\n        -> 1\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (496,6,'SIGNAL','Syntax:\nSIGNAL condition_value\n    [SET signal_information_item\n    [, signal_information_item] ...]\n\ncondition_value: {\n    SQLSTATE [VALUE] sqlstate_value\n  | condition_name\n}\n\nsignal_information_item:\n    condition_information_item_name = simple_value_specification\n\ncondition_information_item_name: {\n    CLASS_ORIGIN\n  | SUBCLASS_ORIGIN\n  | MESSAGE_TEXT\n  | MYSQL_ERRNO\n  | CONSTRAINT_CATALOG\n  | CONSTRAINT_SCHEMA\n  | CONSTRAINT_NAME\n  | CATALOG_NAME\n  | SCHEMA_NAME\n  | TABLE_NAME\n  | COLUMN_NAME\n  | CURSOR_NAME\n}\n\ncondition_name, simple_value_specification:\n    (see following discussion)\n\nSIGNAL is the way to "return" an error. SIGNAL provides error\ninformation to a handler, to an outer portion of the application, or to\nthe client. Also, it provides control over the error\'s characteristics\n(error number, SQLSTATE value, message). Without SIGNAL, it is\nnecessary to resort to workarounds such as deliberately referring to a\nnonexistent table to cause a routine to return an error.\n\nNo privileges are required to execute the SIGNAL statement.\n\nTo retrieve information from the diagnostics area, use the GET\nDIAGNOSTICS statement (see [HELP GET DIAGNOSTICS]). For information\nabout the diagnostics area, see\nhttp://dev.mysql.com/doc/refman/8.0/en/diagnostics-area.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/signal.html\n\n','CREATE PROCEDURE p (pval INT)\nBEGIN\n  DECLARE specialty CONDITION FOR SQLSTATE \'45000\';\n  IF pval = 0 THEN\n    SIGNAL SQLSTATE \'01000\';\n  ELSEIF pval = 1 THEN\n    SIGNAL SQLSTATE \'45000\'\n      SET MESSAGE_TEXT = \'An error occurred\';\n  ELSEIF pval = 2 THEN\n    SIGNAL specialty\n      SET MESSAGE_TEXT = \'An error occurred\';\n  ELSE\n    SIGNAL SQLSTATE \'01000\'\n      SET MESSAGE_TEXT = \'A warning occurred\', MYSQL_ERRNO = 1000;\n    SIGNAL SQLSTATE \'45000\'\n      SET MESSAGE_TEXT = \'An error occurred\', MYSQL_ERRNO = 1001;\n  END IF;\nEND;\n','http://dev.mysql.com/doc/refman/8.0/en/signal.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (497,30,'SIN','Syntax:\nSIN(X)\n\nReturns the sine of X, where X is given in radians.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT SIN(PI());\n        -> 1.2246063538224e-16\nmysql> SELECT ROUND(SIN(PI()));\n        -> 0\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (498,29,'SLEEP','Syntax:\nSLEEP(duration)\n\nSleeps (pauses) for the number of seconds given by the duration\nargument, then returns 0. The duration may have a fractional part. If\nthe argument is NULL or negative, SLEEP() produces a warning, or an\nerror in strict SQL mode.\n\nWhen sleep returns normally (without interruption), it returns 0:\n\nmysql> SELECT SLEEP(1000);\n+-------------+\n| SLEEP(1000) |\n+-------------+\n|           0 |\n+-------------+\n\nWhen SLEEP() is the only thing invoked by a query that is interrupted,\nit returns 1 and the query itself returns no error. This is true\nwhether the query is killed or times out:\n\no This statement is interrupted using KILL QUERY from another session:\n\nmysql> SELECT SLEEP(1000);\n+-------------+\n| SLEEP(1000) |\n+-------------+\n|           1 |\n+-------------+\n\no This statement is interrupted by timing out:\n\nmysql> SELECT /*+ MAX_EXECUTION_TIME(1) */ SLEEP(1000);\n+-------------+\n| SLEEP(1000) |\n+-------------+\n|           1 |\n+-------------+\n\nWhen SLEEP() is only part of a query that is interrupted, the query\nreturns an error:\n\no This statement is interrupted using KILL QUERY from another session:\n\nmysql> SELECT 1 FROM t1 WHERE SLEEP(1000);\nERROR 1317 (70100): Query execution was interrupted\n\no This statement is interrupted by timing out:\n\nmysql> SELECT /*+ MAX_EXECUTION_TIME(1000) */ 1 FROM t1 WHERE SLEEP(1000);\nERROR 3024 (HY000): Query execution was interrupted, maximum statement\nexecution time exceeded\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (499,11,'SMALLINT','SMALLINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA small integer. The signed range is -32768 to 32767. The unsigned\nrange is 0 to 65535.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/numeric-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (500,35,'SOUNDEX','Syntax:\nSOUNDEX(str)\n\nReturns a soundex string from str. Two strings that sound almost the\nsame should have identical soundex strings. A standard soundex string\nis four characters long, but the SOUNDEX() function returns an\narbitrarily long string. You can use SUBSTRING() on the result to get a\nstandard soundex string. All nonalphabetic characters in str are\nignored. All international alphabetic characters outside the A-Z range\nare treated as vowels.\n\n*Important*:\n\nWhen using SOUNDEX(), you should be aware of the following limitations:\n\no This function, as currently implemented, is intended to work well\n  with strings that are in the English language only. Strings in other\n  languages may not produce reliable results.\n\no This function is not guaranteed to provide consistent results with\n  strings that use multibyte character sets, including utf-8. See Bug\n  #22638 for more information.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT SOUNDEX(\'Hello\');\n        -> \'H400\'\nmysql> SELECT SOUNDEX(\'Quadratically\');\n        -> \'Q36324\'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (501,35,'SOUNDS LIKE','Syntax:\nexpr1 SOUNDS LIKE expr2\n\nThis is the same as SOUNDEX(expr1) = SOUNDEX(expr2).\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (502,35,'SPACE','Syntax:\nSPACE(N)\n\nReturns a string consisting of N space characters.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT SPACE(6);\n        -> \'      \'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (503,17,'SPATIAL','For InnoDB and MyISAM tables, MySQL can create spatial indexes using\nsyntax similar to that for creating regular indexes, but using the\nSPATIAL keyword. Columns in spatial indexes must be declared NOT NULL.\nThe following examples demonstrate how to create spatial indexes:\n\no With CREATE TABLE:\n\nCREATE TABLE geom (g GEOMETRY NOT NULL SRID 4326, SPATIAL INDEX(g));\n\no With ALTER TABLE:\n\nCREATE TABLE geom (g GEOMETRY NOT NULL SRID 4326);\nALTER TABLE geom ADD SPATIAL INDEX(g);\n\no With CREATE INDEX:\n\nCREATE TABLE geom (g GEOMETRY NOT NULL SRID 4326);\nCREATE SPATIAL INDEX g ON geom (g);\n\nSPATIAL INDEX creates an R-tree index. For storage engines that support\nnonspatial indexing of spatial columns, the engine creates a B-tree\nindex. A B-tree index on spatial values is useful for exact-value\nlookups, but not for range scans.\n\nThe optimizer can use spatial indexes defined on columns that are\nSRID-restricted. For more information, see\nhttp://dev.mysql.com/doc/refman/8.0/en/spatial-type-overview.html, and\nhttp://dev.mysql.com/doc/refman/8.0/en/spatial-index-optimization.html.\n\nFor more information on indexing spatial columns, see [HELP CREATE\nINDEX].\n\nTo drop spatial indexes, use ALTER TABLE or DROP INDEX:\n\no With ALTER TABLE:\n\nALTER TABLE geom DROP INDEX g;\n\no With DROP INDEX:\n\nDROP INDEX g ON geom;\n\nExample: Suppose that a table geom contains more than 32,000\ngeometries, which are stored in the column g of type GEOMETRY. The\ntable also has an AUTO_INCREMENT column fid for storing object ID\nvalues.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/creating-spatial-indexes.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/creating-spatial-indexes.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (504,30,'SQRT','Syntax:\nSQRT(X)\n\nReturns the square root of a nonnegative number X.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT SQRT(4);\n        -> 2\nmysql> SELECT SQRT(20);\n        -> 4.4721359549996\nmysql> SELECT SQRT(-16);\n        -> NULL\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (505,37,'START SLAVE','Syntax:\nSTART SLAVE [thread_types] [until_option] [connection_options] [channel_option]\n\nthread_types:\n    [thread_type [, thread_type] ... ]\n\nthread_type:\n    IO_THREAD | SQL_THREAD\n\nuntil_option:\n    UNTIL {   {SQL_BEFORE_GTIDS | SQL_AFTER_GTIDS} = gtid_set\n          |   MASTER_LOG_FILE = \'log_name\', MASTER_LOG_POS = log_pos\n          |   RELAY_LOG_FILE = \'log_name\', RELAY_LOG_POS = log_pos\n          |   SQL_AFTER_MTS_GAPS  }\n\nconnection_options:\n    [USER=\'user_name\'] [PASSWORD=\'user_pass\'] [DEFAULT_AUTH=\'plugin_name\'] [PLUGIN_DIR=\'plugin_dir\']\n\n\nchannel_option:\n    FOR CHANNEL channel\n\ngtid_set:\n    uuid_set [, uuid_set] ...\n    | \'\'\n\nuuid_set:\n    uuid:interval[:interval]...\n\nuuid:\n    hhhhhhhh-hhhh-hhhh-hhhh-hhhhhhhhhhhh\n\nh:\n    [0-9,A-F]\n\ninterval:\n    n[-n]\n\n    (n >= 1)\n\nSTART SLAVE with no thread_type options starts both of the slave\nthreads. The I/O thread reads events from the master server and stores\nthem in the relay log. The SQL thread reads events from the relay log\nand executes them. START SLAVE requires the REPLICATION_SLAVE_ADMIN or\nSUPER privilege.\n\nIf START SLAVE succeeds in starting the slave threads, it returns\nwithout any error. However, even in that case, it might be that the\nslave threads start and then later stop (for example, because they do\nnot manage to connect to the master or read its binary log, or some\nother problem). START SLAVE does not warn you about this. You must\ncheck the slave\'s error log for error messages generated by the slave\nthreads, or check that they are running satisfactorily with SHOW SLAVE\nSTATUS.\n\nSTART SLAVE causes an implicit commit of an ongoing transaction. See\nhttp://dev.mysql.com/doc/refman/8.0/en/implicit-commit.html.\n\ngtid_next must be set to AUTOMATIC before issuing this statement.\n\nThe optional FOR CHANNEL channel clause enables you to name which\nreplication channel the statement applies to. Providing a FOR CHANNEL\nchannel clause applies the START SLAVE statement to a specific\nreplication channel. If no clause is named and no extra channels exist,\nthe statement applies to the default channel. If a START SLAVE\nstatement does not have a channel defined when using multiple channels,\nthis statement starts the specified threads for all channels. This\nstatement is disallowed for the group_replication_recovery channel. See\nhttp://dev.mysql.com/doc/refman/8.0/en/replication-channels.html for\nmore information.\n\nMySQL supports pluggable user-password authentication with START SLAVE\nwith the USER, PASSWORD, DEFAULT_AUTH and PLUGIN_DIR options, as\ndescribed in the following list:\n\no USER: User name. Cannot be set to an empty or null string, or left\n  unset if PASSWORD is used.\n\no PASSWORD: Password.\n\no DEFAULT_AUTH: Name of plugin; default is MySQL native authentication.\n\no PLUGIN_DIR: Location of plugin.\n\nYou cannot use the SQL_THREAD option when specifying any of USER,\nPASSWORD, DEFAULT_AUTH, or PLUGIN_DIR, unless the IO_THREAD option is\nalso provided.\n\nSee\nhttp://dev.mysql.com/doc/refman/8.0/en/pluggable-authentication.html,\nfor more information.\n\nIf an insecure connection is used with any these options, the server\nissues the warning Sending passwords in plain text without SSL/TLS is\nextremely insecure.\n\nSTART SLAVE ... UNTIL supports two additional options for use with\nglobal transaction identifiers (GTIDs) (see\nhttp://dev.mysql.com/doc/refman/8.0/en/replication-gtids.html). Each of\nthese takes a set of one or more global transaction identifiers\ngtid_set as an argument (see\nhttp://dev.mysql.com/doc/refman/8.0/en/replication-gtids-concepts.html#\nreplication-gtids-concepts-gtid-sets, for more information).\n\nWhen no thread_type is specified, START SLAVE UNTIL SQL_BEFORE_GTIDS\ncauses the slave SQL thread to process transactions until it has\nreached the first transaction whose GTID is listed in the gtid_set.\nSTART SLAVE UNTIL SQL_AFTER_GTIDS causes the slave threads to process\nall transactions until the last transaction in the gtid_set has been\nprocessed by both threads. In other words, START SLAVE UNTIL\nSQL_BEFORE_GTIDS causes the slave SQL thread to process all\ntransactions occurring before the first GTID in the gtid_set is\nreached, and START SLAVE UNTIL SQL_AFTER_GTIDS causes the slave threads\nto handle all transactions, including those whose GTIDs are found in\ngtid_set, until each has encountered a transaction whose GTID is not\npart of the set. SQL_BEFORE_GTIDS and SQL_AFTER_GTIDS each support the\nSQL_THREAD and IO_THREAD options, although using IO_THREAD with them\ncurrently has no effect.\n\nFor example, START SLAVE SQL_THREAD UNTIL SQL_BEFORE_GTIDS =\n3E11FA47-71CA-11E1-9E33-C80AA9429562:11-56 causes the slave SQL thread\nto process all transactions originating from the master whose\nserver_uuid is 3E11FA47-71CA-11E1-9E33-C80AA9429562 until it encounters\nthe transaction having sequence number 11; it then stops without\nprocessing this transaction. In other words, all transactions up to and\nincluding the transaction with sequence number 10 are processed.\nExecuting START SLAVE SQL_THREAD UNTIL SQL_AFTER_GTIDS =\n3E11FA47-71CA-11E1-9E33-C80AA9429562:11-56, on the other hand, would\ncause the slave SQL thread to obtain all transactions just mentioned\nfrom the master, including all of the transactions having the sequence\nnumbers 11 through 56, and then to stop without processing any\nadditional transactions; that is, the transaction having sequence\nnumber 56 would be the last transaction fetched by the slave SQL\nthread.\n\nWhen using a multithreaded slave with slave_preserve_commit_order=0\nset, there is a chance of gaps in the sequence of transactions that\nhave been executed from the relay log in the following cases:\n\no killing the coordinator thread\n\no after an error occurs in the applier threads\n\no mysqld shuts down unexpectedly\n\nUse the START SLAVE UNTIL SQL_AFTER_MTS_GAPS statement to cause a\nmultithreaded slave\'s worker threads to only run until no more gaps are\nfound in the relay log, and then to stop. This statement can take an\nSQL_THREAD option, but the effects of the statement remain unchanged.\nIt has no effect on the slave I/O thread (and cannot be used with the\nIO_THREAD option).\n\nIssuing START SLAVE on a multithreaded slave with gaps in the sequence\nof transactions executed from the relay log generates a warning. In\nsuch a situation, the solution is to use START SLAVE UNTIL\nSQL_AFTER_MTS_GAPS, then issue RESET SLAVE to remove any remaining\nrelay logs. See\nhttp://dev.mysql.com/doc/refman/8.0/en/replication-features-transaction\n-inconsistencies.html for more information.\n\nTo change a failed multithreaded slave to single-threaded mode, you can\nissue the following series of statements, in the order shown:\n\nSTART SLAVE UNTIL SQL_AFTER_MTS_GAPS;\n\nSET @@GLOBAL.slave_parallel_workers = 0;\n\nSTART SLAVE SQL_THREAD;\n\n*Note*:\n\nIt is possible to view the entire text of a running START SLAVE ...\nstatement, including any USER or PASSWORD values used, in the output of\nSHOW PROCESSLIST. This is also true for the text of a running CHANGE\nMASTER TO statement, including any values it employs for MASTER_USER or\nMASTER_PASSWORD.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/start-slave.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/start-slave.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (506,37,'START TRANSACTION','Syntax:\nSTART TRANSACTION\n    [transaction_characteristic [, transaction_characteristic] ...]\n\ntransaction_characteristic: {\n    WITH CONSISTENT SNAPSHOT\n  | READ WRITE\n  | READ ONLY\n}\n\nBEGIN [WORK]\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nROLLBACK [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nSET autocommit = {0 | 1}\n\nThese statements provide control over use of transactions:\n\no START TRANSACTION or BEGIN start a new transaction.\n\no COMMIT commits the current transaction, making its changes permanent.\n\no ROLLBACK rolls back the current transaction, canceling its changes.\n\no SET autocommit disables or enables the default autocommit mode for\n  the current session.\n\nBy default, MySQL runs with autocommit mode enabled. This means that as\nsoon as you execute a statement that updates (modifies) a table, MySQL\nstores the update on disk to make it permanent. The change cannot be\nrolled back.\n\nTo disable autocommit mode implicitly for a single series of\nstatements, use the START TRANSACTION statement:\n\nSTART TRANSACTION;\nSELECT @A:=SUM(salary) FROM table1 WHERE type=1;\nUPDATE table2 SET summary=@A WHERE type=1;\nCOMMIT;\n\nWith START TRANSACTION, autocommit remains disabled until you end the\ntransaction with COMMIT or ROLLBACK. The autocommit mode then reverts\nto its previous state.\n\nSTART TRANSACTION permits several modifiers that control transaction\ncharacteristics. To specify multiple modifiers, separate them by\ncommas.\n\no The WITH CONSISTENT SNAPSHOT modifier starts a consistent read for\n  storage engines that are capable of it. This applies only to InnoDB.\n  The effect is the same as issuing a START TRANSACTION followed by a\n  SELECT from any InnoDB table. See\n  http://dev.mysql.com/doc/refman/8.0/en/innodb-consistent-read.html.\n  The WITH CONSISTENT SNAPSHOT modifier does not change the current\n  transaction isolation level, so it provides a consistent snapshot\n  only if the current isolation level is one that permits a consistent\n  read. The only isolation level that permits a consistent read is\n  REPEATABLE READ. For all other isolation levels, the WITH CONSISTENT\n  SNAPSHOT clause is ignored. A warning is generated when the WITH\n  CONSISTENT SNAPSHOT clause is ignored.\n\no The READ WRITE and READ ONLY modifiers set the transaction access\n  mode. They permit or prohibit changes to tables used in the\n  transaction. The READ ONLY restriction prevents the transaction from\n  modifying or locking both transactional and nontransactional tables\n  that are visible to other transactions; the transaction can still\n  modify or lock temporary tables.\n\n  MySQL enables extra optimizations for queries on InnoDB tables when\n  the transaction is known to be read-only. Specifying READ ONLY\n  ensures these optimizations are applied in cases where the read-only\n  status cannot be determined automatically. See\n  http://dev.mysql.com/doc/refman/8.0/en/innodb-performance-ro-txn.html\n  for more information.\n\n  If no access mode is specified, the default mode applies. Unless the\n  default has been changed, it is read/write. It is not permitted to\n  specify both READ WRITE and READ ONLY in the same statement.\n\n  In read-only mode, it remains possible to change tables created with\n  the TEMPORARY keyword using DML statements. Changes made with DDL\n  statements are not permitted, just as with permanent tables.\n\n  For additional information about transaction access mode, including\n  ways to change the default mode, see [HELP ISOLATION].\n\n  If the read_only system variable is enabled, explicitly starting a\n  transaction with START TRANSACTION READ WRITE requires the\n  CONNECTION_ADMIN or SUPER privilege.\n\n*Important*:\n\nMany APIs used for writing MySQL client applications (such as JDBC)\nprovide their own methods for starting transactions that can (and\nsometimes should) be used instead of sending a START TRANSACTION\nstatement from the client. See\nhttp://dev.mysql.com/doc/refman/8.0/en/connectors-apis.html, or the\ndocumentation for your API, for more information.\n\nTo disable autocommit mode explicitly, use the following statement:\n\nSET autocommit=0;\n\nAfter disabling autocommit mode by setting the autocommit variable to\nzero, changes to transaction-safe tables (such as those for InnoDB or\nNDB) are not made permanent immediately. You must use COMMIT to store\nyour changes to disk or ROLLBACK to ignore the changes.\n\nautocommit is a session variable and must be set for each session. To\ndisable autocommit mode for each new connection, see the description of\nthe autocommit system variable at\nhttp://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html.\n\nBEGIN and BEGIN WORK are supported as aliases of START TRANSACTION for\ninitiating a transaction. START TRANSACTION is standard SQL syntax, is\nthe recommended way to start an ad-hoc transaction, and permits\nmodifiers that BEGIN does not.\n\nThe BEGIN statement differs from the use of the BEGIN keyword that\nstarts a BEGIN ... END compound statement. The latter does not begin a\ntransaction. See [HELP BEGIN END].\n\n*Note*:\n\nWithin all stored programs (stored procedures and functions, triggers,\nand events), the parser treats BEGIN [WORK] as the beginning of a BEGIN\n... END block. Begin a transaction in this context with START\nTRANSACTION instead.\n\nThe optional WORK keyword is supported for COMMIT and ROLLBACK, as are\nthe CHAIN and RELEASE clauses. CHAIN and RELEASE can be used for\nadditional control over transaction completion. The value of the\ncompletion_type system variable determines the default completion\nbehavior. See\nhttp://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html.\n\nThe AND CHAIN clause causes a new transaction to begin as soon as the\ncurrent one ends, and the new transaction has the same isolation level\nas the just-terminated transaction. The new transaction also uses the\nsame access mode (READ WRITE or READ ONLY) as the just-terminated\ntransaction. The RELEASE clause causes the server to disconnect the\ncurrent client session after terminating the current transaction.\nIncluding the NO keyword suppresses CHAIN or RELEASE completion, which\ncan be useful if the completion_type system variable is set to cause\nchaining or release completion by default.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/commit.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/commit.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (507,13,'STATEMENT_DIGEST','STATEMENT_DIGEST(statement)\n\nGiven an SQL statement as a string, returns the statement digest hash\nvalue as a string in the connection character set, or NULL if the\nargument is NULL. The related STATEMENT_DIGEST_TEXT() function returns\nthe normalized statement digest. For information about statement\ndigesting, see\nhttp://dev.mysql.com/doc/refman/8.0/en/performance-schema-statement-dig\nests.html.\n\nBoth functions use the MySQL parser to parse the statement. If parsing\nfails, an error occurs. The error message includes the parse error only\nif the statement is provided as a literal string.\n\nThe max_digest_length system variable determines the maximum number of\nbytes available to these functions for computing normalized statement\ndigests.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html\n\n','mysql> SET @stmt = \'SELECT * FROM mytable WHERE cola = 10 AND colb = 20\';\nmysql> SELECT STATEMENT_DIGEST(@stmt);\n+------------------------------------------------------------------+\n| STATEMENT_DIGEST(@stmt)                                          |\n+------------------------------------------------------------------+\n| 3bb95eeade896657c4526e74ff2a2862039d0a0fe8a9e7155b5fe492cbd78387 |\n+------------------------------------------------------------------+\nmysql> SELECT STATEMENT_DIGEST_TEXT(@stmt);\n+----------------------------------------------------------+\n| STATEMENT_DIGEST_TEXT(@stmt)                             |\n+----------------------------------------------------------+\n| SELECT * FROM `mytable` WHERE `cola` = ? AND `colb` = ?  |\n+----------------------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (508,13,'STATEMENT_DIGEST_TEXT','STATEMENT_DIGEST_TEXT(statement)\n\nGiven an SQL statement as a string, returns the normalized statement\ndigest as a string in the connection character set, or NULL if the\nargument is NULL. For additional discussion and examples, see the\ndescription of the related STATEMENT_DIGEST() function.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (509,15,'STD','Syntax:\nSTD(expr) [over_clause]\n\nReturns the population standard deviation of expr. STD() is a synonym\nfor the standard SQL function STDDEV_POP(), provided as a MySQL\nextension.\n\nIf there are no matching rows, STD() returns NULL.\n\nThis function executes as a window function if over_clause is present.\nover_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (510,15,'STDDEV','Syntax:\nSTDDEV(expr) [over_clause]\n\nReturns the population standard deviation of expr. STDDEV() is a\nsynonym for the standard SQL function STDDEV_POP(), provided for\ncompatibility with Oracle.\n\nIf there are no matching rows, STDDEV() returns NULL.\n\nThis function executes as a window function if over_clause is present.\nover_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (511,15,'STDDEV_POP','Syntax:\nSTDDEV_POP(expr) [over_clause]\n\nReturns the population standard deviation of expr (the square root of\nVAR_POP()). You can also use STD() or STDDEV(), which are equivalent\nbut not standard SQL.\n\nIf there are no matching rows, STDDEV_POP() returns NULL.\n\nThis function executes as a window function if over_clause is present.\nover_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (512,15,'STDDEV_SAMP','Syntax:\nSTDDEV_SAMP(expr) [over_clause]\n\nReturns the sample standard deviation of expr (the square root of\nVAR_SAMP().\n\nIf there are no matching rows, STDDEV_SAMP() returns NULL.\n\nThis function executes as a window function if over_clause is present.\nover_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (513,37,'STOP SLAVE','Syntax:\nSTOP SLAVE [thread_types]\n\nthread_types:\n    [thread_type [, thread_type] ... ]\n\nthread_type: IO_THREAD | SQL_THREAD\n\nchannel_option:\n    FOR CHANNEL channel\n\nStops the slave threads. STOP SLAVE requires the\nREPLICATION_SLAVE_ADMIN or SUPER privilege. Recommended best practice\nis to execute STOP SLAVE on the slave before stopping the slave server\n(see http://dev.mysql.com/doc/refman/8.0/en/server-shutdown.html, for\nmore information).\n\nWhen using the row-based logging format: You should execute STOP SLAVE\nor STOP SLAVE SQL_THREAD on the slave prior to shutting down the slave\nserver if you are replicating any tables that use a nontransactional\nstorage engine (see the Note later in this section).\n\nLike START SLAVE, this statement may be used with the IO_THREAD and\nSQL_THREAD options to name the thread or threads to be stopped.\n\nSTOP SLAVE causes an implicit commit of an ongoing transaction. See\nhttp://dev.mysql.com/doc/refman/8.0/en/implicit-commit.html.\n\ngtid_next must be set to AUTOMATIC before issuing this statement.\n\nYou can control how long STOP SLAVE waits before timing out by setting\nthe rpl_stop_slave_timeout system variable. This can be used to avoid\ndeadlocks between STOP SLAVE and other slave SQL statements using\ndifferent client connections to the slave. When the timeout value is\nreached, the issuing client returns an error message and stops waiting,\nbut the STOP SLAVE instruction remains in effect. Once the slave\nthreads are no longer busy, the STOP SLAVE statement is executed and\nthe slave stops.\n\nSome CHANGE MASTER TO statements are allowed while the slave is\nrunning, depending on the states of the slave SQL and I/O threads.\nHowever, using STOP SLAVE prior to executing CHANGE MASTER TO in such\ncases is still supported. See [HELP CHANGE MASTER TO], and\nhttp://dev.mysql.com/doc/refman/8.0/en/replication-solutions-switch.htm\nl, for more information.\n\nThe optional FOR CHANNEL channel clause enables you to name which\nreplication channel the statement applies to. Providing a FOR CHANNEL\nchannel clause applies the STOP SLAVE statement to a specific\nreplication channel. If no channel is named and no extra channels\nexist, the statement applies to the default channel. If a STOP SLAVE\nstatement does not name a channel when using multiple channels, this\nstatement stops the specified threads for all channels. This statement\ncannot be used with the group_replication_recovery channel. See\nhttp://dev.mysql.com/doc/refman/8.0/en/replication-channels.html for\nmore information.\n\nWhen using statement-based replication: changing the master while it\nhas open temporary tables is potentially unsafe. This is one of the\nreasons why statement-based replication of temporary tables is not\nrecommended. You can find out whether there are any temporary tables on\nthe slave by checking the value of Slave_open_temp_tables; when using\nstatement-based replication, this value should be 0 before executing\nCHANGE MASTER TO. If there are any temporary tables open on the slave,\nissuing a CHANGE MASTER TO statement after issuing a STOP SLAVE causes\nan ER_WARN_OPEN_TEMP_TABLES_MUST_BE_ZERO warning.\n\nWhen using a multithreaded slave (slave_parallel_workers is a nonzero\nvalue), any gaps in the sequence of transactions executed from the\nrelay log are closed as part of stopping the worker threads. If the\nslave is stopped unexpectedly (for example due to an error in a worker\nthread, or another thread issuing KILL) while a STOP SLAVE statement is\nexecuting, the sequence of executed transactions from the relay log may\nbecome inconsistent. See\nhttp://dev.mysql.com/doc/refman/8.0/en/replication-features-transaction\n-inconsistencies.html for more information.\n\nIf the current replication event group has modified one or more\nnontransactional tables, STOP SLAVE waits for up to 60 seconds for the\nevent group to complete, unless you issue a KILL QUERY or KILL\nCONNECTION statement for the slave SQL thread. If the event group\nremains incomplete after the timeout, an error message is logged.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/stop-slave.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/stop-slave.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (514,35,'STRCMP','Syntax:\nSTRCMP(expr1,expr2)\n\nSTRCMP() returns 0 if the strings are the same, -1 if the first\nargument is smaller than the second according to the current sort\norder, and 1 otherwise.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-comparison-functions.html\n\n','mysql> SELECT STRCMP(\'text\', \'text2\');\n        -> -1\nmysql> SELECT STRCMP(\'text2\', \'text\');\n        -> 1\nmysql> SELECT STRCMP(\'text\', \'text\');\n        -> 0\n','http://dev.mysql.com/doc/refman/8.0/en/string-comparison-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (515,12,'STR_TO_DATE','Syntax:\nSTR_TO_DATE(str,format)\n\nThis is the inverse of the DATE_FORMAT() function. It takes a string\nstr and a format string format. STR_TO_DATE() returns a DATETIME value\nif the format string contains both date and time parts, or a DATE or\nTIME value if the string contains only date or time parts. If the date,\ntime, or datetime value extracted from str is illegal, STR_TO_DATE()\nreturns NULL and produces a warning.\n\nThe server scans str attempting to match format to it. The format\nstring can contain literal characters and format specifiers beginning\nwith %. Literal characters in format must match literally in str.\nFormat specifiers in format must match a date or time part in str. For\nthe specifiers that can be used in format, see the DATE_FORMAT()\nfunction description.\n\nmysql> SELECT STR_TO_DATE(\'01,5,2013\',\'%d,%m,%Y\');\n        -> \'2013-05-01\'\nmysql> SELECT STR_TO_DATE(\'May 1, 2013\',\'%M %d,%Y\');\n        -> \'2013-05-01\'\n\nScanning starts at the beginning of str and fails if format is found\nnot to match. Extra characters at the end of str are ignored.\n\nmysql> SELECT STR_TO_DATE(\'a09:30:17\',\'a%h:%i:%s\');\n        -> \'09:30:17\'\nmysql> SELECT STR_TO_DATE(\'a09:30:17\',\'%h:%i:%s\');\n        -> NULL\nmysql> SELECT STR_TO_DATE(\'09:30:17a\',\'%h:%i:%s\');\n        -> \'09:30:17\'\n\nUnspecified date or time parts have a value of 0, so incompletely\nspecified values in str produce a result with some or all parts set to\n0:\n\nmysql> SELECT STR_TO_DATE(\'abc\',\'abc\');\n        -> \'0000-00-00\'\nmysql> SELECT STR_TO_DATE(\'9\',\'%m\');\n        -> \'0000-09-00\'\nmysql> SELECT STR_TO_DATE(\'9\',\'%s\');\n        -> \'00:00:09\'\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (516,33,'ST_AREA','ST_Area({poly|mpoly})\n\nReturns a double-precision number indicating the area of the Polygon or\nMultiPolygon argument, as measured in its spatial reference system.\n\nAs of MySQL 8.0.13, ST_Area() handles its arguments as described in the\nintroduction to this section, with these exceptions:\n\no If the geometry is geometrically invalid, either the result is an\n  undefined area (that is, it can be any number), or an error occurs.\n\no If the geometry is valid but is not a Polygon or MultiPolygon object,\n  an ER_UNEXPECTED_GEOMETRY_TYPE error occurs.\n\no If the geometry is a valid Polygon in a Cartesian SRS, the result is\n  the Cartesian area of the polygon.\n\no If the geometry is a valid MultiPolygon in a Cartesian SRS, the\n  result is the sum of the Cartesian area of the polygons.\n\no If the geometry is a valid Polygon in a geographic SRS, the result is\n  the geodetic area of the polygon in that SRS, in square meters.\n\no If the geometry is a valid MultiPolygon in a geographic SRS, the\n  result is the sum of geodetic area of the polygons in that SRS, in\n  square meters.\n\no If an area computation results in +inf, an ER_DATA_OUT_OF_RANGE error\n  occurs.\n\no If the geometry has a geographic SRS with a longitude or latitude\n  that is out of range, an error occurs:\n\n  o If any longitude argument is not in the range (−180, 180], an\n    ER_LONGITUDE_OUT_OF_RANGE error occurs.\n\n  o If any latitude argument is not in the range [−90, 90], an\n    ER_LATITUDE_OUT_OF_RANGE error occurs.\n\n  Ranges shown are in degrees. The exact range limits deviate slightly\n  due to floating-point arithmetic.\n\nPrior to MySQL 8.0.13, ST_Area() handles its arguments as described in\nthe introduction to this section, with these exceptions:\n\no For arguments of dimension 0 or 1, the result is 0.\n\no If a geometry is empty, the return value is 0 rather than NULL.\n\no For a geometry collection, the result is the sum of the area values\n  of all components. If the geometry collection is empty, its area is\n  returned as 0.\n\no If the geometry has an SRID value for a geographic spatial reference\n  system (SRS), an ER_NOT_IMPLEMENTED_FOR_GEOGRAPHIC_SRS error occurs.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-polygon-property-functions.html\n\n','mysql> SET @poly =\n       \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\nmysql> SELECT ST_Area(ST_GeomFromText(@poly));\n+---------------------------------+\n| ST_Area(ST_GeomFromText(@poly)) |\n+---------------------------------+\n|                               4 |\n+---------------------------------+\n\nmysql> SET @mpoly =\n       \'MultiPolygon(((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1)))\';\nmysql> SELECT ST_Area(ST_GeomFromText(@mpoly));\n+----------------------------------+\n| ST_Area(ST_GeomFromText(@mpoly)) |\n+----------------------------------+\n|                                8 |\n+----------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/gis-polygon-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (517,40,'ST_ASBINARY','ST_AsBinary(g [, options]), ST_AsWKB(g [, options])\n\nConverts a value in internal geometry format to its WKB representation\nand returns the binary result.\n\nThe function return value has geographic coordinates (latitude,\nlongitude) in the order specified by the spatial reference system that\napplies to the geometry argument. An optional options argument may be\ngiven to override the default axis order.\n\nST_AsBinary() and ST_AsWKB() handle their arguments as described in the\nintroduction to this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-format-conversion-functions.html\n\n','mysql> SET @g = ST_LineFromText(\'LINESTRING(0 5,5 10,10 15)\', 4326);\nmysql> SELECT ST_AsText(ST_GeomFromWKB(ST_AsWKB(@g)));\n+-----------------------------------------+\n| ST_AsText(ST_GeomFromWKB(ST_AsWKB(@g))) |\n+-----------------------------------------+\n| LINESTRING(5 0,10 5,15 10)              |\n+-----------------------------------------+\nmysql> SELECT ST_AsText(ST_GeomFromWKB(ST_AsWKB(@g, \'axis-order=long-lat\')));\n+----------------------------------------------------------------+\n| ST_AsText(ST_GeomFromWKB(ST_AsWKB(@g, \'axis-order=long-lat\'))) |\n+----------------------------------------------------------------+\n| LINESTRING(0 5,5 10,10 15)                                     |\n+----------------------------------------------------------------+\nmysql> SELECT ST_AsText(ST_GeomFromWKB(ST_AsWKB(@g, \'axis-order=lat-long\')));\n+----------------------------------------------------------------+\n| ST_AsText(ST_GeomFromWKB(ST_AsWKB(@g, \'axis-order=lat-long\'))) |\n+----------------------------------------------------------------+\n| LINESTRING(5 0,10 5,15 10)                                     |\n+----------------------------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/gis-format-conversion-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (518,28,'ST_ASGEOJSON','ST_AsGeoJSON(g [, max_dec_digits [, options]])\n\nGenerates a GeoJSON object from the geometry g. The object string has\nthe connection character set and collation.\n\nIf any argument is NULL, the return value is NULL. If any non-NULL\nargument is invalid, an error occurs.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-geojson-functions.html\n\n','mysql> SELECT ST_AsGeoJSON(ST_GeomFromText(\'POINT(11.11111 12.22222)\'),2);\n+-------------------------------------------------------------+\n| ST_AsGeoJSON(ST_GeomFromText(\'POINT(11.11111 12.22222)\'),2) |\n+-------------------------------------------------------------+\n| {"type": "Point", "coordinates": [11.11, 12.22]}            |\n+-------------------------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/spatial-geojson-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (519,40,'ST_ASTEXT','ST_AsText(g [, options]), ST_AsWKT(g [, options])\n\nConverts a value in internal geometry format to its WKT representation\nand returns the string result.\n\nThe function return value has geographic coordinates (latitude,\nlongitude) in the order specified by the spatial reference system that\napplies to the geometry argument. An optional options argument may be\ngiven to override the default axis order.\n\nST_AsText() and ST_AsWKT() handle their arguments as described in the\nintroduction to this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-format-conversion-functions.html\n\n','mysql> SET @g = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,2 2,3 3)        |\n+--------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/gis-format-conversion-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (520,21,'ST_BUFFER','ST_Buffer(g, d[, strategy1[, strategy2[, strategy3]]])\n\nReturns a geometry that represents all points whose distance from the\ngeometry value g is less than or equal to a distance of d.\n\nIf the geometry argument is empty, ST_Buffer() returns an empty\ngeometry.\n\nIf the distance is 0, ST_Buffer() returns the geometry argument\nunchanged:\n\nmysql> SET @pt = ST_GeomFromText(\'POINT(0 0)\');\nmysql> SELECT ST_AsText(ST_Buffer(@pt, 0));\n+------------------------------+\n| ST_AsText(ST_Buffer(@pt, 0)) |\n+------------------------------+\n| POINT(0 0)                   |\n+------------------------------+\n\nST_Buffer() supports negative distances for Polygon and MultiPolygon\nvalues, and for geometry collections containing Polygon or MultiPolygon\nvalues. The result may be an empty geometry.\n\nST_Buffer() permits up to three optional strategy arguments following\nthe distance argument. Strategies influence buffer computation. These\narguments are byte string values produced by the ST_Buffer_Strategy()\nfunction, to be used for point, join, and end strategies:\n\no Point strategies apply to Point and MultiPoint geometries. If no\n  point strategy is specified, the default is\n  ST_Buffer_Strategy(\'point_circle\', 32).\n\no Join strategies apply to LineString, MultiLineString, Polygon, and\n  MultiPolygon geometries. If no join strategy is specified, the\n  default is ST_Buffer_Strategy(\'join_round\', 32).\n\no End strategies apply to LineString and MultiLineString geometries. If\n  no end strategy is specified, the default is\n  ST_Buffer_Strategy(\'end_round\', 32).\n\nUp to one strategy of each type may be specified, and they may be given\nin any order.\n\nST_Buffer() handles its arguments as described in the introduction to\nthis section, with these exceptions:\n\no For a negative distance for Point, MultiPoint, LineString, and\n  MultiLineString values, and for geometry collections not containing\n  any Polygon or MultiPolygon values, an ER_WRONG_ARGUMENTS error\n  occurs.\n\no If multiple strategies of a given type are specified, an\n  ER_WRONG_ARGUMENTS error occurs.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-operator-functions.html\n\n','mysql> SET @pt = ST_GeomFromText(\'POINT(0 0)\');\nmysql> SET @pt_strategy = ST_Buffer_Strategy(\'point_square\');\nmysql> SELECT ST_AsText(ST_Buffer(@pt, 2, @pt_strategy));\n+--------------------------------------------+\n| ST_AsText(ST_Buffer(@pt, 2, @pt_strategy)) |\n+--------------------------------------------+\n| POLYGON((-2 -2,2 -2,2 2,-2 2,-2 -2))       |\n+--------------------------------------------+\n\nmysql> SET @ls = ST_GeomFromText(\'LINESTRING(0 0,0 5,5 5)\');\nmysql> SET @end_strategy = ST_Buffer_Strategy(\'end_flat\');\nmysql> SET @join_strategy = ST_Buffer_Strategy(\'join_round\', 10);\nmysql> SELECT ST_AsText(ST_Buffer(@ls, 5, @end_strategy, @join_strategy))\n+---------------------------------------------------------------+\n| ST_AsText(ST_Buffer(@ls, 5, @end_strategy, @join_strategy))   |\n+---------------------------------------------------------------+\n| POLYGON((5 5,5 10,0 10,-3.5355339059327373 8.535533905932738, |\n| -5 5,-5 0,0 0,5 0,5 5))                                       |\n+---------------------------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/spatial-operator-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (521,21,'ST_BUFFER_STRATEGY','ST_Buffer_Strategy(strategy[, points_per_circle])\n\nThis function returns a strategy byte string for use with ST_Buffer()\nto influence buffer computation.\n\nInformation about strategies is available at Boost.org\n(http://www.boost.org).\n\nThe first argument must be a string indicating a strategy option:\n\no For point strategies, permitted values are \'point_circle\' and\n  \'point_square\'.\n\no For join strategies, permitted values are \'join_round\' and\n  \'join_miter\'.\n\no For end strategies, permitted values are \'end_round\' and \'end_flat\'.\n\nIf the first argument is \'point_circle\', \'join_round\', \'join_miter\', or\n\'end_round\', the points_per_circle argument must be given as a positive\nnumeric value. The maximum points_per_circle value is the value of the\nmax_points_in_geometry system variable.\n\nFor examples, see the description of ST_Buffer().\n\nST_Buffer_Strategy() handles its arguments as described in the\nintroduction to this section, with these exceptions:\n\no If any argument is invalid, an ER_WRONG_ARGUMENTS error occurs.\n\no If the first argument is \'point_square\' or \'end_flat\', the\n  points_per_circle argument must not be given or an ER_WRONG_ARGUMENTS\n  error occurs.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-operator-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/spatial-operator-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (522,33,'ST_CENTROID','ST_Centroid({poly|mpoly})\n\nReturns the mathematical centroid for the Polygon or MultiPolygon\nargument as a Point. The result is not guaranteed to be on the\nMultiPolygon.\n\nThis function processes geometry collections by computing the centroid\npoint for components of highest dimension in the collection. Such\ncomponents are extracted and made into a single MultiPolygon,\nMultiLineString, or MultiPoint for centroid computation.\n\nST_Centroid() handles its arguments as described in the introduction to\nthis section, with these exceptions:\n\no The return value is NULL for the additional condition that the\n  argument is an empty geometry collection.\n\no If the geometry has an SRID value for a geographic spatial reference\n  system (SRS), an ER_NOT_IMPLEMENTED_FOR_GEOGRAPHIC_SRS error occurs.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-polygon-property-functions.html\n\n','mysql> SET @poly =\n       ST_GeomFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),(5 5,7 5,7 7,5 7,5 5))\');\nmysql> SELECT ST_GeometryType(@poly),ST_AsText(ST_Centroid(@poly));\n+------------------------+--------------------------------------------+\n| ST_GeometryType(@poly) | ST_AsText(ST_Centroid(@poly))              |\n+------------------------+--------------------------------------------+\n| POLYGON                | POINT(4.958333333333333 4.958333333333333) |\n+------------------------+--------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/gis-polygon-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (523,20,'ST_CONTAINS','ST_Contains(g1, g2)\n\nReturns 1 or 0 to indicate whether g1 completely contains g2. This\ntests the opposite relationship as ST_Within().\n\nST_Contains() handles its arguments as described in the introduction to\nthis section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-object-shapes.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-object-shapes.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (524,21,'ST_CONVEXHULL','ST_ConvexHull(g)\n\nReturns a geometry that represents the convex hull of the geometry\nvalue g.\n\nThis function computes a geometry\'s convex hull by first checking\nwhether its vertex points are colinear. The function returns a linear\nhull if so, a polygon hull otherwise. This function processes geometry\ncollections by extracting all vertex points of all components of the\ncollection, creating a MultiPoint value from them, and computing its\nconvex hull.\n\nST_ConvexHull() handles its arguments as described in the introduction\nto this section, with this exception:\n\no The return value is NULL for the additional condition that the\n  argument is an empty geometry collection.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-operator-functions.html\n\n','mysql> SET @g = \'MULTIPOINT(5 0,25 0,15 10,15 25)\';\nmysql> SELECT ST_AsText(ST_ConvexHull(ST_GeomFromText(@g)));\n+-----------------------------------------------+\n| ST_AsText(ST_ConvexHull(ST_GeomFromText(@g))) |\n+-----------------------------------------------+\n| POLYGON((5 0,25 0,15 25,5 0))                 |\n+-----------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/spatial-operator-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (525,20,'ST_CROSSES','ST_Crosses(g1, g2)\n\nTwo geometries spatially cross if their spatial relation has the\nfollowing properties:\n\no Unless g1 and and g2 are both of dimension 1: g1 crosses g2 if the\n  interior of g2 has points in common with the interior of g1, but g2\n  does not cover the entire interior of g1.\n\no If both g1 and g2 are of dimension 1: If the lines cross each other\n  in a finite number of points (that is, no common line segments, only\n  single points in common).\n\nThis function returns 1 or 0 to indicate whether g1 spatially crosses\ng2.\n\nST_Crosses() handles its arguments as described in the introduction to\nthis section except that the return value is NULL for these additional\nconditions:\n\no g1 is of dimension 2 (Polygon or MultiPolygon).\n\no g2 is of dimension 1 (Point or MultiPoint).\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-object-shapes.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-object-shapes.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (526,21,'ST_DIFFERENCE','ST_Difference(g1, g2)\n\nReturns a geometry that represents the point set difference of the\ngeometry values g1 and g2.\n\nST_Difference() handles its arguments as described in the introduction\nto this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-operator-functions.html\n\n','mysql> SET @g1 = Point(1,1), @g2 = Point(2,2);\nmysql> SELECT ST_AsText(ST_Difference(@g1, @g2));\n+------------------------------------+\n| ST_AsText(ST_Difference(@g1, @g2)) |\n+------------------------------------+\n| POINT(1 1)                         |\n+------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/spatial-operator-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (527,19,'ST_DIMENSION','ST_Dimension(g)\n\nReturns the inherent dimension of the geometry value g. The dimension\ncan be −1, 0, 1, or 2. The meaning of these values is given in\nhttp://dev.mysql.com/doc/refman/8.0/en/gis-class-geometry.html.\n\nST_Dimension() handles its arguments as described in the introduction\nto this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-general-property-functions.html\n\n','mysql> SELECT ST_Dimension(ST_GeomFromText(\'LineString(1 1,2 2)\'));\n+------------------------------------------------------+\n| ST_Dimension(ST_GeomFromText(\'LineString(1 1,2 2)\')) |\n+------------------------------------------------------+\n|                                                    1 |\n+------------------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/gis-general-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (528,20,'ST_DISJOINT','ST_Disjoint(g1, g2)\n\nReturns 1 or 0 to indicate whether g1 is spatially disjoint from (does\nnot intersect) g2.\n\nST_Disjoint() handles its arguments as described in the introduction to\nthis section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-object-shapes.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-object-shapes.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (529,20,'ST_DISTANCE','ST_Distance(g1, g2 [, unit])\n\nReturns the distance between g1 and g2, measured in the length unit of\nthe spatial reference system (SRS) of the geometry arguments, or in the\nunit of the optional unit argument if that is specified.\n\nThis function processes geometry collections by returning the shortest\ndistance among all combinations of the components of the two geometry\narguments.\n\nST_Distance() handles its geometry arguments as described in the\nintroduction to this section, with these exceptions:\n\no ST_Distance() detects arguments in a geographic (ellipsoidal) spatial\n  reference system and returns the geodetic distance on the ellipsoid.\n  The only permitted geographic argument types are Point and Point, or\n  Point and MultiPoint (in any argument order). If called with other\n  geometry type argument combinations in a geographic SRS, an\n  ER_NOT_IMPLEMENTED_FOR_GEOGRAPHIC_SRS error occurs.\n\no If any argument is geometrically invalid, either the result is an\n  undefined distance (that is, it can be any number), or an error\n  occurs.\n\no If an intermediate or final result produces NaN or a negative number,\n  an ER_GIS_INVALID_DATA error occurs.\n\nAs of MySQL 8.0.14, ST_Distance() permits an optional unit argument\nthat specifies the linear unit for the returned distance value. These\nrules apply:\n\no If a unit is specified but not supported by MySQL, an\n  ER_UNIT_NOT_FOUND error occurs.\n\no If a supported linear unit is specified and the SRID is 0, an\n  ER_GEOMETRY_IN_UNKNOWN_LENGTH_UNIT error occurs.\n\no If a supported linear unit is specified and the SRID is not 0, the\n  result is in that unit.\n\no If a unit is not specified, the result is in the unit of the SRS of\n  the geometries, whether Cartesian or geographic. Currently, all MySQL\n  SRSs are expressed in meters.\n\nA unit is supported if it is found in the INFORMATION_SCHEMA\nST_UNITS_OF_MEASURE table. See\nhttp://dev.mysql.com/doc/refman/8.0/en/st-units-of-measure-table.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-object-shapes.html\n\n','mysql> SET @g1 = Point(1,1);\nmysql> SET @g2 = Point(2,2);\nmysql> SELECT ST_Distance(@g1, @g2);\n+-----------------------+\n| ST_Distance(@g1, @g2) |\n+-----------------------+\n|    1.4142135623730951 |\n+-----------------------+\n\nmysql> SET @g1 = ST_GeomFromText(\'POINT(1 1)\', 4326);\nmysql> SET @g2 = ST_GeomFromText(\'POINT(2 2)\', 4326);\nmysql> SELECT ST_Distance(@g1, @g2);\n+-----------------------+\n| ST_Distance(@g1, @g2) |\n+-----------------------+\n|     156874.3859490455 |\n+-----------------------+\nmysql> SELECT ST_Distance(@g1, @g2, \'metre\');\n+--------------------------------+\n| ST_Distance(@g1, @g2, \'metre\') |\n+--------------------------------+\n|              156874.3859490455 |\n+--------------------------------+\nmysql> SELECT ST_Distance(@g1, @g2, \'foot\');\n+-------------------------------+\n| ST_Distance(@g1, @g2, \'foot\') |\n+-------------------------------+\n|             514679.7439273146 |\n+-------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-object-shapes.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (530,28,'ST_DISTANCE_SPHERE','ST_Distance_Sphere(g1, g2 [, radius])\n\nReturns the mimimum spherical distance between Point or MultiPoint\narguments on a sphere, in meters. (For general-purpose distance\ncalculations, see the ST_Distance() function.) The optional radius\nargument should be given in meters.\n\nIf both geometry parameters are valid Cartesian Point or MultiPoint\nvalues in SRID 0, the return value is shortest distance between the two\ngeometries on a sphere with the provided radius. If omitted, the\ndefault radius is 6,370,986 meters, Point X and Y coordinates are\ninterpreted as longitude and latitude, respectively, in degrees.\n\nIf both geometry parameters are valid Point or MultiPoint values in a\ngeographic spatial reference system (SRS), the return value is the\nshortest distance between the two geometries on a sphere with the\nprovided radius. If omitted, the default radius is equal to the mean\nradius, defined as (2a+b)/3, where a is the semi-major axis and b is\nthe semi-minor axis of the SRS.\n\nST_Distance_Sphere() handles its arguments as described in the\nintroduction to this section, with these exceptions:\n\no Supported geometry argument combinations are Point and Point, or\n  Point and MultiPoint (in any argument order). If at least one of the\n  geometries is neither Point nor MultiPoint, and its SRID is 0, an\n  ER_NOT_IMPLEMENTED_FOR_CARTESIAN_SRS error occurs. If at least one of\n  the geometries is neither Point nor MultiPoint, and its SRID refers\n  to a geographic SRS, an ER_NOT_IMPLEMENTED_FOR_GEOGRAPHIC_SRS error\n  occurs. If any geometry refers to a projected SRS, an\n  ER_NOT_IMPLEMENTED_FOR_PROJECTED_SRS error occurs.\n\no If any argument has a longitude or latitude that is out of range, an\n  error occurs:\n\n  o If any longitude argument is not in the range (−180, 180], an\n    ER_LONGITUDE_OUT_OF_RANGE error occurs.\n\n  o If any latitude argument is not in the range [−90, 90], an\n    ER_LATITUDE_OUT_OF_RANGE error occurs.\n\n  Ranges shown are in degrees. If an SRS uses another unit, the range\n  uses the corresponding values in its unit. The exact range limits\n  deviate slightly due to floating-point arithmetic.\n\no If the radius argument is present but not positive, an\n  ER_NONPOSITIVE_RADIUS error occurs.\n\no If the distance exceeds the range of a double-precision number, an\n  ER_STD_OVERFLOW_ERROR error occurs.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-convenience-functions.html\n\n','mysql> SET @pt1 = ST_GeomFromText(\'POINT(0 0)\');\nmysql> SET @pt2 = ST_GeomFromText(\'POINT(180 0)\');\nmysql> SELECT ST_Distance_Sphere(@pt1, @pt2);\n+--------------------------------+\n| ST_Distance_Sphere(@pt1, @pt2) |\n+--------------------------------+\n|             20015042.813723423 |\n+--------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/spatial-convenience-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (531,25,'ST_ENDPOINT','ST_EndPoint(ls)\n\nReturns the Point that is the endpoint of the LineString value ls.\n\nST_EndPoint() handles its arguments as described in the introduction to\nthis section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-linestring-property-functions.html\n\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT ST_AsText(ST_EndPoint(ST_GeomFromText(@ls)));\n+----------------------------------------------+\n| ST_AsText(ST_EndPoint(ST_GeomFromText(@ls))) |\n+----------------------------------------------+\n| POINT(3 3)                                   |\n+----------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/gis-linestring-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (532,19,'ST_ENVELOPE','ST_Envelope(g)\n\nReturns the minimum bounding rectangle (MBR) for the geometry value g.\nThe result is returned as a Polygon value that is defined by the corner\npoints of the bounding box:\n\nPOLYGON((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n\nmysql> SELECT ST_AsText(ST_Envelope(ST_GeomFromText(\'LineString(1 1,2 2)\')));\n+----------------------------------------------------------------+\n| ST_AsText(ST_Envelope(ST_GeomFromText(\'LineString(1 1,2 2)\'))) |\n+----------------------------------------------------------------+\n| POLYGON((1 1,2 1,2 2,1 2,1 1))                                 |\n+----------------------------------------------------------------+\n\nIf the argument is a point or a vertical or horizontal line segment,\nST_Envelope() returns the point or the line segment as its MBR rather\nthan returning an invalid polygon:\n\nmysql> SELECT ST_AsText(ST_Envelope(ST_GeomFromText(\'LineString(1 1,1 2)\')));\n+----------------------------------------------------------------+\n| ST_AsText(ST_Envelope(ST_GeomFromText(\'LineString(1 1,1 2)\'))) |\n+----------------------------------------------------------------+\n| LINESTRING(1 1,1 2)                                            |\n+----------------------------------------------------------------+\n\nST_Envelope() handles its arguments as described in the introduction to\nthis section, with this exception:\n\no If the geometry has an SRID value for a geographic spatial reference\n  system (SRS), an ER_NOT_IMPLEMENTED_FOR_GEOGRAPHIC_SRS error occurs.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-general-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-general-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (533,20,'ST_EQUALS','ST_Equals(g1, g2)\n\nReturns 1 or 0 to indicate whether g1 is spatially equal to g2.\n\nST_Equals() handles its arguments as described in the introduction to\nthis section, except that it does not return NULL for empty geometry\narguments.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-object-shapes.html\n\n','mysql> SET @g1 = Point(1,1), @g2 = Point(2,2);\nmysql> SELECT ST_Equals(@g1, @g1), ST_Equals(@g1, @g2);\n+---------------------+---------------------+\n| ST_Equals(@g1, @g1) | ST_Equals(@g1, @g2) |\n+---------------------+---------------------+\n|                   1 |                   0 |\n+---------------------+---------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-object-shapes.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (534,33,'ST_EXTERIORRING','ST_ExteriorRing(poly)\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() handles its arguments as described in the\nintroduction to this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-polygon-property-functions.html\n\n','mysql> SET @poly =\n       \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\nmysql> SELECT ST_AsText(ST_ExteriorRing(ST_GeomFromText(@poly)));\n+----------------------------------------------------+\n| ST_AsText(ST_ExteriorRing(ST_GeomFromText(@poly))) |\n+----------------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)                    |\n+----------------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/gis-polygon-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (535,28,'ST_GEOHASH','ST_GeoHash(longitude, latitude, max_length), ST_GeoHash(point,\nmax_length)\n\nReturns a geohash string in the connection character set and collation.\n\nFor the first syntax, the longitude must be a number in the range\n[−180, 180], and the latitude must be a number in the range [−90,\n90]. For the second syntax, a POINT value is required, where the X and\nY coordinates are in the valid ranges for longitude and latitude,\nrespectively.\n\nThe resulting string is no longer than max_length characters, which has\nan upper limit of 100. The string might be shorter than max_length\ncharacters because the algorithm that creates the geohash value\ncontinues until it has created a string that is either an exact\nrepresentation of the location or max_length characters, whichever\ncomes first.\n\nST_GeoHash() handles its arguments as described in the introduction to\nthis section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-geohash-functions.html\n\n','mysql> SELECT ST_GeoHash(180,0,10), ST_GeoHash(-180,-90,15);\n+----------------------+-------------------------+\n| ST_GeoHash(180,0,10) | ST_GeoHash(-180,-90,15) |\n+----------------------+-------------------------+\n| xbpbpbpbpb           | 000000000000000         |\n+----------------------+-------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/spatial-geohash-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (536,41,'ST_GEOMCOLLFROMTEXT','ST_GeomCollFromText(wkt[, srid [, options]]),\nST_GeometryCollectionFromText(wkt[, srid [, options]]),\nST_GeomCollFromTxt(wkt[, srid [, options]])\n\nConstructs a GeometryCollection value using its WKT representation and\nSRID.\n\nThese functions handle their arguments as described in the introduction\nto this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-wkt-functions.html\n\n','mysql> SET @g = "MULTILINESTRING((10 10, 11 11), (9 9, 10 10))";\nmysql> SELECT ST_AsText(ST_GeomCollFromText(@g));\n+--------------------------------------------+\n| ST_AsText(ST_GeomCollFromText(@g))         |\n+--------------------------------------------+\n| MULTILINESTRING((10 10,11 11),(9 9,10 10)) |\n+--------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/gis-wkt-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (537,40,'ST_GEOMCOLLFROMWKB','ST_GeomCollFromWKB(wkb[, srid [, options]]),\nST_GeometryCollectionFromWKB(wkb[, srid [, options]])\n\nConstructs a GeometryCollection value using its WKB representation and\nSRID.\n\nThese functions handle their arguments as described in the introduction\nto this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-wkb-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (538,21,'ST_GEOMETRYN','ST_GeometryN(gc, N)\n\nReturns the N-th geometry in the GeometryCollection value gc.\nGeometries are numbered beginning with 1.\n\nST_GeometryN() handles its arguments as described in the introduction\nto this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-geometrycollection-property-functions.html\n\n','mysql> SET @gc = \'GeometryCollection(Point(1 1),LineString(2 2, 3 3))\';\nmysql> SELECT ST_AsText(ST_GeometryN(ST_GeomFromText(@gc),1));\n+-------------------------------------------------+\n| ST_AsText(ST_GeometryN(ST_GeomFromText(@gc),1)) |\n+-------------------------------------------------+\n| POINT(1 1)                                      |\n+-------------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/gis-geometrycollection-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (539,19,'ST_GEOMETRYTYPE','ST_GeometryType(g)\n\nReturns a binary string indicating the name of the geometry type of\nwhich the geometry instance g is a member. The name corresponds to one\nof the instantiable Geometry subclasses.\n\nST_GeometryType() handles its arguments as described in the\nintroduction to this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-general-property-functions.html\n\n','mysql> SELECT ST_GeometryType(ST_GeomFromText(\'POINT(1 1)\'));\n+------------------------------------------------+\n| ST_GeometryType(ST_GeomFromText(\'POINT(1 1)\')) |\n+------------------------------------------------+\n| POINT                                          |\n+------------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/gis-general-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (540,28,'ST_GEOMFROMGEOJSON','ST_GeomFromGeoJSON(str [, options [, srid]])\n\nParses a string str representing a GeoJSON object and returns a\ngeometry.\n\nIf any argument is NULL, the return value is NULL. If any non-NULL\nargument is invalid, an error occurs.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-geojson-functions.html\n\n','mysql> SET @json = \'{ "type": "Point", "coordinates": [102.0, 0.0]}\';\nmysql> SELECT ST_AsText(ST_GeomFromGeoJSON(@json));\n+--------------------------------------+\n| ST_AsText(ST_GeomFromGeoJSON(@json)) |\n+--------------------------------------+\n| POINT(102 0)                         |\n+--------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/spatial-geojson-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (541,41,'ST_GEOMFROMTEXT','ST_GeomFromText(wkt[, srid [, options]]), ST_GeometryFromText(wkt[,\nsrid [, options]])\n\nConstructs a geometry value of any type using its WKT representation\nand SRID.\n\nThese functions handle their arguments as described in the introduction\nto this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-wkt-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (542,40,'ST_GEOMFROMWKB','ST_GeomFromWKB(wkb[, srid [, options]]), ST_GeometryFromWKB(wkb[, srid\n[, options]])\n\nConstructs a geometry value of any type using its WKB representation\nand SRID.\n\nThese functions handle their arguments as described in the introduction\nto this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-wkb-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (543,33,'ST_INTERIORRINGN','ST_InteriorRingN(poly, N)\n\nReturns the N-th interior ring for the Polygon value poly as a\nLineString. Rings are numbered beginning with 1.\n\nST_InteriorRingN() handles its arguments as described in the\nintroduction to this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-polygon-property-functions.html\n\n','mysql> SET @poly =\n       \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\nmysql> SELECT ST_AsText(ST_InteriorRingN(ST_GeomFromText(@poly),1));\n+-------------------------------------------------------+\n| ST_AsText(ST_InteriorRingN(ST_GeomFromText(@poly),1)) |\n+-------------------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)                       |\n+-------------------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/gis-polygon-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (544,21,'ST_INTERSECTION','ST_Intersection(g1, g2)\n\nReturns a geometry that represents the point set intersection of the\ngeometry values g1 and g2.\n\nST_Intersection() handles its arguments as described in the\nintroduction to this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-operator-functions.html\n\n','mysql> SET @g1 = ST_GeomFromText(\'LineString(1 1, 3 3)\');\nmysql> SET @g2 = ST_GeomFromText(\'LineString(1 3, 3 1)\');\nmysql> SELECT ST_AsText(ST_Intersection(@g1, @g2));\n+--------------------------------------+\n| ST_AsText(ST_Intersection(@g1, @g2)) |\n+--------------------------------------+\n| POINT(2 2)                           |\n+--------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/spatial-operator-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (545,20,'ST_INTERSECTS','ST_Intersects(g1, g2)\n\nReturns 1 or 0 to indicate whether g1 spatially intersects g2.\n\nST_Intersects() handles its arguments as described in the introduction\nto this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-object-shapes.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-object-shapes.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (546,25,'ST_ISCLOSED','ST_IsClosed(ls)\n\nFor a LineString value ls, ST_IsClosed() returns 1 if ls is closed\n(that is, its ST_StartPoint() and ST_EndPoint() values are the same).\n\nFor a MultiLineString value ls, ST_IsClosed() returns 1 if ls is closed\n(that is, the ST_StartPoint() and ST_EndPoint() values are the same for\neach LineString in ls).\n\nST_IsClosed() returns 0 if ls is not closed, and NULL if ls is NULL.\n\nST_IsClosed() handles its arguments as described in the introduction to\nthis section, with this exception:\n\no If the geometry has an SRID value for a geographic spatial reference\n  system (SRS), an ER_NOT_IMPLEMENTED_FOR_GEOGRAPHIC_SRS error occurs.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-linestring-property-functions.html\n\n','mysql> SET @ls1 = \'LineString(1 1,2 2,3 3,2 2)\';\nmysql> SET @ls2 = \'LineString(1 1,2 2,3 3,1 1)\';\n\nmysql> SELECT ST_IsClosed(ST_GeomFromText(@ls1));\n+------------------------------------+\n| ST_IsClosed(ST_GeomFromText(@ls1)) |\n+------------------------------------+\n|                                  0 |\n+------------------------------------+\n\nmysql> SELECT ST_IsClosed(ST_GeomFromText(@ls2));\n+------------------------------------+\n| ST_IsClosed(ST_GeomFromText(@ls2)) |\n+------------------------------------+\n|                                  1 |\n+------------------------------------+\n\nmysql> SET @ls3 = \'MultiLineString((1 1,2 2,3 3),(4 4,5 5))\';\n\nmysql> SELECT ST_IsClosed(ST_GeomFromText(@ls3));\n+------------------------------------+\n| ST_IsClosed(ST_GeomFromText(@ls3)) |\n+------------------------------------+\n|                                  0 |\n+------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/gis-linestring-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (547,19,'ST_ISEMPTY','ST_IsEmpty(g)\n\nThis function is a placeholder that returns 1 for an empty geometry\ncollection value or 0 otherwise.\n\nThe only valid empty geometry is represented in the form of an empty\ngeometry collection value. MySQL does not support GIS EMPTY values such\nas POINT EMPTY.\n\nST_IsEmpty() handles its arguments as described in the introduction to\nthis section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-general-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-general-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (548,19,'ST_ISSIMPLE','ST_IsSimple(g)\n\nReturns 1 if the geometry value g is simple according to the ISO SQL/MM\nPart 3: Spatial standard. ST_IsSimple() returns 0 if the argument is\nnot simple.\n\nThe descriptions of the instantiable geometric classes given under\nhttp://dev.mysql.com/doc/refman/8.0/en/opengis-geometry-model.html\ninclude the specific conditions that cause class instances to be\nclassified as not simple.\n\nST_IsSimple() handles its arguments as described in the introduction to\nthis section, with this exception:\n\no If the geometry has a geographic SRS with a longitude or latitude\n  that is out of range, an error occurs:\n\n  o If any longitude argument is not in the range (−180, 180], an\n    ER_LONGITUDE_OUT_OF_RANGE error occurs.\n\n  o If any latitude argument is not in the range [−90, 90], an\n    ER_LATITUDE_OUT_OF_RANGE error occurs.\n\n  Ranges shown are in degrees. The exact range limits deviate slightly\n  due to floating-point arithmetic.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-general-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-general-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (549,28,'ST_ISVALID','ST_IsValid(g)\n\nReturns 1 if the argument is geometrically valid, 0 if the argument is\nnot geometrically valid. Geometry validity is defined by the OGC\nspecification.\n\nThe only valid empty geometry is represented in the form of an empty\ngeometry collection value. ST_IsValid() returns 1 in this case. MySQL\ndoes not support GIS EMPTY values such as POINT EMPTY.\n\nST_IsValid() handles its arguments as described in the introduction to\nthis section, with this exception:\n\no If the geometry has a geographic SRS with a longitude or latitude\n  that is out of range, an error occurs:\n\n  o If any longitude argument is not in the range (−180, 180], an\n    ER_LONGITUDE_OUT_OF_RANGE error occurs.\n\n  o If any latitude argument is not in the range [−90, 90], an\n    ER_LATITUDE_OUT_OF_RANGE error occurs.\n\n  Ranges shown are in degrees. If an SRS uses another unit, the range\n  uses the corresponding values in its unit. The exact range limits\n  deviate slightly due to floating-point arithmetic.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-convenience-functions.html\n\n','mysql> SET @ls1 = ST_GeomFromText(\'LINESTRING(0 0,-0.00 0,0.0 0)\');\nmysql> SET @ls2 = ST_GeomFromText(\'LINESTRING(0 0, 1 1)\');\nmysql> SELECT ST_IsValid(@ls1);\n+------------------+\n| ST_IsValid(@ls1) |\n+------------------+\n|                0 |\n+------------------+\nmysql> SELECT ST_IsValid(@ls2);\n+------------------+\n| ST_IsValid(@ls2) |\n+------------------+\n|                1 |\n+------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/spatial-convenience-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (550,28,'ST_LATFROMGEOHASH','ST_LatFromGeoHash(geohash_str)\n\nReturns the latitude from a geohash string value, as a double-precision\nnumber in the range [−90, 90].\n\nThe ST_LatFromGeoHash() decoding function reads no more than 433\ncharacters from the geohash_str argument. That represents the upper\nlimit on information in the internal representation of coordinate\nvalues. Characters past the 433rd are ignored, even if they are\notherwise illegal and produce an error.\n\nST_LatFromGeoHash() handles its arguments as described in the\nintroduction to this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-geohash-functions.html\n\n','mysql> SELECT ST_LatFromGeoHash(ST_GeoHash(45,-20,10));\n+------------------------------------------+\n| ST_LatFromGeoHash(ST_GeoHash(45,-20,10)) |\n+------------------------------------------+\n|                                      -20 |\n+------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/spatial-geohash-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (551,32,'ST_LATITUDE','ST_Latitude(p [, new_latitude_val])\n\nWith a single argument representing a valid Point object p that has a\ngeographic spatial reference system (SRS), ST_Latitude() returns the\nlatitude value of p as a double-precision number.\n\nWith the optional second argument representing a valid latitude value,\nST_Latitude() returns a Point object like the first argument with its\nlatitude equal to the second argument.\n\nST_Latitude() handles its arguments as described in the introduction to\nthis section, with the addition that if the Point object is valid but\ndoes not have a geographic SRS, an ER_SRS_NOT_GEOGRAPHIC error occurs.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-point-property-functions.html\n\n','mysql> SET @pt = ST_GeomFromText(\'POINT(45 90)\', 4326);\nmysql> SELECT ST_Latitude(@pt);\n+------------------+\n| ST_Latitude(@pt) |\n+------------------+\n|               45 |\n+------------------+\nmysql> SELECT ST_AsText(ST_Latitude(@pt, 10));\n+---------------------------------+\n| ST_AsText(ST_Latitude(@pt, 10)) |\n+---------------------------------+\n| POINT(10 90)                    |\n+---------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/gis-point-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (552,25,'ST_LENGTH','ST_Length(ls [, unit])\n\nReturns a double-precision number indicating the length of the\nLineString or MultiLineString value ls in its associated spatial\nreference system. The length of a MultiLineString value is equal to the\nsum of the lengths of its elements.\n\nST_Length() computes a result as follows:\n\no If the geometry is a valid LineString in a Cartesian SRS, the return\n  value is the Cartesian length of the geometry.\n\no If the geometry is a valid MultiLineString in a Cartesian SRS, the\n  return value is the sum of the Cartesian lengths of its elements.\n\no If the geometry is a valid LineString in a geographic SRS, the return\n  value is the geodetic length of the geometry in that SRS, in meters.\n\no If the geometry is a valid MultiLineString in a geographic SRS, the\n  return value is the sum of the geodetic lengths of its elements in\n  that SRS, in meters.\n\nST_Length() handles its arguments as described in the introduction to\nthis section, with these exceptions:\n\no If the geometry is not a LineString or MultiLineString, the return\n  value is NULL.\n\no If the geometry is geometrically invalid, either the result is an\n  undefined length (that is, it can be any number), or an error occurs.\n\no If the length computation result is +inf, an ER_DATA_OUT_OF_RANGE\n  error occurs.\n\no If the geometry has a geographic SRS with a longitude or latitude\n  that is out of range, an error occurs:\n\n  o If any longitude argument is not in the range (−180, 180], an\n    ER_LONGITUDE_OUT_OF_RANGE error occurs.\n\n  o If any latitude argument is not in the range [−90, 90], an\n    ER_LATITUDE_OUT_OF_RANGE error occurs.\n\n  Ranges shown are in degrees. The exact range limits deviate slightly\n  due to floating-point arithmetic.\n\nAs of MySQL 8.0.16, ST_Length() permits an optional unit argument that\nspecifies the linear unit for the returned length value. These rules\napply:\n\no If a unit is specified but not supported by MySQL, an\n  ER_UNIT_NOT_FOUND error occurs.\n\no If a supported linear unit is specified and the SRID is 0, an\n  ER_GEOMETRY_IN_UNKNOWN_LENGTH_UNIT error occurs.\n\no If a supported linear unit is specified and the SRID is not 0, the\n  result is in that unit.\n\no If a unit is not specified, the result is in the unit of the SRS of\n  the geometries, whether Cartesian or geographic. Currently, all MySQL\n  SRSs are expressed in meters.\n\nA unit is supported if it is found in the INFORMATION_SCHEMA\nST_UNITS_OF_MEASURE table. See\nhttp://dev.mysql.com/doc/refman/8.0/en/st-units-of-measure-table.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-linestring-property-functions.html\n\n','mysql> SET @ls = ST_GeomFromText(\'LineString(1 1,2 2,3 3)\');\nmysql> SELECT ST_Length(@ls);\n+--------------------+\n| ST_Length(@ls)     |\n+--------------------+\n| 2.8284271247461903 |\n+--------------------+\n\nmysql> SET @mls = ST_GeomFromText(\'MultiLineString((1 1,2 2,3 3),(4 4,5 5))\');\nmysql> SELECT ST_Length(@mls);\n+-------------------+\n| ST_Length(@mls)   |\n+-------------------+\n| 4.242640687119286 |\n+-------------------+\n\nmysql> SET @ls = ST_GeomFromText(\'LineString(1 1,2 2,3 3)\', 4326);\nmysql> SELECT ST_Length(@ls);\n+-------------------+\n| ST_Length(@ls)    |\n+-------------------+\n| 313701.9623204328 |\n+-------------------+\nmysql> SELECT ST_Length(@ls, \'metre\');\n+-------------------------+\n| ST_Length(@ls, \'metre\') |\n+-------------------------+\n|       313701.9623204328 |\n+-------------------------+\nmysql> SELECT ST_Length(@ls, \'foot\');\n+------------------------+\n| ST_Length(@ls, \'foot\') |\n+------------------------+\n|     1029205.9131247795 |\n+------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/gis-linestring-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (553,41,'ST_LINEFROMTEXT','ST_LineFromText(wkt[, srid [, options]]), ST_LineStringFromText(wkt[,\nsrid [, options]])\n\nConstructs a LineString value using its WKT representation and SRID.\n\nThese functions handle their arguments as described in the introduction\nto this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-wkt-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (554,40,'ST_LINEFROMWKB','ST_LineFromWKB(wkb[, srid [, options]]), ST_LineStringFromWKB(wkb[,\nsrid [, options]])\n\nConstructs a LineString value using its WKB representation and SRID.\n\nThese functions handle their arguments as described in the introduction\nto this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-wkb-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (555,28,'ST_LONGFROMGEOHASH','ST_LongFromGeoHash(geohash_str)\n\nReturns the longitude from a geohash string value, as a\ndouble-precision number in the range [−180, 180].\n\nThe remarks in the description of ST_LatFromGeoHash() regarding the\nmaximum number of characters processed from the geohash_str argument\nalso apply to ST_LongFromGeoHash().\n\nST_LongFromGeoHash() handles its arguments as described in the\nintroduction to this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-geohash-functions.html\n\n','mysql> SELECT ST_LongFromGeoHash(ST_GeoHash(45,-20,10));\n+-------------------------------------------+\n| ST_LongFromGeoHash(ST_GeoHash(45,-20,10)) |\n+-------------------------------------------+\n|                                        45 |\n+-------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/spatial-geohash-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (556,32,'ST_LONGITUDE','ST_Longitude(p [, new_longitude_val])\n\nWith a single argument representing a valid Point object p that has a\ngeographic spatial reference system (SRS), ST_Longitude() returns the\nlongitude value of p as a double-precision number.\n\nWith the optional second argument representing a valid longitude value,\nST_Longitude() returns a Point object like the first argument with its\nlongitude equal to the second argument.\n\nST_Longitude() handles its arguments as described in the introduction\nto this section, with the addition that if the Point object is valid\nbut does not have a geographic SRS, an ER_SRS_NOT_GEOGRAPHIC error\noccurs.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-point-property-functions.html\n\n','mysql> SET @pt = ST_GeomFromText(\'POINT(45 90)\', 4326);\nmysql> SELECT ST_Longitude(@pt);\n+-------------------+\n| ST_Longitude(@pt) |\n+-------------------+\n|                90 |\n+-------------------+\nmysql> SELECT ST_AsText(ST_Longitude(@pt, 10));\n+----------------------------------+\n| ST_AsText(ST_Longitude(@pt, 10)) |\n+----------------------------------+\n| POINT(45 10)                     |\n+----------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/gis-point-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (557,28,'ST_MAKEENVELOPE','ST_MakeEnvelope(pt1, pt2)\n\nReturns the rectangle that forms the envelope around two points, as a\nPoint, LineString, or Polygon.\n\nCalculations are done using the Cartesian coordinate system rather than\non a sphere, spheroid, or on earth.\n\nGiven two points pt1 and pt2, ST_MakeEnvelope() creates the result\ngeometry on an abstract plane like this:\n\no If pt1 and pt2 are equal, the result is the point pt1.\n\no Otherwise, if (pt1, pt2) is a vertical or horizontal line segment,\n  the result is the line segment (pt1, pt2).\n\no Otherwise, the result is a polygon using pt1 and pt2 as diagonal\n  points.\n\nThe result geometry has an SRID of 0.\n\nST_MakeEnvelope() handles its arguments as described in the\nintroduction to this section, with these exceptions:\n\no If the arguments are not Point values, an ER_WRONG_ARGUMENTS error\n  occurs.\n\no An ER_GIS_INVALID_DATA error occurs for the additional condition that\n  any coordinate value of the two points is infinite or NaN.\n\no If any geometry has an SRID value for a geographic spatial reference\n  system (SRS), an ER_NOT_IMPLEMENTED_FOR_GEOGRAPHIC_SRS error occurs.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-convenience-functions.html\n\n','mysql> SET @pt1 = ST_GeomFromText(\'POINT(0 0)\');\nmysql> SET @pt2 = ST_GeomFromText(\'POINT(1 1)\');\nmysql> SELECT ST_AsText(ST_MakeEnvelope(@pt1, @pt2));\n+----------------------------------------+\n| ST_AsText(ST_MakeEnvelope(@pt1, @pt2)) |\n+----------------------------------------+\n| POLYGON((0 0,1 0,1 1,0 1,0 0))         |\n+----------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/spatial-convenience-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (558,41,'ST_MLINEFROMTEXT','ST_MLineFromText(wkt[, srid [, options]]),\nST_MultiLineStringFromText(wkt[, srid [, options]])\n\nConstructs a MultiLineString value using its WKT representation and\nSRID.\n\nThese functions handle their arguments as described in the introduction\nto this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-wkt-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (559,40,'ST_MLINEFROMWKB','ST_MLineFromWKB(wkb[, srid [, options]]),\nST_MultiLineStringFromWKB(wkb[, srid [, options]])\n\nConstructs a MultiLineString value using its WKB representation and\nSRID.\n\nThese functions handle their arguments as described in the introduction\nto this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-wkb-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (560,41,'ST_MPOINTFROMTEXT','ST_MPointFromText(wkt[, srid [, options]]), ST_MultiPointFromText(wkt[,\nsrid [, options]])\n\nConstructs a MultiPoint value using its WKT representation and SRID.\n\nThese functions handle their arguments as described in the introduction\nto this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-wkt-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (561,40,'ST_MPOINTFROMWKB','ST_MPointFromWKB(wkb[, srid [, options]]), ST_MultiPointFromWKB(wkb[,\nsrid [, options]])\n\nConstructs a MultiPoint value using its WKB representation and SRID.\n\nThese functions handle their arguments as described in the introduction\nto this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-wkb-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (562,41,'ST_MPOLYFROMTEXT','ST_MPolyFromText(wkt[, srid [, options]]),\nST_MultiPolygonFromText(wkt[, srid [, options]])\n\nConstructs a MultiPolygon value using its WKT representation and SRID.\n\nThese functions handle their arguments as described in the introduction\nto this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-wkt-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (563,40,'ST_MPOLYFROMWKB','ST_MPolyFromWKB(wkb[, srid [, options]]), ST_MultiPolygonFromWKB(wkb[,\nsrid [, options]])\n\nConstructs a MultiPolygon value using its WKB representation and SRID.\n\nThese functions handle their arguments as described in the introduction\nto this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-wkb-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (564,21,'ST_NUMGEOMETRIES','ST_NumGeometries(gc)\n\nReturns the number of geometries in the GeometryCollection value gc.\n\nST_NumGeometries() handles its arguments as described in the\nintroduction to this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-geometrycollection-property-functions.html\n\n','mysql> SET @gc = \'GeometryCollection(Point(1 1),LineString(2 2, 3 3))\';\nmysql> SELECT ST_NumGeometries(ST_GeomFromText(@gc));\n+----------------------------------------+\n| ST_NumGeometries(ST_GeomFromText(@gc)) |\n+----------------------------------------+\n|                                      2 |\n+----------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/gis-geometrycollection-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (565,33,'ST_NUMINTERIORRINGS','ST_NumInteriorRing(poly), ST_NumInteriorRings(poly)\n\nReturns the number of interior rings in the Polygon value poly.\n\nST_NumInteriorRing() and ST_NuminteriorRings() handle their arguments\nas described in the introduction to this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-polygon-property-functions.html\n\n','mysql> SET @poly =\n       \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\nmysql> SELECT ST_NumInteriorRings(ST_GeomFromText(@poly));\n+---------------------------------------------+\n| ST_NumInteriorRings(ST_GeomFromText(@poly)) |\n+---------------------------------------------+\n|                                           1 |\n+---------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/gis-polygon-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (566,25,'ST_NUMPOINTS','ST_NumPoints(ls)\n\nReturns the number of Point objects in the LineString value ls.\n\nST_NumPoints() handles its arguments as described in the introduction\nto this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-linestring-property-functions.html\n\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT ST_NumPoints(ST_GeomFromText(@ls));\n+------------------------------------+\n| ST_NumPoints(ST_GeomFromText(@ls)) |\n+------------------------------------+\n|                                  3 |\n+------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/gis-linestring-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (567,20,'ST_OVERLAPS','ST_Overlaps(g1, g2)\n\nTwo geometries spatially overlap if they intersect and their\nintersection results in a geometry of the same dimension but not equal\nto either of the given geometries.\n\nThis function returns 1 or 0 to indicate whether g1 spatially overlaps\ng2.\n\nST_Overlaps() handles its arguments as described in the introduction to\nthis section except that the return value is NULL for the additional\ncondition that the dimensions of the two geometries are not equal.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-object-shapes.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-object-shapes.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (568,28,'ST_POINTFROMGEOHASH','ST_PointFromGeoHash(geohash_str, srid)\n\nReturns a POINT value containing the decoded geohash value, given a\ngeohash string value.\n\nThe X and Y coordinates of the point are the longitude in the range\n[−180, 180] and the latitude in the range [−90, 90], respectively.\n\nThe srid argument is an 32-bit unsigned integer.\n\nThe remarks in the description of ST_LatFromGeoHash() regarding the\nmaximum number of characters processed from the geohash_str argument\nalso apply to ST_PointFromGeoHash().\n\nST_PointFromGeoHash() handles its arguments as described in the\nintroduction to this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-geohash-functions.html\n\n','mysql> SET @gh = ST_GeoHash(45,-20,10);\nmysql> SELECT ST_AsText(ST_PointFromGeoHash(@gh,0));\n+---------------------------------------+\n| ST_AsText(ST_PointFromGeoHash(@gh,0)) |\n+---------------------------------------+\n| POINT(45 -20)                         |\n+---------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/spatial-geohash-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (569,41,'ST_POINTFROMTEXT','ST_PointFromText(wkt[, srid [, options]])\n\nConstructs a Point value using its WKT representation and SRID.\n\nST_PointFromText() handles its arguments as described in the\nintroduction to this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-wkt-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (570,40,'ST_POINTFROMWKB','ST_PointFromWKB(wkb[, srid [, options]])\n\nConstructs a Point value using its WKB representation and SRID.\n\nST_PointFromWKB() handles its arguments as described in the\nintroduction to this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-wkb-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (571,25,'ST_POINTN','ST_PointN(ls, N)\n\nReturns the N-th Point in the Linestring value ls. Points are numbered\nbeginning with 1.\n\nST_PointN() handles its arguments as described in the introduction to\nthis section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-linestring-property-functions.html\n\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT ST_AsText(ST_PointN(ST_GeomFromText(@ls),2));\n+----------------------------------------------+\n| ST_AsText(ST_PointN(ST_GeomFromText(@ls),2)) |\n+----------------------------------------------+\n| POINT(2 2)                                   |\n+----------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/gis-linestring-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (572,41,'ST_POLYFROMTEXT','ST_PolyFromText(wkt[, srid [, options]]), ST_PolygonFromText(wkt[, srid\n[, options]])\n\nConstructs a Polygon value using its WKT representation and SRID.\n\nThese functions handle their arguments as described in the introduction\nto this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-wkt-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-wkt-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (573,40,'ST_POLYFROMWKB','ST_PolyFromWKB(wkb[, srid [, options]]), ST_PolygonFromWKB(wkb[, srid\n[, options]])\n\nConstructs a Polygon value using its WKB representation and SRID.\n\nThese functions handle their arguments as described in the introduction\nto this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-wkb-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-wkb-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (574,28,'ST_SIMPLIFY','ST_Simplify(g, max_distance)\n\nSimplifies a geometry using the Douglas-Peucker algorithm and returns a\nsimplified value of the same type.\n\nThe geometry may be any geometry type, although the Douglas-Peucker\nalgorithm may not actually process every type. A geometry collection is\nprocessed by giving its components one by one to the simplification\nalgorithm, and the returned geometries are put into a geometry\ncollection as result.\n\nThe max_distance argument is the distance (in units of the input\ncoordinates) of a vertex to other segments to be removed. Vertices\nwithin this distance of the simplified linestring are removed.\n\nAccording to Boost.Geometry, geometries might become invalid as a\nresult of the simplification process, and the process might create\nself-intersections. To check the validity of the result, pass it to\nST_IsValid().\n\nST_Simplify() handles its arguments as described in the introduction to\nthis section, with this exception:\n\no If the max_distance argument is not positive, or is NaN, an\n  ER_WRONG_ARGUMENTS error occurs.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-convenience-functions.html\n\n','mysql> SET @g = ST_GeomFromText(\'LINESTRING(0 0,0 1,1 1,1 2,2 2,2 3,3 3)\');\nmysql> SELECT ST_AsText(ST_Simplify(@g, 0.5));\n+---------------------------------+\n| ST_AsText(ST_Simplify(@g, 0.5)) |\n+---------------------------------+\n| LINESTRING(0 0,0 1,1 1,2 3,3 3) |\n+---------------------------------+\nmysql> SELECT ST_AsText(ST_Simplify(@g, 1.0));\n+---------------------------------+\n| ST_AsText(ST_Simplify(@g, 1.0)) |\n+---------------------------------+\n| LINESTRING(0 0,3 3)             |\n+---------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/spatial-convenience-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (575,19,'ST_SRID','ST_SRID(g[, srid])\n\nWith a single argument representing a valid geometry object g,\nST_SRID() returns an integer indicating the ID of the spatial reference\nsystem (SRS) associated with g.\n\nWith the optional second argument representing a valid SRID value,\nST_SRID() returns an object with the same type as its first argument\nwith an SRID value equal to the second argument. This only sets the\nSRID value of the object; it does not perform any transformation of\ncoordinate values.\n\nST_SRID() handles its arguments as described in the introduction to\nthis section, with this exception:\n\no For the single-argument syntax, ST_SRID() returns the geometry SRID\n  even if it refers to an undefined SRS. An ER_SRS_NOT_FOUND error does\n  not occur.\n\nST_SRID(g, target_srid) and ST_Transform(g, target_srid) differ as\nfollows:\n\no ST_SRID() changes the geometry SRID value without transforming its\n  coordinates.\n\no ST_Transform() transforms the geometry coordinates in addition to\n  changing its SRID value.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-general-property-functions.html\n\n','mysql> SET @g = ST_GeomFromText(\'LineString(1 1,2 2)\', 0);\nmysql> SELECT ST_SRID(@g);\n+-------------+\n| ST_SRID(@g) |\n+-------------+\n|           0 |\n+-------------+\nmysql> SET @g = ST_SRID(@g, 4326);\nmysql> SELECT ST_SRID(@g);\n+-------------+\n| ST_SRID(@g) |\n+-------------+\n|        4326 |\n+-------------+\n','http://dev.mysql.com/doc/refman/8.0/en/gis-general-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (576,25,'ST_STARTPOINT','ST_StartPoint(ls)\n\nReturns the Point that is the start point of the LineString value ls.\n\nST_StartPoint() handles its arguments as described in the introduction\nto this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-linestring-property-functions.html\n\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT ST_AsText(ST_StartPoint(ST_GeomFromText(@ls)));\n+------------------------------------------------+\n| ST_AsText(ST_StartPoint(ST_GeomFromText(@ls))) |\n+------------------------------------------------+\n| POINT(1 1)                                     |\n+------------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/gis-linestring-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (577,40,'ST_SWAPXY','ST_SwapXY(g)\n\nAccepts an argument in internal geometry format, swaps the X and Y\nvalues of each coordinate pair within the geometry, and returns the\nresult.\n\nST_SwapXY() handles its arguments as described in the introduction to\nthis section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-format-conversion-functions.html\n\n','mysql> SET @g = ST_LineFromText(\'LINESTRING(0 5,5 10,10 15)\');\nmysql> SELECT ST_AsText(@g);\n+----------------------------+\n| ST_AsText(@g)              |\n+----------------------------+\n| LINESTRING(0 5,5 10,10 15) |\n+----------------------------+\nmysql> SELECT ST_AsText(ST_SwapXY(@g));\n+----------------------------+\n| ST_AsText(ST_SwapXY(@g))   |\n+----------------------------+\n| LINESTRING(5 0,10 5,15 10) |\n+----------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/gis-format-conversion-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (578,21,'ST_SYMDIFFERENCE','ST_SymDifference(g1, g2)\n\nReturns a geometry that represents the point set symmetric difference\nof the geometry values g1 and g2, which is defined as:\n\ng1 symdifference g2 := (g1 union g2) difference (g1 intersection g2)\n\nOr, in function call notation:\n\nST_SymDifference(g1, g2) = ST_Difference(ST_Union(g1, g2), ST_Intersection(g1, g2))\n\nST_SymDifference() handles its arguments as described in the\nintroduction to this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-operator-functions.html\n\n','mysql> SET @g1 = Point(1,1), @g2 = Point(2,2);\nmysql> SELECT ST_AsText(ST_SymDifference(@g1, @g2));\n+---------------------------------------+\n| ST_AsText(ST_SymDifference(@g1, @g2)) |\n+---------------------------------------+\n| MULTIPOINT((1 1),(2 2))               |\n+---------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/spatial-operator-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (579,20,'ST_TOUCHES','ST_Touches(g1, g2)\n\nTwo geometries spatially touch if their interiors do not intersect, but\nthe boundary of one of the geometries intersects either the boundary or\nthe interior of the other.\n\nThis function returns 1 or 0 to indicate whether g1 spatially touches\ng2.\n\nST_Touches() handles its arguments as described in the introduction to\nthis section except that the return value is NULL for the additional\ncondition that both geometries are of dimension 0 (Point or\nMultiPoint).\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-object-shapes.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-object-shapes.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (580,21,'ST_TRANSFORM','ST_Transform(g, target_srid)\n\nTransforms a geometry from one spatial reference system (SRS) to\nanother. The return value is a geometry of the same type as the input\ngeometry with all coordinates transformed to the target SRID,\ntarget_srid. Transformation support is limited to geographic SRSs,\nunless the SRID of the geometry argument is the same as the target SRID\nvalue, in which case the return value is the input geometry for any\nvalid SRS.\n\nST_Transform() handles its arguments as described in the introduction\nto this section, with these exceptions:\n\no Geometry arguments that have an SRID value for a geographic SRS do\n  not produce an error.\n\no If the geometry or target SRID argument has an SRID value that refers\n  to an undefined spatial reference system (SRS), an ER_SRS_NOT_FOUND\n  error occurs.\n\no If the geometry is in an SRS that ST_Transform() cannot transform\n  from, an ER_TRANSFORM_SOURCE_SRS_NOT_SUPPORTED error occurs.\n\no If the target SRID is in an SRS that ST_Transform() cannot transform\n  to, an ER_TRANSFORM_TARGET_SRS_NOT_SUPPORTED error occurs.\n\no If the geometry is in an SRS that is not WGS 84 and has no TOWGS84\n  clause, an ER_TRANSFORM_SOURCE_SRS_MISSING_TOWGS84 error occurs.\n\no If the target SRID is in an SRS that is not WGS 84 and has no TOWGS84\n  clause, an ER_TRANSFORM_TARGET_SRS_MISSING_TOWGS84 error occurs.\n\nST_SRID(g, target_srid) and ST_Transform(g, target_srid) differ as\nfollows:\n\no ST_SRID() changes the geometry SRID value without transforming its\n  coordinates.\n\no ST_Transform() transforms the geometry coordinates in addition to\n  changing its SRID value.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-operator-functions.html\n\n','mysql> SET @p = ST_GeomFromText(\'POINT(52.381389 13.064444)\', 4326);\nmysql> SELECT ST_AsText(@p);\n+----------------------------+\n| ST_AsText(@p)              |\n+----------------------------+\n| POINT(52.381389 13.064444) |\n+----------------------------+\nmysql> SET @p = ST_Transform(@p, 4230);\nmysql> SELECT ST_AsText(@p);\n+---------------------------------------------+\n| ST_AsText(@p)                               |\n+---------------------------------------------+\n| POINT(52.38208611407426 13.065520672345304) |\n+---------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/spatial-operator-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (581,21,'ST_UNION','ST_Union(g1, g2)\n\nReturns a geometry that represents the point set union of the geometry\nvalues g1 and g2.\n\nST_Union() handles its arguments as described in the introduction to\nthis section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-operator-functions.html\n\n','mysql> SET @g1 = ST_GeomFromText(\'LineString(1 1, 3 3)\');\nmysql> SET @g2 = ST_GeomFromText(\'LineString(1 3, 3 1)\');\nmysql> SELECT ST_AsText(ST_Union(@g1, @g2));\n+--------------------------------------+\n| ST_AsText(ST_Union(@g1, @g2))        |\n+--------------------------------------+\n| MULTILINESTRING((1 1,3 3),(1 3,3 1)) |\n+--------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/spatial-operator-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (582,28,'ST_VALIDATE','ST_Validate(g)\n\nValidates a geometry according to the OGC specification. A geometry can\nbe syntactically well-formed (WKB value plus SRID) but geometrically\ninvalid. For example, this polygon is geometrically invalid: POLYGON((0\n0, 0 0, 0 0, 0 0, 0 0))\n\nST_Validate() returns the geometry if it is syntactically well-formed\nand is geometrically valid, NULL if the argument is not syntactically\nwell-formed or is not geometrically valid or is NULL.\n\nST_Validate() can be used to filter out invalid geometry data, although\nat a cost. For applications that require more precise results not\ntainted by invalid data, this penalty may be worthwhile.\n\nIf the geometry argument is valid, it is returned as is, except that if\nan input Polygon or MultiPolygon has clockwise rings, those rings are\nreversed before checking for validity. If the geometry is valid, the\nvalue with the reversed rings is returned.\n\nThe only valid empty geometry is represented in the form of an empty\ngeometry collection value. ST_Validate() returns it directly without\nfurther checks in this case.\n\nAs of MySQL 8.0.13, ST_Validate() handles its arguments as described in\nthe introduction to this section, with these exceptions:\n\no If the geometry has a geographic SRS with a longitude or latitude\n  that is out of range, an error occurs:\n\n  o If any longitude argument is not in the range (−180, 180], an\n    ER_LONGITUDE_OUT_OF_RANGE error occurs.\n\n  o If any latitude argument is not in the range [−90, 90], an\n    ER_LATITUDE_OUT_OF_RANGE error occurs.\n\n  Ranges shown are in degrees. The exact range limits deviate slightly\n  due to floating-point arithmetic.\n\nPrior to MySQL 8.0.13, ST_Validate() handles its arguments as described\nin the introduction to this section, with these exceptions:\n\no If the geometry is not syntactically well-formed, the return value is\n  NULL. An ER_GIS_INVALID_DATA error does not occur.\n\no If the geometry has an SRID value for a geographic spatial reference\n  system (SRS), an ER_NOT_IMPLEMENTED_FOR_GEOGRAPHIC_SRS error occurs.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-convenience-functions.html\n\n','mysql> SET @ls1 = ST_GeomFromText(\'LINESTRING(0 0)\');\nmysql> SET @ls2 = ST_GeomFromText(\'LINESTRING(0 0, 1 1)\');\nmysql> SELECT ST_AsText(ST_Validate(@ls1));\n+------------------------------+\n| ST_AsText(ST_Validate(@ls1)) |\n+------------------------------+\n| NULL                         |\n+------------------------------+\nmysql> SELECT ST_AsText(ST_Validate(@ls2));\n+------------------------------+\n| ST_AsText(ST_Validate(@ls2)) |\n+------------------------------+\n| LINESTRING(0 0,1 1)          |\n+------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/spatial-convenience-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (583,20,'ST_WITHIN','ST_Within(g1, g2)\n\nReturns 1 or 0 to indicate whether g1 is spatially within g2. This\ntests the opposite relationship as ST_Contains().\n\nST_Within() handles its arguments as described in the introduction to\nthis section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-object-shapes.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/spatial-relation-functions-object-shapes.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (584,32,'ST_X','ST_X(p[, new_x_val])\n\nWith a single argument representing a valid Point object p, ST_X()\nreturns the X-coordinate value of p as a double-precision number. As of\nMySQL 8.0.12, the X coordinate is considered to refer to the axis that\nappears first in the Point spatial reference system (SRS) definition.\n\nWith the optional second argument, ST_X() returns a Point object like\nthe first argument with its X coordinate equal to the second argument.\nAs of MySQL 8.0.12, if the Point object has a geographic SRS, the\nsecond argument must be in the proper range for longitude or latitude\nvalues.\n\nST_X() handles its arguments as described in the introduction to this\nsection.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-point-property-functions.html\n\n','mysql> SELECT ST_X(Point(56.7, 53.34));\n+--------------------------+\n| ST_X(Point(56.7, 53.34)) |\n+--------------------------+\n|                     56.7 |\n+--------------------------+\nmysql> SELECT ST_AsText(ST_X(Point(56.7, 53.34), 10.5));\n+-------------------------------------------+\n| ST_AsText(ST_X(Point(56.7, 53.34), 10.5)) |\n+-------------------------------------------+\n| POINT(10.5 53.34)                         |\n+-------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/gis-point-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (585,32,'ST_Y','ST_Y(p[, new_y_val])\n\nWith a single argument representing a valid Point object p, ST_Y()\nreturns the Y-coordinate value of p as a double-precision number. As of\nMySQL 8.0.12, the Y coordinate is considered to refer to the axis that\nappears second in the Point spatial reference system (SRS) definition.\n\nWith the optional second argument, ST_Y() returns a Point object like\nthe first argument with its Y coordinate equal to the second argument.\nAs of MySQL 8.0.12, if the Point object has a geographic SRS, the\nsecond argument must be in the proper range for longitude or latitude\nvalues.\n\nST_Y() handles its arguments as described in the introduction to this\nsection.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-point-property-functions.html\n\n','mysql> SELECT ST_Y(Point(56.7, 53.34));\n+--------------------------+\n| ST_Y(Point(56.7, 53.34)) |\n+--------------------------+\n|                    53.34 |\n+--------------------------+\nmysql> SELECT ST_AsText(ST_Y(Point(56.7, 53.34), 10.5));\n+-------------------------------------------+\n| ST_AsText(ST_Y(Point(56.7, 53.34), 10.5)) |\n+-------------------------------------------+\n| POINT(56.7 10.5)                          |\n+-------------------------------------------+\n','http://dev.mysql.com/doc/refman/8.0/en/gis-point-property-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (586,12,'SUBDATE','Syntax:\nSUBDATE(date,INTERVAL expr unit), SUBDATE(expr,days)\n\nWhen invoked with the INTERVAL form of the second argument, SUBDATE()\nis a synonym for DATE_SUB(). For information on the INTERVAL unit\nargument, see the discussion for DATE_ADD().\n\nmysql> SELECT DATE_SUB(\'2008-01-02\', INTERVAL 31 DAY);\n        -> \'2007-12-02\'\nmysql> SELECT SUBDATE(\'2008-01-02\', INTERVAL 31 DAY);\n        -> \'2007-12-02\'\n\nThe second form enables the use of an integer value for days. In such\ncases, it is interpreted as the number of days to be subtracted from\nthe date or datetime expression expr.\n\nmysql> SELECT SUBDATE(\'2008-01-02 12:00:00\', 31);\n        -> \'2007-12-02 12:00:00\'\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (587,35,'SUBSTR','Syntax:\nSUBSTR(str,pos), SUBSTR(str FROM pos), SUBSTR(str,pos,len), SUBSTR(str\nFROM pos FOR len)\n\nSUBSTR() is a synonym for SUBSTRING().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (588,35,'SUBSTRING','Syntax:\nSUBSTRING(str,pos), SUBSTRING(str FROM pos), SUBSTRING(str,pos,len),\nSUBSTRING(str FROM pos FOR len)\n\nThe forms without a len argument return a substring from string str\nstarting at position pos. The forms with a len argument return a\nsubstring len characters long from string str, starting at position\npos. The forms that use FROM are standard SQL syntax. It is also\npossible to use a negative value for pos. In this case, the beginning\nof the substring is pos characters from the end of the string, rather\nthan the beginning. A negative value may be used for pos in any of the\nforms of this function.\n\nFor all forms of SUBSTRING(), the position of the first character in\nthe string from which the substring is to be extracted is reckoned as\n1.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT SUBSTRING(\'Quadratically\',5);\n        -> \'ratically\'\nmysql> SELECT SUBSTRING(\'foobarbar\' FROM 4);\n        -> \'barbar\'\nmysql> SELECT SUBSTRING(\'Quadratically\',5,6);\n        -> \'ratica\'\nmysql> SELECT SUBSTRING(\'Sakila\', -3);\n        -> \'ila\'\nmysql> SELECT SUBSTRING(\'Sakila\', -5, 3);\n        -> \'aki\'\nmysql> SELECT SUBSTRING(\'Sakila\' FROM -4 FOR 2);\n        -> \'ki\'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (589,35,'SUBSTRING_INDEX','Syntax:\nSUBSTRING_INDEX(str,delim,count)\n\nReturns the substring from string str before count occurrences of the\ndelimiter delim. If count is positive, everything to the left of the\nfinal delimiter (counting from the left) is returned. If count is\nnegative, everything to the right of the final delimiter (counting from\nthe right) is returned. SUBSTRING_INDEX() performs a case-sensitive\nmatch when searching for delim.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT SUBSTRING_INDEX(\'www.mysql.com\', \'.\', 2);\n        -> \'www.mysql\'\nmysql> SELECT SUBSTRING_INDEX(\'www.mysql.com\', \'.\', -2);\n        -> \'mysql.com\'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (590,12,'SUBTIME','Syntax:\nSUBTIME(expr1,expr2)\n\nSUBTIME() returns expr1 − expr2 expressed as a value in the same\nformat as expr1. expr1 is a time or datetime expression, and expr2 is a\ntime expression.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT SUBTIME(\'2007-12-31 23:59:59.999999\',\'1 1:1:1.000002\');\n        -> \'2007-12-30 22:58:58.999997\'\nmysql> SELECT SUBTIME(\'01:00:00.999999\', \'02:00:00.999998\');\n        -> \'-00:59:59.999999\'\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (591,15,'SUM','Syntax:\nSUM([DISTINCT] expr) [over_clause]\n\nReturns the sum of expr. If the return set has no rows, SUM() returns\nNULL. The DISTINCT keyword can be used to sum only the distinct values\nof expr.\n\nIf there are no matching rows, SUM() returns NULL.\n\nThis function executes as a window function if over_clause is present.\nover_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html; it\ncannot be used with DISTINCT.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (592,12,'SYSDATE','Syntax:\nSYSDATE([fsp])\n\nReturns the current date and time as a value in \'YYYY-MM-DD HH:MM:SS\'\nor YYYYMMDDHHMMSS format, depending on whether the function is used in\na string or numeric context.\n\nIf the fsp argument is given to specify a fractional seconds precision\nfrom 0 to 6, the return value includes a fractional seconds part of\nthat many digits.\n\nSYSDATE() returns the time at which it executes. This differs from the\nbehavior for NOW(), which returns a constant time that indicates the\ntime at which the statement began to execute. (Within a stored function\nor trigger, NOW() returns the time at which the function or triggering\nstatement began to execute.)\n\nmysql> SELECT NOW(), SLEEP(2), NOW();\n+---------------------+----------+---------------------+\n| NOW()               | SLEEP(2) | NOW()               |\n+---------------------+----------+---------------------+\n| 2006-04-12 13:47:36 |        0 | 2006-04-12 13:47:36 |\n+---------------------+----------+---------------------+\n\nmysql> SELECT SYSDATE(), SLEEP(2), SYSDATE();\n+---------------------+----------+---------------------+\n| SYSDATE()           | SLEEP(2) | SYSDATE()           |\n+---------------------+----------+---------------------+\n| 2006-04-12 13:47:44 |        0 | 2006-04-12 13:47:46 |\n+---------------------+----------+---------------------+\n\nIn addition, the SET TIMESTAMP statement affects the value returned by\nNOW() but not by SYSDATE(). This means that timestamp settings in the\nbinary log have no effect on invocations of SYSDATE().\n\nBecause SYSDATE() can return different values even within the same\nstatement, and is not affected by SET TIMESTAMP, it is nondeterministic\nand therefore unsafe for replication if statement-based binary logging\nis used. If that is a problem, you can use row-based logging.\n\nAlternatively, you can use the --sysdate-is-now option to cause\nSYSDATE() to be an alias for NOW(). This works if the option is used on\nboth the master and the slave.\n\nThe nondeterministic nature of SYSDATE() also means that indexes cannot\nbe used for evaluating expressions that refer to it.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (593,23,'SYSTEM_USER','Syntax:\nSYSTEM_USER()\n\nSYSTEM_USER() is a synonym for USER().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/information-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (594,30,'TAN','Syntax:\nTAN(X)\n\nReturns the tangent of X, where X is given in radians.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT TAN(PI());\n        -> -1.2246063538224e-16\nmysql> SELECT TAN(PI()+1);\n        -> 1.5574077246549\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (595,11,'TEXT','TEXT[(M)] [CHARACTER SET charset_name] [COLLATE collation_name]\n\nA TEXT column with a maximum length of 65,535 (216 − 1) characters.\nThe effective maximum length is less if the value contains multibyte\ncharacters. Each TEXT value is stored using a 2-byte length prefix that\nindicates the number of bytes in the value.\n\nAn optional length M can be given for this type. If this is done, MySQL\ncreates the column as the smallest TEXT type large enough to hold\nvalues M characters long.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (596,11,'TIME','TIME[(fsp)]\n\nA time. The range is \'-838:59:59.000000\' to \'838:59:59.000000\'. MySQL\ndisplays TIME values in \'HH:MM:SS[.fraction]\' format, but permits\nassignment of values to TIME columns using either strings or numbers.\n\nAn optional fsp value in the range from 0 to 6 may be given to specify\nfractional seconds precision. A value of 0 signifies that there is no\nfractional part. If omitted, the default precision is 0.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (597,12,'TIME FUNCTION','Syntax:\nTIME(expr)\n\nExtracts the time part of the time or datetime expression expr and\nreturns it as a string.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT TIME(\'2003-12-31 01:02:03\');\n        -> \'01:02:03\'\nmysql> SELECT TIME(\'2003-12-31 01:02:03.000123\');\n        -> \'01:02:03.000123\'\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (598,12,'TIMEDIFF','Syntax:\nTIMEDIFF(expr1,expr2)\n\nTIMEDIFF() returns expr1 − expr2 expressed as a time value. expr1 and\nexpr2 are time or date-and-time expressions, but both must be of the\nsame type.\n\nThe result returned by TIMEDIFF() is limited to the range allowed for\nTIME values. Alternatively, you can use either of the functions\nTIMESTAMPDIFF() and UNIX_TIMESTAMP(), both of which return integers.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT TIMEDIFF(\'2000:01:01 00:00:00\',\n    ->                 \'2000:01:01 00:00:00.000001\');\n        -> \'-00:00:00.000001\'\nmysql> SELECT TIMEDIFF(\'2008-12-31 23:59:59.000001\',\n    ->                 \'2008-12-30 01:01:01.000002\');\n        -> \'46:58:57.999999\'\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (599,11,'TIMESTAMP','TIMESTAMP[(fsp)]\n\nA timestamp. The range is \'1970-01-01 00:00:01.000000\' UTC to\n\'2038-01-19 03:14:07.999999\' UTC. TIMESTAMP values are stored as the\nnumber of seconds since the epoch (\'1970-01-01 00:00:00\' UTC). A\nTIMESTAMP cannot represent the value \'1970-01-01 00:00:00\' because that\nis equivalent to 0 seconds from the epoch and the value 0 is reserved\nfor representing \'0000-00-00 00:00:00\', the "zero" TIMESTAMP value.\n\nAn optional fsp value in the range from 0 to 6 may be given to specify\nfractional seconds precision. A value of 0 signifies that there is no\nfractional part. If omitted, the default precision is 0.\n\nThe way the server handles TIMESTAMP definitions depends on the value\nof the explicit_defaults_for_timestamp system variable (see\nhttp://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html).\n\nIf explicit_defaults_for_timestamp is enabled, there is no automatic\nassignment of the DEFAULT CURRENT_TIMESTAMP or ON UPDATE\nCURRENT_TIMESTAMP attributes to any TIMESTAMP column. They must be\nincluded explicitly in the column definition. Also, any TIMESTAMP not\nexplicitly declared as NOT NULL permits NULL values.\n\nIf explicit_defaults_for_timestamp is disabled, the server handles\nTIMESTAMP as follows:\n\nUnless specified otherwise, the first TIMESTAMP column in a table is\ndefined to be automatically set to the date and time of the most recent\nmodification if not explicitly assigned a value. This makes TIMESTAMP\nuseful for recording the timestamp of an INSERT or UPDATE operation.\nYou can also set any TIMESTAMP column to the current date and time by\nassigning it a NULL value, unless it has been defined with the NULL\nattribute to permit NULL values.\n\nAutomatic initialization and updating to the current date and time can\nbe specified using DEFAULT CURRENT_TIMESTAMP and ON UPDATE\nCURRENT_TIMESTAMP column definition clauses. By default, the first\nTIMESTAMP column has these properties, as previously noted. However,\nany TIMESTAMP column in a table can be defined to have these\nproperties.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (600,12,'TIMESTAMP FUNCTION','Syntax:\nTIMESTAMP(expr), TIMESTAMP(expr1,expr2)\n\nWith a single argument, this function returns the date or datetime\nexpression expr as a datetime value. With two arguments, it adds the\ntime expression expr2 to the date or datetime expression expr1 and\nreturns the result as a datetime value.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT TIMESTAMP(\'2003-12-31\');\n        -> \'2003-12-31 00:00:00\'\nmysql> SELECT TIMESTAMP(\'2003-12-31 12:00:00\',\'12:00:00\');\n        -> \'2004-01-01 00:00:00\'\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (601,12,'TIMESTAMPADD','Syntax:\nTIMESTAMPADD(unit,interval,datetime_expr)\n\nAdds the integer expression interval to the date or datetime expression\ndatetime_expr. The unit for interval is given by the unit argument,\nwhich should be one of the following values: MICROSECOND\n(microseconds), SECOND, MINUTE, HOUR, DAY, WEEK, MONTH, QUARTER, or\nYEAR.\n\nThe unit value may be specified using one of keywords as shown, or with\na prefix of SQL_TSI_. For example, DAY and SQL_TSI_DAY both are legal.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT TIMESTAMPADD(MINUTE,1,\'2003-01-02\');\n        -> \'2003-01-02 00:01:00\'\nmysql> SELECT TIMESTAMPADD(WEEK,1,\'2003-01-02\');\n        -> \'2003-01-09\'\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (602,12,'TIMESTAMPDIFF','Syntax:\nTIMESTAMPDIFF(unit,datetime_expr1,datetime_expr2)\n\nReturns datetime_expr2 − datetime_expr1, where datetime_expr1 and\ndatetime_expr2 are date or datetime expressions. One expression may be\na date and the other a datetime; a date value is treated as a datetime\nhaving the time part \'00:00:00\' where necessary. The unit for the\nresult (an integer) is given by the unit argument. The legal values for\nunit are the same as those listed in the description of the\nTIMESTAMPADD() function.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT TIMESTAMPDIFF(MONTH,\'2003-02-01\',\'2003-05-01\');\n        -> 3\nmysql> SELECT TIMESTAMPDIFF(YEAR,\'2002-05-01\',\'2001-01-01\');\n        -> -1\nmysql> SELECT TIMESTAMPDIFF(MINUTE,\'2003-02-01\',\'2003-05-01 12:05:55\');\n        -> 128885\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (603,12,'TIME_FORMAT','Syntax:\nTIME_FORMAT(time,format)\n\nThis is used like the DATE_FORMAT() function, but the format string may\ncontain format specifiers only for hours, minutes, seconds, and\nmicroseconds. Other specifiers produce a NULL value or 0.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT TIME_FORMAT(\'100:00:00\', \'%H %k %h %I %l\');\n        -> \'100 100 04 04 4\'\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (604,12,'TIME_TO_SEC','Syntax:\nTIME_TO_SEC(time)\n\nReturns the time argument, converted to seconds.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT TIME_TO_SEC(\'22:23:00\');\n        -> 80580\nmysql> SELECT TIME_TO_SEC(\'00:39:38\');\n        -> 2378\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (605,11,'TINYBLOB','TINYBLOB\n\nA BLOB column with a maximum length of 255 (28 − 1) bytes. Each\nTINYBLOB value is stored using a 1-byte length prefix that indicates\nthe number of bytes in the value.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (606,11,'TINYINT','TINYINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA very small integer. The signed range is -128 to 127. The unsigned\nrange is 0 to 255.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/numeric-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (607,11,'TINYTEXT','TINYTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nA TEXT column with a maximum length of 255 (28 − 1) characters. The\neffective maximum length is less if the value contains multibyte\ncharacters. Each TINYTEXT value is stored using a 1-byte length prefix\nthat indicates the number of bytes in the value.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (608,35,'TO_BASE64','Syntax:\nTO_BASE64(str)\n\nConverts the string argument to base-64 encoded form and returns the\nresult as a character string with the connection character set and\ncollation. If the argument is not a string, it is converted to a string\nbefore conversion takes place. The result is NULL if the argument is\nNULL. Base-64 encoded strings can be decoded using the FROM_BASE64()\nfunction.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT TO_BASE64(\'abc\'), FROM_BASE64(TO_BASE64(\'abc\'));\n        -> \'JWJj\', \'abc\'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (609,12,'TO_DAYS','Syntax:\nTO_DAYS(date)\n\nGiven a date date, returns a day number (the number of days since year\n0).\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT TO_DAYS(950501);\n        -> 728779\nmysql> SELECT TO_DAYS(\'2007-10-07\');\n        -> 733321\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (610,12,'TO_SECONDS','Syntax:\nTO_SECONDS(expr)\n\nGiven a date or datetime expr, returns the number of seconds since the\nyear 0. If expr is not a valid date or datetime value, returns NULL.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT TO_SECONDS(950501);\n        -> 62966505600\nmysql> SELECT TO_SECONDS(\'2009-11-29\');\n        -> 63426672000\nmysql> SELECT TO_SECONDS(\'2009-11-29 13:43:32\');\n        -> 63426721412\nmysql> SELECT TO_SECONDS( NOW() );\n        -> 63426721458\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (611,35,'TRIM','Syntax:\nTRIM([{BOTH | LEADING | TRAILING} [remstr] FROM] str), TRIM([remstr\nFROM] str)\n\nReturns the string str with all remstr prefixes or suffixes removed. If\nnone of the specifiers BOTH, LEADING, or TRAILING is given, BOTH is\nassumed. remstr is optional and, if not specified, spaces are removed.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT TRIM(\'  bar   \');\n        -> \'bar\'\nmysql> SELECT TRIM(LEADING \'x\' FROM \'xxxbarxxx\');\n        -> \'barxxx\'\nmysql> SELECT TRIM(BOTH \'x\' FROM \'xxxbarxxx\');\n        -> \'bar\'\nmysql> SELECT TRIM(TRAILING \'xyz\' FROM \'barxxyz\');\n        -> \'barx\'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (612,24,'TRUE FALSE','The constants TRUE and FALSE evaluate to 1 and 0, respectively. The\nconstant names can be written in any lettercase.\n\nmysql> SELECT TRUE, true, FALSE, false;\n        -> 1, 1, 0, 0\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/boolean-literals.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/boolean-literals.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (613,30,'TRUNCATE','Syntax:\nTRUNCATE(X,D)\n\nReturns the number X, truncated to D decimal places. If D is 0, the\nresult has no decimal point or fractional part. D can be negative to\ncause D digits left of the decimal point of the value X to become zero.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html\n\n','mysql> SELECT TRUNCATE(1.223,1);\n        -> 1.2\nmysql> SELECT TRUNCATE(1.999,1);\n        -> 1.9\nmysql> SELECT TRUNCATE(1.999,0);\n        -> 1\nmysql> SELECT TRUNCATE(-1.999,1);\n        -> -1.9\nmysql> SELECT TRUNCATE(122,-2);\n       -> 100\nmysql> SELECT TRUNCATE(10.28*100,0);\n       -> 1028\n','http://dev.mysql.com/doc/refman/8.0/en/mathematical-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (614,9,'TRUNCATE TABLE','Syntax:\nTRUNCATE [TABLE] tbl_name\n\nTRUNCATE TABLE empties a table completely. It requires the DROP\nprivilege. Logically, TRUNCATE TABLE is similar to a DELETE statement\nthat deletes all rows, or a sequence of DROP TABLE and CREATE TABLE\nstatements.\n\nTo achieve high performance, TRUNCATE TABLE bypasses the DML method of\ndeleting data. Thus, it does not cause ON DELETE triggers to fire, it\ncannot be performed for InnoDB tables with parent-child foreign key\nrelationships, and it cannot be rolled back like a DML operation.\nHowever, TRUNCATE TABLE operations on tables that use an atomic\nDDL-supported storage engine are either fully committed or rolled back\nif the server halts during their operation. For more information, see\nhttp://dev.mysql.com/doc/refman/8.0/en/atomic-ddl.html.\n\nAlthough TRUNCATE TABLE is similar to DELETE, it is classified as a DDL\nstatement rather than a DML statement. It differs from DELETE in the\nfollowing ways:\n\no Truncate operations drop and re-create the table, which is much\n  faster than deleting rows one by one, particularly for large tables.\n\no Truncate operations cause an implicit commit, and so cannot be rolled\n  back. See\n  http://dev.mysql.com/doc/refman/8.0/en/implicit-commit.html.\n\no Truncation operations cannot be performed if the session holds an\n  active table lock.\n\no TRUNCATE TABLE fails for an InnoDB table or NDB table if there are\n  any FOREIGN KEY constraints from other tables that reference the\n  table. Foreign key constraints between columns of the same table are\n  permitted.\n\no Truncation operations do not return a meaningful value for the number\n  of deleted rows. The usual result is "0 rows affected," which should\n  be interpreted as "no information."\n\no As long as the table definition is valid, the table can be re-created\n  as an empty table with TRUNCATE TABLE, even if the data or index\n  files have become corrupted.\n\no Any AUTO_INCREMENT value is reset to its start value. This is true\n  even for MyISAM and InnoDB, which normally do not reuse sequence\n  values.\n\no When used with partitioned tables, TRUNCATE TABLE preserves the\n  partitioning; that is, the data and index files are dropped and\n  re-created, while the partition definitions are unaffected.\n\no The TRUNCATE TABLE statement does not invoke ON DELETE triggers.\n\no Truncating a corrupted InnoDB table is supported.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/truncate-table.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/truncate-table.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (615,35,'UCASE','Syntax:\nUCASE(str)\n\nUCASE() is a synonym for UPPER().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (616,13,'UNCOMPRESS','Syntax:\nUNCOMPRESS(string_to_uncompress)\n\nUncompresses a string compressed by the COMPRESS() function. If the\nargument is not a compressed value, the result is NULL. This function\nrequires MySQL to have been compiled with a compression library such as\nzlib. Otherwise, the return value is always NULL.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html\n\n','mysql> SELECT UNCOMPRESS(COMPRESS(\'any string\'));\n        -> \'any string\'\nmysql> SELECT UNCOMPRESS(\'any string\');\n        -> NULL\n','http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (617,13,'UNCOMPRESSED_LENGTH','Syntax:\nUNCOMPRESSED_LENGTH(compressed_string)\n\nReturns the length that the compressed string had before being\ncompressed.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html\n\n','mysql> SELECT UNCOMPRESSED_LENGTH(COMPRESS(REPEAT(\'a\',30)));\n        -> 30\n','http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (618,35,'UNHEX','Syntax:\n\nUNHEX(str)\n\nFor a string argument str, UNHEX(str) interprets each pair of\ncharacters in the argument as a hexadecimal number and converts it to\nthe byte represented by the number. The return value is a binary\nstring.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','mysql> SELECT UNHEX(\'4D7953514C\');\n        -> \'MySQL\'\nmysql> SELECT X\'4D7953514C\';\n        -> \'MySQL\'\nmysql> SELECT UNHEX(HEX(\'string\'));\n        -> \'string\'\nmysql> SELECT HEX(UNHEX(\'1267\'));\n        -> \'1267\'\n','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (619,5,'UNINSTALL COMPONENT','Syntax:\nUNINSTALL COMPONENT component_name [, component_name ] ...\n\nThis statement deactivates and uninstalls one or more server\ncomponents. A component provides services that are available to the\nserver and other components; see\nhttp://dev.mysql.com/doc/refman/8.0/en/server-components.html.\nUNINSTALL COMPONENT is the complement of INSTALL COMPONENT. It requires\nthe DELETE privilege for the mysql.component system table.\n\nExample:\n\nUNINSTALL COMPONENT \'file://component1\', \'file://component2\';\n\nFor information about component naming, see [HELP INSTALL COMPONENT].\n\nIf any error occurs, the statement fails and has no effect. For\nexample, this happens if a component name is erroneous, a named\ncomponent is not installed, or cannot be uninstalled because other\ninstalled components depend on it.\n\nA loader service handles component unloading, which includes removing\nuninstalled components from the mysql.component system table that\nserves as a registry. As a result, unloaded components are not loaded\nduring the startup sequence for subsequent server restarts.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/uninstall-component.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/uninstall-component.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (620,5,'UNINSTALL PLUGIN','Syntax:\nUNINSTALL PLUGIN plugin_name\n\nThis statement removes an installed server plugin. It requires the\nDELETE privilege for the mysql.plugin system table. UNINSTALL PLUGIN is\nthe complement of INSTALL PLUGIN.\n\nplugin_name must be the name of some plugin that is listed in the\nmysql.plugin table. The server executes the plugin\'s deinitialization\nfunction and removes the row for the plugin from the mysql.plugin\nsystem table, so that subsequent server restarts will not load and\ninitialize the plugin. UNINSTALL PLUGIN does not remove the plugin\'s\nshared library file.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/uninstall-plugin.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/uninstall-plugin.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (621,10,'UNION','Syntax:\nSELECT ...\nUNION [ALL | DISTINCT] SELECT ...\n[UNION [ALL | DISTINCT] SELECT ...]\n\nUNION is used to combine the result from multiple SELECT statements\ninto a single result set.\n\nThe column names from the first SELECT statement are used as the column\nnames for the results returned. Selected columns listed in\ncorresponding positions of each SELECT statement should have the same\ndata type. (For example, the first column selected by the first\nstatement should have the same type as the first column selected by the\nother statements.)\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/union.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/union.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (622,12,'UNIX_TIMESTAMP','Syntax:\nUNIX_TIMESTAMP(), UNIX_TIMESTAMP(date)\n\nIf called with no argument, returns a Unix timestamp (seconds since\n\'1970-01-01 00:00:00\' UTC). The return value is an integer if no\nargument is given or the argument does not include a fractional seconds\npart, or DECIMAL if an argument is given that includes a fractional\nseconds part.\n\nIf UNIX_TIMESTAMP() is called with a date argument, it returns the\nvalue of the argument as seconds since \'1970-01-01 00:00:00\' UTC. The\ndate argument may be a DATE, DATETIME, or TIMESTAMP string, or a number\nin YYMMDD, YYMMDDHHMMSS, YYYYMMDD, or YYYYMMDDHHMMSS format. If the\nargument includes a time part, it may optionally include a fractional\nseconds part. The server interprets date as a value in the current time\nzone and converts it to an internal value in UTC. Clients can set their\ntime zone as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/time-zone-support.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT UNIX_TIMESTAMP();\n        -> 1447431666\nmysql> SELECT UNIX_TIMESTAMP(\'2015-11-13 10:20:19\');\n        -> 1447431619\nmysql> SELECT UNIX_TIMESTAMP(\'2015-11-13 10:20:19.012\');\n        -> 1447431619.012\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (623,10,'UPDATE','Syntax:\nUPDATE is a DML statement that modifies rows in a table.\n\nAn UPDATE statement can start with a WITH clause to define common table\nexpressions accessible within the UPDATE. See\nhttp://dev.mysql.com/doc/refman/8.0/en/with.html.\n\nSingle-table syntax:\n\nUPDATE [LOW_PRIORITY] [IGNORE] table_reference\n    SET assignment_list\n    [WHERE where_condition]\n    [ORDER BY ...]\n    [LIMIT row_count]\n\nvalue:\n    {expr | DEFAULT}\n\nassignment:\n    col_name = value\n\nassignment_list:\n    assignment [, assignment] ...\n\nMultiple-table syntax:\n\nUPDATE [LOW_PRIORITY] [IGNORE] table_references\n    SET assignment_list\n    [WHERE where_condition]\n\nFor the single-table syntax, the UPDATE statement updates columns of\nexisting rows in the named table with new values. The SET clause\nindicates which columns to modify and the values they should be given.\nEach value can be given as an expression, or the keyword DEFAULT to set\na column explicitly to its default value. The WHERE clause, if given,\nspecifies the conditions that identify which rows to update. With no\nWHERE clause, all rows are updated. If the ORDER BY clause is\nspecified, the rows are updated in the order that is specified. The\nLIMIT clause places a limit on the number of rows that can be updated.\n\nFor the multiple-table syntax, UPDATE updates rows in each table named\nin table_references that satisfy the conditions. Each matching row is\nupdated once, even if it matches the conditions multiple times. For\nmultiple-table syntax, ORDER BY and LIMIT cannot be used.\n\nFor partitioned tables, both the single-single and multiple-table forms\nof this statement support the use of a PARTITION option as part of a\ntable reference. This option takes a list of one or more partitions or\nsubpartitions (or both). Only the partitions (or subpartitions) listed\nare checked for matches, and a row that is not in any of these\npartitions or subpartitions is not updated, whether it satisfies the\nwhere_condition or not.\n\n*Note*:\n\nUnlike the case when using PARTITION with an INSERT or REPLACE\nstatement, an otherwise valid UPDATE ... PARTITION statement is\nconsidered successful even if no rows in the listed partitions (or\nsubpartitions) match the where_condition.\n\nFor more information and examples, see\nhttp://dev.mysql.com/doc/refman/8.0/en/partitioning-selection.html.\n\nwhere_condition is an expression that evaluates to true for each row to\nbe updated. For expression syntax, see\nhttp://dev.mysql.com/doc/refman/8.0/en/expressions.html.\n\ntable_references and where_condition are specified as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/select.html.\n\nYou need the UPDATE privilege only for columns referenced in an UPDATE\nthat are actually updated. You need only the SELECT privilege for any\ncolumns that are read but not modified.\n\nThe UPDATE statement supports the following modifiers:\n\no With the LOW_PRIORITY modifier, execution of the UPDATE is delayed\n  until no other clients are reading from the table. This affects only\n  storage engines that use only table-level locking (such as MyISAM,\n  MEMORY, and MERGE).\n\no With the IGNORE modifier, the update statement does not abort even if\n  errors occur during the update. Rows for which duplicate-key\n  conflicts occur on a unique key value are not updated. Rows updated\n  to values that would cause data conversion errors are updated to the\n  closest valid values instead. For more information, see\n  http://dev.mysql.com/doc/refman/8.0/en/sql-mode.html#ignore-strict-co\n  mparison.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/update.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/update.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (624,35,'UPDATEXML','Syntax:\nUpdateXML(xml_target, xpath_expr, new_xml)\n\nThis function replaces a single portion of a given fragment of XML\nmarkup xml_target with a new XML fragment new_xml, and then returns the\nchanged XML. The portion of xml_target that is replaced matches an\nXPath expression xpath_expr supplied by the user.\n\nIf no expression matching xpath_expr is found, or if multiple matches\nare found, the function returns the original xml_target XML fragment.\nAll three arguments should be strings.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/xml-functions.html\n\n','mysql> SELECT\n    ->   UpdateXML(\'<a><b>ccc</b><d></d></a>\', \'/a\', \'<e>fff</e>\') AS val1,\n    ->   UpdateXML(\'<a><b>ccc</b><d></d></a>\', \'/b\', \'<e>fff</e>\') AS val2,\n    ->   UpdateXML(\'<a><b>ccc</b><d></d></a>\', \'//b\', \'<e>fff</e>\') AS val3,\n    ->   UpdateXML(\'<a><b>ccc</b><d></d></a>\', \'/a/d\', \'<e>fff</e>\') AS val4,\n    ->   UpdateXML(\'<a><d></d><b>ccc</b><d></d></a>\', \'/a/d\', \'<e>fff</e>\') AS val5\n    -> \\G\n\n*************************** 1. row ***************************\nval1: <e>fff</e>\nval2: <a><b>ccc</b><d></d></a>\nval3: <a><e>fff</e><d></d></a>\nval4: <a><b>ccc</b><e>fff</e></a>\nval5: <a><d></d><b>ccc</b><d></d></a>\n','http://dev.mysql.com/doc/refman/8.0/en/xml-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (625,35,'UPPER','Syntax:\nUPPER(str)\n\nReturns the string str with all characters changed to uppercase\naccording to the current character set mapping. The default is utf8mb4.\n\nmysql> SELECT UPPER(\'Hej\');\n        -> \'HEJ\'\n\nSee the description of LOWER() for information that also applies to\nUPPER(). This included information about how to perform lettercase\nconversion of binary strings (BINARY, VARBINARY, BLOB) for which these\nfunctions are ineffective, and information about case folding for\nUnicode character sets.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (626,39,'USE','Syntax:\nUSE db_name\n\nThe USE db_name statement tells MySQL to use the db_name database as\nthe default (current) database for subsequent statements. The database\nremains the default until the end of the session or another USE\nstatement is issued:\n\nUSE db1;\nSELECT COUNT(*) FROM mytable;   # selects from db1.mytable\nUSE db2;\nSELECT COUNT(*) FROM mytable;   # selects from db2.mytable\n\nThe database name must be specified on a single line. Newlines in\ndatabase names are not supported.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/use.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/use.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (627,23,'USER','Syntax:\nUSER()\n\nReturns the current MySQL user name and host name as a string in the\nutf8 character set.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/information-functions.html\n\n','mysql> SELECT USER();\n        -> \'davida@localhost\'\n','http://dev.mysql.com/doc/refman/8.0/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (628,12,'UTC_DATE','Syntax:\nUTC_DATE, UTC_DATE()\n\nReturns the current UTC date as a value in \'YYYY-MM-DD\' or YYYYMMDD\nformat, depending on whether the function is used in a string or\nnumeric context.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT UTC_DATE(), UTC_DATE() + 0;\n        -> \'2003-08-14\', 20030814\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (629,12,'UTC_TIME','Syntax:\nUTC_TIME, UTC_TIME([fsp])\n\nReturns the current UTC time as a value in \'HH:MM:SS\' or HHMMSS format,\ndepending on whether the function is used in a string or numeric\ncontext.\n\nIf the fsp argument is given to specify a fractional seconds precision\nfrom 0 to 6, the return value includes a fractional seconds part of\nthat many digits.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT UTC_TIME(), UTC_TIME() + 0;\n        -> \'18:07:53\', 180753.000000\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (630,12,'UTC_TIMESTAMP','Syntax:\nUTC_TIMESTAMP, UTC_TIMESTAMP([fsp])\n\nReturns the current UTC date and time as a value in \'YYYY-MM-DD\nHH:MM:SS\' or YYYYMMDDHHMMSS format, depending on whether the function\nis used in a string or numeric context.\n\nIf the fsp argument is given to specify a fractional seconds precision\nfrom 0 to 6, the return value includes a fractional seconds part of\nthat many digits.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT UTC_TIMESTAMP(), UTC_TIMESTAMP() + 0;\n        -> \'2003-08-14 18:08:04\', 20030814180804.000000\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (631,29,'UUID','Syntax:\nUUID()\n\nReturns a Universal Unique Identifier (UUID) generated according to RFC\n4122, "A Universally Unique IDentifier (UUID) URN Namespace"\n(http://www.ietf.org/rfc/rfc4122.txt).\n\nA UUID is designed as a number that is globally unique in space and\ntime. Two calls to UUID() are expected to generate two different\nvalues, even if these calls are performed on two separate devices not\nconnected to each other.\n\n*Warning*:\n\nAlthough UUID() values are intended to be unique, they are not\nnecessarily unguessable or unpredictable. If unpredictability is\nrequired, UUID values should be generated some other way.\n\nUUID() returns a value that conforms to UUID version 1 as described in\nRFC 4122. The value is a 128-bit number represented as a utf8 string of\nfive hexadecimal numbers in aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee\nformat:\n\no The first three numbers are generated from the low, middle, and high\n  parts of a timestamp. The high part also includes the UUID version\n  number.\n\no The fourth number preserves temporal uniqueness in case the timestamp\n  value loses monotonicity (for example, due to daylight saving time).\n\no The fifth number is an IEEE 802 node number that provides spatial\n  uniqueness. A random number is substituted if the latter is not\n  available (for example, because the host device has no Ethernet card,\n  or it is unknown how to find the hardware address of an interface on\n  the host operating system). In this case, spatial uniqueness cannot\n  be guaranteed. Nevertheless, a collision should have very low\n  probability.\n\n  The MAC address of an interface is taken into account only on FreeBSD\n  and Linux. On other operating systems, MySQL uses a randomly\n  generated 48-bit number.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html\n\n','mysql> SELECT UUID();\n        -> \'6ccd780c-baba-1026-9564-5b8c656024db\'\n','http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (632,29,'UUID_SHORT','Syntax:\nUUID_SHORT()\n\nReturns a "short" universal identifier as a 64-bit unsigned integer.\nValues returned by UUID_SHORT() differ from the string-format 128-bit\nidentifiers returned by the UUID() function and have different\nuniqueness properties. The value of UUID_SHORT() is guaranteed to be\nunique if the following conditions hold:\n\no The server_id value of the current server is between 0 and 255 and is\n  unique among your set of master and slave servers\n\no You do not set back the system time for your server host between\n  mysqld restarts\n\no You invoke UUID_SHORT() on average fewer than 16 million times per\n  second between mysqld restarts\n\nThe UUID_SHORT() return value is constructed this way:\n\n  (server_id & 255) << 56\n+ (server_startup_time_in_seconds << 24)\n+ incremented_variable++;\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html\n\n','mysql> SELECT UUID_SHORT();\n        -> 92395783831158784\n','http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (633,29,'UUID_TO_BIN','UUID_TO_BIN(string_uuid), UUID_TO_BIN(string_uuid, swap_flag)\n\nConverts a string UUID to a binary UUID and returns the result. (The\nIS_UUID() function description lists the permitted string UUID\nformats.) The return binary UUID is a VARBINARY(16) value. If the UUID\nargument is NULL, the return value is NULL. If any argument is invalid,\nan error occurs.\n\nUUID_TO_BIN() takes one or two arguments:\n\no The one-argument form takes a string UUID value. The binary result is\n  in the same order as the string argument.\n\no The two-argument form takes a string UUID value and a flag value:\n\n  o If swap_flag is 0, the two-argument form is equivalent to the\n    one-argument form. The binary result is in the same order as the\n    string argument.\n\n  o If swap_flag is 1, the format of the return value differs: The\n    time-low and time-high parts (the first and third groups of\n    hexadecimal digits, respectively) are swapped. This moves the more\n    rapidly varying part to the right and can improve indexing\n    efficiency if the result is stored in an indexed column.\n\nTime-part swapping assumes the use of UUID version 1 values, such as\nare generated by the UUID() function. For UUID values produced by other\nmeans that do not follow version 1 format, time-part swapping provides\nno benefit. For details about version 1 format, see the UUID() function\ndescription.\n\nSuppose that you have the following string UUID value:\n\nmysql> SET @uuid = \'6ccd780c-baba-1026-9564-5b8c656024db\';\n\nTo convert the string UUID to binary with or without time-part\nswapping, use UUID_TO_BIN():\n\nmysql> SELECT HEX(UUID_TO_BIN(@uuid));\n+----------------------------------+\n| HEX(UUID_TO_BIN(@uuid))          |\n+----------------------------------+\n| 6CCD780CBABA102695645B8C656024DB |\n+----------------------------------+\nmysql> SELECT HEX(UUID_TO_BIN(@uuid, 0));\n+----------------------------------+\n| HEX(UUID_TO_BIN(@uuid, 0))       |\n+----------------------------------+\n| 6CCD780CBABA102695645B8C656024DB |\n+----------------------------------+\nmysql> SELECT HEX(UUID_TO_BIN(@uuid, 1));\n+----------------------------------+\n| HEX(UUID_TO_BIN(@uuid, 1))       |\n+----------------------------------+\n| 1026BABA6CCD780C95645B8C656024DB |\n+----------------------------------+\n\nTo convert a binary UUID returned by UUID_TO_BIN() to a string UUID,\nuse BIN_TO_UUID(). If you produce a binary UUID by calling\nUUID_TO_BIN() with a second argument of 1 to swap time parts, you\nshould also pass a second argument of 1 to BIN_TO_UUID() to unswap the\ntime parts when converting the binary UUID back to a string UUID:\n\nmysql> SELECT BIN_TO_UUID(UUID_TO_BIN(@uuid));\n+--------------------------------------+\n| BIN_TO_UUID(UUID_TO_BIN(@uuid))      |\n+--------------------------------------+\n| 6ccd780c-baba-1026-9564-5b8c656024db |\n+--------------------------------------+\nmysql> SELECT BIN_TO_UUID(UUID_TO_BIN(@uuid,0),0);\n+--------------------------------------+\n| BIN_TO_UUID(UUID_TO_BIN(@uuid,0),0)  |\n+--------------------------------------+\n| 6ccd780c-baba-1026-9564-5b8c656024db |\n+--------------------------------------+\nmysql> SELECT BIN_TO_UUID(UUID_TO_BIN(@uuid,1),1);\n+--------------------------------------+\n| BIN_TO_UUID(UUID_TO_BIN(@uuid,1),1)  |\n+--------------------------------------+\n| 6ccd780c-baba-1026-9564-5b8c656024db |\n+--------------------------------------+\n\nIf the use of time-part swapping is not the same for the conversion in\nboth directions, the original UUID will not be recovered properly:\n\nmysql> SELECT BIN_TO_UUID(UUID_TO_BIN(@uuid,0),1);\n+--------------------------------------+\n| BIN_TO_UUID(UUID_TO_BIN(@uuid,0),1)  |\n+--------------------------------------+\n| baba1026-780c-6ccd-9564-5b8c656024db |\n+--------------------------------------+\nmysql> SELECT BIN_TO_UUID(UUID_TO_BIN(@uuid,1),0);\n+--------------------------------------+\n| BIN_TO_UUID(UUID_TO_BIN(@uuid,1),0)  |\n+--------------------------------------+\n| 1026baba-6ccd-780c-9564-5b8c656024db |\n+--------------------------------------+\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (634,13,'VALIDATE_PASSWORD_STRENGTH','Syntax:\nVALIDATE_PASSWORD_STRENGTH(str)\n\nGiven an argument representing a cleartext password, this function\nreturns an integer to indicate how strong the password is. The return\nvalue ranges from 0 (weak) to 100 (strong).\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/encryption-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (635,29,'VALUES','Syntax:\nVALUES(col_name)\n\nIn an INSERT ... ON DUPLICATE KEY UPDATE statement, you can use the\nVALUES(col_name) function in the UPDATE clause to refer to column\nvalues from the INSERT portion of the statement. In other words,\nVALUES(col_name) in the UPDATE clause refers to the value of col_name\nthat would be inserted, had no duplicate-key conflict occurred. This\nfunction is especially useful in multiple-row inserts. The VALUES()\nfunction is meaningful only in the ON DUPLICATE KEY UPDATE clause of\nINSERT statements and returns NULL otherwise. See\nhttp://dev.mysql.com/doc/refman/8.0/en/insert-on-duplicate.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html\n\n','mysql> INSERT INTO table (a,b,c) VALUES (1,2,3),(4,5,6)\n    -> ON DUPLICATE KEY UPDATE c=VALUES(a)+VALUES(b);\n','http://dev.mysql.com/doc/refman/8.0/en/miscellaneous-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (636,11,'VARBINARY','VARBINARY(M)\n\nThe VARBINARY type is similar to the VARCHAR type, but stores binary\nbyte strings rather than nonbinary character strings. M represents the\nmaximum column length in bytes.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (637,11,'VARCHAR','[NATIONAL] VARCHAR(M) [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nA variable-length string. M represents the maximum column length in\ncharacters. The range of M is 0 to 65,535. The effective maximum length\nof a VARCHAR is subject to the maximum row size (65,535 bytes, which is\nshared among all columns) and the character set used. For example, utf8\ncharacters can require up to three bytes per character, so a VARCHAR\ncolumn that uses the utf8 character set can be declared to be a maximum\nof 21,844 characters. See\nhttp://dev.mysql.com/doc/refman/8.0/en/column-count-limit.html.\n\nMySQL stores VARCHAR values as a 1-byte or 2-byte length prefix plus\ndata. The length prefix indicates the number of bytes in the value. A\nVARCHAR column uses one length byte if values require no more than 255\nbytes, two length bytes if values may require more than 255 bytes.\n\n*Note*:\n\nMySQL follows the standard SQL specification, and does not remove\ntrailing spaces from VARCHAR values.\n\nVARCHAR is shorthand for CHARACTER VARYING. NATIONAL VARCHAR is the\nstandard SQL way to define that a VARCHAR column should use some\npredefined character set. MySQL uses utf8 as this predefined character\nset. http://dev.mysql.com/doc/refman/8.0/en/charset-national.html.\nNVARCHAR is shorthand for NATIONAL VARCHAR.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (638,15,'VARIANCE','Syntax:\nVARIANCE(expr) [over_clause]\n\nReturns the population standard variance of expr. VARIANCE() is a\nsynonym for the standard SQL function VAR_POP(), provided as a MySQL\nextension.\n\nIf there are no matching rows, VARIANCE() returns NULL.\n\nThis function executes as a window function if over_clause is present.\nover_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (639,15,'VAR_POP','Syntax:\nVAR_POP(expr) [over_clause]\n\nReturns the population standard variance of expr. It considers rows as\nthe whole population, not as a sample, so it has the number of rows as\nthe denominator. You can also use VARIANCE(), which is equivalent but\nis not standard SQL.\n\nIf there are no matching rows, VAR_POP() returns NULL.\n\nThis function executes as a window function if over_clause is present.\nover_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (640,15,'VAR_SAMP','Syntax:\nVAR_SAMP(expr) [over_clause]\n\nReturns the sample variance of expr. That is, the denominator is the\nnumber of rows minus one.\n\nIf there are no matching rows, VAR_SAMP() returns NULL.\n\nThis function executes as a window function if over_clause is present.\nover_clause is as described in\nhttp://dev.mysql.com/doc/refman/8.0/en/window-functions-usage.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/group-by-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (641,23,'VERSION','Syntax:\nVERSION()\n\nReturns a string that indicates the MySQL server version. The string\nuses the utf8 character set. The value might have a suffix in addition\nto the version number. See the description of the version system\nvariable in\nhttp://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/information-functions.html\n\n','mysql> SELECT VERSION();\n        -> \'8.0.17-standard\'\n','http://dev.mysql.com/doc/refman/8.0/en/information-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (642,28,'WAIT_FOR_EXECUTED_GTID_SET','Syntax:\nWAIT_FOR_EXECUTED_GTID_SET(gtid_set[, timeout])\n\nWait until the server has applied all of the transactions whose global\ntransaction identifiers are contained in gtid_set; that is, until the\ncondition GTID_SUBSET(gtid_subset, @@GLOBAL.gtid_executed) holds. See\nhttp://dev.mysql.com/doc/refman/8.0/en/replication-gtids-concepts.html\nfor a definition of GTID sets.\n\nIf a timeout is specified, and timeout seconds elapse before all of the\ntransactions in the GTID set have been applied, the function stops\nwaiting. timeout is optional, and the default timeout is 0 seconds, in\nwhich case the function always waits until all of the transactions in\nthe GTID set have been applied.\n\nWAIT_FOR_EXECUTED_GTID_SET() monitors all the GTIDs that are applied on\nthe server, including transactions that arrive from all replication\nchannels and user clients. It does not take into account whether\nreplication channels have been started or stopped.\n\nFor more information, see\nhttp://dev.mysql.com/doc/refman/8.0/en/replication-gtids.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gtid-functions.html\n\n','mysql> SELECT WAIT_FOR_EXECUTED_GTID_SET(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:1-5\');\n        -> 0\n','http://dev.mysql.com/doc/refman/8.0/en/gtid-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (643,28,'WAIT_UNTIL_SQL_THREAD_AFTER_GTIDS','Syntax:\nWAIT_UNTIL_SQL_THREAD_AFTER_GTIDS(gtid_set[, timeout][,channel])\n\nWAIT_UNTIL_SQL_THREAD_AFTER_GTIDS() is similar to\nWAIT_FOR_EXECUTED_GTID_SET() in that it waits until all of the\ntransactions whose global transaction identifiers are contained in\ngtid_set have been applied, or until timeout seconds have elapsed,\nwhichever occurs first. However, WAIT_UNTIL_SQL_THREAD_AFTER_GTIDS()\napplies to a specific replication channel, and stops only after the\ntransactions have been applied on the specified channel, for which the\napplier must be running. In contrast, WAIT_FOR_EXECUTED_GTID_SET()\nstops after the transactions have been applied, regardless of where\nthey were applied (on any replication channel or any user client), and\nwhether or not any replication channels are running.\n\nThe channel option names which replication channel the function applies\nto. If no channel is named and no channels other than the default\nreplication channel exist, the function applies to the default\nreplication channel. If multiple replication channels exist, you must\nspecify a channel as otherwise it is not known which replication\nchannel the function applies to. See\nhttp://dev.mysql.com/doc/refman/8.0/en/replication-channels.html for\nmore information on replication channels.\n\n*Note*:\n\nBecause WAIT_UNTIL_SQL_THREAD_AFTER_GTIDS() applies to a specific\nreplication channel, if an expected transaction arrives on a different\nreplication channel or from a user client, for example in a failover or\nmanual recovery situation, the function can hang indefinitely if no\ntimeout is set. Use WAIT_FOR_EXECUTED_GTID_SET() instead to ensure\ncorrect handling of transactions in these situations.\n\nGTID sets used with WAIT_UNTIL_SQL_THREAD_AFTER_GTIDS() are represented\nas strings and must be quoted in the same way as for\nWAIT_FOR_EXECUTED_GTID_SET(). For WAIT_UNTIL_SQL_THREAD_AFTER_GTIDS(),\nthe return value for the function is an arbitrary positive number. If\nGTID-based replication is not active (that is, if the value of the\ngtid_mode variable is OFF), then this value is undefined and\nWAIT_UNTIL_SQL_THREAD_AFTER_GTIDS() returns NULL. If the slave is not\nrunning then the function also returns NULL.\n\ngtid_mode cannot be changed to OFF while any client is using this\nfunction to wait for GTIDs to be applied.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gtid-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gtid-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (644,12,'WEEK','Syntax:\nWEEK(date[,mode])\n\nThis function returns the week number for date. The two-argument form\nof WEEK() enables you to specify whether the week starts on Sunday or\nMonday and whether the return value should be in the range from 0 to 53\nor from 1 to 53. If the mode argument is omitted, the value of the\ndefault_week_format system variable is used. See\nhttp://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT WEEK(\'2008-02-20\');\n        -> 7\nmysql> SELECT WEEK(\'2008-02-20\',0);\n        -> 7\nmysql> SELECT WEEK(\'2008-02-20\',1);\n        -> 8\nmysql> SELECT WEEK(\'2008-12-31\',1);\n        -> 53\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (645,12,'WEEKDAY','Syntax:\nWEEKDAY(date)\n\nReturns the weekday index for date (0 = Monday, 1 = Tuesday, ... 6 =\nSunday).\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT WEEKDAY(\'2008-02-03 22:23:00\');\n        -> 6\nmysql> SELECT WEEKDAY(\'2007-11-06\');\n        -> 1\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (646,12,'WEEKOFYEAR','Syntax:\nWEEKOFYEAR(date)\n\nReturns the calendar week of the date as a number in the range from 1\nto 53. WEEKOFYEAR() is a compatibility function that is equivalent to\nWEEK(date,3).\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT WEEKOFYEAR(\'2008-02-20\');\n        -> 8\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (647,35,'WEIGHT_STRING','Syntax:\nWEIGHT_STRING(str [AS {CHAR|BINARY}(N)] [flags])\n\nThis function returns the weight string for the input string. The\nreturn value is a binary string that represents the comparison and\nsorting value of the string. It has these properties:\n\no If WEIGHT_STRING(str1) = WEIGHT_STRING(str2), then str1 = str2 (str1\n  and str2 are considered equal)\n\no If WEIGHT_STRING(str1) < WEIGHT_STRING(str2), then str1 < str2 (str1\n  sorts before str2)\n\nWEIGHT_STRING() is a debugging function intended for internal use. Its\nbehavior can change without notice between MySQL versions. It can be\nused for testing and debugging of collations, especially if you are\nadding a new collation. See\nhttp://dev.mysql.com/doc/refman/8.0/en/adding-collation.html.\n\nThis list briefly summarizes the arguments. More details are given in\nthe discussion following the list.\n\no str: The input string expression.\n\no AS clause: Optional; cast the input string to a given type and\n  length.\n\no flags: Optional; unused.\n\nThe input string, str, is a string expression. If the input is a\nnonbinary (character) string such as a CHAR, VARCHAR, or TEXT value,\nthe return value contains the collation weights for the string. If the\ninput is a binary (byte) string such as a BINARY, VARBINARY, or BLOB\nvalue, the return value is the same as the input (the weight for each\nbyte in a binary string is the byte value). If the input is NULL,\nWEIGHT_STRING() returns NULL.\n\nExamples:\n\nmysql> SET @s = _utf8mb4 \'AB\' COLLATE utf8mb4_0900_ai_ci;\nmysql> SELECT @s, HEX(@s), HEX(WEIGHT_STRING(@s));\n+------+---------+------------------------+\n| @s   | HEX(@s) | HEX(WEIGHT_STRING(@s)) |\n+------+---------+------------------------+\n| AB   | 4142    | 1C471C60               |\n+------+---------+------------------------+\n\nmysql> SET @s = _utf8mb4 \'ab\' COLLATE utf8mb4_0900_ai_ci;\nmysql> SELECT @s, HEX(@s), HEX(WEIGHT_STRING(@s));\n+------+---------+------------------------+\n| @s   | HEX(@s) | HEX(WEIGHT_STRING(@s)) |\n+------+---------+------------------------+\n| ab   | 6162    | 1C471C60               |\n+------+---------+------------------------+\n\nmysql> SET @s = CAST(\'AB\' AS BINARY);\nmysql> SELECT @s, HEX(@s), HEX(WEIGHT_STRING(@s));\n+------+---------+------------------------+\n| @s   | HEX(@s) | HEX(WEIGHT_STRING(@s)) |\n+------+---------+------------------------+\n| AB   | 4142    | 4142                   |\n+------+---------+------------------------+\n\nmysql> SET @s = CAST(\'ab\' AS BINARY);\nmysql> SELECT @s, HEX(@s), HEX(WEIGHT_STRING(@s));\n+------+---------+------------------------+\n| @s   | HEX(@s) | HEX(WEIGHT_STRING(@s)) |\n+------+---------+------------------------+\n| ab   | 6162    | 6162                   |\n+------+---------+------------------------+\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/string-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (648,6,'WHILE','Syntax:\n[begin_label:] WHILE search_condition DO\n    statement_list\nEND WHILE [end_label]\n\nThe statement list within a WHILE statement is repeated as long as the\nsearch_condition expression is true. statement_list consists of one or\nmore SQL statements, each terminated by a semicolon (;) statement\ndelimiter.\n\nA WHILE statement can be labeled. For the rules regarding label use,\nsee [HELP labels].\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/while.html\n\n','CREATE PROCEDURE dowhile()\nBEGIN\n  DECLARE v1 INT DEFAULT 5;\n\n  WHILE v1 > 0 DO\n    ...\n    SET v1 = v1 - 1;\n  END WHILE;\nEND;\n','http://dev.mysql.com/doc/refman/8.0/en/while.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (649,41,'WKT DEFINITION','The Well-Known Text (WKT) representation of geometry values is designed\nfor exchanging geometry data in ASCII form. The OpenGIS specification\nprovides a Backus-Naur grammar that specifies the formal production\nrules for writing WKT values (see\nhttp://dev.mysql.com/doc/refman/8.0/en/spatial-types.html).\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/gis-data-formats.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/gis-data-formats.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (650,37,'XA','Syntax:\nXA {START|BEGIN} xid [JOIN|RESUME]\n\nXA END xid [SUSPEND [FOR MIGRATE]]\n\nXA PREPARE xid\n\nXA COMMIT xid [ONE PHASE]\n\nXA ROLLBACK xid\n\nXA RECOVER [CONVERT XID]\n\nFor XA START, the JOIN and RESUME clauses are not supported.\n\nFor XA END the SUSPEND [FOR MIGRATE] clause is not supported.\n\nEach XA statement begins with the XA keyword, and most of them require\nan xid value. An xid is an XA transaction identifier. It indicates\nwhich transaction the statement applies to. xid values are supplied by\nthe client, or generated by the MySQL server. An xid value has from one\nto three parts:\n\nxid: gtrid [, bqual [, formatID ]]\n\ngtrid is a global transaction identifier, bqual is a branch qualifier,\nand formatID is a number that identifies the format used by the gtrid\nand bqual values. As indicated by the syntax, bqual and formatID are\noptional. The default bqual value is \'\' if not given. The default\nformatID value is 1 if not given.\n\ngtrid and bqual must be string literals, each up to 64 bytes (not\ncharacters) long. gtrid and bqual can be specified in several ways. You\ncan use a quoted string (\'ab\'), hex string (X\'6162\', 0x6162), or bit\nvalue (b\'nnnn\').\n\nformatID is an unsigned integer.\n\nThe gtrid and bqual values are interpreted in bytes by the MySQL\nserver\'s underlying XA support routines. However, while an SQL\nstatement containing an XA statement is being parsed, the server works\nwith some specific character set. To be safe, write gtrid and bqual as\nhex strings.\n\nxid values typically are generated by the Transaction Manager. Values\ngenerated by one TM must be different from values generated by other\nTMs. A given TM must be able to recognize its own xid values in a list\nof values returned by the XA RECOVER statement.\n\nXA START xid starts an XA transaction with the given xid value. Each XA\ntransaction must have a unique xid value, so the value must not\ncurrently be used by another XA transaction. Uniqueness is assessed\nusing the gtrid and bqual values. All following XA statements for the\nXA transaction must be specified using the same xid value as that given\nin the XA START statement. If you use any of those statements but\nspecify an xid value that does not correspond to some existing XA\ntransaction, an error occurs.\n\nOne or more XA transactions can be part of the same global transaction.\nAll XA transactions within a given global transaction must use the same\ngtrid value in the xid value. For this reason, gtrid values must be\nglobally unique so that there is no ambiguity about which global\ntransaction a given XA transaction is part of. The bqual part of the\nxid value must be different for each XA transaction within a global\ntransaction. (The requirement that bqual values be different is a\nlimitation of the current MySQL XA implementation. It is not part of\nthe XA specification.)\n\nThe XA RECOVER statement returns information for those XA transactions\non the MySQL server that are in the PREPARED state. (See\nhttp://dev.mysql.com/doc/refman/8.0/en/xa-states.html.) The output\nincludes a row for each such XA transaction on the server, regardless\nof which client started it.\n\nXA RECOVER requires the XA_RECOVER_ADMIN privilege. This privilege\nrequirement prevents users from discovering the XID values for\noutstanding prepared XA transactions other than their own. It does not\naffect normal commit or rollback of an XA transaction because the user\nwho started it knows its XID.\n\nXA RECOVER output rows look like this (for an example xid value\nconsisting of the parts \'abc\', \'def\', and 7):\n\nmysql> XA RECOVER;\n+----------+--------------+--------------+--------+\n| formatID | gtrid_length | bqual_length | data   |\n+----------+--------------+--------------+--------+\n|        7 |            3 |            3 | abcdef |\n+----------+--------------+--------------+--------+\n\nThe output columns have the following meanings:\n\no formatID is the formatID part of the transaction xid\n\no gtrid_length is the length in bytes of the gtrid part of the xid\n\no bqual_length is the length in bytes of the bqual part of the xid\n\no data is the concatenation of the gtrid and bqual parts of the xid\n\nXID values may contain nonprintable characters. XA RECOVER permits an\noptional CONVERT XID clause so that clients can request XID values in\nhexadecimal.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/xa-statements.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/xa-statements.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (651,27,'XOR','Syntax:\nXOR\n\nLogical XOR. Returns NULL if either operand is NULL. For non-NULL\noperands, evaluates to 1 if an odd number of operands is nonzero,\notherwise 0 is returned.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/logical-operators.html\n\n','mysql> SELECT 1 XOR 1;\n        -> 0\nmysql> SELECT 1 XOR 0;\n        -> 1\nmysql> SELECT 1 XOR NULL;\n        -> NULL\nmysql> SELECT 1 XOR 1 XOR 1;\n        -> 1\n','http://dev.mysql.com/doc/refman/8.0/en/logical-operators.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (652,12,'YEAR','Syntax:\nYEAR(date)\n\nReturns the year for date, in the range 1000 to 9999, or 0 for the\n"zero" date.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT YEAR(\'1987-01-01\');\n        -> 1987\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (653,11,'YEAR DATA TYPE','YEAR[(4)]\n\nA year in four-digit format. MySQL displays YEAR values in YYYY format,\nbut permits assignment of values to YEAR columns using either strings\nor numbers. Values display as 1901 to 2155, and 0000.\n\nFor additional information about YEAR display format and interpretation\nof input values, see http://dev.mysql.com/doc/refman/8.0/en/year.html.\n\n*Note*:\n\nMySQL 8.0 does not support the YEAR(2) data type permitted in older\nversions of MySQL. For instructions on converting to YEAR(4), see\nYEAR(2) Limitations and Migrating to YEAR(4)\n(http://dev.mysql.com/doc/refman/5.7/en/migrating-to-year4.html) in\nMySQL 5.7 Reference Manual (http://dev.mysql.com/doc/refman/5.7/en/).\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-type-overview.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (654,12,'YEARWEEK','Syntax:\nYEARWEEK(date), YEARWEEK(date,mode)\n\nReturns year and week for a date. The year in the result may be\ndifferent from the year in the date argument for the first and the last\nweek of the year.\n\nThe mode argument works exactly like the mode argument to WEEK(). For\nthe single-argument syntax, a mode value of 0 is used. Unlike WEEK(),\nthe value of default_week_format does not influence YEARWEEK().\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html\n\n','mysql> SELECT YEARWEEK(\'1987-01-01\');\n        -> 198652\n','http://dev.mysql.com/doc/refman/8.0/en/date-and-time-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (655,3,'^','Syntax:\n^\n\nBitwise XOR.\n\nThe result type depends on whether the arguments are evaluated as\nbinary strings or numbers:\n\no Binary-string evaluation occurs when the arguments have a binary\n  string type, and at least one of them is not a hexadecimal literal,\n  bit literal, or NULL literal. Numeric evaluation occurs otherwise,\n  with argument conversion to unsigned 64-bit integers as necessary.\n\no Binary-string evaluation produces a binary string of the same length\n  as the arguments. If the arguments have unequal lengths, an\n  ER_INVALID_BITWISE_OPERANDS_SIZE error occurs. Numeric evaluation\n  produces an unsigned 64-bit integer.\n\nFor more information, see the introductory discussion in this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/bit-functions.html\n\n','mysql> SELECT 1 ^ 1;\n        -> 0\nmysql> SELECT 1 ^ 0;\n        -> 1\nmysql> SELECT 11 ^ 3;\n        -> 8\nmysql> SELECT HEX(_binary X\'FEDC\' ^ X\'1111\');\n        -> \'EFCD\'\n','http://dev.mysql.com/doc/refman/8.0/en/bit-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (656,3,'|','Syntax:\n|\n\nBitwise OR.\n\nThe result type depends on whether the arguments are evaluated as\nbinary strings or numbers:\n\no Binary-string evaluation occurs when the arguments have a binary\n  string type, and at least one of them is not a hexadecimal literal,\n  bit literal, or NULL literal. Numeric evaluation occurs otherwise,\n  with argument conversion to unsigned 64-bit integers as necessary.\n\no Binary-string evaluation produces a binary string of the same length\n  as the arguments. If the arguments have unequal lengths, an\n  ER_INVALID_BITWISE_OPERANDS_SIZE error occurs. Numeric evaluation\n  produces an unsigned 64-bit integer.\n\nFor more information, see the introductory discussion in this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/bit-functions.html\n\n','mysql> SELECT 29 | 15;\n        -> 31\nmysql> SELECT _binary X\'40404040\' | X\'01020304\';\n        -> \'ABCD\'\n','http://dev.mysql.com/doc/refman/8.0/en/bit-functions.html');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (657,3,'~','Syntax:\n~\n\nInvert all bits.\n\nThe result type depends on whether the bit argument is evaluated as a\nbinary string or number:\n\no Binary-string evaluation occurs when the bit argument has a binary\n  string type, and is not a hexadecimal literal, bit literal, or NULL\n  literal. Numeric evaluation occurs otherwise, with argument\n  conversion to an unsigned 64-bit integer as necessary.\n\no Binary-string evaluation produces a binary string of the same length\n  as the bit argument. Numeric evaluation produces an unsigned 64-bit\n  integer.\n\nFor more information, see the introductory discussion in this section.\n\nURL: http://dev.mysql.com/doc/refman/8.0/en/bit-functions.html\n\n','mysql> SELECT 5 & ~1;\n        -> 4\nmysql> SELECT HEX(~X\'0000FFFF1111EEEE\');\n        -> \'FFFF0000EEEE1111\'\n','http://dev.mysql.com/doc/refman/8.0/en/bit-functions.html');

INSERT INTO help_keyword (help_keyword_id,name) VALUES (0,'(JSON');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (1,'->');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (2,'->>');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (3,'<>');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (4,'ACCOUNT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (5,'ACTION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (6,'ADD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (7,'ADMIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (8,'AES_DECRYPT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (9,'AES_ENCRYPT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (10,'AFTER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (11,'AGAINST');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (12,'AGGREGATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (13,'ALGORITHM');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (14,'ALL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (15,'ALTER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (16,'ANALYZE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (17,'AND');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (18,'ANY_VALUE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (19,'ARCHIVE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (20,'AS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (21,'ASC');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (22,'AT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (23,'AUTOCOMMIT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (24,'AUTOEXTEND_SIZE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (25,'AUTO_INCREMENT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (26,'AVG_ROW_LENGTH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (27,'BACKUP');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (28,'BEFORE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (29,'BEGIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (30,'BETWEEN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (31,'BIGINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (32,'BINARY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (33,'BINLOG');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (34,'BIN_TO_UUID');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (35,'BOOL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (36,'BOOLEAN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (37,'BOTH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (38,'BTREE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (39,'BY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (40,'BYTE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (41,'CACHE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (42,'CALL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (43,'CAN_ACCESS_COLUMN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (44,'CAN_ACCESS_DATABASE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (45,'CAN_ACCESS_TABLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (46,'CAN_ACCESS_VIEW');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (47,'CASCADE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (48,'CASE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (49,'CATALOG_NAME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (50,'CEIL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (51,'CEILING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (52,'CHAIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (53,'CHANGE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (54,'CHANNEL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (55,'CHAR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (56,'CHARACTER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (57,'CHARSET');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (58,'CHECK');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (59,'CHECKSUM');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (60,'CIPHER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (61,'CLASS_ORIGIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (62,'CLIENT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (63,'CLOSE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (64,'COALESCE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (65,'CODE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (66,'COLLATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (67,'COLLATION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (68,'COLUMN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (69,'COLUMNS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (70,'COLUMN_NAME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (71,'COMMENT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (72,'COMMIT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (73,'COMMITTED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (74,'COMPACT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (75,'COMPLETION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (76,'COMPONENT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (77,'COMPRESSED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (78,'COMPRESSION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (79,'CONCURRENT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (80,'CONDITION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (81,'CONNECTION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (82,'CONSISTENT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (83,'CONSTRAINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (84,'CONSTRAINT_CATALOG');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (85,'CONSTRAINT_NAME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (86,'CONSTRAINT_SCHEMA');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (87,'CONTINUE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (88,'CONVERT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (89,'COUNT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (90,'CREATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (91,'CREATE_DH_PARAMETERS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (92,'CROSS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (93,'CSV');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (94,'CUME_DIST');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (95,'CURRENT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (96,'CURRENT_ROLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (97,'CURRENT_USER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (98,'CURSOR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (99,'CURSOR_NAME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (100,'DATA');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (101,'DATABASE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (102,'DATABASES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (103,'DATAFILE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (104,'DATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (105,'DATETIME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (106,'DATE_ADD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (107,'DATE_SUB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (108,'DAY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (109,'DAY_HOUR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (110,'DAY_MINUTE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (111,'DAY_SECOND');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (112,'DEALLOCATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (113,'DEC');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (114,'DECIMAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (115,'DECLARE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (116,'DEFAULT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (117,'DEFAULT_AUTH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (118,'DEFINER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (119,'DEFINITION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (120,'DELAYED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (121,'DELAY_KEY_WRITE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (122,'DELETE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (123,'DENSE_RANK');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (124,'DESC');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (125,'DESCRIBE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (126,'DESCRIPTION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (127,'DIAGNOSTICS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (128,'DIRECTORY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (129,'DISABLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (130,'DISCARD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (131,'DISTINCT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (132,'DISTINCTROW');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (133,'DO');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (134,'DROP');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (135,'DUAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (136,'DUMPFILE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (137,'DUPLICATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (138,'DYNAMIC');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (139,'ELSE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (140,'ELSEIF');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (141,'ENABLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (142,'ENCLOSED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (143,'ENCRYPTION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (144,'END');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (145,'ENDS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (146,'ENGINE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (147,'ENGINES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (148,'ERROR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (149,'ERRORS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (150,'ESCAPE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (151,'ESCAPED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (152,'EVENT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (153,'EVENTS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (154,'EVERY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (155,'EXCEPT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (156,'EXCHANGE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (157,'EXECUTE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (158,'EXISTS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (159,'EXIT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (160,'EXPANSION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (161,'EXPIRE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (162,'EXPLAIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (163,'EXPORT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (164,'EXTENDED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (165,'EXTENT_SIZE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (166,'EXTRACTION)');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (167,'FALSE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (168,'FAST');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (169,'FEDERATED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (170,'FETCH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (171,'FIELDS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (172,'FILE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (173,'FILE_BLOCK_SIZE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (174,'FILTER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (175,'FIRST');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (176,'FIRST_VALUE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (177,'FIXED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (178,'FLOAT4');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (179,'FLOAT8');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (180,'FLOOR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (181,'FLUSH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (182,'FOR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (183,'FORCE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (184,'FOREIGN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (185,'FORMAT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (186,'FROM');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (187,'FULL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (188,'FULLTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (189,'FUNCTION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (190,'GENERAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (191,'GEOMCOLLECTION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (192,'GEOMETRYCOLLECTION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (193,'GET');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (194,'GET_DD_COLUMN_PRIVILEGES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (195,'GET_DD_CREATE_OPTIONS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (196,'GET_DD_INDEX_SUB_PART_LENGTH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (197,'GLOBAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (198,'GRANT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (199,'GRANTS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (200,'GROUP');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (201,'GROUPING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (202,'HANDLER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (203,'HAVING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (204,'HEAP');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (205,'HELP');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (206,'HELP_DATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (207,'HELP_VERSION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (208,'HIGH_PRIORITY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (209,'HISTORY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (210,'HOST');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (211,'HOSTS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (212,'HOUR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (213,'HOUR_MINUTE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (214,'HOUR_SECOND');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (215,'ICU_VERSION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (216,'IDENTIFIED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (217,'IF');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (218,'IGNORE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (219,'IGNORE_SERVER_IDS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (220,'IMPORT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (221,'IN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (222,'INDEX');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (223,'INDEXES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (224,'INFILE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (225,'INITIAL_SIZE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (226,'INLINE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (227,'INNER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (228,'INNODB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (229,'INSERT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (230,'INSERT_METHOD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (231,'INSTALL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (232,'INSTANCE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (233,'INT1');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (234,'INT2');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (235,'INT3');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (236,'INT4');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (237,'INT8');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (238,'INTEGER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (239,'INTERNAL_AUTO_INCREMENT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (240,'INTERNAL_AVG_ROW_LENGTH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (241,'INTERNAL_CHECKSUM');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (242,'INTERNAL_CHECK_TIME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (243,'INTERNAL_DATA_FREE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (244,'INTERNAL_DATA_LENGTH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (245,'INTERNAL_DD_CHAR_LENGTH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (246,'INTERNAL_GET_COMMENT_OR_ERROR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (247,'INTERNAL_GET_VIEW_WARNING_OR_ERROR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (248,'INTERNAL_INDEX_COLUMN_CARDINALITY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (249,'INTERNAL_INDEX_LENGTH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (250,'INTERNAL_KEYS_DISABLED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (251,'INTERNAL_MAX_DATA_LENGTH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (252,'INTERNAL_TABLE_ROWS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (253,'INTERNAL_UPDATE_TIME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (254,'INTERVAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (255,'INTO');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (256,'INVISIBLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (257,'IO_THREAD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (258,'IS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (259,'ISOLATION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (260,'ISSUER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (261,'IS_UUID');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (262,'IS_VISIBLE_DD_OBJECT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (263,'ITERATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (264,'JOIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (265,'JSON');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (266,'JSON_ARRAY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (267,'JSON_ARRAYAGG');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (268,'JSON_ARRAY_APPEND');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (269,'JSON_ARRAY_INSERT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (270,'JSON_CONTAINS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (271,'JSON_CONTAINS_PATH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (272,'JSON_DEPTH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (273,'JSON_EXTRACT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (274,'JSON_INSERT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (275,'JSON_KEYS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (276,'JSON_LENGTH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (277,'JSON_MERGE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (278,'JSON_MERGE_PATCH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (279,'JSON_MERGE_PRESERVE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (280,'JSON_OBJECT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (281,'JSON_OBJECTAGG');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (282,'JSON_PRETTY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (283,'JSON_QUOTE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (284,'JSON_REMOVE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (285,'JSON_REPLACE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (286,'JSON_SEARCH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (287,'JSON_SET');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (288,'JSON_STORAGE_FREE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (289,'JSON_STORAGE_SIZE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (290,'JSON_TABLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (291,'JSON_TYPE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (292,'JSON_UNQUOTE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (293,'JSON_VALID');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (294,'KEY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (295,'KEYS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (296,'KEY_BLOCK_SIZE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (297,'KILL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (298,'LAG');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (299,'LAST');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (300,'LAST_VALUE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (301,'LEAD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (302,'LEADING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (303,'LEAVE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (304,'LEFT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (305,'LEVEL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (306,'LIKE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (307,'LIMIT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (308,'LINES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (309,'LINESTRING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (310,'LOAD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (311,'LOCAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (312,'LOCK');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (313,'LOGFILE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (314,'LOGS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (315,'LONG');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (316,'LONGBINARY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (317,'LOOP');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (318,'LOW_PRIORITY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (319,'MASTER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (320,'MASTER_AUTO_POSITION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (321,'MASTER_BIND');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (322,'MASTER_CONNECT_RETRY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (323,'MASTER_HEARTBEAT_PERIOD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (324,'MASTER_HOST');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (325,'MASTER_LOG_FILE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (326,'MASTER_LOG_POS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (327,'MASTER_PASSWORD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (328,'MASTER_PORT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (329,'MASTER_RETRY_COUNT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (330,'MASTER_SSL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (331,'MASTER_SSL_CA');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (332,'MASTER_SSL_CERT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (333,'MASTER_SSL_CIPHER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (334,'MASTER_SSL_CRL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (335,'MASTER_SSL_CRLPATH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (336,'MASTER_SSL_KEY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (337,'MASTER_SSL_VERIFY_SERVER_CERT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (338,'MASTER_TLS_VERSION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (339,'MASTER_USER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (340,'MATCH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (341,'MAX_CONNECTIONS_PER_HOUR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (342,'MAX_QUERIES_PER_HOUR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (343,'MAX_ROWS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (344,'MAX_SIZE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (345,'MAX_UPDATES_PER_HOUR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (346,'MAX_USER_CONNECTIONS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (347,'MBRCONTAINS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (348,'MBRDISJOINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (349,'MBRINTERSECTS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (350,'MBROVERLAPS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (351,'MBRTOUCHES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (352,'MBRWITHIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (353,'MEDIUM');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (354,'MEMORY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (355,'MERGE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (356,'MESSAGE_TEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (357,'MIDDLEINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (358,'MINUTE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (359,'MINUTE_SECOND');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (360,'MIN_ROWS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (361,'MOD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (362,'MODE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (363,'MODIFY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (364,'MONTH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (365,'MRG_MYISAM');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (366,'MULTILINESTRING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (367,'MULTIPOINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (368,'MULTIPOLYGON');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (369,'MUTEX');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (370,'MYISAM');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (371,'MYSQL_ERRNO');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (372,'NAME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (373,'NAMES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (374,'NATIONAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (375,'NATURAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (376,'NCHAR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (377,'NDB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (378,'NDBCLUSTER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (379,'NEVER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (380,'NEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (381,'NO');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (382,'NODEGROUP');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (383,'NONE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (384,'NOT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (385,'NO_WRITE_TO_BINLOG');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (386,'NTH_VALUE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (387,'NTILE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (388,'NULL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (389,'NUMBER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (390,'NUMERIC');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (391,'NVARCHAR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (392,'OFFSET');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (393,'OLD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (394,'ON');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (395,'ONLY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (396,'OPEN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (397,'OPTIMIZE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (398,'OPTIMIZER_COSTS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (399,'OPTION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (400,'OPTIONAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (401,'OPTIONALLY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (402,'OPTIONS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (403,'OR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (404,'ORDER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (405,'ORGANIZATION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (406,'OUTER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (407,'OUTFILE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (408,'OWNER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (409,'PACK_KEYS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (410,'PARSER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (411,'PARTIAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (412,'PARTITION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (413,'PARTITIONING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (414,'PASSWORD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (415,'PATH)');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (416,'PERCENT_RANK');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (417,'PERSIST');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (418,'PERSIST_ONLY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (419,'PLUGIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (420,'PLUGINS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (421,'PLUGIN_DIR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (422,'POINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (423,'POLYGON');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (424,'PORT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (425,'POW');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (426,'POWER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (427,'PRECISION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (428,'PREPARE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (429,'PRESERVE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (430,'PREV');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (431,'PRIMARY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (432,'PRIVILEGES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (433,'PROCEDURE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (434,'PROCESS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (435,'PROCESSLIST');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (436,'PROFILE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (437,'PROFILES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (438,'PROXY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (439,'PURGE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (440,'QUERY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (441,'QUICK');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (442,'RANDOM_BYTES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (443,'RANK');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (444,'READ');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (445,'REAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (446,'REBUILD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (447,'RECOVER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (448,'REDUNDANT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (449,'REFERENCE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (450,'REFERENCES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (451,'REGEXP_INSTR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (452,'REGEXP_LIKE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (453,'REGEXP_REPLACE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (454,'REGEXP_SUBSTR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (455,'RELAY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (456,'RELAYLOG');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (457,'RELAY_LOG_FILE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (458,'RELAY_LOG_POS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (459,'RELEASE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (460,'RELOAD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (461,'REMOVE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (462,'RENAME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (463,'REORGANIZE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (464,'REPAIR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (465,'REPEAT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (466,'REPEATABLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (467,'REPLACE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (468,'REPLICATE_DO_DB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (469,'REPLICATE_DO_TABLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (470,'REPLICATE_IGNORE_DB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (471,'REPLICATE_IGNORE_TABLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (472,'REPLICATE_REWRITE_DB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (473,'REPLICATE_WILD_DO_TABLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (474,'REPLICATE_WILD_IGNORE_TABLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (475,'REPLICATION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (476,'REQUIRE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (477,'RESET');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (478,'RESIGNAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (479,'RESOURCE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (480,'RESTART');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (481,'RESTRICT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (482,'RETAIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (483,'RETURN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (484,'RETURNED_SQLSTATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (485,'RETURNS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (486,'REUSE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (487,'REVOKE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (488,'RIGHT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (489,'RLIKE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (490,'ROLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (491,'ROLES_GRAPHML');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (492,'ROLLBACK');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (493,'ROWS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (494,'ROW_COUNT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (495,'ROW_FORMAT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (496,'ROW_NUMBER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (497,'SAVEPOINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (498,'SCHEDULE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (499,'SCHEMA');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (500,'SCHEMAS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (501,'SCHEMA_NAME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (502,'SECOND');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (503,'SELECT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (504,'SEPARATOR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (505,'SERIAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (506,'SERIALIZABLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (507,'SERVER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (508,'SESSION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (509,'SET');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (510,'SHA');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (511,'SHA1');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (512,'SHA2');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (513,'SHARE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (514,'SHOW');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (515,'SHUTDOWN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (516,'SIGNAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (517,'SIGNED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (518,'SLAVE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (519,'SLOW');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (520,'SNAPSHOT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (521,'SOCKET');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (522,'SONAME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (523,'SOUNDS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (524,'SPATIAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (525,'SQLSTATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (526,'SQL_AFTER_GTIDS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (527,'SQL_AFTER_MTS_GAPS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (528,'SQL_BEFORE_GTIDS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (529,'SQL_BIG_RESULT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (530,'SQL_BUFFER_RESULT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (531,'SQL_CALC_FOUND_ROWS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (532,'SQL_LOG_BIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (533,'SQL_NO_CACHE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (534,'SQL_SLAVE_SKIP_COUNTER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (535,'SQL_SMALL_RESULT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (536,'SQL_THREAD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (537,'SSL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (538,'START');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (539,'STARTING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (540,'STARTS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (541,'STATEMENT_DIGEST');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (542,'STATEMENT_DIGEST_TEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (543,'STATS_AUTO_RECALC');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (544,'STATS_PERSISTENT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (545,'STATS_SAMPLE_PAGES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (546,'STATUS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (547,'STD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (548,'STDDEV');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (549,'STOP');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (550,'STORAGE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (551,'STORED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (552,'STRAIGHT_JOIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (553,'STRING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (554,'ST_AREA');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (555,'ST_ASBINARY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (556,'ST_ASGEOJSON');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (557,'ST_ASTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (558,'ST_ASWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (559,'ST_ASWKT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (560,'ST_BUFFER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (561,'ST_BUFFER_STRATEGY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (562,'ST_CENTROID');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (563,'ST_CONTAINS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (564,'ST_CONVEXHULL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (565,'ST_CROSSES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (566,'ST_DIFFERENCE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (567,'ST_DIMENSION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (568,'ST_DISJOINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (569,'ST_DISTANCE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (570,'ST_DISTANCE_SPHERE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (571,'ST_ENDPOINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (572,'ST_ENVELOPE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (573,'ST_EQUALS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (574,'ST_EXTERIORRING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (575,'ST_GEOHASH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (576,'ST_GEOMCOLLFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (577,'ST_GEOMCOLLFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (578,'ST_GEOMETRYCOLLECTIONFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (579,'ST_GEOMETRYCOLLECTIONFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (580,'ST_GEOMETRYFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (581,'ST_GEOMETRYFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (582,'ST_GEOMETRYN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (583,'ST_GEOMETRYTYPE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (584,'ST_GEOMFROMGEOJSON');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (585,'ST_GEOMFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (586,'ST_GEOMFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (587,'ST_INTERIORRINGN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (588,'ST_INTERSECTION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (589,'ST_INTERSECTS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (590,'ST_ISCLOSED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (591,'ST_ISEMPTY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (592,'ST_ISSIMPLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (593,'ST_ISVALID');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (594,'ST_LATFROMGEOHASH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (595,'ST_LATITUDE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (596,'ST_LINEFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (597,'ST_LINEFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (598,'ST_LINESTRINGFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (599,'ST_LINESTRINGFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (600,'ST_LONGFROMGEOHASH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (601,'ST_LONGITUDE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (602,'ST_MAKEENVELOPE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (603,'ST_MLINEFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (604,'ST_MLINEFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (605,'ST_MPOINTFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (606,'ST_MPOINTFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (607,'ST_MPOLYFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (608,'ST_MPOLYFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (609,'ST_MULTILINESTRINGFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (610,'ST_MULTILINESTRINGFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (611,'ST_MULTIPOINTFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (612,'ST_MULTIPOINTFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (613,'ST_MULTIPOLYGONFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (614,'ST_MULTIPOLYGONFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (615,'ST_NUMGEOMETRIES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (616,'ST_NUMINTERIORRING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (617,'ST_NUMINTERIORRINGS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (618,'ST_NUMPOINTS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (619,'ST_OVERLAPS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (620,'ST_POINTFROMGEOHASH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (621,'ST_POINTFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (622,'ST_POINTFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (623,'ST_POINTN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (624,'ST_POLYFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (625,'ST_POLYFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (626,'ST_POLYGONFROMTEXT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (627,'ST_POLYGONFROMWKB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (628,'ST_SIMPLIFY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (629,'ST_SRID');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (630,'ST_STARTPOINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (631,'ST_SWAPXY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (632,'ST_SYMDIFFERENCE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (633,'ST_TOUCHES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (634,'ST_TRANSFORM');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (635,'ST_UNION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (636,'ST_VALIDATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (637,'ST_WITHIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (638,'ST_X');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (639,'ST_Y');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (640,'SUBCLASS_ORIGIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (641,'SUBJECT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (642,'SUPER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (643,'SYSTEM');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (644,'TABLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (645,'TABLES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (646,'TABLESPACE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (647,'TABLE_NAME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (648,'TEMPORARY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (649,'TERMINATED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (650,'THEN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (651,'THREAD_PRIORITY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (652,'TIME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (653,'TIMESTAMP');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (654,'TO');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (655,'TRADITIONAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (656,'TRAILING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (657,'TRANSACTION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (658,'TRIGGER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (659,'TRIGGERS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (660,'TRUE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (661,'TRUNCATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (662,'TYPE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (663,'UNCOMMITTED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (664,'UNDO');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (665,'UNINSTALL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (666,'UNION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (667,'UNIQUE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (668,'UNLOCK');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (669,'UNSIGNED');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (670,'UNTIL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (671,'UPDATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (672,'UPGRADE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (673,'USAGE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (674,'USE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (675,'USER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (676,'USER_RESOURCES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (677,'USE_FRM');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (678,'USING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (679,'UUID_TO_BIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (680,'VALUE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (681,'VALUES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (682,'VARCHARACTER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (683,'VARIABLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (684,'VARIABLES');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (685,'VARYING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (686,'VCPU');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (687,'VIEW');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (688,'VIRTUAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (689,'VISIBLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (690,'WAIT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (691,'WARNINGS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (692,'WHEN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (693,'WHERE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (694,'WHILE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (695,'WITH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (696,'WORK');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (697,'WRAPPER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (698,'WRITE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (699,'X509');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (700,'XA');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (701,'YEAR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (702,'YEAR_MONTH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (703,'ZEROFILL');

INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (8,0);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (9,0);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (8,1);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (9,2);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (1,3);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (35,4);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (123,4);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (100,5);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,5);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,6);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (34,6);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (121,6);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (503,6);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (216,7);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (23,8);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (24,9);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,10);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (345,11);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (112,12);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,13);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (35,14);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (216,14);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (422,14);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (427,14);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (439,14);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (444,14);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (449,14);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (621,14);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (25,15);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (26,15);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (27,15);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (28,15);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (29,15);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (30,15);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (31,15);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (32,15);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,15);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (34,15);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (35,15);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (36,15);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (216,15);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (503,15);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,16);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (37,16);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (38,17);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (55,17);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (39,18);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,19);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (35,20);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (123,20);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (279,20);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (330,20);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (439,20);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (219,21);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (439,21);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (110,22);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (506,23);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (121,24);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,25);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,26);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,26);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (331,27);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (398,28);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (53,29);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (506,29);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (650,29);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (55,30);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (164,31);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (102,32);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (200,32);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (398,32);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (454,32);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (60,33);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (455,33);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (61,34);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (70,35);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (606,35);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (345,36);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (606,36);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (611,37);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (113,38);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,39);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (35,39);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,39);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (123,39);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (160,39);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (219,39);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (323,39);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (325,39);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (439,39);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (623,39);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (85,40);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (71,41);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (324,41);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (72,42);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (73,43);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (74,44);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (75,45);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (76,46);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (100,47);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,47);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (178,47);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (182,47);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (77,48);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (78,48);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (210,49);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (423,49);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (496,49);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (80,50);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (81,51);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (506,52);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,53);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (82,53);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (83,53);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (82,54);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (200,54);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (422,54);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (485,54);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (487,54);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (505,54);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (513,54);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (85,55);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (102,55);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (25,56);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,56);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (84,56);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (109,56);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,56);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (323,56);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (325,56);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (439,56);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (442,56);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (453,56);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (456,56);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (637,56);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (442,57);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,58);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (90,58);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,58);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,59);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (91,59);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,59);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (35,60);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (123,60);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (210,61);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (423,61);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (496,61);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (216,62);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (92,63);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (222,63);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,64);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (472,65);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (480,65);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (25,66);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,66);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (109,66);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,66);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (453,67);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (457,67);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,68);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,69);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,69);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (323,69);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (453,69);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (458,69);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (210,70);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (423,70);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (496,70);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (26,71);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,71);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (110,71);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (113,71);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,71);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (121,71);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (506,72);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (650,72);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (269,73);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,74);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (26,75);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (110,75);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (243,76);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (619,76);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,77);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,78);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,78);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (323,79);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (325,79);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (153,80);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,81);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,81);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (190,81);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (308,81);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (506,82);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (650,82);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,83);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,83);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (210,84);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (423,84);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (496,84);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (210,85);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (423,85);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (496,85);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (210,86);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (423,86);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (496,86);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (155,87);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (79,88);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (102,88);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (107,89);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (470,89);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (493,89);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (109,90);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (110,90);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (111,90);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (112,90);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (113,90);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (114,90);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (115,90);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (116,90);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (117,90);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (118,90);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (119,90);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,90);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (121,90);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (122,90);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (123,90);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (124,90);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (453,90);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (459,90);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (460,90);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (461,90);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (462,90);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (463,90);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (465,90);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (503,90);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (127,91);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (279,92);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,93);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (323,93);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (129,94);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (35,95);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (123,95);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (447,95);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (132,96);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (26,97);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (110,97);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (154,98);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (210,99);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (423,99);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (496,99);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,100);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (118,100);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,100);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (323,100);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (25,101);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (109,101);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (118,101);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (168,101);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (453,101);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (459,101);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (453,102);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (467,102);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (34,103);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (121,103);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (102,104);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (138,104);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (139,104);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (142,104);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (102,105);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (142,106);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (142,107);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (35,108);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (123,108);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (142,108);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (142,109);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (142,110);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (142,111);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (150,112);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (152,113);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (102,114);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (112,114);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (151,114);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (153,115);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (154,115);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (155,115);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (156,115);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (25,116);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,116);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (35,116);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (51,116);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (100,116);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (109,116);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,116);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (123,116);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (156,116);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (239,116);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (417,116);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (444,116);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (449,116);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (505,117);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (26,118);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (110,118);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (119,119);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (239,120);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (240,120);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (417,120);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,121);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,121);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (100,122);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,122);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (160,122);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (161,123);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (190,124);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (219,124);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (439,124);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (190,125);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (119,126);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (210,127);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,128);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,128);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (26,129);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (31,129);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,129);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (110,129);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (116,129);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,130);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (35,130);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (52,131);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (107,131);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (219,131);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (346,131);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (364,131);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (439,131);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (591,131);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (621,131);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (439,132);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (26,133);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (110,133);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (165,133);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (648,133);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,134);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (34,134);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (150,134);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (168,134);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (169,134);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (170,134);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (171,134);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (172,134);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (173,134);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (174,134);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (175,134);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (176,134);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (177,134);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (178,134);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (179,134);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (180,134);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (181,134);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (182,134);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (183,135);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (439,136);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (239,137);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,138);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (77,139);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (78,139);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (231,140);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (26,141);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (31,141);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,141);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (110,141);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (116,141);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (323,142);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,143);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,143);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (53,144);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (77,144);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (78,144);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (231,144);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (337,144);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (416,144);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (648,144);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (650,144);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (110,145);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,146);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (34,146);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,146);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (121,146);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (179,146);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (200,146);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (453,146);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (468,146);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (453,147);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (469,147);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (200,148);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (453,149);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (470,149);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (320,150);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (323,151);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (26,152);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (110,152);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (169,152);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (460,152);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (455,153);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (471,153);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (485,153);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (110,154);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (449,155);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,156);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (188,157);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (216,157);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (35,158);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (109,158);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (110,158);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (117,158);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (119,158);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (123,158);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (168,158);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (169,158);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (175,158);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (176,158);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (177,158);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (178,158);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (181,158);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (182,158);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (421,158);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (155,159);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (345,160);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (35,161);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (123,161);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (190,162);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (200,163);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (414,164);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (458,164);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (475,164);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (490,164);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (121,165);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (8,166);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (612,167);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (90,168);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,169);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (194,170);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (323,171);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (453,171);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (458,171);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (216,172);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (121,173);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (83,174);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (33,175);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,175);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (222,175);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (197,176);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (120,177);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (152,177);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (198,178);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (166,179);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (164,180);
INSERT INTO help_relation (help_topic_id,help_keyword_id) VALUES (200,181);
INSERT INTO help_rel