/*
	WRMPWFLS.i
	Copyright (C) 2007 Paul C. Pratt

	You can redistribute this file and/or modify it under the terms
	of version 2 of the GNU General Public License as published by
	the Free Software Foundation.  You should have received a copy
	of the license along with this file; see the file COPYING.

	This file is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	license for more details.
*/

/*
	WRite Macintosh Programmer's Workshop specific FiLeS
*/


LOCALPROC WriteLONGGLUEContents(void)
{
	++DestFileIndent;
		WriteDestFileLn("CASE ON");
		WriteBlankLineToDestFile();
		WriteDestFileLn("IMPORT long_main: CODE ");
		WriteBlankLineToDestFile();
	--DestFileIndent;
	WriteDestFileLn("main PROC EXPORT");
	++DestFileIndent;
		WriteBlankLineToDestFile();
		WriteDestFileLn("JMP (long_main).L");
		WriteBlankLineToDestFile();
		WriteDestFileLn("ENDP");
		WriteBlankLineToDestFile();
		WriteDestFileLn("END");
	--DestFileIndent;
}

LOCALPROC WriteLongGlueObjName(void)
{
	WriteCStrToDestFile("LONGGLUE.o");
}

LOCALPROC WriteLongGlueObjPath(void)
{
	WriteFileInDirToDestFile0(Write_obj_d_ToDestFile,
		WriteLongGlueObjName);
}

LOCALPROC WriteLongGlueSourceName(void)
{
	WriteCStrToDestFile("LONGGLUE.S");
}

LOCALPROC WriteLongGlueSourcePath(void)
{
	WriteFileInDirToDestFile0(Write_cfg_d_ToDestFile,
		WriteLongGlueSourceName);
}

LOCALPROC DoLongGlueMakeCompileDeps(void)
{
	WriteMakeDependFile(WriteLongGlueSourcePath);
}

LOCALPROC DoLongGlueMakeCompileBody(void)
{
	WriteBgnDestFileLn();
	WriteCStrToDestFile("Asm");
	WritePathArgInMakeCmnd(WriteLongGlueSourcePath);
	WriteCStrToDestFile(" -o");
	WritePathArgInMakeCmnd(WriteLongGlueObjPath);
	WriteCStrToDestFile(" -model far");
	WriteEndDestFileLn();
}

LOCALPROC DoSrcFileMPWMakeObjects(void)
{
	WriteBgnDestFileLn();
	WriteQuoteToDestFile();
	WriteSrcFileObjPath();
	WriteQuoteToDestFile();
	WriteCStrToDestFile(" \266");
	WriteEndDestFileLn();
}

static void WriteMPWCOptions(blnr fast)
{
	if (gbk_cpufam_68k == gbo_cpufam) {
		WriteCStrToDestFile(" -proto strict -w 17 -align mac68k -b");
		if (gbk_targ_mfpu == cur_targ) {
			WriteCStrToDestFile(" -mc68020 -mc68881 -elems881");
		}
		if (gbk_dbg_on != gbo_dbg) {
			WriteCStrToDestFile(" -mbg off");
		}
		WriteCStrToDestFile(" -model farCode");
	} else if (gbk_cpufam_ppc == gbo_cpufam) {
		WriteCStrToDestFile(" -proto strict -w 17");
		if (gbk_dbg_on == gbo_dbg) {
			WriteCStrToDestFile(" -traceback");
		}
	}
	if (gbk_dbg_on != gbo_dbg) {
		if (fast) {
			if (gbk_cpufam_68k == gbo_cpufam) {
				WriteCStrToDestFile(" -opt speed");
			} else if (gbk_cpufam_ppc == gbo_cpufam) {
				WriteCStrToDestFile(" -opt speed");
			}
		} else {
			if (gbk_cpufam_68k == gbo_cpufam) {
				WriteCStrToDestFile(" -opt space");
			} else if (gbk_cpufam_ppc == gbo_cpufam) {
				WriteCStrToDestFile(" -opt size");
				/* this may not be reliable? */
			}
		}
	}

	WriteCStrToDestFile(" -i ");
	WriteQuoteToDestFile();
	Write_cfg_d_ToDestFile();
	WriteQuoteToDestFile();

	WriteCStrToDestFile(" -i ");
	WriteQuoteToDestFile();
	Write_src_d_ToDestFile();
	WriteQuoteToDestFile();
}

LOCALPROC WriteMainRsrcObjDeps(void)
{
	WriteMakeDependFile(WriteMainRsrcSrcPath);
}

LOCALPROC WriteMainRsrcObjMPWbody(void)
{
	WriteBgnDestFileLn();
	WriteCStrToDestFile("Rez -t rsrc -c RSED -i \"{RIncludes}\" \"");

	WriteCStrToDestFile(" -i ");
	WriteQuoteToDestFile();
	Write_cfg_d_ToDestFile();
	WriteQuoteToDestFile();

	WriteCStrToDestFile(" -i ");
	WriteQuoteToDestFile();
	Write_src_d_ToDestFile();
	WriteQuoteToDestFile();

	WriteMainRsrcSrcPath();
	WriteCStrToDestFile("\" -o \"");
	WriteMainRsrcObjPath();
	WriteCStrToDestFile("\"");
	WriteEndDestFileLn();
}

LOCALPROC WriteMPWMakeFile(void)
{
	WriteDestFileLn("# make file generated by gryphel build system");

	WriteBlankLineToDestFile();

	WriteBgnDestFileLn();
	WriteCStrToDestFile("mk_COptions =");
	WriteMPWCOptions(falseblnr);
	WriteEndDestFileLn();
	WriteBlankLineToDestFile();

	WriteBlankLineToDestFile();
	WriteBgnDestFileLn();
	WriteCStrToDestFile("TheDefaultOutput \304");
	WriteMakeDependFile(Write_machobinpath_ToDestFile);
	WriteEndDestFileLn();

	WriteBlankLineToDestFile();

	if (gbk_cpufam_68k == gbo_cpufam) {
		WriteMakeRule(WriteLongGlueObjPath,
			DoLongGlueMakeCompileDeps,
			DoLongGlueMakeCompileBody);
	}

	DoAllSrcFilesWithSetup(DoSrcFileMakeCompile);
	WriteBlankLineToDestFile();
	WriteDestFileLn("ObjFiles = \266");
	++DestFileIndent;
		DoAllSrcFilesSortWithSetup(DoSrcFileMPWMakeObjects);
		WriteBlankLineToDestFile();
	--DestFileIndent;

	if (HaveMacBundleApp) {
		WriteBlankLineToDestFile();
		WriteMakeRule(Write_machoAppIconPath,
			Write_tmachoShellDeps,
			Write_tmachoShell);
	}

	WriteBlankLineToDestFile();
	WriteBgnDestFileLn();
	WriteCStrToDestFile("\"");
	Write_machobinpath_ToDestFile();
	WriteCStrToDestFile("\" \304");
	WriteCStrToDestFile(" {ObjFiles}");
	if (HaveMacBundleApp) {
		WriteMakeDependFile(Write_machoAppIconPath);
	} else {
		WriteMakeDependFile(WriteMainRsrcObjPath);
	}
	if (gbk_cpufam_68k == gbo_cpufam) {
		WritePathArgInMakeCmnd(WriteLongGlueObjPath);
	}
	WriteEndDestFileLn();
	++DestFileIndent;
		if (HaveMacRrscs) {
			WriteBgnDestFileLn();
			WriteCStrToDestFile("Duplicate -y \"");
			WriteMainRsrcObjPath();
			WriteCStrToDestFile("\" \"");
			Write_machobinpath_ToDestFile();
			WriteCStrToDestFile("\"");
			WriteEndDestFileLn();
		}

		WriteBgnDestFileLn();
			if (gbk_cpufam_68k == gbo_cpufam) {
				WriteCStrToDestFile("Link");
				if (gbk_dbg_on != gbo_dbg) {
					WriteCStrToDestFile(" -rn");
				}
				WriteCStrToDestFile(
					" -model far -sg Main"
					"=STDCLIB,SANELIB,CSANELib,SADEV,STDIO");
			} else if (gbk_cpufam_ppc == gbo_cpufam) {
				WriteCStrToDestFile("PPCLink");
			}

			if (gbk_targ_carb == cur_targ) {
				WriteCStrToDestFile(" -m main");
			}
			WriteCStrToDestFile(" -t APPL -c ");
			WriteCStrToDestFile(kMacCreatorSig);
			WriteCStrToDestFile(" \266");
		WriteEndDestFileLn();

		++DestFileIndent;

			WriteDestFileLn("{ObjFiles} \266");

			if (gbk_targ_carb == cur_targ) {
				WriteDestFileLn("\"{SharedLibraries}CarbonLib\" \266");
#if UseOpenGLinOSX
				WriteDestFileLn(
					"\"{SharedLibraries}OpenGLLibraryStub\" \266");
#endif
				WriteDestFileLn("\"{PPCLibraries}PPCToolLibs.o\" \266");
				WriteDestFileLn("\"{PPCLibraries}PPCCRuntime.o\" \266");
				WriteDestFileLn("\"{SharedLibraries}StdCLib\" \266");
			} else if (gbk_targ_mppc == cur_targ) {
				WriteDestFileLn("\"{PPCLibraries}PPCToolLibs.o\" \266");
				WriteDestFileLn("\"{PPCLibraries}PPCCRuntime.o\" \266");
				WriteDestFileLn("\"{PPCLibraries}StdCRuntime.o\" \266");
				WriteDestFileLn(
					"\"{SharedLibraries}InterfaceLib\" \266");
				WriteDestFileLn("\"{SharedLibraries}MathLib\" \266");
				WriteDestFileLn("\"{SharedLibraries}StdCLib\" \266");
				WriteDestFileLn("-weaklib AppearanceLib \266");
				WriteDestFileLn(
					"\"{SharedLibraries}AppearanceLib\" \266");
				WriteDestFileLn("-weaklib MenusLib \266");
				WriteDestFileLn("\"{SharedLibraries}MenusLib\" \266");
				WriteDestFileLn("-weaklib NavigationLib \266");
				WriteDestFileLn(
					"\"{SharedLibraries}NavigationLib\" \266");
				WriteDestFileLn("-weaklib DragLib \266");
				WriteDestFileLn("\"{SharedLibraries}DragLib\" \266");
				WriteDestFileLn("-weaklib WindowsLib \266");
				WriteDestFileLn("\"{SharedLibraries}WindowsLib\" \266");
			} else if (gbk_targ_m68k == cur_targ) {
				WriteDestFileLn("\"{Libraries}Interface.o\" \266");
				WriteDestFileLn("\"{Libraries}Navigation.o\" \266");
				WriteDestFileLn("\"{Libraries}MacRuntime.o\" \266");
				/* WriteDestFileLn("\"{Libraries}MathLib.o\" \266"); */
			} else if (gbk_targ_mfpu == cur_targ) {
				WriteDestFileLn("\"{Libraries}Interface.o\" \266");
				WriteDestFileLn("\"{Libraries}Navigation.o\" \266");
				WriteDestFileLn("\"{Libraries}MacRuntime.o\" \266");
				/*
					WriteDestFileLn("\"{Libraries}MathLib881.o\" \266");
				*/
			}
			if (gbk_cpufam_68k == gbo_cpufam) {
				WriteBgnDestFileLn();
				WriteQuoteToDestFile();
				WriteLongGlueObjPath();
				WriteQuoteToDestFile();
				WriteCStrToDestFile(" \266");
				WriteEndDestFileLn();
			}

			WriteBgnDestFileLn();
			WriteCStrToDestFile("-o");
			WritePathArgInMakeCmnd(Write_machobinpath_ToDestFile);
			WriteEndDestFileLn();
		--DestFileIndent;

		WriteBgnDestFileLn();
		WriteCStrToDestFile("SetFile -d . -m .");
		if (! HaveMacBundleApp) {
			WriteCStrToDestFile(" -a B");
		}
		WriteCStrToDestFile(" \"");
		Write_machobinpath_ToDestFile();
		WriteCStrToDestFile("\"");
		WriteEndDestFileLn();
	--DestFileIndent;

	if (HaveMacRrscs) {
		WriteBlankLineToDestFile();
		WriteMakeRule(WriteMainRsrcObjPath,
			WriteMainRsrcObjDeps, WriteMainRsrcObjMPWbody);
	}

	WriteBlankLineToDestFile();
	WriteDestFileLn("clean \304");
	++DestFileIndent;
		WriteDestFileLn("Delete -i {ObjFiles}");
		if (HaveMacBundleApp) {
			WriteRmDir(WriteAppNamePath);
		} else {
			WriteRmFile(WriteAppNamePath);
			WriteRmFile(WriteMainRsrcObjPath);
		}
	--DestFileIndent;
	WriteBlankLineToDestFile();
}

LOCALPROC WriteMPWSpecificFiles(void)
{
	if (gbk_cpufam_68k == gbo_cpufam) {
		WriteADstFile1("my_config_d",
			"LONGGLUE", ".S", "entry point glue for large program",
			WriteLONGGLUEContents);
	}

	if (HaveMacBundleApp) {
		WritePListData();
	}

	WriteADstFile1("my_project_d",
		"Makefile", "", "Make file",
		WriteMPWMakeFile);
}
