/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler;

import java.util.ArrayList;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.springframework.boot.cli.compiler.AstUtils;
import org.springframework.core.annotation.Order;

@Order(value=-2147483348)
public class GroovyBeansTransformation
implements ASTTransformation {
    public static final int ORDER = -2147483348;

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        for (ASTNode node : nodes) {
            if (!(node instanceof ModuleNode)) continue;
            ModuleNode module = (ModuleNode)node;
            for (ClassNode classNode : new ArrayList<ClassNode>(module.getClasses())) {
                if (!classNode.isScript()) continue;
                classNode.visitContents(new ClassVisitor(source, classNode));
            }
        }
    }

    private class ClassVisitor
    extends ClassCodeVisitorSupport {
        private static final String SOURCE_INTERFACE = "org.springframework.boot.BeanDefinitionLoader.GroovyBeanDefinitionSource";
        private static final String BEANS = "beans";
        private final SourceUnit source;
        private final ClassNode classNode;
        private boolean xformed = false;

        ClassVisitor(SourceUnit source, ClassNode classNode) {
            this.source = source;
            this.classNode = classNode;
        }

        @Override
        protected SourceUnit getSourceUnit() {
            return this.source;
        }

        @Override
        public void visitBlockStatement(BlockStatement block) {
            if (block.isEmpty() || this.xformed) {
                return;
            }
            ClosureExpression closure = this.beans(block);
            if (closure != null) {
                this.classNode.addInterface(ClassHelper.make(SOURCE_INTERFACE));
                this.classNode.addProperty(new PropertyNode(BEANS, 17, ClassHelper.CLOSURE_TYPE.getPlainNodeReference(), this.classNode, closure, null, null));
                this.xformed = true;
            }
        }

        private ClosureExpression beans(BlockStatement block) {
            return AstUtils.getClosure(block, BEANS, true);
        }
    }
}

