/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

class CharacterSetUTFE
extends CharacterSet
implements CharacterRepConstants {
    static final int MAXBYTEPERCHAR = 4;
    static byte[][] utf8m2utfe = new byte[][]{{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15}, {16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31}, {64, 90, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97}, {-16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111}, {124, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42}, {-41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, -83, -32, -67, 95, 109}, {121, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106}, {-105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, -64, 79, -48, -95, 7}, {32, 33, 34, 35, 36, 37, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27}, {48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1}, {65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 81, 82, 83, 84, 85, 86}, {87, 88, 89, 98, 99, 100, 101, 102, 103, 104, 105, 106, 112, 113, 114, 115}, {116, 117, 118, 119, 120, -128, -118, -117, -116, -115, -114, -113, -112, -102, -101, -100}, {-99, -98, -97, -96, -86, -85, -84, -82, -81, -80, -79, -78, -77, -76, -75, -74}, {-73, -72, -71, -70, -69, -68, -66, -65, -54, -53, -52, -51, -50, -49, -38, -37}, {-36, -35, -34, -33, -31, -22, -21, -20, -19, -18, -17, -6, -5, -4, -3, -2}};
    static byte[][] utfe2utf8m = new byte[][]{{0, 1, 2, 3, -100, 9, -122, 127, -105, -115, -114, 11, 12, 13, 14, 15}, {16, 17, 18, 19, -99, 10, 8, -121, 24, 25, -110, -113, 28, 29, 30, 31}, {-128, -127, -126, -125, -124, -123, 23, 27, -120, -119, -118, -117, -116, 5, 6, 7}, {-112, -111, 22, -109, -108, -107, -106, 4, -104, -103, -102, -101, 20, 21, -98, 26}, {32, -96, -95, -94, -93, -92, -91, -90, -89, -88, -87, 46, 60, 40, 43, 124}, {38, -86, -85, -84, -83, -82, -81, -80, -79, -78, 33, 36, 42, 41, 59, 94}, {45, 47, -77, -76, -75, -74, -73, -72, -71, -70, -69, 44, 37, 95, 62, 63}, {-68, -67, -66, -65, -64, -63, -62, -61, -60, 96, 58, 35, 64, 39, 61, 34}, {-59, 97, 98, 99, 100, 101, 102, 103, 104, 105, -58, -57, -56, -55, -54, -53}, {-52, 106, 107, 108, 109, 110, 111, 112, 113, 114, -51, -50, -49, -48, -47, -46}, {-45, 126, 115, 116, 117, 118, 119, 120, 121, 122, -44, -43, -42, 88, -41, -40}, {-39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, 93, -26, -25}, {123, 65, 66, 67, 68, 69, 70, 71, 72, 73, -24, -23, -22, -21, -20, -19}, {13, 74, 75, 76, 77, 78, 79, 80, 81, 82, -18, -17, -16, -15, -14, -13}, {92, -12, 83, 84, 85, 86, 87, 88, 89, 90, -11, -10, -9, -8, -7, -6}, {48, 49, 50, 51, 52, 53, 54, 55, 56, 57, -5, -4, -3, -2, -1, -97}};
    private static int[] m_byteLen = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 2, 2, 3, 4};
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    CharacterSetUTFE(int n2) {
        super(n2);
        this.rep = 3;
    }

    @Override
    public boolean isLossyFrom(CharacterSet characterSet) {
        return !characterSet.isUnicode();
    }

    @Override
    public boolean isConvertibleFrom(CharacterSet characterSet) {
        boolean bl = characterSet.rep <= 1024;
        return bl;
    }

    @Override
    public boolean isUnicode() {
        return true;
    }

    @Override
    public String toString(byte[] byArray, int n2, int n3) throws SQLException {
        char[] cArray = new char[byArray.length];
        int n4 = this.UTFEToJavaChar(byArray, n2, n3, cArray, CharacterSet.CharacterConverterBehavior.REPORT_ERROR);
        return new String(cArray, 0, n4);
    }

    @Override
    public String toStringWithReplacement(byte[] byArray, int n2, int n3) {
        try {
            char[] cArray = new char[byArray.length];
            int n4 = this.UTFEToJavaChar(byArray, n2, n3, cArray, CharacterSet.CharacterConverterBehavior.REPLACEMENT);
            return new String(cArray, 0, n4);
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException(sQLException.getMessage());
        }
    }

    int UTFEToJavaChar(byte[] byArray, int n2, int n3, char[] cArray, CharacterSet.CharacterConverterBehavior characterConverterBehavior) throws SQLException {
        int n4 = n2;
        int n5 = n2 + n3;
        int n6 = 0;
        block7: while (n4 < n5) {
            byte by = utfe2utf8m[CharacterSetUTFE.high(byArray[n4])][CharacterSetUTFE.low(byArray[n4++])];
            switch (by >>> 4 & 0xF) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n6++] = (char)(by & 0x7F);
                    continue block7;
                }
                case 8: 
                case 9: {
                    cArray[n6++] = (char)(by & 0x1F);
                    continue block7;
                }
                case 12: 
                case 13: {
                    if (n4 >= n5) {
                        characterConverterBehavior.onFailConversion();
                        n4 = n5;
                        continue block7;
                    }
                    by = (byte)(by & 0x1F);
                    byte by2 = utfe2utf8m[CharacterSetUTFE.high(byArray[n4])][CharacterSetUTFE.low(byArray[n4++])];
                    if (!CharacterSetUTFE.is101xxxxx(by2)) {
                        characterConverterBehavior.onFailConversion();
                        cArray[n6++] = 65533;
                        continue block7;
                    }
                    cArray[n6++] = (char)(by << 5 | by2 & 0x1F);
                    continue block7;
                }
                case 14: {
                    if (n4 + 1 >= n5) {
                        characterConverterBehavior.onFailConversion();
                        n4 = n5;
                        continue block7;
                    }
                    by = (byte)(by & 0xF);
                    byte by2 = utfe2utf8m[CharacterSetUTFE.high(byArray[n4])][CharacterSetUTFE.low(byArray[n4++])];
                    byte by3 = utfe2utf8m[CharacterSetUTFE.high(byArray[n4])][CharacterSetUTFE.low(byArray[n4++])];
                    if (!CharacterSetUTFE.is101xxxxx(by2) || !CharacterSetUTFE.is101xxxxx(by3)) {
                        characterConverterBehavior.onFailConversion();
                        cArray[n6++] = 65533;
                        continue block7;
                    }
                    cArray[n6++] = (char)(by << 10 | (by2 & 0x1F) << 5 | by3 & 0x1F);
                    continue block7;
                }
                case 15: {
                    if (n4 + 2 >= n5) {
                        characterConverterBehavior.onFailConversion();
                        n4 = n5;
                        continue block7;
                    }
                    by = (byte)(by & 1);
                    byte by2 = utfe2utf8m[CharacterSetUTFE.high(byArray[n4])][CharacterSetUTFE.low(byArray[n4++])];
                    byte by3 = utfe2utf8m[CharacterSetUTFE.high(byArray[n4])][CharacterSetUTFE.low(byArray[n4++])];
                    byte by4 = utfe2utf8m[CharacterSetUTFE.high(byArray[n4])][CharacterSetUTFE.low(byArray[n4++])];
                    if (!(CharacterSetUTFE.is101xxxxx(by2) && CharacterSetUTFE.is101xxxxx(by3) && CharacterSetUTFE.is101xxxxx(by4))) {
                        characterConverterBehavior.onFailConversion();
                        cArray[n6++] = 65533;
                        continue block7;
                    }
                    cArray[n6++] = (char)(by << 15 | (by2 & 0x1F) << 10 | (by3 & 0x1F) << 5 | by4 & 0x1F);
                    continue block7;
                }
            }
            characterConverterBehavior.onFailConversion();
            cArray[n6++] = 65533;
        }
        return n6;
    }

    @Override
    public byte[] convertWithReplacement(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length * 4];
        int n2 = this.javaCharsToUTFE(cArray, 0, cArray.length, byArray, 0);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    @Override
    public byte[] convert(String string) throws SQLException {
        return this.convertWithReplacement(string);
    }

    @Override
    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n2, int n3) throws SQLException {
        byte[] byArray2;
        if (characterSet.rep == 3) {
            byArray2 = CharacterSetUTFE.useOrCopy(byArray, n2, n3);
        } else {
            String string = characterSet.toString(byArray, n2, n3);
            byArray2 = this.convert(string);
        }
        return byArray2;
    }

    int javaCharsToUTFE(char[] cArray, int n2, int n3, byte[] byArray, int n4) {
        int n5 = n2 + n3;
        int n6 = 0;
        for (int i2 = n2; i2 < n5; ++i2) {
            int n7;
            char c2 = cArray[i2];
            if (c2 <= '\u001f') {
                n7 = c2 | 0x80;
                byArray[n6++] = utf8m2utfe[CharacterSetUTFE.high(n7)][CharacterSetUTFE.low(n7)];
                continue;
            }
            if (c2 <= '\u007f') {
                byArray[n6++] = utf8m2utfe[CharacterSetUTFE.high(c2)][CharacterSetUTFE.low(c2)];
                continue;
            }
            if (c2 <= '\u03ff') {
                n7 = (c2 & 0x3E0) >> 5 | 0xC0;
                byArray[n6++] = utf8m2utfe[CharacterSetUTFE.high(n7)][CharacterSetUTFE.low(n7)];
                n7 = c2 & 0x1F | 0xA0;
                byArray[n6++] = utf8m2utfe[CharacterSetUTFE.high(n7)][CharacterSetUTFE.low(n7)];
                continue;
            }
            if (c2 <= '\u3fff') {
                n7 = (c2 & 0x3C00) >> 10 | 0xE0;
                byArray[n6++] = utf8m2utfe[CharacterSetUTFE.high(n7)][CharacterSetUTFE.low(n7)];
                n7 = (c2 & 0x3E0) >> 5 | 0xA0;
                byArray[n6++] = utf8m2utfe[CharacterSetUTFE.high(n7)][CharacterSetUTFE.low(n7)];
                n7 = c2 & 0x1F | 0xA0;
                byArray[n6++] = utf8m2utfe[CharacterSetUTFE.high(n7)][CharacterSetUTFE.low(n7)];
                continue;
            }
            n7 = (c2 & 0x8000) >> 15 | 0xF0;
            byArray[n6++] = utf8m2utfe[CharacterSetUTFE.high(n7)][CharacterSetUTFE.low(n7)];
            n7 = (c2 & 0x7C00) >> 10 | 0xA0;
            byArray[n6++] = utf8m2utfe[CharacterSetUTFE.high(n7)][CharacterSetUTFE.low(n7)];
            n7 = (c2 & 0x3E0) >> 5 | 0xA0;
            byArray[n6++] = utf8m2utfe[CharacterSetUTFE.high(n7)][CharacterSetUTFE.low(n7)];
            n7 = c2 & 0x1F | 0xA0;
            byArray[n6++] = utf8m2utfe[CharacterSetUTFE.high(n7)][CharacterSetUTFE.low(n7)];
        }
        return n6;
    }

    @Override
    int decode(CharacterWalker characterWalker) throws SQLException {
        byte by;
        int n2;
        byte[] byArray = characterWalker.bytes;
        int n3 = characterWalker.next;
        int n4 = characterWalker.end;
        int n5 = 0;
        if (n3 >= n4) {
            CharacterSetUTFE.failUTFConversion();
        }
        if ((n2 = CharacterSetUTFE.getUTFByteLength(by = byArray[n3])) == 0 || n3 + (n2 - 1) >= n4) {
            CharacterSetUTFE.failUTFConversion();
        }
        try {
            char[] cArray = new char[2];
            int n6 = this.UTFEToJavaChar(byArray, n3, n2, cArray, CharacterSet.CharacterConverterBehavior.REPORT_ERROR);
            characterWalker.next += n2;
            if (n6 == 1) {
                return cArray[0];
            }
            return cArray[0] << 16 | cArray[1];
        }
        catch (SQLException sQLException) {
            CharacterSetUTFE.failUTFConversion();
            characterWalker.next = n3;
            return n5;
        }
    }

    @Override
    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        if ((n2 & 0xFFFF0000) != 0) {
            CharacterSetUTFE.failUTFConversion();
        } else if (n2 <= 31) {
            CharacterSetUTFE.need(characterBuffer, 1);
            int n3 = n2 | 0x80;
            characterBuffer.bytes[characterBuffer.next++] = utf8m2utfe[CharacterSetUTFE.high(n3)][CharacterSetUTFE.low(n3)];
        } else if (n2 <= 127) {
            CharacterSetUTFE.need(characterBuffer, 1);
            characterBuffer.bytes[characterBuffer.next++] = utf8m2utfe[CharacterSetUTFE.high(n2)][CharacterSetUTFE.low(n2)];
        } else if (n2 <= 1023) {
            CharacterSetUTFE.need(characterBuffer, 2);
            int n4 = (n2 & 0x3E0) >> 5 | 0xC0;
            characterBuffer.bytes[characterBuffer.next++] = utf8m2utfe[CharacterSetUTFE.high(n4)][CharacterSetUTFE.low(n4)];
            n4 = n2 & 0x1F | 0xA0;
            characterBuffer.bytes[characterBuffer.next++] = utf8m2utfe[CharacterSetUTFE.high(n4)][CharacterSetUTFE.low(n4)];
        } else if (n2 <= 16383) {
            CharacterSetUTFE.need(characterBuffer, 3);
            int n5 = (n2 & 0x3C00) >> 10 | 0xE0;
            characterBuffer.bytes[characterBuffer.next++] = utf8m2utfe[CharacterSetUTFE.high(n5)][CharacterSetUTFE.low(n5)];
            n5 = (n2 & 0x3E0) >> 5 | 0xA0;
            characterBuffer.bytes[characterBuffer.next++] = utf8m2utfe[CharacterSetUTFE.high(n5)][CharacterSetUTFE.low(n5)];
            n5 = n2 & 0x1F | 0xA0;
            characterBuffer.bytes[characterBuffer.next++] = utf8m2utfe[CharacterSetUTFE.high(n5)][CharacterSetUTFE.low(n5)];
        } else {
            CharacterSetUTFE.need(characterBuffer, 4);
            int n6 = (n2 & 0x8000) >> 15 | 0xF0;
            characterBuffer.bytes[characterBuffer.next++] = utf8m2utfe[CharacterSetUTFE.high(n6)][CharacterSetUTFE.low(n6)];
            n6 = (n2 & 0x7C00) >> 10 | 0xA0;
            characterBuffer.bytes[characterBuffer.next++] = utf8m2utfe[CharacterSetUTFE.high(n6)][CharacterSetUTFE.low(n6)];
            n6 = (n2 & 0x3E0) >> 5 | 0xA0;
            characterBuffer.bytes[characterBuffer.next++] = utf8m2utfe[CharacterSetUTFE.high(n6)][CharacterSetUTFE.low(n6)];
            n6 = n2 & 0x1F | 0xA0;
            characterBuffer.bytes[characterBuffer.next++] = utf8m2utfe[CharacterSetUTFE.high(n6)][CharacterSetUTFE.low(n6)];
        }
    }

    private static int high(int n2) {
        return n2 >> 4 & 0xF;
    }

    private static int low(int n2) {
        return n2 & 0xF;
    }

    private static boolean is101xxxxx(byte by) {
        return (by & 0xFFFFFFE0) == -96;
    }

    private static int getUTFByteLength(byte by) {
        return m_byteLen[utfe2utf8m[CharacterSetUTFE.high(by)][CharacterSetUTFE.low(by)] >>> 4 & 0xF];
    }
}

