%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  
%  This file is part of VivoMind Prolog Unicode Resources  
%  
%  VivoMind Prolog Unicode Resources is free software distributed using the
%  Creative Commons CC0 1.0 Universal (CC0 1.0) - Public Domain Dedication
%  license
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%  Last modified: September 30, 2012
%
%  Original Unicode file header comments follow

/*
# DerivedCoreProperties-6.1.0.txt
# Date: 2011-12-11, 18:26:55 GMT [MD]
#
# Unicode Character Database
# Copyright (c) 1991-2011 Unicode, Inc.
# For terms of use, see http://www.unicode.org/terms_of_use.html
# For documentation, see http://www.unicode.org/reports/tr44/

% ================================================
*/

unicode_id_start(CodePoint) :-
	(	var(CodePoint) ->
		% generate code point pairs
		unicode_id_start(CodePointStart, CodePointEnd),
		between(CodePointStart, CodePointEnd, CodePoint)
	;	% try first-argument indexing first
		unicode_id_start(CodePoint, _) ->
		true
	;	% look for a code point range that includes the given code point
		unicode_id_start(CodePointStart, CodePointEnd),
		between(CodePointStart, CodePointEnd, CodePoint) ->
		true
	).

% ================================================

% Derived Property: ID_Start
%  Characters that can start an identifier.
%  Generated from:
%      Lu + Ll + Lt + Lm + Lo + Nl
%    + Other_ID_Start
%    - Pattern_Syntax
%    - Pattern_White_Space
%  NOTE: See UAX #31 for more information

unicode_id_start(0x0041, 0x005A).	% ID_Start L&  [26] LATIN CAPITAL LETTER A..LATIN CAPITAL LETTER Z
unicode_id_start(0x0061, 0x007A).	% ID_Start L&  [26] LATIN SMALL LETTER A..LATIN SMALL LETTER Z
unicode_id_start(0x00AA, 0x00AA).	% ID_Start Lo       FEMININE ORDINAL INDICATOR
unicode_id_start(0x00B5, 0x00B5).	% ID_Start L&       MICRO SIGN
unicode_id_start(0x00BA, 0x00BA).	% ID_Start Lo       MASCULINE ORDINAL INDICATOR
unicode_id_start(0x00C0, 0x00D6).	% ID_Start L&  [23] LATIN CAPITAL LETTER A WITH GRAVE..LATIN CAPITAL LETTER O WITH DIAERESIS
unicode_id_start(0x00D8, 0x00F6).	% ID_Start L&  [31] LATIN CAPITAL LETTER O WITH STROKE..LATIN SMALL LETTER O WITH DIAERESIS
unicode_id_start(0x00F8, 0x01BA).	% ID_Start L& [195] LATIN SMALL LETTER O WITH STROKE..LATIN SMALL LETTER EZH WITH TAIL
unicode_id_start(0x01BB, 0x01BB).	% ID_Start Lo       LATIN LETTER TWO WITH STROKE
unicode_id_start(0x01BC, 0x01BF).	% ID_Start L&   [4] LATIN CAPITAL LETTER TONE FIVE..LATIN LETTER WYNN
unicode_id_start(0x01C0, 0x01C3).	% ID_Start Lo   [4] LATIN LETTER DENTAL CLICK..LATIN LETTER RETROFLEX CLICK
unicode_id_start(0x01C4, 0x0293).	% ID_Start L& [208] LATIN CAPITAL LETTER DZ WITH CARON..LATIN SMALL LETTER EZH WITH CURL
unicode_id_start(0x0294, 0x0294).	% ID_Start Lo       LATIN LETTER GLOTTAL STOP
unicode_id_start(0x0295, 0x02AF).	% ID_Start L&  [27] LATIN LETTER PHARYNGEAL VOICED FRICATIVE..LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL
unicode_id_start(0x02B0, 0x02C1).	% ID_Start Lm  [18] MODIFIER LETTER SMALL H..MODIFIER LETTER REVERSED GLOTTAL STOP
unicode_id_start(0x02C6, 0x02D1).	% ID_Start Lm  [12] MODIFIER LETTER CIRCUMFLEX ACCENT..MODIFIER LETTER HALF TRIANGULAR COLON
unicode_id_start(0x02E0, 0x02E4).	% ID_Start Lm   [5] MODIFIER LETTER SMALL GAMMA..MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
unicode_id_start(0x02EC, 0x02EC).	% ID_Start Lm       MODIFIER LETTER VOICING
unicode_id_start(0x02EE, 0x02EE).	% ID_Start Lm       MODIFIER LETTER DOUBLE APOSTROPHE
unicode_id_start(0x0370, 0x0373).	% ID_Start L&   [4] GREEK CAPITAL LETTER HETA..GREEK SMALL LETTER ARCHAIC SAMPI
unicode_id_start(0x0374, 0x0374).	% ID_Start Lm       GREEK NUMERAL SIGN
unicode_id_start(0x0376, 0x0377).	% ID_Start L&   [2] GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA..GREEK SMALL LETTER PAMPHYLIAN DIGAMMA
unicode_id_start(0x037A, 0x037A).	% ID_Start Lm       GREEK YPOGEGRAMMENI
unicode_id_start(0x037B, 0x037D).	% ID_Start L&   [3] GREEK SMALL REVERSED LUNATE SIGMA SYMBOL..GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL
unicode_id_start(0x0386, 0x0386).	% ID_Start L&       GREEK CAPITAL LETTER ALPHA WITH TONOS
unicode_id_start(0x0388, 0x038A).	% ID_Start L&   [3] GREEK CAPITAL LETTER EPSILON WITH TONOS..GREEK CAPITAL LETTER IOTA WITH TONOS
unicode_id_start(0x038C, 0x038C).	% ID_Start L&       GREEK CAPITAL LETTER OMICRON WITH TONOS
unicode_id_start(0x038E, 0x03A1).	% ID_Start L&  [20] GREEK CAPITAL LETTER UPSILON WITH TONOS..GREEK CAPITAL LETTER RHO
unicode_id_start(0x03A3, 0x03F5).	% ID_Start L&  [83] GREEK CAPITAL LETTER SIGMA..GREEK LUNATE EPSILON SYMBOL
unicode_id_start(0x03F7, 0x0481).	% ID_Start L& [139] GREEK CAPITAL LETTER SHO..CYRILLIC SMALL LETTER KOPPA
unicode_id_start(0x048A, 0x0527).	% ID_Start L& [158] CYRILLIC CAPITAL LETTER SHORT I WITH TAIL..CYRILLIC SMALL LETTER SHHA WITH DESCENDER
unicode_id_start(0x0531, 0x0556).	% ID_Start L&  [38] ARMENIAN CAPITAL LETTER AYB..ARMENIAN CAPITAL LETTER FEH
unicode_id_start(0x0559, 0x0559).	% ID_Start Lm       ARMENIAN MODIFIER LETTER LEFT HALF RING
unicode_id_start(0x0561, 0x0587).	% ID_Start L&  [39] ARMENIAN SMALL LETTER AYB..ARMENIAN SMALL LIGATURE ECH YIWN
unicode_id_start(0x05D0, 0x05EA).	% ID_Start Lo  [27] HEBREW LETTER ALEF..HEBREW LETTER TAV
unicode_id_start(0x05F0, 0x05F2).	% ID_Start Lo   [3] HEBREW LIGATURE YIDDISH DOUBLE VAV..HEBREW LIGATURE YIDDISH DOUBLE YOD
unicode_id_start(0x0620, 0x063F).	% ID_Start Lo  [32] ARABIC LETTER KASHMIRI YEH..ARABIC LETTER FARSI YEH WITH THREE DOTS ABOVE
unicode_id_start(0x0640, 0x0640).	% ID_Start Lm       ARABIC TATWEEL
unicode_id_start(0x0641, 0x064A).	% ID_Start Lo  [10] ARABIC LETTER FEH..ARABIC LETTER YEH
unicode_id_start(0x066E, 0x066F).	% ID_Start Lo   [2] ARABIC LETTER DOTLESS BEH..ARABIC LETTER DOTLESS QAF
unicode_id_start(0x0671, 0x06D3).	% ID_Start Lo  [99] ARABIC LETTER ALEF WASLA..ARABIC LETTER YEH BARREE WITH HAMZA ABOVE
unicode_id_start(0x06D5, 0x06D5).	% ID_Start Lo       ARABIC LETTER AE
unicode_id_start(0x06E5, 0x06E6).	% ID_Start Lm   [2] ARABIC SMALL WAW..ARABIC SMALL YEH
unicode_id_start(0x06EE, 0x06EF).	% ID_Start Lo   [2] ARABIC LETTER DAL WITH INVERTED V..ARABIC LETTER REH WITH INVERTED V
unicode_id_start(0x06FA, 0x06FC).	% ID_Start Lo   [3] ARABIC LETTER SHEEN WITH DOT BELOW..ARABIC LETTER GHAIN WITH DOT BELOW
unicode_id_start(0x06FF, 0x06FF).	% ID_Start Lo       ARABIC LETTER HEH WITH INVERTED V
unicode_id_start(0x0710, 0x0710).	% ID_Start Lo       SYRIAC LETTER ALAPH
unicode_id_start(0x0712, 0x072F).	% ID_Start Lo  [30] SYRIAC LETTER BETH..SYRIAC LETTER PERSIAN DHALATH
unicode_id_start(0x074D, 0x07A5).	% ID_Start Lo  [89] SYRIAC LETTER SOGDIAN ZHAIN..THAANA LETTER WAAVU
unicode_id_start(0x07B1, 0x07B1).	% ID_Start Lo       THAANA LETTER NAA
unicode_id_start(0x07CA, 0x07EA).	% ID_Start Lo  [33] NKO LETTER A..NKO LETTER JONA RA
unicode_id_start(0x07F4, 0x07F5).	% ID_Start Lm   [2] NKO HIGH TONE APOSTROPHE..NKO LOW TONE APOSTROPHE
unicode_id_start(0x07FA, 0x07FA).	% ID_Start Lm       NKO LAJANYALAN
unicode_id_start(0x0800, 0x0815).	% ID_Start Lo  [22] SAMARITAN LETTER ALAF..SAMARITAN LETTER TAAF
unicode_id_start(0x081A, 0x081A).	% ID_Start Lm       SAMARITAN MODIFIER LETTER EPENTHETIC YUT
unicode_id_start(0x0824, 0x0824).	% ID_Start Lm       SAMARITAN MODIFIER LETTER SHORT A
unicode_id_start(0x0828, 0x0828).	% ID_Start Lm       SAMARITAN MODIFIER LETTER I
unicode_id_start(0x0840, 0x0858).	% ID_Start Lo  [25] MANDAIC LETTER HALQA..MANDAIC LETTER AIN
unicode_id_start(0x08A0, 0x08A0).	% ID_Start Lo       ARABIC LETTER BEH WITH SMALL V BELOW
unicode_id_start(0x08A2, 0x08AC).	% ID_Start Lo  [11] ARABIC LETTER JEEM WITH TWO DOTS ABOVE..ARABIC LETTER ROHINGYA YEH
unicode_id_start(0x0904, 0x0939).	% ID_Start Lo  [54] DEVANAGARI LETTER SHORT A..DEVANAGARI LETTER HA
unicode_id_start(0x093D, 0x093D).	% ID_Start Lo       DEVANAGARI SIGN AVAGRAHA
unicode_id_start(0x0950, 0x0950).	% ID_Start Lo       DEVANAGARI OM
unicode_id_start(0x0958, 0x0961).	% ID_Start Lo  [10] DEVANAGARI LETTER QA..DEVANAGARI LETTER VOCALIC LL
unicode_id_start(0x0971, 0x0971).	% ID_Start Lm       DEVANAGARI SIGN HIGH SPACING DOT
unicode_id_start(0x0972, 0x0977).	% ID_Start Lo   [6] DEVANAGARI LETTER CANDRA A..DEVANAGARI LETTER UUE
unicode_id_start(0x0979, 0x097F).	% ID_Start Lo   [7] DEVANAGARI LETTER ZHA..DEVANAGARI LETTER BBA
unicode_id_start(0x0985, 0x098C).	% ID_Start Lo   [8] BENGALI LETTER A..BENGALI LETTER VOCALIC L
unicode_id_start(0x098F, 0x0990).	% ID_Start Lo   [2] BENGALI LETTER E..BENGALI LETTER AI
unicode_id_start(0x0993, 0x09A8).	% ID_Start Lo  [22] BENGALI LETTER O..BENGALI LETTER NA
unicode_id_start(0x09AA, 0x09B0).	% ID_Start Lo   [7] BENGALI LETTER PA..BENGALI LETTER RA
unicode_id_start(0x09B2, 0x09B2).	% ID_Start Lo       BENGALI LETTER LA
unicode_id_start(0x09B6, 0x09B9).	% ID_Start Lo   [4] BENGALI LETTER SHA..BENGALI LETTER HA
unicode_id_start(0x09BD, 0x09BD).	% ID_Start Lo       BENGALI SIGN AVAGRAHA
unicode_id_start(0x09CE, 0x09CE).	% ID_Start Lo       BENGALI LETTER KHANDA TA
unicode_id_start(0x09DC, 0x09DD).	% ID_Start Lo   [2] BENGALI LETTER RRA..BENGALI LETTER RHA
unicode_id_start(0x09DF, 0x09E1).	% ID_Start Lo   [3] BENGALI LETTER YYA..BENGALI LETTER VOCALIC LL
unicode_id_start(0x09F0, 0x09F1).	% ID_Start Lo   [2] BENGALI LETTER RA WITH MIDDLE DIAGONAL..BENGALI LETTER RA WITH LOWER DIAGONAL
unicode_id_start(0x0A05, 0x0A0A).	% ID_Start Lo   [6] GURMUKHI LETTER A..GURMUKHI LETTER UU
unicode_id_start(0x0A0F, 0x0A10).	% ID_Start Lo   [2] GURMUKHI LETTER EE..GURMUKHI LETTER AI
unicode_id_start(0x0A13, 0x0A28).	% ID_Start Lo  [22] GURMUKHI LETTER OO..GURMUKHI LETTER NA
unicode_id_start(0x0A2A, 0x0A30).	% ID_Start Lo   [7] GURMUKHI LETTER PA..GURMUKHI LETTER RA
unicode_id_start(0x0A32, 0x0A33).	% ID_Start Lo   [2] GURMUKHI LETTER LA..GURMUKHI LETTER LLA
unicode_id_start(0x0A35, 0x0A36).	% ID_Start Lo   [2] GURMUKHI LETTER VA..GURMUKHI LETTER SHA
unicode_id_start(0x0A38, 0x0A39).	% ID_Start Lo   [2] GURMUKHI LETTER SA..GURMUKHI LETTER HA
unicode_id_start(0x0A59, 0x0A5C).	% ID_Start Lo   [4] GURMUKHI LETTER KHHA..GURMUKHI LETTER RRA
unicode_id_start(0x0A5E, 0x0A5E).	% ID_Start Lo       GURMUKHI LETTER FA
unicode_id_start(0x0A72, 0x0A74).	% ID_Start Lo   [3] GURMUKHI IRI..GURMUKHI EK ONKAR
unicode_id_start(0x0A85, 0x0A8D).	% ID_Start Lo   [9] GUJARATI LETTER A..GUJARATI VOWEL CANDRA E
unicode_id_start(0x0A8F, 0x0A91).	% ID_Start Lo   [3] GUJARATI LETTER E..GUJARATI VOWEL CANDRA O
unicode_id_start(0x0A93, 0x0AA8).	% ID_Start Lo  [22] GUJARATI LETTER O..GUJARATI LETTER NA
unicode_id_start(0x0AAA, 0x0AB0).	% ID_Start Lo   [7] GUJARATI LETTER PA..GUJARATI LETTER RA
unicode_id_start(0x0AB2, 0x0AB3).	% ID_Start Lo   [2] GUJARATI LETTER LA..GUJARATI LETTER LLA
unicode_id_start(0x0AB5, 0x0AB9).	% ID_Start Lo   [5] GUJARATI LETTER VA..GUJARATI LETTER HA
unicode_id_start(0x0ABD, 0x0ABD).	% ID_Start Lo       GUJARATI SIGN AVAGRAHA
unicode_id_start(0x0AD0, 0x0AD0).	% ID_Start Lo       GUJARATI OM
unicode_id_start(0x0AE0, 0x0AE1).	% ID_Start Lo   [2] GUJARATI LETTER VOCALIC RR..GUJARATI LETTER VOCALIC LL
unicode_id_start(0x0B05, 0x0B0C).	% ID_Start Lo   [8] ORIYA LETTER A..ORIYA LETTER VOCALIC L
unicode_id_start(0x0B0F, 0x0B10).	% ID_Start Lo   [2] ORIYA LETTER E..ORIYA LETTER AI
unicode_id_start(0x0B13, 0x0B28).	% ID_Start Lo  [22] ORIYA LETTER O..ORIYA LETTER NA
unicode_id_start(0x0B2A, 0x0B30).	% ID_Start Lo   [7] ORIYA LETTER PA..ORIYA LETTER RA
unicode_id_start(0x0B32, 0x0B33).	% ID_Start Lo   [2] ORIYA LETTER LA..ORIYA LETTER LLA
unicode_id_start(0x0B35, 0x0B39).	% ID_Start Lo   [5] ORIYA LETTER VA..ORIYA LETTER HA
unicode_id_start(0x0B3D, 0x0B3D).	% ID_Start Lo       ORIYA SIGN AVAGRAHA
unicode_id_start(0x0B5C, 0x0B5D).	% ID_Start Lo   [2] ORIYA LETTER RRA..ORIYA LETTER RHA
unicode_id_start(0x0B5F, 0x0B61).	% ID_Start Lo   [3] ORIYA LETTER YYA..ORIYA LETTER VOCALIC LL
unicode_id_start(0x0B71, 0x0B71).	% ID_Start Lo       ORIYA LETTER WA
unicode_id_start(0x0B83, 0x0B83).	% ID_Start Lo       TAMIL SIGN VISARGA
unicode_id_start(0x0B85, 0x0B8A).	% ID_Start Lo   [6] TAMIL LETTER A..TAMIL LETTER UU
unicode_id_start(0x0B8E, 0x0B90).	% ID_Start Lo   [3] TAMIL LETTER E..TAMIL LETTER AI
unicode_id_start(0x0B92, 0x0B95).	% ID_Start Lo   [4] TAMIL LETTER O..TAMIL LETTER KA
unicode_id_start(0x0B99, 0x0B9A).	% ID_Start Lo   [2] TAMIL LETTER NGA..TAMIL LETTER CA
unicode_id_start(0x0B9C, 0x0B9C).	% ID_Start Lo       TAMIL LETTER JA
unicode_id_start(0x0B9E, 0x0B9F).	% ID_Start Lo   [2] TAMIL LETTER NYA..TAMIL LETTER TTA
unicode_id_start(0x0BA3, 0x0BA4).	% ID_Start Lo   [2] TAMIL LETTER NNA..TAMIL LETTER TA
unicode_id_start(0x0BA8, 0x0BAA).	% ID_Start Lo   [3] TAMIL LETTER NA..TAMIL LETTER PA
unicode_id_start(0x0BAE, 0x0BB9).	% ID_Start Lo  [12] TAMIL LETTER MA..TAMIL LETTER HA
unicode_id_start(0x0BD0, 0x0BD0).	% ID_Start Lo       TAMIL OM
unicode_id_start(0x0C05, 0x0C0C).	% ID_Start Lo   [8] TELUGU LETTER A..TELUGU LETTER VOCALIC L
unicode_id_start(0x0C0E, 0x0C10).	% ID_Start Lo   [3] TELUGU LETTER E..TELUGU LETTER AI
unicode_id_start(0x0C12, 0x0C28).	% ID_Start Lo  [23] TELUGU LETTER O..TELUGU LETTER NA
unicode_id_start(0x0C2A, 0x0C33).	% ID_Start Lo  [10] TELUGU LETTER PA..TELUGU LETTER LLA
unicode_id_start(0x0C35, 0x0C39).	% ID_Start Lo   [5] TELUGU LETTER VA..TELUGU LETTER HA
unicode_id_start(0x0C3D, 0x0C3D).	% ID_Start Lo       TELUGU SIGN AVAGRAHA
unicode_id_start(0x0C58, 0x0C59).	% ID_Start Lo   [2] TELUGU LETTER TSA..TELUGU LETTER DZA
unicode_id_start(0x0C60, 0x0C61).	% ID_Start Lo   [2] TELUGU LETTER VOCALIC RR..TELUGU LETTER VOCALIC LL
unicode_id_start(0x0C85, 0x0C8C).	% ID_Start Lo   [8] KANNADA LETTER A..KANNADA LETTER VOCALIC L
unicode_id_start(0x0C8E, 0x0C90).	% ID_Start Lo   [3] KANNADA LETTER E..KANNADA LETTER AI
unicode_id_start(0x0C92, 0x0CA8).	% ID_Start Lo  [23] KANNADA LETTER O..KANNADA LETTER NA
unicode_id_start(0x0CAA, 0x0CB3).	% ID_Start Lo  [10] KANNADA LETTER PA..KANNADA LETTER LLA
unicode_id_start(0x0CB5, 0x0CB9).	% ID_Start Lo   [5] KANNADA LETTER VA..KANNADA LETTER HA
unicode_id_start(0x0CBD, 0x0CBD).	% ID_Start Lo       KANNADA SIGN AVAGRAHA
unicode_id_start(0x0CDE, 0x0CDE).	% ID_Start Lo       KANNADA LETTER FA
unicode_id_start(0x0CE0, 0x0CE1).	% ID_Start Lo   [2] KANNADA LETTER VOCALIC RR..KANNADA LETTER VOCALIC LL
unicode_id_start(0x0CF1, 0x0CF2).	% ID_Start Lo   [2] KANNADA SIGN JIHVAMULIYA..KANNADA SIGN UPADHMANIYA
unicode_id_start(0x0D05, 0x0D0C).	% ID_Start Lo   [8] MALAYALAM LETTER A..MALAYALAM LETTER VOCALIC L
unicode_id_start(0x0D0E, 0x0D10).	% ID_Start Lo   [3] MALAYALAM LETTER E..MALAYALAM LETTER AI
unicode_id_start(0x0D12, 0x0D3A).	% ID_Start Lo  [41] MALAYALAM LETTER O..MALAYALAM LETTER TTTA
unicode_id_start(0x0D3D, 0x0D3D).	% ID_Start Lo       MALAYALAM SIGN AVAGRAHA
unicode_id_start(0x0D4E, 0x0D4E).	% ID_Start Lo       MALAYALAM LETTER DOT REPH
unicode_id_start(0x0D60, 0x0D61).	% ID_Start Lo   [2] MALAYALAM LETTER VOCALIC RR..MALAYALAM LETTER VOCALIC LL
unicode_id_start(0x0D7A, 0x0D7F).	% ID_Start Lo   [6] MALAYALAM LETTER CHILLU NN..MALAYALAM LETTER CHILLU K
unicode_id_start(0x0D85, 0x0D96).	% ID_Start Lo  [18] SINHALA LETTER AYANNA..SINHALA LETTER AUYANNA
unicode_id_start(0x0D9A, 0x0DB1).	% ID_Start Lo  [24] SINHALA LETTER ALPAPRAANA KAYANNA..SINHALA LETTER DANTAJA NAYANNA
unicode_id_start(0x0DB3, 0x0DBB).	% ID_Start Lo   [9] SINHALA LETTER SANYAKA DAYANNA..SINHALA LETTER RAYANNA
unicode_id_start(0x0DBD, 0x0DBD).	% ID_Start Lo       SINHALA LETTER DANTAJA LAYANNA
unicode_id_start(0x0DC0, 0x0DC6).	% ID_Start Lo   [7] SINHALA LETTER VAYANNA..SINHALA LETTER FAYANNA
unicode_id_start(0x0E01, 0x0E30).	% ID_Start Lo  [48] THAI CHARACTER KO KAI..THAI CHARACTER SARA A
unicode_id_start(0x0E32, 0x0E33).	% ID_Start Lo   [2] THAI CHARACTER SARA AA..THAI CHARACTER SARA AM
unicode_id_start(0x0E40, 0x0E45).	% ID_Start Lo   [6] THAI CHARACTER SARA E..THAI CHARACTER LAKKHANGYAO
unicode_id_start(0x0E46, 0x0E46).	% ID_Start Lm       THAI CHARACTER MAIYAMOK
unicode_id_start(0x0E81, 0x0E82).	% ID_Start Lo   [2] LAO LETTER KO..LAO LETTER KHO SUNG
unicode_id_start(0x0E84, 0x0E84).	% ID_Start Lo       LAO LETTER KHO TAM
unicode_id_start(0x0E87, 0x0E88).	% ID_Start Lo   [2] LAO LETTER NGO..LAO LETTER CO
unicode_id_start(0x0E8A, 0x0E8A).	% ID_Start Lo       LAO LETTER SO TAM
unicode_id_start(0x0E8D, 0x0E8D).	% ID_Start Lo       LAO LETTER NYO
unicode_id_start(0x0E94, 0x0E97).	% ID_Start Lo   [4] LAO LETTER DO..LAO LETTER THO TAM
unicode_id_start(0x0E99, 0x0E9F).	% ID_Start Lo   [7] LAO LETTER NO..LAO LETTER FO SUNG
unicode_id_start(0x0EA1, 0x0EA3).	% ID_Start Lo   [3] LAO LETTER MO..LAO LETTER LO LING
unicode_id_start(0x0EA5, 0x0EA5).	% ID_Start Lo       LAO LETTER LO LOOT
unicode_id_start(0x0EA7, 0x0EA7).	% ID_Start Lo       LAO LETTER WO
unicode_id_start(0x0EAA, 0x0EAB).	% ID_Start Lo   [2] LAO LETTER SO SUNG..LAO LETTER HO SUNG
unicode_id_start(0x0EAD, 0x0EB0).	% ID_Start Lo   [4] LAO LETTER O..LAO VOWEL SIGN A
unicode_id_start(0x0EB2, 0x0EB3).	% ID_Start Lo   [2] LAO VOWEL SIGN AA..LAO VOWEL SIGN AM
unicode_id_start(0x0EBD, 0x0EBD).	% ID_Start Lo       LAO SEMIVOWEL SIGN NYO
unicode_id_start(0x0EC0, 0x0EC4).	% ID_Start Lo   [5] LAO VOWEL SIGN E..LAO VOWEL SIGN AI
unicode_id_start(0x0EC6, 0x0EC6).	% ID_Start Lm       LAO KO LA
unicode_id_start(0x0EDC, 0x0EDF).	% ID_Start Lo   [4] LAO HO NO..LAO LETTER KHMU NYO
unicode_id_start(0x0F00, 0x0F00).	% ID_Start Lo       TIBETAN SYLLABLE OM
unicode_id_start(0x0F40, 0x0F47).	% ID_Start Lo   [8] TIBETAN LETTER KA..TIBETAN LETTER JA
unicode_id_start(0x0F49, 0x0F6C).	% ID_Start Lo  [36] TIBETAN LETTER NYA..TIBETAN LETTER RRA
unicode_id_start(0x0F88, 0x0F8C).	% ID_Start Lo   [5] TIBETAN SIGN LCE TSA CAN..TIBETAN SIGN INVERTED MCHU CAN
unicode_id_start(0x1000, 0x102A).	% ID_Start Lo  [43] MYANMAR LETTER KA..MYANMAR LETTER AU
unicode_id_start(0x103F, 0x103F).	% ID_Start Lo       MYANMAR LETTER GREAT SA
unicode_id_start(0x1050, 0x1055).	% ID_Start Lo   [6] MYANMAR LETTER SHA..MYANMAR LETTER VOCALIC LL
unicode_id_start(0x105A, 0x105D).	% ID_Start Lo   [4] MYANMAR LETTER MON NGA..MYANMAR LETTER MON BBE
unicode_id_start(0x1061, 0x1061).	% ID_Start Lo       MYANMAR LETTER SGAW KAREN SHA
unicode_id_start(0x1065, 0x1066).	% ID_Start Lo   [2] MYANMAR LETTER WESTERN PWO KAREN THA..MYANMAR LETTER WESTERN PWO KAREN PWA
unicode_id_start(0x106E, 0x1070).	% ID_Start Lo   [3] MYANMAR LETTER EASTERN PWO KAREN NNA..MYANMAR LETTER EASTERN PWO KAREN GHWA
unicode_id_start(0x1075, 0x1081).	% ID_Start Lo  [13] MYANMAR LETTER SHAN KA..MYANMAR LETTER SHAN HA
unicode_id_start(0x108E, 0x108E).	% ID_Start Lo       MYANMAR LETTER RUMAI PALAUNG FA
unicode_id_start(0x10A0, 0x10C5).	% ID_Start L&  [38] GEORGIAN CAPITAL LETTER AN..GEORGIAN CAPITAL LETTER HOE
unicode_id_start(0x10C7, 0x10C7).	% ID_Start L&       GEORGIAN CAPITAL LETTER YN
unicode_id_start(0x10CD, 0x10CD).	% ID_Start L&       GEORGIAN CAPITAL LETTER AEN
unicode_id_start(0x10D0, 0x10FA).	% ID_Start Lo  [43] GEORGIAN LETTER AN..GEORGIAN LETTER AIN
unicode_id_start(0x10FC, 0x10FC).	% ID_Start Lm       MODIFIER LETTER GEORGIAN NAR
unicode_id_start(0x10FD, 0x1248).	% ID_Start Lo [332] GEORGIAN LETTER AEN..ETHIOPIC SYLLABLE QWA
unicode_id_start(0x124A, 0x124D).	% ID_Start Lo   [4] ETHIOPIC SYLLABLE QWI..ETHIOPIC SYLLABLE QWE
unicode_id_start(0x1250, 0x1256).	% ID_Start Lo   [7] ETHIOPIC SYLLABLE QHA..ETHIOPIC SYLLABLE QHO
unicode_id_start(0x1258, 0x1258).	% ID_Start Lo       ETHIOPIC SYLLABLE QHWA
unicode_id_start(0x125A, 0x125D).	% ID_Start Lo   [4] ETHIOPIC SYLLABLE QHWI..ETHIOPIC SYLLABLE QHWE
unicode_id_start(0x1260, 0x1288).	% ID_Start Lo  [41] ETHIOPIC SYLLABLE BA..ETHIOPIC SYLLABLE XWA
unicode_id_start(0x128A, 0x128D).	% ID_Start Lo   [4] ETHIOPIC SYLLABLE XWI..ETHIOPIC SYLLABLE XWE
unicode_id_start(0x1290, 0x12B0).	% ID_Start Lo  [33] ETHIOPIC SYLLABLE NA..ETHIOPIC SYLLABLE KWA
unicode_id_start(0x12B2, 0x12B5).	% ID_Start Lo   [4] ETHIOPIC SYLLABLE KWI..ETHIOPIC SYLLABLE KWE
unicode_id_start(0x12B8, 0x12BE).	% ID_Start Lo   [7] ETHIOPIC SYLLABLE KXA..ETHIOPIC SYLLABLE KXO
unicode_id_start(0x12C0, 0x12C0).	% ID_Start Lo       ETHIOPIC SYLLABLE KXWA
unicode_id_start(0x12C2, 0x12C5).	% ID_Start Lo   [4] ETHIOPIC SYLLABLE KXWI..ETHIOPIC SYLLABLE KXWE
unicode_id_start(0x12C8, 0x12D6).	% ID_Start Lo  [15] ETHIOPIC SYLLABLE WA..ETHIOPIC SYLLABLE PHARYNGEAL O
unicode_id_start(0x12D8, 0x1310).	% ID_Start Lo  [57] ETHIOPIC SYLLABLE ZA..ETHIOPIC SYLLABLE GWA
unicode_id_start(0x1312, 0x1315).	% ID_Start Lo   [4] ETHIOPIC SYLLABLE GWI..ETHIOPIC SYLLABLE GWE
unicode_id_start(0x1318, 0x135A).	% ID_Start Lo  [67] ETHIOPIC SYLLABLE GGA..ETHIOPIC SYLLABLE FYA
unicode_id_start(0x1380, 0x138F).	% ID_Start Lo  [16] ETHIOPIC SYLLABLE SEBATBEIT MWA..ETHIOPIC SYLLABLE PWE
unicode_id_start(0x13A0, 0x13F4).	% ID_Start Lo  [85] CHEROKEE LETTER A..CHEROKEE LETTER YV
unicode_id_start(0x1401, 0x166C).	% ID_Start Lo [620] CANADIAN SYLLABICS E..CANADIAN SYLLABICS CARRIER TTSA
unicode_id_start(0x166F, 0x167F).	% ID_Start Lo  [17] CANADIAN SYLLABICS QAI..CANADIAN SYLLABICS BLACKFOOT W
unicode_id_start(0x1681, 0x169A).	% ID_Start Lo  [26] OGHAM LETTER BEITH..OGHAM LETTER PEITH
unicode_id_start(0x16A0, 0x16EA).	% ID_Start Lo  [75] RUNIC LETTER FEHU FEOH FE F..RUNIC LETTER X
unicode_id_start(0x16EE, 0x16F0).	% ID_Start Nl   [3] RUNIC ARLAUG SYMBOL..RUNIC BELGTHOR SYMBOL
unicode_id_start(0x1700, 0x170C).	% ID_Start Lo  [13] TAGALOG LETTER A..TAGALOG LETTER YA
unicode_id_start(0x170E, 0x1711).	% ID_Start Lo   [4] TAGALOG LETTER LA..TAGALOG LETTER HA
unicode_id_start(0x1720, 0x1731).	% ID_Start Lo  [18] HANUNOO LETTER A..HANUNOO LETTER HA
unicode_id_start(0x1740, 0x1751).	% ID_Start Lo  [18] BUHID LETTER A..BUHID LETTER HA
unicode_id_start(0x1760, 0x176C).	% ID_Start Lo  [13] TAGBANWA LETTER A..TAGBANWA LETTER YA
unicode_id_start(0x176E, 0x1770).	% ID_Start Lo   [3] TAGBANWA LETTER LA..TAGBANWA LETTER SA
unicode_id_start(0x1780, 0x17B3).	% ID_Start Lo  [52] KHMER LETTER KA..KHMER INDEPENDENT VOWEL QAU
unicode_id_start(0x17D7, 0x17D7).	% ID_Start Lm       KHMER SIGN LEK TOO
unicode_id_start(0x17DC, 0x17DC).	% ID_Start Lo       KHMER SIGN AVAKRAHASANYA
unicode_id_start(0x1820, 0x1842).	% ID_Start Lo  [35] MONGOLIAN LETTER A..MONGOLIAN LETTER CHI
unicode_id_start(0x1843, 0x1843).	% ID_Start Lm       MONGOLIAN LETTER TODO LONG VOWEL SIGN
unicode_id_start(0x1844, 0x1877).	% ID_Start Lo  [52] MONGOLIAN LETTER TODO E..MONGOLIAN LETTER MANCHU ZHA
unicode_id_start(0x1880, 0x18A8).	% ID_Start Lo  [41] MONGOLIAN LETTER ALI GALI ANUSVARA ONE..MONGOLIAN LETTER MANCHU ALI GALI BHA
unicode_id_start(0x18AA, 0x18AA).	% ID_Start Lo       MONGOLIAN LETTER MANCHU ALI GALI LHA
unicode_id_start(0x18B0, 0x18F5).	% ID_Start Lo  [70] CANADIAN SYLLABICS OY..CANADIAN SYLLABICS CARRIER DENTAL S
unicode_id_start(0x1900, 0x191C).	% ID_Start Lo  [29] LIMBU VOWEL-CARRIER LETTER..LIMBU LETTER HA
unicode_id_start(0x1950, 0x196D).	% ID_Start Lo  [30] TAI LE LETTER KA..TAI LE LETTER AI
unicode_id_start(0x1970, 0x1974).	% ID_Start Lo   [5] TAI LE LETTER TONE-2..TAI LE LETTER TONE-6
unicode_id_start(0x1980, 0x19AB).	% ID_Start Lo  [44] NEW TAI LUE LETTER HIGH QA..NEW TAI LUE LETTER LOW SUA
unicode_id_start(0x19C1, 0x19C7).	% ID_Start Lo   [7] NEW TAI LUE LETTER FINAL V..NEW TAI LUE LETTER FINAL B
unicode_id_start(0x1A00, 0x1A16).	% ID_Start Lo  [23] BUGINESE LETTER KA..BUGINESE LETTER HA
unicode_id_start(0x1A20, 0x1A54).	% ID_Start Lo  [53] TAI THAM LETTER HIGH KA..TAI THAM LETTER GREAT SA
unicode_id_start(0x1AA7, 0x1AA7).	% ID_Start Lm       TAI THAM SIGN MAI YAMOK
unicode_id_start(0x1B05, 0x1B33).	% ID_Start Lo  [47] BALINESE LETTER AKARA..BALINESE LETTER HA
unicode_id_start(0x1B45, 0x1B4B).	% ID_Start Lo   [7] BALINESE LETTER KAF SASAK..BALINESE LETTER ASYURA SASAK
unicode_id_start(0x1B83, 0x1BA0).	% ID_Start Lo  [30] SUNDANESE LETTER A..SUNDANESE LETTER HA
unicode_id_start(0x1BAE, 0x1BAF).	% ID_Start Lo   [2] SUNDANESE LETTER KHA..SUNDANESE LETTER SYA
unicode_id_start(0x1BBA, 0x1BE5).	% ID_Start Lo  [44] SUNDANESE AVAGRAHA..BATAK LETTER U
unicode_id_start(0x1C00, 0x1C23).	% ID_Start Lo  [36] LEPCHA LETTER KA..LEPCHA LETTER A
unicode_id_start(0x1C4D, 0x1C4F).	% ID_Start Lo   [3] LEPCHA LETTER TTA..LEPCHA LETTER DDA
unicode_id_start(0x1C5A, 0x1C77).	% ID_Start Lo  [30] OL CHIKI LETTER LA..OL CHIKI LETTER OH
unicode_id_start(0x1C78, 0x1C7D).	% ID_Start Lm   [6] OL CHIKI MU TTUDDAG..OL CHIKI AHAD
unicode_id_start(0x1CE9, 0x1CEC).	% ID_Start Lo   [4] VEDIC SIGN ANUSVARA ANTARGOMUKHA..VEDIC SIGN ANUSVARA VAMAGOMUKHA WITH TAIL
unicode_id_start(0x1CEE, 0x1CF1).	% ID_Start Lo   [4] VEDIC SIGN HEXIFORM LONG ANUSVARA..VEDIC SIGN ANUSVARA UBHAYATO MUKHA
unicode_id_start(0x1CF5, 0x1CF6).	% ID_Start Lo   [2] VEDIC SIGN JIHVAMULIYA..VEDIC SIGN UPADHMANIYA
unicode_id_start(0x1D00, 0x1D2B).	% ID_Start L&  [44] LATIN LETTER SMALL CAPITAL A..CYRILLIC LETTER SMALL CAPITAL EL
unicode_id_start(0x1D2C, 0x1D6A).	% ID_Start Lm  [63] MODIFIER LETTER CAPITAL A..GREEK SUBSCRIPT SMALL LETTER CHI
unicode_id_start(0x1D6B, 0x1D77).	% ID_Start L&  [13] LATIN SMALL LETTER UE..LATIN SMALL LETTER TURNED G
unicode_id_start(0x1D78, 0x1D78).	% ID_Start Lm       MODIFIER LETTER CYRILLIC EN
unicode_id_start(0x1D79, 0x1D9A).	% ID_Start L&  [34] LATIN SMALL LETTER INSULAR G..LATIN SMALL LETTER EZH WITH RETROFLEX HOOK
unicode_id_start(0x1D9B, 0x1DBF).	% ID_Start Lm  [37] MODIFIER LETTER SMALL TURNED ALPHA..MODIFIER LETTER SMALL THETA
unicode_id_start(0x1E00, 0x1F15).	% ID_Start L& [278] LATIN CAPITAL LETTER A WITH RING BELOW..GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
unicode_id_start(0x1F18, 0x1F1D).	% ID_Start L&   [6] GREEK CAPITAL LETTER EPSILON WITH PSILI..GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
unicode_id_start(0x1F20, 0x1F45).	% ID_Start L&  [38] GREEK SMALL LETTER ETA WITH PSILI..GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
unicode_id_start(0x1F48, 0x1F4D).	% ID_Start L&   [6] GREEK CAPITAL LETTER OMICRON WITH PSILI..GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
unicode_id_start(0x1F50, 0x1F57).	% ID_Start L&   [8] GREEK SMALL LETTER UPSILON WITH PSILI..GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
unicode_id_start(0x1F59, 0x1F59).	% ID_Start L&       GREEK CAPITAL LETTER UPSILON WITH DASIA
unicode_id_start(0x1F5B, 0x1F5B).	% ID_Start L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
unicode_id_start(0x1F5D, 0x1F5D).	% ID_Start L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
unicode_id_start(0x1F5F, 0x1F7D).	% ID_Start L&  [31] GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI..GREEK SMALL LETTER OMEGA WITH OXIA
unicode_id_start(0x1F80, 0x1FB4).	% ID_Start L&  [53] GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI..GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
unicode_id_start(0x1FB6, 0x1FBC).	% ID_Start L&   [7] GREEK SMALL LETTER ALPHA WITH PERISPOMENI..GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
unicode_id_start(0x1FBE, 0x1FBE).	% ID_Start L&       GREEK PROSGEGRAMMENI
unicode_id_start(0x1FC2, 0x1FC4).	% ID_Start L&   [3] GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
unicode_id_start(0x1FC6, 0x1FCC).	% ID_Start L&   [7] GREEK SMALL LETTER ETA WITH PERISPOMENI..GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
unicode_id_start(0x1FD0, 0x1FD3).	% ID_Start L&   [4] GREEK SMALL LETTER IOTA WITH VRACHY..GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
unicode_id_start(0x1FD6, 0x1FDB).	% ID_Start L&   [6] GREEK SMALL LETTER IOTA WITH PERISPOMENI..GREEK CAPITAL LETTER IOTA WITH OXIA
unicode_id_start(0x1FE0, 0x1FEC).	% ID_Start L&  [13] GREEK SMALL LETTER UPSILON WITH VRACHY..GREEK CAPITAL LETTER RHO WITH DASIA
unicode_id_start(0x1FF2, 0x1FF4).	% ID_Start L&   [3] GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
unicode_id_start(0x1FF6, 0x1FFC).	% ID_Start L&   [7] GREEK SMALL LETTER OMEGA WITH PERISPOMENI..GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
unicode_id_start(0x2071, 0x2071).	% ID_Start Lm       SUPERSCRIPT LATIN SMALL LETTER I
unicode_id_start(0x207F, 0x207F).	% ID_Start Lm       SUPERSCRIPT LATIN SMALL LETTER N
unicode_id_start(0x2090, 0x209C).	% ID_Start Lm  [13] LATIN SUBSCRIPT SMALL LETTER A..LATIN SUBSCRIPT SMALL LETTER T
unicode_id_start(0x2102, 0x2102).	% ID_Start L&       DOUBLE-STRUCK CAPITAL C
unicode_id_start(0x2107, 0x2107).	% ID_Start L&       EULER CONSTANT
unicode_id_start(0x210A, 0x2113).	% ID_Start L&  [10] SCRIPT SMALL G..SCRIPT SMALL L
unicode_id_start(0x2115, 0x2115).	% ID_Start L&       DOUBLE-STRUCK CAPITAL N
unicode_id_start(0x2118, 0x2118).	% ID_Start Sm       SCRIPT CAPITAL P
unicode_id_start(0x2119, 0x211D).	% ID_Start L&   [5] DOUBLE-STRUCK CAPITAL P..DOUBLE-STRUCK CAPITAL R
unicode_id_start(0x2124, 0x2124).	% ID_Start L&       DOUBLE-STRUCK CAPITAL Z
unicode_id_start(0x2126, 0x2126).	% ID_Start L&       OHM SIGN
unicode_id_start(0x2128, 0x2128).	% ID_Start L&       BLACK-LETTER CAPITAL Z
unicode_id_start(0x212A, 0x212D).	% ID_Start L&   [4] KELVIN SIGN..BLACK-LETTER CAPITAL C
unicode_id_start(0x212E, 0x212E).	% ID_Start So       ESTIMATED SYMBOL
unicode_id_start(0x212F, 0x2134).	% ID_Start L&   [6] SCRIPT SMALL E..SCRIPT SMALL O
unicode_id_start(0x2135, 0x2138).	% ID_Start Lo   [4] ALEF SYMBOL..DALET SYMBOL
unicode_id_start(0x2139, 0x2139).	% ID_Start L&       INFORMATION SOURCE
unicode_id_start(0x213C, 0x213F).	% ID_Start L&   [4] DOUBLE-STRUCK SMALL PI..DOUBLE-STRUCK CAPITAL PI
unicode_id_start(0x2145, 0x2149).	% ID_Start L&   [5] DOUBLE-STRUCK ITALIC CAPITAL D..DOUBLE-STRUCK ITALIC SMALL J
unicode_id_start(0x214E, 0x214E).	% ID_Start L&       TURNED SMALL F
unicode_id_start(0x2160, 0x2182).	% ID_Start Nl  [35] ROMAN NUMERAL ONE..ROMAN NUMERAL TEN THOUSAND
unicode_id_start(0x2183, 0x2184).	% ID_Start L&   [2] ROMAN NUMERAL REVERSED ONE HUNDRED..LATIN SMALL LETTER REVERSED C
unicode_id_start(0x2185, 0x2188).	% ID_Start Nl   [4] ROMAN NUMERAL SIX LATE FORM..ROMAN NUMERAL ONE HUNDRED THOUSAND
unicode_id_start(0x2C00, 0x2C2E).	% ID_Start L&  [47] GLAGOLITIC CAPITAL LETTER AZU..GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE
unicode_id_start(0x2C30, 0x2C5E).	% ID_Start L&  [47] GLAGOLITIC SMALL LETTER AZU..GLAGOLITIC SMALL LETTER LATINATE MYSLITE
unicode_id_start(0x2C60, 0x2C7B).	% ID_Start L&  [28] LATIN CAPITAL LETTER L WITH DOUBLE BAR..LATIN LETTER SMALL CAPITAL TURNED E
unicode_id_start(0x2C7C, 0x2C7D).	% ID_Start Lm   [2] LATIN SUBSCRIPT SMALL LETTER J..MODIFIER LETTER CAPITAL V
unicode_id_start(0x2C7E, 0x2CE4).	% ID_Start L& [103] LATIN CAPITAL LETTER S WITH SWASH TAIL..COPTIC SYMBOL KAI
unicode_id_start(0x2CEB, 0x2CEE).	% ID_Start L&   [4] COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI..COPTIC SMALL LETTER CRYPTOGRAMMIC GANGIA
unicode_id_start(0x2CF2, 0x2CF3).	% ID_Start L&   [2] COPTIC CAPITAL LETTER BOHAIRIC KHEI..COPTIC SMALL LETTER BOHAIRIC KHEI
unicode_id_start(0x2D00, 0x2D25).	% ID_Start L&  [38] GEORGIAN SMALL LETTER AN..GEORGIAN SMALL LETTER HOE
unicode_id_start(0x2D27, 0x2D27).	% ID_Start L&       GEORGIAN SMALL LETTER YN
unicode_id_start(0x2D2D, 0x2D2D).	% ID_Start L&       GEORGIAN SMALL LETTER AEN
unicode_id_start(0x2D30, 0x2D67).	% ID_Start Lo  [56] TIFINAGH LETTER YA..TIFINAGH LETTER YO
unicode_id_start(0x2D6F, 0x2D6F).	% ID_Start Lm       TIFINAGH MODIFIER LETTER LABIALIZATION MARK
unicode_id_start(0x2D80, 0x2D96).	% ID_Start Lo  [23] ETHIOPIC SYLLABLE LOA..ETHIOPIC SYLLABLE GGWE
unicode_id_start(0x2DA0, 0x2DA6).	% ID_Start Lo   [7] ETHIOPIC SYLLABLE SSA..ETHIOPIC SYLLABLE SSO
unicode_id_start(0x2DA8, 0x2DAE).	% ID_Start Lo   [7] ETHIOPIC SYLLABLE CCA..ETHIOPIC SYLLABLE CCO
unicode_id_start(0x2DB0, 0x2DB6).	% ID_Start Lo   [7] ETHIOPIC SYLLABLE ZZA..ETHIOPIC SYLLABLE ZZO
unicode_id_start(0x2DB8, 0x2DBE).	% ID_Start Lo   [7] ETHIOPIC SYLLABLE CCHA..ETHIOPIC SYLLABLE CCHO
unicode_id_start(0x2DC0, 0x2DC6).	% ID_Start Lo   [7] ETHIOPIC SYLLABLE QYA..ETHIOPIC SYLLABLE QYO
unicode_id_start(0x2DC8, 0x2DCE).	% ID_Start Lo   [7] ETHIOPIC SYLLABLE KYA..ETHIOPIC SYLLABLE KYO
unicode_id_start(0x2DD0, 0x2DD6).	% ID_Start Lo   [7] ETHIOPIC SYLLABLE XYA..ETHIOPIC SYLLABLE XYO
unicode_id_start(0x2DD8, 0x2DDE).	% ID_Start Lo   [7] ETHIOPIC SYLLABLE GYA..ETHIOPIC SYLLABLE GYO
unicode_id_start(0x3005, 0x3005).	% ID_Start Lm       IDEOGRAPHIC ITERATION MARK
unicode_id_start(0x3006, 0x3006).	% ID_Start Lo       IDEOGRAPHIC CLOSING MARK
unicode_id_start(0x3007, 0x3007).	% ID_Start Nl       IDEOGRAPHIC NUMBER ZERO
unicode_id_start(0x3021, 0x3029).	% ID_Start Nl   [9] HANGZHOU NUMERAL ONE..HANGZHOU NUMERAL NINE
unicode_id_start(0x3031, 0x3035).	% ID_Start Lm   [5] VERTICAL KANA REPEAT MARK..VERTICAL KANA REPEAT MARK LOWER HALF
unicode_id_start(0x3038, 0x303A).	% ID_Start Nl   [3] HANGZHOU NUMERAL TEN..HANGZHOU NUMERAL THIRTY
unicode_id_start(0x303B, 0x303B).	% ID_Start Lm       VERTICAL IDEOGRAPHIC ITERATION MARK
unicode_id_start(0x303C, 0x303C).	% ID_Start Lo       MASU MARK
unicode_id_start(0x3041, 0x3096).	% ID_Start Lo  [86] HIRAGANA LETTER SMALL A..HIRAGANA LETTER SMALL KE
unicode_id_start(0x309B, 0x309C).	% ID_Start Sk   [2] KATAKANA-HIRAGANA VOICED SOUND MARK..KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
unicode_id_start(0x309D, 0x309E).	% ID_Start Lm   [2] HIRAGANA ITERATION MARK..HIRAGANA VOICED ITERATION MARK
unicode_id_start(0x309F, 0x309F).	% ID_Start Lo       HIRAGANA DIGRAPH YORI
unicode_id_start(0x30A1, 0x30FA).	% ID_Start Lo  [90] KATAKANA LETTER SMALL A..KATAKANA LETTER VO
unicode_id_start(0x30FC, 0x30FE).	% ID_Start Lm   [3] KATAKANA-HIRAGANA PROLONGED SOUND MARK..KATAKANA VOICED ITERATION MARK
unicode_id_start(0x30FF, 0x30FF).	% ID_Start Lo       KATAKANA DIGRAPH KOTO
unicode_id_start(0x3105, 0x312D).	% ID_Start Lo  [41] BOPOMOFO LETTER B..BOPOMOFO LETTER IH
unicode_id_start(0x3131, 0x318E).	% ID_Start Lo  [94] HANGUL LETTER KIYEOK..HANGUL LETTER ARAEAE
unicode_id_start(0x31A0, 0x31BA).	% ID_Start Lo  [27] BOPOMOFO LETTER BU..BOPOMOFO LETTER ZY
unicode_id_start(0x31F0, 0x31FF).	% ID_Start Lo  [16] KATAKANA LETTER SMALL KU..KATAKANA LETTER SMALL RO
unicode_id_start(0x3400, 0x4DB5).	% ID_Start Lo [6582] CJK UNIFIED IDEOGRAPH-3400..CJK UNIFIED IDEOGRAPH-4DB5
unicode_id_start(0x4E00, 0x9FCC).	% ID_Start Lo [20941] CJK UNIFIED IDEOGRAPH-4E00..CJK UNIFIED IDEOGRAPH-9FCC
unicode_id_start(0xA000, 0xA014).	% ID_Start Lo  [21] YI SYLLABLE IT..YI SYLLABLE E
unicode_id_start(0xA015, 0xA015).	% ID_Start Lm       YI SYLLABLE WU
unicode_id_start(0xA016, 0xA48C).	% ID_Start Lo [1143] YI SYLLABLE BIT..YI SYLLABLE YYR
unicode_id_start(0xA4D0, 0xA4F7).	% ID_Start Lo  [40] LISU LETTER BA..LISU LETTER OE
unicode_id_start(0xA4F8, 0xA4FD).	% ID_Start Lm   [6] LISU LETTER TONE MYA TI..LISU LETTER TONE MYA JEU
unicode_id_start(0xA500, 0xA60B).	% ID_Start Lo [268] VAI SYLLABLE EE..VAI SYLLABLE NG
unicode_id_start(0xA60C, 0xA60C).	% ID_Start Lm       VAI SYLLABLE LENGTHENER
unicode_id_start(0xA610, 0xA61F).	% ID_Start Lo  [16] VAI SYLLABLE NDOLE FA..VAI SYMBOL JONG
unicode_id_start(0xA62A, 0xA62B).	% ID_Start Lo   [2] VAI SYLLABLE NDOLE MA..VAI SYLLABLE NDOLE DO
unicode_id_start(0xA640, 0xA66D).	% ID_Start L&  [46] CYRILLIC CAPITAL LETTER ZEMLYA..CYRILLIC SMALL LETTER DOUBLE MONOCULAR O
unicode_id_start(0xA66E, 0xA66E).	% ID_Start Lo       CYRILLIC LETTER MULTIOCULAR O
unicode_id_start(0xA67F, 0xA67F).	% ID_Start Lm       CYRILLIC PAYEROK
unicode_id_start(0xA680, 0xA697).	% ID_Start L&  [24] CYRILLIC CAPITAL LETTER DWE..CYRILLIC SMALL LETTER SHWE
unicode_id_start(0xA6A0, 0xA6E5).	% ID_Start Lo  [70] BAMUM LETTER A..BAMUM LETTER KI
unicode_id_start(0xA6E6, 0xA6EF).	% ID_Start Nl  [10] BAMUM LETTER MO..BAMUM LETTER KOGHOM
unicode_id_start(0xA717, 0xA71F).	% ID_Start Lm   [9] MODIFIER LETTER DOT VERTICAL BAR..MODIFIER LETTER LOW INVERTED EXCLAMATION MARK
unicode_id_start(0xA722, 0xA76F).	% ID_Start L&  [78] LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF..LATIN SMALL LETTER CON
unicode_id_start(0xA770, 0xA770).	% ID_Start Lm       MODIFIER LETTER US
unicode_id_start(0xA771, 0xA787).	% ID_Start L&  [23] LATIN SMALL LETTER DUM..LATIN SMALL LETTER INSULAR T
unicode_id_start(0xA788, 0xA788).	% ID_Start Lm       MODIFIER LETTER LOW CIRCUMFLEX ACCENT
unicode_id_start(0xA78B, 0xA78E).	% ID_Start L&   [4] LATIN CAPITAL LETTER SALTILLO..LATIN SMALL LETTER L WITH RETROFLEX HOOK AND BELT
unicode_id_start(0xA790, 0xA793).	% ID_Start L&   [4] LATIN CAPITAL LETTER N WITH DESCENDER..LATIN SMALL LETTER C WITH BAR
unicode_id_start(0xA7A0, 0xA7AA).	% ID_Start L&  [11] LATIN CAPITAL LETTER G WITH OBLIQUE STROKE..LATIN CAPITAL LETTER H WITH HOOK
unicode_id_start(0xA7F8, 0xA7F9).	% ID_Start Lm   [2] MODIFIER LETTER CAPITAL H WITH STROKE..MODIFIER LETTER SMALL LIGATURE OE
unicode_id_start(0xA7FA, 0xA7FA).	% ID_Start L&       LATIN LETTER SMALL CAPITAL TURNED M
unicode_id_start(0xA7FB, 0xA801).	% ID_Start Lo   [7] LATIN EPIGRAPHIC LETTER REVERSED F..SYLOTI NAGRI LETTER I
unicode_id_start(0xA803, 0xA805).	% ID_Start Lo   [3] SYLOTI NAGRI LETTER U..SYLOTI NAGRI LETTER O
unicode_id_start(0xA807, 0xA80A).	% ID_Start Lo   [4] SYLOTI NAGRI LETTER KO..SYLOTI NAGRI LETTER GHO
unicode_id_start(0xA80C, 0xA822).	% ID_Start Lo  [23] SYLOTI NAGRI LETTER CO..SYLOTI NAGRI LETTER HO
unicode_id_start(0xA840, 0xA873).	% ID_Start Lo  [52] PHAGS-PA LETTER KA..PHAGS-PA LETTER CANDRABINDU
unicode_id_start(0xA882, 0xA8B3).	% ID_Start Lo  [50] SAURASHTRA LETTER A..SAURASHTRA LETTER LLA
unicode_id_start(0xA8F2, 0xA8F7).	% ID_Start Lo   [6] DEVANAGARI SIGN SPACING CANDRABINDU..DEVANAGARI SIGN CANDRABINDU AVAGRAHA
unicode_id_start(0xA8FB, 0xA8FB).	% ID_Start Lo       DEVANAGARI HEADSTROKE
unicode_id_start(0xA90A, 0xA925).	% ID_Start Lo  [28] KAYAH LI LETTER KA..KAYAH LI LETTER OO
unicode_id_start(0xA930, 0xA946).	% ID_Start Lo  [23] REJANG LETTER KA..REJANG LETTER A
unicode_id_start(0xA960, 0xA97C).	% ID_Start Lo  [29] HANGUL CHOSEONG TIKEUT-MIEUM..HANGUL CHOSEONG SSANGYEORINHIEUH
unicode_id_start(0xA984, 0xA9B2).	% ID_Start Lo  [47] JAVANESE LETTER A..JAVANESE LETTER HA
unicode_id_start(0xA9CF, 0xA9CF).	% ID_Start Lm       JAVANESE PANGRANGKEP
unicode_id_start(0xAA00, 0xAA28).	% ID_Start Lo  [41] CHAM LETTER A..CHAM LETTER HA
unicode_id_start(0xAA40, 0xAA42).	% ID_Start Lo   [3] CHAM LETTER FINAL K..CHAM LETTER FINAL NG
unicode_id_start(0xAA44, 0xAA4B).	% ID_Start Lo   [8] CHAM LETTER FINAL CH..CHAM LETTER FINAL SS
unicode_id_start(0xAA60, 0xAA6F).	% ID_Start Lo  [16] MYANMAR LETTER KHAMTI GA..MYANMAR LETTER KHAMTI FA
unicode_id_start(0xAA70, 0xAA70).	% ID_Start Lm       MYANMAR MODIFIER LETTER KHAMTI REDUPLICATION
unicode_id_start(0xAA71, 0xAA76).	% ID_Start Lo   [6] MYANMAR LETTER KHAMTI XA..MYANMAR LOGOGRAM KHAMTI HM
unicode_id_start(0xAA7A, 0xAA7A).	% ID_Start Lo       MYANMAR LETTER AITON RA
unicode_id_start(0xAA80, 0xAAAF).	% ID_Start Lo  [48] TAI VIET LETTER LOW KO..TAI VIET LETTER HIGH O
unicode_id_start(0xAAB1, 0xAAB1).	% ID_Start Lo       TAI VIET VOWEL AA
unicode_id_start(0xAAB5, 0xAAB6).	% ID_Start Lo   [2] TAI VIET VOWEL E..TAI VIET VOWEL O
unicode_id_start(0xAAB9, 0xAABD).	% ID_Start Lo   [5] TAI VIET VOWEL UEA..TAI VIET VOWEL AN
unicode_id_start(0xAAC0, 0xAAC0).	% ID_Start Lo       TAI VIET TONE MAI NUENG
unicode_id_start(0xAAC2, 0xAAC2).	% ID_Start Lo       TAI VIET TONE MAI SONG
unicode_id_start(0xAADB, 0xAADC).	% ID_Start Lo   [2] TAI VIET SYMBOL KON..TAI VIET SYMBOL NUENG
unicode_id_start(0xAADD, 0xAADD).	% ID_Start Lm       TAI VIET SYMBOL SAM
unicode_id_start(0xAAE0, 0xAAEA).	% ID_Start Lo  [11] MEETEI MAYEK LETTER E..MEETEI MAYEK LETTER SSA
unicode_id_start(0xAAF2, 0xAAF2).	% ID_Start Lo       MEETEI MAYEK ANJI
unicode_id_start(0xAAF3, 0xAAF4).	% ID_Start Lm   [2] MEETEI MAYEK SYLLABLE REPETITION MARK..MEETEI MAYEK WORD REPETITION MARK
unicode_id_start(0xAB01, 0xAB06).	% ID_Start Lo   [6] ETHIOPIC SYLLABLE TTHU..ETHIOPIC SYLLABLE TTHO
unicode_id_start(0xAB09, 0xAB0E).	% ID_Start Lo   [6] ETHIOPIC SYLLABLE DDHU..ETHIOPIC SYLLABLE DDHO
unicode_id_start(0xAB11, 0xAB16).	% ID_Start Lo   [6] ETHIOPIC SYLLABLE DZU..ETHIOPIC SYLLABLE DZO
unicode_id_start(0xAB20, 0xAB26).	% ID_Start Lo   [7] ETHIOPIC SYLLABLE CCHHA..ETHIOPIC SYLLABLE CCHHO
unicode_id_start(0xAB28, 0xAB2E).	% ID_Start Lo   [7] ETHIOPIC SYLLABLE BBA..ETHIOPIC SYLLABLE BBO
unicode_id_start(0xABC0, 0xABE2).	% ID_Start Lo  [35] MEETEI MAYEK LETTER KOK..MEETEI MAYEK LETTER I LONSUM
unicode_id_start(0xAC00, 0xD7A3).	% ID_Start Lo [11172] HANGUL SYLLABLE GA..HANGUL SYLLABLE HIH
unicode_id_start(0xD7B0, 0xD7C6).	% ID_Start Lo  [23] HANGUL JUNGSEONG O-YEO..HANGUL JUNGSEONG ARAEA-E
unicode_id_start(0xD7CB, 0xD7FB).	% ID_Start Lo  [49] HANGUL JONGSEONG NIEUN-RIEUL..HANGUL JONGSEONG PHIEUPH-THIEUTH
unicode_id_start(0xF900, 0xFA6D).	% ID_Start Lo [366] CJK COMPATIBILITY IDEOGRAPH-F900..CJK COMPATIBILITY IDEOGRAPH-FA6D
unicode_id_start(0xFA70, 0xFAD9).	% ID_Start Lo [106] CJK COMPATIBILITY IDEOGRAPH-FA70..CJK COMPATIBILITY IDEOGRAPH-FAD9
unicode_id_start(0xFB00, 0xFB06).	% ID_Start L&   [7] LATIN SMALL LIGATURE FF..LATIN SMALL LIGATURE ST
unicode_id_start(0xFB13, 0xFB17).	% ID_Start L&   [5] ARMENIAN SMALL LIGATURE MEN NOW..ARMENIAN SMALL LIGATURE MEN XEH
unicode_id_start(0xFB1D, 0xFB1D).	% ID_Start Lo       HEBREW LETTER YOD WITH HIRIQ
unicode_id_start(0xFB1F, 0xFB28).	% ID_Start Lo  [10] HEBREW LIGATURE YIDDISH YOD YOD PATAH..HEBREW LETTER WIDE TAV
unicode_id_start(0xFB2A, 0xFB36).	% ID_Start Lo  [13] HEBREW LETTER SHIN WITH SHIN DOT..HEBREW LETTER ZAYIN WITH DAGESH
unicode_id_start(0xFB38, 0xFB3C).	% ID_Start Lo   [5] HEBREW LETTER TET WITH DAGESH..HEBREW LETTER LAMED WITH DAGESH
unicode_id_start(0xFB3E, 0xFB3E).	% ID_Start Lo       HEBREW LETTER MEM WITH DAGESH
unicode_id_start(0xFB40, 0xFB41).	% ID_Start Lo   [2] HEBREW LETTER NUN WITH DAGESH..HEBREW LETTER SAMEKH WITH DAGESH
unicode_id_start(0xFB43, 0xFB44).	% ID_Start Lo   [2] HEBREW LETTER FINAL PE WITH DAGESH..HEBREW LETTER PE WITH DAGESH
unicode_id_start(0xFB46, 0xFBB1).	% ID_Start Lo [108] HEBREW LETTER TSADI WITH DAGESH..ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM
unicode_id_start(0xFBD3, 0xFD3D).	% ID_Start Lo [363] ARABIC LETTER NG ISOLATED FORM..ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM
unicode_id_start(0xFD50, 0xFD8F).	% ID_Start Lo  [64] ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM..ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM
unicode_id_start(0xFD92, 0xFDC7).	% ID_Start Lo  [54] ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM..ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM
unicode_id_start(0xFDF0, 0xFDFB).	% ID_Start Lo  [12] ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM..ARABIC LIGATURE JALLAJALALOUHOU
unicode_id_start(0xFE70, 0xFE74).	% ID_Start Lo   [5] ARABIC FATHATAN ISOLATED FORM..ARABIC KASRATAN ISOLATED FORM
unicode_id_start(0xFE76, 0xFEFC).	% ID_Start Lo [135] ARABIC FATHA ISOLATED FORM..ARABIC LIGATURE LAM WITH ALEF FINAL FORM
unicode_id_start(0xFF21, 0xFF3A).	% ID_Start L&  [26] FULLWIDTH LATIN CAPITAL LETTER A..FULLWIDTH LATIN CAPITAL LETTER Z
unicode_id_start(0xFF41, 0xFF5A).	% ID_Start L&  [26] FULLWIDTH LATIN SMALL LETTER A..FULLWIDTH LATIN SMALL LETTER Z
unicode_id_start(0xFF66, 0xFF6F).	% ID_Start Lo  [10] HALFWIDTH KATAKANA LETTER WO..HALFWIDTH KATAKANA LETTER SMALL TU
unicode_id_start(0xFF70, 0xFF70).	% ID_Start Lm       HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
unicode_id_start(0xFF71, 0xFF9D).	% ID_Start Lo  [45] HALFWIDTH KATAKANA LETTER A..HALFWIDTH KATAKANA LETTER N
unicode_id_start(0xFF9E, 0xFF9F).	% ID_Start Lm   [2] HALFWIDTH KATAKANA VOICED SOUND MARK..HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
unicode_id_start(0xFFA0, 0xFFBE).	% ID_Start Lo  [31] HALFWIDTH HANGUL FILLER..HALFWIDTH HANGUL LETTER HIEUH
unicode_id_start(0xFFC2, 0xFFC7).	% ID_Start Lo   [6] HALFWIDTH HANGUL LETTER A..HALFWIDTH HANGUL LETTER E
unicode_id_start(0xFFCA, 0xFFCF).	% ID_Start Lo   [6] HALFWIDTH HANGUL LETTER YEO..HALFWIDTH HANGUL LETTER OE
unicode_id_start(0xFFD2, 0xFFD7).	% ID_Start Lo   [6] HALFWIDTH HANGUL LETTER YO..HALFWIDTH HANGUL LETTER YU
unicode_id_start(0xFFDA, 0xFFDC).	% ID_Start Lo   [3] HALFWIDTH HANGUL LETTER EU..HALFWIDTH HANGUL LETTER I
unicode_id_start(0x10000, 0x1000B).	% ID_Start Lo  [12] LINEAR B SYLLABLE B008 A..LINEAR B SYLLABLE B046 JE
unicode_id_start(0x1000D, 0x10026).	% ID_Start Lo  [26] LINEAR B SYLLABLE B036 JO..LINEAR B SYLLABLE B032 QO
unicode_id_start(0x10028, 0x1003A).	% ID_Start Lo  [19] LINEAR B SYLLABLE B060 RA..LINEAR B SYLLABLE B042 WO
unicode_id_start(0x1003C, 0x1003D).	% ID_Start Lo   [2] LINEAR B SYLLABLE B017 ZA..LINEAR B SYLLABLE B074 ZE
unicode_id_start(0x1003F, 0x1004D).	% ID_Start Lo  [15] LINEAR B SYLLABLE B020 ZO..LINEAR B SYLLABLE B091 TWO
unicode_id_start(0x10050, 0x1005D).	% ID_Start Lo  [14] LINEAR B SYMBOL B018..LINEAR B SYMBOL B089
unicode_id_start(0x10080, 0x100FA).	% ID_Start Lo [123] LINEAR B IDEOGRAM B100 MAN..LINEAR B IDEOGRAM VESSEL B305
unicode_id_start(0x10140, 0x10174).	% ID_Start Nl  [53] GREEK ACROPHONIC ATTIC ONE QUARTER..GREEK ACROPHONIC STRATIAN FIFTY MNAS
unicode_id_start(0x10280, 0x1029C).	% ID_Start Lo  [29] LYCIAN LETTER A..LYCIAN LETTER X
unicode_id_start(0x102A0, 0x102D0).	% ID_Start Lo  [49] CARIAN LETTER A..CARIAN LETTER UUU3
unicode_id_start(0x10300, 0x1031E).	% ID_Start Lo  [31] OLD ITALIC LETTER A..OLD ITALIC LETTER UU
unicode_id_start(0x10330, 0x10340).	% ID_Start Lo  [17] GOTHIC LETTER AHSA..GOTHIC LETTER PAIRTHRA
unicode_id_start(0x10341, 0x10341).	% ID_Start Nl       GOTHIC LETTER NINETY
unicode_id_start(0x10342, 0x10349).	% ID_Start Lo   [8] GOTHIC LETTER RAIDA..GOTHIC LETTER OTHAL
unicode_id_start(0x1034A, 0x1034A).	% ID_Start Nl       GOTHIC LETTER NINE HUNDRED
unicode_id_start(0x10380, 0x1039D).	% ID_Start Lo  [30] UGARITIC LETTER ALPA..UGARITIC LETTER SSU
unicode_id_start(0x103A0, 0x103C3).	% ID_Start Lo  [36] OLD PERSIAN SIGN A..OLD PERSIAN SIGN HA
unicode_id_start(0x103C8, 0x103CF).	% ID_Start Lo   [8] OLD PERSIAN SIGN AURAMAZDAA..OLD PERSIAN SIGN BUUMISH
unicode_id_start(0x103D1, 0x103D5).	% ID_Start Nl   [5] OLD PERSIAN NUMBER ONE..OLD PERSIAN NUMBER HUNDRED
unicode_id_start(0x10400, 0x1044F).	% ID_Start L&  [80] DESERET CAPITAL LETTER LONG I..DESERET SMALL LETTER EW
unicode_id_start(0x10450, 0x1049D).	% ID_Start Lo  [78] SHAVIAN LETTER PEEP..OSMANYA LETTER OO
unicode_id_start(0x10800, 0x10805).	% ID_Start Lo   [6] CYPRIOT SYLLABLE A..CYPRIOT SYLLABLE JA
unicode_id_start(0x10808, 0x10808).	% ID_Start Lo       CYPRIOT SYLLABLE JO
unicode_id_start(0x1080A, 0x10835).	% ID_Start Lo  [44] CYPRIOT SYLLABLE KA..CYPRIOT SYLLABLE WO
unicode_id_start(0x10837, 0x10838).	% ID_Start Lo   [2] CYPRIOT SYLLABLE XA..CYPRIOT SYLLABLE XE
unicode_id_start(0x1083C, 0x1083C).	% ID_Start Lo       CYPRIOT SYLLABLE ZA
unicode_id_start(0x1083F, 0x10855).	% ID_Start Lo  [23] CYPRIOT SYLLABLE ZO..IMPERIAL ARAMAIC LETTER TAW
unicode_id_start(0x10900, 0x10915).	% ID_Start Lo  [22] PHOENICIAN LETTER ALF..PHOENICIAN LETTER TAU
unicode_id_start(0x10920, 0x10939).	% ID_Start Lo  [26] LYDIAN LETTER A..LYDIAN LETTER C
unicode_id_start(0x10980, 0x109B7).	% ID_Start Lo  [56] MEROITIC HIEROGLYPHIC LETTER A..MEROITIC CURSIVE LETTER DA
unicode_id_start(0x109BE, 0x109BF).	% ID_Start Lo   [2] MEROITIC CURSIVE LOGOGRAM RMT..MEROITIC CURSIVE LOGOGRAM IMN
unicode_id_start(0x10A00, 0x10A00).	% ID_Start Lo       KHAROSHTHI LETTER A
unicode_id_start(0x10A10, 0x10A13).	% ID_Start Lo   [4] KHAROSHTHI LETTER KA..KHAROSHTHI LETTER GHA
unicode_id_start(0x10A15, 0x10A17).	% ID_Start Lo   [3] KHAROSHTHI LETTER CA..KHAROSHTHI LETTER JA
unicode_id_start(0x10A19, 0x10A33).	% ID_Start Lo  [27] KHAROSHTHI LETTER NYA..KHAROSHTHI LETTER TTTHA
unicode_id_start(0x10A60, 0x10A7C).	% ID_Start Lo  [29] OLD SOUTH ARABIAN LETTER HE..OLD SOUTH ARABIAN LETTER THETH
unicode_id_start(0x10B00, 0x10B35).	% ID_Start Lo  [54] AVESTAN LETTER A..AVESTAN LETTER HE
unicode_id_start(0x10B40, 0x10B55).	% ID_Start Lo  [22] INSCRIPTIONAL PARTHIAN LETTER ALEPH..INSCRIPTIONAL PARTHIAN LETTER TAW
unicode_id_start(0x10B60, 0x10B72).	% ID_Start Lo  [19] INSCRIPTIONAL PAHLAVI LETTER ALEPH..INSCRIPTIONAL PAHLAVI LETTER TAW
unicode_id_start(0x10C00, 0x10C48).	% ID_Start Lo  [73] OLD TURKIC LETTER ORKHON A..OLD TURKIC LETTER ORKHON BASH
unicode_id_start(0x11003, 0x11037).	% ID_Start Lo  [53] BRAHMI SIGN JIHVAMULIYA..BRAHMI LETTER OLD TAMIL NNNA
unicode_id_start(0x11083, 0x110AF).	% ID_Start Lo  [45] KAITHI LETTER A..KAITHI LETTER HA
unicode_id_start(0x110D0, 0x110E8).	% ID_Start Lo  [25] SORA SOMPENG LETTER SAH..SORA SOMPENG LETTER MAE
unicode_id_start(0x11103, 0x11126).	% ID_Start Lo  [36] CHAKMA LETTER AA..CHAKMA LETTER HAA
unicode_id_start(0x11183, 0x111B2).	% ID_Start Lo  [48] SHARADA LETTER A..SHARADA LETTER HA
unicode_id_start(0x111C1, 0x111C4).	% ID_Start Lo   [4] SHARADA SIGN AVAGRAHA..SHARADA OM
unicode_id_start(0x11680, 0x116AA).	% ID_Start Lo  [43] TAKRI LETTER A..TAKRI LETTER RRA
unicode_id_start(0x12000, 0x1236E).	% ID_Start Lo [879] CUNEIFORM SIGN A..CUNEIFORM SIGN ZUM
unicode_id_start(0x12400, 0x12462).	% ID_Start Nl  [99] CUNEIFORM NUMERIC SIGN TWO ASH..CUNEIFORM NUMERIC SIGN OLD ASSYRIAN ONE QUARTER
unicode_id_start(0x13000, 0x1342E).	% ID_Start Lo [1071] EGYPTIAN HIEROGLYPH A001..EGYPTIAN HIEROGLYPH AA032
unicode_id_start(0x16800, 0x16A38).	% ID_Start Lo [569] BAMUM LETTER PHASE-A NGKUE MFON..BAMUM LETTER PHASE-F VUEQ
unicode_id_start(0x16F00, 0x16F44).	% ID_Start Lo  [69] MIAO LETTER PA..MIAO LETTER HHA
unicode_id_start(0x16F50, 0x16F50).	% ID_Start Lo       MIAO LETTER NASALIZATION
unicode_id_start(0x16F93, 0x16F9F).	% ID_Start Lm  [13] MIAO LETTER TONE-2..MIAO LETTER REFORMED TONE-8
unicode_id_start(0x1B000, 0x1B001).	% ID_Start Lo   [2] KATAKANA LETTER ARCHAIC E..HIRAGANA LETTER ARCHAIC YE
unicode_id_start(0x1D400, 0x1D454).	% ID_Start L&  [85] MATHEMATICAL BOLD CAPITAL A..MATHEMATICAL ITALIC SMALL G
unicode_id_start(0x1D456, 0x1D49C).	% ID_Start L&  [71] MATHEMATICAL ITALIC SMALL I..MATHEMATICAL SCRIPT CAPITAL A
unicode_id_start(0x1D49E, 0x1D49F).	% ID_Start L&   [2] MATHEMATICAL SCRIPT CAPITAL C..MATHEMATICAL SCRIPT CAPITAL D
unicode_id_start(0x1D4A2, 0x1D4A2).	% ID_Start L&       MATHEMATICAL SCRIPT CAPITAL G
unicode_id_start(0x1D4A5, 0x1D4A6).	% ID_Start L&   [2] MATHEMATICAL SCRIPT CAPITAL J..MATHEMATICAL SCRIPT CAPITAL K
unicode_id_start(0x1D4A9, 0x1D4AC).	% ID_Start L&   [4] MATHEMATICAL SCRIPT CAPITAL N..MATHEMATICAL SCRIPT CAPITAL Q
unicode_id_start(0x1D4AE, 0x1D4B9).	% ID_Start L&  [12] MATHEMATICAL SCRIPT CAPITAL S..MATHEMATICAL SCRIPT SMALL D
unicode_id_start(0x1D4BB, 0x1D4BB).	% ID_Start L&       MATHEMATICAL SCRIPT SMALL F
unicode_id_start(0x1D4BD, 0x1D4C3).	% ID_Start L&   [7] MATHEMATICAL SCRIPT SMALL H..MATHEMATICAL SCRIPT SMALL N
unicode_id_start(0x1D4C5, 0x1D505).	% ID_Start L&  [65] MATHEMATICAL SCRIPT SMALL P..MATHEMATICAL FRAKTUR CAPITAL B
unicode_id_start(0x1D507, 0x1D50A).	% ID_Start L&   [4] MATHEMATICAL FRAKTUR CAPITAL D..MATHEMATICAL FRAKTUR CAPITAL G
unicode_id_start(0x1D50D, 0x1D514).	% ID_Start L&   [8] MATHEMATICAL FRAKTUR CAPITAL J..MATHEMATICAL FRAKTUR CAPITAL Q
unicode_id_start(0x1D516, 0x1D51C).	% ID_Start L&   [7] MATHEMATICAL FRAKTUR CAPITAL S..MATHEMATICAL FRAKTUR CAPITAL Y
unicode_id_start(0x1D51E, 0x1D539).	% ID_Start L&  [28] MATHEMATICAL FRAKTUR SMALL A..MATHEMATICAL DOUBLE-STRUCK CAPITAL B
unicode_id_start(0x1D53B, 0x1D53E).	% ID_Start L&   [4] MATHEMATICAL DOUBLE-STRUCK CAPITAL D..MATHEMATICAL DOUBLE-STRUCK CAPITAL G
unicode_id_start(0x1D540, 0x1D544).	% ID_Start L&   [5] MATHEMATICAL DOUBLE-STRUCK CAPITAL I..MATHEMATICAL DOUBLE-STRUCK CAPITAL M
unicode_id_start(0x1D546, 0x1D546).	% ID_Start L&       MATHEMATICAL DOUBLE-STRUCK CAPITAL O
unicode_id_start(0x1D54A, 0x1D550).	% ID_Start L&   [7] MATHEMATICAL DOUBLE-STRUCK CAPITAL S..MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
unicode_id_start(0x1D552, 0x1D6A5).	% ID_Start L& [340] MATHEMATICAL DOUBLE-STRUCK SMALL A..MATHEMATICAL ITALIC SMALL DOTLESS J
unicode_id_start(0x1D6A8, 0x1D6C0).	% ID_Start L&  [25] MATHEMATICAL BOLD CAPITAL ALPHA..MATHEMATICAL BOLD CAPITAL OMEGA
unicode_id_start(0x1D6C2, 0x1D6DA).	% ID_Start L&  [25] MATHEMATICAL BOLD SMALL ALPHA..MATHEMATICAL BOLD SMALL OMEGA
unicode_id_start(0x1D6DC, 0x1D6FA).	% ID_Start L&  [31] MATHEMATICAL BOLD EPSILON SYMBOL..MATHEMATICAL ITALIC CAPITAL OMEGA
unicode_id_start(0x1D6FC, 0x1D714).	% ID_Start L&  [25] MATHEMATICAL ITALIC SMALL ALPHA..MATHEMATICAL ITALIC SMALL OMEGA
unicode_id_start(0x1D716, 0x1D734).	% ID_Start L&  [31] MATHEMATICAL ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
unicode_id_start(0x1D736, 0x1D74E).	% ID_Start L&  [25] MATHEMATICAL BOLD ITALIC SMALL ALPHA..MATHEMATICAL BOLD ITALIC SMALL OMEGA
unicode_id_start(0x1D750, 0x1D76E).	% ID_Start L&  [31] MATHEMATICAL BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
unicode_id_start(0x1D770, 0x1D788).	% ID_Start L&  [25] MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
unicode_id_start(0x1D78A, 0x1D7A8).	% ID_Start L&  [31] MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
unicode_id_start(0x1D7AA, 0x1D7C2).	% ID_Start L&  [25] MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
unicode_id_start(0x1D7C4, 0x1D7CB).	% ID_Start L&   [8] MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD SMALL DIGAMMA
unicode_id_start(0x1EE00, 0x1EE03).	% ID_Start Lo   [4] ARABIC MATHEMATICAL ALEF..ARABIC MATHEMATICAL DAL
unicode_id_start(0x1EE05, 0x1EE1F).	% ID_Start Lo  [27] ARABIC MATHEMATICAL WAW..ARABIC MATHEMATICAL DOTLESS QAF
unicode_id_start(0x1EE21, 0x1EE22).	% ID_Start Lo   [2] ARABIC MATHEMATICAL INITIAL BEH..ARABIC MATHEMATICAL INITIAL JEEM
unicode_id_start(0x1EE24, 0x1EE24).	% ID_Start Lo       ARABIC MATHEMATICAL INITIAL HEH
unicode_id_start(0x1EE27, 0x1EE27).	% ID_Start Lo       ARABIC MATHEMATICAL INITIAL HAH
unicode_id_start(0x1EE29, 0x1EE32).	% ID_Start Lo  [10] ARABIC MATHEMATICAL INITIAL YEH..ARABIC MATHEMATICAL INITIAL QAF
unicode_id_start(0x1EE34, 0x1EE37).	% ID_Start Lo   [4] ARABIC MATHEMATICAL INITIAL SHEEN..ARABIC MATHEMATICAL INITIAL KHAH
unicode_id_start(0x1EE39, 0x1EE39).	% ID_Start Lo       ARABIC MATHEMATICAL INITIAL DAD
unicode_id_start(0x1EE3B, 0x1EE3B).	% ID_Start Lo       ARABIC MATHEMATICAL INITIAL GHAIN
unicode_id_start(0x1EE42, 0x1EE42).	% ID_Start Lo       ARABIC MATHEMATICAL TAILED JEEM
unicode_id_start(0x1EE47, 0x1EE47).	% ID_Start Lo       ARABIC MATHEMATICAL TAILED HAH
unicode_id_start(0x1EE49, 0x1EE49).	% ID_Start Lo       ARABIC MATHEMATICAL TAILED YEH
unicode_id_start(0x1EE4B, 0x1EE4B).	% ID_Start Lo       ARABIC MATHEMATICAL TAILED LAM
unicode_id_start(0x1EE4D, 0x1EE4F).	% ID_Start Lo   [3] ARABIC MATHEMATICAL TAILED NOON..ARABIC MATHEMATICAL TAILED AIN
unicode_id_start(0x1EE51, 0x1EE52).	% ID_Start Lo   [2] ARABIC MATHEMATICAL TAILED SAD..ARABIC MATHEMATICAL TAILED QAF
unicode_id_start(0x1EE54, 0x1EE54).	% ID_Start Lo       ARABIC MATHEMATICAL TAILED SHEEN
unicode_id_start(0x1EE57, 0x1EE57).	% ID_Start Lo       ARABIC MATHEMATICAL TAILED KHAH
unicode_id_start(0x1EE59, 0x1EE59).	% ID_Start Lo       ARABIC MATHEMATICAL TAILED DAD
unicode_id_start(0x1EE5B, 0x1EE5B).	% ID_Start Lo       ARABIC MATHEMATICAL TAILED GHAIN
unicode_id_start(0x1EE5D, 0x1EE5D).	% ID_Start Lo       ARABIC MATHEMATICAL TAILED DOTLESS NOON
unicode_id_start(0x1EE5F, 0x1EE5F).	% ID_Start Lo       ARABIC MATHEMATICAL TAILED DOTLESS QAF
unicode_id_start(0x1EE61, 0x1EE62).	% ID_Start Lo   [2] ARABIC MATHEMATICAL STRETCHED BEH..ARABIC MATHEMATICAL STRETCHED JEEM
unicode_id_start(0x1EE64, 0x1EE64).	% ID_Start Lo       ARABIC MATHEMATICAL STRETCHED HEH
unicode_id_start(0x1EE67, 0x1EE6A).	% ID_Start Lo   [4] ARABIC MATHEMATICAL STRETCHED HAH..ARABIC MATHEMATICAL STRETCHED KAF
unicode_id_start(0x1EE6C, 0x1EE72).	% ID_Start Lo   [7] ARABIC MATHEMATICAL STRETCHED MEEM..ARABIC MATHEMATICAL STRETCHED QAF
unicode_id_start(0x1EE74, 0x1EE77).	% ID_Start Lo   [4] ARABIC MATHEMATICAL STRETCHED SHEEN..ARABIC MATHEMATICAL STRETCHED KHAH
unicode_id_start(0x1EE79, 0x1EE7C).	% ID_Start Lo   [4] ARABIC MATHEMATICAL STRETCHED DAD..ARABIC MATHEMATICAL STRETCHED DOTLESS BEH
unicode_id_start(0x1EE7E, 0x1EE7E).	% ID_Start Lo       ARABIC MATHEMATICAL STRETCHED DOTLESS FEH
unicode_id_start(0x1EE80, 0x1EE89).	% ID_Start Lo  [10] ARABIC MATHEMATICAL LOOPED ALEF..ARABIC MATHEMATICAL LOOPED YEH
unicode_id_start(0x1EE8B, 0x1EE9B).	% ID_Start Lo  [17] ARABIC MATHEMATICAL LOOPED LAM..ARABIC MATHEMATICAL LOOPED GHAIN
unicode_id_start(0x1EEA1, 0x1EEA3).	% ID_Start Lo   [3] ARABIC MATHEMATICAL DOUBLE-STRUCK BEH..ARABIC MATHEMATICAL DOUBLE-STRUCK DAL
unicode_id_start(0x1EEA5, 0x1EEA9).	% ID_Start Lo   [5] ARABIC MATHEMATICAL DOUBLE-STRUCK WAW..ARABIC MATHEMATICAL DOUBLE-STRUCK YEH
unicode_id_start(0x1EEAB, 0x1EEBB).	% ID_Start Lo  [17] ARABIC MATHEMATICAL DOUBLE-STRUCK LAM..ARABIC MATHEMATICAL DOUBLE-STRUCK GHAIN
unicode_id_start(0x20000, 0x2A6D6).	% ID_Start Lo [42711] CJK UNIFIED IDEOGRAPH-20000..CJK UNIFIED IDEOGRAPH-2A6D6
unicode_id_start(0x2A700, 0x2B734).	% ID_Start Lo [4149] CJK UNIFIED IDEOGRAPH-2A700..CJK UNIFIED IDEOGRAPH-2B734
unicode_id_start(0x2B740, 0x2B81D).	% ID_Start Lo [222] CJK UNIFIED IDEOGRAPH-2B740..CJK UNIFIED IDEOGRAPH-2B81D
unicode_id_start(0x2F800, 0x2FA1D).	% ID_Start Lo [542] CJK COMPATIBILITY IDEOGRAPH-2F800..CJK COMPATIBILITY IDEOGRAPH-2FA1D

% Total code points: 101240
