/* rep_cmp:  perform a final paranoid check for duplicate files; utilizes
   results of the filesize command

   Copyright (C) 2013-2025 by Brian Lindholm.  This file is part of the
   littleutils utility set.

   The rep_size utility is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 3, or (at your option) any later
   version.

   The rep_size utility is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   the littleutils.  If not, see <https://www.gnu.org/licenses/>. */


#include <config.h>

#ifdef HAVE_STDIO_H
# include <stdio.h>
#endif
#ifdef HAVE_STDLIB_H
# include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
# include <string.h>
#endif

#ifndef LINE_MAX
# define LINE_MAX 8192
#endif


static int
parse_two (char *line, char *field1, char *field2)
{
  char *ptr;
  int i, n, rc;

  i = 0;
  rc = 0;
  ptr = strtok (line, "\t\n");
  while (ptr != NULL)
    {
      i++;
      switch (i)
        {
        case 1:
          n = (int) strlen (ptr);
          if (n > LINE_MAX - 1) n = LINE_MAX - 1;
          strncpy (field1, ptr, (size_t) n);
          field1[n] = (char) '\0';
          rc += 1;
          break;
        case 2:
          n = (int) strlen (ptr);
          if (n > LINE_MAX - 1) n = LINE_MAX - 1;
          strncpy (field2, ptr, (size_t) n);
          field2[n] = (char) '\0';
          rc += 2;
          break;
        default:
          rc = 0;
        }
      ptr = strtok (NULL, "\t\n");
    }
  if (rc == 3)
    return (0);
  else
    return (1);
}


int
main (int argc, char *argv[])
{
  /* declare variables */

  FILE *infile;
  char *status, line[LINE_MAX], command[LINE_MAX];
  char item1[LINE_MAX], item2[LINE_MAX];
  int rc1 = 0, rc2 = 0;

  /* open file or standard input */

  if (argc == 1)
    infile = stdin;
  else if ((infile = fopen (argv[1], "r")) == NULL)
    {
      fprintf (stderr, "rep_size error: can't open %s!\n", argv[1]);
      return (1);
    }

  /* loop through file, comparing pairs of files */

  while ((!feof (infile)) && (rc1 == 0))
    {
      status = fgets (line, LINE_MAX, infile);
      if ((status != NULL) && ((int) strlen (line) > 1) && (line[0] != '#'))
        rc1 = parse_two (line, item1, item2);
      else
        rc1 = 1;
      if (rc1 == 0)
        {
          /* printf("echo \'%s\' \'%s\'", item1, item2); */
          sprintf(command, "cmp -s \'%s\' \'%s\'", item1, item2);
          rc2 = system(command);
          if (rc2 == 0)
            fprintf (stdout, "%s\t%s\n", item1, item2);
        }
    }

  /* close file */

  if (argc > 1)
    (void) fclose (infile);

  /* return proper exit code */

  if (rc1 == 0)
    return (0);
  else
    return (1);
}
