/*
 * $Id: client.c,v 1.26 2002/11/05 08:35:35 kingofgib Exp $
 */

# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <pnet6.h>


/*----------------------------------------------------------------------*/
/* This simple client is designed to work with the server example in 	*/
/* pnet/tests/server.							*/
/* We sent the string "time" to one of the server ports, depending on	*/
/* whether we wish to use IP, IPv6 or the Unix domain sockets.		*/
/* See comments in file ../server/server.c on the port numbers		*/
/*									*/
/* Per default, we connect to localhost, port 44446, using udp and IPv6 */
/*----------------------------------------------------------------------*/

static int
usage( const char * prg )
{
    printf("%s: a simple network client application\n",prg);
    printf("  Send a message to a pnet6 server, across IP, IPv6, or LOCAL,\n"
    	   "using TCP, UDP\n");
    printf("Arguments are: \n");
    printf("    -h:    connect to this address/hostname\n");
    printf("    -p:    connect to this port/service name\n");
    printf("    -P:    use this protocol (values: inet4|inet6|local)\n");
    printf("    -t:    use TCP\n");
    printf("    -u:    use UDP\n");
    printf("    -b:    set broadcast flag\n");
    printf("    -I:    use this interface for link-local IPv6 addresses\n");
    printf(" As last argument, pass the string you want to send, e.g.\n");
    printf(" %s -P local -p /tmp/pnet6time time\n", prg);

    return 1;
}
int
main(int argc,const char **argv)
{
    PNETSOCK	ps;
    char 	buf[128];
    int 	len;
    const char* host = "localhost";
    const char* port = "44446";
    const char* type = "udp";           /* "tcp", "udp" */
    const char* proto= "inet6";         /* "inet4", "inet6", "local" */
    int		pfam = PNET_IPv6;
    int		stream = 0;
    int		brdcst = 0;
    int		conn;
    int		c;
    const char *	text = argv[ argc - 1];
    const char * ifname = NULL;

    while ( (c = pnetGetopt( argc, argv, "P:I:p:h:tub" )) != -1 )
    {
    	switch ( c )
	{
	case 'I':
	    ifname = strdup( pnetOptarg );
	    break;
	case 'P':
	    if ( !strcmp( pnetOptarg, "inet4" ) )
	    {
		pfam = PNET_IPv4;
		proto= strdup( pnetOptarg);
	    }
	    else if ( !strcmp( pnetOptarg, "inet6" ) )
	    {
		pfam = PNET_IPv6;
		proto= strdup( pnetOptarg);
	    }
	    else if ( !strcmp( pnetOptarg, "local" ) )
	    {
		pfam = PNET_LOCAL;
		proto= strdup( pnetOptarg);
	    }
	    else
	    {
		printf("protocol %s not supported\n", pnetOptarg);
		return usage(argv[0]);
	    }
	    break;
	case 'h':
	    host = strdup( pnetOptarg );
	    break;
	case 'p':
	    port = strdup( pnetOptarg );
	    break;
	case 't':
	    stream = 1;
	    type   = "tcp";
	    break;
	case 'u':
	    stream = 0;
	    type   = "udp";
	    break;
	case 'b':
	    brdcst = 1;
	    break;
	case '!':
	    return usage(argv[0]);
	case '?':
	    printf("Unknown argument %c\n", pnetOptopt );
	    return usage(argv[0]);
	}
    }

    if ( stream && brdcst )
    {
	printf(" Broadcasting needs UDP\n");
	return 1;
    }

    printf("%s: using socket(%s,%s,0) on %s:%s\n",argv[0],type,proto,host,port);
 
    if (stream)
	ps = pnetTCPSocket2(pfam);
    else
	ps = pnetUDPSocket2(pfam);

    if (! ps )
    {
	printf("Cannot open socket.\n");
	return 1;
    }

    if (brdcst)
    {
	if( pnetSockSetBroadcast(ps,1) )
	    printf( "Failed to enable broadcasting\n" );
	else
	    printf("Broadcasting enabled.\n");
    }

    /* If you want to change the recv buffer size, do it prior to calling
     * connect, in order to let TCP use the new values at connection 
     * negotiation time */

    pnetSockSetRecvbuf( ps, 50000 );

    /* If you do a non-blocking connect, as in this example, then it's 	*/
    /* necessary to check the return status of pnetConnect(). If it's 	*/
    /* PNET_EINPROGRESS, then the connect is still taking place, and	*/
    /* the program can do other stuff. Afterwards it needs to call 	*/
    /* pnetWaitForConnect() in order to check the status of the connection. */
    /* pnetWaitForConnect() can return PNET_ETIMEDOUT, or other system	*/
    /* error. If the connection is successful, it returns 0. Now you 	*/
    /* have a full-duplex pipe ready and can call read and write.	*/

    pnetSockSetNonBlocking( ps , 1 );

    if ( (conn = pnetConnectX(ps,host,port,NULL,"9999")) == PNET_EINPROGRESS )
    {

	/* Do other things .... */

	/* Now, check the connection. If it has not completed yet, wait  */
	/* for it to complete here. 				 */
	/* pnetWaitForConnect() returns PNET_ETIMEDOUT if the connection */
	/* attempt is timed out 					 */

	conn = pnetWaitForConnect( ps, 15000 ); /* 15 seconds */
    
	if ( conn == PNET_ETIMEDOUT )
	{
	    printf("Connect to %s:%s timed out. Giving up...\n",
		    host,port);
	    pnetClose( ps );
	    return 1;
	}
    }
    /* conn could have been set by pnetConnect() (conn. refused, or	*/
    /* whatever), or by pnetWaitForConnect(). That's why we need to	*/
    /* inspect it here. 						*/
    if ( conn != 0 )
    {
	printf("Cannot connect to %s:%s\n",host,port);
	pnetClose( ps );
	return 1;
    }

    pnetSockSetTTL( ps, 13 );
    pnetWrite( ps, text, strlen( text ) );

    printf("wrote %d bytes\n", strlen( text ));

    while ( (len = pnetReadTimed(ps,buf,sizeof(buf), 0, 500 ) ) )
    {
	PNETADDR pas;
	char 	 addrbuf[ PNET_ADDR_BUFSIZ ];

	if ( len < 0 )
	{
	    printf("No more replies\n");
	    break;
	}
	if (len >= 0)
	{
	    buf[len] = 0;

	    pas = pnetSockGetPeerAddr( ps );
	    if ( pas )
		printf("server '%s' returned '%s'\n",
	    	    pnetAddrToString( pas, addrbuf, sizeof( addrbuf) ), buf);
	}
    }

    pnetClose( ps );

    return 0;
}
