/*
 * This file is part of
 *
 * LIBPNET6: a Portable Network Library
 *
 * LIBPNET6 is Copyright (c) 2002, Peter Bozarov
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Peter Bozarov.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * $Id: sysinfo.c,v 1.17 2002/09/27 08:20:57 kingofgib Exp $
 */

/*----------------------------------------------------------------------*
 * filename:            sysinfo.c
 * created on:          Sun May 19 00:05:55 CEST 2002
 * created by:          teddykgb
 * project:             Portable Network Library
 *----------------------------------------------------------------------*/

# include "local.h"

# ifdef HAVE_SYS_UTSNAME_H
#    include <sys/utsname.h>
# endif

const char *	pnetSysOSName 		= "none";
const char * 	pnetSysNodename 	= "none";
const char * 	pnetSysRelease  	= "none";
const char *	pnetSysVersion  	= "none";
const char *	pnetSysMachine  	= "none";

# ifdef STDWin32
static BOOL GetSystemVersion( void );
# endif

int
pnetGetSystemInfo(void)
{
# ifdef HAVE_UNAME
    struct utsname	uts;

    if (uname(&uts) < 0)
	goto error_lbl;

    pnetSysOSName   = strdup(uts.sysname );
    pnetSysNodename = strdup(uts.nodename);
    pnetSysRelease  = strdup(uts.release );
    pnetSysVersion  = strdup(uts.version );
    pnetSysMachine  = strdup(uts.machine );
# endif

# ifdef STDWin32

    DWORD		len;
    char		buf[MAX_COMPUTERNAME_LENGTH + 1];
    SYSTEM_INFO		sysinf;

    GetSystemInfo(&sysinf);
    GetSystemVersion();

    len = MAX_COMPUTERNAME_LENGTH + 1;

    if ( ! (pnetSysNodename = malloc(len)) )
	goto error_lbl;

    if (! GetComputerName( buf, &len ))
	goto error_lbl;

    if (len > MAX_COMPUTERNAME_LENGTH)
	goto error_lbl;

    buf[ len ] = 0;

    pnetSysNodename = strdup( buf );

    switch (sysinf.wProcessorArchitecture)
    {
    case PROCESSOR_ARCHITECTURE_INTEL:
	pnetSysMachine = strdup("INTEL"); break;
    case PROCESSOR_ARCHITECTURE_MIPS:
	pnetSysMachine = strdup("MIPS"); break;
    case PROCESSOR_ARCHITECTURE_ALPHA:
	pnetSysMachine = strdup("Alpha"); break;
    case PROCESSOR_ARCHITECTURE_PPC:
	pnetSysMachine = strdup("PPC"); break;
    default:
	pnetSysMachine = strdup("Unknown"); break;
    }	


# endif

    pdbg(E_INFO,"OS Name   :    %s\n",pnetSysOSName);
    pdbg(E_INFO,"Node Name :    %s\n",pnetSysNodename);
    pdbg(E_INFO,"OS Release:    %s\n",pnetSysRelease);
    pdbg(E_INFO,"OS Version:    %s\n",pnetSysVersion);
    pdbg(E_INFO,"Machine   :    %s\n",pnetSysMachine);

    return 0;

error_lbl:

    perr(E_FATAL,"pnetGetSystemInfo(): %s\n",SYSERR());
    return -1;
}

/*
 * Get name of temporary directory on the system
 */
# ifndef MAXPATH			/* { */

# ifdef STDLinux
#   define MAXPATH	PATH_MAX
# elif defined PNET_UNIX || defined PNET_APPLE
#   include <sys/param.h>
#     ifndef MAXPATH
#     define MAXPATH	MAXPATHLEN
#   endif
# elif defined STDWin32
#   define MAXPATH	MAX_PATH
# else
#   error What system is this?
# endif

# endif					/* } */

const char *
pnetGetTempPath(void)
{
    static char 	buf[MAXPATH] = { 0 };

    if ( buf[0] )
	return buf;

# if defined PNET_APPLE || defined PNET_UNIX
    snprintf(buf,MAXPATH-1,"/tmp/");
# elif defined STDWin32
    GetTempPath(MAXPATH, buf);
# else
#   error Not implemented on this system. Sorry.
# endif

    return buf;
}

# ifdef STDWin32			/* { */
static BOOL
GetSystemVersion( void )
{
   OSVERSIONINFOEX osvi;
   BOOL bOsVersionInfoEx;

    pnetSysOSName = "Windows";

   /*
    * Try calling GetVersionEx using the OSVERSIONINFOEX structure.
    * If that fails, try using the OSVERSIONINFO structure.
    */

   ZeroMemory(&osvi, sizeof(OSVERSIONINFOEX));
   osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFOEX);

   if( !(bOsVersionInfoEx = GetVersionEx ((OSVERSIONINFO *) &osvi)) )
   {
      // If OSVERSIONINFOEX doesn't work, try OSVERSIONINFO.

      osvi.dwOSVersionInfoSize = sizeof (OSVERSIONINFO);
      if (! GetVersionEx ( (OSVERSIONINFO *) &osvi) ) 
         return FALSE;
   }

   switch (osvi.dwPlatformId)
   {
      case VER_PLATFORM_WIN32_NT:

      // Test for the product.

         if ( osvi.dwMajorVersion <= 4 )
            pnetSysRelease = ("Microsoft Windows NT ");

         if ( osvi.dwMajorVersion == 5 && osvi.dwMinorVersion == 0 )
            pnetSysRelease = ("Microsoft Windows 2000 ");

         if ( osvi.dwMajorVersion == 5 && osvi.dwMinorVersion == 1 )
            pnetSysRelease = ("Microsoft Windows XP ");

      // Test for product type.

         if( bOsVersionInfoEx )
         {
            if ( osvi.wProductType == VER_NT_WORKSTATION )
            {
               if( osvi.wSuiteMask & VER_SUITE_PERSONAL )
                  pnetSysVersion =  ( "Personal " );
               else
                  pnetSysVersion = ( "Professional " );
            }
            else if ( osvi.wProductType == VER_NT_SERVER )
            {
               if( osvi.wSuiteMask & VER_SUITE_DATACENTER )
                  pnetSysVersion = ( "DataCenter Server " );
               else if( osvi.wSuiteMask & VER_SUITE_ENTERPRISE )
                  pnetSysVersion = ( "Advanced Server " );
               else
                  pnetSysVersion = ( "Server " );
            }
         }
         else
         {
            HKEY hKey;
            char szProductType[80];
            DWORD dwBufLen;

            RegOpenKeyEx( HKEY_LOCAL_MACHINE,
               "SYSTEM\\CurrentControlSet\\Control\\ProductOptions",
               0, KEY_QUERY_VALUE, &hKey );
            RegQueryValueEx( hKey, "ProductType", NULL, NULL,
               (LPBYTE) szProductType, &dwBufLen);
            RegCloseKey( hKey );
            if ( lstrcmpi( "WINNT", szProductType) == 0 )
               pnetSysVersion =( "Professional " );
            if ( lstrcmpi( "LANMANNT", szProductType) == 0 )
               pnetSysVersion =( "Server " );
            if ( lstrcmpi( "SERVERNT", szProductType) == 0 )
               pnetSysVersion =( "Advanced Server " );
         }

/*
      // Display version, service pack (if any), and build number.

         if ( osvi.dwMajorVersion <= 4 )
         {
            printf ("version %d.%d %s (Build %d)\n",
               osvi.dwMajorVersion,
               osvi.dwMinorVersion,
               osvi.szCSDVersion,
               osvi.dwBuildNumber & 0xFFFF);
         }
         else
         { 
            printf ("%s (Build %d)\n",
               osvi.szCSDVersion,
               osvi.dwBuildNumber & 0xFFFF);
         }
*/
         break;

      case VER_PLATFORM_WIN32_WINDOWS:

         if (osvi.dwMajorVersion == 4 && osvi.dwMinorVersion == 0)
         {
             pnetSysRelease = ("Microsoft Windows 95 ");
             if ( osvi.szCSDVersion[1] == 'C' || osvi.szCSDVersion[1] == 'B' )
                pnetSysVersion =("OSR2 " );
         } 

         if (osvi.dwMajorVersion == 4 && osvi.dwMinorVersion == 10)
         {
             pnetSysRelease = ("Microsoft Windows 98 ");
             if ( osvi.szCSDVersion[1] == 'A' )
                pnetSysVersion =("SE " );
         } 

         if (osvi.dwMajorVersion == 4 && osvi.dwMinorVersion == 90)
         {
             pnetSysRelease = ("Microsoft Windows Me ");
         } 
         break;

      case VER_PLATFORM_WIN32s:

         pnetSysRelease = ("Microsoft Win32s ");
         break;
   }
   return TRUE; 
}
# endif					/* } */
