/*
 * This file is part of
 *
 * LIBPNET6: a Portable Network Library
 *
 * LIBPNET6 is Copyright (c) 2002, Peter Bozarov
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Peter Bozarov.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * $Id: pnettcp.c,v 1.17 2002/11/01 07:57:30 kingofgib Exp $
 */

/*----------------------------------------------------------------------*
 * filename:		pnettcp.c
 * created on:		Sun Aug 25 23:46:11 CEST 2002
 * created by:		kingofgib
 * project: 		Portable Network Library
 *----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*/
/* TCP header access							*/
/*----------------------------------------------------------------------*/
# include "local.h"
# include "pnet6tlp.h"

int
pnetTCP_Build(  pnet_tcp * tcp,
		pnet_ushort src_port, pnet_ushort dst_port,
		pnet_uint seq,
		pnet_uint ack,
		pnet_byte ecn, pnet_byte ctrl, pnet_ushort win,
		pnet_ushort chksum, pnet_ushort urp )
{
    int offset = 5;

    tcp->th_sport = htons( src_port );
    tcp->th_dport = htons( dst_port );
    tcp->th_seq = htonl( seq );
    tcp->th_ack = htonl( ack );
    tcp->th_x2off = (offset << 4) & 0xF0;
    tcp->th_flags = ecn | ctrl;
    tcp->th_win = htons( win );
    tcp->th_sum = htons( chksum );
    tcp->th_urp = htons( urp );

    return 0;
}
int
pnetTCP_Send( PNETSOCK ps, PNETADDR pa, void *pip,
	      pnet_tcp *tcp, byte * buf, int buflen )
{
    struct iovec	iov[3];
    int			i = 0;
    DBG( dbg( "pnetTCP_Send(ps=%lX,pa=%lX,ip=%lX,tcp=%lX)\n",
	      XX(ps),XX(pa),XX(pip),XX(tcp)) );

    if ( tcp->th_sum == 0 )
    {
    	/* Compute TCP check sum here */
	tcp->th_sum = pnetTCP_ComputeChecksum( pip, tcp, buf, buflen );
    }

    if ( ps->own_header )
    {
	iov[i].iov_base = (char*) pip;
	iov[i].iov_len  = pnetIP_HeaderLength( pip );
	i++;
    }


    iov[i].iov_base = (char*) tcp;
    iov[i].iov_len  = sizeof( pnet_tcp ) + pnetTCP_OptsLen( tcp );
    i++;

    iov[i].iov_base = (char*) buf;
    iov[i].iov_len  = buflen;
    i++;

    return net_writev( ps, pa, iov, i, 0 );
}
pnet_ushort
pnetTCP_ComputeChecksum( void * pip, pnet_tcp *tcp, byte * data, int datalen )
{
    return pnetIP_TLHComputeChecksum( pip, (pnet_byte*) tcp,
		      pnetTCP_DataOffset(tcp), data, datalen, 16, 1 );
}
