/*
 * This file is part of
 *
 * LIBPNET6: a Portable Network Library
 *
 * LIBPNET6 is Copyright (c) 2002, Peter Bozarov
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Peter Bozarov.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * $Id: pnet6.h,v 1.48 2002/12/22 14:13:32 kingofgib Exp $
 */

/*----------------------------------------------------------------------*
 * filename:		pnet6.h
 * created on:		Fri May 10 11:54:43 CEST 2002
 * created by:		teddykgb
 * project: 		Portable Network Library
 *----------------------------------------------------------------------*/

# ifndef _PNET_MAIN_INCLUDE_	/* { */
# define _PNET_MAIN_INCLUDE_

# include <stdio.h>

/* Pull in our system defined stuff */
# if PNET_COMPILE
#   include "pnet6sys.h"
# else
#   include <pnet6sys.h>
# endif

# define PNET_READ_ERROR	-2
# define PNET_READ_TIMED_OUT	-3

# define PNET_EINPROGRESS	1
# define PNET_ETIMEDOUT		2

typedef struct pnet_sock	PNetSocket;
typedef PNetSocket*		PNETSOCK;
typedef struct pnet_addr	PNetAddr;
typedef PNetAddr*		PNETADDR;
typedef struct pif_address	PNetIfAddr;
typedef PNetIfAddr*		PNETIFADDR;
typedef struct pnet_if		PNetIf;
typedef PNetIf*			PNETIF;
typedef struct pnet_aux_info	PNetSockAuxInfo;
typedef PNetSockAuxInfo*	PNETSOCK_AUXINFO;
typedef int (*PNETREADCB)(PNETSOCK,void*);
typedef struct pnet_pktacc	PNetPktAccess;
typedef PNetPktAccess*		PNET_PKTACCESS;
typedef struct pnet_pktfilter	PNetPktFilter;
typedef PNetPktFilter*		PNET_PKTFILTER;
typedef struct pnet_pkt		PNetPacket;
typedef PNetPacket*		PNET_PKT;
typedef struct icmp6_filter*	PNET_ICMPv6_Filter;
typedef void*			PNET_MUTEX;

# define PNET_UNSPEC		0
# define PNET_IPv4		1
# define PNET_IPv6		2
# define PNET_LOCAL		3


# define PNET_LISTEN_SELF	 0
# define PNET_LISTEN_FORK	 1
# define PNET_LISTEN_THREAD	 2

extern int	pnet_error;
# define PNETerrType		0
# define PNETerrAddr		1
# define PNETerrFam		2
# define PNETerrProto		3
# define PNETerrSpace		4

/* Debug output and error output flags	*/
# define PNETdbgLevel0		(1<<0)
# define PNETdbgLevel1		(1<<1)
# define PNETdbgLevel2		(1<<2)
# define PNETdbgLevel3		(1<<3)

# define PNETdbgFatal		1
# define PNETdbgWarn		2
# define PNETdbgMsg		3
# define PNETdbgInfo		4
# define PNETdbgDebug1		5
# define PNETdbgDebug2		6
# define PNETdbgDebug3		7
# define PNETdbgDebug4		8

# define PNET_LOG_TIME		(1<<16)
# define PNET_LOG_PID		(1<<17)
# define PNET_LOG_TID		(1<<18)

# define PNETIF_HWADDR		0
# define PNETIF_UADDR		1
# define PNETIF_BADDR		2
# define PNETIF_DADDR		3
# define PNETIF_NETMASK		5

# define PNETIF_HWADDRLEN	sizeof "AA:BB:CC:DD:EE:FF:GG:HH"

/* Protocol names 		*/
# define PNET_IPPROTO_IP	0
# define PNET_IPPROTO_ICMP	1
# define PNET_IPPROTO_IGMP	2
# define PNET_IPPROTO_TCP	6
# define PNET_IPPROTO_UDP	17	
# define PNET_IPPROTO_ICMPV6	58

/*----------------------------------------------------------------------*/
/* Thread support 							*/
/*----------------------------------------------------------------------*/
typedef void*		pnet_thread_id;

# define PNET_SIG_BLOCK		1
# define PNET_SIG_UNBLOCK	2

typedef struct pnet_thread_lock* PNET_THREAD_LOCK;
typedef struct pnet_thread_cond* PNET_THREAD_COND;
typedef struct pnet_thread_key * PNET_THREAD_KEY ;

typedef void * (*PNET_THREADFUNC)( void * );
typedef void   (*PNET_THREAD_Destructor)( void * );

/* 
 * Cancelation states and types
 */
# define PNET_THREAD_CS_Enable		1
# define PNET_THREAD_CS_Disable		2

# define PNET_THREAD_CT_Deferred	1
# define PNET_THREAD_CT_Async		2

# define PNET_THREAD_CANCELED		((void*)0x1)

/*----------------------------------------------------------------------*/
/* PUSH and POP clean-up handlers.                                      */
/* These are invoked in the reverse order in which they were pushed     */
/* when the calling thread calls pnetThreadExit().                      */
/*----------------------------------------------------------------------*/

/*
 * Add a cleanup handler to top of current thread's cleanup stack.
 */

# if defined PNET_HAVE_PTHREAD_H
# define pnetThreadCleanUpPush(fun,arg) pthread_cleanup_push((fun),(arg))
# else 
# define pnetThreadCleanUpPush(fun,arg)
# endif

/*
 * Pop the clean up routine off of the current thread's cleanup stack and
 * execute it if X is non-nil.
 */

# if defined PNET_HAVE_PTHREAD_H
# define pnetThreadCleanUpPop(X)	pthread_cleanup_pop((X))
# else
# define pnetThreadCleanUpPop(X)
# endif

/*----------------------------------------------------------------------*/
/* Signals								*/
/*----------------------------------------------------------------------*/
# ifdef SIG_ERR
#   define PNET_SIG_ERR		SIG_ERR
# else
#   define PNET_SIG_ERR		((unsigned)-1)
# endif

typedef void (*PNET_SIGFUNC)( int );

/*----------------------------------------------------------------------*/
/* Getopt-esque functionality.						*/
/*----------------------------------------------------------------------*/
extern const char *	pnetOptarg;
extern int	pnetOptind;
extern int	pnetOpterr;
extern int    	pnetOptopt;
/*----------------------------------------------------------------------*/
/* PNET function prototypes						*/
/*----------------------------------------------------------------------*/

/* Currently, simply given; eventually, we'll need to be able to compute it
 * at compile time.
 */
# define PNET_ADDR_STRLEN	(46 + 6 + 16)
# if defined PNET_HAVE_LOCAL
#  undef PNET_ADDR_STRLEN
#  define PNET_ADDR_STRLEN	128
# endif 
# define PNET_ADDR_BUFSIZ	128

typedef    pnet_byte 	PNETADDRSTORAGE[ PNET_ADDR_BUFSIZ ];
# define PNET_SADDR( p )	(( PNETADDR ) p)

# define pnetSockSetTTL( ps, ttl )	pnetSockSetHops( (ps), (ttl) )
# define pnetSockGetTTL( ps, ttl )	pnetSockGetHops( (ps), (ttl) )

/*
 * Connect 
 */

extern void pnetAddrCopy(PNETADDR,PNETADDR);
extern void pnetAddrFree(PNETADDR);
extern pnet_byte* pnetAddrGetBinary(PNETADDR,int *);
extern int pnetAddrGetFamily(PNETADDR);
extern int pnetAddrGetPort(PNETADDR);
extern int pnetAddrIsLinkLocal(PNETADDR);
extern int pnetAddrIsLoopback(PNETADDR);
extern int pnetAddrIsMCLinkLocal(PNETADDR);
extern int pnetAddrIsSiteLocal(PNETADDR);
extern int pnetAddrIsUnspecified(PNETADDR);
extern int pnetAddrIsV4Compatible(PNETADDR);
extern int pnetAddrIsV4Mapped(PNETADDR);
extern int pnetAddrLookupPort(PNETADDR,const char *,const char *);
extern PNETADDR pnetAddrMake(void);
extern PNETADDR pnetAddrNext(PNETADDR);
extern PNETADDR pnetAddrResolve(int,const char *);
extern int pnetAddrSetPort(PNETADDR,int);
extern int pnetAddrToHostname(PNETADDR,char *,int);
extern char * pnetAddrToString(PNETADDR,char *,pnet_uint);
extern PNETADDR pnetAuxDstAddr(PNETSOCK_AUXINFO);
extern int pnetAuxFlagBCST(PNETSOCK_AUXINFO);
extern int pnetAuxFlagEOR(PNETSOCK_AUXINFO);
extern int pnetAuxFlagMCST(PNETSOCK_AUXINFO);
extern int pnetAuxFlagOOB(PNETSOCK_AUXINFO);
extern int pnetAuxFlagTRUNC(PNETSOCK_AUXINFO);
extern int pnetAuxHoplimit(PNETSOCK_AUXINFO);
extern PNETIF pnetAuxRecvIf(PNETSOCK_AUXINFO);
extern int pnetAuxType(PNETSOCK_AUXINFO);
extern int pnetBindOutputStreams(FILE *,FILE *);
extern int pnetBindToAllInterfaces(PNETSOCK);
extern int pnetBindToInterface(PNETSOCK,const char *);
extern void pnetCleanup(void);
extern int pnetClose(PNETSOCK);
extern int pnetCloseRead(PNETSOCK);
extern int pnetCloseReadWrite(PNETSOCK);
extern int pnetCloseWrite(PNETSOCK);
extern int pnetConnect(PNETSOCK,const char *,const char *);
extern int pnetConnectX(PNETSOCK,const char *,const char *,const char *, const char *);
extern int pnetDetachProcess(const char *,const char *);
extern int pnetDumpStats(FILE *);
extern PNetSocket* pnetDuplicate(PNETSOCK);
extern void pnetErr(const char *,... );
extern const char * pnetFamilyToAscii(int);
extern PNETIF pnetGetIfInfo(int);
extern int pnetGetLocalAddress(char *,int);
extern int pnetGetSystemInfo(void);
extern const char * pnetGetTempPath(void);
extern char* pnetGetTimeStamp(char *,unsigned int);
extern int pnetGetopt(int,const char **,const char *);
extern int pnetHexdump(FILE *,pnet_byte *,int,int);
extern int pnetHexdumpX(FILE *,pnet_byte *,int,int,int);

extern const pnet_byte* pnetIfAddrGetBinary(PNETIFADDR,int *);
extern const pnet_byte* pnetIfAddrGetBroadcast(PNETIFADDR);
extern int pnetIfAddrGetFamily(PNETIFADDR);
extern const pnet_byte* pnetIfAddrGetNetmask(PNETIFADDR);
extern PNETIFADDR pnetIfAddrGetNext(PNETIFADDR);
extern int pnetIfAddrGetPrefixLength(PNETIFADDR);
extern int pnetIfAddrGetScopeId(PNETIFADDR);
extern const char * pnetIfAddrToAscii(PNETIF,int,char *,int);
extern int pnetIfAddrToInetAddr(PNETIFADDR,PNETADDR);
extern const char * pnetIfAddrToString(PNETIFADDR,char *,int);
extern PNETIF pnetIfGetByIndex(int,int);
extern PNETIF pnetIfGetByName(int,const char *);
extern const pnet_byte * pnetIfGetLinkAddress(PNETIF,int *);
extern int pnetIfGetMTU(PNETIF);
extern PNETIFADDR pnetIfGetNextAddr(PNETIF,PNETIFADDR);
extern int pnetIfIndex(PNETIF);
extern const char * pnetIfIndexToName(int);
extern int pnetIfIsBroadcast(PNETIF);
extern int pnetIfIsDebug(PNETIF);
extern int pnetIfIsLoopback(PNETIF);
extern int pnetIfIsMulticast(PNETIF);
extern int pnetIfIsNoArp(PNETIF);
extern int pnetIfIsPointopoint(PNETIF);
extern int pnetIfIsPromiscuous(PNETIF);
extern int pnetIfIsRunning(PNETIF);
extern int pnetIfIsSimplex(PNETIF);
extern int pnetIfIsSmart(PNETIF);
extern int pnetIfIsUp(PNETIF);
extern const char * pnetIfName(PNETIF);
extern int pnetIfNameToIndex(const char *);
extern PNETIF pnetIfNext(PNETIF);
extern int pnetIfType(PNETIF);
extern const char* pnetIfTypeString(PNetIf *);

extern int pnetInit(void);
extern int pnetListen(PNETSOCK,const char *);
extern int pnetListenAt(PNETSOCK,const char *,const char *);
extern int pnetListenAtAddress(PNETSOCK,PNETADDR);
extern void pnetLog(const char *,... );
extern int pnetMCastGetHops(PNETSOCK,int *);
extern int pnetMCastGetLoop(PNETSOCK,int *);
extern int pnetMCastJoin(PNETSOCK,PNETADDR,const char *);
extern int pnetMCastLeave(PNETSOCK,PNETADDR,const char *);
extern int pnetMCastSetHops(PNETSOCK,int);
extern int pnetMCastSetInterface(PNETSOCK,const char *);
extern int pnetMCastSetLoop(PNETSOCK,int);
extern PNETSOCK pnetRAWSocket(int);
extern PNETSOCK pnetRAWSocket2(int,int);
extern int pnetRead(PNETSOCK,char *,int);
extern int pnetReadBlock(PNETSOCK,char *,int);
extern int pnetReadTimed(PNETSOCK,char *,int,int,long);
extern PNET_SIGFUNC pnetSetSighandler(int,PNET_SIGFUNC);
extern int pnetShowLibInfo(void);
extern int pnetSockAddReadcallback(PNETSOCK,PNETREADCB,void *);
extern PNETSOCK_AUXINFO pnetSockAuxInfo(PNETSOCK);
extern int pnetSockChecksum(PNETSOCK,int,int);
extern int pnetSockConnected(PNETSOCK);
extern int pnetSockDebug(FILE *,PNETSOCK);
extern int pnetSockFamily(PNETSOCK);
extern int pnetSockGetHops(PNETSOCK,int*);
extern PNETADDR pnetSockGetLocalAddr(PNETSOCK);
extern PNETADDR pnetSockGetPeerAddr(PNETSOCK);
extern int pnetSockOwnIPHeader(PNETSOCK,int);
extern int pnetSockSetBroadcast(PNETSOCK,int);
extern int pnetSockSetHops(PNETSOCK,int);
extern int pnetSockSetKeepalive(PNETSOCK,int);
extern int pnetSockSetHops(PNETSOCK,int);
extern int pnetSockSetKeepalive(PNETSOCK,int);
extern int pnetSockSetLinger(PNETSOCK,int);
extern int pnetSockSetNonBlocking(PNETSOCK,int);
extern int pnetSockSetPeerAddr(PNETSOCK,PNETADDR);
extern int pnetSockSetRecvbuf(PNETSOCK,int);
extern int pnetSockSetReuseaddr(PNETSOCK,int);
extern int pnetSockSetSendbuf(PNETSOCK,int);
extern int pnetStartListen(int);
extern void pnetStopListen(void);
extern PNETSOCK pnetTCPConnect(const char *,const char *);
extern PNETSOCK pnetTCPConnect2(int,const char *,const char *);
extern PNETSOCK pnetTCPConnectX(int,const char *,const char *,const char *,const char *);
extern PNETSOCK pnetTCPSocket(void);
extern PNETSOCK pnetTCPSocket2(int);

/*
 * Threads
 */
/*----------------------------- (   29 lines ) --------------------------*/
extern int pnetThreadCancel(pnet_thread_id);
extern int pnetThreadCondBroadcast(PNET_THREAD_COND);
extern PNET_THREAD_COND pnetThreadCondCreate(void *);
extern int pnetThreadCondFree(PNET_THREAD_COND);
extern int pnetThreadCondSignal(PNET_THREAD_COND);
extern int pnetThreadCondWait(PNET_THREAD_COND,PNET_THREAD_LOCK);
extern int pnetThreadCondWaitTimed(PNET_THREAD_COND,PNET_THREAD_LOCK,int,long);
extern int pnetThreadCreate(pnet_thread_id *,PNET_THREADFUNC,void *);
extern int pnetThreadDetach(pnet_thread_id);
extern void pnetThreadExit(void *);
extern void * pnetThreadGetSpecific(PNET_THREAD_KEY);
extern pnet_thread_id pnetThreadId(void);
extern int pnetThreadJoin(pnet_thread_id,void **);
extern PNET_THREAD_KEY pnetThreadKeyCreate(PNET_THREAD_Destructor);
extern int pnetThreadKeyDelete(PNET_THREAD_KEY);
extern int pnetThreadKill(pnet_thread_id,int);
extern int pnetThreadLockAcquire(PNET_THREAD_LOCK);
extern int pnetThreadLockClose(PNET_THREAD_LOCK);
extern PNET_THREAD_LOCK pnetThreadLockCreate(void);
extern int pnetThreadLockRelease(PNET_THREAD_LOCK);
extern int pnetThreadLockTryAcquire(PNET_THREAD_LOCK);
extern int pnetThreadSetCancelState(int,int *);
extern int pnetThreadSetCancelType(int,int *);
extern int pnetThreadSetSpecific(PNET_THREAD_KEY,const void *);
extern int pnetThreadSignal(int,int);
extern void pnetThreadTestCancel(void);


extern PNETSOCK pnetUDPConnect(const char *,const char *);
extern PNETSOCK pnetUDPConnect2(int,const char *,const char *);
extern PNETSOCK pnetUDPConnectX(int,const char *,const char *,const char *,const
 char *);
extern PNETSOCK pnetUDPSocket(void);
extern PNETSOCK pnetUDPSocket2(int);
extern PNETSOCK pnetUDPSocketX(int);

extern int pnetWaitForConnect(PNETSOCK,int);
extern int pnetWrite(PNETSOCK,const char *,int);
extern int pnetWriteTo(PNETSOCK,PNETADDR,const char *,int);
extern pnet_ulong pnet_htonl(pnet_ulong);
extern pnet_ushort pnet_htons(pnet_ushort);
extern const char * pnet_inet_ntop(int,pnet_byte *,char *,int);
extern int pnet_inet_pton(int,pnet_byte *,char *);
extern pnet_ulong pnet_ntohl(pnet_ulong);
extern pnet_ushort pnet_ntohs(pnet_ushort);
extern char * pnet_ntop(PNETADDR,char *,int);
extern int pnet_pton(int,const char *,PNETADDR);
extern const char * pneterr(int);






#endif /* } */
