/*
 * This file is part of
 *
 * PNET6: a Portable Network Library
 *
 * PNET6 is Copyright (c) 2002, Peter Bozarov
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Peter Bozarov.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * $Id: pkt-ftr.c,v 1.20 2002/12/09 07:55:12 kingofgib Exp $
 */


/*----------------------------------------------------------------------*
 * filename:		pkt-ftr.c
 * created on:		Sat Jul  6 11:19:46 CEST 2002
 * created by:		peter
 * project: 		PNET6
 *----------------------------------------------------------------------*/

# include "../local.h"
# include "../pnet6.h"
# include "../pkt.h"
# include "../pnet6pkt.h"
# include "../pnet6tlp.h"

# ifdef PNET_HAVE_PACKET_ACCESS				/* {{ */

# if defined HAVE_NET_BPF_H || defined PNET_HAVE_PF_PACKET || \
	defined PNET_WIN32_USE_PACKET_DLL 		/* {{ */

static void
bpf_print_filter( BPF_FILTER *f, int len )
{
     int i;

     for (i = 0; i < len; i++, f++)
	printf(" { 0x%x, %d, %d, 0x%.8x },\n", f->code, f->jt, f->jf, f->k);
}


static int 
grab_bytes( PNetPktAccess *pa )
{
    /* The amount we need to capture is set by the user through the
     * pa_glen variable. However, if they have requested cooked mode,
     * they will have requested that we grab whatever amount of bytes
     * minus the link layer header bytes (presumably, one requests cooked
     * mode because they are not interested in the link layer header length).
     * Anyway, we need to add the link layer header bytes to the total
     * grab length here, unless device is in true cooked mode (linux),
     * which means the kernel will do this for us.
     */

    /* NOT COOKED: return whatever they requested */
    if ( pa->pa_cooked == PKTACC_NOT_COOKED )
	return pa->pa_glen;
    /*
     * TRULY  COOKED: no need to deal with actual link layer header
     * grab whatever the user has requested.
     */
    if ( pa->pa_cooked == PKTACC_TRUE_COOKED )
	return pa->pa_glen;
    /*
     * PSEUDO COOKED: account for actual link layer header, and strip if off
     * later 
     */
    return pa->pa_glen + pa->pa_llh_len;
}

extern int pcap_compile_nopcap( int, int, BPF_PROG*, const char*, int, pnet_uint );

int
pnetPktAddFilter( PNetPktAccess *pa, const char * buf )
{
    BPF_PROG prog;

    DBG( dbg( "pnetPktAddFilter(pa=%X,buf=%s)\n", XX(pa), buf ) );

    if ( pcap_compile_nopcap( grab_bytes( pa ), pa->pa_iftype,
			      &prog, buf, 1, 0 ) )
    {
	perr( E_FATAL,"Filter ``%s'' failed to compile.\n", buf );
	return -1;
    }
    DBG( bpf_print_filter( prog.bf_insns, prog.bf_len ) );

    if ( pkt_set_bpf_filter( pa, prog.bf_insns, prog.bf_len ) )
	{ FATALERR("pnetPktAddIPFilter()"); return -1; }

    return 0;
}

# elif defined PNET_HAVE_WIN32_PACKET			/* }{ */
int
pnetPktAddFilter( PNetPktAccess *pa, const char * buf )
{
    return 0;
}
# endif							/* }} */

# else							/* }{ */
int
pnetPktAddFilter( PNetPktAccess *pa, const char * buf )
{
    return 0;
}

# endif							/* }} */
