#!/usr/bin/awk -f
#
#    Converts 11073-10102-AnnexB into 11073-10101-AnnexB.i
#
#    Copyright (C) 2013 Alois Schloegl <alois.schloegl@gmail.com>
#    This file is part of the "BioSig for C/C++" repository
#    (biosig4c++) at http://biosig.sf.net/
#
#    BioSig is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 3
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.


BEGIN { FS = "\t"; 
	print "#if 0\n### This file is autogenerated - Do not modify it !!! ###\n#"; 
	flag = 1;
}

{
	if (/^#/) {
		print $0;
	} else if (NF==4) { 
		if (flag) {
			print "#endif\n";
			flag = 0;
		}
		
		# hexadecimal or decimal - both are fine
		printf("\t{ %3i, %5i, %9i, \"%s\" }, \n",$1, $2, $3, $4);
		# printf("\t{ %3i, 0x%x, 0x%x, \"%s\" }, \n",$1, $2, $3, $4);
	}
}

