//!author: "Lee Samuel Finn"
//: test warning exception  class

#include <iostream>
#include <string>

#include "ldastoolsal/unittest.h"
#include "ldastoolsal/unimplemented_error.hh"

using LDASTools::Error::unimplemented_error;

using namespace std;  //introduces namespace std

LDASTools::Testing::UnitTest Test;

int
main(int ArgC, char** ArgV)
{	
    Test.Init ( ArgC , ArgV );
	if (Test.IsVerbose())
	{
		cout << "$Id: tUnimplemented.cc,v 1.3 2005/09/15 23:55:26 emaros Exp $" << endl;
	}
	
	// Throw the exception, catch it, and check its data
	
	const char* s = "unimplemented error";
	try {
	    throw unimplemented_error(s);
	} catch (unimplemented_error& x) {
		Test.Check(true, "caught unimplemented_error");  
		Test.Check(0 == strcmp(x.what(), s)) 
			<< s << " == " << x.what() << endl;
	} catch (bad_exception &x) {
		Test.Check(false,"caught bad exception");
	}
	Test.Exit(); 
}

