#include <dlfcn.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define FUNC_NAME "doit"

void*
load( char* LibName )
{
  static char lib_buffer[2096];
  void*	retval = (void*)NULL;

  sprintf( lib_buffer, "%s/lib%s.so", ".", LibName );
  if ( access( lib_buffer, R_OK ) != 0 )
  {
    sprintf( lib_buffer, "%s/lib%s.so", ".libs", LibName );
  }
  retval = dlopen( lib_buffer, RTLD_NOW );
  return retval;
}

int
main( )
{
  void* dlhandle = load( "exception" );
  union {
    int (*call)();
    void *ref;
  } func;
  int retval = 0;

  if ( dlhandle == (void*)NULL )
  {
    fprintf( stderr,"-- FAIL: Unable to load shared library for testing\n" );
    exit( 1 );
  }
  func.ref = dlsym( dlhandle, FUNC_NAME );
  if ( func.ref == NULL )
  {
    dlclose( dlhandle );
    fprintf( stderr,"-- FAIL: Unable to get function: %s\n", FUNC_NAME );
    exit( 1 );
  }
  retval = (*(func.call))( );
  if ( retval == 0 )
  {
    dlclose( dlhandle );
    fprintf( stderr,"-- FAIL: calling function returned : %d\n", retval );
    exit( 1 );
  }
  dlclose( dlhandle );
  exit( 0 );
}
