/* -*- mode: c++; c-basic-offset: 2; -*- */

#ifndef LDASTOOLSAL__SYSTEM_CALL_HH
#define LDASTOOLSAL__SYSTEM_CALL_HH

namespace LDASTools
{
  namespace AL
  {
    //-------------------------------------------------------------
    /// \brief Interface for doing operating system calls
    //-------------------------------------------------------------
    class SystemCall
    {
    public:
      SystemCall( );

      //-----------------------------------------------------------
      /// \brief Destructor to properly destroy all resources.
      //-----------------------------------------------------------
      virtual ~SystemCall( );

      //-----------------------------------------------------------
      /// \brief Return the thread specific value of errno
      //-----------------------------------------------------------
      int SystemErrNo( ) const;

      //-----------------------------------------------------------
      /// \brief Return the return code of the system call
      //-----------------------------------------------------------
      int SystemReturnCode( ) const;

    protected:
      //-----------------------------------------------------------
      /// \brief Return code of the system call.
      ///
      /// This is the return code returned by the system call as
      /// defined by the system call's documentation.
      //-----------------------------------------------------------
      int	m_returnCode;
      //-----------------------------------------------------------
      /// \brief Thread specific value of errno at time of exit.
      ///
      /// This allows for the thread specific errno value to be
      /// known outside of the calling thread.
      /// It is most benificial for error recovery as some
      /// conditions should cause a retry.
      //-----------------------------------------------------------
      int	m_errNo;
    };

    inline SystemCall::
    ~SystemCall( )
    {
    }

    inline int SystemCall::
    SystemErrNo( ) const
    {
      return m_errNo;
    }

    inline int SystemCall::
    SystemReturnCode( ) const
    {
      return m_returnCode;
    }
  } // namespace - AL
} // namespace - LDASTools

#endif /* LDASTOOLSAL__SYSTEM_CALL_HH */
