#ifndef GENERAL__CMD__MKDIR_HH
#define GENERAL__CMD__MKDIR_HH

#include <string>

namespace LDASTools
{
  namespace Cmd
  {
    class MkDir
    {
    public:
      typedef int mode_type;
      typedef int option_type;

      enum options {
	OPT_NONE = 0,
	OPT_MAKE_PARENT_DIRECTORIES = 0x0001
      };

      //-----------------------------------------------------------------
      /// \brief Constructor
      ///
      /// \param[in] Mode
      ///     Mode for the created directory.
      /// \param[in] Options
      ///     Options for the created directory.
      //-----------------------------------------------------------------
      MkDir( mode_type Mode, option_type Options = OPT_NONE );

      //-----------------------------------------------------------------
      ///
      //-----------------------------------------------------------------
      void operator()( const std::string& Directory ) const;

      static const char	PATH_SEP;

    private:

      mode_type		mode;
      option_type	opt;

      void eval( const std::string& Directory ) const;
    };
  }
}

#endif /* GENERAL__CMD__MKDIR_HH */
