/* -*- mode: c++ ; c-basic-offset: 4; -*- */
#ifndef GenericApiInputFileHH
#define GenericApiInputFileHH

#include "ldastoolsal/autoarray.hh"
#include "ldastoolsal/fstream.hh"
#include "genericAPI/file.hh"


//-----------------------------------------------------------------------------
//
//: Input File
//
// This class represents a file which is open for input.
//
// <p>The class is
// constructed by passing a filename and an open mode.  The constructor
// creates an underlying ifstream which represents the file.  This ifstream
// is available through an accessor.  The stream is closed when the destructor
// is called.
//
class InputFile : public File
{
public:
    typedef LDASTools::AL::ifstream	ifstream;

    /* Constructor/Destructor */
    InputFile( const char* filename, std::ios::openmode m );
    InputFile( const char* filename, std::ios::openmode m,
	       unsigned int buffer_size );
    InputFile( const char* filename, std::ios::openmode m,
	       bool use_memory_mapped_io,
	       unsigned int buffer_size,
	       char* buffer = (char*) NULL );
    virtual ~InputFile();

    /* Accessors */
    ifstream& getifstream();
    virtual bool is_open( );
    
private:
    // Buffer for stream when a size has been specified
    LDASTools::AL::AutoArray<char>	m_buffer;
    /* Data Members */
    ifstream mStream;

    void open_file( const char* filename, std::ios::openmode m );
};


//-----------------------------------------------------------------------------
//
//: Get the underlying stream
//
//!return: std::ifstream&
//
inline InputFile::ifstream& InputFile::
getifstream()
{
    return mStream;
}


#endif // GenericApiInputFileHH
