#ifndef GenericApiFileHH
#define GenericApiFileHH


#include <fstream>

#include "ldastoolsal/mutexlock.hh"

#include "swigexception.hh"

#undef GENERIC_API_FILE_IO_LOCK


#ifdef GENERIC_API_FILE_IO_LOCK
namespace General
{
  extern pthread_mutex_t			IOMutex;
}
#endif /* GENERIC_API_FILE_IO_LOCK */

//-----------------------------------------------------------------------------
//
//: File
//
// This class represents a file for TCL.
//
class File
{
public:

    /* Destructor */
    virtual ~File();

    //: Check if a file object is open.
    //
    // Returns true if the file is open.
    //
    //!return: bool
    //
    virtual bool is_open( ) = 0;
};


//-----------------------------------------------------------------------------
//
//: Destructor
//
// This destructor does nothing, it just defines the destructor to be virtual
// so that child classes can be destruted through a pointer or reference to the
// base class.
//
inline File::~File()
{
}



#endif // GenericApiFileHH
