#ifndef GENERIC_API__LSTAT_POOL_HH
#define GENERIC_API__LSTAT_POOL_HH

#include <list>

#include "ldastoolsal/mutexlock.hh"
#include "ldastoolsal/Singleton.hh"

namespace GenericAPI
{

  class StatBase;

  class StatPool
    : public LDASTools::AL::Singleton< StatPool >
  {
    // Declare the common methods for Singleton class
  public:
    typedef StatBase info_base_type;
    typedef info_base_type* info_type;
    typedef void (*user_init_cb)( info_type Key );

    StatPool( );

    ~StatPool( );

    static void Cleanup( );

    static info_type StatType( );

    static info_type Request( );
    static void Release( info_type Buffer );
    static void Destroy( info_type Buffer );
    static void UserInitCB( user_init_cb Callback );

  private:
    LDASTools::AL::MutexLock::baton_type	m_pool_lock;
    user_init_cb				m_user_init_cb;
    bool					m_initialized;

    void cleanup( );
    void destroy( info_type Buffer );
    void release( info_type Buffer );
    info_type request( );

    void user_init_callback( user_init_cb Callback );
  };
}

#endif /* GENERIC_API__LSTAT_POOL_HH */
