#ifndef GENERIC_API__LSTAT_DIRECT_HH
#define GENERIC_API__LSTAT_DIRECT_HH

#include "genericAPI/StatBase.hh"

namespace GenericAPI
{
  class StatDirect
    : public StatBase
  {
  public:
    StatDirect( );
    ~StatDirect( );

    virtual void Init( );

    virtual std::string
    Debug( debug_info DebugInfo = STAT_DEBUG_GENERAL ) const;

    virtual int LStat( const std::string& FileName, stat_buf_type& Buf ) const;
    virtual int LStat( const directory_type& Dir,
		       const std::string& RelFilename,
		       stat_buf_type& Buf ) const;

    virtual int Stat( const std::string& FileName, stat_buf_type& Buf ) const;
    virtual int Stat( const directory_type& Dir,
		      const std::string& RelFilename,
		      stat_buf_type& Buf ) const;

    virtual StatDirect* vnew( ) const;
  };
}

#endif /* GENERIC_API__LSTAT_DIRECT_HH */
