#ifndef GENERIC_API__LOG_TEXT_HH
#define GENERIC_API__LOG_TEXT_HH

#include "genericAPI/LogLDAS.hh"

namespace GenericAPI
{
  namespace Log
  {
    //-------------------------------------------------------------------
    /// \brief Text Logging class
    ///
    //-------------------------------------------------------------------
    class Text
      : public LDAS
    {
    public:
      //-----------------------------------------------------------------
      /// \brief Constructor
      ///
      /// \param[in] BaseName
      ///     The base name to be used for creation of the log file.
      ///
      /// \return
      ///     An instance of this object.
      //-----------------------------------------------------------------
      Text( const std::string& BaseName );

      //-----------------------------------------------------------------
      /// \brief Create a new instance
      ///
      /// \return
      ///     A new instance of this object
      //-----------------------------------------------------------------
      virtual Text* Clone( const std::string& BaseName ) const;

      virtual const char* FileExtension( ) const;

      virtual std::string FormatJobInfo( const std::string& JobInfo ) const;

      virtual void Message( message_type MessageType, level_type Level,
			    const std::string& Caller, const std::string& JobInfo,
			    const std::string& Message );

    protected:
      virtual void header( );

      virtual void footer( );
    };
  } // namespace - Log
} // namespace - GenericAPI

#endif /* GENERIC_API__LOG_TEXT_HH */
 
