#ifndef GENERIC_API__FILE_LOCK_HH
#define GENERIC_API__FILE_LOCK_HH

#include <sstream>

namespace GenericAPI
{
  class FileLock
  {
  public:
    FileLock( const std::string& Filename );
    ~FileLock( );
    std::ostream& Buffer( );
  private:
    const std::string	m_filename;
    int			m_fd;
    std::ostringstream	m_buffer;
  };

  inline std::ostream& FileLock::
  Buffer( )
  {
    return m_buffer;
  }
}

#endif /* GENERIC_API__FILE_LOCK_HH */

