#ifndef FrameCPP_VERSION_6_FrTOCProcData_HH
#define FrameCPP_VERSION_6_FrTOCProcData_HH

#include "framecpp/Version6/STRING.hh"

namespace FrameCPP
{
  namespace Common
  {
    class TOCInfo;
  }

  namespace Version_6
  {
    //===================================================================
    //===================================================================
    class FrTOCProcData
    {
    public:
      typedef INT_4U	nproc_type;
      typedef STRING	name_type;
      typedef INT_8U	position_type;

      typedef std::vector< name_type > key_container_type;
      typedef std::vector< position_type > proc_info_type;
      typedef std::map< name_type, proc_info_type >
      MapProc_type;

      FrTOCProcData( );

      Common::FrameSpec::size_type
      Bytes( const Common::StreamBase& Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Retrieve the keys
      ///
      /// \return
      ///     Constant container of keys.
      //-----------------------------------------------------------------
      const key_container_type& GetKeys( ) const;

      const MapProc_type& GetProc( ) const;

      MapProc_type::const_iterator GetProc( const std::string& Name ) const;

      MapProc_type::const_iterator GetProc( INT_4U index ) const;

      void QueryProc( const Common::TOCInfo& Info,
		      INT_4U FrameOffset,
		      INT_8U Position );

      bool operator==( const FrTOCProcData& RHS ) const;

      template< typename SE >
      static void Description( Common::Description& Desc );

    protected:
      key_container_type	m_keys;
      MapProc_type		m_info;

      FrTOCProcData( Common::IStream& Stream, INT_4U FrameCount );
      void write( Common::OStream& Stream ) const;
    };

    inline Common::FrameSpec::size_type FrTOCProcData::
    Bytes( const Common::StreamBase& Stream ) const
    {
      Common::FrameSpec::size_type 
	retval = sizeof( nproc_type );
      if ( m_info.size( ) )
      {
	retval
	  += ( m_info.size( )
	       * ( sizeof( position_type )
		   * m_info.begin( )->second.size( )
		   ) );
      }
      for ( MapProc_type::const_iterator
	      cur = m_info.begin( ),
	      last = m_info.end( );
	    cur != last;
	    ++cur )
      {
	retval += cur->first.Bytes( );
      }
      return retval;
    }

    template< typename SE >
    void FrTOCProcData::
    Description( Common::Description& Desc )
    {
      Desc( SE( "nProc", "INT_4U",
		"Number of unique FrAdcData names in file." ) );
      Desc( SE( "nameProc", "*STRING", "Array of FrAdcData names" ) );
      Desc( SE( "positionProc", "*INT_8U",
		"Array of lists of FrProcData offset positions, in bytes,"
		" from beginning of file (size of nFrame*nProc)"
		) );
    }

    inline const FrTOCProcData::key_container_type& FrTOCProcData::
    GetKeys( ) const
    {
      return m_keys;
    }

    inline const FrTOCProcData::MapProc_type& FrTOCProcData::
    GetProc( ) const
    {
      return m_info;
    }

  } // namespace - Version_6
} // namespace - FrameCPP

#endif /* FrameCPP_VERSION_6_FrTOCProcData_HH */
