#ifndef FrameCPP_VERSION_6_FrTOC_HH
#define FrameCPP_VERSION_6_FrTOC_HH

#if ! defined(SWIGIMPORTED)
#include <map>
#include <vector>
#endif /* ! defined(SWIGIMPORTED) */

#include "framecpp/Common/FrameSpec.hh"
#include "framecpp/Common/FrTOC.hh"

#include "framecpp/Version6/FrameSpec.hh"
#include "framecpp/Version6/FrTOCAdcData.hh"
#include "framecpp/Version6/FrTOCData.hh"
#include "framecpp/Version6/FrTOCEvent.hh"
#include "framecpp/Version6/FrTOCProcData.hh"
#include "framecpp/Version6/FrTOCSerData.hh"
#include "framecpp/Version6/FrTOCSimData.hh"
#include "framecpp/Version6/FrTOCSimEvent.hh"
#include "framecpp/Version6/FrTOCStatData.hh"
#include "framecpp/Version6/FrTOCSummary.hh"
#include "framecpp/Version6/STRING.hh"

namespace FrameCPP
{
  namespace Version_6
  {

    //===================================================================
    //===================================================================
    class FrTOC
      : public Common::FrTOC,
        public FrTOCData,
	public FrTOCStatData,
	public FrTOCAdcData,
	public FrTOCProcData,
	public FrTOCSimData,
	public FrTOCSerData,
	public FrTOCSummary,
	public FrTOCEvent,
	public FrTOCSimEvent
    {
    public:
      typedef INT_8U				position_type;
      typedef std::vector< position_type >	position_list_type;

      class StatTypeKey {
      public:
	std::string	s_name;
	std::string	s_detector;

	StatTypeKey( const std::string& Name,
		     const std::string& Detector );
	bool operator<( const StatTypeKey& RHS ) const;
	bool operator==( const StatTypeKey& RHS ) const;
	bool operator!=( const StatTypeKey& RHS ) const;
      };

      struct StatType_type
      {
	std::vector< INT_4U >	tStart;
	std::vector< INT_4U >	tEnd;
	std::vector< INT_4U >	version;
	position_list_type	positionStat;
      };

      class StatTypeKeyHash
      {
      public:
	size_t operator()( const StatTypeKey& Key ) const
	{
	  LDASTools::AL::hash< const char* > h;

	  std::string key( Key.s_name );
	  key += Key.s_detector;
	  return h( key.c_str( ) );
	}
      };

      typedef LDASTools::AL::unordered_map< StatTypeKey,
					    StatType_type,
					    StatTypeKeyHash >
      MapStatType_type;

      static const INT_4U	NO_DATA_AVAILABLE;

      FrTOC( );

      //-----------------------------------------------------------------
      /// \brief Constructor
      ///
      /// \param[in] Source
      ///     
      /// \return
      ///    A new instance of this object.
      //-----------------------------------------------------------------
      explicit FrTOC( const FrameCPP::Common::FrTOC* Source );

      static const char* StructName( );

      static const Common::Description* StructDescription( );

      virtual void IndexObject( object_type Object,
				std::streampos Position );

      virtual Common::FrameSpec::size_type
      Bytes( const Common::StreamBase& Stream ) const;

      virtual FrTOC* Create( ) const;

      virtual FrTOC* Create( istream_type& Stream ) const;

      virtual void FrStatDataQuery( const std::string& NamePattern,
				    const LDASTools::AL::GPSTime& StartTime,
				    const LDASTools::AL::GPSTime& EndTime,
				    const INT_4U Version,
				    Common::FrStatData::Query& Result ) const;

      virtual const char* ObjectStructName( ) const;

      virtual void Write( ostream_type& Stream ) const;
 
      /// \brief comparison operator
      virtual bool operator==( const Common::FrameSpec::Object& Obj ) const;

      const MapStatType_type&		GetStatType( ) const;

    protected:
      /// \brief Down grade an object
      virtual demote_ret_type
      demote( INT_2U Target,
	      demote_arg_type Obj,
	      istream_type* Stream ) const;

      /// \brief Upgrade an object
      virtual promote_ret_type
      promote( INT_2U Target,
	       promote_arg_type Obj,
	       istream_type* Stream ) const;

    protected:
      //-----------------------------------------------------------------
      // Interface routines
      //-----------------------------------------------------------------
      virtual INT_4U nFrame( ) const;

      virtual const cmn_dt_container_type& dt( ) const;
      virtual const cmn_GTimeS_container_type& GTimeS( ) const;
      virtual const cmn_GTimeN_container_type& GTimeN( ) const;

      virtual cmn_position_type positionDetector( const std::string& Name ) const;

      virtual cmn_position_type positionH( INT_4U FrameIndex ) const;

      virtual const cmn_name_container_type& nameADC( ) const;

      virtual cmn_position_type positionADC( INT_4U FrameIndex,
					     const std::string& Channel ) const;
      virtual cmn_position_type positionADC( INT_4U FrameIndex,
					     INT_4U Channel ) const;

      virtual cmn_position_type positionEvent( INT_4U FrameIndex,
					       const std::string& Event ) const;

      virtual const cmn_name_container_type& nameProc( ) const;

      virtual cmn_position_type positionProc( INT_4U FrameIndex,
					      const std::string& Channel ) const;
      virtual cmn_position_type positionProc( INT_4U FrameIndex,
					      INT_4U Channel ) const;

      virtual const cmn_name_container_type& nameSer( ) const;

      virtual cmn_position_type positionSer( INT_4U FrameIndex,
					     const std::string& Channel ) const;

      virtual const cmn_name_container_type& nameSim( ) const;

      virtual cmn_position_type positionSim( INT_4U FrameIndex,
					     const std::string& Channel ) const;

      virtual cmn_position_type positionSimEvent( INT_4U FrameIndex,
						  const std::string& SimEvent ) const;

      //-----------------------------------------------------------------
      /// \brief Cache where the positions of the Adc channels
      ///
      /// \param[in,out] Stream
      ///     The Stream being read
      //-----------------------------------------------------------------
      virtual void cacheAdcDataPositions( istream_type& Stream );

      //-----------------------------------------------------------------
      /// \brief Advance to the specified Adc channel
      ///
      /// \param[in,out] Stream
      ///     The Stream being read
      /// \param[in] Channel
      ///     The requested channel
      //-----------------------------------------------------------------
      virtual void seekAdcDataPositions( istream_type& Stream,
					 Common::FrTOC::channel_id_type Channel );

      //-----------------------------------------------------------------
      /// \brief Advance to the specified Adc channel
      ///
      /// \param[in,out] Stream
      ///     The Stream being read
      /// \param[in] Channel
      ///     The requested channel
      //-----------------------------------------------------------------
      virtual void seekAdcDataPositions( istream_type& Stream,
					 const std::string& Channel );

      virtual INT_4U nSH( ) const;
      virtual INT_2U SHid( INT_4U Offset ) const;
      virtual const std::string& SHname( INT_4U Offset ) const;

    private:
      using Common::FrameSpec::Object::Create;

      MapStatType_type		m_StatType;

      FrTOC( istream_type& Stream );

      template< typename ChannelType >
      cmn_position_type position_adc( INT_4U FrameIndex, ChannelType Channel ) const;

      template< typename ChannelType >
      cmn_position_type position_proc( INT_4U FrameIndex, ChannelType Channel ) const;

   };

    inline FrTOC::StatTypeKey::
    StatTypeKey( const std::string& Name,
		 const std::string& Detector )
      : s_name( Name ),
	s_detector( Detector )
    {
    }

    inline bool FrTOC::StatTypeKey::
    operator<( const StatTypeKey& RHS ) const
    {
      if ( s_name.compare( RHS.s_name ) == 0 )
      {
	return s_detector < RHS.s_detector;
      }
      return s_name < RHS.s_name;
    }

    inline bool FrTOC::StatTypeKey::
    operator==( const StatTypeKey& RHS ) const
    {
      return ( ( s_name == RHS.s_name )
	       && ( s_detector == RHS.s_detector ) );
    }

    inline bool FrTOC::StatTypeKey::
    operator!=( const StatTypeKey& RHS ) const
    {
      return ( ! ( *this == RHS ) );
    }

    inline const char* FrTOC::
    StructName( )
    {
      static const CHAR* class_name( "FrTOC" );
      return class_name;
    }

    inline const FrTOC::MapStatType_type& FrTOC::
    GetStatType( ) const
    {
      return m_StatType;
    }

  } // namespace - Version_6
} // namespace - FrameCPP

#endif /* FrameCPP_VERSION_6_FrTOC_HH */
