#include "framecpp/Common/Description.hh"
#include "framecpp/Common/TOCInfo.hh"

#include "framecpp/Version4/FrameSpec.hh"
#include "framecpp/Version4/FrTOCProcData.hh"
#include "framecpp/Version4/FrSE.hh"
#include "framecpp/Version4/FrSH.hh"
#include "framecpp/Version4/FrTOC.hh"

#include "framecpp/Version4/STRING.hh"

using FrameCPP::Common::Description;
using FrameCPP::Common::FrameSpec;
using FrameCPP::Common::TOCInfo;

namespace FrameCPP
{
  namespace Version_4
  {
    //===================================================================
    //===================================================================
    void FrTOCProcData::
    Description( Common::Description& Desc )
    {
      Desc( FrSE( "nProc", "INT_4U",
		  "Number of unique FrProcData names in file." ) );
      Desc( FrSE( "nameProc", "*STRING", "Array of FrProcData names" ) );
      Desc( FrSE( "positionProc", "*INT_8U",
		  "Array of lists of FrProcData offset positions, in bytes,"
		  " from beginning of file (size of nFrame*nProc)"
		  ) );
    }

    void FrTOCProcData::
    QueryProc( const Common::TOCInfo& Info,
	       INT_4U FrameOffset,
	       INT_8U Position )
    {
      STRING	name;

      Info.TOCQuery( Common::TOCInfo::IC_NAME, Common::TOCInfo::DT_STRING_2, &name,
		     Common::TOCInfo::IC_EOQ );

      proc_info_type& i( m_info[ name ] );
      i.resize( FrameOffset + 1 );
      i[ FrameOffset ] = Position;
    }

  } // namespace - Version_4
} // namespace - FrameCPP
