#include "framecpp/Common/Description.hh"
#include "framecpp/Common/TOCInfo.hh"

#include "framecpp/Version4/FrameSpec.hh"
#include "framecpp/Version4/FrSE.hh"
#include "framecpp/Version4/FrSH.hh"
#include "framecpp/Version4/FrTOC.hh"

#include "framecpp/Version4/STRING.hh"

using FrameCPP::Common::Description;
using FrameCPP::Common::FrameSpec;
using FrameCPP::Common::TOCInfo;

namespace FrameCPP
{
  namespace Version_4
  {
    //===================================================================
    // FrTOCData
    //===================================================================
    FrTOCData::
    FrTOCData( Common::IStream& Stream )
    {
      nframe_type	nframe;

      Stream >> m_ULeapS
	     >> m_localTime
	     >> nframe;
      if ( nframe )
      {
	m_GTimeS.resize( nframe );
	m_GTimeN.resize( nframe );
	m_dt.resize( nframe );
	m_runs.resize( nframe );
	m_frame.resize( nframe );
	m_positionH.resize( nframe );
	m_nFirstADC.resize( nframe );
	m_nFirstSer.resize( nframe );
	m_nFirstTable.resize( nframe );
	m_nFirstMsg.resize( nframe );
	Stream 
	  >> m_GTimeS
	  >> m_GTimeN
	  >> m_dt
	  >> m_runs
	  >> m_frame
	  >> m_positionH
	  >> m_nFirstADC
	  >> m_nFirstSer
	  >> m_nFirstTable
	  >> m_nFirstMsg
	  ;
      }
      nsh_type	nsh;
      Stream >> nsh;
      if ( nsh > 0 )
      {
	m_SHid.resize( nsh );
	m_SHname.resize( nsh );
	Stream
	  >> m_SHid
	  >> m_SHname
	  ;
      }
    }

    void FrTOCData::
    Description( Common::Description& Desc )
    {
      Desc( FrSE( "ULeapS", "INT_2S",
		  "From the first FrameH in the file" ) );
      Desc( FrSE( "localTime", "INT_4S",
		  "From the first FrameH in the file" ) );
      //-----------------------------------------------------------------
      Desc( FrSE( "nFrame", "INT_4U",
		  "Number of frames in the file" ) );
      Desc( FrSE( "GTimeS", "*INT_4U",
		  "Array of integer GPS frae times (size of nFrames" ) );
      Desc( FrSE( "GTimeN", "*INT_4U",
		  "Array of integer GPS residual nanoseconds for the frame"
		  " (size of nFrame" ) );
      Desc( FrSE( "dt", "*REAL_8",
		  "Array of frame durations in seconds( size of nFrames)" ) );
      Desc( FrSE( "runs", "*INT_4S",
		  "Array of run numbers (size of nFrame)" ) );
      Desc( FrSE( "frame", "*INT_4U",
		  "Array of frame numbers (size of nFrame)" ) );
      Desc( FrSE( "positionH", "*INT_8U",
		  "Array of FrameH positions, in bytes, from the"
		  " bginning of file (size of nFrame)" ) );
      Desc( FrSE( "nFirstADC", "*INT_8U",
		  "Array of FrADCData positions, in bytes, from the"
		  " bginning of file (size of nFrame)" ) );
      Desc( FrSE( "nFirstSer", "*INT_8U",
		  "Array of FrSerData positions, in bytes, from the"
		  " bginning of file (size of nFrame)" ) );
      Desc( FrSE( "nFirstTable", "*INT_8U",
		  "Array of FrTable positions, in bytes, from the"
		  " bginning of file (size of nFrame)" ) );
      Desc( FrSE( "nFirstMsg", "*INT_8U",
		  "Array of FrMsg positions, in bytes, from the"
		  " bginning of file (size of nFrame)" ) );
      //-----------------------------------------------------------------
      Desc( FrSE( "nSH", "INT_4U",
		  "Number of FrSH structures in the file" ) );
      Desc( FrSE( "SHid", "*INT_2U",
		  "Array of FrSH IDs (size of nSH)" ) );
      Desc( FrSE( "SHname", "*STRING",
		  "Array of FrSH names (size of nSH)" ) );
    }

    void FrTOCData::
    write( Common::OStream& Stream ) const
    {
      Stream << m_ULeapS
	     << m_localTime
	     << nframe_type( m_frame.size( ) )
	     << m_GTimeS
	     << m_GTimeN
	     << m_dt
	     << m_runs
	     << m_frame
	     << m_positionH
	     << m_nFirstADC
	     << m_nFirstSer
	     << m_nFirstTable
	     << m_nFirstMsg
	     << nsh_type( m_SHid.size( ) )
	     << m_SHid
	     << m_SHname
	;
    }

  } // namespace - Version_4
} // namespace - FrameCPP
